DROP TABLE IF EXISTS `%PREFIX%admins`;
CREATE TABLE `%PREFIX%admins` (`admin_id` smallint(6) NOT NULL auto_increment, `admin_user_name` varchar(30) NOT NULL default '', `admin_user_pword` varchar(100) NOT NULL default '', `admin_name_first` varchar(20) NOT NULL default 'none', `admin_name_last` varchar(20) NOT NULL default 'none', `admin_email` varchar(50) NOT NULL default 'none', `admin_perms` int(11) NOT NULL default '0', PRIMARY KEY (`admin_id`), UNIQUE KEY `admin_user_name` (`admin_user_name`), KEY `admin_user_pword` (`admin_user_pword`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Admins Table';
INSERT INTO `%PREFIX%admins` (`admin_id`, `admin_user_name`, `admin_user_pword`, `admin_name_first`, `admin_name_last`, `admin_email`, `admin_perms`) VALUES(1, 'webmaster', '%PASSWORD%', 'Site', 'Administrator', 'webmaster@%DOMAINNAME%', 65535);
DROP TABLE IF EXISTS `%PREFIX%articles`;
CREATE TABLE `%PREFIX%articles` (`id` int(9) NOT NULL auto_increment, `subject` varchar(50) NOT NULL default '', `topic_id` int(11) NOT NULL default '1', `cat_id` int(11) NOT NULL default '1', `time_stamp` varchar(10) NOT NULL, `entry` mediumtext NOT NULL, `followup_cnt` int(9) NOT NULL default '0', `auto_nl2br` tinyint(1) NOT NULL default '1', PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Articles Module Table';
INSERT INTO `%PREFIX%articles` (`id`, `subject`, `topic_id`, `cat_id`, `time_stamp`, `entry`, `followup_cnt`, `auto_nl2br`) VALUES(1, 'Welcome to our phpCOIN powered site', 1, 1, '%TIMESTAMP%', 'Just to note we are now running the phpCOIN package.\r\n\r\nCheck back for more info.', 0, 1);
DROP TABLE IF EXISTS `%PREFIX%banned`;
CREATE TABLE `%PREFIX%banned` (`banned_ip` varchar(15) NOT NULL default '', UNIQUE KEY `banned_ip` (`banned_ip`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Banned IP Address Table';
INSERT INTO `%PREFIX%banned` (`banned_ip`) VALUES('000.000.000.000');
DROP TABLE IF EXISTS `%PREFIX%bills`;
CREATE TABLE `%PREFIX%bills` (`bill_id` int(11) NOT NULL default '0', `bill_status` varchar(20) NOT NULL default 'draft', `bill_s_id` int(11) NOT NULL default '0', `bill_invoice_number` varchar(20) NOT NULL default '', `bill_total_cost` double default '0', `bill_total_paid` double default '0', `bill_subtotal_cost` double default '0', `bill_tax_01_percent` double default '0', `bill_tax_01_amount` double default '0', `bill_tax_02_percent` double default '0', `bill_tax_02_amount` double default '0', `bill_tax_autocalc` tinyint(1) NOT NULL default '1', `bill_ts` int(11) NOT NULL, `bill_ts_due` int(11) NOT NULL, `bill_ts_paid` int(11) NOT NULL, `bill_cycle` tinyint(1) NOT NULL default '1', `bill_recurring` tinyint(1) NOT NULL default '0', `bill_recurr_proc` tinyint(4) NOT NULL default '0', PRIMARY KEY  (`bill_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Bills Module Table';
DROP TABLE IF EXISTS `%PREFIX%bills_items`;
CREATE TABLE `%PREFIX%bills_items` (`bi_bill_id` int(11) NOT NULL default '0', `bi_item_no` smallint(4) NOT NULL default '0', `bi_item_name` varchar(30) NOT NULL default '', `bi_item_desc` varchar(75) NOT NULL default '', `bi_item_cost` double default '0', `bi_apply_tax_01` tinyint(1) NOT NULL default '1', `bi_apply_tax_02` tinyint(1) NOT NULL default '1', `bi_calc_tax_02_pb` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`bi_bill_id`,`bi_item_no`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Bills Module Items Table';
DROP TABLE IF EXISTS `%PREFIX%bills_trans`;
CREATE TABLE `%PREFIX%bills_trans` (`bt_id` bigint(11) NOT NULL auto_increment, `bt_ts` int(11) NOT NULL, `bt_bill_id` int(11) NOT NULL default '0', `bt_type` tinyint(2) NOT NULL default '0', `bt_origin` tinyint(2) NOT NULL default '0', `bt_desc` varchar(50) NOT NULL default '', `bt_amount` double default '0', PRIMARY KEY  (`bt_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Bills Module Transactions Table';
DROP TABLE IF EXISTS `%PREFIX%categories`;
CREATE TABLE `%PREFIX%categories` (`cat_id` int(11) NOT NULL auto_increment, `cat_pos` smallint(6) NOT NULL default '0', `cat_name` varchar(50) NOT NULL default '', `cat_desc` varchar(50) NOT NULL default '', `cat_icon` smallint(6) NOT NULL default '1', PRIMARY KEY  (`cat_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Categories Table';
INSERT INTO `%PREFIX%categories` (`cat_id`, `cat_pos`, `cat_name`, `cat_desc`, `cat_icon`) VALUES(1, 0, 'General', 'General / Default Category', 1);
INSERT INTO `%PREFIX%categories` (`cat_id`, `cat_pos`, `cat_name`, `cat_desc`, `cat_icon`) VALUES(2, 0, 'News', 'For News Items', 1);
INSERT INTO `%PREFIX%categories` (`cat_id`, `cat_pos`, `cat_name`, `cat_desc`, `cat_icon`) VALUES(3, 0, 'Site Related', 'For Site Related Items', 1);
DROP TABLE IF EXISTS `%PREFIX%clients`;
CREATE TABLE `%PREFIX%clients` (`cl_id` int(11) NOT NULL default '0', `cl_join_ts` int(11) NOT NULL, `cl_status` varchar(20) NOT NULL default 'pending', `cl_company` varchar(50) NOT NULL default '', `cl_name_first` varchar(20) NOT NULL default '', `cl_name_last` varchar(20) NOT NULL default '', `cl_addr_01` varchar(50) NOT NULL default '', `cl_addr_02` varchar(50) NOT NULL default '', `cl_city` varchar(50) NOT NULL default '', `cl_state_prov` varchar(50) NOT NULL default '', `cl_country` varchar(50) NOT NULL default '', `cl_zip_code` varchar(12) NOT NULL default '', `cl_phone` varchar(20) NOT NULL default '', `cl_email` varchar(50) NOT NULL default '', `cl_user_name` varchar(100) NOT NULL default '', `cl_user_pword` varchar(100) NOT NULL default '', `cl_notes` text NOT NULL, `cl_groups` int(11) NOT NULL default '0', PRIMARY KEY  (`cl_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Clients Module Table';
DROP TABLE IF EXISTS `%PREFIX%clients_contacts`;
CREATE TABLE `%PREFIX%clients_contacts` (`contacts_id` int(11) NOT NULL auto_increment, `contacts_cl_id` int(11) NOT NULL default '0', `contacts_name_first` varchar(20) NOT NULL default '', `contacts_name_last` varchar(20) NOT NULL default '', `contacts_email` varchar(50) NOT NULL default '', UNIQUE KEY `contacts_id` (`contacts_id`), KEY `contacts_cl_id` (`contacts_cl_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `%PREFIX%components`;
CREATE TABLE `%PREFIX%components` (`comp_id` mediumint(9) NOT NULL auto_increment, `comp_type` varchar(20) NOT NULL default '', `comp_name` varchar(20) NOT NULL default '', `comp_mod` varchar(20) NOT NULL default '', `comp_desc` varchar(50) NOT NULL default '', `comp_ptitle` varchar(50) NOT NULL default '', `comp_col_num` tinyint(1) NOT NULL default '3', `comp_isadmin` tinyint(1) NOT NULL default '0', `comp_isuser` tinyint(1) NOT NULL default '0', `comp_status` tinyint(1) NOT NULL default '1', PRIMARY KEY  (`comp_id`), KEY `comp_id` (`comp_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Components Table';
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(1, 'site', 'index', '', 'Site index', 'Home Page', 3, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(2, 'site', 'login', '', 'Site Login', 'Site Login', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(3, 'admin', 'cp_reminders', '', 'Control Panel: Setup overdue invoice auto-reminder', 'Reminders', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(4, 'admin', 'cp_admins', '', 'Control Panel: Admins', 'Admin Admins', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(5, 'admin', 'cp_banip', '', 'Control Panel: Banned IP', 'Admin Banned IP', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(6, 'admin', 'cp_categories', '', 'Control Panel: Categories', 'Admin Categories', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(7, 'admin', 'cp_components', '', 'Control Panel: Components', 'Admin Components', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(8, 'admin', 'cp_icons', '', 'Control Panel: Icon', 'Admin Icons', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(9, 'admin', 'cp_index', '', 'Control Panel: Admin Menu', 'Admin Menu', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(10, 'admin', 'cp_mail_contacts', '', 'Control Panel: Mail Contacts', 'Admin Mail Contacts', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(11, 'admin', 'cp_mail_templates', '', 'Control Panel: Mail Templates', 'Admin Mail Templates', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(12, 'admin', 'cp_menu', '', 'Control Panel: Menu', 'Admin Menu', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(13, 'admin', 'cp_parms', '', 'Control Panel: Parameters', 'Admin Parameters', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(14, 'admin', 'cp_prods', '', 'Control Panel: Products', 'Admin Products', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(15, 'admin', 'cp_server_info', '', 'Control Panel: Server Info', 'Admin Server Info', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(16, 'admin', 'cp_siteinfo', '', 'Control Panel- Site Info', 'Admin SiteInfo', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(17, 'admin', 'cp_topics', '', 'Control Panel: Topics', 'Admin Topics', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(18, 'admin', 'cp_vendors', '', 'Control Panel: Vendors', 'Admin Vendors', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(19, 'admin', 'cp_vprods', '', 'Control Panel: Vendor Products', 'Admin Vendor Products', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(20, 'admin', 'cp_whois', '1', 'Control Panel: WHOIS Lookups', 'Admin: WHOIS Lookups', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(21, 'auxpage', 'auxpage_example', '', 'Auxpage', 'Auxpage Example', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(22, 'module', 'articles', '', 'Articles', 'Articles', 3, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(23, 'module', 'clients', '', 'Clients', 'Clients', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(24, 'module', 'cc', '', 'Command Center', 'Command Center', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(25, 'module', 'domains', '', 'Domains', 'Domains', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(26, 'module', 'faq', '', 'FAQ Module', 'FAQ', 3, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(27, 'module', 'helpdesk', '', 'HelpDesk Module', 'HelpDesk Support Tickets', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(28, 'module', 'invoices', '', 'Invoices', 'Invoices', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(29, 'module', 'mail', '', 'Mail Module', 'Mail', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(30, 'module', 'orders', '', 'Orders', 'Orders', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(31, 'module', 'pages', '', 'Pages', 'Documentation', 3, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(32, 'module', 'search', '', 'Search Site', 'Search Site', 3, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(33, 'module', 'siteinfo', '', 'Site Info Related Output', 'Site Info', 3, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(34, 'module', 'whois', 'whois', 'WHOIS', 'WHOIS', 2, 0, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(35, 'module', 'ipn', 'ipn', 'Instant Payment Notification', 'Instant Payment Notification', 2, 1, 0, 1);
INSERT INTO `%PREFIX%components` (`comp_id`, `comp_type`, `comp_name`, `comp_mod`, `comp_desc`, `comp_ptitle`, `comp_col_num`, `comp_isadmin`, `comp_isuser`, `comp_status`) VALUES(36, 'module', 'ToDo', 'todo', 'ToDo List', 'ToDo List', 2, 1, 0, 1);
DROP TABLE IF EXISTS `%PREFIX%domains`;
CREATE TABLE `%PREFIX%domains` (`dom_id` int(11) NOT NULL auto_increment, `dom_cl_id` int(11) NOT NULL default '0', `dom_domain` varchar(50) NOT NULL default '', `dom_status` tinyint(2) NOT NULL default '0', `dom_type` tinyint(2) NOT NULL default '0', `dom_registrar` varchar(32) NOT NULL default '', `dom_ts_expiration` varchar(10) NOT NULL default '', `dom_sa_expiration` varchar(10) NOT NULL default '', `dom_si_id` int(11) NOT NULL default '0', `dom_ip` varchar(16) NOT NULL default '', `dom_path` varchar(255) NOT NULL default '', `dom_path_temp` varchar(255) NOT NULL default '', `dom_url_cp` varchar(100) NOT NULL default '', `dom_user_name_cp` varchar(30) NOT NULL default '', `dom_user_pword_cp` varchar(30) NOT NULL default '', `dom_user_name_ftp` varchar(30) NOT NULL default '', `dom_user_pword_ftp` varchar(30) NOT NULL default '', `dom_allow_domains` smallint(6) NOT NULL default '0', `dom_allow_subdomains` smallint(6) NOT NULL default '0', `dom_allow_disk_space_mb` int(11) NOT NULL default '0', `dom_allow_traffic_mb` int(11) NOT NULL default '0', `dom_allow_mailboxes` smallint(6) NOT NULL default '0', `dom_allow_databases` smallint(6) NOT NULL default '0', `dom_enable_www_prefix` tinyint(1) NOT NULL default '0', `dom_enable_wu_scripting` tinyint(1) NOT NULL default '0', `dom_enable_webmail` tinyint(1) NOT NULL default '0', `dom_enable_frontpage` tinyint(1) NOT NULL default '0', `dom_enable_fromtpage_ssl` tinyint(1) NOT NULL default '0', `dom_enable_ssi` tinyint(1) NOT NULL default '0', `dom_enable_php` tinyint(1) NOT NULL default '0', `dom_enable_cgi` tinyint(1) NOT NULL default '0', `dom_enable_mod_perl` tinyint(1) NOT NULL default '0', `dom_enable_asp` tinyint(1) NOT NULL default '0', `dom_enable_ssl` tinyint(1) NOT NULL default '0', `dom_enable_stats` tinyint(1) NOT NULL default '0', `dom_enable_err_docs` tinyint(1) NOT NULL default '0', `dom_notes` text NOT NULL, PRIMARY KEY  (`dom_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Domains Module Table';
DROP TABLE IF EXISTS `%PREFIX%downloads`;
CREATE TABLE `%PREFIX%downloads` (`dload_id` int(11) NOT NULL auto_increment, `dload_group` varchar(50) NOT NULL default '', `dload_name` varchar(50) NOT NULL default '', `dload_desc` text NOT NULL, `dload_count` int(11) NOT NULL default '0', `dload_date_str` varchar(10) NOT NULL default 'yyyy-mm-dd', `dload_avail` int(1) NOT NULL default '0', `dload_filename` varchar(50) NOT NULL default '', `dload_filesize` varchar(8) NOT NULL default '', `dload_contributor` varchar(255) NOT NULL default '', PRIMARY KEY  (`dload_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Downloads Table';
DROP TABLE IF EXISTS `%PREFIX%faq`;
CREATE TABLE `%PREFIX%faq` (`faq_id` int(9) NOT NULL auto_increment, `faq_position` int(9) NOT NULL default '1', `faq_time_stamp_mod` varchar(10) NOT NULL, `faq_status` tinyint(1) NOT NULL default '0', `faq_admin` tinyint(1) NOT NULL default '0', `faq_user` tinyint(1) NOT NULL default '0', `faq_title` varchar(50) NOT NULL default '', `faq_descrip` mediumtext NOT NULL, PRIMARY KEY  (`faq_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site FAQ Module Table';
DROP TABLE IF EXISTS `%PREFIX%faq_qa`;
CREATE TABLE `%PREFIX%faq_qa` (`faqqa_id` int(9) NOT NULL auto_increment, `faqqa_faq_id` int(11) NOT NULL default '0', `faqqa_position` int(9) NOT NULL default '1', `faqqa_time_stamp_mod` varchar(10) NOT NULL, `faqqa_status` tinyint(1) NOT NULL default '0', `faqqa_question` varchar(255) NOT NULL default '', `faqqa_answer` mediumtext NOT NULL, `faqqa_auto_nl2br` tinyint(1) NOT NULL default '1', PRIMARY KEY  (`faqqa_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site FAQ Module QA Table';
INSERT INTO `%PREFIX%faq_qa` (`faqqa_id`, `faqqa_faq_id`, `faqqa_position`, `faqqa_time_stamp_mod`, `faqqa_status`, `faqqa_question`, `faqqa_answer`, `faqqa_auto_nl2br`) VALUES(1, 1, 1, '%TIMESTAMP%', 1, 'Welcome to phpcoin.', 'Congratulations on this installation of the phpCOIN (Clients, Order, Invoices, and Notes) package. Please be sure to perform the following:<br>\r\n<ul><li>Please review all documentation in the /coin_docs folder.\r\n<li>Please be sure set / verify the settings in the site config file.\r\n<li>Please be sure set / verify the settings in the theme config file.\r\n<li>Please be sure to backup your database after the initial setup is completed.\r\n</ul>\r\nPlease login to your admin control panel and set / verify required items.', 1);
DROP TABLE IF EXISTS `%PREFIX%helpdesk`;
CREATE TABLE `%PREFIX%helpdesk` (`hd_tt_id` int(11) NOT NULL default '0', `hd_tt_cl_id` int(11) NOT NULL default '0', `hd_tt_cl_email` varchar(50) NOT NULL default '', `hd_tt_time_stamp` varchar(10) NOT NULL, `hd_tt_priority` varchar(20) NOT NULL default '', `hd_tt_category` varchar(20) NOT NULL default '', `hd_tt_subject` varchar(50) NOT NULL default '', `hd_tt_message` text NOT NULL, `hd_tt_cd_id` int(11) NOT NULL default '0', `hd_tt_url` varchar(50) NOT NULL default '', `hd_tt_status` varchar(20) NOT NULL default '', `hd_tt_closed` int(1) NOT NULL default '0', `hd_tt_rating` int(1) NOT NULL default '0', PRIMARY KEY  (`hd_tt_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site HelpDesk Module Table';
DROP TABLE IF EXISTS `%PREFIX%helpdesk_msgs`;
CREATE TABLE `%PREFIX%helpdesk_msgs` (`hdi_tt_id` int(11) NOT NULL default '0', `hdi_tt_time_stamp` varchar(10) NOT NULL, `hdi_tt_cl_id` int(11) NOT NULL default '0', `hdi_tt_ad_id` int(11) NOT NULL default '0', `hdi_tt_message` text NOT NULL) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site HelpDesk Module Messages Table';
DROP TABLE IF EXISTS `%PREFIX%icons`;
CREATE TABLE `%PREFIX%icons` (`icon_id` smallint(6) NOT NULL auto_increment, `icon_name` varchar(32) NOT NULL default '', `icon_desc` varchar(50) NOT NULL default '', `icon_filename` varchar(32) NOT NULL default 'default.gif', PRIMARY KEY  (`icon_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Icons Table';
INSERT INTO `%PREFIX%icons` (`icon_id`, `icon_name`, `icon_desc`, `icon_filename`) VALUES(1, 'default', 'Default', 'default.gif');
DROP TABLE IF EXISTS `%PREFIX%invoices`;
CREATE TABLE `%PREFIX%invoices` (`invc_id` int(11) NOT NULL default '0', `invc_status` varchar(20) NOT NULL default 'draft', `invc_deliv_method` varchar(10) NOT NULL default '', `invc_delivered` tinyint(1) NOT NULL default '0', `invc_cl_id` int(11) NOT NULL default '0', `invc_total_cost` double NOT NULL default '0', `invc_total_paid` double NOT NULL default '0', `invc_subtotal_cost` double NOT NULL default '0', `invc_tax_01_percent` double NOT NULL default '0', `invc_tax_01_amount` double NOT NULL default '0', `invc_tax_02_percent` double NOT NULL default '0', `invc_tax_02_amount` double NOT NULL default '0', `invc_tax_autocalc` tinyint(1) NOT NULL default '1', `invc_ts` int(11) NOT NULL, `invc_ts_due` int(11) NOT NULL, `invc_ts_paid` int(11) NOT NULL, `invc_bill_cycle` tinyint(1) NOT NULL default '1', `invc_recurring` tinyint(1) NOT NULL default '0', `invc_recurr_proc` tinyint(4) NOT NULL default '0', `invc_last_nag_id` int(11) NOT NULL default '0', `invc_pay_link` text NOT NULL, `invc_terms` text NOT NULL,  PRIMARY KEY  (`invc_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Invoices Module Table';
DROP TABLE IF EXISTS `%PREFIX%invoices_items`;
CREATE TABLE `%PREFIX%invoices_items` (`ii_invc_id` int(11) NOT NULL default '0', `ii_item_no` smallint(4) NOT NULL default '0', `ii_item_name` varchar(30) NOT NULL default '', `ii_item_desc` varchar(75) NOT NULL default '', `ii_item_cost` double NOT NULL default '0', `ii_apply_tax_01` tinyint(1) NOT NULL default '1', `ii_apply_tax_02` tinyint(1) NOT NULL default '1', `ii_calc_tax_02_pb` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`ii_invc_id`,`ii_item_no`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Invoices Module Items Table';
DROP TABLE IF EXISTS `%PREFIX%invoices_trans`;
CREATE TABLE `%PREFIX%invoices_trans` (`it_id` bigint(11) NOT NULL auto_increment, `it_ts` int(11) NOT NULL, `it_invc_id` int(11) NOT NULL default '0', `it_type` tinyint(2) NOT NULL default '0', `it_origin` tinyint(2) NOT NULL default '0', `it_desc` varchar(50) NOT NULL default '', `it_amount` double NOT NULL default '0', PRIMARY KEY  (`it_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Invoices Module Transactions Table';
DROP TABLE IF EXISTS `%PREFIX%ipn_log`;
CREATE TABLE `%PREFIX%ipn_log` (`ipn_id` int(10) unsigned NOT NULL auto_increment, `ipn_ts` varchar(10) NOT NULL, `ipn_var_details` text, `ipn_txn` varchar(25) NOT NULL, `ipn_txn_type` varchar(100) NOT NULL, `ipn_cl_id` int(11) NOT NULL, `ipn_pay_amt` double default '0', `ipn_amt_applied` double default '0', `ipn_pay_stat` int(11) NOT NULL, `ipn_name_last` varchar(100) NOT NULL, `ipn_vendor` varchar(50) NOT NULL, PRIMARY KEY  (`ipn_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `%PREFIX%ipn_text`;
CREATE TABLE `%PREFIX%ipn_text` (`id` int(6) unsigned NOT NULL auto_increment, `ipn_txn_id` varchar(25) NOT NULL, `ipn_text_ts` varchar(10) NOT NULL, `ipn_log_text` text, PRIMARY KEY  (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `%PREFIX%mail_archive`;
CREATE TABLE `%PREFIX%mail_archive` (`ma_id` bigint(11) NOT NULL auto_increment, `ma_time_stamp` varchar(10) NOT NULL, `ma_fld_from` varchar(100) NOT NULL default '', `ma_fld_recip` varchar(100) NOT NULL default '', `ma_fld_cc` varchar(100) NOT NULL default '', `ma_fld_bcc` varchar(100) NOT NULL default '', `ma_fld_subject` varchar(100) NOT NULL default '', `ma_fld_message` text NOT NULL, PRIMARY KEY  (`ma_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site eMail Archive Table';
DROP TABLE IF EXISTS `%PREFIX%mail_contacts`;
CREATE TABLE `%PREFIX%mail_contacts` (`mc_id` int(11) NOT NULL auto_increment, `mc_name` varchar(30) NOT NULL default '', `mc_email` varchar(50) NOT NULL default '', `mc_status` tinyint(1) NOT NULL default '1', PRIMARY KEY  (`mc_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Mail Contacts Table';
INSERT INTO `%PREFIX%mail_contacts` (`mc_id`, `mc_name`, `mc_email`, `mc_status`) VALUES(1, 'Billing', 'billing@%DOMAINNAME%', 1);
INSERT INTO `%PREFIX%mail_contacts` (`mc_id`, `mc_name`, `mc_email`, `mc_status`) VALUES(2, 'Orders', 'orders@%DOMAINNAME%', 1);
INSERT INTO `%PREFIX%mail_contacts` (`mc_id`, `mc_name`, `mc_email`, `mc_status`) VALUES(3, 'Support', 'support@%DOMAINNAME%', 1);
INSERT INTO `%PREFIX%mail_contacts` (`mc_id`, `mc_name`, `mc_email`, `mc_status`) VALUES(4, 'Webmaster', 'webmaster@%DOMAINNAME%', 1);
INSERT INTO `%PREFIX%mail_contacts` (`mc_id`, `mc_name`, `mc_email`, `mc_status`) VALUES(5, 'Abuse', 'abuse@%DOMAINNAME%', 1);
DROP TABLE IF EXISTS `%PREFIX%mail_queue`;
CREATE TABLE `%PREFIX%mail_queue` (`mq_id` bigint(11) NOT NULL default '0', `mq_time_stamp` varchar(10) NOT NULL, `mq_fld_from` varchar(100) NOT NULL default '', `mq_fld_recip` varchar(100) NOT NULL default '', `mq_fld_cc` varchar(100) NOT NULL default '', `mq_fld_bcc` varchar(100) NOT NULL default '', `mq_fld_subject` varchar(100) NOT NULL default '', `mq_fld_message` text NOT NULL, `mq_sent_flag` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`mq_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site eMail Queue Table';
DROP TABLE IF EXISTS `%PREFIX%mail_templates`;
CREATE TABLE `%PREFIX%mail_templates` (`mt_id` int(11) NOT NULL auto_increment, `mt_name` varchar(50) NOT NULL default '', `mt_text` text NOT NULL, PRIMARY KEY  (`mt_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site eMail Templates Table';
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(1, 'email_password_reset', 'Hello $_MTP[username],\r\nThe following email from $_MTP[from_email] was triggered from a request to reset the password for this user name.\r\n\r\nThe new password is: $_MTP[password]\r\n\r\nPlease note the password has been reset. If you did not request the password change, we apologize for the inconvenience.\r\n\r\nAs a reminder, you can go to the following link to login and change you password.\r\n$_MTP[url]\r\n\r\n\r\n$_MTP[site] Support\r\n$_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(2, 'email_contact_form', 'Hello $_MTP[to_name],\r\nThe following email from $_MTP[from_name] was sent through the $_MTP[site] contact form. Note- the sender has also been copied on this email.\r\n\r\nMessage as follows:\r\n-------------------\r\nTo: $_MTP[to_name]\r\nFrom: $_MTP[from_name]\r\nEmail: $_MTP[from_email]\r\n\r\nSubject: $_MTP[subject]\r\n\r\nMessage:\r\n$_MTP[message]\r\n\r\n-------------------\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(3, 'email_contact_client_form', 'Hello $_MTP[to_name],\r\nThe following email from $_MTP[from_name] was sent through the $_MTP[site] contact client form. Note- the sender may also be copied on this email.\r\n\r\nMessage as follows:\r\n-------------------\r\nTo: $_MTP[to_name]\r\nFrom: $_MTP[from_name]\r\nEmail: $_MTP[from_email]\r\n\r\nSubject: $_MTP[subject]\r\n\r\nMessage:\r\n$_MTP[message]\r\n\r\n-------------------\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(4, 'email_profile_copy', 'Hello $_MTP[to_name],\r\nThe following client profile copy is from $_MTP[site] $_MTP[from_name] department.\r\n\r\n-------------------\r\n$_MTP[cl_info]\r\n-------------------\r\n\r\nThis profile information can be edited online at the following link (requires login):\r\n $_MTP[cl_url]\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(5, 'email_order_ack', 'Hello $_MTP[to_name],\r\nThe following order acknowledgement is from $_MTP[site] $_MTP[from_name] department.\r\n\r\n-------------------\r\n$_MTP[order]\r\n-------------------\r\n\r\nThis order can be monitored online at the following link (requires login):\r\n $_MTP[ord_url]\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(6, 'email_order_copy', 'Hello $_MTP[to_name],\r\nThe following order copy is from $_MTP[site] $_MTP[from_name] department.\r\n\r\n-------------------\r\n$_MTP[order]\r\n-------------------\r\n\r\nThis order can be monitored online at the following link (requires login):\r\n $_MTP[ord_url]\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(7, 'email_trans_ack', 'Hello $_MTP[to_name],\r\nThe following email transaction acknowledgement is from $_MTP[site] $_MTP[from_name] department.\r\n\r\n Invoice ID:    $_MTP[invc_id]\r\n Invoice Date:  $_MTP[invc_ts]\r\n Date Due:      $_MTP[invc_ts_due]\r\n Date Paid:     $_MTP[invc_ts_paid]\r\n Status:        $_MTP[invc_status]\r\n                ----------------------\r\n Trans ID:      $_MTP[it_id]\r\n Date:          $_MTP[it_ts]\r\n Type:          $_MTP[it_type]\r\n Origin:        $_MTP[it_origin]\r\n Description:   $_MTP[it_desc]\r\n Amount:        $_MTP[it_amount]\r\n                ----------------------\r\n\r\nThe following is overall account balance with $_MTP[site] and includes all account activity:\r\n\r\n Acc Balance:  $_MTP[cl_balance]\r\n\r\nThis transaction can be viewed when visiting following link (requires login):\r\n $_MTP[invc_url]\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(8, 'email_invoice_copy', 'Hello $_MTP[to_name],\r\nThe following email invoice is from $_MTP[site] $_MTP[from_name] department.\r\n\r\n Invoice ID:    $_MTP[invc_id]\r\n Invoice Date:  $_MTP[invc_ts]\r\n Date Due:      $_MTP[invc_ts_due]\r\n Terms:         $_MTP[invc_terms]\r\n Date Paid:     $_MTP[invc_ts_paid]\r\n Billing Cycle: $_MTP[invc_bill_cycle]\r\n\r\n Subtotal Due:  $_MTP[invc_subtotal_cost]\r\n Tax-01:        $_MTP[invc_tax_01_amount] ($_MTP[invc_tax_01_percent]%)\r\n Tax-02:        $_MTP[invc_tax_02_amount] ($_MTP[invc_tax_02_percent]%)\r\n                ----------------------\r\n Total Due:     $_MTP[invc_total_cost]\r\n\r\nOur Tax Registration Number: $_MTP[Company_TaxNo]\r\n(see below for items included in this invoice)\r\n\r\nThis invoice can be paid by clicking on the Payment Link when visiting following link (requires login):\r\n $_MTP[invc_url]\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n $_MTP[Company_Name]\r\n\r\n\r\nThe following is a list of items included in this invoice:\r\n-------------------\r\n$_MTP[iitems]\r\n-------------------\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(9, 'email_invoice_copy_singleline', 'Hello $_MTP[to_name];\r\n\r\nThis email is an automated notification that a new invoice has been issued against your account.\r\nThis email summarizes the invoice, and the original can be viewed and/or printed by clicking on the following link (requires login):\r\n$_MTP[invc_url]\r\n\r\nYou may have a prior debit or credit balance, in which case the amount we expect to receive from you is$_MTP[cl_balance].  You may login to the hosting control panel to see how this amount was determined.\r\n\r\nThank you for continuing to choose $_MTP[Company_Name] for your web service needs.\r\n\r\nRespectfully Yours,\r\nBilling Department\r\n$_MTP[Company_Name]\r\n\r\nINVOICE DETAILS:\r\n================\r\nInvoice ID:     $_MTP[invc_id]\r\nInvoice Date:   $_MTP[invc_ts]\r\nDate Due:       $_MTP[invc_ts_due]\r\nTerms:          $_MTP[invc_terms]\r\nDate Paid:      $_MTP[invc_ts_paid]\r\nInvoice Amount: $_MTP[invc_total_cost]\r\nBilling Cycle:  $_MTP[invc_bill_cycle]\r\nNotes: $_MTP[invc_pay_link]\r\n\r\nLine   Item         Description                                      Cost\r\n-------------------------------------------------------------------------\r\n$_MTP[iitems]\r\n-------------------------------------------------------------------------\r\nSubtotal:  $_MTP[invc_subtotal_cost]\r\n$_CCFG[INVC_TAX_01_LABEL]       $_MTP[invc_tax_01_amount] ($_MTP[invc_tax_01_percent]%)\r\n$_CCFG[INVC_TAX_02_LABEL]       $_MTP[invc_tax_02_amount] ($_MTP[invc_tax_02_percent]%)\r\n=================================\r\nTotal:     $_MTP[invc_total_cost]\r\n\r\nOur Tax Registration: $_MTP[Company_TaxNo]');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(10, 'email_domain_acc_activate', 'Hello $_MTP[to_name],\r\n\r\nWelcome!  Thank you for choosing $_MTP[site] for your hosting needs.\r\n\r\nThis email contains vital information about your server account. Please read it thoroughly and print these pages or copy to a safe place.\r\n\r\n-------------------------------------------------------------\r\n1.	General Client Profile Information\r\n-------------------------------------------------------------\r\n\r\n$_MTP[cl_info]\r\n\r\n-------------------------------------------------------------\r\n2.	General Account Information\r\n-------------------------------------------------------------\r\n\r\nTo log into your account, please access:\r\n\r\n$_MTP[si_cp_url]\r\n or:\r\nhttps://$_MTP[si_ip]:$_MTP[si_cp_url_port]/login.php3\r\n\r\nServer Name:	$_MTP[si_name]\r\nIP Address:		$_MTP[si_ip]  (shared)\r\nDomain Name:	$_MTP[dom_domain]\r\nPOP Server:		mail.$_MTP[dom_domain]\r\nSMTP Server:	mail.$_MTP[dom_domain]\r\n\r\nNameservers:	$_MTP[si_ns_01]  (IP: $_MTP[si_ns_01_ip])\r\n				$_MTP[si_ns_02]  (IP: $_MTP[si_ns_02_ip])\r\n\r\nPlesk Username:	$_MTP[dom_user_name_cp]\r\nPlesk Password:	$_MTP[dom_user_pword_cp]\r\n\r\nFTP Username:	$_MTP[dom_user_name_ftp]\r\nFTP Password:	$_MTP[dom_user_pword_ftp]\r\nFTP URL:		ftp.$_MTP[dom_domain]  (once resolved)\r\n\r\nPlease remember that it will take a short time for your Registrar to process the delegation request and for this new DNS to propagate around the internet. During that time, you will not be able to access this site as normal through a web browser. However, you can still access your site during this period by pointing your browser to:\r\n\r\n		http://$_MTP[si_ip]/~$_MTP[dom_user_name_ftp]\r\n\r\nPlease note that CGI and PHP will not function properly while view your site through this special IP address. It is just a temporary measure to assist you in preparing your site while your new DNS transfer around the net.\r\n\r\nYou can upload your site by pointing your FTP software to your shared IP address ($_MTP[si_ip]). This means that you do not have to wait for your domain name to be transferred to our servers before you can upload your site. Once your domain has fully propagated around the net, you will be able to access your FTP account via your own domain name.\r\n\r\n\r\n-------------------------------------------------------------\r\n3.	Once your domain resolves:\r\n-------------------------------------------------------------\r\n\r\n	Your webmail URL is:	http://webmail.$_MTP[dom_domain]\r\n\r\n	Your Webstats URL is:	http://$_MTP[dom_domain]/webstat/\r\n	(stats can also be viewed from control panel)\r\n\r\n\r\n-------------------------------------------------------------\r\n4.	Setting Up An Email Account\r\n-------------------------------------------------------------\r\n\r\n	Before you can start sending or receiving email, you must\r\n	set up at least one email account.  To do this, please\r\n	follow the instructions below:\r\n\r\n	1. Log in to the control panel\r\n		($_MTP[si_cp_url])\r\n		using your control panel username and password.\r\n\r\n	2. Click on the MAIL button.\r\n\r\n	3. Enter the mail name that you want to create (i.e. "bob",\r\n		"editor", "webmaster" etc., not the full address).\r\n\r\n	4. Click on the ADD button\r\n\r\n	5. Check/Tick the "Mailbox" box\r\n\r\n	6. Enter and confirm a password that you would like to use\r\n\r\n	7. Scroll down to the bottom and click UPDATE\r\n\r\n\r\n-------------------------------------------------------------\r\n5.	Billing Information\r\n-------------------------------------------------------------\r\n\r\nFor increased security reasons we do not process credit cards ourselves on our servers. Depending on your selection of payment method when ordering, one of two third party processors will be used:\r\n\r\n	Paypal:			- Charge will appear as "Paypal"\r\n	Credit Card:	- Charge will appear as "2CheckOut.com Inc."\r\n\r\nRegardless of the method you selected, you will receive an order confirmation email detailing your order information.\r\n\r\nIf your email addresses changes, please notify us of your new email address and also update your profile in the control panel via the EDIT button.\r\n\r\n\r\n-------------------------------------------------------------\r\n6.	Support Methods\r\n-------------------------------------------------------------\r\n\r\nWhen looking for information or support. Please go through the motions:\r\n(see $_MTP[site] on the Client Tools menu for all these links)\r\n\r\na. FAQ Knowledgebase:\r\nFor general and other information, browse and search our FAQ:\r\n\r\n	http://www.yoursite.com/phpcoin/mod.php?mod=faq\r\n\r\n\r\nb. The $_MTP[site] Community:\r\nWe can	 stress enough, the importance of joining and participating in our community forums.  Often, you can find the answers to your questions just by searching for keywords or posting a question.  There are other members who can help you out with certain things that are not covered by our normal support options (Programming etc). You can also interact with $_MTP[site] staff, give us feedback and generally discuss our service at a community level.\r\n\r\n	http://forums.yoursite.com\r\n\r\nImportant note: The community is installed on a different server than the primary website. The reason for this is in the event you cannot reach the main site due to server issues, you should be able to reach the community for information and updates.\r\n\r\n\r\nc. HelpDesk:\r\nIf you require assistance please contact our Technical Support Team by submitting a support form. We will be happy to assist you. All support requests MUST be done using our ticket support system, which can be accessed at:\r\n\r\n	http://www.yoursite.com/phpcoin/mod.php?mod=helpdesk\r\n\r\n\r\nd. Quick Chat:\r\nFor immediate assistance, check the Quick Chat feature setup on the main site. Simply click on the "Quick Chat" link under the client Tools menu. Login and and quite possibly someone will be there who can assist you.\r\n\r\n\r\ne. Email Support:\r\nThis form of support is mostly used for sales, orders, or basic questions. Please view the Contacts Info link on the main site for up-to-date links for email options.\r\n\r\n\r\nf. Phone Support:\r\nCurrently, $_MTP[site] does not offer phone support.\r\n\r\n\r\nh. Regular Mail:\r\n\r\n	$_UVAR[CO_INFO_01_NAME]\r\n	c/o Customer Service\r\n	$_UVAR[CO_INFO_02_ADDR_01]\r\n	$_UVAR[CO_INFO_03_ADDR_02]\r\n	$_UVAR[CO_INFO_04_CITY], $_UVAR[CO_INFO_05_STATE_PROV]	$_UVAR[CO_INFO_06_POSTAL_CODE]\r\n	$_UVAR[CO_INFO_07_COUNTRY]\r\n\r\n	Phone:	$_UVAR[CO_INFO_08_PHONE]\r\n	Fax:	$_UVAR[CO_INFO_09_FAX]\r\n\r\nOnce again, this email contains vital information about your account. \r\nPlease read it thoroughly and print these pages or copy to a safe place.\r\n\r\nThank you again for choosing $_MTP[site] as your service provider.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(11, 'email_helpdesk_tt_update', 'Hello $_MTP[to_name],\r\nThe following email HelpDesk Ticket is from $_MTP[site] $_MTP[from_name] department and is the result of $_MTP[req_type].\r\n\r\nThis ticket can be viewed by clicking on the following link (requires login):\r\n $_MTP[tt_url]\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n\r\n------------------------------\r\n Ticket ID:    $_MTP[hd_tt_id]\r\n Date Opened:  $_MTP[hd_tt_time_stamp]\r\n Priority:     $_MTP[hd_tt_priority]\r\n Category:     $_MTP[hd_tt_category]\r\n Domain:       $_MTP[cd_cl_domain]\r\n\r\n Status:       $_MTP[hd_tt_status]\r\n Open/Closed:  $_MTP[hd_tt_closed]\r\n Rating:       $_MTP[hd_tt_rating]\r\n\r\n Subject:      $_MTP[hd_tt_subject]\r\n Message (below):\r\n ----------------\r\n$_MTP[hd_tt_message]\r\n------------------------------\r\n\r\nThe following is a listing of HelpDesk Support Ticket messages to date:\r\n\r\n$_MTP[tt_msgs]\r\n------------------------------\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(12, 'email_helpdesk_tt_alert', ' Ticket ID:    $_MTP[hd_tt_id]\r\n Priority:     $_MTP[hd_tt_priority]\r\n Subject:      $_MTP[hd_tt_subject]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(13, 'email_custom_order_request', 'Hello $_MTP[to_name],\r\nThe following email from $_MTP[from_name] was sent through the $_MTP[site] Custom Order Request system, and is a copy for your records.\r\n\r\nWe will be contacting you with the results of our processing the information you requested.\r\n\r\nThe following client profile was created as a result of your order request. In the event you choose to place the order, you can login to place the order.\r\n\r\n-------------------\r\n$_MTP[cl_info]\r\n-------------------\r\n\r\nThe following is the information you entered into the Custom Order Request form.\r\n\r\n-------------------\r\n$_MTP[cor_info]\r\n-------------------\r\n\r\n\r\nThank you for continuing to choose $_MTP[site] for your web service needs.\r\n\r\n $_MTP[from_name]\r\n $_MTP[from_email]\r\n');
INSERT INTO `%PREFIX%mail_templates` (`mt_id`, `mt_name`, `mt_text`) VALUES(14, 'email_contact_supplier_form', 'Hello $_MTP[to_name],\r\nThe following email from $_MTP[from_name] was sent through the $_MTP[site] contact supplier form.\r\n\r\nMessage as follows:\r\n-------------------\r\nTo: $_MTP[to_name]\r\nFrom: $_MTP[from_name]\r\nEmail: $_MTP[from_email]\r\n\r\nSubject: $_MTP[subject]\r\n\r\nMessage:\r\n$_MTP[message]\r\n\r\n-------------------\r\n');
DROP TABLE IF EXISTS `%PREFIX%menu_blocks`;
CREATE TABLE IF NOT EXISTS `%PREFIX%menu_blocks` (`block_id` smallint(6) NOT NULL auto_increment, `block_pos` smallint(6) NOT NULL default '0', `block_title` varchar(30) NOT NULL default '', `block_status` tinyint(1) NOT NULL default '0', `block_admin` tinyint(1) NOT NULL default '0', `block_user` tinyint(1) NOT NULL default '0', `block_col` char(1) NOT NULL default 'L', PRIMARY KEY  (`block_id`), UNIQUE KEY `block_id` (`block_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Menu Blocks Table';
INSERT INTO `%PREFIX%menu_blocks` (`block_id`, `block_pos`, `block_title`, `block_status`, `block_admin`, `block_user`, `block_col`) VALUES(1, 1, 'Main Menu', 1, 0, 0, 'L');
INSERT INTO `%PREFIX%menu_blocks` (`block_id`, `block_pos`, `block_title`, `block_status`, `block_admin`, `block_user`, `block_col`) VALUES(2, 2, 'Admin Tools', 1, 1, 0, 'L');
INSERT INTO `%PREFIX%menu_blocks` (`block_id`, `block_pos`, `block_title`, `block_status`, `block_admin`, `block_user`, `block_col`) VALUES(3, 3, 'Client Tools', 1, 0, 0, 'L');
INSERT INTO `%PREFIX%menu_blocks` (`block_id`, `block_pos`, `block_title`, `block_status`, `block_admin`, `block_user`, `block_col`) VALUES(4, 4, 'Sponsored Links', 1, 0, 0, 'R');
INSERT INTO `%PREFIX%menu_blocks` (`block_id`, `block_pos`, `block_title`, `block_status`, `block_admin`, `block_user`, `block_col`) VALUES(5, 5, 'Misc. Links', 1, 0, 0, 'R');
DROP TABLE IF EXISTS `%PREFIX%menu_blocks_items`;
CREATE TABLE IF NOT EXISTS `%PREFIX%menu_blocks_items` (`block_id` smallint(6) NOT NULL default '0', `item_id` smallint(6) NOT NULL default '0', `item_text` varchar(30) NOT NULL default '', `item_url` varchar(100) NOT NULL default '', `item_target` tinyint(1) NOT NULL default '0', `item_type` tinyint(1) NOT NULL default '0', `item_status` tinyint(1) NOT NULL default '1', `item_admin` tinyint(1) NOT NULL default '0', `item_user` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`block_id`,`item_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Menu Blocks Items Table';
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(1, 1, 'Home', 'index.php', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(1, 3, 'About Us', 'mod.php?mod=siteinfo&id=4', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(1, 5, 'Contact Us', 'mod.php?mod=mail&mode=contact', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 2, 'A/R Listing', 'auxpage.php?page=ar_report', 0, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 12, 'PHP-Info', 'phpinfo.php', 1, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 14, 'Logout', 'login.php?w=admin&o=logout', 0, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(3, 1, 'Client Info.', 'mod.php?mod=clients', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(3, 3, 'Order Info.', 'mod.php?mod=orders&mode=view', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(3, 5, 'Invoice Info.', 'mod.php?mod=invoices', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(3, 7, 'Place Order', 'mod.php?mod=orders', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(3, 15, 'Log Out', 'login.php?w=user&o=logout', 0, 0, 1, 0, 1);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(4, 1, '_display_google_adsense', 'v', 0, 2, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(5, 8, 'phpCOIN', 'http://www.phpcoin.com', 1, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 4, 'Bills', 'mod.php?mod=bills', 0, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 5, 'A/P Listing', 'auxpage.php?page=ap_report', 0, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 6, 'ToDo List', 'mod.php?mod=todo', 0, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(2, 8, 'Client Envelope', 'coin_auxpages/client_envelope.php', 0, 0, 1, 1, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(5, 2, 'COINSoft Technologies', 'http://www.coinsofttechnologies.ca', 0, 0, 1, 0, 0);
INSERT INTO `%PREFIX%menu_blocks_items` (`block_id`, `item_id`, `item_text`, `item_url`, `item_target`, `item_type`, `item_status`, `item_admin`, `item_user`) VALUES(5, 4, 'COINSoft Magician', 'http://magician.coinsofttechnologies.ca', 0, 0, 1, 0, 0);
DROP TABLE IF EXISTS `%PREFIX%orders`;
CREATE TABLE `%PREFIX%orders` (`ord_id` int(11) NOT NULL default '0', `ord_ts` int(11) NOT NULL, `ord_ip` varchar(16) NOT NULL default '000.000.000.000', `ord_status` varchar(20) NOT NULL default 'pending', `ord_cl_id` int(11) NOT NULL default '0', `ord_company` varchar(50) NOT NULL default '', `ord_name_first` varchar(20) NOT NULL default '', `ord_name_last` varchar(20) NOT NULL default '', `ord_addr_01` varchar(50) NOT NULL default '', `ord_addr_02` varchar(50) NOT NULL default '', `ord_city` varchar(50) NOT NULL default '', `ord_state_prov` varchar(50) NOT NULL default '', `ord_country` varchar(50) NOT NULL default '', `ord_zip_code` varchar(12) NOT NULL default '', `ord_phone` varchar(20) NOT NULL default '', `ord_email` varchar(50) NOT NULL default '', `ord_domain` varchar(50) NOT NULL default '', `ord_domain_action` tinyint(1) NOT NULL default '0', `ord_user_name` varchar(20) NOT NULL default '', `ord_user_pword` varchar(50) NOT NULL default '', `ord_vendor_id` smallint(6) NOT NULL default '1', `ord_prod_id` smallint(6) NOT NULL default '0', `ord_unit_cost` double NOT NULL default '0', `ord_accept_tos` tinyint(1) NOT NULL default '0', `ord_accept_aup` tinyint(1) NOT NULL default '0', `ord_referred_by` varchar(50) NOT NULL default '', `ord_comments` text NOT NULL, `ord_optfld_01` varchar(50) NOT NULL default '', `ord_optfld_02` varchar(50) NOT NULL default '', `ord_optfld_03` varchar(50) NOT NULL default '', `ord_optfld_04` varchar(50) NOT NULL default '', `ord_optfld_05` varchar(50) NOT NULL default '', `ord_invc_id` int(11) NOT NULL default '0', PRIMARY KEY  (`ord_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Orders Module Table';
DROP TABLE IF EXISTS `%PREFIX%orders_sessions`;
CREATE TABLE `%PREFIX%orders_sessions` (`os_s_id` varchar(36) NOT NULL default '', `os_s_time_init` int(11) NOT NULL default '0', `os_s_time_last` int(11) NOT NULL default '0', `os_s_ip` varchar(16) NOT NULL default '000.000.000.000', `os_ord_processed` tinyint(1) NOT NULL default '0', `os_ord_ret_processed` tinyint(1) NOT NULL default '0', `os_ord_id` int(11) NOT NULL default '0', `os_ord_ts` varchar(10) NOT NULL, `os_ord_status` varchar(20) NOT NULL default 'pending', `os_ord_cl_id` int(11) NOT NULL default '0', `os_ord_company` varchar(50) NOT NULL default '', `os_ord_name_first` varchar(20) NOT NULL default '', `os_ord_name_last` varchar(20) NOT NULL default '', `os_ord_addr_01` varchar(50) NOT NULL default '', `os_ord_addr_02` varchar(50) NOT NULL default '', `os_ord_city` varchar(50) NOT NULL default '', `os_ord_state_prov` varchar(50) NOT NULL default '', `os_ord_country` varchar(50) NOT NULL default '', `os_ord_zip_code` varchar(12) NOT NULL default '', `os_ord_phone` varchar(20) NOT NULL default '', `os_ord_email` varchar(50) NOT NULL default '', `os_ord_domain` varchar(50) NOT NULL default '', `os_ord_domain_action` tinyint(1) NOT NULL default '0', `os_ord_user_name` varchar(20) NOT NULL default '', `os_ord_user_pword` varchar(50) NOT NULL default '', `os_ord_vendor_id` smallint(6) NOT NULL default '1', `os_ord_prod_id` smallint(6) NOT NULL default '0', `os_ord_unit_cost` decimal(10,2) NOT NULL default '0.00', `os_ord_accept_tos` tinyint(1) NOT NULL default '0', `os_ord_accept_aup` tinyint(1) NOT NULL default '0', `os_ord_referred_by` varchar(50) NOT NULL default '', `os_ord_comments` text NOT NULL, `os_ord_optfld_01` varchar(50) NOT NULL default '', `os_ord_optfld_02` varchar(50) NOT NULL default '', `os_ord_optfld_03` varchar(50) NOT NULL default '', `os_ord_optfld_04` varchar(50) NOT NULL default '', `os_ord_optfld_05` varchar(50) NOT NULL default '', `os_ord_cbflag` tinyint(1) NOT NULL default '0', `os_ord_cbpaid` tinyint(1) NOT NULL default '0', `os_cor_flag` tinyint(1) NOT NULL default '0', `os_cor_type` varchar(32) NOT NULL default '', `os_cor_opt_bill_cycle` varchar(32) NOT NULL default '', `os_cor_opt_payment` varchar(32) NOT NULL default '', `os_cor_disk` smallint(6) NOT NULL default '0', `os_cor_disk_units` char(3) NOT NULL default 'Mb', `os_cor_traffic` smallint(6) NOT NULL default '0', `os_cor_traffic_units` char(3) NOT NULL default 'Gb', `os_cor_dbs` smallint(6) NOT NULL default '0', `os_cor_mailboxes` smallint(6) NOT NULL default '0', `os_cor_unique_ip` tinyint(1) NOT NULL default '0', `os_cor_shop_cart` tinyint(1) NOT NULL default '0', `os_cor_sec_cert` tinyint(1) NOT NULL default '0', `os_cor_site_pages` tinyint(4) NOT NULL default '0', `os_cor_comments` text NOT NULL, `os_cor_optfld_01` varchar(50) NOT NULL default '', `os_cor_optfld_02` varchar(50) NOT NULL default '', `os_cor_optfld_03` varchar(50) NOT NULL default '', `os_cor_optfld_04` varchar(50) NOT NULL default '', `os_cor_optfld_05` varchar(50) NOT NULL default '', PRIMARY KEY  (`os_s_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Orders Module Sessions Table';
INSERT INTO `%PREFIX%orders_sessions` (`os_s_id`, `os_s_time_init`, `os_s_time_last`, `os_s_ip`, `os_ord_processed`, `os_ord_ret_processed`, `os_ord_id`, `os_ord_ts`, `os_ord_status`, `os_ord_cl_id`, `os_ord_company`, `os_ord_name_first`, `os_ord_name_last`, `os_ord_addr_01`, `os_ord_addr_02`, `os_ord_city`, `os_ord_state_prov`, `os_ord_country`, `os_ord_zip_code`, `os_ord_phone`, `os_ord_email`, `os_ord_domain`, `os_ord_domain_action`, `os_ord_user_name`, `os_ord_user_pword`, `os_ord_vendor_id`, `os_ord_prod_id`, `os_ord_unit_cost`, `os_ord_accept_tos`, `os_ord_accept_aup`, `os_ord_referred_by`, `os_ord_comments`, `os_ord_optfld_01`, `os_ord_optfld_02`, `os_ord_optfld_03`, `os_ord_optfld_04`, `os_ord_optfld_05`, `os_ord_cbflag`, `os_ord_cbpaid`, `os_cor_flag`, `os_cor_type`, `os_cor_opt_bill_cycle`, `os_cor_opt_payment`, `os_cor_disk`, `os_cor_disk_units`, `os_cor_traffic`, `os_cor_traffic_units`, `os_cor_dbs`, `os_cor_mailboxes`, `os_cor_unique_ip`, `os_cor_shop_cart`, `os_cor_sec_cert`, `os_cor_site_pages`, `os_cor_comments`, `os_cor_optfld_01`, `os_cor_optfld_02`, `os_cor_optfld_03`, `os_cor_optfld_04`, `os_cor_optfld_05`) VALUES('mht56jeg6oavhvjdrq3u3g6u70', 1234814719, 1234818944, '192.168.0.150', 0, 0, 0, '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '', '', 1, 1, '0.00', 1, 1, '', '', '', '', '', '', '', 0, 0, 0, '', '', '', 0, 'Mb', 0, 'Gb', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '');
DROP TABLE IF EXISTS `%PREFIX%pages`;
CREATE TABLE `%PREFIX%pages` (`id` int(9) NOT NULL auto_increment, `subject` varchar(50) NOT NULL default '', `topic_id` int(11) NOT NULL default '1', `cat_id` int(11) NOT NULL default '1', `time_stamp` varchar(10) NOT NULL, `pages_title` varchar(50) NOT NULL, `pages_code` longtext NOT NULL, `pages_block_it` tinyint(1) NOT NULL default '0', `pages_status` tinyint(1) NOT NULL default '0', `pages_admin` tinyint(1) NOT NULL default '0', `pages_link_menu` tinyint(1) NOT NULL default '0', `pages_link_prev` int(11) NOT NULL default '0', `pages_link_home` int(11) NOT NULL default '0', `pages_link_next` int(11) NOT NULL default '0', PRIMARY KEY  (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Pages Module Table';
INSERT INTO `%PREFIX%pages` (`id`, `subject`, `topic_id`, `cat_id`, `time_stamp`, `pages_title`, `pages_code`, `pages_block_it`, `pages_status`, `pages_admin`, `pages_link_menu`, `pages_link_prev`, `pages_link_home`, `pages_link_next`) VALUES(1, 'Backup Failed', 3, 1, '%TIMESTAMP%', 'Backup Failed', 'The MySQL database backup procedure has completed, but for some reason the file was not written to the server. Please check the location in Admin -> parameters -> subgroup=backup and ewnsure the the webserver user has write permission to that location', 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `%PREFIX%pages` (`id`, `subject`, `topic_id`, `cat_id`, `time_stamp`, `pages_title`, `pages_code`, `pages_block_it`, `pages_status`, `pages_admin`, `pages_link_menu`, `pages_link_prev`, `pages_link_home`, `pages_link_next`) VALUES(2, 'Backup Disallowed', 3, 1, '%TIMESTAMP%', 'Backup Disallowed', 'Your attempt to backup the database has been disallowed, sorry. Either you are not an admin, or you used a POST/GET request from outside this website.', 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `%PREFIX%pages` (`id`, `subject`, `topic_id`, `cat_id`, `time_stamp`, `pages_title`, `pages_code`, `pages_block_it`, `pages_status`, `pages_admin`, `pages_link_menu`, `pages_link_prev`, `pages_link_home`, `pages_link_next`) VALUES(3, 'Backup Completed', 3, 1, '%TIMESTAMP%', 'Backup Completed', 'The MySQL database backup procedure has completed. Depending on the backup option you chose, you will now have one of the following:<ul>\r\n<li>A MySQL dump file of the database on your computer, or</li>\r\n<li>A MySQL dump of the database in a directory on your webserver, or</li>\r\n<li>An email message with a MySQL dump of the database attached.</li>\r\n</ul>', 1, 0, 0, 0, 0, 0, 0);
DROP TABLE IF EXISTS `%PREFIX%parameters`;
CREATE TABLE `%PREFIX%parameters` (`parm_id` int(11) NOT NULL auto_increment, `parm_group` varchar(10) NOT NULL default 'common', `parm_group_sub` varchar(10) NOT NULL default 'undefined', `parm_type` char(1) NOT NULL default 'S', `parm_name` varchar(50) NOT NULL default '', `parm_desc` varchar(50) NOT NULL default '', `parm_value` varchar(100) NOT NULL default '', `parm_notes` text NOT NULL, PRIMARY KEY  (`parm_id`), UNIQUE KEY `parm_name` (`parm_name`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Parameters Table';
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'B', 'HELPDESK_AUTO_IMPORT_ENABLE', 'Auto-import: Enable', '1', 'YES: The helpdesk cronjob will connect to a POP or IMAP box and attempt to create helpdesk tickets or ticket messages from any emails found\r\nNO: (obvious)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_SERVER', 'Auto-import: Server', 'mail.%DOMAINNAME%', 'Name of the email server the helpdesk cronjob should connect to');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_TYPE', 'Auto-import: Protocol', ':143/imap/notls', 'Protocol and port that the helpdesk cronjob should connect to\r\n"/imap:143" seems to work better than "/pop:110"\r\nYou may also need to try /IMAP/:143/notls or /:110/POP/notls or even other strings, depending on your mailserver');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_USERID', 'Auto-import: UserName', 'support@%DOMAINNAME%', 'The email username that the helpdesk cronjob will check');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_PASSWORD', 'Auto-import: Password', 'password', 'Password for the email account that will be checked by the helpdesk cronjob');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'I', 'HELPDESK_AUTO_IMPORT_DELETE_MESSAGES', 'Auto-import: Delete Messages', '1', 'Delete _these_ messages on the mail-server when the helpdesk cronjob runs');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_DEFAULT_CATEGORY', 'Auto-import: Category', 'General', 'Default "category" for helpdesk tickets auto-created by the helpdesk cronjob');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_DEFAULT_PRIORITY', 'Auto-import: Priority', 'Medium Priority', 'Default "priority" for helpdesk tickets auto-created by the helpdesk cronjob');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'S', 'HELPDESK_AUTO_IMPORT_DEFAULT_STATUS', 'Auto-import: Status', 'Awaiting Support', 'Default "status" for helpdesk tickets auto-created by the helpdesk cronjob');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'INVC_ACOPY_DELAY_ENABLE', 'Invoice Auto-Copy: Delay', '1', 'YES: Wait until new invoice date is within days-out setting before auto-copying new invoice. Auto-invoices will not sit as "pending" for a long time, and invoice numbers will be close to sequential\r\nNO: Auto-copy new invoice as soon as possible. An auto-invoice for next year will sit as "pending" for almost a year, and invoice numbers will not be sequential');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'I', 'INVC_ACOPY_DAYS_OUT', 'Invoice Auto-Copy: Days Out to Copy', '14', 'The number of days from current date to auto-copy a recurring invoice. Auto-copy will occur if the new invoice date falls within this date range');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'INVC_AUTO_UPDATE_ENABLE', 'Invoice Auto-Copy: Auto-Update Status', '1', 'YES: Auto-update of invoice status will occur when triggered by cron job or when run manually by command summary actions menu\r\nNO: Auto-update of invoice status will not occur');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'INVC_AUTO_COPY_ENABLE', 'Invoice Auto-Copy: Enable', '1', 'YES: Auto-copy of invoices will occur when triggered by cron job or when run manually by command summary actions menu\r\nNO: Auto-copy of invoices will not occur');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'INVC_AUTO_REMINDERS_ENABLE', 'Invoice Reminders: Autosend Overdue Reminders', '1', 'YES: phpCOIN will auto-send the specified email message on the specified overdue day(s)\r\nNO: You must manually remind your customers that they are overdue.\r\nYou may setup as many event-dates and templates as you need.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'INVC_SOON_REMINDERS_ENABLE', 'Invoice Reminders: Autosend Soon-Due Reminders', '1', 'YES: phpCOIN will auto-send "reminders" email message number zero half way between the invoice issued and due dates\r\nNO: There will be NO reminders sent that an invoice will soon be due');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'helpdesk', 'B', 'HELPDESK_AUTO_VERBOSE', 'Auto-import: Verbose', '0', 'YES: phpCOIN will display the results of processing of each email message\r\nNO: phpCOIN will only display aggregate results');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'invoices', 'B', 'ORDER_AUTO_CREATE_INVOICE', 'Order Invoice: Auto-Create From Order', '1', 'YES: Auto-create an invoice with the default terms, due dates, etc. every time a product is ordered\r\nNO: No invoice will be auto-created');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'invoices', 'B', 'AUTO_INV_RECUR', 'Order Invoice: Auto-Recur From Order', '1', 'YES: The invoice will be set to recur automatically by cronjob\r\nNO: The invoice will be set as NOT recurring (ie: one-time)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'invoices', 'S', 'AUTO_INV_STATUS', 'Order Invoice: Default Status', 'due', 'Default status of invoices auto-created by the order module.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'invoices', 'S', 'AUTO_INV_DELIVERY', 'Order Invoice: Default Delivery Method', 'email', 'Default delivery method for invoices auto-created by the order module.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'invoices', 'I', 'AUTO_INVC_BILL_CYCLE', 'Order Invoice: Default Billing Cycle', '1', 'Default billing cycle for invoices auto-created by the order module.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'invoices', 'B', 'AUTO_INV_DELIVERED', 'Order Invoice: Flag as Delivered', '1', 'Should the invoice "delivered" flag be set to delivered?');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'admin', 'B', 'AUTOCHECK_UPDATES', 'Automatically Check For Updates: Enable', '1', 'YES: phpCOIN will check for new versions and bug-fixes each time you click the [Admin] or [Summary] button.  This enables phpCOIN to advise you when a new version or bug-fix is available, and provides a direct link to the actual download.  This feature uses an RSS feed, and does NOT send any information whatsoever to phpCOIN.com\r\nNO: Do not check for available updates and bug-fixes');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'admin', 'I', '_MAX_MENU_BLK_POS', 'Menu Block: Max Menu Blocks', '25', 'The maximum number to appear in the menu block position field drop-down list.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'admin', 'I', '_MAX_MENU_ITM_NO', 'Menu Block: Max Block Items', '25', 'The maximum number to appear in the menu item position field drop-down list.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'admin', 'B', '_PARM_EDITOR_SHOW_NOTES', 'Parameters: Show Notes in Listing', '1', 'Enable the display of the parameter notes field in the main listing (what you are looking at right now)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'admin', 'B', 'DisplayType', 'Admin Menu: Display as List', '0', 'YES: Displays the Admin menu as "list" style\r\nNO: Displays the Admin menu as "button" table');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'API', 'B', 'APIO_MASTER_ENABLE', 'API Output Enable: API System Activated', '0', 'YES: The individual API Output functions enabled are allowed to trigger\r\nNO: Regardless of the individual API settings, no API functions will be triggered');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'API', 'B', 'APIO_ORDER_COR_PROC_ENABLE', 'API Output Enable: Order COR Proc', '0', 'If the API Output function is called when a COR order record is created by the order process');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'API', 'B', 'APIO_ORDER_NEW_CLIENT_ENABLE', 'API Output Enable: Order New Client', '0', 'If the API Output function is called when a client record is created by the order process');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'API', 'B', 'APIO_ORDER_NEW_DOMAIN_ENABLE', 'API Output Enable: Order New Domain', '0', 'If the API Output function is called when a domain record is created by the order process');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'API', 'B', 'APIO_ORDER_OUT_PROC_ENABLE', 'API Output Enable: Order Out Proc', '0', 'If the API Output function is called when a client is shown the paylink during the order process');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'API', 'B', 'APIO_ORDER_RET_PROC_ENABLE', 'API Output Enable: Order Return Proc', '0', 'If the API Output function is called when a client returns from clicking the paylink during the order process');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_CLIENT_NEW_ENABLE', 'API Output Enable: Client Created', '0', 'If the API Output function is called when a client record is created by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_CLIENT_DEL_ENABLE', 'API Output Enable: Client Deleted', '0', 'If the API Output function is called when a client record is deleted by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_DOMAIN_NEW_ENABLE', 'API Output Enable: Domain Created', '0', 'If the API Output function is called when a domain record is created by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_DOMAIN_DEL_ENABLE', 'API Output Enable: Domain Deleted', '0', 'If the API Output function is called when a domain record is deleted by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'API', 'B', 'APIO_ORDER_NEW_ENABLE', 'API Output Enable: Order Created', '0', 'If the API Output function is called when an order record is created');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_ORDER_DEL_ENABLE', 'API Output Enable: Order Deleted', '0', 'If the API Output function is called when an order record is deleted by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_PRODUCT_NEW_ENABLE', 'API Output Enable: Product Created', '0', 'If the API Output function is called when a product record is created by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_PRODUCT_DEL_ENABLE', 'API Output Enable: Product Deleted', '0', 'If the API Output function is called when a product record is deleted by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_TRANS_NEW_ENABLE', 'API Output Enable: Trans Created', '0', 'If the API Output function is called when a transaction record (invoice, payment, etc.) is created');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'API', 'B', 'APIO_TRANS_DEL_ENABLE', 'API Output Enable: Trans Deleted', '0', 'If the API Output function is called when a transaction record (invoice, payment, etc.) is deleted by admin');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'articles', 'I', 'IPP_ARTICLES', 'List: Items Per Page', '25', 'The number of articles that are displayed in listing form on a page.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'articles', 'S', 'ARTICLES_DATE_DISPLAY_FORMAT', 'Articles Date/Time Display Format', '%A- %B %d, %Y @ %H:%M:%S %Z', 'The display format for Articles date display. See http://www.php.net/manual/en/function.strftime.php for formatting options.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_SAVE_DIR', 'Save On Server: Save Directory', '/user/temp', 'Directory on webserver to save mySQL dump file to when the "save to webserver" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_EMAIL_FROM_NAME', 'Backup By Email: Email From Name', 'WebSite', 'The name of the person that the email is from when the "Email to me" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_EMAIL_FROM_ADDRESS', 'Backup By Email: Email From Address', 'webserver@%DOMAINNAME%', 'The email address of the person that the email is from when the "Email to me" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_EMAIL_TO_NAME', 'Backup By Email: Email To Name', 'Recipient Name', 'The name of the person that the email is to when the "Email to me" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_EMAIL_TO_ADDRESS', 'Backup By Email: Email To Address', 'support@%DOMAINNAME%', 'The email address of the person that the email is to when the "Email to me" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_EMAIL_SUBJECT', 'Backup By Email: Email Subject', 'phpCOIN Database Backup Attached', 'Subject line of email sent when "Email to me" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'S', 'MYSQL_BACKUP_EMAIL_BODY', 'Backup By Email: Email Body', 'A MySQL dump of your phpCOIN database is attached to this email.', 'The message body when the "Email to me" backup option is chosen.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'backup', 'I', 'MYSQL_BACKUP_EMAIL_PRIORITY', 'Backup By Email: Email Priority', '3', 'Priority of message when "email to me" backup option is chosen. 1 is "Urgent", 3 is "Normal".');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'I', 'BASE_CLIENT_ID', 'Clients: Initial Value', '1000', 'Starting point for the first client entered in the system. Client ID will be this value plus one');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'clients', 'I', 'IPP_CLIENTS', 'List: Items Per Page', '25', 'The number of clients that are displayed in listing form on a page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'clients', 'I', 'IPL_CLIENTS_ACCOUNT', 'List: Items Per Summary', '5', 'The number of most recent items per section (orders, invoices, tickets) that are displayed on a client account page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'clients', 'S', 'CLIENT_DEF_STATUS_NEW', 'Orders: Client Status on Create', 'active', 'The default client status used when a new client is created during the ordering process');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'B', 'CLIENT_EMAIL_CC_ENABLE', 'Client Profile Email: CC To Admin', '1', 'YES: When a client clicks the icon to email their client profile, the site admin will receive a copy of the email\r\nNO: When a client clicks the icon to email their client profile, the site admin will not receive a copy of the email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'B', 'Username_AlphaNum', 'Login: AlphaNumeric UserName Only', '0', 'YES: The username must contain only letters and numbers\r\nNO: Special characters such as pound and underscore are allowed in a username');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'I', 'CLIENT_MAX_LEN_UNAME', 'Login: Max. Characters for User Name', '16', 'The maximum number of characters permitted in username form fields.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'I', 'CLIENT_MAX_LEN_PWORD', 'Login: Max. Characters for Password', '16', 'The maximum number of characters permitted in password form fields');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'I', 'CLIENT_MIN_LEN_PWORD', 'Login: Min. Characters for Password', '8', 'The minimum number of characters permitted in password form fields');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'clients', 'I', 'CLIENT_VIEW_PAGE_UPON_LOGIN', 'Default: Page View Upon Login', '1', 'The page to show the client when they first log in');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'clients', 'I', 'CLIENT_LIST_DISPLAY', 'List: Optional Data Displayed', '1', 'Select the two-out-of-three columns that you wish displayed when viewing a list of clients.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'B', 'ALLOW_NULL_EMAIL', 'Allow Clients With No Email Address', '0', 'Web-Hosts will want clients to have an email address for auto-billing, but accountants can now use phpCOIN for tracking/invoicing clients with no email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'I', 'MC_ID_BILLING', 'Mail Contacts: ID For Billing', '1', 'The mail contact id to be used when phpCOIN requires an email address for Billing');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'I', 'MC_ID_ORDERS', 'Mail Contacts: ID For Orders', '2', 'The mail contact id to be used when phpCOIN requires an email address for Orders');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'I', 'MC_ID_SUPPORT', 'Mail Contacts: ID For Support', '3', 'The mail contact id to be used when phpCOIN requires an email address for Support');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'I', 'MC_ID_WEBMASTER', 'Mail Contacts: ID For Webmaster', '4', 'The mail contact id to be used when phpCOIN requires an email address for Webmaster');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'domains', 'I', 'IPP_DOMAINS', 'List: Items Per Page', '25', 'The number of domains that are displayed in listing form on a page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'I', 'DOM_DEFAULT_SERVER', 'Default: Server ID', '1', 'The default server id that is inserted when a domain is created');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'S', 'DOM_DEFAULT_PATH', 'Default: Path', '/home/httpd/vhosts/domain/httpdocs', 'The default file-system path to domain files inserted when a domain account is created. Use "username" to insert client user name, or "domain" to insert the domain name');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'domains', 'B', 'DOM_EMAIL_CC_ENABLE', 'Domain Info Email: CC To Admin', '1', 'YES: When a client clicks the icon to email their domain information, the site admin will receive a copy of the email\r\nNO: When a client clicks the icon to email their domain information, the site admin will not receive a copy of the email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'B', 'DOM_FORCE_CHECK_TRUE', 'Domains: All Names Valid', '0', 'NO: Domain names entered will be checked to ensure that the TLD is in the list of TLDs you support in the WHOIS module\r\nYES: The domain name validation logic will always return that the entered domain name is valid, even if that TLD is not active in WHOIS');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'S', 'DOM_DEFAULT_IP', 'Default: IP Address', '000.000.000.000', 'The default domain IP address that is inserted when a domain account is created.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'S', 'DOM_DEFAULT_USERNAME', 'CP/FTP: Default User Name', 'username', 'The default CP/FTP User Name inserted when a domain account is created by the order process. Choose "username" to insert client user name, or "domain" to insert the domain name');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'S', 'DOM_DEFAULT_CP_URL', 'Default: Control Panel URL', '', 'The URL (fully qualified) that will be used for the control panel link shown in domain listings. Variables that can be used her and will be replaced with actual values at run-time are:\r\n%DOM_ID% the domain_id\r\n%DOM_NAME% the domain name\r\n%CL_ID% client_id\r\n%FTP_NAME% default CP/FTP username\r\n%FTP_PWORD% default CP/FTP password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'domains', 'B', 'DOM_CP_URL_LINK_ENABLE', 'List: Enable CP Link', '1', 'YES: The control panel link will be shown in domain listings\r\nNO: The CP link will not be shown in listings');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'B', 'MATCH_CP_LOGIN_TO_ACCOUNT', 'CP/FTP: Use phpCOIN Password For FTP', '0', 'NO: A random password for FTP will be generated by phpCOIN.\r\nYES: The FTP password created by phpCOIN will match the username and password entered by the client for accessing phpCOIN. This means that you will know the u/p for account creation with cPanel, etc., but it is a security risk because this info is stored in the clear in the database');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'domains', 'B', 'SHOW_PASSWORDS_TO_CLIENTS', 'CP/FTP: Show Passwords To Clients', '1', 'YES: Clients can see their plaintext passwords for FTP and Control Panel access when viewing domain info\r\nNO: Only admins can see the passwords');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'domains', 'B', 'DOMAINS_ENABLE', 'Domains: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'helpdesk', 'I', 'IPP_HELPDESK', 'List: Items Per Page', '25', 'The number of helpdesk tickets that are displayed  in listing form on a page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'I', 'BASE_HELPDESK_ID', 'HelpDesk TT ID Base-Initial Value Minus 1', '1000', 'Determines the helpdesk ticket id initial value for the first helpdesk ticket entered in the system. Helpdesk Ticket ID will be this value plus one.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'helpdesk', 'B', 'HELPDESK_ENABLE', 'HelpDesk: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'S', 'HELPDESK_ALERT_EMAIL_ADDRESS', 'HelpDesk TT Alert Email: Address', 'webmaster@%DOMAINNAME%', 'The email (pager email) address the Alert Email is sent to. Does not effect normal support email received');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'helpdesk', 'B', 'HELPDESK_ALERT_EMAIL_ENABLE', 'Helpdesk TT Alert Email: Enable', '1', 'YES: An Alert Email is also sent when a new ticket is created, in addition to normal email to support\r\nNO: Only the normal email to support is sent');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'B', 'HELPDESK_ADMIN_REVEAL_ENABLE', 'HelpDesk Admin: Reveal Admin Identity', '1', 'YES: The specific admin responding to HelpDesk items will be identified in listings and emails\r\nNO: HelpDesk listings and emails will show as being from "support"');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'B', 'HELPDESK_MSG_CC_CLIENT_ENABLE', 'Helpdesk Message Email: CC To Client', '0', 'YES: Client will receive a CC of the email when they submit a helpdesk message\r\nNO: Only support receives the message');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'B', 'HELPDESK_REPLY_EMAIL_SET_LIMIT', 'HelpDesk Reply: Limit Messages Sent', '1', 'YES: Include only the X most recent messages for the HelpDesk Ticket in the reply notice email\r\nNO: Include all messages for the HelpDesk Ticket in the reply notice email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'I', 'HELPDESK_REPLY_EMAIL_LIMIT', 'Helpdesk Reply: Email Messages Limit', '2', 'The number of most recent messages to include in the reply notice email.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'helpdesk', 'B', 'HELPDESK_SHOW_CLIENT_NAME', 'List: Show Client Name', '1', 'Enable the Client column in the helpdesk tickets listing when viewed by admins');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'helpdesk', 'B', 'HELPDESK_ADMIN_CAN_ADD', 'HelpDesk Admin: Admin Can Enter Tickets', '1', 'YES: An administrator can enter a new support ticket on behalf of a client\r\nNO: Only a logged-in client can enter a new support ticket.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'I', 'IPP_INVOICES', 'List: Items Per Page', '25', 'Determines the number of invoices that are displayed  in listing form on a page.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'I', 'BASE_INVOICE_ID', 'Invoice ID Initial Value', '1000', 'Starting point for the first invoice entered in the system. Invoice ID will be this value plus one');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'B', 'INVC_AUTO_EMAIL_ENABLE', 'Invoice Auto-Email to Clients Enable', '1', 'YES: Auto-email of due invoices is enabled when triggered by cron job or manually by command summary actions menu');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'B', 'INVC_AUTO_EMAIL_CC_ENABLE', 'Invoice Auto-Email CC Admin Enable', '0', 'YES: Admin will receive a copy each time the auto-email code sends an invoice');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'S', 'INVC_DEL_MTHD_DEFAULT', 'Invoice Delivery Method Default Value', 'email', 'The default invoice delivery method presented on invoice create');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'I', 'INVC_DUE_DAYS_OFFSET', 'Invoice Due x Days After Create', '10', 'When an invoice is created, phpCOIN will add this many days to the create date in order to auto-calc the due date');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'B', 'INVC_EMAIL_CC_ENABLE', 'Invoice Email CC Admin Enable', '0', 'YES: Admin will receive a copy each time a request is made to email an invoice');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'invoices', 'B', 'INVC_TAX_01_ENABLE', 'Invoices: Tax 01 Enable', '1', 'YES: Tax 1 will be calculated and displayed on invoices\r\nNO: Tax 1 will NOT be calculated and displayed on invoices');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'invoices', 'B', 'INVC_TAX_02_ENABLE', 'Invoices: Tax 02 Enable', '1', 'YES: Tax 2 will be calculated and displayed on invoices\r\nNO: Tax 2 will NOT be calculated and displayed on invoices');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'INVC_TERMS_INSERT_DEF', 'Invoice Terms: Auto-Insert Default', '1', 'YES: When terms are enabled, the terms field is auto-populated with the default terms on new invoices if admin left them empty on save\r\nNO: When terms are enabled, the terms field is left blank on new invoices if admin left them empty on save');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'INVC_TERMS_ENABLE', 'Invoice Terms: Enable', '1', 'YES: The invoice terms field is displayed on invoice views');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'INVC_SHOW_CLIENT_PENDING', 'Invoices: Show Pending To Client', '0', 'YES: The client will see invoices that are set to pending status. Useful as advance warning about upcoming invoices\r\nNO: The client will not see invoices that are set to pending status. No advance warning about upcoming invoices');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'INVC_SPLIT_TRANS_LIST_ENABLE', 'Invoice Transaction Listing: Enable Split Listing', '0', 'YES: The invoice transaction listing is split to list charges on top, and then credits below in a separate list\r\nNO: invoice transactions appear in a single section one after the other, like a standard statement');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'B', 'INVC_TAX_BY_ITEM', 'Invoice Taxes: Tax By Item', '1', 'YES: Taxes will be calculated on each item individually\r\nNO: Taxes will be calculated only on the invoice totals');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'S', 'INVC_TAX_01_LABEL', 'Invoice Tax 01: Label', '13% HST:', 'The text label displayed on bills in place of "Tax 01"');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'R', 'INVC_TAX_01_DEF_VAL', 'Invoice Tax 01: Rate', '13.00', 'The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'S', 'INVC_TAX_02_LABEL', 'Invoice Tax 02: Label', '5% PST:', 'The text label displayed on bills in place of "Tax 02"');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'R', 'INVC_TAX_02_DEF_VAL', 'Invoice Tax 02: Rate', '5.00', 'The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'I', 'INVC_VIEW_SHOW_TRANS', 'Invoice Transaction Listing: Show Transactions', '3', 'If the transactions listing is displayed on lower portion of invoice:\r\n0: No transactions displayed\r\n1: Transactions displayed on-screen only\r\n2: Transactions displayed on printed output only\r\n3: Transactions appear on both screen and printed output');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'PRICES_INCLUDE_TAXES', 'Invoice Taxes: Prices Include Taxes', '0', 'NO: phpCOIN will add applicable taxes to items on invoices\r\nYES: phpCOIN assumes that the prices include tax. In this event, taxes will be removed from the items and then recalculated, so the invoice can show the amount of taxes included in the prices.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'SINGLE_LINE_EMAIL_INVOICE_ITEMS', 'Invoice Email: Single Line Per Item', '1', 'YES: Set each item on an emailed invoice to be single-line like a paper invoice. The formatting only works for text invoices and will not line up properly if outgoing html emails are enabled\r\nNO: Use multiple lines to describe each item. Layout is not messed up with outgoing html emails enabled, but it does not look like and invoice');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'invoices', 'B', 'INVOICES_ENABLE', 'Invoices: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'invoices', 'B', 'INVC_SHOW_LAST_NAG', 'Invoices: Show Last Nag', '1', 'YES: An additional info-box containing the name of the last nag email sent (if any) will be displayed as part of the invoice');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_FOOTER_LINE_01', 'Site Footer Block: Line 01 Text', 'Copyright %DOMAINNAME% 2003-2009, all rights reserved', 'The line 01 text that will be displayed in footer of the page output');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_FOOTER_LINE_02', 'Site Footer Block: Line 02 Text', '', 'The line 02 text that will be displayed in footer of the page output');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', '_PKG_EMAIL_OUT_ENABLE', 'Email: Enable', '1', 'YES: phpCOIN will send all normal emails\r\nNO: The main email functions are disabled from sending email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'B', 'MAIL_USE_CUSTOM_SUBJECT', 'Email Contact Client: Use Custom Subject', '1', 'YES: Use the subject that you entered on the form instead\r\nNO: Use the default subject line of "sitename- Client Contact Message" on emails sent using the [eMail Client] form');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'B', '_PKG_SAFE_EMAIL_ADDRESS', 'Email: Use Safe Address Format', '0', 'YES: Emails will be sent as only <name@address> which every mail-server will accept\r\nNO: Emails sent from phpCOIN use the "Name <name@address>" format. Some mail-servers have a problem with this');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'EMAIL_AS_HTML', 'HTML Email: Enable HTML Outgoing', '1', 'YES: phpCOIN will send html emails\r\nNO: phpCOIN will send plain-text only emails');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'admin', 'B', 'ENABLE_QUICK_EDIT', 'Quick-Edit Icons: Enable', '1', 'YES: Display quick-access icons where appropriate for editing parameters and page text, rather than forcing admin to goto Admin and select menu items\r\nNO: Settings and content can only be edited by clicking through the relevant buttons and menus');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'IPP_ORDERS', 'List: Items Per Page', '25', 'The number of orders that are displayed in listing form on a page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'orders', 'I', 'BASE_ORDER_ID', 'Order ID Base-Initial Value Minus 1', '1000', 'Determines the order id initial value for the first order entered in the system. Order ID will be this value plus one.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'B', 'ENABLE_EMAIL_ORDER_OUT', 'Order Email: Mail to Admin on Order Out', '1', 'YES: An email is sent to admin when client is showed the order paylink (order inserted into system)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'B', 'ENABLE_EMAIL_ORDER_RET', 'Order Email: Mail to Admin on Order Return', '1', 'YES: An email is sent to admin when client is returned to phpCOIN from billing vendor');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDER_POLICY_BTTN_AUP', 'Order Policy Button Show: AUP', '1', 'Determines if order policy button for Acceptable Use Policy is shown on place order screens.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDER_POLICY_BTTN_BC', 'Order Policy Button Show: BC', '1', 'Determines if order policy button for Banned Code is shown on place order screens.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDER_POLICY_BTTN_PP', 'Order Policy Button Show: PP', '1', 'Determines if order policy button for Privacy Policy is shown on place order screens.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDER_POLICY_BTTN_TOS', 'Order Policy Button Show: TOS', '1', 'Determines if order policy button for Terms Of Service is shown on place order screens.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'orders', 'I', 'ORDER_POLICY_SI_ID_AUP', 'Order Policy SiteInfo ID for: AUP', '6', 'Determines the siteinfo page id for the Acceptable Use Policy button link.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'orders', 'I', 'ORDER_POLICY_SI_ID_BC', 'Order Policy SiteInfo ID for: BC', '8', 'Determines the siteinfo page id for the Banned Code Policy button link.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'orders', 'I', 'ORDER_POLICY_SI_ID_PP', 'Order Policy SiteInfo ID for: PP', '5', 'Determines the siteinfo page id for the Privacy Policy button link.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'orders', 'I', 'ORDER_POLICY_SI_ID_TOS', 'Order Policy SiteInfo ID for: TOS', '7', 'Determines the siteinfo page id for the Terms Of Service button link.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'orders', 'B', 'ORDER_EMAIL_CC_ENABLE', 'Order Email: CC To Admin', '1', 'YES: The site admin will receive a copy each time a request is made to email a order');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'B', 'ORDERS_ACK_EMAIL_ENABLE', 'Order Email: Ack Email To Client', '1', 'YES: An acknowledgment email will be sent to client on new order');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'B', 'ORDERS_ACK_EMAIL_ONRET', 'Order Email: Ack Email To Client On Return', '1', 'An acknowledgment email will be sent to client on return from vendor, instead of upon paylink display');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'orders', 'B', 'ORDERS_ENABLE', 'Orders: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'orders', 'B', 'ORDERS_AUP_ENABLE', 'Orders Req. Acceptable Use Policy (AUP): Enable', '1', 'YES: The "Acceptable Use Policy" button is visible and client must check "I agree to AUP" box during order placement');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'orders', 'B', 'ORDERS_COR_ENABLE', 'Custom Order Request (COR): Enable', '1', 'YES: a surfer can click the COR button to submit a price request for a custom order during the order process\r\nNO: The surfer can order only pre-defined products and services');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'orders', 'B', 'ORDERS_TOS_ENABLE', 'Orders Req. Terms Of Service (TOS): Enable', '1', 'YES: The "Terms of Service" button is visible and client must check "I agree to TOS" box during order placement');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'S', 'ORDERS_DEF_STATUS_NEW', 'Orders: Default Status on Create', 'pending', 'The default order status used when an order is placed');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_FIELD_ENABLE_COR', 'Order Form: Enable Fields On COR', '65504', 'Determines which fields are enabled (visible) on the orders COR form.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_FIELD_ENABLE_ORD', 'Order Form: Enable Fields On Form', '65504', 'Determines which fields are enabled (visible) on the orders order form. This also effects client editing forms.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_FIELD_REQUIRE_COR', 'Order Form: Require Fields On COR', '49184', 'Determines which fields are required (visible) on the orders COR form.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_FIELD_REQUIRE_ORD', 'Order Form: Require Fields On Form', '24448', 'Determines which fields are required (visible) on the orders order form. This also effects client editing forms.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDERS_LIST_SHOW_PROD_DESC', 'Order Form: Show Product Description', '1', 'Determines if the Product description will be displayed on Orders Listings instead of the default Vendor / Product Name columns.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_PROD_DISPLAY_SEQUENCE', 'Order Form: Products Display Sequence', '1', 'What to display on the Products List shown to clients when ordering.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_PROD_LIST_SORT_ORDER', 'Order Form: Product List Primary Sort Field', '1', 'Determines which field will be the ascending sort order for the order screen products list.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'I', 'DEFAULT_PAYMENT_METHOD', 'Default Payment Method On Order Form', '0', 'The billing method to use on a new order, or let client select payment method from a drop-down list of vendors. If you specify a vendor here, all modules that normally display the billing vendor will no longer do so.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'R', 'ORDER_SETUP_FEE', 'Orders: Add Order Setup Fee', '0', 'Any amount here other than zero will be added to the price of the product ordered as a setup fee, and the words " (plus setup fee)" will be appended to the item description on the order');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'I', 'ORDERS_PROD_LIST_SIZE', 'Order Form: Product List Size', '1', '0: Products will be displayed as a radio list on the order form\r\nAny non-zero value: phpCOIN will use a select-list with that many rows visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDERS_ITEMS_SUB-LIST', 'Orders: Group Products With Heading', '1', 'YES: If items are displayed on order form by radio list, phpCOIN will "group" the products by the first word in the product display, with that word also used as a group title.  This means you can group products by name, description or price\r\nNO: Do not "group" products');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'clients', 'B', 'ORDER_EDIT_CLIENT', 'Clients: Allow Editing Info On Re-order', '1', 'YES will allow an existing client to edit their contact info when placing a new order. NO will display their contact info without allowing editing');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDER_SHOW_IP', 'Order Form: Show User IP', '1', 'YES: Display the users IP address and a warning about being tracked when placing a new order\r\nNO: Do not display the users IP address and warning about being tracked');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'package', 'S', '_CURRENCY_PREFIX', 'Currency Prefix String (ex. $)', '$', 'The currency notation prefix, placed in front of currency amounts where formatted to display');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'package', 'S', '_CURRENCY_SUFFIX', 'Currency Suffix String (ex. USD)', '(USD)', 'The currency notation suffix, placed following currency amounts where formatted to display');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'package', 'S', '_DB_PKG_LANG', 'Language: Database Setting', 'lang_english', 'Which language files to load, and can  be overridden by config.php setting. The language file directory and files MUST exist prior to selection');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'package', 'S', '_DB_PKG_LOCALE', 'Package Locale: Datetime Display', 'en_EN', 'Some examples:\r\nBulgaria - bg_BG\r\nEnglish  - en_EN (or English)\r\nFrench   - fr_FR\r\nGerman  - German\r\nSwedish  - sv_SE\r\nSpanish  - Spanish');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_DB_PKG_THEME', 'Theme: Database Setting', 'earthtone', 'Which theme files to load, can be overridden by config.php setting. The theme file directory and files MUST exist prior to selection');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'I', '_NUMBER_FORMAT_ID', 'Number Format (see notes)', '3', 'Example number 1234.56\r\nValue = 1	Output: 1234\r\nValue = 2	Output: 1234.56\r\nValue = 3	Output: 1,234.56\r\nValue = 4	Output: 1 234,56\r\nValue = 5	Output: 1.234,56');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_NAME_SHORT', 'Site Name: Short', '%DOMAINNAME%', 'For display of site name (short version). This variable is used extensively in emails and various pages');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_NAME_LONG', 'Site Name: Long', '%DOMAINNAME% WebServices', 'Site long name for display, emails, etc. Basically longer version of the site short name');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'email', 'S', '_PKG_EMAIL_MAIL', 'Email: Default Email', 'support@%DOMAINNAME%', 'Last resort email address used when phpCOIN cannot locate a mail contacts entry');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_TOP_GREETING', 'Site Top Block Greeting Text', 'Welcome To %DOMAINNAME% WebServices', 'The Site Top Block (header) greeting text displayed if logo is not enabled.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'I', '_PKG_DATE_SERVER_OFFSET', 'Date Display: Server Offset In Hours', '0', 'Add or subtract this many hours from server time for the timestamps recorded / displayed');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_DATE_FORMAT_SHORT_DT', 'Date Display: Format For Short Date', 'Y-m-d', 'The display format for the short date, not locale setting dependent. See http://www.php.net/manual/en/function.date.php for formatting options');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_DATE_FORMAT_SHORT_DTTM', 'Date Display: Format For Short DateTime', 'Y-m-d H:i:s', 'The display format for the short datetime, not locale setting dependent. See http://www.php.net/manual/en/function.date.php for formatting options');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_DATE_FORMAT_HEADER', 'Date Display: Format For Header Row', '%A %B %d, %Y', 'The display format for the header block date display. See http://www.php.net/manual/en/function.strftime.php for formatting options');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'S', '_PKG_DATE_FORMAT_PRINT', 'Date Display: Format for Printing', '%A- %B %d, %Y @ %H:%M:%S %Z', 'The display format for the footer printed items date display. See http://www.php.net/manual/en/function.strftime.php for formatting options');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'admin', 'B', '_PKG_ENABLE_IP_BAN', 'Banned IP Addresses: Enable', '1', 'YES: Enables admin to create a list of banned IP addresses that can not view the site. Banned IPs are redirected to error message');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', '_PKG_ENABLE_EMAIL_ARCHIVE', 'Email Archive: Enable', '1', 'YES: Archive ALL emails sent by or through phpCOIN\r\nNO: Archive no emails sent by or through phpCOIN');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'package', 'R', 'PAYLINK_EXCHANGE_RATE', 'Exchange Rate For PayLinks', '0', 'If you show your prices in one currency and collect payment in another, enter the exchange rate here. If you do not use different currencies, leave this as either 1 or 0');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'I', 'USE_LOGIN_MENUBOX', 'Use Login Menu Box', '1', 'LEFT COLUMN: A login/logoff box will be displayed in the left column before any menus, and the logon/logoff button in the header will be disabled.\r\nRIGHT COLUMN: A login/logoff box will be displayed in the right column before any menus, and the logon/logoff button in the header will be disabled\r\nNONE: phpCOIN defaults to normal operation\r\nMake sure that Admin -> Parameters -> Themes -> Disable Menu Columns (Left / Right) is also set to "NO" if left or right column option is chosen');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'pages', 'I', 'IPP_PAGES', 'List: Items Per Page', '15', 'The number of pages that are displayed in listing form on a page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'I', 'CC_DOMAIN_EXP_IN_DAYS', 'Domains Expiring: Days Before Expiry', '30', 'When Domains Expiring Summary is enabled, list domain names that will expire within this many days from today');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'CC_DOMAIN_EXP_LIST_ENABLE', 'Domains Expiring: Enable', '1', 'YES: Display domain names that will expire within X days from today');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'CC_DOMAIN_EXP_LIST_INCL_EXPRD', 'Domains Expiring: Include Expired', '1', 'YES: Include expired domains in Domains Expiring Summary');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'I', 'CC_SACC_EXP_IN_DAYS', 'Server Accounts Expiring: Days Before Expiry', '30', 'When Server Accounts Expiring Summary is enabled, list domain names that will expire within this many days from today');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'CC_SACC_EXP_LIST_ENABLE', 'Server Accounts Expiring: Enable', '1', 'YES: Display a summary of server accounts expiring within x days, or expired');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'CC_SACC_EXP_LIST_INCL_EXPRD', 'Server Accounts Expiring: Include Expired', '1', 'YES: Include expired domains in Server Accounts Expiring Summary.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'CC_SERVER_LIST_ENABLE', 'Servers Summary: Enable', '1', 'Display a list of all your servers, and the number of domains on each server');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'PRODUCT_SUMMARY_ENABLE', 'Active Product Orders: Enable', '1', 'YES: Display a summary of all products that are on an active order.  If "Orders Listing Show Prod. Description" in the "orders" section is set to "Yes", then the description will show on the display, otherwise the product name will be shown.\r\nNO: Do not display');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'SUMMARY_INVOICES_BY_TYPE', 'Invoices By Billing Cycle: Enable', '1', 'YES: Invoices will be listed in columnar format, with the amounts broken out by status and billing cycle\r\nNO: Lump all billing cycles into one column.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'SUMMARY_INVOICES_BY_PRODUCT', 'Invoiced Products: Enable', '1', 'YES: Display a table with the number of times each product appears on an invoice, as well as the total value');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'S', 'SUMMARY_INVOICES_BY_PRODUCT_IGNORE', 'Invoiced Products: Ignore these items', 'NOTE', 'A pipe-separated list of item names on invoices that should be ignored when building the "Invoiced Products Summary"');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'whois', 'R', 'DOMAIN_SETUP_FEE', 'WHOIS: Add Domain Setup Fee', '0', 'Any amount here other than zero will be added to the price of the product ordered as a domain setup fee, and the words " (plus setup fee)" will be appended to the item description on the order IF the whois module "Order" link was clicked.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'whois', 'S', 'WHOIS_AFFILIATE_LINK', 'WHOIS: Registrar Affiliate Link', 'http://www.123-reg.co.uk/affiliate.cgi?id=AF8763', 'If you are an affiliate of a domain registrar and wish to use an affiliate link to register domains, enter the URL of the link here.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'whois', 'B', 'WHOIS_EXT_LIST', 'WHOIS: Show Extensions As DropDown', '1', 'YES: Show allowable domain extensions as a drop-down list\r\nNO: Show the list as radio buttons');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'whois', 'B', 'WHOIS_DETAILS_NEW', 'Show Domain Details In New Window', '1', 'YES: Show details of registered domain in new "popup" window\r\nNO: Use current window');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'whois', 'B', 'WHOIS_INSTRUCTIONS_SHORT', 'WHOIS: Show Short Instructions', '0', 'YES: Show abbreviated domain selection instructions to surfers\r\nNO: Show the long instructions');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'whois', 'B', 'WHOIS_ENABLED', 'WHOIS: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'whois', 'I', 'WHOIS_LINK', 'WHOIS: Domain Registration Operation', '1', '0= Do NOT add an "Order" or "Register" link\r\n1= Add "Order" link and go to "orders" page, passing in domain name and setting "New Domain" to "Yes"\r\n2= Add "Register" link, going to your affiliate link to register the domain. This option will open a new browser window to the registrar, and the original browser window will remain on this page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_01', 'Header Menu Button 01: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_02', 'Header Menu Button 02: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_03', 'Header Menu Button 03: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_04', 'Header Menu Button 04: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_05', 'Header Menu Button 05: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_06', 'Header Menu Button 06: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_07', 'Header Menu Button 07: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_08', 'Header Menu Button 08: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_HDR_MENU_BTTN_09', 'Header Menu Button 09: Enable', '1', 'Determines whether the button appears in the top menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_01', 'Header Menu Button 01: Link', 'index.php', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_02', 'Header Menu Button 02: Link', 'mod.php?mod=siteinfo&id=4', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_03', 'Header Menu Button 03: Link', 'mod.php?mod=articles', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_04', 'Header Menu Button 04: Link', 'mod.php?mod=mail&mode=contact', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_05', 'Header Menu Button 05: Link', 'mod.php?mod=faq', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_06', 'Header Menu Button 06: Link', 'mod.php?mod=helpdesk&mode=new', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_07', 'Header Menu Button 07: Link', 'mod.php?mod=search', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_08', 'Header Menu Button 08: Link', 'mod.php?mod=siteinfo&id=10', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_LINK_09', 'Header Menu Button 09: Link', 'mod.php?mod=orders', 'Determines link (URL) for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_01', 'Header Menu Button 01: Image', '_IMG_MT_HOME_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_02', 'Header Menu Button 02: Image', '_IMG_MT_ABOUT_US_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_03', 'Header Menu Button 03: Image', '_IMG_MT_ARTICLES_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_04', 'Header Menu Button 04: Image', '_IMG_MT_CONTACT_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_05', 'Header Menu Button 05: Image', '_IMG_MT_FAQ_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_06', 'Header Menu Button 06: Image', '_IMG_MT_HELPDESK_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_07', 'Header Menu Button 07: Image', '_IMG_MT_SEARCH_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_08', 'Header Menu Button 08: Image', '_IMG_MT_PLANS_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_HDR_MENU_BTTN_IMG_09', 'Header Menu Button 09: Image', '_IMG_MT_PLACE_ORDER_B', 'Determines image for the corresponding button in main menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_02', 'User Menu Button 02: Enable', '1', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_03', 'User Menu Button 03: Enable', '1', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_04', 'User Menu Button 04: Enable', '1', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_05', 'User Menu Button 05: Enable', '1', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_06', 'User Menu Button 06: Enable', '1', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_07', 'User Menu Button 07: Enable', '0', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'B', '_USR_MENU_BTTN_08', 'User Menu Button 08: Enable', '0', 'Determines whether the button appears in the user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_02', 'User Menu Button 02: Link', 'mod.php?mod=domains', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_03', 'User Menu Button 03: Link', 'mod.php?mod=orders&mode=view', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_04', 'User Menu Button 04: Link', 'mod.php?mod=invoices', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_05', 'User Menu Button 05: Link', 'mod.php?mod=helpdesk&mode=list', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_06', 'User Menu Button 06: Link', 'mod.php?mod=cc', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_07', 'User Menu Button 07: Link', 'index.php', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_LINK_08', 'User Menu Button 08: Link', 'index.php', 'Determines link (URL) for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_02', 'User Menu Button 02: Image', '_IMG_MU_DOMAINS_B', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_03', 'User Menu Button 03: Image', '_IMG_MU_ORDERS_B', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_04', 'User Menu Button 04: Image', '_IMG_MU_INVOICES_B', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_05', 'User Menu Button 05: Image', '_IMG_MU_HELPDESK_B', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_06', 'User Menu Button 06: Image', '_IMG_MU_SUMMARY_B', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_07', 'User Menu Button 07: Image', 'undefined', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'buttons', 'S', '_USR_MENU_BTTN_IMG_08', 'User Menu Button 08: Image', 'undefined', 'Determines image for the corresponding button in user menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_DISABLE_MENU_COLS', 'Menu Columns: Disable', '0', 'YES: Do not display the page left / right menu columns');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_DISABLE_HEADER_BLK', 'Header: Disable Block', '0', 'YES: Hide the page header row');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_DISABLE_FOOTER_BLK', 'Footer: Disable', '0', 'YES: Hide the page footer row');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'admin', 'B', '_ENABLE_ADMIN_LOGIN_LINK', 'Admin Login Link Button Enable', '1', 'YES: An "Admin" login button link is displayed on the client login screen\r\nNO: Button is not displayed. The only way for an admin to login is to manually type the URL to the admin login form');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_ENABLE_BTN_MOUSEOVER', 'Form Button Mouseover: Enable', '1', 'YES: Enable the mouseover action on all form buttons throughout phpCOIN');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_ENABLE_MENU_USER_HDR', 'Header: User Menu Same Block', '1', 'YES: The logged in user / admin menu is visible directly below the main header menu, within the same block');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_ENABLE_MENU_USER_HROW', 'Header: User Menu New Block', '0', 'YES: The logged in user / admin menu is visible directly below the main header menu, as a separate block');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_ENABLE_MENU_USER_FROW', 'Footer: User Menu Row', '0', 'YES: The logged in user / admin menu is visible as an additional row above the footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_PAGE_HEADER_DATE', 'Header: Show Date', '1', 'YES: Display the date in the page header block');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_PAGE_HEADER_LOGO', 'Header: Show Logo', '1', 'YES: Display the site logo in the page header block\r\nNO: Display greeting text in the page header block');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'S', '_PAGE_HEADER_LOGO_FILE', 'Header: Logo Filename', 'logo_phpcoin.png', 'Filename for logo that is located in /images directory for each theme');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_PAGE_HEADER_CLEAR', 'Header: Make Clear', '0', 'YES: The site header row is clear (underlying color)\r\nNO: The site header row is colored (styles)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_PAGE_FOOTER_CLEAR', 'Footer: Make Clear', '1', 'YES: The site footer row is clear (underlying color)\r\nNO: The site footer row is colored (styles)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'B', '_PKG_WRAPPER_ENABLE', 'Package Wrapper: Enable', '0', 'YES: Enable "wrapper" code around phpCOIN for controlling top/left and right/bottom\r\nNO: Use the themes functions for controlling top/left and right/bottom');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'S', '_WIDTH_OUTER_TABLE', 'Table: Width Of Outmost Table', '75%', 'The width of the outermost table. Must include either percent or pixel signs, % or px');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'I', '_WIDTH_COL_BLOCK', 'Menu Columns: Percentage Width', '15', 'The percentage width for each left / right menu column,  without the % sign');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'I', '_WIDTH_MENU_BLOCK', 'Menu Columns: Block Pixel Width', '150', 'The pixel width setting for a menu block displayed within a left-right menu column, without the px sign');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'S', '_WIDTH_CONTENT_AREA', 'Table: Percentage Width Of Non-Module Area', '100%', 'The percentage width of the content area that non-modules output will consume, including % sign');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'S', '_WIDTH_MODULE_AREA', 'Table: Percentage Width Of Module Area', '100%', 'The percentage width of the content area that modules output will consume, with % sign');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'theme', 'package', 'I', '_WIDTH_PRINT_AREA', 'Table: Pixel Width For Printing', '700', 'The pixel width of the outermost table when being printed, excluding px sign');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_01_NAME', 'Company Info 01: Name', 'A phpCOIN User', 'Company name that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_02_ADDR_01', 'Company Info 02: Address Line 01', '', 'Street address that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_03_ADDR_02', 'Company Info 03: Address Line 02', '', 'Secondary address line or suite number that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_04_CITY', 'Company Info 04: City', '', 'City that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_05_STATE_PROV', 'Company Info 05: State/Prov', '', 'State or Province that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_06_POSTAL_CODE', 'Company Info 06: Postal Code', '', 'Zip or Postal code that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_07_COUNTRY', 'Company Info 07: Country', '', 'Country that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_08_PHONE', 'Company Info 08: Phone No.', '', 'Phone number, if you have one, that you want to appear on invoices and on the "Contact US" page and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_09_FAX', 'Company Info 09: FAX', '', 'Fax number, if you have one, that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_10_TAXNO', 'Company Info 10: Tax Number', '', 'If you charge taxes and require that your tax registration number appear on invoices, etc., enter it here');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_11_TOLL_FREE', 'Company Info 11: Toll Free Number', '', 'A toll-free number, if you have one, that you want to appear on invoices, and on the "Contact Us" page if address display enabled, and on the website footer if the theme enables a site-owner footer');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'S', 'CO_INFO_12_TAGLINE', 'Company Info 12: TagLine', 'A Clever TagLine Here', 'Text of a "tagline" that will appear on invoices, and in the site footer if the theme used supports it');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'B', 'DISPLAY_ON_CONTACT_FORM', 'Display On Contact Form', '1', 'YES: The Company Information in this section will be displayed on the "Contact Us" form,as well as used on invoices\r\nNO: The "Contact Us" form will be an email-only form.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'user', 'package', 'B', 'DISPLAY_ON_FOOTER', 'Display On Output Footer', '1', 'YES: The Company Information in this section will be displayed in the footer of every page output by phpCOIN if the theme used supports it.  The built-in themes all support this');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'downloads', 'B', 'LIMIT_DOWNLOADS_TO_LOGGED_IN', 'Downloads for logged-in users only', '0', 'YES: A user must be logged-in in order to access the downloads page\r\nNO: Anyone can access the downloads page.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'downloads', 'B', 'HIDE_NOAVAILS', 'Show Available Downloads Only', '1', 'YES: phpCOIN will display only those downloads marked "available"\r\nNO: phpCOIN will display all downloads in the database, but only available downloads will be clickable');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'downloads', 'S', 'DLOAD_URL', 'Downloads Root URL', 'http://%DOMAINNAME%/coin_downloads/', 'Root URL where downloads are located. The http:// prefix and the trailing slash can be eliminated ~ phpCOIN will auto-append them if necessary.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'ipn', 'I', 'IPN_NUM_DISPLAY', 'List: Items Per Page', '25', 'Number of IPN Log items to display per page in listings');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'IPN_SEND_TRANS_ACK', 'IPN: Send Transaction Ack Email', '1', 'YES: Send a trans ack email when payment is received\r\nNO: Do not send a trans ack email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'IPN_PROCESS_INCOMING', 'IPN: Process Incoming Data', '1', 'If we accept data, do we want to process it also?');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'S', 'PAYPAL_RECEIVER_EMAIL', 'Paypal: Primary Email Address', 'purchasing@coinsofttechnologies.ca', 'This is your PayPal Primary Email Address.  Incoming transactions will have this recipient address, to ensure that the transaction was meant for you.  You can have multiple email addresses here separated by spaces, for example:\r\njon@paypal.com john@paypal.com');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'IPN_SEARCH_NAME', 'IPN: Select Invoice By Name', '1', 'YES: If there is no invoice number or email address match, then use the first and last name of the payer to determine the invoice\r\nNO: Use only the supplied invoice number or email address to determine which invoice to pay');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'ipn', 'B', 'IPN_ACCEPT_INCOMING', 'IPN: Enable', '1', 'YES: Module is enabled and ready for accept and apply payment notifications\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, no output from this module will be visible, and no payment notifications will be accepted and applied');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'I', 'IPN_INVOICE_FIND_METHOD', 'IPN: Invoice Find Method', '4', 'If no invoice number is sent with an incoming transaction, this is how ipn determines which invoice to apply the payment to:\r\n0: Highest invoice number, regardless of status\r\n1: Highest invoice number that does not have status PAID\r\n2: Highest invoice number that does not have status PAID, if none found, then return highest invoice num\r\n3: Lowest invoice number that does not have status PAID\r\n4: Lowest invoice number that does not have status PAID, IF none found, then return highest invoice number');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'IPN_ALLOW_RESUBMIT', 'IPN: Allow Transaction Resubmit', '1', 'Allows you to simulate the transaction being run again.  Doing this will NOT reverse any payments posted, status changes, etc.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'IPN_ALLOW_DELETE', 'IPN: Allow Transaction Delete', '1', 'Allow IPN transactions to be deleted from the LOG');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'IPN_REQUIRE_AMOUNT_MATCH', 'IPN: Received Amount Must Match Invoice', '0', 'YES: Amount received must match the invoice amount for the payment to be successful\r\nNO: Amount received can be for any amount ~ useful if you receive partial payments');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', 'PAYPAL_WRITEDEBUG', 'PayPal: Enable Text Log', '0', 'Create a text file to log IPN connection attempts to and from PayPal.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'S', 'PAYPAL_DEBUGFILE', 'PayPal: Name of Text Log', 'c:/temp/paypal_ipn_%TIMESTAMP%.log', 'Name of text file to log IPN connection attempts to and from PayPal (Use &#37;TIMESTAMP% to have current timestamp appended)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'S', 'PAYPAL_SBEMAIL', 'PayPal: SandBox Seller Email', 'paypal_111111111_biz@yourdomain.com', 'Sandbox email address of seller, for testing IPN with PayPal');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'INCOMING_EMAIL_AS_HTML', 'HTML Email: Enable HTML Incoming', '0', 'YES: "Contact us" form will send you html email\r\nNO: "Contact Us" form allows plain-text only');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'todo', 'I', 'IPP_TODO', 'List: Items Per Page', '25', 'The number of ToDo items that are displayed in listing form on a page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'email', 'B', 'ENABLE_SUPPORT_ON_CONTACT', 'Mail Contacts: Show Support On Contact Form', '1', 'YES: "Support" will be a choice for users on the "Contact Us" form\r\nNO: "Support" will not be an option on the contact form. Useful if you want to enforce that support requests originate via helpdesk rather than a "contact Us" email to support');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'NO_NAG_ON_CREDIT', 'Invoice Reminders: No Nag If Credit Balance', '1', 'YES: A client will not be nagged about an unpaid invoice if their account has a cedit balance\r\nNO: A client will be nagged about an overdue invoice regardless of their account balance');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SHOW_EMPTY_INVC_STATUS', 'Invoices By Billing Cycle: Show Unused Status', '0', 'YES: The invoice columnar listing will show a row for each invoice status, whether any invoices have that status or not.\r\nNO: Only statuses that are used on an invoice will be shown');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SHOW_EMPTY_INVC_CYCLE', 'Invoices By Billing Cycle: Show Unused Cycle', '0', 'YES: The invoice columnar listing will show a column for each invoice cycle, whether any invoices use that cycle or not.\r\nNO: Only cycles that are used on an invoice will be shown');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SHOW_INVC_ZERO_TOTAL', 'Invoices By Billing Cycle: $0.00 Totals', '1', 'YES: Zero value billing cycle totals will display as $0.00\r\nNO: Zero value billing cycle totals will display as a blank space');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'B', 'PAYPAL_AUTO_VERBOSE', 'PayPal Emails: Verbose', '0', 'YES: phpCOIN will display the results of processing of each email message\r\nNO: phpCOIN will only display aggregate results');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'B', 'PAYPAL_AUTO_IMPORT_ENABLE', 'PayPal Emails: Enable', '1', 'YES: The paypal cronjob will connect to a POP or IMAP box and attempt to create invoice payments from any emails found\r\nNO: (obvious)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_SERVER', 'PayPal Emails: Server', 'mail.%DOMAINNAME%', 'Name of the email server the helpdesk cronjob should connect to');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_TYPE', 'PayPal Emails: Protocol', ':143/imap/notls', 'Protocol and port that the paypal cronjob should connect to\r\n"/imap:143" seems to work better than "/pop:110"\r\nYou may also need to try /IMAP/:143/notls or /:110/POP/notls or even other strings, depending on your mailserver');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_USERID', 'PayPal Emails: UserName', 'sales@%DOMAINNAME%', 'The email username that the paypal cronjob will check');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_PASSWORD', 'PayPal Emails: Password', 'password', 'Password for the email account that will be checked by the paypal cronjob');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'I', 'PAYPAL_AUTO_IMPORT_DELETE_MESSAGES', 'PayPal Emails: Delete Messages', '1', 'Delete _these_ messages on the mail-server when the paypal cronjob runs');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_PARTIAL_SUBJECT', 'PayPal Emails: Partial Subject String', 'Notification of Payment Received', 'Emails from PayPal will include this text in the subject line');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_INVOICE_ID', 'PayPal Emails: Invoice ID String', 'Invoice ID', 'Emails from PayPal will include this text in the Invoice ID line');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_TRANS_ID', 'PayPal Emails: Transaction ID String', 'Transaction ID', 'Emails from PayPal will include this text in the Transaction ID line');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'ipn', 'S', 'PAYPAL_AUTO_TOTAL_AMT', 'PayPal Emails: Total Amount String', 'Total Amount', 'Emails from PayPal will include this text in the Total Amount line');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'clients', 'B', 'CLIENT_NOTES_VISIBLE', 'Notes: Visible To Clients', '0', 'YES: Client can view admin-entered client notes\r\nNO: Client cannot see admin-entered client notes');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'INVC_ACOPY_NEW_TERMS', 'Invoice AutoCopy: Insert New Terms', '1', 'YES: phpCOIN will replace the existing terms on auto-copied invoices with whatever the current terms are in lang_config.php\r\nNO: phpCOIN will copy any existing terms on the invoice as-is');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'I', 'TAX_DISPLAY_DIGITS_PERCENT', 'Display Digits: Tax Percent', '3', 'How many digits after the decimal place should we display for the tax percentages?');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'I', 'TAX_DISPLAY_DIGITS_AMOUNT', 'Display Digits: Tax Amount', '2', 'How many digits after the decimal place should we display for the tax amounts?');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'package', 'I', 'CURRENCY_DISPLAY_DIGITS_AMOUNT', 'Display Digits: Currency Amounts', '2', 'How many digits after the decimal place should we display for currency (non-tax) amounts?');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDERS_TOS_IN_IFRAME', 'Display TOS in Iframe', '1', 'YES: Show the TOS in an iframe on the orders page, underneath the "Accept TOS" checkbox\r\nNO: Display a "Display TOS" hyperlink on the orders page, after the "Accept TOS" checkbox');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'orders', 'B', 'ORDERS_AUP_IN_IFRAME', 'Display AUP in Iframe', '1', 'YES: Show the AUP in an iframe on the orders page, underneath the "Accept AUP" checkbox\r\nNO: Display a "Display AUP" hyperlink on the orders page, after the "Accept AUP" checkbox');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'I', 'SUMMARY_PRODUCTS_ORDER_BY', 'Active Product Orders: Sort Order', '1', 'The sort order for active product orders:\r\n1: Alphabetical by product name or description\r\n2: Reverse alphabetical by product name or description\r\n3: Number of products sold, low to high\r\n4: Number of products sold, high to low\r\n5: Value of products sold, low to high\r\n6: Value of products sold, high to low');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'suppliers', 'B', 'SUPPLIERS_ENABLE', 'Suppliers: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'suppliers', 'I', 'BASE_SUPPLIER_ID', 'Supplier ID Base-Initial Value Minus 1', '1000', 'The id for the first supplier entered in the system. Supplier ID will be this value plus one');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'suppliers', 'I', 'IPP_SUPPLIERS', 'List: Items Per Page', '25', 'The number of suppliers that are displayed on a page in listing form');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'suppliers', 'I', 'IPL_SUPPLIERS', 'List: Items Per Summary', '5', 'The number of most recent items (bills and email archive messages) that are displayed on a supplier account page');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'bills', 'B', 'BILL_ACOPY_DELAY_ENABLE', 'Bill Auto-Copy: Delay', '1', 'Determines if the auto-copy of recurring bills is delayed until new bill date is within days out setting.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'bills', 'I', 'BILL_ACOPY_DAYS_OUT', 'Bill Auto-Copy: Days Out to Copy', '15', 'Determines number of days from current date to auto-copy a recurring bill. Will auto-copy if the new bill date falls within this date range.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'bills', 'B', 'BILL_AUTO_UPDATE_ENABLE', 'Bill Auto Copy: Auto-Update Status', '1', 'Determines if the auto-update of bill status function is enabled when triggered by cron job or manually by command summary actions menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'bills', 'B', 'BILL_AUTO_COPY_ENABLE', 'Bill Auto-Copy: Enable', '1', 'Determines if the auto-copy of recurring bills function is enabled when triggered by cron job or manually by command summary actions menu.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'bills', 'I', 'BILL_DUE_DAYS_OFFSET', 'Bill Due Date: x Days After Create', '10', 'When a bill is created, phpCOIN will add this many days to the create date in order to auto-calc the due date');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'bills', 'B', 'BILL_TAX_01_ENABLE', 'Bill Taxes: Tax 01 Enable', '1', 'YES: Tax 1 will be calculated and displayed.\r\nNO: Tax 1 will NOT be calculated and displayed');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'bills', 'B', 'BILL_TAX_02_ENABLE', 'Bill Taxes: Tax 02 Enable', '1', 'YES: Tax 2 will be calculated and displayed.\r\nNO: Tax 2 will NOT be calculated and displayed');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'bills', 'B', 'BILL_SPLIT_TRANS_LIST_ENABLE', 'Bill Transaction Listing:  Enable Split Listing', '0', 'YES: The bill transaction listing is split to list charges on top, and then credits below in a separate list\r\nNO: bill transactions appear in a single section one after the other, like a standard statement');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'bills', 'S', 'BILL_TAX_01_LABEL', 'Bill Taxes: Tax 01 Label', '13% HST:', 'The text label displayed on bills in place of "Tax 01"');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'bills', 'S', 'BILL_TAX_02_LABEL', 'Bill Taxes: Tax 02 Label', '5% PST:', 'The text label displayed on bills in place of "Tax 02"');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'bills', 'I', 'BILL_VIEW_SHOW_TRANS', 'Bill Transaction Listing: Show Transactions', '3', 'If the transactions listing is displayed on lower portion of bill:\r\n0: No transactions displayed\r\n1: Transactions displayed on-screen only\r\n2: Transactions displayed on printed output only\r\n3: Transactions appear on both screen and printed output');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'bills', 'B', 'BILLS_ENABLE', 'Bills: Enable', '1', 'YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'bills', 'R', 'BILL_TAX_01_DEF_VAL', 'Bill Taxes: Tax 01 Default Rate', '13.00', 'The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'bills', 'R', 'BILL_TAX_02_DEF_VAL', 'Bill Taxes: Tax 02 Default Rate', '5.00', 'The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'bills', 'I', 'BASE_BILL_ID', 'Bills: Initial Value', '1000', 'Starting point for the first bill entered in the system. Bill ID will be this value plus one.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'SUMMARY_BILLS_BY_PRODUCT', 'Expenses: Enable', '1', 'YES: Display a table with the number of times each expense appears on a bill, as well as the total value');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'S', 'SUMMARY_BILLS_BY_PRODUCT_IGNORE', 'Expenses: Ignore these items', '', 'A pipe-separated list of item codes on bills that should be ignored when building the billed expenses summary.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'bills', 'B', 'BILL_TAX_BY_ITEM', 'Bill Taxes: Tax By Item', '1', 'YES: Taxes will be calculated on each item individually\r\nNO: Taxes will be calculated only on the invoice totals');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'bills', 'I', 'IPP_BILLS', 'List: Items Per Page', '25', 'The number of bills that are displayed in listing form on a page.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'bills', 'B', 'BILL_PRICES_INCLUDE_TAXES', 'Bill Taxes: Prices Include Taxes', '0', 'NO: phpCOIN will add applicable taxes to items on bills\r\nYES: phpCOIN assumes that the prices include tax. In this event, taxes will be removed from the items and then recalculated, so the bill can show the amount of taxes included in the prices.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'B', '2CHECKOUT_WRITEDEBUG', '2Checkout: Enable Text Log', '0', 'Create a text file to log IPN connection attempts to and from 2Checkout.');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'S', '2CHECKOUT_DEBUGFILE', '2Checkout: Name of Text Log', 'c:/temp/2co_ipn_%TIMESTAMP%.log', 'Name of text file to log IPN connection attempts to and from 2Checkout (Use &#37;TIMESTAMP%to have current timestamp appended)');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'S', '2CHECKOUT_SECRET_WORD', '2Checkout: INS Secret Word', 'SECRET', 'Incoming INS transactions will have this secret word as part of the MD5 hash, to help assure that the data is from 2Checkout');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'ipn', 'S', '2CHECKOUT_VENDOR_ID', '2Checkout: Vendor ID', '1234567', 'Incoming transactions will include your 2co vendor ID, to ensure that the transaction was meant for you');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'S', 'SUMMARY_INVOICES_BY_PRODUCT_STATUS_IGNORE', 'Invoiced Products: Ignore these status', '1|4|5', 'A pipe-separated list of invoice statuses that should be ignored when building the invoiced products summary. This list MUST be the $_CCFG[''INV_STATUS''][] array element number, NOT the text of the status');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SUMMARY_THIS_YEAR', 'Summary: Current Year Only', '1', 'YES: Display data on Summary page for this year only\r\nNO: Display data on Summary page for all dates in database');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'S', 'SUMMARY_EXPENSES_STATUS_IGNORE', 'Expenses: Ignore these status', '1|4|5', 'A pipe-separated list of bill statuses that should be ignored when building the billed expenses summary. This list MUST be the $_CCFG[''BILL_STATUS''][] array element number, NOT the text of the status');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'orders', 'B', 'ENABLE_AUTOPASS_ORDERS', 'Orders: AutoPassword Enable', '1', 'YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'clients', 'B', 'ENABLE_AUTOPASS_CLIENTS', 'Clients: AutoPassword Enable', '1', 'YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'domains', 'B', 'ENABLE_AUTOPASS_DOMAINS', 'Domains: AutoPassword Enable', '1', 'YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'clients', 'B', 'AUTOPASSWORD_STRENGTH', 'Clients: Strongest Auto-Password', '1', 'YES: An auto-generated password will utilize the full alphanumeric character set and symbols, in the ASCII range 33 to 126\r\nNO: An auto-generated password will utilize only lowercase letters');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'B', 'SKIP_CONFIRM_SCREEN', 'Skip Order Confirmation Page', '0', 'YES: Skip the confirmation screen and send the client straight to paylink\r\nNO: Display the order confirmation page so a client can change order info before processing');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'B', 'Company_In_Select', 'Client List: Select by Company Name', '1', 'When adding or editing an invoice, the "client" drop-down will be:\r\nYES: CompanyName - LastName, FirstName\r\nNO: LastName, FirstName - UserName');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'client_can_resend', 'Email Archive: Client Can Resend Messages', '1', 'YES: On archived email listings, client will have an ''email'' icon to allow the client to re-send any previous message\r\nNO: On archived email listings, client will not have an ''email'' icon to allow the client to re-send any previous message');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'no_cc_on_resend', 'Email Archive: Resend To CC and BCC', '0', 'YES: When an archived email message is resent, any CC or BCC recipients on the original message WILL receive a copy of the message again\r\nNO: When an archived email message is resent, any CC or BCC recipients on the original message will NOT receive a copy of the message again');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'show_archive_to_clients', 'Email Archive: Show To Client', '1', 'YES: When a client views their "My Account" summary page, they will also see a section showing every email that was sent to them if "Email Archive: Enable" is enabled. Client can view/print any message, and re-send a message if "Email Archive: Client Can Resend Messages" is enabled\r\nNO: When a client views their "My Account" summary page, they will NOT see a section showing every email that was sent to them');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'CONTACT_FORM_CC', 'Contact Form CC: Enable', '0', 'No: Do NOT send a CC of the messge entered on the "Contact us" form to the sender\r\nYes: DO send a CC of the messge entered on the "Contact us" form to the sender');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'cronjobs', 'invoices', 'B', 'AUTOCOPY_UNPAID', 'Invoices: Auto-Recur Unpaid', '1', 'Yes: When it is time to auto-recur an invoice, copy it whether it is paid or not\r\nNo: Ony auto-recur an invoice if it was paid');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SHOW_EMPTY_BILL_STATUS', 'Bills By Billing Cycle: Show Unused Status', '0', 'YES: The bill columnar listing will show a row for each bill status, whether any bills have that status or not.\r\nNO: Only statuses that are used on a bill will be shown');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SHOW_EMPTY_BILL_CYCLE', 'Bills By Billing Cycle: Show Unused Cycle', '0', 'YES: The bill columnar listing will show a column for each bill cycle, whether any bills have that cycle or not.\r\nNO: Only cycles that are used on a bill will be shown');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SHOW_BILL_ZERO_TOTAL', 'Bills By Billing Cycle: $0.00 Totals', '1', 'YES: Zero value billing cycle totals will display as $0.00\r\nNO: Zero value billing cycle totals will display as a blank space');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'summary', 'B', 'SUMMARY_BILLS_BY_TYPE', 'Bills By Billing Cycle: Enable', '1', 'YES: Bills will be listed in columnar format, with the amounts broken out by status and billing cycle\r\nNO: Lump all billing cycles into one column.');
DROP TABLE IF EXISTS `%PREFIX%products`;
CREATE TABLE `%PREFIX%products` (`prod_id` smallint(6) NOT NULL auto_increment, `prod_status` tinyint(1) NOT NULL default '1', `prod_name` varchar(20) NOT NULL default '', `prod_desc` text NOT NULL default '', `prod_unit_cost` double NOT NULL default '0', `prod_client_scope` int(11) NOT NULL default '0', `prod_apply_tax_01` tinyint(1) NOT NULL default '1', `prod_apply_tax_02` tinyint(1) NOT NULL default '1', `prod_calc_tax_02_pb` tinyint(1) NOT NULL default '0', `prod_dom_type` tinyint(2) NOT NULL default '0', `prod_allow_domains` smallint(6) NOT NULL default '0', `prod_allow_subdomains` smallint(6) NOT NULL default '0', `prod_allow_disk_space_mb` int(11) NOT NULL default '0', `prod_allow_traffic_mb` int(11) NOT NULL default '0', `prod_allow_mailboxes` smallint(6) NOT NULL default '0', `prod_allow_databases` smallint(6) NOT NULL default '0', `prod_cg_01` tinyint(1) NOT NULL default '0', `prod_cg_02` tinyint(1) NOT NULL default '0', `prod_cg_03` tinyint(1) NOT NULL default '0', `prod_cg_04` tinyint(1) NOT NULL default '0', `prod_cg_05` tinyint(1) NOT NULL default '0', `prod_cg_06` tinyint(1) NOT NULL default '0', `prod_cg_07` tinyint(1) NOT NULL default '0', `prod_cg_08` tinyint(1) NOT NULL default '0', PRIMARY KEY  (`prod_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Products Table';
INSERT INTO `%PREFIX%products` (`prod_id`, `prod_status`, `prod_name`, `prod_desc`, `prod_unit_cost`, `prod_client_scope`, `prod_apply_tax_01`, `prod_apply_tax_02`, `prod_calc_tax_02_pb`, `prod_dom_type`, `prod_allow_domains`, `prod_allow_subdomains`, `prod_allow_disk_space_mb`, `prod_allow_traffic_mb`, `prod_allow_mailboxes`, `prod_allow_databases`, `prod_cg_01`, `prod_cg_02`, `prod_cg_03`, `prod_cg_04`, `prod_cg_05`, `prod_cg_06`, `prod_cg_07`, `prod_cg_08`) VALUES(1, 1, 'ID-0001', 'Sample Hosting Product 01', 19.95, 0, 1, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
INSERT INTO `%PREFIX%products` (`prod_id`, `prod_status`, `prod_name`, `prod_desc`, `prod_unit_cost`, `prod_client_scope`, `prod_apply_tax_01`, `prod_apply_tax_02`, `prod_calc_tax_02_pb`, `prod_dom_type`, `prod_allow_domains`, `prod_allow_subdomains`, `prod_allow_disk_space_mb`, `prod_allow_traffic_mb`, `prod_allow_mailboxes`, `prod_allow_databases`, `prod_cg_01`, `prod_cg_02`, `prod_cg_03`, `prod_cg_04`, `prod_cg_05`, `prod_cg_06`, `prod_cg_07`, `prod_cg_08`) VALUES(2, 1, 'ID-0002', 'Sample Non-Hosting Product 02', 29.95, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
DROP TABLE IF EXISTS `%PREFIX%reminders`;
CREATE TABLE `%PREFIX%reminders` (`overdue_id` int(11) NOT NULL auto_increment, `overdue_title` varchar(50) NOT NULL default '', `overdue_active` char(1) NOT NULL default '1', `overdue_days` tinyint(4) NOT NULL default '10', `overdue_subject` varchar(150) NOT NULL default '', `overdue_template` text NOT NULL, `overdue_cc_support` tinyint(1) NOT NULL default '0', UNIQUE KEY `overdue_id` (`overdue_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `%PREFIX%reminders` (`overdue_id`, `overdue_title`, `overdue_active`, `overdue_days`, `overdue_subject`, `overdue_template`, `overdue_cc_support`) VALUES(5, 'Soon Due', '1', 0, 'Account Soon Due', 'Hello $_MTP[to_name];\r\n\r\nThis email is an automated reminder that your account recently had an invoice issued that will soon be due, with an outstanding account balance of $_MTP[cl_balance].  You may check the status of your account by clicking on the following link (requires login):\r\n$_MTP[invc_url]\r\n\r\n.  If you have already made payment arrangements, we thank you for your diligence and apologize for this automated reminder.\r\n\r\nThank you for continuing to choose $_MTP[Company_Name] for your web service needs.\r\n\r\nRespectfully Yours,\r\nBilling Department\r\n$_MTP[Company_Name]', 1);
INSERT INTO `%PREFIX%reminders` (`overdue_id`, `overdue_title`, `overdue_active`, `overdue_days`, `overdue_subject`, `overdue_template`, `overdue_cc_support`) VALUES(1, '10 Days Overdue', '1', 10, 'Account Overdue', 'Hello $_MTP[to_name];\r\n\r\nWe realize that everyone gets busy and occasionally overlooks things.  Unfortunately, we appear to have been overlooked this time.\r\n\r\nThis email is an automated notification that your account is now ten days overdue, with an outstanding balance of $_MTP[cl_balance].  You may check the status of your account by clicking on the following link (requires login):\r\n$_MTP[invc_url]\r\n\r\nWe ask that you take action to bring your account up-to-date, as specified in our <a href="$_MTP[_PKG_URL_BASE]/mod.php?mod=siteinfo&id=7" target="_new">Terms Of Service</a> page.  If you have already made payment arrangements, we thank you for your diligence and apologize for this automated reminder.\r\n\r\nThank you for continuing to choose $_MTP[Company_Name] for your web service needs.\r\n\r\nRespectfully Yours,\r\nBilling Department\r\n$_MTP[Company_Name]', 1);
INSERT INTO `%PREFIX%reminders` (`overdue_id`, `overdue_title`, `overdue_active`, `overdue_days`, `overdue_subject`, `overdue_template`, `overdue_cc_support`) VALUES(2, '20 Days Overdue', '1', 20, 'Account Seriously Overdue', 'Hello $_MTP[to_name];\r\n\r\nThis email is an automated notification that your account is now twenty days overdue, with an outstanding balance of $_MTP[cl_balance].  You may check the status of your account by clicking on the following link (requires login):\r\n$_MTP[invc_url]\r\n\r\nWe ask that you take immediate action to bring your account up-to-date, as specified in our <a href="$_MTP[_PKG_URL_BASE]/mod.php?mod=siteinfo&id=7" target="_new">Terms Of Service</a> page.  Failure to do so may result in additional collection steps and/or costs.  If you have already made payment arrangements, we thank you and apologize for this automated reminder.\r\n\r\nThank you for continuing to choose $_MTP[Company_Name] for your web service needs.\r\n\r\nRespectfully Yours,\r\nCollection Department\r\n$_MTP[Company_Name]', 1);
INSERT INTO `%PREFIX%reminders` (`overdue_id`, `overdue_title`, `overdue_active`, `overdue_days`, `overdue_subject`, `overdue_template`, `overdue_cc_support`) VALUES(3, '30 Days Overdue', '1', 30, 'Account Suspended', 'Hello $_MTP[to_name];\r\n\r\nThis email is an automated notification that your account is now thirty days overdue, with an outstanding balance of $_MTP[cl_balance].  You may check the status of your account by clicking on the following link (requires login):\r\n$_MTP[invc_url]\r\n\r\nThis is a very serious situation, and your account has been suspended.  To have your account re-instated, you must pay your outstanding balance in full plus a re-instatement fee of $20, as specified in our <a href="$_MTP[_PKG_URL_BASE]/mod.php?mod=siteinfo&id=7" target="_new">Terms Of Service</a> page.  Failure to pay everything owed within the next 15 days WILL result in ALL of your website, database and email files being deleted FOREVER.\r\n\r\nIf you have already made payment arrangements, we thank you and apologize for this automated reminder.\r\n\r\n\r\nRespectfully Yours,\r\nCollection Manager\r\n$_MTP[Company_Name]', 1);
INSERT INTO `%PREFIX%reminders` (`overdue_id`, `overdue_title`, `overdue_active`, `overdue_days`, `overdue_subject`, `overdue_template`, `overdue_cc_support`) VALUES(4, '1 Day Overdue', '1', 1, 'A Gentle Reminder', 'Hello $_MTP[to_name];\r\n\r\nWe realize that everyone gets busy and occasionally overlooks things.  Unfortunately, we appear to have been overlooked this time.\r\n\r\nThis email is an automated notification that your account is now overdue, with an outstanding balance of $_MTP[cl_balance].  You may check the status of your account by clicking on the following link (requires login):\r\n$_MTP[invc_url]\r\n\r\nWe ask that you take action to bring your account up-to-date, as specified in our <a href="$_MTP[_PKG_URL_BASE]/mod.php?mod=siteinfo&id=7" target="_new">Terms Of Service</a> page.  If you have already made payment arrangements, we thank you for your diligence and apologize for this automated reminder.\r\n\r\nThank you for continuing to choose $_MTP[Company_Name] for your web service needs.\r\n\r\nRespectfully Yours,\r\nBilling Department\r\n$_MTP[Company_Name]', 1);
DROP TABLE IF EXISTS `%PREFIX%server_info`;
CREATE TABLE `%PREFIX%server_info` (`si_id` smallint(6) NOT NULL auto_increment, `si_name` varchar(20) NOT NULL default '', `si_ip` varchar(15) NOT NULL default '000.000.000.000', `si_ns_01` varchar(50) NOT NULL default '', `si_ns_01_ip` varchar(15) NOT NULL default '000.000.000.000', `si_ns_02` varchar(50) NOT NULL default '', `si_ns_02_ip` varchar(15) NOT NULL default '000.000.000.000', `si_cp_url` varchar(50) NOT NULL default '', `si_cp_url_port` int(11) NOT NULL default '0', PRIMARY KEY  (`si_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Server Info Table';
INSERT INTO `%PREFIX%server_info` (`si_id`, `si_name`, `si_ip`, `si_ns_01`, `si_ns_01_ip`, `si_ns_02`, `si_ns_02_ip`, `si_cp_url`, `si_cp_url_port`) VALUES(1, 'Alpha', '216.118.66.244', 'NS1.NAMESERVER.COM', '000.000.000.000', 'NS2.NAMESERVER.COM', '000.000.000.000', 'https://www.server.com:8443/login.php3', 8443);
INSERT INTO `%PREFIX%server_info` (`si_id`, `si_name`, `si_ip`, `si_ns_01`, `si_ns_01_ip`, `si_ns_02`, `si_ns_02_ip`, `si_cp_url`, `si_cp_url_port`) VALUES(2, 'Beta', '216.118.66.245', 'NS1.NAMESERVER.COM', '000.000.000.000', 'NS2.NAMESERVER.COM', '000.000.000.000', 'https://www.server.com:8443/login.php3', 8443);
DROP TABLE IF EXISTS `%PREFIX%sessions`;
CREATE TABLE `%PREFIX%sessions` (`s_id` varchar(36) NOT NULL default '', `s_time_init` int(11) NOT NULL default '0', `s_time_last` int(11) NOT NULL default '0', `s_ip` varchar(16) NOT NULL default '000.000.000.000', `s_is_admin` tinyint(1) NOT NULL default '0', `s_is_user` tinyint(1) NOT NULL default '0', `s_time_last_contact` int(11) NOT NULL default '0', `s_time_last_order` int(11) NOT NULL default '0', PRIMARY KEY  (`s_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Sessions Table';
INSERT INTO `%PREFIX%sessions` (`s_id`, `s_time_init`, `s_time_last`, `s_ip`, `s_is_admin`, `s_is_user`, `s_time_last_contact`, `s_time_last_order`) VALUES('', 1235149924, 1235149924, '192.168.0.50', 0, 0, 0, 0);
DROP TABLE IF EXISTS `%PREFIX%site_info`;
CREATE TABLE `%PREFIX%site_info` (`si_id` int(11) NOT NULL auto_increment, `si_group` varchar(32) NOT NULL, `si_name` varchar(32) NOT NULL, `si_seq_no` int(11) NOT NULL, `si_desc` varchar(50) NOT NULL, `si_block_it` tinyint(1) NOT NULL default '0', `si_title` varchar(50) NOT NULL, `si_code` longtext, `si_status` tinyint(1) NOT NULL default '0', `si_footer_menu` tinyint(1) NOT NULL default '1', PRIMARY KEY  (`si_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site SiteInfo Table';
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(1, 'site', 'index', 0, 'Index Block HTML code.', 1, 'Welcome', '<p><img src="coin_images/phpcoin_box.gif" border="0" hspace="5" vspace="3" align="right" />Welcome to your phpCOIN install at $_CCFG[_PKG_NAME_SHORT]. Installation is now complete, but there are still some things you need to configure before you can fully utilize phpCOIN:</p> <ul> <li>Your administrator username is <span style="font-weight: bold; color: red">webmaster</span></li> <li>Your password is your <span style="font-weight: bold; color: red">database password</span></li> <li>Read the online manual at <a href="http://docs.phpcoin.com/">http://docs.phpCOIN.com</a> for help with configuration and operations</li> <li>If you still have any questions, consult the support forums at <a href="http://forums.phpCOIN.com/">http://forums.phpCOIN.com</a></li> <li>You <em>should</em> login and change the text of this page immediately.</li> </ul> <p>The Cost:</p> <ul> <li>phpCOIN version 1.x is 100% <em>free</em> of cost to install and use</li> <li>A <a href="http://www.phpcoin.com/mod.php?mod=siteinfo&id=10">donation</a> to help cover development and support expenses would be appreciated, but is <em>not</em> required</li> <li>You are <em>not</em> allowed to remove the "Powered by phpCOIN" link unless you have <a href="http://www.phpcoin.com/mod.php?mod=orders">purchased a license</a> to do so.</li> </ul> <p>Support Options:</p> <ul> <li>Support via the phpCOIN <a href="http://forums.phpcoin.com/">support forums</a> or the <a href="http://docs.phpcoin.com/">online manual</a> is <em>free</em></li> <li>Support via email <em>will</em> be billed at $50 per question. If your question was already answered in the support forums or in the online manual, the fee will increase to $100 per question so <em>please</em> check the manual and forums <em>first</em>. Please include your credit card information or your email/fax <em>will</em> be ignored</li> <li>At the present time support via telephone and/or facsimile is not available</li> <li>Several users have created free themes and/or translations and/or other modules. Please see the phpCOIN <a href="http://www.phpcoin.com/mod.php?mod=downloads">downloads page</a></li> </ul> <p>License Terms:</p> <ul> <li>You <em>explicitly</em> accepted the <a href="coin_docs/license.txt">phpCOIN license terms</a> during the installation process.</li> <li>Failure to comply with the phpCOIN license terms may cause an offending website to be listed on the phpCOIN <a href="http://www.phpcoin.com/auxpage.php?page=shame">Wall of Shame</a> until compliant.</li> </ul> <p>Thank you for trying phpCOIN.</p> <p>%GOOGLE_H%</p>', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(2, 'site', 'greeting', 0, 'Site greeting html code. Placed on index page', 1, 'Site Greeting', 'For a site greeting?', 0, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(3, 'site', 'announce', 0, 'For Top billing announcement on index page.', 1, 'Announcement', 'For a site announcment?', 0, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(4, 'site', 'about', 0, 'About this site info page.', 1, 'About This Site', '<center>\r\n<p><br>This is where you tell them about $_CCFG[_PKG_NAME_SHORT].\r\n<br><br>\r\n</center>', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(5, 'site', 'policy_privacy', 0, 'Privacy Policy', 1, 'Privacy Policy', '<p>$_CCFG[_PKG_NAME_SHORT] is committed to the privacy of our clients.  ...... typical Privacy Polic policy page.<br><br>\r\n', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(6, 'site', 'policy_acceptable_use', 0, 'Acceptable Use Policy', 1, 'Acceptable Use Policy', '<p>...... typical Acceptable Use Policy policy page.<br><br>\r\n', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(7, 'site', 'policy_terms_of_service', 0, 'Terms Of Service', 1, 'Terms Of Service', '<p>When using the Service provided by $_CCFG[_PKG_NAME_SHORT], ...... typical Terms Of Service policy page.<br><br\r\n>', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(8, 'site', 'policy_banned_code', 0, 'Banned Code', 1, 'Banned Code', '<p>...... typical Banned Code policy page.<br><br>\r\n', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(9, 'site', 'dream', 0, 'A Kind Of Dream', 0, 'A Kind Of Dream', '<!-- Start content -->\r\n	<br><br>\r\n		<div align="center">\r\n			<p><font face="Comic Sans MS" size="2">We can walk our road together<br>\r\n					If our goals are all the same.<br>\r\n					We can run alone and free<br>\r\n					If we pursue a different aim.<br>\r\n					Let the Truth of Love be lighted,<br>\r\n					Let the Love of Truth shine clear. Sensibility,<br>\r\n					Armed with sense and liberty,<br>\r\n					With the Heart and Mind united in a single<br>\r\n					Perfect<br>\r\n					Sphere.</font></p>\r\n			<p><i><font face="Comic Sans MS" size="1">The Sphere: A Kind of Dream (Rush: Hemispheres)</font></i></p>\r\n		</div><p>%GOOGLE_H%</p>\r\n\r\n', 1, 1);
INSERT INTO `%PREFIX%site_info` (`si_id`, `si_group`, `si_name`, `si_seq_no`, `si_desc`, `si_block_it`, `si_title`, `si_code`, `si_status`, `si_footer_menu`) VALUES(10, 'site', 'plans', 1, 'Hosting Plans', 1, 'Hosting Plans', '%PLANS_H%', 1, 0);
DROP TABLE IF EXISTS `%PREFIX%suppliers`;
CREATE TABLE `%PREFIX%suppliers` (`s_id` int(11) NOT NULL default '0', `s_status` varchar(20) NOT NULL default 'pending', `s_company` varchar(50) NOT NULL default '', `s_name_first` varchar(20) NOT NULL default '', `s_name_last` varchar(20) NOT NULL default '', `s_addr_01` varchar(50) NOT NULL default '', `s_addr_02` varchar(50) NOT NULL default '', `s_city` varchar(50) NOT NULL default '', `s_state_prov` varchar(50) NOT NULL default '', `s_country` varchar(50) NOT NULL default '', `s_zip_code` varchar(12) NOT NULL default '', `s_phone` varchar(20) NOT NULL default '', `s_fax` varchar(20) NOT NULL default '', `s_tollfree` varchar(20) NOT NULL default '', `s_email` varchar(50) NOT NULL default '', `s_taxid` varchar(20) NOT NULL default '', `s_account` varchar(20) NOT NULL default '', `s_terms` varchar(20) NOT NULL, `s_notes` text NOT NULL, PRIMARY KEY  (`s_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Suppliers Module Table';
DROP TABLE IF EXISTS `%PREFIX%suppliers_contacts`;
CREATE TABLE `%PREFIX%suppliers_contacts` (`contacts_id` int(11) NOT NULL auto_increment, `contacts_s_id` int(11) NOT NULL default '0', `contacts_name_first` varchar(20) NOT NULL default '', `contacts_name_last` varchar(20) NOT NULL default '', `contacts_email` varchar(50) NOT NULL default '', UNIQUE KEY `contacts_id` (`contacts_id`), KEY `contacts_s_id` (`contacts_s_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Suppliers Additional Emails Table';
DROP TABLE IF EXISTS `%PREFIX%todo`;
CREATE TABLE `%PREFIX%todo` (`todo_id` smallint(6) NOT NULL auto_increment, `todo_admin_id` smallint(6) default '0', `todo_title` varchar(255) default '0', `todo_text` text, `todo_duedate` varchar(15) default '0', `todo_entered` varchar(15) default '0', `todo_completed` tinyint(1) default '0', `todo_priority` int(2) default '1', PRIMARY KEY  (`todo_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `%PREFIX%topics`;
CREATE TABLE `%PREFIX%topics` (`topic_id` mediumint(9) NOT NULL auto_increment, `topic_pos` smallint(6) NOT NULL default '0', `topic_name` varchar(50) NOT NULL default '', `topic_desc` varchar(50) NOT NULL default '', `topic_icon` smallint(6) NOT NULL default '1', PRIMARY KEY  (`topic_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Topics Table';
INSERT INTO `%PREFIX%topics` (`topic_id`, `topic_pos`, `topic_name`, `topic_desc`, `topic_icon`) VALUES(1, 0, 'General', 'General / Default Topic', 1);
INSERT INTO `%PREFIX%topics` (`topic_id`, `topic_pos`, `topic_name`, `topic_desc`, `topic_icon`) VALUES(2, 0, 'Announcements', 'For Announcements', 1);
INSERT INTO `%PREFIX%topics` (`topic_id`, `topic_pos`, `topic_name`, `topic_desc`, `topic_icon`) VALUES(3, 0, 'Documentation', 'For Documentation', 1);
INSERT INTO `%PREFIX%topics` (`topic_id`, `topic_pos`, `topic_name`, `topic_desc`, `topic_icon`) VALUES(4, 0, 'News', 'For News', 1);
DROP TABLE IF EXISTS `%PREFIX%vendors`;
CREATE TABLE `%PREFIX%vendors` (`vendor_id` smallint(6) NOT NULL auto_increment, `vendor_status` tinyint(1) NOT NULL default '0', `vendor_name` varchar(20) NOT NULL default '', `vendor_buy_parm` varchar(30) NOT NULL default 'buy', `vendor_buy_parm_val` varchar(10) NOT NULL default '1', `vendor_url` varchar(50) NOT NULL default '', `vendor_use_ipn` tinyint(1) NOT NULL default '0', `vendor_notes` text NOT NULL, PRIMARY KEY  (`vendor_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Vendors Table';
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(1, 1, 'Paypal', 'buy', '1', 'http://www.paypal.com', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/PayPal for PayPal specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(2, 0, '2Checkout', 'credit_card_processed', 'Y', 'http://www.2checkout.com', 0, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/2Checkout for 2Checkout specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(3, 0, 'Bank Transfer', 'transfer', '1', 'http://YOURWEBSITE/mod.php?mod=orders&mode=return', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/Bank_Transfer for Bank Transfer specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(4, 0, 'BRPay', 'Status', '1', 'http://www.brpay.com.br/', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. You also need to download the BRPay callback file. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/BRPay for BRPay specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(5, 0, 'Cheque/Money Order', 'cheque', '1', 'http://YOURWEBSITE/mod.php?mod=orders&mode=return', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/Cheque/Money_Order for Cheque/Money Order specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(6, 0, 'E-xact', 'exact', '1', 'http://www.e-xact.com/', 0, 'You need to insert one PayLink for each product/service that will use this as a payment method. You also need to download the E-xact callback file. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/E-xact for E-xact specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(7, 0, 'MoneyBookers', 'moneybookers', '1', 'http://www.moneybookers.com/', 0, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/MoneyBookers for MoneyBookers specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(8, 0, 'PayMate', 'buy', '1', 'http://www.paymate.com.au/', 0, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/PayMate for PayMate specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(9, 0, 'Purchase Order', 'po', '1', 'http://YOURWEBSITE/mod.php?mod=orders&mode=return', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/Purchase_Order for general PayLink information and variables, and http://docs.phpcoin.com/index.php/Purchase_Order for Purchase Order specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(10, 0, 'Quantum Gateway', 'quantum', '1', 'http://www.quantumgateway.com/', 0, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/Quantum_Gateway for Quantum Gateway specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(11, 0, 'e-gold', 'egold', '1', 'http://www.e-gold.com', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/e-gold for e-gold specific PayLink information');
INSERT INTO `%PREFIX%vendors` (`vendor_id`, `vendor_status`, `vendor_name`, `vendor_buy_parm`, `vendor_buy_parm_val`, `vendor_url`, `vendor_use_ipn`, `vendor_notes`) VALUES(12, 0, 'AlertPay', 'alertpay', '1', 'https://www.alertpay.com', 1, 'You need to insert one PayLink for each product/service that will use this as a payment method. See http://docs.phpcoin.com/index.php/PayLinks for general PayLink information and variables, and http://docs.phpcoin.com/index.php/AlertPay for AlertPay specific PayLink information');
DROP TABLE IF EXISTS `%PREFIX%vendors_prods`;
CREATE TABLE `%PREFIX%vendors_prods` (`vprod_id` smallint(6) NOT NULL auto_increment, `vprod_vendor_id` smallint(6) NOT NULL default '0', `vprod_prod_id` smallint(6) NOT NULL default '0', `vprod_desc` varchar(50) NOT NULL default '', `vprod_order_link` text NOT NULL, PRIMARY KEY  (`vprod_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Vendor Products Table';
INSERT INTO `%PREFIX%vendors_prods` (`vprod_id`, `vprod_vendor_id`, `vprod_prod_id`, `vprod_desc`, `vprod_order_link`) VALUES(1, 1, 1, 'Sample: Paypal - Product 1', '<form action="https://www.paypal.com/cgi-bin/webscr" method="post"><input type="hidden" name="rm" value="2"><input type="hidden" name="cmd" value="_xclick"><input type="hidden" name="business" value="YourPaypalEmailAddress@YourEmailsDomain.com"><input type="hidden" name="item_name" value="<prod_desc>"><input type="hidden" name="item_number" value="<prod_desc>"><input type="hidden" name="no_shipping" value="1"><input type="hidden" name="no_note" value="1"><input type="hidden" name="currency_code" value="USD"><input type="hidden" name="amount" value="<total_amt>"><input type="hidden" name="return" value="<return_link_buy>"><input type="hidden" name="cancel_return" value="<return_link_cancel>"><input type="hidden" name="notify_url" value="<return_link_ipn>paypal.php"><input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-butcc.gif" border="0" name="submit" alt="Make payment - it is fast, free and secure!"></form>');
INSERT INTO `%PREFIX%vendors_prods` (`vprod_id`, `vprod_vendor_id`, `vprod_prod_id`, `vprod_desc`, `vprod_order_link`) VALUES(2, 1, 2, 'Sample: Paypal - Product 2', '<form action="https://www.paypal.com/cgi-bin/webscr" method="post"><input type="hidden" name="rm" value="2"><input type="hidden" name="cmd" value="_xclick"><input type="hidden" name="business" value="YourPaypalEmailAddress@YourEmailsDomain.com"><input type="hidden" name="item_name" value="<prod_desc>"><input type="hidden" name="item_number" value="<prod_desc>"><input type="hidden" name="no_shipping" value="1"><input type="hidden" name="no_note" value="1"><input type="hidden" name="currency_code" value="USD"><input type="hidden" name="amount" value="<total_amt>"><input type="hidden" name="return" value="<return_link_buy>"><input type="hidden" name="cancel_return" value="<return_link_cancel>"><input type="hidden" name="notify_url" value="<return_link_ipn>paypal.php"><input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-butcc.gif" border="0" name="submit" alt="Make payment - it is fast, free and secure!"></form>');
INSERT INTO `%PREFIX%vendors_prods` (`vprod_id`, `vprod_vendor_id`, `vprod_prod_id`, `vprod_desc`, `vprod_order_link`) VALUES(3, 2, 1, 'Sample: 2Checkout - Product 1', '<p><form action="https://www.2checkout.com/2co/buyer/purchase" method="post"><input type="hidden" name="id_type" value="1"><input type="hidden" name="sid" value="XXXXX"><input type="hidden" name="c_prod" value="YYYYY"><input type="hidden" name="c_name" value="<prod_name>"><input type="hidden" name="c_description" value="<prod_desc>"><input type="hidden" name="c_price" value="<prod_unit_cost>"><input type="hidden" name="c_tangible" value="N"><input type="hidden" name="cart_order_id" value="<order_id>"><input type="hidden" name="total" value="<total_amt>"><input type="submit" value="Click to buy thru 2CheckOut"></form>2Checkout.com, Inc. is an authorized retailer of goods and services provided by phpcoin.com</p>');
INSERT INTO `%PREFIX%vendors_prods` (`vprod_id`, `vprod_vendor_id`, `vprod_prod_id`, `vprod_desc`, `vprod_order_link`) VALUES(4, 2, 2, 'Sample: 2Checkout - Product 2', '<p><form action="https://www.2checkout.com/2co/buyer/purchase" method="post"><input type="hidden" name="id_type" value="1"><input type="hidden" name="sid" value="XXXXX"><input type="hidden" name="c_prod" value="YYYYY"><input type="hidden" name="c_name" value="<prod_name>"><input type="hidden" name="c_description" value="<prod_desc>"><input type="hidden" name="c_price" value="<prod_unit_cost>"><input type="hidden" name="c_tangible" value="N"><input type="hidden" name="cart_order_id" value="<order_id>"><input type="hidden" name="total" value="<total_amt>"><input type="submit" value="Click to buy thru 2CheckOut"></form>2Checkout.com, Inc. is an authorized retailer of goods and services provided by phpcoin.com</p>');
DROP TABLE IF EXISTS `%PREFIX%whois`;
CREATE TABLE `%PREFIX%whois` (`whois_id` int(11) NOT NULL auto_increment, `whois_server` varchar(100) NOT NULL default '', `whois_nomatch` varchar(40) NOT NULL default '', `whois_value` varchar(20) NOT NULL default '', `whois_display` varchar(25) NOT NULL default '', `whois_include` tinyint(1) NOT NULL default '1', `whois_prod_id` int(11) NOT NULL default '0', `whois_notes` text, UNIQUE KEY `whois_id` (`whois_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(1, 'whois.cira.ca', 'Status:AVAIL', 'ca', '.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(2, 'whois.nic.biz', 'Not found', 'biz', '.biz', 0, 0, 'Must be registered to get WHOIS results for .biz');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(3, 'whois.cira.ca', 'Status:AVAIL', 'ab.ca', '.ab.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(4, 'whois.cira.ca', 'Status:AVAIL', 'bc.ca', '.bc.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(5, 'whois.cira.ca', 'Status:AVAIL', 'mb.ca', '.mb.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(6, 'whois.cira.ca', 'Status:AVAIL', 'nb.ca', '.nb.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(7, 'whois.cira.ca', 'Status:AVAIL', 'ns.ca', '.ns.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(8, 'whois.cira.ca', 'Status:AVAIL', 'nf.ca', '.nf.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(9, 'whois.cira.ca', 'Status:AVAIL', 'on.ca', '.on.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(10, 'whois.cira.ca', 'Status:AVAIL', 'pe.ca', '.pe.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(11, 'whois.cira.ca', 'Status:AVAIL', 'pq.ca', '.pq.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(12, 'whois.cira.ca', 'Status:AVAIL', 'sk.ca', '.sk.ca', 1, 0, 'Handles all .ca and PROV.ca domain registrations');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(13, 'whois.internic.net', 'no match', 'com net', '.com .net', 0, 0, 'Handles .com and .net domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(14, 'whois.internic.net', 'no match', 'com', '.com', 1, 0, 'Handles .com domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(15, 'whois.internic.net', 'no match', 'net', '.net', 1, 0, 'Handles .net domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(16, 'whois.opensrs.net', 'Not found', 'info', '.info', 1, 0, 'Handles .info domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(17, 'whois.publicinterestregistry.net', 'NOT FOUND', 'org', '.org', 1, 0, 'Handles .org domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(18, 'whois.dns.pl', 'does not exists', 'pl com.pl', '.pl .com.pl', 0, 0, 'Handles .pl and .com.pl domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(19, 'whois.dns.pl', 'does not exists', 'pl', '.pl', 0, 0, 'Handles .pl domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(20, 'whois.dns.pl', 'does not exists', 'com.pl', '.com.pl', 0, 0, 'Handles .com.pl domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(21, 'whois.nic.uk', 'No match', 'uk', '.uk', 0, 0, 'Handles .uk domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(22, 'whois.nic.uk', 'No match', 'co.uk org.uk me.uk', '.co.uk .org.uk .me.uk', 0, 0, 'Handles various combined .uk domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(23, 'whois.nic.uk', 'No match', 'co.uk', '.co.uk', 0, 0, 'Handles .co.uk domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(24, 'whois.nic.uk', 'No match', 'org.uk', '.org.uk', 0, 0, 'Handles .org.uk domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(25, 'whois.nic.uk', 'No match', 'me.uk', '.me.uk', 0, 0, 'Handles .me.uk domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(26, 'whois.nic.us', 'Not found:', 'us', '.us', 0, 0, 'Handles .us domains');
INSERT INTO `%PREFIX%whois` (`whois_id`, `whois_server`, `whois_nomatch`, `whois_value`, `whois_display`, `whois_include`, `whois_prod_id`, `whois_notes`) VALUES(27, 'whois.nic.cc', 'No Match', 'cc', '.cc', 0, 0, 'Handles .cc domains');
DROP TABLE IF EXISTS `%PREFIX%versions`;
CREATE TABLE `%PREFIX%versions` (`v_id` smallint(6) NOT NULL auto_increment, `v_ts` varchar(10) NOT NULL default '', `v_ver` varchar(8) NOT NULL default '', `v_type` varchar(10) NOT NULL default 'Install', PRIMARY KEY  (`v_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Package Versions Table';
INSERT INTO `%PREFIX%versions` (`v_id`, `v_ts`, `v_ver`, `v_type`) VALUES(1, '%TIMESTAMP%', 'v1.6.5', 'Install');
