#! /usr/lib/rads/venv/bin/python3
"""Subclass for WordPress CMS"""
# Author: Daniel K

import os
import logging
from typing import TYPE_CHECKING
from cms_tools.db import simple_query
from cms_tools.cms import CMS
from cms_tools.cms import VariableData

if TYPE_CHECKING:
    from cms_tools.cms import CMSFind

LOGGER = logging.getLogger(__name__)


class WordPress(CMS):
    '''
    Class for WordPress installations
    '''

    def setup(self):

        self.type = 'WordPress'

        self.config = os.path.join(self.directory_root, 'wp-config.php')

        self.db_name_data = VariableData('php_define', 'DB_NAME', self.config)
        self.db_user_data = VariableData('php_define', 'DB_USER', self.config)
        self.db_pass_data = VariableData(
            'php_define', 'DB_PASSWORD', self.config
        )
        self.db_pref_data = VariableData(
            'php_variable', 'table_prefix', self.config
        )
        self.db_host_data = VariableData('php_define', 'DB_HOST', self.config)

        self.cms_directories = [r"wp-"]

        self.version = VariableData(
            'php_variable',
            'wp_version',
            os.path.join(self.directory_root, 'wp-includes/version.php'),
        ).get_value()

        return True

    def post_tables_hook(self):
        '''Perform operations which require working db connection'''

        result = simple_query(
            self, 'option_value', 'options', 'option_name', 'siteurl'
        )

        if result is not None:
            self.siteurl = result[0]

        return True


def register_cms(cms_find_instance: 'CMSFind'):
    '''
    Register self with current cms_find_instance
    '''

    cms_find_instance.add_quick("WordPress", WordPress)
