#! /usr/lib/rads/venv/bin/python3
"""Subclass for PrestaShop CMS"""
# Author: Daniel K

import os
import logging
from typing import TYPE_CHECKING
from cms_tools.db import simple_query
from cms_tools.cms import CMS
from cms_tools.cms import VariableData

if TYPE_CHECKING:
    from cms_tools.cms import CMSFind

LOGGER = logging.getLogger(__name__)


class PrestaShop(CMS):
    '''
    Class for PrestaShop installations
    '''

    def setup(self):

        self.type = 'PrestaShop'

        self.config = os.path.join(
            self.directory_root, 'config/settings.inc.php'
        )

        self.db_name_data = VariableData('php_define', '_DB_NAME_', self.config)
        self.db_user_data = VariableData('php_define', '_DB_USER_', self.config)
        self.db_pass_data = VariableData(
            'php_define', '_DB_PASSWD_', self.config
        )
        self.db_pref_data = VariableData(
            'php_define', '_DB_PREFIX_', self.config
        )
        self.db_host_data = VariableData(
            'php_define', '_DB_SERVER_', self.config
        )

        self.cms_directories = [
            r"admin.*",
            "js",
            "modules",
            "webservice",
            "override",
            "img",
            "log",
            "localization",
            "tools",
            "download",
            "classes",
            "translations",
            "docs",
            "themes",
            "config",
            "mails",
            "cache",
            "pdf",
            "upload",
            "controllers",
            "css",
        ]

        return True

    def post_tables_hook(self):
        '''Perform operations which require working db connection'''

        result = simple_query(
            self, 'value', 'configuration', 'name', 'PS_INSTALL_VERSION'
        )

        if result is not None:
            self.version = result[0]

        result = simple_query(
            self,
            'domain',
            'shop_url',
        )

        if result is not None:
            self.siteurl = "http://%s" % result[0]

        result = simple_query(
            self,
            'physical_uri',
            'shop_url',
        )

        if result is not None:
            self.siteurl += result[0]

        return True


def register_cms(cms_find_instance: 'CMSFind'):
    '''
    Register self with current cms_find_instance
    '''

    cms_find_instance.add_quick("PrestaShop", PrestaShop)
