#! /usr/lib/rads/venv/bin/python3
"""Subclass for phpBB CMS"""
# Author: Daniel K

import os
import logging
from typing import TYPE_CHECKING
from ..cms import CMS
from ..cms import VariableData

if TYPE_CHECKING:
    from ..cms import CMSFind

LOGGER = logging.getLogger(__name__)


class PhpBB(CMS):
    '''
    Class for phpBB installations
    '''

    def setup(self):

        self.type = 'phpBB'

        self.config = os.path.join(self.directory_root, 'config.php')

        self.db_name_data = VariableData('php_variable', 'dbname', self.config)
        self.db_user_data = VariableData('php_variable', 'dbuser', self.config)
        self.db_pass_data = VariableData(
            'php_variable', 'dbpasswd', self.config
        )
        self.db_pref_data = VariableData(
            'php_variable', 'table_prefix', self.config
        )
        self.db_host_data = VariableData('php_variable', 'dbhost', self.config)

        self.cms_directories = [
            "language",
            "vendor",
            "phpbb",
            "bin",
            "includes",
            "download",
            "styles",
            "docs",
            "assets",
            "store",
            "files",
            "config",
            "ext",
            "adm",
            "cache",
            "images",
        ]

        return True


def register_cms(cms_find_instance: 'CMSFind'):
    '''
    Register self with current cms_find_instance
    '''

    cms_find_instance.add_quick("phpBB", PhpBB)
