#! /usr/lib/rads/venv/bin/python3
"""Subclass for Joomla CMS"""
# Author: Daniel K

import os
import logging
from typing import TYPE_CHECKING
from ..cms import CMS
from ..cms import VariableData

if TYPE_CHECKING:
    from ..cms import CMSFind

LOGGER = logging.getLogger(__name__)


class Joomla(CMS):
    '''
    Class for Joomla installations
    '''

    def setup(self):

        self.type = 'Joomla'

        self.config = os.path.join(self.directory_root, 'configuration.php')

        self.db_name_data = VariableData('php_variable', 'db', self.config)
        self.db_user_data = VariableData('php_variable', 'user', self.config)
        self.db_pass_data = VariableData(
            'php_variable', 'password', self.config
        )
        self.db_pref_data = VariableData(
            'php_variable', 'dbprefix', self.config
        )
        self.db_host_data = VariableData('php_variable', 'host', self.config)

        self.cms_directories = [
            "language",
            "layouts",
            "components",
            "modules",
            "logs",
            "bin",
            "media",
            "tmp",
            "administrator",
            "cli",
            "includes",
            "plugins",
            "templates",
            "libraries",
            "images",
            "xmlrpc",
        ]

        siteurl = VariableData(
            'php_variable', 'live_site', self.config
        ).get_value()

        if siteurl is not None:
            self.siteurl = siteurl

        for version_file in (
            'libraries/cms/version/version.php',
            'libraries/joomla/version.php',
            'includes/version.php',
        ):
            version_file = os.path.join(self.directory_root, version_file)
            if os.path.isfile(version_file):
                self.version = VariableData(
                    'php_variable', 'RELEASE', version_file
                ).get_value()

        return True


def register_cms(cms_find_instance: 'CMSFind'):
    '''
    Register self with current cms_find_instance
    '''

    cms_find_instance.add_quick("Joomla", Joomla)
