#! /usr/lib/rads/venv/bin/python3
"""Template for cms_tools CMS modules"""
import os
import logging
from typing import TYPE_CHECKING
from ..cms import CMS
from ..cms import VariableData

# Optional. Use if needing to get db query for a variable
from ..db import simple_query

if TYPE_CHECKING:
    from ..cms import CMSFind


LOGGER = logging.getLogger(__name__)


class NewCMS(CMS):
    '''
    Class for NewCMS installations
    '''

    def setup(self):

        # Set the human redable name for the CMS
        self.type = 'WordPress'

        # Location of the congiguration file
        self.config = os.path.join(self.directory_root, 'config.php')

        # Tell the software about the variables.

        # The database configurations are set by specifying
        # where to find the data. The main class handles the rest.

        # Example for the db_name
        self.db_name_data = VariableData(
            'php_variable',  # Type of data. Can be: php_define or php_variable
            'name',  # The name of the variable in the file
            self.config,  # The file where this data can be found
        )

        # The user, password, prefix, and host should be set in a similar way
        self.db_user_data = VariableData('php_define', 'user', self.config)
        self.db_pass_data = VariableData('php_define', 'pass', self.config)
        self.db_pref_data = VariableData('php_define', 'prefix', self.config)
        self.db_host_data = VariableData('php_define', 'host', self.config)

        # List containig directories which are known to be part of this
        # installation. These will not be checked for other CMS.
        self.cms_directories = ["directory1", "directory2", "directoryn"]

        # These are two optional variables, but it's advisable to set them.
        # Typically, you wouldn't set them explicitly, but makde some code
        # to determine them somehow.
        self.version = "Unknwon"
        self.stieurl = "Unknown"

        # This is an example of how you can get a variable directly from a file
        # This example is from WordPress.
        self.version = VariableData(
            'php_variable',
            'wp_version',
            os.path.join(self.directory_root, 'wp-includes/version.php'),
        ).get_value()

        # If you do smething advanced that can fail, you could return False,
        # but with this simple stuff, just return True.
        return True

    # This is an optional method. This can be used if some data can only be
    # discovered after databases have been properly configured
    # If this is added, keep it on the same indent as setup() as it
    # is still part of the sub-class definition
    def post_tables_hook(self):
        '''Setup after tables have been confirmed'''

        # This is how you can collect data from a database.
        # This example works for WordPress.
        result = simple_query(
            self,  # This is mandatory and passes the class itself
            'option_value',  # This is the row that you want returned
            'options',  # This is the table name without the prefix
            'option_name',  # The last two are optional, Search this row
            'siteurl',  # for this value.
        )

        # It's good to check fo a result before assigning
        if result is not None:
            self.siteurl = result[0]


# End NewCMS class
# Additional cunctions can be placed after here, or before the class line


def register_cms(cms_find_instance: 'CMSFind'):
    '''
    Register self with current cms_find_instance
    '''

    # Allow module to be regustered. The first parameter is the human
    # readable name, and the second is the name of the specific class
    cms_find_instance.add_quick("NewCMS", NewCMS)
