-- Clipper 1.2 Sample Site Data

--
-- Dumping data for table `{PREFIX}site_content`
--


REPLACE INTO `{PREFIX}site_content` VALUES
(1, 'document', 'text/html', 'ClipperCMS Demo', 'ClipperCMS Demo website', '', '', '', 1, 0, 0, 0, 0, '', '<p>You can use this demo site to explore Clipper and experiment with its features. The various pages demonstrate the ease with which you can use the Clipper''s key elements to create your own site in your own way, whether you are a designer, developer or prefer not to be labelled.</p>\r\n<p>If you''ve installed Clipper on your own server, you''ll have been into the manager already at the end of the process. If you''re viewing the demo on the Clipper site, you can <a href="manager">log in</a> and take a look around.</p>\r\n<p>The site illustrates some of the basic features of Clipper. It''s neither a tutorial nor a manual. It''s not even very extensive as a demo! It aims to give you a head start in seeing how a simple site is constructed, and the overview in the Help pages, along with other documentation, will help you get to grips with the terminology and design options.</p>\r\n<p>Beyond what you can see in the demo, Clipper offers a wide range of useful facilities for subscriber and user management, access control, "friendly URLs" and publication timing, and it really is easy to extend without becoming a PHP guru. Explore, enjoy, and if you have questions and suggestions, join us in the <a href="http://www.clippercms.com/forum/">forums</a>!</p>', 1, 4, 0, 1, 1, 1, 1130304721, 1, 1371145729, 0, 0, 0, 1130304721, 1, 'Home', 0, 0, 0, 0, 0),
(2, 'document', 'text/html', 'Getting Started', 'Getting Started with ClipperCMS', '', '', '', 1, 0, 0, 0, 0, '', '<p>To install Clipper, you will need:</p>\r\n<ul>\r\n<li>A Web Server with writing permissions</li>\r\n<li>PHP version 5+</li>\r\n<li>MySQL version 5+</li>\r\n</ul>\r\n<p style="margin-top: 10px;">Clipper (version 1.2+) works happily with PHP 5.4. It has been thoroughly tested using Apache web server under both Linux and Windows. It will also run on Windows IIS 6.0+.</p>\r\n<p>It is recommended that you install a local web host to try things out, using a package such as XAMPP, WAMP, MAMP or EasyPHP.</p>\r\n<p>Installation is straightforward. Just download the current release of Clipper, unpack the files in your web root (or a subdirectory, as long as you can edit the .htaccess file to redirect traffic to it), set up your server configuration and hosts files if required, and go to the site. Click on the Install link that comes up, and you''re on your way. See the <a href="http://www.clippercms.com/documentation" target="_blank">Clipper documentation site</a> for full details.</p>\r\n<p>When you get to the installation options screen, tick the box to install the demo site; note this will erase any previous installation, as it overwrites the database.</p>', 1, 5, 1, 1, 1, 1, 1367530358, 1, 1371145663, 0, 0, 0, 1367530392, 1, '', 0, 0, 0, 0, 0),
(3, 'document', 'text/html', 'Recipes', 'Recipes: an example of an "index" page', '', 'recipes', '', 1, 0, 0, 0, 1, '', '<p>This page is an example of Clipper''s List snippet. Like the "loop" in Wordpress or Ditto in MODX, List extracts data from specified sets of resources and presents them in formats set by HTML mini-templates. You can use List to make a newsreel, a blog front page, a product catalogue or a feature index. List is also good for building single-level navigation menus when the more complex features of Wayfinder are not required.</p>', 1, 5, 3, 1, 1, 1, 1367530362, 1, 1371145356, 0, 0, 0, 1367530396, 1, 'Recipes', 0, 0, 0, 0, 0),
(4, 'document', 'text/html', 'Features', 'Features', '', '', '', 1, 0, 0, 0, 0, '', '<p class="western">Out of the box, Clipper is a CMS - a Content Management System that you can use to create and maintain your website. After logging in as a manager, you see the resources that generate the pages of your site in a tree structure on the left, and can edit them and elements tied to them in the main editing area on the right. All you need to get started is an HTML page to use as your basic template, and you can build out from there.</p>\r\n<p class="western">The text content of your site is stored in a <strong>database</strong>, making it easy to reorganize it, search it and create backups. Page templates and smaller PHP code modules (snippets, plugins and modules) are also stored in the database, while files are used for images, CSS, Javascript and bulkier PHP scripts. An efficient cache mechanism avoids unnecessary calls to the database when pages are generated, and ensures maximum performance.</p>\r\n<hr />\r\n<p class="western">A flexible <strong>template system</strong> means that code for pages with similar layout can be reused across the site. Dynamic elements are inserted using various tags for document fields, shared HTML code and output of PHP scripts.</p>\r\n<hr />\r\n<p class="western">Each page <strong>resource</strong> has a fixed set of fields for commonly-used features such as page title and publication status. <strong>Template variables</strong> [TVs] expand the range of purpose-created fields available to each resource via the template associated with it. Types of TV range from simple text fields and image tags to drop-down lists and rich-text editor inputs.</p>\r\n<hr />\r\n<p class="western">It''s easy to <strong>extend</strong> Clipper without touching the core code, thanks to Extras such as snippets - PHP scripts inserted into resources and templates using tags, plugins - PHP that can be run when a large variety of system events are triggered, and modules - additional features in the "back end" for site editors logged in as managers. Bundled extras include the List snippet, which generates the Recipe page''s listing of features detailed in sub-pages, and Resource Manager, which make sit easy to sort and update sets of pages in bulk.</p>\r\n<p class="western">Clipper is more than a CMS (Content Management System), it''s a CMF - a Content Management Framework that you can customize to produce extended facilities and different views for different groups of editors and subscribers. The ManagerManager plugin, for instance, is a bundled extra that enables you to rearrange fields and tabs in the main ediitng area to suit different templates and different groups of editors.</p>\r\n<p class="western">Clipper takes security seriously; passwords use a salted hash mechanism, and different levels of access can be granted to the relevant groups of editors and subscribers via user-definable roles and resource groups.</p>', 1, 5, 2, 1, 1, 1, 1367530370, 2, 1370682892, 0, 0, 0, 1367530397, 1, 'Features', 0, 0, 0, 0, 0),
(5, 'document', 'text/html', 'Help', 'Hints on what''s where in the demo', '', '', '', 1, 0, 0, 0, 1, '', '<p>These Help pages aim to:</p>\r\n<ul style="margin-bottom: 10px;">\r\n<li>Explain the structure and components of the demo website</li>\r\n<li>Describe the key operations for editing the site in the Manager "back end"</li>\r\n<li>Give you an idea of how you can use the demo as a learning tool</li>\r\n</ul>\r\n<p>&nbsp;The demo is not intended as a "starter" site to base your own development on. It is an example of one way of building a site, using a selection of the available tools. Clipper can probably adapt to your preferred way of working. The demo simply helps you to gain some idea of how the elements all hang together to create a site.</p>', 1, 5, 4, 1, 1, 1, 1367530376, 2, 1371142700, 0, 0, 0, 1367530398, 1, 'Help', 0, 0, 0, 0, 0),
(6, 'document', 'text/html', 'Contacts', 'Contacts', '', 'contacts', '', 1, 0, 0, 0, 1, '', '<p>The Clipper package includes the PHP snippet <strong>eForm</strong>, a well proven means of generating and processing contact forms and other input pages. eForm includes a variety of field validation categories, and needs vey little extra Javascript to produce smart error messages as employed in the form on this page. With no extra scripting, errors are displayed in a block wherever the relevant placeholder is located.</p>', 1, 5, 5, 1, 1, 1, 1367530384, 1, 1370708512, 0, 0, 0, 1367530400, 1, '', 0, 0, 0, 0, 0),
(7, 'document', 'text/html', 'Search Results', 'Search Results', '', '', '', 1, 0, 0, 0, 0, '', '[!AjaxSearch? \r\n	&ajaxSearch=`0` \r\n	&showInputForm=`0` \r\n	&language=`english` \r\n	&whereSearch=`content:content` \r\n	&extract=`1:content` \r\n	&extractLength=`560` \r\n	&extractEllips=`` \r\n	&extractSeparator=`` \r\n	&grabMax=`0` \r\n	&advSearch=`oneword` \r\n	&highlightResult=`1` \r\n!]', 0, 5, 6, 0, 1, 1, 1367530413, 1, 1371164810, 0, 0, 0, 1367530548, 1, '', 0, 0, 0, 0, 1),
(10, 'document', 'text/html', 'Thank You', 'Thank you!', '', '', '', 1, 0, 0, 6, 0, '', '<p class="alert-box success">Your message has been successfully sent! Go back to <a href="[~1~]">home</a>.</p>', 1, 5, 0, 1, 1, 1, 1367533186, 1, 1370877806, 0, 0, 0, 1367533195, 1, '', 0, 0, 0, 0, 1),
(11, 'document', 'text/html', 'Lamb Hotpot', 'Lamb hot pot', '', 'lamb-hot-pot', '', 1, 0, 0, 3, 0, 'Based on Lancashire hotpot, a dish made traditionally from lamb or mutton and onion, topped with sliced potatoes, slow-cooked in a heavy pot. Originating in the days of heavy industrialisation in Lancashire, England, it requires a minimum of effort to prepare. ', '<p>[*introtext*]</p>\r\n<h3>Ingredients</h3>\r\n<table id="recipe-ingredients">\r\n<tbody>\r\n<tr>\r\n<td colspan="2">[*food-shot*]</td>\r\n</tr>\r\n<tr>\r\n<td>Servings</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Ready in</td>\r\n<td>1h 35m</td>\r\n</tr>\r\n<tr>\r\n<td>Preparation time</td>\r\n<td>20m</td>\r\n</tr>\r\n<tr>\r\n<td>Cooking time</td>\r\n<td>1h 15m</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<ul>\r\n<li>2 Carrots finely diced</li>\r\n<li>2 Celery Sticks finely diced</li>\r\n<li>2 Onions finely diced</li>\r\n<li>1 clove of garlic, crushed</li>\r\n<li>2 sprigs of Rosemary</li>\r\n<li>75g Butter</li>\r\n<li>4 Large Chump Chops</li>\r\n<li>150ml white wine</li>\r\n<li>650ml Good Lamb or beef stock</li>\r\n<li>8 Rooster Potatoes thinly sliced</li>\r\n<li>Salt &amp; Pepper</li>\r\n</ul>\r\n<h3>Mise en place</h3>\r\n<p>Pre-heat oven to 180&deg;C / Gas Mark 4.</p>\r\n<h3>Method</h3>\r\n<ol>\r\n<li>Lightly cook the vegetables, garlic and rosemary in 50g of butter, remove from pan and keep to one side.</li>\r\n<li>Melt the remaining butter in the pan and brown the chops on each side, remove from pan.</li>\r\n<li>Add the wine, boil and reduce until almost dry add the stock and bring to the boil.</li>\r\n<li>Place the chops into a shallow braising dish, cover with the vegetables and season with salt &amp; pepper.</li>\r\n<li>Lay the sliced potatoes overlapping onto the chops, pour over the hot stock, place into oven and cook for 1 hour basting the potatoes every 15 minutes.</li>\r\n</ol>\r\n<p>(Recipe by Andrew Fairlie)</p>\r\n<p>{{attribution-cookipedia}}</p>', 1, 6, 0, 1, 1, 2, 1370438183, 1, 1370710515, 0, 0, 0, 1370438848, 2, '', 0, 0, 0, 0, 0),
(12, 'document', 'text/html', 'Aubergines and Parmesan', 'Baked aubergines with tomatoes and Parmesan', '', 'parmigiana', '', 1, 0, 0, 3, 0, 'A bit like parmigiana di melanzane, a Southern Italian dish made with a shallow-fried sliced filling, layered with cheese and tomato sauce, then baked. The filling is aubergine, AKA eggplant.', '<p>[*introtext*]</p>\r\n<h3>Ingredients</h3>\r\n<table id="recipe-ingredients">\r\n<tbody>\r\n<tr>\r\n<td colspan="2">[*food-shot*]</td>\r\n</tr>\r\n<tr>\r\n<td>Servings</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Ready in</td>\r\n<td>55m</td>\r\n</tr>\r\n<tr>\r\n<td>Preparation time</td>\r\n<td>25m</td>\r\n</tr>\r\n<tr>\r\n<td>Cooking time</td>\r\n<td>35m</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<ul>\r\n<li>2 large aubergines, thickly sliced, but NOT peeled</li>\r\n<li>Olive oil</li>\r\n<li>sea salt</li>\r\n<li>Black pepper, freshly ground</li>\r\n<li>1-2 bulbs garlic, crushed or finely chopped</li>\r\n<li>2 or more hot red chillies, finely chopped</li>\r\n<li>500 g tomatoes, chopped</li>\r\n<li>Parmesan cheese, to taste, finely grated</li>\r\n</ul>\r\n<h3>Mise en place</h3>\r\n<p>Pre-heat the oven to 220&deg; C (425&deg; F - gas 7), placing a shelf at the top of the oven.</p>\r\n<h3>Method</h3>\r\n<ol>\r\n<li>Place the aubergine slices on a baking tray so that they do not overlap - use more than one try if necessary.</li>\r\n<li>Brush the slices with plenty of olive oil and lightly sprinkle the salt and pepper over them.</li>\r\n<li>Turn them over and do the same to the other sides.</li>\r\n<li>Bake at the top of the oven for about 25 minutes.</li>\r\n<li>Meanwhile, heat a little oil in a pan, add the garlic and chillies and quickly fry, without them turning brown.</li>\r\n<li>Add the tomatoes and cook until any liquid has almost evaporated and you have a thick sludge of tomato mixture.</li>\r\n<li>When the aubergines are ready spread the tomato mixture over each slice.</li>\r\n<li>Finally, sprinkle the Parmesan over each slice and bake for a further 10 minutes or until the cheese has cooked.</li>\r\n</ol>\r\n<h3>Serving suggestions</h3>\r\n<p>Serve with ciabatta.</p>\r\n<h3>Chef''s notes</h3>\r\n<p>If you find that the skins of the aubergines are tough, just remove the skins as you eat the slices. Do not peel them before cooking or the slices will lose theire shape and become mushy.</p>\r\n<p>You may find that you need more or less of the given tomato quantity as it will depend on how juicy the tomatoes are. If they are fairly solid, you can use less.</p>\r\n<p>The amount of Parmesan you use is up to you. Just grate a reasonable quantity of it and see how much you can pile onto the aubergine slices. Any left over cheese can be kept in the fridge in an airtight container.</p>\r\n<p>{{attribution-cookipedia}}</p>', 1, 6, 1, 1, 1, 2, 1370439272, 1, 1370710532, 0, 0, 0, 1370439296, 2, 'Aubergines with Parmesan', 0, 0, 0, 0, 0),
(13, 'document', 'text/html', 'Borscht', 'Borscht', '', 'borscht', '', 1, 0, 0, 3, 0, 'Borscht (also borsht or borshch) is a vegetable soup from Eastern Europe. It is traditionally made with beetroot as a main ingredient which gives it a strong red colour. ', '<p>[*introtext*]</p>\r\n<h3>Ingredients</h3>\r\n<table id="recipe-ingredients">\r\n<tbody>\r\n<tr>\r\n<td colspan="2">[*food-shot*]</td>\r\n</tr>\r\n<tr>\r\n<td>Servings</td>\r\n<td>4 to 6</td>\r\n</tr>\r\n<tr>\r\n<td>Ready in</td>\r\n<td>2h 45m</td>\r\n</tr>\r\n<tr>\r\n<td>Preparation time</td>\r\n<td>15m</td>\r\n</tr>\r\n<tr>\r\n<td>Cooking time</td>\r\n<td>2h 30m</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<ul>\r\n<li>4 large onions</li>\r\n<li>2 medium peeled potatoes</li>\r\n<li>4 peeled carrots</li>\r\n<li>2 large tomatoes</li>\r\n<li>&frac14; head of cabbage</li>\r\n<li>3 medium-Beetroots</li>\r\n<li>4 large Cloves of garlic, peeled and chopped</li>\r\n<li>Parsley and/or dill (to taste)</li>\r\n<li>1 tablespoon vinegar or lemon juice</li>\r\n<li>Cooking oil for frying</li>\r\n<li>1 tablespoon salt (to taste)</li>\r\n<li>1 tablespoon sugar (to taste)</li>\r\n</ul>\r\n<h3>Method</h3>\r\n<ol>\r\n<li>Chop the onions, potatoes, cabbage, and tomatoes into small pieces, and grate the beets and carrots into approximately 1-inch long pieces.</li>\r\n<li>Fry the onions until golden-brown (with about 4-5 tablespoons. oil) in a deep frying pan at medium heat. Stir regularly.</li>\r\n<li>Add the carrots to the onions and cook for two or three minutes more.</li>\r\n<li>Add the tomatoes and beets to the frying pan. Immediately pour vinegar or lemon juice over the beets to preserve their colour and taste. If you are going to add ketchup, do it right now.</li>\r\n<li>Mix everything, then cover the pan with a lid and cook for 5-10 minutes more at low heat.</li>\r\n<li>Pour cool water into a large pot so that the water takes up between &frac12; and 2/3 of the pot''s total capacity. Turn on medium heat and wait until the water is boiling.</li>\r\n<li>Add the potatoes to the boiling water and wait 3-4 minutes.</li>\r\n<li>Add the cabbage and wait about two minutes.</li>\r\n<li>Add everything in the frying pan to the pot.</li>\r\n<li>Add the garlic, parsley, and dill.</li>\r\n<li>Add the salt and sugar.</li>\r\n<li>Wait until the water is boiling again (as it should have stopped when everything was added) and then turn off the heat. Cover the pot with a lid, leaving a crack for steam to escape.</li>\r\n<li>Let the soup cook in its own heat for about 2 hours. The longer it cooks, the better it tastes. You may want to refrigerate it and microwave it the next day for an even better taste.</li>\r\n</ol>\r\n<h3>Serving suggestions</h3>\r\n<p>Serve with sour cream</p>\r\n<p>{{attribution-cookipedia}}</p>', 1, 6, 2, 1, 1, 2, 1370439413, 1, 1370710496, 0, 0, 0, 1370439442, 2, 'Borscht', 0, 0, 0, 0, 0),
(14, 'document', 'text/html', 'Manager basics', 'Key operations in the Manager', '', 'help-manager', '', 1, 0, 0, 5, 0, '', '<p>Clipper''s administrative interface is called the Manager, located at <strong>&lt;site_URL&gt;/manager</strong>. If you installed Clipper on your own server, you''ll have logged in to the Manager already at the end of the installation process, and set your site''s name in the Configuration section.</p>\r\n<p>The key items in the main menu (across the top) to be covered here are <strong>Site</strong>, <strong>Elements</strong> and <strong>Tools</strong>. Sub-menus for the current main menu item appear in a line below it. <br />Down the left side is the <strong>Resource Tree</strong>, which shows your site''s resources (the focal point for generating individual web pages) in a standard filing system structure. <br />On the right is the main editing area, where you will see the resource you are currently editing, an index list of available items to edit, or a report, depending on what part of the Manager your are in.</p>\r\n<h4>Manager menu</h4>\r\n<p><strong>Site &gt; Home</strong> recalls the screen you see when you first log in, with a tabbed display of information in the main editing area.<br /><strong>Site &gt; Preview</strong> calls up the home page of your site in a new browser tab or window.<br /> <strong>Site &gt; Clear Cache</strong>: Updating an item clears the cache automatically, but you can use this command to ensure the latest version is being published (e.g. after updating a stylesheet file). Clipper''s built-in cache mechanism reduces database calls to a minimum to keep response times down.</p>\r\n<p><strong>Elements &gt; Manage Elements</strong> brings up tabbed lists of the Templates, Template Variables, HTML chunks and PHP snippets that are tied in to your resources to generate web pages. (Tip: open <strong>Manage Elements</strong> in a separate browser tab so you can keep a resource you''re editing open).</p>\r\n<p style="margin-bottom: 5px;"><strong>Tools &gt; Configuration</strong> opens a tabbed set of site configuration fields. Some important ones are:</p>\r\n<ul>\r\n<li><strong>Site &gt; Automatic Template Assignment </strong>and <strong>System Default Template</strong> affecting templates assigned to new resources</li>\r\n<li>Settings<strong> </strong>for handling of deprecated PHP functions and display of PHP errors, near the bottom of the <strong>Site</strong> tab</li>\r\n<li><strong>Site &gt; jQuery URL</strong>, which can be inserted into templates and resources as a tag</li>\r\n<li><strong>User &gt; E-mail address</strong>, which is the default From adress for mail created by the site</li>\r\n<li><strong>Interface &amp; Features &gt; Page Click Behaviour</strong>: open a resource for editing, or just view its overview when you&nbsp; click on it in the tree?</li>\r\n<li><strong>Interface &amp; Features &gt; File base path</strong>, which usually needs resetting when you move your site to another server<strong>, </strong>along with <strong>File Manager path</strong> in the <strong>File Manager</strong> tab. <strong></strong></li>\r\n</ul>\r\n<h4>Resource Tree</h4>\r\n<p>When you left-click an item in the resource tree, either it will open for editing or its main fields will be display in the main editing area, depending on your setting in <strong>Interface &amp; Features &gt; Page Click Behaviour</strong>. When you right-click on a resource''s title in the tree, a context menu appears, which includes commands to edit the resource and to see its overview.</p>\r\n<p><strong>Create Resource here</strong> creates a new resource as a child of the one you clicked on. Its initial template will be set according to your choices in the site configuration and your settings for the parent template. <br />To create a new top-level resource, click on the <strong>New Resource</strong><strong> </strong>icon above the tree, or use the <strong>Site&nbsp;&gt;&nbsp;New&nbsp;Resource</strong> menu item.</p>\r\n<p>&nbsp;</p>', 1, 5, 0, 1, 1, 2, 1370621761, 2, 1371137462, 0, 0, 0, 1370622516, 2, '', 0, 0, 0, 0, 0),
(15, 'document', 'text/html', 'Files vs database', 'What''s stored where', '', 'help-storage', '', 1, 0, 0, 5, 0, '', '<p>Your web pages are dynamically generated from a combination of resources, templates and elements such as chunks (shared HTML) and snippets (PHP scripts). When you create or update a resource, Clipper stores it in the database, so you will not find any set of files corresponding to your web pages. Output that will not change until the source is updated may, however, be saved in cache files, to reduce time spent looking up database records.</p>\r\n<h4>PHP</h4>\r\n<p>Output from PHP scripts is included in your resources, templates and chunks using <strong>snippet tags</strong>. The outline of the script is always stored in the database. Longer snippets use included files, stored in the assets/snippets folder.&nbsp;</p>\r\n<h4>CSS and Javascript</h4>\r\n<p>Stylesheets and Javascript files are stored as normal files, not in the database. General-purpose Javascript (such as&nbsp; the main jQuery script) is usually stored in the assets/js folder. Javascript that is specific to the Demo site is stored in its own template folder under assets/templates. CSS used in your templates is also stored there. The only CSS files bundled with Clipper are manager theme files, stored under the manager/media/style folder.</p>\r\n<h4>Images and other files</h4>\r\n<p>Images are normally stored under the assets/images folder, which is where the Manager''s file browser looks for them. The browser is preset to look for flash and media files in the relevant folders under assets, and will offer the assets/files folder as the default location for a hyperlink or for a template variable with the type "file".</p>', 1, 5, 1, 1, 1, 2, 1370621854, 1, 1370877593, 0, 0, 0, 1370622524, 2, '', 0, 0, 0, 0, 0),
(16, 'document', 'text/html', 'Templates', 'Templates', '', 'help-templates', '', 1, 0, 0, 5, 0, '', '<p>Templates are a key feature in generating web pages from Clipper resources. They provide the skeleton around which a page is built by combining a resource''s fields, variables and other data with tags in the template. Templates selectively extend the set of built-in fields available to all resources, through template variables that can be associated with them.</p>\r\n<p>The demo site includes three example templates: <strong>Home Page</strong>, <strong>Basic Template</strong> and <strong>Recipe, </strong>where Basic Template&nbsp;is the general default for the site, and Home Page and Recipe have specific extra features.</p>\r\n<p>All the templates start with the chunk { {head} }, which contains the items in common to the HEAD tag of every page, such as the HTML specification, layout of the TITLE tag, and stylesheet and Javascript links. Note the setting of the BASE tag using the <strong>site_url</strong> site variable; this makes it easy to use relative URLs and to transfer the site from one server to another. The sidebar and footer are also in common to all templates, and are read in from chunks.</p>\r\n<p>The main content area of <strong>Basic Template</strong>&nbsp;has a tag for the resource''s <strong>content</strong> field (a rich-text edit box), followed by a template variable called <strong>plain-text-section</strong>, a textarea where you can add a snippet call or plain HTML code without the risk of the rich-text editor interfering with it. (It could also be hidden from non-technical users if required). The Recipes page uses this to call the <strong>List</strong> snippet, while the Contacts page uses it for the <strong>eForm</strong> snippet.</p>\r\n<p>The <strong>Home Page</strong> template features a call to a purpose-built snippet, <strong>ShowSlides</strong>, which reads the value of a dropdown-list menu template variable [TV] and inserts the HTML code for a slideshow when it is Yes. The names of the TV and the chunk holding the slideshow code are supplied as parameters to the snippet. This TV is available only to resources using the Home Page template, so it does not clutter up the editing screen elsewhere. Using the <strong>ManagerManager</strong> plugin, it is also given its own tab in the editing pane, along with input fields for the four slideshow pictures and their captions. Rules for adjusting manager screen layout are defined in a chunk called <strong>mm_rules</strong>.</p>\r\n<p>The <strong>Recipe</strong> template is used for the individual recipes that are children of the main Recipes page. It has an image-type template variable called <strong>food-shot</strong> for the image included in the index page and in the individual recipe pages.</p>\r\n<p>When you right-click the Recipes resource in the resource tree and select <strong>Create Resource here</strong>,&nbsp; the new resource that appears has the Recipe template assigned, thanks to the setting for <strong>Automatic Template Assignment</strong> in <strong>Tools &gt; Configuration &gt; Site</strong>, where youi can choose to assign the nominated system default template (also configurable), the parent resource''s template or the template already in use for sibling items as the default template for a new resource. Advanced levels of automatic template assignment and restriction of available templates are available using both system-wide and template-specific controls.</p>', 1, 5, 2, 1, 1, 2, 1370621923, 2, 1370881906, 0, 0, 0, 1370880911, 2, '', 0, 0, 0, 0, 0),
(17, 'document', 'text/html', 'Clipper tags', 'Tags: fields, variables, placeholders', '', 'help-tags', '', 1, 0, 0, 5, 0, '', '<p>Clipper uses <strong>tags</strong> to include text into the page being generated, the source of which might be:</p>\r\n<ul>\r\n<li>resource fields, e.g. <strong>[ *pagetitle* ]</strong></li>\r\n<li>template variables (TVs), e.g.<strong> [ *sidebar-title2* ]</strong></li>\r\n<li>system settings, e.g. <strong>[ (site_name) ]&nbsp; </strong></li>\r\n<li>shared HTML chunks e.g. <strong>{ {footer} }</strong></li>\r\n<li>output of PHP snippets, e.g. <strong>[ [Wayfinder? &amp;startId=`0`] ]</strong></li>\r\n<li>a link to another resource, e.g. <strong>[ ~4~ ]</strong></li>\r\n<li>a placeholder, set by a preceding snippet, e.g. <strong>[ +email+ ]</strong></li>\r\n<li>a performance measure, such as time to generate the page, <strong>[ ^t^ ]</strong></li>\r\n</ul>\r\n<p style="margin-top: 10px;">Look through the demo site''s templates and chunks for examples of how tags are used.</p>\r\n<p style="margin-top: 10px;">A new feature in Clipper for resource field and template variable tags is <strong>cross-references</strong>. By appending <strong>@</strong> and a resource identifier to the name of a field or TV, the value of the relevant variable in the referenced resource is inserted, e.g. <strong><span style="white-space: nowrap;">[ *sidebar-title2@1* ]</span></strong>. This feature is used in the demo site''s sidebar, as defined in the <strong>{ {sidebar} }</strong> chunk.</p>\r\n<p style="margin-top: 10px;">A reminder of the syntax to indicate what kind of tag is required is included below the text-editing area in the template and chunk editing screens. It''s also available in the <strong>Syntax</strong> tab of the manager''s <strong>Help</strong> pages.</p>', 1, 5, 3, 1, 1, 2, 1370621981, 1, 1372680579, 0, 0, 0, 1371135928, 2, '', 0, 0, 0, 0, 0),
(18, 'document', 'text/html', 'Chunks', 'Sharing HTML with chunks', '', 'help-chunks', '', 1, 0, 0, 5, 0, '', '<p>A Clipper <strong>chunk</strong> is a piece of HTML code and Clipper tags which has a name and which can be inserted into pages, templates and other chunks using double-curly-brace tag markers: { {chunk&nbsp;name} }. Chunks can also be used as parameters in snippet calls, and as default text or input options for template variables.</p>\r\n<p>Chunks used in the demo site include the { {head} } section of all the templates; { {recipe-dittoTpl} }, the chunk that defines format of output from the List snippet for the top-level Recipes page; { {form-template} }. a parameter for the eForm call on the Contacts page; and { {attribution-cookipedia} }, a short piece of HTML that is inserted into the content of each recipe page.</p>', 1, 5, 4, 1, 1, 2, 1370622012, 2, 1371137817, 0, 0, 0, 1370880920, 2, '', 0, 0, 0, 0, 0),
(19, 'document', 'text/html', 'Snippets', 'Dynamic content using PHP snippets', '', 'help-snippets', '', 1, 0, 0, 5, 0, '', '<p>PHP is included in Clipper resources, templates and chunks using <strong>snippet tags</strong>, which are replaced by the text returned from the named PHP script. A number of useful snippets are bundled with Clipper, and it''s also easy to create your own. Most sites will have a use for <strong>Wayfinder</strong>, which generates menus reflecting the structure of your resources, and for <strong>List</strong>, which creates formatted index listings from fields in sets of resources. A small purpose-built snippet, <strong>ShowSlides</strong>, is used to switch the demo site''s home page slideshow on or off according to the value of a template variable.</p>\r\n<p>Snippets can have one or more <strong>parameters</strong>, set using a format similar to the query string in a URL. Parameter values are enclosed in back-apostrophes (<strong>`</strong>), and can themselves be nested snippet calls or other Clipper tags.</p>\r\n<p>Snippet tags take two forms, indicating whether they are to be <strong>[ [cached] ]</strong> (enclosed in double square brackets), when output is stored and reused after the first call until the site cache is cleared, or <strong>[ !uncached! ]</strong> (enclosed in square bracket plus exclamation mark), to be run afresh every time the page is loaded, as required by a form-handling snippet such as <strong>eForm</strong> on the Contacts page.</p>', 1, 5, 5, 1, 1, 2, 1370622092, 2, 1371137914, 0, 0, 0, 1370880927, 2, '', 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Dumping data for table `{PREFIX}site_htmlsnippets`
--


REPLACE INTO `{PREFIX}site_htmlsnippets` VALUES
(1, 'mm_rules', '(sample) Default ManagerManager rules plus Sideshow, Sidebar tab rules', 0, 3, 0, '// Uncomment this line (remove the leading ''// '') to hide longtitle if you do not use it.\r\n// mm_hideFields(''longtitle'');\r\n\r\n// Uncomment this if you use [*description*] in a description meta tag\r\n// mm_changeFieldHelp(''description'', ''Description for search engines. Optional. Leave blank if unsure''); \r\n\r\n// Uncomment the following to hide some often unused fields from all users\r\n// mm_hideFields(''log'');\r\n// mm_hideFields(''parent'');\r\n// mm_hideFields(''link_attributes'');\r\n// mm_hideFields(''which_editor'');\r\n// mm_hideFields(''is_richtext'');\r\n\r\n// Examples of changing the help text. Uncomment to use these or write your own.\r\n// mm_changeFieldHelp(''pagetitle'', ''Title of this page'');\r\n// mm_changeFieldHelp(''menutitle'', ''An optional title for this page to be used in menus. Usually shorter if used.'');\r\n\r\n// Uncomment the following to hide the fields from all but admins\r\n// mm_hideFields(''cacheable'', ''!1'');\r\n// mm_hideFields(''clear_cache'', ''!1'');\r\n// mm_hideFields(''is_folder'', ''!1'');\r\n// mm_hideFields(''content_dispo'', ''!1'');\r\n// mm_hideFields(''content_type'', ''!1'');\r\n\r\n\r\n// -----[Template Home [Slideshow]] ---- // \r\nmm_createTab(''Slideshow'', ''slideshow'', '''', ''4'', ''<p><strong>Instructions:</strong> Insert image and caption for each slide in the Home Page.</p><div class=\\"split\\"></div><br />'');\r\nmm_moveFieldsToTab(''tvshow-slideshow,tvslide-img1,tvslide-text1,tvslide-img2,tvslide-text2,tvslide-img3,tvslide-text3,tvslide-img4,tvslide-text4'', ''slideshow'');\r\n\r\n// -----[Template Home [Sidebar]] ---- // \r\nmm_createTab(''Sidebar'', ''sidebar'', '''', ''4'', ''<p><strong>Instructions:</strong> Insert title and content for each box of the sidebar.</p><div class=\\"split\\"></div><br />'');\r\nmm_moveFieldsToTab(''tvsidebar-title1,tvsidebar-text1,tvsidebar-title2,tvsidebar-text2,tvsidebar-title3,tvsidebar-text3,tvsidebar-title4,tvsidebar-text4'', ''sidebar'');\r\n', 0),
(2, 'WebLoginSideBar', 'WebLogin Tpl', 0, 2, 0, '<!-- #declare:separator <hr> -->\r\n<!-- login form section-->\r\n<form method="post" name="loginfrm" action="[+action+]">\r\n    <input type="hidden" value="[+rememberme+]" name="rememberme" />\r\n    <fieldset>\r\n        <h3>Your Login Details</h3>\r\n        <label for="username">User: <input type="text" name="username" id="username" tabindex="1" onkeypress="return webLoginEnter(document.loginfrm.password);" value="[+username+]" /></label>\r\n    	<label for="password">Password: <input type="password" name="password" id="password" tabindex="2" onkeypress="return webLoginEnter(document.loginfrm.cmdweblogin);" value="" /></label>\r\n    	<input type="checkbox" id="checkbox_1" name="checkbox_1" tabindex="3" size="1" value="" [+checkbox+] onclick="webLoginCheckRemember()" /><label for="checkbox_1" class="checkbox">Remember me</label>\r\n    	<input type="submit" value="[+logintext+]" name="cmdweblogin" class="button" />\r\n	<a href="#" onclick="webLoginShowForm(2);return false;" id="forgotpsswd">Forget Your Password?</a>\r\n	</fieldset>\r\n</form>\r\n<hr>\r\n<!-- log out hyperlink section -->\r\n<h4>You''re already logged in</h4>\r\nDo you wish to <a href="[+action+]" class="button">[+logouttext+]</a>?\r\n<hr>\r\n<!-- Password reminder form section -->\r\n<form name="loginreminder" method="post" action="[+action+]">\r\n    <fieldset>\r\n        <h3>It happens to everyone...</h3>\r\n        <input type="hidden" name="txtpwdrem" value="0" />\r\n        <label for="txtwebemail">Enter the email address of your account to reset your password: <input type="text" name="txtwebemail" id="txtwebemail" size="24" /></label>\r\n        <label>To return to the login form, press the cancel button.</label>\r\n    	<input type="submit" value="Submit" name="cmdweblogin" class="button" /> <input type="reset" value="Cancel" name="cmdcancel" onclick="webLoginShowForm(1);" class="button" style="clear:none;display:inline" />\r\n    </fieldset>\r\n</form>\r\n\r\n', 0),
('3','head','Head template [Title, meta, CSS, JS]','0','0','0','<!DOCTYPE html>\r\n<!--[if lt IE 7]>      <html class=\"no-js lt-ie9 lt-ie8 lt-ie7\"> <![endif]-->\r\n<!--[if IE 7]>         <html class=\"no-js lt-ie9 lt-ie8\"> <![endif]-->\r\n<!--[if IE 8]>         <html class=\"no-js lt-ie9\"> <![endif]-->\r\n<!--[if gt IE 8]><!--> <html class=\"no-js\"> <!--<![endif]-->\r\n<head>\r\n\r\n	<!-- [Meta] -->		\r\n	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=[(modx_charset)]\" />\r\n	<meta name=\"description\" content=\"[*description*]\">\r\n	<meta name=\"viewport\" content=\"width=device-width\">	\r\n	<!-- [/End Meta] -->	\r\n	\r\n	<title>[*pagetitle*] | [(site_name)]</title>\r\n	<base href=\"[(site_url)]\" />\r\n\r\n	<!-- [CSS] -->	\r\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"assets/templates/clipperdemo/css/foundation.css\"/>\r\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"assets/templates/clipperdemo/css/layout.css\"/>\r\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"http://fonts.googleapis.com/css?family=Merriweather+Sans\"/>\r\n	<link rel=\"shortcut icon\" href=\"assets/templates/clipperdemo/favicon.png\" />\r\n	<!-- [/End CSS] -->	\r\n	\r\n	<!-- [JavaScripts] -->    \r\n        <script src=\"[(jquery_url)]\"></script>\r\n        <script src=\"assets/templates/clipperdemo/js/javascript.js\"></script>\r\n        <script src=\"assets/templates/clipperdemo/js/settings.js\"></script>\r\n\r\n	<!--[if lt IE 9]><script src=\"http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js\"></script><![endif]-->	 \r\n	<!-- [/End JavaScripts] -->    \r\n	\r\n</head>','0'),
(4, 'header', 'Header template [Logo, Search, Menu]', 0, 8, 0, '<!-- [Header] -->\r\n<header id="header">\r\n\r\n	<!-- [Logo and Search] -->\r\n	<div class="row">\r\n		<div class="small-9 large-8 columns">\r\n			<div id="header-logo">\r\n				<a href="[~1~]">[(site_name)]</a>\r\n			</div>\r\n		</div>\r\n		<div class="small-3 large-4 columns" id="header-mobile">\r\n			<span id="header-menu-mobile">Show/Hide Menu</span>\r\n			<span id="header-search-mobile">Search</span>\r\n		</div>			\r\n		<div class="small-3 large-4 columns" id="header-search">\r\n			<div id="header-search-form">\r\n				[!AjaxSearch? \r\n           				&ajaxSearch=`0` \r\n           				&showResults=`0` \r\n           				&landingPage=`7` \r\n           				&showIntro=`0` \r\n           				&tplInput=`ajaxsearch` \r\n           				&language=`english` \r\n                		!]\r\n			</div>	\r\n		</div>	\r\n	</div>	\r\n	<!-- [/End Logo and Search] -->	\r\n	\r\n	<!-- [Header Menu] -->\r\n	<div class="row" id="header-menu">\r\n		<div class="small-12 columns">\r\n			<nav>\r\n				[[Wayfinder? \r\n					&startId=`0` \r\n					&level=`2` 			\r\n					&sortBy=`menuindex`\r\n					&sortOrder=`ASC`\r\n				]]\r\n			</nav>\r\n		</div>\r\n	</div>	\r\n	<!-- [/End Header Menu] -->\r\n	\r\n</header>\r\n<!-- [/End Header] -->', 0),
(5, 'footer', 'Footer template', 0, 8, 0, '<!-- [Footer] -->\r\n<footer id="footer">\r\n	<div class="row">\r\n		<div class="large-12 columns">\r\n			 &copy; Powered by <a href="http://www.clippercms.com" target="_blank">ClipperCMS</a>\r\n		</div>	\r\n	</div>\r\n</footer>\r\n<!-- [/End Footer] -->', 0),
(6, 'ajaxsearch', 'AjaxSearch template', 0, 8, 0, '[+as.showInputForm:is=`1`:then=`\r\n		<!-- [Search Form] -->\r\n		<form id="[+as.formId+]" action="[+as.formAction+]" method="post">\r\n\r\n			<input type="hidden" name="advSearch" value="[+as.advSearch+]" />\r\n			<input type="text" name="search" value="" placeholder="Search..." [+as.inputOptions+] />\r\n			<input type="submit" name="sub" value="" />\r\n			 \r\n		</form>\r\n		<!-- [/End Search Form] -->\r\n`+]\r\n[+as.showIntro:is=`1`:then=`\r\n<p class="ajaxSearch_intro" id="ajaxSearch_intro">[+as.introMessage+]</p>\r\n`+]', 0),
(7, 'slideshow', 'Slideshow template', 0, 8, 0, '<!-- [Slideshow] -->\r\n<div class="row" id="slideshow">\r\n	<div class="small-12 columns">\r\n		<ul>\r\n			<li>\r\n				<img src="[*slide-img1*]" alt="#">\r\n				<div class="slideshow-caption">[*slide-text1*]</div>\r\n			</li>\r\n			<li>\r\n				<img src="[*slide-img2*]" alt="#">\r\n				<div class="slideshow-caption">[*slide-text2*]</div>\r\n			</li>\r\n			<li>\r\n				<img src="[*slide-img3*]" alt="#">\r\n				<div class="slideshow-caption">[*slide-text3*]</div>\r\n			</li>\r\n			<li>\r\n				<img src="[*slide-img4*]" alt="#">\r\n				<div class="slideshow-caption">[*slide-text4*]</div>\r\n			</li>		\r\n		</ul>\r\n	</div>\r\n</div>\r\n<!-- [/End Slideshow] -->', 0),
(8, 'default-list', 'Show a list of second-level content', 0, 8, 0, '<!-- [Default List] -->\r\n<div class="default-list">\r\n	<h2><a href="[+url+]">[+longtitle+]</a></h2>\r\n	<p>[+introtext+]</p>\r\n</div>\r\n', 0),
(9, 'sidebar', 'Sidebar template', 0, 8, 0, '	<!-- [Sidebar] -->\r\n	<aside class="large-4 columns" id="sidebar">\r\n\r\n		[[Wayfinder? \r\n			&startId=`[[UltimateParent? &topLevel=`1`]]` \r\n			&displayStart=`0`\r\n			&level=`1` 			\r\n			&sortBy=`menuindex`\r\n			&sortOrder=`ASC`\r\n			&outerTpl=`wayfinder-sidebar-outerTpl`\r\n		]]\r\n	\r\n		<div class="sidebar-box">\r\n			<h3>[*sidebar-title1@1*]</h3>\r\n			[*sidebar-text1@1*]\r\n		</div>\r\n	\r\n		<div class="sidebar-box">\r\n			<h3>[*sidebar-title2@1*]</h3>\r\n			[*sidebar-text2@1*]\r\n		</div>\r\n	\r\n		<div class="sidebar-box">\r\n			<h3>[*sidebar-title3@1*]</h3>\r\n			[*sidebar-text3@1*]\r\n		</div>\r\n		<div class="sidebar-box">\r\n			<h3>[*sidebar-title4@1*]</h3>\r\n			[*sidebar-text4@1*]\r\n		</div>		\r\n	</aside>\r\n	<!-- [/End Sidebar] -->	', 0),
(10, 'form-template', 'Form template', 0, 6, 0, '<!-- [Form] -->	\r\n[+validationmessage+]\r\n<form method="post" action="[~[*id*]~]" name="contactform" id="contactform">\r\n	<fieldset>\r\n		<legend>Contact Form</legend>\r\n				\r\n		<div class="contactform">\r\n			<label>Name</label>					\r\n			<input type="text" maxlength="60" class="required-name" placeholder="Name*" name="name" eform="Name:string:1" />			\r\n		</div>\r\n\r\n		<div class="contactform">				\r\n			<label>Email</label>	\r\n			<input type="text" maxlength="60" class="required-email" placeholder="Email*" name="email" eform="Email:email:1" />						\r\n		</div>\r\n\r\n		<div class="contactform">				\r\n			<label>Subject</label>	\r\n			<input type="text" maxlength="60" class="required-subject" placeholder="Subject*" name="subjected" eform="Subject:string:1" />					\r\n		</div>\r\n\r\n		<div class="contactform-textarea">				\r\n			<label>Text</label>	\r\n			<textarea class="required-text" placeholder="Message*" name="message" eform="Message:string:1"></textarea>\r\n		</div>	\r\n			\r\n		<input type="submit" class="button small" name="submit" value="Send" />\r\n			\r\n	</fieldset>\r\n</form>				\r\n<!-- [/End Form] -->', 0),
(11, 'wayfinder-sidebar-outerTpl', 'Wayfinder outer template', 0, 8, 0, '		<div class="sidebar-box">\r\n			<h3>[*menutitle@ultimateparent*]</h3>\r\n			<ul>\r\n				[+wf.wrapper+]\r\n			</ul>\r\n		</div>', 0),
(12, 'form-report', 'Form report template', 0, 6, 0, '<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td align="center" valign="top" style="background: #FFF; padding: 20px 0 0;">\r\n\r\n<table width="100%" height="236" border="0" style="border: 1px solid #DDD; font-family: Arial; font-size: 14px; max-width: 650px; border-collapse:collapse;" >\r\n	<tr valign="top">\r\n	  <td colspan="3" valign="middle" bgcolor="#333">\r\n		<p style="color: #FFF; padding: 0 10px 0;">This is an email from <strong style="color:white;">[+name+]</strong>.  The details are as follows:</p>\r\n	  </td>\r\n	</tr>\r\n	<tr valign="top">\r\n	  <td height="43" width="23" valign="middle" bgcolor="#F0F0F0">&nbsp;</td>\r\n	  <td height="43" width="122" valign="middle" bgcolor="#F0F0F0">Name:</td>\r\n	  <td width="1053" valign="middle" bgcolor="#F0F0F0">[+name+]</td>\r\n	</tr>\r\n	<tr valign="top">\r\n	  <td height="43" valign="middle">&nbsp;</td>\r\n	  <td height="43" valign="middle">Email:</td>\r\n	  <td height="43" valign="middle">[+email+]</td>\r\n	</tr>\r\n	<tr valign="top">\r\n	  <td height="43" valign="middle" bgcolor="#F0F0F0">&nbsp;</td>\r\n	  <td height="43" valign="middle" bgcolor="#F0F0F0">Subject:</td>\r\n	  <td height="43" valign="middle" bgcolor="#F0F0F0">[+subjected+]</td>\r\n	</tr>\r\n	<tr valign="top">\r\n	  <td height="43" valign="middle">&nbsp;</td>\r\n	  <td height="43" valign="middle">Message:</td>\r\n	  <td height="43" valign="middle" >[+message+]</td>\r\n	</tr>\r\n</table>\r\n\r\n<table width="100%" border="0" style="font-family: Arial; font-size: 14px; max-width: 650px; border-collapse:collapse;" >\r\n	<tr valign="top">\r\n	  <td height="43" valign="middle">\r\n	    <p style="text-align: left;">Reply here: <a href="mailto:[+email+]?subject=RE:[+subjected+]">[+email+]</a></p>\r\n	  </td>\r\n	</tr>\r\n</table>\r\n\r\n</td></tr></table>', 0),
(13, 'attribution-cookipedia', 'Creative Commons attribution', 0, 1, 0, '<p id="cc-licence"><a href="http://creativecommons.org/licenses/by-sa/3.0/"><img src="assets/images/recipes/cc-by-sa.png" alt="Creative Commons" /></a> Based on material from <a href="http://www.cookipedia.co.uk">Cookipedia</a></p>\r\n', 0),
(14, 'recipe-ListTpl', 'Index listing template for recipes', 0, 1, 0, '<article class="row">\r\n    <div class="small-7 large-8 columns recipe-right">\r\n        <h3><a href="[+url+]">[+longtitle+]</a></h3>\r\n        <p>[+introtext+]</p>\r\n    </div>\r\n    <div class="small-5 large-4 columns recipe-left">\r\n        <a href="[+url+]">[+food-shot+]</a>\r\n    </div>\r\n</article>\r\n', 0),
(15, 'help-page-ListTpl', 'Index listing template for Help page articles', 0, 1, 0, '<article class="row">\r\n    <div class="small-12 columns">\r\n        <h3><a href="[+url+]">[+longtitle+]</a></h3>\r\n        [+summary+] <div><a href="[+url+]" class="button">Read More</a></div>\r\n    </div>\r\n</article>\r\n', 0);

--
-- Dumping data for table `{PREFIX}site_plugins`
--


REPLACE INTO `{PREFIX}site_plugins` VALUES
(7, 'Brackify', 'Remove extra space between tag brackets (inserted to prevent parsing)', 0, 3, 0, '// <?php // Note PHP tag in comment to help editing; plugins don''t have an active PHP tag.\r\n\r\n// Brackify\r\n// Plugin to remove extra space added between tag brackets\r\n// (there to prevent tags being parsed)\r\n// Use with OnWebPagePrerender system event checked\r\n\r\n$e = &$modx->Event;\r\nif ($e->name == "OnWebPagePrerender"){\r\n    $page = $modx->documentOutput;\r\n    $brackets = ''[ (,) ],{ {,} },[ [,] ],[ !,! ],[ +,+ ],[ *,* ],[ ^,^ ],[ ~,~ ]'' ;\r\n    $despaced = str_replace('' '','''',$brackets);\r\n    $search = explode('','',$brackets);\r\n    $replace = explode ('','',$despaced);\r\n    $page = str_replace($search,$replace,$page);\r\n    $modx->documentOutput = $page;\r\n}\r\n', 0, '', 0, ' ');

--
-- Dumping data for table `{PREFIX}site_plugin_events`
--


REPLACE INTO `{PREFIX}site_plugin_events` VALUES
(7, 3, 1);

--
-- Dumping data for table `{PREFIX}site_templates`
--


REPLACE INTO `{PREFIX}site_templates` VALUES
(3, 'Minimal Template', 'Default minimal empty template (content returned only)', 0, 0, '', 0, '[*content*]', 0, 0, '', 0),
(4, 'Home Page', 'Home Page template', 0, 8, '', 0, '{{head}}\r\n<body>\r\n\r\n{{header}}\r\n[[ShowSlides? &switch=`[*show-slideshow*]` &chunk=`slideshow`]]\r\n\r\n<!-- [Content] -->\r\n<div class="row" id="content">\r\n\r\n	<!-- [Text] -->\r\n	<div class="large-8 columns" id="text">\r\n		<h1>[*longtitle*]</h1>\r\n		[*content*]\r\n                [*plain-text-section*]\r\n	</div>\r\n	<!-- [/End Text] -->	\r\n\r\n	{{sidebar}}\r\n	\r\n</div>\r\n<!-- [/End Content] -->\r\n\r\n{{footer}}\r\n\r\n</body>\r\n</html>', 0, 0, '0', 0),
(5, 'Basic Template', 'Default template', 0, 8, '', 0, '{{head}}\r\n<body>\r\n\r\n{{header}}\r\n\r\n<!-- [Content] -->\r\n<div class="row" id="content">\r\n\r\n	<!-- [Text] -->\r\n	<div class="large-8 columns" id="text">\r\n		<h1>[*longtitle*]</h1>\r\n		[*content*]\r\n                [*plain-text-section*]\r\n	</div>\r\n	<!-- [/End Text] -->	\r\n\r\n	{{sidebar}}\r\n	\r\n</div>\r\n<!-- [/End Content] -->\r\n\r\n{{footer}}\r\n\r\n</body>\r\n</html>', 0, 0, '0', 0),
(6, 'Recipe Template', 'Recipe template', 0, 8, '', 0, '{{head}}\r\n<body>\r\n\r\n{{header}}\r\n\r\n<!-- [Content] -->\r\n<div class="row" id="content">\r\n\r\n	<!-- [Text] -->\r\n	<div class="large-8 columns" id="text">\r\n		<h1>[*longtitle*]</h1>\r\n		[*content*]\r\n                [*plain-text-section*] \r\n	</div>\r\n	<!-- [/End Text] -->	\r\n\r\n	{{sidebar}}\r\n	\r\n</div>\r\n<!-- [/End Content] -->\r\n\r\n{{footer}}\r\n\r\n</body>\r\n</html>', 0, 0, '0', 0);

--
-- Dumping data for table `{PREFIX}site_tmplvars`
--


REPLACE INTO `{PREFIX}site_tmplvars` VALUES
(1, 'image', 'slide-img1', 'Insert image', '', 0, 8, 0, '', 0, '', '', ''),
(2, 'image', 'slide-img2', 'Insert image', '', 0, 8, 0, '', 0, '', '', ''),
(3, 'image', 'slide-img3', 'Insert image', '', 0, 8, 0, '', 0, '', '', ''),
(4, 'image', 'slide-img4', 'Insert image', '', 0, 8, 0, '', 0, '', '', ''),
(5, 'richtext', 'slide-text1', 'Insert caption', '', 0, 8, 0, '', 0, '', '', ''),
(6, 'richtext', 'slide-text2', 'Insert caption', '', 0, 8, 0, '', 0, '', '', ''),
(7, 'richtext', 'slide-text3', 'Insert caption', '', 0, 8, 0, '', 0, '', '', ''),
(8, 'richtext', 'slide-text4', 'Insert caption', '', 0, 8, 0, '', 0, '', '', ''),
(9, 'dropdown', 'show-slideshow', 'Show Slideshow?', '', 0, 8, 0, 'Yes==1||No==0', 0, '', '', ''),
(10, 'text', 'sidebar-title1', 'Sidebar Title', '', 0, 8, 0, '', 0, '', '', ''),
(11, 'text', 'sidebar-title2', 'Sidebar Title', '', 0, 8, 0, '', 0, '', '', ''),
(12, 'text', 'sidebar-title3', 'Sidebar Title', '', 0, 8, 0, '', 0, '', '', ''),
(13, 'text', 'sidebar-title4', 'Sidebar Title', '', 0, 8, 0, '', 0, '', '', ''),
(14, 'richtext', 'sidebar-text1', 'Sidebar Content', '', 0, 8, 0, '', 0, '', '', ''),
(15, 'richtext', 'sidebar-text2', 'Sidebar Content', '', 0, 8, 0, '', 0, '', '', ''),
(16, 'richtext', 'sidebar-text3', 'Sidebar Content', '', 0, 8, 0, '', 0, '', '', ''),
(17, 'richtext', 'sidebar-text4', 'Sidebar Content', '', 0, 8, 0, '', 0, '', '', ''),
(18, 'image', 'food-shot', 'Photo', 'Picture to accompany recipe', 0, 1, 0, '', 0, 'image', '&alttext=[*pagetitle*]&align=none&class=food-shot', ''),
(19, 'textarea', 'plain-text-section', 'Plain text second section', 'Plain text section to follow Content', 0, 1, 0, '', 0, '', '', '');

--
-- Dumping data for table `{PREFIX}site_tmplvar_contentvalues`
--


REPLACE INTO `{PREFIX}site_tmplvar_contentvalues` VALUES
(2, 2, 1, 'assets/images/slide/2.jpg'),
(3, 3, 1, 'assets/images/slide/3.jpg'),
(4, 4, 1, 'assets/images/slide/4.jpg'),
(5, 5, 1, '<p>Photo1, by <a href="http://www.freerangestock.com" target="_blank">Freerangestock.com</a></p>'),
(6, 6, 1, '<p>Photo2, by <a href="http://www.freerangestock.com" target="_blank">Freerangestock.com</a></p>'),
(7, 7, 1, '<p>Photo3, by <a href="http://www.freerangestock.com" target="_blank">Freerangestock.com</a></p>'),
(8, 8, 1, '<p>Photo4, by <a href="http://www.freerangestock.com" target="_blank">Freerangestock.com</a></p>'),
(9, 9, 1, '1'),
(10, 1, 1, 'assets/images/slide/1.jpg'),
(11, 10, 1, 'External Links'),
(12, 11, 1, 'Manager login'),
(13, 12, 1, 'About ClipperCMS'),
(14, 13, 1, 'Feedback'),
(15, 14, 1, '<ul>\r\n<li><a href="http://www.clippercms.com/download/current-release.html" target="_blank">Download Clipper</a></li>\r\n<li><a href="http://www.clippercms.com/forum/" target="_blank">Community Forums</a></li>\r\n<li><a href="http://www.clippercms.com/documentation" target="_blank">Documentation</a></li>\r\n</ul>'),
(16, 15, 1, '<p><a href="[(site_url)]manager/" target="_blank">Click here</a> to login to your <strong>[(site_name)]</strong> administration panel.</p>'),
(17, 16, 1, '<p>Clipper is a flexible and powerful open source content management system released under the GPL license, you can use this web software to build websites, personal blogs and also complex and dynamic applications.</p>'),
(18, 17, 1, '<p>We would really appreciate your feedback regarding Clipper, as this would help us improve the system. Feel free to contact us <a href="mailto:hello@clippercms.org?subject=ClipperCMS%20Feedback%20(demo%20website)">by email</a> or let us know your impressions and suggestions directly on <a href="http://www.clippercms.com/forum/" target="_blank">Clipper forum</a>.</p>'),
(19, 18, 11, 'assets/images/recipes/300px-Lamb_hot_pot_recipe.jpg'),
(20, 18, 12, 'assets/images/recipes/300px-Baked_aubergines_with_tomatoes_and_Parmesan_recipe.jpg'),
(21, 18, 13, 'assets/images/recipes/300px-Borscht_recipe.jpg'),
(22, 19, 5, '<div id="help-pages">\r\n[[List? \r\n    &tpl=`help-page-ListTpl` \r\n    &orderBy=`menuindex ASC`\r\n    &extenders=`summary` \r\n]]\r\n</div>'),
(23, 19, 3, '<div id="recipes">\r\n[[List? \r\n    &display=`4` \r\n    &depth=`0` \r\n    &tpl=`recipe-ListTpl` \r\n    &orderBy=`menuindex ASC` \r\n    &showInMenuOnly=`1` \r\n    &noResults=` `\r\n]]\r\n</div>'),
(24, 19, 6, '[!eForm? \r\n	&formid=`contactform` \r\n	&tpl=`form-template` \r\n	&report=`form-report` \r\n	&language=`english` \r\n	&from=`((email))` \r\n	&to=`[(emailsender)]`\r\n	&subject=`Contact Form | [(site_name)]` \r\n	&gotoid=`10`  \r\n!]');

--
-- Dumping data for table `{PREFIX}site_tmplvar_templates`
--


REPLACE INTO `{PREFIX}site_tmplvar_templates` VALUES
(1, 4, 0),
(2, 4, 0),
(3, 4, 0),
(4, 4, 0),
(5, 4, 0),
(6, 4, 0),
(7, 4, 0),
(8, 4, 0),
(9, 4, 0),
(10, 4, 0),
(11, 4, 0),
(12, 4, 0),
(13, 4, 0),
(14, 4, 0),
(15, 4, 0),
(16, 4, 0),
(17, 4, 0),
(18, 6, 0),
(19, 4, 0),
(19, 5, 0),
(19, 6, 0);

-- Update ManagerManager rules setting


UPDATE `{PREFIX}site_plugins` 
SET properties = '&config_chunk=Configuration Chunk;text;mm_rules; &which_jquery=jQuery source;list;local (assets/js),remote (google code),manual url (specify below);local (assets/js) &js_src_type=jQuery URL override;text;' 
WHERE name = 'ManagerManager';

