SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `clipper133`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]active_users`
--

CREATE TABLE `[[dbprefix]]active_users` (
  `internalKey` int(9) NOT NULL DEFAULT '0',
  `username` varchar(50) NOT NULL DEFAULT '',
  `lasthit` int(20) NOT NULL DEFAULT '0',
  `id` int(10) DEFAULT NULL,
  `action` varchar(10) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`internalKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data about active users.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Categories to be used snippets,tv,chunks, etc' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 'Demo Content'),
(2, 'Manager and Admin'),
(3, 'Search'),
(4, 'Content'),
(5, 'Forms'),
(6, 'Login'),
(7, 'Navigation');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]documentgroup_names`
--

CREATE TABLE `[[dbprefix]]documentgroup_names` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `private_memgroup` tinyint(4) DEFAULT '0' COMMENT 'determine whether the document group is private to manager users',
  `private_webgroup` tinyint(4) DEFAULT '0' COMMENT 'determines whether the document is private to web users',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]document_groups`
--

CREATE TABLE `[[dbprefix]]document_groups` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `document_group` int(10) NOT NULL DEFAULT '0',
  `document` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `document` (`document`),
  KEY `document_group` (`document_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event_log`
--

CREATE TABLE `[[dbprefix]]event_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eventid` int(11) DEFAULT '0',
  `createdon` int(11) NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1- information, 2 - warning, 3- error',
  `user` int(11) NOT NULL DEFAULT '0' COMMENT 'link to user table',
  `usertype` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 - manager, 1 - web',
  `source` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores event and error logs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manager_log`
--

CREATE TABLE `[[dbprefix]]manager_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `timestamp` int(20) NOT NULL DEFAULT '0',
  `internalKey` int(10) NOT NULL DEFAULT '0',
  `username` varchar(255) DEFAULT NULL,
  `action` int(10) NOT NULL DEFAULT '0',
  `itemid` varchar(10) DEFAULT '0',
  `itemname` varchar(255) DEFAULT NULL,
  `message` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains a record of user interaction.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manager_users`
--

CREATE TABLE `[[dbprefix]]manager_users` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '',
  `hashtype` smallint(6) NOT NULL DEFAULT '0',
  `salt` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains login information for backend users.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]manager_users`
--

INSERT INTO `[[dbprefix]]manager_users` VALUES
(1, '[[admin_username]]', 1, '[[salt]]', '[[admin_pass]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]membergroup_access`
--

CREATE TABLE `[[dbprefix]]membergroup_access` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `membergroup` int(10) NOT NULL DEFAULT '0',
  `documentgroup` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]membergroup_names`
--

CREATE TABLE `[[dbprefix]]membergroup_names` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]member_groups`
--

CREATE TABLE `[[dbprefix]]member_groups` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_group` int(10) NOT NULL DEFAULT '0',
  `member` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_group_member` (`user_group`,`member`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_content`
--

CREATE TABLE `[[dbprefix]]site_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL DEFAULT 'document',
  `contentType` varchar(50) NOT NULL DEFAULT 'text/html',
  `pagetitle` varchar(255) NOT NULL DEFAULT '',
  `longtitle` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) DEFAULT '',
  `link_attributes` varchar(255) NOT NULL DEFAULT '',
  `published` int(1) NOT NULL DEFAULT '0',
  `pub_date` int(20) NOT NULL DEFAULT '0',
  `unpub_date` int(20) NOT NULL DEFAULT '0',
  `parent` int(10) NOT NULL DEFAULT '0',
  `isfolder` int(1) NOT NULL DEFAULT '0',
  `introtext` text COMMENT 'Used to provide quick summary of the document',
  `content` mediumtext,
  `richtext` tinyint(1) NOT NULL DEFAULT '1',
  `template` int(10) NOT NULL DEFAULT '1',
  `menuindex` int(10) NOT NULL DEFAULT '0',
  `searchable` int(1) NOT NULL DEFAULT '1',
  `cacheable` int(1) NOT NULL DEFAULT '1',
  `createdby` int(10) NOT NULL DEFAULT '0',
  `createdon` int(20) NOT NULL DEFAULT '0',
  `editedby` int(10) NOT NULL DEFAULT '0',
  `editedon` int(20) NOT NULL DEFAULT '0',
  `deleted` int(1) NOT NULL DEFAULT '0',
  `deletedon` int(20) NOT NULL DEFAULT '0',
  `deletedby` int(10) NOT NULL DEFAULT '0',
  `publishedon` int(20) NOT NULL DEFAULT '0',
  `publishedby` int(10) NOT NULL DEFAULT '0',
  `menutitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'Menu title',
  `donthit` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Disable page hit count',
  `privateweb` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Private web document',
  `privatemgr` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Private manager document',
  `content_dispo` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-inline, 1-attachment',
  `hidemenu` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Hide document from menu',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `parent` (`parent`),
  KEY `aliasidx` (`alias`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the site document tree.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]site_content`
--

INSERT INTO `[[dbprefix]]site_content` VALUES
(1, 'document', 'text/html', 'ClipperCMS Install Success', 'Welcome to the Clipper Content Management System', '', 'minimal-base', '', 1, 0, 0, 0, 0, '', '<h3>Install Successful!</h3>\r\n<p>You have successfully installed ClipperCMS.</p>\r\n\r\n<h3>Getting Help</h3>\r\n<p>The <a href="http://clippercms.com/forum/" target="_blank">ClipperCMS Community</a> provides a great starting point to learn all things Clipper, or you can visit the documentation pages on <a href="http://www.clippercms.com/documentation/construction.html">site construction</a> for a quick-start guide to building a website with Clipper.</p>\r\n<p>Welcome to ClipperCMS!</p>\r\n', 1, 3, 0, 1, 1, 1, 1130304721, 1, 1130304927, 0, 0, 0, 1130304721, 1, 'Base Install', 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_htmlsnippets`
--

CREATE TABLE `[[dbprefix]]site_htmlsnippets` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT 'Chunk',
  `editor_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-plain text,1-rich text,2-code editor',
  `category` int(11) NOT NULL DEFAULT '0' COMMENT 'category id',
  `cache_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Cache option',
  `snippet` mediumtext,
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the site chunks.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]site_htmlsnippets`
--

INSERT INTO `[[dbprefix]]site_htmlsnippets` VALUES
(1, 'mm_demo_rules', 'Default ManagerManager rules. Should be modified for your own sites.', 0, 1, 0, '// Uncomment this line (remove the leading ''// '') to hide longtitle if you do not use it.\n// mm_hideFields(''longtitle'');\n\n// Uncomment this if you use [*description*] in a description meta tag\n// mm_changeFieldHelp(''description'', ''Description for search engines. Optional. Leave blank if unsure''); \n\n// Uncomment the following to hide some often unused fields from all users\n// mm_hideFields(''log'');\n// mm_hideFields(''parent'');\n// mm_hideFields(''link_attributes'');\n// mm_hideFields(''which_editor'');\n// mm_hideFields(''is_richtext'');\n\n// Examples of changing the help text. Uncomment to use these or write your own.\n// mm_changeFieldHelp(''pagetitle'', ''Title of this page'');\n// mm_changeFieldHelp(''menutitle'', ''An optional title for this page to be used in menus. Usually shorter if used.'');\n\n// Uncomment the following to hide the fields from all but admins\n// mm_hideFields(''cacheable'', ''!1'');\n// mm_hideFields(''clear_cache'', ''!1'');\n// mm_hideFields(''is_folder'', ''!1'');\n// mm_hideFields(''content_dispo'', ''!1'');\n// mm_hideFields(''content_type'', ''!1'');\n\n\n', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_modules`
--

CREATE TABLE `[[dbprefix]]site_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '0',
  `editor_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-plain text,1-rich text,2-code editor',
  `disabled` tinyint(4) NOT NULL DEFAULT '0',
  `category` int(11) NOT NULL DEFAULT '0' COMMENT 'category id',
  `wrap` tinyint(4) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT 'url to module icon',
  `enable_resource` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'enables the resource file feature',
  `resourcefile` varchar(255) NOT NULL DEFAULT '' COMMENT 'a physical link to a resource file',
  `createdon` int(11) NOT NULL DEFAULT '0',
  `editedon` int(11) NOT NULL DEFAULT '0',
  `guid` varchar(32) NOT NULL DEFAULT '' COMMENT 'globally unique identifier',
  `enable_sharedparams` tinyint(4) NOT NULL DEFAULT '0',
  `properties` text,
  `modulecode` mediumtext COMMENT 'module boot up code',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Site Modules' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]site_modules`
--

INSERT INTO `[[dbprefix]]site_modules` VALUES
(1, 'Res Manager', '<strong>1.1</strong> Quickly perform bulk updates to the Documents in your site including templates, publishing details, and permissions', 0, 0, 2, 0, 0, '', 0, '', 0, 0, '', 1, '', 'include_once(MODX_BASE_PATH.''assets/modules/resmanager/classes/resmanager.class.php'');\ninclude_once(MODX_BASE_PATH.''assets/modules/resmanager/classes/rm_frontend.class.php'');\ninclude_once(MODX_BASE_PATH.''assets/modules/resmanager/classes/rm_backend.class.php'');\n\n$rm = new ResManager($modx);\n$rmf = new ResManagerFrontend($rm, $modx);\n$rmb = new ResManagerBackend($rm, $modx);\n\n$rm->ph = $rm->getLang();\n$rm->ph[''theme''] = $rm->getTheme();\n$rm->ph[''ajax.endpoint''] = MODX_SITE_URL.''assets/modules/resmanager/tv.ajax.php'';\n$rm->ph[''datepicker.year_range''] = $modx->config[''datepicker_year_range''];\n$rm->ph[''date.format''] = $modx->config[''date_format''];\n$rm->ph[''time.format''] = $modx->config[''time_format''];\n\n$rm->ph[''style.css''] = '''';\nif (is_file(MODX_MANAGER_PATH."media/style/$manager_theme/style.css")) {\n    $rm->ph[''style.css''] = ''<link rel="stylesheet" href="media/style/''.$manager_theme."/style.css\\" />\\n";\n}\n\n$rm->ph[''manager.css''] = '''';\nif (is_file(MODX_MANAGER_PATH."media/style/$manager_theme/manager.css")) {\n    $rm->ph[''manager.css''] =  ''<link rel="stylesheet" href="media/style/''.$manager_theme."/manager.css\\" />\\n";\n}\n\n$rm->ph[''jquery''] = $modx->getJqueryTag();\n$rm->ph[''jquery.ui''] = $modx->getJqueryPluginTag(''jquery-ui-custom-clippermanager'', ''jquery-ui-custom-clippermanager.min.js'');\n$rm->ph[''jquery.timepicker''] =$modx->getJqueryPluginTag(''jquery-ui-timepicker'', ''jquery-ui-timepicker-addon.js'');\n\nif (isset($_POST[''tabAction''])) {\n\n    $rmb->handlePostback();\n} else {\n\n    $rmf->getViews();\n    echo $rm->parseTemplate(''main.tpl'', $rm->ph);\n}\n');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_module_access`
--

CREATE TABLE `[[dbprefix]]site_module_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` int(11) NOT NULL DEFAULT '0',
  `usergroup` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Module users group access permission' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_module_depobj`
--

CREATE TABLE `[[dbprefix]]site_module_depobj` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` int(11) NOT NULL DEFAULT '0',
  `resource` int(11) NOT NULL DEFAULT '0',
  `type` int(2) NOT NULL DEFAULT '0' COMMENT '10-chunks, 20-docs, 30-plugins, 40-snips, 50-tpls, 60-tvs',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Module Dependencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_plugins`
--

CREATE TABLE `[[dbprefix]]site_plugins` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT 'Plugin',
  `editor_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-plain text,1-rich text,2-code editor',
  `category` int(11) NOT NULL DEFAULT '0' COMMENT 'category id',
  `cache_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Cache option',
  `plugincode` mediumtext,
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `properties` text,
  `disabled` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Disables the plugin',
  `moduleguid` varchar(32) NOT NULL DEFAULT '' COMMENT 'GUID of module from which to import shared parameters',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the site plugins.' AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]site_plugins`
--

INSERT INTO `[[dbprefix]]site_plugins` VALUES
(1, 'ManagerManager', '<strong>clipper-0.3.13</strong> Customize the MODx Manager to offer bespoke admin functions for end users.', 0, 2, 0, '// You can put your ManagerManager rules EITHER in a chunk OR in an external file - whichever suits your development style the best\n\n// To use an external file, put your rules in /assets/plugins/managermanager/mm_rules.inc.php \n// (you can rename default.mm_rules.inc.php and use it as an example)\n// The chunk SHOULD have php opening tags at the beginning and end\n\n// If you want to put your rules in a chunk (so you can edit them through the Manager),\n// create the chunk, and enter its name in the configuration tab.\n// The chunk should NOT have php tags at the beginning or end\n\n// You don''t need to change anything else from here onwards\n//-------------------------------------------------------\n\n// Run the main code\n$asset_path = $modx->config[''base_path''] . ''assets/plugins/managermanager/mm.inc.php'';\ninclude($asset_path);\n', 0, '&config_chunk=Configuration Chunk;text;mm_demo_rules; &which_jquery=jQuery source;list;local (assets/js),remote (google code),manual url (specify below);local (assets/js) &js_src_type=jQuery URL override;text;', 0, ''),
(2, 'Search Highlight', '<strong>clipper-1.5.1</strong> Used with AjaxSearch to show search terms highlighted on page linked from search results', 0, 3, 0, '/*\n  ------------------------------------------------------------------------\n  Plugin: Search_Highlight clipper-v1.5.1\n  ------------------------------------------------------------------------\n  Changes:\n  18/03/10 - Remove possibility of XSS attempts being passed in the URL\n           - look-behind assertion improved\n  29/03/09 - Removed urldecode calls;\n           - Added check for magic quotes - if set, remove slashes\n           - Highlights terms searched for when target is a HTML entity\n  18/07/08 - advSearch parameter and pcre modifier added\n  10/02/08 - Strip_tags added to avoid sql injection and XSS. Use of $_REQUEST\n  01/03/07 - Added fies/updates from forum from users mikkelwe/identity\n  (better highlight replacement, additional div around term/removal message)\n  ------------------------------------------------------------------------\n  Description: When a user clicks on the link from the AjaxSearch results\n    the target page will have the terms highlighted.\n  ------------------------------------------------------------------------\n  Created By:  Susan Ottwell (sottwell@sottwell.com)\n               Kyle Jaebker (kjaebker@muddydogpaws.com)\n\n  Refactored by Coroico (www.modx.wangba.fr) and TS\n  ------------------------------------------------------------------------\n  Based off the the code by Susan Ottwell (www.sottwell.com)\n    http://modxcms.com/forums/index.php/topic,1237.0.html\n  ------------------------------------------------------------------------\n  CSS:\n    The classes used for the highlighting are the same as the AjaxSearch\n  ------------------------------------------------------------------------\n  Notes:\n    To add a link to remove the highlighting and to show the searchterms\n    put the following on your page where you would like this to appear:\n\n      <!--search_terms-->\n\n    Example output for this:\n\n      Search Terms: the, template\n      Remove Highlighting\n\n    Set the following variables to change the text:\n\n      $termText - the text before the search terms\n      $removeText - the text for the remove link\n  ------------------------------------------------------------------------\n*/\nglobal $database_connection_charset;\n// Conversion code name between html page character encoding and Mysql character encoding\n// Some others conversions should be added if needed. Otherwise Page charset = Database charset\n$pageCharset = array(\n  ''utf8'' => ''UTF-8'',\n  ''latin1'' => ''ISO-8859-1'',\n  ''latin2'' => ''ISO-8859-2''\n);\n\nif (isset($_REQUEST[''searched'']) && isset($_REQUEST[''highlight''])) {\n\n  // Set these to customize the text for the highlighting key\n  // --------------------------------------------------------\n     $termText = ''<div class="searchTerms">Search Terms: '';\n     $removeText = ''Remove Highlighting'';\n  // --------------------------------------------------------\n\n  $highlightText = $termText;\n  $advsearch = ''oneword'';\n\n  $dbCharset = $database_connection_charset;\n  $pgCharset = array_key_exists($dbCharset,$pageCharset) ? $pageCharset[$dbCharset] : $dbCharset;\n\n  // magic quotes check\n  if (get_magic_quotes_gpc()){\n    $searched = $modx->stripTags(stripslashes($_REQUEST[''searched'']));\n    $highlight = $modx->stripTags(stripslashes($_REQUEST[''highlight'']));\n    if (isset($_REQUEST[''advsearch''])) $advsearch = $modx->stripTags(stripslashes($_REQUEST[''advsearch'']));\n  }\n  else {\n    $searched = $modx->stripTags($_REQUEST[''searched'']);\n    $highlight = $modx->stripTags($_REQUEST[''highlight'']);\n    if (isset($_REQUEST[''advsearch''])) $advsearch = $modx->stripTags($_REQUEST[''advsearch'']);\n  }\n\n  if ($advsearch != ''nowords'') {\n\n    $searchArray = array();\n    if ($advsearch == ''exactphrase'') $searchArray[0] = $searched;\n    else $searchArray = explode('' '', $searched);\n\n    $searchArray = array_unique($searchArray);\n    $nbterms = count($searchArray);\n    $searchTerms = array();\n    for($i=0;$i<$nbterms;$i++){\n      // Consider all possible combinations\n      $word_ents = array();\n      $word_ents[] = $searchArray[$i];\n      $word_ents[] = htmlentities($searchArray[$i], ENT_NOQUOTES, $pgCharset);\n      $word_ents[] = htmlentities($searchArray[$i], ENT_COMPAT, $pgCharset);\n      $word_ents[] = htmlentities($searchArray[$i], ENT_QUOTES, $pgCharset);\n      // Avoid duplication\n      $word_ents = array_unique($word_ents);\n      foreach($word_ents as $word) $searchTerms[]= array(''term'' => $word, ''class'' => $i+1);\n    }\n\n    $output = $modx->documentOutput; // get the parsed document\n    $body = explode("<body", $output); // break out the head\n\n    $highlightClass = explode('' '',$highlight); // break out the highlight classes\n    /* remove possibility of XSS attempts being passed in URL */\n    foreach ($highlightClass as $key => $value) {\n       $highlightClass[$key] = preg_match(''/[^A-Za-z0-9_-]/ms'', $value) == 1 ? '''' : $value;\n    }\n\n    $pcreModifier = ($pgCharset == ''UTF-8'') ? ''iu'' : ''i'';\n    $lookBehind = ''/(?<!&|&[\\w#]|&[\\w#]\\w|&[\\w#]\\w\\w|&[\\w#]\\w\\w\\w|&[\\w#]\\w\\w\\w\\w|&[\\w#]\\w\\w\\w\\w\\w)'';  // avoid a match with a html entity\n    $lookAhead = ''(?=[^>]*<)/''; // avoid a match with a html tag\n\n    $nbterms = count($searchTerms);\n    for($i=0;$i<$nbterms;$i++){\n      $word = $searchTerms[$i][''term''];\n      $class = $highlightClass[0].'' ''.$highlightClass[$searchTerms[$i][''class'']];\n\n      $highlightText .= ($i > 0) ? '', '' : '''';\n      $highlightText .= ''<span class="''.$class.''">''.$word.''</span>'';\n\n      $pattern = $lookBehind . preg_quote($word, ''/'') . $lookAhead . $pcreModifier;\n      $replacement = ''<span class="'' . $class . ''">${0}</span>'';\n      $body[1] = preg_replace($pattern, $replacement, $body[1]);\n    }\n\n    $output = implode("<body", $body);\n\n    $removeUrl = $modx->makeUrl($modx->documentIdentifier);\n    $highlightText .= ''<br /><a href="''.$removeUrl.''" class="ajaxSearch_removeHighlight">''.$removeText.''</a></div>'';\n\n    $output = str_replace(''<!--search_terms-->'',$highlightText,$output);\n    $modx->documentOutput = $output;\n  }\n}\n', 0, '', 0, ''),
(3, 'Forgot Manager Login', '<strong>clipper-1.2.1</strong> Resets your manager login when you forget your password via email confirmation', 0, 2, 0, 'if(!class_exists(''ForgotManagerPassword'')) {\n    class ForgotManagerPassword{\n        function __construct(){\n            $this->errors = array();\n            $this->checkLang();\n        }\n\n        function getLink() {\n            global $_lang;\n  \n            $link = <<<EOD\n <a id="ForgotManagerPassword-show_form" href="index.php?action=show_form">{$_lang[''forgot_your_password'']}</a>\nEOD;\n\n            return $link;\n        }\n\n        function getForm() {\n            global $_lang;\n\n            $form = <<<EOD\n<label id="FMP-email_label" for="FMP_email">{$_lang[''account_email'']}:</label>\n<input id="FMP-email" type="text" />\n<button id="FMP-email_button" type="button" onclick="window.location = ''index.php?action=send_email&email=''+document.getElementById(''FMP-email'').value;">{$_lang[''send'']}</button>\nEOD;\n\n            return $form;\n        }\n\n        /* Get user info including a hash unique to this user, password, and day */\n        function getUser($user_id=false, $username='''', $email='''', $hash='''') {\n            global $modx, $_lang;\n\n            $user_id = $user_id == false ? false : $modx->db->escape($user_id);\n            $username = $modx->db->escape($username);\n            $email = $modx->db->escape($email);\n            $hash = $modx->db->escape($hash);\n\n			$pre = $modx->db->config[''table_prefix''];\n			$site_id = $modx->config[''site_id''];\n			$today = date(''Yz''); // Year and day of the year\n			$wheres = array();\n			$where = '''';\n			$user = null;\n  \n            if($user_id !== false) { $wheres[] = "usr.id = ''{$user_id}''"; }\n            if(!empty($username)) { $wheres[] = "usr.username = ''{$username}''"; }\n            if(!empty($email)) { $wheres[] = "attr.email = ''{$email}''"; }\n            if(!empty($hash)) { $wheres[] = "MD5(CONCAT(usr.username,usr.password,''{$site_id}'',''{$today}'')) = ''{$hash}''"; } \n\n            if($wheres) {\n                $where = '' WHERE ''.implode('' AND '',$wheres);\n                $sql = "SELECT usr.id, usr.username, attr.email, MD5(CONCAT(usr.username,usr.password,''{$site_id}'',''{$today}'')) AS hash\n                    FROM `{$pre}manager_users` usr\n                    INNER JOIN `{$pre}user_attributes` attr ON usr.id = attr.internalKey\n                    {$where}      \n                    LIMIT 1;"; \n\n                if($result = $modx->db->query($sql)){\n                    if($modx->db->getRecordCount($result)==1) {\n                        $user = $modx->db->getRow($result);\n                    }\n                }\n            }\n\n            if($user == null) { $this->errors[] = $_lang[''could_not_find_user'']; }\n\n            return $user;\n        }\n\n\n\n        /* Send an email with a link to login */\n        function sendEmail($to) {\n            global $modx, $_lang;\n\n            $user = $this->getUser(0, '''', $to);\n  \n            if($user[''username'']) {\n\n				require($modx->config[''base_path''].''manager/includes/controls/clipper_mailer.class.inc.php'');\n				\n				$mail = new ClipperMailer();\n				$mail->Subject = $_lang[''password_change_request''];\n				$mail->isHTML(true);\n				$mail->Body = <<<EOD\n<p>{$_lang[''forgot_password_email_intro'']} <a href="{$modx->config[''site_url'']}manager/processors/login.processor.php?username={$user[''username'']}&hash={$user[''hash'']}">{$_lang[''forgot_password_email_link'']}</a></p>\n<p>{$_lang[''forgot_password_email_instructions'']}</p>\n<p><small>{$_lang[''forgot_password_email_fine_print'']}</small></p>\nEOD;\n				$mail->AddAddress($to);\n\n                if(!$mail->Send()) { $this->errors[] = $_lang[''error_sending_email'']; }\n   \n                return $mail;  \n            }\n        }\n\n        function unblockUser($user_id) {\n            global $modx, $_lang;\n\n            $pre = $modx->db->config[''table_prefix''];\n            $modx->db->update(array(''blocked'' => 0, ''blockeduntil'' => 0, ''failedlogincount'' => 0), "`{$pre}user_attributes`", "internalKey = ''{$user_id}''");\n\n            if(!$modx->db->getAffectedRows()) { $this->errors[] = $_lang[''user_doesnt_exist'']; return; }\n\n            return true;\n        }\n\n        function checkLang() {\n            global $_lang;\n\n            $eng = array();\n            $eng[''forgot_your_password''] = ''Forgot your password?'';\n            $eng[''account_email''] = ''Account email'';\n            $eng[''send''] = ''Send'';\n            $eng[''password_change_request''] = ''Password change request'';\n            $eng[''forgot_password_email_intro''] = ''A request has been made to change the password on your account.'';\n            $eng[''forgot_password_email_link''] = ''Click here to complete the process.'';\n            $eng[''forgot_password_email_instructions''] = ''From there you will be able to change your password from the My Account menu.'';\n            $eng[''forgot_password_email_fine_print''] = ''* The URL above will expire once you change your password or after today.'';\n            $eng[''error_sending_email''] = ''Error sending email'';\n            $eng[''could_not_find_user''] = ''Could not find user'';\n            $eng[''user_doesnt_exist''] = ''User does not exist'';\n            $eng[''email_sent''] = ''Email sent'';\n\n            foreach($eng as $key=>$value) {\n                if(empty($_lang[$key])) { $_lang[$key] = $value; }\n            }  \n        }\n\n        function getErrorOutput() {\n            $output = '''';\n\n            if($this->errors) {\n                $output = ''<span class="error">''.implode(''</span><span class="errors">'', $this->errors).''</span>'';\n            }\n  \n            return $output;\n        }\n    }\n}\n\nglobal $_lang;\n\n$output = '''';\n$event_name = $modx->Event->name;\n$action = ((isset($_GET[''action'']) && !is_array($_GET[''action'']) && $_GET[''action'']!='''') ? $_GET[''action''] : '''');\n$username = ((isset($_GET[''username'']) && !is_array($_GET[''username'']) && $_GET[''username'']!='''') ? $_GET[''username''] : '''');\n$to = ((isset($_GET[''email'']) &&  !is_array($_GET[''email'']) && $_GET[''email'']!='''') ?  $_GET[''email''] : '''');\n$hash = ((isset($_GET[''hash'']) && !is_array($_GET[''hash'']) && $_GET[''hash'']!='''') ? $_GET[''hash''] : '''');\n$forgot = new ForgotManagerPassword();\n\nif($event_name == ''OnManagerLoginFormRender'') {\n    switch($action) {\n        case ''show_form'':\n            $output = $forgot->getForm();\n            break;\n        case ''send_email'':\n            if($forgot->sendEmail($to)) { $output = $_lang[''email_sent'']; }\n            break;\n        default:\n            $output = $forgot->getLink();\n            break;\n    }\n\n    if($forgot->errors) { $output = $forgot->getErrorOutput() . $forgot->getLink(); }\n}\n\nif($event_name == ''OnBeforeManagerLogin'' && $hash && $username) {\n    $user = $forgot->getUser(false, $username, '''', $hash);\n    if($user && is_array($user) && !$forgot->errors) {\n        $forgot->unblockUser($user[''id'']);\n    }\n}\n\nif($event_name == ''OnManagerAuthentication'' && $hash && $username) {\n    $user = $forgot->getUser(false, $username, '''', $hash);\n    $output = ($user !== null && count($forgot->errors) == 0) ? true : false;\n}\n\n$modx->Event->output($output);\n\n', 0, '', 0, ''),
(4, 'TransAlias', '<strong>clipper-1.1.1</strong> Human readible URL translation supporting multiple languages and overrides.', 0, 2, 0, 'require MODX_BASE_PATH.''assets/plugins/transalias/plugin.transalias.php'';\n', 0, '&table_name=Trans table;list;common,russian,dutch,german,czech,utf8,utf8lowercase;utf8lowercase &char_restrict=Restrict alias to;list;lowercase alphanumeric,alphanumeric,legal characters;legal characters &remove_periods=Remove Periods;list;Yes,No;No &word_separator=Word Separator;list;dash,underscore,none;dash &override_tv=Override TV name;string;', 0, ''),
(5, 'Quick Manager+', '<strong>clipper-1.6</strong> Enables QuickManager+ front end content editing support', 0, 2, 0, '// In manager\nif (isset($_SESSION[''mgrValidated''])) {\n\n    $show = TRUE;\n\n    if ($disabled  != '''') {\n        $arr = explode(",", $disabled );\n        if (in_array($modx->documentIdentifier, $arr)) {\n            $show = FALSE;\n        }\n    }\n\n    if ($show) {\n        // Replace [*#tv*] with QM+ edit TV button placeholders\n        if ($tvbuttons == ''true'') {\n            $e = $modx->Event;\n            if ($e->name == ''OnParseDocument'') {\n                 $output = &$modx->documentOutput;\n                 $output = preg_replace(''~\\[\\*#(.*?)\\*\\]~'', ''<!-- ''.$tvbclass.'' $1 -->[*$1*]'', $output);\n                 $modx->documentOutput = $output;\n             }\n         }\n        // In manager\n        if (isset($_SESSION[''mgrValidated''])) {\n            require_once($modx->config[''base_path''].''assets/plugins/qm/qm.inc.php'');\n            $qm = new Qm($modx, $noconflict === ''true'', $loadtb, $tbwidth, $tbheight, $hidefields, $hidetabs, $hidesections, $addbutton, $custombutton, $managerbutton, $logout, $autohide, $editbuttons, $editbclass, $newbuttons, $newbclass, $tvbuttons, $tvbclass);\n        }\n    }\n}\n', 0, '&noconflict=Use own instance of jquery;list;true,false;true &loadtb=Load modal box in front-end;list;true,false;true &tbwidth=Modal box window width;text;80% &tbheight=Modal box window height;text;90% &hidefields=Hide document fields from front-end editors;text;parent &hidetabs=Hide document tabs from front-end editors;text; &hidesections=Hide document sections from front-end editors;text; &addbutton=Show add document here button;list;true,false;true &custombutton=Custom buttons;textarea; &managerbutton=Show go to manager button;list;true,false;true &logout=Logout to;list;manager,front-end;manager &disabled=Plugin disabled on documents;text; &autohide=Autohide toolbar;list;true,false;true &editbuttons=Inline edit buttons;list;true,false;false &editbclass=Edit button CSS class;text;qm-edit &newbuttons=Inline new resource buttons;list;true,false;false &newbclass=New resource button CSS class;text;qm-new &tvbuttons=Inline template variable buttons;list;true,false;false &tvbclass=Template variable button CSS class;text;qm-tv', 0, ''),
(6, 'TinyMCE Rich Text Editor', '<strong>clipper-3.5.3</strong> Javascript WYSIWYG Editor', 0, 2, 0, '// Set the name of the plugin folder\n$plugin_dir = "tinymce";\n\n// Set path and base setting variables\nif(!isset($mce_path))\n{ \n	$mce_path = MODX_BASE_PATH . ''assets/plugins/''.$plugin_dir . ''/''; \n	$mce_url  = MODX_BASE_URL  . ''assets/plugins/''.$plugin_dir . ''/''; \n}\n\n$params[''customparams'']    = $customparams;\n$params[''blockFormats'']    = $mce_formats;\n$params[''entity_encoding''] = $entity_encoding;\n$params[''entities'']        = $entities;\n$params[''pathoptions'']     = $mce_path_options;\n$params[''resizing'']        = $mce_resizing;\n$params[''disabledButtons''] = $disabledButtons;\n$params[''link_list'']       = $link_list;\n$params[''theme'']           = $webtheme;\n$params[''custom_plugins'']  = $webPlugins;\n$params[''custom_buttons1''] = $webButtons1;\n$params[''custom_buttons2''] = $webButtons2;\n$params[''custom_buttons3''] = $webButtons3;\n$params[''custom_buttons4''] = $webButtons4;\n$params[''toolbar_align'']   = $webAlign;\n$params[''width'']           = $width;\n$params[''height'']          = $height;\n\n$params[''mce_path'']        = $mce_path;\n$params[''mce_url'']         = $mce_url;\n\ninclude_once $mce_path . ''lang/tinymce.lang.php'';\ninclude_once $mce_path . ''tinymce.functions.php'';\n\n$mce = new TinyMCE($params);\n\n// Handle event\n$e = &$modx->Event; \nswitch ($e->name)\n{\n	case "OnRichTextEditorRegister": // register only for backend\n		$e->output("TinyMCE");\n		break;\n\n	case "OnRichTextEditorInit": \n		if($editor!=="TinyMCE") return;\n		\n		$params[''elements'']        = $elements;\n		$params[''css_selectors'']   = $modx->config[''tinymce_css_selectors''];\n		$params[''use_browser'']     = $modx->config[''use_browser''];\n		$params[''editor_css_path''] = $modx->config[''editor_css_path''];\n		\n		if($modx->isBackend() || (intval($_GET[''quickmanagertv'']) == 1 && isset($_SESSION[''mgrValidated''])))\n		{\n			$params[''theme'']           = $modx->config[''tinymce_editor_theme''];\n			$params[''language'']        = getTinyMCELang($modx->config[''manager_language'']);\n			$params[''frontend'']        = false;\n			$params[''custom_plugins'']  = $modx->config[''tinymce_custom_plugins''];\n			$params[''custom_buttons1''] = $modx->config[''tinymce_custom_buttons1''];\n			$params[''custom_buttons2''] = $modx->config[''tinymce_custom_buttons2''];\n			$params[''custom_buttons3''] = $modx->config[''tinymce_custom_buttons3''];\n			$params[''custom_buttons4''] = $modx->config[''tinymce_custom_buttons4''];\n			$params[''toolbar_align'']   = $modx->config[''manager_direction''];\n			$params[''webuser'']         = null;\n			\n			$html = $mce->get_mce_script($params);\n		}\n		else\n		{\n			$frontend_language = isset($modx->config[''fe_editor_lang'']) ? $modx->config[''fe_editor_lang'']:'''';\n			$webuser = (isset($modx->config[''rb_webuser'']) ? $modx->config[''rb_webuser''] : null);\n			\n			$params[''webuser'']         = $webuser;\n			$params[''language'']        = getTinyMCELang($frontend_language);\n			$params[''frontend'']        = true;\n			\n			$html = $mce->get_mce_script($params);\n		}\n		$e->output($html);\n		break;\n\n	case "OnInterfaceSettingsRender":\n		global $usersettings,$settings;\n		$action = $modx->manager->action;\n		switch ($action)\n		{\n			case 11:\n				$mce_settings = '''';\n				break;\n			case 12:\n				$mce_settings = $usersettings;\n				break;\n			case 17:\n				$mce_settings = $settings;\n				break;\n			default:\n				$mce_settings = $settings;\n				break;\n		}\n		\n		$params[''use_editor'']       = $modx->config[''base_url''].$modx->config[''use_editor''];\n        $params[''editor_css_path'']  = $modx->config[''editor_css_path''];\n		$params[''theme'']            = $mce_settings[''tinymce_editor_theme''];\n		$params[''css_selectors'']    = $mce_settings[''tinymce_css_selectors''];\n		$params[''custom_plugins'']   = $mce_settings[''tinymce_custom_plugins''];\n		$params[''custom_buttons1'']  = $mce_settings[''tinymce_custom_buttons1''];\n		$params[''custom_buttons2'']  = $mce_settings[''tinymce_custom_buttons2''];\n		$params[''custom_buttons3'']  = $mce_settings[''tinymce_custom_buttons3''];\n		$params[''custom_buttons4'']  = $mce_settings[''tinymce_custom_buttons4''];\n		\n		$html = $mce->get_mce_settings($params);\n		$e->output($html);\n		break;\n		\n	default :\n		return; // stop here - this is very important. \n		break; \n}\n', 0, '&customparams=Custom Parameters;textarea; &mce_formats=Block Formats;text;p,h1,h2,h3,h4,h5,h6,div,blockquote,code,pre &entity_encoding=Entity Encoding;list;named,numeric,raw;named &entities=Entities;text; &mce_path_options=Path Options;list;rootrelative,docrelative,fullpathurl;docrelative &mce_resizing=Advanced Resizing;list;true,false;true &disabledButtons=Disabled Buttons;text; &link_list=Link List;list;enabled,disabled;enabled &webtheme=Web Theme;list;simple,editor,creative,custom;simple &webPlugins=Web Plugins;text;style,advimage,advlink,searchreplace,contextmenu,paste,fullscreen,nonbreaking,xhtmlxtras,visualchars,media &webButtons1=Web Buttons 1;text;undo,redo,selectall,|,pastetext,pasteword,|,search,replace,|,nonbreaking,hr,charmap,|,image,link,unlink,anchor,media,|,cleanup,removeformat,|,fullscreen,code,help &webButtons2=Web Buttons 2;text;bold,italic,underline,strikethrough,sub,sup,|,|,blockquote,bullist,numlist,outdent,indent,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect,|,styleprops &webButtons3=Web Buttons 3;text; &webButtons4=Web Buttons 4;text; &webAlign=Web Toolbar Alignment;list;ltr,rtl;ltr &width=Width;text;100% &height=Height;text;400', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_plugin_events`
--

CREATE TABLE `[[dbprefix]]site_plugin_events` (
  `pluginid` int(10) NOT NULL,
  `evtid` int(10) NOT NULL DEFAULT '0',
  `priority` int(10) NOT NULL DEFAULT '0' COMMENT 'determines plugin run order'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Links to system events';

--
-- Dumping data for table `[[dbprefix]]site_plugin_events`
--

INSERT INTO `[[dbprefix]]site_plugin_events` VALUES
(1, 28, 0),
(1, 29, 0),
(1, 30, 0),
(1, 35, 0),
(2, 3, 0),
(3, 80, 0),
(3, 81, 0),
(3, 93, 0),
(4, 100, 0),
(5, 3, 0),
(5, 11, 0),
(5, 13, 0),
(5, 28, 0),
(5, 31, 0),
(5, 90, 0),
(5, 92, 0),
(6, 85, 0),
(6, 87, 0),
(6, 88, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_snippets`
--

CREATE TABLE `[[dbprefix]]site_snippets` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT 'Snippet',
  `editor_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-plain text,1-rich text,2-code editor',
  `category` int(11) NOT NULL DEFAULT '0' COMMENT 'category id',
  `cache_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Cache option',
  `snippet` mediumtext,
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `properties` text,
  `moduleguid` varchar(32) NOT NULL DEFAULT '' COMMENT 'GUID of module from which to import shared parameters',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the site snippets.' AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]site_snippets`
--

INSERT INTO `[[dbprefix]]site_snippets` VALUES
(1, 'Jot', '<strong>clipper-1.1.5</strong> User comments with moderation and email subscription', 0, 4, 0, '/*####\n#\n# Author: Armand "bS" Pondman (apondman@zerobarrier.nl)\n#\n# Latest Version: http://modxcms.com/Jot-998.html\n# Jot Demo Site: http://projects.zerobarrier.nl/modx/\n# Documentation: http://wiki.modxcms.com/index.php/Jot (wiki)\n#\n####*/\n\n$jotPath = $modx->config[''base_path''] . ''assets/snippets/jot/'';\ninclude_once($jotPath.''jot.class.inc.php'');\n\n$Jot = new CJot;\n$Jot->VersionCheck("1.1.4");\n$Jot->Set("path",$jotPath);\n$Jot->Set("action", $action);\n$Jot->Set("postdelay", $postdelay);\n$Jot->Set("docid", $docid);\n$Jot->Set("tagid", $tagid);\n$Jot->Set("subscribe", $subscribe);\n$Jot->Set("moderated", $moderated);\n$Jot->Set("captcha", $captcha);\n$Jot->Set("badwords", $badwords);\n$Jot->Set("bw", $bw);\n$Jot->Set("sortby", $sortby);\n$Jot->Set("numdir", $numdir);\n$Jot->Set("customfields", $customfields);\n$Jot->Set("guestname", $guestname);\n$Jot->Set("canpost", $canpost);\n$Jot->Set("canview", $canview);\n$Jot->Set("canedit", $canedit);\n$Jot->Set("canmoderate", $canmoderate);\n$Jot->Set("trusted", $trusted);\n$Jot->Set("pagination", $pagination);\n$Jot->Set("placeholders", $placeholders);\n$Jot->Set("subjectSubscribe", $subjectSubscribe);\n$Jot->Set("subjectModerate", $subjectModerate);\n$Jot->Set("subjectAuthor", $subjectAuthor);\n$Jot->Set("notify", $notify);\n$Jot->Set("notifyAuthor", $notifyAuthor);\n$Jot->Set("validate", $validate);\n$Jot->Set("title", $title);\n$Jot->Set("authorid", $authorid);\n$Jot->Set("css", $css);\n$Jot->Set("cssFile", $cssFile);\n$Jot->Set("cssRowAlt", $cssRowAlt);\n$Jot->Set("cssRowMe", $cssRowMe);\n$Jot->Set("cssRowAuthor", $cssRowAuthor);\n$Jot->Set("tplForm", $tplForm);\n$Jot->Set("tplComments", $tplComments);\n$Jot->Set("tplModerate", $tplModerate);\n$Jot->Set("tplNav", $tplNav);\n$Jot->Set("tplNotify", $tplNotify);\n$Jot->Set("tplNotifyModerator", $tplNotifyModerator);\n$Jot->Set("tplNotifyAuthor", $tplNotifyAuthor);\n$Jot->Set("tplSubscribe", $tplSubscribe);\n$Jot->Set("debug", $debug);\n$Jot->Set("output", $output);\nreturn $Jot->Run();\n', 0, '', ''),
(2, 'eForm', '<strong>1.4.8-clipper</strong> Robust form parser/processor with validation, multiple sending options, chunk/page support for forms and reports, and file uploads', 0, 5, 0, '# Original created by Raymond Irving 15-Dec-2004.\n# Further work by the MODx community and ClipperCMS community\n\n# Set Snippet Paths\n$snipFolder = isset($snipFolder)?$snipFolder:''eform'';\n$snipPath = $modx->config["base_path"].''assets/snippets/''.$snipFolder.''/'';\n\n\n# check if inside manager\nif ($modx->isBackend()) {\nreturn ''''; # don''t go any further when inside manager\n}\n\n//tidying up some casing errors in parameters\nif(isset($eformOnValidate)) $eFormOnValidate = $eformOnValidate;\nif(isset($eformOnBeforeMailSent)) $eFormOnBeforeMailSent = $eformOnBeforeMailSent;\nif(isset($eformOnMailSent)) $eFormOnMailSent = $eformOnMailSent;\nif(isset($eformOnValidate)) $eFormOnValidate = $eformOnValidate;\nif(isset($eformOnBeforeFormMerge)) $eFormOnBeforeFormMerge = $eformOnBeforeFormMerge;\nif(isset($eformOnBeforeFormParse)) $eFormOnBeforeFormParse = $eformOnBeforeFormParse;\n//for sottwell :)\nif(isset($eFormCSS)) $cssStyle = $eFormCSS;\n\n# Snippet customize settings\n$params = array (\n   // Snippet Path\n   ''snipPath'' => $snipPath, //includes $snipFolder\n	 ''snipFolder'' => $snipFolder,\n\n// eForm Params\n   ''vericode'' => isset($vericode)? $vericode:"",\n   ''formid'' => isset($formid)? $formid:"",\n   ''from'' => isset($from)? $from:$modx->config[''emailsender''],\n   ''fromname'' => isset($fromname)? $fromname:$modx->config[''site_name''],\n   ''to'' => isset($to)? $to:$modx->config[''emailsender''],\n   ''cc'' => isset($cc)? $cc:"",\n   ''bcc'' => isset($bcc)? $bcc:"",\n   ''subject'' => isset($subject)? $subject:"",\n   ''ccsender'' => isset($ccsender)?$ccsender:0,\n   ''sendirect'' => isset($sendirect)? $sendirect:0,\n   ''mselector'' => isset($mailselector)? $mailselector:0,\n   ''mobile'' => isset($mobile)? $mobile:'''',\n   ''mobiletext'' => isset($mobiletext)? $mobiletext:'''',\n   ''autosender'' => isset($autosender)? $autosender:$from,\n   ''autotext'' => isset($automessage)? $automessage:"",\n   ''category'' => isset($category)? $category:0,\n   ''keywords'' => isset($keywords)? $keywords:"",\n   ''gid'' => isset($gotoid)? $gotoid:$modx->documentIdentifier,\n   ''noemail'' => isset($noemail)? ($noemail):false,\n   ''saveform'' => isset($saveform)? ($saveform? true:false):true,\n   ''tpl'' => isset($tpl)? $tpl:"",\n   ''report'' => isset($report)? $report:"",\n   ''allowhtml'' => isset($allowhtml)? $allowhtml:0,\n   //Added by JJ\n   ''replyto'' => isset($replyto)? $replyto:"",\n   ''language'' => isset($language)? $language:$modx->config[''manager_language''],\n   ''thankyou'' => isset($thankyou)? $thankyou:"",\n   ''isDebug'' => isset($debug)? $debug:0,\n   ''reportAbuse'' => isset($reportAbuse)? $reportAbuse:false,\n   ''disclaimer'' => isset($disclaimer)?$disclaimer:'''',\n   ''sendAsHtml'' => isset($sendAsHtml)?$sendAsHtml:false,\n   ''sendAsText'' => isset($sendAsText)?$sendAsText:false,\n   ''sessionVars'' => isset($sessionVars)?$sessionVars:false,\n   ''postOverides'' => isset($postOverides)?$postOverides:0,\n   ''eFormOnBeforeMailSent'' => isset($eFormOnBeforeMailSent)?$eFormOnBeforeMailSent:'''',\n   ''eFormOnMailSent'' => isset($eFormOnMailSent)?$eFormOnMailSent:'''',\n   ''eFormOnValidate'' => isset($eFormOnValidate)?$eFormOnValidate:'''',\n   ''eFormOnBeforeFormMerge'' => isset($eFormOnBeforeFormMerge)?$eFormOnBeforeFormMerge:'''',\n   ''eFormOnBeforeFormParse'' => isset($eFormOnBeforeFormParse)?$eFormOnBeforeFormParse:'''',\n   ''cssStyle'' => isset($cssStyle)?$cssStyle:'''',\n   ''jScript'' => isset($jScript)?$jScript:'''',\n   ''submitLimit'' => (isset($submitLimit) &&  is_numeric($submitLimit))?$submitLimit*60:0,\n   ''protectSubmit'' => isset($protectSubmit)?$protectSubmit:1,\n   ''requiredClass'' => isset($requiredClass)?$requiredClass:"required",\n   ''invalidClass'' => isset($invalidClass)?$invalidClass:"invalid",\n   ''runSnippet'' => ( isset($runSnippet) && !is_numeric($runSnippet) )?$runSnippet:'''',\n   ''autoSenderName'' => isset($autoSenderName)?$autoSenderName:'''',\n   ''version'' => ''1.4.6''\n);\n\n// pixelchutes PHx workaround\nforeach( $params as $key=>$val ) $params[ $key ] = str_replace( array(''(('',''))''), array(''[+'',''+]''), $val );\n\n# Start processing\n\ninclude_once ($snipPath."eform.inc.php");\n\n$output = eForm($modx,$params);\n\n# Return\nreturn $output;\n', 0, '', ''),
(3, 'WebUsers', '<strong>1.3.6</strong> @package		WebUsers', 0, 6, 0, '$type = isset($type) ? $type : ''simple'';\n	$regType = isset($regType) ? $regType : ''instant'';\n	$notify = isset($notify) ? $notify : '''';\n	$groups = isset($groups) ? $groups : '''';\n	$regRequired = isset($regRequired) ? $regRequired : '''';\n	$customTable = isset($customTable) ? $customTable : ''web_user_attributes_extended'';\n	$customFields = isset($customFields) ? $customFields : '''';\n	$prefixTable = isset($prefixTable) ? $prefixTable : 1;\n	$lang = isset($lang) ? $lang : ''en'';\n	$userImageSettings = isset($userImage) ? $userImage : ''105000,100,100'';\n	$dateFormat = isset($dateFormat) ? $dateFormat : ''%A %B %d, %Y at %I:%M %p'';\n	$disableServices = isset($disableServices) ? explode('','', str_replace('', '','','',$disableServices)) : array();\n	$tableCheck = isset($tableCheck) ? $tableCheck : 1;\n	\n	define(''WEBUSER_PATH'', MODX_BASE_PATH.''assets/snippets/webusers/'');\n	\n	require_once(WEBUSER_PATH.''webusers.class.php'');\n	require_once(WEBUSER_PATH.''webusers.templates.php'');\n\n	if (file_exists(WEBUSER_PATH.''lang/''.$lang.''.php''))\n	{\n		require_once(WEBUSER_PATH.''lang/''.$lang.''.php'');\n	}\n	else\n	{\n		require_once(WEBUSER_PATH.''lang/en.php'');\n		$modx->setPlaceholder(''wlpe.message'', $wlpe_lang[105]);\n		print ''[+wlpe.message+]'';\n	}\n	\n	$wlpe = new WebLoginPE($wlpe_lang, $dateFormat, $userImageSettings, $type);\n	$wlpe->CustomTable($customTable, $customFields, $prefixTable, $tableCheck);\n\n	$liHomeId = isset($liHomeId) ? explode('','', $liHomeId) : '''';\n	$loHomeId = isset($loHomeId) ? $loHomeId : '''';\n	$regHomeId = isset($regHomeId) ? $regHomeId : '''';\n	$regSuccessId = isset($regSuccessId) ? $regSuccessId : '''';\n	$regSuccessPause = isset($regSuccessPause) ? $regSuccessPause : 5;\n	$profileHomeId = isset($profileHomeId) ? $profileHomeId : '''';\n	$inputHandler = isset($inputHandler) ? explode(''||'', $inputHandler) : array();\n	$usersList = isset($usersList) ? $usersList : '''';\n	\n	if ($regType == ''verify''){$wlpeRegisterTpl = $wlpeRegisterVerifyTpl;}else{$wlpeRegisterTpl = $wlpeRegisterInstantTpl;}\n	\n	$displayLoginFormTpl = isset($loginFormTpl) ? $wlpe->Template($loginFormTpl) : $wlpeDefaultFormTpl;\n	$displaySuccessTpl = isset($successTpl) ? $wlpe->Template($successTpl) : $wlpeDefaultSuccessTpl;\n	$displayRegisterTpl = isset($registerTpl) ? $wlpe->Template($registerTpl) : $wlpeRegisterTpl;\n	$displayRegSuccessTpl = isset($registerSuccessTpl) ? $wlpe->Template($registerSuccessTpl) : $wlpeDefaultFormTpl;\n	$displayProfileTpl = isset($profileTpl) ? $wlpe->Template($profileTpl) : $wlpeProfileTpl;\n	$displayViewProfileTpl = isset($viewProfileTpl) ? $wlpe->Template($viewProfileTpl) : $wlpeViewProfileTpl;\n	$displayUsersOuterTpl = isset($usersOuterTpl) ? $wlpe->Template($usersOuterTpl) : $wlpeUsersOuterTpl;\n	$displayUsersTpl = isset($usersTpl) ? $wlpe->Template($usersTpl) : $wlpeUsersTpl;\n	$displayManageOuterTpl = isset($manageOuterTpl) ? $wlpe->Template($manageOuterTpl) : $wlpeUsersOuterTpl;\n	$displayManageTpl = isset($manageTpl) ? $wlpe->Template($manageTpl) : $wlpeManageTpl;\n	$displayManageProfileTpl = isset($manageProfileTpl) ? $wlpe->Template($manageProfileTpl) : $wlpeManageProfileTpl;\n	$displayManageDeleteTpl = isset($manageDeleteTpl) ? $wlpe->Template($manageDeleteTpl) : $wlpeManageDeleteTpl;\n	$displayProfileDeleteTpl = isset($profileDeleteTpl) ? $wlpe->Template($profileDeleteTpl) : $wlpeProfileDeleteTpl;\n	$displayActivateTpl = isset($activateTpl) ? $wlpe->Template($activateTpl) : $wlpeActivateTpl;\n	$displayResetTpl = isset($resetTpl) ? $wlpe->Template($resetTpl) : $wlpeResetTpl;\n	$notifyTpl = isset($notifyTpl) ? $wlpe->Template($notifyTpl) : $wlpeNotifyTpl;\n	$notifySubject = isset($notifySubject) ? $notifySubject : ''New Web User for ''.$modx->config[''site_name''].''.'';\n	$messageTpl = isset($messageTpl) ? $wlpe->Template($messageTpl) : $wlpeMessageTpl;\n	$tosChunk = isset($tosChunk) ? $wlpe->Template($tosChunk) : $wlpeTos;\n	$modx->setPlaceholder(''tos'', $tosChunk);\n	\n	$loadJquery = isset($loadJquery) ? $loadJquery : false;\n	$customJs = isset($customJs) ? $customJs : '''';\n	\n	if (isset($pruneDays))\n	{\n		$wlpe->PruneUsers($pruneDays);\n	}\n		\n	if ($loadJquery == ''true'' || $loadJquery == true || $loadJquery == 1 || $loadJquery == ''1'') \n	{\n		$wlpe->RegisterScripts($customJs);\n	}\n	else if (!empty($customJs))\n	{\n		$modx->regClientStartupScript($customJs);\n	}\n	\n	$wlpe->ActiveUsers();\n	$wlpe->PlaceHolders($inputHandler, $messageTpl);\n\n	$service = $_REQUEST[''service''];\n	if (empty($service) || $service == '''')\n	{\n		$service = $_REQUEST[''serviceButtonValue''];\n	}\n	\n	if ($type == ''register'')\n	{\n		if (in_array(''register'', $disableServices)){return;}\n		switch ($service) \n		{\n			case ''register'' :\n				if (in_array(''register'', $disableServices)){return;}\n				$registration = $wlpe->Register($regType, $groups, $regRequired, $notify, $notifyTpl, $notifySubject);\n				\n				if (isset($regSuccessId) && $regSuccessId !== '''')\n				{\n					if ($registration == ''success'')\n					{\n						$url = rtrim($modx->config[''site_url''], ''/'').$modx->makeURL($regSuccessId);\n						header(''Refresh: ''.$regSuccessPause.'';URL=''.$url);\n						return $displayRegSuccessTpl;\n					}\n					return $displayRegisterTpl;\n					\n				}\n				if ($registration == ''success'')\n				{\n					return $displayRegSuccessTpl;\n				}\n				return $displayRegisterTpl;\n				break;\n				\n			case ''cancel'':\n				if ($loHomeId == '''') $loHomeId = $modx->config[''site_start''];\n				$url = $modx->makeURL($loHomeId);\n		        $modx->sendRedirect($url,0,''REDIRECT_REFRESH'');\n				break;\n			\n			case ''login'' :\n				if ($_SERVER[''REQUEST_METHOD''] == ''POST'')\n				{\n					$wlpe->Login($type, $liHomeId);\n				}\n\n				if ($modx->getLoginUserID())\n				{\n					return $displaySuccessTpl;\n				}\n				else\n				{\n					return $displayLoginFormTpl;\n				}\n				break;\n\n			case ''logout'' :\n				$wlpe->Logout($type, $loHomeId);\n				return $displayLoginFormTpl;\n				break;\n			\n			default :\n				return $displayRegisterTpl;\n		}\n		return;\n	}\n	\n	else if ($type == ''profile'')\n	{\n		if (in_array(''profile'', $disableServices)){return;}\n		switch ($service) \n		{\n			case ''saveprofile'' :\n				if (in_array(''saveprofile'', $disableServices)){return;}\n				$wlpe->SaveUserProfile();\n				$wlpe->PlaceHolders($inputHandler, $messageTpl);\n				return $displayProfileTpl;\n				break;\n				\n			case ''cancel'':\n				if ($loHomeId == '''') $loHomeId = $modx->config[''site_start''];\n				$url = $modx->makeURL($loHomeId);\n		        $modx->sendRedirect($url,0,''REDIRECT_REFRESH'');\n				break;\n				\n			case ''logout'':\n				if ($loHomeId == '''') $loHomeId = $modx->config[''site_start''];\n				$wlpe->Logout($type, $loHomeId);\n				break;\n				\n			case ''deleteprofile'':\n				if (in_array(''deleteprofile'', $disableServices)){return;}\n				return $displayProfileDeleteTpl;\n				break;\n			\n			case ''confirmdeleteprofile'':\n				if (in_array(''confirmdeleteprofile'', $disableServices)){return;}\n				$wlpe->RemoveUserProfile();\n				return ''[+wlpe.message+]'';\n				break;\n				\n			default :\n				return $displayProfileTpl;\n				break;\n		}\n		return;\n	}\n	\n	else if ($type == ''users'')\n	{\n		if (in_array(''users'', $disableServices)){return;}\n		switch ($service)\n		{\n			case ''viewprofile'':\n				if (in_array(''viewprofile'', $disableServices)){return;}\n				$wlpe->ViewUserProfile($_REQUEST[''username''],$inputHandler);\n				return $displayViewProfileTpl;\n				break;\n				\n			case ''messageuser'':\n				if (in_array(''messageuser'', $disableServices)){return;}\n				$wlpe->SendMessageToUser();\n				return $displayViewProfileTpl;\n				break;\n			\n			default :\n				$userpage = $wlpe->ViewAllUsers($displayUsersTpl, $displayUsersOuterTpl, $usersList);\n				return $userpage;\n		}\n		return;\n	}\n	\n	else if ($type == ''manager'')\n	{\n		if (in_array(''manager'', $disableServices)){return;}\n		switch ($service)\n		{\n			case ''editprofile'':\n				if (in_array(''editprofile'', $disableServices)){return;}\n				$wlpe->ViewUserProfile($_REQUEST[''username''],$inputHandler);\n				return $displayManageProfileTpl;\n				break;\n				\n			case ''saveuserprofile'' :\n				if (in_array(''saveuserprofile'', $disableServices)){return;}\n				$wlpe->SaveUserProfile($_POST[''internalKey'']);\n				$manageUsersPage = $wlpe->ViewAllUsers($displayManageTpl, $displayManageOuterTpl, $usersList);\n				return $manageUsersPage;\n				break;\n				\n			case ''messageuser'':\n				if (in_array(''messageuser'', $disableServices)){return;}\n				$wlpe->SendMessageToUser();\n				return $displayViewProfileTpl;\n				break;\n				\n			case ''deleteuser'':\n				if (in_array(''deleteuser'', $disableServices)){return;}\n				$_SESSION[''editInternalKey''] = $_POST[''internalKey''];\n				return $displayManageDeleteTpl;\n				break;\n\n			case ''confirmdeleteuser'':\n				if (in_array(''confirmdeleteuser'', $disableServices)){return;}\n				$wlpe->RemoveUserProfileManager($_SESSION[''editInternalKey'']);\n				$manageUsersPage = $wlpe->ViewAllUsers($displayManageTpl, $displayManageOuterTpl, $usersList);\n				unset($_SESSION[''editInternalKey'']);\n				return $manageUsersPage;\n				break;\n			\n			default :\n				$manageUsersPage = $wlpe->ViewAllUsers($displayManageTpl, $displayManageOuterTpl, $usersList);\n				return $manageUsersPage;\n		}\n		return;\n	}\n	\n	else if ($type == ''simple'')\n	{\n		switch ($service) \n		{\n\n			case ''login'' :\n				if ($_SERVER[''REQUEST_METHOD''] == ''POST'')\n				{\n					$wlpe->Login($type, $liHomeId);\n				}\n\n				if ($modx->getLoginUserID())\n				{\n					return $displaySuccessTpl;\n				}\n				else\n				{\n					return $displayLoginFormTpl;\n				}\n				break;\n\n			case ''logout'' :\n				$wlpe->Logout($type, $loHomeId);\n				return $displayLoginFormTpl;\n				break;\n\n			case ''profile'' :\n				if (in_array(''profile'', $disableServices)){return;}\n				if (empty($profileHomeId))\n				{\n					return $displayProfileTpl;\n				}\n				$url = $modx->makeURL($profileHomeId);\n		        $modx->sendRedirect($url,0,''REDIRECT_REFRESH'');\n		        return;\n				break;\n				\n            case ''saveprofile'':\n			case ''saveprofilesimple'' :\n				if (in_array(''saveprofile'', $disableServices)){return;}\n				$wlpe->SaveUserProfile();\n				$wlpe->PlaceHolders($inputHandler, $messageTpl);\n				return $displayProfileTpl;\n				break;\n			\n            case ''deleteprofile'':\n			case ''deleteprofilesimple'':\n				if (in_array(''deleteprofile'', $disableServices)){return;}\n				return $displayProfileDeleteTpl;\n				break;\n\n			case ''confirmdeleteprofilesimple'':\n				if (in_array(''confirmdeleteprofile'', $disableServices)){return;}\n				$wlpe->RemoveUserProfile();\n				return ''[+wlpe.message+]'';\n				break;\n\n			case ''registernew'' :\n				if (in_array(''register'', $disableServices)){return;}\n				if (empty($regHomeId))\n				{\n					return $displayRegisterTpl;\n				}\n				$url = $modx->makeURL($regHomeId);\n		        $modx->sendRedirect($url,0,''REDIRECT_REFRESH'');\n		        return;\n				break;\n				\n			case ''register'':\n				if (in_array(''register'', $disableServices)){return;}\n				$registration = $wlpe->Register($regType, $groups, $regRequired, $notify, $notifyTpl, $notifySubject);\n				\n				if (isset($regSuccessId) && $regSuccessId !== '''')\n				{\n					if ($registration == ''success'')\n					{\n						$url = rtrim($modx->config[''site_url''], ''/'').$modx->makeURL($regSuccessId);\n						header(''Refresh: ''.$regSuccessPause.'';URL=''.$url);\n						return $displayRegSuccessTpl;\n					}\n					return $displayRegisterTpl;\n					\n				}\n				if ($registration == ''success'')\n				{\n					return $displayRegSuccessTpl;\n				}\n				return $displayRegisterTpl;\n				break;\n\n			case ''forgot'' :\n				if (in_array(''forgot'', $disableServices)){return;}\n				return $displayResetTpl;\n				break;\n			\n			case ''resetpassword'' :\n				if (in_array(''resetpassword'', $disableServices)){return;}\n				$wlpe->ResetPassword();\n				if (isset($wlpe->Report)) \n				{\n					if (isset($_POST[''email'']))\n					{\n						return $displayResetTpl;\n					}\n					else\n					{\n						return $displayActivateTpl;\n					}\n				}\n				return;\n				break;\n			\n			case ''activate'' :\n				if (in_array(''activate'', $disableServices)){return;}\n				return $displayActivateTpl;\n				break;\n			\n			case ''activated'':\n                if (in_array(''activated'', $disableServices)){return;}\n                $wlpe->ActivateUser();\n                // pixelchutes 1:57 AM 9/19/2007\n                // Here we check for an error, then reload the activation template if necessary\n                // Do NOT reload if wlpe->Report indicates success\n                 // Added strip_tags() around string which means an error is not thrown regarding a modifier from closing\n                // html tag e.g. if $wlpe_lang[104] contains "</div>" this will fail as "/d" treated as modifier\n                if ( isset( $wlpe->Report ) && !preg_match( "/".strip_tags($wlpe_lang[104])."/i", $wlpe->Report ) )\n                {\n                    return $displayActivateTpl;\n                }                \n                return $displayLoginFormTpl;\n                break;\n			\n			default :\n				\n				if ($modx->getLoginUserID())\n				{\n					return $displaySuccessTpl;\n				}\n				else\n				{\n					$wlpe->AutoLogin();\n					return $displayLoginFormTpl;\n				}\n\n		}// [END] Switch : $service for simple.\n	}\n	\n	else if ($type == ''taconite'')\n	{\n		switch ($service) \n		{\n\n			case ''login'' :\n				if ($_SERVER[''REQUEST_METHOD''] == ''POST'')\n				{\n					$wlpe->Login($type, $liHomeId);\n				}\n				if (isset($wlpe->Report)) \n				{\n					return $wlpe->Report;\n				}\n				return;\n				break;\n\n			case ''logout'' :\n				$wlpe->Logout($type, $loHomeId);				\n				return;\n				break;\n\n			case ''register'' :\n				if (in_array(''register'', $disableServices)){return;}\n				$wlpe->Register($regType, $groups, $regRequired, $notify, $notifyTpl, $notifySubject);\n				return $wlpe->Report;\n				break;\n			\n			case ''resetpassword'' :\n				if (in_array(''resetpassword'', $disableServices)){return;}\n				$wlpe->ResetPassword();\n				return $wlpe->Report;\n				break;\n				\n			case ''activated'':\n				if (in_array(''activated'', $disableServices)){return;}\n				$wlpe->ActivateUser();\n				return $wlpe->Report;\n				break;\n					\n			default :\n				if ($modx->getLoginUserID())\n				{\n					return;\n				}\n				else\n				{\n					$wlpe->AutoLogin();\n				}\n		}// [END] Switch : $service for taconite.\n	}\n	\n	else\n	{\n		return;\n	}\n\n', 0, '', ''),
(4, 'Personalize', '<strong>2.1</strong> Personalize snippet', 0, 6, 0, '#::::::::::::::::::::::::::::::::::::::::\n# Created By:Ryan Thrash (modx@vertexworks.com),\n#	and then powered up by kudo (kudo@kudolink.com)\n#\n# Date: Aug 03, 2006\n#\n# Changelog:\n# Dec 01, 05 -- initial release\n# Jun 19, 06 -- updated description\n# Jul 19, 06 -- hacked by kudo to output chunks\n# Aug 03, 06 -- added placeholder for username\n# Aug 27, 10 -- powered up all code\n#\n#::::::::::::::::::::::::::::::::::::::::\n# Description:\n#	Checks to see if webusers are logged in and displays yesChunk if the user\n#	is logged or noChunk if user is not logged. Insert only the chunk name as\n#	param, without {{}}. Can use a placeholder to output the username.\n#	TESTED: can be used more than once per page.\n#	TESTED: chunks can contain snippets.\n#\n#\n# Params:\n#	&yesChunk [string] (optional)\n#		Output for LOGGED users\n#\n#	&noChunk [string] (optional)\n#		Output for NOT logged users\n#\n#	&ph [string] (optional)\n#		Placeholder for placing the username\n#		ATTENTION!: place this ph only in yesChunk!\n#\n#	&context [string] (optional)\n#		web|mgr\n#\n#	&yesTV [string] (optional)\n#		Output for LOGGED users\n#\n#	&noTV [string] (optional)\n#		Output for NOT logged users\n#\n# Example Usage:\n#\n#	[[Personalize? &yesChunk=`Link` &noChunk=`Register` &ph=`name`]]\n#\n#	Having Chunks named {{Link}} and another {{Register}}, the first will be\n#	published to registered user, the second to non-registered users.\n#\n#::::::::::::::::::::::::::::::::::::::::\n\n# prepare params and variables\n\nif     ($this->isFrontend() && isset ($_SESSION[''webValidated''])) $current_context = ''web'';\nelseif ($this->isBackend()  && isset ($_SESSION[''mgrValidated''])) $current_context = ''mgr'';\n\n$output = '''';\n$yesChunk = (isset($yesChunk))? $yesChunk : '''';\n$noChunk  = (isset($noChunk)) ? $noChunk  : '''';\n$ph       = (isset($ph))      ? $ph       : ''username'';\n$context  = (isset($context)) ? $context     : $current_context;\n$yesTV    = (isset($yesTV))   ? $yesTV : '''';\n$noTV     = (isset($noTV))    ? $noTV  : '''';\n\n/*\n$referer = htmlspecialchars($_SERVER[''HTTP_REFERER''], ENT_QUOTES);\n$ua =      htmlspecialchars($_SERVER[''HTTP_USER_AGENT''], ENT_QUOTES);\n$ip =      htmlspecialchars($_SERVER[''REMOTE_ADDR''], ENT_QUOTES);\n$host =    htmlspecialchars($_SERVER[''REMOTE_HOST''], ENT_QUOTES);\n\n$ua_strtolower = strtolower($_SERVER[''HTTP_USER_AGENT'']);\nif    (strpos($ua_strtolower, ''firefox'') !== false)     $browser = ''firefox'';\nelseif(strpos($ua_strtolower, ''trident/4.0'') !== false) $browser = ''internet explorer 8'';\nelseif(strpos($ua_strtolower, ''msie'') !== false)        $browser = ''internet explorer'';\nelseif(strpos($ua_strtolower, ''chrome'') !== false)      $browser = ''chrome'';\nelseif(strpos($ua_strtolower, ''safari'') !== false)      $browser = ''safari'';\nelseif(strpos($ua_strtolower, ''opera'') !== false)       $browser = ''opera'';\nelse $browser = ''other'';\n\n$modx->setPlaceholder(''referer'', $referer);\n$modx->setPlaceholder(''ua'',      $ua);\n$modx->setPlaceholder(''browser'', $browser);\n$modx->setPlaceholder(''ip'',      $ip);\n$modx->setPlaceholder(''host'',    $host);\n*/\n\nswitch($context)\n{\n    case ''web'':\n        $short_name = $_SESSION[''webShortname''];\n        $full_name  = $_SESSION[''webFullname''];\n        $email      = $_SESSION[''webEmail''];\n        $last_login = $_SESSION[''webLastlogin''];\n        break;\n    case ''mgr'':\n    case ''manager'':\n        $short_name = $_SESSION[''mgrShortname''];\n        $full_name  = $_SESSION[''mgrFullname''];\n        $email      = $_SESSION[''mgrEmail''];\n        $last_login = $_SESSION[''mgrLastlogin''];\n        break;\n    default:\n        $short_name = '''';\n}\nif (!empty($context))\n{\n    if($yesTV !== '''')\n    {\n        $pre_output = $modx->documentObject[$yesTV];\n        if(is_array($pre_output))\n        {\n            $output = $pre_output[1];\n        }\n        else\n        {\n            $output = $pre_output;\n        }\n    }\n    elseif($yesChunk !== '''')\n    {\n        $output = $modx->getChunk($yesChunk);\n    }\n    else\n    {\n        $output = ''username : '' . $short_name;\n    }\n\n    if(empty($last_login)) $last_login_text = ''first login'';\n    else                   $last_login_text = $modx->toDateFormat($last_login);\n\n    $modx->setPlaceholder($ph,$short_name);\n    $modx->setPlaceholder(''short_name'',  $short_name);\n    $modx->setPlaceholder(''full_name'',   $full_name);\n    $modx->setPlaceholder(''email'',       $email);\n    $modx->setPlaceholder(''last_login'', $last_login_text);\n}\nelse\n{\n    if($noTV !== '''')\n    {\n        $pre_output = $modx->documentObject[$noTV];\n        if(is_array($pre_output))\n        {\n            $output = $pre_output[1];\n        }\n        else\n        {\n            $output = $pre_output;\n        }\n    }\n    elseif($noChunk!=='''')\n    {\n        $output = $modx->getChunk($noChunk);\n    }\n    else\n    {\n        $output = ''guest'';\n    }\n}\nreturn $output;', 0, '', ''),
(5, 'MemberCheck', '<strong>1.1.1</strong> Show chunks based on a logged in Web User''s group membership', 0, 6, 0, '#::::::::::::::::::::::::::::::::::::::::\n# Version: 1.0\n# Created By Ryan Thrash (vertexworks.com)\n# Sanitized By Jason Coward (opengeek.com)\n#\n# Date: November 29, 2005\n#\n# Changelog: \n# Nov 29, 05 -- initial release\n# Jul 13, 06 -- adjusted Singleton to work under PHP4, added placeholder code (by: garryn)\n#\n#::::::::::::::::::::::::::::::::::::::::\n# Description: 	\n#	Checks to see if users belong to a certain group and \n#	displays the specified chunk if they do. Performs several\n#	sanity checks and allows to be used multiple times on a page.\n#\n# Params:\n#	&groups [array] (REQUIRED)\n#		array of webuser group-names to check against\n#\n#	&chunk [string] (REQUIRED)\n#		name of the chunk to use if passes the check\n#\n#	&ph [string] (optional)\n#		name of the placeholder to set instead of directly retuning chunk\n#\n#	&debug [boolean] (optional | false) \n#		turn on debug mode for extra troubleshooting\n#\n# Example Usage:\n#\n#	[[MemberCheck? &groups=`siteadmin, registered users` &chunk=`privateSiteNav` &ph=`MemberMenu` &debug=`true`]]\n#\n#	This would place the ''members-only'' navigation store in the chunk ''privateSiteNav''\n#	into a placeholder (called ''MemberMenu''). It will only do this as long as the user \n#	is logged in as a webuser and is a member of the ''siteadmin'' or the ''registered users''\n#	groups. The optional debug parameter can be used to display informative error messages \n#	when configuring this snippet for your site. For example, if the developer had \n#	mistakenly typed ''siteowners'' for the first group, and none existed with debug mode on, \n#	it would have returned the error message: The group siteowners could not be found....\n#\n#::::::::::::::::::::::::::::::::::::::::\n\n# debug parameter\n$debug = isset ($debug) ? $debug : false;\n\n# check if inside manager\nif ($m = $modx->insideManager()) {\n	return ''''; # don''t go any further when inside manager\n}\n\nif (!isset ($groups)) {\n	return $debug ? ''<p>Error: No Group Specified</p>'' : '''';\n}\n\nif (!isset ($chunk)) {\n	return $debug ? ''<p>Error: No Chunk Specified</p>'' : '''';\n}\n\n# turn comma-delimited list of groups into an array\n$groups = explode('','', $groups);\n\nif (!class_exists(''MemberCheck'')) {\n	class MemberCheck {\n		var $allGroups = NULL;\n		var $debug;\n\n		static function getInstance($debug) {\n			static $instance;\n			if (!isset ($instance)) {\n				$instance = new MemberCheck($debug);\n			}\n			return $instance;\n		}\n\n		function __construct($debug = false) {\n			global $modx;\n\n			$this->debug = $debug;\n			if ($debug) {\n				$this->allGroups = array ();\n				$tableName = $modx->getFullTableName(''webgroup_names'');\n				$sql = "SELECT name FROM $tableName";\n				if ($rs = $modx->db->query($sql)) {\n					while ($row = $modx->db->getRow($rs)) {\n						array_push($this->allGroups, stripslashes($row[''name'']));\n					}\n				}\n			}\n		}\n\n		function isValidGroup($groupName) {\n			$isValid = !(array_search($groupName, $this->allGroups) === false);\n			return $isValid;\n		}\n\n		function getMemberChunk(& $groups, $chunk) {\n			global $modx;\n			$o = '''';\n			if (is_array($groups)) {\n				for ($i = 0; $i < count($groups); $i++) {\n					$groups[$i] = trim($groups[$i]);\n					if ($this->debug) {\n						if (!$this->isValidGroup($groups[$i])) {\n							return "<p>The group <strong>" . $groups[$i] . "</strong> could not be found...</p>";\n						}\n					}\n				}\n\n				$check = $modx->isMemberOfWebGroup($groups);\n\n				$chunkcheck = $modx->getChunk($chunk);\n\n				$o .= ($check && $chunkcheck) ? $chunkcheck : '''';\n				if (!$chunkcheck)\n					$o .= $this->debug ? "<p>The chunk <strong>$chunk</strong> not found...</p>" : '''';\n			} else {\n				$o .= "<p>No valid group names were specified!</p>";\n			}\n\n			return $o;\n		}\n	}\n}\n\n$memberCheck = MemberCheck :: getInstance($debug);\n\nif (!isset ($ph)) {\n	return $memberCheck->getMemberChunk($groups, $chunk);\n} else {\n	$modx->setPlaceholder($ph, $memberCheck->getMemberChunk($groups, $chunk));\n	return '''';\n}\n', 0, '', ''),
(6, 'UltimateParent', '<strong>2.0</strong> Travels up the document tree from a specified document and returns its "ultimate" non-root parent', 0, 7, 0, '/*\n * @name UltimateParent\n * @version 2.0 beta (requires MODx 0.9.5+)\n * @author Jason Coward <modx@opengeek.com>\n * \n * @param &id The id of the document whose parent you want to find.\n * @param &top The top node for the search.\n * @param &topLevel The top level node for the search (root = level 1)\n * \n * @license Public Domain, use as you like.\n * \n * @example [[UltimateParent? &id=`45` &top=`6`]] \n * Will find the ultimate parent of document 45 if it is a child of document 6;\n * otherwise it will return 45.\n * \n * @example [[UltimateParent? &topLevel=`2`]]\n * Will find the ultimate parent of the current document at a depth of 2 levels\n * in the document hierarchy, with the root level being level 1.\n * \n * This snippet travels up the document tree from a specified document and\n * returns the "ultimate" parent.  Version 2.0 was rewritten to use the new\n * getParentIds function features available only in MODx 0.9.5 or later.\n * \n * Based on the original UltimateParent 1.x snippet by Susan Ottwell\n * <sottwell@sottwell.com>.  The topLevel parameter was introduced by staed and\n * adopted here.\n */\n$top= isset ($top) && intval($top) ? $top : 0;\n$id= isset ($id) && intval($id) ? intval($id) : $modx->documentIdentifier;\n$topLevel= isset ($topLevel) && intval($topLevel) ? intval($topLevel) : 0;\nif ($id && $id != $top) {\n    $pid= $id;\n    if (!$topLevel || count($modx->getParentIds($id)) >= $topLevel) {\n        while ($parentIds= $modx->getParentIds($id, 1)) {\n            $pid= array_pop($parentIds);\n            if ($pid == $top) {\n                break;\n            }\n            $id= $pid;\n            if ($topLevel && count($modx->getParentIds($id)) < $topLevel) {\n                break;\n            }\n        }\n    }\n}\nreturn $id;', 0, '', ''),
(7, 'FirstChildRedirect', '<strong>1.0</strong> Automatically redirects to the first child of a Container Resource', 0, 7, 0, '/*\n * @name FirstChildRedirect\n * @author Jason Coward <jason@opengeek.com>\n * @modified-by Ryan Thrash <ryan@vertexworks.com>\n * @license Public Domain\n * @version 1.0\n * \n * This snippet redirects to the first child document of a folder in which this\n * snippet is included within the content (e.g. [!FirstChildRedirect!]).  This\n * allows MODx folders to emulate the behavior of real folders since MODx\n * usually treats folders as actual documents with their own content.\n * \n * Modified to make Doc ID a required parameter... now defaults to the current \n * Page/Folder you call the snippet from.\n * \n * &docid=`12` \n * Use the docid parameter to have this snippet redirect to the\n * first child document of the specified document.\n */\n\n$docid = (isset($docid))? $docid: $modx->documentIdentifier;\n\n$children= $modx->getActiveChildren($docid, ''menuindex'', ''ASC'');\nif (!$children === false) {\n    $firstChild= $children[0];\n    $firstChildUrl= $modx->makeUrl($firstChild[''id'']);\n} else {\n    $firstChildUrl= $modx->makeUrl($modx->config[''site_start'']);\n}\nreturn $modx->sendRedirect($firstChildUrl);\n', 0, '', '');
INSERT INTO `[[dbprefix]]site_snippets` VALUES
(8, 'List', '<strong>2.1.3</strong> Summarizes and lists pages to create blogs, catalogs, PR archives, bio listings and more', 0, 4, 0, '/* Description:\n *      Aggregates documents to create blogs, article/news\n *      collections, and more,with full support for templating.\n * \n * Author: \n *      Mark Kaplan for MODx CMF (up to 2.1.0).\n *		This version modified by Tim Spencer in 2012/2013 (see changelog.txt)\n*/\n\n//---Core Settings---------------------------------------------------- //\n\n$ditto_version = "2.1.1";\n    // Ditto version being executed\n\n$ditto_base = isset($ditto_base) ? $modx->config[''base_path''].$ditto_base : $modx->config[''base_path'']."assets/snippets/list/";\n/*\n    Param: ditto_base\n    \n    Purpose:\n    Location of Ditto files\n\n    Options:\n    Any valid folder location containing the Ditto source code with a trailing slash\n\n    Default:\n    [(base_path)]assets/snippets/list/\n*/\n$dittoID = (!isset($id)) ? "" : $id."_";\n$GLOBALS["dittoID"] = $dittoID;\n/*\n    Param: id\n\n    Purpose:\n    Unique ID for this Ditto instance for connection with other scripts (like Reflect) and unique URL parameters\n\n    Options:\n    Any combination of characters a-z, underscores, and numbers 0-9\n    \n    Note:\n    This is case sensitive\n\n    Default:\n    "" - blank\n*/      \n$language = (isset($language))? $language : $modx->config[''manager_language''];\nif (!file_exists($ditto_base."lang/".$language.".inc.php")) {\n    $language ="english";\n}\n/*\n    Param: language\n\n    Purpose:\n    language for defaults, debug, and error messages\n\n    Options:\n    Any language name with a corresponding file in the &ditto_base/lang folder\n\n    Default:\n    "english"\n*/\n$format = (isset($format)) ? strtolower($format) : "html" ;\n/*\n    Param: format\n\n    Purpose:\n    Output format to use\n\n    Options:\n    - "html"\n    - "json"\n    - "xml"\n    - "atom"\n    - "rss"\n\n    Default:\n    "html"\n*/\n$config = (isset($config)) ? $config : "default";\n/*\n    Param: config\n\n    Purpose:\n    Load a custom configuration\n\n    Options:\n    "default" - default blank config file\n    CONFIG_NAME - Other configs installed in the configs folder or in any folder within the MODx base path via @FILE\n\n    Default:\n    "default"\n    \n    Related:\n    - <extenders>\n*/\n$debug = isset($debug)? $debug : 0;\n/*\n    Param: debug\n\n    Purpose:\n    Output debugging information\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    0 - off\n    \n    Related:\n    - <debug>\n*/\n$phx = (isset($phx))? $phx : 1;\n/*\n    Param: phx\n\n    Purpose:\n    Use PHx formatting\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    1 - on\n*/      \n$extenders = isset($extenders) ? explode(",",$extenders) : array();\n/*\n    Param: extenders\n\n    Purpose:\n    Load an extender which adds functionality to Ditto\n\n    Options:\n    Any extender in the extenders folder or in any folder within the MODx base path via @FILE\n\n    Default:\n    [NULL]\n\n    Related:\n    - <config>\n*/\n    // Variable: extenders\n    // Array that can be added to by configs or formats to load that extender\n    \n$placeholders = array();\n    // Variable: placeholders\n    // Initialize custom placeholders array for configs or extenders to add to\n\n$filters = array("custom"=>array(),"parsed"=>array());\n    // Variable: filters\n    // Holds both the custom filters array for configs or extenders to add to \n    // and the parsed filters array. To add to this array, use the following format\n    // (code)\n    // $filters["parsed"][] = array("name" => array("source"=>$source,"value"=>$value,"mode"=>$mode));\n    // $filters["custom"][] = array("source","callback_function");\n\n$orderBy = array(''parsed''=>array(),''custom''=>array(),''unparsed''=>$orderBy);\n    // Variable: orderBy\n    // An array that holds all criteria to sort the result set by. \n    // Note that using a custom sort will disable all other sorting.\n    // (code)\n    // $orderBy["parsed"][] = array("sortBy","sortDir");\n    // $orderBy["custom"][] = array("sortBy","callback_function");\n        \n//---Includes-------------------------------------------------------- //\n\n$language_files = array(\n    ''base_language'' => $ditto_base.''lang/english.inc.php'',\n    ''language'' => $ditto_base."lang/$language.inc.php"\n);\nforeach ($language_files as $filevalue) {\n    if (file_exists($filevalue)) {\n        require($filevalue);\n        if (!$modx->convertLanguageArray($_lang, $language_files[''base_language''], ''_lang'')) {\n            $modx->logEvent(1, 3, "Language file cannot be completely converted to {$modx->config[''modx_charset'']}. Please check: $filevalue");\n        }\n    } else {\n        $modx->logEvent(1, 3, "Language file does not exist Please check: $filevalue");\n    }\n}\n\n$files = array (\n    "main_class" => $ditto_base."classes/ditto.class.inc.php",\n    "template_class" => $ditto_base."classes/template.class.inc.php",\n    "filter_class" => $ditto_base."classes/filter.class.inc.php",\n    "format" => $ditto_base."formats/$format.format.inc.php",\n    "config" => $ditto_base."configs/default.config.php",\n    "user_config" => (substr($config, 0, 5) != "@FILE") ? $ditto_base."configs/$config.config.php" : $modx->config[''base_path''].trim(substr($config, 5))\n);\n\nif ($phx == 1) {\n    $files["prePHx_class"] = $ditto_base."classes/phx.pre.class.inc.php";\n}\nif (isset($randomize)) {\n    $files["randomize_class"] = $ditto_base."classes/random.class.inc.php";\n}\nif ($debug == 1) {\n    $files["modx_debug_class"] = $ditto_base."debug/modxDebugConsole.class.php";\n    $files["debug_class"] = $ditto_base."classes/debug.class.inc.php";\n    $files["debug_templates"] = $ditto_base."debug/debug.templates.php";\n}\n\n$files = array_unique($files);\nforeach ($files as $filename => $filevalue) {\n    if (file_exists($filevalue) && strpos($filename,"class")) {\n        include_once($filevalue);\n    } else if (file_exists($filevalue)) {\n        include($filevalue);\n    } else {\n        $modx->logEvent(1, 3, $filevalue . " " . $_lang[''file_does_not_exist''], "Ditto " . $ditto_version);\n        return $filevalue . " " . $_lang[''file_does_not_exist''];\n    }\n}\n\n//---Initiate Class-------------------------------------------------- //\nif (class_exists(''ditto'')) {\n    $ditto = new ditto($dittoID,$format,$_lang,$dbg_templates);\n        // create a new Ditto instance in the specified format and language with the requested debug level\n} else {\n    $modx->logEvent(1,3,$_lang[''invalid_class''],"Ditto ".$ditto_version);\n    return $_lang[''invalid_class''];\n}\n\n//---Initiate Extenders---------------------------------------------- //\nif (isset($tagData)) {\n    $extenders[] = "tagging";\n}\nif(count($extenders) > 0) {\n    $extenders = array_unique($extenders);\n    foreach ($extenders as $extender) {\n            if(substr($extender, 0, 5) != "@FILE") {\n                $extender_path = $ditto_base."extenders/".$extender.".extender.inc.php";                \n            } else {\n                $extender_path = $modx->config[''base_path''].trim(substr($extender, 5));\n            }\n            \n            if (file_exists($extender_path)){\n                include($extender_path);\n            } else {\n                $modx->logEvent(1, 3, $extender . " " . $_lang[''extender_does_not_exist''], "Ditto ".$ditto_version);\n                return $extender . " " . $_lang[''extender_does_not_exist''];\n            }       \n    }   \n}\n\n//---Parameters------------------------------------------------------- /*\nif (isset($startID)) {$parents = $startID;}\nif (isset($summarize)) {$display = $summarize;}\nif (isset($limit)) {$queryLimit = $limit;}\nif (isset($sortBy) || isset($sortDir) || is_null($orderBy[''unparsed''])) {\n    $sortDir = isset($sortDir) ? strtoupper($sortDir) : ''DESC'';\n    $sortBy = isset($sortBy) ? $sortBy : "createdon";\n    $orderBy[''parsed''][]=array($sortBy,$sortDir);\n}\n    // Allow backwards compatibility\n\n$idType = isset($documents) ? "documents" : "parents";\n    // Variable: idType\n    // type of IDs provided; can be either parents or documents\n\n$parents = isset($parents) ? $ditto->cleanIDs($parents) : $modx->documentIdentifier;\n\n/*\n    Param: parents\n\n    Purpose:\n    IDs of containers for Ditto to retrieve their children to &depth depth\n\n    Options:\n    Any valid MODx document marked as a container\n\n    Default:\n    Current MODx Document\n\n    Related:\n    - <documents>\n    - <depth>\n*/\n$documents = isset($documents) ? $ditto->cleanIDs($documents) : false;\n/*\n    Param: documents\n\n    Purpose:\n    IDs of documents for Ditto to retrieve\n\n    Options:\n    Any valid MODx document marked as a container\n\n    Default:\n    None\n\n    Related:\n    - <parents>\n*/\n\n$IDs = ($idType == "parents") ? $parents : $documents;\n    // Variable: IDs\n    // Internal variable which holds the set of IDs for Ditto to fetch\n\n$depth = isset($depth) ? $depth : 1;\n/*\n    Param: depth\n\n    Purpose:\n    Number of levels deep to retrieve documents\n\n    Options:\n    Any number greater than or equal to 1\n    0 - infinite depth\n\n    Default:\n    1\n\n    Related:\n    - <seeThruUnpub>\n*/\n$paginate = isset($paginate)? $paginate : 0;\n/*\n    Param: paginate\n\n    Purpose:\n    Paginate the results set into pages of &display length.\n    Use &total to limit the number of documents retreived.\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    0 - off\n    \n    Related:\n    - <paginateAlwaysShowLinks>\n    - <paginateSplitterCharacter>\n    - <display>\n*/\n$dateSource = isset($dateSource) ? $dateSource : "createdon";\n/*\n    Param: dateSource\n\n    Purpose:\n    Source of the [+date+] placeholder\n\n    Options:\n    # - Any UNIX timestamp from MODx fields or TVs such as createdon, pub_date, or editedon\n    \n    Default:\n    "createdon"\n    \n    Related:\n    - <dateFormat>\n*/\n$dateFormat = isset($dateFormat)? $dateFormat : $_lang["dateFormat"];\n/*\n    Param: dateFormat\n\n    Purpose:\n    Format the [+date+] placeholder in human readable form\n\n    Options:\n    Any PHP valid strftime option\n\n    Default:\n    [LANG]\n    \n    Related:\n    - <dateSource>\n*/\n$display = isset($display) ? $display : "all";\n/*\n    Param: display\n\n    Purpose:\n    Number of documents to display in the results\n\n    Options:\n    # - Any number\n    "all" - All documents found\n\n    Default:\n    "all"\n    \n    Related:\n    - <queryLimit>\n    - <total>\n*/\n$total = isset($total) ? $total : "all";\n/*\n    Param: total\n\n    Purpose:\n    Number of documents to retrieve\n    \n    Options:\n    # - Any number\n    "all" - All documents found\n\n    Default:\n    "all" - All documents found\n    \n    Related:\n    - <display>\n    - <queryLimit>\n*/\n$showPublishedOnly = isset($showPublishedOnly) ? $showPublishedOnly : 1;\n/*\n    Param: showPublishedOnly\n\n    Purpose:\n    Show only published documents\n\n    Options:\n    0 - show only unpublished documents\n    1 - show both published and unpublished documents\n    \n    Default:\n    1 - show both published and unpublished documents\n    \n    Related:\n    - <seeThruUnpub>\n    - <hideFolders>\n    - <showPublishedOnly>\n    - <where>\n*/\n$showInMenuOnly = isset($showInMenuOnly) ? $showInMenuOnly : 0;\n/*\n    Param: showInMenuOnly\n\n    Purpose:\n    Show only documents visible in the menu\n\n    Options:\n    0 - show all documents\n    1 - show only documents with the show in menu flag checked\n    \n    Default:\n    0 - show all documents\n    \n    Related:\n    - <seeThruUnpub>\n    - <hideFolders>\n    - <where>\n*/\n$hideFolders = isset($hideFolders)? $hideFolders : 0;\n/*\n    Param: hideFolders\n\n    Purpose:\n    Don''t show folders in the returned results\n\n    Options:\n    0 - keep folders\n    1 - remove folders\n    \n    Default:\n    0 - keep folders\n    \n    Related:\n    - <seeThruUnpub>\n    - <showInMenuOnly>\n    - <where>\n*/\n$hidePrivate = isset($hidePrivate)? $hidePrivate : 1;\n/*\n    Param: hidePrivate\n\n    Purpose:\n    Don''t show documents the guest or user does not have permission to see\n\n    Options:\n    0 - show private documents\n    1 - hide private documents\n    \n    Default:\n    1 - hide private documents\n    \n    Related:\n    - <seeThruUnpub>\n    - <showInMenuOnly>\n    - <where>\n*/\n$seeThruUnpub = (isset($seeThruUnpub))? $seeThruUnpub : 1 ;\n/*\n    Param: seeThruUnpub\n\n    Purpose:\n    See through unpublished folders to retrive their children\n    Used when depth is greater than 1\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    0 - off\n    \n    Related:\n    - <hideFolders>\n    - <showInMenuOnly>\n    - <where>\n*/\n$queryLimit = (isset($queryLimit))? $queryLimit : 0;\n/*\n    Param: queryLimit\n\n    Purpose:\n    Number of documents to retrieve from the database, same as MySQL LIMIT\n\n    Options:\n    # - Any number\n    0 - automatic\n\n    Default:\n    0 - automatic\n    \n    Related:\n    - <where>\n*/\n$where = (isset($where))? $where : "";\n/*\n    Param: where\n\n    Purpose:\n    Custom MySQL WHERE statement\n\n    Options:\n    A valid MySQL WHERE statement using only document object items (no TVs)\n\n    Default:\n    [NULL]\n    \n    Related:\n    - <queryLimit>\n*/\n$noResults = isset($noResults)? $ditto->getParam($noResults,"no_documents") : $_lang[''no_documents''];\n/*\n    Param: noResults\n\n    Purpose:\n    Text or chunk to display when there are no results\n\n    Options:\n    Any valid chunk name or text\n\n    Default:\n    [LANG]\n*/\n$removeChunk = isset($removeChunk) ? explode(",",$removeChunk) : false;\n/*\n    Param: removeChunk\n\n    Purpose:\n    Name of chunks to be stripped from content separated by commas\n    - Commonly used to remove comments\n\n    Options:\n    Any valid chunkname that appears in the output\n\n    Default:\n    [NULL]\n*/\n$hiddenFields = isset($hiddenFields) ? explode(",",$hiddenFields) : false;\n/*\n    Param: hiddenFields\n\n    Purpose:\n    Allow Ditto to retrieve fields its template parser cannot handle such as nested placeholders and [*fields*]\n\n    Options:\n    Any valid MODx fieldnames or TVs comma separated\n\n    Default:\n    [NULL]\n*/\n$offset = isset($start) ? $start : 0;\n$start = (isset($_GET[$dittoID.''start''])) ? intval($_GET[$dittoID.''start'']) : 0;\n/*\n    Param: start\n\n    Purpose:\n    Number of documents to skip in the results\n    \n    Options:\n    Any number\n\n    Default:\n    0\n*/\n$globalFilterDelimiter = isset($globalFilterDelimiter) ? $globalFilterDelimiter : "|";\n/*\n    Param: globalFilterDelimiter\n\n    Purpose:\n    Filter delimiter used to separate filters in the filter string\n    \n    Options:\n    Any character not used in the filters\n\n    Default:\n    "|"\n    \n    Related:\n    - <localFilterDelimiter>\n    - <filter>\n    - <parseFilters>\n*/\n    \n$localFilterDelimiter = isset($localFilterDelimiter) ? $localFilterDelimiter : ",";\n/*\n    Param: localFilterDelimiter\n\n    Purpose:\n    Delimiter used to separate individual parameters within each filter string\n    \n    Options:\n    Any character not used in the filter itself\n\n    Default:\n    ","\n    \n    Related:\n    - <globalFilterDelimiter>\n    - <filter>\n    - <parseFilters>\n*/\n$filters["custom"] = isset($cFilters) ? array_merge($filters["custom"],$cFilters) : $filters["custom"];\n$filters["parsed"] = isset($parsedFilters) ? array_merge($filters["parsed"],$parsedFilters) : $filters["parsed"];\n    // handle 2.0.0 compatibility\n$filter = (isset($filter) || ($filters["custom"] != false) || ($filters["parsed"] != false)) ? $ditto->parseFilters($filter,$filters["custom"],$filters["parsed"],$globalFilterDelimiter,$localFilterDelimiter) : false;\n/*\n    Param: filter\n\n    Purpose:\n    Removes items not meeting a critera. Thus, if pagetitle == joe then it will be removed.\n    Use in the format field,criteria,mode with the comma being the local delimiter\n\n    *Mode* *Meaning*\n    \n    1 - !=\n    2 - ==\n    3 - <\n    4 - >\n    5 - <=\n    6 - >=\n    7 - Text not in field value\n    8 - Text in field value\n    9 - case insenstive version of #7\n    10 - case insenstive version of #8\n    11 - checks leading character of the field\n    \n    @EVAL:\n        @EVAL in filters works the same as it does in MODx exect it can only be used \n        with basic filtering, not custom filtering (tagging, etc). Make sure that\n        you return the value you wish Ditto to filter by and that the code is valid PHP.\n\n    Default:\n    [NULL]\n    \n    Related:\n    - <localFilterDelimiter>\n    - <globalFilterDelimiter>\n    - <parseFilters>\n*/\n$keywords = (isset($keywords))? $keywords : 0;\n/*  \n    Param: keywords\n    \n    Purpose: \n    Enable fetching of associated keywords for each document\n    Can be used as [+keywords+] or as a tagData source\n    \n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    0 - off\n*/\n\n$randomize = (isset($randomize))? $randomize : 0;\n/*  \n    Param: randomize\n    \n    Purpose: \n    Randomize the order of the output\n    \n    Options:\n    0 - off\n    1 - on\n    Any MODx field or TV for weighted random\n    \n    Default:\n    0 - off\n*/\n$save = (isset($save))? $save : 0;\n/*\n    Param: save\n\n    Purpose:\n    Saves the ditto object and results set to placeholders\n    for use by other snippets\n\n    Options:\n    0 - off; returns output\n    1 - remaining; returns output\n    2 - all;\n    3 - all; returns ph only\n\n    Default:\n        0 - off; returns output\n*/\n$templates = array(\n    "default" => "@CODE".$_lang[''default_template''],\n    "base" => $tpl,\n    "alt" => $tplAlt,\n    "first" => $tplFirst,\n    "last" => $tplLast,\n    "current" => $tplCurrentDocument\n);\n/*\n    Param: tpl\n\n    Purpose:\n    User defined chunk to format the documents \n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE\n    - File via @FILE\n\n    Default:\n    [LANG]\n*/\n/*\n    Param: tplAlt\n\n    Purpose:\n    User defined chunk to format every other document\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE\n    - File via @FILE\n\n    Default:\n    &tpl\n*/\n/*\n    Param: tplFirst\n\n    Purpose:\n    User defined chunk to format the first document \n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE\n    - File via @FILE\n\n    Default:\n    &tpl\n*/\n/*\n    Param: tplLast\n\n    Purpose:\n    User defined chunk to format the last document \n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE\n    - File via @FILE\n\n    Default:\n    &tpl\n*/\n/*\n    Param: tplCurrentDocument\n\n    Purpose:\n    User defined chunk to format the current document\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE\n    - File via @FILE\n\n    Default:\n    &tpl\n*/\n$orderBy = $ditto->parseOrderBy($orderBy,$randomize);\n/*\n    Param: orderBy\n\n    Purpose:\n    Sort the result set\n\n    Options:\n    Any valid MySQL style orderBy statement\n\n    Default:\n    createdon DESC\n*/\n//-------------------------------------------------------------------- */\n$templates = $ditto->template->process($templates);\n    // parse the templates for TV''s and store them for later use\n\n$ditto->setDisplayFields($ditto->template->fields,$hiddenFields);\n    // parse hidden fields\n    \n$ditto->parseFields($placeholders,$seeThruUnpub,$dateSource,$randomize);\n    // parse the fields into the field array\n    \n$documentIDs = $ditto->determineIDs($IDs, $idType, $ditto->fields["backend"]["tv"], $orderBy, $depth, $showPublishedOnly, $seeThruUnpub, $hideFolders, $hidePrivate, $showInMenuOnly, $where, $keywords, $dateSource, $queryLimit, $display, $filter,$paginate, $randomize);\n    // retrieves a list of document IDs that meet the criteria and populates the $resources array with them\n$count = count($documentIDs);\n    // count the number of documents to be retrieved\n$count = $count-$offset;\n    // handle the offset\n\nif ($count > 0) {\n    // if documents are returned continue with execution\n    \n    $total = ($total == "all") ? $count : min($total,$count);\n        // set total equal to count if all documents are to be included\n    \n    $display = ($display == "all") ? min($count,$total) : min($display,$total);\n        // allow show to use all option\n\n    $stop = ($save != "1") ? min($total-$start,$display) : min($count,$total);\n        // set initial stop count\n\n    if($paginate == 1) {\n        $paginateAlwaysShowLinks = isset($paginateAlwaysShowLinks)? $paginateAlwaysShowLinks : 0;\n        /*\n            Param: paginateAlwaysShowLinks\n\n            Purpose:\n            Determine whether or not to always show previous next links\n\n            Options:\n            0 - off\n            1 - on\n\n            Default:\n            0 - off\n        \n            Related:\n            - <paginate>\n            - <paginateSplitterCharacter>\n        */\n        $paginateSplitterCharacter = isset($paginateSplitterCharacter)? $paginateSplitterCharacter : $_lang[''button_splitter''];\n        /*\n            Param: paginateSplitterCharacter\n\n            Purpose:\n            Splitter to use if always show is disabled\n\n            Options:\n            Any valid character\n\n            Default:\n            [LANG]\n        \n            Related:\n            - <paginate>\n            - <paginateSplitterCharacter>\n        */\n        $tplPaginatePrevious = isset($tplPaginatePrevious)? $ditto->template->fetch($tplPaginatePrevious) : "<a href=''[+url+]'' class=''ditto_previous_link''>[+lang:previous+]</a>";\n        /*\n            Param: tplPaginatePrevious\n\n            Purpose:\n            Template for the previous link\n\n            Options:\n            - Any valid chunk name\n            - Code via @CODE\n            - File via @FILE\n\n            Placeholders:\n            url - URL for the previous link\n            lang:previous - value of ''prev'' from the language file\n        \n            Related:\n            - <tplPaginateNext>\n            - <paginateSplitterCharacter>\n        */\n        $tplPaginateNext = isset($tplPaginateNext)? $ditto->template->fetch($tplPaginateNext) : "<a href=''[+url+]'' class=''ditto_next_link''>[+lang:next+]</a>";\n        /*\n            Param: tplPaginateNext\n\n            Purpose:\n            Template for the next link\n\n            Options:\n            - Any valid chunk name\n            - Code via @CODE\n            - File via @FILE\n\n            Placeholders:\n            url - URL for the next link\n            lang:next - value of ''next'' from the language file\n        \n            Related:\n            - <tplPaginatePrevious>\n            - <paginateSplitterCharacter>\n        */\n        $tplPaginateNextOff = isset($tplPaginateNextOff)? $ditto->template->fetch($tplPaginateNextOff) : "<span class=''ditto_next_off ditto_off''>[+lang:next+]</span>";\n        /*\n            Param: tplPaginateNextOff\n\n            Purpose:\n            Template for the inside of the next link\n\n            Options:\n            - Any valid chunk name\n            - Code via @CODE\n            - File via @FILE\n\n            Placeholders:\n            lang:next - value of ''next'' from the language file\n        \n            Related:\n            - <tplPaginatePrevious>\n            - <paginateSplitterCharacter>\n        */\n        $tplPaginatePreviousOff = isset($tplPaginatePreviousOff)? $ditto->template->fetch($tplPaginatePreviousOff) : "<span class=''ditto_previous_off ditto_off''>[+lang:previous+]</span>";\n        /*\n            Param: tplPaginatePreviousOff\n\n            Purpose:\n            Template for the previous link when it is off\n\n            Options:\n            - Any valid chunk name\n            - Code via @CODE\n            - File via @FILE\n\n            Placeholders:\n            lang:previous - value of ''prev'' from the language file\n    \n            Related:\n            - <tplPaginatePrevious>\n            - <paginateSplitterCharacter>\n        */\n        $tplPaginatePage = isset($tplPaginatePage)? $ditto->template->fetch($tplPaginatePage) : "<a class=''ditto_page'' href=''[+url+]''>[+page+]</a>";\n        /*\n            Param: tplPaginatePage\n\n            Purpose:\n            Template for the page link\n\n            Options:\n            - Any valid chunk name\n            - Code via @CODE\n            - File via @FILE\n\n            Placeholders:\n            url - url for the page\n            page - number of the page\n    \n            Related:\n            - <tplPaginatePrevious>\n            - <paginateSplitterCharacter>\n        */\n        $tplPaginateCurrentPage = isset($tplPaginateCurrentPage)? $ditto->template->fetch($tplPaginateCurrentPage) : "<span class=''ditto_currentpage''>[+page+]</span>";\n        /*\n            Param: tplPaginateCurrentPage\n\n            Purpose:\n            Template for the current page link\n\n            Options:\n            - Any valid chunk name\n            - Code via @CODE\n            - File via @FILE\n\n            Placeholders:\n            page - number of the page\n    \n            Related:\n            - <tplPaginatePrevious>\n            - <paginateSplitterCharacter>\n        */\n        \n        $ditto->paginate($start, $stop, $total, $display, $tplPaginateNext, $tplPaginatePrevious, $tplPaginateNextOff, $tplPaginatePreviousOff, $tplPaginatePage, $tplPaginateCurrentPage, $paginateAlwaysShowLinks, $paginateSplitterCharacter);\n            // generate the pagination placeholders\n    }\n\n    $dbFields = $ditto->fields["display"]["db"];\n        // get the database fields\n    $TVs = $ditto->fields["display"]["tv"];\n        // get the TVs\n    \n    switch($orderBy[''parsed''][0][1]) {\n        case "DESC":\n            $stop = ($ditto->prefetch === false) ? $stop + $start + $offset : $stop + $offset; \n            $start += $offset;\n        break;\n        case "ASC":\n            $start += $offset;\n            $stop += $start;\n        break;\n    }\n\n    if ($ditto->prefetch !== false) {\n        $documentIDs = array_slice($documentIDs,$start,$stop);\n            // set the document IDs equal to the trimmed array\n        $dbFields = array_diff($dbFields,$ditto->prefetch["fields"]["db"]);\n            // calculate the difference between the database fields and those already prefetched\n        $dbFields[] = "id";\n            // append id to the db fields array\n        $TVs = array_diff($TVs,$ditto->prefetch["fields"]["tv"]);\n            // calculate the difference between the tv fields and those already prefetched\n        $start = 0;\n        $stop = min($display,($queryLimit != 0) ? $queryLimit : $display,count($documentIDs));\n    } else {\n        $queryLimit = ($queryLimit == 0) ? "" : $queryLimit;\n    }\n    \n    $resource = $ditto->getDocuments($documentIDs, $dbFields, $TVs, $orderBy, $showPublishedOnly, 0, $hidePrivate, $where, $queryLimit, $keywords, $randomize, $dateSource);\n        // retrieves documents\n    $output = $header;\n        // initialize the output variable and send the header\n\n    if ($resource) {\n        if ($randomize != "0" && $randomize != "1") {\n            $resource = $ditto->weightedRandom($resource,$randomize,$stop);\n                // randomize the documents\n        }\n        \n        $resource = array_values($resource);\n\n        for ($x=$start;$x<$stop;$x++) {\n            $template = $ditto->template->determine($templates,$x,0,$stop,$resource[$x]["id"]);\n                // choose the template to use and set the code of that template to the template variable\n            $renderedOutput = $ditto->render($resource[$x], $template, $removeChunk, $dateSource, $dateFormat, $placeholders,$phx,abs($start-$x));\n                // render the output using the correct template, in the correct format and language\n            $modx->setPlaceholder($dittoID."item[".abs($start-$x)."]",$renderedOutput);\n            /*\n                Placeholder: item[x]\n\n                Content:\n                Individual items rendered output\n            */\n            $output .= $renderedOutput;\n                // send the rendered output to the buffer\n        }\n    } else {\n        $output .= $ditto->noResults($noResults,$paginate);\n            // if no documents are found return a no documents found string\n    }\n    $output .= $footer;\n        // send the footer\n\n    // ---------------------------------------------------\n    // Save Object\n    // ---------------------------------------------------\n\n    if($save) {\n        $modx->setPlaceholder($dittoID."ditto_object", $ditto);\n        $modx->setPlaceholder($dittoID."ditto_resource", ($save == "1") ? array_slice($resource,$display) : $resource);\n    }\n} else {\n    $output = $header.$ditto->noResults($noResults,$paginate).$footer;\n}\n// ---------------------------------------------------\n// Handle Debugging\n// ---------------------------------------------------\n\nif ($debug == 1) {\n    $ditto_params =& $modx->event_params;\n    if (!isset($_GET["ditto_".$dittoID."debug"])) {\n    $_SESSION["ditto_debug_$dittoID"] = $ditto->debug->render_popup($ditto, $ditto_base, $ditto_version, $ditto_params, $documentIDs, array("db"=>$dbFields,"tv"=>$TVs), $display, $templates, $orderBy, $start, $stop, $total,$filter,$resource);\n    }\n    if (isset($_GET["ditto_".$dittoID."debug"])) {\n        switch ($_GET["ditto_".$dittoID."debug"]) {\n            case "open" :\n                exit($_SESSION["ditto_debug_$dittoID"]);\n            break;\n            case "save" :\n                $ditto->debug->save($_SESSION["ditto_debug_$dittoID"],"ditto".strtolower($ditto_version)."_debug_doc".$modx->documentIdentifier.".html");\n            break;\n        }\n    } else {\n        $output = $ditto->debug->render_link($dittoID,$ditto_base).$output;\n    }\n}\n\nreturn ($save != 3) ? $output : "";\n', 0, '', ''),
(9, 'Reflect', '<strong>2.1.0</strong> Generates date-based archives using List', 0, 4, 0, '/*\n * Author: \n *      Mark Kaplan for MODx CMF\n * \n * Note: \n *      If Reflect is not retrieving its own documents, make sure that the\n *          Ditto call feeding it has all of the fields in it that you plan on\n *       calling in your Reflect template. Furthermore, Reflect will ONLY\n *          show what is currently in the Ditto result set.\n *       Thus, if pagination is on it will ONLY show that page''s items.\n*/\n \n\n// ---------------------------------------------------\n//  Includes\n// ---------------------------------------------------\n\n$reflect_base = isset($reflect_base) ? $modx->config[''base_path''].$reflect_base : $modx->config[''base_path'']."assets/snippets/reflect/";\n/*\n    Param: ditto_base\n    \n    Purpose:\n    Location of Ditto files\n\n    Options:\n    Any valid folder location containing the Ditto source code with a trailing slash\n\n    Default:\n    [(base_path)]assets/snippets/ditto/\n*/\n\n$config = (isset($config)) ? $config : "default";\n/*\n    Param: config\n\n    Purpose:\n    Load a custom configuration\n\n    Options:\n    "default" - default blank config file\n    CONFIG_NAME - Other configs installed in the configs folder or in any folder within the MODx base path via @FILE\n\n    Default:\n    "default"\n    \n    Related:\n    - <extenders>\n*/\n\nrequire($reflect_base."configs/default.config.php");\nrequire($reflect_base."default.templates.php");\nif ($config != "default") {\n    require((substr($config, 0, 5) != "@FILE") ? $reflect_base."configs/$config.config.php" : $modx->config[''base_path''].trim(substr($config, 5)));\n}\n\n// ---------------------------------------------------\n//  Parameters\n// ---------------------------------------------------\n\n$id = isset($id) ? $id."_" : false;\n/*\n    Param: id\n\n    Purpose:\n    Unique ID for this Ditto instance for connection with other scripts (like Reflect) and unique URL parameters\n\n    Options:\n    Any valid folder location containing the Ditto source code with a trailing slash\n\n    Default:\n    "" - blank\n*/\n$getDocuments = isset($getDocuments) ? $getDocuments : 0;\n/*\n    Param: getDocuments\n\n    Purpose:\n    Force Reflect to get documents\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    0 - off\n*/\n$showItems = isset($showItems) ? $showItems : 1;\n/*\n    Param: showItems\n\n    Purpose:\n    Show individual items in the archive\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    1 - on\n*/\n$groupByYears = isset($groupByYears)? $groupByYears : 1;\n/*\n    Param: groupByYears\n\n    Purpose:\n    Group the archive by years\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    1 - on\n*/\n$targetID = isset($targetID) ? $targetID : $modx->documentObject[''id''];\n/*\n    Param: targetID\n\n    Purpose:\n    ID for archive links to point to\n\n    Options:\n    Any MODx document with a Ditto call setup with extenders=`dateFilter`\n    \n    Default:\n    Current MODx Document\n*/\n$dateSource = isset($dateSource) ? $dateSource : "createdon";\n/*\n    Param: dateSource\n\n    Purpose:\n    Date source to display for archive items\n\n    Options:\n    # - Any UNIX timestamp from MODx fields or TVs such as createdon, pub_date, or editedon\n    \n    Default:\n    "createdon"\n    \n    Related:\n    - <dateFormat>\n*/\n$dateFormat = isset($dateFormat) ? $dateFormat : "%d-%b-%y %H:%M";  \n/*\n    Param: dateFormat\n\n    Purpose:\n    Format the [+date+] placeholder in human readable form\n\n    Options:\n    Any PHP valid strftime option\n\n    Default:\n    "%d-%b-%y %H:%M"\n    \n    Related:\n    - <dateSource>\n*/\n$yearSortDir = isset($yearSortDir) ? $yearSortDir : "DESC";\n/*\n    Param: yearSortDir\n\n    Purpose:\n    Direction to sort documents\n\n    Options:\n    ASC - ascending\n    DESC - descending\n\n    Default:\n    "DESC"\n    \n    Related:\n    - <monthSortDir>\n*/\n$monthSortDir = isset($monthSortDir) ? $monthSortDir : "ASC";\n/*\n    Param: monthSortDir\n\n    Purpose:\n    Direction to sort the months\n\n    Options:\n    ASC - ascending\n    DESC - descending\n\n    Default:\n    "ASC"\n    \n    Related:\n    - <yearSortDir>\n*/\n$start = isset($start)? intval($start) : 0;\n/*\n    Param: start\n\n    Purpose:\n    Number of documents to skip in the results\n    \n    Options:\n    Any number\n\n    Default:\n    0\n*/  \n$phx = (isset($phx))? $phx : 1;\n/*\n    Param: phx\n\n    Purpose:\n    Use PHx formatting\n\n    Options:\n    0 - off\n    1 - on\n    \n    Default:\n    1 - on\n*/\n\n// ---------------------------------------------------\n//  Initialize Ditto\n// ---------------------------------------------------\n$placeholder = ($id != false && $getDocuments == 0) ? true : false;\nif ($placeholder === false) {\n    $rID = "reflect_".rand(1,1000);\n    $itemTemplate = isset($tplItem) ? $tplItem: "@CODE:".$defaultTemplates[''item''];\n    $dParams = array(\n        "id" => "$rID",\n        "save" => "3",  \n        "summarize" => "all",\n        "tpl" => $itemTemplate,\n    );\n    \n    $source = $dittoSnippetName;\n    $params = $dittoSnippetParameters;\n        // TODO: Remove after 3.0\n        \n    if (isset($params)) {\n        $givenParams = explode("|",$params);\n        foreach ($givenParams as $parameter) {\n            $p = explode(":",$parameter);\n            $dParams[$p[0]] = $p[1];\n        }\n    }\n    /*\n        Param: params\n\n        Purpose:\n        Pass parameters to the Ditto instance used to retreive the documents\n\n        Options:\n        Any valid ditto parameters in the format name:value \n        with multiple parameters separated by a pipe (|)\n        \n        Note:\n        This parameter is only needed for config, start, and phx as you can\n        now simply use the parameter as if Reflect was Ditto\n\n        Default:\n        [NULL]\n    */\n    \n    $reflectParameters = array(''reflect_base'',''config'',''id'',''getDocuments'',''showItems'',''groupByYears'',''targetID'',''yearSortDir'',''monthSortDir'',''start'',''phx'',''tplContainer'',''tplYear'',''tplMonth'',''tplMonthInner'',''tplItem'',''save'');\n    $params =& $modx->event->params;\n    if(is_array($params)) {\n        foreach ($params as $param=>$value) {\n            if (!in_array($param,$reflectParameters) && substr($param,-3) != ''tpl'') {\n                $dParams[$param] = $value;\n            }\n        }\n    }\n\n    $source = isset($source) ? $source : "Ditto";\n    /*\n        Param: source\n\n        Purpose:\n        Name of the Ditto snippet to use\n\n        Options:\n        Any valid snippet name\n\n        Default:\n        "Ditto"\n    */\n    $snippetOutput = $modx->runSnippet($source,$dParams);\n    $ditto = $modx->getPlaceholder($rID."_ditto_object");\n    $resource = $modx->getPlaceholder($rID."_ditto_resource");\n} else {\n    $ditto = $modx->getPlaceholder($id."ditto_object");\n    $resource = $modx->getPlaceholder($id."ditto_resource");\n}\nif (!is_object($ditto) || !isset($ditto) || !isset($resource)) {\n    return !empty($snippetOutput) ? $snippetOutput : "The Ditto object is invalid. Please check it.";\n}\n\n// ---------------------------------------------------\n//  Templates\n// ---------------------------------------------------\n\n$templates[''tpl''] = isset($tplContainer) ? $ditto->template->fetch($tplContainer): $defaultTemplates[''tpl''];\n/*\n    Param: tplContainer\n\n    Purpose:\n    Container template for the archive\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE:\n    - File via @FILE:\n\n    Default:\n    See default.tempates.php\n*/\n$templates[''year''] = isset($tplYear) ? $ditto->template->fetch($tplYear): $defaultTemplates[''year''];\n/*\n    Param: tplYear\n\n    Purpose:\n    Template for the year item\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE:\n    - File via @FILE:\n\n    Default:\n    See default.tempates.php\n*/\n$templates[''year_inner''] = isset($tplYearInner) ? $ditto->template->fetch($tplYearInner): $defaultTemplates[''year_inner''];\n/*\n    Param: tplYearInner\n\n    Purpose:\n    Template for the year item (the ul to hold the year template)\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE:\n    - File via @FILE:\n\n    Default:\n    See default.tempates.php\n*/\n$templates[''month''] = isset($tplMonth) ? $ditto->template->fetch($tplMonth): $defaultTemplates[''month''];\n/*\n    Param: tplMonth\n\n    Purpose:\n    Template for the month item\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE:\n    - File via @FILE:\n\n    Default:\n    See default.tempates.php\n*/\n$templates[''month_inner''] = isset($tplMonthInner) ? $ditto->template->fetch($tplMonthInner): $defaultTemplates[''month_inner''];\n/*\n    Param: tplMonthInner\n\n    Purpose:\n    Template for the month item  (the ul to hold the month template)\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE:\n    - File via @FILE:\n\n    Default:\n    See default.tempates.php\n*/\n$templates[''item''] = isset($tplItem) ? $ditto->template->fetch($tplItem): $defaultTemplates[''item''];\n/*\n    Param: tplItem\n\n    Purpose:\n    Template for the individual item\n\n    Options:\n    - Any valid chunk name\n    - Code via @CODE:\n    - File via @FILE:\n\n    Default:\n    See default.tempates.php\n*/\n\n$ditto->addField("date","display","custom");\n    // force add the date field if receiving data from a Ditto instance\n\n// ---------------------------------------------------\n//  Reflect\n// ---------------------------------------------------\n\nif (function_exists("reflect") === FALSE) {\nfunction reflect($templatesDocumentID, $showItems, $groupByYears, $resource, $templatesDateSource, $dateFormat, $ditto, $templates,$id,$start,$yearSortDir,$monthSortDir) {\n    global $modx;\n    $cal = array();\n    $output = '''';\n    $ph = array(''year''=>'''',''month''=>'''',''item''=>'''',''out''=>'''');\n    $build = array();\n    $stop = count($resource);\n\n    // loop and fetch all the results\n    for ($i = $start; $i < $stop; $i++) {\n        $date = getdate($resource[$i][$templatesDateSource]);\n        $year = $date["year"];\n        $month = $date["mon"];\n        $cal[$year][$month][] = $resource[$i];\n    }\n    if ($yearSortDir == "DESC") {\n        krsort($cal);\n    } else {\n        ksort($cal);\n    }\n    foreach ($cal as $year=>$months) {\n        if ($monthSortDir == "ASC") {\n            ksort($months);\n        } else {\n            krsort($months);\n        }\n        $build[$year] = $months;\n    }\n    \n    foreach ($build as $year=>$months) {\n        $r_year = '''';\n        $r_month = '''';\n        $r_month_2 = '''';\n        $year_count = 0;\n        $items = array();\n        \n        foreach ($months as $mon=>$month) {\n            $month_text = strftime("%B", mktime(10, 10, 10, $mon, 10, $year));\n            $month_url = ditto::buildURL("month=".$mon."&year=".$year."&day=false&start=0",$templatesDocumentID,$id);\n            $month_count = count($month);\n            $year_count += $month_count;\n            $r_month = $ditto->template->replace(array("year"=>$year,"month"=>$month_text,"url"=>$month_url,"count"=>$month_count),$templates[''month'']);\n            if ($showItems) {\n                foreach ($month as $item) {\n                    $items[$year][$mon][''items''][] = $ditto->render($item, $templates[''item''], false, $templatesDateSource, $dateFormat, array(),$phx);\n                }\n                $r_month_2 = $ditto->template->replace(array(''wrapper'' => implode('''',$items[$year][$mon][''items''])),$templates[''month_inner'']);\n                $items[$year][$mon] = $ditto->template->replace(array(''wrapper'' => $r_month_2),$r_month);\n            } else {\n                $items[$year][$mon] = $r_month;\n            }\n        }\n        if ($groupByYears) {\n            $year_url = ditto::buildURL("year=".$year."&month=false&day=false&start=0",$templatesDocumentID,$id);\n            $r_year =  $ditto->template->replace(array("year"=>$year,"url"=>$year_url,"count"=>$year_count),$templates[''year'']);\n            $var = $ditto->template->replace(array(''wrapper''=>implode('''',$items[$year])),$templates[''year_inner'']);\n            $output .= $ditto->template->replace(array(''wrapper''=>$var),$r_year);\n        } else {\n            $output .= implode('''',$items[$year]);\n        }\n    }\n\n    $output = $ditto->template->replace(array(''wrapper''=>$output),$templates[''tpl'']);\n    $modx->setPlaceholder($id.''reset'',ditto::buildURL(''year=false&month=false&day=false'',$templatesDocumentID,$id));\n\nreturn $output;\n    \n}\n}\n\nreturn reflect($targetID, $showItems, $groupByYears, $resource, $dateSource, $dateFormat, $ditto, $templates,$id,$start,$yearSortDir,$monthSortDir);\n', 0, '', '');
INSERT INTO `[[dbprefix]]site_snippets` VALUES
(10, 'Breadcrumbs', '<strong>1.0.3</strong> Configurable breadcrumb page-trail navigation', 0, 7, 0, '/*\n * This snippet shows the path through the various levels of site structure. It\n * is NOT necessarily the path the user took to arrive at a given page.\n */\n\n/* -----------------------------------------------------------------------------\n * CONFIGURATION\n * -----------------------------------------------------------------------------\n * This section contains brief explanations of the available parameters.\n */\n\n/* General setup\n * -----------------------------------------------------------------------------\n */\n\n/* $maxCrumbs [ integer ]\n * Max number of elemetns to have in a breadcrumb path. The default 100 is an\n * arbitrarily high number that will essentially include everything. If you were\n * to set it to 2, and you were 5 levels deep, it would appear like:\n * HOME > ... > Level 3 > Level 4 > CURRENT PAGE\n * It should be noted that the "home" link, and the current page do not count as\n * they are managed by their own configuration settings.\n */\n( isset($maxCrumbs) ) ? $maxCrumbs : $maxCrumbs = 100;\n\n/* $pathThruUnPub [ 1 | 0 ]\n * When your path includes an unpublished folder, setting this to 1 (true) will\n * show all documents in path EXCEPT the unpublished. When set to 0 (false), the\n * path will not go "through" that unpublished folder and will stop there.\n */\n( isset($pathThruUnPub) ) ? $pathThruUnPub : $pathThruUnPub = 1;\n\n/* $respectHidemenu [ 0 | 1 ]\n * Setting this to 1 (true) will respect the hidemenu setting of the document\n * and not include it in trail.\n */\n( isset($respectHidemenu) ) ? (int)$respectHidemenu : $respectHidemenu = 1;\n\n/* $showCurrentCrumb [ 1 | 0 ]\n * Include the current page at the end of the trail. On by default.\n */\n( isset($showCurrentCrumb) ) ? $showCurrentCrumb : $showCurrentCrumb = 1;\n\n/* $currentAsLink [ 1 | 0 ]\n * If the current page is included, this parameter will show it as a link (1) or\n * just plain text (0).\n */\n( $currentAsLink ) ? $currentAsLink : $currentAsLink = 0;\n\n/* $linkTextField [ string ]\n * Prioritized list of fields to use as link text. Options are: pagetitle,\n * longtitle, description, menutitle. The first of these fields that has a value\n * will be the title.\n */\n( isset($linkTextField) ) ? $linkTextField : $linkTextField = ''menutitle,pagetitle,longtitle'';\n\n/* $linkDescField [ string ]\n * Prioritized list of fields to use as link title text. Options are: pagetitle,\n * longtitle, description, menutitle. The first of these fields that has a value\n * will be the title.\n */\n( isset($linkDescField) ) ? $linkDescField : $linkDescField = ''description,longtitle,pagetitle,menutitle'';\n\n/* $showCrumbsAsLinks [ 1 | 0 ]\n * If for some reason you want breadcrumbs to be text and not links, set to 0\n * (false).\n */\n( isset($showCrumbsAsLinks) ) ? $showCrumbsAsLinks : $showCrumbsAsLinks = 1;\n\n/* $templateSet [ string ]\n * The set of templates you''d like to use. (Templates are defined below.) It\n * will default to defaultString which replicates the output of previous\n * versions.\n */\n( isset($templateSet) ) ? $templateSet : $templateSet = ''defaultString'';\n\n/* $crumbGap [ string ]\n * String to be shown to represent gap if there are more crumbs in trail than\n * can be shown. Note: if you would like to use an image, the entire image tag\n * must be provided. When making a snippet call, you cannot use "=", so use "||"\n * instead and it will be converted for you.\n */\n( isset($crumbGap) ) ? $crumbGap : $crumbGap = ''...'';\n\n/* $stylePrefix [ string ]\n * Breadcrumbs will add style classes to various parts of the trail. To avoid\n * class name conflicts, you can determine your own prefix. The following\n * classes will be attached:\n * crumbBox: Span that surrounds all crumb output\n * hideCrumb: Span that surrounds the "..." if there are more crumbs than will\n * be shown\n * currentCrumb: Span or A tag surrounding the current crumb\n * firstCrumb: Span that will be applied to first crumb, whether it is "home" or\n * not\n * lastCrumb: Span surrounding last crumb, whether it is the current page or\n * not\n * crumb: Class given to each A tag surrounding the intermediate crumbs (not\n * "home", "current", or "hide")\n * homeCrumb: Class given to the home crumb\n */\n( isset($stylePrefix) ) ? $stylePrefix : $stylePrefix = ''B_'';\n\n\n\n/* Home link parameters\n * -----------------------------------------------------------------------------\n * The home link is unique. It is a link that can be placed at the head of the\n * breadcrumb trail, even if it is not truly in the hierarchy.\n */\n\n/* $showHomeCrumb [ 1 | 0 ]\n * This toggles the "home" crumb to be added to the beginning of your trail.\n */\n( isset($showHomeCrumb) ) ? $showHomeCrumb : $showHomeCrumb = 1;\n\n/* $homeId [ integer ]\n * Usually the page designated as "site start" in MODx configuration is\n * considered the home page. But if you would like to use some other document,\n * you may explicitly define it.\n */\n( isset($homeId) ) ? (int)$homeId : $homeId = $modx->config[''site_start''];\n\n/* $homeCrumbTitle [ string ]\n * If you''d like to use something other than the menutitle (or pagetitle) for\n * the home link.\n */\n( isset($homeCrumbTitle) ) ? $homeCrumbTitle : $homeCrumbTitle = '''';\n\n/* $homeCrumbDescription [ string ]\n * If you''d like to use a custom description (link title) on the home link. If\n * left blank, the title will follow the title order set in $titleField.\n */\n( isset($homeCrumbDescription) ) ? $homeCrumbDescription : $homeCrumbDescription = '''';\n\n\n/* Custom behaviors\n * -----------------------------------------------------------------------------\n * The following parameters will alter the behavior of the Breadcrumbs based on\n * the page it is on.\n */\n\n/* $showCrumbsAtHome [ 1 | 0 ]\n * You can turn off Breadcrumbs all together on the home page by setting this to\n * 1 (true);\n */\n( isset($showCrumbsAtHome) ) ? $showCrumbsAtHome : $showCrumbsAtHome = 0;\n\n/* $hideOn [ string ]\n * Comma separated list of documents you don''t want Breadcrumbs on at all. If\n * you have a LOT of pages like this, you might try $hideUnder or use another\n * template. This parameter is best for those rare odd balls - otherwise it will\n * become a pain to manage.\n */\n( isset($hideOn) ) ? $hideOn : $hideOn = '''';\n\n/* $hideUnder [ string ]\n * Comma separated list of parent documents, whose CHILDREN you don''t want\n * Breadcrumbs to appear on at all. This enables you to hide Breadcrumbs on a\n * whole folders worth of documents by specifying the parent only. The PARENT\n * will not have Breadcrumbs hidden however. If you wanted to hide the parent\n * and the children, put the parent ID in hideUnder AND hideOn.\n */\n( isset($hideUnder) ) ? $hideUnder : $hideUnder = '''';\n\n/* $stopIds [ string ]\n * Comma separated list of document IDs that when reached, stops Breadcrumbs\n * from going any further. This is useful in situations like where you have\n * language branches, and you don''t want the Breadcrumbs going past the "home"\n * of the language you''re in.\n */\n( isset($stopIds) ) ? $stopIds : $stopIds = '''';\n\n/* $ignoreIds [ string ]\n * Comma separated list of document IDs to explicitly ignore.\n */\n( isset($ignoreIds) ) ? $ignoreids : $ignoreids = '''';\n\n/* Templates\n * -----------------------------------------------------------------------------\n * In an effort to keep the MODx chunks manager from getting mired down in lots\n * of templates, Breadcrumbs templates are included here. Two sets are provided\n * prefixed with defaultString, and defaultList. You can create as many more as\n * you like, each set with it''s own prefix\n */\n$templates = array(\n    ''defaultString'' => array(\n        ''crumb'' => ''[+crumb+]'',\n        ''separator'' => '' &raquo; '',\n        ''crumbContainer'' => ''<span class="[+crumbBoxClass+]">[+crumbs+]</span>'',\n        ''lastCrumbWrapper'' => ''<span class="[+lastCrumbClass+]">[+lastCrumbSpanA+]</span>'',\n        ''firstCrumbWrapper'' => ''<span class="[+firstCrumbClass+]">[+firstCrumbSpanA+]</span>''\n    ),\n    ''defaultList'' => array(\n        ''crumb'' => ''<li>[+crumb+]</li>'',\n        ''separator'' => '''',\n        ''crumbContainer'' => ''<ul class="[+crumbBoxClass+]">[+crumbs+]</ul>'',\n        ''lastCrumbWrapper'' => ''<span class="[+lastCrumbClass+]">[+lastCrumbSpanA+]</span>'',\n        ''firstCrumbWrapper'' => ''<span class="[+firstCrumbClass+]">[+firstCrumbSpanA+]</span>''\n    ),\n);\n\n\n/* -----------------------------------------------------------------------------\n * END CONFIGURATION\n * -----------------------------------------------------------------------------\n */\n\n// Return blank if necessary: on home page\nif ( !$showCrumbsAtHome && $homeId == $modx->documentObject[''id''] )\n{\n    return '''';\n}\n// Return blank if necessary: specified pages\nif ( $hideOn || $hideUnder )\n{\n    // Create array of hide pages\n    $hideOn = str_replace('' '','''',$hideOn);\n    $hideOn = explode('','',$hideOn);\n\n    // Get more hide pages based on parents if needed\n    if ( $hideUnder )\n    {\n        $hiddenKids = array();\n        // Get child pages to hide\n        $hideKidsQuery = $modx->db->select(''id'',$modx->getFullTableName("site_content"),"parent IN ($hideUnder)");\n        while ( $hideKid = $modx->db->getRow($hideKidsQuery) )\n        {\n            $hiddenKids[] = $hideKid[''id''];\n        }\n        // Merge with hideOn pages\n        $hideOn = array_merge($hideOn,$hiddenKids);\n    }\n\n    if ( in_array($modx->documentObject[''id''],$hideOn) )\n    {\n        return '''';\n    }\n\n}\n\n\n// Initialize ------------------------------------------------------------------\n\n// Put certain parameters in arrays\n$stopIds = str_replace('' '','''',$stopIds);\n$stopIds = explode('','',$stopIds);\n$linkTextField = str_replace('' '','''',$linkTextField);\n$linkTextField = explode('','',$linkTextField);\n$linkDescField = str_replace('' '','''',$linkDescField);\n$linkDescField = explode('','',$linkDescField);\n$ignoreIds = str_replace('' '','''',$ignoreIds);\n$ignoreIds = explode('','',$ignoreIds);\n\n/* $crumbs\n * Crumb elements are: id, parent, pagetitle, longtitle, menutitle, description,\n * published, hidemenu\n */\n$crumbs = array();\n$parent = $modx->documentObject[''parent''];\n$output = '''';\n$maxCrumbs += ($showCurrentCrumb) ? 1 : 0;\n\n// Replace || in snippet parameters that accept them with =\n$crumbGap = str_replace(''||'',''='',$crumbGap);\n\n// Curent crumb ----------------------------------------------------------------\n\n// Decide if current page is to be a crumb\nif ( $showCurrentCrumb )\n{\n    $crumbs[] = array(\n        ''id'' => $modx->documentObject[''id''],\n        ''parent'' => $modx->documentObject[''parent''],\n        ''pagetitle'' => $modx->documentObject[''pagetitle''],\n        ''longtitle'' => $modx->documentObject[''longtitle''],\n        ''menutitle'' => $modx->documentObject[''menutitle''],\n        ''description'' => $modx->documentObject[''description'']);\n}\n\n// Intermediate crumbs ---------------------------------------------------------\n\n\n// Iterate through parents till we hit root or a reason to stop\n$loopSafety = 0;\nwhile ( $parent && $parent!=$modx->config[''site_start''] && $loopSafety < 1000 )\n{\n    // Get next crumb\n    $tempCrumb = $modx->getPageInfo($parent,0,"id,parent,pagetitle,longtitle,menutitle,description,published,hidemenu");\n\n    // Check for include conditions & add to crumbs\n    if (\n        $tempCrumb[''published''] &&\n        ( !$tempCrumb[''hidemenu''] || !$respectHidemenu ) &&\n        !in_array($tempCrumb[''id''],$ignoreIds)\n    )\n    {\n        // Add crumb\n        $crumbs[] = array(\n        ''id'' => $tempCrumb[''id''],\n        ''parent'' => $tempCrumb[''parent''],\n        ''pagetitle'' => $tempCrumb[''pagetitle''],\n        ''longtitle'' => $tempCrumb[''longtitle''],\n        ''menutitle'' => $tempCrumb[''menutitle''],\n        ''description'' => $tempCrumb[''description'']);\n    }\n\n    // Check stop conditions\n    if (\n        in_array($tempCrumb[''id''],$stopIds) ||  // Is one of the stop IDs\n        !$tempCrumb[''parent''] || // At root\n        ( !$tempCrumb[''published''] && !$pathThruUnPub ) // Unpublished\n    )\n    {\n        // Halt making crumbs\n        break;\n    }\n\n    // Reset parent\n    $parent = $tempCrumb[''parent''];\n\n    // Increment loop safety\n    $loopSafety++;\n}\n\n// Home crumb ------------------------------------------------------------------\n\nif ( $showHomeCrumb && $homeId != $modx->documentObject[''id''] && $homeCrumb = $modx->getPageInfo($homeId,0,"id,parent,pagetitle,longtitle,menutitle,description,published,hidemenu") )\n{\n    $crumbs[] = array(\n    ''id'' => $homeCrumb[''id''],\n    ''parent'' => $homeCrumb[''parent''],\n    ''pagetitle'' => $homeCrumb[''pagetitle''],\n    ''longtitle'' => $homeCrumb[''longtitle''],\n    ''menutitle'' => $homeCrumb[''menutitle''],\n    ''description'' => $homeCrumb[''description'']);\n}\n\n\n// Process each crumb ----------------------------------------------------------\n$pretemplateCrumbs = array();\n\nforeach ( $crumbs as $c )\n{\n\n    // Skip if we''ve exceeded our crumb limit but we''re waiting to get to home\n    if ( count($pretemplateCrumbs) > $maxCrumbs && $c[''id''] != $homeId )\n    {\n        continue;\n    }\n\n    $text = '''';\n    $title = '''';\n    $pretemplateCrumb = '''';\n\n    // Determine appropriate span/link text: home link specified\n    if ( $c[''id''] == $homeId && $homeCrumbTitle )\n    {\n        $text = $homeCrumbTitle;\n    }\n    else\n    // Determine appropriate span/link text: home link not specified\n    {\n        for ($i = 0; !$text && $i < count($linkTextField); $i++)\n        {\n            if ( $c[$linkTextField[$i]] )\n            {\n                $text = $c[$linkTextField[$i]];\n            }\n        }\n    }\n\n    // Determine link/span class(es)\n    if ( $c[''id''] == $homeId )\n    {\n        $crumbClass = $stylePrefix.''homeCrumb'';\n    }\n    else if ( $modx->documentObject[''id''] == $c[''id''] )\n    {\n        $crumbClass = $stylePrefix.''currentCrumb'';\n    }\n    else\n    {\n        $crumbClass = $stylePrefix.''crumb'';\n    }\n\n    // Make link\n    if (\n        ( $c[''id''] != $modx->documentObject[''id''] && $showCrumbsAsLinks ) ||\n        ( $c[''id''] == $modx->documentObject[''id''] && $currentAsLink )\n    )\n    {\n        // Determine appropriate title for link: home link specified\n        if ( $c[''id''] == $homeId && $homeCrumbDescription )\n        {\n            $title = htmlspecialchars($homeCrumbDescription);\n        }\n        else\n        // Determine appropriate title for link: home link not specified\n        {\n            for ($i = 0; !$title && $i < count($linkDescField); $i++)\n            {\n                if ( $c[$linkDescField[$i]] )\n                {\n                    $title = htmlspecialchars($c[$linkDescField[$i]]);\n                }\n            }\n        }\n\n\n        $pretemplateCrumb .= ''<a class="''.$crumbClass.''" href="''.($c[''id''] == $modx->config[''site_start''] ? $modx->config[''base_url''] : $modx->makeUrl($c[''id''])).''" title="''.$title.''">''.$text.''</a>'';\n    }\n    else\n    // Make a span instead of a link\n    {\n       $pretemplateCrumb .= ''<span class="''.$crumbClass.''">''.$text.''</span>'';\n    }\n\n    // Add crumb to pretemplate crumb array\n    $pretemplateCrumbs[] = $pretemplateCrumb;\n\n    // If we have hit the crumb limit\n    if ( count($pretemplateCrumbs) == $maxCrumbs )\n    {\n        if ( count($crumbs) > ($maxCrumbs + (($showHomeCrumb) ? 1 : 0)) )\n        {\n            // Add gap\n            $pretemplateCrumbs[] = ''<span class="''.$stylePrefix.''hideCrumb''.''">''.$crumbGap.''</span>'';\n        }\n\n        // Stop here if we''re not looking for the home crumb\n        if ( !$showHomeCrumb )\n        {\n            break;\n        }\n    }\n}\n\n// Put in correct order for output\n$pretemplateCrumbs = array_reverse($pretemplateCrumbs);\n\n// Wrap first/last spans\n$pretemplateCrumbs[0] = str_replace(\n    array(''[+firstCrumbClass+]'',''[+firstCrumbSpanA+]''),\n    array($stylePrefix.''firstCrumb'',$pretemplateCrumbs[0]),\n    $templates[$templateSet][''firstCrumbWrapper'']\n);\n$pretemplateCrumbs[(count($pretemplateCrumbs)-1)] = str_replace(\n    array(''[+lastCrumbClass+]'',''[+lastCrumbSpanA+]''),\n    array($stylePrefix.''lastCrumb'',$pretemplateCrumbs[(count($pretemplateCrumbs)-1)]),\n    $templates[$templateSet][''lastCrumbWrapper'']\n);\n\n// Insert crumbs into crumb template\n$processedCrumbs = array();\nforeach ( $pretemplateCrumbs as $pc )\n{\n    $processedCrumbs[] = str_replace(''[+crumb+]'',$pc,$templates[$templateSet][''crumb'']);\n}\n\n// Combine crumbs together into one string with separator\n$processedCrumbs = implode($templates[$templateSet][''separator''],$processedCrumbs);\n\n// Put crumbs into crumb container template\n$container = str_replace(\n    array(''[+crumbBoxClass+]'',''[+crumbs+]''),\n    array($stylePrefix.''crumbBox'',$processedCrumbs),\n    $templates[$templateSet][''crumbContainer'']\n    );\n\n// Return crumbs\nreturn $container;', 0, '', ''),
(11, 'AjaxSearch', '<strong>1.10.2</strong> Ajax and non-Ajax search that supports results highlighting', 0, 3, 0, '/**\n--------------------------------------------------------------------------------\n:: Preamble\n--------------------------------------------------------------------------------\n\n AjaxSearch 1.10.2 includes bugfixes only\n AjaxSearch 1.10.1 includes bugfixes only\n AjaxSearch 1.10.0 upgraded by TimGS from AjaxSearch 1.9.3. Now uses the DBAPI throughout.\n\n Coroico <coroico@wangba.fr>\n Jason Coward <jason@opengeek.com>\n Kyle Jaebker <kjaebker@muddydogpaws.com>\n Ryan Thrash  <ryan@vertexworks.com>\n\n--------------------------------------------------------------------------------\n:: Description\n--------------------------------------------------------------------------------\n\n        Ajax and non-Ajax search that supports results highlighting.\n\nThis snippet adds AJAX functionality on top of the robust content searching.\n\nWhat AjaxSearch do:\n- search in fields of the content an TV MODx tables\n- several customizable input forms available\n- search in a subset of documents\n- highlighting of searchword in the results returned\n- allow a filtering of search results\n- displaying of search results customizable thru templates\n- group the search results by categories\n- filter features (allow to set up specific search forms)\n\nIt could works in two modes:\n\najax mode :\n- search results displayed in current page through AJAX request\n- multiple search options including live search\n- available link to view all results in a new page when only a subset is returned\n- customize the number of results returned\n- offer two types for paginating the results\n- uses the MooTools or JQuery js library for AJAX and visual effects\n\nnon-ajax mode :\n- search results displayed in a new page or below on the same page\n- offer two types for paginating the results\n- works without JS enabled\n\nWhat AjaxSearch don''t :\n- search in dynamic content. AjaxSearch could retreive only data stored in\ndatabase. It can''t find something stored in a chunk or generated by a snippet.\n\nMORE : See the ajaxSearch.readme.txt file for more informations. \n\n----------------------------------------------------------------------------- */\n\n// ajaxSearch version being executed\ndefine(''AS_VERSION'', ''1.10.0'');\n// Path where ajaxSearch is installed\ndefine(''AS_SPATH'', ''assets/snippets/ajaxSearch/'');\n//include snippet file\ndefine(''AS_PATH'', MODX_BASE_PATH . AS_SPATH);\n\n//------------------------------------------------------------------------------\n// Configuration - general AjaxSearch snippet setup options\n//------------------------------------------------------------------------------\nglobal $modx;\n$tstart = $modx->getMicroTime();\n\n$cfg = array(); // current configuration\n$cfg[''version''] = AS_VERSION;\n\n// Load the default configuration $dcfg to get the default values\n$default = AS_PATH . ''configs/default.config.php'';\nif (file_exists($default)) include $default;\nelse return "<h3>AjaxSearch error: $default not found !<br />Check the existing of this file!</h3>";\nif (!isset($dcfg)) return "<h3>AjaxSearch error: default configuration array not defined in $default!<br /> Check the content of this file!</h3>";\n\nif ($dcfg[''version''] != AS_VERSION) return "<h3>AjaxSearch error: Version number mismatch. Check the content of the default configuration file!</h3>";\n\n// check the possible use of deprecated parameters (since 1.8.5)\n$readme = "ajaxSearch_version_193.txt";\nif (isset($searchWordList)) return "<h3>AjaxSearch error: searchWordList is a deprecated parameter. Read " . $readme . " file.</h3>";\nif (isset($resultsPage)) return "<h3>AjaxSearch error: resultsPage is a deprecated parameter. Read " . $readme . " file.</h3>";\nif (isset($AS_showForm)) return "<h3>AjaxSearch error: AS_showForm parameter has been renamed showInputForm. Read " . $readme . " file.</h3>";\nif (isset($AS_landing)) return "<h3>AjaxSearch error: AS_landing parameter has been renamed landingPage. Read " . $readme . " file.</h3>";\nif (isset($AS_showResults)) return "<h3>AjaxSearch error: AS_showResults parameter has been renamed showResults. Read " . $readme . " file.</h3>";\n\n// Load a custom configuration file if required\n// config_name - Other config installed in the configs folder or in any folder within the MODx base path via @FILE\n// Configuration files should be named in the form: <config_name>.config.php\n// Default: '''' - no custom config\n$cfg[''config''] = isset($config) ? $config : $dcfg[''config''];\nif ($cfg[''config'']) {\n    $config = $cfg[''config''];\n    $lconfig = (substr($config, 0, 6) != "@FILE:") ? AS_PATH . "configs/$config.config.php" : $modx->config[''base_path''] . trim(substr($config, 6, strlen($config)-6));\n    if (file_exists($lconfig)) include $lconfig;\n    else return "<h3>AjaxSearch error: " . $lconfig . " not found !<br />Check your config parameter or your config file name!</h3>";\n}\n\n// &debug = [ 0 | 1 | 2 | 3 ]\n// 1,2,3 : File mode - Output logged into a file named ajaxSearch_log.txt in ajaxSearch/debug/ directory.\n// this directory should be writable.\n// Default: 0 - no logs\n$cfg[''debug''] = isset($debug) ? $debug : (isset($__debug) ? $__debug : $dcfg[''debug'']);\n\n// &timeLimit = [ int | 60 ]\n// Max execution time in seconds for the AjaxSearch script\n// 0 - If set to zero, no time limit is imposed\n// Default: 60 - 1 minute.\n$cfg[''timeLimit''] = isset($timeLimit) ? $timeLimit : (isset($__timeLimit) ? $__timeLimit : $dcfg[''timeLimit'']);\n\n// &language [ language_name | manager_language ] (optional)\n// Default: $modx->config[''manager_language''] - manager language used\n$cfg[''language''] = isset($language) ? $language : (isset($__language) ? $__language : $dcfg[''language'']);\n\n// &ajaxSearch [1 | 0] (as passed in snippet variable ONLY)\n// Use this to display the search results using ajax You must include the Mootools library in your template\n// Default: 1 - ajax mode selected\n$cfg[''ajaxSearch''] = isset($ajaxSearch) ? $ajaxSearch : (isset($__ajaxSearch) ? $__ajaxSearch : $dcfg[''ajaxSearch'']);\n\n// &advSearch [ ''exactphrase'' | ''allwords'' | ''nowords'' | ''oneword'' ]\n// Advanced search:\n// - exactphrase : provides the documents which contain the exact phrase\n// - allwords : provides the documents which contain all the words\n// - nowords : provides the documents which do not contain the words\n// - oneword : provides the document which contain at least one word\n// Default: ''oneword''\n$cfg[''advSearch''] = isset($advSearch) ? $advSearch : (isset($__advSearch) ? $__advSearch : $dcfg[''advSearch'']);\n\n// &asId - Unique id for AjaxSearch instance\n// this allows to distinguish several Ajaxsearch instances on the same page\n// Any combination of characters a-z, underscores, and numbers 0-9\n// This is case sensitive. Default = empty string\n// With ajax mode, the first snippet call of the page shouldn''t use the asId parameter\n$cfg[''asId''] = isset($asId) ? $asId : (isset($__asId) ? $__asId : $dcfg[''asId'']);\n\n// &whereSearch\n// Define where should occur the search\n// a separated list of keywords describing the tables where to search\n// keywords allowed :\n// "content" for site_content, "tv" for site_tmplvar_contentvalues, "jot" for jot_content, "maxigallery" for maxigallery\n// you could add your own keywords. But the keyword should be a user function which describes the tables to use\n// all the text fields are searchable but you could specify the fields like this:\n// whereSearch=`content:pagetitle,introtext,content|tv:tv_value|maxigallery:gal_title`\n// Default: ''content|tv''\n$cfg[''whereSearch''] = isset($whereSearch) ? $whereSearch : (isset($__whereSearch) ? $__whereSearch : $dcfg[''whereSearch'']);\n\n// &sites : [comma separated list of sites]\n// sites allow to define sites where to do the search\n$cfg[''sites''] = isset($sites) ? $sites : (isset($__sites) ? $__sites : $dcfg[''sites'']);\n\n// &subSearch  [comma separated list of subsites]\n// subSearch allow to define sub-domains or subsites where to do the search\n$cfg[''subSearch''] = isset($subSearch) ? $subSearch : (isset($__subSearch) ? $__subSearch : $dcfg[''subSearch'']);\n\n// &category  [ tv_name ]\n// Any combination of characters a-z, underscores, and numbers 0-9\n// This is case sensitive. Default = empty string\n// Name of a TV. The category of a MODx document is provided by this TV content\n$cfg[''category''] = isset($category) ? $category : (isset($__category) ? $__category : $dcfg[''category'']);\n\n// &display [ ''mixed'' | ''unmixed'' ]\n// When results comes from differents sites, subsites or categories, you could choose to display the results mixed or unmixed.\n// Default: unmixed\n// Unmixed mode display the results grouped by site, subsite or category. Each group of results could be paginated.\n// Mixed mode mixe all the results coming from the differents area.\n// With unmixed mode, results are ordered by the field provided by the first field of the order parameter\n$cfg[''display''] = isset($display) ? $display : (isset($__display) ? $__display : $dcfg[''display'']);\n\n// &init  [ ''none'' | ''all'' ]\n// init defines if the search display all the results or none when the search term is an empty string\n// Default: none\n$cfg[''init''] = isset($init) ? $init : (isset($__init) ? $__init : $dcfg[''init'']);\n\n// &withTvs - Define which Tvs are used for the search in Tvs\n// a comma separated list of TV names\n// Default: '''' - all TVs are used (empty list)\n$cfg[''withTvs''] = isset($withTvs) ? $withTvs : (isset($__withTvs) ? $__withTvs : $dcfg[''withTvs'']);\n\n// &order - Define the sort order of results\n// Comma separated list of fields defined as searchable in the table definition\n// to suppress the sorting, use &order=``\n// Default: ''pub_date,pagetitle''\n$cfg[''order''] = isset($order) ? $order : (isset($__order) ? $__order : $dcfg[''order'']);\n\n// &rank - Define the rank of search results. Results are sorted by rank value\n// Comma separated list of fields with optionally user defined weight\n// Default: ''pagetitle:100,extract''\n// to suppress the rank sorting, use &rank=``;\n// &rank sort occurs after the &order sort\n$cfg[''rank''] = isset($rank) ? $rank : (isset($__rank) ? $__rank : $dcfg[''rank'']);\n\n// &maxWords [ 1 < int < 10 ]\n// Maximum number of words for searching\n// Default: 5\n$cfg[''maxWords''] = isset($maxWords) ? intval($maxWords) : (isset($__maxWords) ? intval($__maxWords) : $dcfg[''maxWords'']);\n\n// &minChars [  2 < int < 100 ]\n// Minimum number of characters to require for a word to be valid for searching.\n// length of each word with $advSearch = ''allwords'', ''oneword'' or ''nowords''\n// length of the search string with possible spaces with $advSearch = ''exactphrase''\n// Default: 3\n$cfg[''minChars''] = isset($minChars) ? intval($minChars) : (isset($__minChars) ? intval($__minChars) : $dcfg[''minChars'']);\n\n// &showInputForm [0 | 1]\n// If you would like to turn off the search form when showing results you can set this to false.(1=true, 0=false)\n// Default: 1\n$cfg[''showInputForm''] = isset($showInputForm) ? $showInputForm : (isset($__showInputForm) ? $__showInputForm : $dcfg[''showInputForm'']);\n\n// &showIntro [0 | 1]\n// If you would like to turn off the intro message beyond the input form you can set this to false.(1=true, 0=false)\n// Default: 1\n$cfg[''showIntro''] = isset($showIntro) ? $showIntro : (isset($__showIntro) ? $__showIntro : $dcfg[''showIntro'']);\n\n// &grabMax [ int ]\n// Set to the max number of records you would like on each page. Set to 0 if unlimited.\n// Default: 10\n$cfg[''grabMax''] = isset($grabMax) ? intval($grabMax) : (isset($__grabMax) ? intval($__grabMax) : $dcfg[''grabMax'']);\n\n// &extract [ n:searchable fields list | 1:content,description,introtext,tv_content]\n// show the search terms highlighted in a little extract\n// n : maximum number of extracts displayed\n// ordered searchable fields list : separated list of fields define as searchable in the table definition\n// Default: ''1:content,description,introtext,tv_value'' - One extract from content then description,introtext,tv_value\n$cfg[''extract''] = isset($extract) ? $extract : (isset($__extract) ? $__extract : $dcfg[''extract'']);\n\n// &extractLength [ 50 < int < 800]\n// Length of extract around the search words found - between 50 and 800 characters\n// Default: 200\n$cfg[''extractLength''] = isset($extractLength) ? intval($extractLength) : (isset($__extractLength) ? intval($__extractLength) : $dcfg[''extractLength'']);\n\n// &extractEllips [ string ]\n// Ellipside to mark the star and the end of  an extract when the sentence is cutting\n// Default: ''...''\n$cfg[''extractEllips''] = isset($extractEllips) ? $extractEllips : (isset($__extractEllips) ? $__extractEllips : $dcfg[''extractEllips'']);\n\n// &extractSeparator [ string ]\n// Any html tag to mark the separation between extracts\n// Default: ''<br />'' - but you could also choose for instance ''<hr />''\n$cfg[''extractSeparator''] = isset($extractSeparator) ? $extractSeparator : (isset($__extractSeparator) ? $__extractSeparator : $dcfg[''extractSeparator'']);\n\n// &formatDate [ string ]\n// The format of outputted dates. See http://www.php.net/manual/en/function.date.php\n// Default: ''d/m/y : H:i:s'' - e.g: 21/01/08 : 23:09:22\n$cfg[''formatDate''] = isset($formatDate) ? $formatDate : (isset($__formatDate) ? $__formatDate : $dcfg[''formatDate'']);\n\n// &highlightResult [1 | 0]\n// create links so that search terms will be highlighted when linked page clicked\n// Default: 1 - Results highlighted\n$cfg[''highlightResult''] = isset($highlightResult) ? $highlightResult : (isset($__highlightResult) ? $__highlightResult : $dcfg[''highlightResult'']);\n\n// &pagingType[ 0 | 1 | 2 ]\n// Determine the pagination type used - Default 1 : Previous - X-Y/Z - Next\n$cfg[''pagingType''] = isset($pagingType) ? $pagingType : (isset($__pagingType) ? $__pagingType : $dcfg[''pagingType'']);\n\n// &pageLinkSeparator [ string ]\n// What you want, if anything, between your page link numbers\n// Default: '' | ''\n$cfg[''pageLinkSeparator''] = isset($pageLinkSeparator) ? $pageLinkSeparator : (isset($__pageLinkSeparator) ? $__pageLinkSeparator : $dcfg[''pageLinkSeparator'']);\n\n// &showPagingAlways[1 | 0]\n// Determine whether or not to always show paging\n$cfg[''showPagingAlways''] = isset($showPagingAlways) ? $showPagingAlways : (isset($__showPagingAlways) ? $__showPagingAlways : $dcfg[''showPagingAlways'']);\n\n// &landingPage  [int] set the page to show the results page (non Ajax search)\n// Default: false\n$cfg[''landingPage''] = isset($landingPage) ? $landingPage : (isset($__landingPage) ? $__landingPage : $dcfg[''landingPage'']);\n\n// &showResults  [1 | 0]  establish whether to show the results or not\n// Default: 1\n$cfg[''showResults''] = isset($showResults) ? $showResults : (isset($__showResults) ? $__showResults : $dcfg[''showResults'']);\n\n// &parents [ [ in | not in ] : comma separated list of Ids | '''' ]\n// Ids of documents to retrieve their children to &depth depth  where to do the search in or not in\n// Default: '''' - empty list\n$cfg[''parents''] = isset($parents) ? $parents : (isset($__parents) ? $__parents : $dcfg[''parents'']);\n\n// &documents [ [ in | not in ] : comma separated list of Ids | '''' ]\n// Ids of documents where to do the search in or not in\n// Default: '''' - empty list\n$cfg[''documents''] = isset($documents) ? $documents : (isset($__documents) ? $__documents : $dcfg[''documents'']);\n\n// &depth [ 0 < int ] Number of levels deep to retrieve documents\n// Default: 10\n$cfg[''depth''] = isset($depth) ? intval($depth) : (isset($__depth) ? intval($__depth) : $dcfg[''depth'']);\n\n// &hideMenu [0 | 1| 2]  Search in hidden documents from menu.\n// 0 - search only in documents visible from menu\n// 1 - search only in documents hidden from menu\n// 2 - search in hidden or visible documents from menu\n// Default: 2\n$cfg[''hideMenu''] = isset($hideMenu) ? $hideMenu : (isset($__hideMenu) ? $__hideMenu : $dcfg[''hideMenu'']);\n\n// &hideLink [0 | 1 ]   Search in content of type reference (link)\n// 0 - search in content of type document AND reference\n// 1 - search only in content of type document\n// Default: 1\n$cfg[''hideLink''] = isset($hideLink) ? $hideLink : (isset($__hideLink) ? $__hideLink : $dcfg[''hideLink'']);\n\n// &filter - Basic filtering : remove unwanted documents that meets the criteria of the filter\n// See Ditto 2 Basic filtering and the ajaxSearch demo site for more information\n// Default: '''' - empty list\n$cfg[''filter''] = isset($filter) ? $filter : (isset($__filter) ? $__filter : $dcfg[''filter'']);\n\n// &output [0 | 1 ]Custom layout\n// Default: 0 - Results are listed just under the input form\n// 1 - custom layout. put [+as.inputForm+] and [+as.results+] where you want to define the layout\n$cfg[''output''] = isset($output) ? $output : (isset($__output) ? $__output : $dcfg[''output'']);\n\n// &tplInput - Chunk to style the ajaxSearch input form\n// Default: ''@FILE:'' . AS_SPATH . ''templates/input.tpl.html''\n$cfg[''tplInput''] = isset($tplInput) ? $tplInput : (isset($__tplInput) ? $__tplInput : $dcfg[''tplInput'']);\n\n// &tplResults - Chunk to style the non-ajax output results outer\n// Default: ''@FILE:'' . AS_SPATH . ''templates/results.tpl.html''\n$cfg[''tplResults''] = isset($tplResults) ? $tplResults : (isset($__tplResults) ? $__tplResults : $dcfg[''tplResults'']);\n\n// &tplGrpResult - Chunk to style the non-ajax output group result outer\n// Default: ''@FILE:'' . AS_SPATH . ''templates/grpResult.tpl.html''\n$cfg[''tplGrpResult''] = isset($tplGrpResult) ? $tplGrpResult : (isset($__tplGrpResult) ? $__tplGrpResult : $dcfg[''tplGrpResult'']);\n\n// &tplResult - Chunk to style each output result\n// Default: "@FILE:" . AS_SPATH . ''templates/result.tpl.html''\n$cfg[''tplResult''] = isset($tplResult) ? $tplResult : (isset($__tplResult) ? $__tplResult : $dcfg[''tplResult'']);\n\n// &tplComment - Chunk to style the comment form (Also used with the ajax mode)\n// Default: ''@FILE:'' . AS_SPATH . ''templates/comment.tpl.html''\n$cfg[''tplComment''] = isset($tplComment) ? $tplComment : (isset($__tplComment) ? $__tplComment : $dcfg[''tplComment'']);\n\n// &tplPaging0 - Chunk to style the paging links - type 0\n// Default: ''@FILE:'' . AS_SPATH . ''templates/paging0.tpl.html''\n$cfg[''tplPaging0''] = isset($tplPaging0) ? $tplPaging0 : (isset($__tplPaging0) ? $__tplPaging0 : $dcfg[''tplPaging0'']);\n\n// &tplPaging1 - Chunk to style the paging links - type 1\n// Default: ''@FILE:'' . AS_SPATH . ''templates/paging1.tpl.html''\n$cfg[''tplPaging1''] = isset($tplPaging1) ? $tplPaging1 : (isset($__tplPaging1) ? $__tplPaging1 : $dcfg[''tplPaging1'']);\n\n// &tplPaging2 - Chunk to style the paging links - type 2\n// Default: ''@FILE:'' . AS_SPATH . ''templates/paging2.tpl.html''\n$cfg[''tplPaging2''] = isset($tplPaging2) ? $tplPaging2 : (isset($__tplPaging2) ? $__tplPaging2 : $dcfg[''tplPaging2'']);\n\n// &stripInput - stripInput user function name\n// Default: ''defaultStripInput''\n$cfg[''stripInput''] = isset($stripInput) ? $stripInput : (isset($__stripInput) ? $__stripInput : $dcfg[''stripInput'']);\n\n// &stripOutput - stripOutput user function name\n// Default: ''defaultStripOutput''\n$cfg[''stripOutput''] = isset($stripOutput) ? $stripOutput : (isset($__stripOutput) ? $__stripOutput : $dcfg[''stripOutput'']);\n\n// &breadcrumbs\n// 0 : disallow the breadcrumbs link\n// Name of the breadcrumbs function : allow the breadcrumbs link\n// The function name could be followed by some parameter initialization\n// e.g: &breadcrumbs=`Breadcrumbs,showHomeCrumb:0,showCrumbsAtHome:1`\n// Default: '''' - empty string\n$cfg[''breadcrumbs''] = isset($breadcrumbs) ? $breadcrumbs : (isset($__breadcrumbs) ? $__breadcrumbs : $dcfg[''breadcrumbs'']);\n\n// &tvPhx - display and set placeHolders for TV (template variables)\n// 0 : disallow the feature\n// 1 : allow the display of all Modx TVs of the document found (default)\n// ''tb_alias:display_function_name[,[tb_alias:display_function_name]*]'' : set up placeholders for custom joined tables\n// Default: 1 - tvPhx allowed for TV only\n$cfg[''tvPhx''] = isset($tvPhx) ? $tvPhx : (isset($__tvPhx) ? $__tvPhx : $dcfg[''tvPhx'']);\n\n// &clearDefault - Clearing default text\n// Set this to 1 if you would like to include the clear default js function\n// add the class "cleardefault" to your input text form and set this parameter\n// Default: 0\n$cfg[''clearDefault''] = isset($clearDefault) ? $clearDefault : (isset($__clearDefault) ? $__clearDefault : $dcfg[''clearDefault'']);\n\n// &jsClearDefault - Location of the js library\n// Default: AS_SPATH . ''js/clearDefault.js''\n$cfg[''jsClearDefault''] = $dcfg[''jsClearDefault''];\n\n// &mbstring - php_mbstring extension available [0 | 1]\n// Default: 1 - extension available\n$cfg[''mbstring''] = isset($mbstring) ? $mbstring : (isset($__mbstring) ? $__mbstring : $dcfg[''mbstring'']);\n\n//  &asLog - ajaxSearch log [ level [: comment [: purge]]]\n//  level:\n//        0 : disallow the ajaxSearch log (Default)\n//        1 : failed search requests are logged\n//        2 : all ajaxSearch requests are logged\n//  comment:\n//        0 : user comment not allowed (Default)\n//        1 : user comment allowed\n//  purge: number of logs allowed before to do an automatic purge of the table\n//        Default: 200\n$cfg[''asLog''] = isset($asLog) ? $asLog : (isset($__asLog) ? $__asLog : $dcfg[''asLog'']);\n\n\n//------------------------------------------------------------------------------\n// Configuration - Simple Ajax mode\n//------------------------------------------------------------------------------\n\nif ($cfg[''ajaxSearch'']) {\n\n    // $liveSearch [1 | 0] (as passed in snippet variable ONLY)\n    // Set this to 1 if you would like to use the live search (i.e. results as you type)\n    // Default: 0 - livesearch mode inactivated\n    $cfg[''liveSearch''] = isset($liveSearch) ? $liveSearch : (isset($__liveSearch) ? $__liveSearch : $dcfg[''liveSearch'']);\n\n    // &ajaxMax [int] - The maximum number of results to show for the ajaxsearch\n    // Default: 6\n    $cfg[''ajaxMax''] = isset($ajaxMax) ? $ajaxMax : (isset($__ajaxMax) ? $__ajaxMax : $dcfg[''ajaxMax'']);\n\n    // &moreResultsPage [int]\n    // The document id of the page you want the more results link to point to\n    // Default: 0\n    $cfg[''moreResultsPage''] = isset($moreResultsPage) ? $moreResultsPage : (isset($__moreResultsPage) ? $__moreResultsPage : $dcfg[''moreResultsPage'']);\n\n    // &opacity - set the opacity of the div ajaxSearch_output\n    // Should be a float value: [ 0. < float <= 1. ]\n    // Default: 1.\n    $cfg[''opacity''] = isset($opacity) ? $opacity : (isset($__opacity) ? $__opacity : $dcfg[''opacity'']);\n\n    // &tplAjaxResults - Chunk to style the ajax output results outer\n    // Default: '''' - empty string\n    $cfg[''tplAjaxResults''] = isset($tplAjaxResults) ? $tplAjaxResults : (isset($__tplAjaxResults) ? $__tplAjaxResults : $dcfg[''tplAjaxResults'']);\n\n    // &tplAjaxGrpResult - Chunk to style each ajax output group result outer\n    // Default: '''' - empty string\n    $cfg[''tplAjaxGrpResult''] = isset($tplAjaxGrpResult) ? $tplAjaxGrpResult : (isset($__tplAjaxGrpResult) ? $__tplAjaxGrpResult : $dcfg[''tplAjaxGrpResult'']);\n\n    // &tplAjaxResult - Chunk to style each ajax output result\n    // Default: '''' - empty string\n    $cfg[''tplAjaxResult''] = isset($tplAjaxResult) ? $tplAjaxResult : (isset($__tplAjaxResult) ? $__tplAjaxResult : $dcfg[''tplAjaxResult'']);\n\n    // &jscript [''jquery''|''mootools2''|''mootools'']\n    // Set this to jquery if you would like use the jquery library\n    // set mootools2 to use the version 1.2 of mootools (limited to JS functions used by AS)\n    // Default: ''mootools'' - use the version 1.11 of mootools provided with MODx\n    $cfg[''jscript''] = isset($jscript) ? $jscript : (isset($__jscript) ? $__jscript : $dcfg[''jscript'']);\n\n    // &addJscript [1 | 0]\n    // Set this to 1 if you would like to include or not the mootool/jquery library in the header of your pages automatically\n    // Default: 1\n    $cfg[''addJscript''] = isset($addJscript) ? $addJscript : (isset($__addJscript) ? $__addJscript : $dcfg[''addJscript'']);\n\n    // &jsMooTools - Location of the mootools javascript library (current version of MODx)\n    // Default: ''manager/media/script/mootools/mootools.js''\n    $cfg[''jsMooTools''] = isset($jsMooTools) ? $jsMooTools : (isset($__jsMooTools) ? $__jsMooTools : $dcfg[''jsMooTools'']);\n\n    // &jsMooTools2 - Location of an alternative mootools javascript library\n    // Default: AS_SPATH . ''js/mootools1.2/mootools.js'' - contains only the required functions for AS\n    // to use an another library, use this parameter and change the ajaxSearch/js/ajaxSearch1/ajaxSearch-mootools2.js file\n    $cfg[''jsMooTools2''] = isset($jsMooTools2) ? $jsMooTools2 : (isset($__jsMooTools2) ? $__jsMooTools2 : $dcfg[''jsMooTools2'']);\n\n    // &jsQuery - Location of the jquery javascript library\n    // Default: AS_SPATH . ''js/jquery/jquery.js''\n    $cfg[''jsJquery''] = isset($jsJquery) ? $jsJquery : (isset($__jsJquery) ? $__jsJquery : $dcfg[''jsJquery'']);\n}\n\n// ========================================================== End of config\ninclude_once AS_PATH . "classes/ajaxSearch.class.inc.php";\nif (class_exists(''AjaxSearch'')) {\n    $as = new AjaxSearch();\n    $output = $as->run($tstart, $dcfg, $cfg);\n} else {\n    $output = "<h3>error: AjaxSearch class not found</h3>";\n}\n$elapsedTime = $modx->getMicroTime() - $tstart;\n$etime = sprintf("%.4fs",$elapsedTime);\n//$f=fopen(''test.txt'',''a+'');fwrite($f,"etime=".$etime."\\n\\n");\nreturn $output;\n', 0, '', ''),
(12, 'Wayfinder', '<strong>2.0.1+</strong> Completely template-driven and highly flexible menu builder', 0, 7, 0, '/*\n::::::::::::::::::::::::::::::::::::::::\n Snippet name: Wayfinder\n Short Desc: builds site navigation\n Version: 2.0\n Authors: \n	Kyle Jaebker (muddydogpaws.com)\n	Ryan Thrash (vertexworks.com)\n Date: February 27, 2006\n::::::::::::::::::::::::::::::::::::::::\nDescription:\n    Totally refactored from original DropMenu nav builder to make it easier to\n    create custom navigation by using chunks as output templates. By using templates,\n    many of the paramaters are no longer needed for flexible output including tables,\n    unordered- or ordered-lists (ULs or OLs), definition lists (DLs) or in any other\n    format you desire.\n::::::::::::::::::::::::::::::::::::::::\nExample Usage:\n    [[Wayfinder? &startId=`0`]]\n::::::::::::::::::::::::::::::::::::::::\n*/\n\n$wayfinder_base = $modx->config[''base_path'']."assets/snippets/wayfinder/";\n\n//Include a custom config file if specified\n$config = (isset($config)) ? "{$wayfinder_base}configs/{$config}.config.php" : "{$wayfinder_base}configs/default.config.php";\nif (file_exists($config)) {\n	include("$config");\n}\n\ninclude_once("{$wayfinder_base}wayfinder.inc.php");\n\nif (class_exists(''Wayfinder'')) {\n   $wf = new Wayfinder();\n} else {\n    return ''error: Wayfinder class not found'';\n}\n\n$wf->_config = array(\n	''id'' => isset($startId) ? $startId : $modx->documentIdentifier,\n	''level'' => isset($level) ? $level : 0,\n	''includeDocs'' => isset($includeDocs) ? $includeDocs : 0,\n	''excludeDocs'' => isset($excludeDocs) ? $excludeDocs : 0,\n	''ph'' => isset($ph) ? $ph : FALSE,\n	''debug'' => isset($debug) ? TRUE : FALSE,\n	''ignoreHidden'' => isset($ignoreHidden) ? $ignoreHidden : FALSE,\n	''hideSubMenus'' => isset($hideSubMenus) ? $hideSubMenus : FALSE,\n	''useWeblinkUrl'' => isset($useWeblinkUrl) ? $useWeblinkUrl : TRUE,\n	''fullLink'' => isset($fullLink) ? $fullLink : FALSE,\n	''nl'' => isset($removeNewLines) ? '''' : "\\n",\n	''sortOrder'' => isset($sortOrder) ? strtoupper($sortOrder) : ''ASC'',\n	''sortBy'' => isset($sortBy) ? $sortBy : ''menuindex'',\n	''limit'' => isset($limit) ? $limit : 0,\n	''cssTpl'' => isset($cssTpl) ? $cssTpl : FALSE,\n	''jsTpl'' => isset($jsTpl) ? $jsTpl : FALSE,\n	''rowIdPrefix'' => isset($rowIdPrefix) ? $rowIdPrefix : FALSE,\n	''textOfLinks'' => isset($textOfLinks) ? $textOfLinks : ''menutitle'',\n	''titleOfLinks'' => isset($titleOfLinks) ? $titleOfLinks : ''pagetitle'',\n	''displayStart'' => isset($displayStart) ? $displayStart : FALSE,\n);\n\n//get user class definitions\n$wf->_css = array(\n	''first'' => isset($firstClass) ? $firstClass : '''',\n	''last'' => isset($lastClass) ? $lastClass : ''last'',\n	''here'' => isset($hereClass) ? $hereClass : ''active'',\n	''parent'' => isset($parentClass) ? $parentClass : '''',\n	''row'' => isset($rowClass) ? $rowClass : '''',\n	''outer'' => isset($outerClass) ? $outerClass : '''',\n	''inner'' => isset($innerClass) ? $innerClass : '''',\n	''level'' => isset($levelClass) ? $levelClass: '''',\n	''self'' => isset($selfClass) ? $selfClass : '''',\n	''weblink'' => isset($webLinkClass) ? $webLinkClass : '''',\n);\n\n//get user templates\n$wf->_templates = array(\n	''outerTpl'' => isset($outerTpl) ? $outerTpl : '''',\n	''rowTpl'' => isset($rowTpl) ? $rowTpl : '''',\n	''parentRowTpl'' => isset($parentRowTpl) ? $parentRowTpl : '''',\n	''parentRowHereTpl'' => isset($parentRowHereTpl) ? $parentRowHereTpl : '''',\n	''hereTpl'' => isset($hereTpl) ? $hereTpl : '''',\n	''innerTpl'' => isset($innerTpl) ? $innerTpl : '''',\n	''innerRowTpl'' => isset($innerRowTpl) ? $innerRowTpl : '''',\n	''innerHereTpl'' => isset($innerHereTpl) ? $innerHereTpl : '''',\n	''activeParentRowTpl'' => isset($activeParentRowTpl) ? $activeParentRowTpl : '''',\n	''categoryFoldersTpl'' => isset($categoryFoldersTpl) ? $categoryFoldersTpl : '''',\n	''startItemTpl'' => isset($startItemTpl) ? $startItemTpl : '''',\n);\n\n//Process Wayfinder\n$output = $wf->run();\n\nif ($wf->_config[''debug'']) {\n	$output .= $wf->renderDebugOutput();\n}\n\n//Ouput Results\nif ($wf->_config[''ph'']) {\n    $modx->setPlaceholder($wf->_config[''ph''],$output);\n} else {\n    return $output;\n}\n', 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_templates`
--

CREATE TABLE `[[dbprefix]]site_templates` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `templatename` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT 'Template',
  `editor_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-plain text,1-rich text,2-code editor',
  `category` int(11) NOT NULL DEFAULT '0' COMMENT 'category id',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT 'url to icon file',
  `template_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-page,1-content',
  `content` mediumtext,
  `default_child_template` int(11) NOT NULL DEFAULT '0',
  `restrict_children` tinyint(1) NOT NULL DEFAULT '0',
  `allowed_child_templates` varchar(50) NOT NULL DEFAULT '',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the site templates.' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]site_templates`
--

INSERT INTO `[[dbprefix]]site_templates` VALUES
(3, 'Minimal Template', 'Default minimal empty template (content returned only)', 0, 0, '', 0, '[*content*]', 0, 0, '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_tmplvars`
--

CREATE TABLE `[[dbprefix]]site_tmplvars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `caption` varchar(80) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `editor_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-plain text,1-rich text,2-code editor',
  `category` int(11) NOT NULL DEFAULT '0' COMMENT 'category id',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `elements` text,
  `rank` int(11) NOT NULL DEFAULT '0',
  `display` varchar(20) NOT NULL DEFAULT '' COMMENT 'Display Control',
  `display_params` text COMMENT 'Display Control Properties',
  `default_text` text,
  PRIMARY KEY (`id`),
  KEY `indx_rank` (`rank`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Site Template Variables' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_tmplvar_access`
--

CREATE TABLE `[[dbprefix]]site_tmplvar_access` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `tmplvarid` int(10) NOT NULL DEFAULT '0',
  `documentgroup` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for template variable access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_tmplvar_contentvalues`
--

CREATE TABLE `[[dbprefix]]site_tmplvar_contentvalues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tmplvarid` int(10) NOT NULL DEFAULT '0' COMMENT 'Template Variable id',
  `contentid` int(10) NOT NULL DEFAULT '0' COMMENT 'Site Content Id',
  `value` text,
  PRIMARY KEY (`id`),
  KEY `idx_tmplvarid` (`tmplvarid`),
  KEY `idx_id` (`contentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Site Template Variables Content Values Link Table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_tmplvar_templates`
--

CREATE TABLE `[[dbprefix]]site_tmplvar_templates` (
  `tmplvarid` int(10) NOT NULL DEFAULT '0' COMMENT 'Template Variable id',
  `templateid` int(11) NOT NULL DEFAULT '0',
  `rank` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tmplvarid`,`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Site Template Variables Templates Link Table';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_eventnames`
--

CREATE TABLE `[[dbprefix]]system_eventnames` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `service` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'System Service number',
  `groupname` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='System Event Names.' AUTO_INCREMENT=1001 ;

--
-- Dumping data for table `[[dbprefix]]system_eventnames`
--

INSERT INTO `[[dbprefix]]system_eventnames` VALUES
(1, 'OnDocPublished', 5, ''),
(2, 'OnDocUnPublished', 5, ''),
(3, 'OnWebPagePrerender', 5, ''),
(4, 'OnWebLogin', 3, ''),
(5, 'OnBeforeWebLogout', 3, ''),
(6, 'OnWebLogout', 3, ''),
(7, 'OnWebSaveUser', 3, ''),
(8, 'OnWebDeleteUser', 3, ''),
(9, 'OnWebChangePassword', 3, ''),
(10, 'OnWebCreateGroup', 3, ''),
(11, 'OnManagerLogin', 2, ''),
(12, 'OnBeforeManagerLogout', 2, ''),
(13, 'OnManagerLogout', 2, ''),
(14, 'OnManagerSaveUser', 2, ''),
(15, 'OnManagerDeleteUser', 2, ''),
(16, 'OnManagerChangePassword', 2, ''),
(17, 'OnManagerCreateGroup', 2, ''),
(18, 'OnBeforeCacheUpdate', 4, ''),
(19, 'OnCacheUpdate', 4, ''),
(20, 'OnLoadWebPageCache', 4, ''),
(21, 'OnBeforeSaveWebPageCache', 4, ''),
(22, 'OnChunkFormPrerender', 1, 'Chunks'),
(23, 'OnChunkFormRender', 1, 'Chunks'),
(24, 'OnBeforeChunkFormSave', 1, 'Chunks'),
(25, 'OnChunkFormSave', 1, 'Chunks'),
(26, 'OnBeforeChunkFormDelete', 1, 'Chunks'),
(27, 'OnChunkFormDelete', 1, 'Chunks'),
(28, 'OnDocFormPrerender', 1, 'Documents'),
(29, 'OnDocFormRender', 1, 'Documents'),
(30, 'OnBeforeDocFormSave', 1, 'Documents'),
(31, 'OnDocFormSave', 1, 'Documents'),
(32, 'OnBeforeDocFormDelete', 1, 'Documents'),
(33, 'OnDocFormDelete', 1, 'Documents'),
(34, 'OnPluginFormPrerender', 1, 'Plugins'),
(35, 'OnPluginFormRender', 1, 'Plugins'),
(36, 'OnBeforePluginFormSave', 1, 'Plugins'),
(37, 'OnPluginFormSave', 1, 'Plugins'),
(38, 'OnBeforePluginFormDelete', 1, 'Plugins'),
(39, 'OnPluginFormDelete', 1, 'Plugins'),
(40, 'OnSnipFormPrerender', 1, 'Snippets'),
(41, 'OnSnipFormRender', 1, 'Snippets'),
(42, 'OnBeforeSnipFormSave', 1, 'Snippets'),
(43, 'OnSnipFormSave', 1, 'Snippets'),
(44, 'OnBeforeSnipFormDelete', 1, 'Snippets'),
(45, 'OnSnipFormDelete', 1, 'Snippets'),
(46, 'OnTempFormPrerender', 1, 'Templates'),
(47, 'OnTempFormRender', 1, 'Templates'),
(48, 'OnBeforeTempFormSave', 1, 'Templates'),
(49, 'OnTempFormSave', 1, 'Templates'),
(50, 'OnBeforeTempFormDelete', 1, 'Templates'),
(51, 'OnTempFormDelete', 1, 'Templates'),
(52, 'OnTVFormPrerender', 1, 'Template Variables'),
(53, 'OnTVFormRender', 1, 'Template Variables'),
(54, 'OnBeforeTVFormSave', 1, 'Template Variables'),
(55, 'OnTVFormSave', 1, 'Template Variables'),
(56, 'OnBeforeTVFormDelete', 1, 'Template Variables'),
(57, 'OnTVFormDelete', 1, 'Template Variables'),
(58, 'OnUserFormPrerender', 1, 'Users'),
(59, 'OnUserFormRender', 1, 'Users'),
(60, 'OnBeforeUserFormSave', 1, 'Users'),
(61, 'OnUserFormSave', 1, 'Users'),
(62, 'OnBeforeUserFormDelete', 1, 'Users'),
(63, 'OnUserFormDelete', 1, 'Users'),
(64, 'OnWUsrFormPrerender', 1, 'Web Users'),
(65, 'OnWUsrFormRender', 1, 'Web Users'),
(66, 'OnBeforeWUsrFormSave', 1, 'Web Users'),
(67, 'OnWUsrFormSave', 1, 'Web Users'),
(68, 'OnBeforeWUsrFormDelete', 1, 'Web Users'),
(69, 'OnWUsrFormDelete', 1, 'Web Users'),
(70, 'OnSiteRefresh', 1, ''),
(71, 'OnFileManagerUpload', 1, ''),
(72, 'OnModFormPrerender', 1, 'Modules'),
(73, 'OnModFormRender', 1, 'Modules'),
(74, 'OnBeforeModFormDelete', 1, 'Modules'),
(75, 'OnModFormDelete', 1, 'Modules'),
(76, 'OnBeforeModFormSave', 1, 'Modules'),
(77, 'OnModFormSave', 1, 'Modules'),
(78, 'OnBeforeWebLogin', 3, ''),
(79, 'OnWebAuthentication', 3, ''),
(80, 'OnBeforeManagerLogin', 2, ''),
(81, 'OnManagerAuthentication', 2, ''),
(82, 'OnSiteSettingsRender', 1, 'System Settings'),
(83, 'OnFriendlyURLSettingsRender', 1, 'System Settings'),
(84, 'OnUserSettingsRender', 1, 'System Settings'),
(85, 'OnInterfaceSettingsRender', 1, 'System Settings'),
(86, 'OnMiscSettingsRender', 1, 'System Settings'),
(87, 'OnRichTextEditorRegister', 1, 'RichText Editor'),
(88, 'OnRichTextEditorInit', 1, 'RichText Editor'),
(89, 'OnManagerPageInit', 2, ''),
(90, 'OnWebPageInit', 5, ''),
(91, 'OnLoadWebDocument', 5, ''),
(92, 'OnParseDocument', 5, ''),
(93, 'OnManagerLoginFormRender', 2, ''),
(94, 'OnWebPageComplete', 5, ''),
(95, 'OnLogPageHit', 5, ''),
(96, 'OnBeforeManagerPageInit', 2, ''),
(97, 'OnBeforeEmptyTrash', 1, 'Documents'),
(98, 'OnEmptyTrash', 1, 'Documents'),
(99, 'OnManagerLoginFormPrerender', 2, ''),
(100, 'OnStripAlias', 1, 'Documents'),
(110, 'OnGetChunk', 5, ''),
(200, 'OnCreateDocGroup', 1, 'Documents'),
(201, 'OnManagerWelcomePrerender', 2, ''),
(202, 'OnManagerWelcomeHome', 2, ''),
(203, 'OnManagerWelcomeRender', 2, ''),
(204, 'OnBeforeDocDuplicate', 1, 'Documents'),
(205, 'OnDocDuplicate', 1, 'Documents'),
(206, 'OnManagerMainFrameHeaderHTMLBlock', 2, ''),
(500, 'OnBeforeMakeURL', 1, ''),
(501, 'OnMakeURL', 1, ''),
(502, 'OnGetDocID', 1, ''),
(503, 'OnGetTableName', 1, ''),
(504, 'OnGetFullTableName', 1, ''),
(999, 'OnPageUnauthorized', 1, ''),
(1000, 'OnPageNotFound', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_settings`
--

CREATE TABLE `[[dbprefix]]system_settings` (
  `setting_name` varchar(50) NOT NULL DEFAULT '',
  `setting_value` text,
  UNIQUE KEY `setting_name` (`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains Content Manager settings.';

--
-- Dumping data for table `[[dbprefix]]system_settings`
--

INSERT INTO `[[dbprefix]]system_settings` VALUES
('allow_duplicate_alias', '0'),
('automatic_alias', '1'),
('auto_menuindex', '1'),
('auto_template_logic', 'parent'),
('blocked_minutes', '60'),
('cache_default', '1'),
('captcha_words', 'Clipper,Access,Better,BitCode,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Tattoo,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote'),
('captcha_words_default', 'ClipperCMS,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote'),
('clean_uploaded_filename', '0'),
('custom_contenttype', 'application/rss+xml,application/pdf,application/vnd.ms-word,application/vnd.ms-excel,text/html,text/css,text/xml,text/javascript,text/plain'),
('datepicker_year_range', '-10'),
('date_format', 'dd-mm-yy'),
('default_template', '3'),
('docid_visibility', '1'),
('editor_css_path', ''),
('editor_css_selectors', ''),
('emailsender', '[[admin_email]]'),
('emailsubject', 'Your login details'),
('emailsubject_default', 'Your login details'),
('error_handling_deprecated', '1'),
('error_handling_silent', '0'),
('error_page', '1'),
('failed_login_attempts', '3'),
('fck_editor_autolang', '0'),
('fck_editor_toolbar', 'standard'),
('fe_editor_lang', '[[language]]'),
('filemanager_path', '[[softpath]]/'),
('file_browser', 'kcfinder'),
('friendly_alias_urls', '1'),
('friendly_urls', '0'),
('friendly_url_prefix', ''),
('friendly_url_suffix', '.html'),
('jquery_noconflict', '1'),
('jquery_plugin_dir', 'assets/js/'),
('jquery_url', 'assets/js/jquery.min.js'),
('manager_direction', 'ltr'),
('manager_language', '[[language]]'),
('manager_layout', '4'),
('manager_theme', 'ClipperModern'),
('modx_charset', 'UTF-8'),
('new_file_permissions', '0644'),
('new_folder_permissions', '0755'),
('number_of_logs', '100'),
('number_of_messages', '30'),
('number_of_results', '20'),
('old_template', '3'),
('publish_default', '0'),
('rb_base_dir', '[[softpath]]/assets/'),
('rb_base_url', 'assets/'),
('rb_webuser', '0'),
('reload_captcha_words', ''),
('reload_emailsubject', ''),
('reload_signupemail_message', ''),
('reload_site_unavailable', ''),
('reload_system_email_webreminder_message', ''),
('reload_websignupemail_message', ''),
('remember_last_tab', '1'),
('rss_len', '10'),
('rss_url_news', 'http://www.clippercms.com/forum/extern.php?action=feed&fid=3,31&type=rss&order=posted'),
('rss_url_security', 'http://www.clippercms.com/forum/extern.php?action=feed&fid=22&type=rss&order=posted'),
('search_default', '1'),
('server_offset_time', '0'),
('server_protocol', 'http'),
('session.cookie.lifetime', '604800'),
('settings_version', '1.3.3'),
('signupemail_message', 'Hello [+uid+] \r\n\r\nHere are your login details for [+sname+] Content Manager:\r\n\r\nUsername: [+uid+]\r\nPassword: [+pwd+]\r\n\r\nOnce you log into the Content Manager ([+surl+]), you can change your password.\r\n\r\nRegards,\r\nSite Administrator'),
('siteunavailable_message_default', 'The site is currently unavailable.'),
('site_id', '[[site_id]]'),
('site_name', 'My Clipper Site'),
('site_start', '1'),
('site_status', '1'),
('site_unavailable_message', 'The site is currently unavailable'),
('site_unavailable_page', ''),
('smtp', '0'),
('smtp_host', ''),
('smtp_pass', ''),
('smtp_port', ''),
('smtp_prefix', 'ssl'),
('smtp_user', ''),
('strip_image_paths', '1'),
('system_email_signup_default', 'Hello [+uid+] \r\n\r\nHere are your login details for [+sname+] Content Manager:\r\n\r\nUsername: [+uid+]\r\nPassword: [+pwd+]\r\n\r\nOnce you log into the Content Manager ([+surl+]), you can change your password.\r\n\r\nRegards,\r\nSite Administrator'),
('system_email_webreminder_default', 'Hello [+uid+]\r\n\r\nTo activate your new password click the following link:\r\n\r\n[+surl+]\r\n\r\nIf successful you can use the following password to login:\r\n\r\nPassword:[+pwd+]\r\n\r\nIf you did not request this email then please ignore it.\r\n\r\nRegards,\r\nSite Administrator'),
('system_email_websignup_default', 'Hello [+uid+]\r\n\r\nHere are your login details for [+sname+]:\r\n\r\nUsername: [+uid+]\r\nPassword: [+pwd+]\r\n\r\nOnce you log into [+sname+] ([+surl+]), you can change your password.\r\n\r\nRegards,\r\nSite Administrator'),
('template_rules_tv', ''),
('theme_refresher', ''),
('time_format', 'HH:mm:ss'),
('tinymce_css_selectors', ''),
('tinymce_custom_buttons1', 'undo,redo,selectall,separator,pastetext,pasteword,separator,search,replace,separator,nonbreaking,hr,charmap,separator,image,link,unlink,anchor,media,separator,cleanup,removeformat,separator,fullscreen,print,code,help'),
('tinymce_custom_buttons2', 'bold,italic,underline,strikethrough,sub,sup,separator,bullist,numlist,outdent,indent,separator,justifyleft,justifycenter,justifyright,justifyfull,separator,styleselect,formatselect,separator,styleprops'),
('tinymce_custom_buttons3', ''),
('tinymce_custom_buttons4', ''),
('tinymce_custom_plugins', 'style,advimage,advlink,searchreplace,print,contextmenu,paste,fullscreen,nonbreaking,xhtmlxtras,visualchars,media'),
('tinymce_editor_theme', 'editor'),
('top_howmany', '10'),
('track_visitors', '0'),
('tree_page_click', '27'),
('tree_show_protected', '0'),
('udperms_allowroot', '0'),
('unauthorized_page', '1'),
('upload_files', 'aac,au,avi,css,cache,doc,docx,gz,gzip,htaccess,htm,html,js,mp3,mp4,mpeg,mpg,ods,odp,odt,pdf,ppt,pptx,rar,tar,tgz,txt,wav,wmv,xls,xlsx,xml,z,zip'),
('upload_flash', 'fla,flv,swf'),
('upload_images', 'bmp,ico,gif,jpeg,jpg,png,psd,tif,tiff'),
('upload_maxsize', '1048576'),
('upload_media', 'au,avi,mp3,mp4,mpeg,mpg,wav,wmv'),
('use_alias_path', '0'),
('use_browser', '1'),
('use_editor', '1'),
('use_udperms', '1'),
('validate_referer', '1'),
('valid_hostnames', '[[domhost]]'),
('warning_visibility', '1'),
('webpwdreminder_message', 'Hello [+uid+]\r\n\r\nTo activate your new password click the following link:\r\n\r\n[+surl+]\r\n\r\nIf successful you can use the following password to login:\r\n\r\nPassword:[+pwd+]\r\n\r\nIf you did not request this email then please ignore it.\r\n\r\nRegards,\r\nSite Administrator'),
('websignupemail_message', 'Hello [+uid+]\r\n\r\nHere are your login details for [+sname+]:\r\n\r\nUsername: [+uid+]\r\nPassword: [+pwd+]\r\n\r\nOnce you log into [+sname+] ([+surl+]), you can change your password.\r\n\r\nRegards,\r\nSite Administrator'),
('webuser_hash_method', '1'),
('which_editor', 'TinyMCE'),
('xhtml_urls', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_attributes`
--

CREATE TABLE `[[dbprefix]]user_attributes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `internalKey` int(10) NOT NULL DEFAULT '0',
  `fullname` varchar(100) NOT NULL DEFAULT '',
  `role` int(10) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(100) NOT NULL DEFAULT '',
  `mobilephone` varchar(100) NOT NULL DEFAULT '',
  `blocked` int(1) NOT NULL DEFAULT '0',
  `blockeduntil` int(11) NOT NULL DEFAULT '0',
  `blockedafter` int(11) NOT NULL DEFAULT '0',
  `logincount` int(11) NOT NULL DEFAULT '0',
  `lastlogin` int(11) NOT NULL DEFAULT '0',
  `thislogin` int(11) NOT NULL DEFAULT '0',
  `failedlogincount` int(10) NOT NULL DEFAULT '0',
  `sessionid` varchar(100) NOT NULL DEFAULT '',
  `dob` int(10) NOT NULL DEFAULT '0',
  `gender` int(1) NOT NULL DEFAULT '0' COMMENT '0 - unknown, 1 - Male 2 - female',
  `country` varchar(5) NOT NULL DEFAULT '',
  `state` varchar(25) NOT NULL DEFAULT '',
  `zip` varchar(25) NOT NULL DEFAULT '',
  `fax` varchar(100) NOT NULL DEFAULT '',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT 'link to photo',
  `comment` text,
  PRIMARY KEY (`id`),
  KEY `userid` (`internalKey`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains information about the backend users.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user_attributes`
--

INSERT INTO `[[dbprefix]]user_attributes` VALUES
(1, 1, 'Default admin account', 1, '[[admin_email]]', '', '', 0, 0, 0, 1, 0, [[timestamp]], 0, '', 0, 0, '', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_roles`
--

CREATE TABLE `[[dbprefix]]user_roles` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `frames` int(1) NOT NULL DEFAULT '0',
  `home` int(1) NOT NULL DEFAULT '0',
  `view_document` int(1) NOT NULL DEFAULT '0',
  `new_document` int(1) NOT NULL DEFAULT '0',
  `save_document` int(1) NOT NULL DEFAULT '0',
  `publish_document` int(1) NOT NULL DEFAULT '0',
  `delete_document` int(1) NOT NULL DEFAULT '0',
  `empty_trash` int(1) NOT NULL DEFAULT '0',
  `action_ok` int(1) NOT NULL DEFAULT '0',
  `logout` int(1) NOT NULL DEFAULT '0',
  `help` int(1) NOT NULL DEFAULT '0',
  `messages` int(1) NOT NULL DEFAULT '0',
  `new_user` int(1) NOT NULL DEFAULT '0',
  `edit_user` int(1) NOT NULL DEFAULT '0',
  `logs` int(1) NOT NULL DEFAULT '0',
  `edit_parser` int(1) NOT NULL DEFAULT '0',
  `save_parser` int(1) NOT NULL DEFAULT '0',
  `edit_template` int(1) NOT NULL DEFAULT '0',
  `settings` int(1) NOT NULL DEFAULT '0',
  `credits` int(1) NOT NULL DEFAULT '0',
  `new_template` int(1) NOT NULL DEFAULT '0',
  `save_template` int(1) NOT NULL DEFAULT '0',
  `delete_template` int(1) NOT NULL DEFAULT '0',
  `edit_snippet` int(1) NOT NULL DEFAULT '0',
  `new_snippet` int(1) NOT NULL DEFAULT '0',
  `save_snippet` int(1) NOT NULL DEFAULT '0',
  `delete_snippet` int(1) NOT NULL DEFAULT '0',
  `edit_chunk` int(1) NOT NULL DEFAULT '0',
  `new_chunk` int(1) NOT NULL DEFAULT '0',
  `save_chunk` int(1) NOT NULL DEFAULT '0',
  `delete_chunk` int(1) NOT NULL DEFAULT '0',
  `empty_cache` int(1) NOT NULL DEFAULT '0',
  `edit_document` int(1) NOT NULL DEFAULT '0',
  `change_password` int(1) NOT NULL DEFAULT '0',
  `error_dialog` int(1) NOT NULL DEFAULT '0',
  `about` int(1) NOT NULL DEFAULT '0',
  `file_manager` int(1) NOT NULL DEFAULT '0',
  `save_user` int(1) NOT NULL DEFAULT '0',
  `delete_user` int(1) NOT NULL DEFAULT '0',
  `save_password` int(11) NOT NULL DEFAULT '0',
  `edit_role` int(1) NOT NULL DEFAULT '0',
  `save_role` int(1) NOT NULL DEFAULT '0',
  `delete_role` int(1) NOT NULL DEFAULT '0',
  `new_role` int(1) NOT NULL DEFAULT '0',
  `access_permissions` int(1) NOT NULL DEFAULT '0',
  `bk_manager` int(1) NOT NULL DEFAULT '0',
  `new_plugin` int(1) NOT NULL DEFAULT '0',
  `edit_plugin` int(1) NOT NULL DEFAULT '0',
  `save_plugin` int(1) NOT NULL DEFAULT '0',
  `delete_plugin` int(1) NOT NULL DEFAULT '0',
  `new_module` int(1) NOT NULL DEFAULT '0',
  `edit_module` int(1) NOT NULL DEFAULT '0',
  `save_module` int(1) NOT NULL DEFAULT '0',
  `delete_module` int(1) NOT NULL DEFAULT '0',
  `exec_module` int(1) NOT NULL DEFAULT '0',
  `view_eventlog` int(1) NOT NULL DEFAULT '0',
  `delete_eventlog` int(1) NOT NULL DEFAULT '0',
  `new_web_user` int(1) NOT NULL DEFAULT '0',
  `edit_web_user` int(1) NOT NULL DEFAULT '0',
  `save_web_user` int(1) NOT NULL DEFAULT '0',
  `delete_web_user` int(1) NOT NULL DEFAULT '0',
  `web_access_permissions` int(1) NOT NULL DEFAULT '0',
  `view_unpublished` int(1) NOT NULL DEFAULT '0',
  `import_static` int(1) NOT NULL DEFAULT '0',
  `remove_locks` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains information describing the user roles.' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]user_roles`
--

INSERT INTO `[[dbprefix]]user_roles` VALUES
(1, 'Administrator', 'Site administrators have full access to all functions', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(2, 'Editor', 'Limited to managing content', 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1),
(3, 'Publisher', 'Editor with expanded permissions including manage users, update Elements and site settings', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_settings`
--

CREATE TABLE `[[dbprefix]]user_settings` (
  `user` int(11) NOT NULL,
  `setting_name` varchar(50) NOT NULL DEFAULT '',
  `setting_value` text,
  KEY `setting_name` (`setting_name`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains backend user settings.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webgroup_access`
--

CREATE TABLE `[[dbprefix]]webgroup_access` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `webgroup` int(10) NOT NULL DEFAULT '0',
  `documentgroup` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for web access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webgroup_names`
--

CREATE TABLE `[[dbprefix]]webgroup_names` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for web access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]web_groups`
--

CREATE TABLE `[[dbprefix]]web_groups` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `webgroup` int(10) NOT NULL DEFAULT '0',
  `webuser` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_group_user` (`webgroup`,`webuser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains data used for web access permissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]web_users`
--

CREATE TABLE `[[dbprefix]]web_users` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '',
  `hashtype` smallint(6) NOT NULL DEFAULT '0',
  `salt` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `cachepwd` varchar(100) NOT NULL DEFAULT '' COMMENT 'Store new unconfirmed password',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]web_user_attributes`
--

CREATE TABLE `[[dbprefix]]web_user_attributes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `internalKey` int(10) NOT NULL DEFAULT '0',
  `fullname` varchar(100) NOT NULL DEFAULT '',
  `role` int(10) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(100) NOT NULL DEFAULT '',
  `mobilephone` varchar(100) NOT NULL DEFAULT '',
  `blocked` int(1) NOT NULL DEFAULT '0',
  `blockeduntil` int(11) NOT NULL DEFAULT '0',
  `blockedafter` int(11) NOT NULL DEFAULT '0',
  `logincount` int(11) NOT NULL DEFAULT '0',
  `lastlogin` int(11) NOT NULL DEFAULT '0',
  `thislogin` int(11) NOT NULL DEFAULT '0',
  `failedlogincount` int(10) NOT NULL DEFAULT '0',
  `sessionid` varchar(100) NOT NULL DEFAULT '',
  `dob` int(10) NOT NULL DEFAULT '0',
  `gender` int(1) NOT NULL DEFAULT '0' COMMENT '0 - unknown, 1 - Male 2 - female',
  `country` varchar(5) NOT NULL DEFAULT '',
  `state` varchar(25) NOT NULL DEFAULT '',
  `zip` varchar(25) NOT NULL DEFAULT '',
  `fax` varchar(100) NOT NULL DEFAULT '',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT 'link to photo',
  `comment` text,
  PRIMARY KEY (`id`),
  KEY `userid` (`internalKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains information for web users.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]web_user_settings`
--

CREATE TABLE `[[dbprefix]]web_user_settings` (
  `webuser` int(11) NOT NULL,
  `setting_name` varchar(50) NOT NULL DEFAULT '',
  `setting_value` text,
  KEY `setting_name` (`setting_name`),
  KEY `webuserid` (`webuser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains web user settings.';

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
