
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `chyrp252`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, 'Admin'),
(4, 'Banned'),
(3, 'Friend'),
(5, 'Guest'),
(2, 'Member');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) DEFAULT '',
  `body` longtext,
  `show_in_list` tinyint(1) DEFAULT '1',
  `list_order` int(11) DEFAULT '0',
  `clean` varchar(128) DEFAULT '',
  `url` varchar(128) DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `parent_id` int(11) DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) DEFAULT '',
  `group_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
('add_draft', 'Add Drafts', 0),
('add_draft', 'Add Drafts', 1),
('add_group', 'Add Groups', 0),
('add_group', 'Add Groups', 1),
('add_page', 'Add Pages', 0),
('add_page', 'Add Pages', 1),
('add_post', 'Add Posts', 0),
('add_post', 'Add Posts', 1),
('add_user', 'Add Users', 0),
('add_user', 'Add Users', 1),
('change_settings', 'Change Settings', 0),
('change_settings', 'Change Settings', 1),
('delete_draft', 'Delete Drafts', 0),
('delete_draft', 'Delete Drafts', 1),
('delete_group', 'Delete Groups', 0),
('delete_group', 'Delete Groups', 1),
('delete_own_draft', 'Delete Own Drafts', 0),
('delete_own_draft', 'Delete Own Drafts', 1),
('delete_own_post', 'Delete Own Posts', 0),
('delete_own_post', 'Delete Own Posts', 1),
('delete_page', 'Delete Pages', 0),
('delete_page', 'Delete Pages', 1),
('delete_post', 'Delete Posts', 0),
('delete_post', 'Delete Posts', 1),
('delete_user', 'Delete Users', 0),
('delete_user', 'Delete Users', 1),
('edit_draft', 'Edit Drafts', 0),
('edit_draft', 'Edit Drafts', 1),
('edit_group', 'Edit Groups', 0),
('edit_group', 'Edit Groups', 1),
('edit_own_draft', 'Edit Own Drafts', 0),
('edit_own_draft', 'Edit Own Drafts', 1),
('edit_own_post', 'Edit Own Posts', 0),
('edit_own_post', 'Edit Own Posts', 1),
('edit_page', 'Edit Pages', 0),
('edit_page', 'Edit Pages', 1),
('edit_post', 'Edit Posts', 0),
('edit_post', 'Edit Posts', 1),
('edit_user', 'Edit Users', 0),
('edit_user', 'Edit Users', 1),
('toggle_extensions', 'Toggle Extensions', 0),
('toggle_extensions', 'Toggle Extensions', 1),
('view_draft', 'View Drafts', 0),
('view_draft', 'View Drafts', 1),
('view_own_draft', 'View Own Drafts', 0),
('view_own_draft', 'View Own Drafts', 1),
('view_private', 'View Private Posts', 0),
('view_private', 'View Private Posts', 1),
('view_private', 'View Private Posts', 3),
('view_scheduled', 'View Scheduled Posts', 0),
('view_scheduled', 'View Scheduled Posts', 1),
('view_scheduled', 'View Scheduled Posts', 3),
('view_site', 'View Site', 0),
('view_site', 'View Site', 1),
('view_site', 'View Site', 2),
('view_site', 'View Site', 3),
('view_site', 'View Site', 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feather` varchar(32) DEFAULT '',
  `clean` varchar(128) DEFAULT '',
  `url` varchar(128) DEFAULT '',
  `pinned` tinyint(1) DEFAULT '0',
  `status` varchar(32) DEFAULT 'public',
  `user_id` int(11) DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_attributes`
--

CREATE TABLE `[[dbprefix]]post_attributes` (
  `post_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`post_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` varchar(40) NOT NULL DEFAULT '',
  `data` longtext,
  `user_id` int(11) DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(64) DEFAULT '',
  `password` varchar(60) DEFAULT '',
  `full_name` varchar(250) DEFAULT '',
  `email` varchar(128) DEFAULT '',
  `website` varchar(128) DEFAULT '',
  `group_id` int(11) DEFAULT '0',
  `approved` tinyint(1) DEFAULT '1',
  `joined_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '', '[[admin_email]]', '[[softurl]]', 1, 1, '[[regtime]]');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
