<?php
\Schema::create('tags', function ($table) {
  $table->increments('id');
  $table->string('tag', 255);
  $table->string('DE', 255)->default('');
  $table->string('EN', 255)->default('');
  $table->string('ES', 255)->default('');
  $table->string('FR', 255)->default('');
  $table->string('IT', 255)->default('');
  $table->string('RU', 255)->default('');
  $table->string('ZH_CN', 255)->default('');
  $table->string('ZH_TW', 255)->default('');
  $table->string('bgcolor', 50)->default('#330033');
  $table->string('ftcolor', 50)->default('#FFFFFF');
  $table->timestamps();
  $table->unique('tag');
});

\DB::table('tags')->insert(array(
	array('id'=>1,	'tag'=>'status:open',			'bgcolor'=>'#c43c35','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'status:open',			'FR'=>'État:ouvert',			'ES'=>'Estado: Aberto'),
	array('id'=>2,	'tag'=>'status:closed',			'bgcolor'=>'#46A546','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'status:closed',		'FR'=>'État:fermé',				'ES'=>'Estado: Cerrado'),
	array('id'=>3,	'tag'=>'type:feature',			'bgcolor'=>'#62cffc','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'type:feature',			'FR'=>'Type: développement',	'ES'=>'Tipo: desarollo'),
	array('id'=>4,	'tag'=>'type:bug',				'bgcolor'=>'#f89406','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'type:bug',				'FR'=>'Type: débogage',			'ES'=>'Tipo: debug'),
	array('id'=>6,	'tag'=>'resolution:won`t fix',	'bgcolor'=>'#812323','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'resolution:won`t fix',	'FR'=>'Verdict: impossible :(',	'ES'=>'Deicsion: impossible'),
	array('id'=>7,	'tag'=>'resolution:fixed',		'bgcolor'=>'#048383','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'resolution:fixed',		'FR'=>'Verdict: Résolu ! :)',	'ES'=>'Decision: Solucionado'),
	array('id'=>8,	'tag'=>'status:testing',		'bgcolor'=>'#FCC307','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2016-11-30 23:11:01','EN'=>'status:testing',		'FR'=>'État: nous testons',		'ES'=>'Estado: haciendo tests'),
	array('id'=>9,	'tag'=>'status:inProgress',		'bgcolor'=>'#FF6600','ftcolor'=>'#FFFFFF','created_at'=>'2016-11-10 23:12:01','updated_at'=>'2016-11-10 23:12:01','EN'=>'status:inProgress',	'FR'=>'État: Progressons',		'ES'=>'Estado: progressamos')
));

\DB::query("INSERT INTO projects_issues_tags (issue_id, tag_id, created_at, updated_at)
	(SELECT id as issue_id, IF(status = 1, 1, 2) as tag_id, NOW(), NOW() FROM projects_issues )"
	);


