<?php

    namespace thebuggenie\core\modules\installation\upgrade_413;

    use thebuggenie\core\entities\common\IdentifiableScoped;

    /**
     * Agile board class
     *
     * @package thebuggenie
     * @subpackage agile
     *
     * @Table(name="\thebuggenie\core\modules\installation\upgrade_413\AgileBoardsTable")
     */
    class AgileBoard extends IdentifiableScoped
    {
        /**
         * The name of the board
         *
         * @var string
         * @Column(type="string", length=200)
         */
        protected $_name;

        /**
         * Board description
         *
         * @var string
         * @Column(type="string", length=200)
         */
        protected $_description;

        /**
         * Whether this board is the private
         *
         * @var boolean
         * @Column(type="boolean", default=1)
         */
        protected $_is_private = true;

        /**
         * @var \thebuggenie\core\entities\User
         * @Column(type="integer", length=10)
         * @Relates(class="\thebuggenie\core\entities\User")
         */
        protected $_user_id;

        /**
         * @var \thebuggenie\core\entities\Project
         * @Column(type="integer", length=10)
         * @Relates(class="\thebuggenie\core\entities\Project")
         */
        protected $_project_id;

        /**
         * @var \thebuggenie\core\entities\Issuetype
         * @Column(type="integer", length=10)
         * @Relates(class="\thebuggenie\core\entities\Issuetype")
         */
        protected $_epic_issuetype_id;

        /**
         * @var \thebuggenie\core\entities\Issuetype
         * @Column(type="integer", length=10)
         * @Relates(class="\thebuggenie\core\entities\Issuetype")
         */
        protected $_task_issuetype_id;

        /**
         * @var \thebuggenie\core\entities\SavedSearch
         * @Column(type="integer", length=10)
         * @Relates(class="\thebuggenie\core\entities\SavedSearch")
         */
        protected $_backlog_search_id;

        /**
         * @var integer
         * @Column(type="integer", length=10)
         */
        protected $_autogenerated_search;

        /**
         * The board type
         *
         * @var integer
         * @Column(type="integer", length=10)
         */
        protected $_type = self::TYPE_SCRUM;

        /**
         * Whether to use swimlanes
         *
         * @var boolean
         * @Column(type="boolean", default=false)
         */
        protected $_use_swimlanes = false;

        /**
         * Swimlane type
         *
         * @var string
         * @Column(type="string", length=50, default="issuetype")
         */
        protected $_swimlane_type = self::SWIMLANES_ISSUES;

        /**
         * Swimlane identifier field
         *
         * @var string
         * @Column(type="string", length=50, default="issuetype")
         */
        protected $_swimlane_identifier = "issuetype";

        /**
         * Swimlane field value
         *
         * @var array
         * @Column(type="serializable", length=500)
         */
        protected $_swimlane_field_values = array();

        /**
         * Board columns
         *
         * @var array|\thebuggenie\modules\agile\entities\BoardColumn
         * @Relates(class="\thebuggenie\modules\agile\entities\BoardColumn", collection=true, foreign_column="board_id", orderby="sort_order")
         */
        protected $_board_columns = null;

    }
