
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `buggenie431`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]agileboards`
--

CREATE TABLE `[[dbprefix]]agileboards` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `is_private` tinyint(1) DEFAULT NULL,
  `user_id` int(10) DEFAULT '0',
  `project_id` int(10) DEFAULT '0',
  `epic_issuetype_id` int(10) DEFAULT '0',
  `task_issuetype_id` int(10) DEFAULT '0',
  `backlog_search_id` int(10) DEFAULT '0',
  `autogenerated_search` int(10) DEFAULT '0',
  `type` int(10) DEFAULT '0',
  `use_swimlanes` tinyint(1) DEFAULT NULL,
  `swimlane_type` varchar(50) DEFAULT NULL,
  `swimlane_identifier` varchar(50) DEFAULT NULL,
  `swimlane_field_values` varchar(500) DEFAULT NULL,
  `issue_field_values` varchar(500) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]agileboard_columns`
--

CREATE TABLE `[[dbprefix]]agileboard_columns` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `board_id` int(10) DEFAULT '0',
  `sort_order` int(10) DEFAULT '0',
  `max_workitems` int(10) DEFAULT '0',
  `min_workitems` int(10) DEFAULT '0',
  `status_ids` varchar(500) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]application_password`
--

CREATE TABLE `[[dbprefix]]application_password` (
  `name` varchar(200) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `created_at` int(10) DEFAULT '0',
  `last_used_at` int(10) DEFAULT '0',
  `user_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articlecategories`
--

CREATE TABLE `[[dbprefix]]articlecategories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `article_name` varchar(300) DEFAULT NULL,
  `article_is_category` tinyint(1) DEFAULT '0',
  `category_name` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]articlecategories`
--

INSERT INTO `[[dbprefix]]articlecategories` VALUES
(1, 1, 'Category:Help:Configuration', 1, 'Help'),
(2, 1, 'VCSIntegration', 0, 'Help'),
(3, 1, 'ConfigurePermissions', 0, 'Help'),
(4, 1, 'ConfigurePermissions', 0, 'Help:Configuration'),
(5, 1, 'ConfigurePermissions', 0, 'Help:Howto'),
(6, 1, 'CreatingIssues', 0, 'Help'),
(7, 1, 'CreatingIssues', 0, 'Help:Howto'),
(8, 1, 'Workflow', 0, 'TheBugGenie:Workflow'),
(9, 1, 'CamelCasing', 0, 'Help'),
(10, 1, 'CSVImport', 0, 'Help'),
(11, 1, 'GettingStarted', 0, 'Help'),
(12, 1, 'GettingStarted', 0, 'Help:Howto'),
(13, 1, 'Category:Help:HowTo', 1, 'Help'),
(14, 1, 'WikiFormatting', 0, 'Help'),
(15, 1, 'WikiFormatting', 0, 'Help:Howto');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articlefiles`
--

CREATE TABLE `[[dbprefix]]articlefiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `article_id` int(10) unsigned DEFAULT '0',
  `file_id` int(10) unsigned DEFAULT '0',
  `attached_at` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articlehistory`
--

CREATE TABLE `[[dbprefix]]articlehistory` (
  `article_name` varchar(255) DEFAULT NULL,
  `old_content` text,
  `new_content` text,
  `reason` text,
  `revision` int(10) DEFAULT '0',
  `date` int(10) DEFAULT '0',
  `author` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- Dumping data for table `[[dbprefix]]articlehistory`
--

INSERT INTO `[[dbprefix]]articlehistory` VALUES
('Category:Help', NULL, 'This is a list of all the available help articles in The Bug Genie. If you are stuck, look here for help.', NULL, 1, [[timestamp]], 0, 1, 1),
('IssuetypeScheme', NULL, '= Description =\nAn issue type scheme is the scheme that specifies - per issue type - which issue fields are:\n* available for reporting via the "main" reporting view\n* available for reporting via the "additional information" pane at the bottom\n* required for reporting\n* available on the "view issue" page\n\nAll issue types have their own settings for which fields are available / required on both the reporting page and on the issue overview page. These settings are deeply integrated in The Bug Genie, and always respected.\n\nOn the [[CreatingIssues|Report an issue]] page, fields will be displayed and marked as required based on the settings specified in the issue type scheme in use by the selected project. These settings are also used to determine which fields are displayed on the "View issue" page.\n\n= Custom fields =\nBecause the DefaultIssuetypeScheme is not editable, you have to create a copy of it and modify that copy to be able to display any CustomFields, as they would not be available by default. Which issuetype scheme a project uses is available in the project configuration popup.', NULL, 1, [[timestamp]], 0, 1, 2),
('ForgottenPasswordIntro', NULL, '= Forgot your password? =\nIf you have forgotten your password, enter your username here and we will send you an email with instructions on how to change your password.', NULL, 1, [[timestamp]], 0, 1, 3),
('Category:Help:Configuration', NULL, 'This is a list of all the available help articles on configuring The Bug Genie.\n\n[[Category:Help]]', NULL, 1, [[timestamp]], 0, 1, 4),
('VCSIntegration', NULL, '{{TOC}}\n= VCS Integration =\nThe Bug Genie includes the VCS Integration module, which allows you to link your projects in The Bug Genie to a source code repository. This allows your commits to update issues, as well as access the repository viewer from The Bug Genie. However, before you can start, you need to set up the module - both globally and for each project using the module.\n\nPlease note that the git hook does not support the web access method (explained later), only the direct access method. In addition, a Mercurial hook is available, though it is not included due to license restrictions. Please refer to The Bug Genie website to obtain it.\n\n= Setting up =\n=== Global settings ===\nThere are two methods for VCS hooks (the code that interfaces between your source code repository and The Bug Genie) to communicate with your installation. The methods are ''''''direct access'''''' and ''''''http access''''''.\n\n==== Direct access ====\nIn direct access, the repository exists on the same server as The Bug Genie, or the hook can use SSH or other associated systems to access the server that The Bug Genie is hosted on. Therefore the user that VCS hooks are executed as will need access to The Bug Genie''s files, as well as a PHP executable. You will also require the CLI version of PHP installed.\n\nIn each hook, you will need to enable direct mode, and set the path to PHP and The Bug Genie''s tbg_cli file. You will also need to set the project ID, which can be found on the VCS configuration page. Please refer to each hook''s documentation (it may be included in the hook file itself) to see how to do this.\n\nThen, in the VCS Integration general settings tab, on the Configuration page, choose ''''''Direct access'''''' and click Save. You can then set up your projects.\n\n==== HTTP access ====\nAnother option would be to use HTTP access, where the hook will use HTTP to access a page on your installation of The Bug Genie, which will cause the checkin to be recorded. Choose this option if you are not able to use the direct method. You will also need this method to interface The Bug Genie with github.\n\nYou will need to configure hooks to use this mode, as well as set the project ID and URL to access. Refer to hook documentation for doing this (this may be included in the hook itself). Please also set a secure passkey to prevent unauthorized commits. This will need to be the same for every VCS, and set in each hook.\n\nYou will then need to choose ''''''HTTP access'''''' on the VCS Integration general settings tab. In addition, you will need to enter the passkey you set earlier on this screen.\n\nAfter saving these settings, you can then set up each project.\n\n==== Github support ====\nIf you wish to use the github hook, please set up HTTP access as previously discussed. You will then need to set up your Github project''s post-receive hook to contact The Bug Genie.\n\nTo do this, go to your project''s service hooks page on github, and set a Post-recieve URL to point to the following URL:\n  http://www.your-tbg-site.com/vcs_integration/report/PROJECTID/github/?passkey=PASSKEY\nYou will need to set the hostname and path correctly as appropriate, as well as replacing PASSKEY with the passkey you set, and PROJECTID with the ID number of the project, which can be found on the projects tab of VCS Integration configuration.\n\nAny commits which follow the rules for being picked up (see below) will then be recorded against their respective issues on push, though commits which make no changes to the filesystem (i.e. nothing added, removed or modified) will not be recorded in this release of VCS Integration.\n\n==== Bitbucket support ====\nIf you wish to use the bitbucket hook, please set up HTTP access as previously discussed. You will then need to set up your Bitbucket project''s post-receive hook to contact The Bug Genie.\n\nTo do this, go to your project''s service hooks page on bitbucket, and set a POST URL to point to the following URL:\n  http://www.your-tbg-site.com/vcs_integration/report/PROJECTID/bitbucket/?passkey=PASSKEY\nYou will need to set the hostname and path correctly as appropriate, as well as replacing PASSKEY with the passkey you set, and PROJECTID with the ID number of the project, which can be found on the projects tab of VCS Integration configuration.\n\nAny commits which follow the rules for being picked up (see below) will then be recorded against their respective issues on push, though commits which make no changes to the filesystem (i.e. nothing added, removed or modified) will not be recorded in this release of VCS Integration.\n\n==== Gitorious support ====\nIf you have a locally hosted Gitorious server, then you can integrate that with The Bug Genie.\n\nAgain, set a post-receive hook as per your documentation, the URL for which is:\n  http://www.your-tbg-site.com/vcs_integration/report/PROJECTID/gitorious/?passkey=PASSKEY\n\nPlease note that the Gitorious support will only create comments and will not record filesystem changes, plus it will not work on the gitorious.com server.\n\n=== Project settings ===\nEach project to use VCS Integration will then require configuration. If a project will not be using VCS Integration, then you can leave its repository URL field empty.\n\nTo set up each project, you need to specify the repository browser you use. This will be used to build the right URLs to be displayed in The Bug Genie. In the ''''URL to repository browser'''' field, you enter the path to the root of the repository browser (i.e. this may be the page where a list of available repository browsers is shown). Finally you enter the repository name in the final box.\n\nAfter pressing save, a ''''''Source code'''''' link will be added to the project dashboard. You can use this link to test to see if the details are correct - if so this link will open the main page of the repository browser for your chosen project.\n\nAfter doing this, the module can be used by committing details as below, and they will show up in a new tab when viewing an issue, with links to view files, diffs, revision info and other details.\n\n= Using the module =\n\nWhen a commit is made which refers to an issue, then the issue will be updated with the commit log and details of every changed file. The Bug Genie will pick up any commits which contain any of the following words, followed by an issue number:\n  bug, issue, ticket, fix, fixes, fixed, fixing, applies to, closes\n  references, ref, addresses, re, see, according to, also see\n\nThe user assigned to the commit will depends on the user who committed it to the VCS. If you are using a VCS where your committer name is in the form "Joe Bloggs <jbloggs@example.com>", for example, then The Bug Genie will search for users with the email as provided.\n\nIf a user can not be found, or if there is no email, then The Bug Genie will take the name part (or username) and search against the Full Name field. Failing that, we then search against the friendly name and then finally the user name. If still no user can be found then no user will be recorded for the commit.\n\nLinks on the project dashboard to view the source code repository is added upon set up, and each commit will have a link to view the commit details, a log of commits, diffs and links to view files.\n[[Category:Help]]\n', NULL, 1, [[timestamp]], 0, 1, 5),
('DefaultWorkflow', NULL, '= Overview =\nThe default workflow is used for issue types that does not have a workflow set in the workflow scheme associated with the current project. The default workflow is also used in the default workflow scheme setup.<br>\nThis is an overview of the default workflow setup with its steps and transitions:\n\n{|\n! Step !! Connected status !! State !! Outgoing transitions !! Notes\n|-\n| ''''''New'''''' || ''''New'''' || Open and editable || Investigate issue → Investigating<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress<br>Resolve issue → Closed || This is the default, initial step all issues start in\n|-\n| ''''''Investigating'''''' || ''''Investigating'''' || Open and editable || Request more information → New<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress || \n|-\n| ''''''Confirmed'''''' || ''''Confirmed'''' || Open but not editable || Accept issue → In progress <br>Assign issue → In progress <br>Resolve issue → Closed || \n|-\n| ''''''In progress'''''' || ''''Being worked on'''' || Open but not editable || Reject issue → Rejected <br>Mark ready for testing → Ready for testing <br>Resolve issue → Closed || \n|-\n| ''''''Ready for testing'''''' || ''''Ready for testing / QA'''' || Open but not editable || Resolve issue → Closed <br>Test issue solution → Testing || \n|-\n| ''''''Testing'''''' || ''''Testing / QA'''' || Open but not editable || Accept issue solution → Closed <br>Reject issue solution → In progress || \n|-\n| ''''''Rejected'''''' || ''''Not a bug'''' || Closed and not editable || Reopen issue → New || \n|-\n| ''''''Closed'''''' || - || Closed and not editable || Reopen issue → New || This workflow step is not linked directly to a status\n|}\n\nSome things to note about the default workflow:\n* It is not possible to directly move an issue from new to closed - it has to either be accepted or assigned first. You can however move it directly to rejected if it is invalid or duplicate\n* The ''''Closed'''' step is not linked to a status, but has two valid statuses - ''''''Closed'''''' and ''''''Postponed''''''', NULL, 1, [[timestamp]], 0, 1, 6),
('MainPage', NULL, 'This is the global wiki frontpage.', NULL, 1, [[timestamp]], 0, 1, 7),
('ConfigurePermissions', NULL, '= Setting up and understanding permissions in The Bug Genie =\n{{TOC}}\n== How are permissions defined? ==\nPermissions are defined on a 4-level basis, in the following order:\n# ''''''Global permissions'''''' - applies to all users, groups and teams\n# ''''''Group-specific permissions'''''' - applies only to members in that usergroup\n# ''''''Team-specific permissions'''''' - applies to any member of that team, and you can be a member of multiple teams\n# ''''''User-specific permissions'''''' - applies to the user it''s specified for\nEach new level in the above list overrides the previous one. That means if you''ve set "''''Report issues''''" to "''''Allowed''''" for "''''''''''Everyone''''''''''" and "''''Denied''''" for the "''''''''''Guest group''''''''''", then the group permission will override the global permission for all users in the guest group. In addition to this, The Bug Genie has a "''''Permissive''''" or "''''Restrictive''''" security setting which means if you trust all your users you can set this setting to "''''Permissive''''" and everyone will be able to do pretty much anything unless specifically denied. The only exception here is access to the configuration pages, where you must have explicit "''''Allowed''''" access. This gives you fine-grained control over what users, groups and teams can do.\n\n== Permissions hierarchy ==\nMany settings are grouped, and most specific settings (ex: "''''Can set issue priority''''") are only available as sub-permissions of more general groups. An example is the "''''Can edit basic information on your own issues''''" permission. This has three sub-settings, "''''Can edit title''''", "''''Can edit descrition''''" and "''''Can edit reproductions steps''''". Using "''''''''''Everyone''''''''''" as an example, if you set the top setting to "''''Allowed''''", everyone can edit basic information (title, description and reproduction steps) for issues they create. If you want to modify this, say you only want them to change the title, then you can do this two ways:\n# Set "''''Can edit description''''" and "''''Can edit reproduction steps''''" to "''''Denied''''". They will still have the basic "''''Can edit basic information (...)''''" setting, which means the title is editable, but the "''''Denied''''" settings for editing description and reproduction steps has higher priority, which means they will not be editable.\n# Unset the "''''Can edit basic information (...)''''" permission, and only set "''''Can edit title''''" to "''''Allowed''''".\nThis grouping is used several places, and is indicated by a little list icon next to the permission icon in the permissions overview. Clicking the list icon brings up all permissions in that group and lets you specify a more fine-grained permission in the group if desired.\n\n== Project-specific permissions ==\nAdding to all this, many permissions can be set on a project-specific basis. You might want to only let people report issues for a certain project, or restrict people from doing something on a specific project. The "''''Project-specific permissions''''"-tab in the permissions overview lets you define this. The same rules apply as above, but if a project-specific permission is set, then it will take presedence over the global permission.\n\n== Page access permissions ==\nYou can limit access to certain pages if you want to restrict users from accessing them. Some of these settings are available as both global and project-specific settings - such as the project-specific pages. This setting is "''''Permissive''''" by default and cannot be changed.\n\n== Datatype permissions ==\nEvery datatype (status, priority, category, etc) also have their own permissions available for each defined value. This setting is permissive by default (and cannot be changed), but lets you control who can set which field to a certain value. Even if you set a datatype field permission to "''''Denied''''" the user will still be able to ''''see'''' the field value, but they cannot set it to that value if the permission is "''''Denied''''". This can be useful in a workflow setting where you only want certain users to be able to mark issues as "''''Fixed''''", "''''Closed''''", etc.\n''''''These permissions are also available for all custom datatypes''''''.\n\n== Nice to know about the permissions handling ==\n* There is one important exception in effect when you''re reporting an issue: If a field is set to "''''''Required''''''" in the reporting process, then the user will have access to this field, even if it set in the permissions manager that they are not allowed to change it. This is to stop the reporting wizard from failing if you''re missing access to a required field. They still need access to a field value to set it, so if all field values are set to "''''Denied''''" then they won''t have any options to choose from. They will also not be able to change it after the issue has been reported if they don''t have access to do so.\n* If a user has read or write access to any of the configuration pages, they will automatically see the "''''Configure''''" link in the menu. If they don''t have access to any configuration page, this link will be hidden.\n* The permissions setting dialog will always show if a setting is permissive or restrictive by default, by showing a faded out "''''Denied''''" or faded out "''''Allowed''''" icon.\n\n[[Category:Help]][[Category:Help:Configuration]][[Category:Help:Howto]]', NULL, 1, [[timestamp]], 0, 1, 8),
('CreatingIssues', NULL, '{{TOC}}\n= Introduction =\nCreating issues in The Bug Genie requires one or more existing projects, as all issues are filed against projects.\n\n= How to start creating an issue =\nWhen a project has been created, an issue can be filed by either using the "Report an issue" tab inside the project space, or by using the "Report an issue" button on the frontpage, if the project is visible there. Both methods will let you pick an issue type directly via a dropdown menu. If you don''t specify an issue type (by clicking directly on the "Report an issue" links, you can specify as the first step on the reporting page.\n\n= Specifying issue details =\nWhen you report an issue, you have to specify the details you want to be saved with the issue when it is reported. By default these details include items such as a descriptive title, a longer description about the issue and a reproduction step list. \n\nThe available and required fields you have to fill out vary depending on the type of issue you are reporting and the associated IssuetypeScheme. The only field that will always be available (and required) is the descriptive title, other fields may vary. A short description of each possible field follows:\n\n=== Title ===\nThis is a short (max 150 char) but descriptive overview of the issue you''re filing. It should be descriptive enough to identify the issue, but short enough to fit on one line.\n* Bad example: ''''The application crashes constantly''''\n* Good example: ''''Whenever I let my cat sleep on the keyboard, the application crashes after about two hours''''\n\n=== Description ===\nA thorough description of the issue. Use as many words as is needed to describe the issue. Pretend that you''re describing it to your mom.\n* Bad example: ''''The stupid application crashed on me! Just as I was about to send my document!"\n* Good example: ''''I opened up the application to write a letter to my aunt. I had been writing for two hours non-stop, and was about to send it, when I tripped and accidentally hit some keys on my keyboard and the application crashed with a message saying "Invalid key combination: CTRL+ALT+PAGEUP+F+S+L+G"''''\n\n=== Reproduction steps ===\nA step-by-step guide to reproducing the issue you''re reporting. Try to be as descriptive as possible and include any and all steps that would be necessary to reproduce the issue for someone that has never experienced it.\n* Bad example: ''''The application just randomly crashes, and I have no idea when, where or why. It''s usually dark and I don''t know what I''m doing''''\n* Good example: \n# Open Application\n# Click "New document"\n# Type some text\n# Accidentally trip and hit the key combination CTRL+ALT+PAGEUP+F+S+L+G\n# Observe application crashing\n\n== Additional details ==\nDepending on the [[IssuetypeSceme|issue type scheme]], there might be additional fields available in the grey area below the main reporting area (known as the "additional fields area") where you can add less important, but still potentially useful information about the issue. If such fields are reportable and marked as "additional", they will show up here, instead of in the main reporting view.\n\n= Submitting an issue =\nWhen you''ve filled out the form and are ready to submit the issue, click the "''''''file issue''''''" button located in the green bar below the main reporting area. As soon as the issue has been saved, it will - based on the settings for that specific issue type - either reload the page with a new reporting form and a link to the submitted issue at the top, or redirect you to the issue you just reported.\n\n[[Category:Help]] [[Category:Help:Howto]]', NULL, 1, [[timestamp]], 0, 1, 9),
('LoginIntro', NULL, '= Welcome to The Bug Genie =\nPlease login below.<br>\nIf you have not already registered, please use the "Create an account" button to do so.\n', NULL, 1, [[timestamp]], 0, 1, 10),
('Category:Workflow', '', '', NULL, 1, [[timestamp]], 0, 1, 11),
('LoremIpsum', NULL, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed luctus, elit vel auctor tincidunt, magna orci elementum enim, eget luctus nisl enim et velit. Nullam sit amet est augue, ut tincidunt diam. Aliquam aliquam enim et turpis sagittis imperdiet. Donec in augue vitae quam facilisis malesuada a tempus orci. Quisque consectetur scelerisque sapien vel consectetur. Nam at congue magna. Aliquam commodo ornare nisi, vitae malesuada nunc congue in. Duis id est orci. Donec a ullamcorper tellus. Morbi non neque non augue aliquam porta. Sed posuere volutpat quam vitae dignissim. Nullam eu ipsum erat. Morbi nec arcu eget enim condimentum sollicitudin. Ut dui lectus, rhoncus et euismod et, feugiat eu nisi. Cras facilisis, nisl quis venenatis elementum, neque justo vehicula odio, id venenatis sapien neque vel nulla. In quis turpis non orci convallis pharetra. Aliquam erat volutpat.\n\nCras urna lectus, iaculis non venenatis vel, egestas quis est. Aliquam laoreet, neque nec bibendum dignissim, nulla felis hendrerit est, nec volutpat nisl lectus vitae enim. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Integer laoreet risus in massa sollicitudin quis vulputate nulla pretium. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Suspendisse semper, nunc consequat imperdiet convallis, quam tortor euismod mi, ac cursus sem neque sed elit. Vestibulum egestas tempor elit vel imperdiet. Donec lacinia, nulla et tempor facilisis, neque purus sollicitudin nunc, non venenatis leo eros sed ipsum. Cras lacus felis, auctor at euismod quis, vehicula vel est. Sed sit amet mauris ac felis imperdiet faucibus. Nam et euismod erat. Duis varius, dui in molestie dignissim, turpis nulla sollicitudin erat, in porta erat lacus ac eros. Phasellus consequat elementum pellentesque. Sed pharetra condimentum sagittis. Suspendisse metus leo, adipiscing nec congue id, interdum sit amet dui. Phasellus commodo ante ac augue imperdiet vitae volutpat nisl posuere. Integer vitae urna mi, et tincidunt orci. Nulla mattis ultrices dui vitae vestibulum. Donec felis tortor, lobortis vitae euismod in, laoreet quis augue.\n\nMaecenas a felis urna. Cras tincidunt ligula id nisi aliquam pretium. Mauris at nibh at arcu molestie scelerisque a a orci. Nam quam arcu, vulputate et tristique at, dapibus sit amet eros. Nam scelerisque massa posuere dui fermentum eu condimentum erat ultrices. Cras ante diam, mollis sed pretium imperdiet, pretium nec enim. Proin blandit justo tortor, eget sollicitudin magna. Donec rhoncus commodo nibh eget pulvinar. Nunc bibendum tristique arcu a dapibus. Maecenas ultricies consequat dolor et dignissim. Nulla nec velit in magna cursus rhoncus a vitae eros. Maecenas pretium nisl id risus facilisis sed dignissim quam tristique. Nunc consequat, elit ut consectetur blandit, dolor quam vehicula sem, non molestie ipsum nunc pellentesque ipsum. Aliquam erat volutpat. Donec ante massa, bibendum at dapibus a, facilisis nec metus. Nunc tristique sodales erat. Sed laoreet orci sed odio molestie quis varius magna rhoncus.\n\nDonec laoreet luctus lacus dictum commodo. Donec dignissim auctor varius. Nulla nunc metus, egestas sit amet vestibulum sed, fermentum nec ante. Ut in ultrices libero. Donec tortor velit, suscipit a tempor eu, auctor accumsan elit. Donec sed nisl enim. Morbi sagittis interdum quam in lacinia. In fermentum luctus turpis vitae vulputate. Nulla tincidunt semper neque, ut tincidunt nibh tincidunt sed. Maecenas tellus dui, bibendum sed convallis id, varius et mi. Nulla facilisi. Nulla semper, leo non tristique volutpat, ipsum arcu vestibulum enim, bibendum mattis urna nulla vel dolor. Cras nibh lorem, ullamcorper vitae ultricies eu, consequat sed est.\n\nVestibulum varius tempor nisi sed tempor. In suscipit luctus tellus porttitor sollicitudin. Sed in arcu turpis. Donec eu neque non est commodo porttitor. Aliquam erat volutpat. Donec varius, sem nec rutrum commodo, ipsum est sollicitudin dui, sed tempus purus est in felis. Aliquam sodales, velit vitae accumsan molestie, nulla lectus lobortis erat, vehicula ultrices dolor ipsum nec ipsum. Nunc sed turpis sed magna rhoncus lobortis ut ac lectus. Nunc a felis a eros condimentum fringilla. Donec ultrices aliquet leo, ac venenatis quam pharetra at. Pellentesque sodales condimentum felis a porta. Integer justo elit, ullamcorper eget vulputate ut, tincidunt non velit. Donec at urna mi, eget ultricies metus. Duis feugiat pulvinar metus, nec laoreet sem pharetra at. Maecenas quis mi sed lorem euismod convallis eget non quam. Sed vestibulum porttitor arcu, et rutrum est cursus vel. Fusce posuere pellentesque arcu vitae ullamcorper. Nulla facilisis hendrerit ligula, tempus condimentum eros imperdiet et. ', NULL, 1, [[timestamp]], 0, 1, 12),
('Workflow', NULL, '{{TOC}}\n= Introduction =\nA workflow is reprecented by [[WorkflowSteps|steps]] and [[WorkflowTransitions|transitions]] that an issue progresses through, thereby defining an issue lifecycle. Steps and transitions can further be customized with validation, conditional access and permission based access to fields to create a setup perfectly tailored to an individual company workflow.\n\nThis defined lifecycle usually represents an internal company setup, or reflects a companys team-based structure, and is usually also anchored in a company or teams development and QA guidelines.\n\nThe Bug Genie comes with a default workflow called [[DefaultWorkflow|"Default workflow"]]. This workflow cannot be edited or removed, and is used as a fallback workflow or when a project doesn''t have a workflow configured. The editing tools for workflow will of course let you copy this default workflow or create a new one to make your own, and everything in other workflows than the builting one can be customized.\n[[Category:TheBugGenie:Workflow]]', NULL, 1, [[timestamp]], 0, 1, 13),
('WorkflowSteps', NULL, '== Workflow step explained ==\nA workflow consists of several steps, together defining the possible states an issue can be in during the issue lifecycle. A step is linked to the following three separate properties of an issue:\n* Whether the issue is editable\n* Whether the issue is closed\n* (optionally) The issue status ("Fixed", "In progress", "Testing", etc)\n\n== Changing issue workflow step ==\nAn issue can only enter a new step via a [[WorkflowTransition|transition]] (either instantly or via a [[WorkflowTransitionView|transition view]]), which often defines other properties that needs to be set in order for the issue to progress to the defined step. For the issue to progress, a transition from the current step to any other step in the workflow needs to be defined in the workflow itself.\n\nAn example of this is such as when an issue is in the initial step (often linked with the status "New"), a transition can take it to the "Confirmed" step (often linked with the corresponding "Confirmed" status). During this transition, a user or developer may be asked to provide additional details to validate the transition. How transitions work are explained in more detail in the [[WorkflowTransitions|transitions]] documentation.\n\nThe workflow step is not visible anywhere on the issue - the way to tell it is usually to look at its state (open / closed) and the issues status field. This will give you an overview of the issues current position in the defined workflow.\n\n== Step actions ==\nA step does not have any specific actions associated with it. Because a step is a "state", not the transition between states, the step definition is limited to the three properties mentioned above, and does not include actions.\n\n== Defining a workflow step ==\nIf you''re using a non-default workflow, new steps can be added from the workflow configuration page. This page lists all steps in the specified workflow, and lets you edit the step and/or add outgoing [[WorkflowTransitions|transitions]] to it, leading to another step.', NULL, 1, [[timestamp]], 0, 1, 14),
('CamelCasing', NULL, '''''''!CamelCase'''''' (also spelled "camel case") or ''''medial capitals'''' is the practice of writing compound words or phrases in which the elements are joined without spaces, with each element''s initial letter capitalized within the compound, and the first letter can be upper or lower case — as in !LaBelle, !BackColor, !MacGyver, or iPod.\n\nThe name comes from the uppercase "bumps" in the middle of the compound word, suggestive of the humps of a camel.\n\nThe practice is also known by many other names, such as ''''''!BumpCaps'''''', ''''''!BeefCaps'''''', ''''''!CapWords'''''' and ''''''!WikiWords''''''.\n\n''''''This is a short introduction to the subject, based on the [[Wikipedia:CamelCase|Wikipedia article]] about camel case.\n[[Category:Help]]', NULL, 1, [[timestamp]], 0, 1, 15),
('CSVImport', NULL, '= Importing data from CSV files =\n\nYou can import data to The Bug Genie from a CSV file, pasted into the Import screen. Currently you can only import projects, issues and clients. This document explains how to use the Import feature.\n\nData must be provided in comma-separated format, with the first row containing column names (which have restrictions - see below). Column values should be enclosed in speech marks if appropriate - The Bug Genie will handle these correctly. In addition, The Bug Genie also performs a number of validation steps to ensure the data is valid, also explained below.\n\nWhen the tables mention the ''column name'', this is what should be in the first row to indicate the column. Some columns are required, some are optional, however if you specify a column in the header row it must be included in every subsequent row. Likewise, you can not specify data in subsequent rows which does not have a matching column marked in the header row.\n\n== Importing projects ==\n\n{|\n! Column name !! Required !! Contains !! Other details\n|-\n| name || Yes || Project name || none\n|-\n| prefix || No || Prefix for project issue numbers || By specifying a prefix, the project will automatically use the prefix\n|-\n| scrum || No || Should scrum (Agile) development be used || 1 for yes, 0 for no\n|-\n| owner || No (yes if owner_type specified) || User or Team ID for project owner || none\n|-\n| owner_type || No (yes if owner specified) || Type identifier for owner || 1 for user, 2 for team\n|-\n| lead || No (yes if lead_type specified) || User or Team ID for project leader || none\n|-\n| lead_type || No (yes if lead specified) || Type identifier for leader || 1 for user, 2 for team\n|-\n| qa || No (yes if qa_type specified) || User or Team ID for project''s QA responsible || none\n|-\n| qa_type || No (yes if qa specified) || Type identifier for QA responsible || 1 for user, 2 for team\n|-\n| descr || No || Description || none\n|-\n| doc_url || No || URL for documentation website || none\n|-\n| wiki_url || No || URL for wiki website || none\n|-\n| freelance || No || Can users edit issue properties without working on the issue || 1 for yes, 0 for no\n|-\n| en_builds || No || Are builds enabled || 1 for yes, 0 for no\n|-\n| en_comps || No || Are components enabled || 1 for yes, 0 for no\n|-\n| en_editions || No || Are editions enabled || 1 for yes, 0 for no\n|-\n| workflow_id || No || ID number of workflow scheme || none\n|-\n| client || No || ID number of client || none\n|-\n| show_summary || No || Should a summary be shown on the frontpage || 1 for yes, 0 for no\n|-\n| summary_type || No || What to show on the frontpage || Either issuetypes or milestones\n|-\n| issuetype_scheme || No || ID number of issuetype scheme || none\n|-\n| allow_reporting || No || Set whether new issues can be reported against this project || 1 for yes, 0 for no\n|-\n| autoassign || No || Set whether to automatically assign issues based on the leader for projects, editions and components || 1 for yes, 0 for no\n|}\n\n== Importing clients ==\n\n{|\n! Column name  !! Required !! Contains !! Other details\n|-\n| name || Yes || Client name || none\n|-\n| email || No || Email address || none\n|-\n| telephone || No || Telephone number || none\n|-\n| fax || No || Fax number || none\n|-\n| website || No || Website address || none\n|}\n\n== Importing issues ==\n\n{|\n! Column name !! Required !! Contains !! Other details\n|-\n| title || Yes || Issue title || none\n|-\n| project || Yes || Project ID || none\n|-\n| descr || No || Issue description || none\n|-\n| repro || No || Reproduction steps || none\n|-\n| state || No || Type identifier for owner || 1 for closed, 0 for open\n|-\n| status || No || ID for status value || none\n|-\n| posted_by || No || User ID (NOT team) for issue poster || If not specified, importing user will be set\n|-\n| owner || No (yes if owner_type specified) || User or Team ID for issue owner || none\n|-\n| owner_type || No (yes if owner specified) || Type identifier for owner || 1 for user, 2 for team\n|-\n| assigned || No (yes if assigned_type specified) || User or Team ID for issue assignee || none\n|-\n| assigned_type || No (yes if assigned specified) || Type identifier for assignee || 1 for user, 2 for team\n|-\n| resolution || No || ID of resolution value || none\n|-\n| issue_type || Yes || ID of issue type || none\n|-\n| priority || No || ID of priority value || none\n|-\n| category || No || ID of category value || none\n|-\n| severity || No || ID of severity value || none\n|-\n| reproducability || No || ID of reproducability value || none\n|-\n| votes || No || Number of votes || none\n|-\n| percentage || No || How much of the issue is complete || 0 to 100 inclusive\n|-\n| blocking || No || Does the issue block the next release || 1 for yes, 0 for no\n|-\n| milestone || No || ID number of milestone || none\n|}\n\n[[Category:Help]]\n', NULL, 1, [[timestamp]], 0, 1, 16),
('GettingStarted', NULL, '= Getting started with The Bug Genie =\n{{TOC}}\n== Name, slogan and other settings ==\nYou might want to set the name and slogan, or change some of the other default settings. You can do this from [[TBG:configure_settings|Configure -> Settings]], where you have all the main settings available.\n\n== Your first project ==\nThe first thing you want to do is set up your project. Although The Bug Genie can be used without any projects, it''s mainly an issue tracker, and that''s where it excels.\n\nTo add a project, log in as an admin, and either click the little configuration icon next to the project list on the frontpage, or click [[TBG:configure_projects|Configure -> projects]]. This will take you to the projects list. To create a project from here, simply enter the project name in the text box and click "Add" or press Enter.\n\nThe Bug Genie is now ready to be used for issue reporting with your new project. However, you might want to set up more information about the project. Click the "Edit project" link on the project and change any settings in here. From that page you can also add a project description, release date and more information about your project. This is also where you set up editions, components, releases, milestones, and more.\n\n=== Permissions ===\nYour project will initially only be available to the user group that created the project. If you created the project as the administrator user, the project will initially be available only to the "Administrator" group. You can change this by clicking the "more details" link when you create the project. You can also change project permissions for other user groups by going to [[TBG:configure_permissions|Configure -> Permissions]]. Select the "Project specific permissions" tab, and click the project name. From here you can set permissions for all groups and teams in the system. \n\nTo allow easy bug reporting if the global security setting is set to "Restrictive", enable the following permission groups:\n* Can access project\n* Can access all project pages\n* Can create issues, edit basic information on issues reported by the user and close/re-open them\n\nTo do this, click the permission group text, and then click the icons for either global access, group-specific- or team-specific access.\n\n''''For smaller teams, consider setting the global security setting to "Permissive". This can be done from [[TBG:configure_settings|Configure -> settings]] under the "Users & security" tab.''''\n\n\n=== Project team ===\nSomeone is usually working on your project. You should add developers working on The Bug Genie to your project. (This of course requires that your developers have user accounts). Click the "Edit project" icon on your project, and then open up the ''''''Related users'''''' tab. Add developers, project managers, testers and documentors from this page. By adding developers to projects, you ensure that they get access to project specific features such as project information on their dashboard, issue notifications, and they also appear on the projects'' team page.\n\n=== Editions, components & releases ===\n==== Releases ====\nIf your project publishes regular test releases / builds, you should enable releases. This lets you add a specific build / release name / id to an issue so that you can target the issues progress through a set of releases. When this setting is enabled you can also add a release to your issue when you report it, and even make it mandatory during the report process for any given issue type.\n\n==== Components ====\nOften a project is made up of several very specific pieces of code or functionality. Such components can be "search", "wiki", "admin interface", etc. and is up to you to decide. Similar to above (releases), an issue can also target a specific component. You can also notify certain developers or teams when a new issue for a certain component has been reported by adding them to the specific component on the project "Related users" configuration page.\n\n==== Editions ====\nIn some cases your project may also be made up of several different editions. Editions are mainly defined by their included components, and one edition usually includes a different feature set from another edition. You may also want to use editions for version tracking, and set up editions between major versions, such as "MYPROJECT version 1", "MYPROJECT version 2", and so on.\n\n== Reporting issues ==\nYou can report issues for any projects registered in the bug genie by clicking the "Report an issue" tab in the top menu bar, or the green "Report an issue" button which is shown in the project menu bar. If you''re not in any project (such as in the global wiki, your user account settings, dashboard, etc), the report issue form will let you choose a project to report an issue for. Otherwise, the issue will be reported for the currently selected issue.\n\n=== Customizing issue types ===\nThe Bug Genie comes with a predefined set of issue types available out of the box. These can be customized to show different fields during issue reporting and in the issue overview page. You can do this from [[TBG:configure_issuetypes|Configure -> issue types]], where you can also add new issue types. Keep in mind that The Bug Genie uses the information in these issue types to include them in areas of the system where they would be relevant, such as showing any custom "bug report" issue types in bug report statistics, etc - use this to your advantage!\n\n=== Adding custom fields ===\nIf the standard issue fields aren''t enough for your needs, you can add custom ones from [[TBG:configure_issuefields|Configure -> issue fields]]. These fields are treated just as other issue fields in the system, and are available for searches and issue type customization. There are several types of custom fields to choose from, such as radio buttons, input areas, list of users, secondary status fields, dates, and more.\n\n[[Category:Help]][[Category:Help:Howto]]', NULL, 1, [[timestamp]], 0, 1, 17),
('RegistrationIntro', NULL, '= Register a new account =\nTo register, please fill out the information below.<br>\n''''(Required information is marked with an asterisk)<strike></strike>''''', NULL, 1, [[timestamp]], 0, 1, 18),
('Configuration', NULL, '#REDIRECT [[Category:Help:Configuration]]', NULL, 1, [[timestamp]], 0, 1, 19),
('Category:Help:HowTo', NULL, '[[Category:Help]]', NULL, 1, [[timestamp]], 0, 1, 20),
('FrontpageLeftmenu', NULL, 'If you want to put something in this area, edit the FrontpageLeftmenu wiki article.', NULL, 1, [[timestamp]], 0, 1, 21),
('AboutIssuePrefixes', NULL, '== Prefixes explained ==\nA project can specify a prefix that will be used for all issues created against it. This prefix will then be used in issue numbers, links and descriptions. Because all issues in The Bug Genie are counted against specific projects (this means you can have an issue #1 for "Project 1" and an issue #1 for Project 2), prefixes can be an easy way to quickly distinguish between issues from different projects simply by looking at their issue number.\n\n== Example ==\nSay you have two projects, "Awesome product" and "Crappy product", and you want to use a prefix on issues created against "Crappy product" so you can easily find them in your list of issues. To do this, open up project configuration for "Crappy product" (either by clicking the "edit project" link on the frontpage, project dashboard or on the [[TBG:configure_projects|Configure projects]] page), and select "Yes" for "Enable prefix". Then - in the box below - specify a prefix that will be used (e.g. "CRAP").\n\nNow all issues for this project uses the prefix specified. Issue #1 will be called "CRAP-1", issue #2 "CRAP-2", etc. This is also backwards-compatible, so you can change it any time you want, and it will be valid for all your issues in that project.', NULL, 1, [[timestamp]], 0, 1, 22),
('WorkflowTransitionView', NULL, '== Introduction ==\nThe workflow transition view is a popup presented to the user / developer so he or she can specify additional properties to be applied to the issue during its transition to the outgoing transition step. This popup can have items such as choosing whether time spent on the issue should be automatically logged, what resolution to pick for an issue, and more.\n\n== Properties ==\nThe list of properties shown in the transition view is defined by the post-transition actions specified on the transition. For example, if the transition doesn''t specify that it will set the resolution to the resolution given by the user, no dropdown for selecting a resolution will be shown. Also, if the resolution field isn''t defined as visible for that project / issue type combination, a message will be displayed to the user, so he/she can choose not to specify that particular field.\n\n== Instant transitions ==\nA transition doesn''t have to specify a view for when it is being applied to an issue. A transition without an associated transition view will be applied instantly.', NULL, 1, [[timestamp]], 0, 1, 23);
INSERT INTO `[[dbprefix]]articlehistory` VALUES
('WikiFormatting', NULL, '{{TOC}}\nThe Bug Genie uses a formatting technique called "Wiki formatting", most commonly known from Wikipedia (!MediaWiki).\nThe Bug Genie wiki tries to stay as close to the !MediaWiki syntax as possible, so if you''re familiar with that syntax you should feel right at home.\n\nWiki formatting is well explained in the [http://en.wikipedia.org/wiki/Help:Wikitext_examples Wikipedia help article], but can be easily summarized as a simple method of formatting your text by placing certain characters.\nWe will show you the most common syntax below.\n\n== Line breaks and text formatting ==\nYou can use line breaks to space out the text and make it more readable in the editor. One line break will not be transformed into a line break when the page is \ndisplayed. A blank line makes a new paragraph. You can put <br> to make a hard line break, but be careful with this as it might break layout.\n  This text is easy to\n  read because it is\n  split into several lines\n  but it will only show up as one line on the page\nThis text is easy to\nread because it is\nsplit into several lines\nbut it will only show up as one line on the page\n\nText can be formatted by putting ''-characters around the text you want to format. Here are some examples:\n\n  ''''this is some italic text''''\n''''this is some italic text''''\n  ''''''this is some bold text''''''\n''''''this is some bold text''''''\n  ''''''''''this is some bold and italic text''''''''''\n''''''''''this is some bold and italic text''''''''''\n\nYou can also use simple html formatting for things like underlined and strikethrough:\n\n  <strike>strikethrough</strike>\n<strike>strikethrough</strike>\n  <u>underlined</u>\n<u>underlined</u>\n\n== Headings ==\nTo specify headings, use equals-character around the line you want to be a heading. The number of equals-characters you put around the line decides how big the heading is (1 is biggest, 6 is lowest).\n  = I''m a big header =\n  == I''m a fairly big header ==\n  ===== I''m a very small header =====\nHeadings will automatically appear in the table of contents (if you have one).\n\n== Creating links between documents ==\nTraditionally, wikis have used something called [[WIKIPEDIA:CamelCase|Camel Casing]] to create links between documents. CamelCasing means that you put any word or combination of words as a "''''''camel cased''''''" word, and then the wiki will create a link to the document with that name for you automatically. If the page you are trying to link to isn''t yet created, the link will still be displayed, and you can click it to start editing the new article.\n\nIf you want to write a word with more than one capital letter, use an exclamation mark infront of it - that will stop it from being turned into a link automatically. The support for "camel casing" can be turned off in the wiki settings.\n\nYou can also use the double square bracket link format to link to internal pages, if you don''t want to use the CamelCasing style:\n  [[InternalPage]]\n[[InternalPage]]\n  [[Myproject:MainPage|Myproject wiki frontpage]]\n[[Myproject:MainPage|Myproject wiki frontpage]]\n\nWith this method you can also link to internal pages in The Bug Genie, by either specifying the relative url (like "/configure" points to the configuration page and "/wiki" points to the wiki), or use the internal route namespace "TBG:" (this has the added benefit of being safe if the link ever changes in a future release).\nUnfortunately, the list of routes used in The Bug Genie is quite long, but a few examples are listed below:\n\n  [[/about|About The Bug Genie]]\n[[/about|About The Bug Genie]]\n  [[/logout|Log out]]\n[[/logout|Log out]]\n  [[TBG:configure_projects|Configure projects]]\n[[TBG:configure_projects|Configure projects]]\n  [[TBG:configure_modules|Modules configuration]]\n[[TBG:configure_modules|Modules configuration]]\n\nThe Bug Genie wiki also lets you link directly to [http://www.wikipedia.org Wikipedia] articles by using the WIKIPEDIA namespace:\n\n  [[WIKIPEDIA:CamelCase]]\n[[WIKIPEDIA:CamelCase]]\n  [[WIKIPEDIA:CamelCase|Wikipedia article]]\n[[WIKIPEDIA:CamelCase|Wikipedia article]]\n\n''''''Remember - if all this sound complicated, you can always just use CamelCasing (provided it''s not disabled)''''''\n\n== Links ==\nIn addition to linking between internal pages with double square brackets, you can link to external pages with single square brackets. Any URLs inside your text will also automatically be turned into clickable links, but you can also put a pair of square brackets around the link to make it clickable. In addition, you can add a title if you want to:\n\n  https://thebuggenie.com\nhttps://thebuggenie.com\n  [https://thebuggenie.com]\n[https://thebuggenie.com]\n  [https://thebuggenie.com The Bug Genie website]\n[https://thebuggenie.com The Bug Genie website]\n\n== Horizontal line ==\nIf you want to put a horizontal line in the document, use four dashes:\n\n  ----\n----\n\n= Advanced usage =\n\n== Tables ==\nYou can add tables to your wiki page by using the table layout for defining rows, columns and headers. An example table (without headers) looks like this:\n  {|\n  |-\n  | Column 1 || Column 2 || Column 3\n  |}\n{|\n|-\n| Column 1 || Column 2 || Column 3\n|}\n\nAn example table ''''''with headers'''''' looks like this:\n  {|\n  ! Header 1 !! Header 2 !! Header 3\n  |-\n  | Column 1 || Column 2 || Column 3\n  |}\n{|\n! Header 1 !! Header 2 !! Header 3\n|-\n| Column 1 || Column 2 || Column 3\n|}\n\nA table must start with a table opener, and end with a table closer:\n\n''''''Table opener:''''''\n  {|\n''''''Table closer:''''''\n  |}\n\nIf you want to add header columns to your table, use the header row formatting, which is similar to the "normal" column formatting, but with an exclamation mark separator character:\n  ! Header 1 !! Header 2 !! Header 3\n\nEvery new row starts with a row indicator, which looks like this:\n  |-\n\nThe first column in a row starts with a single or double pipe character, and every new column is separated with a double pipe separator. These are both valid columns:\n  | Column 1 || Column 2 || Column 3\nand:\n  || Column 1 || Column 2 || Column 3\n\n\n== Categories ==\nYour article can be in none, one or more categories. You specify which category your article is in by using the Category namespace link:\n  [[Category:Mycategory]]\n\nThis won''t show up on the page, and you usually place this at the very end of your wiki page when you edit it. Categories will show up in the "Categories" area at the bottom of the article.\n\nIf you want to link to a Category, instead of put your article ''''''in'''''' a category, put a colon in front of the word "Category":\n  [[:Category:Mycategory]]\n[[:Category:Mycategory]]\n\nA category can have one or more ''''subcategories''''. You put one category in another category by putting the Category link shown above ''''inside the subcategory article''''.\n\n''''''Ex:'''''' after having created the page [[:Category:Actors]], create the page [[:Category:MaleActors]], and at the bottom of that article, put:\n  [[Category:Actors]]\nThis will make [[:Category:MaleActors]] a subcategory of [[:Category:Actors]]. That means [[:Category:MaleActors]] will show up in the "Subcategories" list on the [[:Category:Actors]] page.\n\nBefore you can see the content of a category - its subcategories or pages in that category, the category must be created. To create a category, put an article in a category, click the category link at the bottom of the article, and create the page.\nA category page is in essence just any other wiki article, but with the list of subcategories (if any) and pages in that category.\n\n== Redirecting from one page to another ==\nIf you want to make one page redirect directly to another page, use the ''''#REDIRECT'''' keyword, followed by the article to redirect to, like this:\n #REDIRECT [[PageToRedirectTo]]\n\nThe ''''#REDIRECT'''' must be the first thing on the first line, and must be followed by a space and the article name in the format specified above. This will not work:\n This is some content\n #REDIRECT [[AnotherPage]]\n\nNeither will this:\n  #REDIRECT [[AnotherPage]]\n(notice the space in front of ''''#REDIRECT'''')\n\n\n== Images ==\nYou can show uploaded images by using the same notation as for links, using the Image namespace:\n [[Image:image1.png]]\n\nThe Image: namespaced link accepts several parameters, separated by a pipe (|), and the right-most parameter is always the description. This means that if you want to specify any parameters, you must always put a description as the last parameter:\n [[Image:image1.png|Description here]]\n [[Image:image1.png|thumb|Description here]]\n\nImages are shown full-size by default, but you usually probably want to show a thumbnail of the image instead. To do this, use the "thumb" parameter:\n [[Image:image1.png|thumb|Image description]]\n\nImages float right by default, but this can also be specified as a parameter, by specifying "left" as a parameter on the Image tag:\n [[Image:image1.png|This image floats right]]\n [[Image:image1.png|right|This image also floats right]]\n [[Image:image1.png|left|This image floats left]]\n\n== Completely unparsed text ==\nIf you have some text that you don''t want to be automatically parsed at all, put them inside <nowiki></nowiki> tags:\n  <nowiki><nowiki>some text that shouldn''t be parsed [[a|link]] and ''''''bold text''''''</nowiki></nowiki>\n<nowiki>some text that shouldn''t be parsed [[a|link]] and ''''''bold text''''''</nowiki>\n\n== Lists ==\nTo create a list, use the star character for a bulleted list, hash character for a numbered (ordered) list, or a combination:\n\n  * One bullet\n  * Another ''''''bullet''''''\n  *# a list item\n  *# another list item\n  *#* unordered, ordered, unordered\n  *#* again\n  *# back down one\n* One bullet\n* Another ''''''bullet''''''\n*# a list item\n*# another list item\n*#* unordered, ordered, unordered\n*#* again\n*# back down one\n\n\n== Variables ==\nThere are some shortcuts available for outputting special data such as the current date, hour, day, etc. By putting special keywords enclosed with two { and }-characters on each side, The Bug Genie will automatically translate this for you.\n\n''''''Here are some examples'''''':\n  {{CURRENTMONTH}}\n{{CURRENTMONTH}}\n  {{CURRENTDAY}}\n{{CURRENTDAY}}\n  {{SITENAME}}\n{{SITENAME}}\n\nThe following keywords are available for automatic substitution: CURRENTMONTH, CURRENTMONTHNAMEGEN, CURRENTMONTHNAME, CURRENTDAY, CURRENTDAYNAME, CURRENTYEAR, CURRENTTIME, NUMBEROFARTICLES, PAGENAME, NAMESPACE, SITENAME, SITETAGLINE.\n\n== Table of contents ==\nYou can get a table of content on your page (like the one in the top right on this page) by using the TOC variable the same way as the "normal" variables above. It doesn''t matter where you put this variable in your document, it will always be displayed in the top right corner.\n\n== Linking to issues ==\nIf you want to link to an issue, use one of the following keywords: ''''''bug'''''', ''''''issue'''''', ''''''ticket'''''', ''''''story'''''', followed by the issue number:\n  ticket #123\nticket [http://sample.com/product/issue/123 #123 - title from ticket here]\n  bug #200\nbug [http://sample.com/product/issue/200 #200 - serious bug]\n  issue TBG-24\nissue <strike>[http://sample.com/product/issue/TBG-24 TBG-24 - issue title]</strike>\n\nThe links will automatically include things such as the title, and a strikethrough if the issue is closed.\n\n== Examples / comments ==\nIf you want to put some text on the page that shouldn''t be interpreted (like the examples above), put two spaces in front of each line.\n    I''m an example because I have two spaces in front of me (actually I have four, but that''s just so you can see the two spaces)\n    This is a second line\n\n== Syntax highlighting ==\n\nIf you have a code sample you want to place on a page, you can use syntax highlighting to place line numbers, and color the code depending on what language it is.\n\nTo do this, surround your code in <nowiki><source></source></nowiki> tags. By default this will use the default language and line numbering settings set by the administrator. You can also override these parameters to match your code settings.\n\n=== Code language ===\n\nTo set the language of the code, simply specify it as a property of the source tag, such as <nowiki><source lang="php">echo(''hi'');</source></nowiki>. If you specify an language that does not exist then no colors will be applied, but there are over 130 language definitions available so chances are you will find the right one. A few of the odd ones are ''''''html4strict'''''' for HTML code, and ''''''dos'''''' for a DOS batch file.\n\n=== Line numbering ===\n\nThree parameters are available to set the line numbering. The first of these is called ''''''line'''''', and it sets the style of numbering that is performed. The following styles are available:\n* ''''''GESHI_FANCY_LINE_NUMBERS'''''' or ''''''highlighted'''''' - Line numbering with a highlighted row at a regular interval (this interval is configurable)\n* ''''''GESHI_NORMAL_LINE_NUMBERS'''''' or ''''''normal'''''' - Normal line numbers with no highlighting\n* ''''''Anything else'''''' - No numbers\nYou can also specify the number at which the numbers count from. This is useful if you have taken a snippet from line 1000 in a file, and you want to make the snippet show this so that its easier to match the two up. To do this, the parameter is ''''''line start="''''number''''"'''''' (there is a space between line and start), and it will start counting from ''''number''''.\n\nFinally, if you choose ''''''GESHI_FANCY_LINE_NUMBERS'''''' or ''''''highlighted'''''', every ''''n''''th row is highlighted. To set a value for ''''n'''', you use the highlight property. For example if you set it to 10, then every 10th row will be highlighted.\n\nBelow is an example of all of the properties in use.\n\n<nowiki>\n<source lang="php" line="highlighted" line start="54" highlight="3">\n<?php\nfunction do_something($stuff) {\necho($stuff);\n$mythings = array();\n$mythings[] = $stuff;\n}\n?>\n</source>\n</nowiki>\n\n<source lang="php" line="highlighted" line start="54" highlight="3">\n<?php\nfunction do_something($stuff) {\necho($stuff);\n$mythings = array();\n$mythings[] = $stuff;\n}\n?>\n</source>\n\n[[Category:Help]][[Category:Help:Howto]]', NULL, 1, [[timestamp]], 0, 1, 24),
('WorkflowDefault', NULL, '= Overview =\nThe default workflow is used for issue types that does not have a workflow set in the workflow scheme associated with the current project. The default workflow is also used in the default workflow scheme setup.<br>\nThis is an overview of the default workflow setup with its steps and transitions:\n\n{|\n! Step !! Connected status !! State !! Outgoing transitions !! Notes\n|-\n| ''''''New'''''' || ''''New'''' || Open and editable || Investigate issue → Investigating<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress<br>Resolve issue → Closed || This is the default, initial step all issues start in\n|-\n| ''''''Investigating'''''' || ''''Investigating'''' || Open and editable || Request more information → New<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress || \n|-\n| ''''''Confirmed'''''' || ''''Confirmed'''' || Open but not editable || Accept issue → In progress <br>Assign issue → In progress <br>Resolve issue → Closed || \n|-\n| ''''''In progress'''''' || ''''Being worked on'''' || Open but not editable || Reject issue → Rejected <br>Mark ready for testing → Ready for testing <br>Resolve issue → Closed || \n|-\n| ''''''Ready for testing'''''' || ''''Ready for testing / QA'''' || Open but not editable || Resolve issue → Closed <br>Test issue solution → Testing || \n|-\n| ''''''Testing'''''' || ''''Testing / QA'''' || Open but not editable || Accept issue solution → Closed <br>Reject issue solution → In progress || \n|-\n| ''''''Rejected'''''' || ''''Not a bug'''' || Closed and not editable || Reopen issue → New || \n|-\n| ''''''Closed'''''' || - || Closed and not editable || Reopen issue → New || This workflow step is not linked directly to a status\n|}\n\nSome things to note about the default workflow:\n* It is not possible to directly move an issue from new to closed - it has to either be accepted or assigned first. You can however move it directly to rejected if it is invalid or duplicate\n* The ''''Closed'''' step is not linked to a status, but has two valid statuses - ''''''Closed'''''' and ''''''Postponed''''''', NULL, 1, [[timestamp]], 0, 1, 25),
('WorkflowTransition', NULL, '== Workflow transitions explained ==\nA transition is when an issue moves from one step to another in the workflow associated with that project/issue type combination. The workflow transition is what triggers email notifications, changes status, resolution, issue state, and more. Without a transition happening, changes to an issue state will not be consistent with the data associated with that workflow step. The transition being performed is essential for the workflow to function properly.\n\n== Transition details ==\nWhen a transition is defined, it can have pre-/post-validators, and post-transition actions associated with it.\n\n=== Pre-validators ===\nA pre-validator is a set of rules that must apply to an issue for the transition to be available. For example, you can set a "maximum number of assigned issues", which means that for that transition to be available to the developer, he can not have more than the specified number of issues assigned. These pre-validation rules are shown in the workflow configuration view after selecting a transaction.\n\n=== Post-validators ===\nThe post-validators validates input from the user, and makes sure it passes a valid set of allowed values. For example (in the default workflow), issues that are moving from the "In progress" step to the "Resolved" step will have to have the status set to one of the following: "Done", "Fixed" or "Closed". These validation rules are also integrated with the transition view, so it is not possible to modify the issue property to a value that is not allowed in the transitions'' post-validation rule set.\n\n=== Post-transition actions ===\nA post-transition action is an action that defines what will be done with the issue after the transaction validation is complete. This can be everything from applying a user-specified priority/resolution, to marking an issue as being worked on by a user (for automated time tracking), changing the percent complete field (to give a good visual indicator of how complete an issue is) or changing the user assigned to an issue. Post-transition actions occur at the very end of the transition, right before the issues step is changed to the outgoing step of the transition.\n\n=== Pre- vs. post-validators ===\nThere is a fundamental difference between pre- and post-validators. Whereas the post-validators validate user input, such as a status provided in the [[WorkflowTransitionView|transition view]], the pre-validators is what decides whether the user will even be able to trigger the transition view or transition. A pre-validation rule keeps the transition from being ''''''available'''''' under certain conditions, whereas the post-validation rules keeps the issue from ''''''having its properties set to invalid values''''''.', NULL, 1, [[timestamp]], 0, 1, 26),
('OpenidIntro', NULL, '= Log in using an OpenID account =\nIf you have an account registered with any of the services listed below, press the associated button to log via that service', NULL, 1, [[timestamp]], 0, 1, 27),
('DefaultIssuetypeScheme', NULL, '{{TOC}}\n= Introduction =\nThe Default issuetype scheme is used for projects without a custom issue type scheme set, and defines a default set of visible / required properties on the [[CreatingIssues|Report an issue]] page, as well as on the "view issue" page.\n\n= Overview =\nThis is an overview of the required / visible properties per issue type. \n''''''Note:'''''' If a field has been set (either via a workflow transition, or otherwise), its value will be displayed regardless of its "visible" setting. Remember that the user must also have the permission to set the field in question, and there must be values available for the field to be populated.\n\n''''''Explanation:''''''\n* ''''Reportable'''': Whether the specified field is visible on the reporting page\n* ''''Required'''': Whether this field is required when reporting an issue\n* ''''Additional'''': Whether this is shown in the "additional fields" area, or in the main view when reporting an issue\n* ''''Visible'''': Whether this field is visible on the "view issue" page\n== Bug report ==\n* ''''''Redirects to the reported issue'''''': Yes\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || Yes\n|-\n| Description || Yes || Yes || - || Yes\n|-\n| Reproduction steps || Yes || Yes || - || Yes\n|-\n| Category || Yes || Yes || - || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || Yes || Yes || Yes || -\n|-\n| Priority || Yes || Yes || Yes || -\n|-\n| Severity || Yes || Yes || Yes || -\n|-\n| Estimated time to complete || Yes || Yes || Yes || -\n|-\n| Targetted for milestone || Yes || Yes || Yes || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || - || - || - || -\n|-\n| Affected edition(s) || Yes || Yes || - || -\n|-\n| Affected release(s) || Yes || Yes || - || -\n|-\n| Affected component(s) || Yes || Yes || - || -\n|-\n| Time spent working on the issue || Yes || - || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || - || - || - || -\n|}\n== Feature request, Enhancement & Idea ==\n* ''''''Redirects to the reported issue'''''': Yes\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || Yes\n|-\n| Description || Yes || Yes || - || Yes\n|-\n| Reproduction steps || - || - || - || -\n|-\n| Category || Yes || Yes || Yes || -\n|-\n| Reproducability || - || - || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || - || - || - || -\n|-\n| Priority || Yes || Yes || Yes || -\n|-\n| Severity || - || - || - || -\n|-\n| Estimated time to complete || Yes || Yes || Yes || -\n|-\n| Targetted for milestone || Yes || Yes || Yes || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || Yes || Yes || Yes || -\n|-\n| Affected edition(s) || - || - || - || -\n|-\n| Affected release(s) || - || - || - || -\n|-\n| Affected component(s) || - || - || - || -\n|-\n| Time spent working on the issue || Yes || - || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || Yes || - || - || -\n|}\n== Task ==\n* ''''''Redirects to the reported issue'''''': No, loads a new & empty reporting form with a link to the saved issue at the top\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || -\n|-\n| Description || Yes || Yes || - || Yes\n|-\n| Reproduction steps || - || - || - || -\n|-\n| Category || Yes || Yes || Yes || -\n|-\n| Reproducability || - || - || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || - || - || - || -\n|-\n| Priority || Yes || Yes || Yes || -\n|-\n| Severity || - || - || - || -\n|-\n| Estimated time to complete || Yes || Yes || Yes || -\n|-\n| Targetted for milestone || Yes || Yes || Yes || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || Yes || Yes || Yes || -\n|-\n| Affected edition(s) || - || - || - || -\n|-\n| Affected release(s) || - || - || - || -\n|-\n| Affected component(s) || - || - || - || -\n|-\n| Time spent working on the issue || Yes || - || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || Yes || - || - || -\n|}\n== User story ==\n* ''''''Redirects to the reported issue'''''': No, loads a new & empty reporting form with a link to the saved issue at the top\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || -\n|-\n| Description || Yes || Yes || - || -\n|-\n| Reproduction steps || - || - || - || -\n|-\n| Category || Yes || Yes || - || -\n|-\n| Reproducability || - || - || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || - || - || - || -\n|-\n| Priority || Yes || Yes || - || -\n|-\n| Severity || - || - || - || -\n|-\n| Estimated time to complete || Yes || Yes || - || -\n|-\n| Targetted for milestone || Yes || Yes || - || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || Yes || Yes || - || -\n|-\n| Affected edition(s) || - || - || - || -\n|-\n| Affected release(s) || - || - || - || -\n|-\n| Affected component(s) || - || - || - || -\n|-\n| Time spent working on the issue || Yes || Yes || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || Yes || - || - || -\n|}', NULL, 1, [[timestamp]], 0, 1, 28);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articlelinks`
--

CREATE TABLE `[[dbprefix]]articlelinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `article_name` varchar(300) DEFAULT NULL,
  `link_article_name` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]articlelinks`
--

INSERT INTO `[[dbprefix]]articlelinks` VALUES
(1, 1, 'IssuetypeScheme', 'DefaultIssuetypeScheme'),
(2, 1, 'IssuetypeScheme', 'CustomFields'),
(3, 1, 'IssuetypeScheme', 'CreatingIssues'),
(4, 1, 'CreatingIssues', 'IssuetypeScheme'),
(5, 1, 'CreatingIssues', 'IssuetypeSceme'),
(6, 1, 'Workflow', 'WorkflowSteps'),
(7, 1, 'Workflow', 'WorkflowTransitions'),
(8, 1, 'Workflow', 'DefaultWorkflow'),
(9, 1, 'WorkflowSteps', 'WorkflowTransition'),
(10, 1, 'WorkflowSteps', 'WorkflowTransitionView'),
(11, 1, 'WorkflowSteps', 'WorkflowTransitions'),
(12, 1, 'FrontpageLeftmenu', 'FrontpageLeftmenu'),
(13, 1, 'WikiFormatting', 'CamelCasing'),
(14, 1, 'WikiFormatting', 'InternalPage'),
(15, 1, 'WikiFormatting', 'Myproject:MainPage'),
(16, 1, 'WikiFormatting', 'Category:Mycategory'),
(17, 1, 'WikiFormatting', 'Category:Actors'),
(18, 1, 'WikiFormatting', 'Category:MaleActors'),
(19, 1, 'WorkflowTransition', 'WorkflowTransitionView'),
(20, 1, 'OpenidIntro', 'OpenID'),
(21, 1, 'DefaultIssuetypeScheme', 'CreatingIssues');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles`
--

CREATE TABLE `[[dbprefix]]articles` (
  `author` int(10) DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `manual_name` varchar(200) DEFAULT NULL,
  `date` int(10) DEFAULT '0',
  `article_type` int(10) DEFAULT '0',
  `content` text,
  `content_syntax` int(3) DEFAULT '0',
  `is_published` tinyint(1) DEFAULT NULL,
  `parent_article_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- Dumping data for table `[[dbprefix]]articles`
--

INSERT INTO `[[dbprefix]]articles` VALUES
(0, 'Category:Help', 'Category:Help', [[timestamp]], 1, 'This is a list of all the available help articles in The Bug Genie. If you are stuck, look here for help.', 1, 0, 0, 1, 1),
(0, 'IssuetypeScheme', 'IssuetypeScheme', [[timestamp]], 1, '= Description =\nAn issue type scheme is the scheme that specifies - per issue type - which issue fields are:\n* available for reporting via the "main" reporting view\n* available for reporting via the "additional information" pane at the bottom\n* required for reporting\n* available on the "view issue" page\n\nAll issue types have their own settings for which fields are available / required on both the reporting page and on the issue overview page. These settings are deeply integrated in The Bug Genie, and always respected.\n\nOn the [[CreatingIssues|Report an issue]] page, fields will be displayed and marked as required based on the settings specified in the issue type scheme in use by the selected project. These settings are also used to determine which fields are displayed on the "View issue" page.\n\n= Custom fields =\nBecause the DefaultIssuetypeScheme is not editable, you have to create a copy of it and modify that copy to be able to display any CustomFields, as they would not be available by default. Which issuetype scheme a project uses is available in the project configuration popup.', 1, 0, 0, 1, 2),
(0, 'ForgottenPasswordIntro', 'ForgottenPasswordIntro', [[timestamp]], 1, '= Forgot your password? =\nIf you have forgotten your password, enter your username here and we will send you an email with instructions on how to change your password.', 1, 0, 0, 1, 3),
(0, 'Category:Help:Configuration', 'Category:Help:Configuration', [[timestamp]], 1, 'This is a list of all the available help articles on configuring The Bug Genie.\n\n[[Category:Help]]', 1, 0, 0, 1, 4),
(0, 'VCSIntegration', 'VCSIntegration', [[timestamp]], 1, '{{TOC}}\n= VCS Integration =\nThe Bug Genie includes the VCS Integration module, which allows you to link your projects in The Bug Genie to a source code repository. This allows your commits to update issues, as well as access the repository viewer from The Bug Genie. However, before you can start, you need to set up the module - both globally and for each project using the module.\n\nPlease note that the git hook does not support the web access method (explained later), only the direct access method. In addition, a Mercurial hook is available, though it is not included due to license restrictions. Please refer to The Bug Genie website to obtain it.\n\n= Setting up =\n=== Global settings ===\nThere are two methods for VCS hooks (the code that interfaces between your source code repository and The Bug Genie) to communicate with your installation. The methods are ''''''direct access'''''' and ''''''http access''''''.\n\n==== Direct access ====\nIn direct access, the repository exists on the same server as The Bug Genie, or the hook can use SSH or other associated systems to access the server that The Bug Genie is hosted on. Therefore the user that VCS hooks are executed as will need access to The Bug Genie''s files, as well as a PHP executable. You will also require the CLI version of PHP installed.\n\nIn each hook, you will need to enable direct mode, and set the path to PHP and The Bug Genie''s tbg_cli file. You will also need to set the project ID, which can be found on the VCS configuration page. Please refer to each hook''s documentation (it may be included in the hook file itself) to see how to do this.\n\nThen, in the VCS Integration general settings tab, on the Configuration page, choose ''''''Direct access'''''' and click Save. You can then set up your projects.\n\n==== HTTP access ====\nAnother option would be to use HTTP access, where the hook will use HTTP to access a page on your installation of The Bug Genie, which will cause the checkin to be recorded. Choose this option if you are not able to use the direct method. You will also need this method to interface The Bug Genie with github.\n\nYou will need to configure hooks to use this mode, as well as set the project ID and URL to access. Refer to hook documentation for doing this (this may be included in the hook itself). Please also set a secure passkey to prevent unauthorized commits. This will need to be the same for every VCS, and set in each hook.\n\nYou will then need to choose ''''''HTTP access'''''' on the VCS Integration general settings tab. In addition, you will need to enter the passkey you set earlier on this screen.\n\nAfter saving these settings, you can then set up each project.\n\n==== Github support ====\nIf you wish to use the github hook, please set up HTTP access as previously discussed. You will then need to set up your Github project''s post-receive hook to contact The Bug Genie.\n\nTo do this, go to your project''s service hooks page on github, and set a Post-recieve URL to point to the following URL:\n  http://www.your-tbg-site.com/vcs_integration/report/PROJECTID/github/?passkey=PASSKEY\nYou will need to set the hostname and path correctly as appropriate, as well as replacing PASSKEY with the passkey you set, and PROJECTID with the ID number of the project, which can be found on the projects tab of VCS Integration configuration.\n\nAny commits which follow the rules for being picked up (see below) will then be recorded against their respective issues on push, though commits which make no changes to the filesystem (i.e. nothing added, removed or modified) will not be recorded in this release of VCS Integration.\n\n==== Bitbucket support ====\nIf you wish to use the bitbucket hook, please set up HTTP access as previously discussed. You will then need to set up your Bitbucket project''s post-receive hook to contact The Bug Genie.\n\nTo do this, go to your project''s service hooks page on bitbucket, and set a POST URL to point to the following URL:\n  http://www.your-tbg-site.com/vcs_integration/report/PROJECTID/bitbucket/?passkey=PASSKEY\nYou will need to set the hostname and path correctly as appropriate, as well as replacing PASSKEY with the passkey you set, and PROJECTID with the ID number of the project, which can be found on the projects tab of VCS Integration configuration.\n\nAny commits which follow the rules for being picked up (see below) will then be recorded against their respective issues on push, though commits which make no changes to the filesystem (i.e. nothing added, removed or modified) will not be recorded in this release of VCS Integration.\n\n==== Gitorious support ====\nIf you have a locally hosted Gitorious server, then you can integrate that with The Bug Genie.\n\nAgain, set a post-receive hook as per your documentation, the URL for which is:\n  http://www.your-tbg-site.com/vcs_integration/report/PROJECTID/gitorious/?passkey=PASSKEY\n\nPlease note that the Gitorious support will only create comments and will not record filesystem changes, plus it will not work on the gitorious.com server.\n\n=== Project settings ===\nEach project to use VCS Integration will then require configuration. If a project will not be using VCS Integration, then you can leave its repository URL field empty.\n\nTo set up each project, you need to specify the repository browser you use. This will be used to build the right URLs to be displayed in The Bug Genie. In the ''''URL to repository browser'''' field, you enter the path to the root of the repository browser (i.e. this may be the page where a list of available repository browsers is shown). Finally you enter the repository name in the final box.\n\nAfter pressing save, a ''''''Source code'''''' link will be added to the project dashboard. You can use this link to test to see if the details are correct - if so this link will open the main page of the repository browser for your chosen project.\n\nAfter doing this, the module can be used by committing details as below, and they will show up in a new tab when viewing an issue, with links to view files, diffs, revision info and other details.\n\n= Using the module =\n\nWhen a commit is made which refers to an issue, then the issue will be updated with the commit log and details of every changed file. The Bug Genie will pick up any commits which contain any of the following words, followed by an issue number:\n  bug, issue, ticket, fix, fixes, fixed, fixing, applies to, closes\n  references, ref, addresses, re, see, according to, also see\n\nThe user assigned to the commit will depends on the user who committed it to the VCS. If you are using a VCS where your committer name is in the form "Joe Bloggs <jbloggs@example.com>", for example, then The Bug Genie will search for users with the email as provided.\n\nIf a user can not be found, or if there is no email, then The Bug Genie will take the name part (or username) and search against the Full Name field. Failing that, we then search against the friendly name and then finally the user name. If still no user can be found then no user will be recorded for the commit.\n\nLinks on the project dashboard to view the source code repository is added upon set up, and each commit will have a link to view the commit details, a log of commits, diffs and links to view files.\n[[Category:Help]]\n', 1, 0, 0, 1, 5),
(0, 'DefaultWorkflow', 'DefaultWorkflow', [[timestamp]], 1, '= Overview =\nThe default workflow is used for issue types that does not have a workflow set in the workflow scheme associated with the current project. The default workflow is also used in the default workflow scheme setup.<br>\nThis is an overview of the default workflow setup with its steps and transitions:\n\n{|\n! Step !! Connected status !! State !! Outgoing transitions !! Notes\n|-\n| ''''''New'''''' || ''''New'''' || Open and editable || Investigate issue → Investigating<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress<br>Resolve issue → Closed || This is the default, initial step all issues start in\n|-\n| ''''''Investigating'''''' || ''''Investigating'''' || Open and editable || Request more information → New<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress || \n|-\n| ''''''Confirmed'''''' || ''''Confirmed'''' || Open but not editable || Accept issue → In progress <br>Assign issue → In progress <br>Resolve issue → Closed || \n|-\n| ''''''In progress'''''' || ''''Being worked on'''' || Open but not editable || Reject issue → Rejected <br>Mark ready for testing → Ready for testing <br>Resolve issue → Closed || \n|-\n| ''''''Ready for testing'''''' || ''''Ready for testing / QA'''' || Open but not editable || Resolve issue → Closed <br>Test issue solution → Testing || \n|-\n| ''''''Testing'''''' || ''''Testing / QA'''' || Open but not editable || Accept issue solution → Closed <br>Reject issue solution → In progress || \n|-\n| ''''''Rejected'''''' || ''''Not a bug'''' || Closed and not editable || Reopen issue → New || \n|-\n| ''''''Closed'''''' || - || Closed and not editable || Reopen issue → New || This workflow step is not linked directly to a status\n|}\n\nSome things to note about the default workflow:\n* It is not possible to directly move an issue from new to closed - it has to either be accepted or assigned first. You can however move it directly to rejected if it is invalid or duplicate\n* The ''''Closed'''' step is not linked to a status, but has two valid statuses - ''''''Closed'''''' and ''''''Postponed''''''', 1, 0, 0, 1, 6),
(0, 'MainPage', 'MainPage', [[timestamp]], 1, 'This is the global wiki frontpage.', 1, 0, 0, 1, 7),
(0, 'ConfigurePermissions', 'ConfigurePermissions', [[timestamp]], 1, '= Setting up and understanding permissions in The Bug Genie =\n{{TOC}}\n== How are permissions defined? ==\nPermissions are defined on a 4-level basis, in the following order:\n# ''''''Global permissions'''''' - applies to all users, groups and teams\n# ''''''Group-specific permissions'''''' - applies only to members in that usergroup\n# ''''''Team-specific permissions'''''' - applies to any member of that team, and you can be a member of multiple teams\n# ''''''User-specific permissions'''''' - applies to the user it''s specified for\nEach new level in the above list overrides the previous one. That means if you''ve set "''''Report issues''''" to "''''Allowed''''" for "''''''''''Everyone''''''''''" and "''''Denied''''" for the "''''''''''Guest group''''''''''", then the group permission will override the global permission for all users in the guest group. In addition to this, The Bug Genie has a "''''Permissive''''" or "''''Restrictive''''" security setting which means if you trust all your users you can set this setting to "''''Permissive''''" and everyone will be able to do pretty much anything unless specifically denied. The only exception here is access to the configuration pages, where you must have explicit "''''Allowed''''" access. This gives you fine-grained control over what users, groups and teams can do.\n\n== Permissions hierarchy ==\nMany settings are grouped, and most specific settings (ex: "''''Can set issue priority''''") are only available as sub-permissions of more general groups. An example is the "''''Can edit basic information on your own issues''''" permission. This has three sub-settings, "''''Can edit title''''", "''''Can edit descrition''''" and "''''Can edit reproductions steps''''". Using "''''''''''Everyone''''''''''" as an example, if you set the top setting to "''''Allowed''''", everyone can edit basic information (title, description and reproduction steps) for issues they create. If you want to modify this, say you only want them to change the title, then you can do this two ways:\n# Set "''''Can edit description''''" and "''''Can edit reproduction steps''''" to "''''Denied''''". They will still have the basic "''''Can edit basic information (...)''''" setting, which means the title is editable, but the "''''Denied''''" settings for editing description and reproduction steps has higher priority, which means they will not be editable.\n# Unset the "''''Can edit basic information (...)''''" permission, and only set "''''Can edit title''''" to "''''Allowed''''".\nThis grouping is used several places, and is indicated by a little list icon next to the permission icon in the permissions overview. Clicking the list icon brings up all permissions in that group and lets you specify a more fine-grained permission in the group if desired.\n\n== Project-specific permissions ==\nAdding to all this, many permissions can be set on a project-specific basis. You might want to only let people report issues for a certain project, or restrict people from doing something on a specific project. The "''''Project-specific permissions''''"-tab in the permissions overview lets you define this. The same rules apply as above, but if a project-specific permission is set, then it will take presedence over the global permission.\n\n== Page access permissions ==\nYou can limit access to certain pages if you want to restrict users from accessing them. Some of these settings are available as both global and project-specific settings - such as the project-specific pages. This setting is "''''Permissive''''" by default and cannot be changed.\n\n== Datatype permissions ==\nEvery datatype (status, priority, category, etc) also have their own permissions available for each defined value. This setting is permissive by default (and cannot be changed), but lets you control who can set which field to a certain value. Even if you set a datatype field permission to "''''Denied''''" the user will still be able to ''''see'''' the field value, but they cannot set it to that value if the permission is "''''Denied''''". This can be useful in a workflow setting where you only want certain users to be able to mark issues as "''''Fixed''''", "''''Closed''''", etc.\n''''''These permissions are also available for all custom datatypes''''''.\n\n== Nice to know about the permissions handling ==\n* There is one important exception in effect when you''re reporting an issue: If a field is set to "''''''Required''''''" in the reporting process, then the user will have access to this field, even if it set in the permissions manager that they are not allowed to change it. This is to stop the reporting wizard from failing if you''re missing access to a required field. They still need access to a field value to set it, so if all field values are set to "''''Denied''''" then they won''t have any options to choose from. They will also not be able to change it after the issue has been reported if they don''t have access to do so.\n* If a user has read or write access to any of the configuration pages, they will automatically see the "''''Configure''''" link in the menu. If they don''t have access to any configuration page, this link will be hidden.\n* The permissions setting dialog will always show if a setting is permissive or restrictive by default, by showing a faded out "''''Denied''''" or faded out "''''Allowed''''" icon.\n\n[[Category:Help]][[Category:Help:Configuration]][[Category:Help:Howto]]', 1, 0, 0, 1, 8),
(0, 'CreatingIssues', 'CreatingIssues', [[timestamp]], 1, '{{TOC}}\n= Introduction =\nCreating issues in The Bug Genie requires one or more existing projects, as all issues are filed against projects.\n\n= How to start creating an issue =\nWhen a project has been created, an issue can be filed by either using the "Report an issue" tab inside the project space, or by using the "Report an issue" button on the frontpage, if the project is visible there. Both methods will let you pick an issue type directly via a dropdown menu. If you don''t specify an issue type (by clicking directly on the "Report an issue" links, you can specify as the first step on the reporting page.\n\n= Specifying issue details =\nWhen you report an issue, you have to specify the details you want to be saved with the issue when it is reported. By default these details include items such as a descriptive title, a longer description about the issue and a reproduction step list. \n\nThe available and required fields you have to fill out vary depending on the type of issue you are reporting and the associated IssuetypeScheme. The only field that will always be available (and required) is the descriptive title, other fields may vary. A short description of each possible field follows:\n\n=== Title ===\nThis is a short (max 150 char) but descriptive overview of the issue you''re filing. It should be descriptive enough to identify the issue, but short enough to fit on one line.\n* Bad example: ''''The application crashes constantly''''\n* Good example: ''''Whenever I let my cat sleep on the keyboard, the application crashes after about two hours''''\n\n=== Description ===\nA thorough description of the issue. Use as many words as is needed to describe the issue. Pretend that you''re describing it to your mom.\n* Bad example: ''''The stupid application crashed on me! Just as I was about to send my document!"\n* Good example: ''''I opened up the application to write a letter to my aunt. I had been writing for two hours non-stop, and was about to send it, when I tripped and accidentally hit some keys on my keyboard and the application crashed with a message saying "Invalid key combination: CTRL+ALT+PAGEUP+F+S+L+G"''''\n\n=== Reproduction steps ===\nA step-by-step guide to reproducing the issue you''re reporting. Try to be as descriptive as possible and include any and all steps that would be necessary to reproduce the issue for someone that has never experienced it.\n* Bad example: ''''The application just randomly crashes, and I have no idea when, where or why. It''s usually dark and I don''t know what I''m doing''''\n* Good example: \n# Open Application\n# Click "New document"\n# Type some text\n# Accidentally trip and hit the key combination CTRL+ALT+PAGEUP+F+S+L+G\n# Observe application crashing\n\n== Additional details ==\nDepending on the [[IssuetypeSceme|issue type scheme]], there might be additional fields available in the grey area below the main reporting area (known as the "additional fields area") where you can add less important, but still potentially useful information about the issue. If such fields are reportable and marked as "additional", they will show up here, instead of in the main reporting view.\n\n= Submitting an issue =\nWhen you''ve filled out the form and are ready to submit the issue, click the "''''''file issue''''''" button located in the green bar below the main reporting area. As soon as the issue has been saved, it will - based on the settings for that specific issue type - either reload the page with a new reporting form and a link to the submitted issue at the top, or redirect you to the issue you just reported.\n\n[[Category:Help]] [[Category:Help:Howto]]', 1, 0, 0, 1, 9),
(0, 'LoginIntro', 'LoginIntro', [[timestamp]], 1, '= Welcome to The Bug Genie =\nPlease login below.<br>\nIf you have not already registered, please use the "Create an account" button to do so.\n', 1, 0, 0, 1, 10),
(0, 'Category:Workflow', 'Category:Workflow', [[timestamp]], 1, '', 1, 0, 0, 1, 11),
(0, 'LoremIpsum', 'LoremIpsum', [[timestamp]], 1, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed luctus, elit vel auctor tincidunt, magna orci elementum enim, eget luctus nisl enim et velit. Nullam sit amet est augue, ut tincidunt diam. Aliquam aliquam enim et turpis sagittis imperdiet. Donec in augue vitae quam facilisis malesuada a tempus orci. Quisque consectetur scelerisque sapien vel consectetur. Nam at congue magna. Aliquam commodo ornare nisi, vitae malesuada nunc congue in. Duis id est orci. Donec a ullamcorper tellus. Morbi non neque non augue aliquam porta. Sed posuere volutpat quam vitae dignissim. Nullam eu ipsum erat. Morbi nec arcu eget enim condimentum sollicitudin. Ut dui lectus, rhoncus et euismod et, feugiat eu nisi. Cras facilisis, nisl quis venenatis elementum, neque justo vehicula odio, id venenatis sapien neque vel nulla. In quis turpis non orci convallis pharetra. Aliquam erat volutpat.\n\nCras urna lectus, iaculis non venenatis vel, egestas quis est. Aliquam laoreet, neque nec bibendum dignissim, nulla felis hendrerit est, nec volutpat nisl lectus vitae enim. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Integer laoreet risus in massa sollicitudin quis vulputate nulla pretium. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Suspendisse semper, nunc consequat imperdiet convallis, quam tortor euismod mi, ac cursus sem neque sed elit. Vestibulum egestas tempor elit vel imperdiet. Donec lacinia, nulla et tempor facilisis, neque purus sollicitudin nunc, non venenatis leo eros sed ipsum. Cras lacus felis, auctor at euismod quis, vehicula vel est. Sed sit amet mauris ac felis imperdiet faucibus. Nam et euismod erat. Duis varius, dui in molestie dignissim, turpis nulla sollicitudin erat, in porta erat lacus ac eros. Phasellus consequat elementum pellentesque. Sed pharetra condimentum sagittis. Suspendisse metus leo, adipiscing nec congue id, interdum sit amet dui. Phasellus commodo ante ac augue imperdiet vitae volutpat nisl posuere. Integer vitae urna mi, et tincidunt orci. Nulla mattis ultrices dui vitae vestibulum. Donec felis tortor, lobortis vitae euismod in, laoreet quis augue.\n\nMaecenas a felis urna. Cras tincidunt ligula id nisi aliquam pretium. Mauris at nibh at arcu molestie scelerisque a a orci. Nam quam arcu, vulputate et tristique at, dapibus sit amet eros. Nam scelerisque massa posuere dui fermentum eu condimentum erat ultrices. Cras ante diam, mollis sed pretium imperdiet, pretium nec enim. Proin blandit justo tortor, eget sollicitudin magna. Donec rhoncus commodo nibh eget pulvinar. Nunc bibendum tristique arcu a dapibus. Maecenas ultricies consequat dolor et dignissim. Nulla nec velit in magna cursus rhoncus a vitae eros. Maecenas pretium nisl id risus facilisis sed dignissim quam tristique. Nunc consequat, elit ut consectetur blandit, dolor quam vehicula sem, non molestie ipsum nunc pellentesque ipsum. Aliquam erat volutpat. Donec ante massa, bibendum at dapibus a, facilisis nec metus. Nunc tristique sodales erat. Sed laoreet orci sed odio molestie quis varius magna rhoncus.\n\nDonec laoreet luctus lacus dictum commodo. Donec dignissim auctor varius. Nulla nunc metus, egestas sit amet vestibulum sed, fermentum nec ante. Ut in ultrices libero. Donec tortor velit, suscipit a tempor eu, auctor accumsan elit. Donec sed nisl enim. Morbi sagittis interdum quam in lacinia. In fermentum luctus turpis vitae vulputate. Nulla tincidunt semper neque, ut tincidunt nibh tincidunt sed. Maecenas tellus dui, bibendum sed convallis id, varius et mi. Nulla facilisi. Nulla semper, leo non tristique volutpat, ipsum arcu vestibulum enim, bibendum mattis urna nulla vel dolor. Cras nibh lorem, ullamcorper vitae ultricies eu, consequat sed est.\n\nVestibulum varius tempor nisi sed tempor. In suscipit luctus tellus porttitor sollicitudin. Sed in arcu turpis. Donec eu neque non est commodo porttitor. Aliquam erat volutpat. Donec varius, sem nec rutrum commodo, ipsum est sollicitudin dui, sed tempus purus est in felis. Aliquam sodales, velit vitae accumsan molestie, nulla lectus lobortis erat, vehicula ultrices dolor ipsum nec ipsum. Nunc sed turpis sed magna rhoncus lobortis ut ac lectus. Nunc a felis a eros condimentum fringilla. Donec ultrices aliquet leo, ac venenatis quam pharetra at. Pellentesque sodales condimentum felis a porta. Integer justo elit, ullamcorper eget vulputate ut, tincidunt non velit. Donec at urna mi, eget ultricies metus. Duis feugiat pulvinar metus, nec laoreet sem pharetra at. Maecenas quis mi sed lorem euismod convallis eget non quam. Sed vestibulum porttitor arcu, et rutrum est cursus vel. Fusce posuere pellentesque arcu vitae ullamcorper. Nulla facilisis hendrerit ligula, tempus condimentum eros imperdiet et. ', 1, 0, 0, 1, 12),
(0, 'Workflow', 'Workflow', [[timestamp]], 1, '{{TOC}}\n= Introduction =\nA workflow is reprecented by [[WorkflowSteps|steps]] and [[WorkflowTransitions|transitions]] that an issue progresses through, thereby defining an issue lifecycle. Steps and transitions can further be customized with validation, conditional access and permission based access to fields to create a setup perfectly tailored to an individual company workflow.\n\nThis defined lifecycle usually represents an internal company setup, or reflects a companys team-based structure, and is usually also anchored in a company or teams development and QA guidelines.\n\nThe Bug Genie comes with a default workflow called [[DefaultWorkflow|"Default workflow"]]. This workflow cannot be edited or removed, and is used as a fallback workflow or when a project doesn''t have a workflow configured. The editing tools for workflow will of course let you copy this default workflow or create a new one to make your own, and everything in other workflows than the builting one can be customized.\n[[Category:TheBugGenie:Workflow]]', 1, 0, 0, 1, 13),
(0, 'WorkflowSteps', 'WorkflowSteps', [[timestamp]], 1, '== Workflow step explained ==\nA workflow consists of several steps, together defining the possible states an issue can be in during the issue lifecycle. A step is linked to the following three separate properties of an issue:\n* Whether the issue is editable\n* Whether the issue is closed\n* (optionally) The issue status ("Fixed", "In progress", "Testing", etc)\n\n== Changing issue workflow step ==\nAn issue can only enter a new step via a [[WorkflowTransition|transition]] (either instantly or via a [[WorkflowTransitionView|transition view]]), which often defines other properties that needs to be set in order for the issue to progress to the defined step. For the issue to progress, a transition from the current step to any other step in the workflow needs to be defined in the workflow itself.\n\nAn example of this is such as when an issue is in the initial step (often linked with the status "New"), a transition can take it to the "Confirmed" step (often linked with the corresponding "Confirmed" status). During this transition, a user or developer may be asked to provide additional details to validate the transition. How transitions work are explained in more detail in the [[WorkflowTransitions|transitions]] documentation.\n\nThe workflow step is not visible anywhere on the issue - the way to tell it is usually to look at its state (open / closed) and the issues status field. This will give you an overview of the issues current position in the defined workflow.\n\n== Step actions ==\nA step does not have any specific actions associated with it. Because a step is a "state", not the transition between states, the step definition is limited to the three properties mentioned above, and does not include actions.\n\n== Defining a workflow step ==\nIf you''re using a non-default workflow, new steps can be added from the workflow configuration page. This page lists all steps in the specified workflow, and lets you edit the step and/or add outgoing [[WorkflowTransitions|transitions]] to it, leading to another step.', 1, 0, 0, 1, 14),
(0, 'CamelCasing', 'CamelCasing', [[timestamp]], 1, '''''''!CamelCase'''''' (also spelled "camel case") or ''''medial capitals'''' is the practice of writing compound words or phrases in which the elements are joined without spaces, with each element''s initial letter capitalized within the compound, and the first letter can be upper or lower case — as in !LaBelle, !BackColor, !MacGyver, or iPod.\n\nThe name comes from the uppercase "bumps" in the middle of the compound word, suggestive of the humps of a camel.\n\nThe practice is also known by many other names, such as ''''''!BumpCaps'''''', ''''''!BeefCaps'''''', ''''''!CapWords'''''' and ''''''!WikiWords''''''.\n\n''''''This is a short introduction to the subject, based on the [[Wikipedia:CamelCase|Wikipedia article]] about camel case.\n[[Category:Help]]', 1, 0, 0, 1, 15),
(0, 'CSVImport', 'CSVImport', [[timestamp]], 1, '= Importing data from CSV files =\n\nYou can import data to The Bug Genie from a CSV file, pasted into the Import screen. Currently you can only import projects, issues and clients. This document explains how to use the Import feature.\n\nData must be provided in comma-separated format, with the first row containing column names (which have restrictions - see below). Column values should be enclosed in speech marks if appropriate - The Bug Genie will handle these correctly. In addition, The Bug Genie also performs a number of validation steps to ensure the data is valid, also explained below.\n\nWhen the tables mention the ''column name'', this is what should be in the first row to indicate the column. Some columns are required, some are optional, however if you specify a column in the header row it must be included in every subsequent row. Likewise, you can not specify data in subsequent rows which does not have a matching column marked in the header row.\n\n== Importing projects ==\n\n{|\n! Column name !! Required !! Contains !! Other details\n|-\n| name || Yes || Project name || none\n|-\n| prefix || No || Prefix for project issue numbers || By specifying a prefix, the project will automatically use the prefix\n|-\n| scrum || No || Should scrum (Agile) development be used || 1 for yes, 0 for no\n|-\n| owner || No (yes if owner_type specified) || User or Team ID for project owner || none\n|-\n| owner_type || No (yes if owner specified) || Type identifier for owner || 1 for user, 2 for team\n|-\n| lead || No (yes if lead_type specified) || User or Team ID for project leader || none\n|-\n| lead_type || No (yes if lead specified) || Type identifier for leader || 1 for user, 2 for team\n|-\n| qa || No (yes if qa_type specified) || User or Team ID for project''s QA responsible || none\n|-\n| qa_type || No (yes if qa specified) || Type identifier for QA responsible || 1 for user, 2 for team\n|-\n| descr || No || Description || none\n|-\n| doc_url || No || URL for documentation website || none\n|-\n| wiki_url || No || URL for wiki website || none\n|-\n| freelance || No || Can users edit issue properties without working on the issue || 1 for yes, 0 for no\n|-\n| en_builds || No || Are builds enabled || 1 for yes, 0 for no\n|-\n| en_comps || No || Are components enabled || 1 for yes, 0 for no\n|-\n| en_editions || No || Are editions enabled || 1 for yes, 0 for no\n|-\n| workflow_id || No || ID number of workflow scheme || none\n|-\n| client || No || ID number of client || none\n|-\n| show_summary || No || Should a summary be shown on the frontpage || 1 for yes, 0 for no\n|-\n| summary_type || No || What to show on the frontpage || Either issuetypes or milestones\n|-\n| issuetype_scheme || No || ID number of issuetype scheme || none\n|-\n| allow_reporting || No || Set whether new issues can be reported against this project || 1 for yes, 0 for no\n|-\n| autoassign || No || Set whether to automatically assign issues based on the leader for projects, editions and components || 1 for yes, 0 for no\n|}\n\n== Importing clients ==\n\n{|\n! Column name  !! Required !! Contains !! Other details\n|-\n| name || Yes || Client name || none\n|-\n| email || No || Email address || none\n|-\n| telephone || No || Telephone number || none\n|-\n| fax || No || Fax number || none\n|-\n| website || No || Website address || none\n|}\n\n== Importing issues ==\n\n{|\n! Column name !! Required !! Contains !! Other details\n|-\n| title || Yes || Issue title || none\n|-\n| project || Yes || Project ID || none\n|-\n| descr || No || Issue description || none\n|-\n| repro || No || Reproduction steps || none\n|-\n| state || No || Type identifier for owner || 1 for closed, 0 for open\n|-\n| status || No || ID for status value || none\n|-\n| posted_by || No || User ID (NOT team) for issue poster || If not specified, importing user will be set\n|-\n| owner || No (yes if owner_type specified) || User or Team ID for issue owner || none\n|-\n| owner_type || No (yes if owner specified) || Type identifier for owner || 1 for user, 2 for team\n|-\n| assigned || No (yes if assigned_type specified) || User or Team ID for issue assignee || none\n|-\n| assigned_type || No (yes if assigned specified) || Type identifier for assignee || 1 for user, 2 for team\n|-\n| resolution || No || ID of resolution value || none\n|-\n| issue_type || Yes || ID of issue type || none\n|-\n| priority || No || ID of priority value || none\n|-\n| category || No || ID of category value || none\n|-\n| severity || No || ID of severity value || none\n|-\n| reproducability || No || ID of reproducability value || none\n|-\n| votes || No || Number of votes || none\n|-\n| percentage || No || How much of the issue is complete || 0 to 100 inclusive\n|-\n| blocking || No || Does the issue block the next release || 1 for yes, 0 for no\n|-\n| milestone || No || ID number of milestone || none\n|}\n\n[[Category:Help]]\n', 1, 0, 0, 1, 16),
(0, 'GettingStarted', 'GettingStarted', [[timestamp]], 1, '= Getting started with The Bug Genie =\n{{TOC}}\n== Name, slogan and other settings ==\nYou might want to set the name and slogan, or change some of the other default settings. You can do this from [[TBG:configure_settings|Configure -> Settings]], where you have all the main settings available.\n\n== Your first project ==\nThe first thing you want to do is set up your project. Although The Bug Genie can be used without any projects, it''s mainly an issue tracker, and that''s where it excels.\n\nTo add a project, log in as an admin, and either click the little configuration icon next to the project list on the frontpage, or click [[TBG:configure_projects|Configure -> projects]]. This will take you to the projects list. To create a project from here, simply enter the project name in the text box and click "Add" or press Enter.\n\nThe Bug Genie is now ready to be used for issue reporting with your new project. However, you might want to set up more information about the project. Click the "Edit project" link on the project and change any settings in here. From that page you can also add a project description, release date and more information about your project. This is also where you set up editions, components, releases, milestones, and more.\n\n=== Permissions ===\nYour project will initially only be available to the user group that created the project. If you created the project as the administrator user, the project will initially be available only to the "Administrator" group. You can change this by clicking the "more details" link when you create the project. You can also change project permissions for other user groups by going to [[TBG:configure_permissions|Configure -> Permissions]]. Select the "Project specific permissions" tab, and click the project name. From here you can set permissions for all groups and teams in the system. \n\nTo allow easy bug reporting if the global security setting is set to "Restrictive", enable the following permission groups:\n* Can access project\n* Can access all project pages\n* Can create issues, edit basic information on issues reported by the user and close/re-open them\n\nTo do this, click the permission group text, and then click the icons for either global access, group-specific- or team-specific access.\n\n''''For smaller teams, consider setting the global security setting to "Permissive". This can be done from [[TBG:configure_settings|Configure -> settings]] under the "Users & security" tab.''''\n\n\n=== Project team ===\nSomeone is usually working on your project. You should add developers working on The Bug Genie to your project. (This of course requires that your developers have user accounts). Click the "Edit project" icon on your project, and then open up the ''''''Related users'''''' tab. Add developers, project managers, testers and documentors from this page. By adding developers to projects, you ensure that they get access to project specific features such as project information on their dashboard, issue notifications, and they also appear on the projects'' team page.\n\n=== Editions, components & releases ===\n==== Releases ====\nIf your project publishes regular test releases / builds, you should enable releases. This lets you add a specific build / release name / id to an issue so that you can target the issues progress through a set of releases. When this setting is enabled you can also add a release to your issue when you report it, and even make it mandatory during the report process for any given issue type.\n\n==== Components ====\nOften a project is made up of several very specific pieces of code or functionality. Such components can be "search", "wiki", "admin interface", etc. and is up to you to decide. Similar to above (releases), an issue can also target a specific component. You can also notify certain developers or teams when a new issue for a certain component has been reported by adding them to the specific component on the project "Related users" configuration page.\n\n==== Editions ====\nIn some cases your project may also be made up of several different editions. Editions are mainly defined by their included components, and one edition usually includes a different feature set from another edition. You may also want to use editions for version tracking, and set up editions between major versions, such as "MYPROJECT version 1", "MYPROJECT version 2", and so on.\n\n== Reporting issues ==\nYou can report issues for any projects registered in the bug genie by clicking the "Report an issue" tab in the top menu bar, or the green "Report an issue" button which is shown in the project menu bar. If you''re not in any project (such as in the global wiki, your user account settings, dashboard, etc), the report issue form will let you choose a project to report an issue for. Otherwise, the issue will be reported for the currently selected issue.\n\n=== Customizing issue types ===\nThe Bug Genie comes with a predefined set of issue types available out of the box. These can be customized to show different fields during issue reporting and in the issue overview page. You can do this from [[TBG:configure_issuetypes|Configure -> issue types]], where you can also add new issue types. Keep in mind that The Bug Genie uses the information in these issue types to include them in areas of the system where they would be relevant, such as showing any custom "bug report" issue types in bug report statistics, etc - use this to your advantage!\n\n=== Adding custom fields ===\nIf the standard issue fields aren''t enough for your needs, you can add custom ones from [[TBG:configure_issuefields|Configure -> issue fields]]. These fields are treated just as other issue fields in the system, and are available for searches and issue type customization. There are several types of custom fields to choose from, such as radio buttons, input areas, list of users, secondary status fields, dates, and more.\n\n[[Category:Help]][[Category:Help:Howto]]', 1, 0, 0, 1, 17),
(0, 'RegistrationIntro', 'RegistrationIntro', [[timestamp]], 1, '= Register a new account =\nTo register, please fill out the information below.<br>\n''''(Required information is marked with an asterisk)<strike></strike>''''', 1, 0, 0, 1, 18),
(0, 'Configuration', 'Configuration', [[timestamp]], 1, '#REDIRECT [[Category:Help:Configuration]]', 1, 0, 0, 1, 19),
(0, 'Category:Help:HowTo', 'Category:Help:HowTo', [[timestamp]], 1, '[[Category:Help]]', 1, 0, 0, 1, 20),
(0, 'FrontpageLeftmenu', 'FrontpageLeftmenu', [[timestamp]], 1, 'If you want to put something in this area, edit the FrontpageLeftmenu wiki article.', 1, 0, 0, 1, 21),
(0, 'AboutIssuePrefixes', 'AboutIssuePrefixes', [[timestamp]], 1, '== Prefixes explained ==\nA project can specify a prefix that will be used for all issues created against it. This prefix will then be used in issue numbers, links and descriptions. Because all issues in The Bug Genie are counted against specific projects (this means you can have an issue #1 for "Project 1" and an issue #1 for Project 2), prefixes can be an easy way to quickly distinguish between issues from different projects simply by looking at their issue number.\n\n== Example ==\nSay you have two projects, "Awesome product" and "Crappy product", and you want to use a prefix on issues created against "Crappy product" so you can easily find them in your list of issues. To do this, open up project configuration for "Crappy product" (either by clicking the "edit project" link on the frontpage, project dashboard or on the [[TBG:configure_projects|Configure projects]] page), and select "Yes" for "Enable prefix". Then - in the box below - specify a prefix that will be used (e.g. "CRAP").\n\nNow all issues for this project uses the prefix specified. Issue #1 will be called "CRAP-1", issue #2 "CRAP-2", etc. This is also backwards-compatible, so you can change it any time you want, and it will be valid for all your issues in that project.', 1, 0, 0, 1, 22),
(0, 'WorkflowTransitionView', 'WorkflowTransitionView', [[timestamp]], 1, '== Introduction ==\nThe workflow transition view is a popup presented to the user / developer so he or she can specify additional properties to be applied to the issue during its transition to the outgoing transition step. This popup can have items such as choosing whether time spent on the issue should be automatically logged, what resolution to pick for an issue, and more.\n\n== Properties ==\nThe list of properties shown in the transition view is defined by the post-transition actions specified on the transition. For example, if the transition doesn''t specify that it will set the resolution to the resolution given by the user, no dropdown for selecting a resolution will be shown. Also, if the resolution field isn''t defined as visible for that project / issue type combination, a message will be displayed to the user, so he/she can choose not to specify that particular field.\n\n== Instant transitions ==\nA transition doesn''t have to specify a view for when it is being applied to an issue. A transition without an associated transition view will be applied instantly.', 1, 0, 0, 1, 23);
INSERT INTO `[[dbprefix]]articles` VALUES
(0, 'WikiFormatting', 'WikiFormatting', [[timestamp]], 1, '{{TOC}}\nThe Bug Genie uses a formatting technique called "Wiki formatting", most commonly known from Wikipedia (!MediaWiki).\nThe Bug Genie wiki tries to stay as close to the !MediaWiki syntax as possible, so if you''re familiar with that syntax you should feel right at home.\n\nWiki formatting is well explained in the [http://en.wikipedia.org/wiki/Help:Wikitext_examples Wikipedia help article], but can be easily summarized as a simple method of formatting your text by placing certain characters.\nWe will show you the most common syntax below.\n\n== Line breaks and text formatting ==\nYou can use line breaks to space out the text and make it more readable in the editor. One line break will not be transformed into a line break when the page is \ndisplayed. A blank line makes a new paragraph. You can put <br> to make a hard line break, but be careful with this as it might break layout.\n  This text is easy to\n  read because it is\n  split into several lines\n  but it will only show up as one line on the page\nThis text is easy to\nread because it is\nsplit into several lines\nbut it will only show up as one line on the page\n\nText can be formatted by putting ''-characters around the text you want to format. Here are some examples:\n\n  ''''this is some italic text''''\n''''this is some italic text''''\n  ''''''this is some bold text''''''\n''''''this is some bold text''''''\n  ''''''''''this is some bold and italic text''''''''''\n''''''''''this is some bold and italic text''''''''''\n\nYou can also use simple html formatting for things like underlined and strikethrough:\n\n  <strike>strikethrough</strike>\n<strike>strikethrough</strike>\n  <u>underlined</u>\n<u>underlined</u>\n\n== Headings ==\nTo specify headings, use equals-character around the line you want to be a heading. The number of equals-characters you put around the line decides how big the heading is (1 is biggest, 6 is lowest).\n  = I''m a big header =\n  == I''m a fairly big header ==\n  ===== I''m a very small header =====\nHeadings will automatically appear in the table of contents (if you have one).\n\n== Creating links between documents ==\nTraditionally, wikis have used something called [[WIKIPEDIA:CamelCase|Camel Casing]] to create links between documents. CamelCasing means that you put any word or combination of words as a "''''''camel cased''''''" word, and then the wiki will create a link to the document with that name for you automatically. If the page you are trying to link to isn''t yet created, the link will still be displayed, and you can click it to start editing the new article.\n\nIf you want to write a word with more than one capital letter, use an exclamation mark infront of it - that will stop it from being turned into a link automatically. The support for "camel casing" can be turned off in the wiki settings.\n\nYou can also use the double square bracket link format to link to internal pages, if you don''t want to use the CamelCasing style:\n  [[InternalPage]]\n[[InternalPage]]\n  [[Myproject:MainPage|Myproject wiki frontpage]]\n[[Myproject:MainPage|Myproject wiki frontpage]]\n\nWith this method you can also link to internal pages in The Bug Genie, by either specifying the relative url (like "/configure" points to the configuration page and "/wiki" points to the wiki), or use the internal route namespace "TBG:" (this has the added benefit of being safe if the link ever changes in a future release).\nUnfortunately, the list of routes used in The Bug Genie is quite long, but a few examples are listed below:\n\n  [[/about|About The Bug Genie]]\n[[/about|About The Bug Genie]]\n  [[/logout|Log out]]\n[[/logout|Log out]]\n  [[TBG:configure_projects|Configure projects]]\n[[TBG:configure_projects|Configure projects]]\n  [[TBG:configure_modules|Modules configuration]]\n[[TBG:configure_modules|Modules configuration]]\n\nThe Bug Genie wiki also lets you link directly to [http://www.wikipedia.org Wikipedia] articles by using the WIKIPEDIA namespace:\n\n  [[WIKIPEDIA:CamelCase]]\n[[WIKIPEDIA:CamelCase]]\n  [[WIKIPEDIA:CamelCase|Wikipedia article]]\n[[WIKIPEDIA:CamelCase|Wikipedia article]]\n\n''''''Remember - if all this sound complicated, you can always just use CamelCasing (provided it''s not disabled)''''''\n\n== Links ==\nIn addition to linking between internal pages with double square brackets, you can link to external pages with single square brackets. Any URLs inside your text will also automatically be turned into clickable links, but you can also put a pair of square brackets around the link to make it clickable. In addition, you can add a title if you want to:\n\n  https://thebuggenie.com\nhttps://thebuggenie.com\n  [https://thebuggenie.com]\n[https://thebuggenie.com]\n  [https://thebuggenie.com The Bug Genie website]\n[https://thebuggenie.com The Bug Genie website]\n\n== Horizontal line ==\nIf you want to put a horizontal line in the document, use four dashes:\n\n  ----\n----\n\n= Advanced usage =\n\n== Tables ==\nYou can add tables to your wiki page by using the table layout for defining rows, columns and headers. An example table (without headers) looks like this:\n  {|\n  |-\n  | Column 1 || Column 2 || Column 3\n  |}\n{|\n|-\n| Column 1 || Column 2 || Column 3\n|}\n\nAn example table ''''''with headers'''''' looks like this:\n  {|\n  ! Header 1 !! Header 2 !! Header 3\n  |-\n  | Column 1 || Column 2 || Column 3\n  |}\n{|\n! Header 1 !! Header 2 !! Header 3\n|-\n| Column 1 || Column 2 || Column 3\n|}\n\nA table must start with a table opener, and end with a table closer:\n\n''''''Table opener:''''''\n  {|\n''''''Table closer:''''''\n  |}\n\nIf you want to add header columns to your table, use the header row formatting, which is similar to the "normal" column formatting, but with an exclamation mark separator character:\n  ! Header 1 !! Header 2 !! Header 3\n\nEvery new row starts with a row indicator, which looks like this:\n  |-\n\nThe first column in a row starts with a single or double pipe character, and every new column is separated with a double pipe separator. These are both valid columns:\n  | Column 1 || Column 2 || Column 3\nand:\n  || Column 1 || Column 2 || Column 3\n\n\n== Categories ==\nYour article can be in none, one or more categories. You specify which category your article is in by using the Category namespace link:\n  [[Category:Mycategory]]\n\nThis won''t show up on the page, and you usually place this at the very end of your wiki page when you edit it. Categories will show up in the "Categories" area at the bottom of the article.\n\nIf you want to link to a Category, instead of put your article ''''''in'''''' a category, put a colon in front of the word "Category":\n  [[:Category:Mycategory]]\n[[:Category:Mycategory]]\n\nA category can have one or more ''''subcategories''''. You put one category in another category by putting the Category link shown above ''''inside the subcategory article''''.\n\n''''''Ex:'''''' after having created the page [[:Category:Actors]], create the page [[:Category:MaleActors]], and at the bottom of that article, put:\n  [[Category:Actors]]\nThis will make [[:Category:MaleActors]] a subcategory of [[:Category:Actors]]. That means [[:Category:MaleActors]] will show up in the "Subcategories" list on the [[:Category:Actors]] page.\n\nBefore you can see the content of a category - its subcategories or pages in that category, the category must be created. To create a category, put an article in a category, click the category link at the bottom of the article, and create the page.\nA category page is in essence just any other wiki article, but with the list of subcategories (if any) and pages in that category.\n\n== Redirecting from one page to another ==\nIf you want to make one page redirect directly to another page, use the ''''#REDIRECT'''' keyword, followed by the article to redirect to, like this:\n #REDIRECT [[PageToRedirectTo]]\n\nThe ''''#REDIRECT'''' must be the first thing on the first line, and must be followed by a space and the article name in the format specified above. This will not work:\n This is some content\n #REDIRECT [[AnotherPage]]\n\nNeither will this:\n  #REDIRECT [[AnotherPage]]\n(notice the space in front of ''''#REDIRECT'''')\n\n\n== Images ==\nYou can show uploaded images by using the same notation as for links, using the Image namespace:\n [[Image:image1.png]]\n\nThe Image: namespaced link accepts several parameters, separated by a pipe (|), and the right-most parameter is always the description. This means that if you want to specify any parameters, you must always put a description as the last parameter:\n [[Image:image1.png|Description here]]\n [[Image:image1.png|thumb|Description here]]\n\nImages are shown full-size by default, but you usually probably want to show a thumbnail of the image instead. To do this, use the "thumb" parameter:\n [[Image:image1.png|thumb|Image description]]\n\nImages float right by default, but this can also be specified as a parameter, by specifying "left" as a parameter on the Image tag:\n [[Image:image1.png|This image floats right]]\n [[Image:image1.png|right|This image also floats right]]\n [[Image:image1.png|left|This image floats left]]\n\n== Completely unparsed text ==\nIf you have some text that you don''t want to be automatically parsed at all, put them inside <nowiki></nowiki> tags:\n  <nowiki><nowiki>some text that shouldn''t be parsed [[a|link]] and ''''''bold text''''''</nowiki></nowiki>\n<nowiki>some text that shouldn''t be parsed [[a|link]] and ''''''bold text''''''</nowiki>\n\n== Lists ==\nTo create a list, use the star character for a bulleted list, hash character for a numbered (ordered) list, or a combination:\n\n  * One bullet\n  * Another ''''''bullet''''''\n  *# a list item\n  *# another list item\n  *#* unordered, ordered, unordered\n  *#* again\n  *# back down one\n* One bullet\n* Another ''''''bullet''''''\n*# a list item\n*# another list item\n*#* unordered, ordered, unordered\n*#* again\n*# back down one\n\n\n== Variables ==\nThere are some shortcuts available for outputting special data such as the current date, hour, day, etc. By putting special keywords enclosed with two { and }-characters on each side, The Bug Genie will automatically translate this for you.\n\n''''''Here are some examples'''''':\n  {{CURRENTMONTH}}\n{{CURRENTMONTH}}\n  {{CURRENTDAY}}\n{{CURRENTDAY}}\n  {{SITENAME}}\n{{SITENAME}}\n\nThe following keywords are available for automatic substitution: CURRENTMONTH, CURRENTMONTHNAMEGEN, CURRENTMONTHNAME, CURRENTDAY, CURRENTDAYNAME, CURRENTYEAR, CURRENTTIME, NUMBEROFARTICLES, PAGENAME, NAMESPACE, SITENAME, SITETAGLINE.\n\n== Table of contents ==\nYou can get a table of content on your page (like the one in the top right on this page) by using the TOC variable the same way as the "normal" variables above. It doesn''t matter where you put this variable in your document, it will always be displayed in the top right corner.\n\n== Linking to issues ==\nIf you want to link to an issue, use one of the following keywords: ''''''bug'''''', ''''''issue'''''', ''''''ticket'''''', ''''''story'''''', followed by the issue number:\n  ticket #123\nticket [http://sample.com/product/issue/123 #123 - title from ticket here]\n  bug #200\nbug [http://sample.com/product/issue/200 #200 - serious bug]\n  issue TBG-24\nissue <strike>[http://sample.com/product/issue/TBG-24 TBG-24 - issue title]</strike>\n\nThe links will automatically include things such as the title, and a strikethrough if the issue is closed.\n\n== Examples / comments ==\nIf you want to put some text on the page that shouldn''t be interpreted (like the examples above), put two spaces in front of each line.\n    I''m an example because I have two spaces in front of me (actually I have four, but that''s just so you can see the two spaces)\n    This is a second line\n\n== Syntax highlighting ==\n\nIf you have a code sample you want to place on a page, you can use syntax highlighting to place line numbers, and color the code depending on what language it is.\n\nTo do this, surround your code in <nowiki><source></source></nowiki> tags. By default this will use the default language and line numbering settings set by the administrator. You can also override these parameters to match your code settings.\n\n=== Code language ===\n\nTo set the language of the code, simply specify it as a property of the source tag, such as <nowiki><source lang="php">echo(''hi'');</source></nowiki>. If you specify an language that does not exist then no colors will be applied, but there are over 130 language definitions available so chances are you will find the right one. A few of the odd ones are ''''''html4strict'''''' for HTML code, and ''''''dos'''''' for a DOS batch file.\n\n=== Line numbering ===\n\nThree parameters are available to set the line numbering. The first of these is called ''''''line'''''', and it sets the style of numbering that is performed. The following styles are available:\n* ''''''GESHI_FANCY_LINE_NUMBERS'''''' or ''''''highlighted'''''' - Line numbering with a highlighted row at a regular interval (this interval is configurable)\n* ''''''GESHI_NORMAL_LINE_NUMBERS'''''' or ''''''normal'''''' - Normal line numbers with no highlighting\n* ''''''Anything else'''''' - No numbers\nYou can also specify the number at which the numbers count from. This is useful if you have taken a snippet from line 1000 in a file, and you want to make the snippet show this so that its easier to match the two up. To do this, the parameter is ''''''line start="''''number''''"'''''' (there is a space between line and start), and it will start counting from ''''number''''.\n\nFinally, if you choose ''''''GESHI_FANCY_LINE_NUMBERS'''''' or ''''''highlighted'''''', every ''''n''''th row is highlighted. To set a value for ''''n'''', you use the highlight property. For example if you set it to 10, then every 10th row will be highlighted.\n\nBelow is an example of all of the properties in use.\n\n<nowiki>\n<source lang="php" line="highlighted" line start="54" highlight="3">\n<?php\nfunction do_something($stuff) {\necho($stuff);\n$mythings = array();\n$mythings[] = $stuff;\n}\n?>\n</source>\n</nowiki>\n\n<source lang="php" line="highlighted" line start="54" highlight="3">\n<?php\nfunction do_something($stuff) {\necho($stuff);\n$mythings = array();\n$mythings[] = $stuff;\n}\n?>\n</source>\n\n[[Category:Help]][[Category:Help:Howto]]', 1, 0, 0, 1, 24),
(0, 'WorkflowDefault', 'WorkflowDefault', [[timestamp]], 1, '= Overview =\nThe default workflow is used for issue types that does not have a workflow set in the workflow scheme associated with the current project. The default workflow is also used in the default workflow scheme setup.<br>\nThis is an overview of the default workflow setup with its steps and transitions:\n\n{|\n! Step !! Connected status !! State !! Outgoing transitions !! Notes\n|-\n| ''''''New'''''' || ''''New'''' || Open and editable || Investigate issue → Investigating<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress<br>Resolve issue → Closed || This is the default, initial step all issues start in\n|-\n| ''''''Investigating'''''' || ''''Investigating'''' || Open and editable || Request more information → New<br>Confirm issue → Confirmed<br>Reject issue → Rejected<br>Accept issue → In progress || \n|-\n| ''''''Confirmed'''''' || ''''Confirmed'''' || Open but not editable || Accept issue → In progress <br>Assign issue → In progress <br>Resolve issue → Closed || \n|-\n| ''''''In progress'''''' || ''''Being worked on'''' || Open but not editable || Reject issue → Rejected <br>Mark ready for testing → Ready for testing <br>Resolve issue → Closed || \n|-\n| ''''''Ready for testing'''''' || ''''Ready for testing / QA'''' || Open but not editable || Resolve issue → Closed <br>Test issue solution → Testing || \n|-\n| ''''''Testing'''''' || ''''Testing / QA'''' || Open but not editable || Accept issue solution → Closed <br>Reject issue solution → In progress || \n|-\n| ''''''Rejected'''''' || ''''Not a bug'''' || Closed and not editable || Reopen issue → New || \n|-\n| ''''''Closed'''''' || - || Closed and not editable || Reopen issue → New || This workflow step is not linked directly to a status\n|}\n\nSome things to note about the default workflow:\n* It is not possible to directly move an issue from new to closed - it has to either be accepted or assigned first. You can however move it directly to rejected if it is invalid or duplicate\n* The ''''Closed'''' step is not linked to a status, but has two valid statuses - ''''''Closed'''''' and ''''''Postponed''''''', 1, 0, 0, 1, 25),
(0, 'WorkflowTransition', 'WorkflowTransition', [[timestamp]], 1, '== Workflow transitions explained ==\nA transition is when an issue moves from one step to another in the workflow associated with that project/issue type combination. The workflow transition is what triggers email notifications, changes status, resolution, issue state, and more. Without a transition happening, changes to an issue state will not be consistent with the data associated with that workflow step. The transition being performed is essential for the workflow to function properly.\n\n== Transition details ==\nWhen a transition is defined, it can have pre-/post-validators, and post-transition actions associated with it.\n\n=== Pre-validators ===\nA pre-validator is a set of rules that must apply to an issue for the transition to be available. For example, you can set a "maximum number of assigned issues", which means that for that transition to be available to the developer, he can not have more than the specified number of issues assigned. These pre-validation rules are shown in the workflow configuration view after selecting a transaction.\n\n=== Post-validators ===\nThe post-validators validates input from the user, and makes sure it passes a valid set of allowed values. For example (in the default workflow), issues that are moving from the "In progress" step to the "Resolved" step will have to have the status set to one of the following: "Done", "Fixed" or "Closed". These validation rules are also integrated with the transition view, so it is not possible to modify the issue property to a value that is not allowed in the transitions'' post-validation rule set.\n\n=== Post-transition actions ===\nA post-transition action is an action that defines what will be done with the issue after the transaction validation is complete. This can be everything from applying a user-specified priority/resolution, to marking an issue as being worked on by a user (for automated time tracking), changing the percent complete field (to give a good visual indicator of how complete an issue is) or changing the user assigned to an issue. Post-transition actions occur at the very end of the transition, right before the issues step is changed to the outgoing step of the transition.\n\n=== Pre- vs. post-validators ===\nThere is a fundamental difference between pre- and post-validators. Whereas the post-validators validate user input, such as a status provided in the [[WorkflowTransitionView|transition view]], the pre-validators is what decides whether the user will even be able to trigger the transition view or transition. A pre-validation rule keeps the transition from being ''''''available'''''' under certain conditions, whereas the post-validation rules keeps the issue from ''''''having its properties set to invalid values''''''.', 1, 0, 0, 1, 26),
(0, 'OpenidIntro', 'OpenidIntro', [[timestamp]], 1, '= Log in using an OpenID account =\nIf you have an account registered with any of the services listed below, press the associated button to log via that service', 1, 0, 0, 1, 27),
(0, 'DefaultIssuetypeScheme', 'DefaultIssuetypeScheme', [[timestamp]], 1, '{{TOC}}\n= Introduction =\nThe Default issuetype scheme is used for projects without a custom issue type scheme set, and defines a default set of visible / required properties on the [[CreatingIssues|Report an issue]] page, as well as on the "view issue" page.\n\n= Overview =\nThis is an overview of the required / visible properties per issue type. \n''''''Note:'''''' If a field has been set (either via a workflow transition, or otherwise), its value will be displayed regardless of its "visible" setting. Remember that the user must also have the permission to set the field in question, and there must be values available for the field to be populated.\n\n''''''Explanation:''''''\n* ''''Reportable'''': Whether the specified field is visible on the reporting page\n* ''''Required'''': Whether this field is required when reporting an issue\n* ''''Additional'''': Whether this is shown in the "additional fields" area, or in the main view when reporting an issue\n* ''''Visible'''': Whether this field is visible on the "view issue" page\n== Bug report ==\n* ''''''Redirects to the reported issue'''''': Yes\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || Yes\n|-\n| Description || Yes || Yes || - || Yes\n|-\n| Reproduction steps || Yes || Yes || - || Yes\n|-\n| Category || Yes || Yes || - || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || Yes || Yes || Yes || -\n|-\n| Priority || Yes || Yes || Yes || -\n|-\n| Severity || Yes || Yes || Yes || -\n|-\n| Estimated time to complete || Yes || Yes || Yes || -\n|-\n| Targetted for milestone || Yes || Yes || Yes || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || - || - || - || -\n|-\n| Affected edition(s) || Yes || Yes || - || -\n|-\n| Affected release(s) || Yes || Yes || - || -\n|-\n| Affected component(s) || Yes || Yes || - || -\n|-\n| Time spent working on the issue || Yes || - || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || - || - || - || -\n|}\n== Feature request, Enhancement & Idea ==\n* ''''''Redirects to the reported issue'''''': Yes\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || Yes\n|-\n| Description || Yes || Yes || - || Yes\n|-\n| Reproduction steps || - || - || - || -\n|-\n| Category || Yes || Yes || Yes || -\n|-\n| Reproducability || - || - || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || - || - || - || -\n|-\n| Priority || Yes || Yes || Yes || -\n|-\n| Severity || - || - || - || -\n|-\n| Estimated time to complete || Yes || Yes || Yes || -\n|-\n| Targetted for milestone || Yes || Yes || Yes || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || Yes || Yes || Yes || -\n|-\n| Affected edition(s) || - || - || - || -\n|-\n| Affected release(s) || - || - || - || -\n|-\n| Affected component(s) || - || - || - || -\n|-\n| Time spent working on the issue || Yes || - || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || Yes || - || - || -\n|}\n== Task ==\n* ''''''Redirects to the reported issue'''''': No, loads a new & empty reporting form with a link to the saved issue at the top\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || -\n|-\n| Description || Yes || Yes || - || Yes\n|-\n| Reproduction steps || - || - || - || -\n|-\n| Category || Yes || Yes || Yes || -\n|-\n| Reproducability || - || - || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || - || - || - || -\n|-\n| Priority || Yes || Yes || Yes || -\n|-\n| Severity || - || - || - || -\n|-\n| Estimated time to complete || Yes || Yes || Yes || -\n|-\n| Targetted for milestone || Yes || Yes || Yes || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || Yes || Yes || Yes || -\n|-\n| Affected edition(s) || - || - || - || -\n|-\n| Affected release(s) || - || - || - || -\n|-\n| Affected component(s) || - || - || - || -\n|-\n| Time spent working on the issue || Yes || - || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || Yes || - || - || -\n|}\n== User story ==\n* ''''''Redirects to the reported issue'''''': No, loads a new & empty reporting form with a link to the saved issue at the top\n{|\n! Field !! Visible !! Reportable !! Additional !! Required\n|-\n| Title || Yes || Yes || - || -\n|-\n| Description || Yes || Yes || - || -\n|-\n| Reproduction steps || - || - || - || -\n|-\n| Category || Yes || Yes || - || -\n|-\n| Reproducability || - || - || - || -\n|-\n| Status || Yes || - || - || -\n|-\n| Resolution || - || - || - || -\n|-\n| Priority || Yes || Yes || - || -\n|-\n| Severity || - || - || - || -\n|-\n| Estimated time to complete || Yes || Yes || - || -\n|-\n| Targetted for milestone || Yes || Yes || - || -\n|-\n| Reproducability || Yes || Yes || - || -\n|-\n| Percent completed || Yes || Yes || - || -\n|-\n| Affected edition(s) || - || - || - || -\n|-\n| Affected release(s) || - || - || - || -\n|-\n| Affected component(s) || - || - || - || -\n|-\n| Time spent working on the issue || Yes || Yes || - || -\n|-\n| Triaging: user paing || - || - || - || -\n|-\n| Votes || Yes || - || - || -\n|}', 1, 0, 0, 1, 28);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articleviews`
--

CREATE TABLE `[[dbprefix]]articleviews` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT '0',
  `article_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]branchcommits`
--

CREATE TABLE `[[dbprefix]]branchcommits` (
  `branch_id` int(10) DEFAULT '0',
  `commit_id` int(10) DEFAULT '0',
  `commit_sha` text,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]branchcommits_commit` (`commit_id`),
  KEY `[[dbprefix]]branchcommits_branch` (`branch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]branches`
--

CREATE TABLE `[[dbprefix]]branches` (
  `name` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) DEFAULT NULL,
  `latest_commit_id` int(10) DEFAULT '0',
  `project_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]branches_project` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]buddies`
--

CREATE TABLE `[[dbprefix]]buddies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `bid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]builds`
--

CREATE TABLE `[[dbprefix]]builds` (
  `name` varchar(200) DEFAULT NULL,
  `edition` int(10) DEFAULT '0',
  `project` int(10) DEFAULT '0',
  `milestone` int(10) DEFAULT '0',
  `locked` tinyint(1) DEFAULT NULL,
  `file_id` int(10) DEFAULT '0',
  `file_url` varchar(255) DEFAULT NULL,
  `version_major` int(5) DEFAULT '0',
  `version_minor` int(5) DEFAULT '0',
  `version_revision` varchar(30) DEFAULT NULL,
  `isreleased` tinyint(1) DEFAULT NULL,
  `release_date` int(10) DEFAULT '0',
  `owner_team` int(10) DEFAULT '0',
  `owner_user` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]clientmembers`
--

CREATE TABLE `[[dbprefix]]clientmembers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `cid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]clients`
--

CREATE TABLE `[[dbprefix]]clients` (
  `name` varchar(200) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `telephone` varchar(200) DEFAULT NULL,
  `website` varchar(200) DEFAULT NULL,
  `fax` varchar(200) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `content` text,
  `posted_by` int(10) DEFAULT '0',
  `updated_by` int(10) DEFAULT '0',
  `posted` int(10) DEFAULT '0',
  `updated` int(10) DEFAULT '0',
  `target_id` int(10) DEFAULT '0',
  `target_type` int(5) DEFAULT '0',
  `is_public` tinyint(1) DEFAULT NULL,
  `module` varchar(100) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `system_comment` tinyint(1) DEFAULT NULL,
  `has_associated_changes` tinyint(1) DEFAULT NULL,
  `comment_number` int(10) DEFAULT '0',
  `reply_to_comment` int(10) DEFAULT '0',
  `syntax` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comments_type_target` (`target_type`,`target_id`),
  KEY `[[dbprefix]]comments_type_target_deleted_system` (`target_type`,`target_id`,`deleted`,`system_comment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]commitfiles`
--

CREATE TABLE `[[dbprefix]]commitfiles` (
  `file_name` text,
  `action` varchar(1) DEFAULT NULL,
  `commit_id` int(10) DEFAULT '0',
  `data` varchar(500) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]commitfiles_commit` (`commit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]commitfile_diffs`
--

CREATE TABLE `[[dbprefix]]commitfile_diffs` (
  `diff` text,
  `start_line_remove` int(10) DEFAULT '0',
  `lines_removed` int(10) DEFAULT '0',
  `start_line_add` int(10) DEFAULT '0',
  `lines_added` int(10) DEFAULT '0',
  `diff_header` varchar(300) DEFAULT NULL,
  `commit_file_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]commits`
--

CREATE TABLE `[[dbprefix]]commits` (
  `log` text,
  `old_rev` varchar(40) DEFAULT NULL,
  `previous_commit_id` int(10) DEFAULT '0',
  `new_rev` varchar(40) DEFAULT NULL,
  `new_rev_short` varchar(40) DEFAULT NULL,
  `author` int(10) DEFAULT '0',
  `date` int(10) DEFAULT '0',
  `data` varchar(500) DEFAULT NULL,
  `project_id` int(10) DEFAULT '0',
  `is_imported` tinyint(1) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]commits_project` (`project_id`),
  KEY `[[dbprefix]]commits_project_commit` (`project_id`,`new_rev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]components`
--

CREATE TABLE `[[dbprefix]]components` (
  `name` varchar(200) DEFAULT NULL,
  `project` int(10) DEFAULT '0',
  `leader_team` int(10) DEFAULT '0',
  `leader_user` int(10) DEFAULT '0',
  `qa_responsible_team` int(10) DEFAULT '0',
  `qa_responsible_user` int(10) DEFAULT '0',
  `isreleased` tinyint(1) DEFAULT NULL,
  `release_date` int(10) DEFAULT '0',
  `owner_team` int(10) DEFAULT '0',
  `owner_user` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfieldoptions`
--

CREATE TABLE `[[dbprefix]]customfieldoptions` (
  `value` varchar(200) DEFAULT NULL,
  `customfield_id` int(10) DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `itemtype` varchar(200) DEFAULT NULL,
  `itemdata` varchar(200) DEFAULT NULL,
  `sort_order` int(10) DEFAULT '0',
  `key` varchar(100) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfields`
--

CREATE TABLE `[[dbprefix]]customfields` (
  `description` varchar(200) DEFAULT NULL,
  `instructions` text,
  `name` varchar(200) DEFAULT NULL,
  `itemtype` varchar(200) DEFAULT NULL,
  `itemdata` varchar(200) DEFAULT NULL,
  `sort_order` int(10) DEFAULT '0',
  `key` varchar(100) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dashboards`
--

CREATE TABLE `[[dbprefix]]dashboards` (
  `name` varchar(200) DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT NULL,
  `user_id` int(10) DEFAULT '0',
  `project_id` int(10) DEFAULT '0',
  `team_id` int(10) DEFAULT '0',
  `client_id` int(10) DEFAULT '0',
  `layout` varchar(200) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]dashboards`
--

INSERT INTO `[[dbprefix]]dashboards` VALUES
('', 0, 1, 0, 0, 0, 'main/dashboardlayoutstandard', 1, 1),
('', 0, 2, 0, 0, 0, 'main/dashboardlayoutstandard', 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dashboard_views`
--

CREATE TABLE `[[dbprefix]]dashboard_views` (
  `name` varchar(200) DEFAULT NULL,
  `column` int(2) DEFAULT '0',
  `sort_order` int(10) DEFAULT '0',
  `view` int(10) DEFAULT '0',
  `dashboard_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]dashboard_views`
--

INSERT INTO `[[dbprefix]]dashboard_views` VALUES
('6', 1, 0, 0, 1, 1, 1),
('3', 2, 0, 0, 1, 1, 2),
('6', 1, 0, 0, 2, 1, 3),
('3', 2, 0, 0, 2, 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]editioncomponents`
--

CREATE TABLE `[[dbprefix]]editioncomponents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `edition` int(10) unsigned DEFAULT '0',
  `component` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]editions`
--

CREATE TABLE `[[dbprefix]]editions` (
  `name` varchar(200) DEFAULT NULL,
  `project` int(10) DEFAULT '0',
  `description` varchar(200) DEFAULT NULL,
  `doc_url` varchar(200) DEFAULT NULL,
  `locked` tinyint(1) DEFAULT NULL,
  `leader_team` int(10) DEFAULT '0',
  `leader_user` int(10) DEFAULT '0',
  `qa_responsible_team` int(10) DEFAULT '0',
  `qa_responsible_user` int(10) DEFAULT '0',
  `isreleased` tinyint(1) DEFAULT NULL,
  `release_date` int(10) DEFAULT '0',
  `owner_team` int(10) DEFAULT '0',
  `owner_user` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `content_type` varchar(200) DEFAULT NULL,
  `uploaded_at` int(10) DEFAULT '0',
  `real_filename` varchar(200) DEFAULT NULL,
  `original_filename` varchar(200) DEFAULT NULL,
  `content` longblob,
  `description` varchar(200) DEFAULT NULL,
  `size` varchar(200) DEFAULT NULL,
  `uid` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `name` varchar(200) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
('Administrators', 1, 1),
('Regular users', 1, 2),
('Guests', 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issueaffectsbuild`
--

CREATE TABLE `[[dbprefix]]issueaffectsbuild` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `confirmed` tinyint(1) DEFAULT '0',
  `build` int(10) unsigned DEFAULT '0',
  `issue` int(10) unsigned DEFAULT '0',
  `status` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issueaffectsbuild_issue` (`issue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issueaffectscomponent`
--

CREATE TABLE `[[dbprefix]]issueaffectscomponent` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `confirmed` tinyint(1) DEFAULT '0',
  `component` int(10) unsigned DEFAULT '0',
  `issue` int(10) unsigned DEFAULT '0',
  `status` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issueaffectscomponent_issue` (`issue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issueaffectsedition`
--

CREATE TABLE `[[dbprefix]]issueaffectsedition` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `confirmed` tinyint(1) DEFAULT '0',
  `edition` int(10) unsigned DEFAULT '0',
  `issue` int(10) unsigned DEFAULT '0',
  `status` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issueaffectsedition_issue` (`issue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuecommits`
--

CREATE TABLE `[[dbprefix]]issuecommits` (
  `issue_no` int(10) DEFAULT '0',
  `commit_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issuecommits_commit` (`commit_id`),
  KEY `[[dbprefix]]issuecommits_issue` (`issue_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuecustomfields`
--

CREATE TABLE `[[dbprefix]]issuecustomfields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `issue_id` int(10) unsigned DEFAULT '0',
  `customfields_id` int(10) unsigned DEFAULT '0',
  `customfieldoption_id` int(10) unsigned DEFAULT '0',
  `option_value` text,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issuecustomfields_issueid_scope` (`issue_id`,`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuefields`
--

CREATE TABLE `[[dbprefix]]issuefields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `field_key` varchar(100) DEFAULT NULL,
  `required` tinyint(1) DEFAULT '0',
  `is_reportable` tinyint(1) DEFAULT '0',
  `is_additional` tinyint(1) DEFAULT '0',
  `issuetype_id` int(10) unsigned DEFAULT '0',
  `issuetype_scheme_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issuefields_scope_issuetypescheme_issuetype` (`scope`,`issuetype_scheme_id`,`issuetype_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=141 ;

--
-- Dumping data for table `[[dbprefix]]issuefields`
--

INSERT INTO `[[dbprefix]]issuefields` VALUES
(1, 1, 'description', 1, 1, 0, 1, 1),
(2, 1, 'reproduction_steps', 1, 1, 0, 1, 1),
(3, 1, 'edition', 0, 1, 1, 1, 1),
(4, 1, 'build', 0, 1, 0, 1, 1),
(5, 1, 'component', 0, 1, 0, 1, 1),
(6, 1, 'category', 0, 1, 1, 1, 1),
(7, 1, 'reproducability', 0, 1, 0, 1, 1),
(8, 1, 'resolution', 0, 0, 0, 1, 1),
(9, 1, 'milestone', 0, 0, 0, 1, 1),
(10, 1, 'estimated_time', 0, 0, 0, 1, 1),
(11, 1, 'spent_time', 0, 0, 0, 1, 1),
(12, 1, 'description', 1, 1, 0, 2, 1),
(13, 1, 'category', 0, 1, 1, 2, 1),
(14, 1, 'milestone', 0, 0, 0, 2, 1),
(15, 1, 'estimated_time', 0, 0, 0, 2, 1),
(16, 1, 'spent_time', 0, 0, 0, 2, 1),
(17, 1, 'percent_complete', 0, 0, 0, 2, 1),
(18, 1, 'priority', 0, 0, 0, 2, 1),
(19, 1, 'votes', 0, 0, 0, 2, 1),
(20, 1, 'description', 1, 1, 0, 3, 1),
(21, 1, 'category', 0, 1, 1, 3, 1),
(22, 1, 'milestone', 0, 0, 0, 3, 1),
(23, 1, 'estimated_time', 0, 0, 0, 3, 1),
(24, 1, 'spent_time', 0, 0, 0, 3, 1),
(25, 1, 'percent_complete', 0, 0, 0, 3, 1),
(26, 1, 'priority', 0, 0, 0, 3, 1),
(27, 1, 'description', 1, 1, 0, 4, 1),
(28, 1, 'category', 0, 1, 1, 4, 1),
(29, 1, 'milestone', 0, 0, 0, 4, 1),
(30, 1, 'estimated_time', 0, 0, 0, 4, 1),
(31, 1, 'spent_time', 0, 0, 0, 4, 1),
(32, 1, 'percent_complete', 0, 0, 0, 4, 1),
(33, 1, 'priority', 0, 0, 0, 4, 1),
(34, 1, 'description', 1, 1, 0, 7, 1),
(35, 1, 'category', 0, 1, 1, 7, 1),
(36, 1, 'milestone', 0, 1, 1, 7, 1),
(37, 1, 'estimated_time', 0, 1, 1, 7, 1),
(38, 1, 'spent_time', 0, 0, 0, 7, 1),
(39, 1, 'percent_complete', 0, 0, 0, 7, 1),
(40, 1, 'priority', 0, 0, 0, 7, 1),
(41, 1, 'description', 1, 1, 0, 5, 1),
(42, 1, 'category', 0, 1, 0, 5, 1),
(43, 1, 'milestone', 0, 1, 1, 5, 1),
(44, 1, 'estimated_time', 0, 1, 0, 5, 1),
(45, 1, 'spent_time', 0, 0, 0, 5, 1),
(46, 1, 'percent_complete', 0, 0, 0, 5, 1),
(47, 1, 'priority', 0, 1, 1, 5, 1),
(48, 1, 'shortname', 1, 1, 0, 6, 1),
(49, 1, 'description', 1, 1, 0, 1, 2),
(50, 1, 'reproduction_steps', 0, 1, 0, 1, 2),
(51, 1, 'edition', 0, 0, 0, 1, 2),
(52, 1, 'build', 0, 1, 0, 1, 2),
(53, 1, 'component', 0, 1, 1, 1, 2),
(54, 1, 'category', 0, 1, 0, 1, 2),
(55, 1, 'reproducability', 0, 1, 0, 1, 2),
(56, 1, 'resolution', 0, 0, 0, 1, 2),
(57, 1, 'milestone', 0, 0, 0, 1, 2),
(58, 1, 'estimated_time', 0, 0, 0, 1, 2),
(59, 1, 'spent_time', 0, 0, 0, 1, 2),
(60, 1, 'description', 1, 1, 0, 2, 2),
(61, 1, 'category', 0, 1, 1, 2, 2),
(62, 1, 'milestone', 0, 1, 1, 2, 2),
(63, 1, 'estimated_time', 0, 0, 0, 2, 2),
(64, 1, 'spent_time', 0, 0, 0, 2, 2),
(65, 1, 'percent_complete', 0, 0, 0, 2, 2),
(66, 1, 'priority', 0, 0, 0, 2, 2),
(67, 1, 'votes', 0, 0, 0, 2, 2),
(68, 1, 'description', 1, 1, 0, 4, 2),
(69, 1, 'category', 0, 1, 1, 4, 2),
(70, 1, 'estimated_time', 0, 0, 0, 4, 2),
(71, 1, 'spent_time', 0, 0, 0, 4, 2),
(72, 1, 'priority', 0, 0, 0, 4, 2),
(73, 1, 'description', 1, 1, 0, 7, 2),
(74, 1, 'category', 0, 1, 1, 7, 2),
(75, 1, 'milestone', 0, 0, 0, 7, 2),
(76, 1, 'estimated_time', 0, 0, 0, 7, 2),
(77, 1, 'priority', 0, 0, 0, 7, 2),
(78, 1, 'votes', 0, 0, 0, 7, 2),
(79, 1, 'description', 1, 1, 0, 1, 3),
(80, 1, 'reproduction_steps', 0, 1, 0, 1, 3),
(81, 1, 'edition', 0, 0, 0, 1, 3),
(82, 1, 'build', 0, 1, 0, 1, 3),
(83, 1, 'component', 0, 1, 1, 1, 3),
(84, 1, 'category', 0, 1, 0, 1, 3),
(85, 1, 'reproducability', 0, 1, 0, 1, 3),
(86, 1, 'resolution', 0, 0, 0, 1, 3),
(87, 1, 'milestone', 0, 0, 0, 1, 3),
(88, 1, 'estimated_time', 0, 0, 0, 1, 3),
(89, 1, 'spent_time', 0, 0, 0, 1, 3),
(90, 1, 'description', 1, 1, 0, 2, 3),
(91, 1, 'category', 0, 1, 1, 2, 3),
(92, 1, 'milestone', 0, 1, 1, 2, 3),
(93, 1, 'estimated_time', 0, 0, 0, 2, 3),
(94, 1, 'spent_time', 0, 0, 0, 2, 3),
(95, 1, 'percent_complete', 0, 0, 0, 2, 3),
(96, 1, 'priority', 0, 0, 0, 2, 3),
(97, 1, 'votes', 0, 0, 0, 2, 3),
(98, 1, 'description', 1, 1, 0, 4, 3),
(99, 1, 'category', 0, 1, 1, 4, 3),
(100, 1, 'estimated_time', 0, 0, 0, 4, 3),
(101, 1, 'spent_time', 0, 0, 0, 4, 3),
(102, 1, 'priority', 0, 0, 0, 4, 3),
(103, 1, 'description', 1, 1, 0, 7, 3),
(104, 1, 'category', 0, 1, 1, 7, 3),
(105, 1, 'milestone', 0, 0, 0, 7, 3),
(106, 1, 'estimated_time', 0, 0, 0, 7, 3),
(107, 1, 'priority', 0, 0, 0, 7, 3),
(108, 1, 'votes', 0, 0, 0, 7, 3),
(109, 1, 'description', 1, 1, 0, 5, 3),
(110, 1, 'category', 0, 1, 0, 5, 3),
(111, 1, 'milestone', 0, 1, 1, 5, 3),
(112, 1, 'estimated_time', 0, 1, 0, 5, 3),
(113, 1, 'spent_time', 0, 0, 0, 5, 3),
(114, 1, 'percent_complete', 0, 0, 0, 5, 3),
(115, 1, 'priority', 0, 1, 1, 5, 3),
(116, 1, 'shortname', 1, 1, 0, 6, 3),
(117, 1, 'description', 1, 1, 0, 1, 4),
(118, 1, 'reproduction_steps', 0, 1, 0, 1, 4),
(119, 1, 'build', 0, 1, 0, 1, 4),
(120, 1, 'edition', 0, 0, 0, 1, 4),
(121, 1, 'component', 0, 1, 1, 1, 4),
(122, 1, 'category', 0, 1, 0, 1, 4),
(123, 1, 'reproducability', 0, 1, 0, 1, 4),
(124, 1, 'resolution', 0, 0, 0, 1, 4),
(125, 1, 'milestone', 0, 0, 0, 1, 4),
(126, 1, 'estimated_time', 0, 0, 0, 1, 4),
(127, 1, 'spent_time', 0, 0, 0, 1, 4),
(128, 1, 'description', 1, 1, 0, 2, 4),
(129, 1, 'category', 0, 1, 1, 2, 4),
(130, 1, 'milestone', 0, 1, 1, 2, 4),
(131, 1, 'estimated_time', 0, 0, 0, 2, 4),
(132, 1, 'spent_time', 0, 0, 0, 2, 4),
(133, 1, 'percent_complete', 0, 0, 0, 2, 4),
(134, 1, 'priority', 0, 0, 0, 2, 4),
(135, 1, 'votes', 0, 0, 0, 2, 4),
(136, 1, 'description', 1, 1, 0, 4, 4),
(137, 1, 'category', 0, 1, 1, 4, 4),
(138, 1, 'estimated_time', 0, 0, 0, 4, 4),
(139, 1, 'spent_time', 0, 0, 0, 4, 4),
(140, 1, 'priority', 0, 0, 0, 4, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuefiles`
--

CREATE TABLE `[[dbprefix]]issuefiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `issue_id` int(10) unsigned DEFAULT '0',
  `file_id` int(10) unsigned DEFAULT '0',
  `attached_at` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issuefiles_issueid` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuerelations`
--

CREATE TABLE `[[dbprefix]]issuerelations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `mustfix` tinyint(1) DEFAULT '0',
  `parent_id` int(10) unsigned DEFAULT '0',
  `child_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issues`
--

CREATE TABLE `[[dbprefix]]issues` (
  `name` varchar(255) DEFAULT NULL,
  `shortname` varchar(255) DEFAULT NULL,
  `issue_no` int(10) DEFAULT '0',
  `issuetype` int(10) DEFAULT '0',
  `project_id` int(10) DEFAULT '0',
  `description` text,
  `description_syntax` int(2) DEFAULT '0',
  `reproduction_steps` text,
  `reproduction_steps_syntax` int(2) DEFAULT '0',
  `posted` int(10) DEFAULT '0',
  `last_updated` int(10) DEFAULT '0',
  `posted_by` int(10) DEFAULT '0',
  `assignee_team` int(10) DEFAULT '0',
  `assignee_user` int(10) DEFAULT '0',
  `pain_bug_type` int(3) DEFAULT '0',
  `pain_effect` int(3) DEFAULT '0',
  `pain_likelihood` int(3) DEFAULT '0',
  `user_pain` float DEFAULT NULL,
  `resolution` int(10) DEFAULT '0',
  `state` int(2) DEFAULT '0',
  `category` int(10) DEFAULT '0',
  `status` int(10) DEFAULT '0',
  `priority` int(10) DEFAULT '0',
  `reproducability` int(10) DEFAULT '0',
  `severity` int(10) DEFAULT '0',
  `scrumcolor` varchar(7) DEFAULT NULL,
  `estimated_months` int(10) DEFAULT '0',
  `estimated_weeks` int(10) DEFAULT '0',
  `estimated_days` int(10) DEFAULT '0',
  `estimated_hours` int(10) DEFAULT '0',
  `estimated_minutes` int(10) DEFAULT '0',
  `estimated_points` int(10) DEFAULT '0',
  `spent_months` int(10) DEFAULT '0',
  `spent_weeks` int(10) DEFAULT '0',
  `spent_days` int(10) DEFAULT '0',
  `spent_hours` int(10) DEFAULT '0',
  `spent_minutes` int(10) DEFAULT '0',
  `spent_points` int(10) DEFAULT '0',
  `percent_complete` int(2) DEFAULT '0',
  `being_worked_on_by_user` int(10) DEFAULT '0',
  `being_worked_on_by_user_since` int(10) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT NULL,
  `blocking` tinyint(1) DEFAULT NULL,
  `votes_total` int(10) DEFAULT '0',
  `milestone_order` int(10) DEFAULT '0',
  `duplicate_of` int(10) DEFAULT '0',
  `milestone` int(10) DEFAULT '0',
  `locked` tinyint(1) DEFAULT NULL,
  `locked_category` tinyint(1) DEFAULT NULL,
  `workflow_step_id` int(10) DEFAULT '0',
  `owner_team` int(10) DEFAULT '0',
  `owner_user` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issues_project` (`project_id`),
  KEY `[[dbprefix]]issues_last_updated` (`last_updated`),
  KEY `[[dbprefix]]issues_deleted` (`deleted`),
  KEY `[[dbprefix]]issues_deleted_project` (`deleted`,`project_id`),
  KEY `[[dbprefix]]issues_deleted_state_project` (`deleted`,`state`,`project_id`),
  KEY `[[dbprefix]]issues_deleted_project_issueno` (`deleted`,`issue_no`,`project_id`),
  KEY `[[dbprefix]]issues_duplicateof` (`duplicate_of`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuetags`
--

CREATE TABLE `[[dbprefix]]issuetags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `issue_id` int(10) unsigned DEFAULT '0',
  `tag_name` varchar(50) DEFAULT NULL,
  `added` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuetypes`
--

CREATE TABLE `[[dbprefix]]issuetypes` (
  `name` varchar(200) DEFAULT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `description` text,
  `key` varchar(100) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]issuetypes`
--

INSERT INTO `[[dbprefix]]issuetypes` VALUES
('Bug report', 'bug_report', 'Have you discovered a bug in the application, or is something not working as expected?', 'bugreport', 1, 1),
('Feature request', 'feature_request', 'Are you missing some specific feature, or is your favourite part of the application a bit lacking?', 'featurerequest', 1, 2),
('Enhancement', 'enhancement', 'Have you found something that is working in a way that could be improved?', 'enhancement', 1, 3),
('Task', 'task', '', 'task', 1, 4),
('User story', 'developer_report', 'Doing it Agile-style. Issue type perfectly suited for entering user stories', 'userstory', 1, 5),
('Epic', 'epic', 'Issue type suited for entering epics', 'epic', 1, 6),
('Idea', 'idea', 'Express yourself - share your ideas with the rest of the team!', 'idea', 1, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuetype_schemes`
--

CREATE TABLE `[[dbprefix]]issuetype_schemes` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]issuetype_schemes`
--

INSERT INTO `[[dbprefix]]issuetype_schemes` VALUES
('Full range issue type scheme', 'This issuetype scheme enables a broad range of issue types. It is especially useful for projects with many different types of issues', 1, 1),
('Balanced issue type scheme', 'This issuetype scheme enables a variety of issue types. This is useful for most medium / small-sized projects', 1, 2),
('Balanced issue type scheme (agile)', 'This issuetype scheme enables a variety of issue types, including epics and stories. This is useful for most medium / small-sized agile projects', 1, 3),
('Simple issue type scheme', 'This issuetype scheme enables a minimum number of issue types. This is useful for small-sized / one-person projects', 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issuetype_scheme_link`
--

CREATE TABLE `[[dbprefix]]issuetype_scheme_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `issuetype_scheme_id` int(10) unsigned DEFAULT '0',
  `issuetype_id` int(10) unsigned DEFAULT '0',
  `reportable` tinyint(1) DEFAULT '1',
  `redirect_after_reporting` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]issuetype_scheme_link_issuetypescheme_scope` (`issuetype_scheme_id`,`scope`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]issuetype_scheme_link`
--

INSERT INTO `[[dbprefix]]issuetype_scheme_link` VALUES
(1, 1, 1, 1, 1, 1),
(2, 1, 1, 2, 1, 1),
(3, 1, 1, 3, 1, 1),
(4, 1, 1, 4, 0, 1),
(5, 1, 1, 5, 0, 1),
(6, 1, 1, 6, 0, 1),
(7, 1, 1, 7, 1, 1),
(8, 1, 2, 1, 1, 1),
(9, 1, 2, 2, 1, 1),
(10, 1, 2, 4, 1, 1),
(11, 1, 2, 7, 1, 1),
(12, 1, 3, 1, 1, 1),
(13, 1, 3, 2, 1, 1),
(14, 1, 3, 4, 1, 1),
(15, 1, 3, 5, 0, 1),
(16, 1, 3, 6, 0, 1),
(17, 1, 4, 1, 1, 1),
(18, 1, 4, 2, 1, 1),
(19, 1, 4, 4, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issue_estimates`
--

CREATE TABLE `[[dbprefix]]issue_estimates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `issue_id` int(10) unsigned DEFAULT '0',
  `edited_by` int(10) unsigned DEFAULT '0',
  `edited_at` int(10) DEFAULT '0',
  `estimated_months` int(10) DEFAULT '0',
  `estimated_weeks` int(10) DEFAULT '0',
  `estimated_days` int(10) DEFAULT '0',
  `estimated_hours` int(10) DEFAULT '0',
  `estimated_minutes` int(10) DEFAULT '0',
  `estimated_points` float DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issue_spenttimes`
--

CREATE TABLE `[[dbprefix]]issue_spenttimes` (
  `issue_id` int(10) DEFAULT '0',
  `edited_by` int(10) DEFAULT '0',
  `activity_type` int(10) DEFAULT '0',
  `edited_at` int(10) DEFAULT '0',
  `spent_months` int(10) DEFAULT '0',
  `spent_weeks` int(10) DEFAULT '0',
  `spent_days` int(10) DEFAULT '0',
  `spent_hours` int(10) DEFAULT '0',
  `spent_minutes` int(10) DEFAULT '0',
  `spent_points` int(10) DEFAULT '0',
  `comment` text,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]links`
--

CREATE TABLE `[[dbprefix]]links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `url` varchar(300) DEFAULT NULL,
  `link_order` int(3) DEFAULT '0',
  `target_type` varchar(30) DEFAULT NULL,
  `target_id` int(10) DEFAULT '0',
  `description` varchar(100) DEFAULT '',
  `uid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]links_targettype_targetid_scope` (`target_type`,`target_id`,`scope`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]links`
--

INSERT INTO `[[dbprefix]]links` VALUES
(1, 1, 'https://thebuggenie.com', 1, 'main_menu', 0, 'The Bug Genie homepage', 0),
(2, 1, NULL, 2, 'main_menu', 0, NULL, 0),
(3, 1, 'https://issues.thebuggenie.com', 4, 'main_menu', 0, 'Online issue tracker', 0),
(4, 1, '', 5, 'main_menu', 0, '''''This is the issue tracker for The Bug Genie''''', 0),
(5, 1, 'MainPage', 1, 'wiki', 0, 'Wiki Frontpage', 0),
(6, 1, 'WikiFormatting', 2, 'wiki', 0, 'Formatting help', 0),
(7, 1, 'Category:Help', 3, 'wiki', 0, 'Help topics', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]listtypes`
--

CREATE TABLE `[[dbprefix]]listtypes` (
  `name` varchar(200) DEFAULT NULL,
  `itemtype` varchar(200) DEFAULT NULL,
  `itemdata` varchar(200) DEFAULT NULL,
  `sort_order` int(10) DEFAULT '0',
  `key` varchar(100) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]listtypes_scope` (`scope`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=52 ;

--
-- Dumping data for table `[[dbprefix]]listtypes`
--

INSERT INTO `[[dbprefix]]listtypes` VALUES
('General', 'category', '#FFFFFF', 0, 'general', 1, 1),
('Security', 'category', '#C2F533', 0, 'security', 1, 2),
('User interface', 'category', '#55CC55', 0, 'userinterface', 1, 3),
('Critical', 'priority', '1', 0, 'critical', 1, 4),
('High', 'priority', '2', 0, 'high', 1, 5),
('Normal', 'priority', '3', 0, 'normal', 1, 6),
('Low', 'priority', '4', 0, 'low', 1, 7),
('Trivial', 'priority', '5', 0, 'trivial', 1, 8),
('Can''t reproduce', 'reproducability', '', 0, 'cantreproduce', 1, 9),
('Rarely', 'reproducability', '', 0, 'rarely', 1, 10),
('Often', 'reproducability', '', 0, 'often', 1, 11),
('Always', 'reproducability', '', 0, 'always', 1, 12),
('CAN''T REPRODUCE', 'resolution', '', 0, 'cantreproduce', 1, 13),
('WON''T FIX', 'resolution', '', 0, 'wontfix', 1, 14),
('NOT AN ISSUE', 'resolution', '', 0, 'notanissue', 1, 15),
('POSTPONED', 'resolution', '', 0, 'postponed', 1, 16),
('RESOLVED', 'resolution', '', 0, 'resolved', 1, 17),
('CAN''T FIX', 'resolution', '', 0, 'cantfix', 1, 18),
('DUPLICATE', 'resolution', '', 0, 'duplicate', 1, 19),
('Low', 'severity', '', 0, 'low', 1, 20),
('Normal', 'severity', '', 0, 'normal', 1, 21),
('Critical', 'severity', '', 0, 'critical', 1, 22),
('New', 'status', '#FFFFFF', 0, 'new', 1, 23),
('Investigating', 'status', '#C2F533', 0, 'investigating', 1, 24),
('Confirmed', 'status', '#FF55AA', 0, 'confirmed', 1, 25),
('Not a bug', 'status', '#44FC1D', 0, 'notabug', 1, 26),
('Being worked on', 'status', '#55CC55', 0, 'beingworkedon', 1, 27),
('Near completion', 'status', '#77DD33', 0, 'nearcompletion', 1, 28),
('Ready for testing / QA', 'status', '#5555CC', 0, 'readyfortestingqa', 1, 29),
('Testing / QA', 'status', '#7777CC', 0, 'testingqa', 1, 30),
('Closed', 'status', '#C2F588', 0, 'closed', 1, 31),
('Postponed', 'status', '#FFAA55', 0, 'postponed', 1, 32),
('Done', 'status', '#77DD33', 0, 'done', 1, 33),
('Fixed', 'status', '#55CC55', 0, 'fixed', 1, 34),
('Developer', 'role', '', 0, 'developer', 1, 35),
('Project manager', 'role', '', 0, 'projectmanager', 1, 36),
('Tester', 'role', '', 0, 'tester', 1, 37),
('Documentation editor', 'role', '', 0, 'documentationeditor', 1, 38),
('Investigation', 'activitytype', '', 0, 'investigation', 1, 39),
('Documentation', 'activitytype', '', 0, 'documentation', 1, 40),
('Development', 'activitytype', '', 0, 'development', 1, 41),
('Testing', 'activitytype', '', 0, 'testing', 1, 42),
('Deployment', 'activitytype', '', 0, 'deployment', 1, 43),
('In progress', 'status', '', 0, 'inprogress', 1, 44),
('Ready to test', 'status', '', 0, 'readytotest', 1, 45),
('Resolved', 'status', '', 0, 'resolved', 1, 46),
('Reopened', 'status', '', 0, 'reopened', 1, 47),
('Open', 'status', '', 0, 'open', 1, 48),
('In progress', 'status', '', 0, 'inprogress', 1, 49),
('Resolved', 'status', '', 0, 'resolved', 1, 50),
('Reopened', 'status', '', 0, 'reopened', 1, 51);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]livelink_imports`
--

CREATE TABLE `[[dbprefix]]livelink_imports` (
  `user_id` int(10) DEFAULT '0',
  `project_id` int(10) DEFAULT '0',
  `created_at` int(10) DEFAULT '0',
  `completed_at` int(10) DEFAULT '0',
  `data` varchar(1000) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `target` int(10) DEFAULT '0',
  `target_type` int(10) DEFAULT '0',
  `change_type` int(10) DEFAULT '0',
  `previous_value` text,
  `current_value` text,
  `text` text,
  `time` int(10) DEFAULT '0',
  `uid` int(10) DEFAULT '0',
  `comment_id` int(10) DEFAULT '0',
  `project_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]log_commentid` (`comment_id`),
  KEY `[[dbprefix]]log_targettype_time` (`target_type`,`time`),
  KEY `[[dbprefix]]log_targettype_changetype` (`target_type`,`change_type`),
  KEY `[[dbprefix]]log_target_uid_commentid_scope` (`target`,`uid`,`comment_id`,`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailing_incoming_email_account`
--

CREATE TABLE `[[dbprefix]]mailing_incoming_email_account` (
  `name` varchar(200) DEFAULT NULL,
  `server` varchar(200) DEFAULT NULL,
  `port` int(10) DEFAULT '0',
  `folder` varchar(200) DEFAULT NULL,
  `server_type` int(10) DEFAULT '0',
  `ssl` tinyint(1) DEFAULT NULL,
  `ignore_certificate_validation` tinyint(1) DEFAULT NULL,
  `prefer_html` tinyint(1) DEFAULT NULL,
  `plaintext_authentication` tinyint(1) DEFAULT NULL,
  `keep_email` tinyint(1) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `project` int(10) DEFAULT '0',
  `issuetype` int(10) DEFAULT '0',
  `num_last_fetched` int(10) DEFAULT '0',
  `time_last_fetched` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailing_queue`
--

CREATE TABLE `[[dbprefix]]mailing_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `from` varchar(255) DEFAULT NULL,
  `to` text,
  `headers` text,
  `part` text,
  `date` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]milestones`
--

CREATE TABLE `[[dbprefix]]milestones` (
  `project` int(10) DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `itemtype` varchar(200) DEFAULT NULL,
  `closed` tinyint(1) DEFAULT NULL,
  `reacheddate` int(10) DEFAULT '0',
  `scheduleddate` int(10) DEFAULT '0',
  `startingdate` int(10) DEFAULT '0',
  `visible_roadmap` tinyint(1) DEFAULT NULL,
  `visible_issues` tinyint(1) DEFAULT NULL,
  `description` text,
  `sort_order` int(10) DEFAULT '0',
  `percentage_type` varchar(200) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `name` varchar(200) DEFAULT NULL,
  `classname` varchar(100) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
('publish', NULL, 1, '2.0', 1, 1),
('agile', NULL, 1, '1.0', 1, 2),
('mailing', NULL, 1, '2.0.1', 1, 3),
('vcs_integration', NULL, 1, '2.0.1', 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `target_id` int(10) DEFAULT '0',
  `notification_type` varchar(100) DEFAULT NULL,
  `module_name` varchar(50) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `created_at` int(10) DEFAULT '0',
  `triggered_by_user_id` int(10) DEFAULT '0',
  `user_id` int(10) DEFAULT '0',
  `shown_at` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]notifications_userid_targetid_notificationtype_scope` (`user_id`,`target_id`,`notification_type`,`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notificationsettings`
--

CREATE TABLE `[[dbprefix]]notificationsettings` (
  `module_name` varchar(50) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `value` varchar(100) DEFAULT NULL,
  `user_id` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `permission_type` varchar(100) DEFAULT NULL,
  `target_id` varchar(200) DEFAULT '0',
  `allowed` tinyint(1) DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `uid` int(10) unsigned DEFAULT '0',
  `gid` int(10) unsigned DEFAULT '0',
  `tid` int(10) unsigned DEFAULT '0',
  `role_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]permissions_scope` (`scope`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=50 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 1, 'cancreatepublicsearches', '0', 0, 'core', 0, 0, 0, 0),
(2, 1, 'page_home_access', '0', 1, 'core', 0, 0, 0, 0),
(3, 1, 'page_about_access', '0', 1, 'core', 0, 0, 0, 0),
(4, 1, 'page_search_access', '0', 1, 'core', 0, 0, 0, 0),
(5, 1, 'page_confirm_scope_access', '0', 1, 'core', 0, 0, 0, 0),
(6, 1, 'canfindissues', '0', 1, 'core', 0, 0, 0, 0),
(7, 1, 'canfindissuesandsavesearches', '0', 1, 'core', 0, 0, 0, 0),
(8, 1, 'canfindissuesandsavesearches', '0', 0, 'core', 0, 3, 0, 0),
(9, 1, 'page_account_access', '0', 1, 'core', 0, 0, 0, 0),
(10, 1, 'page_account_access', '0', 0, 'core', 0, 3, 0, 0),
(11, 1, 'page_dashboard_access', '0', 1, 'core', 0, 0, 0, 0),
(12, 1, 'page_dashboard_access', '0', 0, 'core', 0, 3, 0, 0),
(13, 1, 'canaddextrainformationtoissues', '0', 1, 'core', 0, 1, 0, 0),
(14, 1, 'cancreateandeditissues', '0', 1, 'core', 0, 1, 0, 0),
(15, 1, 'cancreatepublicsearches', '0', 1, 'core', 0, 1, 0, 0),
(16, 1, 'candeleteissues', '0', 1, 'core', 0, 1, 0, 0),
(17, 1, 'candoscrumplanning', '0', 1, 'core', 0, 1, 0, 0),
(18, 1, 'caneditissue', '0', 1, 'core', 0, 1, 0, 0),
(19, 1, 'caneditissuecustomfields', '0', 1, 'core', 0, 1, 0, 0),
(20, 1, 'caneditmainmenu', '0', 1, 'core', 0, 1, 0, 0),
(21, 1, 'canfindissues', '0', 1, 'core', 0, 1, 0, 0),
(22, 1, 'canfindissuesandsavesearches', '0', 1, 'core', 0, 1, 0, 0),
(23, 1, 'canlockandeditlockedissues', '0', 1, 'core', 0, 1, 0, 0),
(24, 1, 'canpostseeandeditallcomments', '0', 1, 'core', 0, 1, 0, 0),
(25, 1, 'canpostseeandeditallcomments', '0', 1, 'core', 0, 1, 0, 0),
(26, 1, 'cansaveconfig', '0', 1, 'core', 0, 1, 0, 0),
(27, 1, 'canseeproject', '0', 1, 'core', 0, 1, 0, 0),
(28, 1, 'canseetimespent', '0', 1, 'core', 0, 1, 0, 0),
(29, 1, 'canvoteforissues', '0', 1, 'core', 0, 1, 0, 0),
(30, 1, 'page_about_access', '0', 1, 'core', 0, 1, 0, 0),
(31, 1, 'page_account_access', '0', 1, 'core', 0, 1, 0, 0),
(32, 1, 'page_clientlist_access', '0', 1, 'core', 0, 1, 0, 0),
(33, 1, 'page_confirm_scope_access', '0', 1, 'core', 0, 1, 0, 0),
(34, 1, 'page_dashboard_access', '0', 1, 'core', 0, 1, 0, 0),
(35, 1, 'page_home_access', '0', 1, 'core', 0, 1, 0, 0),
(36, 1, 'page_project_allpages_access', '0', 1, 'core', 0, 1, 0, 0),
(37, 1, 'page_search_access', '0', 1, 'core', 0, 1, 0, 0),
(38, 1, 'page_teamlist_access', '0', 1, 'core', 0, 1, 0, 0),
(39, 1, 'set_datatype_status', '0', 1, 'core', 0, 0, 0, 0),
(40, 1, 'set_datatype_priority', '0', 1, 'core', 0, 0, 0, 0),
(41, 1, 'set_datatype_category', '0', 1, 'core', 0, 0, 0, 0),
(42, 1, 'set_datatype_severity', '0', 1, 'core', 0, 0, 0, 0),
(43, 1, 'set_datatype_reproducability', '0', 1, 'core', 0, 0, 0, 0),
(44, 1, 'set_datatype_resolution', '0', 1, 'core', 0, 0, 0, 0),
(45, 1, 'set_datatype_activitytype', '0', 1, 'core', 0, 0, 0, 0),
(46, 1, 'article_management', '0', 1, 'publish', 0, 1, 0, 0),
(47, 1, 'readarticle', '0', 1, 'publish', 0, 1, 0, 0),
(48, 1, 'editarticle', '0', 1, 'publish', 0, 1, 0, 0),
(49, 1, 'deletearticle', '0', 1, 'publish', 0, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projectassignedteams`
--

CREATE TABLE `[[dbprefix]]projectassignedteams` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `project_id` int(10) unsigned DEFAULT '0',
  `role_id` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projectassignedusers`
--

CREATE TABLE `[[dbprefix]]projectassignedusers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `project_id` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `role_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projects`
--

CREATE TABLE `[[dbprefix]]projects` (
  `name` varchar(200) DEFAULT NULL,
  `prefix` varchar(25) DEFAULT NULL,
  `use_prefix` tinyint(1) DEFAULT NULL,
  `locked` tinyint(1) DEFAULT NULL,
  `issues_lock_type` int(10) DEFAULT '0',
  `use_scrum` tinyint(1) DEFAULT NULL,
  `enable_builds` tinyint(1) DEFAULT NULL,
  `enable_editions` tinyint(1) DEFAULT NULL,
  `enable_components` tinyint(1) DEFAULT NULL,
  `key` varchar(200) DEFAULT NULL,
  `homepage` varchar(200) DEFAULT NULL,
  `small_icon` int(10) DEFAULT '0',
  `large_icon` int(10) DEFAULT '0',
  `doc_url` varchar(200) DEFAULT NULL,
  `wiki_url` varchar(200) DEFAULT NULL,
  `description` text,
  `show_in_summary` tinyint(1) DEFAULT NULL,
  `summary_display` varchar(15) DEFAULT NULL,
  `allow_freelancing` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `workflow_scheme_id` int(10) DEFAULT '0',
  `issuetype_scheme_id` int(10) DEFAULT '0',
  `client` int(10) DEFAULT '0',
  `autoassign` tinyint(1) DEFAULT NULL,
  `parent` int(10) DEFAULT '0',
  `has_downloads` tinyint(1) DEFAULT NULL,
  `archived` tinyint(1) DEFAULT NULL,
  `time_units` int(10) DEFAULT '0',
  `leader_team` int(10) DEFAULT '0',
  `leader_user` int(10) DEFAULT '0',
  `qa_responsible_team` int(10) DEFAULT '0',
  `qa_responsible_user` int(10) DEFAULT '0',
  `isreleased` tinyint(1) DEFAULT NULL,
  `release_date` int(10) DEFAULT '0',
  `owner_team` int(10) DEFAULT '0',
  `owner_user` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]projects_scope` (`scope`),
  KEY `[[dbprefix]]projects_scope_name` (`scope`,`name`),
  KEY `[[dbprefix]]projects_workflow_scheme_id` (`workflow_scheme_id`),
  KEY `[[dbprefix]]projects_issuetype_scheme_id` (`issuetype_scheme_id`),
  KEY `[[dbprefix]]projects_parent` (`parent`),
  KEY `[[dbprefix]]projects_parent_scope` (`parent`,`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rolepermissions`
--

CREATE TABLE `[[dbprefix]]rolepermissions` (
  `module` varchar(100) DEFAULT NULL,
  `target_id` varchar(250) DEFAULT NULL,
  `permission` varchar(250) DEFAULT NULL,
  `role_id` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]rolepermissions_role_id` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=50 ;

--
-- Dumping data for table `[[dbprefix]]rolepermissions`
--

INSERT INTO `[[dbprefix]]rolepermissions` VALUES
('core', '', 'page_project_allpages_access', 35, 1),
('core', '', 'canseeproject', 35, 2),
('core', '', 'canseeprojecthierarchy', 35, 3),
('core', '', 'canvoteforissues', 35, 4),
('core', '', 'canseetimespent', 35, 5),
('core', '', 'canlockandeditlockedissues', 35, 6),
('core', '', 'cancreateandeditissues', 35, 7),
('core', '', 'caneditissue', 35, 8),
('core', '', 'caneditissuecustomfields', 35, 9),
('core', '', 'canaddextrainformationtoissues', 35, 10),
('core', '', 'canpostseeandeditallcomments', 35, 11),
('publish', '%project_key%', 'readarticle', 35, 12),
('publish', '%project_key%', 'editarticle', 35, 13),
('publish', '%project_key%', 'deletearticle', 35, 14),
('core', '', 'page_project_allpages_access', 36, 15),
('core', '', 'canseeproject', 36, 16),
('core', '', 'canseeprojecthierarchy', 36, 17),
('core', '', 'canvoteforissues', 36, 18),
('core', '', 'canseetimespent', 36, 19),
('core', '', 'canlockandeditlockedissues', 36, 20),
('core', '', 'cancreateandeditissues', 36, 21),
('core', '', 'caneditissue', 36, 22),
('core', '', 'caneditissuecustomfields', 36, 23),
('core', '', 'canaddextrainformationtoissues', 36, 24),
('core', '', 'canpostseeandeditallcomments', 36, 25),
('publish', '%project_key%', 'readarticle', 36, 26),
('publish', '%project_key%', 'editarticle', 36, 27),
('publish', '%project_key%', 'deletearticle', 36, 28),
('core', '', 'page_project_allpages_access', 37, 29),
('core', '', 'canseeproject', 37, 30),
('core', '', 'canseeprojecthierarchy', 37, 31),
('core', '', 'canvoteforissues', 37, 32),
('core', '', 'canseetimespent', 37, 33),
('core', '', 'cancreateandeditissues', 37, 34),
('core', '', 'caneditissuecustomfields', 37, 35),
('core', '', 'canaddextrainformationtoissues', 37, 36),
('core', '', 'canpostandeditcomments', 37, 37),
('publish', '%project_key%', 'readarticle', 37, 38),
('publish', '%project_key%', 'editarticle', 37, 39),
('core', '', 'page_project_allpages_access', 38, 40),
('core', '', 'canseeproject', 38, 41),
('core', '', 'canseeprojecthierarchy', 38, 42),
('core', '', 'canvoteforissues', 38, 43),
('core', '', 'canseetimespent', 38, 44),
('core', '', 'cancreateandeditissues', 38, 45),
('core', '', 'canaddextrainformationtoissues', 38, 46),
('core', '', 'canpostandeditcomments', 38, 47),
('publish', '%project_key%', 'readarticle', 38, 48),
('publish', '%project_key%', 'editarticle', 38, 49);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]savedsearches`
--

CREATE TABLE `[[dbprefix]]savedsearches` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `templatename` varchar(200) DEFAULT NULL,
  `templateparameter` varchar(200) DEFAULT NULL,
  `issues_per_page` int(10) DEFAULT '0',
  `sortfields` varchar(400) DEFAULT NULL,
  `columns` varchar(600) DEFAULT NULL,
  `groupby` varchar(100) DEFAULT NULL,
  `grouporder` varchar(5) DEFAULT NULL,
  `applies_to_project` int(10) DEFAULT '0',
  `uid` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]savedsearchfilters`
--

CREATE TABLE `[[dbprefix]]savedsearchfilters` (
  `value` varchar(200) DEFAULT NULL,
  `operator` varchar(40) DEFAULT NULL,
  `filter_key` varchar(100) DEFAULT NULL,
  `search_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scopehostnames`
--

CREATE TABLE `[[dbprefix]]scopehostnames` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope_id` int(10) unsigned DEFAULT '0',
  `hostname` varchar(200) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scopehostnames_id_hostname` (`id`,`hostname`),
  KEY `[[dbprefix]]scopehostnames_scopeid_hostname` (`scope_id`,`hostname`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]scopehostnames`
--

INSERT INTO `[[dbprefix]]scopehostnames` VALUES
(1, 1, '*');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scopes`
--

CREATE TABLE `[[dbprefix]]scopes` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `uploads_enabled` tinyint(1) DEFAULT NULL,
  `max_upload_limit` int(10) DEFAULT '0',
  `custom_workflows_enabled` tinyint(1) DEFAULT NULL,
  `max_workflows` int(10) DEFAULT '0',
  `max_users` int(10) DEFAULT '0',
  `max_projects` int(10) DEFAULT '0',
  `max_teams` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]scopes`
--

INSERT INTO `[[dbprefix]]scopes` VALUES
('The default scope', '', 1, 1, 0, 1, 0, 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `name` varchar(45) DEFAULT NULL,
  `module` varchar(45) DEFAULT NULL,
  `value` varchar(200) DEFAULT NULL,
  `uid` int(10) DEFAULT '0',
  `updated_at` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]settings_scope_uid` (`scope`,`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 1, 'theme_name', 'core', 'oxygen', 0, [[timestamp]]),
(2, 1, 'requirelogin', 'core', '0', 0, [[timestamp]]),
(3, 1, 'defaultisguest', 'core', '1', 0, [[timestamp]]),
(4, 1, 'allowreg', 'core', '1', 0, [[timestamp]]),
(5, 1, 'returnfromlogin', 'core', 'referer', 0, [[timestamp]]),
(6, 1, 'returnfromlogout', 'core', 'home', 0, [[timestamp]]),
(7, 1, 'showprojectsoverview', 'core', '1', 0, [[timestamp]]),
(8, 1, 'userthemes', 'core', '0', 0, [[timestamp]]),
(9, 1, 'enable_uploads', 'core', '0', 0, [[timestamp]]),
(10, 1, 'enable_gravatars', 'core', '1', 0, [[timestamp]]),
(11, 1, 'upload_restriction_mode', 'core', 'blacklist', 0, [[timestamp]]),
(12, 1, 'upload_extensions_list', 'core', 'exe,bat,php,asp,jsp', 0, [[timestamp]]),
(13, 1, 'upload_storage', 'core', 'files', 0, [[timestamp]]),
(14, 1, 'upload_localpath', 'core', '[[softpath]]/files/', 0, [[timestamp]]),
(15, 1, 'upload_allow_image_caching', 'core', '0', 0, [[timestamp]]),
(16, 1, 'upload_delivery_use_xsend', 'core', '0', 0, [[timestamp]]),
(17, 1, 'b2_name', 'core', 'The Bug Genie', 0, [[timestamp]]),
(18, 1, 'highlight_default_lang', 'core', 'html', 0, [[timestamp]]),
(19, 1, 'highlight_default_numbering', 'core', '3', 0, [[timestamp]]),
(20, 1, 'highlight_default_interval', 'core', '10', 0, [[timestamp]]),
(21, 1, 'iconset', 'core', 'oxygen', 0, [[timestamp]]),
(22, 1, 'server_timezone', 'core', 'UTC', 0, [[timestamp]]),
(23, 1, 'elevatedlogindisabled', 'core', '1', 0, [[timestamp]]),
(24, 1, 'admingroup', 'core', '1', 0, [[timestamp]]),
(25, 1, 'defaultgroup', 'core', '2', 0, [[timestamp]]),
(26, 1, 'defaultuserid', 'core', '2', 0, [[timestamp]]),
(27, 1, 'onlinestate', 'core', '1', 0, [[timestamp]]),
(28, 1, 'offlinestate', 'core', '2', 0, [[timestamp]]),
(29, 1, 'awaystate', 'core', '7', 0, [[timestamp]]),
(30, 1, 'issuetype_bug_report', 'core', '1', 0, [[timestamp]]),
(31, 1, 'issuetype_feature_request', 'core', '2', 0, [[timestamp]]),
(32, 1, 'issuetype_enhancement', 'core', '3', 0, [[timestamp]]),
(33, 1, 'issuetype_task', 'core', '4', 0, [[timestamp]]),
(34, 1, 'issuetype_user_story', 'core', '5', 0, [[timestamp]]),
(35, 1, 'issuetype_epic', 'core', '6', 0, [[timestamp]]),
(36, 1, 'issuetype_idea', 'core', '7', 0, [[timestamp]]),
(37, 1, 'full_range_issuetype_scheme', 'core', '1', 0, [[timestamp]]),
(38, 1, 'balanced_issuetype_scheme', 'core', '2', 0, [[timestamp]]),
(39, 1, 'balanced_agile_issuetype_scheme', 'core', '3', 0, [[timestamp]]),
(40, 1, 'simple_issuetype_scheme', 'core', '4', 0, [[timestamp]]),
(41, 1, 'multi_team_workflow_scheme', 'core', '1', 0, [[timestamp]]),
(42, 1, 'balanced_workflow_scheme', 'core', '2', 0, [[timestamp]]),
(43, 1, 'simple_workflow_scheme', 'core', '3', 0, [[timestamp]]),
(44, 1, 'language', 'core', 'en_US', 0, [[timestamp]]),
(45, 1, 'allow_camelcase_links', 'publish', '1', 0, [[timestamp]]),
(46, 1, 'require_change_reason', 'publish', '0', 0, [[timestamp]]),
(47, 1, 'smtp_host', 'mailing', '', 0, [[timestamp]]),
(48, 1, 'smtp_port', 'mailing', '25', 0, [[timestamp]]),
(49, 1, 'smtp_user', 'mailing', '', 0, [[timestamp]]),
(50, 1, 'smtp_pwd', 'mailing', '', 0, [[timestamp]]),
(51, 1, 'headcharset', 'mailing', 'utf-8', 0, [[timestamp]]),
(52, 1, 'from_name', 'mailing', 'The Bug Genie Automailer', 0, [[timestamp]]),
(53, 1, 'from_addr', 'mailing', '', 0, [[timestamp]]),
(54, 1, 'ehlo', 'mailing', '1', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]teammembers`
--

CREATE TABLE `[[dbprefix]]teammembers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `tid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]teammembers_scope_uid` (`uid`,`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]teams`
--

CREATE TABLE `[[dbprefix]]teams` (
  `name` varchar(200) DEFAULT NULL,
  `ondemand` tinyint(1) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]teams_scope_ondemand` (`scope`,`ondemand`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]teams`
--

INSERT INTO `[[dbprefix]]teams` VALUES
('Staff members', 0, 1, 1),
('Developers', 0, 1, 2),
('Team leaders', 0, 1, 3),
('Testers', 0, 1, 4),
('Translators', 0, 1, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userarticles`
--

CREATE TABLE `[[dbprefix]]userarticles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `article` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userissues`
--

CREATE TABLE `[[dbprefix]]userissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `issue` int(10) unsigned DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userissues_uid_scope` (`uid`,`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `realname` varchar(200) DEFAULT NULL,
  `buddyname` varchar(200) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `private_email` tinyint(1) DEFAULT NULL,
  `userstate` int(10) DEFAULT '0',
  `customstate` tinyint(1) DEFAULT NULL,
  `homepage` varchar(200) DEFAULT NULL,
  `language` varchar(20) DEFAULT NULL,
  `avatar` varchar(200) DEFAULT NULL,
  `use_gravatar` tinyint(1) DEFAULT NULL,
  `lastseen` int(10) DEFAULT '0',
  `timezone` varchar(100) DEFAULT NULL,
  `quota` int(10) DEFAULT '0',
  `joined` int(10) DEFAULT '0',
  `enabled` tinyint(1) DEFAULT NULL,
  `openid_locked` tinyint(1) DEFAULT NULL,
  `activated` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `preferred_issues_syntax` int(3) DEFAULT '0',
  `preferred_wiki_syntax` int(3) DEFAULT '0',
  `preferred_comments_syntax` int(3) DEFAULT '0',
  `prefer_wiki_markdown` tinyint(1) DEFAULT NULL,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]users_userstate` (`userstate`),
  KEY `[[dbprefix]]users_username_password` (`username`,`password`),
  KEY `[[dbprefix]]users_username_deleted` (`username`,`deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
('[[admin_username]]', '[[admin_pass]]', '[[admin_fname]] [[admin_lname]]', 'Admin', '[[admin_email]]', 1, 0, 0, '', '', 'admin', 1, 0, '', 0, [[timestamp]], 1, 0, 1, 0, 2, 1, 2, 0, 1),
('guest', '$2y$10$JpDcyXvBMkXdr5a7UBREeurrQKlR4w.WNuq0KtNcZlBYMfDzJfk46', 'Guest user', 'Guest user', '', 1, 0, 0, '', '', '', 1, 0, '', 0, [[timestamp]], 1, 0, 1, 0, 2, 1, 2, 0, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userscopes`
--

CREATE TABLE `[[dbprefix]]userscopes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `confirmed` tinyint(1) DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT '0',
  `group_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userscopes_uid_scope` (`user_id`,`scope`),
  KEY `[[dbprefix]]userscopes_groupid_scope` (`group_id`,`scope`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]userscopes`
--

INSERT INTO `[[dbprefix]]userscopes` VALUES
(1, 1, 1, 1, 1),
(2, 1, 1, 2, 3),
(3, 1, 1, 2, 3),
(4, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usersession`
--

CREATE TABLE `[[dbprefix]]usersession` (
  `name` varchar(200) DEFAULT NULL,
  `token` varchar(200) DEFAULT NULL,
  `created_at` int(10) DEFAULT '0',
  `last_used_at` int(10) DEFAULT '0',
  `is_elevated` tinyint(1) DEFAULT NULL,
  `expires_at` int(10) DEFAULT '0',
  `user_id` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userstate`
--

CREATE TABLE `[[dbprefix]]userstate` (
  `name` varchar(200) DEFAULT NULL,
  `is_online` tinyint(1) DEFAULT NULL,
  `is_unavailable` tinyint(1) DEFAULT NULL,
  `is_busy` tinyint(1) DEFAULT NULL,
  `is_in_meeting` tinyint(1) DEFAULT NULL,
  `is_absent` tinyint(1) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]userstate`
--

INSERT INTO `[[dbprefix]]userstate` VALUES
('Available', 1, 0, 0, 0, 0, 1, 1),
('Offline', 0, 1, 0, 0, 0, 1, 2),
('Busy', 1, 1, 0, 0, 0, 1, 3),
('Unavailable', 1, 1, 0, 0, 0, 1, 4),
('In a meeting', 0, 1, 0, 1, 0, 1, 5),
('Coding', 1, 1, 1, 0, 0, 1, 6),
('Away', 1, 1, 1, 0, 1, 1, 7),
('On vacation', 0, 1, 1, 0, 1, 1, 8);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vcsintegration_commits`
--

CREATE TABLE `[[dbprefix]]vcsintegration_commits` (
  `log` text,
  `old_rev` varchar(40) DEFAULT NULL,
  `new_rev` varchar(40) DEFAULT NULL,
  `author` int(10) DEFAULT '0',
  `date` int(10) DEFAULT '0',
  `data` text,
  `project_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vcsintegration_files`
--

CREATE TABLE `[[dbprefix]]vcsintegration_files` (
  `file_name` text,
  `action` varchar(1) DEFAULT NULL,
  `commit_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vcsintegration_issuelinks`
--

CREATE TABLE `[[dbprefix]]vcsintegration_issuelinks` (
  `issue_no` int(10) DEFAULT '0',
  `commit_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]visible_issue_types`
--

CREATE TABLE `[[dbprefix]]visible_issue_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `issuetype_id` int(10) unsigned DEFAULT '0',
  `project_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]visible_milestones`
--

CREATE TABLE `[[dbprefix]]visible_milestones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `milestone_id` int(10) unsigned DEFAULT '0',
  `project_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votes`
--

CREATE TABLE `[[dbprefix]]votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `target` int(10) DEFAULT '0',
  `vote` int(2) DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflows`
--

CREATE TABLE `[[dbprefix]]workflows` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `initial_transition_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]workflows`
--

INSERT INTO `[[dbprefix]]workflows` VALUES
('Multi-team workflow', 'This is a workflow well suited for projects with multiple teams. It uses an issue lifecycle involving triaging, testing and QA, and works well for large projects.', 1, 1, 1, 1),
('Balanced workflow', 'This is a workflow used to handle medium-sized projects or small-team projects.', 1, 14, 1, 2),
('Simple workflow', 'This is a simple workflow that can be used on projects with few people, or even just one person.', 1, 21, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_issuetype`
--

CREATE TABLE `[[dbprefix]]workflow_issuetype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `workflow_id` int(10) unsigned DEFAULT '0',
  `workflow_scheme_id` int(10) unsigned DEFAULT '0',
  `issutype_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]workflow_issuetype`
--

INSERT INTO `[[dbprefix]]workflow_issuetype` VALUES
(1, 1, 1, 1, 1),
(2, 1, 1, 1, 2),
(3, 1, 1, 1, 3),
(4, 1, 1, 1, 4),
(5, 1, 1, 1, 5),
(6, 1, 1, 1, 6),
(7, 1, 1, 1, 7),
(8, 1, 2, 2, 1),
(9, 1, 2, 2, 2),
(10, 1, 2, 2, 3),
(11, 1, 2, 2, 4),
(12, 1, 2, 2, 5),
(13, 1, 2, 2, 6),
(14, 1, 2, 2, 7),
(15, 1, 3, 3, 1),
(16, 1, 3, 3, 2),
(17, 1, 3, 3, 3),
(18, 1, 3, 3, 4),
(19, 1, 3, 3, 5),
(20, 1, 3, 3, 6),
(21, 1, 3, 3, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_schemes`
--

CREATE TABLE `[[dbprefix]]workflow_schemes` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]workflow_schemes`
--

INSERT INTO `[[dbprefix]]workflow_schemes` VALUES
('Multi-team workflow scheme', 'This is a workflow scheme well suited for projects with multiple teams. It uses the multi-team workflow for all issue types.', 1, 1),
('Balanced workflow scheme', 'This is a workflow scheme used to handle medium-sized projects or small-team projects. It uses the balanced workflow for all issue types.', 1, 2),
('Simple workflow scheme', 'This is a simple workflow scheme for projects with few people, or even just one person. It uses the simple workflow for all issue types.', 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_steps`
--

CREATE TABLE `[[dbprefix]]workflow_steps` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `editable` tinyint(1) DEFAULT NULL,
  `closed` tinyint(1) DEFAULT NULL,
  `status_id` int(10) DEFAULT '0',
  `workflow_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=21 ;

--
-- Dumping data for table `[[dbprefix]]workflow_steps`
--

INSERT INTO `[[dbprefix]]workflow_steps` VALUES
('New', 'A new issue, not yet handled', 1, 0, 23, 1, 1, 1),
('Investigating', 'An issue that is being investigated, looked into or is by other means between new and unconfirmed state', 1, 0, 24, 1, 1, 2),
('Confirmed', 'An issue that has been confirmed', 0, 0, 25, 1, 1, 3),
('In progress', 'An issue that is being adressed', 0, 0, 27, 1, 1, 4),
('Ready for testing', 'An issue that has been marked fixed and is ready for testing', 0, 0, 29, 1, 1, 5),
('Testing', 'An issue where the proposed or implemented solution is currently being tested or approved', 0, 0, 30, 1, 1, 6),
('Rejected', 'A closed issue that has been rejected', 0, 1, 26, 1, 1, 7),
('Closed', 'A closed issue', 0, 1, 0, 1, 1, 8),
('New', 'A new issue, not yet handled', 1, 0, 23, 2, 1, 9),
('Confirmed', 'A new issue, not yet handled', 1, 0, 25, 2, 1, 10),
('In progress', 'An issue that is being worked on', 1, 0, 44, 2, 1, 11),
('Ready for testing', 'An issue that is ready to be tested', 0, 0, 45, 2, 1, 12),
('Resolved', 'An issue that has been resolved', 0, 0, 46, 2, 1, 13),
('Closed', 'An issue that has been closed', 0, 1, 31, 2, 1, 14),
('Reopened', 'An issue that was previously resolved or closed', 1, 0, 47, 2, 1, 15),
('Open', 'A new issue, not yet handled', 1, 0, 48, 3, 1, 16),
('In progress', 'An issue that is being worked on', 1, 0, 49, 3, 1, 17),
('Resolved', 'An issue that has been resolved', 0, 0, 50, 3, 1, 18),
('Closed', 'An issue that has been closed', 0, 1, 31, 3, 1, 19),
('Reopened', 'An issue that was previously resolved or closed', 1, 0, 51, 3, 1, 20);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_step_transitions`
--

CREATE TABLE `[[dbprefix]]workflow_step_transitions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` int(10) unsigned DEFAULT '0',
  `workflow_id` int(10) unsigned DEFAULT '0',
  `from_step_id` int(10) unsigned DEFAULT '0',
  `transition_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workflow_step_transitions_scope_fromstepid` (`scope`,`from_step_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]workflow_step_transitions`
--

INSERT INTO `[[dbprefix]]workflow_step_transitions` VALUES
(1, 1, 1, 1, 2),
(2, 1, 1, 1, 4),
(3, 1, 1, 1, 5),
(4, 1, 1, 1, 6),
(5, 1, 1, 1, 10),
(6, 1, 1, 2, 3),
(7, 1, 1, 2, 4),
(8, 1, 1, 2, 5),
(9, 1, 1, 2, 6),
(10, 1, 1, 3, 6),
(11, 1, 1, 3, 8),
(12, 1, 1, 3, 10),
(13, 1, 1, 4, 5),
(14, 1, 1, 4, 9),
(15, 1, 1, 4, 10),
(16, 1, 1, 5, 10),
(17, 1, 1, 5, 11),
(18, 1, 1, 6, 12),
(19, 1, 1, 6, 13),
(20, 1, 1, 7, 7),
(21, 1, 1, 8, 7),
(22, 1, 2, 9, 18),
(23, 1, 2, 9, 19),
(24, 1, 2, 9, 17),
(25, 1, 2, 10, 18),
(26, 1, 2, 10, 19),
(27, 1, 2, 10, 15),
(28, 1, 2, 11, 19),
(29, 1, 2, 11, 18),
(30, 1, 2, 11, 16),
(31, 1, 2, 12, 18),
(32, 1, 2, 12, 19),
(33, 1, 2, 12, 20),
(34, 1, 2, 13, 20),
(35, 1, 2, 13, 19),
(36, 1, 2, 14, 20),
(37, 1, 2, 15, 18),
(38, 1, 2, 15, 19),
(39, 1, 2, 15, 15),
(40, 1, 3, 16, 23),
(41, 1, 3, 16, 24),
(42, 1, 3, 16, 22),
(43, 1, 3, 17, 24),
(44, 1, 3, 17, 23),
(45, 1, 3, 18, 25),
(46, 1, 3, 18, 24),
(47, 1, 3, 19, 25),
(48, 1, 3, 20, 23),
(49, 1, 3, 20, 24),
(50, 1, 3, 20, 22);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_transitions`
--

CREATE TABLE `[[dbprefix]]workflow_transitions` (
  `name` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `outgoing_step_id` int(10) DEFAULT '0',
  `template` varchar(200) DEFAULT NULL,
  `workflow_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]workflow_transitions`
--

INSERT INTO `[[dbprefix]]workflow_transitions` VALUES
('Issue created', 'This is the initial transition for issues using this workflow', 1, '', 1, 1, 1),
('Investigate issue', 'Assign the issue to yourself and start investigating it', 2, '', 1, 1, 2),
('Request more information', 'Move issue back to new state for more details', 1, 'main/updateissueproperties', 1, 1, 3),
('Confirm issue', 'Confirm that the issue is valid', 3, '', 1, 1, 4),
('Reject issue', 'Reject the issue as invalid', 7, 'main/updateissueproperties', 1, 1, 5),
('Accept issue', 'Accept the issue and assign it to yourself', 4, '', 1, 1, 6),
('Reopen issue', 'Reopen the issue', 1, '', 1, 1, 7),
('Assign issue', 'Accept the issue and assign it to someone', 4, 'main/updateissueproperties', 1, 1, 8),
('Mark ready for testing', 'Mark the issue as ready to be tested', 5, '', 1, 1, 9),
('Resolve issue', 'Resolve the issue', 8, 'main/updateissueproperties', 1, 1, 10),
('Test issue solution', 'Check whether the solution is valid', 6, '', 1, 1, 11),
('Accept issue solution', 'Mark the issue as resolved', 8, 'main/updateissueproperties', 1, 1, 12),
('Reject issue solution', 'Reject the proposed solution and mark the issue as in progress', 4, '', 1, 1, 13),
('Issue created', 'This is the initial transition for issues using this workflow', 9, '', 2, 1, 14),
('Start progress', 'Assign the issue to yourself and start working on it', 11, '', 2, 1, 15),
('Mark ready for testing', 'Mark issue as ready to be tested', 12, 'main/updateissueproperties', 2, 1, 16),
('Confirm issue', 'Confirm that the issue is valid', 10, 'main/updateissueproperties', 2, 1, 17),
('Resolve issue', 'Mark issue as resolved', 13, 'main/updateissueproperties', 2, 1, 18),
('Close issue', 'Close the issue', 14, 'main/updateissueproperties', 2, 1, 19),
('Reopen issue', 'Reopen the issue', 15, 'main/updateissueproperties', 2, 1, 20),
('Issue created', 'This is the initial transition for issues using this workflow', 16, '', 3, 1, 21),
('Start progress', 'Assign the issue to yourself and start working on it', 17, '', 3, 1, 22),
('Resolve issue', 'Mark issue as resolved', 18, 'main/updateissueproperties', 3, 1, 23),
('Close issue', 'Close the issue', 19, 'main/updateissueproperties', 3, 1, 24),
('Reopen issue', 'Reopen the issue', 20, 'main/updateissueproperties', 3, 1, 25);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_transition_actions`
--

CREATE TABLE `[[dbprefix]]workflow_transition_actions` (
  `action_type` varchar(200) DEFAULT NULL,
  `target_value` varchar(200) DEFAULT NULL,
  `transition_id` int(10) DEFAULT '0',
  `workflow_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workflow_transition_actions_scope_transitionid` (`scope`,`transition_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=49 ;

--
-- Dumping data for table `[[dbprefix]]workflow_transition_actions`
--

INSERT INTO `[[dbprefix]]workflow_transition_actions` VALUES
('assign_self', '0', 2, 1, 1, 1),
('clear_assignee', '0', 3, 1, 1, 2),
('set_percent', '10', 4, 1, 1, 3),
('set_resolution', '0', 5, 1, 1, 4),
('set_duplicate', '0', 5, 1, 1, 5),
('set_percent', '100', 5, 1, 1, 6),
('user_stop_working', '0', 5, 1, 1, 7),
('assign_self', '0', 6, 1, 1, 8),
('user_start_working', '0', 6, 1, 1, 9),
('clear_resolution', '0', 7, 1, 1, 10),
('clear_duplicate', '0', 7, 1, 1, 11),
('clear_percent', '0', 7, 1, 1, 12),
('assign_user', '0', 8, 1, 1, 13),
('user_start_working', '0', 8, 1, 1, 14),
('clear_assignee', '0', 9, 1, 1, 15),
('user_stop_working', '0', 9, 1, 1, 16),
('set_status', '0', 10, 1, 1, 17),
('set_percent', '100', 10, 1, 1, 18),
('set_resolution', '0', 10, 1, 1, 19),
('user_stop_working', '0', 10, 1, 1, 20),
('assign_self', '0', 11, 1, 1, 21),
('user_start_working', '0', 11, 1, 1, 22),
('set_resolution', '0', 12, 1, 1, 23),
('clear_assignee', '0', 12, 1, 1, 24),
('user_stop_working', '0', 12, 1, 1, 25),
('set_resolution', '0', 13, 1, 1, 26),
('clear_assignee', '0', 13, 1, 1, 27),
('user_stop_working', '0', 13, 1, 1, 28),
('assign_self', '0', 15, 2, 1, 29),
('set_percent', '33', 15, 2, 1, 30),
('clear_assignee', '0', 16, 2, 1, 31),
('set_percent', '80', 16, 2, 1, 32),
('clear_assignee', '0', 17, 2, 1, 33),
('set_percent', '10', 17, 2, 1, 34),
('clear_assignee', '0', 18, 2, 1, 35),
('set_percent', '90', 18, 2, 1, 36),
('set_percent', '100', 19, 2, 1, 37),
('set_duplicate', '0', 19, 2, 1, 38),
('set_resolution', '0', 20, 2, 1, 39),
('set_percent', '0', 20, 2, 1, 40),
('assign_self', '0', 22, 3, 1, 41),
('set_percent', '33', 22, 3, 1, 42),
('clear_assignee', '0', 23, 3, 1, 43),
('set_percent', '90', 23, 3, 1, 44),
('set_percent', '100', 24, 3, 1, 45),
('set_duplicate', '0', 24, 3, 1, 46),
('set_resolution', '0', 25, 3, 1, 47),
('set_percent', '0', 25, 3, 1, 48);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow_transition_validation_rules`
--

CREATE TABLE `[[dbprefix]]workflow_transition_validation_rules` (
  `rule` varchar(100) DEFAULT NULL,
  `rule_value` varchar(200) DEFAULT NULL,
  `pre_or_post` varchar(200) DEFAULT NULL,
  `transition_id` int(10) DEFAULT '0',
  `workflow_id` int(10) DEFAULT '0',
  `scope` int(10) DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workflow_transition_validation_rules_scope_transitionid` (`scope`,`transition_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]workflow_transition_validation_rules`
--

INSERT INTO `[[dbprefix]]workflow_transition_validation_rules` VALUES
('max_assigned_issues', '5', 'pre', 2, 1, 1, 1),
('valid_resolution', '15,14,18,13,19', 'post', 5, 1, 1, 2),
('max_assigned_issues', '5', 'pre', 6, 1, 1, 3),
('valid_status', '31,32,33,34', 'post', 10, 1, 1, 4),
('valid_resolution', '17,14,16,19', 'post', 10, 1, 1, 5);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
