---
name: 🐛 Bug Report
about: File a bug report, if you've discovered a problem in Bolt's code.
---

A brief description of the issue goes here.

<!--

If you haven't yet done so, please read the "contributing guidelines"
thoroughly. Then, proceed by filling out the rest of the details in the issue
template below. The more details you can give us, the easier it will be for us
to determine the cause of a problem.

See: https://github.com/bolt/bolt/blob/master/.github/CONTRIBUTING.md

-->

Details
-------

| Question                      | Answer
|----------------- | ------
| Relevant Bolt Version | legacy / 3.5 / 3.6 / master
| Install type                   |  Zip or tar install / Composer install / GitHub checkout
| BC Break                     | yes/no
| PHP version                 | 5.5 / 5.6 / 7.0 / 7.1 / 7.2
| Web server                  | Apache / Nginx / Built-in, version [ version ]
| For UX/UI issues        | Browser name and version


Reproduction
------------

If you're filing a bug, please describe how to reproduce it. Include as much
relevant information as possible, such as:

### Bug summary

<!--
    * Write a short summary of the bug
    * Try to pinpoint it as much as possible
    * Try to state the _actual problem_, and not just what you _think_ the
      solution might be.
-->

### Specifics

<!--
    * Mention the URL where this bug occurs, if applicable
    * What version of Bolt are you using (down to the very last digit!)
    * What method did you use to install Bolt
    * What browser and version you are using
    * Please mention if you've checked it in other browsers as well
    * Please include *full error messages* and *screenshots* if possible
-->

### Steps to reproduce

<!--
    * Clearly mention the steps to reproduce the bug
-->

### Expected result

<!--
    * What did you _expect_ that would happen on your Bolt site?
    * Describe the intended/desired outcome after you did the steps mentioned.
-->

### Actual result

<!--
    * What is the actual result of the above steps?
    * Describe the behaviour of the bug
    * Please, please include **error messages** and screenshots. They might mean
      nothing to you, but they are _very_ helpful to us.
-->
