<?php
// disable the mock by default
namespace
{  
    $mockProcOpen = false;
}  

// same namespace as SUT
namespace PHPExif\Adapter
{

    // stub the function
    function proc_open($cmd, array $descriptorspec , &$pipes = array())
    {
        global $mockProcOpen;
        if (isset($mockProcOpen) && !$mockProcOpen) {
            return \proc_open(
                $cmd,
                $descriptorspec,
                $pipes
            );
        }
        return false;
    }

    /**
     * @covers \PHPExif\Adapter\Exiftool::<!public>
     */
    class ExiftoolProcOpenTest extends \PHPUnit_Framework_TestCase
    {
        /**
         * @var \PHPExif\Adapter\Exiftool
         */
        protected $adapter;

        public function setUp()
        {
            global $mockProcOpen;
            $mockProcOpen = true;
            $this->adapter = new \PHPExif\Adapter\Exiftool();
        }

        public function tearDown()
        {
            global $mockProcOpen;
            $mockProcOpen = false;
        }

        /**
         * @group exiftool
         * @covers \PHPExif\Adapter\Exiftool::getCliOutput
         * @expectedException RuntimeException
         */
        public function testGetCliOutput()
        {
            $reflMethod = new \ReflectionMethod('\PHPExif\Adapter\Exiftool', 'getCliOutput');
            $reflMethod->setAccessible(true);

            $result = $reflMethod->invoke(
                $this->adapter,
                sprintf(
                    '%1$s',
                    'pwd'
                )
            );
        }
    }
}
