<?php

namespace Bolt\Storage\Field\Type;

use Bolt\Storage\EntityManager;
use Bolt\Storage\Mapping;
use Bolt\Storage\QuerySet;
use Carbon\Carbon;

/**
 * This is one of a suite of basic Bolt field transformers that handles
 * the lifecycle of a field from pre-query to persist.
 *
 * @author Ross Riley <riley.ross@gmail.com>
 */
class DateTimeType extends DateType
{
    /**
     * {@inheritdoc}
     */
    public function __construct(array $mapping = [], EntityManager $em = null)
    {
        parent::__construct($mapping, $em);
    }

    /**
     * {@inheritdoc}
     */
    public function persist(QuerySet $queries, $entity)
    {
        $key = $this->mapping['fieldname'];
        $value = $entity->get($key);

        if (!$value instanceof \DateTime && $value !== null) {
            $value = new Carbon($value);
            $entity->set($key, $value);
        }

        parent::persist($queries, $entity);
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'datetime';
    }
}
