// From: https://github.com/antoningrele/img-brightness-normalization

function normalizeBrightness(coeff=1.25) {

	document.querySelectorAll('[data-background-image]').forEach(function(div) {

		/* Get the div's image background url and apply to the style */
		var imageUrl = div.dataset.backgroundImage
		div.style.background = "url('" + imageUrl + "')"

		/* Prepare a dom image for canvas manipulation*/
		var background = new Image()
		background.src = imageUrl

		/* When the dom image loads, proceed with the calculations */
		background.onload = function() {

			var brightness = getBrightness(background)
			div.dataset.brightness = brightness

			/* The more opaque the overlay, the darker the image.
			A coefficient of 1 will equate the overlay's opacity with the image's brightness.
			A higher coefficient will leave more room for differences between the images, but
			will avoid darkening your images too much. */
			var darkOverlayOpacity = brightness / coeff
			div.style.background =  `
				linear-gradient(rgba(0,0,0,${darkOverlayOpacity}),
				rgba(0,0,0,${darkOverlayOpacity})),
				url(${imageUrl})
				`
			div.style.backgroundSize = "cover"
		}
	})
}


function getBrightness(img) {

	/* Returns a brightness value between 0 and 1 based on the image's brightness */

	var rgb = getAverageColor(img)
	var brightness255 = (rgb.r * 2 + rgb.g *3 + rgb.b) / 6
	var brightness = brightness255 / 255
	return brightness

}

function getAverageColor(img) {

	/* Returns an RGB object of an image's average color */

	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	var width = canvas.width = img.naturalWidth;
	var height = canvas.height = img.naturalHeight;

	ctx.drawImage(img, 0, 0);

	var imageData = ctx.getImageData(0, 0, width, height);
	var data = imageData.data;
	var r = 0;
	var g = 0;
	var b = 0;

	for (var i = 0; i < data.length; i += 4) {
		r += data[i];
		g += data[i+1];
		b += data[i+2];
	}

	r = Math.floor(r / (data.length / 4));
	g = Math.floor(g / (data.length / 4));
	b = Math.floor(b / (data.length / 4));

	return { r: r, g: g, b: b };

}