
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `bolt371`
--

-- --------------------------------------------------------

--
-- Table structure for table `bolt_authtoken`
--

CREATE TABLE `bolt_authtoken` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `username` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `token` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `salt` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `lastseen` datetime DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `useragent` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `validity` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_740AC52FA76ED395` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `bolt_authtoken`
--


-- --------------------------------------------------------

--
-- Table structure for table `bolt_blocks`
--

CREATE TABLE `bolt_blocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `datecreated` datetime NOT NULL,
  `datechanged` datetime NOT NULL,
  `datepublish` datetime DEFAULT NULL,
  `datedepublish` datetime DEFAULT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `templatefields` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `title` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8_unicode_ci,
  `contentlink` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  PRIMARY KEY (`id`),
  KEY `IDX_7B2C81B7989D9B62` (`slug`),
  KEY `IDX_7B2C81B7AFBA6FD8` (`datecreated`),
  KEY `IDX_7B2C81B7BE74E59A` (`datechanged`),
  KEY `IDX_7B2C81B7A5131421` (`datepublish`),
  KEY `IDX_7B2C81B7B7805520` (`datedepublish`),
  KEY `IDX_7B2C81B77B00651C` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `bolt_blocks`
--

INSERT INTO `bolt_blocks` VALUES
(1, 'about-us', '2019-06-19 17:27:53', '[[regtime]]', '2020-04-25 17:52:43', NULL, 1, 'published', '[]', 'About Us', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. An potest, inquit ille, quicquam esse suavius quam nihil dolere? <a href="http://loripsum.net/" target="_blank">Duo Reges: constructio interrete.</a> Ergo ita: non posse honeste vivi, nisi honeste vivatur? Suo genere perveniant ad extremum; Nam quibus rebus efficiuntur voluptates, eae non sunt in potestate sapientis. Vide, ne etiam menses! nisi forte eum dicis, qui, simul atque arripuit, interficit. </p>', NULL, '{"file":"placeholder_37edfa4a2ee0.jpg","title":"Placeholder_37edfa4a2ee0.","alt":"Placeholder_37edfa4a2ee0."}'),
(2, 'address', '2019-09-23 01:32:53', '[[regtime]]', '2019-10-16 14:53:06', NULL, 1, 'published', '[]', 'Address', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <a href="http://loripsum.net/" target="_blank">Sequitur disserendi ratio cognitioque naturae;</a> An vero displicuit ea, quae tributa est animi virtutibus tanta praestantia? <a href="http://loripsum.net/" target="_blank">Quae contraria sunt his, malane?</a> Si quidem, inquit, tollerem, sed relinquo. <a href="http://loripsum.net/" target="_blank">Eadem fortitudinis ratio reperietur.</a> Si longus, levis. Quamquam ab iis philosophiam et omnes ingenuas disciplinas habemus; Duo Reges: constructio interrete. </p>', NULL, '{"file":"placeholder_c71e0798e830.jpg","title":"Placeholder_c71e0798e830.","alt":"Placeholder_c71e0798e830."}'),
(3, 'search-teaser', '2019-08-09 08:39:35', '[[regtime]]', '2019-10-15 11:42:53', NULL, 1, 'published', '[]', 'Search Teaser', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <i>Sed residamus, inquit, si placet.</i> Expectoque quid ad id, quod quaerebam, respondeas. Quod vestri non item. Vadem te ad mortem tyranno dabis pro amico, ut Pythagoreus ille Siculo fecit tyranno? <i>Sed virtutem ipsam inchoavit, nihil amplius.</i> Ea possunt paria non esse. </p>', NULL, '{"file":"placeholder_13c5c2652fe4.jpg","title":"Placeholder_13c5c2652fe4.","alt":"Placeholder_13c5c2652fe4."}'),
(4, '404-not-found', '2019-11-07 21:42:32', '[[regtime]]', '2019-09-23 14:09:58', NULL, 1, 'published', '[]', '404 Not Found', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quam illa ardentis amores excitaret sui! Cur tandem? <i>Expectoque quid ad id, quod quaerebam, respondeas.</i> Qui-vere falsone, quaerere mittimus-dicitur oculis se privasse; An eum discere ea mavis, quae cum plane perdidiceriti nihil sciat? Nam quid possumus facere melius? Hoc unum Aristo tenuit: praeter vitia atque virtutes negavit rem esse ullam aut fugiendam aut expetendam. Duo Reges: constructio interrete. </p>', NULL, '{"file":"placeholder_29d9776450ee.jpg","title":"Placeholder_29d9776450ee.","alt":"Placeholder_29d9776450ee."}'),
(5, 'gloriosa-ostentatio-in-constituendo-summo-bono', '2019-05-28 18:41:59', '[[regtime]]', '2019-11-28 12:54:24', NULL, 1, 'published', '[]', 'Gloriosa ostentatio in constituendo summo bono.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <i>Dic in quovis conventu te omnia facere, ne doleas.</i> <b>Quae est igitur causa istarum angustiarum?</b> Duo Reges: constructio interrete. Qualem igitur hominem natura inchoavit? </p>', NULL, '{"file":"placeholder_29d9776450ee.jpg","title":"Placeholder_29d9776450ee.","alt":"Placeholder_29d9776450ee."}');

-- --------------------------------------------------------

--
-- Table structure for table `bolt_cron`
--

CREATE TABLE `bolt_cron` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `interim` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `lastrun` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CD38E123615F8869` (`interim`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bolt_entries`
--

CREATE TABLE `bolt_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `datecreated` datetime NOT NULL,
  `datechanged` datetime NOT NULL,
  `datepublish` datetime DEFAULT NULL,
  `datedepublish` datetime DEFAULT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `templatefields` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `title` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `teaser` longtext COLLATE utf8_unicode_ci,
  `body` longtext COLLATE utf8_unicode_ci,
  `image` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `video` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  PRIMARY KEY (`id`),
  KEY `IDX_2696ADF0989D9B62` (`slug`),
  KEY `IDX_2696ADF0AFBA6FD8` (`datecreated`),
  KEY `IDX_2696ADF0BE74E59A` (`datechanged`),
  KEY `IDX_2696ADF0A5131421` (`datepublish`),
  KEY `IDX_2696ADF0B7805520` (`datedepublish`),
  KEY `IDX_2696ADF07B00651C` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `bolt_entries`
--

INSERT INTO `bolt_entries` VALUES
(1, 'que-manilium-ab-iisque-m', '2019-05-19 20:49:35', '[[regtime]]', '2019-09-23 01:54:12', NULL, 1, 'published', '[]', 'Que Manilium, ab iisque M.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quae similitudo in genere etiam humano apparet. Atqui iste locus est, Piso, tibi etiam atque etiam confirmandus, inquam; </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Dicet pro me ipsa virtus nec dubitabit isti vestro beato M. Ea possunt paria non esse. Hinc ceteri particulas arripere conati suam quisque videro voluit afferre sententiam. Scisse enim te quis coarguere possit? Sin tantum modo ad indicia veteris memoriae cognoscenda, curiosorum. Quod autem satis est, eo quicquid accessit, nimium est; Duo Reges: constructio interrete. </p>\n\n<ul>\n<li>At iste non dolendi status non vocatur voluptas.</li>\n	<li>Cum id quoque, ut cupiebat, audivisset, evelli iussit eam, qua erat transfixus, hastam.</li>\n	<li>Hanc quoque iucunditatem, si vis, transfer in animum;</li>\n	<li>Miserum hominem! Si dolor summum malum est, dici aliter non potest.</li>\n</ul>\n<ol>\n<li>Hoc non est positum in nostra actione.</li>\n	<li>Sit hoc ultimum bonorum, quod nunc a me defenditur;</li>\n</ol>\n<p>Sit enim idem caecus, debilis. Erit enim instructus ad mortem contemnendam, ad exilium, ad ipsum etiam dolorem. Ad quorum et cognitionem et usum iam corroborati natura ipsa praeeunte deducimur. De ingenio eius in his disputationibus, non de moribus quaeritur. <b>Poterat autem inpune;</b> Et quidem iure fortasse, sed tamen non gravissimum est testimonium multitudinis. </p>\n\n<p>Stoici scilicet. Hoc positum in Phaedro a Platone probavit Epicurus sensitque in omni disputatione id fieri oportere. <mark>Res enim concurrent contrariae.</mark> Videsne quam sit magna dissensio? </p>', '{"file":"placeholder_37edfa4a2ee0.jpg","title":"placeholder","alt":"placeholder"}', NULL),
(2, 'non-autem-hoc-igitur-ne-illud-quidem', '2019-07-12 05:13:18', '[[regtime]]', '2019-07-06 19:19:04', NULL, 1, 'published', '[]', 'Non autem hoc: igitur ne illud quidem.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Non enim solum Torquatus dixit quid sentiret, sed etiam cur. Habes, inquam, Cato, formam eorum, de quibus loquor, philosophorum. <b>Duo Reges: constructio interrete.</b> Mihi enim satis est, ipsis non satis. <a href="http://loripsum.net/" target="_blank">Quis est tam dissimile homini.</a> </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Beatus sibi videtur esse moriens. <b>Que Manilium, ab iisque M.</b> <i>Hic ambiguo ludimur.</i> <b>Ego vero isti, inquam, permitto.</b> </p>\n\n<p>Et quod est munus, quod opus sapientiae? Multoque hoc melius nos veriusque quam Stoici. Dempta enim aeternitate nihilo beatior Iuppiter quam Epicurus; <a href="http://loripsum.net/" target="_blank">Duo Reges: constructio interrete.</a> At iste non dolendi status non vocatur voluptas. Traditur, inquit, ab Epicuro ratio neglegendi doloris. Quamvis enim depravatae non sint, pravae tamen esse possunt. Bestiarum vero nullum iudicium puto. </p>\n\n<ol>\n<li>Apparet statim, quae sint officia, quae actiones.</li>\n	<li>Age nunc isti doceant, vel tu potius quis enim ista melius?</li>\n	<li>Quod equidem non reprehendo;</li>\n	<li>Cur deinde Metrodori liberos commendas?</li>\n</ol>\n<p>Transfer idem ad modestiam vel temperantiam, quae est moderatio cupiditatum rationi oboediens. Et quidem Arcesilas tuus, etsi fuit in disserendo pertinacior, tamen noster fuit; Cum id fugiunt, re eadem defendunt, quae Peripatetici, verba. <a href="http://loripsum.net/" target="_blank">Cur, nisi quod turpis oratio est?</a> Quorum sine causa fieri nihil putandum est. <b>Sin aliud quid voles, postea.</b> Quae cum ita sint, effectum est nihil esse malum, quod turpe non sit. </p>\n\n<ul>\n<li>Dicet pro me ipsa virtus nec dubitabit isti vestro beato M.</li>\n	<li>Quid ei reliquisti, nisi te, quoquo modo loqueretur, intellegere, quid diceret?</li>\n	<li>Nam et complectitur verbis, quod vult, et dicit plane, quod intellegam;</li>\n</ul>', '{"file":"placeholder_2f2ecc39d7b6.jpg","title":"placeholder","alt":"placeholder"}', NULL),
(3, 'pollicetur-certe', '2020-01-28 14:15:08', '[[regtime]]', '2020-04-09 11:49:23', NULL, 1, 'published', '[]', 'Pollicetur certe.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. A villa enim, credo, et: Si ibi te esse scissem, ad te ipse venissem. Mihi quidem Antiochum, quem audis, satis belle videris attendere. Ex quo intellegitur officium medium quiddam esse, quod neque in bonis ponatur neque in contrariis. <b>At multis malis affectus.</b> Quae cum essent dicta, discessimus. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Me igitur ipsum ames oportet, non mea, si veri amici futuri sumus. <b>Eadem fortitudinis ratio reperietur.</b> <a href="http://loripsum.net/" target="_blank">Collatio igitur ista te nihil iuvat.</a> <i>Duo Reges: constructio interrete.</i> Ubi ut eam caperet aut quando? At negat Epicurus-hoc enim vestrum lumen estquemquam, qui honeste non vivat, iucunde posse vivere. <a href="http://loripsum.net/" target="_blank">Non quam nostram quidem, inquit Pomponius iocans;</a> </p>\n\n<p>Quid ad utilitatem tantae pecuniae? <a href="http://loripsum.net/" target="_blank">Invidiosum nomen est, infame, suspectum.</a> <a href="http://loripsum.net/" target="_blank">Cur post Tarentum ad Archytam?</a> Sed ea mala virtuti magnitudine obruebantur. Cupiditates non Epicuri divisione finiebat, sed sua satietate. Quando enim Socrates, qui parens philosophiae iure dici potest, quicquam tale fecit? </p>\n\n<ol>\n<li>Quasi vero, inquit, perpetua oratio rhetorum solum, non etiam philosophorum sit.</li>\n	<li>Quarum ambarum rerum cum medicinam pollicetur, luxuriae licentiam pollicetur.</li>\n	<li>Expectoque quid ad id, quod quaerebam, respondeas.</li>\n	<li>Nihilne est in his rebus, quod dignum libero aut indignum esse ducamus?</li>\n	<li>Non est enim vitium in oratione solum, sed etiam in moribus.</li>\n</ol>\n<p><b>Bonum integritas corporis: misera debilitas.</b> Equidem etiam Epicurum, in physicis quidem, Democriteum puto. Quid ergo hoc loco intellegit honestum? <mark>Terram, mihi crede, ea lanx et maria deprimet.</mark></p>\n\n<ul>\n<li>Quis suae urbis conservatorem Codrum, quis Erechthei filias non maxime laudat?</li>\n	<li>Si stante, hoc natura videlicet vult, salvam esse se, quod concedimus;</li>\n	<li>Ita enim vivunt quidam, ut eorum vita refellatur oratio.</li>\n</ul>', '{"file":"placeholder_5ff2a79537dc.jpg","title":"placeholder","alt":"placeholder"}', NULL),
(4, 'immo-alio-genere', '2020-03-16 21:39:41', '[[regtime]]', '2020-03-27 02:52:29', NULL, 1, 'published', '[]', 'Immo alio genere;', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duo Reges: constructio interrete. Quo modo autem optimum, si bonum praeterea nullum est? Hoc sic expositum dissimile est superiori. Praeclare hoc quidem. Atque haec ita iustitiae propria sunt, ut sint virtutum reliquarum communia. Quid ait Aristoteles reliquique Platonis alumni? Quamquam haec quidem praeposita recte et reiecta dicere licebit. <a href="http://loripsum.net/" target="_blank">Bonum integritas corporis: misera debilitas.</a> Nam, ut sint illa vendibiliora, haec uberiora certe sunt. Huius, Lyco, oratione locuples, rebus ipsis ielunior. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam, ut sint illa vendibiliora, haec uberiora certe sunt. <a href="http://loripsum.net/" target="_blank">Hoc est non dividere, sed frangere.</a> Ex ea difficultate illae fallaciloquae, ut ait Accius, malitiae natae sunt. Vide, ne etiam menses! nisi forte eum dicis, qui, simul atque arripuit, interficit. </p>\n\n<p>Aliter autem vobis placet. <a href="http://loripsum.net/" target="_blank">Scrupulum, inquam, abeunti;</a> Duo Reges: constructio interrete. <a href="http://loripsum.net/" target="_blank">Bonum liberi: misera orbitas.</a> Atque ab isto capite fluere necesse est omnem rationem bonorum et malorum. Nullus est igitur cuiusquam dies natalis. Nam diligi et carum esse iucundum est propterea, quia tutiorem vitam et voluptatem pleniorem efficit. <b>Inde igitur, inquit, ordiendum est.</b> </p>\n\n<p>Idem iste, inquam, de voluptate quid sentit? <a href="http://loripsum.net/" target="_blank">Est enim effectrix multarum et magnarum voluptatum.</a> Iam doloris medicamenta illa Epicurea tamquam de narthecio proment: Si gravis, brevis; <i>Idem iste, inquam, de voluptate quid sentit?</i> <b>Nonne igitur tibi videntur, inquit, mala?</b> Sed ut iis bonis erigimur, quae expectamus, sic laetamur iis, quae recordamur. </p>\n\n<ol>\n<li>Cur igitur, cum de re conveniat, non malumus usitate loqui?</li>\n	<li>Quantum Aristoxeni ingenium consumptum videmus in musicis?</li>\n	<li>Sed tamen omne, quod de re bona dilucide dicitur, mihi praeclare dici videtur.</li>\n	<li>Habes, inquam, Cato, formam eorum, de quibus loquor, philosophorum.</li>\n</ol>\n<ul>\n<li>Ex quo, id quod omnes expetunt, beate vivendi ratio inveniri et comparari potest.</li>\n	<li>Tu autem inter haec tantam multitudinem hominum interiectam non vides nec laetantium nec dolentium?</li>\n</ul>', '{"file":"placeholder_c71e0798e830.jpg","title":"placeholder","alt":"placeholder"}', NULL),
(5, 'quodsi-ipsam-honestatem-undique-pertectam-atque-absolutam', '2020-01-13 02:51:18', '[[regtime]]', '2019-07-16 07:33:20', NULL, 1, 'published', '[]', 'Quodsi ipsam honestatem undique pertectam atque absolutam.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Te ipsum, dignissimum maioribus tuis, voluptasne induxit, ut adolescentulus eriperes P. Quamvis enim depravatae non sint, pravae tamen esse possunt. Id et fieri posse et saepe esse factum et ad voluptates percipiendas maxime pertinere. Tu vero, inquam, ducas licet, si sequetur; <b>Cum praesertim illa perdiscere ludus esset.</b> Duo Reges: constructio interrete. Itaque hic ipse iam pridem est reiectus; Non autem hoc: igitur ne illud quidem. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ego vero isti, inquam, permitto. Nam his libris eum malo quam reliquo ornatu villae delectari. Quam nemo umquam voluptatem appellavit, appellat; Omnia contraria, quos etiam insanos esse vultis. <a href="http://loripsum.net/" target="_blank">Verum hoc idem saepe faciamus.</a> Duo Reges: constructio interrete. </p>\n\n<ul>\n<li>Quis enim confidit semper sibi illud stabile et firmum permansurum, quod fragile et caducum sit?</li>\n	<li>Videmusne ut pueri ne verberibus quidem a contemplandis rebus perquirendisque deterreantur?</li>\n	<li>Sin tantum modo ad indicia veteris memoriae cognoscenda, curiosorum.</li>\n</ul>\n<ol>\n<li>Et ego: Piso, inquam, si est quisquam, qui acute in causis videre soleat quae res agatur.</li>\n	<li>Virtutis, magnitudinis animi, patientiae, fortitudinis fomentis dolor mitigari solet.</li>\n	<li>Si sapiens, ne tum quidem miser, cum ab Oroete, praetore Darei, in crucem actus est.</li>\n	<li>Qualem igitur hominem natura inchoavit?</li>\n</ol>\n<p>Ex ea difficultate illae fallaciloquae, ut ait Accius, malitiae natae sunt. Sed haec quidem liberius ab eo dicuntur et saepius. <i>Erat enim Polemonis.</i> <i>Suo enim quisque studio maxime ducitur.</i> Quod autem satis est, eo quicquid accessit, nimium est; Quonam, inquit, modo? <mark>Duo enim genera quae erant, fecit tria.</mark> Sed haec quidem liberius ab eo dicuntur et saepius. </p>\n\n<p>Ita fit cum gravior, tum etiam splendidior oratio. Ita multa dicunt, quae vix intellegam. Qui enim voluptatem ipsam contemnunt, iis licet dicere se acupenserem maenae non anteponere. Te enim iudicem aequum puto, modo quae dicat ille bene noris. <i>Hoc mihi cum tuo fratre convenit.</i> Qui convenit? </p>', '{"file":"placeholder_edfb904510e3.jpg","title":"placeholder","alt":"placeholder"}', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `bolt_field_value`
--

CREATE TABLE `bolt_field_value` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contenttype` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `content_id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `grouping` int(11) NOT NULL DEFAULT '0',
  `block` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fieldname` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fieldtype` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value_string` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value_text` longtext COLLATE utf8_unicode_ci,
  `value_integer` int(11) DEFAULT NULL,
  `value_float` double DEFAULT NULL,
  `value_decimal` decimal(18,9) DEFAULT NULL,
  `value_date` date DEFAULT NULL,
  `value_datetime` datetime DEFAULT NULL,
  `value_json_array` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json)',
  `value_boolean` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `IDX_8B31D78784A0A3ED745E1826` (`content_id`,`contenttype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bolt_homepage`
--

CREATE TABLE `bolt_homepage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `datecreated` datetime NOT NULL,
  `datechanged` datetime NOT NULL,
  `datepublish` datetime DEFAULT NULL,
  `datedepublish` datetime DEFAULT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `templatefields` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `title` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `teaser` longtext COLLATE utf8_unicode_ci,
  `content` longtext COLLATE utf8_unicode_ci,
  `contentlink` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9D9C7FD3989D9B62` (`slug`),
  KEY `IDX_9D9C7FD3AFBA6FD8` (`datecreated`),
  KEY `IDX_9D9C7FD3BE74E59A` (`datechanged`),
  KEY `IDX_9D9C7FD3A5131421` (`datepublish`),
  KEY `IDX_9D9C7FD3B7805520` (`datedepublish`),
  KEY `IDX_9D9C7FD37B00651C` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `bolt_homepage`
--

INSERT INTO `bolt_homepage` VALUES
(1, 'dat-enim-intervalla-et-relaxat', '2020-01-21 08:48:51', '[[regtime]]', '2019-10-10 15:38:46', NULL, 1, 'published', '[]', 'Dat enim intervalla et relaxat.', '{"file":"placeholder_9aac9e8ab4e5.jpg","title":"placeholder","alt":"placeholder"}', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quorum sine causa fieri nihil putandum est. Quae cum magnifice primo dici viderentur, considerata minus probabantur. Duo Reges: constructio interrete. Bonum patria: miserum exilium. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. At miser, si in flagitiosa et vitiosa vita afflueret voluptatibus. Fortasse id optimum, sed ubi illud: Plus semper voluptatis? Huius, Lyco, oratione locuples, rebus ipsis ielunior. Illud quaero, quid ei, qui in voluptate summum bonum ponat, consentaneum sit dicere. Duo Reges: constructio interrete. </p>', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `bolt_log_change`
--

CREATE TABLE `bolt_log_change` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `title` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `contenttype` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `contentid` int(11) NOT NULL,
  `mutation_type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `diff` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json)',
  `comment` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_946F972AA9E377A` (`date`),
  KEY `IDX_946F97275DAD987` (`ownerid`),
  KEY `IDX_946F972745E1826` (`contenttype`),
  KEY `IDX_946F972E625AE99` (`contentid`),
  KEY `IDX_946F972B0AEEF39` (`mutation_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bolt_log_system`
--

CREATE TABLE `bolt_log_system` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `message` varchar(1024) COLLATE utf8_unicode_ci NOT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `requesturi` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `route` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `context` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `source` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json)',
  PRIMARY KEY (`id`),
  KEY `IDX_805C16D99AEACC13` (`level`),
  KEY `IDX_805C16D9AA9E377A` (`date`),
  KEY `IDX_805C16D975DAD987` (`ownerid`),
  KEY `IDX_805C16D9E25D857E` (`context`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `bolt_log_system`
--

-- --------------------------------------------------------

--
-- Table structure for table `bolt_pages`
--

CREATE TABLE `bolt_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `datecreated` datetime NOT NULL,
  `datechanged` datetime NOT NULL,
  `datepublish` datetime DEFAULT NULL,
  `datedepublish` datetime DEFAULT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `templatefields` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `title` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `teaser` longtext COLLATE utf8_unicode_ci,
  `body` longtext COLLATE utf8_unicode_ci,
  `template` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_31AF1BC8989D9B62` (`slug`),
  KEY `IDX_31AF1BC8AFBA6FD8` (`datecreated`),
  KEY `IDX_31AF1BC8BE74E59A` (`datechanged`),
  KEY `IDX_31AF1BC8A5131421` (`datepublish`),
  KEY `IDX_31AF1BC8B7805520` (`datedepublish`),
  KEY `IDX_31AF1BC87B00651C` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `bolt_pages`
--

INSERT INTO `bolt_pages` VALUES
(1, 'collatio-igitur-ista-te-nihil-iuvat', '2019-06-19 05:09:12', '[[regtime]]', '2019-09-08 22:51:22', NULL, 1, 'published', '[]', 'Collatio igitur ista te nihil iuvat.', '{"file":"placeholder_d39dade1223e.jpg","title":"placeholder","alt":"placeholder"}', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <b>Honesta oratio, Socratica, Platonis etiam.</b> Habent enim et bene longam et satis litigiosam disputationem. Ego vero volo in virtute vim esse quam maximam; Verba tu fingas et ea dicas, quae non sentias? Nunc haec primum fortasse audientis servire debemus. Summus dolor plures dies manere non potest? Duo Reges: constructio interrete. Aperiendum est igitur, quid sit voluptas; Multa sunt dicta ab antiquis de contemnendis ac despiciendis rebus humanis; </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <a href="http://loripsum.net/" target="_blank">Quibusnam praeteritis?</a> Multoque hoc melius nos veriusque quam Stoici. Efficiens dici potest. Atqui reperies, inquit, in hoc quidem pertinacem; Duo Reges: constructio interrete. <a href="http://loripsum.net/" target="_blank">Equidem, sed audistine modo de Carneade?</a> </p>\n\n<ol>\n<li>Quid in isto egregio tuo officio et tanta fide-sic enim existimo-ad corpus refers?</li>\n	<li>Et quidem iure fortasse, sed tamen non gravissimum est testimonium multitudinis.</li>\n	<li>Innumerabilia dici possunt in hanc sententiam, sed non necesse est.</li>\n	<li>Si quicquam extra virtutem habeatur in bonis.</li>\n</ol>\n<p>Quae in controversiam veniunt, de iis, si placet, disseramus. Ab hoc autem quaedam non melius quam veteres, quaedam omnino relicta. Quid, si non sensus modo ei sit datus, verum etiam animus hominis? <a href="http://loripsum.net/" target="_blank">Ut pulsi recurrant?</a> Paria sunt igitur. De malis autem et bonis ab iis animalibus, quae nondum depravata sint, ait optime iudicari. At iste non dolendi status non vocatur voluptas. </p>\n\n<p><a href="http://loripsum.net/" target="_blank">Quae contraria sunt his, malane?</a> Itaque rursus eadem ratione, qua sum paulo ante usus, haerebitis. <i>An tu me de L.</i> <b>Eademne, quae restincta siti?</b> Nihil enim hoc differt. Tu quidem reddes; Quod autem magnum dolorem brevem, longinquum levem esse dicitis, id non intellego quale sit. Mihi quidem Antiochum, quem audis, satis belle videris attendere. </p>\n\n<ul>\n<li>Egone quaeris, inquit, quid sentiam?</li>\n	<li>Atqui perspicuum est hominem e corpore animoque constare, cum primae sint animi partes, secundae corporis.</li>\n	<li>Duo enim genera quae erant, fecit tria.</li>\n</ul>', NULL),
(2, 'haeret-in-salebra', '2019-09-12 15:22:40', '[[regtime]]', '2020-05-06 10:27:26', NULL, 1, 'published', '[]', 'Haeret in salebra.', '{"file":"placeholder_54c39e274cc7.jpg","title":"placeholder","alt":"placeholder"}', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Itaque e contrario moderati aequabilesque habitus, affectiones ususque corporis apti esse ad naturam videntur. <a href="http://loripsum.net/" target="_blank">Philosophi autem in suis lectulis plerumque moriuntur.</a> <b>Etenim semper illud extra est, quod arte comprehenditur.</b> Duo Reges: constructio interrete. Nos quidem Virtutes sic natae sumus, ut tibi serviremus, aliud negotii nihil habemus. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <b>Nam ista vestra: Si gravis, brevis;</b> Ab hoc autem quaedam non melius quam veteres, quaedam omnino relicta. Sed potestne rerum maior esse dissensio? Duo Reges: constructio interrete. Potius inflammat, ut coercendi magis quam dedocendi esse videantur. Sed id ne cogitari quidem potest quale sit, ut non repugnet ipsum sibi. </p>\n\n<ul>\n<li>Quorum altera prosunt, nocent altera.</li>\n	<li>Vidit Homerus probari fabulam non posse, si cantiunculis tantus irretitus vir teneretur;</li>\n</ul>\n<p><a href="http://loripsum.net/" target="_blank">Murenam te accusante defenderem.</a> Materiam vero rerum et copiam apud hos exilem, apud illos uberrimam reperiemus. Vitae autem degendae ratio maxime quidem illis placuit quieta. Modo etiam paulum ad dexteram de via declinavi, ut ad Pericli sepulcrum accederem. </p>\n\n<ol>\n<li>Sed finge non solum callidum eum, qui aliquid improbe faciat, verum etiam praepotentem, ut M.</li>\n	<li>Ergo ita: non posse honeste vivi, nisi honeste vivatur?</li>\n	<li>His similes sunt omnes, qui virtuti student levantur vitiis, levantur erroribus, nisi forte censes Ti.</li>\n	<li>Quamquam in hac divisione rem ipsam prorsus probo, elegantiam desidero.</li>\n	<li>Piso, familiaris noster, et alia multa et hoc loco Stoicos irridebat: Quid enim?</li>\n	<li>Nam neque virtute retinetur ille in vita, nec iis, qui sine virtute sunt, mors est oppetenda.</li>\n</ol>\n<p>Cum ageremus, inquit, vitae beatum et eundem supremum diem, scribebamus haec. Nam illud vehementer repugnat, eundem beatum esse et multis malis oppressum. <i>Odium autem et invidiam facile vitabis.</i> Mihi, inquam, qui te id ipsum rogavi? Mihi vero, inquit, placet agi subtilius et, ut ipse dixisti, pressius. </p>', NULL),
(3, 'omnis-enim-est-natura-diligens-sui', '2019-10-23 08:47:30', '[[regtime]]', '2019-10-31 21:41:51', NULL, 1, 'published', '[]', 'Omnis enim est natura diligens sui.', '{"file":"placeholder_a55681849805.jpg","title":"placeholder","alt":"placeholder"}', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nos grave certamen belli clademque tenemus, Graecia quam Troiae divino numine vexit, Omniaque e latis rerum vestigia terris. Quid ergo aliud intellegetur nisi uti ne quae pars naturae neglegatur? <mark>Age sane, inquam.</mark> Omnium enim rerum principia parva sunt, sed suis progressionibus usa augentur nec sine causa; Facillimum id quidem est, inquam. Duo Reges: constructio interrete. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Atque haec coniunctio confusioque virtutum tamen a philosophis ratione quadam distinguitur. Quo plebiscito decreta a senatu est consuli quaestio Cn. <i>Ut proverbia non nulla veriora sint quam vestra dogmata.</i> Sed quid ages tandem, si utilitas ab amicitia, ut fit saepe, defecerit? Cur haec eadem Democritus? Mihi enim erit isdem istis fortasse iam utendum. Duo Reges: constructio interrete. Nam quibus rebus efficiuntur voluptates, eae non sunt in potestate sapientis. </p>\n\n<ul>\n<li>Roges enim Aristonem, bonane ei videantur haec: vacuitas doloris, divitiae, valitudo;</li>\n	<li>Summum ením bonum exposuit vacuitatem doloris;</li>\n	<li>Eodem modo is enim tibi nemo dabit, quod, expetendum sit, id esse laudabile.</li>\n	<li>Fortasse id optimum, sed ubi illud: Plus semper voluptatis?</li>\n</ul>\n<ol>\n<li>Incommoda autem et commoda-ita enim estmata et dustmata appello-communia esse voluerunt, paria noluerunt.</li>\n	<li>Quantam rem agas, ut Circeis qui habitet totum hunc mundum suum municipium esse existimet?</li>\n	<li>Color egregius, integra valitudo, summa gratia, vita denique conferta voluptatum omnium varietate.</li>\n	<li>Quis est autem dignus nomine hominis, qui unum diem totum velit esse in genere isto voluptatis?</li>\n	<li>Tum Piso: Atqui, Cicero, inquit, ista studia, si ad imitandos summos viros spectant, ingeniosorum sunt;</li>\n	<li>Quod cum dixissent, ille contra.</li>\n	<li>In omni enim arte vel studio vel quavis scientia vel in ipsa virtute optimum quidque rarissimum est.</li>\n</ol>\n<p>Si enim ita est, vide ne facinus facias, cum mori suadeas. Sed tamen intellego quid velit. Age, inquies, ista parva sunt. Sed vos squalidius, illorum vides quam niteat oratio. Universa enim illorum ratione cum tota vestra confligendum puto. Ita fit cum gravior, tum etiam splendidior oratio. </p>\n\n<p><a href="http://loripsum.net/" target="_blank">Ita nemo beato beatior.</a> Virtutibus igitur rectissime mihi videris et ad consuetudinem nostrae orationis vitia posuisse contraria. <i>Illud non continuo, ut aeque incontentae.</i> Hanc quoque iucunditatem, si vis, transfer in animum; Non enim quaero quid verum, sed quid cuique dicendum sit. <b>Immo alio genere;</b> <b>At coluit ipse amicitias.</b> Se dicere inter honestum et turpe nimium quantum, nescio quid inmensum, inter ceteras res nihil omnino interesse. </p>', NULL),
(4, 'quo-modo-autem-philosophus-loquitur', '2019-11-25 14:12:36', '[[regtime]]', '2020-03-15 02:09:18', NULL, 1, 'published', '[]', 'Quo modo autem philosophus loquitur?', '{"file":"placeholder_14a0cf09a507.jpg","title":"placeholder","alt":"placeholder"}', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quonam, inquit, modo? Commoda autem et incommoda in eo genere sunt, quae praeposita et reiecta diximus; Sit enim idem caecus, debilis. Qui igitur convenit ab alia voluptate dicere naturam proficisci, in alia summum bonum ponere? <a href="http://loripsum.net/" target="_blank">Duo Reges: constructio interrete.</a> </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <a href="http://loripsum.net/" target="_blank">Bonum liberi: misera orbitas.</a> Num igitur eum postea censes anxio animo aut sollicito fuisse? Nam memini etiam quae nolo, oblivisci non possum quae volo. Duo Reges: constructio interrete. An me, inquam, nisi te audire vellem, censes haec dicturum fuisse? An nisi populari fama? </p>\n\n<ol>\n<li>Quid, si reviviscant Platonis illi et deinceps qui eorum auditores fuerunt, et tecum ita loquantur?</li>\n	<li>Quorum sine causa fieri nihil putandum est.</li>\n	<li>Quae cum essent dicta, finem fecimus et ambulandi et disputandi.</li>\n</ol>\n<ul>\n<li>Res enim concurrent contrariae.</li>\n	<li>Ego quoque, inquit, didicerim libentius si quid attuleris, quam te reprehenderim.</li>\n	<li>Egone quaeris, inquit, quid sentiam?</li>\n	<li>Quasi ego id curem, quid ille aiat aut neget.</li>\n</ul>\n<p>Certe nihil nisi quod possit ipsum propter se iure laudari. Obsecro, inquit, Torquate, haec dicit Epicurus? Mene ergo et Triarium dignos existimas, apud quos turpiter loquare? Conferam tecum, quam cuique verso rem subicias; Si qua in iis corrigere voluit, deteriora fecit. Ita ne hoc quidem modo paria peccata sunt. </p>\n\n<p>An, partus ancillae sitne in fructu habendus, disseretur inter principes civitatis, P. Tu vero, inquam, ducas licet, si sequetur; <i>Honesta oratio, Socratica, Platonis etiam.</i> <a href="http://loripsum.net/" target="_blank">Nam ante Aristippus, et ille melius.</a> </p>', NULL),
(5, 'quo-modo', '2019-07-30 13:46:01', '[[regtime]]', '2020-03-13 03:17:58', NULL, 1, 'published', '[]', 'Quo modo?', '{"file":"placeholder_4b1582a42be0.jpg","title":"placeholder","alt":"placeholder"}', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duo Reges: constructio interrete. <b>Expectoque quid ad id, quod quaerebam, respondeas.</b> Omnes enim iucundum motum, quo sensus hilaretur. </p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid, si etiam iucunda memoria est praeteritorum malorum? Plane idem, inquit, et maxima quidem, qua fieri nulla maior potest. Neque enim civitas in seditione beata esse potest nec in discordia dominorum domus; Itaque his sapiens semper vacabit. Primum quid tu dicis breve? </p>\n\n<p>Idemne potest esse dies saepius, qui semel fuit? Ut id aliis narrare gestiant? <b>Quantum Aristoxeni ingenium consumptum videmus in musicis?</b> <i>Sin tantum modo ad indicia veteris memoriae cognoscenda, curiosorum.</i> Mihi vero, inquit, placet agi subtilius et, ut ipse dixisti, pressius. Nihil ad rem! Ne sit sane; <i>Memini vero, inquam;</i> <i>Putabam equidem satis, inquit, me dixisse.</i> <b>Estne, quaeso, inquam, sitienti in bibendo voluptas?</b> An ea, quae per vinitorem antea consequebatur, per se ipsa curabit? Quo tandem modo? Scaevola tribunus plebis ferret ad plebem vellentne de ea re quaeri. </p>\n\n<ul>\n<li>Mihi quidem Antiochum, quem audis, satis belle videris attendere.</li>\n	<li>Mihi, inquam, qui te id ipsum rogavi?</li>\n	<li>Negat esse eam, inquit, propter se expetendam.</li>\n	<li>Quae tamen a te agetur non melior, quam illae sunt, quas interdum optines.</li>\n</ul>\n<ol>\n<li>Quid igitur dubitamus in tota eius natura quaerere quid sit effectum?</li>\n	<li>Multoque hoc melius nos veriusque quam Stoici.</li>\n	<li>Ita redarguitur ipse a sese, convincunturque scripta eius probitate ipsius ac moribus.</li>\n	<li>Sunt enim prima elementa naturae, quibus auctis vírtutis quasi germen efficitur.</li>\n	<li>Id enim volumus, id contendimus, ut officii fructus sit ipsum officium.</li>\n</ol>\n<p>Non potes, nisi retexueris illa. Mihi, inquam, qui te id ipsum rogavi? Primum cur ista res digna odio est, nisi quod est turpis? Duo Reges: constructio interrete. Quae cum praeponunt, ut sit aliqua rerum selectio, naturam videntur sequi; Immo videri fortasse. </p>', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `bolt_relations`
--

CREATE TABLE `bolt_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_contenttype` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `from_id` int(11) NOT NULL,
  `to_contenttype` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `to_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4C524BC3EA11294378CED90B` (`from_contenttype`,`from_id`),
  KEY `IDX_4C524BC35ACD264530354A65` (`to_contenttype`,`to_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bolt_showcases`
--

CREATE TABLE `bolt_showcases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `datecreated` datetime NOT NULL,
  `datechanged` datetime NOT NULL,
  `datepublish` datetime DEFAULT NULL,
  `datedepublish` datetime DEFAULT NULL,
  `ownerid` int(11) DEFAULT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `templatefields` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `title` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `html` longtext COLLATE utf8_unicode_ci,
  `textarea` longtext COLLATE utf8_unicode_ci,
  `markdown` longtext COLLATE utf8_unicode_ci,
  `geolocation` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `embed` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `video` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `image` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `imagelist` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `file` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filelist` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `checkbox` tinyint(1) NOT NULL DEFAULT '0',
  `datetime` datetime DEFAULT NULL,
  `date` date DEFAULT NULL,
  `integerfield` int(11) NOT NULL DEFAULT '0',
  `floatfield` double NOT NULL DEFAULT '0',
  `selectfield` longtext COLLATE utf8_unicode_ci,
  `multiselect` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json)',
  `selectentry` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_C5F751E8989D9B62` (`slug`),
  KEY `IDX_C5F751E8AFBA6FD8` (`datecreated`),
  KEY `IDX_C5F751E8BE74E59A` (`datechanged`),
  KEY `IDX_C5F751E8A5131421` (`datepublish`),
  KEY `IDX_C5F751E8B7805520` (`datedepublish`),
  KEY `IDX_C5F751E87B00651C` (`status`),
  KEY `IDX_C5F751E8FD4718AE` (`integerfield`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `bolt_showcases`
--

INSERT INTO `bolt_showcases` VALUES
(1, 'quam-nemo-umquam-voluptatem-appellavit-appellat', '2020-03-03 10:26:37', '[[regtime]]', '2019-11-20 03:50:45', NULL, 1, 'published', '[]', 'Quam nemo umquam voluptatem appellavit, appellat;', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. At hoc in eo M. Cum audissem Antiochum, Brute, ut solebam, cum M. Non semper, inquam; Iam in altera philosophiae parte. Nihil ad rem! Ne sit sane; Hoc loco tenere se Triarius non potuit. Omnis enim est natura diligens sui. </p>\n\n<ul>\n<li>Nam quid possumus facere melius?</li>\n	<li>Hoc est vim afferre, Torquate, sensibus, extorquere ex animis cognitiones verborum, quibus inbuti sumus.</li>\n	<li>Nemo nostrum istius generis asotos iucunde putat vivere.</li>\n	<li>Honesta oratio, Socratica, Platonis etiam.</li>\n	<li>Quoniam, si dis placet, ab Epicuro loqui discimus.</li>\n	<li>Quo plebiscito decreta a senatu est consuli quaestio Cn.</li>\n</ul>\n<p>Graecum enim hunc versum nostis omnes-: Suavis laborum est praeteritorum memoria. Duo Reges: constructio interrete. Efficiens dici potest. <a href="http://loripsum.net/" target="_blank">De quibus cupio scire quid sentias.</a> </p>\n\n<p>Videamus animi partes, quarum est conspectus illustrior; Quid, si non sensus modo ei sit datus, verum etiam animus hominis? Mihi, inquam, qui te id ipsum rogavi? Solum praeterea formosum, solum liberum, solum civem, stultost; Quid ergo aliud intellegetur nisi uti ne quae pars naturae neglegatur? Illud dico, ea, quae dicat, praeclare inter se cohaerere. Illum mallem levares, quo optimum atque humanissimum virum, Cn. Theophrastus mediocriterne delectat, cum tractat locos ab Aristotele ante tractatos? Tibi hoc incredibile, quod beatissimum. Sin aliud quid voles, postea. Cuius quidem, quoniam Stoicus fuit, sententia condemnata mihi videtur esse inanitas ista verborum. </p>\n\n<ol>\n<li>Eam si varietatem diceres, intellegerem, ut etiam non dicente te intellego;</li>\n	<li>Quae qui non vident, nihil umquam magnum ac cognitione dignum amaverunt.</li>\n	<li>Huic mori optimum esse propter desperationem sapientiae, illi propter spem vivere.</li>\n	<li>Compensabatur, inquit, cum summis doloribus laetitia.</li>\n</ol>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ea possunt paria non esse. Qui enim voluptatem ipsam contemnunt, iis licet dicere se acupenserem maenae non anteponere. Duo Reges: constructio interrete. Aliter homines, aliter philosophos loqui putas oportere? <a href=''http://loripsum.net/'' target=''_blank''>At enim hic etiam dolore.</a> Praeclare Laelius, et recte sofñw, illudque vere: O Publi, o gurges, Galloni! es homo miser, inquit. Ergo hoc quidem apparet, nos ad agendum esse natos. Quae cum praeponunt, ut sit aliqua rerum selectio, naturam videntur sequi; </p>\n\n<p>Cur post Tarentum ad Archytam? Eorum enim est haec querela, qui sibi cari sunt seseque diligunt. Quo modo autem optimum, si bonum praeterea nullum est? Traditur, inquit, ab Epicuro ratio neglegendi doloris. Se dicere inter honestum et turpe nimium quantum, nescio quid inmensum, inter ceteras res nihil omnino interesse. Qui convenit? Quid ergo aliud intellegetur nisi uti ne quae pars naturae neglegatur? </p>\n\n<ol>\n	<li>Nec vero alia sunt quaerenda contra Carneadeam illam sententiam.</li>\n	<li>Non perfecti autem homines et tamen ingeniis excellentibus praediti excitantur saepe gloria, quae habet speciem honestatis et similitudinem.</li>\n	<li>Tum Torquatus: Prorsus, inquit, assentior;</li>\n	<li>Sed utrum hortandus es nobis, Luci, inquit, an etiam tua sponte propensus es?</li>\n</ol>\n\n\n<ul>\n	<li>Non igitur potestis voluptate omnia dirigentes aut tueri aut retinere virtutem.</li>\n	<li>Ergo opifex plus sibi proponet ad formarum quam civis excellens ad factorum pulchritudinem?</li>\n	<li>Cur tantas regiones barbarorum pedibus obiit, tot maria transmisit?</li>\n	<li>Et quidem iure fortasse, sed tamen non gravissimum est testimonium multitudinis.</li>\n	<li>Quis enim est, qui non videat haec esse in natura rerum tria?</li>\n</ul>\n\n\n<p>Vitae autem degendae ratio maxime quidem illis placuit quieta. At iste non dolendi status non vocatur voluptas. Quod mihi quidem visus est, cum sciret, velle tamen confitentem audire Torquatum. <b>Dici enim nihil potest verius.</b> Mihi quidem Antiochum, quem audis, satis belle videris attendere. Tubulum fuisse, qua illum, cuius is condemnatus est rogatione, P. </p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Si enim ad populum me vocas, eum. Itaque sensibus rationem adiunxit et ratione effecta sensus non reliquit. Habent enim et bene longam et satis litigiosam disputationem. Polemoni et iam ante Aristoteli ea prima visa sunt, quae paulo ante dixi. Duo Reges: constructio interrete. Tu autem negas fortem esse quemquam posse, qui dolorem malum putet. Restatis igitur vos; Miserum hominem! Si dolor summum malum est, dici aliter non potest. \n\n\n	Bonum integritas corporis: misera debilitas.\n	Dic in quovis conventu te omnia facere, ne doleas.\n	Oculorum, inquit Plato, est in nobis sensus acerrimus, quibus sapientiam non cernimus.\n	Vidit Homerus probari fabulam non posse, si cantiunculis tantus irretitus vir teneretur;\n	Portenta haec esse dicit, neque ea ratione ullo modo posse vivi;\n\n\n\nQuid enim ab antiquis ex eo genere, quod ad disserendum valet, praetermissum est? Id est enim, de quo quaerimus. Summus dolor plures dies manere non potest? \n\n\n	Itaque eos id agere, ut a se dolores, morbos, debilitates repellant.\n	Cur tantas regiones barbarorum pedibus obiit, tot maria transmisit?\n	Reicietur etiam Carneades, nec ulla de summo bono ratio aut voluptatis non dolendive particeps aut honestatis expers probabitur.\n	Quamquam ab iis philosophiam et omnes ingenuas disciplinas habemus;\n	Sed ea mala virtuti magnitudine obruebantur.\n\n\n\nQuo tandem modo? Conferam tecum, quam cuique verso rem subicias; Atqui haec patefactio quasi rerum opertarum, cum quid quidque sit aperitur, definitio est. Respondent extrema primis, media utrisque, omnia omnibus. Si stante, hoc natura videlicet vult, salvam esse se, quod concedimus; Quae iam oratio non a philosopho aliquo, sed a censore opprimenda est. Quantum Aristoxeni ingenium consumptum videmus in musicis? Quae fere omnia appellantur uno ingenii nomine, easque virtutes qui habent, ingeniosi vocantur. ', NULL, '""', NULL, '{"file":"placeholder_29d9776450ee.jpg","title":"placeholder","alt":"placeholder"}', '[{"filename":"placeholder_edfb904510e3.jpg","title":"Placeholder_edfb904510e3.","alt":"Placeholder_edfb904510e3."},{"filename":"placeholder_2f2ecc39d7b6.jpg","title":"Placeholder_2f2ecc39d7b6.","alt":"Placeholder_2f2ecc39d7b6."},{"filename":"placeholder_a55681849805.jpg","title":"Placeholder_a55681849805.","alt":"Placeholder_a55681849805."}]', NULL, '[]', 1, '2020-09-27 20:57:17', '2020-08-05', -919, -339.087, NULL, NULL, NULL),
(2, 'hic-nihil-fuit-quod-quaereremus', '2020-04-10 22:50:23', '[[regtime]]', '2019-09-12 03:18:16', NULL, 1, 'published', '[]', 'Hic nihil fuit, quod quaereremus.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliter enim explicari, quod quaeritur, non potest. <b>Sed ego in hoc resisto;</b> <a href="http://loripsum.net/" target="_blank">Restinguet citius, si ardentem acceperit.</a> Duo Reges: constructio interrete. Dic in quovis conventu te omnia facere, ne doleas. <i>Scio enim esse quosdam, qui quavis lingua philosophari possint;</i> </p>\n\n<p>Nam de isto magna dissensio est. Nunc omni virtuti vitium contrario nomine opponitur. Illa sunt similia: hebes acies est cuipiam oculorum, corpore alius senescit; Non minor, inquit, voluptas percipitur ex vilissimis rebus quam ex pretiosissimis. Quare ad ea primum, si videtur; Aliter enim explicari, quod quaeritur, non potest. Haec para/doca illi, nos admirabilia dicamus. </p>\n\n<p>Fortemne possumus dicere eundem illum Torquatum? Qui autem esse poteris, nisi te amor ipse ceperit? <b>Ille enim occurrentia nescio quae comminiscebatur;</b> Nam si propter voluptatem, quae est ista laus, quae possit e macello peti? Quare conare, quaeso. <a href="http://loripsum.net/" target="_blank">An dolor longissimus quisque miserrimus, voluptatem non optabiliorem diuturnitas facit?</a> </p>\n\n<ul>\n<li>Atque ab his initiis profecti omnium virtutum et originem et progressionem persecuti sunt.</li>\n	<li>Sed quid minus probandum quam esse aliquem beatum nec satis beatum?</li>\n	<li>Quarum cum una sit, qua mores conformari putantur, differo eam partem, quae quasi stirps ets huius quaestionis.</li>\n	<li>Ac ne plura complectar-sunt enim innumerabilia-, bene laudata virtus voluptatis aditus intercludat necesse est.</li>\n	<li>Quod non faceret, si in voluptate summum bonum poneret.</li>\n	<li>Inde igitur, inquit, ordiendum est.</li>\n</ul>\n<ol>\n<li>Qui ita affectus, beatum esse numquam probabis;</li>\n	<li>Te enim iudicem aequum puto, modo quae dicat ille bene noris.</li>\n	<li>Vitiosum est enim in dividendo partem in genere numerare.</li>\n	<li>Erit enim instructus ad mortem contemnendam, ad exilium, ad ipsum etiam dolorem.</li>\n	<li>Expressa vero in iis aetatibus, quae iam confirmatae sunt.</li>\n	<li>An hoc usque quaque, aliter in vita?</li>\n	<li>Quid ergo attinet gloriose loqui, nisi constanter loquare?</li>\n</ol>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Huius ego nunc auctoritatem sequens idem faciam. Sed tamen enitar et, si minus multa mihi occurrent, non fugiam ista popularia. <b>Nemo igitur esse beatus potest.</b> Sin laboramus, quis est, qui alienae modum statuat industriae? Duo Reges: constructio interrete. Quae cum magnifice primo dici viderentur, considerata minus probabantur. Gloriosa ostentatio in constituendo summo bono. <b>Ita multa dicunt, quae vix intellegam.</b> </p>\n\n<p>Sed utrum hortandus es nobis, Luci, inquit, an etiam tua sponte propensus es? <b>Audeo dicere, inquit.</b> Quid ei reliquisti, nisi te, quoquo modo loqueretur, intellegere, quid diceret? Est enim effectrix multarum et magnarum voluptatum. Vide igitur ne non debeas verbis nostris uti, sententiis tuis. Graecum enim hunc versum nostis omnes-: Suavis laborum est praeteritorum memoria. Dic in quovis conventu te omnia facere, ne doleas. <a href=''http://loripsum.net/'' target=''_blank''>Non risu potius quam oratione eiciendum?</a> </p>\n\n<p>Quod autem magnum dolorem brevem, longinquum levem esse dicitis, id non intellego quale sit. Conferam avum tuum Drusum cum C. Haec igitur Epicuri non probo, inquam. Quae cum ita sint, effectum est nihil esse malum, quod turpe non sit. </p>\n\n<ol>\n	<li>Nunc dicam de voluptate, nihil scilicet novi, ea tamen, quae te ipsum probaturum esse confidam.</li>\n	<li>Similiter sensus, cum accessit ad naturam, tuetur illam quidem, sed etiam se tuetur;</li>\n	<li>Quare hoc videndum est, possitne nobis hoc ratio philosophorum dare.</li>\n	<li>Sit hoc ultimum bonorum, quod nunc a me defenditur;</li>\n</ol>\n\n\n<ul>\n	<li>Nam Pyrrho, Aristo, Erillus iam diu abiecti.</li>\n	<li>Cum ageremus, inquit, vitae beatum et eundem supremum diem, scribebamus haec.</li>\n	<li>Cuius quidem, quoniam Stoicus fuit, sententia condemnata mihi videtur esse inanitas ista verborum.</li>\n	<li>Primum in nostrane potestate est, quid meminerimus?</li>\n	<li>Ex quo, id quod omnes expetunt, beate vivendi ratio inveniri et comparari potest.</li>\n</ul>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. At quicum ioca seria, ut dicitur, quicum arcana, quicum occulta omnia? Videamus animi partes, quarum est conspectus illustrior; Equidem, sed audistine modo de Carneade? Nam bonum ex quo appellatum sit, nescio, praepositum ex eo credo, quod praeponatur aliis. Quamvis enim depravatae non sint, pravae tamen esse possunt. Bonum valitudo: miser morbus. \n\n\n	Nonne videmus quanta perturbatio rerum omnium consequatur, quanta confusio?\n	Quis istud possit, inquit, negare?\n	Huic mori optimum esse propter desperationem sapientiae, illi propter spem vivere.\n	Haec igitur Epicuri non probo, inquam.\n\n\n\n\n	Etsi ea quidem, quae adhuc dixisti, quamvis ad aetatem recte isto modo dicerentur.\n	Verum hoc loco sumo verbis his eandem certe vim voluptatis Epicurum nosse quam ceteros.\n	Esse enim quam vellet iniquus iustus poterat inpune.\n	Quod mihi quidem visus est, cum sciret, velle tamen confitentem audire Torquatum.\n	Aliis esse maiora, illud dubium, ad id, quod summum bonum dicitis, ecquaenam possit fieri accessio.\n\n\n\nDuo Reges: constructio interrete. Solum praeterea formosum, solum liberum, solum civem, stultost; Traditur, inquit, ab Epicuro ratio neglegendi doloris. Non prorsus, inquit, omnisque, qui sine dolore sint, in voluptate, et ea quidem summa, esse dico. Erat enim Polemonis. \n\nAn vero, inquit, quisquam potest probare, quod perceptfum, quod. Ac ne plura complectar-sunt enim innumerabilia-, bene laudata virtus voluptatis aditus intercludat necesse est. Nam quid possumus facere melius? Nam aliquando posse recte fieri dicunt nulla expectata nec quaesita voluptate. Minime vero istorum quidem, inquit. Cupit enim dícere nihil posse ad beatam vitam deesse sapienti. Materiam vero rerum et copiam apud hos exilem, apud illos uberrimam reperiemus. Qui convenit? Res enim se praeclare habebat, et quidem in utraque parte. Quid ergo? ', NULL, '""', NULL, '{"file":"placeholder_38a2bd1e1ddf.jpg","title":"placeholder","alt":"placeholder"}', '[{"filename":"placeholder_54c39e274cc7.jpg","title":"Placeholder_54c39e274cc7.","alt":"Placeholder_54c39e274cc7."},{"filename":"placeholder_4b1582a42be0.jpg","title":"Placeholder_4b1582a42be0.","alt":"Placeholder_4b1582a42be0."},{"filename":"placeholder_c71e0798e830.jpg","title":"Placeholder_c71e0798e830.","alt":"Placeholder_c71e0798e830."}]', NULL, '[]', 1, '2020-01-07 07:19:39', '2020-07-17', 222, -121.128, NULL, NULL, NULL),
(3, 'graccho-eius-fere-aequali', '2019-05-23 19:20:03', '[[regtime]]', '2020-02-07 06:03:11', NULL, 1, 'published', '[]', 'Graccho, eius fere, aequalí?', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quorum sine causa fieri nihil putandum est. Nam si beatus umquam fuisset, beatam vitam usque ad illum a Cyro extructum rogum pertulisset. Si mala non sunt, iacet omnis ratio Peripateticorum. Consequens enim est et post oritur, ut dixi. A quibus propter discendi cupiditatem videmus ultimas terras esse peragratas. Duo Reges: constructio interrete. </p>\n\n<p>At quicum ioca seria, ut dicitur, quicum arcana, quicum occulta omnia? Certe nihil nisi quod possit ipsum propter se iure laudari. <a href="http://loripsum.net/" target="_blank">Omnia contraria, quos etiam insanos esse vultis.</a> Me igitur ipsum ames oportet, non mea, si veri amici futuri sumus. <mark>Idem iste, inquam, de voluptate quid sentit?</mark> Quamquam ab iis philosophiam et omnes ingenuas disciplinas habemus; <a href="http://loripsum.net/" target="_blank">Praeclarae mortes sunt imperatoriae;</a> <a href="http://loripsum.net/" target="_blank">Quid ait Aristoteles reliquique Platonis alumni?</a> Sin dicit obscurari quaedam nec apparere, quia valde parva sint, nos quoque concedimus; Respondeat totidem verbis. </p>\n\n<ul>\n<li>Quod praeceptum quia maius erat, quam ut ab homine videretur, idcirco assignatum est deo.</li>\n	<li>Cum id fugiunt, re eadem defendunt, quae Peripatetici, verba.</li>\n</ul>\n<p>Quod autem principium officii quaerunt, melius quam Pyrrho; Ergo id est convenienter naturae vivere, a natura discedere. Eadem nunc mea adversum te oratio est. <a href="http://loripsum.net/" target="_blank">Beatus sibi videtur esse moriens.</a> Philosophi autem in suis lectulis plerumque moriuntur. Ergo ita: non posse honeste vivi, nisi honeste vivatur? </p>\n\n<ol>\n<li>Qui ita affectus, beatum esse numquam probabis;</li>\n	<li>Venit enim mihi Platonis in mentem, quem accepimus primum hic disputare solitum;</li>\n	<li>Ergo instituto veterum, quo etiam Stoici utuntur, hinc capiamus exordium.</li>\n</ol>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quo plebiscito decreta a senatu est consuli quaestio Cn. Quod autem ratione actum est, id officium appellamus. Quae quidem sapientes sequuntur duce natura tamquam videntes; Sic, et quidem diligentius saepiusque ista loquemur inter nos agemusque communiter. Quis enim potest ea, quae probabilia videantur ei, non probare? Duo Reges: constructio interrete. Certe, nisi voluptatem tanti aestimaretis. Illa sunt similia: hebes acies est cuipiam oculorum, corpore alius senescit; An vero, inquit, quisquam potest probare, quod perceptfum, quod. Iam id ipsum absurdum, maximum malum neglegi. </p>\n\n<p>Itaque mihi non satis videmini considerare quod iter sit naturae quaeque progressio. Quod autem in homine praestantissimum atque optimum est, id deseruit. <a href=''http://loripsum.net/'' target=''_blank''>Quam ob rem tandem, inquit, non satisfacit?</a> </p>\n\n<ol>\n	<li>Amicitiam autem adhibendam esse censent, quia sit ex eo genere, quae prosunt.</li>\n	<li>Quibus natura iure responderit non esse verum aliunde finem beate vivendi, a se principia rei gerendae peti;</li>\n	<li>Quae tamen a te agetur non melior, quam illae sunt, quas interdum optines.</li>\n	<li>Ut in voluptate sit, qui epuletur, in dolore, qui torqueatur.</li>\n	<li>Sed haec quidem liberius ab eo dicuntur et saepius.</li>\n	<li>Etenim nec iustitia nec amicitia esse omnino poterunt, nisi ipsae per se expetuntur.</li>\n	<li>Nihil acciderat ei, quod nollet, nisi quod anulum, quo delectabatur, in mari abiecerat.</li>\n</ol>\n\n\n<ul>\n	<li>Qui ita affectus, beatum esse numquam probabis;</li>\n	<li>Quamvis enim depravatae non sint, pravae tamen esse possunt.</li>\n	<li>Manebit ergo amicitia tam diu, quam diu sequetur utilitas, et, si utilitas amicitiam constituet, tollet eadem.</li>\n</ul>\n\n\n<p>Quamquam ab iis philosophiam et omnes ingenuas disciplinas habemus; Quare ad ea primum, si videtur; Fortemne possumus dicere eundem illum Torquatum? Roges enim Aristonem, bonane ei videantur haec: vacuitas doloris, divitiae, valitudo; Quid ergo attinet gloriose loqui, nisi constanter loquare? <a href=''http://loripsum.net/'' target=''_blank''>Minime vero istorum quidem, inquit.</a> </p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aut haec tibi, Torquate, sunt vituperanda aut patrocinium voluptatis repudiandum. Non dolere, inquam, istud quam vim habeat postea videro; Ego vero volo in virtute vim esse quam maximam; Qui autem de summo bono dissentit de tota philosophiae ratione dissentit. Quis Aristidem non mortuum diligit? Vitiosum est enim in dividendo partem in genere numerare. \n\n\n	Non enim ipsa genuit hominem, sed accepit a natura inchoatum.\n	Sed emolumenta communia esse dicuntur, recte autem facta et peccata non habentur communia.\n	Quarum ambarum rerum cum medicinam pollicetur, luxuriae licentiam pollicetur.\n	Ait enim se, si uratur, Quam hoc suave! dicturum.\n	Nam aliquando posse recte fieri dicunt nulla expectata nec quaesita voluptate.\n	Ut necesse sit omnium rerum, quae natura vigeant, similem esse finem, non eundem.\n\n\n\nCollige omnia, quae soletis: Praesidium amicorum. Duo Reges: constructio interrete. Nam si propter voluptatem, quae est ista laus, quae possit e macello peti? Conferam tecum, quam cuique verso rem subicias; Non est igitur voluptas bonum. Sed in rebus apertissimis nimium longi sumus. At multis malis affectus. Putabam equidem satis, inquit, me dixisse. Sed haec omittamus; \n\n\n	Quae cum magnifice primo dici viderentur, considerata minus probabantur.\n	Cum praesertim illa perdiscere ludus esset.\n	At quicum ioca seria, ut dicitur, quicum arcana, quicum occulta omnia?\n	Sin te auctoritas commovebat, nobisne omnibus et Platoni ipsi nescio quem illum anteponebas?\n	Sed hoc sane concedamus.\n	Universa enim illorum ratione cum tota vestra confligendum puto.\n\n\n\nQuid de Pythagora? Sed haec nihil sane ad rem; Sed ea mala virtuti magnitudine obruebantur. Que Manilium, ab iisque M. Si est nihil nisi corpus, summa erunt illa: valitudo, vacuitas doloris, pulchritudo, cetera. Theophrasti igitur, inquit, tibi liber ille placet de beata vita? Quod autem satis est, eo quicquid accessit, nimium est; Mihi quidem Homerus huius modi quiddam vidisse videatur in iis, quae de Sirenum cantibus finxerit. Traditur, inquit, ab Epicuro ratio neglegendi doloris. Quod ea non occurrentia fingunt, vincunt Aristonem; ', NULL, '""', NULL, '{"file":"placeholder_13c5c2652fe4.jpg","title":"placeholder","alt":"placeholder"}', '[{"filename":"placeholder_d39dade1223e.jpg","title":"Placeholder_d39dade1223e.","alt":"Placeholder_d39dade1223e."},{"filename":"placeholder_54c39e274cc7.jpg","title":"Placeholder_54c39e274cc7.","alt":"Placeholder_54c39e274cc7."},{"filename":"placeholder_d39dade1223e.jpg","title":"Placeholder_d39dade1223e.","alt":"Placeholder_d39dade1223e."}]', NULL, '[]', 0, '2021-01-20 13:13:55', '2020-04-16', 386, -784.191, NULL, NULL, NULL),
(4, 'atqui-reperies-inquit-in-hoc-quidem-pertinacem', '2020-04-12 04:36:44', '[[regtime]]', '2020-01-02 12:47:55', NULL, 1, 'published', '[]', 'Atqui reperies, inquit, in hoc quidem pertinacem;', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed haec nihil sane ad rem; <a href="http://loripsum.net/" target="_blank">Si longus, levis;</a> Omnis enim est natura diligens sui. </p>\n\n<p>Primum in nostrane potestate est, quid meminerimus? Iam id ipsum absurdum, maximum malum neglegi. <a href="http://loripsum.net/" target="_blank">Qui ita affectus, beatum esse numquam probabis;</a> An eum discere ea mavis, quae cum plane perdidiceriti nihil sciat? Hoc mihi cum tuo fratre convenit. Non potes, nisi retexueris illa. </p>\n\n<p>Quam ob rem tandem, inquit, non satisfacit? <b>Duo Reges: constructio interrete.</b> <a href="http://loripsum.net/" target="_blank">Cur deinde Metrodori liberos commendas?</a> Quid enim necesse est, tamquam meretricem in matronarum coetum, sic voluptatem in virtutum concilium adducere? Graecum enim hunc versum nostis omnes-: Suavis laborum est praeteritorum memoria. Mihi quidem Antiochum, quem audis, satis belle videris attendere. Cupit enim dícere nihil posse ad beatam vitam deesse sapienti. <mark>Hic nihil fuit, quod quaereremus.</mark> Nam Pyrrho, Aristo, Erillus iam diu abiecti. </p>\n\n<ul>\n<li>His similes sunt omnes, qui virtuti student levantur vitiis, levantur erroribus, nisi forte censes Ti.</li>\n	<li>Eorum enim est haec querela, qui sibi cari sunt seseque diligunt.</li>\n	<li>Quamquam haec quidem praeposita recte et reiecta dicere licebit.</li>\n	<li>Nos commodius agimus.</li>\n</ul>\n<ol>\n<li>Iam quae corporis sunt, ea nec auctoritatem cum animi partibus, comparandam et cognitionem habent faciliorem.</li>\n	<li>Sin te auctoritas commovebat, nobisne omnibus et Platoni ipsi nescio quem illum anteponebas?</li>\n	<li>Quod autem magnum dolorem brevem, longinquum levem esse dicitis, id non intellego quale sit.</li>\n	<li>Dic in quovis conventu te omnia facere, ne doleas.</li>\n</ol>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Et ille ridens: Video, inquit, quid agas; Summum ením bonum exposuit vacuitatem doloris; Sed eum qui audiebant, quoad poterant, defendebant sententiam suam. Pisone in eo gymnasio, quod Ptolomaeum vocatur, unaque nobiscum Q. Duo Reges: constructio interrete. Solum praeterea formosum, solum liberum, solum civem, stultost; Sic, et quidem diligentius saepiusque ista loquemur inter nos agemusque communiter. </p>\n\n<p>Et non ex maxima parte de tota iudicabis? Scaevola tribunus plebis ferret ad plebem vellentne de ea re quaeri. Ergo ita: non posse honeste vivi, nisi honeste vivatur? Tum ille: Tu autem cum ipse tantum librorum habeas, quos hic tandem requiris? Nam, ut sint illa vendibiliora, haec uberiora certe sunt. <b>Sed haec omittamus;</b> Nunc omni virtuti vitium contrario nomine opponitur. Quamquam haec quidem praeposita recte et reiecta dicere licebit. <b>Sed quid sentiat, non videtis.</b> <i>Etiam beatissimum?</i> Tum ille timide vel potius verecunde: Facio, inquit. Quae animi affectio suum cuique tribuens atque hanc, quam dico. </p>\n\n<p>Beatus sibi videtur esse moriens. At miser, si in flagitiosa et vitiosa vita afflueret voluptatibus. Facile est hoc cernere in primis puerorum aetatulis. Quid enim me prohiberet Epicureum esse, si probarem, quae ille diceret? <i>Sint modo partes vitae beatae.</i> <mark>At enim hic etiam dolore.</mark> <a href=''http://loripsum.net/'' target=''_blank''>Quis hoc dicit?</a> </p>\n\n<ul>\n	<li>Tum mihi Piso: Quid ergo?</li>\n	<li>Quod ea non occurrentia fingunt, vincunt Aristonem;</li>\n	<li>Neque enim disputari sine reprehensione nec cum iracundia aut pertinacia recte disputari potest.</li>\n	<li>Potius ergo illa dicantur: turpe esse, viri non esse debilitari dolore, frangi, succumbere.</li>\n	<li>Idque testamento cavebit is, qui nobis quasi oraculum ediderit nihil post mortem ad nos pertinere?</li>\n</ul>\n\n\n<ol>\n	<li>Sin te auctoritas commovebat, nobisne omnibus et Platoni ipsi nescio quem illum anteponebas?</li>\n	<li>Satisne vobis videor pro meo iure in vestris auribus commentatus?</li>\n	<li>De quibus cupio scire quid sentias.</li>\n	<li>Illa enim, quae prosunt aut quae nocent, aut bona sunt aut mala, quae sint paria necesse est.</li>\n	<li>Pisone in eo gymnasio, quod Ptolomaeum vocatur, unaque nobiscum Q.</li>\n	<li>Est igitur officium eius generis, quod nec in bonis ponatur nec in contrariis.</li>\n</ol>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid iudicant sensus? Ut in geometria, prima si dederis, danda sunt omnia. Is es profecto tu. Immo alio genere; Duo Reges: constructio interrete. Quia nec honesto quic quam honestius nec turpi turpius. Itaque sensibus rationem adiunxit et ratione effecta sensus non reliquit. Non enim solum Torquatus dixit quid sentiret, sed etiam cur. Ad quorum et cognitionem et usum iam corroborati natura ipsa praeeunte deducimur. \n\nScisse enim te quis coarguere possit? Nam quibus rebus efficiuntur voluptates, eae non sunt in potestate sapientis. Terram, mihi crede, ea lanx et maria deprimet. Nec tamen ille erat sapiens quis enim hoc aut quando aut ubi aut unde? Negat esse eam, inquit, propter se expetendam. Tum ille timide vel potius verecunde: Facio, inquit. \n\n\n	Quod autem satis est, eo quicquid accessit, nimium est;\n	An quod ita callida est, ut optime possit architectari voluptates?\n\n\n\n\n	Velut ego nunc moveor.\n	Aliter enim nosmet ipsos nosse non possumus.\n\n\n\nNunc haec primum fortasse audientis servire debemus. Hic nihil fuit, quod quaereremus. Est igitur officium eius generis, quod nec in bonis ponatur nec in contrariis. Summus dolor plures dies manere non potest? Eorum enim omnium multa praetermittentium, dum eligant aliquid, quod sequantur, quasi curta sententia; Satisne ergo pudori consulat, si quis sine teste libidini pareat? ', NULL, '""', NULL, '{"file":"placeholder_34a1663450c9.jpg","title":"placeholder","alt":"placeholder"}', '[{"filename":"placeholder_a55681849805.jpg","title":"Placeholder_a55681849805.","alt":"Placeholder_a55681849805."},{"filename":"placeholder_29d9776450ee.jpg","title":"Placeholder_29d9776450ee.","alt":"Placeholder_29d9776450ee."},{"filename":"placeholder_54c39e274cc7.jpg","title":"Placeholder_54c39e274cc7.","alt":"Placeholder_54c39e274cc7."}]', NULL, '[]', 1, '2020-07-11 04:59:27', '2019-12-15', -76, 920.27, NULL, NULL, NULL),
(5, 'ex-rebus-enim-timiditas-non-ex-vocabulis-nascitur', '2020-04-27 15:44:34', '[[regtime]]', '2019-11-23 11:42:52', NULL, 1, 'published', '[]', 'Ex rebus enim timiditas, non ex vocabulis nascitur.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc ita separantur, ut disiuncta sint, quo nihil potest esse perversius. Aeque enim contingit omnibus fidibus, ut incontentae sint. Philosophi autem in suis lectulis plerumque moriuntur. <a href="http://loripsum.net/" target="_blank">Quae similitudo in genere etiam humano apparet.</a> Iam in altera philosophiae parte. Duo Reges: constructio interrete. Qua tu etiam inprudens utebare non numquam. Illa videamus, quae a te de amicitia dicta sunt. <b>Et quod est munus, quod opus sapientiae?</b> </p>\n\n<p><i>Quod ea non occurrentia fingunt, vincunt Aristonem;</i> Si enim ita est, vide ne facinus facias, cum mori suadeas. Nam illud vehementer repugnat, eundem beatum esse et multis malis oppressum. Nam, ut sint illa vendibiliora, haec uberiora certe sunt. Laboro autem non sine causa; </p>\n\n<p>Ostendit pedes et pectus. Hanc ergo intuens debet institutum illud quasi signum absolvere. Qui est in parvis malis. Non enim iam stirpis bonum quaeret, sed animalis. Quantum Aristoxeni ingenium consumptum videmus in musicis? Hoc est non modo cor non habere, sed ne palatum quidem. Nummus in Croesi divitiis obscuratur, pars est tamen divitiarum. Ita enim vivunt quidam, ut eorum vita refellatur oratio. Aliud igitur esse censet gaudere, aliud non dolere. Quia dolori non voluptas contraria est, sed doloris privatio. </p>\n\n<ul>\n<li>Profectus in exilium Tubulus statim nec respondere ausus;</li>\n	<li>Quae sunt igitur communia vobis cum antiquis, iis sic utamur quasi concessis;</li>\n</ul>\n<ol>\n<li>Hoc enim identidem dicitis, non intellegere nos quam dicatis voluptatem.</li>\n	<li>Ne tum quidem te respicies et cogitabis sibi quemque natum esse et suis voluptatibus?</li>\n	<li>Non igitur potestis voluptate omnia dirigentes aut tueri aut retinere virtutem.</li>\n	<li>Nummus in Croesi divitiis obscuratur, pars est tamen divitiarum.</li>\n</ol>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Octavio fuit, cum illam severitatem in eo filio adhibuit, quem in adoptionem D. <a href=''http://loripsum.net/'' target=''_blank''>Haec dicuntur inconstantissime.</a> Aliter enim nosmet ipsos nosse non possumus. <a href=''http://loripsum.net/'' target=''_blank''>Duo Reges: constructio interrete.</a> Negat enim summo bono afferre incrementum diem. <a href=''http://loripsum.net/'' target=''_blank''>Aliter homines, aliter philosophos loqui putas oportere?</a> </p>\n\n<ol>\n	<li>Neque solum ea communia, verum etiam paria esse dixerunt.</li>\n	<li>Levatio igitur vitiorum magna fit in iis, qui habent ad virtutem progressionis aliquantum.</li>\n	<li>Res tota, Torquate, non doctorum hominum, velle post mortem epulis celebrari memoriam sui nominis.</li>\n	<li>Hoc dixerit potius Ennius: Nimium boni est, cui nihil est mali.</li>\n	<li>Quare hoc videndum est, possitne nobis hoc ratio philosophorum dare.</li>\n</ol>\n\n\n<p>Immo videri fortasse. Cur tantas regiones barbarorum pedibus obiit, tot maria transmisit? Expressa vero in iis aetatibus, quae iam confirmatae sunt. Quamquam tu hanc copiosiorem etiam soles dicere. Inde igitur, inquit, ordiendum est. Itaque mihi non satis videmini considerare quod iter sit naturae quaeque progressio. Sin dicit obscurari quaedam nec apparere, quia valde parva sint, nos quoque concedimus; <a href=''http://loripsum.net/'' target=''_blank''>Sed haec omittamus;</a> <b>Quippe: habes enim a rhetoribus;</b> Duo enim genera quae erant, fecit tria. </p>\n\n<p>Tum Piso: Quoniam igitur aliquid omnes, quid Lucius noster? <a href=''http://loripsum.net/'' target=''_blank''>Magna laus.</a> Sin autem est in ea, quod quidam volunt, nihil impedit hanc nostram comprehensionem summi boni. Sed haec quidem liberius ab eo dicuntur et saepius. </p>\n\n<ul>\n	<li>Multoque hoc melius nos veriusque quam Stoici.</li>\n	<li>Habes, inquam, Cato, formam eorum, de quibus loquor, philosophorum.</li>\n	<li>Non dolere, inquam, istud quam vim habeat postea videro;</li>\n	<li>Sed venio ad inconstantiae crimen, ne saepius dicas me aberrare;</li>\n</ul>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Verum hoc loco sumo verbis his eandem certe vim voluptatis Epicurum nosse quam ceteros. Vidit Homerus probari fabulam non posse, si cantiunculis tantus irretitus vir teneretur; Conferam tecum, quam cuique verso rem subicias; Istam voluptatem perpetuam quis potest praestare sapienti? Hoc positum in Phaedro a Platone probavit Epicurus sensitque in omni disputatione id fieri oportere. Duo Reges: constructio interrete. Immo videri fortasse. Ex quo intellegitur officium medium quiddam esse, quod neque in bonis ponatur neque in contrariis. \n\n\n	Bona autem corporis huic sunt, quod posterius posui, similiora.\n	Quare, quoniam de primis naturae commodis satis dietum est nunc de maioribus consequentibusque videamus.\n	At certe gravius.\n	Sequitur disserendi ratio cognitioque naturae;\n\n\n\n\n	Nihil acciderat ei, quod nollet, nisi quod anulum, quo delectabatur, in mari abiecerat.\n	Maximas vero virtutes iacere omnis necesse est voluptate dominante.\n	Mene ergo et Triarium dignos existimas, apud quos turpiter loquare?\n\n\n\nEt certamen honestum et disputatio splendida! omnis est enim de virtutis dignitate contentio. Vide ne ista sint Manliana vestra aut maiora etiam, si imperes quod facere non possim. Cum autem in quo sapienter dicimus, id a primo rectissime dicitur. Cum audissem Antiochum, Brute, ut solebam, cum M. Duae sunt enim res quoque, ne tu verba solum putes. Quod ea non occurrentia fingunt, vincunt Aristonem; Quod quidem iam fit etiam in Academia. In quibus doctissimi illi veteres inesse quiddam caeleste et divinum putaverunt. Sed quid sentiat, non videtis. Gerendus est mos, modo recte sentiat. \n\nFaceres tu quidem, Torquate, haec omnia; Quo tandem modo? Bonum valitudo: miser morbus. Polemoni et iam ante Aristoteli ea prima visa sunt, quae paulo ante dixi. Quid affers, cur Thorius, cur Caius Postumius, cur omnium horum magister, Orata, non iucundissime vixerit? Sed vobis voluptatum perceptarum recordatio vitam beatam facit, et quidem corpore perceptarum. Sed quid attinet de rebus tam apertis plura requirere? Quorum sine causa fieri nihil putandum est. ', NULL, '""', NULL, '{"file":"placeholder_3d7a64fc4b50.jpg","title":"placeholder","alt":"placeholder"}', '[{"filename":"placeholder_14a0cf09a507.jpg","title":"Placeholder_14a0cf09a507.","alt":"Placeholder_14a0cf09a507."},{"filename":"placeholder_29d9776450ee.jpg","title":"Placeholder_29d9776450ee.","alt":"Placeholder_29d9776450ee."},{"filename":"placeholder_29d9776450ee.jpg","title":"Placeholder_29d9776450ee.","alt":"Placeholder_29d9776450ee."}]', NULL, '[]', 1, '2020-07-28 10:34:44', '2021-03-22', -311, -569.432, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `bolt_taxonomy`
--

CREATE TABLE `bolt_taxonomy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `contenttype` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `taxonomytype` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `sortorder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `IDX_ABAA120084A0A3ED` (`content_id`),
  KEY `IDX_ABAA1200745E1826` (`contenttype`),
  KEY `IDX_ABAA1200FE2A268F` (`taxonomytype`),
  KEY `IDX_ABAA1200989D9B62` (`slug`),
  KEY `IDX_ABAA1200FEA3B3F9` (`sortorder`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=66 ;

--
-- Dumping data for table `bolt_taxonomy`
--

INSERT INTO `bolt_taxonomy` VALUES
(1, 1, 'pages', 'groups', 'other', 'The other stuff', 880),
(2, 2, 'pages', 'groups', 'other', 'The other stuff', 462),
(3, 3, 'pages', 'groups', 'meta', 'Meta group', 870),
(4, 4, 'pages', 'groups', 'main', 'The main group', 117),
(5, 5, 'pages', 'groups', 'other', 'The other stuff', 54),
(6, 1, 'entries', 'categories', 'news', 'news', 592),
(7, 1, 'entries', 'tags', 'inspirational', 'inspirational', 0),
(8, 1, 'entries', 'tags', 'fashion', 'fashion', 0),
(9, 1, 'entries', 'tags', 'rock', 'rock', 0),
(10, 1, 'entries', 'tags', 'thriller', 'thriller', 0),
(11, 1, 'entries', 'tags', 'spirituality', 'spirituality', 0),
(12, 2, 'entries', 'categories', 'love', 'love', 461),
(13, 2, 'entries', 'tags', 'philosophy', 'philosophy', 0),
(14, 2, 'entries', 'tags', 'adult', 'adult', 0),
(15, 2, 'entries', 'tags', 'security', 'security', 0),
(16, 2, 'entries', 'tags', 'dogs', 'dogs', 0),
(17, 2, 'entries', 'tags', 'fashion', 'fashion', 0),
(18, 3, 'entries', 'categories', 'love', 'love', 556),
(19, 3, 'entries', 'tags', 'evolution', 'evolution', 0),
(20, 3, 'entries', 'tags', 'astronomy', 'astronomy', 0),
(21, 3, 'entries', 'tags', 'post-apocalyptic', 'post-apocalyptic', 0),
(22, 3, 'entries', 'tags', 'news', 'news', 0),
(23, 3, 'entries', 'tags', 'photography', 'photography', 0),
(24, 4, 'entries', 'categories', 'news', 'news', 290),
(25, 4, 'entries', 'tags', 'adult', 'adult', 0),
(26, 4, 'entries', 'tags', 'fun', 'fun', 0),
(27, 4, 'entries', 'tags', 'terrorism', 'terrorism', 0),
(28, 4, 'entries', 'tags', 'philosophy', 'philosophy', 0),
(29, 4, 'entries', 'tags', 'travel', 'travel', 0),
(30, 5, 'entries', 'categories', 'fun', 'fun', 8),
(31, 5, 'entries', 'tags', 'movies', 'movies', 0),
(32, 5, 'entries', 'tags', 'inspirational', 'inspirational', 0),
(33, 5, 'entries', 'tags', 'fashion', 'fashion', 0),
(34, 5, 'entries', 'tags', 'magic', 'magic', 0),
(35, 5, 'entries', 'tags', 'music', 'music', 0),
(36, 1, 'showcases', 'categories', 'fun', 'fun', 62),
(37, 1, 'showcases', 'tags', 'business', 'business', 0),
(38, 1, 'showcases', 'tags', 'documentary', 'documentary', 0),
(39, 1, 'showcases', 'tags', 'inspirational', 'inspirational', 0),
(40, 1, 'showcases', 'tags', 'camera', 'camera', 0),
(41, 1, 'showcases', 'tags', 'zombies', 'zombies', 0),
(42, 2, 'showcases', 'categories', 'life', 'life', 632),
(43, 2, 'showcases', 'tags', 'dogs', 'dogs', 0),
(44, 2, 'showcases', 'tags', 'sciencefiction', 'sciencefiction', 0),
(45, 2, 'showcases', 'tags', 'baby', 'baby', 0),
(46, 2, 'showcases', 'tags', 'story', 'story', 0),
(47, 2, 'showcases', 'tags', 'paranormal', 'paranormal', 0),
(48, 3, 'showcases', 'categories', 'love', 'love', 451),
(49, 3, 'showcases', 'tags', 'nonfiction', 'nonfiction', 0),
(50, 3, 'showcases', 'tags', 'music', 'music', 0),
(51, 3, 'showcases', 'tags', 'security', 'security', 0),
(52, 3, 'showcases', 'tags', 'cooking', 'cooking', 0),
(53, 3, 'showcases', 'tags', 'murder', 'murder', 0),
(54, 4, 'showcases', 'categories', 'events', 'events', 653),
(55, 4, 'showcases', 'tags', 'comics', 'comics', 0),
(56, 4, 'showcases', 'tags', 'adult', 'adult', 0),
(57, 4, 'showcases', 'tags', 'rock', 'rock', 0),
(58, 4, 'showcases', 'tags', 'environment', 'environment', 0),
(59, 4, 'showcases', 'tags', 'suspense', 'suspense', 0),
(60, 5, 'showcases', 'categories', 'life', 'life', 510),
(61, 5, 'showcases', 'tags', 'privacy', 'privacy', 0),
(62, 5, 'showcases', 'tags', 'physics', 'physics', 0),
(63, 5, 'showcases', 'tags', 'biography', 'biography', 0),
(64, 5, 'showcases', 'tags', 'cookbook', 'cookbook', 0),
(65, 5, 'showcases', 'tags', 'thriller', 'thriller', 0);

-- --------------------------------------------------------

--
-- Table structure for table `bolt_users`
--

CREATE TABLE `bolt_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(254) COLLATE utf8_unicode_ci NOT NULL,
  `lastseen` datetime DEFAULT NULL,
  `lastip` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayname` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `stack` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json)',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `shadowpassword` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadowtoken` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadowvalidity` datetime DEFAULT NULL,
  `failedlogins` int(11) NOT NULL DEFAULT '0',
  `throttleduntil` datetime DEFAULT NULL,
  `roles` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5585B54F85E0677` (`username`),
  UNIQUE KEY `UNIQ_5585B54E7927C74` (`email`),
  KEY `IDX_5585B5450F9BB84` (`enabled`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `bolt_users`
--

INSERT INTO `bolt_users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '[[regtime]]', '[[clientip]]', '[[admin_realname]]', '[]', 1, NULL, NULL, NULL, 0, NULL, '["root","everyone"]');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
