<?php

/**
 * Admin Company Look And Feel Settings
 *
 * @package blesta
 * @subpackage blesta.app.controllers
 * @copyright Copyright (c) 2010, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */
class AdminCompanyLookandfeel extends AppController
{
    /**
     * Pre-action
     */
    public function preAction()
    {
        parent::preAction();

        // Require login
        $this->requireLogin();

        $this->uses(['Navigation', 'Companies', 'PluginManager', 'Plugins', 'Themes']);
        $this->components(['SettingsCollection']);

        Language::loadLang('admin_company_lookandfeel');

        // Set the left nav for all settings pages to settings_leftnav
        $this->set(
            'left_nav',
            $this->partial('settings_leftnav', ['nav' => $this->Navigation->getCompany($this->base_uri)])
        );
    }

    /**
     * Index
     */
    public function index()
    {
        $this->redirect($this->base_uri . 'settings/company/lookandfeel/template/');
    }

    /**
     * Set template
     */
    public function template()
    {
        $client_view_dirs = $this->Companies->getViewDirs('client');
        foreach ($client_view_dirs as $dir => $info) {
            $client_view_dirs[$dir] = $info->name;
        }

        $admin_view_dirs = $this->Companies->getViewDirs('admin');
        foreach ($admin_view_dirs as $dir => $info) {
            $admin_view_dirs[$dir] = $info->name;
        }

        if (!empty($this->post)) {
            $this->Companies->setSettings($this->company_id, $this->post, ['client_view_dir', 'admin_view_dir']);

            $this->setMessage('message', Language::_('AdminCompanyLookandfeel.!success.template_updated', true));
        }

        $this->set('client_view_dirs', $client_view_dirs);
        $this->set('admin_view_dirs', $admin_view_dirs);
        $this->set('vars', $this->SettingsCollection->fetchSettings($this->Companies, $this->company_id));
    }

    /**
     * Customize layout
     */
    public function layout()
    {
        // Fetch cards
        $plugin_cards = $this->PluginManager->getCards($this->company_id);
        $cards = [];
        foreach ($plugin_cards as $key => $plugin_card) {
            $plugin_card->card_id = $plugin_card->plugin_dir . '_' . Loader::fromCamelCase($plugin_card->callback[1]);
            $cards[$plugin_card->card_id] = $plugin_card;
        }

        if (!empty($this->post)) {
            // Update cards
            if (isset($this->post['cards'])) {
                $this->PluginManager->begin();

                foreach ($cards as $card) {
                    if (array_key_exists($card->card_id, $this->post['cards']))
                    {
                        $background_type = isset($this->post['cards'][$card->card_id]['background_type'])
                            ? $this->post['cards'][$card->card_id]['background_type']
                            : $card->background_type;
                        $vars = [
                            'enabled' => isset($this->post['cards'][$card->card_id]['enabled'])
                                ? $this->post['cards'][$card->card_id]['enabled']
                                : '0',
                            'background' => isset($this->post['cards'][$card->card_id]['background_' . $background_type])
                                ? $this->post['cards'][$card->card_id]['background_' . $background_type]
                                : $card->background,
                            'background_type' => isset($this->post['cards'][$card->card_id]['background_type'])
                                ? $this->post['cards'][$card->card_id]['background_type']
                                : $card->background_type,
                        ];
                        $card->enabled = $vars['enabled'];
                        $card->background = $vars['background'];
                        $card->background_type = $vars['background_type'];

                        $this->PluginManager->editCard(
                            $card->plugin_id,
                            $card->callback,
                            $card->level,
                            $vars
                        );
                    }
                }
            }

            // Save cards order
            $cards_order = [];

            if (isset($this->post['cards'])) {
                foreach ($this->post['cards'] as $card_id => $card) {
                    $cards_order[] = $card_id;
                }
            }

            $cards_order = base64_encode(serialize($cards_order));
            $this->Companies->setSetting($this->company_id, 'layout_cards_order', $cards_order);

            if (($errors = $this->PluginManager->errors())) {
                $this->PluginManager->rollback();
                $this->setMessage('error', $errors);
            } else {
                $this->PluginManager->commit();
                $this->flashMessage(
                    'message',
                    Language::_('AdminCompanyLookandfeel.!success.layout_updated', true)
                );
                $this->redirect($this->base_uri . 'settings/company/lookandfeel/layout/');
            }
        }

        // Order cards
        $cards_order = $this->Companies->getSetting($this->company_id, 'layout_cards_order');
        $cards_order = isset($cards_order->value) ? unserialize(base64_decode($cards_order->value)) : [];

        $admin_cards = array_merge(array_flip($cards_order), $cards);
        foreach ($admin_cards as $key => $value) {
            if (!is_object($value) || (isset($value->level) && $value->level !== 'staff')) {
                unset($admin_cards[$key]);
            }
        }

        $client_cards = array_merge(array_flip($cards_order), $cards);
        foreach ($client_cards as $key => $value) {
            if (!is_object($value) || (isset($value->level) && $value->level !== 'client')) {
                unset($client_cards[$key]);
            }
        }

        // Get theme types
        $theme_types = $this->Themes->getTypes();

        if (is_array($theme_types)) {
            // Default to the client view
            $theme_types = array_reverse($theme_types);
        }

        // Load color picker
        $this->Javascript->setFile('colorpicker.min.js');

        $this->set(
            'layout_admin',
            $this->partial(
                'admin_company_lookandfeel_layout_tab',
                ['cards' => $admin_cards, 'theme_type' => 'admin']
            )
        );
        $this->set(
            'layout_client',
            $this->partial(
                'admin_company_lookandfeel_layout_tab',
                ['cards' => $client_cards, 'theme_type' => 'client']
            )
        );

        $this->set('theme_types', $theme_types);
    }

    /**
     *
     */
    public function customize()
    {
        #
        # TODO: Set custom content CORE-828
        #
        return false;
    }
}
