<?php
/**
 * Upgrades to version 3.0.0.b3
 *
 * @package blesta
 * @subpackage blesta.components.upgrades.tasks
 * @copyright Copyright (c) 2010, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */
class Upgrade3_0_0B3 extends UpgradeUtil
{

    /**
     * @var array An array of all tasks completed
     */
    private $tasks = [];

    /**
     * Setup
     */
    public function __construct()
    {
        Loader::loadComponents($this, ['Record']);
    }

    /**
     * Returns a numerically indexed array of tasks to execute for the upgrade process
     *
     * @retrun array A numerically indexed array of tasks to execute for the upgrade process
     */
    public function tasks()
    {
        return [
            'setStates'
        ];
    }

    /**
     * Processes the given task
     *
     * @param string $task The task to process
     */
    public function process($task)
    {
        $tasks = $this->tasks();

        // Ensure task exists
        if (!in_array($task, $tasks)) {
            return;
        }

        $this->tasks[] = $task;
        $this->{$task}();
    }

    /**
     * Rolls back all tasks completed for the upgrade process
     */
    public function rollback()
    {
        // Undo all tasks
        while (($task = array_pop($this->tasks))) {
            $this->{$task}(true);
        }
    }

    /**
     * Updates all states
     *
     * @param bool $undo True to undo the change false to perform the change
     */
    private function setStates($undo = false)
    {
        if ($undo) {
            // Nothing to undo
            return;
        }

        $this->Record->truncate('states');

        $statement = $this->Record->query(
            "INSERT INTO `states` (`country_alpha2`, `code`, `name`) VALUES 
			('AD', '02', 'Canillo'),
			('AD', '03', 'Encamp'),
			('AD', '04', 'La Massana'),
			('AD', '05', 'Ordino'),
			('AD', '06', 'Sant Julià de Lòria'),
			('AD', '07', 'Andorra la Vella'),
			('AD', '08', 'Escaldes-Engordany'),
			('AE', 'AJ', 'Ajman'),
			('AE', 'AZ', 'Abu Z¸aby [Abu Dhabi]'),
			('AE', 'DU', 'Dubayy [Dubai]'),
			('AE', 'FU', 'Al Fujayrah'),
			('AE', 'RK', 'Ra’s al Khaymah'),
			('AE', 'SH', 'Ash Shariqah [Sharjah]'),
			('AE', 'UQ', 'Umm al Qaywayn'),
			('AF', 'BAL', 'Balkh'),
			('AF', 'BAM', 'Bāmyān'),
			('AF', 'BDG', 'Bādghīs'),
			('AF', 'BDS', 'Badakhshān'),
			('AF', 'BGL', 'Baghlān'),
			('AF', 'DAY', 'Dāykundī'),
			('AF', 'FRA', 'Farāh'),
			('AF', 'FYB', 'Fāryāb'),
			('AF', 'GHA', 'Ghaznī'),
			('AF', 'GHO', 'Ghōr'),
			('AF', 'HEL', 'Helmand'),
			('AF', 'HER', 'Herāt'),
			('AF', 'JOW', 'Jowzjān'),
			('AF', 'KAB', 'Kābul'),
			('AF', 'KAN', 'Kandahār'),
			('AF', 'KAP', 'Kāpīsā'),
			('AF', 'KDZ', 'Kunduz'),
			('AF', 'KHO', 'Khōst'),
			('AF', 'KNR', 'Kunar'),
			('AF', 'LAG', 'Laghmān'),
			('AF', 'LOG', 'Lōgar'),
			('AF', 'NAN', 'Nangarhār'),
			('AF', 'NIM', 'Nīmrōz'),
			('AF', 'NUR', 'Nūristān'),
			('AF', 'PAN', 'Panjshayr'),
			('AF', 'PAR', 'Parwān'),
			('AF', 'PIA', 'Paktia'),
			('AF', 'PKA', 'Paktika'),
			('AF', 'SAM', 'Samangan'),
			('AF', 'SAR', 'Sar-e Pul'),
			('AF', 'TAK', 'Takhar'),
			('AF', 'URU', 'Uruzgān'),
			('AF', 'WAR', 'Wardak'),
			('AF', 'ZAB', 'Zābul'),
			('AG', '03', 'Saint George'),
			('AG', '04', 'Saint John’s'),
			('AG', '05', 'Saint Mary'),
			('AG', '06', 'Saint Paul'),
			('AG', '07', 'Saint Peter'),
			('AG', '08', 'Saint Philip'),
			('AG', '10', 'Barbuda'),
			('AG', '11', 'Redonda'),
			('AL', '01', 'Berat'),
			('AL', '02', 'Durrës'),
			('AL', '03', 'Elbasan'),
			('AL', '04', 'Fier'),
			('AL', '05', 'Gjirokastër'),
			('AL', '06', 'Korçë'),
			('AL', '07', 'Kukës'),
			('AL', '08', 'Lezhë'),
			('AL', '09', 'Dibër'),
			('AL', '10', 'Shkodër'),
			('AL', '11', 'Tiranë'),
			('AL', '12', 'Vlorë'),
			('AL', 'BR', 'Berat'),
			('AL', 'BU', 'Bulqizë'),
			('AL', 'DI', 'Dibër'),
			('AL', 'DL', 'Delvinë'),
			('AL', 'DR', 'Durrës'),
			('AL', 'DV', 'Devoll'),
			('AL', 'EL', 'Elbasan'),
			('AL', 'ER', 'Kolonjë'),
			('AL', 'FR', 'Fier'),
			('AL', 'GJ', 'Gjirokastër'),
			('AL', 'GR', 'Gramsh'),
			('AL', 'HA', 'Has'),
			('AL', 'KA', 'Kavajë'),
			('AL', 'KB', 'Kurbin'),
			('AL', 'KC', 'Kuçovë'),
			('AL', 'KO', 'Korçë'),
			('AL', 'KR', 'Krujë'),
			('AL', 'KU', 'Kukës'),
			('AL', 'LB', 'Librazhd'),
			('AL', 'LE', 'Lezhë'),
			('AL', 'LU', 'Lushnjë'),
			('AL', 'MK', 'Mallakastër'),
			('AL', 'MM', 'Malësi e Madhe'),
			('AL', 'MR', 'Mirditë'),
			('AL', 'MT', 'Mat'),
			('AL', 'PG', 'Pogradec'),
			('AL', 'PQ', 'Peqin'),
			('AL', 'PR', 'Përmet'),
			('AL', 'PU', 'Pukë'),
			('AL', 'SH', 'Shkodër'),
			('AL', 'SK', 'Skrapar'),
			('AL', 'SR', 'Sarandë'),
			('AL', 'TE', 'Tepelenë'),
			('AL', 'TP', 'Tropojë'),
			('AL', 'TR', 'Tiranë'),
			('AL', 'VL', 'Vlorë'),
			('AM', 'AG', 'Aragac?otn'),
			('AM', 'AR', 'Ararat'),
			('AM', 'AV', 'Armavir'),
			('AM', 'ER', 'Erevan'),
			('AM', 'GR', 'Gegark''unik'''),
			('AM', 'KT', 'Kotayk'''),
			('AM', 'LO', 'Lo?y'),
			('AM', 'SH', 'Širak'),
			('AM', 'SU', 'Syunik'''),
			('AM', 'TV', 'Tavuš'),
			('AM', 'VD', 'Vayoc Jor'),
			('AO', 'BGO', 'Bengo'),
			('AO', 'BGU', 'Benguela'),
			('AO', 'BIE', 'Bié'),
			('AO', 'CAB', 'Cabinda'),
			('AO', 'CCU', 'Cuando-Cubango'),
			('AO', 'CNN', 'Cunene'),
			('AO', 'CNO', 'Cuanza Norte'),
			('AO', 'CUS', 'Cuanza Sul'),
			('AO', 'HUA', 'Huambo'),
			('AO', 'HUI', 'Huíla'),
			('AO', 'LNO', 'Lunda Norte'),
			('AO', 'LSU', 'Lunda Sul'),
			('AO', 'LUA', 'Luanda'),
			('AO', 'MAL', 'Malange'),
			('AO', 'MOX', 'Moxico'),
			('AO', 'NAM', 'Namibe'),
			('AO', 'UIG', 'Uíge'),
			('AO', 'ZAI', 'Zaire'),
			('AR', 'A', 'Salta'),
			('AR', 'B', 'Buenos Aires'),
			('AR', 'C', 'Ciudad Autónoma de Buenos Aires'),
			('AR', 'D', 'San Luis'),
			('AR', 'E', 'Entre Ríos'),
			('AR', 'F', 'La Rioja'),
			('AR', 'G', 'Santiago del Estero'),
			('AR', 'H', 'Chaco'),
			('AR', 'J', 'San Juan'),
			('AR', 'K', 'Catamarca'),
			('AR', 'L', 'La Pampa'),
			('AR', 'M', 'Mendoza'),
			('AR', 'N', 'Misiones'),
			('AR', 'P', 'Formosa'),
			('AR', 'Q', 'Neuquén'),
			('AR', 'R', 'Río Negro'),
			('AR', 'S', 'Santa Fe'),
			('AR', 'T', 'Tucumán'),
			('AR', 'U', 'Chubut'),
			('AR', 'V', 'Tierra del Fuego'),
			('AR', 'W', 'Corrientes'),
			('AR', 'X', 'Córdoba'),
			('AR', 'Y', 'Jujuy'),
			('AR', 'Z', 'Santa Cruz'),
			('AT', '1', 'Burgenland'),
			('AT', '2', 'Kärnten'),
			('AT', '3', 'Niederösterreich'),
			('AT', '4', 'Oberösterreich'),
			('AT', '5', 'Salzburg'),
			('AT', '6', 'Steiermark'),
			('AT', '7', 'Tirol'),
			('AT', '8', 'Vorarlberg'),
			('AT', '9', 'Wien'),
			('AU', 'ACT', 'Australian Capital Territory'),
			('AU', 'NSW', 'New South Wales'),
			('AU', 'NT', 'Northern Territory'),
			('AU', 'QLD', 'Queensland'),
			('AU', 'SA', 'South Australia'),
			('AU', 'TAS', 'Tasmania'),
			('AU', 'VIC', 'Victoria'),
			('AU', 'WA', 'Western Australia'),
			('AZ', 'ABS', 'Abseron'),
			('AZ', 'AGA', 'Agstafa'),
			('AZ', 'AGC', 'Agcabädi'),
			('AZ', 'AGM', 'Agdam'),
			('AZ', 'AGS', 'Agdas'),
			('AZ', 'AGU', 'Agsu'),
			('AZ', 'AST', 'Astara'),
			('AZ', 'BA', 'Baki'),
			('AZ', 'BAB', 'Babäk'),
			('AZ', 'BAL', 'Balakän'),
			('AZ', 'BAR', 'Bärdä'),
			('AZ', 'BEY', 'Beyläqan'),
			('AZ', 'BIL', 'Biläsuvar'),
			('AZ', 'CAB', 'Cäbrayil'),
			('AZ', 'CAL', 'Cälilabab'),
			('AZ', 'CUL', 'Culfa'),
			('AZ', 'DAS', 'Daskäsän'),
			('AZ', 'FUZ', 'Füzuli'),
			('AZ', 'GA', 'Gəncə'),
			('AZ', 'GAD', 'Gädäbäy'),
			('AZ', 'GOR', 'Goranboy'),
			('AZ', 'GOY', 'Göyçay'),
			('AZ', 'GYG', 'Göygöl'),
			('AZ', 'HAC', 'Haciqabul'),
			('AZ', 'IMI', 'Imisli'),
			('AZ', 'ISM', 'Ismayilli'),
			('AZ', 'KAL', 'Kälbäcär'),
			('AZ', 'KAN', 'Kǝngǝrli'),
			('AZ', 'KUR', 'Kürdämir'),
			('AZ', 'LA', 'Lənkəran'),
			('AZ', 'LAC', 'Laçin'),
			('AZ', 'LAN', 'Länkäran'),
			('AZ', 'LER', 'Lerik'),
			('AZ', 'MAS', 'Masalli'),
			('AZ', 'MI', 'Mingəçevir'),
			('AZ', 'NA', 'Naftalan'),
			('AZ', 'NEF', 'Neftçala'),
			('AZ', 'NV', 'Naxçıvan'),
			('AZ', 'NX', 'Naxçivan'),
			('AZ', 'OGU', 'Oguz'),
			('AZ', 'ORD', 'Ordubad'),
			('AZ', 'QAB', 'Qäbälä'),
			('AZ', 'QAX', 'Qax'),
			('AZ', 'QAZ', 'Qazax'),
			('AZ', 'QBA', 'Quba'),
			('AZ', 'QBI', 'Qubadli'),
			('AZ', 'QOB', 'Qobustan'),
			('AZ', 'QUS', 'Qusar'),
			('AZ', 'SA', 'Şəki'),
			('AZ', 'SAB', 'Sabirabad'),
			('AZ', 'SAD', 'Sädäräk'),
			('AZ', 'SAH', 'Sahbuz'),
			('AZ', 'SAK', 'Säki'),
			('AZ', 'SAL', 'Salyan'),
			('AZ', 'SAR', 'Särur'),
			('AZ', 'SAT', 'Saatli'),
			('AZ', 'SBN', 'Şabran'),
			('AZ', 'SIY', 'Siyäzän'),
			('AZ', 'SKR', 'Sämkir'),
			('AZ', 'SM', 'Sumqayıt'),
			('AZ', 'SMI', 'Samaxi'),
			('AZ', 'SMX', 'Samux'),
			('AZ', 'SR', 'Şirvan'),
			('AZ', 'SUS', 'Susa'),
			('AZ', 'TAR', 'Tärtär'),
			('AZ', 'TOV', 'Tovuz'),
			('AZ', 'UCA', 'Ucar'),
			('AZ', 'XA', 'Xankəndi'),
			('AZ', 'XAC', 'Xaçmaz'),
			('AZ', 'XCI', 'Xocali'),
			('AZ', 'XIZ', 'Xizi'),
			('AZ', 'XVD', 'Xocavänd'),
			('AZ', 'YAR', 'Yardimli'),
			('AZ', 'YE', 'Yevlax City'),
			('AZ', 'YEV', 'Yevlax'),
			('AZ', 'ZAN', 'Zängilan'),
			('AZ', 'ZAQ', 'Zaqatala'),
			('AZ', 'ZAR', 'Zärdab'),
			('BA', '01', 'Unsko-sanski kanton'),
			('BA', '02', 'Posavski kanton'),
			('BA', '03', 'Tuzlanski kanton'),
			('BA', '04', 'Zeni?ko-dobojski kanton'),
			('BA', '05', 'Bosansko-podrinjski kanton'),
			('BA', '06', 'Srednjobosanski kanton'),
			('BA', '07', 'Hercegova?ko-neretvanski kanton'),
			('BA', '08', 'Zapadnohercegova?ki kanton'),
			('BA', '09', 'Kanton Sarajevo'),
			('BA', '10', 'Kanton br. 10'),
			('BA', 'BIH', 'Federacija Bosna i Hercegovina'),
			('BA', 'BRC', 'Brčko distrikt'),
			('BA', 'SRP', 'Republika Srpska'),
			('BB', '01', 'Christ Church'),
			('BB', '02', 'Saint Andrew'),
			('BB', '03', 'Saint George'),
			('BB', '04', 'Saint James'),
			('BB', '05', 'Saint John'),
			('BB', '06', 'Saint Joseph'),
			('BB', '07', 'Saint Lucy'),
			('BB', '08', 'Saint Michael'),
			('BB', '09', 'Saint Peter'),
			('BB', '10', 'Saint Philip'),
			('BB', '11', 'Saint Thomas'),
			('BD', '01', 'Bandarban'),
			('BD', '02', 'Barguna'),
			('BD', '03', 'Bogra'),
			('BD', '04', 'Brahmanbaria'),
			('BD', '05', 'Bagerhat'),
			('BD', '06', 'Barisal'),
			('BD', '07', 'Bhola'),
			('BD', '08', 'Comilla'),
			('BD', '09', 'Chandpur'),
			('BD', '10', 'Chittagong'),
			('BD', '11', 'Cox''s Bazar'),
			('BD', '12', 'Chuadanga'),
			('BD', '13', 'Dhaka'),
			('BD', '14', 'Dinajpur'),
			('BD', '15', 'Faridpur'),
			('BD', '16', 'Feni'),
			('BD', '17', 'Gopalganj'),
			('BD', '18', 'Gazipur'),
			('BD', '19', 'Gaibandha'),
			('BD', '20', 'Habiganj'),
			('BD', '21', 'Jamalpur'),
			('BD', '22', 'Jessore'),
			('BD', '23', 'Jhenaidah'),
			('BD', '24', 'Jaipurhat'),
			('BD', '25', 'Jhalakati'),
			('BD', '26', 'Kishoreganj'),
			('BD', '27', 'Khulna'),
			('BD', '28', 'Kurigram'),
			('BD', '29', 'Khagrachari'),
			('BD', '30', 'Kushtia'),
			('BD', '31', 'Lakshmipur'),
			('BD', '32', 'Lalmonirhat'),
			('BD', '33', 'Manikganj'),
			('BD', '34', 'Mymensingh'),
			('BD', '35', 'Munshiganj'),
			('BD', '36', 'Madaripur'),
			('BD', '37', 'Magura'),
			('BD', '38', 'Moulvibazar'),
			('BD', '39', 'Meherpur'),
			('BD', '40', 'Narayanganj'),
			('BD', '41', 'Netrakona'),
			('BD', '42', 'Narsingdi'),
			('BD', '43', 'Narail'),
			('BD', '44', 'Natore'),
			('BD', '45', 'Nawabganj'),
			('BD', '46', 'Nilphamari'),
			('BD', '47', 'Noakhali'),
			('BD', '48', 'Naogaon'),
			('BD', '49', 'Pabna'),
			('BD', '50', 'Pirojpur'),
			('BD', '51', 'Patuakhali'),
			('BD', '52', 'Panchagarh'),
			('BD', '53', 'Rajbari'),
			('BD', '54', 'Rajshahi'),
			('BD', '55', 'Rangpur'),
			('BD', '56', 'Rangamati Parbattya Chattagram'),
			('BD', '57', 'Sherpur'),
			('BD', '58', 'Satkhira'),
			('BD', '59', 'Sirajganj'),
			('BD', '60', 'Sylhet'),
			('BD', '61', 'Sunamganj'),
			('BD', '62', 'Shariatpur'),
			('BD', '63', 'Tangail'),
			('BD', '64', 'Thakurgaon'),
			('BD', 'A', 'Barisal'),
			('BD', 'B', 'Chittagong'),
			('BD', 'C', 'Dhaka'),
			('BD', 'D', 'Khulna'),
			('BD', 'E', 'Rajshahi'),
			('BD', 'F', 'Rangpur'),
			('BD', 'G', 'Sylhet'),
			('BE', 'BRU', 'Brussels'),
			('BE', 'VAN', 'Antwerpen'),
			('BE', 'VBR', 'Vlaams Brabant'),
			('BE', 'VLG', 'Flemish Region'),
			('BE', 'VLI', 'Limburg'),
			('BE', 'VOV', 'Oost-Vlaanderen'),
			('BE', 'VWV', 'West-Vlaanderen'),
			('BE', 'WAL', 'Wallonia'),
			('BE', 'WBR', 'Brabant Wallon'),
			('BE', 'WHT', 'Hainaut'),
			('BE', 'WLG', 'Liège'),
			('BE', 'WLX', 'Luxembourg'),
			('BE', 'WNA', 'Namur'),
			('BF', '01', 'Boucle du Mouhoun'),
			('BF', '02', 'Cascades'),
			('BF', '03', 'Centre'),
			('BF', '04', 'Centre-Est'),
			('BF', '05', 'Centre-Nord'),
			('BF', '06', 'Centre-Ouest'),
			('BF', '07', 'Centre-Sud'),
			('BF', '08', 'Est'),
			('BF', '09', 'Hauts-Bassins'),
			('BF', '10', 'Nord'),
			('BF', '11', 'Plateau-Central'),
			('BF', '12', 'Sahel'),
			('BF', '13', 'Sud-Ouest'),
			('BF', 'BAL', 'Balé'),
			('BF', 'BAM', 'Bam'),
			('BF', 'BAN', 'Banwa'),
			('BF', 'BAZ', 'Bazèga'),
			('BF', 'BGR', 'Bougouriba'),
			('BF', 'BLG', 'Boulgou'),
			('BF', 'BLK', 'Boulkiemdé'),
			('BF', 'COM', 'Comoé'),
			('BF', 'GAN', 'Ganzourgou'),
			('BF', 'GNA', 'Gnagna'),
			('BF', 'GOU', 'Gourma'),
			('BF', 'HOU', 'Houet'),
			('BF', 'IOB', 'Ioba'),
			('BF', 'KAD', 'Kadiogo'),
			('BF', 'KEN', 'Kénédougou'),
			('BF', 'KMD', 'Komondjari'),
			('BF', 'KMP', 'Kompienga'),
			('BF', 'KOP', 'Koulpélogo'),
			('BF', 'KOS', 'Kossi'),
			('BF', 'KOT', 'Kouritenga'),
			('BF', 'KOW', 'Kourwéogo'),
			('BF', 'LER', 'Léraba'),
			('BF', 'LOR', 'Loroum'),
			('BF', 'MOU', 'Mouhoun'),
			('BF', 'NAM', 'Namentenga'),
			('BF', 'NAO', 'Nahouri'),
			('BF', 'NAY', 'Nayala'),
			('BF', 'NOU', 'Noumbiel'),
			('BF', 'OUB', 'Oubritenga'),
			('BF', 'OUD', 'Oudalan'),
			('BF', 'PAS', 'Passoré'),
			('BF', 'PON', 'Poni'),
			('BF', 'SEN', 'Séno'),
			('BF', 'SIS', 'Sissili'),
			('BF', 'SMT', 'Sanmatenga'),
			('BF', 'SNG', 'Sanguié'),
			('BF', 'SOM', 'Soum'),
			('BF', 'SOR', 'Sourou'),
			('BF', 'TAP', 'Tapoa'),
			('BF', 'TUI', 'Tui'),
			('BF', 'YAG', 'Yagha'),
			('BF', 'YAT', 'Yatenga'),
			('BF', 'ZIR', 'Ziro'),
			('BF', 'ZON', 'Zondoma'),
			('BF', 'ZOU', 'Zoundwéogo'),
			('BG', '01', 'Blagoevgrad'),
			('BG', '02', 'Burgas'),
			('BG', '03', 'Varna'),
			('BG', '04', 'Veliko Tarnovo'),
			('BG', '05', 'Vidin'),
			('BG', '06', 'Vratsa'),
			('BG', '07', 'Gabrovo'),
			('BG', '08', 'Dobrich'),
			('BG', '09', 'Kardzhali'),
			('BG', '10', 'Kjustendil'),
			('BG', '11', 'Lovech'),
			('BG', '12', 'Montana'),
			('BG', '13', 'Pazardzhik'),
			('BG', '14', 'Pernik'),
			('BG', '15', 'Pleven'),
			('BG', '16', 'Plovdiv'),
			('BG', '17', 'Razgrad'),
			('BG', '18', 'Ruse'),
			('BG', '19', 'Silistra'),
			('BG', '20', 'Sliven'),
			('BG', '21', 'Smolyan'),
			('BG', '22', 'Sofia-Grad'),
			('BG', '23', 'Sofia'),
			('BG', '24', 'Stara Zagora'),
			('BG', '25', 'Targovishte'),
			('BG', '26', 'Haskovo'),
			('BG', '27', 'Šumen'),
			('BG', '28', 'Yambol'),
			('BH', '13', 'Al Manamah'),
			('BH', '14', 'Al Janubiyah'),
			('BH', '15', 'Al Muharraq'),
			('BH', '16', 'Al Wustá'),
			('BH', '17', 'Ash Shamaliyah'),
			('BI', 'BB', 'Bubanza'),
			('BI', 'BL', 'Bujumbura Rural'),
			('BI', 'BM', 'Bujumbura Mairie'),
			('BI', 'BR', 'Bururi'),
			('BI', 'CA', 'Cankuzo'),
			('BI', 'CI', 'Cibitoke'),
			('BI', 'GI', 'Gitega'),
			('BI', 'KI', 'Kirundo'),
			('BI', 'KR', 'Karuzi'),
			('BI', 'KY', 'Kayanza'),
			('BI', 'MA', 'Makamba'),
			('BI', 'MU', 'Muramvya'),
			('BI', 'MW', 'Mwaro'),
			('BI', 'MY', 'Muyinga'),
			('BI', 'NG', 'Ngozi'),
			('BI', 'RT', 'Rutana'),
			('BI', 'RY', 'Ruyigi'),
			('BJ', 'AK', 'Atakora'),
			('BJ', 'AL', 'Alibori'),
			('BJ', 'AQ', 'Atlantique'),
			('BJ', 'BO', 'Borgou'),
			('BJ', 'CO', 'Collines'),
			('BJ', 'DO', 'Donga'),
			('BJ', 'KO', 'Kouffo'),
			('BJ', 'LI', 'Littoral'),
			('BJ', 'MO', 'Mono'),
			('BJ', 'OU', 'Ouémé'),
			('BJ', 'PL', 'Plateau'),
			('BJ', 'ZO', 'Zou'),
			('BM', 'DEV', 'Devonshire'),
			('BM', 'HA', 'Hamilton municipality'),
			('BM', 'HAM', 'Hamilton'),
			('BM', 'PAG', 'Paget'),
			('BM', 'PEM', 'Pembroke'),
			('BM', 'SAN', 'Sandys'),
			('BM', 'SG', 'Saint George municipality'),
			('BM', 'SGE', 'Saint George'),
			('BM', 'SMI', 'Smiths'),
			('BM', 'SOU', 'Southampton'),
			('BM', 'WAR', 'Warwick'),
			('BN', 'BE', 'Belait'),
			('BN', 'BM', 'Brunei-Muara'),
			('BN', 'TE', 'Temburong'),
			('BN', 'TU', 'Tutong'),
			('BO', 'B', 'El Beni'),
			('BO', 'C', 'Cochabamba'),
			('BO', 'H', 'Chuquisaca'),
			('BO', 'L', 'La Paz'),
			('BO', 'N', 'Pando'),
			('BO', 'O', 'Oruro'),
			('BO', 'P', 'Potosí'),
			('BO', 'S', 'Santa Cruz'),
			('BO', 'T', 'Tarija'),
			('BQ', 'BO', 'Bonaire'),
			('BQ', 'SA', 'Saba'),
			('BQ', 'SE', 'Sint Eustatius'),
			('BR', 'AC', 'Acre'),
			('BR', 'AL', 'Alagoas'),
			('BR', 'AM', 'Amazonas'),
			('BR', 'AP', 'Amapá'),
			('BR', 'BA', 'Bahia'),
			('BR', 'CE', 'Ceará'),
			('BR', 'DF', 'Distrito Federal'),
			('BR', 'ES', 'Espírito Santo'),
			('BR', 'GO', 'Goiás'),
			('BR', 'MA', 'Maranhão'),
			('BR', 'MG', 'Minas Gerais'),
			('BR', 'MS', 'Mato Grosso do Sul'),
			('BR', 'MT', 'Mato Grosso'),
			('BR', 'PA', 'Pará'),
			('BR', 'PB', 'Paraíba'),
			('BR', 'PE', 'Pernambuco'),
			('BR', 'PI', 'Piauí'),
			('BR', 'PR', 'Paraná'),
			('BR', 'RJ', 'Rio de Janeiro'),
			('BR', 'RN', 'Rio Grande do Norte'),
			('BR', 'RO', 'Rondônia'),
			('BR', 'RR', 'Roraima'),
			('BR', 'RS', 'Rio Grande do Sul'),
			('BR', 'SC', 'Santa Catarina'),
			('BR', 'SE', 'Sergipe'),
			('BR', 'SP', 'São Paulo'),
			('BR', 'TO', 'Tocantins'),
			('BS', 'AK', 'Acklins Islands'),
			('BS', 'BI', 'Bimini and Cat Cay'),
			('BS', 'BP', 'Black Point'),
			('BS', 'BY', 'Berry Islands'),
			('BS', 'CE', 'Central Eleuthera'),
			('BS', 'CI', 'Cat Island'),
			('BS', 'CK', 'Crooked Island and Long Cay'),
			('BS', 'CO', 'Central Abaco'),
			('BS', 'CS', 'Central Andros'),
			('BS', 'EG', 'East Grand Bahama'),
			('BS', 'EX', 'Exuma'),
			('BS', 'FP', 'City of Freeport'),
			('BS', 'GC', 'Grand Cay'),
			('BS', 'GT', 'Green Turtle Cay'),
			('BS', 'HI', 'Harbour Island'),
			('BS', 'HT', 'Hope Town'),
			('BS', 'IN', 'Inagua'),
			('BS', 'LI', 'Long Island'),
			('BS', 'MC', 'Mangrove Cay'),
			('BS', 'MG', 'Mayaguana'),
			('BS', 'MI', 'Moore’s Island'),
			('BS', 'NE', 'North Eleuthera'),
			('BS', 'NO', 'North Abaco'),
			('BS', 'NS', 'North Andros'),
			('BS', 'RC', 'Rum Cay'),
			('BS', 'RI', 'Ragged Island'),
			('BS', 'SA', 'South Andros'),
			('BS', 'SE', 'South Eleuthera'),
			('BS', 'SO', 'South Abaco'),
			('BS', 'SS', 'San Salvador'),
			('BS', 'SW', 'Spanish Wells'),
			('BS', 'WG', 'West Grand Bahama'),
			('BT', '11', 'Paro'),
			('BT', '12', 'Chhukha'),
			('BT', '13', 'Ha'),
			('BT', '14', 'Samtse'),
			('BT', '15', 'Thimphu'),
			('BT', '21', 'Tsirang'),
			('BT', '22', 'Dagana'),
			('BT', '23', 'Punakha'),
			('BT', '24', 'Wangdue Phodrang'),
			('BT', '31', 'Sarpang'),
			('BT', '32', 'Trongsa'),
			('BT', '33', 'Bumthang'),
			('BT', '34', 'Zhemgang'),
			('BT', '41', 'Trashigang'),
			('BT', '42', 'Monggar'),
			('BT', '43', 'Pemagatshel'),
			('BT', '44', 'Lhuentse'),
			('BT', '45', 'Samdrup Jongkha'),
			('BT', 'GA', 'Gasa'),
			('BT', 'TY', 'Trashi Yangtse'),
			('BW', 'CE', 'Central'),
			('BW', 'GH', 'Ghanzi'),
			('BW', 'KG', 'Kgalagadi'),
			('BW', 'KL', 'Kgatleng'),
			('BW', 'KW', 'Kweneng'),
			('BW', 'NE', 'North-East'),
			('BW', 'NW', 'North-West'),
			('BW', 'SE', 'South-East'),
			('BW', 'SO', 'Southern'),
			('BY', 'BR', 'Brestskaya voblasts'),
			('BY', 'HM', 'Horad Minsk'),
			('BY', 'HO', 'Homyel''skaya voblasts'),
			('BY', 'HR', 'Hrodzenskaya voblasts'),
			('BY', 'MA', 'Mahilyowskaya voblasts'),
			('BY', 'MI', 'Minskaya voblasts'),
			('BY', 'VI', 'Vitsyebskaya voblasts'),
			('BZ', 'BZ', 'Belize'),
			('BZ', 'CY', 'Cayo'),
			('BZ', 'CZL', 'Corozal'),
			('BZ', 'OW', 'Orange Walk'),
			('BZ', 'SC', 'Stann Creek'),
			('BZ', 'TOL', 'Toledo'),
			('CA', 'AB', 'Alberta'),
			('CA', 'BC', 'British Columbia'),
			('CA', 'MB', 'Manitoba'),
			('CA', 'NB', 'New Brunswick'),
			('CA', 'NL', 'Newfoundland and Labrador'),
			('CA', 'NS', 'Nova Scotia'),
			('CA', 'NT', 'Northwest Territories'),
			('CA', 'NU', 'Nunavut'),
			('CA', 'ON', 'Ontario'),
			('CA', 'PE', 'Prince Edward Island'),
			('CA', 'QC', 'Quebec'),
			('CA', 'SK', 'Saskatchewan'),
			('CA', 'YT', 'Yukon Territory'),
			('CD', 'BC', 'Bas-Congo'),
			('CD', 'BN', 'Bandundu'),
			('CD', 'EQ', 'Équateur'),
			('CD', 'KA', 'Katanga'),
			('CD', 'KE', 'Kasai-Oriental'),
			('CD', 'KN', 'Kinshasa'),
			('CD', 'KW', 'Kasai-Occidental'),
			('CD', 'MA', 'Maniema'),
			('CD', 'NK', 'Nord-Kivu'),
			('CD', 'OR', 'Orientale'),
			('CD', 'SK', 'Sud-Kivu'),
			('CF', 'AC', 'Ouham'),
			('CF', 'BB', 'Bamingui-Bangoran'),
			('CF', 'BGF', 'Bangui'),
			('CF', 'BK', 'Basse-Kotto'),
			('CF', 'HK', 'Haute-Kotto'),
			('CF', 'HM', 'Haut-Mbomou'),
			('CF', 'HS', 'Haute-Sangha / Mambéré-Kadéï'),
			('CF', 'KB', 'Gribingui'),
			('CF', 'KG', 'Kémo-Gribingui'),
			('CF', 'LB', 'Lobaye'),
			('CF', 'MB', 'Mbomou'),
			('CF', 'MP', 'Ombella-Mpoko'),
			('CF', 'NM', 'Nana-Mambéré'),
			('CF', 'OP', 'Ouham-Pendé'),
			('CF', 'SE', 'Sangha'),
			('CF', 'UK', 'Ouaka'),
			('CF', 'VK', 'Vakaga'),
			('CG', '11', 'Bouenza'),
			('CG', '12', 'Pool'),
			('CG', '13', 'Sangha'),
			('CG', '14', 'Plateaux'),
			('CG', '15', 'Cuvette-Ouest'),
			('CG', '2', 'Lékoumou'),
			('CG', '5', 'Kouilou'),
			('CG', '7', 'Likouala'),
			('CG', '8', 'Cuvette'),
			('CG', '9', 'Niari'),
			('CG', 'BZV', 'Brazzaville'),
			('CH', 'AG', 'Aargau'),
			('CH', 'AI', 'Appenzell Innerrhoden'),
			('CH', 'AR', 'Appenzell Ausserrhoden'),
			('CH', 'BE', 'Bern'),
			('CH', 'BL', 'Basel-Landschaft'),
			('CH', 'BS', 'Basel-Stadt'),
			('CH', 'FR', 'Fribourg'),
			('CH', 'GE', 'Genève'),
			('CH', 'GL', 'Glarus'),
			('CH', 'GR', 'Graubünden'),
			('CH', 'JU', 'Jura'),
			('CH', 'LU', 'Luzern'),
			('CH', 'NE', 'Neuchâtel'),
			('CH', 'NW', 'Nidwalden'),
			('CH', 'OW', 'Obwalden'),
			('CH', 'SG', 'Sankt Gallen'),
			('CH', 'SH', 'Schaffhausen'),
			('CH', 'SO', 'Solothurn'),
			('CH', 'SZ', 'Schwyz'),
			('CH', 'TG', 'Thurgau'),
			('CH', 'TI', 'Ticino'),
			('CH', 'UR', 'Uri'),
			('CH', 'VD', 'Vaud'),
			('CH', 'VS', 'Valais'),
			('CH', 'ZG', 'Zug'),
			('CH', 'ZH', 'Zürich'),
			('CI', '01', 'Lagunes'),
			('CI', '02', 'Haut-Sassandra'),
			('CI', '03', 'Savanes'),
			('CI', '04', 'Vallée du Bandama'),
			('CI', '05', 'Moyen-Comoé'),
			('CI', '06', '18 Montagnes'),
			('CI', '07', 'Lacs'),
			('CI', '08', 'Zanzan'),
			('CI', '09', 'Bas-Sassandra'),
			('CI', '10', 'Denguélé'),
			('CI', '11', 'Nzi-Comoé'),
			('CI', '12', 'Marahoué'),
			('CI', '13', 'Sud-Comoé'),
			('CI', '14', 'Worodougou'),
			('CI', '15', 'Sud-Bandama'),
			('CI', '16', 'Agnébi'),
			('CI', '17', 'Bafing'),
			('CI', '18', 'Fromager'),
			('CI', '19', 'Moyen-Cavally'),
			('CL', 'AI', 'Aisén del General Carlos Ibáñez del Campo'),
			('CL', 'AN', 'Antofagasta'),
			('CL', 'AP', 'Arica y Parinacota'),
			('CL', 'AR', 'Araucanía'),
			('CL', 'AT', 'Atacama'),
			('CL', 'BI', 'Bío-Bío'),
			('CL', 'CO', 'Coquimbo'),
			('CL', 'LI', 'Libertador General Bernardo O''Higgins'),
			('CL', 'LL', 'Los Lagos'),
			('CL', 'LR', 'Los Ríos'),
			('CL', 'MA', 'Magallanes'),
			('CL', 'ML', 'Maule'),
			('CL', 'RM', 'Región Metropolitana de Santiago'),
			('CL', 'TA', 'Tarapacá'),
			('CL', 'VS', 'Valparaíso'),
			('CM', 'AD', 'Adamaoua'),
			('CM', 'CE', 'Centre'),
			('CM', 'EN', 'Far North'),
			('CM', 'ES', 'East'),
			('CM', 'LT', 'Littoral'),
			('CM', 'NO', 'North'),
			('CM', 'NW', 'North-West'),
			('CM', 'OU', 'West'),
			('CM', 'SU', 'South'),
			('CM', 'SW', 'South-West'),
			('CN', '11', 'Beijing'),
			('CN', '12', 'Tianjin'),
			('CN', '13', 'Hebei'),
			('CN', '14', 'Shanxi'),
			('CN', '15', 'Nei Mongol'),
			('CN', '21', 'Liaoning'),
			('CN', '22', 'Jilin'),
			('CN', '23', 'Heilongjiang'),
			('CN', '31', 'Shanghai'),
			('CN', '32', 'Jiangsu'),
			('CN', '33', 'Zhejiang'),
			('CN', '34', 'Anhui'),
			('CN', '35', 'Fujian'),
			('CN', '36', 'Jiangxi'),
			('CN', '37', 'Shandong'),
			('CN', '41', 'Henan'),
			('CN', '42', 'Hubei'),
			('CN', '43', 'Hunan'),
			('CN', '44', 'Guangdong'),
			('CN', '45', 'Guangxi'),
			('CN', '46', 'Hainan'),
			('CN', '50', 'Chongqing'),
			('CN', '51', 'Sichuan'),
			('CN', '52', 'Guizhou'),
			('CN', '53', 'Yunnan'),
			('CN', '54', 'Xizang'),
			('CN', '61', 'Shaanxi'),
			('CN', '62', 'Gansu'),
			('CN', '63', 'Qinghai'),
			('CN', '64', 'Ningxia'),
			('CN', '65', 'Xinjiang'),
			('CN', '71', 'Taiwan *'),
			('CN', '91', 'Xianggang'),
			('CN', '92', 'Aomen'),
			('CO', 'AMA', 'Amazonas'),
			('CO', 'ANT', 'Antioquia'),
			('CO', 'ARA', 'Arauca'),
			('CO', 'ATL', 'Atlántico'),
			('CO', 'BOL', 'Bolívar'),
			('CO', 'BOY', 'Boyacá'),
			('CO', 'CAL', 'Caldas'),
			('CO', 'CAQ', 'Caquetá'),
			('CO', 'CAS', 'Casanare'),
			('CO', 'CAU', 'Cauca'),
			('CO', 'CES', 'Cesar'),
			('CO', 'CHO', 'Chocó'),
			('CO', 'COR', 'Córdoba'),
			('CO', 'CUN', 'Cundinamarca'),
			('CO', 'DC', 'Distrito Capital de Bogotá'),
			('CO', 'GUA', 'Guainía'),
			('CO', 'GUV', 'Guaviare'),
			('CO', 'HUI', 'Huila'),
			('CO', 'LAG', 'La Guajira'),
			('CO', 'MAG', 'Magdalena'),
			('CO', 'MET', 'Meta'),
			('CO', 'NAR', 'Nariño'),
			('CO', 'NSA', 'Norte de Santander'),
			('CO', 'PUT', 'Putumayo'),
			('CO', 'QUI', 'Quindío'),
			('CO', 'RIS', 'Risaralda'),
			('CO', 'SAN', 'Santander'),
			('CO', 'SAP', 'San Andrés, Providencia y Santa Catalina'),
			('CO', 'SUC', 'Sucre'),
			('CO', 'TOL', 'Tolima'),
			('CO', 'VAC', 'Valle del Cauca'),
			('CO', 'VAU', 'Vaupés'),
			('CO', 'VID', 'Vichada'),
			('CR', 'A', 'Alajuela'),
			('CR', 'C', 'Cartago'),
			('CR', 'G', 'Guanacaste'),
			('CR', 'H', 'Heredia'),
			('CR', 'L', 'Limón'),
			('CR', 'P', 'Puntarenas'),
			('CR', 'SJ', 'San José'),
			('CU', '01', 'Pinar del Río'),
			('CU', '02', 'La Habana'),
			('CU', '03', 'Ciudad de La Habana'),
			('CU', '04', 'Matanzas'),
			('CU', '05', 'Villa Clara'),
			('CU', '06', 'Cienfuegos'),
			('CU', '07', 'Sancti Spíritus'),
			('CU', '08', 'Ciego de Ávila'),
			('CU', '09', 'Camagüey'),
			('CU', '10', 'Las Tunas'),
			('CU', '11', 'Holguín'),
			('CU', '12', 'Granma'),
			('CU', '13', 'Santiago de Cuba'),
			('CU', '14', 'Guantánamo'),
			('CU', '99', 'Isla de la Juventud'),
			('CV', 'B', 'Ilhas de Barlavento'),
			('CV', 'BR', 'Brava'),
			('CV', 'BV', 'Boa Vista'),
			('CV', 'CA', 'Santa Catarina'),
			('CV', 'CF', 'Santa Catarina do Fogo'),
			('CV', 'CR', 'Santa Cruz'),
			('CV', 'MA', 'Maio'),
			('CV', 'MO', 'Mosteiros'),
			('CV', 'PA', 'Paul'),
			('CV', 'PN', 'Porto Novo'),
			('CV', 'PR', 'Praia'),
			('CV', 'RB', 'Ribeira Brava'),
			('CV', 'RG', 'Ribeira Grande'),
			('CV', 'RS', 'Ribeira Grande de Santiago'),
			('CV', 'S', 'Ilhas de Sotavento'),
			('CV', 'SD', 'São Domingos'),
			('CV', 'SF', 'São Filipe'),
			('CV', 'SL', 'Sal'),
			('CV', 'SM', 'São Miguel'),
			('CV', 'SO', 'São Lourenço dos Órgãos'),
			('CV', 'SS', 'São Salvador do Mundo'),
			('CV', 'SV', 'São Vicente'),
			('CV', 'TA', 'Tarrafal'),
			('CV', 'TS', 'Tarrafal de São Nicolau'),
			('CY', '01', 'Lefkosia'),
			('CY', '02', 'Lemesos'),
			('CY', '03', 'Larnaka'),
			('CY', '04', 'Ammochostos'),
			('CY', '05', 'Pafos'),
			('CY', '06', 'Keryneia'),
			('CZ', '101', 'Praha 1'),
			('CZ', '102', 'Praha 2'),
			('CZ', '103', 'Praha 3'),
			('CZ', '104', 'Praha 4'),
			('CZ', '105', 'Praha 5'),
			('CZ', '106', 'Praha 6'),
			('CZ', '107', 'Praha 7'),
			('CZ', '108', 'Praha 8'),
			('CZ', '109', 'Praha 9'),
			('CZ', '10A', 'Praha 10'),
			('CZ', '10B', 'Praha 11'),
			('CZ', '10C', 'Praha 12'),
			('CZ', '10D', 'Praha 13'),
			('CZ', '10E', 'Praha 14'),
			('CZ', '10F', 'Praha 15'),
			('CZ', '201', 'Benešov'),
			('CZ', '202', 'Beroun'),
			('CZ', '203', 'Kladno'),
			('CZ', '204', 'Kolín'),
			('CZ', '205', 'Kutná Hora'),
			('CZ', '206', 'Mělník'),
			('CZ', '207', 'Mladá Boleslav'),
			('CZ', '208', 'Nymburk'),
			('CZ', '209', 'Praha východ'),
			('CZ', '20A', 'Praha západ'),
			('CZ', '20B', 'Příbram'),
			('CZ', '20C', 'Rakovník'),
			('CZ', '311', 'České Budějovice'),
			('CZ', '312', 'Český Krumlov'),
			('CZ', '313', 'Jindřichův Hradec'),
			('CZ', '314', 'Písek'),
			('CZ', '315', 'Prachatice'),
			('CZ', '316', 'Strakonice'),
			('CZ', '317', 'Tábor'),
			('CZ', '321', 'Domažlice'),
			('CZ', '322', 'Klatovy'),
			('CZ', '323', 'Plzeň město'),
			('CZ', '324', 'Plzeň jih'),
			('CZ', '325', 'Plzeň sever'),
			('CZ', '326', 'Rokycany'),
			('CZ', '327', 'Tachov'),
			('CZ', '411', 'Cheb'),
			('CZ', '412', 'Karlovy Vary'),
			('CZ', '413', 'Sokolov'),
			('CZ', '421', 'Děčín'),
			('CZ', '422', 'Chomutov'),
			('CZ', '423', 'Litoměřice'),
			('CZ', '424', 'Louny'),
			('CZ', '425', 'Most'),
			('CZ', '426', 'Teplice'),
			('CZ', '427', 'Ústí nad Labem'),
			('CZ', '511', 'Česká Lípa'),
			('CZ', '512', 'Jablonec nad Nisou'),
			('CZ', '513', 'Liberec'),
			('CZ', '514', 'Semily'),
			('CZ', '521', 'Hradec Králové'),
			('CZ', '522', 'Jičín'),
			('CZ', '523', 'Náchod'),
			('CZ', '524', 'Rychnov nad Kněžnou'),
			('CZ', '525', 'Trutnov'),
			('CZ', '531', 'Chrudim'),
			('CZ', '532', 'Pardubice'),
			('CZ', '533', 'Svitavy'),
			('CZ', '534', 'Ústí nad Orlicí'),
			('CZ', '611', 'Havlíčkův Brod'),
			('CZ', '612', 'Jihlava'),
			('CZ', '613', 'Pelhřimov'),
			('CZ', '614', 'Třebíč'),
			('CZ', '615', 'Žd’ár nad Sázavou'),
			('CZ', '621', 'Blansko'),
			('CZ', '622', 'Brno-město'),
			('CZ', '623', 'Brno-venkov'),
			('CZ', '624', 'Břeclav'),
			('CZ', '625', 'Hodonín'),
			('CZ', '626', 'Vyškov'),
			('CZ', '627', 'Znojmo'),
			('CZ', '711', 'Jeseník'),
			('CZ', '712', 'Olomouc'),
			('CZ', '713', 'Prostĕjov'),
			('CZ', '714', 'Přerov'),
			('CZ', '715', 'Šumperk'),
			('CZ', '721', 'Kromĕříž'),
			('CZ', '722', 'Uherské Hradištĕ'),
			('CZ', '723', 'Vsetín'),
			('CZ', '724', 'Zlín'),
			('CZ', '801', 'Bruntál'),
			('CZ', '802', 'Frýdek Místek'),
			('CZ', '803', 'Karviná'),
			('CZ', '804', 'Nový Jičín'),
			('CZ', '805', 'Opava'),
			('CZ', '806', 'Ostrava město'),
			('CZ', 'JC', 'Jihoceský kraj'),
			('CZ', 'JM', 'Jihomoravský kraj'),
			('CZ', 'KA', 'Karlovarský kraj'),
			('CZ', 'KR', 'Královéhradecký kraj'),
			('CZ', 'LI', 'Liberecký kraj'),
			('CZ', 'MO', 'Moravskoslezský kraj'),
			('CZ', 'OL', 'Olomoucký kraj'),
			('CZ', 'PA', 'Pardubický kraj'),
			('CZ', 'PL', 'Plzenský kraj'),
			('CZ', 'PR', 'Praha, hlavní mesto'),
			('CZ', 'ST', 'Stredoceský kraj'),
			('CZ', 'US', 'Ústecký kraj'),
			('CZ', 'VY', 'Vysocina'),
			('CZ', 'ZL', 'Zlínský kraj'),
			('DE', 'BB', 'Brandenburg'),
			('DE', 'BE', 'Berlin'),
			('DE', 'BW', 'Baden-Württemberg'),
			('DE', 'BY', 'Bayern'),
			('DE', 'HB', 'Bremen'),
			('DE', 'HE', 'Hessen'),
			('DE', 'HH', 'Hamburg'),
			('DE', 'MV', 'Mecklenburg-Vorpommern'),
			('DE', 'NI', 'Niedersachsen'),
			('DE', 'NW', 'Nordrhein-Westfalen'),
			('DE', 'RP', 'Rheinland-Pfalz'),
			('DE', 'SH', 'Schleswig-Holstein'),
			('DE', 'SL', 'Saarland'),
			('DE', 'SN', 'Sachsen'),
			('DE', 'ST', 'Sachsen-Anhalt'),
			('DE', 'TH', 'Thüringen'),
			('DJ', 'AR', 'Arta'),
			('DJ', 'AS', 'Ali Sabieh'),
			('DJ', 'DI', 'Dikhil'),
			('DJ', 'DJ', 'Djibouti'),
			('DJ', 'OB', 'Obock'),
			('DJ', 'TA', 'Tadjourah'),
			('DK', '81', 'North Jutland'),
			('DK', '82', 'Central Jutland'),
			('DK', '83', 'South Denmark'),
			('DK', '84', 'Capital'),
			('DK', '85', 'Zeeland'),
			('DM', '02', 'Saint Andrew'),
			('DM', '03', 'Saint David'),
			('DM', '04', 'Saint George'),
			('DM', '05', 'Saint John'),
			('DM', '06', 'Saint Joseph'),
			('DM', '07', 'Saint Luke'),
			('DM', '08', 'Saint Mark'),
			('DM', '09', 'Saint Patrick'),
			('DM', '10', 'Saint Paul'),
			('DM', '11', 'Saint Peter'),
			('DO', '01', 'Distrito Nacional'),
			('DO', '02', 'Azua'),
			('DO', '03', 'Bahoruco'),
			('DO', '04', 'Barahona'),
			('DO', '05', 'Dajabón'),
			('DO', '06', 'Duarte'),
			('DO', '07', 'La Estrelleta [Elías Piña]'),
			('DO', '08', 'El Seybo [El Seibo]'),
			('DO', '09', 'Espaillat'),
			('DO', '10', 'Independencia'),
			('DO', '11', 'La Altagracia'),
			('DO', '12', 'La Romana'),
			('DO', '13', 'La Vega'),
			('DO', '14', 'María Trinidad Sánchez'),
			('DO', '15', 'Monte Cristi'),
			('DO', '16', 'Pedernales'),
			('DO', '17', 'Peravia'),
			('DO', '18', 'Puerto Plata'),
			('DO', '19', 'Salcedo'),
			('DO', '20', 'Samaná'),
			('DO', '21', 'San Cristóbal'),
			('DO', '22', 'San Juan'),
			('DO', '23', 'San Pedro de Macorís'),
			('DO', '24', 'Sánchez Ramírez'),
			('DO', '25', 'Santiago'),
			('DO', '26', 'Santiago Rodríguez'),
			('DO', '27', 'Valverde'),
			('DO', '28', 'Monseñor Nouel'),
			('DO', '29', 'Monte Plata'),
			('DO', '30', 'Hato Mayor'),
			('DO', '31', 'San Jose de Ocoa'),
			('DO', '32', 'Santo Domingo'),
			('DZ', '01', 'Adrar'),
			('DZ', '02', 'Chlef'),
			('DZ', '03', 'Laghouat'),
			('DZ', '04', 'Oum el Bouaghi'),
			('DZ', '05', 'Batna'),
			('DZ', '06', 'Béjaïa'),
			('DZ', '07', 'Biskra'),
			('DZ', '08', 'Béchar'),
			('DZ', '09', 'Blida'),
			('DZ', '10', 'Bouira'),
			('DZ', '11', 'Tamanghasset'),
			('DZ', '12', 'Tébessa'),
			('DZ', '13', 'Tlemcen'),
			('DZ', '14', 'Tiaret'),
			('DZ', '15', 'Tizi Ouzou'),
			('DZ', '16', 'Alger'),
			('DZ', '17', 'Djelfa'),
			('DZ', '18', 'Jijel'),
			('DZ', '19', 'Sétif'),
			('DZ', '20', 'Saïda'),
			('DZ', '21', 'Skikda'),
			('DZ', '22', 'Sidi Bel Abbès'),
			('DZ', '23', 'Annaba'),
			('DZ', '24', 'Guelma'),
			('DZ', '25', 'Constantine'),
			('DZ', '26', 'Médéa'),
			('DZ', '27', 'Mostaganem'),
			('DZ', '28', 'Msila'),
			('DZ', '29', 'Mascara'),
			('DZ', '30', 'Ouargla'),
			('DZ', '31', 'Oran'),
			('DZ', '32', 'El Bayadh'),
			('DZ', '33', 'Illizi'),
			('DZ', '34', 'Bordj Bou Arréridj'),
			('DZ', '35', 'Boumerdès'),
			('DZ', '36', 'El Tarf'),
			('DZ', '37', 'Tindouf'),
			('DZ', '38', 'Tissemsilt'),
			('DZ', '39', 'El Oued'),
			('DZ', '40', 'Khenchela'),
			('DZ', '41', 'Souk Ahras'),
			('DZ', '42', 'Tipaza'),
			('DZ', '43', 'Mila'),
			('DZ', '44', 'Aïn Defla'),
			('DZ', '45', 'Naama'),
			('DZ', '46', 'Aïn Témouchent'),
			('DZ', '47', 'Ghardaïa'),
			('DZ', '48', 'Relizane'),
			('EC', 'A', 'Azuay'),
			('EC', 'B', 'Bolívar'),
			('EC', 'C', 'Carchi'),
			('EC', 'D', 'Orellana'),
			('EC', 'E', 'Esmeraldas'),
			('EC', 'F', 'Cañar'),
			('EC', 'G', 'Guayas'),
			('EC', 'H', 'Chimborazo'),
			('EC', 'I', 'Imbabura'),
			('EC', 'L', 'Loja'),
			('EC', 'M', 'Manabí'),
			('EC', 'N', 'Napo'),
			('EC', 'O', 'El Oro'),
			('EC', 'P', 'Pichincha'),
			('EC', 'R', 'Los Ríos'),
			('EC', 'S', 'Morona-Santiago'),
			('EC', 'SD', 'Santo Domingo de los Tsachilas'),
			('EC', 'SE', 'Santa Elena'),
			('EC', 'T', 'Tungurahua'),
			('EC', 'U', 'Sucumbíos'),
			('EC', 'W', 'Galápagos'),
			('EC', 'X', 'Cotopaxi'),
			('EC', 'Y', 'Pastaza'),
			('EC', 'Z', 'Zamora-Chinchipe'),
			('EE', '37', 'Harjumaa'),
			('EE', '39', 'Hiiumaa'),
			('EE', '44', 'Ida-Virumaa'),
			('EE', '49', 'Jõgevamaa'),
			('EE', '51', 'Järvamaa'),
			('EE', '57', 'Läänemaa'),
			('EE', '59', 'Lääne-Virumaa'),
			('EE', '65', 'Põlvamaa'),
			('EE', '67', 'Pärnumaa'),
			('EE', '70', 'Raplamaa'),
			('EE', '74', 'Saaremaa'),
			('EE', '78', 'Tartumaa'),
			('EE', '82', 'Valgamaa'),
			('EE', '84', 'Viljandimaa'),
			('EE', '86', 'Võrumaa'),
			('EG', 'ALX', 'Al Iskandariyah'),
			('EG', 'ASN', 'Aswan'),
			('EG', 'AST', 'Asyut'),
			('EG', 'BA', 'Al Bahr al Ahmar'),
			('EG', 'BH', 'Al Buhayrah'),
			('EG', 'BNS', 'Bani Suwayf'),
			('EG', 'C', 'Al Qahirah'),
			('EG', 'DK', 'Ad Daqahliyah'),
			('EG', 'DT', 'Dumyat'),
			('EG', 'FYM', 'Al Fayyum'),
			('EG', 'GH', 'Al Gharbiyah'),
			('EG', 'GZ', 'Al Jizah'),
			('EG', 'HU', 'Ḩulwān'),
			('EG', 'IS', 'Al Ismā`īlīyah'),
			('EG', 'JS', 'Janub Sina'''),
			('EG', 'KB', 'Al Qalyubiyah'),
			('EG', 'KFS', 'Kafr ash Shaykh'),
			('EG', 'KN', 'Qina'),
			('EG', 'LX', 'al-Uqsur'),
			('EG', 'MN', 'Al Minya'),
			('EG', 'MNF', 'Al Minufiyah'),
			('EG', 'MT', 'Matrūh'),
			('EG', 'PTS', 'Būr Sa`īd'),
			('EG', 'SHG', 'Suhaj'),
			('EG', 'SHR', 'Ash Sharqiyah'),
			('EG', 'SIN', 'Shamal Sina'''),
			('EG', 'SU', 'As Sādis min Uktūbar'),
			('EG', 'SUZ', 'As Suways'),
			('EG', 'WAD', 'Al Wadi al Jadid'),
			('EH', 'BOD', 'Boujdour'),
			('EH', 'ESM', 'Es Semara'),
			('EH', 'LAA', 'Laayoune'),
			('EH', 'OUD', 'Oued el Dahab'),
			('ER', 'AN', 'Anseba'),
			('ER', 'DK', 'Debubawi K’eyyĭḥ Baḥri'),
			('ER', 'DU', 'Debub'),
			('ER', 'GB', 'Gash-Barka'),
			('ER', 'MA', 'Ma’ĭkel'),
			('ER', 'SK', 'Semienawi K’eyyĭḥ Baḥri'),
			('ES', 'A', 'Alicante'),
			('ES', 'AB', 'Albacete'),
			('ES', 'AL', 'Almería'),
			('ES', 'AN', 'Andalucía'),
			('ES', 'AR', 'Aragón'),
			('ES', 'AS', 'Asturias, Principado de'),
			('ES', 'AV', 'Ávila'),
			('ES', 'B', 'Barcelona'),
			('ES', 'BA', 'Badajoz'),
			('ES', 'BI', 'Vizcaya'),
			('ES', 'BU', 'Burgos'),
			('ES', 'C', 'A Coruña'),
			('ES', 'CA', 'Cádiz'),
			('ES', 'CB', 'Cantabria'),
			('ES', 'CC', 'Cáceres'),
			('ES', 'CE', 'Ceuta'),
			('ES', 'CL', 'Castilla y León'),
			('ES', 'CM', 'Castilla-La Mancha'),
			('ES', 'CN', 'Canarias'),
			('ES', 'CO', 'Córdoba'),
			('ES', 'CR', 'Ciudad Real'),
			('ES', 'CS', 'Castellón'),
			('ES', 'CT', 'Catalunya'),
			('ES', 'CU', 'Cuenca'),
			('ES', 'EX', 'Extremadura'),
			('ES', 'GA', 'Galicia'),
			('ES', 'GC', 'Las Palmas'),
			('ES', 'GI', 'Girona'),
			('ES', 'GR', 'Granada'),
			('ES', 'GU', 'Guadalajara'),
			('ES', 'H', 'Huelva'),
			('ES', 'HU', 'Huesca'),
			('ES', 'IB', 'Illes Balears'),
			('ES', 'J', 'Jaén'),
			('ES', 'L', 'Lleida'),
			('ES', 'LE', 'León'),
			('ES', 'LO', 'La Rioja'),
			('ES', 'LU', 'Lugo'),
			('ES', 'M', 'Madrid'),
			('ES', 'MA', 'Málaga'),
			('ES', 'MC', 'Murcia, Región de'),
			('ES', 'MD', 'Madrid, Comunidad de'),
			('ES', 'ML', 'Melilla'),
			('ES', 'MU', 'Murcia'),
			('ES', 'NA', 'Navarra'),
			('ES', 'NC', 'Navarra, Comunidad Foral de'),
			('ES', 'O', 'Asturias'),
			('ES', 'OR', 'Ourense'),
			('ES', 'P', 'Palencia'),
			('ES', 'PM', 'Baleares'),
			('ES', 'PO', 'Pontevedra'),
			('ES', 'PV', 'País Vasco'),
			('ES', 'RI', 'La Rioja'),
			('ES', 'S', 'Cantabria'),
			('ES', 'SA', 'Salamanca'),
			('ES', 'SE', 'Sevilla'),
			('ES', 'SG', 'Segovia'),
			('ES', 'SO', 'Soria'),
			('ES', 'SS', 'Guipúzcoa'),
			('ES', 'T', 'Tarragona'),
			('ES', 'TE', 'Teruel'),
			('ES', 'TF', 'Santa Cruz de Tenerife'),
			('ES', 'TO', 'Toledo'),
			('ES', 'V', 'Valencia'),
			('ES', 'VA', 'Valladolid'),
			('ES', 'VC', 'Valenciana, Comunidad'),
			('ES', 'VI', 'Álava'),
			('ES', 'Z', 'Zaragoza'),
			('ES', 'ZA', 'Zamora'),
			('ET', 'AA', 'Adis Abeba'),
			('ET', 'AF', 'Afar'),
			('ET', 'AM', 'Amara'),
			('ET', 'BE', 'Binshangul Gumuz'),
			('ET', 'DD', 'Dire Dawa'),
			('ET', 'GA', 'Gambela Hizboch'),
			('ET', 'HA', 'Hareri Hizb'),
			('ET', 'OR', 'Oromiya'),
			('ET', 'SN', 'YeDebub Biheroch Bihereseboch na Hizboch'),
			('ET', 'SO', 'Sumale'),
			('ET', 'TI', 'Tigray'),
			('FI', '01', 'Ahvenanmaan maakunta'),
			('FI', '02', 'Etelä-Karjala'),
			('FI', '03', 'Etelä-Pohjanmaa'),
			('FI', '04', 'Etelä-Savo'),
			('FI', '05', 'Kainuu'),
			('FI', '06', 'Kanta-Häme'),
			('FI', '07', 'Keski-Pohjanmaa'),
			('FI', '08', 'Keski-Suomi'),
			('FI', '09', 'Kymenlaakso'),
			('FI', '10', 'Lappi'),
			('FI', '11', 'Pirkanmaa'),
			('FI', '12', 'Pohjanmaa'),
			('FI', '13', 'Pohjois-Karjala'),
			('FI', '14', 'Pohjois-Pohjanmaa'),
			('FI', '15', 'Pohjois-Savo'),
			('FI', '16', 'Päijät-Häme'),
			('FI', '17', 'Satakunta'),
			('FI', '18', 'Uusimaa'),
			('FI', '19', 'Varsinais-Suomi'),
			('FJ', 'C', 'Central'),
			('FJ', 'E', 'Eastern'),
			('FJ', 'N', 'Northern'),
			('FJ', 'R', 'Rotuma'),
			('FJ', 'W', 'Western'),
			('FM', 'KSA', 'Kosrae'),
			('FM', 'PNI', 'Pohnpei'),
			('FM', 'TRK', 'Chuuk'),
			('FM', 'YAP', 'Yap'),
			('FR', '01', 'Ain'),
			('FR', '02', 'Aisne'),
			('FR', '03', 'Allier'),
			('FR', '04', 'Alpes-de-Haute-Provence'),
			('FR', '05', 'Hautes-Alpes'),
			('FR', '06', 'Alpes-Maritimes'),
			('FR', '07', 'Ardèche'),
			('FR', '08', 'Ardennes'),
			('FR', '09', 'Ariège'),
			('FR', '10', 'Aube'),
			('FR', '11', 'Aude'),
			('FR', '12', 'Aveyron'),
			('FR', '13', 'Bouches-du-Rhône'),
			('FR', '14', 'Calvados'),
			('FR', '15', 'Cantal'),
			('FR', '16', 'Charente'),
			('FR', '17', 'Charente-Maritime'),
			('FR', '18', 'Cher'),
			('FR', '19', 'Corrèze'),
			('FR', '21', 'Côte-d''Or'),
			('FR', '22', 'Côtes-d''Armor'),
			('FR', '23', 'Creuse'),
			('FR', '24', 'Dordogne'),
			('FR', '25', 'Doubs'),
			('FR', '26', 'Drôme'),
			('FR', '27', 'Eure'),
			('FR', '28', 'Eure-et-Loir'),
			('FR', '29', 'Finistère'),
			('FR', '2A', 'Corse-du-Sud'),
			('FR', '2B', 'Haute-Corse'),
			('FR', '30', 'Gard'),
			('FR', '31', 'Haute-Garonne'),
			('FR', '32', 'Gers'),
			('FR', '33', 'Gironde'),
			('FR', '34', 'Hérault'),
			('FR', '35', 'Ille-et-Vilaine'),
			('FR', '36', 'Indre'),
			('FR', '37', 'Indre-et-Loire'),
			('FR', '38', 'Isère'),
			('FR', '39', 'Jura'),
			('FR', '40', 'Landes'),
			('FR', '41', 'Loir-et-Cher'),
			('FR', '42', 'Loire'),
			('FR', '43', 'Haute-Loire'),
			('FR', '44', 'Loire-Atlantique'),
			('FR', '45', 'Loiret'),
			('FR', '46', 'Lot'),
			('FR', '47', 'Lot-et-Garonne'),
			('FR', '48', 'Lozère'),
			('FR', '49', 'Maine-et-Loire'),
			('FR', '50', 'Manche'),
			('FR', '51', 'Marne'),
			('FR', '52', 'Haute-Marne'),
			('FR', '53', 'Mayenne'),
			('FR', '54', 'Meurthe-et-Moselle'),
			('FR', '55', 'Meuse'),
			('FR', '56', 'Morbihan'),
			('FR', '57', 'Moselle'),
			('FR', '58', 'Nièvre'),
			('FR', '59', 'Nord'),
			('FR', '60', 'Oise'),
			('FR', '61', 'Orne'),
			('FR', '62', 'Pas-de-Calais'),
			('FR', '63', 'Puy-de-Dôme'),
			('FR', '64', 'Pyrénées-Atlantiques'),
			('FR', '65', 'Hautes-Pyrénées'),
			('FR', '66', 'Pyrénées-Orientales'),
			('FR', '67', 'Bas-Rhin'),
			('FR', '68', 'Haut-Rhin'),
			('FR', '69', 'Rhône'),
			('FR', '70', 'Haute-Saône'),
			('FR', '71', 'Saône-et-Loire'),
			('FR', '72', 'Sarthe'),
			('FR', '73', 'Savoie'),
			('FR', '74', 'Haute-Savoie'),
			('FR', '75', 'Paris'),
			('FR', '76', 'Seine-Maritime'),
			('FR', '77', 'Seine-et-Marne'),
			('FR', '78', 'Yvelines'),
			('FR', '79', 'Deux-Sèvres'),
			('FR', '80', 'Somme'),
			('FR', '81', 'Tarn'),
			('FR', '82', 'Tarn-et-Garonne'),
			('FR', '83', 'Var'),
			('FR', '84', 'Vaucluse'),
			('FR', '85', 'Vendée'),
			('FR', '86', 'Vienne'),
			('FR', '87', 'Haute-Vienne'),
			('FR', '88', 'Vosges'),
			('FR', '89', 'Yonne'),
			('FR', '90', 'Territoire de Belfort'),
			('FR', '91', 'Essonne'),
			('FR', '92', 'Hauts-de-Seine'),
			('FR', '93', 'Seine-Saint-Denis'),
			('FR', '94', 'Val-de-Marne'),
			('FR', '95', 'Val-d''Oise'),
			('FR', 'A', 'Alsace'),
			('FR', 'B', 'Aquitaine'),
			('FR', 'BL', 'Saint-Barthélemy'),
			('FR', 'C', 'Auvergne'),
			('FR', 'CP', 'Clipperton'),
			('FR', 'D', 'Bourgogne'),
			('FR', 'E', 'Bretagne'),
			('FR', 'F', 'Centre'),
			('FR', 'G', 'Champagne-Ardenne'),
			('FR', 'GF', 'Guyane'),
			('FR', 'GP', 'Guadeloupe'),
			('FR', 'H', 'Corse'),
			('FR', 'I', 'Franche-Comté'),
			('FR', 'J', 'Île-de-France'),
			('FR', 'K', 'Languedoc-Roussillon'),
			('FR', 'L', 'Limousin'),
			('FR', 'M', 'Lorraine'),
			('FR', 'MF', 'Saint-Martin'),
			('FR', 'MQ', 'Martinique'),
			('FR', 'N', 'Midi-Pyrénées'),
			('FR', 'NC', 'Nouvelle-Calédonie'),
			('FR', 'O', 'Nord-Pas-de-Calais'),
			('FR', 'P', 'Basse-Normandie'),
			('FR', 'PF', 'Polynésie française'),
			('FR', 'PM', 'Saint-Pierre-et-Miquelon'),
			('FR', 'Q', 'Haute-Normandie'),
			('FR', 'R', 'Pays-de-la-Loire'),
			('FR', 'RE', 'La Réunion'),
			('FR', 'S', 'Picardie'),
			('FR', 'T', 'Poitou-Charentes'),
			('FR', 'TF', 'Terres Australes Françaises'),
			('FR', 'U', 'Provence-Alpes-Côte-d''Azur'),
			('FR', 'V', 'Rhône-Alpes'),
			('FR', 'WF', 'Wallis et Futuna'),
			('FR', 'YT', 'Mayotte'),
			('GA', '1', 'Estuaire'),
			('GA', '2', 'Haut-Ogooué'),
			('GA', '3', 'Moyen-Ogooué'),
			('GA', '4', 'Ngounié'),
			('GA', '5', 'Nyanga'),
			('GA', '6', 'Ogooué-Ivindo'),
			('GA', '7', 'Ogooué-Lolo'),
			('GA', '8', 'Ogooué-Maritime'),
			('GA', '9', 'Woleu-Ntem'),
			('GB', 'ABD', 'Aberdeenshire'),
			('GB', 'ABE', 'Aberdeen City'),
			('GB', 'AGB', 'Argyll and Bute'),
			('GB', 'AGY', 'Isle of Anglesey [Sir Ynys Môn GB-YNM]'),
			('GB', 'ANS', 'Angus'),
			('GB', 'ANT', 'Antrim'),
			('GB', 'ARD', 'Ards'),
			('GB', 'ARM', 'Armagh'),
			('GB', 'BAS', 'Bath and North East Somerset'),
			('GB', 'BBD', 'Blackburn with Darwen'),
			('GB', 'BDF', 'Bedfordshire'),
			('GB', 'BDG', 'Barking and Dagenham'),
			('GB', 'BEN', 'Brent'),
			('GB', 'BEX', 'Bexley'),
			('GB', 'BFS', 'Belfast'),
			('GB', 'BGE', 'Bridgend [Pen-y-bont ar Ogwr GB-POG]'),
			('GB', 'BGW', 'Blaenau Gwent'),
			('GB', 'BIR', 'Birmingham'),
			('GB', 'BKM', 'Buckinghamshire'),
			('GB', 'BLA', 'Ballymena'),
			('GB', 'BLY', 'Ballymoney'),
			('GB', 'BMH', 'Bournemouth'),
			('GB', 'BNB', 'Banbridge'),
			('GB', 'BNE', 'Barnet'),
			('GB', 'BNH', 'Brighton and Hove'),
			('GB', 'BNS', 'Barnsley'),
			('GB', 'BOL', 'Bolton'),
			('GB', 'BPL', 'Blackpool'),
			('GB', 'BRC', 'Bracknell Forest'),
			('GB', 'BRD', 'Bradford'),
			('GB', 'BRY', 'Bromley'),
			('GB', 'BST', 'Bristol, City of'),
			('GB', 'BUR', 'Bury'),
			('GB', 'CAM', 'Cambridgeshire'),
			('GB', 'CAY', 'Caerphilly [Caerffili GB-CAF]'),
			('GB', 'CGN', 'Ceredigion [Sir Ceredigion]'),
			('GB', 'CGV', 'Craigavon'),
			('GB', 'CHS', 'Cheshire'),
			('GB', 'CKF', 'Carrickfergus'),
			('GB', 'CKT', 'Cookstown'),
			('GB', 'CLD', 'Calderdale'),
			('GB', 'CLK', 'Clackmannanshire'),
			('GB', 'CLR', 'Coleraine'),
			('GB', 'CMA', 'Cumbria'),
			('GB', 'CMD', 'Camden'),
			('GB', 'CMN', 'Carmarthenshire [Sir Gaerfyrddin GB-GFY]'),
			('GB', 'CON', 'Cornwall'),
			('GB', 'COV', 'Coventry'),
			('GB', 'CRF', 'Cardiff [Caerdydd GB-CRD]'),
			('GB', 'CRY', 'Croydon'),
			('GB', 'CSR', 'Castlereagh'),
			('GB', 'CWY', 'Conwy'),
			('GB', 'DAL', 'Darlington'),
			('GB', 'DBY', 'Derbyshire'),
			('GB', 'DEN', 'Denbighshire [Sir Ddinbych GB-DDB]'),
			('GB', 'DER', 'Derby'),
			('GB', 'DEV', 'Devon'),
			('GB', 'DGN', 'Dungannon and South Tyrone'),
			('GB', 'DGY', 'Dumfries and Galloway'),
			('GB', 'DNC', 'Doncaster'),
			('GB', 'DND', 'Dundee City'),
			('GB', 'DOR', 'Dorset'),
			('GB', 'DOW', 'Down'),
			('GB', 'DRY', 'Derry'),
			('GB', 'DUD', 'Dudley'),
			('GB', 'DUR', 'Durham'),
			('GB', 'EAL', 'Ealing'),
			('GB', 'EAY', 'East Ayrshire'),
			('GB', 'EDH', 'Edinburgh, City of'),
			('GB', 'EDU', 'East Dunbartonshire'),
			('GB', 'ELN', 'East Lothian'),
			('GB', 'ELS', 'Eilean Siar'),
			('GB', 'ENF', 'Enfield'),
			('GB', 'ENG', 'England'),
			('GB', 'ERW', 'East Renfrewshire'),
			('GB', 'ERY', 'East Riding of Yorkshire'),
			('GB', 'ESS', 'Essex'),
			('GB', 'ESX', 'East Sussex'),
			('GB', 'FAL', 'Falkirk'),
			('GB', 'FER', 'Fermanagh'),
			('GB', 'FIF', 'Fife'),
			('GB', 'FLN', 'Flintshire [Sir y Fflint GB-FFL]'),
			('GB', 'GAT', 'Gateshead'),
			('GB', 'GLG', 'Glasgow City'),
			('GB', 'GLS', 'Gloucestershire'),
			('GB', 'GRE', 'Greenwich'),
			('GB', 'GWN', 'Gwynedd'),
			('GB', 'HAL', 'Halton'),
			('GB', 'HAM', 'Hampshire'),
			('GB', 'HAV', 'Havering'),
			('GB', 'HCK', 'Hackney'),
			('GB', 'HEF', 'Herefordshire, County of'),
			('GB', 'HIL', 'Hillingdon'),
			('GB', 'HLD', 'Highland'),
			('GB', 'HMF', 'Hammersmith and Fulham'),
			('GB', 'HNS', 'Hounslow'),
			('GB', 'HPL', 'Hartlepool'),
			('GB', 'HRT', 'Hertfordshire'),
			('GB', 'HRW', 'Harrow'),
			('GB', 'HRY', 'Haringey'),
			('GB', 'IOS', 'Isles of Scilly'),
			('GB', 'IOW', 'Isle of Wight'),
			('GB', 'ISL', 'Islington'),
			('GB', 'IVC', 'Inverclyde'),
			('GB', 'KEC', 'Kensington and Chelsea'),
			('GB', 'KEN', 'Kent'),
			('GB', 'KHL', 'Kingston upon Hull, City of'),
			('GB', 'KIR', 'Kirklees'),
			('GB', 'KTT', 'Kingston upon Thames'),
			('GB', 'KWL', 'Knowsley'),
			('GB', 'LAN', 'Lancashire'),
			('GB', 'LBH', 'Lambeth'),
			('GB', 'LCE', 'Leicester'),
			('GB', 'LDS', 'Leeds'),
			('GB', 'LEC', 'Leicestershire'),
			('GB', 'LEW', 'Lewisham'),
			('GB', 'LIN', 'Lincolnshire'),
			('GB', 'LIV', 'Liverpool'),
			('GB', 'LMV', 'Limavady'),
			('GB', 'LND', 'London, City of'),
			('GB', 'LRN', 'Larne'),
			('GB', 'LSB', 'Lisburn'),
			('GB', 'LUT', 'Luton'),
			('GB', 'MAN', 'Manchester'),
			('GB', 'MDB', 'Middlesbrough'),
			('GB', 'MDW', 'Medway'),
			('GB', 'MFT', 'Magherafelt'),
			('GB', 'MIK', 'Milton Keynes'),
			('GB', 'MLN', 'Midlothian'),
			('GB', 'MON', 'Monmouthshire [Sir Fynwy GB-FYN]'),
			('GB', 'MRT', 'Merton'),
			('GB', 'MRY', 'Moray'),
			('GB', 'MTY', 'Merthyr Tydfil [Merthyr Tudful GB-MTU]'),
			('GB', 'MYL', 'Moyle'),
			('GB', 'NAY', 'North Ayrshire'),
			('GB', 'NBL', 'Northumberland'),
			('GB', 'NDN', 'North Down'),
			('GB', 'NEL', 'North East Lincolnshire'),
			('GB', 'NET', 'Newcastle upon Tyne'),
			('GB', 'NFK', 'Norfolk'),
			('GB', 'NGM', 'Nottingham'),
			('GB', 'NIR', 'Northern Ireland'),
			('GB', 'NLK', 'North Lanarkshire'),
			('GB', 'NLN', 'North Lincolnshire'),
			('GB', 'NSM', 'North Somerset'),
			('GB', 'NTA', 'Newtownabbey'),
			('GB', 'NTH', 'Northamptonshire'),
			('GB', 'NTL', 'Neath Port Talbot [Castell-nedd Port Talbot GB-CTL]'),
			('GB', 'NTT', 'Nottinghamshire'),
			('GB', 'NTY', 'North Tyneside'),
			('GB', 'NWM', 'Newham'),
			('GB', 'NWP', 'Newport [Casnewydd GB-CNW]'),
			('GB', 'NYK', 'North Yorkshire'),
			('GB', 'NYM', 'Newry and Mourne'),
			('GB', 'OLD', 'Oldham'),
			('GB', 'OMH', 'Omagh'),
			('GB', 'ORK', 'Orkney Islands'),
			('GB', 'OXF', 'Oxfordshire'),
			('GB', 'PEM', 'Pembrokeshire [Sir Benfro GB-BNF]'),
			('GB', 'PKN', 'Perth and Kinross'),
			('GB', 'PLY', 'Plymouth'),
			('GB', 'POL', 'Poole'),
			('GB', 'POR', 'Portsmouth'),
			('GB', 'POW', 'Powys'),
			('GB', 'PTE', 'Peterborough'),
			('GB', 'RCC', 'Redcar and Cleveland'),
			('GB', 'RCH', 'Rochdale'),
			('GB', 'RCT', 'Rhondda, Cynon, Taff [Rhondda, Cynon,Taf]'),
			('GB', 'RDB', 'Redbridge'),
			('GB', 'RDG', 'Reading'),
			('GB', 'RFW', 'Renfrewshire'),
			('GB', 'RIC', 'Richmond upon Thames'),
			('GB', 'ROT', 'Rotherham'),
			('GB', 'RUT', 'Rutland'),
			('GB', 'SAW', 'Sandwell'),
			('GB', 'SAY', 'South Ayrshire'),
			('GB', 'SCB', 'Scottish Borders, The'),
			('GB', 'SCT', 'Scotland'),
			('GB', 'SFK', 'Suffolk'),
			('GB', 'SFT', 'Sefton'),
			('GB', 'SGC', 'South Gloucestershire'),
			('GB', 'SHF', 'Sheffield'),
			('GB', 'SHN', 'St. Helens'),
			('GB', 'SHR', 'Shropshire'),
			('GB', 'SKP', 'Stockport'),
			('GB', 'SLF', 'Salford'),
			('GB', 'SLG', 'Slough'),
			('GB', 'SLK', 'South Lanarkshire'),
			('GB', 'SND', 'Sunderland'),
			('GB', 'SOL', 'Solihull'),
			('GB', 'SOM', 'Somerset'),
			('GB', 'SOS', 'Southend-on-Sea'),
			('GB', 'SRY', 'Surrey'),
			('GB', 'STB', 'Strabane'),
			('GB', 'STE', 'Stoke-on-Trent'),
			('GB', 'STG', 'Stirling'),
			('GB', 'STH', 'Southampton'),
			('GB', 'STN', 'Sutton'),
			('GB', 'STS', 'Staffordshire'),
			('GB', 'STT', 'Stockton-on-Tees'),
			('GB', 'STY', 'South Tyneside'),
			('GB', 'SWA', 'Swansea [Abertawe GB-ATA]'),
			('GB', 'SWD', 'Swindon'),
			('GB', 'SWK', 'Southwark'),
			('GB', 'TAM', 'Tameside'),
			('GB', 'TFW', 'Telford and Wrekin'),
			('GB', 'THR', 'Thurrock'),
			('GB', 'TOB', 'Torbay'),
			('GB', 'TOF', 'Torfaen [Tor-faen]'),
			('GB', 'TRF', 'Trafford'),
			('GB', 'TWH', 'Tower Hamlets'),
			('GB', 'VGL', 'Vale of Glamorgan, The [Bro Morgannwg GB-BMG]'),
			('GB', 'WAR', 'Warwickshire'),
			('GB', 'WBK', 'West Berkshire'),
			('GB', 'WDU', 'West Dunbartonshire'),
			('GB', 'WFT', 'Waltham Forest'),
			('GB', 'WGN', 'Wigan'),
			('GB', 'WIL', 'Wiltshire'),
			('GB', 'WKF', 'Wakefield'),
			('GB', 'WLL', 'Walsall'),
			('GB', 'WLN', 'West Lothian'),
			('GB', 'WLS', 'Wales'),
			('GB', 'WLV', 'Wolverhampton'),
			('GB', 'WND', 'Wandsworth'),
			('GB', 'WNM', 'Windsor and Maidenhead'),
			('GB', 'WOK', 'Wokingham'),
			('GB', 'WOR', 'Worcestershire'),
			('GB', 'WRL', 'Wirral'),
			('GB', 'WRT', 'Warrington'),
			('GB', 'WRX', 'Wrexham [Wrecsam GB-WRC]'),
			('GB', 'WSM', 'Westminster'),
			('GB', 'WSX', 'West Sussex'),
			('GB', 'YOR', 'York'),
			('GB', 'ZET', 'Shetland Islands'),
			('GD', '01', 'Saint Andrew'),
			('GD', '02', 'Saint David'),
			('GD', '03', 'Saint George'),
			('GD', '04', 'Saint John'),
			('GD', '05', 'Saint Mark'),
			('GD', '06', 'Saint Patrick'),
			('GD', '10', 'Southern Grenadine Islands'),
			('GE', 'AB', 'Abkhazia'),
			('GE', 'AJ', 'Ajaria'),
			('GE', 'GU', 'Guria'),
			('GE', 'IM', 'Imereti'),
			('GE', 'KA', 'Kakheti'),
			('GE', 'KK', 'Kvemo Kartli'),
			('GE', 'MM', 'Mtskheta-Mtianeti'),
			('GE', 'RL', 'Racha-Lechkhumi [and] Kvemo Svaneti'),
			('GE', 'SJ', 'Samtskhe-Javakheti'),
			('GE', 'SK', 'Shida Kartli'),
			('GE', 'SZ', 'Samegrelo-Zemo Svaneti'),
			('GE', 'TB', 'Tbilisi'),
			('GH', 'AA', 'Greater Accra'),
			('GH', 'AH', 'Ashanti'),
			('GH', 'BA', 'Brong-Ahafo'),
			('GH', 'CP', 'Central'),
			('GH', 'EP', 'Eastern'),
			('GH', 'NP', 'Northern'),
			('GH', 'TV', 'Volta'),
			('GH', 'UE', 'Upper East'),
			('GH', 'UW', 'Upper West'),
			('GH', 'WP', 'Western'),
			('GL', 'KU', 'Kommune Kujalleq'),
			('GL', 'QA', 'Qaasuitsup Kommunia'),
			('GL', 'QE', 'Qeqqata Kommunia'),
			('GL', 'SM', 'Kommuneqarfik Sermersooq'),
			('GM', 'B', 'Banjul'),
			('GM', 'L', 'Lower River'),
			('GM', 'M', 'MacCarthy Island'),
			('GM', 'N', 'North Bank'),
			('GM', 'U', 'Upper River'),
			('GM', 'W', 'Western'),
			('GN', 'B', 'Boké'),
			('GN', 'BE', 'Beyla'),
			('GN', 'BF', 'Boffa'),
			('GN', 'BK', 'Boké'),
			('GN', 'C', 'Conakry'),
			('GN', 'CO', 'Coyah'),
			('GN', 'D', 'Kindia'),
			('GN', 'DB', 'Dabola'),
			('GN', 'DI', 'Dinguiraye'),
			('GN', 'DL', 'Dalaba'),
			('GN', 'DU', 'Dubréka'),
			('GN', 'F', 'faranah'),
			('GN', 'FA', 'Faranah'),
			('GN', 'FO', 'Forécariah'),
			('GN', 'FR', 'Fria'),
			('GN', 'GA', 'Gaoual'),
			('GN', 'GU', 'Guékédou'),
			('GN', 'K', 'Kankan'),
			('GN', 'KA', 'Kankan'),
			('GN', 'KB', 'Koubia'),
			('GN', 'KD', 'Kindia'),
			('GN', 'KE', 'Kérouané'),
			('GN', 'KN', 'Koundara'),
			('GN', 'KO', 'Kouroussa'),
			('GN', 'KS', 'Kissidougou'),
			('GN', 'L', 'Labé'),
			('GN', 'LA', 'Labé'),
			('GN', 'LE', 'Lélouma'),
			('GN', 'LO', 'Lola'),
			('GN', 'M', 'Mamou'),
			('GN', 'MC', 'Macenta'),
			('GN', 'MD', 'Mandiana'),
			('GN', 'ML', 'Mali'),
			('GN', 'MM', 'Mamou'),
			('GN', 'N', 'Nzérékoré'),
			('GN', 'NZ', 'Nzérékoré'),
			('GN', 'PI', 'Pita'),
			('GN', 'SI', 'Siguiri'),
			('GN', 'TE', 'Télimélé'),
			('GN', 'TO', 'Tougué'),
			('GN', 'YO', 'Yomou'),
			('GQ', 'AN', 'Annobón'),
			('GQ', 'BN', 'Bioko Norte'),
			('GQ', 'BS', 'Bioko Sur'),
			('GQ', 'C', 'Región Continental'),
			('GQ', 'CS', 'Centro Sur'),
			('GQ', 'I', 'Región Insular'),
			('GQ', 'KN', 'Kie-Ntem'),
			('GQ', 'LI', 'Litoral'),
			('GQ', 'WN', 'Wele-Nzás'),
			('GR', '01', 'Aitolia kai Akarnania'),
			('GR', '03', 'Voiotia'),
			('GR', '04', 'Evvoia'),
			('GR', '05', 'Evrytania'),
			('GR', '06', 'Fthiotida'),
			('GR', '07', 'Fokida'),
			('GR', '11', 'Argolida'),
			('GR', '12', 'Arkadia'),
			('GR', '13', 'Achaïa'),
			('GR', '14', 'Ileia'),
			('GR', '15', 'Korinthia'),
			('GR', '16', 'Lakonia'),
			('GR', '17', 'Messinia'),
			('GR', '21', 'Zakynthos'),
			('GR', '22', 'Kerkyra'),
			('GR', '23', 'Kefallonia'),
			('GR', '24', 'Lefkada'),
			('GR', '31', 'Arta'),
			('GR', '32', 'Thesprotia'),
			('GR', '33', 'Ioannina'),
			('GR', '34', 'Preveza'),
			('GR', '41', 'Karditsa'),
			('GR', '42', 'Larisa'),
			('GR', '43', 'Magnisia'),
			('GR', '44', 'Trikala'),
			('GR', '51', 'Grevena'),
			('GR', '52', 'Drama'),
			('GR', '53', 'Imathia'),
			('GR', '54', 'Thessaloniki'),
			('GR', '55', 'Kavala'),
			('GR', '56', 'Kastoria'),
			('GR', '57', 'Kilkis'),
			('GR', '58', 'Kozani'),
			('GR', '59', 'Pella'),
			('GR', '61', 'Pieria'),
			('GR', '62', 'Serres'),
			('GR', '63', 'Florina'),
			('GR', '64', 'Chalkidiki'),
			('GR', '69', 'Agio Oros'),
			('GR', '71', 'Evros'),
			('GR', '72', 'Xanthi'),
			('GR', '73', 'Rodopi'),
			('GR', '81', 'Dodekanisos'),
			('GR', '82', 'Kyklades'),
			('GR', '83', 'Lesvos'),
			('GR', '84', 'Samos'),
			('GR', '85', 'Chios'),
			('GR', '91', 'Irakleio'),
			('GR', '92', 'Lasithi'),
			('GR', '93', 'Rethymno'),
			('GR', '94', 'Chania'),
			('GR', 'A', 'Anatoliki Makedonia kai Thraki'),
			('GR', 'A1', 'Attiki'),
			('GR', 'B', 'Kentriki Makedonia'),
			('GR', 'C', 'Dytiki Makedonia'),
			('GR', 'D', 'Ipeiros'),
			('GR', 'E', 'Thessalia'),
			('GR', 'F', 'Ionia Nisia'),
			('GR', 'G', 'Dytiki Ellada'),
			('GR', 'H', 'Sterea Ellada'),
			('GR', 'I', 'Attiki'),
			('GR', 'J', 'Peloponnisos'),
			('GR', 'K', 'Voreio Aigaio'),
			('GR', 'L', 'Notio Aigaio'),
			('GR', 'M', 'Kriti'),
			('GT', 'AV', 'Alta Verapaz'),
			('GT', 'BV', 'Baja Verapaz'),
			('GT', 'CM', 'Chimaltenango'),
			('GT', 'CQ', 'Chiquimula'),
			('GT', 'ES', 'Escuintla'),
			('GT', 'GU', 'Guatemala'),
			('GT', 'HU', 'Huehuetenango'),
			('GT', 'IZ', 'Izabal'),
			('GT', 'JA', 'Jalapa'),
			('GT', 'JU', 'Jutiapa'),
			('GT', 'PE', 'Petén'),
			('GT', 'PR', 'El Progreso'),
			('GT', 'QC', 'Quiché'),
			('GT', 'QZ', 'Quetzaltenango'),
			('GT', 'RE', 'Retalhuleu'),
			('GT', 'SA', 'Sacatepéquez'),
			('GT', 'SM', 'San Marcos'),
			('GT', 'SO', 'Sololá'),
			('GT', 'SR', 'Santa Rosa'),
			('GT', 'SU', 'Suchitepéquez'),
			('GT', 'TO', 'Totonicapán'),
			('GT', 'ZA', 'Zacapa'),
			('GW', 'BA', 'Bafatá'),
			('GW', 'BL', 'Bolama'),
			('GW', 'BM', 'Biombo'),
			('GW', 'BS', 'Bissau'),
			('GW', 'CA', 'Cacheu'),
			('GW', 'GA', 'Gabú'),
			('GW', 'L', 'Leste'),
			('GW', 'N', 'Norte'),
			('GW', 'OI', 'Oio'),
			('GW', 'QU', 'Quinara'),
			('GW', 'S', 'Sul'),
			('GW', 'TO', 'Tombali'),
			('GY', 'BA', 'Barima-Waini'),
			('GY', 'CU', 'Cuyuni-Mazaruni'),
			('GY', 'DE', 'Demerara-Mahaica'),
			('GY', 'EB', 'East Berbice-Corentyne'),
			('GY', 'ES', 'Essequibo Islands-West Demerara'),
			('GY', 'MA', 'Mahaica-Berbice'),
			('GY', 'PM', 'Pomeroon-Supenaam'),
			('GY', 'PT', 'Potaro-Siparuni'),
			('GY', 'UD', 'Upper Demerara-Berbice'),
			('GY', 'UT', 'Upper Takutu-Upper Essequibo'),
			('HN', 'AT', 'Atlántida'),
			('HN', 'CH', 'Choluteca'),
			('HN', 'CL', 'Colón'),
			('HN', 'CM', 'Comayagua'),
			('HN', 'CP', 'Copán'),
			('HN', 'CR', 'Cortés'),
			('HN', 'EP', 'El Paraíso'),
			('HN', 'FM', 'Francisco Morazán'),
			('HN', 'GD', 'Gracias a Dios'),
			('HN', 'IB', 'Islas de la Bahía'),
			('HN', 'IN', 'Intibucá'),
			('HN', 'LE', 'Lempira'),
			('HN', 'LP', 'La Paz'),
			('HN', 'OC', 'Ocotepeque'),
			('HN', 'OL', 'Olancho'),
			('HN', 'SB', 'Santa Bárbara'),
			('HN', 'VA', 'Valle'),
			('HN', 'YO', 'Yoro'),
			('HR', '01', 'Zagrebacka županija'),
			('HR', '02', 'Krapinsko-zagorska županija'),
			('HR', '03', 'Sisacko-moslavacka županija'),
			('HR', '04', 'Karlovacka županija'),
			('HR', '05', 'Varaždinska županija'),
			('HR', '06', 'Koprivnicko-križevacka županija'),
			('HR', '07', 'Bjelovarsko-bilogorska županija'),
			('HR', '08', 'Primorsko-goranska županija'),
			('HR', '09', 'Licko-senjska županija'),
			('HR', '10', 'Viroviticko-podravska županija'),
			('HR', '11', 'Požeško-slavonska županija'),
			('HR', '12', 'Brodsko-posavska županija'),
			('HR', '13', 'Zadarska županija'),
			('HR', '14', 'Osjecko-baranjska županija'),
			('HR', '15', 'Šibensko-kninska županija'),
			('HR', '16', 'Vukovarsko-srijemska županija'),
			('HR', '17', 'Splitsko-dalmatinska županija'),
			('HR', '18', 'Istarska županija'),
			('HR', '19', 'Dubrovacko-neretvanska županija'),
			('HR', '20', 'Medimurska županija'),
			('HR', '21', 'Grad Zagreb'),
			('HT', 'AR', 'Artibonite'),
			('HT', 'CE', 'Centre'),
			('HT', 'GA', 'Grande-Anse'),
			('HT', 'ND', 'Nord'),
			('HT', 'NE', 'Nord-Est'),
			('HT', 'NI', 'Nippes'),
			('HT', 'NO', 'Nord-Ouest'),
			('HT', 'OU', 'Ouest'),
			('HT', 'SD', 'Sud'),
			('HT', 'SE', 'Sud-Est'),
			('HU', 'BA', 'Baranya'),
			('HU', 'BC', 'Békéscsaba'),
			('HU', 'BE', 'Békés'),
			('HU', 'BK', 'Bács-Kiskun'),
			('HU', 'BU', 'Budapest'),
			('HU', 'BZ', 'Borsod-Abaúj-Zemplén'),
			('HU', 'CS', 'Csongrád'),
			('HU', 'DE', 'Debrecen'),
			('HU', 'DU', 'Dunaújváros'),
			('HU', 'EG', 'Eger'),
			('HU', 'ER', 'Erd'),
			('HU', 'FE', 'Fejér'),
			('HU', 'GS', 'Gyor-Moson-Sopron'),
			('HU', 'GY', 'Gyor'),
			('HU', 'HB', 'Hajdú-Bihar'),
			('HU', 'HE', 'Heves'),
			('HU', 'HV', 'Hódmezovásárhely');
			INSERT INTO `states` (`country_alpha2`, `code`, `name`) VALUES 
			('HU', 'JN', 'Jász-Nagykun-Szolnok'),
			('HU', 'KE', 'Komárom-Esztergom'),
			('HU', 'KM', 'Kecskemét'),
			('HU', 'KV', 'Kaposvár'),
			('HU', 'MI', 'Miskolc'),
			('HU', 'NK', 'Nagykanizsa'),
			('HU', 'NO', 'Nógrád'),
			('HU', 'NY', 'Nyíregyháza'),
			('HU', 'PE', 'Pest'),
			('HU', 'PS', 'Pécs'),
			('HU', 'SD', 'Szeged'),
			('HU', 'SF', 'Székesfehérvár'),
			('HU', 'SH', 'Szombathely'),
			('HU', 'SK', 'Szolnok'),
			('HU', 'SN', 'Sopron'),
			('HU', 'SO', 'Somogy'),
			('HU', 'SS', 'Szekszárd'),
			('HU', 'ST', 'Salgótarján'),
			('HU', 'SZ', 'Szabolcs-Szatmár-Bereg'),
			('HU', 'TB', 'Tatabánya'),
			('HU', 'TO', 'Tolna'),
			('HU', 'VA', 'Vas'),
			('HU', 'VE', 'Veszprém'),
			('HU', 'VM', 'Veszprém City'),
			('HU', 'ZA', 'Zala'),
			('HU', 'ZE', 'Zalaegerszeg'),
			('ID', 'AC', 'Aceh'),
			('ID', 'BA', 'Bali'),
			('ID', 'BB', 'Bangka Belitung'),
			('ID', 'BE', 'Bengkulu'),
			('ID', 'BT', 'Banten'),
			('ID', 'GO', 'Gorontalo'),
			('ID', 'IJ', 'Papua'),
			('ID', 'JA', 'Jambi'),
			('ID', 'JB', 'Jawa Barat'),
			('ID', 'JI', 'Jawa Timur'),
			('ID', 'JK', 'Jakarta Raya'),
			('ID', 'JT', 'Jawa Tengah'),
			('ID', 'JW', 'Jawa'),
			('ID', 'KA', 'Kalimantan'),
			('ID', 'KB', 'Kalimantan Barat'),
			('ID', 'KI', 'Kalimantan Timur'),
			('ID', 'KR', 'Kepulauan Riau'),
			('ID', 'KS', 'Kalimantan Selatan'),
			('ID', 'KT', 'Kalimantan Tengah'),
			('ID', 'LA', 'Lampung'),
			('ID', 'MA', 'Maluku'),
			('ID', 'ML', 'Maluku'),
			('ID', 'MU', 'Maluku Utara'),
			('ID', 'NB', 'Nusa Tenggara Barat'),
			('ID', 'NT', 'Nusa Tenggara Timur'),
			('ID', 'NU', 'Nusa Tenggara'),
			('ID', 'PA', 'Papua'),
			('ID', 'PB', 'Papua Barat'),
			('ID', 'RI', 'Riau'),
			('ID', 'SA', 'Sulawesi Utara'),
			('ID', 'SB', 'Sumatera Barat'),
			('ID', 'SG', 'Sulawesi Tenggara'),
			('ID', 'SL', 'Sulawesi'),
			('ID', 'SM', 'Sumatera'),
			('ID', 'SN', 'Sulawesi Selatan'),
			('ID', 'SR', 'Sulawesi Barat'),
			('ID', 'SS', 'Sumatera Selatan'),
			('ID', 'ST', 'Sulawesi Tengah'),
			('ID', 'SU', 'Sumatera Utara'),
			('ID', 'YO', 'Yogyakarta'),
			('IE', 'C', 'Connaught'),
			('IE', 'CE', 'Clare'),
			('IE', 'CN', 'Cavan'),
			('IE', 'CO', 'Cork'),
			('IE', 'CW', 'Carlow'),
			('IE', 'D', 'Dublin'),
			('IE', 'DL', 'Donegal'),
			('IE', 'G', 'Galway'),
			('IE', 'KE', 'Kildare'),
			('IE', 'KK', 'Kilkenny'),
			('IE', 'KY', 'Kerry'),
			('IE', 'L', 'Leinster'),
			('IE', 'LD', 'Longford'),
			('IE', 'LH', 'Louth'),
			('IE', 'LK', 'Limerick'),
			('IE', 'LM', 'Leitrim'),
			('IE', 'LS', 'Laois'),
			('IE', 'M', 'Munster'),
			('IE', 'MH', 'Meath'),
			('IE', 'MN', 'Monaghan'),
			('IE', 'MO', 'Mayo'),
			('IE', 'OY', 'Offaly'),
			('IE', 'RN', 'Roscommon'),
			('IE', 'SO', 'Sligo'),
			('IE', 'TA', 'Tipperary'),
			('IE', 'U', 'Ulster'),
			('IE', 'WD', 'Waterford'),
			('IE', 'WH', 'Westmeath'),
			('IE', 'WW', 'Wicklow'),
			('IE', 'WX', 'Wexford'),
			('IL', 'D', 'HaDarom'),
			('IL', 'HA', 'Haifa'),
			('IL', 'JM', 'Yerushalayim'),
			('IL', 'M', 'HaMerkaz'),
			('IL', 'TA', 'Tel-Aviv'),
			('IL', 'Z', 'HaZafon'),
			('IN', 'AN', 'Andaman and Nicobar Islands'),
			('IN', 'AP', 'Andhra Pradesh'),
			('IN', 'AR', 'Arunachal Pradesh'),
			('IN', 'AS', 'Assam'),
			('IN', 'BR', 'Bihar'),
			('IN', 'CH', 'Chandigarh'),
			('IN', 'CT', 'Chhattisgarh'),
			('IN', 'DD', 'Daman and Diu'),
			('IN', 'DL', 'Delhi'),
			('IN', 'DN', 'Dadra and Nagar Haveli'),
			('IN', 'GA', 'Goa'),
			('IN', 'GJ', 'Gujarat'),
			('IN', 'HP', 'Himachal Pradesh'),
			('IN', 'HR', 'Haryana'),
			('IN', 'JH', 'Jharkhand'),
			('IN', 'JK', 'Jammu and Kashmir'),
			('IN', 'KA', 'Karnataka'),
			('IN', 'KL', 'Kerala'),
			('IN', 'LD', 'Lakshadweep'),
			('IN', 'MH', 'Maharashtra'),
			('IN', 'ML', 'Meghalaya'),
			('IN', 'MN', 'Manipur'),
			('IN', 'MP', 'Madhya Pradesh'),
			('IN', 'MZ', 'Mizoram'),
			('IN', 'NL', 'Nagaland'),
			('IN', 'OR', 'Orissa'),
			('IN', 'PB', 'Punjab'),
			('IN', 'PY', 'Pondicherry'),
			('IN', 'RJ', 'Rajasthan'),
			('IN', 'SK', 'Sikkim'),
			('IN', 'TN', 'Tamil Nadu'),
			('IN', 'TR', 'Tripura'),
			('IN', 'UP', 'Uttar Pradesh'),
			('IN', 'UT', 'Uttaranchal'),
			('IN', 'WB', 'West Bengal'),
			('IQ', 'AN', 'Al Anbar'),
			('IQ', 'AR', 'Arbil'),
			('IQ', 'BA', 'Al Basrah'),
			('IQ', 'BB', 'Babil'),
			('IQ', 'BG', 'Baghdad'),
			('IQ', 'DA', 'Dahuk'),
			('IQ', 'DI', 'Diyalá'),
			('IQ', 'DQ', 'Dhi Qar'),
			('IQ', 'KA', 'Karbala'''),
			('IQ', 'MA', 'Maysan'),
			('IQ', 'MU', 'Al Muthanná'),
			('IQ', 'NA', 'An Najaf'),
			('IQ', 'NI', 'Ninawá'),
			('IQ', 'QA', 'Al Qadisiyah'),
			('IQ', 'SD', 'Salah ad Din'),
			('IQ', 'SU', 'As Sulaymaniyah'),
			('IQ', 'TS', 'At Ta''mim'),
			('IQ', 'WA', 'Wasit'),
			('IR', '01', 'Az¯arbayjan-e Sharqi'),
			('IR', '02', 'Az¯arbayjan-e Gharbi'),
			('IR', '03', 'Ardabil'),
			('IR', '04', 'Esfahan'),
			('IR', '05', 'Ilam'),
			('IR', '06', 'Bushehr'),
			('IR', '07', 'Tehran'),
			('IR', '08', 'Chahar Mah¸all va Bakhtiari'),
			('IR', '09', 'Khorasan'),
			('IR', '10', 'Khuzestan'),
			('IR', '11', 'Zanjan'),
			('IR', '12', 'Semnan'),
			('IR', '13', 'Sistan va Baluchestan'),
			('IR', '14', 'Fars'),
			('IR', '15', 'Kerman'),
			('IR', '16', 'Kordestan'),
			('IR', '17', 'Kermanshah'),
			('IR', '18', 'Kohkiluyeh va Buyer Ahmad'),
			('IR', '19', 'Gilan'),
			('IR', '20', 'Lorestan'),
			('IR', '21', 'Mazandaran'),
			('IR', '22', 'Markazi'),
			('IR', '23', 'Hormozgan'),
			('IR', '24', 'Hamadan'),
			('IR', '25', 'Yazd'),
			('IR', '26', 'Qom'),
			('IR', '27', 'Golestan'),
			('IR', '28', 'Qazvin'),
			('IR', '29', 'Khorasan-e Janubi'),
			('IR', '30', 'Khorasan-e Razavi'),
			('IR', '31', 'Khorasan-e Shemali'),
			('IS', '0', 'Reykjavík'),
			('IS', '1', 'Höfuðborgarsvæði utan Reykjavíkur'),
			('IS', '2', 'Suðurnes'),
			('IS', '3', 'Vesturland'),
			('IS', '4', 'Vestfirðir'),
			('IS', '5', 'Norðurland vestra'),
			('IS', '6', 'Norðurland eystra'),
			('IS', '7', 'Austurland'),
			('IS', '8', 'Suðurland'),
			('IT', '21', 'Piemonte'),
			('IT', '23', 'Valle d''Aosta'),
			('IT', '25', 'Lombardia'),
			('IT', '32', 'Trentino-Alto Adige'),
			('IT', '34', 'Veneto'),
			('IT', '36', 'Friuli-Venezia Giulia'),
			('IT', '42', 'Liguria'),
			('IT', '45', 'Emilia-Romagna'),
			('IT', '52', 'Toscana'),
			('IT', '55', 'Umbria'),
			('IT', '57', 'Marche'),
			('IT', '62', 'Lazio'),
			('IT', '65', 'Abruzzo'),
			('IT', '67', 'Molise'),
			('IT', '72', 'Campania'),
			('IT', '75', 'Puglia'),
			('IT', '77', 'Basilicata'),
			('IT', '78', 'Calabria'),
			('IT', '82', 'Sicilia'),
			('IT', '88', 'Sardegna'),
			('IT', 'AG', 'Agrigento'),
			('IT', 'AL', 'Alessandria'),
			('IT', 'AN', 'Ancona'),
			('IT', 'AO', 'Aosta'),
			('IT', 'AP', 'Ascoli Piceno'),
			('IT', 'AQ', 'L''Aquila'),
			('IT', 'AR', 'Arezzo'),
			('IT', 'AT', 'Asti'),
			('IT', 'AV', 'Avellino'),
			('IT', 'BA', 'Bari'),
			('IT', 'BG', 'Bergamo'),
			('IT', 'BI', 'Biella'),
			('IT', 'BL', 'Belluno'),
			('IT', 'BN', 'Benevento'),
			('IT', 'BO', 'Bologna'),
			('IT', 'BR', 'Brindisi'),
			('IT', 'BS', 'Brescia'),
			('IT', 'BT', 'Barletta-Andria-Trani'),
			('IT', 'BZ', 'Bolzano'),
			('IT', 'CA', 'Cagliari'),
			('IT', 'CB', 'Campobasso'),
			('IT', 'CE', 'Caserta'),
			('IT', 'CH', 'Chieti'),
			('IT', 'CI', 'Carbonia-Iglesias'),
			('IT', 'CL', 'Caltanissetta'),
			('IT', 'CN', 'Cuneo'),
			('IT', 'CO', 'Como'),
			('IT', 'CR', 'Cremona'),
			('IT', 'CS', 'Cosenza'),
			('IT', 'CT', 'Catania'),
			('IT', 'CZ', 'Catanzaro'),
			('IT', 'EN', 'Enna'),
			('IT', 'FC', 'Forli-Cesena'),
			('IT', 'FE', 'Ferrara'),
			('IT', 'FG', 'Foggia'),
			('IT', 'FI', 'Firenze'),
			('IT', 'FM', 'Fermo'),
			('IT', 'FR', 'Frosinone'),
			('IT', 'GE', 'Genova'),
			('IT', 'GO', 'Gorizia'),
			('IT', 'GR', 'Grosseto'),
			('IT', 'IM', 'Imperia'),
			('IT', 'IS', 'Isernia'),
			('IT', 'KR', 'Crotone'),
			('IT', 'LC', 'Lecco'),
			('IT', 'LE', 'Lecce'),
			('IT', 'LI', 'Livorno'),
			('IT', 'LO', 'Lodi'),
			('IT', 'LT', 'Latina'),
			('IT', 'LU', 'Lucca'),
			('IT', 'MB', 'Monza e Brianza'),
			('IT', 'MC', 'Macerata'),
			('IT', 'ME', 'Messina'),
			('IT', 'MI', 'Milano'),
			('IT', 'MN', 'Mantova'),
			('IT', 'MO', 'Modena'),
			('IT', 'MS', 'Massa-Carrara'),
			('IT', 'MT', 'Matera'),
			('IT', 'NA', 'Napoli'),
			('IT', 'NO', 'Novara'),
			('IT', 'NU', 'Nuoro'),
			('IT', 'OG', 'Ogliastra'),
			('IT', 'OR', 'Oristano'),
			('IT', 'OT', 'Olbia-Tempio'),
			('IT', 'PA', 'Palermo'),
			('IT', 'PC', 'Piacenza'),
			('IT', 'PD', 'Padova'),
			('IT', 'PE', 'Pescara'),
			('IT', 'PG', 'Perugia'),
			('IT', 'PI', 'Pisa'),
			('IT', 'PN', 'Pordenone'),
			('IT', 'PO', 'Prato'),
			('IT', 'PR', 'Parma'),
			('IT', 'PT', 'Pistoia'),
			('IT', 'PU', 'Pesaro e Urbino'),
			('IT', 'PV', 'Pavia'),
			('IT', 'PZ', 'Potenza'),
			('IT', 'RA', 'Ravenna'),
			('IT', 'RC', 'Reggio Calabria'),
			('IT', 'RE', 'Reggio Emilia'),
			('IT', 'RG', 'Ragusa'),
			('IT', 'RI', 'Rieti'),
			('IT', 'RM', 'Roma'),
			('IT', 'RN', 'Rimini'),
			('IT', 'RO', 'Rovigo'),
			('IT', 'SA', 'Salerno'),
			('IT', 'SI', 'Siena'),
			('IT', 'SO', 'Sondrio'),
			('IT', 'SP', 'La Spezia'),
			('IT', 'SR', 'Siracusa'),
			('IT', 'SS', 'Sassari'),
			('IT', 'SV', 'Savona'),
			('IT', 'TA', 'Taranto'),
			('IT', 'TE', 'Teramo'),
			('IT', 'TN', 'Trento'),
			('IT', 'TO', 'Torino'),
			('IT', 'TP', 'Trapani'),
			('IT', 'TR', 'Terni'),
			('IT', 'TS', 'Trieste'),
			('IT', 'TV', 'Treviso'),
			('IT', 'UD', 'Udine'),
			('IT', 'VA', 'Varese'),
			('IT', 'VB', 'Verbano-Cusio-Ossola'),
			('IT', 'VC', 'Vercelli'),
			('IT', 'VE', 'Venezia'),
			('IT', 'VI', 'Vicenza'),
			('IT', 'VR', 'Verona'),
			('IT', 'VS', 'Medio Campidano'),
			('IT', 'VT', 'Viterbo'),
			('IT', 'VV', 'Vibo Valentia'),
			('JM', '01', 'Kingston'),
			('JM', '02', 'Saint Andrew'),
			('JM', '03', 'Saint Thomas'),
			('JM', '04', 'Portland'),
			('JM', '05', 'Saint Mary'),
			('JM', '06', 'Saint Ann'),
			('JM', '07', 'Trelawny'),
			('JM', '08', 'Saint James'),
			('JM', '09', 'Hanover'),
			('JM', '10', 'Westmoreland'),
			('JM', '11', 'Saint Elizabeth'),
			('JM', '12', 'Manchester'),
			('JM', '13', 'Clarendon'),
			('JM', '14', 'Saint Catherine'),
			('JO', 'AJ', '‘Ajlūn'),
			('JO', 'AM', '‘Ammān'),
			('JO', 'AQ', 'Al ‘Aqabah'),
			('JO', 'AT', 'At Tafilah'),
			('JO', 'AZ', 'Az Zarqā'''),
			('JO', 'BA', 'Al Balqa'''),
			('JO', 'IR', 'Irbid'),
			('JO', 'JA', 'Jarash'),
			('JO', 'KA', 'Al Karak'),
			('JO', 'MA', 'Al Mafraq'),
			('JO', 'MD', 'Mādabā'),
			('JO', 'MN', 'Ma`an'),
			('JP', '01', 'Hokkaidô [Hokkaido]'),
			('JP', '02', 'Aomori'),
			('JP', '03', 'Iwate'),
			('JP', '04', 'Miyagi'),
			('JP', '05', 'Akita'),
			('JP', '06', 'Yamagata'),
			('JP', '07', 'Hukusima [Fukushima]'),
			('JP', '08', 'Ibaraki'),
			('JP', '09', 'Totigi [Tochigi]'),
			('JP', '10', 'Gunma'),
			('JP', '11', 'Saitama'),
			('JP', '12', 'Tiba [Chiba]'),
			('JP', '13', 'Tôkyô [Tokyo]'),
			('JP', '14', 'Kanagawa'),
			('JP', '15', 'Niigata'),
			('JP', '16', 'Toyama'),
			('JP', '17', 'Isikawa [Ishikawa]'),
			('JP', '18', 'Hukui [Fukui]'),
			('JP', '19', 'Yamanasi [Yamanashi]'),
			('JP', '20', 'Nagano'),
			('JP', '21', 'Gihu [Gifu]'),
			('JP', '22', 'Sizuoka [Shizuoka]'),
			('JP', '23', 'Aiti [Aichi]'),
			('JP', '24', 'Mie'),
			('JP', '25', 'Siga [Shiga]'),
			('JP', '26', 'Kyôto [Kyoto]'),
			('JP', '27', 'Ôsaka [Osaka]'),
			('JP', '28', 'Hyôgo [Hyogo]'),
			('JP', '29', 'Nara'),
			('JP', '30', 'Wakayama'),
			('JP', '31', 'Tottori'),
			('JP', '32', 'Simane [Shimane]'),
			('JP', '33', 'Okayama'),
			('JP', '34', 'Hirosima [Hiroshima]'),
			('JP', '35', 'Yamaguti [Yamaguchi]'),
			('JP', '36', 'Tokusima [Tokushima]'),
			('JP', '37', 'Kagawa'),
			('JP', '38', 'Ehime'),
			('JP', '39', 'Kôti [Kochi]'),
			('JP', '40', 'Hukuoka [Fukuoka]'),
			('JP', '41', 'Saga'),
			('JP', '42', 'Nagasaki'),
			('JP', '43', 'Kumamoto'),
			('JP', '44', 'Ôita [Oita]'),
			('JP', '45', 'Miyazaki'),
			('JP', '46', 'Kagosima [Kagoshima]'),
			('JP', '47', 'Okinawa'),
			('KE', '110', 'Nairobi'),
			('KE', '200', 'Central'),
			('KE', '300', 'Coast'),
			('KE', '400', 'Eastern'),
			('KE', '500', 'North-Eastern'),
			('KE', '600', 'Nyanza'),
			('KE', '700', 'Rift Valley'),
			('KE', '800', 'Western'),
			('KG', 'B', 'Batken'),
			('KG', 'C', 'Chü'),
			('KG', 'GB', 'Bishkek'),
			('KG', 'J', 'Jalal-Abad'),
			('KG', 'N', 'Naryn'),
			('KG', 'O', 'Osh'),
			('KG', 'T', 'Talas'),
			('KG', 'Y', 'Ysyk-Köl'),
			('KH', '1', 'Banteay Mean Chey [Bântéay Méanchey]'),
			('KH', '10', 'Kracheh [Krâchéh]'),
			('KH', '11', 'Mondol Kiri [Môndól Kiri]'),
			('KH', '12', 'Phnom Penh [Phnum Pénh]'),
			('KH', '13', 'Preah Vihear [Preah Vihéar]'),
			('KH', '14', 'Prey Veaeng [Prey Vêng]'),
			('KH', '15', 'Pousaat [Pouthisat]'),
			('KH', '16', 'Rotanak Kiri [Rôtânôkiri]'),
			('KH', '17', 'Siem Reab [Siemréab]'),
			('KH', '18', 'Krong Preah Sihanouk [Krong Preah Sihanouk]'),
			('KH', '19', 'Stueng Traeng [Stœ?ng Trêng]'),
			('KH', '2', 'Baat Dambang [Batdâmbâng]'),
			('KH', '20', 'Svaay Rieng [Svay Rieng]'),
			('KH', '21', 'Taakaev [Takêv]'),
			('KH', '22', 'Otdar Mean Chey [Otdâr Méanchey]'),
			('KH', '23', 'Krong Kaeb [Krong Kêb]'),
			('KH', '24', 'Krong Pailin [Krong Pailin]'),
			('KH', '3', 'Kampong Chaam [Kâmpóng Cham]'),
			('KH', '4', 'Kampong Chhnang [Kâmpóng Chhnang]'),
			('KH', '5', 'Kampong Spueu [Kâmpóng Spœ]'),
			('KH', '6', 'Kampong Thum [Kâmpóng Thum]'),
			('KH', '7', 'Kampot [Kâmpôt]'),
			('KH', '8', 'Kandaal [Kândal]'),
			('KH', '9', 'Kaoh Kong [Kaôh Kong]'),
			('KI', 'G', 'Gilbert Islands'),
			('KI', 'L', 'Line Islands'),
			('KI', 'P', 'Phoenix Islands'),
			('KM', 'A', 'Andjouân'),
			('KM', 'G', 'Andjazîdja'),
			('KM', 'M', 'Moûhîlî'),
			('KN', '01', 'Christ Church Nichola Town'),
			('KN', '02', 'Saint Anne Sandy Point'),
			('KN', '03', 'Saint George Basseterre'),
			('KN', '04', 'Saint George Gingerland'),
			('KN', '05', 'Saint James Windward'),
			('KN', '06', 'Saint John Capisterre'),
			('KN', '07', 'Saint John Figtree'),
			('KN', '08', 'Saint Mary Cayon'),
			('KN', '09', 'Saint Paul Capisterre'),
			('KN', '10', 'Saint Paul Charlestown'),
			('KN', '11', 'Saint Peter Basseterre'),
			('KN', '12', 'Saint Thomas Lowland'),
			('KN', '13', 'Saint Thomas Middle Island'),
			('KN', '15', 'Trinity Palmetto Point'),
			('KN', 'K', 'Saint Kitts'),
			('KN', 'N', 'Nevis'),
			('KP', '01', 'Pyongyang'),
			('KP', '02', 'Pyongan-namdo'),
			('KP', '03', 'Pyongan-bukdo'),
			('KP', '04', 'Chagang-do'),
			('KP', '05', 'Hwanghae-namdo'),
			('KP', '06', 'Hwanghae-bukto'),
			('KP', '07', 'Kangwon-do'),
			('KP', '08', 'Hamgyong-namdo'),
			('KP', '09', 'Hamgyong-bukdo'),
			('KP', '10', 'Yanggang-do'),
			('KP', '13', 'Nason'),
			('KR', '11', 'Seoul Teugbyeolsi [Seoul-T''ukpyolshi]'),
			('KR', '26', 'Busan Gwang''yeogsi [Pusan-Kwangyokshi]'),
			('KR', '27', 'Daegu Gwang''yeogsi [Taegu-Kwangyokshi]'),
			('KR', '28', 'Incheon Gwang''yeogsi [Inch''n-Kwangyokshi]'),
			('KR', '29', 'Gwangju Gwang''yeogsi [Kwangju-Kwangyokshi]'),
			('KR', '30', 'Daejeon Gwang''yeogsi [Taejon-Kwangyokshi]'),
			('KR', '31', 'Ulsan Gwang''yeogsi [Ulsan-Kwangyokshi]'),
			('KR', '41', 'Gyeonggido [Kyonggi-do]'),
			('KR', '42', 'Gang''weondo [Kang-won-do]'),
			('KR', '43', 'Chungcheongbugdo [Ch''ungch''ongbuk-do]'),
			('KR', '44', 'Chungcheongnamdo [Ch''ungch''ongnam-do]'),
			('KR', '45', 'Jeonrabugdo[Chollabuk-do]'),
			('KR', '46', 'Jeonranamdo [Chollanam-do]'),
			('KR', '47', 'Gyeongsangbugdo [Kyongsangbuk-do]'),
			('KR', '48', 'Gyeongsangnamdo [Kyongsangnam-do]'),
			('KR', '49', 'Jejudo [Cheju-do]'),
			('KW', 'AH', 'Al Ahmadi'),
			('KW', 'FA', 'Al Farwaniyah'),
			('KW', 'HA', 'Hawalli'),
			('KW', 'JA', 'Al Jahrah'),
			('KW', 'KU', 'Al Kuwayt'),
			('KW', 'MU', 'Mubarak al-Kabir'),
			('KY', '01~', 'Bodden Town'),
			('KY', '02~', 'Cayman Brac'),
			('KY', '03~', 'East End'),
			('KY', '04~', 'George Town'),
			('KY', '06~', 'North Side'),
			('KY', '07~', 'West Bay'),
			('KY', 'Ky-', 'Little Cayman'),
			('KZ', 'AKM', 'Aqmola oblysy'),
			('KZ', 'AKT', 'Aqtöbe oblysy'),
			('KZ', 'ALA', 'Almaty'),
			('KZ', 'ALM', 'Almaty oblysy'),
			('KZ', 'AST', 'Astana'),
			('KZ', 'ATY', 'Atyrau oblysy'),
			('KZ', 'BAY', 'Bayqongyr'),
			('KZ', 'KAR', 'Qaraghandy oblysy'),
			('KZ', 'KUS', 'Qostanay oblysy'),
			('KZ', 'KZY', 'Qyzylorda oblysy'),
			('KZ', 'MAN', 'Mangghystau oblysy'),
			('KZ', 'PAV', 'Pavlodar oblysy'),
			('KZ', 'SEV', 'Soltüstik Qazaqstan oblysy'),
			('KZ', 'VOS', 'Shyghys Qazaqstan oblysy'),
			('KZ', 'YUZ', 'Ongtüstik Qazaqstan oblysy'),
			('KZ', 'ZAP', 'Batys Qazaqstan oblysy'),
			('KZ', 'ZHA', 'Zhambyl oblysy'),
			('LA', 'AT', 'Attapu [Attopeu]'),
			('LA', 'BK', 'Bokèo'),
			('LA', 'BL', 'Bolikhamxai [Borikhane]'),
			('LA', 'CH', 'Champasak [Champassak]'),
			('LA', 'HO', 'Houaphan'),
			('LA', 'KH', 'Khammouan'),
			('LA', 'LM', 'Louang Namtha'),
			('LA', 'LP', 'Louangphabang [Louang Prabang]'),
			('LA', 'OU', 'Oudômxai [Oudomsai]'),
			('LA', 'PH', 'Phôngsali [Phong Saly]'),
			('LA', 'SL', 'Salavan [Saravane]'),
			('LA', 'SV', 'Savannakhét'),
			('LA', 'VI', 'Vientiane'),
			('LA', 'VT', 'Vientiane Prefecture'),
			('LA', 'XA', 'Xaignabouli [Sayaboury]'),
			('LA', 'XE', 'Xékong [Sékong]'),
			('LA', 'XI', 'Xiangkhoang [Xieng Khouang]'),
			('LA', 'XN', 'Xaisômboun'),
			('LB', 'AK', 'Aakkar'),
			('LB', 'AS', 'Loubnâne ech Chemâli'),
			('LB', 'BA', 'Beirut'),
			('LB', 'BH', 'Baalbek-Hermel'),
			('LB', 'BI', 'El Béqaa'),
			('LB', 'JA', 'Loubnâne ej Jnoûbi'),
			('LB', 'JL', 'Jabal Loubnâne'),
			('LB', 'NA', 'Nabatîyé'),
			('LC', '01', 'Anse-la-Raye'),
			('LC', '02', 'Castries'),
			('LC', '03', 'Choiseul'),
			('LC', '04', 'Dauphin'),
			('LC', '05', 'Dennery'),
			('LC', '06', 'Gros Inlet'),
			('LC', '07', 'Laborie'),
			('LC', '08', 'Micoud'),
			('LC', '09', 'Praslin'),
			('LC', '10', 'Soufrière'),
			('LC', '11', 'Vieux Fort'),
			('LI', '01', 'Balzers'),
			('LI', '02', 'Eschen'),
			('LI', '03', 'Gamprin'),
			('LI', '04', 'Mauren'),
			('LI', '05', 'Planken'),
			('LI', '06', 'Ruggell'),
			('LI', '07', 'Schaan'),
			('LI', '08', 'Schellenberg'),
			('LI', '09', 'Triesen'),
			('LI', '10', 'Triesenberg'),
			('LI', '11', 'Vaduz'),
			('LK', '1', 'Basnāhira paḷāta'),
			('LK', '11', 'Kŏḷamba'),
			('LK', '12', 'Gampaha'),
			('LK', '13', 'Kalutara'),
			('LK', '2', 'Madhyama paḷāta'),
			('LK', '21', 'Mahanuvara'),
			('LK', '22', 'Mātale'),
			('LK', '23', 'Nuvara Ĕliya'),
			('LK', '3', 'Dakuṇu paḷāta'),
			('LK', '31', 'Gālla'),
			('LK', '32', 'Mātara'),
			('LK', '33', 'Hambantŏṭa'),
			('LK', '4', 'Uturu paḷāta'),
			('LK', '41', 'Yāpanaya'),
			('LK', '42', 'Kilinŏchchi'),
			('LK', '43', 'Mannārama'),
			('LK', '44', 'Vavuniyāva'),
			('LK', '45', 'Mulativ'),
			('LK', '5', 'Mattiya mākāṇam'),
			('LK', '51', 'Madakalapuva'),
			('LK', '52', 'Ampāra'),
			('LK', '53', 'Trikuṇāmalaya'),
			('LK', '6', 'Vayamba paḷāta'),
			('LK', '61', 'Kuruṇægala'),
			('LK', '62', 'Puttalama'),
			('LK', '7', 'Uturumæ̆da paḷāta'),
			('LK', '71', 'Anurādhapura'),
			('LK', '72', 'Pŏḷŏnnaruva'),
			('LK', '8', 'Ūva paḷāta'),
			('LK', '81', 'Badulla'),
			('LK', '82', 'Mŏṇarāgala'),
			('LK', '9', 'Sabaragamuva paḷāta'),
			('LK', '91', 'Ratnapura'),
			('LK', '92', 'Kegalla'),
			('LR', 'BG', 'Bong'),
			('LR', 'BM', 'Bomi'),
			('LR', 'CM', 'Grand Cape Mount'),
			('LR', 'GB', 'Grand Bassa'),
			('LR', 'GG', 'Grand Gedeh'),
			('LR', 'GK', 'Grand Kru'),
			('LR', 'LO', 'Lofa'),
			('LR', 'MG', 'Margibi'),
			('LR', 'MO', 'Montserrado'),
			('LR', 'MY', 'Maryland'),
			('LR', 'NI', 'Nimba'),
			('LR', 'RI', 'Rivercess'),
			('LR', 'SI', 'Sinoe'),
			('LR', 'X1~', 'Gbarpolu'),
			('LR', 'X2~', 'River Gee'),
			('LS', 'A', 'Maseru'),
			('LS', 'B', 'Butha-Buthe'),
			('LS', 'C', 'Leribe'),
			('LS', 'D', 'Berea'),
			('LS', 'E', 'Mafeteng'),
			('LS', 'F', 'Mohale''s Hoek'),
			('LS', 'G', 'Quthing'),
			('LS', 'H', 'Qacha''s Nek'),
			('LS', 'J', 'Mokhotlong'),
			('LS', 'K', 'Thaba-Tseka'),
			('LT', 'AL', 'Alytaus Apskritis'),
			('LT', 'KL', 'Klaipedos Apskritis'),
			('LT', 'KU', 'Kauno Apskritis'),
			('LT', 'MR', 'Marijampoles Apskritis'),
			('LT', 'PN', 'Panevežio Apskritis'),
			('LT', 'SA', 'Šiauliu Apskritis'),
			('LT', 'TA', 'Taurages Apskritis'),
			('LT', 'TE', 'Telšiu Apskritis'),
			('LT', 'UT', 'Utenos Apskritis'),
			('LT', 'VL', 'Vilniaus Apskritis'),
			('LU', 'D', 'Diekirch'),
			('LU', 'G', 'Grevenmacher'),
			('LU', 'L', 'Luxembourg'),
			('LV', '001', 'Aglonas novads'),
			('LV', '002', 'Aizkraukles novads'),
			('LV', '003', 'Aizputes novads'),
			('LV', '004', 'Aknīstes novads'),
			('LV', '005', 'Alojas novads'),
			('LV', '006', 'Alsungas novads'),
			('LV', '007', 'Alūksnes novads'),
			('LV', '008', 'Amatas novads'),
			('LV', '009', 'Apes novads'),
			('LV', '010', 'Auces novads'),
			('LV', '011', 'Ādažu novads'),
			('LV', '012', 'Babītes novads'),
			('LV', '013', 'Baldones novads'),
			('LV', '014', 'Baltinavas novads'),
			('LV', '015', 'Balvu novads'),
			('LV', '016', 'Bauskas novads'),
			('LV', '017', 'Beverīnas novads'),
			('LV', '018', 'Brocēnu novads'),
			('LV', '019', 'Burtnieku novads'),
			('LV', '020', 'Carnikavas novads'),
			('LV', '021', 'Cesvaines novads'),
			('LV', '022', 'Cēsu novads'),
			('LV', '023', 'Ciblas novads'),
			('LV', '024', 'Dagdas novads'),
			('LV', '025', 'Daugavpils novads'),
			('LV', '026', 'Dobeles novads'),
			('LV', '027', 'Dundagas novads'),
			('LV', '028', 'Durbes novads'),
			('LV', '029', 'Engures novads'),
			('LV', '030', 'Ērgļu novads'),
			('LV', '031', 'Garkalnes novads'),
			('LV', '032', 'Grobiņas novads'),
			('LV', '033', 'Gulbenes novads'),
			('LV', '034', 'Iecavas novads'),
			('LV', '035', 'Ikšķiles novads'),
			('LV', '036', 'Ilūkstes novads'),
			('LV', '037', 'Inčukalna novads'),
			('LV', '038', 'Jaunjelgavas novads'),
			('LV', '039', 'Jaunpiebalgas novads'),
			('LV', '040', 'Jaunpils novads'),
			('LV', '041', 'Jelgavas novads'),
			('LV', '042', 'Jēkabpils novads'),
			('LV', '043', 'Kandavas novads'),
			('LV', '044', 'Kārsavas novads'),
			('LV', '045', 'Kocēnu novads'),
			('LV', '046', 'Kokneses novads'),
			('LV', '047', 'Krāslavas novads'),
			('LV', '048', 'Krimuldas novads'),
			('LV', '049', 'Krustpils novads'),
			('LV', '050', 'Kuldīgas novads'),
			('LV', '051', 'Ķeguma novads'),
			('LV', '052', 'Ķekavas novads'),
			('LV', '053', 'Lielvārdes novads'),
			('LV', '054', 'Limbažu novads'),
			('LV', '055', 'Līgatnes novads'),
			('LV', '056', 'Līvānu novads'),
			('LV', '057', 'Lubānas novads'),
			('LV', '058', 'Ludzas novads'),
			('LV', '059', 'Madonas novads'),
			('LV', '060', 'Mazsalacas novads'),
			('LV', '061', 'Mālpils novads'),
			('LV', '062', 'Mārupes novads'),
			('LV', '063', 'Mērsraga novads'),
			('LV', '064', 'Naukšēnu novads'),
			('LV', '065', 'Neretas novads'),
			('LV', '066', 'Nīcas novads'),
			('LV', '067', 'Ogres novads'),
			('LV', '068', 'Olaines novads'),
			('LV', '069', 'Ozolnieku novads'),
			('LV', '070', 'Pārgaujas novads'),
			('LV', '071', 'Pāvilostas novads'),
			('LV', '072', 'Pļaviņu novads'),
			('LV', '073', 'Preiļu novads'),
			('LV', '074', 'Priekules novads'),
			('LV', '075', 'Priekuļu novads'),
			('LV', '076', 'Raunas novads'),
			('LV', '077', 'Rēzeknes novads'),
			('LV', '078', 'Riebiņu novads'),
			('LV', '079', 'Rojas novads'),
			('LV', '080', 'Ropažu novads'),
			('LV', '081', 'Rucavas novads'),
			('LV', '082', 'Rugāju novads'),
			('LV', '083', 'Rundāles novads'),
			('LV', '084', 'Rūjienas novads'),
			('LV', '085', 'Salas novads'),
			('LV', '086', 'Salacgrīvas novads'),
			('LV', '087', 'Salaspils novads'),
			('LV', '088', 'Saldus novads'),
			('LV', '089', 'Saulkrastu novads'),
			('LV', '090', 'Sējas novads'),
			('LV', '091', 'Siguldas novads'),
			('LV', '092', 'Skrīveru novads'),
			('LV', '093', 'Skrundas novads'),
			('LV', '094', 'Smiltenes novads'),
			('LV', '095', 'Stopiņu novads'),
			('LV', '096', 'Strenču novads'),
			('LV', '097', 'Talsu novads'),
			('LV', '098', 'Tērvetes novads'),
			('LV', '099', 'Tukuma novads'),
			('LV', '100', 'Vaiņodes novads'),
			('LV', '101', 'Valkas novads'),
			('LV', '102', 'Varakļānu novads'),
			('LV', '103', 'Vārkavas novads'),
			('LV', '104', 'Vecpiebalgas novads'),
			('LV', '105', 'Vecumnieku novads'),
			('LV', '106', 'Ventspils novads'),
			('LV', '107', 'Viesītes novads'),
			('LV', '108', 'Viļakas novads'),
			('LV', '109', 'Viļānu novads'),
			('LV', '110', 'Zilupes novads'),
			('LV', 'DGV', 'Daugavpils'),
			('LV', 'JEL', 'Jelgava'),
			('LV', 'JKB', 'Jēkabpils'),
			('LV', 'JUR', 'Jurmala'),
			('LV', 'LPX', 'Liepaja'),
			('LV', 'REZ', 'Rezekne'),
			('LV', 'RIX', 'Riga'),
			('LV', 'VEN', 'Ventspils'),
			('LV', 'VMR', 'Valmiera'),
			('LY', 'BA', 'Banghazi'),
			('LY', 'BU', 'Al Butnan'),
			('LY', 'DR', 'Darnah'),
			('LY', 'GT', 'Ghat'),
			('LY', 'JA', 'Al Jabal al Akh?ar'),
			('LY', 'JG', 'Al Jabal al Gharbī'),
			('LY', 'JI', 'Al Jifarah'),
			('LY', 'JU', 'Al Jufrah'),
			('LY', 'KF', 'Al Kufrah'),
			('LY', 'MB', 'Al Marqab'),
			('LY', 'MI', 'Misratah'),
			('LY', 'MJ', 'Al Marj'),
			('LY', 'MQ', 'Murzuq'),
			('LY', 'NL', 'Nalut'),
			('LY', 'NQ', 'An Nuqat al Khams'),
			('LY', 'SB', 'Sabha'),
			('LY', 'SR', 'Surt'),
			('LY', 'TB', 'Tarabulus'),
			('LY', 'WA', 'Al Wāḩāt'),
			('LY', 'WD', 'Wadi al ?ayat'),
			('LY', 'WS', 'Wādī ash Shāţiʾ'),
			('LY', 'ZA', 'Az Zawiyah'),
			('MA', '01', 'Tanger-Tetouan'),
			('MA', '02', 'Gharb-Chrarda-Beni Hssen'),
			('MA', '03', 'Taza-Al Hoceima-Taounate'),
			('MA', '04', 'L''Oriental'),
			('MA', '05', 'Fes-Boulemane'),
			('MA', '06', 'Meknes-Tafilalet'),
			('MA', '07', 'Rabat-Salé-Zemmour-Zaer'),
			('MA', '08', 'Grand Casablanca'),
			('MA', '09', 'Chaouia-Ouardigh'),
			('MA', '10', 'Doukkala-Abda'),
			('MA', '11', 'Marrakech-Tensift-Al Haouz'),
			('MA', '12', 'Tadla-Azilal'),
			('MA', '13', 'Souss-Massa-Draa'),
			('MA', '14', 'Guelmim-Es Smar'),
			('MA', '15', 'Laayoune-Boujdour-Sakia El Hamra'),
			('MA', '16', 'Oued ed Dahab-Lagouira'),
			('MA', 'AGD', 'Agadir-Ida-Outanane'),
			('MA', 'AOU', 'Aousserd'),
			('MA', 'ASZ', 'Assa-Zag'),
			('MA', 'AZI', 'Azilal'),
			('MA', 'BEM', 'Beni Mellal'),
			('MA', 'BER', 'Berkane'),
			('MA', 'BES', 'Ben Slimane'),
			('MA', 'BOD', 'Boujdour'),
			('MA', 'BOM', 'Boulemane'),
			('MA', 'CAS', 'Casablanca [Dar el Beïda]*'),
			('MA', 'CHE', 'Chefchaouen'),
			('MA', 'CHI', 'Chichaoua'),
			('MA', 'CHT', 'Chtouka-Ait Baha'),
			('MA', 'ERR', 'Errachidia'),
			('MA', 'ESI', 'Essaouira'),
			('MA', 'ESM', 'Es Smara'),
			('MA', 'FAH', 'Fahs-Beni Makada'),
			('MA', 'FES', 'Fès-Dar-Dbibegh'),
			('MA', 'FIG', 'Figuig'),
			('MA', 'GUE', 'Guelmim'),
			('MA', 'HAJ', 'El Hajeb'),
			('MA', 'HAO', 'Al Haouz'),
			('MA', 'HOC', 'Al Hoceïma'),
			('MA', 'IFR', 'Ifrane'),
			('MA', 'INE', 'Inezgane-Ait Melloul'),
			('MA', 'JDI', 'El Jadida'),
			('MA', 'JRA', 'Jrada'),
			('MA', 'KEN', 'Kénitra'),
			('MA', 'KES', 'Kelaat es Sraghna'),
			('MA', 'KHE', 'Khemisset'),
			('MA', 'KHN', 'Khenifra'),
			('MA', 'KHO', 'Khouribga'),
			('MA', 'LAA', 'Laâyoune*'),
			('MA', 'LAR', 'Larache'),
			('MA', 'MED', 'Mediouna'),
			('MA', 'MEK', 'Meknès'),
			('MA', 'MMD', 'Marrakech-Medina'),
			('MA', 'MMN', 'Marrakech-Menara'),
			('MA', 'MOH', 'Mohammadia'),
			('MA', 'MOU', 'Moulay Yacoub'),
			('MA', 'NAD', 'Nador'),
			('MA', 'NOU', 'Nouaceur'),
			('MA', 'OUA', 'Ouarzazate'),
			('MA', 'OUD', 'Oued ed Dahab'),
			('MA', 'OUJ', 'Oujda*'),
			('MA', 'RAB', 'Rabat'),
			('MA', 'SAF', 'Safi'),
			('MA', 'SAL', 'Connaught Salé'),
			('MA', 'SEF', 'Sefrou'),
			('MA', 'SET', 'Settat'),
			('MA', 'SIK', 'Sidi Kacem'),
			('MA', 'SKH', 'Skhirate-Témara'),
			('MA', 'SYB', 'Sidi Youssef Ben Ali'),
			('MA', 'TAI', 'Taourirt'),
			('MA', 'TAO', 'Taounate'),
			('MA', 'TAR', 'Taroudant'),
			('MA', 'TAT', 'Tata'),
			('MA', 'TAZ', 'Taza'),
			('MA', 'TIZ', 'Tiznit'),
			('MA', 'TNG', 'Tanger-Assilah'),
			('MA', 'TNT', 'Tan-Tan'),
			('MA', 'ZAG', 'Zagora'),
			('MC', 'CL', 'La Colle'),
			('MC', 'CO', 'La Condamine'),
			('MC', 'FO', 'Fontvieille'),
			('MC', 'GA', 'La Gare'),
			('MC', 'JE', 'Jardin Exotique'),
			('MC', 'LA', 'Larvotto'),
			('MC', 'MA', 'Malbousquet'),
			('MC', 'MC', 'Monte-Carlo'),
			('MC', 'MG', 'Moneghetti'),
			('MC', 'MO', 'Monaco-Ville'),
			('MC', 'MU', 'Moulins'),
			('MC', 'PH', 'Port-Hercule'),
			('MC', 'SD', 'Sainte-Dévote'),
			('MC', 'SO', 'La Source'),
			('MC', 'SP', 'Spélugues'),
			('MC', 'SR', 'Saint-Roman'),
			('MC', 'VR', 'Vallon de la Rousse'),
			('MD', 'AN', 'Anenii Noi'),
			('MD', 'BA', 'Bălţi'),
			('MD', 'BD', 'Tighina'),
			('MD', 'BR', 'Briceni'),
			('MD', 'BS', 'Basarabeasca'),
			('MD', 'CA', 'Cahul'),
			('MD', 'CL', 'Călăraşi'),
			('MD', 'CM', 'Cimişlia'),
			('MD', 'CR', 'Criuleni'),
			('MD', 'CS', 'Căuşeni'),
			('MD', 'CT', 'Cantemir'),
			('MD', 'CU', 'Chisinau'),
			('MD', 'DO', 'Donduşeni'),
			('MD', 'DR', 'Drochia'),
			('MD', 'DU', 'Dubăsari'),
			('MD', 'ED', 'Edinet'),
			('MD', 'FA', 'Făleşti'),
			('MD', 'FL', 'Floreşti'),
			('MD', 'GA', 'Gagauzia, Unitatea teritoriala autonoma'),
			('MD', 'GL', 'Glodeni'),
			('MD', 'HI', 'Hînceşti'),
			('MD', 'IA', 'Ialoveni'),
			('MD', 'LE', 'Leova'),
			('MD', 'NI', 'Nisporeni'),
			('MD', 'OC', 'Ocniţa'),
			('MD', 'OR', 'Orhei'),
			('MD', 'RE', 'Rezina'),
			('MD', 'RI', 'Rîşcani'),
			('MD', 'SD', 'Şoldăneşti'),
			('MD', 'SI', 'Sîngerei'),
			('MD', 'SN', 'Stînga Nistrului, unitatea teritoriala din'),
			('MD', 'SO', 'Soroca'),
			('MD', 'ST', 'Străşeni'),
			('MD', 'SV', 'Ştefan Vodă'),
			('MD', 'TA', 'Taraclia'),
			('MD', 'TE', 'Teleneşti'),
			('MD', 'UN', 'Ungheni'),
			('ME', '01', 'Andrijevica'),
			('ME', '02', 'Bar'),
			('ME', '03', 'Berane'),
			('ME', '04', 'Bijelo Polje'),
			('ME', '05', 'Budva'),
			('ME', '06', 'Cetinje'),
			('ME', '07', 'Danilovgrad'),
			('ME', '08', 'Herceg-Novi'),
			('ME', '09', 'Kolašin'),
			('ME', '10', 'Kotor'),
			('ME', '11', 'Mojkovac'),
			('ME', '12', 'Nikšic´'),
			('ME', '13', 'Plav'),
			('ME', '14', 'Pljevlja'),
			('ME', '15', 'Plužine'),
			('ME', '16', 'Podgorica'),
			('ME', '17', 'Rožaje'),
			('ME', '18', 'Šavnik'),
			('ME', '19', 'Tivat'),
			('ME', '20', 'Ulcinj'),
			('ME', '21', 'Žabljak'),
			('MG', 'A', 'Toamasina'),
			('MG', 'D', 'Antsiranana'),
			('MG', 'F', 'Fianarantsoa'),
			('MG', 'M', 'Mahajanga'),
			('MG', 'T', 'Antananarivo'),
			('MG', 'U', 'Toliara'),
			('MH', 'ALK', 'Ailuk'),
			('MH', 'ALL', 'Ailinglaplap'),
			('MH', 'ARN', 'Arno'),
			('MH', 'AUR', 'Aur'),
			('MH', 'EBO', 'Ebon'),
			('MH', 'ENI', 'Enewetak'),
			('MH', 'JAB', 'Jabat'),
			('MH', 'JAL', 'Jaluit'),
			('MH', 'KIL', 'Kili'),
			('MH', 'KWA', 'Kwajalein'),
			('MH', 'L', 'Ralik chain'),
			('MH', 'LAE', 'Lae'),
			('MH', 'LIB', 'Lib'),
			('MH', 'LIK', 'Likiep'),
			('MH', 'MAJ', 'Majuro'),
			('MH', 'MAL', 'Maloelap'),
			('MH', 'MEJ', 'Mejit'),
			('MH', 'MIL', 'Mili'),
			('MH', 'NMK', 'Namdrik'),
			('MH', 'NMU', 'Namu'),
			('MH', 'RON', 'Rongelap'),
			('MH', 'T', 'Ratak chain'),
			('MH', 'UJA', 'Ujae'),
			('MH', 'UTI', 'Utirik'),
			('MH', 'WTH', 'Wotho'),
			('MH', 'WTJ', 'Wotje'),
			('MK', '01', 'Aerodrom'),
			('MK', '02', 'Aračinovo'),
			('MK', '03', 'Berovo'),
			('MK', '04', 'Bitola'),
			('MK', '05', 'Bogdanci'),
			('MK', '06', 'Bogovinje'),
			('MK', '07', 'Bosilovo'),
			('MK', '08', 'Brvenica'),
			('MK', '09', 'Butel'),
			('MK', '10', 'Valandovo'),
			('MK', '11', 'Vasilevo'),
			('MK', '12', 'Vevčani'),
			('MK', '13', 'Veles'),
			('MK', '14', 'Vinica'),
			('MK', '15', 'Vraneštica'),
			('MK', '16', 'Vrapčište'),
			('MK', '17', 'Gazi Baba'),
			('MK', '18', 'Gevgelija'),
			('MK', '19', 'Gostivar'),
			('MK', '20', 'Gradsko'),
			('MK', '21', 'Debar'),
			('MK', '22', 'Debarca'),
			('MK', '23', 'Delčevo'),
			('MK', '24', 'Demir Kapija'),
			('MK', '25', 'Demir Hisar'),
			('MK', '26', 'Dojran'),
			('MK', '27', 'Dolneni'),
			('MK', '28', 'Drugovo'),
			('MK', '29', 'Gjorče Petrov'),
			('MK', '30', 'Želino'),
			('MK', '31', 'Zajas'),
			('MK', '32', 'Zelenikovo'),
			('MK', '33', 'Zrnovci'),
			('MK', '34', 'Ilinden'),
			('MK', '35', 'Jegunovce'),
			('MK', '36', 'Kavadarci'),
			('MK', '37', 'Karbinci'),
			('MK', '38', 'Karpoš'),
			('MK', '39', 'Kisela Voda'),
			('MK', '40', 'Kičevo'),
			('MK', '41', 'Konče'),
			('MK', '42', 'Kočani'),
			('MK', '43', 'Kratovo'),
			('MK', '44', 'Kriva Palanka'),
			('MK', '45', 'Krivogaštani'),
			('MK', '46', 'Kruševo'),
			('MK', '47', 'Kumanovo'),
			('MK', '48', 'Lipkovo'),
			('MK', '49', 'Lozovo'),
			('MK', '50', 'Mavrovo i Rostuša'),
			('MK', '51', 'Makedonska Kamenica'),
			('MK', '52', 'Makedonski Brod'),
			('MK', '53', 'Mogila'),
			('MK', '54', 'Negotino'),
			('MK', '55', 'Novaci'),
			('MK', '56', 'Novo Selo'),
			('MK', '57', 'Oslomej'),
			('MK', '58', 'Ohrid'),
			('MK', '59', 'Petrovec'),
			('MK', '60', 'Pehčevo'),
			('MK', '61', 'Plasnica'),
			('MK', '62', 'Prilep'),
			('MK', '63', 'Probištip'),
			('MK', '64', 'Radoviš'),
			('MK', '65', 'Rankovce'),
			('MK', '66', 'Resen'),
			('MK', '67', 'Rosoman'),
			('MK', '68', 'Saraj'),
			('MK', '69', 'Sveti Nikole'),
			('MK', '70', 'Sopište'),
			('MK', '71', 'Staro Nagoričane'),
			('MK', '72', 'Struga'),
			('MK', '73', 'Strumica'),
			('MK', '74', 'Studeničani'),
			('MK', '75', 'Tearce'),
			('MK', '76', 'Tetovo'),
			('MK', '77', 'Centar'),
			('MK', '78', 'Centar Župa'),
			('MK', '79', 'Čair'),
			('MK', '80', 'Čaška'),
			('MK', '81', 'Češinovo-Obleševo'),
			('MK', '82', 'Čučer Sandevo'),
			('MK', '83', 'Štip'),
			('MK', '84', 'Šuto Orizari'),
			('ML', '1', 'Kayes'),
			('ML', '2', 'Koulikoro'),
			('ML', '3', 'Sikasso'),
			('ML', '4', 'Ségou'),
			('ML', '5', 'Mopti'),
			('ML', '6', 'Tombouctou'),
			('ML', '7', 'Gao'),
			('ML', '8', 'Kidal'),
			('ML', 'BKO', 'Bamako'),
			('MM', '01', 'Sagaing'),
			('MM', '02', 'Bago'),
			('MM', '03', 'Magway'),
			('MM', '04', 'Mandalay'),
			('MM', '05', 'Tanintharyi'),
			('MM', '06', 'Yangon'),
			('MM', '07', 'Ayeyarwady'),
			('MM', '11', 'Kachin'),
			('MM', '12', 'Kayah'),
			('MM', '13', 'Kayin'),
			('MM', '14', 'Chin'),
			('MM', '15', 'Mon'),
			('MM', '16', 'Rakhine'),
			('MM', '17', 'Shan'),
			('MN', '035', 'Orhon'),
			('MN', '037', 'Darhan uul'),
			('MN', '039', 'Hentiy'),
			('MN', '041', 'Hövsgöl'),
			('MN', '043', 'Hovd'),
			('MN', '046', 'Uvs'),
			('MN', '047', 'Töv'),
			('MN', '049', 'Selenge'),
			('MN', '051', 'Sühbaatar'),
			('MN', '053', 'Ömnögovi'),
			('MN', '055', 'Övörhangay'),
			('MN', '057', 'Dzavhan'),
			('MN', '059', 'Dundgovi'),
			('MN', '061', 'Dornod'),
			('MN', '063', 'Dornogovi'),
			('MN', '064', 'Govi-Sümber'),
			('MN', '065', 'Govi-Altay'),
			('MN', '067', 'Bulgan'),
			('MN', '069', 'Bayanhongor'),
			('MN', '071', 'Bayan-Ölgiy'),
			('MN', '073', 'Arhangay'),
			('MN', '1', 'Ulaanbaatar'),
			('MO', 'I', 'Ilhas'),
			('MO', 'M', 'Macau'),
			('MR', '01', 'Hodh ech Chargui'),
			('MR', '02', 'Hodh el Gharbi'),
			('MR', '03', 'Assaba'),
			('MR', '04', 'Gorgol'),
			('MR', '05', 'Brakna'),
			('MR', '06', 'Trarza'),
			('MR', '07', 'Adrar'),
			('MR', '08', 'Dakhlet Nouâdhibou'),
			('MR', '09', 'Tagant'),
			('MR', '10', 'Guidimaka'),
			('MR', '11', 'Tiris Zemmour'),
			('MR', '12', 'Inchiri'),
			('MR', 'NKC', 'Nouakchott'),
			('MT', '01', 'Attard'),
			('MT', '02', 'Balzan'),
			('MT', '03', 'Birgu'),
			('MT', '04', 'Birkirkara'),
			('MT', '05', 'Birżebbuġa'),
			('MT', '06', 'Bormla'),
			('MT', '07', 'Dingli'),
			('MT', '08', 'Fgura'),
			('MT', '09', 'Floriana'),
			('MT', '10', 'Fontana'),
			('MT', '11', 'Gudja'),
			('MT', '12', 'Gżira'),
			('MT', '13', 'Għajnsielem'),
			('MT', '14', 'Għarb'),
			('MT', '15', 'Għargħur'),
			('MT', '16', 'Għasri'),
			('MT', '17', 'Għaxaq'),
			('MT', '18', 'Ħamrun'),
			('MT', '19', 'Iklin'),
			('MT', '20', 'Isla'),
			('MT', '21', 'Kalkara'),
			('MT', '22', 'Kerċem'),
			('MT', '23', 'Kirkop'),
			('MT', '24', 'Lija'),
			('MT', '25', 'Luqa'),
			('MT', '26', 'Marsa'),
			('MT', '27', 'Marsaskala'),
			('MT', '28', 'Marsaxlokk'),
			('MT', '29', 'Mdina'),
			('MT', '30', 'Mellieħa'),
			('MT', '31', 'Mġarr'),
			('MT', '32', 'Mosta'),
			('MT', '33', 'Mqabba'),
			('MT', '34', 'Msida'),
			('MT', '35', 'Mtarfa'),
			('MT', '36', 'Munxar'),
			('MT', '37', 'Nadur'),
			('MT', '38', 'Naxxar'),
			('MT', '39', 'Paola'),
			('MT', '40', 'Pembroke'),
			('MT', '41', 'Pietà'),
			('MT', '42', 'Qala'),
			('MT', '43', 'Qormi'),
			('MT', '44', 'Qrendi'),
			('MT', '45', 'Rabat Għawdex'),
			('MT', '46', 'Rabat Malta'),
			('MT', '47', 'Safi'),
			('MT', '48', 'San Ġiljan'),
			('MT', '49', 'San Ġwann'),
			('MT', '50', 'San Lawrenz'),
			('MT', '51', 'San Pawl il-Baħar'),
			('MT', '52', 'Sannat'),
			('MT', '53', 'Santa Luċija'),
			('MT', '54', 'Santa Venera'),
			('MT', '55', 'Siġġiewi'),
			('MT', '56', 'Sliema'),
			('MT', '57', 'Swieqi'),
			('MT', '58', 'Ta’ Xbiex'),
			('MT', '59', 'Tarxien'),
			('MT', '60', 'Valletta'),
			('MT', '61', 'Xagħra'),
			('MT', '62', 'Xewkija'),
			('MT', '63', 'Xgħajra'),
			('MT', '64', 'Żabbar'),
			('MT', '65', 'Żebbuġ Għawdex'),
			('MT', '66', 'Żebbuġ Malta'),
			('MT', '67', 'Żejtun'),
			('MT', '68', 'Żurrieq'),
			('MU', 'AG', 'Agalega Islands'),
			('MU', 'BL', 'Black River'),
			('MU', 'BR', 'Beau Bassin-Rose Hill'),
			('MU', 'CC', 'Cargados Carajos Shoals [Saint Brandon Islands]'),
			('MU', 'CU', 'Curepipe'),
			('MU', 'FL', 'Flacq'),
			('MU', 'GP', 'Grand Port'),
			('MU', 'MO', 'Moka'),
			('MU', 'PA', 'Pamplemousses'),
			('MU', 'PL', 'Port Louis City'),
			('MU', 'PU', 'Port Louis District'),
			('MU', 'PW', 'Plaines Wilhems'),
			('MU', 'QB', 'Quatre Bornes'),
			('MU', 'RO', 'Rodrigues Island'),
			('MU', 'RR', 'Rivière du Rempart'),
			('MU', 'SA', 'Savanne'),
			('MU', 'VP', 'Vacoas-Phoenix'),
			('MV', '00', 'Alif Dhaal'),
			('MV', '01', 'Seenu'),
			('MV', '02', 'Alif'),
			('MV', '03', 'Lhaviyani'),
			('MV', '04', 'Vaavu'),
			('MV', '05', 'Laamu'),
			('MV', '07', 'Haa Alif'),
			('MV', '08', 'Thaa'),
			('MV', '12', 'Meemu'),
			('MV', '13', 'Raa'),
			('MV', '14', 'Faafu'),
			('MV', '17', 'Dhaalu'),
			('MV', '20', 'Baa'),
			('MV', '23', 'Haa Dhaalu'),
			('MV', '24', 'Shaviyani'),
			('MV', '25', 'Noonu'),
			('MV', '26', 'Kaafu'),
			('MV', '27', 'Gaaf Alif'),
			('MV', '28', 'Gaafu Dhaalu'),
			('MV', '29', 'Gnaviyani'),
			('MV', 'CE', 'Central'),
			('MV', 'MLE', 'Male'),
			('MV', 'NC', 'North Central'),
			('MV', 'NO', 'North'),
			('MV', 'SC', 'South Central'),
			('MV', 'SU', 'South'),
			('MV', 'UN', 'Upper North'),
			('MV', 'US', 'Upper South'),
			('MW', 'BA', 'Balaka'),
			('MW', 'BL', 'Blantyre'),
			('MW', 'C', 'Central Region'),
			('MW', 'CK', 'Chikwawa'),
			('MW', 'CR', 'Chiradzulu'),
			('MW', 'CT', 'Chitipa'),
			('MW', 'DE', 'Dedza'),
			('MW', 'DO', 'Dowa'),
			('MW', 'KR', 'Karonga'),
			('MW', 'KS', 'Kasungu'),
			('MW', 'LI', 'Lilongwe'),
			('MW', 'LK', 'Likoma'),
			('MW', 'MC', 'Mchinji'),
			('MW', 'MG', 'Mangochi'),
			('MW', 'MH', 'Machinga'),
			('MW', 'MU', 'Mulanje'),
			('MW', 'MW', 'Mwanza'),
			('MW', 'MZ', 'Mzimba'),
			('MW', 'N', 'Northern Region'),
			('MW', 'NB', 'Nkhata Bay'),
			('MW', 'NE', 'Neno'),
			('MW', 'NI', 'Ntchisi'),
			('MW', 'NK', 'Nkhotakota'),
			('MW', 'NS', 'Nsanje'),
			('MW', 'NU', 'Ntcheu'),
			('MW', 'PH', 'Phalombe'),
			('MW', 'RU', 'Rumphi'),
			('MW', 'S', 'Southern Region'),
			('MW', 'SA', 'Salima'),
			('MW', 'TH', 'Thyolo'),
			('MW', 'ZO', 'Zomba'),
			('MX', 'AGU', 'Aguascalientes'),
			('MX', 'BCN', 'Baja California'),
			('MX', 'BCS', 'Baja California Sur'),
			('MX', 'CAM', 'Campeche'),
			('MX', 'CHH', 'Chihuahua'),
			('MX', 'CHP', 'Chiapas'),
			('MX', 'COA', 'Coahuila'),
			('MX', 'COL', 'Colima'),
			('MX', 'DIF', 'Distrito Federal'),
			('MX', 'DUR', 'Durango'),
			('MX', 'GRO', 'Guerrero'),
			('MX', 'GUA', 'Guanajuato'),
			('MX', 'HID', 'Hidalgo'),
			('MX', 'JAL', 'Jalisco'),
			('MX', 'MEX', 'México'),
			('MX', 'MIC', 'Michoacán'),
			('MX', 'MOR', 'Morelos'),
			('MX', 'NAY', 'Nayarit'),
			('MX', 'NLE', 'Nuevo León'),
			('MX', 'OAX', 'Oaxaca'),
			('MX', 'PUE', 'Puebla'),
			('MX', 'QUE', 'Querétaro'),
			('MX', 'ROO', 'Quintana Roo'),
			('MX', 'SIN', 'Sinaloa'),
			('MX', 'SLP', 'San Luis Potosí'),
			('MX', 'SON', 'Sonora'),
			('MX', 'TAB', 'Tabasco'),
			('MX', 'TAM', 'Tamaulipas'),
			('MX', 'TLA', 'Tlaxcala'),
			('MX', 'VER', 'Veracruz'),
			('MX', 'YUC', 'Yucatán'),
			('MX', 'ZAC', 'Zacatecas'),
			('MY', '01', 'Johor'),
			('MY', '02', 'Kedah'),
			('MY', '03', 'Kelantan'),
			('MY', '04', 'Melaka'),
			('MY', '05', 'Negeri Sembilan'),
			('MY', '06', 'Pahang'),
			('MY', '07', 'Pulau Pinang'),
			('MY', '08', 'Perak'),
			('MY', '09', 'Perlis'),
			('MY', '10', 'Selangor'),
			('MY', '11', 'Terengganu'),
			('MY', '12', 'Sabah'),
			('MY', '13', 'Sarawak'),
			('MY', '14', 'Wilayah Persekutuan Kuala Lumpur'),
			('MY', '15', 'Wilayah Persekutuan Labuan'),
			('MY', '16', 'Wilayah Persekutuan Putrajaya'),
			('MZ', 'A', 'Niassa'),
			('MZ', 'B', 'Manica'),
			('MZ', 'G', 'Gaza'),
			('MZ', 'I', 'Inhambane'),
			('MZ', 'L', 'Maputo'),
			('MZ', 'MPM', 'Maputo City'),
			('MZ', 'N', 'Nampula'),
			('MZ', 'P', 'Cabo Delgado'),
			('MZ', 'Q', 'Zambézia'),
			('MZ', 'S', 'Sofala'),
			('MZ', 'T', 'Tete'),
			('NA', 'CA', 'Caprivi'),
			('NA', 'ER', 'Erongo'),
			('NA', 'HA', 'Hardap'),
			('NA', 'KA', 'Karas'),
			('NA', 'KH', 'Khomas'),
			('NA', 'KU', 'Kunene'),
			('NA', 'OD', 'Otjozondjupa'),
			('NA', 'OH', 'Omaheke'),
			('NA', 'OK', 'Okavango'),
			('NA', 'ON', 'Oshana'),
			('NA', 'OS', 'Omusati'),
			('NA', 'OT', 'Oshikoto'),
			('NA', 'OW', 'Ohangwena'),
			('NE', '1', 'Agadez'),
			('NE', '2', 'Diffa'),
			('NE', '3', 'Dosso'),
			('NE', '4', 'Maradi'),
			('NE', '5', 'Tahoua'),
			('NE', '6', 'Tillabéri'),
			('NE', '7', 'Zinder'),
			('NE', '8', 'Niamey'),
			('NG', 'AB', 'Abia'),
			('NG', 'AD', 'Adamawa'),
			('NG', 'AK', 'Akwa Ibom'),
			('NG', 'AN', 'Anambra'),
			('NG', 'BA', 'Bauchi'),
			('NG', 'BE', 'Benue'),
			('NG', 'BO', 'Borno'),
			('NG', 'BY', 'Bayelsa'),
			('NG', 'CR', 'Cross River'),
			('NG', 'DE', 'Delta'),
			('NG', 'EB', 'Ebonyi'),
			('NG', 'ED', 'Edo'),
			('NG', 'EK', 'Ekiti'),
			('NG', 'EN', 'Enugu'),
			('NG', 'FC', 'Abuja Federal Capital Territory'),
			('NG', 'GO', 'Gombe'),
			('NG', 'IM', 'Imo'),
			('NG', 'JI', 'Jigawa'),
			('NG', 'KD', 'Kaduna'),
			('NG', 'KE', 'Kebbi'),
			('NG', 'KN', 'Kano'),
			('NG', 'KO', 'Kogi'),
			('NG', 'KT', 'Katsina'),
			('NG', 'KW', 'Kwara'),
			('NG', 'LA', 'Lagos'),
			('NG', 'NA', 'Nassarawa'),
			('NG', 'NI', 'Niger'),
			('NG', 'OG', 'Ogun'),
			('NG', 'ON', 'Ondo'),
			('NG', 'OS', 'Osun'),
			('NG', 'OY', 'Oyo'),
			('NG', 'PL', 'Plateau'),
			('NG', 'RI', 'Rivers'),
			('NG', 'SO', 'Sokoto'),
			('NG', 'TA', 'Taraba'),
			('NG', 'YO', 'Yobe'),
			('NG', 'ZA', 'Zamfara'),
			('NI', 'AN', 'Atlántico Norte*'),
			('NI', 'AS', 'Atlántico Sur*'),
			('NI', 'BO', 'Boaco'),
			('NI', 'CA', 'Carazo'),
			('NI', 'CI', 'Chinandega'),
			('NI', 'CO', 'Chontales'),
			('NI', 'ES', 'Estelí'),
			('NI', 'GR', 'Granada'),
			('NI', 'JI', 'Jinotega'),
			('NI', 'LE', 'León'),
			('NI', 'MD', 'Madriz'),
			('NI', 'MN', 'Managua'),
			('NI', 'MS', 'Masaya'),
			('NI', 'MT', 'Matagalpa'),
			('NI', 'NS', 'Nueva Segovia'),
			('NI', 'RI', 'Rivas'),
			('NI', 'SJ', 'Río San Juan'),
			('NL', 'AW', 'Aruba'),
			('NL', 'BQ1', 'Bonaire'),
			('NL', 'BQ2', 'Saba'),
			('NL', 'BQ3', 'Sint Eustatius'),
			('NL', 'CW', 'Curaçao'),
			('NL', 'DR', 'Drenthe'),
			('NL', 'FL', 'Flevoland'),
			('NL', 'FR', 'Friesland'),
			('NL', 'GE', 'Gelderland'),
			('NL', 'GR', 'Groningen'),
			('NL', 'LI', 'Limburg'),
			('NL', 'NB', 'Noord-Brabant'),
			('NL', 'NH', 'Noord-Holland'),
			('NL', 'OV', 'Overijssel'),
			('NL', 'SX', 'Sint Maarten'),
			('NL', 'UT', 'Utrecht'),
			('NL', 'ZE', 'Zeeland'),
			('NL', 'ZH', 'Zuid-Holland'),
			('NO', '01', 'Østfold'),
			('NO', '02', 'Akershus'),
			('NO', '03', 'Oslo'),
			('NO', '04', 'Hedmark'),
			('NO', '05', 'Oppland'),
			('NO', '06', 'Buskerud'),
			('NO', '07', 'Vestfold'),
			('NO', '08', 'Telemark'),
			('NO', '09', 'Aust-Agder'),
			('NO', '10', 'Vest-Agder'),
			('NO', '11', 'Rogaland'),
			('NO', '12', 'Hordaland'),
			('NO', '14', 'Sogn og Fjordane'),
			('NO', '15', 'Møre og Romsdal'),
			('NO', '16', 'Sør-Trøndelag'),
			('NO', '17', 'Nord-Trøndelag'),
			('NO', '18', 'Nordland'),
			('NO', '19', 'Troms'),
			('NO', '20', 'Finnmark'),
			('NO', '21', 'Svalbard'),
			('NO', '22', 'Jan Mayen'),
			('NP', '1', 'Madhyamanchal'),
			('NP', '2', 'Madhya Pashchimanchal'),
			('NP', '3', 'Pashchimanchal'),
			('NP', '4', 'Purwanchal'),
			('NP', '5', 'Sudur Pashchimanchal'),
			('NP', 'BA', 'Bagmati'),
			('NP', 'BH', 'Bheri'),
			('NP', 'DH', 'Dhawalagiri'),
			('NP', 'GA', 'Gandaki'),
			('NP', 'JA', 'Janakpur'),
			('NP', 'KA', 'Karnali'),
			('NP', 'KO', 'Kosi [Koshi]'),
			('NP', 'LU', 'Lumbini'),
			('NP', 'MA', 'Mahakali'),
			('NP', 'ME', 'Mechi'),
			('NP', 'NA', 'Narayani'),
			('NP', 'RA', 'Rapti'),
			('NP', 'SA', 'Sagarmatha'),
			('NP', 'SE', 'Seti'),
			('NR', '01', 'Aiwo'),
			('NR', '02', 'Anabar'),
			('NR', '03', 'Anetan'),
			('NR', '04', 'Anibare'),
			('NR', '05', 'Baiti'),
			('NR', '06', 'Boe'),
			('NR', '07', 'Buada'),
			('NR', '08', 'Denigomodu'),
			('NR', '09', 'Ewa'),
			('NR', '10', 'Ijuw'),
			('NR', '11', 'Meneng'),
			('NR', '12', 'Nibok'),
			('NR', '13', 'Uaboe'),
			('NR', '14', 'Yaren'),
			('NZ', 'AUK', 'Auckland'),
			('NZ', 'BOP', 'Bay of Plenty'),
			('NZ', 'CAN', 'Canterbury'),
			('NZ', 'CIT', 'Chatham Islands Territory'),
			('NZ', 'GIS', 'Gisborne District'),
			('NZ', 'HKB', 'Hawkes''s Bay'),
			('NZ', 'MBH', 'Marlborough District'),
			('NZ', 'MWT', 'Manawatu-Wanganui'),
			('NZ', 'N', 'North Island'),
			('NZ', 'NSN', 'Nelson City'),
			('NZ', 'NTL', 'Northland'),
			('NZ', 'OTA', 'Otago'),
			('NZ', 'S', 'South Island'),
			('NZ', 'STL', 'Southland'),
			('NZ', 'TAS', 'Tasman District'),
			('NZ', 'TKI', 'Taranaki'),
			('NZ', 'WGN', 'Wellington'),
			('NZ', 'WKO', 'Waikato'),
			('NZ', 'WTC', 'West Coast'),
			('OM', 'BA', 'Al Batinah'),
			('OM', 'BU', 'Al Buraymi'),
			('OM', 'DA', 'Ad Dakhiliyah'),
			('OM', 'MA', 'Masqat'),
			('OM', 'MU', 'Musandam'),
			('OM', 'SH', 'Ash Sharqiyah'),
			('OM', 'WU', 'Al Wustá'),
			('OM', 'ZA', 'Az̧ Z̧āhirah'),
			('OM', 'ZU', 'Z̧ufār'),
			('PA', '1', 'Bocas del Toro'),
			('PA', '2', 'Coclé'),
			('PA', '3', 'Colón'),
			('PA', '4', 'Chiriquí'),
			('PA', '5', 'Darién'),
			('PA', '6', 'Herrera'),
			('PA', '7', 'Los Santos'),
			('PA', '8', 'Panamá'),
			('PA', '9', 'Veraguas'),
			('PA', 'EM', 'Emberá'),
			('PA', 'KY', 'Kuna Yala'),
			('PA', 'NB', 'Ngöbe-Buglé'),
			('PE', 'AMA', 'Amazonas'),
			('PE', 'ANC', 'Ancash'),
			('PE', 'APU', 'Apurímac'),
			('PE', 'ARE', 'Arequipa'),
			('PE', 'AYA', 'Ayacucho'),
			('PE', 'CAJ', 'Cajamarca'),
			('PE', 'CAL', 'El Callao'),
			('PE', 'CUS', 'Cusco [Cuzco]'),
			('PE', 'HUC', 'Huánuco'),
			('PE', 'HUV', 'Huancavelica'),
			('PE', 'ICA', 'Ica'),
			('PE', 'JUN', 'Junín'),
			('PE', 'LAL', 'La Libertad'),
			('PE', 'LAM', 'Lambayeque'),
			('PE', 'LIM', 'Lima'),
			('PE', 'LMA', 'Municipalidad Metropolitana de Lima'),
			('PE', 'LOR', 'Loreto'),
			('PE', 'MDD', 'Madre de Dios'),
			('PE', 'MOQ', 'Moquegua'),
			('PE', 'PAS', 'Pasco'),
			('PE', 'PIU', 'Piura'),
			('PE', 'PUN', 'Puno'),
			('PE', 'SAM', 'San Martín'),
			('PE', 'TAC', 'Tacna'),
			('PE', 'TUM', 'Tumbes'),
			('PE', 'UCA', 'Ucayali'),
			('PG', 'CPK', 'Chimbu'),
			('PG', 'CPM', 'Central'),
			('PG', 'EBR', 'East New Britain'),
			('PG', 'EHG', 'Eastern Highlands'),
			('PG', 'EPW', 'Enga'),
			('PG', 'ESW', 'East Sepik'),
			('PG', 'GPK', 'Gulf'),
			('PG', 'MBA', 'Milne Bay'),
			('PG', 'MPL', 'Morobe'),
			('PG', 'MPM', 'Madang'),
			('PG', 'MRL', 'Manus'),
			('PG', 'NCD', 'National Capital District'),
			('PG', 'NIK', 'New Ireland'),
			('PG', 'NPP', 'Northern'),
			('PG', 'NSB', 'Bougainville'),
			('PG', 'SAN', 'Sandaun [West Sepik]'),
			('PG', 'SHM', 'Southern Highlands'),
			('PG', 'WBK', 'West New Britain'),
			('PG', 'WHM', 'Western Highlands'),
			('PG', 'WPD', 'Western'),
			('PH', '00', 'National Capital Region'),
			('PH', '01', 'Ilocos'),
			('PH', '02', 'Cagayan Valley'),
			('PH', '03', 'Central Luzon'),
			('PH', '05', 'Bicol'),
			('PH', '06', 'Western Visayas'),
			('PH', '07', 'Central Visayas'),
			('PH', '08', 'Eastern Visayas'),
			('PH', '09', 'Zamboanga Peninsula'),
			('PH', '10', 'Northern Mindanao'),
			('PH', '11', 'Davao'),
			('PH', '12', 'Soccsksargen'),
			('PH', '13', 'Caraga'),
			('PH', '14', 'Autonomous Region in Muslim Mindanao'),
			('PH', '15', 'Cordillera Administrative Region'),
			('PH', '40', 'CALABARZON'),
			('PH', '41', 'MIMAROPA'),
			('PH', 'ABR', 'Abra'),
			('PH', 'AGN', 'Agusan del Norte'),
			('PH', 'AGS', 'Agusan del Sur'),
			('PH', 'AKL', 'Aklan'),
			('PH', 'ALB', 'Albay'),
			('PH', 'ANT', 'Antique'),
			('PH', 'APA', 'Apayao'),
			('PH', 'AUR', 'Aurora'),
			('PH', 'BAN', 'Bataan'),
			('PH', 'BAS', 'Basilan'),
			('PH', 'BEN', 'Benguet'),
			('PH', 'BIL', 'Biliran'),
			('PH', 'BOH', 'Bohol'),
			('PH', 'BTG', 'Batangas'),
			('PH', 'BTN', 'Batanes'),
			('PH', 'BUK', 'Bukidnon'),
			('PH', 'BUL', 'Bulacan'),
			('PH', 'CAG', 'Cagayan'),
			('PH', 'CAM', 'Camiguin'),
			('PH', 'CAN', 'Camarines Norte'),
			('PH', 'CAP', 'Capiz'),
			('PH', 'CAS', 'Camarines Sur'),
			('PH', 'CAT', 'Catanduanes'),
			('PH', 'CAV', 'Cavite'),
			('PH', 'CEB', 'Cebu'),
			('PH', 'COM', 'Compostela Valley'),
			('PH', 'DAO', 'Davao Oriental'),
			('PH', 'DAS', 'Davao del Sur'),
			('PH', 'DAV', 'Davao del Norte'),
			('PH', 'DIN', 'Dinagat Islands'),
			('PH', 'EAS', 'Eastern Samar'),
			('PH', 'GUI', 'Guimaras'),
			('PH', 'IFU', 'Ifugao'),
			('PH', 'ILI', 'Iloilo'),
			('PH', 'ILN', 'Ilocos Norte'),
			('PH', 'ILS', 'Ilocos Sur'),
			('PH', 'ISA', 'Isabela'),
			('PH', 'KAL', 'Kalinga'),
			('PH', 'LAG', 'Laguna'),
			('PH', 'LAN', 'Lanao del Norte'),
			('PH', 'LAS', 'Lanao del Sur'),
			('PH', 'LEY', 'Leyte'),
			('PH', 'LUN', 'La Union'),
			('PH', 'MAD', 'Marinduque'),
			('PH', 'MAG', 'Maguindanao'),
			('PH', 'MAS', 'Masbate'),
			('PH', 'MDC', 'Mindoro Occidental'),
			('PH', 'MDR', 'Mindoro Oriental'),
			('PH', 'MOU', 'Mountain Province'),
			('PH', 'MSC', 'Misamis Occidental'),
			('PH', 'MSR', 'Misamis Oriental'),
			('PH', 'NCO', 'Cotabato'),
			('PH', 'NEC', 'Negros Occidental'),
			('PH', 'NER', 'Negros Oriental'),
			('PH', 'NSA', 'Northern Samar'),
			('PH', 'NUE', 'Nueva Ecija'),
			('PH', 'NUV', 'Nueva Vizcaya'),
			('PH', 'PAM', 'Pampanga'),
			('PH', 'PAN', 'Pangasinan'),
			('PH', 'PLW', 'Palawan'),
			('PH', 'QUE', 'Quezon'),
			('PH', 'QUI', 'Quirino'),
			('PH', 'RIZ', 'Rizal'),
			('PH', 'ROM', 'Romblon'),
			('PH', 'SAR', 'Sarangani'),
			('PH', 'SCO', 'South Cotabato'),
			('PH', 'SIG', 'Siquijor'),
			('PH', 'SLE', 'Southern Leyte'),
			('PH', 'SLU', 'Sulu'),
			('PH', 'SOR', 'Sorsogon'),
			('PH', 'SUK', 'Sultan Kudarat'),
			('PH', 'SUN', 'Surigao del Norte'),
			('PH', 'SUR', 'Surigao del Sur'),
			('PH', 'TAR', 'Tarlac'),
			('PH', 'TAW', 'Tawi-Tawi'),
			('PH', 'WSA', 'Western Samar'),
			('PH', 'X2~', 'Shariff Kabunsuan'),
			('PH', 'ZAN', 'Zamboanga del Norte'),
			('PH', 'ZAS', 'Zamboanga del Sur'),
			('PH', 'ZMB', 'Zambales'),
			('PH', 'ZSI', 'Zamboanga Sibuguey [Zamboanga Sibugay]'),
			('PK', 'BA', 'Baluchistan'),
			('PK', 'GB', 'Gilgit-Baltistan'),
			('PK', 'IS', 'Islamabad'),
			('PK', 'JK', 'Azad Kashmir'),
			('PK', 'KP', 'Khyber Pakhtunkhwa'),
			('PK', 'PB', 'Punjab'),
			('PK', 'SD', 'Sindh'),
			('PK', 'TA', 'Federally Administered Tribal Areas'),
			('PL', 'DS', 'Dolnoslaskie'),
			('PL', 'KP', 'Kujawsko-pomorskie'),
			('PL', 'LB', 'Lubuskie'),
			('PL', 'LD', 'Lódzkie'),
			('PL', 'LU', 'Lubelskie'),
			('PL', 'MA', 'Malopolskie'),
			('PL', 'MZ', 'Mazowieckie'),
			('PL', 'OP', 'Opolskie'),
			('PL', 'PD', 'Podlaskie'),
			('PL', 'PK', 'Podkarpackie'),
			('PL', 'PM', 'Pomorskie'),
			('PL', 'SK', 'Swietokrzyskie'),
			('PL', 'SL', 'Slaskie'),
			('PL', 'WN', 'Warminsko-mazurskie'),
			('PL', 'WP', 'Wielkopolskie'),
			('PL', 'ZP', 'Zachodniopomorskie'),
			('PS', 'BTH', 'Bethlehem Bayt Laḩm'),
			('PS', 'DEB', 'Deir El Balah Dayr al Balaḩ'),
			('PS', 'GZA', 'Gaza Ghazzah'),
			('PS', 'HBN', 'Hebron Al Khalīl'),
			('PS', 'JEM', 'Jerusalem Al Quds'),
			('PS', 'JEN', 'Jenin Janīn'),
			('PS', 'JRH', 'Jericho – Al Aghwar Arīḩā wa al Aghwār'),
			('PS', 'KYS', 'Khan Yunis Khān Yūnis'),
			('PS', 'NBS', 'Nablus Nāblus'),
			('PS', 'NGZ', 'North Gaza Shamāl Ghazzah'),
			('PS', 'QQA', 'Qalqilya Qalqīlyah'),
			('PS', 'RBH', 'Ramallah Rām Allāh wa al Bīrah'),
			('PS', 'RFH', 'Rafah Rafaḩ'),
			('PS', 'SLT', 'Salfit Salfīt'),
			('PS', 'TBS', 'Tubas Ţūbās'),
			('PS', 'TKM', 'Tulkarm Ţūlkarm'),
			('PT', '01', 'Aveiro'),
			('PT', '02', 'Beja'),
			('PT', '03', 'Braga'),
			('PT', '04', 'Bragança'),
			('PT', '05', 'Castelo Branco'),
			('PT', '06', 'Coimbra'),
			('PT', '07', 'Évora'),
			('PT', '08', 'Faro'),
			('PT', '09', 'Guarda'),
			('PT', '10', 'Leiria'),
			('PT', '11', 'Lisboa'),
			('PT', '12', 'Portalegre'),
			('PT', '13', 'Porto'),
			('PT', '14', 'Santarém'),
			('PT', '15', 'Setúbal'),
			('PT', '16', 'Viana do Castelo'),
			('PT', '17', 'Vila Real'),
			('PT', '18', 'Viseu'),
			('PT', '20', 'Região Autónoma dos Açores'),
			('PT', '30', 'Região Autónoma da Madeira'),
			('PW', '002', 'Aimeliik'),
			('PW', '004', 'Airai'),
			('PW', '010', 'Angaur'),
			('PW', '050', 'Hatobohei'),
			('PW', '100', 'Kayangel'),
			('PW', '150', 'Koror'),
			('PW', '212', 'Melekeok'),
			('PW', '214', 'Ngaraard'),
			('PW', '218', 'Ngarchelong'),
			('PW', '222', 'Ngardmau'),
			('PW', '224', 'Ngatpang'),
			('PW', '226', 'Ngchesar'),
			('PW', '227', 'Ngeremlengui'),
			('PW', '228', 'Ngiwal'),
			('PW', '350', 'Peleliu'),
			('PW', '370', 'Sonsorol'),
			('PY', '1', 'Concepción'),
			('PY', '10', 'Alto Paraná'),
			('PY', '11', 'Central'),
			('PY', '12', 'Ñeembucú'),
			('PY', '13', 'Amambay'),
			('PY', '14', 'Canindeyú'),
			('PY', '15', 'Presidente Hayes'),
			('PY', '16', 'Alto Paraguay'),
			('PY', '19', 'Boquerón'),
			('PY', '2', 'San Pedro'),
			('PY', '3', 'Cordillera'),
			('PY', '4', 'Guairá'),
			('PY', '5', 'Caaguazú'),
			('PY', '6', 'Caazapá'),
			('PY', '7', 'Itapúa'),
			('PY', '8', 'Misiones'),
			('PY', '9', 'Paraguarí'),
			('PY', 'ASU', 'Asunción'),
			('QA', 'DA', 'Ad Dawhah'),
			('QA', 'KH', 'Al Khawr wa adh Dhakhīrah'),
			('QA', 'MS', 'Madinat ash Shamal'),
			('QA', 'RA', 'Ar Rayyan'),
			('QA', 'US', 'Umm Salal'),
			('QA', 'WA', 'Al Wakrah'),
			('QA', 'X1~', 'Umm Sa''id'),
			('QA', 'ZA', 'Az̧ Z̧a‘āyin'),
			('RO', 'AB', 'Alba'),
			('RO', 'AG', 'Arges'),
			('RO', 'AR', 'Arad'),
			('RO', 'B', 'Bucuresti'),
			('RO', 'BC', 'Bacau'),
			('RO', 'BH', 'Bihor'),
			('RO', 'BN', 'Bistrita-Nasaud'),
			('RO', 'BR', 'Braila'),
			('RO', 'BT', 'Botosani'),
			('RO', 'BV', 'Brasov'),
			('RO', 'BZ', 'Buzau'),
			('RO', 'CJ', 'Cluj'),
			('RO', 'CL', 'Calarasi'),
			('RO', 'CS', 'Caras-Severin'),
			('RO', 'CT', 'Constanta'),
			('RO', 'CV', 'Covasna'),
			('RO', 'DB', 'Dâmbovita'),
			('RO', 'DJ', 'Dolj'),
			('RO', 'GJ', 'Gorj'),
			('RO', 'GL', 'Galati'),
			('RO', 'GR', 'Giurgiu'),
			('RO', 'HD', 'Hunedoara'),
			('RO', 'HR', 'Harghita'),
			('RO', 'IF', 'Ilfov'),
			('RO', 'IL', 'Ialomita'),
			('RO', 'IS', 'Iasi'),
			('RO', 'MH', 'Mehedinti'),
			('RO', 'MM', 'Maramures'),
			('RO', 'MS', 'Mures'),
			('RO', 'NT', 'Neamt'),
			('RO', 'OT', 'Olt'),
			('RO', 'PH', 'Prahova'),
			('RO', 'SB', 'Sibiu'),
			('RO', 'SJ', 'Salaj'),
			('RO', 'SM', 'Satu Mare'),
			('RO', 'SV', 'Suceava'),
			('RO', 'TL', 'Tulcea'),
			('RO', 'TM', 'Timis'),
			('RO', 'TR', 'Teleorman'),
			('RO', 'VL', 'Vâlcea'),
			('RO', 'VN', 'Vrancea'),
			('RO', 'VS', 'Vaslui'),
			('RS', '00', 'Belgrade'),
			('RS', '01', 'Severnobački okrug'),
			('RS', '02', 'Srednjebanatski okrug'),
			('RS', '03', 'Severnobanatski okrug'),
			('RS', '04', 'Južnobanatski okrug'),
			('RS', '05', 'Zapadnobaèki okrug'),
			('RS', '06', 'Južnobanatski okrug'),
			('RS', '07', 'Sremski okrug'),
			('RS', '08', 'Mačvanski okrug'),
			('RS', '09', 'Kolubarski okrug'),
			('RS', '10', 'Podunavski okrug'),
			('RS', '11', 'Braničevski okrug'),
			('RS', '12', 'Šumadijski okrug'),
			('RS', '13', 'Pomoravski okrug'),
			('RS', '14', 'Borski okrug'),
			('RS', '15', 'Zajeèarski okrug'),
			('RS', '16', 'Zlatiborski okrug'),
			('RS', '17', 'Moravički okrug'),
			('RS', '18', 'Raška okrug'),
			('RS', '19', 'Rasinski okrug'),
			('RS', '20', 'Nišavski okrug'),
			('RS', '21', 'Toplièki okrug'),
			('RS', '22', 'Pirotski okrug'),
			('RS', '23', 'Jablanički okrug'),
			('RS', '24', 'Pčinjski okrug'),
			('RS', '25', 'Kosovski okrug'),
			('RS', '26', 'Pećki okrug'),
			('RS', '27', 'Prizrenski okrug'),
			('RS', '28', 'Kosovsko-Mitrovački okrug'),
			('RS', '29', 'Kosovsko-Pomoravski okrug'),
			('RU', 'AD', 'Adygeya, Respublika'),
			('RU', 'AL', 'Altay, Respublika'),
			('RU', 'ALT', 'Altayskiy kray'),
			('RU', 'AMU', 'Amurskaya oblast'''),
			('RU', 'ARK', 'Arkhangel''skaya oblast'''),
			('RU', 'AST', 'Astrakhanskaya oblast'''),
			('RU', 'BA', 'Bashkortostan, Respublika'),
			('RU', 'BEL', 'Belgorodskaya oblast'''),
			('RU', 'BRY', 'Bryanskaya oblast'''),
			('RU', 'BU', 'Buryatiya, Respublika'),
			('RU', 'CE', 'Chechenskaya Respublika'),
			('RU', 'CHE', 'Chelyabinskaya oblast'''),
			('RU', 'CHU', 'Chukotskiy avtonomnyy okrug'),
			('RU', 'CU', 'Chuvashskaya Respublika'),
			('RU', 'DA', 'Dagestan, Respublika'),
			('RU', 'IN', 'Ingushskaya Respublika [Respublika Ingushetiya]'),
			('RU', 'IRK', 'Irkutskaya oblast'''),
			('RU', 'IVA', 'Ivanovskaya oblast'''),
			('RU', 'KAM', 'Kamchatskaya oblast'''),
			('RU', 'KB', 'Kabardino-Balkarskaya Respublika'),
			('RU', 'KC', 'Karachayevo-Cherkesskaya Respublika'),
			('RU', 'KDA', 'Krasnodarskiy kray'),
			('RU', 'KEM', 'Kemerovskaya oblast'''),
			('RU', 'KGD', 'Kaliningradskaya oblast'''),
			('RU', 'KGN', 'Kurganskaya oblast'''),
			('RU', 'KHA', 'Khabarovskiy kray'),
			('RU', 'KHM', 'Khanty-Mansiyskiy avtonomnyy okrug [Yugra]'),
			('RU', 'KIR', 'Kirovskaya oblast'''),
			('RU', 'KK', 'Khakasiya, Respublika'),
			('RU', 'KL', 'Kalmykiya, Respublika'),
			('RU', 'KLU', 'Kaluzhskaya oblast'''),
			('RU', 'KO', 'Komi, Respublika'),
			('RU', 'KOS', 'Kostromskaya oblast'''),
			('RU', 'KR', 'Kareliya, Respublika');
			INSERT INTO `states` (`country_alpha2`, `code`, `name`) VALUES 
			('RU', 'KRS', 'Kurskaya oblast'''),
			('RU', 'KYA', 'Krasnoyarskiy kray'),
			('RU', 'LEN', 'Leningradskaya oblast'''),
			('RU', 'LIP', 'Lipetskaya oblast'''),
			('RU', 'MAG', 'Magadanskaya oblast'''),
			('RU', 'ME', 'Mariy El, Respublika'),
			('RU', 'MO', 'Mordoviya, Respublika'),
			('RU', 'MOS', 'Moskovskaya oblast'''),
			('RU', 'MOW', 'Moskva'),
			('RU', 'MUR', 'Murmanskaya oblast'''),
			('RU', 'NEN', 'Nenetskiy avtonomnyy okrug'),
			('RU', 'NGR', 'Novgorodskaya oblast'''),
			('RU', 'NIZ', 'Nizhegorodskaya oblast'''),
			('RU', 'NVS', 'Novosibirskaya oblast'''),
			('RU', 'OMS', 'Omskaya oblast'''),
			('RU', 'ORE', 'Orenburgskaya oblast'''),
			('RU', 'ORL', 'Orlovskaya oblast'''),
			('RU', 'PER', 'Perm'),
			('RU', 'PNZ', 'Penzenskaya oblast'''),
			('RU', 'PRI', 'Primorskiy kray'),
			('RU', 'PSK', 'Pskovskaya oblast'''),
			('RU', 'ROS', 'Rostovskaya oblast'''),
			('RU', 'RYA', 'Ryazanskaya oblast'''),
			('RU', 'SA', 'Sakha, Respublika [Yakutiya]'),
			('RU', 'SAK', 'Sakhalinskaya oblast'''),
			('RU', 'SAM', 'Samarskaya oblast'''),
			('RU', 'SAR', 'Saratovskaya oblast'''),
			('RU', 'SE', 'Severnaya Osetiya, Respublika [Alaniya] [Respublika Severnaya Osetiya-Alaniya]'),
			('RU', 'SMO', 'Smolenskaya oblast'''),
			('RU', 'SPE', 'Sankt-Peterburg'),
			('RU', 'STA', 'Stavropol''skiy kray'),
			('RU', 'SVE', 'Sverdlovskaya oblast'''),
			('RU', 'TA', 'Tatarstan, Respublika'),
			('RU', 'TAM', 'Tambovskaya oblast'''),
			('RU', 'TOM', 'Tomskaya oblast'''),
			('RU', 'TUL', 'Tul''skaya oblast'''),
			('RU', 'TVE', 'Tverskaya oblast'''),
			('RU', 'TY', 'Tyva, Respublika [Tuva]'),
			('RU', 'TYU', 'Tyumenskaya oblast'''),
			('RU', 'UD', 'Udmurtskaya Respublika'),
			('RU', 'ULY', 'Ul''yanovskaya oblast'''),
			('RU', 'VGG', 'Volgogradskaya oblast'''),
			('RU', 'VLA', 'Vladimirskaya oblast'''),
			('RU', 'VLG', 'Vologodskaya oblast'''),
			('RU', 'VOR', 'Voronezhskaya oblast'''),
			('RU', 'X1~', 'Komi-Permyak'),
			('RU', 'YAN', 'Yamalo-Nenetskiy avtonomnyy okrug'),
			('RU', 'YAR', 'Yaroslavskaya oblast'''),
			('RU', 'YEV', 'Yevreyskaya avtonomnaya oblast'''),
			('RU', 'ZAB', 'Zabajkal''skij kraj'),
			('RW', '01', 'Ville de Kigali'),
			('RW', '02', 'Est'),
			('RW', '03', 'Nord'),
			('RW', '04', 'Ouest'),
			('RW', '05', 'Sud'),
			('SA', '01', 'Ar Riyāḑ'),
			('SA', '02', 'Makkah'),
			('SA', '03', 'Al Madinah'),
			('SA', '04', 'Ash Sharqiyah'),
			('SA', '05', 'Al Qasim'),
			('SA', '06', '?a''il'),
			('SA', '07', 'Tabuk'),
			('SA', '08', 'Al Ḩudūd ash Shamālīyah'),
			('SA', '09', 'Jizan'),
			('SA', '10', 'Najran'),
			('SA', '11', 'Al Bāḩah'),
			('SA', '12', 'Al Jawf'),
			('SA', '14', '?Asir'),
			('SB', 'CE', 'Central'),
			('SB', 'CH', 'Choiseul'),
			('SB', 'CT', 'Capital Territory'),
			('SB', 'GU', 'Guadalcanal'),
			('SB', 'IS', 'Isabel'),
			('SB', 'MK', 'Makira'),
			('SB', 'ML', 'Malaita'),
			('SB', 'RB', 'Rennell and Bellona'),
			('SB', 'TE', 'Temotu'),
			('SB', 'WE', 'Western'),
			('SC', '01', 'Anse aux Pins'),
			('SC', '02', 'Anse Boileau'),
			('SC', '03', 'Anse Étoile'),
			('SC', '04', 'Au Cap'),
			('SC', '05', 'Anse Royale'),
			('SC', '06', 'Baie Lazare'),
			('SC', '07', 'Baie Sainte Anne'),
			('SC', '08', 'Beau Vallon'),
			('SC', '09', 'Bel Air'),
			('SC', '10', 'Bel Ombre'),
			('SC', '11', 'Cascade'),
			('SC', '12', 'Glacis'),
			('SC', '13', 'Grand Anse Mahe'),
			('SC', '14', 'Grand Anse Praslin'),
			('SC', '15', 'La Digue'),
			('SC', '16', 'English River'),
			('SC', '17', 'Mont Buxton'),
			('SC', '18', 'Mont Fleuri'),
			('SC', '19', 'Plaisance'),
			('SC', '20', 'Pointe La Rue'),
			('SC', '21', 'Port Glaud'),
			('SC', '22', 'Saint Louis'),
			('SC', '23', 'Takamaka'),
			('SC', '24', 'Les Mamelles'),
			('SC', '25', 'Roche Caiman'),
			('SD', '10', 'Gharb Kurdufan'),
			('SD', 'DC', 'Zalingei'),
			('SD', 'DE', 'Sharq Dārfūr'),
			('SD', 'DN', 'Shamal Darfur'),
			('SD', 'DS', 'Janub Darfur'),
			('SD', 'DW', 'Gharb Darfur'),
			('SD', 'GD', 'Al Qaḑārif'),
			('SD', 'GZ', 'Al Jazirah'),
			('SD', 'KA', 'Kassala'),
			('SD', 'KH', 'Al Khartum'),
			('SD', 'KN', 'Shamal Kurdufan'),
			('SD', 'KS', 'Janub Kurdufan'),
			('SD', 'NB', 'An Nil al Azraq'),
			('SD', 'NO', 'Ash Shamaliyah'),
			('SD', 'NR', 'An Nil'),
			('SD', 'NW', 'An Nīl al Abyaḑ'),
			('SD', 'RS', 'Al Bah¸r al Ah¸mar'),
			('SD', 'SI', 'Sinnar'),
			('SE', 'AB', 'Stockholms län [SE-01]'),
			('SE', 'AC', 'Västerbottens län [SE-24]'),
			('SE', 'BD', 'Norrbottens län [SE-25]'),
			('SE', 'C', 'Uppsala län [SE-03]'),
			('SE', 'D', 'Södermanlands län [SE-04]'),
			('SE', 'E', 'Östergötlands län [SE-05]'),
			('SE', 'F', 'Jönköpings län [SE-06]'),
			('SE', 'G', 'Kronobergs län [SE-07]'),
			('SE', 'H', 'Kalmar län [SE-08]'),
			('SE', 'I', 'Gotlands län [SE-09]'),
			('SE', 'K', 'Blekinge län [SE-10]'),
			('SE', 'M', 'Skåne län [SE-12]'),
			('SE', 'N', 'Hallands län [SE-13]'),
			('SE', 'O', 'Västra Götalands län [SE-14]'),
			('SE', 'S', 'Värmlands län [SE-17]'),
			('SE', 'T', 'Örebro län [SE-18]'),
			('SE', 'U', 'Västmanlands län [SE-19]'),
			('SE', 'W', 'Dalarnas län [SE-20]'),
			('SE', 'X', 'Gävleborgs län [SE-21]'),
			('SE', 'Y', 'Västernorrlands län [SE-22]'),
			('SE', 'Z', 'Jämtlands län [SE-23]'),
			('SG', '01', 'Central Singapore'),
			('SG', '02', 'North East'),
			('SG', '03', 'North West'),
			('SG', '04', 'South East'),
			('SG', '05', 'South West'),
			('SG', 'X1~', 'Singapore - No State'),
			('SH', 'AC', 'Ascension'),
			('SH', 'HL', 'Saint Helena'),
			('SH', 'SH', 'Saint Helena'),
			('SH', 'TA', 'Tristan da Cunha'),
			('SI', '001', 'Ajdovšcina'),
			('SI', '002', 'Beltinci'),
			('SI', '003', 'Bled'),
			('SI', '004', 'Bohinj'),
			('SI', '005', 'Borovnica'),
			('SI', '006', 'Bovec'),
			('SI', '007', 'Brda'),
			('SI', '008', 'Brezovica'),
			('SI', '009', 'Brežice'),
			('SI', '010', 'Tišina'),
			('SI', '011', 'Celje'),
			('SI', '012', 'Cerklje na Gorenjskem'),
			('SI', '013', 'Cerknica'),
			('SI', '014', 'Cerkno'),
			('SI', '015', 'Crenšovci'),
			('SI', '016', 'Crna na Koroškem'),
			('SI', '017', 'Crnomelj'),
			('SI', '018', 'Destrnik'),
			('SI', '019', 'Divaca'),
			('SI', '020', 'Dobrepolje'),
			('SI', '021', 'Dobrova-Polhov Gradec'),
			('SI', '022', 'Dol pri Ljubljani'),
			('SI', '023', 'Domžale'),
			('SI', '024', 'Dornava'),
			('SI', '025', 'Dravograd'),
			('SI', '026', 'Duplek'),
			('SI', '027', 'Gorenja vas-Poljane'),
			('SI', '028', 'Gorišnica'),
			('SI', '029', 'Gornja Radgona'),
			('SI', '030', 'Gornji Grad'),
			('SI', '031', 'Gornji Petrovci'),
			('SI', '032', 'Grosuplje'),
			('SI', '033', 'Šalovci'),
			('SI', '034', 'Hrastnik'),
			('SI', '035', 'Hrpelje-Kozina'),
			('SI', '036', 'Idrija'),
			('SI', '037', 'Ig'),
			('SI', '038', 'Ilirska Bistrica'),
			('SI', '039', 'Ivancna Gorica'),
			('SI', '040', 'Izola/Isola'),
			('SI', '041', 'Jesenice'),
			('SI', '042', 'Juršinci'),
			('SI', '043', 'Kamnik'),
			('SI', '044', 'Kanal'),
			('SI', '045', 'Kidricevo'),
			('SI', '046', 'Kobarid'),
			('SI', '047', 'Kobilje'),
			('SI', '048', 'Kocevje'),
			('SI', '049', 'Komen'),
			('SI', '050', 'Koper/Capodistria'),
			('SI', '051', 'Kozje'),
			('SI', '052', 'Kranj'),
			('SI', '053', 'Kranjska Gora'),
			('SI', '054', 'Krško'),
			('SI', '055', 'Kungota'),
			('SI', '056', 'Kuzma'),
			('SI', '057', 'Laško'),
			('SI', '058', 'Lenart'),
			('SI', '059', 'Lendava/Lendva'),
			('SI', '060', 'Litija'),
			('SI', '061', 'Ljubljana'),
			('SI', '062', 'Ljubno'),
			('SI', '063', 'Ljutomer'),
			('SI', '064', 'Logatec'),
			('SI', '065', 'Loška dolina'),
			('SI', '066', 'Loški Potok'),
			('SI', '067', 'Luce'),
			('SI', '068', 'Lukovica'),
			('SI', '069', 'Majšperk'),
			('SI', '070', 'Maribor'),
			('SI', '071', 'Medvode'),
			('SI', '072', 'Mengeš'),
			('SI', '073', 'Metlika'),
			('SI', '074', 'Mežica'),
			('SI', '075', 'Miren-Kostanjevica'),
			('SI', '076', 'Mislinja'),
			('SI', '077', 'Moravce'),
			('SI', '078', 'Moravske Toplice'),
			('SI', '079', 'Mozirje'),
			('SI', '080', 'Murska Sobota'),
			('SI', '081', 'Muta'),
			('SI', '082', 'Naklo'),
			('SI', '083', 'Nazarje'),
			('SI', '084', 'Nova Gorica'),
			('SI', '085', 'Novo mesto'),
			('SI', '086', 'Odranci'),
			('SI', '087', 'Ormož'),
			('SI', '088', 'Osilnica'),
			('SI', '089', 'Pesnica'),
			('SI', '090', 'Piran/Pirano'),
			('SI', '091', 'Pivka'),
			('SI', '092', 'Podcetrtek'),
			('SI', '093', 'Podvelka'),
			('SI', '094', 'Postojna'),
			('SI', '095', 'Preddvor'),
			('SI', '096', 'Ptuj'),
			('SI', '097', 'Puconci'),
			('SI', '098', 'Race-Fram'),
			('SI', '099', 'Radece'),
			('SI', '100', 'Radenci'),
			('SI', '101', 'Radlje ob Dravi'),
			('SI', '102', 'Radovljica'),
			('SI', '103', 'Ravne na Koroškem'),
			('SI', '104', 'Ribnica'),
			('SI', '105', 'Rogašovci'),
			('SI', '106', 'Rogaška Slatina'),
			('SI', '107', 'Rogatec'),
			('SI', '108', 'Ruše'),
			('SI', '109', 'Semic'),
			('SI', '110', 'Sevnica'),
			('SI', '111', 'Sežana'),
			('SI', '112', 'Slovenj Gradec'),
			('SI', '113', 'Slovenska Bistrica'),
			('SI', '114', 'Slovenske Konjice'),
			('SI', '115', 'Starše'),
			('SI', '116', 'Sveti Jurij'),
			('SI', '117', 'Šencur'),
			('SI', '118', 'Šentilj'),
			('SI', '119', 'Šentjernej'),
			('SI', '120', 'Šentjur pri Celju'),
			('SI', '121', 'Škocjan'),
			('SI', '122', 'Škofja Loka'),
			('SI', '123', 'Škofljica'),
			('SI', '124', 'Šmarje pri Jelšah'),
			('SI', '125', 'Šmartno ob Paki'),
			('SI', '126', 'Šoštanj'),
			('SI', '127', 'Štore'),
			('SI', '128', 'Tolmin'),
			('SI', '129', 'Trbovlje'),
			('SI', '130', 'Trebnje'),
			('SI', '131', 'Tržic'),
			('SI', '132', 'Turnišce'),
			('SI', '133', 'Velenje'),
			('SI', '134', 'Velike Lašce'),
			('SI', '135', 'Videm'),
			('SI', '136', 'Vipava'),
			('SI', '137', 'Vitanje'),
			('SI', '138', 'Vodice'),
			('SI', '139', 'Vojnik'),
			('SI', '140', 'Vrhnika'),
			('SI', '141', 'Vuzenica'),
			('SI', '142', 'Zagorje ob Savi'),
			('SI', '143', 'Zavrc'),
			('SI', '144', 'Zrece'),
			('SI', '146', 'Železniki'),
			('SI', '147', 'Žiri'),
			('SI', '148', 'Benedikt'),
			('SI', '149', 'Bistrica ob Sotli'),
			('SI', '150', 'Bloke'),
			('SI', '151', 'Braslovce'),
			('SI', '152', 'Cankova'),
			('SI', '153', 'Cerkvenjak'),
			('SI', '154', 'Dobje'),
			('SI', '155', 'Dobrna'),
			('SI', '156', 'Dobrovnik/Dobronak'),
			('SI', '157', 'Dolenjske Toplice'),
			('SI', '158', 'Grad'),
			('SI', '159', 'Hajdina'),
			('SI', '160', 'Hoce-Slivnica'),
			('SI', '161', 'Hodoš/Hodos'),
			('SI', '162', 'Horjul'),
			('SI', '163', 'Jezersko'),
			('SI', '164', 'Komenda'),
			('SI', '165', 'Kostel'),
			('SI', '166', 'Križevci'),
			('SI', '167', 'Lovrenc na Pohorju'),
			('SI', '168', 'Markovci'),
			('SI', '169', 'Miklavž na Dravskem polju'),
			('SI', '170', 'Mirna Pec'),
			('SI', '171', 'Oplotnica'),
			('SI', '172', 'Podlehnik'),
			('SI', '173', 'Polzela'),
			('SI', '174', 'Prebold'),
			('SI', '175', 'Prevalje'),
			('SI', '176', 'Razkrižje'),
			('SI', '177', 'Ribnica na Pohorju'),
			('SI', '178', 'Selnica ob Dravi'),
			('SI', '179', 'Sodražica'),
			('SI', '180', 'Solcava'),
			('SI', '181', 'Sveta Ana'),
			('SI', '182', 'Sveti Andraž v Slovenskih goricah'),
			('SI', '183', 'Šempeter-Vrtojba'),
			('SI', '184', 'Tabor'),
			('SI', '185', 'Trnovska vas'),
			('SI', '186', 'Trzin'),
			('SI', '187', 'Velika Polana'),
			('SI', '188', 'Veržej'),
			('SI', '189', 'Vransko'),
			('SI', '190', 'Žalec'),
			('SI', '191', 'Žetale'),
			('SI', '192', 'Žirovnica'),
			('SI', '193', 'Žužemberk'),
			('SI', '194', 'Šmartno pri Litiji'),
			('SI', '195', 'Apače'),
			('SI', '196', 'Kosanjevica na Krki'),
			('SI', '197', 'Cirkulane'),
			('SI', '198', 'Makole'),
			('SI', '199', 'Mokronog-Trebelno'),
			('SI', '200', 'Poljčane'),
			('SI', '201', 'Renče-Vogrsko'),
			('SI', '202', 'Središče ob Dravi'),
			('SI', '203', 'Straža'),
			('SI', '204', 'Sveta Trojica v Slovenskih Goricah'),
			('SI', '205', 'Sveti Tomaž'),
			('SI', '206', 'Šmarješke Toplice'),
			('SI', '207', 'Gorje'),
			('SI', '208', 'Log-Dragomer'),
			('SI', '209', 'Rečica ob Savinji'),
			('SI', '210', 'Sveti Jurij v Slovenskih Goricah'),
			('SI', '211', 'Šentrupert'),
			('SK', 'BC', 'Banskobystrický kraj'),
			('SK', 'BL', 'Bratislavský kraj'),
			('SK', 'KI', 'Košický kraj'),
			('SK', 'NI', 'Nitriansky kraj'),
			('SK', 'PV', 'Prešovský kraj'),
			('SK', 'TA', 'Trnavský kraj'),
			('SK', 'TC', 'Trenciansky kraj'),
			('SK', 'ZI', 'Žilinský kraj'),
			('SL', 'E', 'Eastern'),
			('SL', 'N', 'Northern'),
			('SL', 'S', 'Southern'),
			('SL', 'W', 'Western Area'),
			('SM', '01', 'Acquaviva'),
			('SM', '02', 'Chiesanuova'),
			('SM', '03', 'Domagnano'),
			('SM', '04', 'Faetano'),
			('SM', '05', 'Fiorentino'),
			('SM', '06', 'Borgo Maggiore'),
			('SM', '07', 'San Marino'),
			('SM', '08', 'Montegiardino'),
			('SM', '09', 'Serravalle'),
			('SN', 'DB', 'Diourbel'),
			('SN', 'DK', 'Dakar'),
			('SN', 'FK', 'Fatick'),
			('SN', 'KA', 'Kaffrine'),
			('SN', 'KD', 'Kolda'),
			('SN', 'KE', 'Kédougou'),
			('SN', 'KL', 'Kaolack'),
			('SN', 'LG', 'Louga'),
			('SN', 'MT', 'Matam'),
			('SN', 'SE', 'Sédhiou'),
			('SN', 'SL', 'Saint-Louis'),
			('SN', 'TC', 'Tambacounda'),
			('SN', 'TH', 'Thiès'),
			('SN', 'ZG', 'Ziguinchor'),
			('SO', 'AW', 'Awdal'),
			('SO', 'BK', 'Bakool'),
			('SO', 'BN', 'Banaadir'),
			('SO', 'BR', 'Bari'),
			('SO', 'BY', 'Bay'),
			('SO', 'GA', 'Galguduud'),
			('SO', 'GE', 'Gedo'),
			('SO', 'HI', 'Hiiraan'),
			('SO', 'JD', 'Jubbada Dhexe'),
			('SO', 'JH', 'Jubbada Hoose'),
			('SO', 'MU', 'Mudug'),
			('SO', 'NU', 'Nugaal'),
			('SO', 'SA', 'Sanaag'),
			('SO', 'SD', 'Shabeellaha Dhexe'),
			('SO', 'SH', 'Shabeellaha Hoose'),
			('SO', 'SO', 'Sool'),
			('SO', 'TO', 'Togdheer'),
			('SO', 'WO', 'Woqooyi Galbeed'),
			('SR', 'BR', 'Brokopondo'),
			('SR', 'CM', 'Commewijne'),
			('SR', 'CR', 'Coronie'),
			('SR', 'MA', 'Marowijne'),
			('SR', 'NI', 'Nickerie'),
			('SR', 'PM', 'Paramaribo'),
			('SR', 'PR', 'Para'),
			('SR', 'SA', 'Saramacca'),
			('SR', 'SI', 'Sipaliwini'),
			('SR', 'WA', 'Wanica'),
			('SS', 'BN', 'Northern Bahr el-Ghazal'),
			('SS', 'BW', 'Western Bahr el-Ghazal'),
			('SS', 'EC', 'Central Equatoria'),
			('SS', 'EE', 'Eastern Equatoria'),
			('SS', 'EW', 'Western Equatoria'),
			('SS', 'JG', 'Jonglei'),
			('SS', 'LK', 'Lakes'),
			('SS', 'NU', 'Upper Nile'),
			('SS', 'UY', 'Unity'),
			('SS', 'WR', 'Warrap'),
			('ST', 'P', 'Príncipe'),
			('ST', 'S', 'São Tomé'),
			('SV', 'AH', 'Ahuachapán'),
			('SV', 'CA', 'Cabañas'),
			('SV', 'CH', 'Chalatenango'),
			('SV', 'CU', 'Cuscatlán'),
			('SV', 'LI', 'La Libertad'),
			('SV', 'MO', 'Morazán'),
			('SV', 'PA', 'La Paz'),
			('SV', 'SA', 'Santa Ana'),
			('SV', 'SM', 'San Miguel'),
			('SV', 'SO', 'Sonsonate'),
			('SV', 'SS', 'San Salvador'),
			('SV', 'SV', 'San Vicente'),
			('SV', 'UN', 'La Unión'),
			('SV', 'US', 'Usulután'),
			('SY', 'DI', 'Dimashq'),
			('SY', 'DR', 'Dar?a'),
			('SY', 'DY', 'Dayr az Zawr'),
			('SY', 'HA', 'Al ?asakah'),
			('SY', 'HI', '?ims'),
			('SY', 'HL', '?alab'),
			('SY', 'HM', '?amah'),
			('SY', 'ID', 'Idlib'),
			('SY', 'LA', 'Al Ladhiqiyah'),
			('SY', 'QU', 'Al Qunaytirah'),
			('SY', 'RA', 'Ar Raqqah'),
			('SY', 'RD', 'Rif Dimashq'),
			('SY', 'SU', 'As Suwayda'''),
			('SY', 'TA', 'Tartus'),
			('SZ', 'HH', 'Hhohho'),
			('SZ', 'LU', 'Lubombo'),
			('SZ', 'MA', 'Manzini'),
			('SZ', 'SH', 'Shiselweni'),
			('TD', 'BA', 'Al Baṭḩah'),
			('TD', 'BG', 'Baḩr al Ghazāl'),
			('TD', 'BO', 'Būrkū'),
			('TD', 'CB', 'Shārī Bāqirmī'),
			('TD', 'EN', 'Innīdī'),
			('TD', 'GR', 'Qīrā'),
			('TD', 'HL', 'Ḥajjar Lamīs'),
			('TD', 'KA', 'Kānim'),
			('TD', 'LC', 'Al Buḩayrah'),
			('TD', 'LO', 'Lūqūn al Gharbī'),
			('TD', 'LR', 'Lūqūn ash Sharqī'),
			('TD', 'MA', 'Māndūl'),
			('TD', 'MC', 'Shārī al Awsaṭ'),
			('TD', 'ME', 'Māyū Kībbī ash Sharqī'),
			('TD', 'MO', 'Māyū Kībbī al Gharbī'),
			('TD', 'ND', 'Madīnat Injamīnā'),
			('TD', 'OD', 'Waddāy'),
			('TD', 'SA', 'Salāmāt'),
			('TD', 'SI', 'Sīlā'),
			('TD', 'TA', 'Tānjilī'),
			('TD', 'TI', 'Tibastī'),
			('TD', 'WF', 'Wādī Fīrā'),
			('TF', 'X1~', 'Ile Saint-Paul et Ile Amsterdam'),
			('TF', 'X2~', 'Crozet Islands'),
			('TF', 'X3~', 'Kerguelen'),
			('TF', 'X4~', 'Iles Eparses'),
			('TG', 'C', 'Centre'),
			('TG', 'K', 'Kara'),
			('TG', 'M', 'Maritime'),
			('TG', 'P', 'Plateaux'),
			('TG', 'S', 'Savannes'),
			('TH', '10', 'Krung Thep Maha Nakhon [Bangkok]'),
			('TH', '11', 'Samut Prakan'),
			('TH', '12', 'Nonthaburi'),
			('TH', '13', 'Pathum Thani'),
			('TH', '14', 'Phra Nakhon Si Ayutthaya'),
			('TH', '15', 'Ang Thong'),
			('TH', '16', 'Lop Buri'),
			('TH', '17', 'Sing Buri'),
			('TH', '18', 'Chai Nat'),
			('TH', '19', 'Saraburi'),
			('TH', '20', 'Chon Buri'),
			('TH', '21', 'Rayong'),
			('TH', '22', 'Chanthaburi'),
			('TH', '23', 'Trat'),
			('TH', '24', 'Chachoengsao'),
			('TH', '25', 'Prachin Buri'),
			('TH', '26', 'Nakhon Nayok'),
			('TH', '27', 'Sa Kaeo'),
			('TH', '30', 'Nakhon Ratchasima'),
			('TH', '31', 'Buri Ram'),
			('TH', '32', 'Surin'),
			('TH', '33', 'Si Sa Ket'),
			('TH', '34', 'Ubon Ratchathani'),
			('TH', '35', 'Yasothon'),
			('TH', '36', 'Chaiyaphum'),
			('TH', '37', 'Amnat Charoen'),
			('TH', '39', 'Nong Bua Lam Phu'),
			('TH', '40', 'Khon Kaen'),
			('TH', '41', 'Udon Thani'),
			('TH', '42', 'Loei'),
			('TH', '43', 'Nong Khai'),
			('TH', '44', 'Maha Sarakham'),
			('TH', '45', 'Roi Et'),
			('TH', '46', 'Kalasin'),
			('TH', '47', 'Sakon Nakhon'),
			('TH', '48', 'Nakhon Phanom'),
			('TH', '49', 'Mukdahan'),
			('TH', '50', 'Chiang Mai'),
			('TH', '51', 'Lamphun'),
			('TH', '52', 'Lampang'),
			('TH', '53', 'Uttaradit'),
			('TH', '54', 'Phrae'),
			('TH', '55', 'Nan'),
			('TH', '56', 'Phayao'),
			('TH', '57', 'Chiang Rai'),
			('TH', '58', 'Mae Hong Son'),
			('TH', '60', 'Nakhon Sawan'),
			('TH', '61', 'Uthai Thani'),
			('TH', '62', 'Kamphaeng Phet'),
			('TH', '63', 'Tak'),
			('TH', '64', 'Sukhothai'),
			('TH', '65', 'Phitsanulok'),
			('TH', '66', 'Phichit'),
			('TH', '67', 'Phetchabun'),
			('TH', '70', 'Ratchaburi'),
			('TH', '71', 'Kanchanaburi'),
			('TH', '72', 'Suphan Buri'),
			('TH', '73', 'Nakhon Pathom'),
			('TH', '74', 'Samut Sakhon'),
			('TH', '75', 'Samut Songkhram'),
			('TH', '76', 'Phetchaburi'),
			('TH', '77', 'Prachuap Khiri Khan'),
			('TH', '80', 'Nakhon Si Thammarat'),
			('TH', '81', 'Krabi'),
			('TH', '82', 'Phangnga'),
			('TH', '83', 'Phuket'),
			('TH', '84', 'Surat Thani'),
			('TH', '85', 'Ranong'),
			('TH', '86', 'Chumphon'),
			('TH', '90', 'Songkhla'),
			('TH', '91', 'Satun'),
			('TH', '92', 'Trang'),
			('TH', '93', 'Phatthalung'),
			('TH', '94', 'Pattani'),
			('TH', '95', 'Yala'),
			('TH', '96', 'Narathiwat'),
			('TH', 'S', 'Phatthaya'),
			('TJ', 'GB', 'Gorno-Badakhshan'),
			('TJ', 'KT', 'Khatlon'),
			('TJ', 'SU', 'Sughd'),
			('TJ', 'X1~', 'Dushanbe'),
			('TL', 'AL', 'Aileu'),
			('TL', 'AN', 'Ainaro'),
			('TL', 'BA', 'Baucau'),
			('TL', 'BO', 'Bobonaro'),
			('TL', 'CO', 'Cova Lima'),
			('TL', 'DI', 'Díli'),
			('TL', 'ER', 'Ermera'),
			('TL', 'LA', 'Lautem'),
			('TL', 'LI', 'Liquiça'),
			('TL', 'MF', 'Manufahi'),
			('TL', 'MT', 'Manatuto'),
			('TL', 'OE', 'Oecussi'),
			('TL', 'VI', 'Viqueque'),
			('TM', 'A', 'Ahal'),
			('TM', 'B', 'Balkan'),
			('TM', 'D', 'Dasoguz'),
			('TM', 'L', 'Lebap'),
			('TM', 'M', 'Mary'),
			('TM', 'S', 'Aşgabat'),
			('TN', '11', 'Tunis'),
			('TN', '12', 'Ariana'),
			('TN', '13', 'Ben Arous'),
			('TN', '14', 'La Manouba'),
			('TN', '21', 'Nabeul'),
			('TN', '22', 'Zaghouan'),
			('TN', '23', 'Bizerte'),
			('TN', '31', 'Béja'),
			('TN', '32', 'Jendouba'),
			('TN', '33', 'Le Kef'),
			('TN', '34', 'Siliana'),
			('TN', '41', 'Kairouan'),
			('TN', '42', 'Kasserine'),
			('TN', '43', 'Sidi Bouzid'),
			('TN', '51', 'Sousse'),
			('TN', '52', 'Monastir'),
			('TN', '53', 'Mahdia'),
			('TN', '61', 'Sfax'),
			('TN', '71', 'Gafsa'),
			('TN', '72', 'Tozeur'),
			('TN', '73', 'Kebili'),
			('TN', '81', 'Gabès'),
			('TN', '82', 'Medenine'),
			('TN', '83', 'Tataouine'),
			('TO', '01', 'Eua'),
			('TO', '02', 'Ha''apai'),
			('TO', '03', 'Niuas'),
			('TO', '04', 'Tongatapu'),
			('TO', '05', 'Vava''u'),
			('TR', '01', 'Adana'),
			('TR', '02', 'Adiyaman'),
			('TR', '03', 'Afyonkarahisar'),
			('TR', '04', 'Agri'),
			('TR', '05', 'Amasya'),
			('TR', '06', 'Ankara'),
			('TR', '07', 'Antalya'),
			('TR', '08', 'Artvin'),
			('TR', '09', 'Aydin'),
			('TR', '10', 'Balikesir'),
			('TR', '11', 'Bilecik'),
			('TR', '12', 'Bingöl'),
			('TR', '13', 'Bitlis'),
			('TR', '14', 'Bolu'),
			('TR', '15', 'Burdur'),
			('TR', '16', 'Bursa'),
			('TR', '17', 'Çanakkale'),
			('TR', '18', 'Çankiri'),
			('TR', '19', 'Çorum'),
			('TR', '20', 'Denizli'),
			('TR', '21', 'Diyarbakir'),
			('TR', '22', 'Edirne'),
			('TR', '23', 'Elazig'),
			('TR', '24', 'Erzincan'),
			('TR', '25', 'Erzurum'),
			('TR', '26', 'Eskisehir'),
			('TR', '27', 'Gaziantep'),
			('TR', '28', 'Giresun'),
			('TR', '29', 'Gümüshane'),
			('TR', '30', 'Hakkâri'),
			('TR', '31', 'Hatay'),
			('TR', '32', 'Isparta'),
			('TR', '33', 'Mersin'),
			('TR', '34', 'Istanbul'),
			('TR', '35', 'Izmir'),
			('TR', '36', 'Kars'),
			('TR', '37', 'Kastamonu'),
			('TR', '38', 'Kayseri'),
			('TR', '39', 'Kirklareli'),
			('TR', '40', 'Kirsehir'),
			('TR', '41', 'Kocaeli'),
			('TR', '42', 'Konya'),
			('TR', '43', 'Kütahya'),
			('TR', '44', 'Malatya'),
			('TR', '45', 'Manisa'),
			('TR', '46', 'Kahramanmaras'),
			('TR', '47', 'Mardin'),
			('TR', '48', 'Mugla'),
			('TR', '49', 'Mus'),
			('TR', '50', 'Nevsehir'),
			('TR', '51', 'Nigde'),
			('TR', '52', 'Ordu'),
			('TR', '53', 'Rize'),
			('TR', '54', 'Sakarya'),
			('TR', '55', 'Samsun'),
			('TR', '56', 'Siirt'),
			('TR', '57', 'Sinop'),
			('TR', '58', 'Sivas'),
			('TR', '59', 'Tekirdag'),
			('TR', '60', 'Tokat'),
			('TR', '61', 'Trabzon'),
			('TR', '62', 'Tunceli'),
			('TR', '63', 'Sanliurfa'),
			('TR', '64', 'Usak'),
			('TR', '65', 'Van'),
			('TR', '66', 'Yozgat'),
			('TR', '67', 'Zonguldak'),
			('TR', '68', 'Aksaray'),
			('TR', '69', 'Bayburt'),
			('TR', '70', 'Karaman'),
			('TR', '71', 'Kirikkale'),
			('TR', '72', 'Batman'),
			('TR', '73', 'Sirnak'),
			('TR', '74', 'Bartin'),
			('TR', '75', 'Ardahan'),
			('TR', '76', 'Igdir'),
			('TR', '77', 'Yalova'),
			('TR', '78', 'Karabük'),
			('TR', '79', 'Kilis'),
			('TR', '80', 'Osmaniye'),
			('TR', '81', 'Düzce'),
			('TT', 'ARI', 'Arima'),
			('TT', 'CHA', 'Chaguanas'),
			('TT', 'CTT', 'Couva-Tabaquite-Talparo'),
			('TT', 'DMN', 'Diego Martin'),
			('TT', 'ETO', 'Eastern Tobago'),
			('TT', 'PED', 'Penal-Debe'),
			('TT', 'POS', 'Port of Spain'),
			('TT', 'PRT', 'Princes Town'),
			('TT', 'PTF', 'Point Fortin'),
			('TT', 'RCM', 'Rio Claro-Mayaro'),
			('TT', 'SFO', 'San Fernando'),
			('TT', 'SGE', 'Sangre Grande'),
			('TT', 'SIP', 'Siparia'),
			('TT', 'SJL', 'San Juan-Laventille'),
			('TT', 'TUP', 'Tunapuna-Piarco'),
			('TT', 'WTO', 'Western Tobago'),
			('TV', 'FUN', 'Funafuti'),
			('TV', 'NIT', 'Niutao'),
			('TV', 'NIU', 'Nui'),
			('TV', 'NKF', 'Nukufetau'),
			('TV', 'NKL', 'Nukulaelae'),
			('TV', 'NMA', 'Nanumea'),
			('TV', 'NMG', 'Nanumanga'),
			('TV', 'VAI', 'Vaitupu'),
			('TW', 'CHA', 'Changhua'),
			('TW', 'CYI', 'Chiayi Municipality'),
			('TW', 'CYQ', 'Chiayi'),
			('TW', 'HSQ', 'Hsinchu'),
			('TW', 'HSZ', 'Hsinchu Municipality'),
			('TW', 'HUA', 'Hualien'),
			('TW', 'ILA', 'Ilan'),
			('TW', 'KEE', 'Keelung Municipality'),
			('TW', 'KHH', 'Kaohsiung Special Municipality'),
			('TW', 'KHQ', 'Kaohsiung'),
			('TW', 'MIA', 'Miaoli'),
			('TW', 'NAN', 'Nantou'),
			('TW', 'PEN', 'Penghu'),
			('TW', 'PIF', 'Pingtung'),
			('TW', 'TAO', 'Taoyuan'),
			('TW', 'TNN', 'Tainan Municipality'),
			('TW', 'TNQ', 'Tainan'),
			('TW', 'TPE', 'Taipei Special Municipality'),
			('TW', 'TPQ', 'Taipei'),
			('TW', 'TTT', 'Taitung'),
			('TW', 'TXG', 'Taichung Municipality'),
			('TW', 'TXQ', 'Taichung'),
			('TW', 'YUN', 'Yunlin'),
			('TZ', '01', 'Arusha'),
			('TZ', '02', 'Dar es Salaam'),
			('TZ', '03', 'Dodoma'),
			('TZ', '04', 'Iringa'),
			('TZ', '05', 'Kagera'),
			('TZ', '06', 'Kaskazini Pemba'),
			('TZ', '07', 'Kaskazini Unguja'),
			('TZ', '08', 'Kigoma'),
			('TZ', '09', 'Kilimanjaro'),
			('TZ', '10', 'Kusini Pemba'),
			('TZ', '11', 'Kusini Unguja'),
			('TZ', '12', 'Lindi'),
			('TZ', '13', 'Mara'),
			('TZ', '14', 'Mbeya'),
			('TZ', '15', 'Mjini Magharibi'),
			('TZ', '16', 'Morogoro'),
			('TZ', '17', 'Mtwara'),
			('TZ', '18', 'Mwanza'),
			('TZ', '19', 'Pwani'),
			('TZ', '20', 'Rukwa'),
			('TZ', '21', 'Ruvuma'),
			('TZ', '22', 'Shinyanga'),
			('TZ', '23', 'Singida'),
			('TZ', '24', 'Tabora'),
			('TZ', '25', 'Tanga'),
			('TZ', '26', 'Manyara'),
			('UA', '05', 'Vinnyts''ka Oblast'''),
			('UA', '07', 'Volyns''ka Oblast'''),
			('UA', '09', 'Luhans''ka Oblast'''),
			('UA', '12', 'Dnipropetrovs''ka Oblast'''),
			('UA', '14', 'Donets''ka Oblast'''),
			('UA', '18', 'Zhytomyrs''ka Oblast'''),
			('UA', '21', 'Zakarpats''ka Oblast'''),
			('UA', '23', 'Zaporiz''ka Oblast'''),
			('UA', '26', 'Ivano-Frankivs''ka Oblast'''),
			('UA', '30', 'Kyïv'),
			('UA', '32', 'Kyïvs''ka Oblast'''),
			('UA', '35', 'Kirovohrads''ka Oblast'''),
			('UA', '40', 'Sevastopol'''),
			('UA', '43', 'Respublika Krym'),
			('UA', '46', 'L''vivs''ka Oblast'''),
			('UA', '48', 'Mykolaïvs''ka Oblast'''),
			('UA', '51', 'Odes''ka Oblast'''),
			('UA', '53', 'Poltavs''ka Oblast'''),
			('UA', '56', 'Rivnens''ka Oblast'''),
			('UA', '59', 'Sums''ka Oblast'''),
			('UA', '61', 'Ternopil''s''ka Oblast'''),
			('UA', '63', 'Kharkivs''ka Oblast'''),
			('UA', '65', 'Khersons''ka Oblast'''),
			('UA', '68', 'Khmel''nyts''ka Oblast'''),
			('UA', '71', 'Cherkas''ka Oblast'''),
			('UA', '74', 'Chernihivs''ka Oblast'''),
			('UA', '77', 'Chernivets''ka Oblast'''),
			('UG', '101', 'Kalangala'),
			('UG', '102', 'Kampala'),
			('UG', '103', 'Kiboga'),
			('UG', '104', 'Luwero'),
			('UG', '105', 'Masaka'),
			('UG', '106', 'Mpigi'),
			('UG', '107', 'Mubende'),
			('UG', '108', 'Mukono'),
			('UG', '109', 'Nakasongola'),
			('UG', '110', 'Rakai'),
			('UG', '111', 'Sembabule'),
			('UG', '112', 'Kayunga'),
			('UG', '113', 'Wakiso'),
			('UG', '114', 'Mityana'),
			('UG', '115', 'Nakaseke'),
			('UG', '116', 'Lyantonde'),
			('UG', '201', 'Bugiri'),
			('UG', '202', 'Busia'),
			('UG', '203', 'Iganga'),
			('UG', '204', 'Jinja'),
			('UG', '205', 'Kamuli'),
			('UG', '206', 'Kapchorwa'),
			('UG', '207', 'Katakwi'),
			('UG', '208', 'Kumi'),
			('UG', '209', 'Mbale'),
			('UG', '210', 'Pallisa'),
			('UG', '211', 'Soroti'),
			('UG', '212', 'Tororo'),
			('UG', '213', 'Kaberamaido'),
			('UG', '214', 'Mayuge'),
			('UG', '215', 'Sironko'),
			('UG', '216', 'Amuria'),
			('UG', '217', 'Budaka'),
			('UG', '218', 'Bukwa'),
			('UG', '219', 'Butaleja'),
			('UG', '220', 'Kaliro'),
			('UG', '221', 'Manafwa'),
			('UG', '222', 'Namutumba'),
			('UG', '223', 'Bududa'),
			('UG', '224', 'Bukedea'),
			('UG', '301', 'Adjumani'),
			('UG', '302', 'Apac'),
			('UG', '303', 'Arua'),
			('UG', '304', 'Gulu'),
			('UG', '305', 'Kitgum'),
			('UG', '306', 'Kotido'),
			('UG', '307', 'Lira'),
			('UG', '308', 'Moroto'),
			('UG', '309', 'Moyo'),
			('UG', '310', 'Nebbi'),
			('UG', '311', 'Nakapiripirit'),
			('UG', '312', 'Pader'),
			('UG', '313', 'Yumbe'),
			('UG', '314', 'Amolatar'),
			('UG', '315', 'Kaabong'),
			('UG', '316', 'Koboko'),
			('UG', '317', 'Abim'),
			('UG', '318', 'Dokolo'),
			('UG', '319', 'Amuru'),
			('UG', '320', 'Maracha'),
			('UG', '321', 'Oyam'),
			('UG', '401', 'Bundibugyo'),
			('UG', '402', 'Bushenyi'),
			('UG', '403', 'Hoima'),
			('UG', '404', 'Kabale'),
			('UG', '405', 'Kabarole'),
			('UG', '406', 'Kasese'),
			('UG', '407', 'Kibaale'),
			('UG', '408', 'Kisoro'),
			('UG', '409', 'Masindi'),
			('UG', '410', 'Mbarara'),
			('UG', '411', 'Ntungamo'),
			('UG', '412', 'Rukungiri'),
			('UG', '413', 'Kamwenge'),
			('UG', '414', 'Kanungu'),
			('UG', '415', 'Kyenjojo'),
			('UG', '416', 'Ibanda'),
			('UG', '417', 'Isingiro'),
			('UG', '418', 'Kiruhura'),
			('UG', '419', 'Buliisa'),
			('UG', 'C', 'Central'),
			('UG', 'E', 'Eastern'),
			('UG', 'N', 'Northern'),
			('UG', 'W', 'Western'),
			('UM', '67', 'Johnston Atoll'),
			('UM', '71', 'Midway Islands'),
			('UM', '76', 'Navassa Island'),
			('UM', '79', 'Wake Island'),
			('UM', '81', 'Baker Island'),
			('UM', '84', 'Howland Island'),
			('UM', '86', 'Jarvis Island'),
			('UM', '89', 'Kingman Reef'),
			('UM', '95', 'Palmyra Atoll'),
			('US', 'AK', 'Alaska'),
			('US', 'AL', 'Alabama'),
			('US', 'AR', 'Arkansas'),
			('US', 'AS', 'American Samoa'),
			('US', 'AZ', 'Arizona'),
			('US', 'CA', 'California'),
			('US', 'CO', 'Colorado'),
			('US', 'CT', 'Connecticut'),
			('US', 'DC', 'District of Columbia'),
			('US', 'DE', 'Delaware'),
			('US', 'FL', 'Florida'),
			('US', 'GA', 'Georgia'),
			('US', 'GU', 'Guam'),
			('US', 'HI', 'Hawaii'),
			('US', 'IA', 'Iowa'),
			('US', 'ID', 'Idaho'),
			('US', 'IL', 'Illinois'),
			('US', 'IN', 'Indiana'),
			('US', 'KS', 'Kansas'),
			('US', 'KY', 'Kentucky'),
			('US', 'LA', 'Louisiana'),
			('US', 'MA', 'Massachusetts'),
			('US', 'MD', 'Maryland'),
			('US', 'ME', 'Maine'),
			('US', 'MI', 'Michigan'),
			('US', 'MN', 'Minnesota'),
			('US', 'MO', 'Missouri'),
			('US', 'MP', 'Northern Mariana Islands'),
			('US', 'MS', 'Mississippi'),
			('US', 'MT', 'Montana'),
			('US', 'NC', 'North Carolina'),
			('US', 'ND', 'North Dakota'),
			('US', 'NE', 'Nebraska'),
			('US', 'NH', 'New Hampshire'),
			('US', 'NJ', 'New Jersey'),
			('US', 'NM', 'New Mexico'),
			('US', 'NV', 'Nevada'),
			('US', 'NY', 'New York'),
			('US', 'OH', 'Ohio'),
			('US', 'OK', 'Oklahoma'),
			('US', 'OR', 'Oregon'),
			('US', 'PA', 'Pennsylvania'),
			('US', 'PR', 'Puerto Rico'),
			('US', 'RI', 'Rhode Island'),
			('US', 'SC', 'South Carolina'),
			('US', 'SD', 'South Dakota'),
			('US', 'TN', 'Tennessee'),
			('US', 'TX', 'Texas'),
			('US', 'UM', 'United States Minor Outlying Islands'),
			('US', 'UT', 'Utah'),
			('US', 'VA', 'Virginia'),
			('US', 'VI', 'Virgin Islands, U.S.'),
			('US', 'VT', 'Vermont'),
			('US', 'WA', 'Washington'),
			('US', 'WI', 'Wisconsin'),
			('US', 'WV', 'West Virginia'),
			('US', 'WY', 'Wyoming'),
			('UY', 'AR', 'Artigas'),
			('UY', 'DU', 'Durazno'),
			('UY', 'FD', 'Florida'),
			('UY', 'FS', 'Flores'),
			('UY', 'LA', 'Lavalleja'),
			('UY', 'MA', 'Maldonado'),
			('UY', 'MO', 'Montevideo'),
			('UY', 'PA', 'Paysandú'),
			('UY', 'RN', 'Río Negro'),
			('UY', 'RO', 'Rocha'),
			('UY', 'RV', 'Rivera'),
			('UY', 'SA', 'Salto'),
			('UY', 'SJ', 'San José'),
			('UY', 'SO', 'Soriano'),
			('UY', 'TA', 'Tacuarembó'),
			('UY', 'TT', 'Treinta y Tres'),
			('UZ', 'AN', 'Andijon'),
			('UZ', 'BU', 'Buxoro'),
			('UZ', 'FA', 'Farg‘ona'),
			('UZ', 'JI', 'Jizzax'),
			('UZ', 'NG', 'Namangan'),
			('UZ', 'NW', 'Navoiy'),
			('UZ', 'QA', 'Qashqadaryo'),
			('UZ', 'QR', 'Qoraqalpog‘iston Respublikasi'),
			('UZ', 'SA', 'Samarqand'),
			('UZ', 'SI', 'Sirdaryo'),
			('UZ', 'SU', 'Surxondaryo'),
			('UZ', 'TK', 'Toshkent City'),
			('UZ', 'TO', 'Toshkent'),
			('UZ', 'XO', 'Xorazm'),
			('VC', '01', 'Charlotte'),
			('VC', '02', 'Saint Andrew'),
			('VC', '03', 'Saint David'),
			('VC', '04', 'Saint George'),
			('VC', '05', 'Saint Patrick'),
			('VC', '06', 'Grenadines'),
			('VE', 'A', 'Distrito Federal'),
			('VE', 'B', 'Anzoátegui'),
			('VE', 'C', 'Apure'),
			('VE', 'D', 'Aragua'),
			('VE', 'E', 'Barinas'),
			('VE', 'F', 'Bolívar'),
			('VE', 'G', 'Carabobo'),
			('VE', 'H', 'Cojedes'),
			('VE', 'I', 'Falcón'),
			('VE', 'J', 'Guárico'),
			('VE', 'K', 'Lara'),
			('VE', 'L', 'Mérida'),
			('VE', 'M', 'Miranda'),
			('VE', 'N', 'Monagas'),
			('VE', 'O', 'Nueva Esparta'),
			('VE', 'P', 'Portuguesa'),
			('VE', 'R', 'Sucre'),
			('VE', 'S', 'Táchira'),
			('VE', 'T', 'Trujillo'),
			('VE', 'U', 'Yaracuy'),
			('VE', 'V', 'Zulia'),
			('VE', 'W', 'Dependencias Federales'),
			('VE', 'X', 'Vargas'),
			('VE', 'Y', 'Delta Amacuro'),
			('VE', 'Z', 'Amazonas'),
			('VN', '01', 'Lai Chau'),
			('VN', '02', 'Lao Cai'),
			('VN', '03', 'Ha Giang'),
			('VN', '04', 'Cao Bang'),
			('VN', '05', 'Son La'),
			('VN', '06', 'Yen Bai'),
			('VN', '07', 'Tuyen Quang'),
			('VN', '09', 'Lang Son'),
			('VN', '13', 'Quang Ninh'),
			('VN', '14', 'Hoa Binh'),
			('VN', '15', 'Ha Tay'),
			('VN', '18', 'Ninh Binh'),
			('VN', '20', 'Thai Binh'),
			('VN', '21', 'Thanh Hoa'),
			('VN', '22', 'Nghe An'),
			('VN', '23', 'Ha Tinh'),
			('VN', '24', 'Quang Binh'),
			('VN', '25', 'Quang Tri'),
			('VN', '26', 'Thua Thien-Hue'),
			('VN', '27', 'Quang Nam'),
			('VN', '28', 'Kon Tum'),
			('VN', '29', 'Quang Ngai'),
			('VN', '30', 'Gia Lai'),
			('VN', '31', 'Binh Dinh'),
			('VN', '32', 'Phu Yen'),
			('VN', '33', 'Dac Lac'),
			('VN', '34', 'Khanh Hoa'),
			('VN', '35', 'Lam Dong'),
			('VN', '36', 'Ninh Thuan'),
			('VN', '37', 'Tay Ninh'),
			('VN', '39', 'Dong Nai'),
			('VN', '40', 'Binh Thuan'),
			('VN', '41', 'Long An'),
			('VN', '43', 'Ba Ria-Vung Tau'),
			('VN', '44', 'An Giang'),
			('VN', '45', 'Dong Thap'),
			('VN', '46', 'Tien Giang'),
			('VN', '47', 'Kien Giang'),
			('VN', '49', 'Vinh Long'),
			('VN', '50', 'Ben Tre'),
			('VN', '51', 'Tra Vinh'),
			('VN', '52', 'Soc Trang'),
			('VN', '53', 'Bac Can'),
			('VN', '54', 'Bac Giang'),
			('VN', '55', 'Bac Lieu'),
			('VN', '56', 'Bac Ninh'),
			('VN', '57', 'Binh Duong'),
			('VN', '58', 'Binh Phuoc'),
			('VN', '59', 'Ca Mau'),
			('VN', '61', 'Hai Duong'),
			('VN', '63', 'Ha Nam'),
			('VN', '66', 'Hung Yen'),
			('VN', '67', 'Nam Dinh'),
			('VN', '68', 'Phu Tho'),
			('VN', '69', 'Thai Nguyen'),
			('VN', '70', 'Vinh Phuc'),
			('VN', '71', 'Dien Bien'),
			('VN', '72', 'Dak Nong'),
			('VN', '73', 'Hau Giang'),
			('VN', 'CT', 'Can Tho'),
			('VN', 'DN', 'Da Nang'),
			('VN', 'HN', 'Ha Noi'),
			('VN', 'HP', 'Hai Phong'),
			('VN', 'SG', 'Ho Chi Minh [Sai Gon]'),
			('VU', 'MAP', 'Malampa'),
			('VU', 'PAM', 'Pénama'),
			('VU', 'SAM', 'Sanma'),
			('VU', 'SEE', 'Shéfa'),
			('VU', 'TAE', 'Taféa'),
			('VU', 'TOB', 'Torba'),
			('WS', 'AA', 'A''ana'),
			('WS', 'AL', 'Aiga-i-le-Tai'),
			('WS', 'AT', 'Atua'),
			('WS', 'FA', 'Fa''asaleleaga'),
			('WS', 'GE', 'Gaga''emauga'),
			('WS', 'GI', 'Gagaifomauga'),
			('WS', 'PA', 'Palauli'),
			('WS', 'SA', 'Satupa''itea'),
			('WS', 'TU', 'Tuamasaga'),
			('WS', 'VF', 'Va''a-o-Fonoti'),
			('WS', 'VS', 'Vaisigano'),
			('YE', 'AB', 'Abyan'),
			('YE', 'AD', 'ʿAdan'),
			('YE', 'AM', 'Amran'),
			('YE', 'BA', 'Al Bay?a'''),
			('YE', 'DA', 'Ad Dāli‘'),
			('YE', 'DH', 'Dhamar'),
			('YE', 'HD', 'Hadramawt'),
			('YE', 'HJ', 'Hajjah'),
			('YE', 'HU', 'Al ?udaydah'),
			('YE', 'IB', 'Ibb'),
			('YE', 'JA', 'Al Jawf'),
			('YE', 'LA', 'La?ij'),
			('YE', 'MA', 'Ma''rib'),
			('YE', 'MR', 'Al Mahrah'),
			('YE', 'MW', 'Al Mahwit'),
			('YE', 'RA', 'Raymah'),
			('YE', 'SA', 'Şan‘ā'),
			('YE', 'SD', 'Sa`dah'),
			('YE', 'SH', 'Shabwah'),
			('YE', 'SN', 'Sanʿā'),
			('YE', 'TA', 'Taʿizz'),
			('ZA', 'EC', 'Eastern Cape'),
			('ZA', 'FS', 'Free State'),
			('ZA', 'GT', 'Gauteng'),
			('ZA', 'LP', 'Limpopo'),
			('ZA', 'MP', 'Mpumalanga'),
			('ZA', 'NC', 'Northern Cape'),
			('ZA', 'NL', 'Kwazulu-Natal'),
			('ZA', 'NW', 'North-West'),
			('ZA', 'WC', 'Western Cape'),
			('ZM', '01', 'Western'),
			('ZM', '02', 'Central'),
			('ZM', '03', 'Eastern'),
			('ZM', '04', 'Luapula'),
			('ZM', '05', 'Northern'),
			('ZM', '06', 'North-Western'),
			('ZM', '07', 'Southern'),
			('ZM', '08', 'Copperbelt'),
			('ZM', '09', 'Lusaka'),
			('ZW', 'BU', 'Bulawayo'),
			('ZW', 'HA', 'Harare'),
			('ZW', 'MA', 'Manicaland'),
			('ZW', 'MC', 'Mashonaland Central'),
			('ZW', 'ME', 'Mashonaland East'),
			('ZW', 'MI', 'Midlands'),
			('ZW', 'MN', 'Matabeleland North'),
			('ZW', 'MS', 'Matabeleland South'),
			('ZW', 'MV', 'Masvingo'),
			('ZW', 'MW', 'Mashonaland West');"
        );
        $statement->closeCursor();
        unset($statement);
    }
}
