<?php
$lang['Pterodactyl.name'] = 'Pterodactyl';
$lang['Pterodactyl.description'] = 'Provisions and manages game servers via the Pterodactyl panel.';
$lang['Pterodactyl.module_row'] = 'Server';
$lang['Pterodactyl.module_row_plural'] = 'Servers';
$lang['Pterodactyl.module_group'] = 'Server Group';


// Errors
$lang['Pterodactyl.!error.server_name.empty'] = 'You must enter a server name.';
$lang['Pterodactyl.!error.host_name.valid'] = 'The Hostname appears to be invalid.';
$lang['Pterodactyl.!error.account_api_key.empty'] = 'You must enter an Account API key.';
$lang['Pterodactyl.!error.account_api_key.valid'] = 'Unable to connect with the given URL and Account API key.';
$lang['Pterodactyl.!error.application_api_key.empty'] = 'You must enter an Application API key.';
$lang['Pterodactyl.!error.application_api_key.valid'] = 'Unable to connect with the given URL and Application API key.';

$lang['Pterodactyl.!error.module_row.missing'] = 'An internal error occurred. The module row is unavailable.';


// Success
$lang['Pterodactyl.!success.start'] = 'The server is now booting.';
$lang['Pterodactyl.!success.stop'] = 'The server is now shutting down.';
$lang['Pterodactyl.!success.restart'] = 'The server is now rebooting.';


// Add module row
$lang['Pterodactyl.add_row.box_title'] = 'Add Pterodactyl Server';
$lang['Pterodactyl.add_row.basic_title'] = 'Basic Settings';
$lang['Pterodactyl.add_row.add_btn'] = 'Add Server';


// Edit module row
$lang['Pterodactyl.edit_row.box_title'] = 'Edit Pterodactyl Server';
$lang['Pterodactyl.edit_row.basic_title'] = 'Basic Settings';
$lang['Pterodactyl.edit_row.add_btn'] = 'Edit Server';


// Module row meta data
$lang['Pterodactyl.row_meta.server_name'] = 'Server Label';
$lang['Pterodactyl.row_meta.host_name'] = 'Hostname';
$lang['Pterodactyl.row_meta.use_ssl'] = 'Use SSL when connecting to the API (recommended)';
$lang['Pterodactyl.row_meta.account_api_key'] = 'Account API Key';
$lang['Pterodactyl.row_meta.application_api_key'] = 'Application API Key';


// Module row tooltips
$lang['Pterodactyl.!tooltip.host_name'] = 'Enter the hostname or IP of your Pterodactyl panel. e.g. panel.domain.com';
$lang['Pterodactyl.!tooltip.account_api_key'] = 'Enter the Account API key generated for your Pterodactyl panel.';
$lang['Pterodactyl.!tooltip.application_api_key'] = 'Enter the Application API key generated for your Pterodactyl panel.';


// Module management
$lang['Pterodactyl.order_options.first'] = 'First non-full server';

$lang['Pterodactyl.add_module_row'] = 'Add Server';
$lang['Pterodactyl.add_module_group'] = 'Add Server Group';
$lang['Pterodactyl.manage.module_rows_title'] = 'Servers';
$lang['Pterodactyl.manage.module_groups_title'] = 'Server Groups';
$lang['Pterodactyl.manage.module_rows_heading.name'] = 'Server Label';
$lang['Pterodactyl.manage.module_rows_heading.host_name'] = 'Hostname';
$lang['Pterodactyl.manage.module_rows_heading.options'] = 'Options';
$lang['Pterodactyl.manage.module_groups_heading.name'] = 'Group Name';
$lang['Pterodactyl.manage.module_groups_heading.servers'] = 'Server Count';
$lang['Pterodactyl.manage.module_groups_heading.options'] = 'Options';
$lang['Pterodactyl.manage.module_rows.edit'] = 'Edit';
$lang['Pterodactyl.manage.module_groups.edit'] = 'Edit';
$lang['Pterodactyl.manage.module_rows.delete'] = 'Delete';
$lang['Pterodactyl.manage.module_groups.delete'] = 'Delete';
$lang['Pterodactyl.manage.module_rows.confirm_delete'] = 'Are you sure you want to delete this server?';
$lang['Pterodactyl.manage.module_groups.confirm_delete'] = 'Are you sure you want to delete this server group?';
$lang['Pterodactyl.manage.module_rows_no_results'] = 'There are no servers.';
$lang['Pterodactyl.manage.module_groups_no_results'] = 'There are no server groups.';

$lang['Pterodactyl.order_options.first'] = 'First Non-full Server';


// Service Info
$lang['Pterodactyl.service_info.username'] = 'Username';
$lang['Pterodactyl.service_info.password'] = 'Password';
$lang['Pterodactyl.service_info.login'] = 'Login URL';


// Tabs
$lang['Pterodactyl.tab_actions'] = 'Server Actions';
$lang['Pterodactyl.tab_client_actions'] = 'Server Actions';


// Actions Tab
$lang['Pterodactyl.tab_actions.heading_actions'] = 'Actions';
$lang['Pterodactyl.tab_actions.server_status'] = 'Server Status';

$lang['Pterodactyl.tab_actions.status_on'] = 'Online';
$lang['Pterodactyl.tab_actions.status_off'] = 'Offline';
$lang['Pterodactyl.tab_actions.status_starting'] = 'Starting';
$lang['Pterodactyl.tab_actions.status_stopping'] = 'Stopping';



// Client Actions Tab
$lang['Pterodactyl.tab_client_actions.heading_actions'] = 'Actions';
$lang['Pterodactyl.tab_client_actions.server_status'] = 'Server Status';

$lang['Pterodactyl.tab_client_actions.status_on'] = 'Online';
$lang['Pterodactyl.tab_client_actions.status_off'] = 'Offline';
$lang['Pterodactyl.tab_client_actions.status_starting'] = 'Starting';
$lang['Pterodactyl.tab_client_actions.status_stopping'] = 'Stopping';


$lang['Pterodactyl.!actions.start'] = 'Start';
$lang['Pterodactyl.!actions.stop'] = 'Stop';
$lang['Pterodactyl.!actions.restart'] = 'Restart';
