<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class PayoutsIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\Payout(array());
        $this->assertNotNull($obj);
    }
    
    public function testPayoutsList()
    {
        $fixture = $this->loadJsonFixture('payouts')->list;
        $this->stub_request($fixture);

        $service = $this->client->payouts();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->payouts;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\Payout', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->amount, $record->amount);
            $this->assertEquals($body[$num]->arrival_date, $record->arrival_date);
            $this->assertEquals($body[$num]->created_at, $record->created_at);
            $this->assertEquals($body[$num]->currency, $record->currency);
            $this->assertEquals($body[$num]->deducted_fees, $record->deducted_fees);
            $this->assertEquals($body[$num]->id, $record->id);
            $this->assertEquals($body[$num]->links, $record->links);
            $this->assertEquals($body[$num]->payout_type, $record->payout_type);
            $this->assertEquals($body[$num]->reference, $record->reference);
            $this->assertEquals($body[$num]->status, $record->status);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testPayoutsGet()
    {
        $fixture = $this->loadJsonFixture('payouts')->get;
        $this->stub_request($fixture);

        $service = $this->client->payouts();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->payouts;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\Payout', $response);

        $this->assertEquals($body->amount, $response->amount);
        $this->assertEquals($body->arrival_date, $response->arrival_date);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->deducted_fees, $response->deducted_fees);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->payout_type, $response->payout_type);
        $this->assertEquals($body->reference, $response->reference);
        $this->assertEquals($body->status, $response->status);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
