/**
 * Copyright (c) 2009 - 2010 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot  or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * jqPlot includes date instance methods and printf/sprintf functions by other authors:
 *
 * Date instance methods contained in jqplot.dateMethods.js:
 *
 *     author Ken Snyder (ken d snyder at gmail dot com)
 *     date 2008-09-10
 *     version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 *     license Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * JavaScript printf/sprintf functions contained in jqplot.sprintf.js:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(c){c.jqplot.MeterGaugeRenderer=function(){c.jqplot.LineRenderer.call(this)};c.jqplot.MeterGaugeRenderer.prototype=new c.jqplot.LineRenderer();c.jqplot.MeterGaugeRenderer.prototype.constructor=c.jqplot.MeterGaugeRenderer;c.jqplot.MeterGaugeRenderer.prototype.init=function(e){this.diameter=null;this.padding=null;this.shadowOffset=2;this.shadowAlpha=0.07;this.shadowDepth=4;this.background="#efefef";this.ringColor="#BBC6D0";this.needleColor="#C3D3E5";this.tickColor="989898";this.ringWidth=null;this.min;this.max;this.ticks=[];this.showTicks=true;this.showTickLabels=true;this.label=null;this.labelHeightAdjust=0;this.labelPosition="inside";this.intervals=[];this.intervalColors=["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"];this.intervalInnerRadius=null;this.intervalOuterRadius=null;this.tickRenderer=c.jqplot.MeterGaugeTickRenderer;this.tickPositions=[1,2,2.5,5,10];this.tickSpacing=30;this.numberMinorTicks=null;this.hubRadius=null;this.tickPadding=null;this.needleThickness=null;this.needlePad=6;this.pegNeedle=true;c.extend(true,this,e);this.type=null;this.numberTicks=null;this.tickInterval=null;this.span=180;if(this.type=="circular"){this.semiCircular=false}else{if(this.type!="circular"){this.semiCircular=true}else{this.semiCircular=(this.span<=180)?true:false}}this._tickPoints=[];this._labelElm=null;this.startAngle=(90+(360-this.span)/2)*Math.PI/180;this.endAngle=(90-(360-this.span)/2)*Math.PI/180;this.setmin=!!(this.min==null);this.setmax=!!(this.max==null);if(this.intervals.length){if(this.intervals[0].length==null||this.intervals.length==1){for(var f=0;f<this.intervals.length;f++){this.intervals[f]=[this.intervals[f],this.intervals[f],this.intervalColors[f]]}}else{if(this.intervals[0].length==2){for(f=0;f<this.intervals.length;f++){this.intervals[f]=[this.intervals[f][0],this.intervals[f][1],this.intervalColors[f]]}}}}if(this.ticks.length){if(this.ticks[0].length==null||this.ticks[0].length==1){for(var f=0;f<this.ticks.length;f++){this.ticks[f]=[this.ticks[f],this.ticks[f]]}}this.min=(this.min==null)?this.ticks[0][0]:this.min;this.max=(this.max==null)?this.ticks[this.ticks.length-1][0]:this.max;this.setmin=false;this.setmax=false;this.numberTicks=this.ticks.length;this.tickInterval=this.ticks[1][0]-this.ticks[0][0];this.tickFactor=Math.floor(parseFloat((Math.log(this.tickInterval)/Math.log(10)).toFixed(11)));this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}if(!this.numberMinorTicks){this.numberMinorTicks=1}}else{if(this.intervals.length){this.min=(this.min==null)?0:this.min;this.setmin=false;if(this.max==null){if(this.intervals[this.intervals.length-1][0]>=this.data[0][1]){this.max=this.intervals[this.intervals.length-1][0];this.setmax=false}}else{this.setmax=false}}else{this.min=(this.min==null)?0:this.min;this.setmin=false;if(this.max==null){this.max=this.data[0][1]*1.25;this.setmax=true}else{this.setmax=false}}}};c.jqplot.MeterGaugeRenderer.prototype.setGridData=function(j){var f=[];var k=[];var e=this.startAngle;for(var h=0;h<this.data.length;h++){f.push(this.data[h][1]);k.push([this.data[h][0]]);if(h>0){f[h]+=f[h-1]}}var g=Math.PI*2/f[f.length-1];for(var h=0;h<f.length;h++){k[h][1]=f[h]*g}this.gridData=k};c.jqplot.MeterGaugeRenderer.prototype.makeGridData=function(j,k){var f=[];var l=[];var e=this.startAngle;for(var h=0;h<j.length;h++){f.push(j[h][1]);l.push([j[h][0]]);if(h>0){f[h]+=f[h-1]}}var g=Math.PI*2/f[f.length-1];for(var h=0;h<f.length;h++){l[h][1]=f[h]*g}return l};function b(h,f,g){var e;for(i=h.length-1;i>=0;i--){e=f/(h[i]*Math.pow(10,g));if(e==4||e==5){return e-1}}return null}c.jqplot.MeterGaugeRenderer.prototype.draw=function(V,ay,am){var X;var aF=(am!=undefined)?am:{};var ag=0;var af=0;var ap=1;if(am.legendInfo&&am.legendInfo.placement=="inside"){var aC=am.legendInfo;switch(aC.location){case"nw":ag=aC.width+aC.xoffset;break;case"w":ag=aC.width+aC.xoffset;break;case"sw":ag=aC.width+aC.xoffset;break;case"ne":ag=aC.width+aC.xoffset;ap=-1;break;case"e":ag=aC.width+aC.xoffset;ap=-1;break;case"se":ag=aC.width+aC.xoffset;ap=-1;break;case"n":af=aC.height+aC.yoffset;break;case"s":af=aC.height+aC.yoffset;ap=-1;break;default:break}}if(this.label){this._labelElem=c('<div class="jqplot-meterGauge-label" style="position:absolute;">'+this.label+"</div>");this.canvas._elem.after(this._labelElem)}var k=(aF.shadow!=undefined)?aF.shadow:this.shadow;var L=(aF.showLine!=undefined)?aF.showLine:this.showLine;var H=(aF.fill!=undefined)?aF.fill:this.fill;var J=V.canvas.width;var Q=V.canvas.height;if(this.padding==null){this.padding=Math.round(Math.min(J,Q)/30)}var O=J-ag-2*this.padding;var Z=Q-af-2*this.padding;if(this.labelPosition=="bottom"&&this.label){Z-=this._labelElem.outerHeight(true)}var K=Math.min(O,Z);var ab=K;if(!this.diameter){if(this.semiCircular){if(O>=2*Z){if(!this.ringWidth){this.ringWidth=2*Z/35}this.needleThickness=this.needleThickness||2+Math.pow(this.ringWidth,0.8);this.innerPad=this.ringWidth/2+this.needleThickness/2+this.needlePad;this.diameter=2*(Z-2*this.innerPad)}else{if(!this.ringWidth){this.ringWidth=O/35}this.needleThickness=this.needleThickness||2+Math.pow(this.ringWidth,0.8);this.innerPad=this.ringWidth/2+this.needleThickness/2+this.needlePad;this.diameter=O-2*this.innerPad}this._center=[(J-ap*ag)/2+ap*ag,(Q+ap*af-this.padding-this.ringWidth-this.innerPad)]}else{if(!this.ringWidth){this.ringWidth=ab/35}this.needleThickness=this.needleThickness||2+Math.pow(this.ringWidth,0.8);this.innerPad=0;this.diameter=ab-this.ringWidth;this._center=[(J-ap*ag)/2+ap*ag,(Q-ap*af)/2+ap*af]}}if(this._labelElem&&this.labelPosition=="bottom"){this._center[1]-=this._labelElem.outerHeight(true)}this._radius=this.diameter/2;this.tickSpacing=6000/this.diameter;if(!this.hubRadius){this.hubRadius=this.diameter/18}this.shadowOffset=0.5+this.ringWidth/9;this.shadowWidth=this.ringWidth*1;this.tickPadding=3+Math.pow(this.diameter/20,0.7);this.tickOuterRadius=this._radius-this.ringWidth/2-this.tickPadding;this.tickLength=(this.showTicks)?this._radius/13:0;if(this.ticks.length==0){var z=this.max,aE=this.min,p=this.setmax,aB=this.setmin,aq=(z-aE)*this.tickSpacing/this.span;var ar=Math.floor(parseFloat((Math.log(aq)/Math.log(10)).toFixed(11)));var al=(aq/Math.pow(10,ar));(al>2&&al<=2.5)?al=2.5:al=Math.ceil(al);var R=this.tickPositions;var aw,ai;for(X=0;X<R.length;X++){if(al==R[X]||X&&R[X-1]<al&&al<R[X]){aq=R[X]*Math.pow(10,ar);aw=X}}for(X=0;X<R.length;X++){if(al==R[X]||X&&R[X-1]<al&&al<R[X]){aq=R[X]*Math.pow(10,ar);ai=Math.ceil((z-aE)/aq)}}if(p&&aB){var aI=(aE>0)?aE-aE%aq:aE-aE%aq-aq;if(!this.forceZero){var C=Math.min(aE-aI,0.8*aq);var n=Math.floor(C/R[aw]);if(n>1){aI=aI+R[aw]*(n-1);if(parseInt(aI,10)!=aI&&parseInt(aI-R[aw],10)==aI-R[aw]){aI=aI-R[aw]}}}if(aE==aI){aE-=aq}else{if(aE-aI>0.23*aq){aE=aI}else{aE=aI-aq;ai+=1}}ai+=1;var D=aE+(ai-1)*aq;if(z>=D){D+=aq;ai+=1}if(D-z<0.23*aq){D+=aq;ai+=1}this.max=z=D;this.min=aE;this.tickInterval=aq;this.numberTicks=ai;var M;for(X=0;X<ai;X++){M=parseFloat((aE+X*aq).toFixed(11));this.ticks.push([M,M])}this.max=this.ticks[ai-1][1];this.tickFactor=ar;this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}}else{if(p){var D=aE+(ai-1)*aq;if(z>=D){z=D+aq;ai+=1}else{z=D}this.tickInterval=this.tickInterval||aq;this.numberTicks=this.numberTicks||ai;var M;for(X=0;X<this.numberTicks;X++){M=parseFloat((aE+X*this.tickInterval).toFixed(11));this.ticks.push([M,M])}this.max=this.ticks[this.numberTicks-1][1];this.tickFactor=ar;this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}}}if(!p&&!aB){var N=this.max-this.min;ar=Math.floor(parseFloat((Math.log(N)/Math.log(10)).toFixed(11)))-1;var aG=[5,6,4,7,3],T,B;for(X=0;X<aG.length;X++){T=N/(aG[X]-1)/Math.pow(10,ar);if(T==parseInt(T,10)){this.numberTicks=aG[X];this.tickInterval=N/(this.numberTicks-1);this.tickFactor=ar+1;break}}var M;for(X=0;X<this.numberTicks;X++){M=parseFloat((this.min+X*this.tickInterval).toFixed(11));this.ticks.push([M,M])}this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}if(!this.numberMinorTicks){this.numberMinorTicks=1}}}var S=this._radius,aA=this.startAngle,g=this.endAngle,G=Math.PI,e=Math.PI/2;if(this.semiCircular){var x=Math.atan(this.innerPad/S),aa=this.outerStartAngle=aA-x,ax=this.outerEndAngle=g+x,A=this.hubStartAngle=aA-Math.atan(this.innerPad/this.hubRadius*2),ad=this.hubEndAngle=g+Math.atan(this.innerPad/this.hubRadius*2);V.save();V.translate(this._center[0],this._center[1]);V.lineJoin="round";V.lineCap="round";V.save();V.beginPath();V.fillStyle=this.background;V.arc(0,0,S,aa,ax,false);V.closePath();V.fill();V.restore();var ah="rgba(0,0,0,"+this.shadowAlpha+")";V.save();for(var X=0;X<this.shadowDepth;X++){V.translate(this.shadowOffset*Math.cos(this.shadowAngle/180*Math.PI),this.shadowOffset*Math.sin(this.shadowAngle/180*Math.PI));V.beginPath();V.strokeStyle=ah;V.lineWidth=this.shadowWidth;V.arc(0,0,S,aa,ax,false);V.closePath();V.stroke()}V.restore();V.save();var av=parseInt((this.shadowDepth+1)/2,10);for(var X=0;X<av;X++){V.translate(this.shadowOffset*Math.cos(this.shadowAngle/180*Math.PI),this.shadowOffset*Math.sin(this.shadowAngle/180*Math.PI));V.beginPath();V.fillStyle=ah;V.arc(0,0,this.hubRadius,A,ad,false);V.closePath();V.fill()}V.restore();V.save();V.beginPath();V.strokeStyle=this.ringColor;V.lineWidth=this.ringWidth;V.arc(0,0,S,aa,ax,false);V.closePath();V.stroke();V.restore();V.save();V.beginPath();V.fillStyle=this.ringColor;V.arc(0,0,this.hubRadius,A,ad,false);V.closePath();V.fill();V.restore();if(this.showTicks){V.save();var f=this.tickOuterRadius,an=this.tickLength,u=an/2,E=this.numberMinorTicks,ak=this.span*Math.PI/180/(this.ticks.length-1),o=ak/(E+1);for(X=0;X<this.ticks.length;X++){V.beginPath();V.lineWidth=1.5+this.diameter/360;V.strokeStyle=this.ringColor;var ac=ak*X+aA;V.moveTo(-f*Math.cos(ak*X+aA),f*Math.sin(ak*X+aA));V.lineTo(-(f-an)*Math.cos(ak*X+aA),(f-an)*Math.sin(ak*X+aA));this._tickPoints.push([(f-an)*Math.cos(ak*X+aA)+this._center[0]+this.canvas._offsets.left,(f-an)*Math.sin(ak*X+aA)+this._center[1]+this.canvas._offsets.top,ak*X+aA]);V.stroke();V.lineWidth=1+this.diameter/440;if(X<this.ticks.length-1){for(var W=1;W<=E;W++){V.beginPath();V.moveTo(-f*Math.cos(ak*X+o*W+aA),f*Math.sin(ak*X+o*W+aA));V.lineTo(-(f-u)*Math.cos(ak*X+o*W+aA),(f-u)*Math.sin(ak*X+o*W+aA));V.stroke()}}}V.restore()}if(this.showTickLabels){var I,U,R,aH,F,m=0;var al=this.tickPadding*(1-1/(this.diameter/80+1));for(X=0;X<this.ticks.length;X++){I=c('<div class="jqplot-meterGauge-tick" style="position:absolute;">'+this.ticks[X][1]+"</div>");this.canvas._elem.after(I);aH=I.outerWidth(true);eh=I.outerHeight(true);U=this._tickPoints[X][0]-aH*(this._tickPoints[X][2]-Math.PI)/Math.PI-al*Math.cos(this._tickPoints[X][2]);R=this._tickPoints[X][1]-eh/2+eh/2*Math.pow(Math.abs((Math.sin(this._tickPoints[X][2]))),0.5)+al/3*Math.pow(Math.abs((Math.sin(this._tickPoints[X][2]))),0.5);I.css({left:U,top:R});F=aH*Math.cos(this._tickPoints[X][2])+eh*Math.sin(Math.PI/2+this._tickPoints[X][2]/2);m=(F>m)?F:m}}if(this.label&&this.labelPosition=="inside"){var U=this._center[0]+this.canvas._offsets.left;var al=this.tickPadding*(1-1/(this.diameter/80+1));var R=0.5*(this._center[1]+this.canvas._offsets.top-this.hubRadius)+0.5*(this._center[1]+this.canvas._offsets.top-this.tickOuterRadius+this.tickLength+al)+this.labelHeightAdjust;U-=this._labelElem.outerWidth(true)/2;R-=this._labelElem.outerHeight(true)/2;this._labelElem.css({left:U,top:R})}else{if(this.label&&this.labelPosition=="bottom"){var U=this._center[0]+this.canvas._offsets.left-this._labelElem.outerWidth(true)/2;var R=this._center[1]+this.canvas._offsets.top+this.innerPad+ +this.ringWidth+this.padding+this.labelHeightAdjust;this._labelElem.css({left:U,top:R})}}V.save();var at=this.intervalInnerRadius||this.hubRadius*1.5;if(this.intervalOuterRadius==null){if(this.showTickLabels){var ae=(this.tickOuterRadius-this.tickLength-this.tickPadding-this.diameter/8)}else{var ae=(this.tickOuterRadius-this.tickLength-this.diameter/16)}}else{var ae=this.intervalOuterRadius}var N=this.max-this.min;var az=this.intervals[this.intervals.length-1]-this.min;var y,Y,s=this.span*Math.PI/180;for(X=0;X<this.intervals.length;X++){y=(X==0)?aA:aA+(this.intervals[X-1][0]-this.min)*s/N;if(y<0){y=0}Y=aA+(this.intervals[X][0]-this.min)*s/N;if(Y<0){Y=0}V.beginPath();V.fillStyle=this.intervals[X][2];V.arc(0,0,at,y,Y,false);V.lineTo(ae*Math.cos(Y),ae*Math.sin(Y));V.arc(0,0,ae,Y,y,true);V.lineTo(at*Math.cos(y),at*Math.sin(y));V.closePath();V.fill()}V.restore();var au=this.data[0][1];var P=this.max-this.min;if(this.pegNeedle){if(this.data[0][1]>this.max+P*3/this.span){au=this.max+P*3/this.span}if(this.data[0][1]<this.min-P*3/this.span){au=this.min-P*3/this.span}}var aj=(au-this.min)/P*this.span*Math.PI/180+this.startAngle;V.save();V.beginPath();V.fillStyle=this.ringColor;V.strokeStyle=this.ringColor;this.needleLength=(this.tickOuterRadius-this.tickLength)*0.85;this.needleThickness=(this.needleThickness<2)?2:this.needleThickness;var aD=this.needleThickness*0.4;var v=this.needleLength/10;var q=(this.needleThickness-aD)/10;var ao;for(var X=0;X<10;X++){ao=this.needleThickness-X*q;V.moveTo(v*X*Math.cos(aj),v*X*Math.sin(aj));V.lineWidth=ao;V.lineTo(v*(X+1)*Math.cos(aj),v*(X+1)*Math.sin(aj));V.stroke()}V.restore()}else{this._center=[(J-ap*ag)/2+ap*ag,(Q-ap*af)/2+ap*af]}};c.jqplot.MeterGaugeAxisRenderer=function(){c.jqplot.LinearAxisRenderer.call(this)};c.jqplot.MeterGaugeAxisRenderer.prototype=new c.jqplot.LinearAxisRenderer();c.jqplot.MeterGaugeAxisRenderer.prototype.constructor=c.jqplot.MeterGaugeAxisRenderer;c.jqplot.MeterGaugeAxisRenderer.prototype.init=function(e){this.tickRenderer=c.jqplot.MeterGaugeTickRenderer;c.extend(true,this,e);this._dataBounds={min:0,max:100};this.min=0;this.max=100;this.showTicks=false;this.ticks=[];this.showMark=false;this.show=false};c.jqplot.MeterGaugeLegendRenderer=function(){c.jqplot.TableLegendRenderer.call(this)};c.jqplot.MeterGaugeLegendRenderer.prototype=new c.jqplot.TableLegendRenderer();c.jqplot.MeterGaugeLegendRenderer.prototype.constructor=c.jqplot.MeterGaugeLegendRenderer;c.jqplot.MeterGaugeLegendRenderer.prototype.init=function(e){this.numberRows=null;this.numberColumns=null;c.extend(true,this,e)};c.jqplot.MeterGaugeLegendRenderer.prototype.draw=function(){var g=this;if(this.show){var p=this._series;var t="position:absolute;";t+=(this.background)?"background:"+this.background+";":"";t+=(this.border)?"border:"+this.border+";":"";t+=(this.fontSize)?"font-size:"+this.fontSize+";":"";t+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";t+=(this.textColor)?"color:"+this.textColor+";":"";t+=(this.marginTop!=null)?"margin-top:"+this.marginTop+";":"";t+=(this.marginBottom!=null)?"margin-bottom:"+this.marginBottom+";":"";t+=(this.marginLeft!=null)?"margin-left:"+this.marginLeft+";":"";t+=(this.marginRight!=null)?"margin-right:"+this.marginRight+";":"";this._elem=c('<table class="jqplot-table-legend" style="'+t+'"></table>');var x=false,o=false,e,m;var q=p[0];if(q.show){var y=q.data;if(this.numberRows){e=this.numberRows;if(!this.numberColumns){m=Math.ceil(y.length/e)}else{m=this.numberColumns}}else{if(this.numberColumns){m=this.numberColumns;e=Math.ceil(y.length/this.numberColumns)}else{e=y.length;m=1}}var w,v,f,k,h,l,n,u;var r=0;for(w=0;w<e;w++){if(o){f=c('<tr class="jqplot-table-legend"></tr>').prependTo(this._elem)}else{f=c('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem)}for(v=0;v<m;v++){if(r<y.length){l=this.labels[r]||y[r][0].toString();u=colorGenerator.next();if(!o){if(w>0){x=true}else{x=false}}else{if(w==e-1){x=false}else{x=true}}n=(x)?this.rowSpacing:"0";k=c('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+n+';"><div><div class="jqplot-table-legend-swatch" style="border-color:'+u+';"></div></div></td>');h=c('<td class="jqplot-table-legend" style="padding-top:'+n+';"></td>');if(this.escapeHtml){h.text(l)}else{h.html(l)}if(o){h.prependTo(f);k.prependTo(f)}else{k.appendTo(f);h.appendTo(f)}x=true}r++}}}}return this._elem};function a(j,h,f){f=f||{};f.axesDefaults=f.axesDefaults||{};f.legend=f.legend||{};f.seriesDefaults=f.seriesDefaults||{};f.grid=f.grid||{};f.gridPadding=f.gridPadding||{};var e=false;if(f.seriesDefaults.renderer==c.jqplot.MeterGaugeRenderer){e=true}else{if(f.series){for(var g=0;g<f.series.length;g++){if(f.series[g].renderer==c.jqplot.MeterGaugeRenderer){e=true}}}}if(e){f.axesDefaults.renderer=c.jqplot.MeterGaugeAxisRenderer;f.legend.renderer=c.jqplot.MeterGaugeLegendRenderer;f.legend.preDraw=true;f.grid.background=f.grid.background||"white";f.grid.drawGridlines=false;f.grid.borderWidth=(f.grid.borderWidth!=null)?f.grid.borderWidth:0;f.grid.shadow=(f.grid.shadow!=null)?f.grid.shadow:false;f.gridPadding.top=(f.gridPadding.top!=null)?f.gridPadding.top:0;f.gridPadding.bottom=(f.gridPadding.bottom!=null)?f.gridPadding.bottom:0;f.gridPadding.left=(f.gridPadding.left!=null)?f.gridPadding.left:0;f.gridPadding.right=(f.gridPadding.right!=null)?f.gridPadding.right:0}}function d(e){}c.jqplot.preInitHooks.push(a);c.jqplot.postParseOptionsHooks.push(d);c.jqplot.MeterGaugeTickRenderer=function(){c.jqplot.AxisTickRenderer.call(this)};c.jqplot.MeterGaugeTickRenderer.prototype=new c.jqplot.AxisTickRenderer();c.jqplot.MeterGaugeTickRenderer.prototype.constructor=c.jqplot.MeterGaugeTickRenderer})(jQuery);