/**
 * Copyright (c) 2009 - 2010 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot  or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * jqPlot includes date instance methods and printf/sprintf functions by other authors:
 *
 * Date instance methods contained in jqplot.dateMethods.js:
 *
 *     author Ken Snyder (ken d snyder at gmail dot com)
 *     date 2008-09-10
 *     version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 *     license Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * JavaScript printf/sprintf functions contained in jqplot.sprintf.js:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(B){var l;B.jqplot=function(W,T,R){var S,Q;if(R==null){if(T instanceof Array){S=T;Q=null}else{if(T.constructor==Object){S=null;Q=T}}}else{S=T;Q=R}var V=new F();B("#"+W).removeClass("jqplot-error");if(B.jqplot.config.catchErrors){try{V.init(W,S,Q);V.draw();V.themeEngine.init.call(V);return V}catch(U){var X=B.jqplot.config.errorMessage||U.message;B("#"+W).append('<div class="jqplot-error-message">'+X+"</div>");B("#"+W).addClass("jqplot-error");document.getElementById(W).style.background=B.jqplot.config.errorBackground;document.getElementById(W).style.border=B.jqplot.config.errorBorder;document.getElementById(W).style.fontFamily=B.jqplot.config.errorFontFamily;document.getElementById(W).style.fontSize=B.jqplot.config.errorFontSize;document.getElementById(W).style.fontStyle=B.jqplot.config.errorFontStyle;document.getElementById(W).style.fontWeight=B.jqplot.config.errorFontWeight}}else{V.init(W,S,Q);V.draw();V.themeEngine.init.call(V);return V}};B.jqplot.debug=1;B.jqplot.config={debug:1,enablePlugins:false,defaultHeight:300,defaultWidth:400,UTCAdjust:false,timezoneOffset:new Date(new Date().getTimezoneOffset()*60000),errorMessage:"",errorBackground:"",errorBorder:"",errorFontFamily:"",errorFontSize:"",errorFontStyle:"",errorFontWeight:"",catchErrors:false,defaultTickFormatString:"%.1f"};B.jqplot.enablePlugins=B.jqplot.config.enablePlugins;B.jqplot.preInitHooks=[];B.jqplot.postInitHooks=[];B.jqplot.preParseOptionsHooks=[];B.jqplot.postParseOptionsHooks=[];B.jqplot.preDrawHooks=[];B.jqplot.postDrawHooks=[];B.jqplot.preDrawSeriesHooks=[];B.jqplot.postDrawSeriesHooks=[];B.jqplot.preDrawLegendHooks=[];B.jqplot.addLegendRowHooks=[];B.jqplot.preSeriesInitHooks=[];B.jqplot.postSeriesInitHooks=[];B.jqplot.preParseSeriesOptionsHooks=[];B.jqplot.postParseSeriesOptionsHooks=[];B.jqplot.eventListenerHooks=[];B.jqplot.preDrawSeriesShadowHooks=[];B.jqplot.postDrawSeriesShadowHooks=[];B.jqplot.ElemContainer=function(){this._elem;this._plotWidth;this._plotHeight;this._plotDimensions={height:null,width:null}};B.jqplot.ElemContainer.prototype.createElement=function(T,V,R,S,W){this._offsets=V;var Q=R||"jqplot";var U=document.createElement(T);this._elem=B(U);this._elem.addClass(Q);this._elem.css(S);this._elem.attr(W);return this._elem};B.jqplot.ElemContainer.prototype.getWidth=function(){if(this._elem){return this._elem.outerWidth(true)}else{return null}};B.jqplot.ElemContainer.prototype.getHeight=function(){if(this._elem){return this._elem.outerHeight(true)}else{return null}};B.jqplot.ElemContainer.prototype.getPosition=function(){if(this._elem){return this._elem.position()}else{return{top:null,left:null,bottom:null,right:null}}};B.jqplot.ElemContainer.prototype.getTop=function(){return this.getPosition().top};B.jqplot.ElemContainer.prototype.getLeft=function(){return this.getPosition().left};B.jqplot.ElemContainer.prototype.getBottom=function(){return this._elem.css("bottom")};B.jqplot.ElemContainer.prototype.getRight=function(){return this._elem.css("right")};function o(Q){B.jqplot.ElemContainer.call(this);this.name=Q;this._series=[];this.show=false;this.tickRenderer=B.jqplot.AxisTickRenderer;this.tickOptions={};this.labelRenderer=B.jqplot.AxisLabelRenderer;this.labelOptions={};this.label=null;this.showLabel=true;this.min=null;this.max=null;this.autoscale=false;this.pad=1.2;this.padMax=null;this.padMin=null;this.ticks=[];this.numberTicks;this.tickInterval;this.renderer=B.jqplot.LinearAxisRenderer;this.rendererOptions={};this.showTicks=true;this.showTickMarks=true;this.showMinorTicks=true;this.useSeriesColor=false;this.borderWidth=null;this.borderColor=null;this._dataBounds={min:null,max:null};this._offsets={min:null,max:null};this._ticks=[];this._label=null;this.syncTicks=null;this.tickSpacing=75;this._min=null;this._max=null;this._tickInterval=null;this._numberTicks=null;this.__ticks=null}o.prototype=new B.jqplot.ElemContainer();o.prototype.constructor=o;o.prototype.init=function(){this.renderer=new this.renderer();this.tickOptions.axis=this.name;if(this.label==null||this.label==""){this.showLabel=false}else{this.labelOptions.label=this.label}if(this.showLabel==false){this.labelOptions.show=false}if(this.pad==0){this.pad=1}if(this.padMax==0){this.padMax=1}if(this.padMin==0){this.padMin=1}if(this.padMax==null){this.padMax=(this.pad-1)/2+1}if(this.padMin==null){this.padMin=(this.pad-1)/2+1}this.pad=this.padMax+this.padMin-1;if(this.min!=null||this.max!=null){this.autoscale=false}if(this.syncTicks==null&&this.name.indexOf("y")>-1){this.syncTicks=true}else{if(this.syncTicks==null){this.syncTicks=false}}this.renderer.init.call(this,this.rendererOptions)};o.prototype.draw=function(Q){return this.renderer.draw.call(this,Q)};o.prototype.set=function(){this.renderer.set.call(this)};o.prototype.pack=function(R,Q){if(this.show){this.renderer.pack.call(this,R,Q)}if(this._min==null){this._min=this.min;this._max=this.max;this._tickInterval=this.tickInterval;this._numberTicks=this.numberTicks;this.__ticks=this._ticks}};o.prototype.reset=function(){this.renderer.reset.call(this)};o.prototype.resetScale=function(){this.min=null;this.max=null;this.numberTicks=null;this.tickInterval=null};function g(Q){B.jqplot.ElemContainer.call(this);this.show=false;this.location="ne";this.labels=[];this.showLabels=true;this.showSwatches=true;this.placement="insideGrid";this.xoffset=0;this.yoffset=0;this.border;this.background;this.textColor;this.fontFamily;this.fontSize;this.rowSpacing="0.5em";this.renderer=B.jqplot.TableLegendRenderer;this.rendererOptions={};this.preDraw=false;this.marginTop=null;this.marginRight=null;this.marginBottom=null;this.marginLeft=null;this.escapeHtml=false;this._series=[];B.extend(true,this,Q)}g.prototype=new B.jqplot.ElemContainer();g.prototype.constructor=g;g.prototype.setOptions=function(Q){B.extend(true,this,Q);if(this.placement=="inside"){this.placement="insideGrid"}if(this.xoffset>0){if(this.placement=="insideGrid"){switch(this.location){case"nw":case"w":case"sw":if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break;case"ne":case"e":case"se":default:if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break}}else{if(this.placement=="outside"){switch(this.location){case"nw":case"w":case"sw":if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break;case"ne":case"e":case"se":default:if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break}}}this.xoffset=0}if(this.yoffset>0){if(this.placement=="outside"){switch(this.location){case"sw":case"s":case"se":if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break;case"ne":case"n":case"nw":default:if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break}}else{if(this.placement=="insideGrid"){switch(this.location){case"sw":case"s":case"se":if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break;case"ne":case"n":case"nw":default:if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break}}}this.yoffset=0}};g.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};g.prototype.draw=function(R){for(var Q=0;Q<B.jqplot.preDrawLegendHooks.length;Q++){B.jqplot.preDrawLegendHooks[Q].call(this,R)}return this.renderer.draw.call(this,R)};g.prototype.pack=function(Q){this.renderer.pack.call(this,Q)};function p(Q){B.jqplot.ElemContainer.call(this);this.text=Q;this.show=true;this.fontFamily;this.fontSize;this.textAlign;this.textColor;this.renderer=B.jqplot.DivTitleRenderer;this.rendererOptions={}}p.prototype=new B.jqplot.ElemContainer();p.prototype.constructor=p;p.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};p.prototype.draw=function(Q){return this.renderer.draw.call(this,Q)};p.prototype.pack=function(){this.renderer.pack.call(this)};function G(){B.jqplot.ElemContainer.call(this);this.show=true;this.xaxis="xaxis";this._xaxis;this.yaxis="yaxis";this._yaxis;this.gridBorderWidth=2;this.renderer=B.jqplot.LineRenderer;this.rendererOptions={};this.data=[];this.gridData=[];this.label="";this.showLabel=true;this.color;this.lineWidth=2.5;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.25;this.shadowDepth=3;this.shadowAlpha="0.1";this.breakOnNull=false;this.markerRenderer=B.jqplot.MarkerRenderer;this.markerOptions={};this.showLine=true;this.showMarker=true;this.index;this.fill=false;this.fillColor;this.fillAlpha;this.fillAndStroke=false;this.disableStack=false;this._stack=false;this.neighborThreshold=4;this.fillToZero=false;this.fillToValue=0;this.fillAxis="y";this.useNegativeColors=true;this._stackData=[];this._plotData=[];this._plotValues={x:[],y:[]};this._intervals={x:{},y:{}};this._prevPlotData=[];this._prevGridData=[];this._stackAxis="y";this._primaryAxis="_xaxis";this.canvas=new B.jqplot.GenericCanvas();this.shadowCanvas=new B.jqplot.GenericCanvas();this.plugins={};this._sumy=0;this._sumx=0}G.prototype=new B.jqplot.ElemContainer();G.prototype.constructor=G;G.prototype.init=function(S,W,U){this.index=S;this.gridBorderWidth=W;var V=this.data;var R=[],T;for(T=0;T<V.length;T++){if(!this.breakOnNull){if(V[T]==null||V[T][0]==null||V[T][1]==null){continue}else{R.push(V[T])}}else{R.push(V[T])}}this.data=R;if(!this.fillColor){this.fillColor=this.color}if(this.fillAlpha){var Q=B.jqplot.normalize2rgb(this.fillColor);var Q=B.jqplot.getColorComponents(Q);this.fillColor="rgba("+Q[0]+","+Q[1]+","+Q[2]+","+this.fillAlpha+")"}this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions,U);this.markerRenderer=new this.markerRenderer();if(!this.markerOptions.color){this.markerOptions.color=this.color}if(this.markerOptions.show==null){this.markerOptions.show=this.showMarker}this.showMarker=this.markerOptions.show;this.markerRenderer.init(this.markerOptions)};G.prototype.draw=function(W,T,V){var R=(T==l)?{}:T;W=(W==l)?this.canvas._ctx:W;for(var Q=0;Q<B.jqplot.preDrawSeriesHooks.length;Q++){B.jqplot.preDrawSeriesHooks[Q].call(this,W,R)}if(this.show){this.renderer.setGridData.call(this,V);if(!R.preventJqPlotSeriesDrawTrigger){B(W.canvas).trigger("jqplotSeriesDraw",[this.data,this.gridData])}var U=[];if(R.data){U=R.data}else{if(!this._stack){U=this.data}else{U=this._plotData}}var S=R.gridData||this.renderer.makeGridData.call(this,U,V);this.renderer.draw.call(this,W,S,R,V)}for(var Q=0;Q<B.jqplot.postDrawSeriesHooks.length;Q++){B.jqplot.postDrawSeriesHooks[Q].call(this,W,R)}};G.prototype.drawShadow=function(W,T,V){var R=(T==l)?{}:T;W=(W==l)?this.shadowCanvas._ctx:W;for(var Q=0;Q<B.jqplot.preDrawSeriesShadowHooks.length;Q++){B.jqplot.preDrawSeriesShadowHooks[Q].call(this,W,R)}if(this.shadow){this.renderer.setGridData.call(this,V);var U=[];if(R.data){U=R.data}else{if(!this._stack){U=this.data}else{U=this._plotData}}var S=R.gridData||this.renderer.makeGridData.call(this,U,V);this.renderer.drawShadow.call(this,W,S,R)}for(var Q=0;Q<B.jqplot.postDrawSeriesShadowHooks.length;Q++){B.jqplot.postDrawSeriesShadowHooks[Q].call(this,W,R)}};G.prototype.toggleDisplay=function(R){var Q,S;if(R.data.series){Q=R.data.series}else{Q=this}if(R.data.speed){S=R.data.speed}if(S){if(Q.canvas._elem.is(":hidden")){if(Q.shadowCanvas._elem){Q.shadowCanvas._elem.fadeIn(S)}Q.canvas._elem.fadeIn(S);Q.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+Q.index).fadeIn(S)}else{if(Q.shadowCanvas._elem){Q.shadowCanvas._elem.fadeOut(S)}Q.canvas._elem.fadeOut(S);Q.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+Q.index).fadeOut(S)}}else{if(Q.canvas._elem.is(":hidden")){if(Q.shadowCanvas._elem){Q.shadowCanvas._elem.show()}Q.canvas._elem.show();Q.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+Q.index).show()}else{if(Q.shadowCanvas._elem){Q.shadowCanvas._elem.hide()}Q.canvas._elem.hide();Q.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+Q.index).hide()}}};function C(){B.jqplot.ElemContainer.call(this);this.drawGridlines=true;this.gridLineColor="#cccccc";this.gridLineWidth=1;this.background="#fffdf6";this.borderColor="#999999";this.borderWidth=2;this.drawBorder=true;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.5;this.shadowWidth=3;this.shadowDepth=3;this.shadowColor=null;this.shadowAlpha="0.07";this._left;this._top;this._right;this._bottom;this._width;this._height;this._axes=[];this.renderer=B.jqplot.CanvasGridRenderer;this.rendererOptions={};this._offsets={top:null,bottom:null,left:null,right:null}}C.prototype=new B.jqplot.ElemContainer();C.prototype.constructor=C;C.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};C.prototype.createElement=function(Q){this._offsets=Q;return this.renderer.createElement.call(this)};C.prototype.draw=function(){this.renderer.draw.call(this)};B.jqplot.GenericCanvas=function(){B.jqplot.ElemContainer.call(this);this._ctx};B.jqplot.GenericCanvas.prototype=new B.jqplot.ElemContainer();B.jqplot.GenericCanvas.prototype.constructor=B.jqplot.GenericCanvas;B.jqplot.GenericCanvas.prototype.createElement=function(U,S,R){this._offsets=U;var Q="jqplot";if(S!=l){Q=S}var T;if(this._elem){T=this._elem.get(0)}else{T=document.createElement("canvas")}if(R!=l){this._plotDimensions=R}T.width=this._plotDimensions.width-this._offsets.left-this._offsets.right;T.height=this._plotDimensions.height-this._offsets.top-this._offsets.bottom;this._elem=B(T);this._elem.css({position:"absolute",left:this._offsets.left,top:this._offsets.top});this._elem.addClass(Q);if(B.browser.msie){window.G_vmlCanvasManager.init_(document);T=window.G_vmlCanvasManager.initElement(T)}return this._elem};B.jqplot.GenericCanvas.prototype.setContext=function(){this._ctx=this._elem.get(0).getContext("2d");return this._ctx};B.jqplot.HooksManager=function(){this.hooks=[]};B.jqplot.HooksManager.prototype.addOnce=function(R){var S=false,Q;for(Q=0;Q<this.hooks.length;Q++){if(this.hooks[Q][0]==R){S=true}}if(!S){this.hooks.push(R)}};B.jqplot.HooksManager.prototype.add=function(Q){this.hooks.push(Q)};B.jqplot.EventListenerManager=function(){this.hooks=[]};B.jqplot.EventListenerManager.prototype.addOnce=function(T,S){var U=false,R,Q;for(Q=0;Q<this.hooks.length;Q++){R=this.hooks[Q];if(R[0]==T&&R[1]==S){U=true}}if(!U){this.hooks.push([T,S])}};B.jqplot.EventListenerManager.prototype.add=function(R,Q){this.hooks.push([R,Q])};function F(){this.data=[];this.targetId=null;this.target=null;this.defaults={axesDefaults:{},axes:{xaxis:{},yaxis:{},x2axis:{},y2axis:{},y3axis:{},y4axis:{},y5axis:{},y6axis:{},y7axis:{},y8axis:{},y9axis:{}},seriesDefaults:{},gridPadding:{top:10,right:10,bottom:23,left:10},series:[]};this.series=[];this.axes={xaxis:new o("xaxis"),yaxis:new o("yaxis"),x2axis:new o("x2axis"),y2axis:new o("y2axis"),y3axis:new o("y3axis"),y4axis:new o("y4axis"),y5axis:new o("y5axis"),y6axis:new o("y6axis"),y7axis:new o("y7axis"),y8axis:new o("y8axis"),y9axis:new o("y9axis")};this.grid=new C();this.legend=new g();this.baseCanvas=new B.jqplot.GenericCanvas();this.seriesStack=[];this.previousSeriesStack=[];this.eventCanvas=new B.jqplot.GenericCanvas();this._width=null;this._height=null;this._plotDimensions={height:null,width:null};this._gridPadding={top:10,right:10,bottom:10,left:10};this.syncXTicks=true;this.syncYTicks=true;this.seriesColors=["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"];this.negativeSeriesColors=["#498991","#C08840","#9F9274","#546D61","#646C4A","#6F6621","#6E3F5F","#4F64B0","#A89050","#C45923","#187399","#945381","#959E5C","#C7AF7B","#478396","#907294"];this.sortData=true;var S=0;this.textColor;this.fontFamily;this.fontSize;this.title=new p();this.options={};this.stackSeries=false;this.defaultAxisStart=1;this._stackData=[];this._plotData=[];this.plugins={};this._drawCount=0;this.drawIfHidden=false;this.captureRightClick=false;this.themeEngine=new B.jqplot.ThemeEngine();this._sumy=0;this._sumx=0;this.preInitHooks=new B.jqplot.HooksManager();this.postInitHooks=new B.jqplot.HooksManager();this.preParseOptionsHooks=new B.jqplot.HooksManager();this.postParseOptionsHooks=new B.jqplot.HooksManager();this.preDrawHooks=new B.jqplot.HooksManager();this.postDrawHooks=new B.jqplot.HooksManager();this.preDrawSeriesHooks=new B.jqplot.HooksManager();this.postDrawSeriesHooks=new B.jqplot.HooksManager();this.preDrawLegendHooks=new B.jqplot.HooksManager();this.addLegendRowHooks=new B.jqplot.HooksManager();this.preSeriesInitHooks=new B.jqplot.HooksManager();this.postSeriesInitHooks=new B.jqplot.HooksManager();this.preParseSeriesOptionsHooks=new B.jqplot.HooksManager();this.postParseSeriesOptionsHooks=new B.jqplot.HooksManager();this.eventListenerHooks=new B.jqplot.EventListenerManager();this.preDrawSeriesShadowHooks=new B.jqplot.HooksManager();this.postDrawSeriesShadowHooks=new B.jqplot.HooksManager();this.colorGenerator=B.jqplot.ColorGenerator;this.init=function(ab,aa,X){for(var Y=0;Y<B.jqplot.preInitHooks.length;Y++){B.jqplot.preInitHooks[Y].call(this,ab,aa,X)}for(var Y=0;Y<this.preInitHooks.hooks.length;Y++){this.preInitHooks.hooks[Y].call(this,ab,aa,X)}this.targetId="#"+ab;this.target=B("#"+ab);this.target.removeClass("jqplot-error");if(!this.target.get(0)){throw"No plot target specified"}if(this.target.css("position")=="static"){this.target.css("position","relative")}if(!this.target.hasClass("jqplot-target")){this.target.addClass("jqplot-target")}if(!this.target.height()){var Z;if(X&&X.height){Z=parseInt(X.height,10)}else{if(this.target.attr("data-height")){Z=parseInt(this.target.attr("data-height"),10)}else{Z=parseInt(B.jqplot.config.defaultHeight,10)}}this._height=Z;this.target.css("height",Z+"px")}else{this._height=this.target.height()}if(!this.target.width()){var U;if(X&&X.width){U=parseInt(X.width,10)}else{if(this.target.attr("data-width")){U=parseInt(this.target.attr("data-width"),10)}else{U=parseInt(B.jqplot.config.defaultWidth,10)}}this._width=U;this.target.css("width",U+"px")}else{this._width=this.target.width()}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Canvas dimension not set"}if(aa==null){throw {name:"DataError",message:"No data to plot."}}if(aa.constructor!=Array||aa.length==0||aa[0].constructor!=Array||aa[0].length==0){throw {name:"DataError",message:"No data to plot."}}this.data=aa;this.parseOptions(X);if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this.title.init();this.legend.init();this._sumy=0;this._sumx=0;for(var Y=0;Y<this.series.length;Y++){this.seriesStack.push(Y);this.previousSeriesStack.push(Y);this.series[Y].shadowCanvas._plotDimensions=this._plotDimensions;this.series[Y].canvas._plotDimensions=this._plotDimensions;for(var W=0;W<B.jqplot.preSeriesInitHooks.length;W++){B.jqplot.preSeriesInitHooks[W].call(this.series[Y],ab,aa,this.options.seriesDefaults,this.options.series[Y],this)}for(var W=0;W<this.preSeriesInitHooks.hooks.length;W++){this.preSeriesInitHooks.hooks[W].call(this.series[Y],ab,aa,this.options.seriesDefaults,this.options.series[Y],this)}this.populatePlotData(this.series[Y],Y);this.series[Y]._plotDimensions=this._plotDimensions;this.series[Y].init(Y,this.grid.borderWidth,this);for(var W=0;W<B.jqplot.postSeriesInitHooks.length;W++){B.jqplot.postSeriesInitHooks[W].call(this.series[Y],ab,aa,this.options.seriesDefaults,this.options.series[Y],this)}for(var W=0;W<this.postSeriesInitHooks.hooks.length;W++){this.postSeriesInitHooks.hooks[W].call(this.series[Y],ab,aa,this.options.seriesDefaults,this.options.series[Y],this)}this._sumy+=this.series[Y]._sumy;this._sumx+=this.series[Y]._sumx}for(var V in this.axes){this.axes[V]._plotDimensions=this._plotDimensions;this.axes[V].init()}if(this.sortData){Q(this.series)}this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(var Y=0;Y<B.jqplot.postInitHooks.length;Y++){B.jqplot.postInitHooks[Y].call(this,ab,aa,X)}for(var Y=0;Y<this.postInitHooks.hooks.length;Y++){this.postInitHooks.hooks[Y].call(this,ab,aa,X)}};this.resetAxesScale=function(X){var W=(X!=l)?X:this.axes;if(W===true){W=this.axes}if(W.constructor===Array){for(var V=0;V<W.length;V++){this.axes[W[V]].resetScale()}}else{if(W.constructor===Object){for(var U in W){this.axes[U].resetScale()}}}};this.reInitialize=function(){if(!this.target.height()){var X;if(options&&options.height){X=parseInt(options.height,10)}else{if(this.target.attr("data-height")){X=parseInt(this.target.attr("data-height"),10)}else{X=parseInt(B.jqplot.config.defaultHeight,10)}}this._height=X;this.target.css("height",X+"px")}else{this._height=this.target.height()}if(!this.target.width()){var U;if(options&&options.width){U=parseInt(options.width,10)}else{if(this.target.attr("data-width")){U=parseInt(this.target.attr("data-width"),10)}else{U=parseInt(B.jqplot.config.defaultWidth,10)}}this._width=U;this.target.css("width",U+"px")}else{this._width=this.target.width()}if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Target dimension not set"}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;for(var Y in this.axes){this.axes[Y]._plotWidth=this._width;this.axes[Y]._plotHeight=this._height}this.title._plotWidth=this._width;if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this._sumy=0;this._sumx=0;for(var W=0;W<this.series.length;W++){this.populatePlotData(this.series[W],W);this.series[W]._plotDimensions=this._plotDimensions;this.series[W].canvas._plotDimensions=this._plotDimensions;this._sumy+=this.series[W]._sumy;this._sumx+=this.series[W]._sumx}for(var V in this.axes){this.axes[V]._plotDimensions=this._plotDimensions;this.axes[V]._ticks=[];this.axes[V].renderer.init.call(this.axes[V],{})}if(this.sortData){Q(this.series)}this.grid._axes=this.axes;this.legend._series=this.series};function Q(Y){var ac,ad,ae,U,ab;for(var Z=0;Z<Y.length;Z++){var V;var aa=[Y[Z].data,Y[Z]._stackData,Y[Z]._plotData,Y[Z]._prevPlotData];for(var W=0;W<4;W++){V=true;ac=aa[W];if(Y[Z]._stackAxis=="x"){for(var X=0;X<ac.length;X++){if(typeof(ac[X][1])!="number"){V=false;break}}if(V){ac.sort(function(ag,af){return ag[1]-af[1]})}}else{for(var X=0;X<ac.length;X++){if(typeof(ac[X][0])!="number"){V=false;break}}if(V){ac.sort(function(ag,af){return ag[0]-af[0]})}}}}}this.populatePlotData=function(Y,Z){this._plotData=[];this._stackData=[];Y._stackData=[];Y._plotData=[];var ac={x:[],y:[]};if(this.stackSeries&&!Y.disableStack){Y._stack=true;var aa=Y._stackAxis=="x"?0:1;var ab=aa?0:1;var ad=B.extend(true,[],Y.data);var ae=B.extend(true,[],Y.data);for(var W=0;W<Z;W++){var U=this.series[W].data;for(var V=0;V<U.length;V++){ad[V][0]+=U[V][0];ad[V][1]+=U[V][1];ae[V][aa]+=U[V][aa]}}for(var X=0;X<ae.length;X++){ac.x.push(ae[X][0]);ac.y.push(ae[X][1])}this._plotData.push(ae);this._stackData.push(ad);Y._stackData=ad;Y._plotData=ae;Y._plotValues=ac}else{for(var X=0;X<Y.data.length;X++){ac.x.push(Y.data[X][0]);ac.y.push(Y.data[X][1])}this._stackData.push(Y.data);this.series[Z]._stackData=Y.data;this._plotData.push(Y.data);Y._plotData=Y.data;Y._plotValues=ac}if(Z>0){Y._prevPlotData=this.series[Z-1]._plotData}Y._sumy=0;Y._sumx=0;for(X=Y.data.length-1;X>-1;X--){Y._sumy+=Y.data[X][1];Y._sumx+=Y.data[X][0]}};this.getNextSeriesColor=(function(V){var U=0;var W=V.seriesColors;return function(){if(U<W.length){return W[U++]}else{U=0;return W[U++]}}})(this);this.parseOptions=function(ac){for(var Z=0;Z<this.preParseOptionsHooks.hooks.length;Z++){this.preParseOptionsHooks.hooks[Z].call(this,ac)}for(var Z=0;Z<B.jqplot.preParseOptionsHooks.length;Z++){B.jqplot.preParseOptionsHooks[Z].call(this,ac)}this.options=B.extend(true,{},this.defaults,ac);this.stackSeries=this.options.stackSeries;if(this.options.seriesColors){this.seriesColors=this.options.seriesColors}if(this.options.negativeSeriesColors){this.negativeSeriesColors=this.options.negativeSeriesColors}if(this.options.captureRightClick){this.captureRightClick=this.options.captureRightClick}this.defaultAxisStart=(ac&&ac.defaultAxisStart!=null)?ac.defaultAxisStart:this.defaultAxisStart;var U=new this.colorGenerator(this.seriesColors);B.extend(true,this._gridPadding,this.options.gridPadding);this.sortData=(this.options.sortData!=null)?this.options.sortData:this.sortData;for(var V in this.axes){var X=this.axes[V];B.extend(true,X,this.options.axesDefaults,this.options.axes[V]);X._plotWidth=this._width;X._plotHeight=this._height}if(this.data.length==0){this.data=[];for(var Z=0;Z<this.options.series.length;Z++){this.data.push(this.options.series.data)}}var aa=function(ag,ae,ah){var ad=[];var af;ae=ae||"vertical";if(!(ag[0] instanceof Array)){for(af=0;af<ag.length;af++){if(ae=="vertical"){ad.push([ah+af,ag[af]])}else{ad.push([ag[af],ah+af])}}}else{B.extend(true,ad,ag)}return ad};for(var Z=0;Z<this.data.length;Z++){var ab=new G();for(var Y=0;Y<B.jqplot.preParseSeriesOptionsHooks.length;Y++){B.jqplot.preParseSeriesOptionsHooks[Y].call(ab,this.options.seriesDefaults,this.options.series[Z])}for(var Y=0;Y<this.preParseSeriesOptionsHooks.hooks.length;Y++){this.preParseSeriesOptionsHooks.hooks[Y].call(ab,this.options.seriesDefaults,this.options.series[Z])}B.extend(true,ab,{seriesColors:this.seriesColors,negativeSeriesColors:this.negativeSeriesColors},this.options.seriesDefaults,this.options.series[Z]);var W="vertical";if(ab.renderer.constructor==B.jqplot.barRenderer&&ab.rendererOptions&&ab.rendererOptions.barDirection=="horizontal"){W="horizontal"}ab.data=aa(this.data[Z],W,this.defaultAxisStart);switch(ab.xaxis){case"xaxis":ab._xaxis=this.axes.xaxis;break;case"x2axis":ab._xaxis=this.axes.x2axis;break;default:break}ab._yaxis=this.axes[ab.yaxis];ab._xaxis._series.push(ab);ab._yaxis._series.push(ab);if(ab.show){ab._xaxis.show=true;ab._yaxis.show=true}if(!ab.color&&ab.show!=false){ab.color=U.next()}if(!ab.label){ab.label="Series "+(Z+1).toString()}this.series.push(ab);for(var Y=0;Y<B.jqplot.postParseSeriesOptionsHooks.length;Y++){B.jqplot.postParseSeriesOptionsHooks[Y].call(this.series[Z],this.options.seriesDefaults,this.options.series[Z])}for(var Y=0;Y<this.postParseSeriesOptionsHooks.hooks.length;Y++){this.postParseSeriesOptionsHooks.hooks[Y].call(this.series[Z],this.options.seriesDefaults,this.options.series[Z])}}B.extend(true,this.grid,this.options.grid);for(var V in this.axes){var X=this.axes[V];if(X.borderWidth==null){X.borderWidth=this.grid.borderWidth}if(X.borderColor==null){if(V!="xaxis"&&V!="x2axis"&&X.useSeriesColor===true&&X.show){X.borderColor=X._series[0].color}else{X.borderColor=this.grid.borderColor}}}if(typeof this.options.title=="string"){this.title.text=this.options.title}else{if(typeof this.options.title=="object"){B.extend(true,this.title,this.options.title)}}this.title._plotWidth=this._width;this.legend.setOptions(this.options.legend);for(var Z=0;Z<B.jqplot.postParseOptionsHooks.length;Z++){B.jqplot.postParseOptionsHooks[Z].call(this,ac)}for(var Z=0;Z<this.postParseOptionsHooks.hooks.length;Z++){this.postParseOptionsHooks.hooks[Z].call(this,ac)}};this.replot=function(V){var W=(V!=l)?V:{};var U=(W.clear!=l)?W.clear:true;var X=(W.resetAxes!=l)?W.resetAxes:false;this.target.trigger("jqplotPreReplot");if(U){this.target.empty()}if(X){this.resetAxesScale(X)}this.reInitialize();this.draw();this.target.trigger("jqplotPostReplot")};this.redraw=function(U){U=(U!=null)?U:true;this.target.trigger("jqplotPreRedraw");if(U){this.target.empty()}for(var W in this.axes){this.axes[W]._ticks=[]}for(var V=0;V<this.series.length;V++){this.populatePlotData(this.series[V],V)}this._sumy=0;this._sumx=0;for(V=0;V<this.series.length;V++){this._sumy+=this.series[V]._sumy;this._sumx+=this.series[V]._sumx}this.draw();this.target.trigger("jqplotPostRedraw")};this.draw=function(){if(this.drawIfHidden||this.target.is(":visible")){this.target.trigger("jqplotPreDraw");var aa,Z;for(aa=0;aa<B.jqplot.preDrawHooks.length;aa++){B.jqplot.preDrawHooks[aa].call(this)}for(aa=0;aa<this.preDrawHooks.hooks.length;aa++){this.preDrawHooks.hooks[aa].call(this)}this.target.append(this.baseCanvas.createElement({left:0,right:0,top:0,bottom:0},"jqplot-base-canvas"));this.baseCanvas.setContext();this.target.append(this.title.draw());this.title.pack({top:0,left:0});var af=this.legend.draw();var ae={top:0,left:0,bottom:0,right:0};if(this.legend.placement=="outsideGrid"){this.target.append(af);switch(this.legend.location){case"n":ae.top+=this.legend.getHeight();break;case"s":ae.bottom+=this.legend.getHeight();break;case"ne":case"e":case"se":ae.right+=this.legend.getWidth();break;case"nw":case"w":case"sw":ae.left+=this.legend.getWidth();break;default:ae.right+=this.legend.getWidth();break}af=af.detach()}var U=this.axes;for(var W in U){this.target.append(U[W].draw(this.baseCanvas._ctx));U[W].set()}if(U.yaxis.show){ae.left+=U.yaxis.getWidth()}var X=["y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var V=[0,0,0,0,0,0,0,0];var ac=0;var Y;for(Y=0;Y<8;Y++){if(U[X[Y]].show){ac+=U[X[Y]].getWidth();V[Y]=ac}}ae.right+=ac;if(U.x2axis.show){ae.top+=U.x2axis.getHeight()}if(this.title.show){ae.top+=this.title.getHeight()}if(U.xaxis.show){ae.bottom+=U.xaxis.getHeight()}var ab=["top","bottom","left","right"];for(var Y in ab){if(ae[ab[Y]]){this._gridPadding[ab[Y]]=ae[ab[Y]]}}var ad=(this.legend.placement=="outsideGrid")?{top:this.title.getHeight(),left:0,right:0,bottom:0}:this._gridPadding;U.xaxis.pack({position:"absolute",bottom:this._gridPadding.bottom-U.xaxis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});U.yaxis.pack({position:"absolute",top:0,left:this._gridPadding.left-U.yaxis.getWidth(),height:this._height},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});U.x2axis.pack({position:"absolute",top:this._gridPadding.top-U.x2axis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});for(aa=8;aa>0;aa--){U[X[aa-1]].pack({position:"absolute",top:0,right:this._gridPadding.right-V[aa-1]},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top})}this.target.append(this.grid.createElement(this._gridPadding));this.grid.draw();for(aa=0;aa<this.series.length;aa++){Z=this.seriesStack[aa];this.target.append(this.series[Z].shadowCanvas.createElement(this._gridPadding,"jqplot-series-shadowCanvas"));this.series[Z].shadowCanvas.setContext();this.series[Z].shadowCanvas._elem.data("seriesIndex",Z)}for(aa=0;aa<this.series.length;aa++){Z=this.seriesStack[aa];this.target.append(this.series[Z].canvas.createElement(this._gridPadding,"jqplot-series-canvas"));this.series[Z].canvas.setContext();this.series[Z].canvas._elem.data("seriesIndex",Z)}this.target.append(this.eventCanvas.createElement(this._gridPadding,"jqplot-event-canvas"));this.eventCanvas.setContext();this.eventCanvas._ctx.fillStyle="rgba(0,0,0,0)";this.eventCanvas._ctx.fillRect(0,0,this.eventCanvas._ctx.canvas.width,this.eventCanvas._ctx.canvas.height);this.bindCustomEvents();if(this.legend.preDraw){this.eventCanvas._elem.before(af);this.legend.pack(ad);if(this.legend._elem){this.drawSeries({legendInfo:{location:this.legend.location,placement:this.legend.placement,width:this.legend.getWidth(),height:this.legend.getHeight(),xoffset:this.legend.xoffset,yoffset:this.legend.yoffset}})}else{this.drawSeries()}}else{this.drawSeries();B(this.series[this.series.length-1].canvas._elem).after(af);this.legend.pack(ad)}for(var aa=0;aa<B.jqplot.eventListenerHooks.length;aa++){this.eventCanvas._elem.bind(B.jqplot.eventListenerHooks[aa][0],{plot:this},B.jqplot.eventListenerHooks[aa][1])}for(var aa=0;aa<this.eventListenerHooks.hooks.length;aa++){this.eventCanvas._elem.bind(this.eventListenerHooks.hooks[aa][0],{plot:this},this.eventListenerHooks.hooks[aa][1])}for(var aa=0;aa<B.jqplot.postDrawHooks.length;aa++){B.jqplot.postDrawHooks[aa].call(this)}for(var aa=0;aa<this.postDrawHooks.hooks.length;aa++){this.postDrawHooks.hooks[aa].call(this)}if(this.target.is(":visible")){this._drawCount+=1}this.target.trigger("jqplotPostDraw",[this])}};this.bindCustomEvents=function(){this.eventCanvas._elem.bind("click",{plot:this},this.onClick);this.eventCanvas._elem.bind("dblclick",{plot:this},this.onDblClick);this.eventCanvas._elem.bind("mousedown",{plot:this},this.onMouseDown);this.eventCanvas._elem.bind("mousemove",{plot:this},this.onMouseMove);this.eventCanvas._elem.bind("mouseenter",{plot:this},this.onMouseEnter);this.eventCanvas._elem.bind("mouseleave",{plot:this},this.onMouseLeave);if(this.captureRightClick){this.eventCanvas._elem.bind("mouseup",{plot:this},this.onRightClick);this.eventCanvas._elem.get(0).oncontextmenu=function(){return false}}else{this.eventCanvas._elem.bind("mouseup",{plot:this},this.onMouseUp)}};function R(ac){var ab=ac.data.plot;var X=ab.eventCanvas._elem.offset();var aa={x:ac.pageX-X.left,y:ac.pageY-X.top};var Y={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null};var Z=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var U=ab.axes;var V,W;for(V=11;V>0;V--){W=Z[V-1];if(U[W].show){Y[W]=U[W].series_p2u(aa[W.charAt(0)])}}return{offsets:X,gridPos:aa,dataPos:Y}}function T(U,V){var Z=V.series;var aD,aC,aB,aw,ax,aq,ap,ae,ac,ag,ah,ar;var aA,aE,ay,aa,ao,au;var W,av;for(aB=V.seriesStack.length-1;aB>=0;aB--){aD=V.seriesStack[aB];aw=Z[aD];switch(aw.renderer.constructor){case B.jqplot.BarRenderer:aq=U.x;ap=U.y;for(aC=aw.gridData.length-1;aC>=0;aC--){ao=aw._barPoints[aC];if(aq>ao[0][0]&&aq<ao[2][0]&&ap>ao[2][1]&&ap<ao[0][1]){return{seriesIndex:aw.index,pointIndex:aC,gridData:ay,data:aw.data[aC],points:aw._barPoints[aC]}}}break;case B.jqplot.DonutRenderer:ag=aw.startAngle/180*Math.PI;aq=U.x-aw._center[0];ap=U.y-aw._center[1];ax=Math.sqrt(Math.pow(aq,2)+Math.pow(ap,2));if(aq>0&&-ap>=0){ae=2*Math.PI-Math.atan(-ap/aq)}else{if(aq>0&&-ap<0){ae=-Math.atan(-ap/aq)}else{if(aq<0){ae=Math.PI-Math.atan(-ap/aq)}else{if(aq==0&&-ap>0){ae=3*Math.PI/2}else{if(aq==0&&-ap<0){ae=Math.PI/2}else{if(aq==0&&ap==0){ae=0}}}}}}if(ag){ae-=ag;if(ae<0){ae+=2*Math.PI}else{if(ae>2*Math.PI){ae-=2*Math.PI}}}ac=aw.sliceMargin/180*Math.PI;if(ax<aw._radius&&ax>aw._innerRadius){for(aC=0;aC<aw.gridData.length;aC++){ah=(aC>0)?aw.gridData[aC-1][1]+ac:ac;ar=aw.gridData[aC][1];if(ae>ah&&ae<ar){return{seriesIndex:aw.index,pointIndex:aC,gridData:aw.gridData[aC],data:aw.data[aC]}}}}break;case B.jqplot.PieRenderer:ag=aw.startAngle/180*Math.PI;aq=U.x-aw._center[0];ap=U.y-aw._center[1];ax=Math.sqrt(Math.pow(aq,2)+Math.pow(ap,2));if(aq>0&&-ap>=0){ae=2*Math.PI-Math.atan(-ap/aq)}else{if(aq>0&&-ap<0){ae=-Math.atan(-ap/aq)}else{if(aq<0){ae=Math.PI-Math.atan(-ap/aq)}else{if(aq==0&&-ap>0){ae=3*Math.PI/2}else{if(aq==0&&-ap<0){ae=Math.PI/2}else{if(aq==0&&ap==0){ae=0}}}}}}if(ag){ae-=ag;if(ae<0){ae+=2*Math.PI}else{if(ae>2*Math.PI){ae-=2*Math.PI}}}ac=aw.sliceMargin/180*Math.PI;if(ax<aw._radius){for(aC=0;aC<aw.gridData.length;aC++){ah=(aC>0)?aw.gridData[aC-1][1]+ac:ac;ar=aw.gridData[aC][1];if(ae>ah&&ae<ar){return{seriesIndex:aw.index,pointIndex:aC,gridData:aw.gridData[aC],data:aw.data[aC]}}}}break;case B.jqplot.BubbleRenderer:aq=U.x;ap=U.y;var am=null;if(aw.show){for(var aC=0;aC<aw.gridData.length;aC++){ay=aw.gridData[aC];aE=Math.sqrt((aq-ay[0])*(aq-ay[0])+(ap-ay[1])*(ap-ay[1]));if(aE<=ay[2]&&(aE<=aA||aA==null)){aA=aE;am={seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}if(am!=null){return am}}break;case B.jqplot.FunnelRenderer:aq=U.x;ap=U.y;var at=aw._vertices,Y=at[0],X=at[at.length-1],ab,al;function az(aH,aJ,aI){var aG=(aJ[1]-aI[1])/(aJ[0]-aI[0]);var aF=aJ[1]-aG*aJ[0];var aK=aH+aJ[1];return[(aK-aF)/aG,aK]}ab=az(ap,Y[0],X[3]);al=az(ap,Y[1],X[2]);for(aC=0;aC<at.length;aC++){cv=at[aC];if(ap>=cv[0][1]&&ap<=cv[3][1]&&aq>=ab[0]&&aq<=al[0]){return{seriesIndex:aw.index,pointIndex:aC,gridData:null,data:aw.data[aC]}}}break;case B.jqplot.LineRenderer:aq=U.x;ap=U.y;ax=aw.renderer;if(aw.show){if(aw.fill){var af=false;if(aq>aw._boundingBox[0][0]&&aq<aw._boundingBox[1][0]&&ap>aw._boundingBox[1][1]&&ap<aw._boundingBox[0][1]){var ak=aw._areaPoints.length;var an;var aC=ak-1;for(var an=0;an<ak;an++){var aj=[aw._areaPoints[an][0],aw._areaPoints[an][1]];var ai=[aw._areaPoints[aC][0],aw._areaPoints[aC][1]];if(aj[1]<ap&&ai[1]>=ap||ai[1]<ap&&aj[1]>=ap){if(aj[0]+(ap-aj[1])/(ai[1]-aj[1])*(ai[0]-aj[0])<aq){af=!af}}aC=an}}if(af){return{seriesIndex:aD,pointIndex:null,gridData:aw.gridData,data:aw.data,points:aw._areaPoints}}break}else{av=aw.markerRenderer.size/2+aw.neighborThreshold;W=(av>0)?av:0;for(var aC=0;aC<aw.gridData.length;aC++){ay=aw.gridData[aC];if(ax.constructor==B.jqplot.OHLCRenderer){if(ax.candleStick){var ad=aw._yaxis.series_u2p;if(aq>=ay[0]-ax._bodyWidth/2&&aq<=ay[0]+ax._bodyWidth/2&&ap>=ad(aw.data[aC][2])&&ap<=ad(aw.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}else{if(!ax.hlc){var ad=aw._yaxis.series_u2p;if(aq>=ay[0]-ax._tickLength&&aq<=ay[0]+ax._tickLength&&ap>=ad(aw.data[aC][2])&&ap<=ad(aw.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}else{var ad=aw._yaxis.series_u2p;if(aq>=ay[0]-ax._tickLength&&aq<=ay[0]+ax._tickLength&&ap>=ad(aw.data[aC][1])&&ap<=ad(aw.data[aC][2])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}}}else{if(ay[0]!=null&&ay[1]!=null){aE=Math.sqrt((aq-ay[0])*(aq-ay[0])+(ap-ay[1])*(ap-ay[1]));if(aE<=W&&(aE<=aA||aA==null)){aA=aE;return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}}}}}break;default:aq=U.x;ap=U.y;ax=aw.renderer;if(aw.show){av=aw.markerRenderer.size/2+aw.neighborThreshold;W=(av>0)?av:0;for(var aC=0;aC<aw.gridData.length;aC++){ay=aw.gridData[aC];if(ax.constructor==B.jqplot.OHLCRenderer){if(ax.candleStick){var ad=aw._yaxis.series_u2p;if(aq>=ay[0]-ax._bodyWidth/2&&aq<=ay[0]+ax._bodyWidth/2&&ap>=ad(aw.data[aC][2])&&ap<=ad(aw.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}else{if(!ax.hlc){var ad=aw._yaxis.series_u2p;if(aq>=ay[0]-ax._tickLength&&aq<=ay[0]+ax._tickLength&&ap>=ad(aw.data[aC][2])&&ap<=ad(aw.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}else{var ad=aw._yaxis.series_u2p;if(aq>=ay[0]-ax._tickLength&&aq<=ay[0]+ax._tickLength&&ap>=ad(aw.data[aC][1])&&ap<=ad(aw.data[aC][2])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}}}else{aE=Math.sqrt((aq-ay[0])*(aq-ay[0])+(ap-ay[1])*(ap-ay[1]));if(aE<=W&&(aE<=aA||aA==null)){aA=aE;return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:aw.data[aC]}}}}}break}}return null}this.onClick=function(W){var V=R(W);var Y=W.data.plot;var X=T(V.gridPos,Y);var U=jQuery.Event("jqplotClick");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,X,Y])};this.onDblClick=function(W){var V=R(W);var Y=W.data.plot;var X=T(V.gridPos,Y);var U=jQuery.Event("jqplotDblClick");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,X,Y])};this.onMouseDown=function(W){var V=R(W);var Y=W.data.plot;var X=T(V.gridPos,Y);var U=jQuery.Event("jqplotMouseDown");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,X,Y])};this.onMouseUp=function(W){var V=R(W);var U=jQuery.Event("jqplotMouseUp");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,null,W.data.plot])};this.onRightClick=function(W){var V=R(W);var Y=W.data.plot;var X=T(V.gridPos,Y);if(Y.captureRightClick){if(W.which==3){var U=jQuery.Event("jqplotRightClick");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,X,Y])}else{var U=jQuery.Event("jqplotMouseUp");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,X,Y])}}};this.onMouseMove=function(W){var V=R(W);var Y=W.data.plot;var X=T(V.gridPos,Y);var U=jQuery.Event("jqplotMouseMove");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,X,Y])};this.onMouseEnter=function(W){var V=R(W);var X=W.data.plot;var U=jQuery.Event("jqplotMouseEnter");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,null,X])};this.onMouseLeave=function(W){var V=R(W);var X=W.data.plot;var U=jQuery.Event("jqplotMouseLeave");U.pageX=W.pageX;U.pageY=W.pageY;B(this).trigger(U,[V.gridPos,V.dataPos,null,X])};this.drawSeries=function(W,U){var Y,X,V;U=(typeof(W)=="number"&&U==null)?W:U;W=(typeof(W)=="object")?W:{};if(U!=l){X=this.series[U];V=X.shadowCanvas._ctx;V.clearRect(0,0,V.canvas.width,V.canvas.height);X.drawShadow(V,W,this);V=X.canvas._ctx;V.clearRect(0,0,V.canvas.width,V.canvas.height);X.draw(V,W,this);if(X.renderer.constructor==B.jqplot.BezierCurveRenderer){if(U<this.series.length-1){this.drawSeries(U+1)}}}else{for(Y=0;Y<this.series.length;Y++){X=this.series[Y];V=X.shadowCanvas._ctx;V.clearRect(0,0,V.canvas.width,V.canvas.height);X.drawShadow(V,W,this);V=X.canvas._ctx;V.clearRect(0,0,V.canvas.width,V.canvas.height);X.draw(V,W,this)}}};this.moveSeriesToFront=function(V){V=parseInt(V,10);var Y=B.inArray(V,this.seriesStack);if(Y==-1){return}if(Y==this.seriesStack.length-1){this.previousSeriesStack=this.seriesStack.slice(0);return}var U=this.seriesStack[this.seriesStack.length-1];var X=this.series[V].canvas._elem.detach();var W=this.series[V].shadowCanvas._elem.detach();this.series[U].shadowCanvas._elem.after(W);this.series[U].canvas._elem.after(X);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(Y,1);this.seriesStack.push(V)};this.moveSeriesToBack=function(V){V=parseInt(V,10);var Y=B.inArray(V,this.seriesStack);if(Y==0||Y==-1){return}var U=this.seriesStack[0];var X=this.series[V].canvas._elem.detach();var W=this.series[V].shadowCanvas._elem.detach();this.series[U].shadowCanvas._elem.before(W);this.series[U].canvas._elem.before(X);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(Y,1);this.seriesStack.unshift(V)};this.restorePreviousSeriesOrder=function(){var Y,X,W,V,U;if(this.seriesStack==this.previousSeriesStack){return}for(Y=1;Y<this.previousSeriesStack.length;Y++){move=this.previousSeriesStack[Y];keep=this.previousSeriesStack[Y-1];W=this.series[move].canvas._elem.detach();V=this.series[move].shadowCanvas._elem.detach();this.series[keep].shadowCanvas._elem.after(V);this.series[keep].canvas._elem.after(W)}U=this.seriesStack.slice(0);this.seriesStack=this.previousSeriesStack.slice(0);this.previousSeriesStack=U};this.restoreOriginalSeriesOrder=function(){var W,V,U=[];for(W=0;W<this.series.length;W++){U.push(W)}if(this.seriesStack==U){return}this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack=U;for(W=1;W<this.seriesStack.length;W++){serelem=this.series[W].canvas._elem.detach();shadelem=this.series[W].shadowCanvas._elem.detach();this.series[W-1].shadowCanvas._elem.after(shadelem);this.series[W-1].canvas._elem.after(serelem)}};this.activateTheme=function(U){this.themeEngine.activate(this,U)}}B.jqplot.computeHighlightColors=function(R){var T;if(typeof(R)=="array"){T=[];for(var V=0;V<R.length;V++){var U=B.jqplot.getColorComponents(R[V]);var Q=[U[0],U[1],U[2]];var W=Q[0]+Q[1]+Q[2];for(var S=0;S<3;S++){Q[S]=(W>570)?Q[S]*0.8:Q[S]+0.3*(255-Q[S]);Q[S]=parseInt(Q[S],10)}T.push("rgb("+Q[0]+","+Q[1]+","+Q[2]+")")}}else{var U=B.jqplot.getColorComponents(R);var Q=[U[0],U[1],U[2]];var W=Q[0]+Q[1]+Q[2];for(var S=0;S<3;S++){Q[S]=(W>570)?Q[S]*0.8:Q[S]+0.3*(255-Q[S]);Q[S]=parseInt(Q[S],10)}T="rgb("+Q[0]+","+Q[1]+","+Q[2]+")"}return T};B.jqplot.ColorGenerator=function(R){var Q=0;this.next=function(){if(Q<R.length){return R[Q++]}else{Q=0;return R[Q++]}};this.previous=function(){if(Q>0){return R[Q--]}else{Q=R.length-1;return R[Q]}};this.get=function(T){var S=T-R.length*Math.floor(T/R.length);return R[S]};this.setColors=function(S){R=S};this.reset=function(){Q=0}};B.jqplot.hex2rgb=function(S,Q){S=S.replace("#","");if(S.length==3){S=S[0]+S[0]+S[1]+S[1]+S[2]+S[2]}var R;R="rgba("+parseInt(S.slice(0,2),16)+", "+parseInt(S.slice(2,4),16)+", "+parseInt(S.slice(4,6),16);if(Q){R+=", "+Q}R+=")";return R};B.jqplot.rgb2hex=function(U){var S=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *(?:, *[0-9.]*)?\)/;var Q=U.match(S);var T="#";for(i=1;i<4;i++){var R;if(Q[i].search(/%/)!=-1){R=parseInt(255*Q[i]/100,10).toString(16);if(R.length==1){R="0"+R}}else{R=parseInt(Q[i],10).toString(16);if(R.length==1){R="0"+R}}T+=R}return T};B.jqplot.normalize2rgb=function(R,Q){if(R.search(/^ *rgba?\(/)!=-1){return R}else{if(R.search(/^ *#?[0-9a-fA-F]?[0-9a-fA-F]/)!=-1){return B.jqplot.hex2rgb(R,Q)}else{throw"invalid color spec"}}};B.jqplot.getColorComponents=function(U){U=B.jqplot.colorKeywordMap[U]||U;var T=B.jqplot.normalize2rgb(U);var S=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *,? *([0-9.]* *)?\)/;var Q=T.match(S);var R=[];for(i=1;i<4;i++){if(Q[i].search(/%/)!=-1){R[i-1]=parseInt(255*Q[i]/100,10)}else{R[i-1]=parseInt(Q[i],10)}}R[3]=parseFloat(Q[4])?parseFloat(Q[4]):1;return R};B.jqplot.colorKeywordMap={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagreen:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};B.jqplot.log=function(){if(window.console&&B.jqplot.debug){if(arguments.length==1){console.log(arguments[0])}else{console.log(arguments)}}};var e=B.jqplot.log;B.jqplot.AxisLabelRenderer=function(Q){B.jqplot.ElemContainer.call(this);this.axis;this.show=true;this.label="";this.fontFamily=null;this.fontSize=null;this.textColor=null;this._elem;this.escapeHTML=false;B.extend(true,this,Q)};B.jqplot.AxisLabelRenderer.prototype=new B.jqplot.ElemContainer();B.jqplot.AxisLabelRenderer.prototype.constructor=B.jqplot.AxisLabelRenderer;B.jqplot.AxisLabelRenderer.prototype.init=function(Q){B.extend(true,this,Q)};B.jqplot.AxisLabelRenderer.prototype.draw=function(){this._elem=B('<div style="position:absolute;" class="jqplot-'+this.axis+'-label"></div>');if(Number(this.label)){this._elem.css("white-space","nowrap")}if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}return this._elem};B.jqplot.AxisLabelRenderer.prototype.pack=function(){};B.jqplot.AxisTickRenderer=function(Q){B.jqplot.ElemContainer.call(this);this.mark="outside";this.axis;this.showMark=true;this.showGridline=true;this.isMinorTick=false;this.size=4;this.markSize=6;this.show=true;this.showLabel=true;this.label="";this.value=null;this._styles={};this.formatter=B.jqplot.DefaultTickFormatter;this.prefix="";this.formatString="";this.fontFamily;this.fontSize;this.textColor;this._elem;B.extend(true,this,Q)};B.jqplot.AxisTickRenderer.prototype.init=function(Q){B.extend(true,this,Q)};B.jqplot.AxisTickRenderer.prototype=new B.jqplot.ElemContainer();B.jqplot.AxisTickRenderer.prototype.constructor=B.jqplot.AxisTickRenderer;B.jqplot.AxisTickRenderer.prototype.setTick=function(Q,S,R){this.value=Q;this.axis=S;if(R){this.isMinorTick=true}return this};B.jqplot.AxisTickRenderer.prototype.draw=function(){if(!this.label){this.label=this.formatter(this.formatString,this.value)}if(this.prefix&&!this.formatString){this.label=this.prefix+this.label}style='style="position:absolute;';if(Number(this.label)){style+="white-space:nowrap;"}style+='"';this._elem=B("<div "+style+' class="jqplot-'+this.axis+'-tick">'+this.label+"</div>");for(var Q in this._styles){this._elem.css(Q,this._styles[Q])}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}return this._elem};B.jqplot.DefaultTickFormatter=function(Q,R){if(typeof R=="number"){if(!Q){Q=B.jqplot.config.defaultTickFormatString}return B.jqplot.sprintf(Q,R)}else{return String(R)}};B.jqplot.AxisTickRenderer.prototype.pack=function(){};B.jqplot.CanvasGridRenderer=function(){this.shadowRenderer=new B.jqplot.ShadowRenderer()};B.jqplot.CanvasGridRenderer.prototype.init=function(R){this._ctx;B.extend(true,this,R);var Q={lineJoin:"miter",lineCap:"round",fill:false,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.shadowWidth,closePath:false,strokeStyle:this.shadowColor};this.renderer.shadowRenderer.init(Q)};B.jqplot.CanvasGridRenderer.prototype.createElement=function(){var S=document.createElement("canvas");var Q=this._plotDimensions.width;var R=this._plotDimensions.height;S.width=Q;S.height=R;this._elem=B(S);this._elem.addClass("jqplot-grid-canvas");this._elem.css({position:"absolute",left:0,top:0});if(B.browser.msie){window.G_vmlCanvasManager.init_(document)}if(B.browser.msie){S=window.G_vmlCanvasManager.initElement(S)}this._top=this._offsets.top;this._bottom=R-this._offsets.bottom;this._left=this._offsets.left;this._right=Q-this._offsets.right;this._width=this._right-this._left;this._height=this._bottom-this._top;return this._elem};B.jqplot.CanvasGridRenderer.prototype.draw=function(){this._ctx=this._elem.get(0).getContext("2d");var ag=this._ctx;var Z=this._axes;ag.save();ag.clearRect(0,0,this._plotDimensions.width,this._plotDimensions.height);ag.fillStyle=this.backgroundColor||this.background;ag.fillRect(this._left,this._top,this._width,this._height);if(this.drawGridlines){ag.save();ag.lineJoin="miter";ag.lineCap="butt";ag.lineWidth=this.gridLineWidth;ag.strokeStyle=this.gridLineColor;var ab,Y;var Q=["xaxis","yaxis","x2axis","y2axis"];for(var V=4;V>0;V--){var R=Q[V-1];var T=Z[R];var ac=T._ticks;if(T.show){for(var U=ac.length;U>0;U--){var af=ac[U-1];if(af.show){var aa=Math.round(T.u2p(af.value))+0.5;switch(R){case"xaxis":if(af.showGridline){X(aa,this._top,aa,this._bottom)}if(af.showMark&&af.mark){s=af.markSize;m=af.mark;var aa=Math.round(T.u2p(af.value))+0.5;switch(m){case"outside":ab=this._bottom;Y=this._bottom+s;break;case"inside":ab=this._bottom-s;Y=this._bottom;break;case"cross":ab=this._bottom-s;Y=this._bottom+s;break;default:ab=this._bottom;Y=this._bottom+s;break}if(this.shadow){this.renderer.shadowRenderer.draw(ag,[[aa,ab],[aa,Y]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}X(aa,ab,aa,Y)}break;case"yaxis":if(af.showGridline){X(this._right,aa,this._left,aa)}if(af.showMark&&af.mark){s=af.markSize;m=af.mark;var aa=Math.round(T.u2p(af.value))+0.5;switch(m){case"outside":ab=this._left-s;Y=this._left;break;case"inside":ab=this._left;Y=this._left+s;break;case"cross":ab=this._left-s;Y=this._left+s;break;default:ab=this._left-s;Y=this._left;break}if(this.shadow){this.renderer.shadowRenderer.draw(ag,[[ab,aa],[Y,aa]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}X(ab,aa,Y,aa,{strokeStyle:T.borderColor})}break;case"x2axis":if(af.showGridline){X(aa,this._bottom,aa,this._top)}if(af.showMark&&af.mark){s=af.markSize;m=af.mark;var aa=Math.round(T.u2p(af.value))+0.5;switch(m){case"outside":ab=this._top-s;Y=this._top;break;case"inside":ab=this._top;Y=this._top+s;break;case"cross":ab=this._top-s;Y=this._top+s;break;default:ab=this._top-s;Y=this._top;break}if(this.shadow){this.renderer.shadowRenderer.draw(ag,[[aa,ab],[aa,Y]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}X(aa,ab,aa,Y)}break;case"y2axis":if(af.showGridline){X(this._left,aa,this._right,aa)}if(af.showMark&&af.mark){s=af.markSize;m=af.mark;var aa=Math.round(T.u2p(af.value))+0.5;switch(m){case"outside":ab=this._right;Y=this._right+s;break;case"inside":ab=this._right-s;Y=this._right;break;case"cross":ab=this._right-s;Y=this._right+s;break;default:ab=this._right;Y=this._right+s;break}if(this.shadow){this.renderer.shadowRenderer.draw(ag,[[ab,aa],[Y,aa]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}X(ab,aa,Y,aa,{strokeStyle:T.borderColor})}break;default:break}}}}}Q=["y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];for(var V=7;V>0;V--){var T=Z[Q[V-1]];var ac=T._ticks;if(T.show){var ae=ac[T.numberTicks-1];var W=ac[0];var S=T.getLeft();var ad=[[S,ae.getTop()+ae.getHeight()/2],[S,W.getTop()+W.getHeight()/2+1]];if(this.shadow){this.renderer.shadowRenderer.draw(ag,ad,{lineCap:"butt",fill:false,closePath:false})}X(ad[0][0],ad[0][1],ad[1][0],ad[1][1],{lineCap:"butt",strokeStyle:T.borderColor,lineWidth:T.borderWidth});for(var U=ac.length;U>0;U--){var af=ac[U-1];s=af.markSize;m=af.mark;var aa=Math.round(T.u2p(af.value))+0.5;if(af.showMark&&af.mark){switch(m){case"outside":ab=S;Y=S+s;break;case"inside":ab=S-s;Y=S;break;case"cross":ab=S-s;Y=S+s;break;default:ab=S;Y=S+s;break}ad=[[ab,aa],[Y,aa]];if(this.shadow){this.renderer.shadowRenderer.draw(ag,ad,{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}X(ab,aa,Y,aa,{strokeStyle:T.borderColor})}}}}ag.restore()}function X(al,ak,ai,ah,aj){ag.save();aj=aj||{};if(aj.lineWidth==null||aj.lineWidth!=0){B.extend(true,ag,aj);ag.beginPath();ag.moveTo(al,ak);ag.lineTo(ai,ah);ag.stroke();ag.restore()}}if(this.shadow){var ad=[[this._left,this._bottom],[this._right,this._bottom],[this._right,this._top]];this.renderer.shadowRenderer.draw(ag,ad)}if(this.borderWidth!=0&&this.drawBorder){X(this._left,this._top,this._right,this._top,{lineCap:"round",strokeStyle:Z.x2axis.borderColor,lineWidth:Z.x2axis.borderWidth});X(this._right,this._top,this._right,this._bottom,{lineCap:"round",strokeStyle:Z.y2axis.borderColor,lineWidth:Z.y2axis.borderWidth});X(this._right,this._bottom,this._left,this._bottom,{lineCap:"round",strokeStyle:Z.xaxis.borderColor,lineWidth:Z.xaxis.borderWidth});X(this._left,this._bottom,this._left,this._top,{lineCap:"round",strokeStyle:Z.yaxis.borderColor,lineWidth:Z.yaxis.borderWidth})}ag.restore()};var v=24*60*60*1000;var K=function(Q,R){Q=String(Q);while(Q.length<R){Q="0"+Q}return Q};var w={millisecond:1,second:1000,minute:60*1000,hour:60*60*1000,day:v,week:7*v,month:{add:function(S,Q){w.year.add(S,Math[Q>0?"floor":"ceil"](Q/12));var R=S.getMonth()+(Q%12);if(R==12){R=0;S.setYear(S.getFullYear()+1)}else{if(R==-1){R=11;S.setYear(S.getFullYear()-1)}}S.setMonth(R)},diff:function(U,S){var Q=U.getFullYear()-S.getFullYear();var R=U.getMonth()-S.getMonth()+(Q*12);var T=U.getDate()-S.getDate();return R+(T/30)}},year:{add:function(R,Q){R.setYear(R.getFullYear()+Math[Q>0?"floor":"ceil"](Q))},diff:function(R,Q){return w.month.diff(R,Q)/12}}};for(var J in w){if(J.substring(J.length-1)!="s"){w[J+"s"]=w[J]}}var y=function(T,S){if(Date.prototype.strftime.formatShortcuts[S]){return T.strftime(Date.prototype.strftime.formatShortcuts[S])}else{var Q=(Date.prototype.strftime.formatCodes[S]||"").split(".");var R=T["get"+Q[0]]?T["get"+Q[0]]():"";if(Q[1]){R=K(R,Q[1])}return R}};var r={succ:function(Q){return this.clone().add(1,Q)},add:function(S,R){var Q=w[R]||w.day;if(typeof Q=="number"){this.setTime(this.getTime()+(Q*S))}else{Q.add(this,S)}return this},diff:function(R,U,Q){R=Date.create(R);if(R===null){return null}var S=w[U]||w.day;if(typeof S=="number"){var T=(this.getTime()-R.getTime())/S}else{var T=S.diff(this,R)}return(Q?T:Math[T>0?"floor":"ceil"](T))},strftime:function(R){var T=R||"%Y-%m-%d",Q="",S;while(T.length>0){if(S=T.match(Date.prototype.strftime.formatCodes.matcher)){Q+=T.slice(0,S.index);Q+=(S[1]||"")+y(this,S[2]);T=T.slice(S.index+S[0].length)}else{Q+=T;T=""}}return Q},getShortYear:function(){return this.getYear()%100},getMonthNumber:function(){return this.getMonth()+1},getMonthName:function(){return Date.MONTHNAMES[this.getMonth()]},getAbbrMonthName:function(){return Date.ABBR_MONTHNAMES[this.getMonth()]},getDayName:function(){return Date.DAYNAMES[this.getDay()]},getAbbrDayName:function(){return Date.ABBR_DAYNAMES[this.getDay()]},getDayOrdinal:function(){return Date.ORDINALNAMES[this.getDate()%10]},getHours12:function(){var Q=this.getHours();return Q>12?Q-12:(Q==0?12:Q)},getAmPm:function(){return this.getHours()>=12?"PM":"AM"},getUnix:function(){return Math.round(this.getTime()/1000,0)},getGmtOffset:function(){var Q=this.getTimezoneOffset()/60;var R=Q<0?"+":"-";Q=Math.abs(Q);return R+K(Math.floor(Q),2)+":"+K((Q%1)*60,2)},getTimezoneName:function(){var Q=/(?:\((.+)\)$| ([A-Z]{3}) )/.exec(this.toString());return Q[1]||Q[2]||"GMT"+this.getGmtOffset()},toYmdInt:function(){return(this.getFullYear()*10000)+(this.getMonthNumber()*100)+this.getDate()},clone:function(){return new Date(this.getTime())}};for(var n in r){Date.prototype[n]=r[n]}var A={create:function(Q){if(Q instanceof Date){return Q}if(typeof Q=="number"){return new Date(Q)}var V=String(Q).replace(/^\s*(.+)\s*$/,"$1"),R=0,S=Date.create.patterns.length,T;var U=V;while(R<S){ms=Date.parse(U);if(!isNaN(ms)){return new Date(ms)}T=Date.create.patterns[R];if(typeof T=="function"){obj=T(U);if(obj instanceof Date){return obj}}else{U=V.replace(T[0],T[1])}R++}return NaN},MONTHNAMES:"January February March April May June July August September October November December".split(" "),ABBR_MONTHNAMES:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "),DAYNAMES:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),ABBR_DAYNAMES:"Sun Mon Tue Wed Thu Fri Sat".split(" "),ORDINALNAMES:"th st nd rd th th th th th th".split(" "),ISO:"%Y-%m-%dT%H:%M:%S.%N%G",SQL:"%Y-%m-%d %H:%M:%S",daysInMonth:function(Q,R){if(R==2){return new Date(Q,1,29).getDate()==29?29:28}return[l,31,l,31,30,31,30,31,31,30,31,30,31][R]}};for(var n in A){Date[n]=A[n]}Date.prototype.strftime.formatCodes={matcher:/()%(#?(%|[a-z]))/i,Y:"FullYear",y:"ShortYear.2",m:"MonthNumber.2","#m":"MonthNumber",B:"MonthName",b:"AbbrMonthName",d:"Date.2","#d":"Date",e:"Date",A:"DayName",a:"AbbrDayName",w:"Day",o:"DayOrdinal",H:"Hours.2","#H":"Hours",I:"Hours12.2","#I":"Hours12",p:"AmPm",M:"Minutes.2","#M":"Minutes",S:"Seconds.2","#S":"Seconds",s:"Unix",N:"Milliseconds.3","#N":"Milliseconds",O:"TimezoneOffset",Z:"TimezoneName",G:"GmtOffset"};Date.prototype.strftime.formatShortcuts={F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",D:"%m/%d/%y","#c":"%a %b %e %H:%M:%S %Y",v:"%e-%b-%Y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"};Date.create.patterns=[[/-/g,"/"],[/st|nd|rd|th/g,""],[/(3[01]|[0-2]\d)\s*\.\s*(1[0-2]|0\d)\s*\.\s*([1-9]\d{3})/,"$2/$1/$3"],[/([1-9]\d{3})\s*-\s*(1[0-2]|0\d)\s*-\s*(3[01]|[0-2]\d)/,"$2/$3/$1"],function(T){var R=T.match(/^(?:(.+)\s+)?([012]?\d)(?:\s*\:\s*(\d\d))?(?:\s*\:\s*(\d\d(\.\d*)?))?\s*(am|pm)?\s*$/i);if(R){if(R[1]){var S=Date.create(R[1]);if(isNaN(S)){return}}else{var S=new Date();S.setMilliseconds(0)}var Q=parseFloat(R[2]);if(R[6]){Q=R[6].toLowerCase()=="am"?(Q==12?0:Q):(Q==12?12:Q+12)}S.setHours(Q,parseInt(R[3]||0,10),parseInt(R[4]||0,10),((parseFloat(R[5]||0))||0)*1000);return S}else{return T}},function(T){var R=T.match(/^(?:(.+))[T|\s+]([012]\d)(?:\:(\d\d))(?:\:(\d\d))(?:\.\d+)([\+\-]\d\d\:\d\d)$/i);if(R){if(R[1]){var S=Date.create(R[1]);if(isNaN(S)){return}}else{var S=new Date();S.setMilliseconds(0)}var Q=parseFloat(R[2]);S.setHours(Q,parseInt(R[3],10),parseInt(R[4],10),parseFloat(R[5])*1000);return S}else{return T}},function(U){var S=U.match(/^([0-3]?\d)\s*[-\/.\s]{1}\s*([a-zA-Z]{3,9})\s*[-\/.\s]{1}\s*([0-3]?\d)$/);if(S){var T=new Date();var V=parseFloat(String(T.getFullYear()).slice(2,4));var W=parseInt(String(T.getFullYear())/100,10)*100;var Y=1;var Z=parseFloat(S[1]);var X=parseFloat(S[3]);var R,Q,aa;if(Z>31){Q=S[3];if(Z<V+Y){R=W+Z}else{R=W-100+Z}}else{Q=S[1];if(X<V+Y){R=W+X}else{R=W-100+X}}var aa=B.inArray(S[2],Date.ABBR_MONTHNAMES);if(aa==-1){aa=B.inArray(S[2],Date.MONTHNAMES)}T.setFullYear(R,aa,Q);T.setHours(0,0,0,0);return T}else{return U}}];if(B.jqplot.config.debug){B.date=Date.create}B.jqplot.DivTitleRenderer=function(){};B.jqplot.DivTitleRenderer.prototype.init=function(Q){B.extend(true,this,Q)};B.jqplot.DivTitleRenderer.prototype.draw=function(){var S=this.renderer;if(!this.text){this.show=false;this._elem=B('<div class="jqplot-title" style="height:0px;width:0px;"></div>')}else{if(this.text){var R;if(this.color){R=this.color}else{if(this.textColor){R=this.textColor}}var Q="position:absolute;top:0px;left:0px;";Q+=(this._plotWidth)?"width:"+this._plotWidth+"px;":"";Q+=(this.fontSize)?"font-size:"+this.fontSize+";":"";Q+=(this.textAlign)?"text-align:"+this.textAlign+";":"text-align:center;";Q+=(R)?"color:"+R+";":"";Q+=(this.paddingBottom)?"padding-bottom:"+this.paddingBottom+";":"";this._elem=B('<div class="jqplot-title" style="'+Q+'">'+this.text+"</div>");if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}}}return this._elem};B.jqplot.DivTitleRenderer.prototype.pack=function(){};B.jqplot.LineRenderer=function(){this.shapeRenderer=new B.jqplot.ShapeRenderer();this.shadowRenderer=new B.jqplot.ShadowRenderer()};B.jqplot.LineRenderer.prototype.init=function(R,V){R=R||{};var T={highlightMouseOver:R.highlightMouseOver,highlightMouseDown:R.highlightMouseDown,highlightColor:R.highlightColor};delete (R.highlightMouseOver);delete (R.highlightMouseDown);delete (R.highlightColor);B.extend(true,this.renderer,R);var U={lineJoin:"round",lineCap:"round",fill:this.fill,isarc:false,strokeStyle:this.color,fillStyle:this.fillColor,lineWidth:this.lineWidth,closePath:this.fill};this.renderer.shapeRenderer.init(U);if(this.lineWidth>2.5){var S=this.shadowOffset*(1+(Math.atan((this.lineWidth/2.5))/0.785398163-1)*0.6)}else{var S=this.shadowOffset*Math.atan((this.lineWidth/2.5))/0.785398163}var Q={lineJoin:"round",lineCap:"round",fill:this.fill,isarc:false,angle:this.shadowAngle,offset:S,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.lineWidth,closePath:this.fill};this.renderer.shadowRenderer.init(Q);this._areaPoints=[];this._boundingBox=[[],[]];if(!this.isTrendline&&this.fill){this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColor=null;if(T.highlightMouseDown&&T.highlightMouseOver==null){T.highlightMouseOver=false}B.extend(true,this,{highlightMouseOver:T.highlightMouseOver,highlightMouseDown:T.highlightMouseDown,highlightColor:T.highlightColor});if(!this.highlightColor){this.highlightColor=B.jqplot.computeHighlightColors(this.fillColor)}if(this.highlighter){this.highlighter.show=false}V.postInitHooks.addOnce(q);V.postDrawHooks.addOnce(P);V.eventListenerHooks.addOnce("jqplotMouseMove",d);V.eventListenerHooks.addOnce("jqplotMouseDown",a);V.eventListenerHooks.addOnce("jqplotMouseUp",O);V.eventListenerHooks.addOnce("jqplotClick",c);V.eventListenerHooks.addOnce("jqplotRightClick",j)}};B.jqplot.LineRenderer.prototype.setGridData=function(V){var R=this._xaxis.series_u2p;var U=this._yaxis.series_u2p;var S=this._plotData;var T=this._prevPlotData;this.gridData=[];this._prevGridData=[];for(var Q=0;Q<this.data.length;Q++){if(S[Q][0]!=null&&S[Q][1]!=null){this.gridData.push([R.call(this._xaxis,S[Q][0]),U.call(this._yaxis,S[Q][1])])}else{if(S[Q][0]==null){this.gridData.push([null,U.call(this._yaxis,S[Q][1])])}else{if(S[Q][1]==null){this.gridData.push([R.call(this._xaxis,S[Q][0]),null])}}}if(T[Q]!=null&&T[Q][0]!=null&&T[Q][1]!=null){this._prevGridData.push([R.call(this._xaxis,T[Q][0]),U.call(this._yaxis,T[Q][1])])}else{if(T[Q]!=null&&T[Q][0]==null){this._prevGridData.push([null,U.call(this._yaxis,T[Q][1])])}else{if(T[Q]!=null&&T[Q][0]!=null&&T[Q][1]==null){this._prevGridData.push([R.call(this._xaxis,T[Q][0]),null])}}}}};B.jqplot.LineRenderer.prototype.makeGridData=function(T,V){var S=this._xaxis.series_u2p;var U=this._yaxis.series_u2p;var R=[];var W=[];for(var Q=0;Q<T.length;Q++){if(T[Q][0]!=null&&T[Q][1]!=null){R.push([S.call(this._xaxis,T[Q][0]),U.call(this._yaxis,T[Q][1])])}else{if(T[Q][0]==null){R.push([null,U.call(this._yaxis,T[Q][1])])}else{if(T[Q][1]==null){R.push([S.call(this._xaxis,T[Q][0]),null])}}}}return R};B.jqplot.LineRenderer.prototype.draw=function(af,ao,R){var aj;var Z=(R!=l)?R:{};var T=(Z.shadow!=l)?Z.shadow:this.shadow;var ap=(Z.showLine!=l)?Z.showLine:this.showLine;var ai=(Z.fill!=l)?Z.fill:this.fill;var Q=(Z.fillAndStroke!=l)?Z.fillAndStroke:this.fillAndStroke;var aa,ag,ad,ak;af.save();if(ao.length){if(ap){if(ai){if(this.fillToZero){var U=new B.jqplot.ColorGenerator(this.negativeSeriesColors);var al=U.get(this.index);if(!this.useNegativeColors){al=Z.fillStyle}var X=false;var Y=Z.fillStyle;if(Q){var an=ao.slice(0)}if(this.index==0||!this._stack){var ae=[];this._areaPoints=[];var am=this._yaxis.series_u2p(this.fillToValue);var S=this._xaxis.series_u2p(this.fillToValue);if(this.fillAxis=="y"){ae.push([ao[0][0],am]);this._areaPoints.push([ao[0][0],am]);for(var aj=0;aj<ao.length-1;aj++){ae.push(ao[aj]);this._areaPoints.push(ao[aj]);if(this._plotData[aj][1]*this._plotData[aj+1][1]<0){if(this._plotData[aj][1]<0){X=true;Z.fillStyle=al}else{X=false;Z.fillStyle=Y}var W=ao[aj][0]+(ao[aj+1][0]-ao[aj][0])*(am-ao[aj][1])/(ao[aj+1][1]-ao[aj][1]);ae.push([W,am]);this._areaPoints.push([W,am]);if(T){this.renderer.shadowRenderer.draw(af,ae,Z)}this.renderer.shapeRenderer.draw(af,ae,Z);ae=[[W,am]]}}if(this._plotData[ao.length-1][1]<0){X=true;Z.fillStyle=al}else{X=false;Z.fillStyle=Y}ae.push(ao[ao.length-1]);this._areaPoints.push(ao[ao.length-1]);ae.push([ao[ao.length-1][0],am]);this._areaPoints.push([ao[ao.length-1][0],am])}if(T){this.renderer.shadowRenderer.draw(af,ae,Z)}this.renderer.shapeRenderer.draw(af,ae,Z)}else{var ac=this._prevGridData;for(var aj=ac.length;aj>0;aj--){ao.push(ac[aj-1])}if(T){this.renderer.shadowRenderer.draw(af,ao,Z)}this._areaPoints=ao;this.renderer.shapeRenderer.draw(af,ao,Z)}}else{if(Q){var an=ao.slice(0)}if(this.index==0||!this._stack){var V=af.canvas.height;ao.unshift([ao[0][0],V]);len=ao.length;ao.push([ao[len-1][0],V])}else{var ac=this._prevGridData;for(var aj=ac.length;aj>0;aj--){ao.push(ac[aj-1])}}this._areaPoints=ao;if(T){this.renderer.shadowRenderer.draw(af,ao,Z)}this.renderer.shapeRenderer.draw(af,ao,Z)}if(Q){var ah=B.extend(true,{},Z,{fill:false,closePath:false});this.renderer.shapeRenderer.draw(af,an,ah);if(this.markerRenderer.show){for(aj=0;aj<an.length;aj++){this.markerRenderer.draw(an[aj][0],an[aj][1],af,Z.markerOptions)}}}}else{if(T){this.renderer.shadowRenderer.draw(af,ao,Z)}this.renderer.shapeRenderer.draw(af,ao,Z)}}var aa=ad=ag=ak=null;for(aj=0;aj<this._areaPoints.length;aj++){var ab=this._areaPoints[aj];if(aa>ab[0]||aa==null){aa=ab[0]}if(ak<ab[1]||ak==null){ak=ab[1]}if(ad<ab[0]||ad==null){ad=ab[0]}if(ag>ab[1]||ag==null){ag=ab[1]}}this._boundingBox=[[aa,ak],[ad,ag]];if(this.markerRenderer.show&&!ai){for(aj=0;aj<ao.length;aj++){if(ao[aj][0]!=null&&ao[aj][1]!=null){this.markerRenderer.draw(ao[aj][0],ao[aj][1],af,Z.markerOptions)}}}}af.restore()};B.jqplot.LineRenderer.prototype.drawShadow=function(Q,S,R){};function q(S,R,Q){for(i=0;i<this.series.length;i++){if(this.series[i].renderer.constructor==B.jqplot.LineRenderer){if(this.series[i].highlightMouseOver){this.series[i].highlightMouseDown=false}}}this.target.bind("mouseout",{plot:this},function(T){M(T.data.plot)})}function P(){this.plugins.lineRenderer={highlightedSeriesIndex:null};this.plugins.lineRenderer.highlightCanvas=new B.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.lineRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-lineRenderer-highlight-canvas",this._plotDimensions));var Q=this.plugins.lineRenderer.highlightCanvas.setContext()}function N(W,V,T,S){var R=W.series[V];var Q=W.plugins.lineRenderer.highlightCanvas;Q._ctx.clearRect(0,0,Q._ctx.canvas.width,Q._ctx.canvas.height);R._highlightedPoint=T;W.plugins.lineRenderer.highlightedSeriesIndex=V;var U={fillStyle:R.highlightColor};R.renderer.shapeRenderer.draw(Q._ctx,S,U)}function M(S){var Q=S.plugins.lineRenderer.highlightCanvas;Q._ctx.clearRect(0,0,Q._ctx.canvas.width,Q._ctx.canvas.height);for(var R=0;R<S.series.length;R++){S.series[R]._highlightedPoint=null}S.plugins.lineRenderer.highlightedSeriesIndex=null;S.target.trigger("jqplotDataUnhighlight")}function d(U,T,X,W,V){if(W){var S=[W.seriesIndex,W.pointIndex,W.data];var R=jQuery.Event("jqplotDataMouseOver");R.pageX=U.pageX;R.pageY=U.pageY;V.target.trigger(R,S);if(V.series[S[0]].highlightMouseOver&&!(S[0]==V.plugins.lineRenderer.highlightedSeriesIndex)){var Q=jQuery.Event("jqplotDataHighlight");Q.pageX=U.pageX;Q.pageY=U.pageY;V.target.trigger(Q,S);N(V,W.seriesIndex,W.pointIndex,W.points)}}else{if(W==null){M(V)}}}function a(T,S,W,V,U){if(V){var R=[V.seriesIndex,V.pointIndex,V.data];if(U.series[R[0]].highlightMouseDown&&!(R[0]==U.plugins.lineRenderer.highlightedSeriesIndex)){var Q=jQuery.Event("jqplotDataHighlight");Q.pageX=T.pageX;Q.pageY=T.pageY;U.target.trigger(Q,R);N(U,V.seriesIndex,V.pointIndex,V.points)}}else{if(V==null){M(U)}}}function O(S,R,V,U,T){var Q=T.plugins.lineRenderer.highlightedSeriesIndex;if(Q!=null&&T.series[Q].highlightMouseDown){M(T)}}function c(T,S,W,V,U){if(V){var R=[V.seriesIndex,V.pointIndex,V.data];var Q=jQuery.Event("jqplotDataClick");Q.pageX=T.pageX;Q.pageY=T.pageY;U.target.trigger(Q,R)}}function j(U,T,X,W,V){if(W){var S=[W.seriesIndex,W.pointIndex,W.data];var Q=V.plugins.lineRenderer.highlightedSeriesIndex;if(Q!=null&&V.series[Q].highlightMouseDown){M(V)}var R=jQuery.Event("jqplotDataRightClick");R.pageX=U.pageX;R.pageY=U.pageY;V.target.trigger(R,S)}}B.jqplot.LinearAxisRenderer=function(){};B.jqplot.LinearAxisRenderer.prototype.init=function(S){B.extend(true,this,S);var Q=this._dataBounds;for(var T=0;T<this._series.length;T++){var U=this._series[T];var V=U._plotData;for(var R=0;R<V.length;R++){if(this.name=="xaxis"||this.name=="x2axis"){if((V[R][0]!=null&&V[R][0]<Q.min)||Q.min==null){Q.min=V[R][0]}if((V[R][0]!=null&&V[R][0]>Q.max)||Q.max==null){Q.max=V[R][0]}}else{if((V[R][1]!=null&&V[R][1]<Q.min)||Q.min==null){Q.min=V[R][1]}if((V[R][1]!=null&&V[R][1]>Q.max)||Q.max==null){Q.max=V[R][1]}}}}};B.jqplot.LinearAxisRenderer.prototype.draw=function(Q){if(this.show){this.renderer.createTicks.call(this);var W=0;var R;if(this._elem){this._elem.empty()}this._elem=B('<div class="jqplot-axis jqplot-'+this.name+'" style="position:absolute;"></div>');if(this.name=="xaxis"||this.name=="x2axis"){this._elem.width(this._plotDimensions.width)}else{this._elem.height(this._plotDimensions.height)}this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);if(this._label.show){var V=this._label.draw(Q);V.appendTo(this._elem)}if(this.showTicks){var U=this._ticks;for(var T=0;T<U.length;T++){var S=U[T];if(S.showLabel&&(!S.isMinorTick||this.showMinorTicks)){var V=S.draw(Q);V.appendTo(this._elem)}}}}return this._elem};B.jqplot.LinearAxisRenderer.prototype.reset=function(){this.min=this._min;this.max=this._max;this.tickInterval=this._tickInterval;this.numberTicks=this._numberTicks};B.jqplot.LinearAxisRenderer.prototype.set=function(){var X=0;var S;var R=0;var W=0;var Q=(this._label==null)?false:this._label.show;if(this.show&&this.showTicks){var V=this._ticks;for(var U=0;U<V.length;U++){var T=V[U];if(T.showLabel&&(!T.isMinorTick||this.showMinorTicks)){if(this.name=="xaxis"||this.name=="x2axis"){S=T._elem.outerHeight(true)}else{S=T._elem.outerWidth(true)}if(S>X){X=S}}}if(Q){R=this._label._elem.outerWidth(true);W=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){X=X+W;this._elem.css({height:X+"px",left:"0px",bottom:"0px"})}else{if(this.name=="x2axis"){X=X+W;this._elem.css({height:X+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){X=X+R;this._elem.css({width:X+"px",left:"0px",top:"0px"});if(Q&&this._label.constructor==B.jqplot.AxisLabelRenderer){this._label._elem.css("width",R+"px")}}else{X=X+R;this._elem.css({width:X+"px",right:"0px",top:"0px"});if(Q&&this._label.constructor==B.jqplot.AxisLabelRenderer){this._label._elem.css("width",R+"px")}}}}}};B.jqplot.LinearAxisRenderer.prototype.createTicks=function(){var at=this._ticks;var am=this.ticks;var ad=this.name;var af=this._dataBounds;var Q,U;var aF,ak;var W,V;var aD,aA;var aj=this.min;var aE=this.max;var aw=this.numberTicks;var aI=this.tickInterval;if(am.length){for(aA=0;aA<am.length;aA++){var ap=am[aA];var au=new this.tickRenderer(this.tickOptions);if(ap.constructor==Array){au.value=ap[0];au.label=ap[1];if(!this.showTicks){au.showLabel=false;au.showMark=false}else{if(!this.showTickMarks){au.showMark=false}}au.setTick(ap[0],this.name);this._ticks.push(au)}else{au.value=ap;if(!this.showTicks){au.showLabel=false;au.showMark=false}else{if(!this.showTickMarks){au.showMark=false}}au.setTick(ap,this.name);this._ticks.push(au)}}this.numberTicks=am.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.tickInterval=(this.max-this.min)/(this.numberTicks-1)}else{if(ad=="xaxis"||ad=="x2axis"){Q=this._plotDimensions.width}else{Q=this._plotDimensions.height}if(!this.autoscale&&this.min!=null&&this.max!=null&&this.numberTicks!=null){this.tickInterval=null}aF=((this.min!=null)?this.min:af.min);ak=((this.max!=null)?this.max:af.max);if(aF==ak){var R=0.05;if(aF>0){R=Math.max(Math.log(aF)/Math.LN10,0.05)}aF-=R;ak+=R}var ab=ak-aF;var aq,ac;var Z;if(this.autoscale&&this.min==null&&this.max==null){var S,T,Y;var ag=false;var ao=false;var ae={min:null,max:null,average:null,stddev:null};for(var aA=0;aA<this._series.length;aA++){var av=this._series[aA];var ah=(av.fillAxis=="x")?av._xaxis.name:av._yaxis.name;if(this.name==ah){var ar=av._plotValues[av.fillAxis];var ai=ar[0];var aB=ar[0];for(var az=1;az<ar.length;az++){if(ar[az]<ai){ai=ar[az]}else{if(ar[az]>aB){aB=ar[az]}}}var aa=(aB-ai)/aB;if(av.renderer.constructor==B.jqplot.BarRenderer){if(ai>=0&&(av.fillToZero||aa>0.1)){ag=true}else{ag=false;if(av.fill&&av.fillToZero&&ai<0&&aB>0){ao=true}else{ao=false}}}else{if(av.fill){if(ai>=0&&(av.fillToZero||aa>0.1)){ag=true}else{if(ai<0&&aB>0&&av.fillToZero){ag=false;ao=true}else{ag=false;ao=false}}}else{if(ai<0){ag=false}}}}}if(ag){this.numberTicks=2+Math.ceil((Q-(this.tickSpacing-1))/this.tickSpacing);this.min=0;aj=0;T=ak/(this.numberTicks-1);Z=Math.pow(10,Math.abs(Math.floor(Math.log(T)/Math.LN10)));if(T/Z==parseInt(T/Z,10)){T+=Z}this.tickInterval=Math.ceil(T/Z)*Z;this.max=this.tickInterval*(this.numberTicks-1)}else{if(ao){this.numberTicks=2+Math.ceil((Q-(this.tickSpacing-1))/this.tickSpacing);var al=Math.ceil(Math.abs(aF)/ab*(this.numberTicks-1));var aH=this.numberTicks-1-al;T=Math.max(Math.abs(aF/al),Math.abs(ak/aH));Z=Math.pow(10,Math.abs(Math.floor(Math.log(T)/Math.LN10)));this.tickInterval=Math.ceil(T/Z)*Z;this.max=this.tickInterval*aH;this.min=-this.tickInterval*al}else{if(this.numberTicks==null){if(this.tickInterval){this.numberTicks=3+Math.ceil(ab/this.tickInterval)}else{this.numberTicks=2+Math.ceil((Q-(this.tickSpacing-1))/this.tickSpacing)}}if(this.tickInterval==null){T=ab/(this.numberTicks-1);if(T<1){Z=Math.pow(10,Math.abs(Math.floor(Math.log(T)/Math.LN10)))}else{Z=1}this.tickInterval=Math.ceil(T*Z*this.pad)/Z}else{Z=1/this.tickInterval}S=this.tickInterval*(this.numberTicks-1);Y=(S-ab)/2;if(this.min==null){this.min=Math.floor(Z*(aF-Y))/Z}if(this.max==null){this.max=this.min+S}}}}else{aq=(this.min!=null)?this.min:aF-ab*(this.padMin-1);ac=(this.max!=null)?this.max:ak+ab*(this.padMax-1);this.min=aq;this.max=ac;ab=this.max-this.min;if(this.numberTicks==null){if(this.tickInterval!=null){this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(Q>100){this.numberTicks=parseInt(3+(Q-100)/75,10)}else{this.numberTicks=2}}}if(this.tickInterval==null){this.tickInterval=ab/(this.numberTicks-1)}}if(this.renderer.constructor==B.jqplot.LinearAxisRenderer){ab=this.max-this.min;var aG=new this.tickRenderer(this.tickOptions);var an=aG.formatString||B.jqplot.config.defaultTickFormatString;var an=an.match(B.jqplot.sprintf.regex)[0];var aC=0;if(an){if(an.search(/[fFeEgGpP]/)>-1){var ay=an.match(/\%\.(\d{0,})?[eEfFgGpP]/);if(ay){aC=parseInt(ay[1],10)}else{aC=6}}else{if(an.search(/[di]/)>-1){aC=0}}var X=Math.pow(10,-aC);if(this.tickInterval<X){if(aw==null&&aI==null){this.tickInterval=X;if(aE==null&&aj==null){this.min=Math.floor(this._dataBounds.min/X)*X;if(this.min==this._dataBounds.min){this.min=this._dataBounds.min-this.tickInterval}this.max=Math.ceil(this._dataBounds.max/X)*X;if(this.max==this._dataBounds.max){this.max=this._dataBounds.max+this.tickInterval}var ax=(this.max-this.min)/this.tickInterval;ax=ax.toFixed(11);ax=Math.ceil(ax);this.numberTicks=ax+1}else{if(aE==null){var ax=(this._dataBounds.max-this.min)/this.tickInterval;ax=ax.toFixed(11);this.numberTicks=Math.ceil(ax)+2;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(aj==null){var ax=(this.max-this._dataBounds.min)/this.tickInterval;ax=ax.toFixed(11);this.numberTicks=Math.ceil(ax)+2;this.min=this.max-this.tickInterval*(this.numberTicks-1)}else{this.numberTicks=Math.ceil((aE-aj)/this.tickInterval)+1;this.min=Math.floor(aj*Math.pow(10,aC))/Math.pow(10,aC);this.max=Math.ceil(aE*Math.pow(10,aC))/Math.pow(10,aC);this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1}}}}}}}for(var aA=0;aA<this.numberTicks;aA++){aD=this.min+aA*this.tickInterval;var au=new this.tickRenderer(this.tickOptions);if(!this.showTicks){au.showLabel=false;au.showMark=false}else{if(!this.showTickMarks){au.showMark=false}}au.setTick(aD,this.name);this._ticks.push(au)}}};B.jqplot.LinearAxisRenderer.prototype.pack=function(Z,U){var ac=this._ticks;var aa=this.max;var W=this.min;var T=U.max;var ag=U.min;var X=(this._label==null)?false:this._label.show;for(var Q in Z){this._elem.css(Q,Z[Q])}this._offsets=U;var S=T-ag;var af=aa-W;this.p2u=function(ah){return(ah-ag)*af/S+W};this.u2p=function(ah){return(ah-W)*S/af+ag};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(ah){return(ah-W)*S/af};this.series_p2u=function(ah){return ah*af/S+W}}else{this.series_u2p=function(ah){return(ah-aa)*S/af};this.series_p2u=function(ah){return ah*af/S+aa}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(i=0;i<ac.length;i++){var ae=ac[i];if(ae.show&&ae.showLabel){var V;if(ae.constructor==B.jqplot.CanvasAxisTickRenderer&&ae.angle){var ad=(this.name=="xaxis")?1:-1;switch(ae.labelPosition){case"auto":if(ad*ae.angle<0){V=-ae.getWidth()+ae._textRenderer.height*Math.sin(-ae._textRenderer.angle)/2}else{V=-ae._textRenderer.height*Math.sin(ae._textRenderer.angle)/2}break;case"end":V=-ae.getWidth()+ae._textRenderer.height*Math.sin(-ae._textRenderer.angle)/2;break;case"start":V=-ae._textRenderer.height*Math.sin(ae._textRenderer.angle)/2;break;case"middle":V=-ae.getWidth()/2+ae._textRenderer.height*Math.sin(-ae._textRenderer.angle)/2;break;default:V=-ae.getWidth()/2+ae._textRenderer.height*Math.sin(-ae._textRenderer.angle)/2;break}}else{V=-ae.getWidth()/2}var R=this.u2p(ae.value)+V+"px";ae._elem.css("left",R);ae.pack()}}if(X){var ab=this._label._elem.outerWidth(true);this._label._elem.css("left",ag+S/2-ab/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(i=0;i<ac.length;i++){var ae=ac[i];if(ae.show&&ae.showLabel){var V;if(ae.constructor==B.jqplot.CanvasAxisTickRenderer&&ae.angle){var ad=(this.name=="yaxis")?1:-1;switch(ae.labelPosition){case"auto":case"end":if(ad*ae.angle<0){V=-ae._textRenderer.height*Math.cos(-ae._textRenderer.angle)/2}else{V=-ae.getHeight()+ae._textRenderer.height*Math.cos(ae._textRenderer.angle)/2}break;case"start":if(ae.angle>0){V=-ae._textRenderer.height*Math.cos(-ae._textRenderer.angle)/2}else{V=-ae.getHeight()+ae._textRenderer.height*Math.cos(ae._textRenderer.angle)/2}break;case"middle":V=-ae.getHeight()/2;break;default:V=-ae.getHeight()/2;break}}else{V=-ae.getHeight()/2}var R=this.u2p(ae.value)+V+"px";ae._elem.css("top",R);ae.pack()}}if(X){var Y=this._label._elem.outerHeight(true);this._label._elem.css("top",T-S/2-Y/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}};B.jqplot.MarkerRenderer=function(Q){this.show=true;this.style="filledCircle";this.lineWidth=2;this.size=9;this.color="#666666";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1;this.shadowDepth=3;this.shadowAlpha="0.07";this.shadowRenderer=new B.jqplot.ShadowRenderer();this.shapeRenderer=new B.jqplot.ShapeRenderer();B.extend(true,this,Q)};B.jqplot.MarkerRenderer.prototype.init=function(Q){B.extend(true,this,Q);var S={angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,lineWidth:this.lineWidth,depth:this.shadowDepth,closePath:true};if(this.style.indexOf("filled")!=-1){S.fill=true}if(this.style.indexOf("ircle")!=-1){S.isarc=true;S.closePath=false}this.shadowRenderer.init(S);var R={fill:false,isarc:false,strokeStyle:this.color,fillStyle:this.color,lineWidth:this.lineWidth,closePath:true};if(this.style.indexOf("filled")!=-1){R.fill=true}if(this.style.indexOf("ircle")!=-1){R.isarc=true;R.closePath=false}this.shapeRenderer.init(R)};B.jqplot.MarkerRenderer.prototype.drawDiamond=function(S,R,V,U,X){var Q=1.2;var Y=this.size/2/Q;var W=this.size/2*Q;var T=[[S-Y,R],[S,R+W],[S+Y,R],[S,R-W]];if(this.shadow){this.shadowRenderer.draw(V,T)}this.shapeRenderer.draw(V,T,X)};B.jqplot.MarkerRenderer.prototype.drawPlus=function(T,S,W,V,Z){var R=1;var aa=this.size/2*R;var X=this.size/2*R;var Y=[[T,S-X],[T,S+X]];var U=[[T+aa,S],[T-aa,S]];var Q=B.extend(true,{},this.options,{closePath:false});if(this.shadow){this.shadowRenderer.draw(W,Y,{closePath:false});this.shadowRenderer.draw(W,U,{closePath:false})}this.shapeRenderer.draw(W,Y,Q);this.shapeRenderer.draw(W,U,Q)};B.jqplot.MarkerRenderer.prototype.drawX=function(T,S,W,V,Z){var R=1;var aa=this.size/2*R;var X=this.size/2*R;var Q=B.extend(true,{},this.options,{closePath:false});var Y=[[T-aa,S-X],[T+aa,S+X]];var U=[[T-aa,S+X],[T+aa,S-X]];if(this.shadow){this.shadowRenderer.draw(W,Y,{closePath:false});this.shadowRenderer.draw(W,U,{closePath:false})}this.shapeRenderer.draw(W,Y,Q);this.shapeRenderer.draw(W,U,Q)};B.jqplot.MarkerRenderer.prototype.drawDash=function(S,R,V,U,X){var Q=1;var Y=this.size/2*Q;var W=this.size/2*Q;var T=[[S-Y,R],[S+Y,R]];if(this.shadow){this.shadowRenderer.draw(V,T)}this.shapeRenderer.draw(V,T,X)};B.jqplot.MarkerRenderer.prototype.drawSquare=function(S,R,V,U,X){var Q=1;var Y=this.size/2/Q;var W=this.size/2*Q;var T=[[S-Y,R-W],[S-Y,R+W],[S+Y,R+W],[S+Y,R-W]];if(this.shadow){this.shadowRenderer.draw(V,T)}this.shapeRenderer.draw(V,T,X)};B.jqplot.MarkerRenderer.prototype.drawCircle=function(R,X,T,W,U){var Q=this.size/2;var S=2*Math.PI;var V=[R,X,Q,0,S,true];if(this.shadow){this.shadowRenderer.draw(T,V)}this.shapeRenderer.draw(T,V,U)};B.jqplot.MarkerRenderer.prototype.draw=function(Q,T,R,S){S=S||{};if(S.show==null||S.show!=false){if(S.color&&!S.fillStyle){S.fillStyle=S.color}if(S.color&&!S.strokeStyle){S.strokeStyle=S.color}switch(this.style){case"diamond":this.drawDiamond(Q,T,R,false,S);break;case"filledDiamond":this.drawDiamond(Q,T,R,true,S);break;case"circle":this.drawCircle(Q,T,R,false,S);break;case"filledCircle":this.drawCircle(Q,T,R,true,S);break;case"square":this.drawSquare(Q,T,R,false,S);break;case"filledSquare":this.drawSquare(Q,T,R,true,S);break;case"x":this.drawX(Q,T,R,true,S);break;case"plus":this.drawPlus(Q,T,R,true,S);break;case"dash":this.drawDash(Q,T,R,true,S);break;default:this.drawDiamond(Q,T,R,false,S);break}}};B.jqplot.ShadowRenderer=function(Q){this.angle=45;this.offset=1;this.alpha=0.07;this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.depth=3;this.strokeStyle="rgba(0,0,0,0.1)";this.isarc=false;B.extend(true,this,Q)};B.jqplot.ShadowRenderer.prototype.init=function(Q){B.extend(true,this,Q)};B.jqplot.ShadowRenderer.prototype.draw=function(Z,X,ab){Z.save();var Q=(ab!=null)?ab:{};var Y=(Q.fill!=null)?Q.fill:this.fill;var W=(Q.closePath!=null)?Q.closePath:this.closePath;var T=(Q.offset!=null)?Q.offset:this.offset;var R=(Q.alpha!=null)?Q.alpha:this.alpha;var V=(Q.depth!=null)?Q.depth:this.depth;var aa=(Q.isarc!=null)?Q.isarc:this.isarc;Z.lineWidth=(Q.lineWidth!=null)?Q.lineWidth:this.lineWidth;Z.lineJoin=(Q.lineJoin!=null)?Q.lineJoin:this.lineJoin;Z.lineCap=(Q.lineCap!=null)?Q.lineCap:this.lineCap;Z.strokeStyle=Q.strokeStyle||this.strokeStyle||"rgba(0,0,0,"+R+")";Z.fillStyle=Q.fillStyle||this.fillStyle||"rgba(0,0,0,"+R+")";for(var S=0;S<V;S++){Z.translate(Math.cos(this.angle*Math.PI/180)*T,Math.sin(this.angle*Math.PI/180)*T);Z.beginPath();if(aa){Z.arc(X[0],X[1],X[2],X[3],X[4],true)}else{Z.moveTo(X[0][0],X[0][1]);for(var U=1;U<X.length;U++){if(X[U][0]!=null&&X[U][1]!=null){Z.lineTo(X[U][0],X[U][1])}else{U++;if(U<X.length){Z.moveTo(X[U][0],X[U][1])}}}}if(W){Z.closePath()}if(Y){Z.fill()}else{Z.stroke()}}Z.restore()};B.jqplot.ShapeRenderer=function(Q){this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.isarc=false;this.fillRect=false;this.strokeRect=false;this.clearRect=false;this.strokeStyle="#999999";this.fillStyle="#999999";B.extend(true,this,Q)};B.jqplot.ShapeRenderer.prototype.init=function(Q){B.extend(true,this,Q)};B.jqplot.ShapeRenderer.prototype.draw=function(Y,W,aa){Y.save();var Q=(aa!=null)?aa:{};var X=(Q.fill!=null)?Q.fill:this.fill;var U=(Q.closePath!=null)?Q.closePath:this.closePath;var V=(Q.fillRect!=null)?Q.fillRect:this.fillRect;var S=(Q.strokeRect!=null)?Q.strokeRect:this.strokeRect;var R=(Q.clearRect!=null)?Q.clearRect:this.clearRect;var Z=(Q.isarc!=null)?Q.isarc:this.isarc;Y.lineWidth=Q.lineWidth||this.lineWidth;Y.lineJoin=Q.lineJoing||this.lineJoin;Y.lineCap=Q.lineCap||this.lineCap;Y.strokeStyle=(Q.strokeStyle||Q.color)||this.strokeStyle;Y.fillStyle=Q.fillStyle||this.fillStyle;Y.beginPath();if(Z){Y.arc(W[0],W[1],W[2],W[3],W[4],true);if(U){Y.closePath()}if(X){Y.fill()}else{Y.stroke()}Y.restore();return}else{if(R){Y.clearRect(W[0],W[1],W[2],W[3]);Y.restore();return}else{if(V||S){if(V){Y.fillRect(W[0],W[1],W[2],W[3])}if(S){Y.strokeRect(W[0],W[1],W[2],W[3]);Y.restore();return}}else{Y.moveTo(W[0][0],W[0][1]);for(var T=1;T<W.length;T++){if(W[T][0]!=null&&W[T][1]!=null){Y.lineTo(W[T][0],W[T][1])}else{T++;if(T<W.length){Y.moveTo(W[T][0],W[T][1])}}}if(U){Y.closePath()}if(X){Y.fill()}else{Y.stroke()}}}}Y.restore()};B.jqplot.TableLegendRenderer=function(){};B.jqplot.TableLegendRenderer.prototype.init=function(Q){B.extend(true,this,Q)};B.jqplot.TableLegendRenderer.prototype.addrow=function(T,R,W,S){var Q=(W)?this.rowSpacing:"0";if(S){var V=B('<tr class="jqplot-table-legend"></tr>').prependTo(this._elem)}else{var V=B('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem)}if(this.showSwatches){B('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+Q+';"><div><div class="jqplot-table-legend-swatch" style="background-color:'+R+";border-color:"+R+';"></div></div></td>').appendTo(V)}if(this.showLabels){var U=B('<td class="jqplot-table-legend" style="padding-top:'+Q+';"></td>');U.appendTo(V);if(this.escapeHtml){U.text(T)}else{U.html(T)}}};B.jqplot.TableLegendRenderer.prototype.draw=function(){var X=this;if(this.show){var U=this._series;var Z="position:absolute;";Z+=(this.background)?"background:"+this.background+";":"";Z+=(this.border)?"border:"+this.border+";":"";Z+=(this.fontSize)?"font-size:"+this.fontSize+";":"";Z+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";Z+=(this.textColor)?"color:"+this.textColor+";":"";Z+=(this.marginTop!=null)?"margin-top:"+this.marginTop+";":"";Z+=(this.marginBottom!=null)?"margin-bottom:"+this.marginBottom+";":"";Z+=(this.marginLeft!=null)?"margin-left:"+this.marginLeft+";":"";Z+=(this.marginRight!=null)?"margin-right:"+this.marginRight+";":"";this._elem=B('<table class="jqplot-table-legend" style="'+Z+'"></table>');var Q=false,W=false;for(var V=0;V<U.length;V++){s=U[V];if(s._stack||s.renderer.constructor==B.jqplot.BezierCurveRenderer){W=true}if(s.show&&s.showLabel){var T=this.labels[V]||s.label.toString();if(T){var R=s.color;if(W&&V<U.length-1){Q=true}else{if(W&&V==U.length-1){Q=false}}this.renderer.addrow.call(this,T,R,Q,W);Q=true}for(var S=0;S<B.jqplot.addLegendRowHooks.length;S++){var Y=B.jqplot.addLegendRowHooks[S].call(this,s);if(Y){this.renderer.addrow.call(this,Y.label,Y.color,Q);Q=true}}}}}return this._elem};B.jqplot.TableLegendRenderer.prototype.pack=function(S){if(this.show){if(this.placement=="insideGrid"){switch(this.location){case"nw":var R=S.left;var Q=S.top;this._elem.css("left",R);this._elem.css("top",Q);break;case"n":var R=(S.left+(this._plotDimensions.width-S.right))/2-this.getWidth()/2;var Q=S.top;this._elem.css("left",R);this._elem.css("top",Q);break;case"ne":var R=S.right;var Q=S.top;this._elem.css({right:R,top:Q});break;case"e":var R=S.right;var Q=(S.top+(this._plotDimensions.height-S.bottom))/2-this.getHeight()/2;this._elem.css({right:R,top:Q});break;case"se":var R=S.right;var Q=S.bottom;this._elem.css({right:R,bottom:Q});break;case"s":var R=(S.left+(this._plotDimensions.width-S.right))/2-this.getWidth()/2;var Q=S.bottom;this._elem.css({left:R,bottom:Q});break;case"sw":var R=S.left;var Q=S.bottom;this._elem.css({left:R,bottom:Q});break;case"w":var R=S.left;var Q=(S.top+(this._plotDimensions.height-S.bottom))/2-this.getHeight()/2;this._elem.css({left:R,top:Q});break;default:var R=S.right;var Q=S.bottom;this._elem.css({right:R,bottom:Q});break}}else{if(this.placement=="outside"){switch(this.location){case"nw":var R=this._plotDimensions.width-S.left;var Q=S.top;this._elem.css("right",R);this._elem.css("top",Q);break;case"n":var R=(S.left+(this._plotDimensions.width-S.right))/2-this.getWidth()/2;var Q=this._plotDimensions.height-S.top;this._elem.css("left",R);this._elem.css("bottom",Q);break;case"ne":var R=this._plotDimensions.width-S.right;var Q=S.top;this._elem.css({left:R,top:Q});break;case"e":var R=this._plotDimensions.width-S.right;var Q=(S.top+(this._plotDimensions.height-S.bottom))/2-this.getHeight()/2;this._elem.css({left:R,top:Q});break;case"se":var R=this._plotDimensions.width-S.right;var Q=S.bottom;this._elem.css({left:R,bottom:Q});break;case"s":var R=(S.left+(this._plotDimensions.width-S.right))/2-this.getWidth()/2;var Q=this._plotDimensions.height-S.bottom;this._elem.css({left:R,top:Q});break;case"sw":var R=this._plotDimensions.width-S.left;var Q=S.bottom;this._elem.css({right:R,bottom:Q});break;case"w":var R=this._plotDimensions.width-S.left;var Q=(S.top+(this._plotDimensions.height-S.bottom))/2-this.getHeight()/2;this._elem.css({right:R,top:Q});break;default:var R=S.right;var Q=S.bottom;this._elem.css({right:R,bottom:Q});break}}else{switch(this.location){case"nw":this._elem.css({left:0,top:S.top});break;case"n":var R=(S.left+(this._plotDimensions.width-S.right))/2-this.getWidth()/2;this._elem.css({left:R,top:S.top});break;case"ne":this._elem.css({right:0,top:S.top});break;case"e":var Q=(S.top+(this._plotDimensions.height-S.bottom))/2-this.getHeight()/2;this._elem.css({right:S.right,top:Q});break;case"se":this._elem.css({right:S.right,bottom:S.bottom});break;case"s":var R=(S.left+(this._plotDimensions.width-S.right))/2-this.getWidth()/2;this._elem.css({left:R,bottom:S.bottom});break;case"sw":this._elem.css({left:S.left,bottom:S.bottom});break;case"w":var Q=(S.top+(this._plotDimensions.height-S.bottom))/2-this.getHeight()/2;this._elem.css({left:S.left,top:Q});break;default:this._elem.css({right:S.right,bottom:S.bottom});break}}}}};B.jqplot.ThemeEngine=function(){this.themes={};this.activeTheme=null};B.jqplot.ThemeEngine.prototype.init=function(){var T=new B.jqplot.Theme({_name:"Default"});var V,R;for(V in T.target){if(V=="textColor"){T.target[V]=this.target.css("color")}else{T.target[V]=this.target.css(V)}}if(this.title.show&&this.title._elem){for(V in T.title){if(V=="textColor"){T.title[V]=this.title._elem.css("color")}else{T.title[V]=this.title._elem.css(V)}}}for(V in T.grid){T.grid[V]=this.grid[V]}if(T.grid.backgroundColor==null&&this.grid.background!=null){T.grid.backgroundColor=this.grid.background}if(this.legend.show&&this.legend._elem){for(V in T.legend){if(V=="textColor"){T.legend[V]=this.legend._elem.css("color")}else{T.legend[V]=this.legend._elem.css(V)}}}var S;for(R=0;R<this.series.length;R++){S=this.series[R];if(S.renderer.constructor==B.jqplot.LineRenderer){T.series.push(new h())}else{if(S.renderer.constructor==B.jqplot.BarRenderer){T.series.push(new H())}else{if(S.renderer.constructor==B.jqplot.PieRenderer){T.series.push(new b())}else{if(S.renderer.constructor==B.jqplot.DonutRenderer){T.series.push(new x())}else{if(S.renderer.constructor==B.jqplot.FunnelRenderer){T.series.push(new L())}else{if(S.renderer.constructor==B.jqplot.MeterGaugeRenderer){T.series.push(new u())}else{T.series.push({})}}}}}}for(V in T.series[R]){T.series[R][V]=S[V]}}var Q,U;for(V in this.axes){U=this.axes[V];Q=T.axes[V]=new E();Q.borderColor=U.borderColor;Q.borderWidth=U.borderWidth;if(U._ticks&&U._ticks[0]){for(nn in Q.ticks){if(U._ticks[0].hasOwnProperty(nn)){Q.ticks[nn]=U._ticks[0][nn]}else{if(U._ticks[0]._elem){Q.ticks[nn]=U._ticks[0]._elem.css(nn)}}}}if(U._label&&U._label.show){for(nn in Q.label){if(U._label[nn]){Q.label[nn]=U._label[nn]}else{if(U._label._elem){if(nn=="textColor"){Q.label[nn]=U._label._elem.css("color")}else{Q.label[nn]=U._label._elem.css(nn)}}}}}}this.themeEngine._add(T);this.themeEngine.activeTheme=this.themeEngine.themes[T._name]};B.jqplot.ThemeEngine.prototype.get=function(Q){if(!Q){return this.activeTheme}else{return this.themes[Q]}};function D(R,Q){return R-Q}B.jqplot.ThemeEngine.prototype.getThemeNames=function(){var Q=[];for(var R in this.themes){Q.push(R)}return Q.sort(D)};B.jqplot.ThemeEngine.prototype.getThemes=function(){var R=[];var Q=[];for(var T in this.themes){R.push(T)}R.sort(D);for(var S=0;S<R.length;S++){Q.push(this.themes[R[S]])}return Q};B.jqplot.ThemeEngine.prototype.activate=function(ab,T){var ag=false;if(!T&&this.activeTheme&&this.activeTheme._name){T=this.activeTheme._name}if(!this.themes.hasOwnProperty(T)){throw new Error("No theme of that name")}else{var U=this.themes[T];this.activeTheme=U;var W,af=false,ac=false;var aa=["xaxis","x2axis","yaxis","y2axis"];for(Z=0;Z<aa.length;Z++){var S=aa[Z];if(U.axesStyles.borderColor!=null){ab.axes[S].borderColor=U.axesStyles.borderColor}if(U.axesStyles.borderWidth!=null){ab.axes[S].borderWidth=U.axesStyles.borderWidth}}for(axname in ab.axes){var X=ab.axes[axname];if(X.show){var ae=U.axes[axname]||{};var R=U.axesStyles;var Y=B.jqplot.extend(true,{},ae,R);W=(U.axesStyles.borderColor!=null)?U.axesStyles.borderColor:Y.borderColor;if(Y.borderColor!=null){X.borderColor=Y.borderColor;ag=true}W=(U.axesStyles.borderWidth!=null)?U.axesStyles.borderWidth:Y.borderWidth;if(Y.borderWidth!=null){X.borderWidth=Y.borderWidth;ag=true}if(X._ticks&&X._ticks[0]){for(nn in Y.ticks){W=Y.ticks[nn];if(W!=null){X.tickOptions[nn]=W;X._ticks=[];ag=true}}}if(X._label&&X._label.show){for(nn in Y.label){W=Y.label[nn];if(W!=null){X.labelOptions[nn]=W;ag=true}}}}}for(var V in U.grid){if(U.grid[V]!=null){ab.grid[V]=U.grid[V]}}if(!ag){ab.grid.draw()}if(ab.legend.show){for(V in U.legend){if(U.legend[V]!=null){ab.legend[V]=U.legend[V]}}}if(ab.title.show){for(V in U.title){if(U.title[V]!=null){ab.title[V]=U.title[V]}}}var Z;for(Z=0;Z<U.series.length;Z++){var Q={};var ad=false;for(V in U.series[Z]){W=(U.seriesStyles[V]!=null)?U.seriesStyles[V]:U.series[Z][V];if(W!=null){Q[V]=W;if(V=="color"){ab.series[Z].renderer.shapeRenderer.fillStyle=W;ab.series[Z].renderer.shapeRenderer.strokeStyle=W;ab.series[Z][V]=W}else{if(V=="lineWidth"){ab.series[Z].renderer.shapeRenderer.lineWidth=W;ab.series[Z][V]=W}else{if(V=="markerOptions"){I(ab.series[Z].markerOptions,W);I(ab.series[Z].markerRenderer,W)}else{ab.series[Z][V]=W}}}ag=true}}}if(ag){ab.target.empty();ab.draw()}for(V in U.target){if(U.target[V]!=null){ab.target.css(V,U.target[V])}}}};B.jqplot.ThemeEngine.prototype._add=function(R,Q){if(Q){R._name=Q}if(!R._name){R._name=Date.parse(new Date())}if(!this.themes.hasOwnProperty(R._name)){this.themes[R._name]=R}else{throw new Error("jqplot.ThemeEngine Error: Theme already in use")}};B.jqplot.ThemeEngine.prototype.remove=function(Q){if(Q=="Default"){return false}return delete this.themes[Q]};B.jqplot.ThemeEngine.prototype.newTheme=function(Q,S){if(typeof(Q)=="object"){S=S||Q;Q=null}if(S&&S._name){Q=S._name}else{Q=Q||Date.parse(new Date())}var R=this.copy(this.themes.Default._name,Q);B.jqplot.extend(R,S);return R};function t(S){if(S==null||typeof(S)!="object"){return S}var Q=new S.constructor();for(var R in S){Q[R]=t(S[R])}return Q}B.jqplot.clone=t;function I(S,R){if(R==null||typeof(R)!="object"){return}for(var Q in R){if(Q=="highlightColors"){S[Q]=t(R[Q])}if(R[Q]!=null&&typeof(R[Q])=="object"){if(!S.hasOwnProperty(Q)){S[Q]={}}I(S[Q],R[Q])}else{S[Q]=R[Q]}}}B.jqplot.merge=I;B.jqplot.extend=function(){var V=arguments[0]||{},T=1,U=arguments.length,Q=false,S;if(typeof V==="boolean"){Q=V;V=arguments[1]||{};T=2}if(typeof V!=="object"&&!toString.call(V)==="[object Function]"){V={}}for(;T<U;T++){if((S=arguments[T])!=null){for(var R in S){var W=V[R],X=S[R];if(V===X){continue}if(Q&&X&&typeof X==="object"&&!X.nodeType){V[R]=B.jqplot.extend(Q,W||(X.length!=null?[]:{}),X)}else{if(X!==l){V[R]=X}}}}}return V};B.jqplot.ThemeEngine.prototype.rename=function(R,Q){if(R=="Default"||Q=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot rename from/to Default")}if(this.themes.hasOwnProperty(Q)){throw new Error("jqplot.ThemeEngine Error: New name already in use.")}else{if(this.themes.hasOwnProperty(R)){var S=this.copy(R,Q);this.remove(R);return S}}throw new Error("jqplot.ThemeEngine Error: Old name or new name invalid")};B.jqplot.ThemeEngine.prototype.copy=function(Q,S,U){if(S=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot copy over Default theme")}if(!this.themes.hasOwnProperty(Q)){var R="jqplot.ThemeEngine Error: Source name invalid";throw new Error(R)}if(this.themes.hasOwnProperty(S)){var R="jqplot.ThemeEngine Error: Target name invalid";throw new Error(R)}else{var T=t(this.themes[Q]);T._name=S;B.jqplot.extend(true,T,U);this._add(T);return T}};B.jqplot.Theme=function(Q,R){if(typeof(Q)=="object"){R=R||Q;Q=null}Q=Q||Date.parse(new Date());this._name=Q;this.target={backgroundColor:null};this.legend={textColor:null,fontFamily:null,fontSize:null,border:null,background:null};this.title={textColor:null,fontFamily:null,fontSize:null,textAlign:null};this.seriesStyles={};this.series=[];this.grid={drawGridlines:null,gridLineColor:null,gridLineWidth:null,backgroundColor:null,borderColor:null,borderWidth:null,shadow:null};this.axesStyles={label:{},ticks:{}};this.axes={};if(typeof(R)=="string"){this._name=R}else{if(typeof(R)=="object"){B.jqplot.extend(true,this,R)}}};var E=function(){this.borderColor=null;this.borderWidth=null;this.ticks=new f();this.label=new k()};var f=function(){this.show=null;this.showGridline=null;this.showLabel=null;this.showMark=null;this.size=null;this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null};var k=function(){this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null;this.fontWeight=null};var h=function(){this.color=null;this.lineWidth=null;this.shadow=null;this.fillColor=null;this.showMarker=null;this.markerOptions=new z()};var z=function(){this.show=null;this.style=null;this.lineWidth=null;this.size=null;this.color=null;this.shadow=null};var H=function(){this.color=null;this.seriesColors=null;this.lineWidth=null;this.shadow=null;this.barPadding=null;this.barMargin=null;this.barWidth=null;this.highlightColors=null};var b=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.highlightColors=null};var x=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.innerDiameter=null;this.thickness=null;this.ringMargin=null;this.highlightColors=null};var L=function(){this.color=null;this.lineWidth=null;this.shadow=null;this.padding=null;this.sectionMargin=null;this.seriesColors=null;this.highlightColors=null};var u=function(){this.padding=null;this.backgroundColor=null;this.ringColor=null;this.tickColor=null;this.ringWidth=null;this.intervalColors=null;this.intervalInnerRadius=null;this.intervalOuterRadius=null;this.hubRadius=null;this.needleThickness=null;this.needlePad=null};B.jqplot.sprintf=function(){function V(ab,X,Y,aa){var Z=(ab.length>=X)?"":Array(1+X-ab.length>>>0).join(Y);return aa?ab+Z:Z+ab}function S(ac,ab,ae,Z,aa,Y){var ad=Z-ac.length;if(ad>0){var X=" ";if(Y){X="&nbsp;"}if(ae||!aa){ac=V(ac,Z,X,ae)}else{ac=ac.slice(0,ab.length)+V("",ad,"0",true)+ac.slice(ab.length)}}return ac}function W(af,Y,ad,Z,X,ac,ae,ab){var aa=af>>>0;ad=ad&&aa&&{"2":"0b","8":"0","16":"0x"}[Y]||"";af=ad+V(aa.toString(Y),ac||0,"0",false);return S(af,ad,Z,X,ae,ab)}function Q(ab,ac,Z,X,aa,Y){if(X!=null){ab=ab.slice(0,X)}return S(ab,"",ac,Z,aa,Y)}var R=arguments,T=0,U=R[T++];return U.replace(B.jqplot.sprintf.regex,function(aq,ad,ae,ah,at,ao,ab){if(aq=="%%"){return"%"}var ai=false,af="",ag=false,ap=false,ac=false;for(var an=0;ae&&an<ae.length;an++){switch(ae.charAt(an)){case" ":af=" ";break;case"+":af="+";break;case"-":ai=true;break;case"0":ag=true;break;case"#":ap=true;break;case"&":ac=true;break}}if(!ah){ah=0}else{if(ah=="*"){ah=+R[T++]}else{if(ah.charAt(0)=="*"){ah=+R[ah.slice(1,-1)]}else{ah=+ah}}}if(ah<0){ah=-ah;ai=true}if(!isFinite(ah)){throw new Error("$.jqplot.sprintf: (minimum-)width must be finite")}if(!ao){ao="fFeE".indexOf(ab)>-1?6:(ab=="d")?0:void (0)}else{if(ao=="*"){ao=+R[T++]}else{if(ao.charAt(0)=="*"){ao=+R[ao.slice(1,-1)]}else{ao=+ao}}}var ak=ad?R[ad.slice(0,-1)]:R[T++];switch(ab){case"s":if(ak==null){return""}return Q(String(ak),ai,ah,ao,ag,ac);case"c":return Q(String.fromCharCode(+ak),ai,ah,ao,ag,ac);case"b":return W(ak,2,ap,ai,ah,ao,ag,ac);case"o":return W(ak,8,ap,ai,ah,ao,ag,ac);case"x":return W(ak,16,ap,ai,ah,ao,ag,ac);case"X":return W(ak,16,ap,ai,ah,ao,ag,ac).toUpperCase();case"u":return W(ak,10,ap,ai,ah,ao,ag,ac);case"i":var Z=parseInt(+ak,10);if(isNaN(Z)){return""}var am=Z<0?"-":af;ak=am+V(String(Math.abs(Z)),ao,"0",false);return S(ak,am,ai,ah,ag,ac);case"d":var Z=Math.round(+ak);if(isNaN(Z)){return""}var am=Z<0?"-":af;ak=am+V(String(Math.abs(Z)),ao,"0",false);return S(ak,am,ai,ah,ag,ac);case"e":case"E":case"f":case"F":case"g":case"G":var Z=+ak;if(isNaN(Z)){return""}var am=Z<0?"-":af;var aa=["toExponential","toFixed","toPrecision"]["efg".indexOf(ab.toLowerCase())];var ar=["toString","toUpperCase"]["eEfFgG".indexOf(ab)%2];ak=am+Math.abs(Z)[aa](ao);return S(ak,am,ai,ah,ag,ac)[ar]();case"p":case"P":var Z=+ak;if(isNaN(Z)){return""}var am=Z<0?"-":af;var aj=String(Number(Math.abs(Z)).toExponential()).split(/e|E/);var Y=(aj[0].indexOf(".")!=-1)?aj[0].length-1:aj[0].length;var al=(aj[1]<0)?-aj[1]-1:0;if(Math.abs(Z)<1){if(Y+al<=ao){ak=am+Math.abs(Z).toPrecision(Y)}else{if(Y<=ao-1){ak=am+Math.abs(Z).toExponential(Y-1)}else{ak=am+Math.abs(Z).toExponential(ao-1)}}}else{var X=(Y<=ao)?Y:ao;ak=am+Math.abs(Z).toPrecision(X)}var ar=["toString","toUpperCase"]["pP".indexOf(ab)%2];return S(ak,am,ai,ah,ag,ac)[ar]();case"n":return"";default:return aq}})};B.jqplot.sprintf.regex=/%%|%(\d+\$)?([-+#0& ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([nAscboxXuidfegpEGP])/g})(jQuery);