<?php
/**
 * Language definitions for the Admin Company Messenger settings controller/views
 *
 * @package blesta
 * @subpackage blesta.language.en_us
 * @copyright Copyright (c) 2020, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */

// Success messages
$lang['AdminCompanyMessengers.!success.upgraded'] = 'The messenger was successfully upgraded.';
$lang['AdminCompanyMessengers.!success.installed'] = 'The messenger was successfully installed.';
$lang['AdminCompanyMessengers.!success.uninstalled'] = 'The messenger was successfully uninstalled.';
$lang['AdminCompanyMessengers.!success.messenger_options_updated'] = 'The messenger configuration was successfully updated!';
$lang['AdminCompanyMessengers.!success.edit_template_updated'] = 'The message template was successfully updated.';
$lang['AdminCompanyMessengers.!success.messenger_updated'] = 'The messenger was successfully updated.';

// Tooltips
$lang['AdminCompanyMessengers.!tooltip.status'] = 'No messages will be sent using this template unless this option is enabled.';

// Tabs
$lang['AdminCompanyMessengers.!tab.installed'] = 'Installed';
$lang['AdminCompanyMessengers.!tab.available'] = 'Available';


// Available Messengers
$lang['AdminCompanyMessengers.available.page_title'] = 'Settings > Company > Messengers > Available';
$lang['AdminCompanyMessengers.available.boxtitle_messenger'] = 'Messengers';

$lang['AdminCompanyMessengers.available.text_author'] = 'Author:';
$lang['AdminCompanyMessengers.available.text_version'] = '(ver %1$s)'; // %1$s is the messenger's version number
$lang['AdminCompanyMessengers.available.text_none'] = 'There are no available messengers.';
$lang['AdminCompanyMessengers.available.btn_install'] = 'Install';


// Installed Messengers
$lang['AdminCompanyMessengers.installed.page_title'] = 'Settings > Company > Messengers > Installed';
$lang['AdminCompanyMessengers.installed.boxtitle_installed'] = 'Messengers';

$lang['AdminCompanyMessengers.installed.text_author'] = 'Author:';
$lang['AdminCompanyMessengers.installed.text_version'] = '(ver %1$s)'; // %1$s is the messenger's version number
$lang['AdminCompanyMessengers.installed.text_none'] = 'There are no installed messengers.';
$lang['AdminCompanyMessengers.installed.btn_uninstall'] = 'Uninstall';
$lang['AdminCompanyMessengers.installed.btn_manage'] = 'Manage';
$lang['AdminCompanyMessengers.installed.btn_upgrade'] = 'Upgrade';

$lang['AdminCompanyMessengers.installed.confirm_uninstall'] = 'Are you sure you want to uninstall this messenger?';


// Manage a Messenger
$lang['AdminCompanyMessengers.manage.page_title'] = 'Settings > Company > Messengers > Manage %1$s'; // %1$s is the name of the messenger
$lang['AdminCompanyMessengers.manage.boxtitle_manage'] = 'Manage %1$s'; // %1$s is the name of the messenger
$lang['AdminCompanyMessengers.manage.none_text'] = 'There is nothing to manage for this messenger.';
$lang['AdminCompanyMessengers.manage.field_update'] = 'Update Settings';

// Messenger Configuration
$lang['AdminCompanyMessengers.configuration.page_title'] = 'Settings > Company > Messengers > Messenger Configuration';
$lang['AdminCompanyMessengers.configuration.boxtitle_messenger_configuration'] = 'Messenger Configuration';

$lang['AdminCompanyMessengers.configuration.heading_message_type'] = 'Message Type';
$lang['AdminCompanyMessengers.configuration.heading_messenger'] = 'Messenger';

$lang['AdminCompanyMessengers.configuration.field_update'] = 'Update Settings';

$lang['AdminCompanyMessengers.configuration.text_none'] = 'There are no installed messengers.';


// Message Templates
$lang['AdminCompanyMessengers.templates.page_title'] = 'Settings > Company > Messengers > Message Templates';
$lang['AdminCompanyMessengers.templates.boxtitle_message_templates'] = 'Message Templates';

$lang['AdminCompanyMessengers.templates.heading_client'] = 'Client Messages';
$lang['AdminCompanyMessengers.templates.heading_staff'] = 'Staff Messages';
$lang['AdminCompanyMessengers.templates.heading_plugins'] = 'Plugin Messages';

$lang['AdminCompanyMessengers.templates.text_name'] = 'Name';
$lang['AdminCompanyMessengers.templates.text_plugin'] = 'Plugin';
$lang['AdminCompanyMessengers.templates.text_description'] = 'Description';
$lang['AdminCompanyMessengers.templates.text_options'] = 'Options';

$lang['AdminCompanyMessengers.templates.option_edit'] = 'Edit';

$lang['AdminCompanyMessengers.templates.no_results'] = 'There are no templates of this type.';


// Edit Template
$lang['AdminCompanyMessengers.edittemplate.page_title'] = 'Settings > Company > Emails > Edit Message Template';
$lang['AdminCompanyMessengers.edittemplate.boxtitle_edittemplate'] = 'Edit Message Template %1$s'; // %1$s is the email template group name
$lang['AdminCompanyMessengers.edittemplate.text_none'] = 'None';

$lang['AdminCompanyMessengers.edittemplate.field.tags'] = 'Available Tags';
$lang['AdminCompanyMessengers.edittemplate.field.status'] = 'Enabled';
$lang['AdminCompanyMessengers.edittemplate.field.cancel'] = 'Cancel';
$lang['AdminCompanyMessengers.edittemplate.field.edittemplatesubmit'] = 'Update Template';
