
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_biblio072`
--

-- --------------------------------------------------------

--
-- Table structure for table `biblio`
--

CREATE TABLE `biblio` (
  `bibid` int(11) NOT NULL AUTO_INCREMENT,
  `create_dt` datetime NOT NULL,
  `last_change_dt` datetime NOT NULL,
  `last_change_userid` int(11) NOT NULL,
  `material_cd` smallint(6) NOT NULL,
  `collection_cd` smallint(6) NOT NULL,
  `call_nmbr1` varchar(20) DEFAULT NULL,
  `call_nmbr2` varchar(20) DEFAULT NULL,
  `call_nmbr3` varchar(20) DEFAULT NULL,
  `title` text,
  `title_remainder` text,
  `responsibility_stmt` text,
  `author` text,
  `topic1` text,
  `topic2` text,
  `topic3` text,
  `topic4` text,
  `topic5` text,
  `opac_flg` char(1) NOT NULL,
  PRIMARY KEY (`bibid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `biblio_copy`
--

CREATE TABLE `biblio_copy` (
  `bibid` int(11) NOT NULL,
  `copyid` int(11) NOT NULL AUTO_INCREMENT,
  `create_dt` datetime NOT NULL,
  `copy_desc` varchar(160) DEFAULT NULL,
  `barcode_nmbr` varchar(20) NOT NULL,
  `status_cd` char(3) NOT NULL,
  `status_begin_dt` datetime NOT NULL,
  `due_back_dt` date DEFAULT NULL,
  `mbrid` int(11) DEFAULT NULL,
  `renewal_count` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`bibid`,`copyid`),
  KEY `barcode_index` (`barcode_nmbr`),
  KEY `mbr_index` (`mbrid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `biblio_copy_fields`
--

CREATE TABLE `biblio_copy_fields` (
  `bibid` int(11) NOT NULL,
  `copyid` int(11) NOT NULL,
  `code` varchar(16) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`bibid`,`copyid`,`code`),
  KEY `code_index` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `biblio_copy_fields_dm`
--

CREATE TABLE `biblio_copy_fields_dm` (
  `code` varchar(16) NOT NULL,
  `description` char(32) NOT NULL,
  `default_flg` char(1) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `biblio_field`
--

CREATE TABLE `biblio_field` (
  `bibid` int(11) NOT NULL,
  `fieldid` int(11) NOT NULL AUTO_INCREMENT,
  `tag` smallint(6) NOT NULL,
  `ind1_cd` char(1) DEFAULT NULL,
  `ind2_cd` char(1) DEFAULT NULL,
  `subfield_cd` char(1) NOT NULL,
  `field_data` text,
  PRIMARY KEY (`bibid`,`fieldid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `biblio_hold`
--

CREATE TABLE `biblio_hold` (
  `bibid` int(11) NOT NULL,
  `copyid` int(11) NOT NULL,
  `holdid` int(11) NOT NULL AUTO_INCREMENT,
  `hold_begin_dt` datetime NOT NULL,
  `mbrid` int(11) NOT NULL,
  PRIMARY KEY (`bibid`,`copyid`,`holdid`),
  KEY `mbr_index` (`mbrid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `biblio_status_dm`
--

CREATE TABLE `biblio_status_dm` (
  `code` char(3) NOT NULL,
  `description` varchar(40) NOT NULL,
  `default_flg` char(1) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `biblio_status_dm`
--

INSERT INTO `biblio_status_dm` VALUES
('in', 'checked in', 'Y'),
('out', 'checked out', 'N'),
('mnd', 'damaged/mending', 'N'),
('dis', 'display area', 'N'),
('hld', 'on hold', 'N'),
('lst', 'lost', 'N'),
('ln', 'on loan', 'N'),
('ord', 'on order', 'N'),
('crt', 'shelving cart', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `biblio_status_hist`
--

CREATE TABLE `biblio_status_hist` (
  `bibid` int(11) NOT NULL,
  `copyid` int(11) NOT NULL,
  `status_cd` char(3) NOT NULL,
  `status_begin_dt` datetime NOT NULL,
  `due_back_dt` date DEFAULT NULL,
  `mbrid` int(11) DEFAULT NULL,
  `renewal_count` tinyint(3) unsigned NOT NULL,
  KEY `mbr_index` (`mbrid`),
  KEY `copy_index` (`bibid`,`copyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `checkout_privs`
--

CREATE TABLE `checkout_privs` (
  `material_cd` smallint(6) NOT NULL,
  `classification` smallint(6) NOT NULL,
  `checkout_limit` tinyint(3) unsigned NOT NULL,
  `renewal_limit` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`material_cd`,`classification`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `checkout_privs`
--

INSERT INTO `checkout_privs` VALUES
(1, 1, 10, 0),
(1, 2, 5, 0),
(2, 1, 20, 0),
(2, 2, 10, 0),
(3, 1, 10, 0),
(3, 2, 5, 0),
(4, 1, 5, 0),
(4, 2, 3, 0),
(5, 1, 3, 0),
(5, 2, 0, 0),
(6, 1, 10, 0),
(6, 2, 5, 0),
(7, 1, 5, 0),
(7, 2, 3, 0),
(8, 1, 5, 0),
(8, 2, 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `collection_dm`
--

CREATE TABLE `collection_dm` (
  `code` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(40) NOT NULL,
  `default_flg` char(1) NOT NULL,
  `days_due_back` smallint(5) unsigned NOT NULL,
  `daily_late_fee` decimal(4,2) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `collection_dm`
--

INSERT INTO `collection_dm` VALUES
(1, 'Adult Fiction', 'N', 21, '0.05'),
(2, 'Adult Nonfiction', 'Y', 21, '0.05'),
(3, 'Cassettes', 'N', 7, '0.05'),
(4, 'Compact Discs', 'N', 7, '0.15'),
(5, 'Computer Software', 'N', 7, '0.15'),
(6, 'Easy Readers', 'N', 21, '0.05'),
(7, 'Juvenile Fiction', 'N', 21, '0.05'),
(8, 'Juvenile Nonfiction', 'N', 21, '0.05'),
(9, 'New Books', 'N', 14, '0.10'),
(10, 'Periodics', 'N', 14, '0.05'),
(11, 'Reference', 'N', 0, '0.00'),
(12, 'Videos and DVDs', 'N', 3, '1.00');

-- --------------------------------------------------------

--
-- Table structure for table `material_type_dm`
--

CREATE TABLE `material_type_dm` (
  `code` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(40) NOT NULL,
  `default_flg` char(1) NOT NULL,
  `image_file` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `material_type_dm`
--

INSERT INTO `material_type_dm` VALUES
(1, 'audio tapes', 'N', 'tape.gif'),
(2, 'book', 'Y', 'book.gif'),
(3, 'cd audio', 'N', 'cd.gif'),
(4, 'cd computer', 'N', 'cd.gif'),
(5, 'equipment', 'N', 'case.gif'),
(6, 'magazines', 'N', 'mag.gif'),
(7, 'maps', 'N', 'map.gif'),
(8, 'video/dvd', 'N', 'camera.gif');

-- --------------------------------------------------------

--
-- Table structure for table `material_usmarc_xref`
--

CREATE TABLE `material_usmarc_xref` (
  `xref_id` int(11) NOT NULL AUTO_INCREMENT,
  `materialCd` int(11) NOT NULL DEFAULT '0',
  `tag` char(3) NOT NULL DEFAULT '',
  `subfieldCd` char(1) NOT NULL DEFAULT '',
  `descr` varchar(64) NOT NULL DEFAULT '',
  `required` char(1) NOT NULL DEFAULT '',
  `cntrltype` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`xref_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mbr_classify_dm`
--

CREATE TABLE `mbr_classify_dm` (
  `code` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(40) NOT NULL,
  `default_flg` char(1) NOT NULL,
  `max_fines` decimal(4,2) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `mbr_classify_dm`
--

INSERT INTO `mbr_classify_dm` VALUES
(1, 'adult', 'Y', '0.00'),
(2, 'juvenile', 'N', '0.00');

-- --------------------------------------------------------

--
-- Table structure for table `member`
--

CREATE TABLE `member` (
  `mbrid` int(11) NOT NULL AUTO_INCREMENT,
  `barcode_nmbr` varchar(20) NOT NULL,
  `create_dt` datetime NOT NULL,
  `last_change_dt` datetime NOT NULL,
  `last_change_userid` int(11) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `address` text,
  `home_phone` varchar(15) DEFAULT NULL,
  `work_phone` varchar(15) DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  `classification` smallint(6) NOT NULL,
  PRIMARY KEY (`mbrid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `member_account`
--

CREATE TABLE `member_account` (
  `mbrid` int(11) NOT NULL,
  `transid` int(11) NOT NULL AUTO_INCREMENT,
  `create_dt` datetime NOT NULL,
  `create_userid` int(11) NOT NULL,
  `transaction_type_cd` char(2) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`mbrid`,`transid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `member_fields`
--

CREATE TABLE `member_fields` (
  `mbrid` int(11) NOT NULL,
  `code` varchar(16) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`mbrid`,`code`),
  KEY `code_index` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `member_fields_dm`
--

CREATE TABLE `member_fields_dm` (
  `code` varchar(16) NOT NULL,
  `description` char(32) NOT NULL,
  `default_flg` char(1) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `member_fields_dm`
--

INSERT INTO `member_fields_dm` VALUES
('schoolGrade', 'School Grade', 'N'),
('schoolTeacher', 'School Teacher', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `session`
--

CREATE TABLE `session` (
  `userid` int(5) NOT NULL,
  `last_updated_dt` datetime NOT NULL,
  `token` int(5) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `library_name` varchar(128) DEFAULT NULL,
  `library_image_url` text,
  `use_image_flg` char(1) NOT NULL,
  `library_hours` varchar(128) DEFAULT NULL,
  `library_phone` varchar(40) DEFAULT NULL,
  `library_url` text,
  `opac_url` text,
  `session_timeout` smallint(6) NOT NULL,
  `items_per_page` tinyint(4) NOT NULL,
  `version` varchar(10) NOT NULL,
  `themeid` smallint(6) NOT NULL,
  `purge_history_after_months` smallint(6) NOT NULL,
  `block_checkouts_when_fines_due` char(1) NOT NULL,
  `hold_max_days` smallint(6) NOT NULL,
  `locale` varchar(30) NOT NULL,
  `charset` varchar(20) DEFAULT NULL,
  `html_lang_attr` varchar(8) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` VALUES
('[[site_name]]', '../images/sampleLogo.png', 'N', 'M-F 8am-9pm, Sa noon-5pm, Su 1-5pm', '111-222-3333', NULL, '../opac/index.php', 20, 10, '0.7.1', 1, 6, 'Y', 14, 'en', 'iso-8859-1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `staff`
--

CREATE TABLE `staff` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `create_dt` datetime NOT NULL,
  `last_change_dt` datetime NOT NULL,
  `last_change_userid` int(11) NOT NULL,
  `username` varchar(20) NOT NULL,
  `pwd` char(32) NOT NULL,
  `last_name` varchar(30) NOT NULL,
  `first_name` varchar(30) DEFAULT NULL,
  `suspended_flg` char(1) NOT NULL,
  `admin_flg` char(1) NOT NULL,
  `circ_flg` char(1) NOT NULL,
  `circ_mbr_flg` char(1) NOT NULL,
  `catalog_flg` char(1) NOT NULL,
  `reports_flg` char(1) NOT NULL,
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `staff`
--

INSERT INTO `staff` VALUES
(1, '[[regtime]]', '[[regtime]]', 1, '[[admin_username]]', '[[admin_pass]]', 'Root Administrator', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'Y');

-- --------------------------------------------------------

--
-- Table structure for table `theme`
--

CREATE TABLE `theme` (
  `themeid` smallint(6) NOT NULL AUTO_INCREMENT,
  `theme_name` varchar(40) NOT NULL,
  `title_bg` varchar(20) NOT NULL,
  `title_font_face` varchar(128) NOT NULL,
  `title_font_size` tinyint(4) NOT NULL,
  `title_font_bold` char(1) NOT NULL,
  `title_font_color` varchar(20) NOT NULL,
  `title_align` varchar(30) NOT NULL,
  `primary_bg` varchar(20) NOT NULL,
  `primary_font_face` varchar(128) NOT NULL,
  `primary_font_size` tinyint(4) NOT NULL,
  `primary_font_color` varchar(20) NOT NULL,
  `primary_link_color` varchar(20) NOT NULL,
  `primary_error_color` varchar(20) NOT NULL,
  `alt1_bg` varchar(20) NOT NULL,
  `alt1_font_face` varchar(128) NOT NULL,
  `alt1_font_size` tinyint(4) NOT NULL,
  `alt1_font_color` varchar(20) NOT NULL,
  `alt1_link_color` varchar(20) NOT NULL,
  `alt2_bg` varchar(20) NOT NULL,
  `alt2_font_face` varchar(128) NOT NULL,
  `alt2_font_size` tinyint(4) NOT NULL,
  `alt2_font_color` varchar(20) NOT NULL,
  `alt2_link_color` varchar(20) NOT NULL,
  `alt2_font_bold` char(1) NOT NULL,
  `border_color` varchar(20) NOT NULL,
  `border_width` tinyint(4) NOT NULL,
  `table_padding` tinyint(4) NOT NULL,
  PRIMARY KEY (`themeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `theme`
--

INSERT INTO `theme` VALUES
(1, 'Mossy Blue', '#7695C0', 'Arial,Helvetica,sans-serif', 26, 'N', '#ffffff', 'left', '#ffffff', 'verdana,arial,helvetica', 13, '#000000', '#0000aa', '#990000', '#CCCC99', 'verdana,arial,helvetica', 13, '#000000', '#0000aa', '#003366', 'verdana,arial,helvetica', 13, '#ffffff', '#ffffff', 'Y', '#000000', 1, 2),
(2, 'Arizona Dessert', '#dfa955', 'Arial,Helvetica,sans-serif', 26, 'N', '#ffffff', 'left', '#ffffff', 'verdana,arial,helvetica', 13, '#000000', '#af6622', '#990000', '#c0c0c0', 'verdana,arial,helvetica', 13, '#000000', '#bf7733', '#c05232', 'verdana,arial,helvetica', 13, '#ffffff', '#ffffff', 'Y', '#000000', 1, 2),
(3, 'Blue and Green', '#aaaaff', 'Arial,Helvetica,sans-serif', 26, 'N', '#000055', 'left', '#ffffff', 'verdana,arial,helvetica', 13, '#000055', '#000088', '#990000', '#aaffaa', 'verdana,arial,helvetica', 13, '#005500', '#000088', '#4444ff', 'verdana,arial,helvetica', 13, '#ffffff', '#ffffff', 'Y', '#000055', 1, 2),
(4, 'Dark Wood', '#551122', 'Arial,Helvetica,sans-serif', 26, 'N', '#ffffff', 'left', '#000000', 'arial', 13, '#ffffff', '#ffff99', '#990000', '#393333', 'arial', 13, '#ffffff', '#ffff99', '#999080', 'verdana,arial,helvetica', 13, '#ffffff', '#ffffff', 'Y', '#a9a090', 1, 2),
(5, 'Metalic Grey', '#ffffff', 'Arial,Helvetica,sans-serif', 26, 'N', '#000000', 'left', '#f0f0f0', 'verdana,arial,helvetica', 13, '#000000', '#0000aa', '#990000', '#e0e0e0', 'verdana,arial,helvetica', 13, '#000000', '#0000aa', '#c9cfde', 'verdana,arial,helvetica', 13, '#000000', '#000000', 'Y', '#000000', 1, 2),
(6, 'Midnight', '#222255', 'Arial,Helvetica,sans-serif', 26, 'N', '#ffffff', 'left', '#000000', 'arial', 13, '#b5b5db', '#ffff99', '#990000', '#333366', 'arial', 13, '#ffffff', '#ffff99', '#8585ab', 'verdana,arial,helvetica', 13, '#ffffff', '#ffffff', 'N', '#b5b5db', 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `transaction_type_dm`
--

CREATE TABLE `transaction_type_dm` (
  `code` char(2) NOT NULL,
  `description` varchar(40) NOT NULL,
  `default_flg` char(1) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `transaction_type_dm`
--

INSERT INTO `transaction_type_dm` VALUES
('-p', 'payment', 'Y'),
('-r', 'credit', 'N'),
('+c', 'charge', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `usmarc_block_dm`
--

CREATE TABLE `usmarc_block_dm` (
  `block_nmbr` tinyint(4) NOT NULL,
  `description` varchar(80) NOT NULL,
  PRIMARY KEY (`block_nmbr`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `usmarc_block_dm`
--

INSERT INTO `usmarc_block_dm` VALUES
(0, 'Control information, numbers, and codes'),
(1, 'Main entry'),
(2, 'Titles and title paragraph (title, edition, imprint)'),
(3, 'Physical description, etc.'),
(4, 'Series statements'),
(5, 'Notes'),
(6, 'Subject access fields'),
(7, 'Added entries other than subject or series, linking fields'),
(8, 'Series added entries: location, and alternate graphics'),
(9, 'Reserved for local implementation');

-- --------------------------------------------------------

--
-- Table structure for table `usmarc_indicator_dm`
--

CREATE TABLE `usmarc_indicator_dm` (
  `tag` smallint(6) NOT NULL,
  `indicator_nmbr` tinyint(4) NOT NULL,
  `indicator_cd` char(1) NOT NULL,
  `description` varchar(80) NOT NULL,
  PRIMARY KEY (`tag`,`indicator_nmbr`,`indicator_cd`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `usmarc_indicator_dm`
--

INSERT INTO `usmarc_indicator_dm` VALUES
(10, 1, '#', 'Undefined'),
(10, 2, '#', 'Undefined'),
(13, 1, '#', 'Undefined'),
(13, 2, '#', 'Undefined'),
(15, 1, '#', 'Undefined'),
(15, 2, '#', 'Undefined'),
(16, 1, '#', 'National Library of Canada'),
(16, 1, '7', 'Agency identified in subfield $2'),
(16, 2, '#', 'Undefined'),
(17, 1, '#', 'Undefined'),
(17, 2, '#', 'Undefined'),
(18, 1, '#', 'Undefined'),
(18, 2, '#', 'Undefined'),
(20, 1, '#', 'Undefined'),
(20, 2, '#', 'Undefined'),
(22, 1, '#', 'No level specified'),
(22, 1, '0', 'Serial of international interest'),
(22, 1, '1', 'Serial not of international interest'),
(22, 2, '#', 'Undefined'),
(24, 1, '0', 'International Standard Recording Code (ISRC)'),
(24, 1, '1', 'Universal Product Code (UPC)'),
(24, 1, '2', 'International Standard Music Number (ISMN)'),
(24, 1, '3', 'International Article Number (EAN)'),
(24, 1, '4', 'Serial Item and Contribution Identifier (SICI)'),
(24, 1, '7', 'Source specified in subfield $2'),
(24, 1, '8', 'Unspecified type of standard number or code'),
(24, 2, '#', 'No information provided'),
(24, 2, '0', 'No difference'),
(24, 2, '1', 'Difference'),
(25, 1, '#', 'Undefined'),
(25, 2, '#', 'Undefined'),
(27, 1, '#', 'Undefined'),
(27, 2, '#', 'Undefined'),
(28, 1, '0', 'Issue number'),
(28, 1, '1', 'Matrix number'),
(28, 1, '2', 'Plate number'),
(28, 1, '3', 'Other music number'),
(28, 1, '4', 'Videorecording number'),
(28, 1, '5', 'Other publisher number'),
(28, 2, '0', 'No note, no added entry'),
(28, 2, '1', 'Note, added entry'),
(28, 2, '2', 'Note, no added entry'),
(28, 2, '3', 'No note, added entry'),
(30, 1, '#', 'Undefined'),
(30, 2, '#', 'Undefined'),
(32, 1, '#', 'Undefined'),
(32, 2, '#', 'Undefined'),
(33, 1, '#', 'No date information'),
(33, 1, '0', 'Single date'),
(33, 1, '1', 'Multiple single dates'),
(33, 1, '2', 'Range of dates'),
(33, 2, '#', 'No information provided'),
(33, 2, '0', 'Capture'),
(33, 2, '1', 'Broadcast'),
(33, 2, '2', 'Finding'),
(34, 1, '0', 'Scale indeterminable/No scale recorded'),
(34, 1, '1', 'Single scale'),
(34, 1, '3', 'Range of scales'),
(34, 2, '#', 'Not applicable'),
(34, 2, '0', 'Outer ring'),
(34, 2, '1', 'Exclusion ring'),
(35, 1, '#', 'Undefined'),
(35, 2, '#', 'Undefined'),
(36, 1, '#', 'Undefined'),
(36, 2, '#', 'Undefined'),
(37, 1, '#', 'Undefined'),
(37, 2, '#', 'Undefined'),
(40, 1, '#', 'Undefined'),
(40, 2, '#', 'Undefined'),
(41, 1, '0', 'Item not a translation/does not include a translation'),
(41, 1, '1', 'Item is or includes a translation'),
(41, 2, '#', 'MARC language code'),
(41, 2, '7', 'Source specified in subfield $2'),
(42, 1, '#', 'Undefined'),
(42, 2, '#', 'Undefined'),
(43, 1, '#', 'Undefined'),
(43, 2, '#', 'Undefined'),
(44, 1, '#', 'Undefined'),
(44, 2, '#', 'Undefined'),
(45, 1, '#', 'Subfield $b or $c not present'),
(45, 1, '0', 'Single date/time'),
(45, 1, '1', 'Multiple single dates/times'),
(45, 1, '2', 'Range of dates/times'),
(45, 2, '#', 'Undefined'),
(46, 1, '#', 'Undefined'),
(46, 2, '#', 'Undefined'),
(47, 1, '#', 'Undefined'),
(47, 2, '#', 'Undefined'),
(48, 1, '#', 'Undefined'),
(48, 2, '#', 'Undefined'),
(50, 1, '#', 'No information provided'),
(50, 1, '0', 'Item is in LC'),
(50, 1, '1', 'Item is not in LC'),
(50, 2, '0', 'Assigned by LC'),
(50, 2, '4', 'Assigned by agency other than LC'),
(51, 1, '#', 'Undefined'),
(51, 2, '#', 'Undefined'),
(52, 1, '#', 'Library of Congress Classification'),
(52, 1, '0', 'U.S. Dept. of Defense Classification'),
(52, 1, '7', 'Source specified in subfield $2'),
(52, 2, '#', 'Undefined'),
(55, 1, '#', 'Information not provided'),
(55, 1, '0', 'Work held by NLC'),
(55, 1, '1', 'Work not held by NLC'),
(55, 2, '0', 'LC-based call number assigned by NLC'),
(55, 2, '1', 'Complete LC class number assigned by NLC'),
(55, 2, '2', 'Incomplete LC class number assigned by NLC'),
(55, 2, '3', 'LC-based call number assigned by the contributing library'),
(55, 2, '4', 'Complete LC class number assigned by the contributing library'),
(55, 2, '5', 'Incomplete LC class number assigned by the contributing library'),
(55, 2, '6', 'Other call number assigned by NLC'),
(55, 2, '7', 'Other class number assigned by NLC'),
(55, 2, '8', 'Other call number assigned by the contributing library'),
(55, 2, '9', 'Other class number assigned by the contributing library'),
(60, 1, '#', 'No information provided'),
(60, 1, '0', 'Item is in NLM'),
(60, 1, '1', 'Item is not in NLM'),
(60, 2, '0', 'Assigned by NLM'),
(60, 2, '4', 'Assigned by agency other than NLM'),
(61, 1, '#', 'Undefined'),
(61, 2, '#', 'Undefined'),
(66, 1, '#', 'Undefined'),
(66, 2, '#', 'Undefined'),
(70, 1, '0', 'Item is in NAL'),
(70, 1, '1', 'Item is not in NAL'),
(70, 2, '#', 'Undefined'),
(71, 1, '#', 'Undefined'),
(71, 2, '#', 'Undefined'),
(72, 1, '#', 'Undefined'),
(72, 2, '0', 'NAL subject category code list'),
(72, 2, '7', 'Code source specified in subfield $2'),
(74, 1, '#', 'Undefined'),
(74, 2, '#', 'Undefined'),
(80, 1, '#', 'Undefined'),
(80, 2, '#', 'Undefined'),
(82, 1, '0', 'Full edition'),
(82, 1, '1', 'Abridged edition'),
(82, 2, '#', 'No information provided'),
(82, 2, '0', 'Assigned by LC'),
(82, 2, '4', 'Assigned by agency other than LC'),
(84, 1, '#', 'Undefined'),
(84, 2, '#', 'Undefined'),
(86, 1, '#', 'Source specified in subfield $2'),
(86, 1, '0', 'Superintendent of Documents Classification System'),
(86, 1, '1', 'Government of Canada Publications: Outline of Classification'),
(86, 2, '#', 'Undefined'),
(88, 1, '#', 'Undefined'),
(88, 2, '#', 'Undefined'),
(100, 1, '0', 'Forename'),
(100, 1, '1', 'Surname'),
(100, 1, '3', 'Family name'),
(100, 2, '#', 'Undefined'),
(110, 1, '0', 'Inverted name'),
(110, 1, '1', 'Jurisdiction name'),
(110, 1, '2', 'Name in direct order'),
(110, 2, '#', 'Undefined'),
(111, 1, '0', 'Inverted name'),
(111, 1, '1', 'Jurisdiction name'),
(111, 1, '2', 'Name in direct order'),
(111, 2, '#', 'Undefined'),
(130, 2, '#', 'Undefined'),
(210, 1, '0', 'No added entry'),
(210, 1, '1', 'Added entry'),
(210, 2, '#', 'Abbreviated key title'),
(210, 2, '0', 'Other abbreviated title'),
(222, 1, '#', 'Undefined'),
(222, 1, '0', 'No key title added entry, title proper same'),
(222, 1, '1', 'Key title added entry, title proper different'),
(222, 1, '2', 'Key title added entry, title proper same'),
(222, 1, '3', 'No key title added entry, title proper different'),
(240, 1, '0', 'Not printed or displayed'),
(240, 1, '1', 'Printed or displayed'),
(242, 1, '0', 'No added entry'),
(242, 1, '1', 'Added entry'),
(243, 1, '0', 'Not printed or displayed'),
(243, 1, '1', 'Printed or displayed'),
(245, 1, '0', 'No added entry'),
(245, 1, '1', 'Added entry'),
(246, 1, '0', 'Note, no added entry'),
(246, 1, '1', 'Note, added entry'),
(246, 1, '2', 'No note, no title added entry'),
(246, 1, '3', 'No note, added entry'),
(246, 2, '#', 'No type specified'),
(246, 2, '0', 'Portion of title'),
(246, 2, '1', 'Parallel title'),
(246, 2, '2', 'Distinctive title'),
(246, 2, '3', 'Other title'),
(246, 2, '4', 'Cover title'),
(246, 2, '5', 'Added title page title'),
(246, 2, '6', 'Caption title'),
(246, 2, '7', 'Running title'),
(246, 2, '8', 'Spine title'),
(247, 1, '0', 'No added entry'),
(247, 1, '1', 'Added entry'),
(247, 2, '0', 'Display note'),
(247, 2, '1', 'Do not display note'),
(250, 1, '#', 'Undefined'),
(250, 2, '#', 'Undefined'),
(254, 1, '#', 'Undefined'),
(254, 2, '#', 'Undefined'),
(255, 1, '#', 'Undefined'),
(255, 2, '#', 'Undefined'),
(256, 1, '#', 'Undefined'),
(256, 2, '#', 'Undefined'),
(257, 1, '#', 'Undefined'),
(257, 2, '#', 'Undefined'),
(260, 1, '#', 'Not applicable/No information provided/Earliest available publisher'),
(260, 1, '2', 'Intervening publisher'),
(260, 1, '3', 'Current/latest publisher'),
(260, 2, '#', 'Undefined'),
(261, 1, '#', 'Undefined'),
(261, 2, '#', 'Undefined'),
(262, 1, '#', 'Undefined'),
(262, 2, '#', 'Undefined'),
(263, 1, '#', 'Undefined'),
(263, 2, '#', 'Undefined'),
(270, 1, '#', 'No level specified'),
(270, 1, '1', 'Primary'),
(270, 1, '2', 'Secondary'),
(270, 2, '#', 'No type specified'),
(270, 2, '0', 'Mailing'),
(270, 2, '7', 'Type specified in subfield $i'),
(300, 1, '#', 'Undefined'),
(300, 2, '#', 'Undefined'),
(306, 1, '#', 'Undefined'),
(306, 2, '#', 'Undefined'),
(307, 1, '#', 'Hours'),
(307, 1, '8', 'No display constant generated'),
(307, 2, '#', 'Undefined'),
(310, 1, '#', 'Undefined'),
(310, 2, '#', 'Undefined'),
(340, 1, '#', 'Undefined'),
(340, 2, '#', 'Undefined'),
(342, 1, '0', 'Horizontal coordinate system'),
(342, 1, '1', 'Vertical coordinate system'),
(342, 2, '0', 'Geographic'),
(342, 2, '1', 'Map projection'),
(342, 2, '2', 'Grid coordinate system'),
(342, 2, '3', 'Local planar'),
(342, 2, '4', 'Local'),
(342, 2, '5', 'Geodetic model'),
(342, 2, '6', 'Altitude'),
(342, 2, '7', 'Method specified in $2'),
(342, 2, '8', 'Depth'),
(343, 1, '#', 'Undefined'),
(343, 2, '#', 'Undefined'),
(351, 1, '#', 'Undefined'),
(351, 2, '#', 'Undefined'),
(352, 1, '#', 'Undefined'),
(352, 2, '#', 'Undefined'),
(355, 1, '0', 'Document'),
(355, 1, '1', 'Title'),
(355, 1, '2', 'Abstract'),
(355, 1, '3', 'Contents note'),
(355, 1, '4', 'Author'),
(355, 1, '5', 'Record'),
(355, 1, '8', 'Other element'),
(355, 2, '#', 'Undefined'),
(357, 1, '#', 'Undefined'),
(357, 2, '#', 'Undefined'),
(362, 1, '0', 'Formatted style'),
(362, 1, '1', 'Unformatted note'),
(362, 2, '#', 'Undefined'),
(400, 1, '0', 'Forename'),
(400, 1, '1', 'Surname'),
(400, 1, '3', 'Family name'),
(400, 2, '0', 'Main entry not represented by pronoun'),
(400, 2, '1', 'Main entry represented by pronoun'),
(410, 1, '0', 'Inverted name'),
(410, 1, '1', 'Jurisdiction name'),
(410, 1, '2', 'Name in direct order'),
(410, 2, '0', 'Main entry not represented by pronoun'),
(410, 2, '1', 'Main entry represented by pronoun'),
(411, 1, '0', 'Inverted name'),
(411, 1, '1', 'Jurisdiction name'),
(411, 1, '2', 'Name in direct order'),
(411, 2, '0', 'Main entry not represented by pronoun'),
(411, 2, '1', 'Main entry represented by pronoun'),
(440, 1, '#', 'Undefined'),
(490, 1, '0', 'Series not traced'),
(490, 1, '1', 'Series traced differently'),
(490, 2, '#', 'Undefined'),
(500, 1, '#', 'Undefined'),
(500, 2, '#', 'Undefined'),
(501, 1, '#', 'Undefined'),
(501, 2, '#', 'Undefined'),
(502, 1, '#', 'Undefined'),
(502, 2, '#', 'Undefined'),
(504, 1, '#', 'Undefined'),
(504, 2, '#', 'Undefined'),
(505, 1, '0', 'Contents'),
(505, 1, '1', 'Incomplete contents'),
(505, 1, '2', 'Partial contents'),
(505, 1, '8', 'No display constant generated'),
(505, 2, '#', 'Basic'),
(505, 2, '0', 'Enhanced'),
(506, 1, '#', 'Undefined'),
(506, 2, '#', 'Undefined'),
(507, 1, '#', 'Undefined'),
(507, 2, '#', 'Undefined'),
(508, 1, '#', 'Undefined'),
(508, 2, '#', 'Undefined'),
(510, 1, '0', 'Coverage unknown'),
(510, 1, '1', 'Coverage complete'),
(510, 1, '2', 'Coverage is selective'),
(510, 1, '3', 'Location in source not given'),
(510, 1, '4', 'Location in source given'),
(510, 2, '#', 'Undefined'),
(511, 1, '0', 'No display constant generated'),
(511, 1, '1', 'Cast'),
(511, 2, '#', 'Undefined'),
(513, 1, '#', 'Undefined'),
(513, 2, '#', 'Undefined'),
(514, 1, '#', 'Undefined'),
(514, 2, '#', 'Undefined'),
(515, 1, '#', 'Undefined'),
(515, 2, '#', 'Undefined'),
(516, 1, '#', 'Type of file'),
(516, 1, '8', 'No display constant generated'),
(516, 2, '#', 'Undefined'),
(518, 1, '#', 'Undefined'),
(518, 2, '#', 'Undefined'),
(520, 1, '#', 'Summary'),
(520, 1, '0', 'Subject'),
(520, 1, '1', 'Review'),
(520, 1, '2', 'Scope and content'),
(520, 1, '3', 'Abstract'),
(520, 1, '8', 'No display constant generated'),
(520, 2, '#', 'Undefined'),
(521, 1, '#', 'Audience'),
(521, 1, '0', 'Reading grade level'),
(521, 1, '1', 'Interest age level'),
(521, 1, '2', 'Interest grade level'),
(521, 1, '3', 'Special audience characteristics'),
(521, 1, '4', 'Motivation interest level'),
(521, 1, '8', 'No display constant generated'),
(521, 2, '#', 'Undefined'),
(522, 1, '#', 'Geographic coverage'),
(522, 1, '8', 'No display constant generated'),
(522, 2, '#', 'Undefined'),
(524, 1, '#', 'Cite as'),
(524, 1, '8', 'No display constant generated'),
(524, 2, '#', 'Undefined'),
(525, 1, '#', 'Undefined'),
(525, 2, '#', 'Undefined'),
(526, 1, '0', 'Reading program'),
(526, 1, '8', 'No display constant generated'),
(526, 2, '#', 'Undefined'),
(530, 1, '#', 'Undefined'),
(530, 2, '#', 'Undefined'),
(533, 1, '#', 'Undefined'),
(533, 2, '#', 'Undefined'),
(534, 1, '#', 'Undefined'),
(534, 2, '#', 'Undefined'),
(535, 1, '1', 'Holder of originals'),
(535, 1, '2', 'Holder of duplicates'),
(535, 2, '#', 'Undefined'),
(536, 1, '#', 'Undefined'),
(536, 2, '#', 'Undefined'),
(538, 1, '#', 'Undefined'),
(538, 2, '#', 'Undefined'),
(540, 1, '#', 'Undefined'),
(540, 2, '#', 'Undefined'),
(541, 1, '#', 'Undefined'),
(541, 2, '#', 'Undefined'),
(544, 1, '#', 'No information provided'),
(544, 1, '0', 'Associated materials'),
(544, 1, '1', 'Related materials'),
(544, 2, '#', 'Undefined'),
(545, 1, '#', 'No information provided'),
(545, 1, '0', 'Biographical sketch'),
(545, 1, '1', 'Administrative history'),
(545, 2, '#', 'Undefined'),
(546, 1, '#', 'Undefined'),
(546, 2, '#', 'Undefined'),
(547, 1, '#', 'Undefined'),
(547, 2, '#', 'Undefined'),
(550, 1, '#', 'Undefined'),
(550, 2, '#', 'Undefined'),
(552, 1, '#', 'Undefined'),
(552, 2, '#', 'Undefined'),
(555, 1, '#', 'Indexes'),
(555, 1, '0', 'Finding aids'),
(555, 1, '8', 'No display constant generated'),
(555, 2, '#', 'Undefined'),
(556, 1, '#', 'Documentation'),
(556, 1, '8', 'No display constant generated'),
(556, 2, '#', 'Undefined'),
(561, 1, '#', 'Undefined'),
(561, 2, '#', 'Undefined'),
(562, 1, '#', 'Undefined'),
(562, 2, '#', 'Undefined'),
(565, 1, '#', 'File size'),
(565, 1, '0', 'Case file characteristics'),
(565, 1, '8', 'No display constant generated'),
(565, 2, '#', 'Undefined'),
(567, 1, '#', 'Methodology'),
(567, 1, '8', 'No display constant generated'),
(567, 2, '#', 'Undefined'),
(580, 1, '#', 'Undefined'),
(580, 2, '#', 'Undefined'),
(581, 1, '#', 'Publications'),
(581, 1, '8', 'No display constant generated'),
(581, 2, '#', 'Undefined'),
(583, 1, '#', 'Undefined'),
(583, 2, '#', 'Undefined'),
(584, 1, '#', 'Undefined'),
(584, 2, '#', 'Undefined'),
(585, 1, '#', 'Undefined'),
(585, 2, '#', 'Undefined'),
(586, 1, '#', 'Awards'),
(586, 1, '8', 'No display constant generated'),
(586, 2, '#', 'Undefined'),
(600, 1, '0', 'Forename'),
(600, 1, '1', 'Surname'),
(600, 1, '3', 'Family name'),
(600, 2, '0', 'Library of Congress Subject Headings'),
(600, 2, '1', 'LC subject headings for children''s literature'),
(600, 2, '2', 'Medical Subject Headings'),
(600, 2, '3', 'National Agricultural Library subject authority file'),
(600, 2, '4', 'Source not specified'),
(600, 2, '5', 'Canadian Subject Headings'),
(600, 2, '6', 'R&eacute,pertoire de vedettes-mati&egrave,re'),
(600, 2, '7', 'Source specified in subfield $2'),
(610, 1, '0', 'Inverted name'),
(610, 1, '1', 'Jurisdiction name'),
(610, 1, '2', 'Name in direct order'),
(610, 2, '0', 'Library of Congress Subject Headings'),
(610, 2, '1', 'LC subject headings for children''s literature'),
(610, 2, '2', 'Medical Subject Headings'),
(610, 2, '4', 'Source not specified'),
(610, 2, '5', 'Canadian Subject Headings'),
(610, 2, '6', 'R&eacute,pertoire de vedettes-mati&egrave,re'),
(610, 2, '7', 'Source specified in subfield $2'),
(611, 1, '0', 'Inverted name'),
(611, 1, '1', 'Jurisdiction name'),
(611, 1, '2', 'Name in direct order'),
(611, 2, '0', 'Library of Congress Subject Headings'),
(611, 2, '1', 'LC subject headings for children''s literature'),
(611, 2, '2', 'Medical Subject Headings'),
(611, 2, '3', 'National Agricultural Library subject authority file'),
(611, 2, '4', 'Source not specified'),
(611, 2, '5', 'Canadian Subject Headings'),
(611, 2, '6', 'R&eacute,pertoire de vedettes-mati&egrave,re'),
(611, 2, '7', 'Source specified in subfield $2'),
(630, 2, '0', 'Library of Congress Subject Headings'),
(630, 2, '1', 'LC subject headings for children''s literature'),
(630, 2, '2', 'Medical Subject Headings'),
(630, 2, '3', 'National Agricultural Library subject authority file'),
(630, 2, '4', 'Source not specified'),
(630, 2, '5', 'Canadian Subject Headings'),
(630, 2, '6', 'R&eacute,pertoire de vedettes-mati&egrave,re'),
(630, 2, '7', 'Source specified in subfield $2'),
(650, 1, '#', 'No information provided'),
(650, 1, '0', 'No level specified'),
(650, 1, '2', 'Secondary'),
(650, 2, '0', 'Library of Congress Subject Headings'),
(650, 2, '1', 'LC subject headings for children''s literature'),
(650, 2, '2', 'Medical Subject Headings'),
(650, 2, '3', 'National Agricultural Library subject authority file'),
(650, 2, '4', 'Source not specified'),
(650, 2, '5', 'Canadian Subject Headings'),
(650, 2, '6', 'R&eacute,pertoire de vedettes-mati&egrave,re'),
(650, 2, '7', 'Source specified in subfield $2'),
(651, 1, '#', 'Undefined'),
(651, 2, '0', 'Library of Congress Subject Headings'),
(651, 2, '1', 'LC subject headings for children''s literature'),
(651, 2, '2', 'Medical Subject Headings'),
(651, 2, '3', 'National Agricultural Library subject authority file'),
(651, 2, '4', 'Source not specified'),
(651, 2, '5', 'Canadian Subject Headings'),
(651, 2, '6', 'R&eacute,pertoire de vedettes-mati&egrave,re'),
(651, 2, '7', 'Source specified in subfield $2'),
(653, 1, '#', 'No information provided'),
(653, 1, '0', 'No level specified'),
(653, 1, '1', 'Primary'),
(653, 1, '2', 'Secondary'),
(653, 2, '#', 'Undefined'),
(654, 1, '#', 'No information provided'),
(654, 1, '0', 'No level specified'),
(654, 1, '1', 'Primary'),
(654, 1, '2', 'Secondary'),
(654, 2, '#', 'Undefined'),
(655, 1, '#', 'Basic'),
(655, 1, '0', 'Faceted'),
(655, 2, '7', 'Source specified in subfield $2'),
(656, 1, '#', 'Undefined'),
(656, 2, '7', 'Source specified in subfield $2'),
(657, 1, '#', 'Undefined'),
(657, 2, '7', 'Source specified in subfield $2'),
(658, 1, '#', 'Undefined'),
(658, 2, '#', 'Undefined'),
(700, 1, '0', 'Forename'),
(700, 1, '1', 'Surname'),
(700, 1, '3', 'Family name'),
(700, 2, '#', 'No information provided'),
(700, 2, '2', 'Analytical entry'),
(710, 1, '0', 'Inverted name'),
(710, 1, '1', 'Jurisdiction name'),
(710, 1, '2', 'Name in direct order'),
(710, 2, '#', 'No information provided'),
(710, 2, '2', 'Analytical entry'),
(711, 1, '0', 'Inverted name'),
(711, 1, '1', 'Jurisdiction name'),
(711, 1, '2', 'Name in direct order'),
(711, 2, '#', 'No information provided'),
(711, 2, '2', 'Analytical entry'),
(720, 1, '#', 'Not specified'),
(720, 1, '1', 'Personal'),
(720, 1, '2', 'Other'),
(720, 2, '#', 'Undefined'),
(730, 2, '#', 'No information provided'),
(730, 2, '2', 'Analytical entry'),
(740, 2, '#', 'No information provided'),
(740, 2, '2', 'Analytical entry'),
(752, 1, '#', 'Undefined'),
(752, 2, '#', 'Undefined'),
(753, 1, '#', 'Undefined'),
(753, 2, '#', 'Undefined'),
(754, 1, '#', 'Undefined'),
(754, 2, '#', 'Undefined'),
(760, 1, '0', 'Display note'),
(760, 1, '1', 'Do not display note'),
(760, 2, '#', 'Main series'),
(760, 2, '8', 'No display constant generated'),
(762, 1, '0', 'Display note'),
(762, 1, '1', 'Do not display note'),
(762, 2, '#', 'Has subseries'),
(762, 2, '8', 'No display constant generated'),
(765, 1, '0', 'Display note'),
(765, 1, '1', 'Do not display note'),
(765, 2, '#', 'Translation of'),
(765, 2, '8', 'No display constant generated'),
(767, 1, '0', 'Display note'),
(767, 1, '1', 'Do not display note'),
(767, 2, '#', 'Translated as'),
(767, 2, '8', 'No display constant generated'),
(770, 1, '0', 'Display note'),
(770, 1, '1', 'Do not display note'),
(770, 2, '#', 'Has supplement'),
(770, 2, '8', 'No display constant generated'),
(772, 1, '0', 'Display note'),
(772, 1, '1', 'Do not display note'),
(772, 2, '#', 'Supplement to'),
(772, 2, '0', 'Parent'),
(772, 2, '8', 'No display constant generated'),
(773, 1, '0', 'Display note'),
(773, 1, '1', 'Do not display note'),
(773, 2, '#', 'In'),
(773, 2, '8', 'No display constant generated'),
(774, 1, '0', 'Display note'),
(774, 1, '1', 'Do not display note'),
(774, 2, '#', 'Constituent unit'),
(774, 2, '8', 'No display constant generated'),
(775, 1, '0', 'Display note'),
(775, 1, '1', 'Do not display note'),
(775, 2, '#', 'Other edition available'),
(775, 2, '8', 'No display constant generated'),
(776, 1, '0', 'Display note'),
(776, 1, '1', 'Do not display note'),
(776, 2, '#', 'Available in another form'),
(776, 2, '8', 'No display constant generated'),
(777, 1, '0', 'Display note'),
(777, 1, '1', 'Do not display note'),
(777, 2, '#', 'Issued with'),
(777, 2, '8', 'No display constant generated'),
(780, 1, '0', 'Display note'),
(780, 1, '1', 'Do not display note'),
(780, 2, '0', 'Continues'),
(780, 2, '1', 'Continues in part'),
(780, 2, '2', 'Supersedes'),
(780, 2, '3', 'Supersedes in part'),
(780, 2, '4', 'Formed by the union of ... and ...'),
(780, 2, '5', 'Absorbed'),
(780, 2, '6', 'Absorbed in part'),
(780, 2, '7', 'Separated from'),
(785, 1, '0', 'Display note'),
(785, 1, '1', 'Do not display note'),
(785, 2, '0', 'Continued by'),
(785, 2, '1', 'Continued in part by'),
(785, 2, '2', 'Superseded by'),
(785, 2, '3', 'Superseded in part by'),
(785, 2, '4', 'Absorbed by'),
(785, 2, '5', 'Absorbed in part by'),
(785, 2, '6', 'Split into ... and ...'),
(785, 2, '7', 'Merged with ... to form ...'),
(785, 2, '8', 'Changed back to'),
(786, 1, '0', 'Display note'),
(786, 1, '1', 'Do not display note'),
(786, 2, '#', 'Data source'),
(786, 2, '8', 'No display constant generated'),
(787, 1, '0', 'Display note'),
(787, 1, '1', 'Do not display note'),
(787, 2, '#', 'Related item'),
(787, 2, '8', 'No display constant generated'),
(800, 1, '0', 'Forename'),
(800, 1, '1', 'Surname'),
(800, 1, '3', 'Family name'),
(800, 2, '#', 'Undefined'),
(810, 1, '0', 'Inverted name'),
(810, 1, '1', 'Jurisdiction name'),
(810, 1, '2', 'Name in direct order'),
(810, 2, '#', 'Undefined'),
(811, 1, '0', 'Inverted name'),
(811, 1, '1', 'Jurisdiction name'),
(811, 1, '2', 'Name in direct order'),
(811, 2, '#', 'Undefined'),
(830, 1, '#', 'Undefined'),
(850, 1, '#', 'Undefined'),
(850, 2, '#', 'Undefined'),
(852, 1, '#', 'No information provided'),
(852, 1, '0', 'Library of Congress classification'),
(852, 1, '1', 'Dewey Decimal classification'),
(852, 1, '2', 'National Library of Medicine classification'),
(852, 1, '3', 'Superintendent of Documents classification'),
(852, 1, '4', 'Shelving control number'),
(852, 1, '5', 'Title'),
(852, 1, '6', 'Shelved separately'),
(852, 1, '7', 'Source specified in subfield $2'),
(852, 1, '8', 'Other scheme'),
(852, 2, '#', 'No information provided'),
(852, 2, '0', 'Not enumeration'),
(852, 2, '1', 'Primary enumeration'),
(852, 2, '2', 'Alternative enumeration'),
(856, 1, '#', 'No information provided'),
(856, 1, '0', 'Email'),
(856, 1, '1', 'FTP'),
(856, 1, '2', 'Remote login (Telnet)'),
(856, 1, '3', 'Dial-up'),
(856, 1, '4', 'HTTP'),
(856, 1, '7', 'Method specified in subfield $2'),
(856, 2, '#', 'No information provided'),
(856, 2, '0', 'Resource'),
(856, 2, '1', 'Version of resource'),
(856, 2, '2', 'Related resource'),
(856, 2, '8', 'No display constant generated'),
(886, 1, '0', 'Leader'),
(886, 1, '1', 'Variable control fields (002-009)'),
(886, 1, '2', 'Variable data fields (010-999)'),
(886, 2, '#', 'Undefined'),
(887, 1, '#', 'Undefined'),
(887, 2, '#', 'Undefined');

-- --------------------------------------------------------

--
-- Table structure for table `usmarc_subfield_dm`
--

CREATE TABLE `usmarc_subfield_dm` (
  `tag` smallint(6) NOT NULL,
  `subfield_cd` char(1) NOT NULL,
  `description` varchar(80) NOT NULL,
  `repeatable_flg` char(1) NOT NULL,
  PRIMARY KEY (`tag`,`subfield_cd`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `usmarc_subfield_dm`
--

INSERT INTO `usmarc_subfield_dm` VALUES
(10, 'a', 'LC control number', 'N'),
(10, 'b', 'NUCMC control number', 'Y'),
(10, 'z', 'Canceled/invalid LC control number', 'Y'),
(10, '8', 'Field link and sequence number', 'Y'),
(13, 'a', 'Number', 'N'),
(13, 'b', 'Country', 'N'),
(13, 'c', 'Type of number', 'N'),
(13, 'd', 'Date', 'Y'),
(13, 'e', 'Status', 'Y'),
(13, 'f', 'Party to document', 'Y'),
(13, '6', 'Linkage', 'N'),
(13, '8', 'Field link and sequence number', 'Y'),
(15, 'a', 'National bibliography number', 'Y'),
(15, '2', 'Source', 'N'),
(15, '6', 'Linkage', 'N'),
(15, '8', 'Field link and sequence number', 'Y'),
(16, 'a', 'Record control number', 'N'),
(16, 'z', 'Canceled or invalid record control number', 'Y'),
(16, '2', 'Source', 'N'),
(16, '8', 'Field link and sequence number', 'Y'),
(17, 'a', 'Copyright registration number', 'Y'),
(17, 'b', 'Assigning agency', 'N'),
(17, '2', 'Source', 'N'),
(17, '6', 'Linkage', 'N'),
(17, '8', 'Field link and sequence number', 'Y'),
(18, 'a', 'Copyright article-fee code', 'N'),
(18, '8', 'Field link and sequence number', 'Y'),
(20, 'a', 'International Standard Book Number', 'N'),
(20, 'c', 'Terms of availability', 'N'),
(20, 'z', 'Canceled/invalid ISBN', 'Y'),
(20, '6', 'Linkage', 'N'),
(20, '8', 'Field link and sequence number', 'Y'),
(22, 'a', 'International Standard Serial Number', 'N'),
(22, 'y', 'Incorrect ISSN', 'Y'),
(22, 'z', 'Canceled ISSN', 'Y'),
(22, '6', 'Linkage', 'N'),
(22, '8', 'Field link and sequence number', 'Y'),
(24, 'a', 'Standard number or code', 'N'),
(24, 'c', 'Terms of availability', 'N'),
(24, 'd', 'Additional codes following the standard number or code', 'N'),
(24, 'z', 'Canceled/invalid standard number or code', 'Y'),
(24, '2', 'Source of number or code', 'N'),
(24, '6', 'Linkage', 'N'),
(24, '8', 'Field link and sequence number', 'Y'),
(25, 'a', 'Overseas acquisition number', 'Y'),
(25, '8', 'Field link and sequence number', 'Y'),
(27, 'a', 'Standard technical report number', 'N'),
(27, 'z', 'Canceled/invalid number', 'Y'),
(27, '6', 'Linkage', 'N'),
(27, '8', 'Field link and sequence number', 'Y'),
(28, 'a', 'Publisher number', 'N'),
(28, 'b', 'Source', 'N'),
(28, '6', 'Linkage', 'N'),
(28, '8', 'Field link and sequence number', 'Y'),
(30, 'a', 'CODEN', 'N'),
(30, 'z', 'Canceled/invalid CODEN', 'Y'),
(30, '6', 'Linkage', 'N'),
(30, '8', 'Field link and sequence number', 'Y'),
(32, 'a', 'Postal registration number', 'N'),
(32, 'b', 'Source (agency assigning number)', 'N'),
(32, '6', 'Linkage', 'N'),
(32, '8', 'Field link and sequence number', 'Y'),
(33, 'a', 'Formatted date/time', 'Y'),
(33, 'b', 'Geographic classification area code', 'Y'),
(33, 'c', 'Geographic classification subarea code', 'Y'),
(33, '3', 'Materials specified', 'N'),
(33, '6', 'Linkage', 'N'),
(33, '8', 'Field link and sequence number', 'Y'),
(34, 'a', 'Category of scale', 'N'),
(34, 'b', 'Constant ratio linear horizontal scale', 'Y'),
(34, 'c', 'Constant ratio linear vertical scale', 'Y'),
(34, 'd', 'Coordinates--westernmost longitude', 'N'),
(34, 'e', 'Coordinates--easternmost longitude', 'N'),
(34, 'f', 'Coordinates--northernmost latitude', 'N'),
(34, 'g', 'Coordinates--southernmost latitude', 'N'),
(34, 'h', 'Angular scale', 'Y'),
(34, 'j', 'Declination--northern limit', 'N'),
(34, 'k', 'Declination--southern limit', 'N'),
(34, 'm', 'Right ascension--eastern limit', 'N'),
(34, 'n', 'Right ascension--western limit', 'N'),
(34, 'p', 'Equinox', 'N'),
(34, 's', 'G-ring latitude', 'Y'),
(34, 't', 'G-ring longitude', 'Y'),
(34, '6', 'Linkage', 'N'),
(34, '8', 'Field link and sequence number', 'Y'),
(35, 'a', 'System control number', 'N'),
(35, 'z', 'Canceled/invalid control number', 'Y'),
(35, '6', 'Linkage', 'N'),
(35, '8', 'Field link and sequence number', 'Y'),
(36, 'a', 'Original study number', 'N'),
(36, 'b', 'Source (agency assigning number)', 'N'),
(36, '6', 'Linkage', 'N'),
(36, '8', 'Field link and sequence number', 'Y'),
(37, 'a', 'Stock number', 'N'),
(37, 'b', 'Source of stock number/acquisition', 'N'),
(37, 'c', 'Terms of availability', 'Y'),
(37, 'f', 'Form of issue', 'Y'),
(37, 'g', 'Additional format characteristics', 'Y'),
(37, 'n', 'Note', 'Y'),
(37, '6', 'Linkage', 'N'),
(37, '8', 'Field link and sequence number', 'Y'),
(40, 'a', 'Original cataloging agency', 'N'),
(40, 'b', 'Language of cataloging', 'N'),
(40, 'c', 'Transcribing agency', 'N'),
(40, 'd', 'Modifying agency', 'Y'),
(40, 'e', 'Description conventions', 'N'),
(40, '6', 'Linkage', 'N'),
(40, '8', 'Field link and sequence number', 'Y'),
(41, 'a', 'Language code of text/sound track or separate title', 'Y'),
(41, 'b', 'Language code of summary or abstract/overprinted title or subtitle', 'Y'),
(41, 'd', 'Language code of sung or spoken text', 'Y'),
(41, 'e', 'Language code of librettos', 'Y'),
(41, 'f', 'Language code of table of contents', 'Y'),
(41, 'g', 'Language code of accompanying material other than librettos', 'Y'),
(41, 'h', 'Language code of original and/or intermediate translations of text', 'Y'),
(41, '2', 'Source of code', 'N'),
(41, '6', 'Linkage', 'N'),
(41, '8', 'Field link and sequence number', 'Y'),
(42, 'a', 'Authentication code', 'Y'),
(43, 'a', 'Geographic area code', 'Y'),
(43, 'b', 'Local GAC code', 'Y'),
(43, 'c', 'ISO code', 'Y'),
(43, '2', 'Source of local code', 'Y'),
(43, '6', 'Linkage', 'N'),
(43, '8', 'Field link and sequence number', 'Y'),
(44, 'a', 'Country of publishing/producing entity code', 'Y'),
(44, 'b', 'Local subentity code', 'Y'),
(44, 'c', 'ISO code', 'Y'),
(44, '2', 'Source of local subentity code', 'Y'),
(44, '6', 'Linkage', 'N'),
(44, '8', 'Field link and sequence number', 'Y'),
(45, 'a', 'Time period code', 'Y'),
(45, 'b', 'Formatted 9999 B.C. through C.E. time period', 'Y'),
(45, 'c', 'Formatted pre-9999 B.C. time period', 'Y'),
(45, '6', 'Linkage', 'N'),
(45, '8', 'Field link and sequence number', 'Y'),
(46, 'a', 'Type of date code', 'N'),
(46, 'b', 'Date 1 (B.C. date)', 'N'),
(46, 'c', 'Date 1 (C.E. date)', 'N'),
(46, 'd', 'Date 2 (B.C. date)', 'N'),
(46, 'e', 'Date 2 (C.E. date)', 'N'),
(46, '6', 'Linkage', 'N'),
(46, '8', 'Field link and sequence number', 'Y'),
(47, 'a', 'Form of musical composition code', 'Y'),
(47, '8', 'Field link and sequence number', 'Y'),
(48, 'a', 'Performer or ensemble', 'Y'),
(48, 'b', 'Soloist', 'Y'),
(48, '8', 'Field link and sequence number', 'Y'),
(50, 'a', 'Classification number', 'Y'),
(50, 'b', 'Item number', 'N'),
(50, '3', 'Materials specified', 'N'),
(50, '6', 'Linkage', 'N'),
(50, '8', 'Field link and sequence number', 'Y'),
(51, 'a', 'Classification number', 'N'),
(51, 'b', 'Item number', 'N'),
(51, 'c', 'Copy information', 'N'),
(51, '8', 'Field link and sequence number', 'Y'),
(52, 'a', 'Geographic classification area code', 'N'),
(52, 'b', 'Geographic classification subarea code', 'Y'),
(52, 'd', 'Populated place name', 'Y'),
(52, '2', 'Code source', 'N'),
(52, '6', 'Linkage', 'N'),
(52, '8', 'Field link and sequence number', 'Y'),
(55, 'a', 'Classification number', 'N'),
(55, 'b', 'Item number', 'N'),
(55, '2', 'Source of call/class number', 'N'),
(55, '8', 'Field link and sequence number', 'Y'),
(60, 'a', 'Classification number', 'Y'),
(60, 'b', 'Item number', 'N'),
(60, '8', 'Field link and sequence number', 'Y'),
(61, 'a', 'Classification number', 'Y'),
(61, 'b', 'Item number', 'N'),
(61, 'c', 'Copy information', 'N'),
(61, '8', 'Field link and sequence number', 'Y'),
(66, 'a', 'Primary G0 character set', 'N'),
(66, 'b', 'Primary G1 character set', 'N'),
(66, 'c', 'Alternate G0 or G1 character set', 'Y'),
(70, 'a', 'Classification number', 'Y'),
(70, 'b', 'Item number', 'N'),
(70, '8', 'Field link and sequence number', 'Y'),
(71, 'a', 'Classification number', 'Y'),
(71, 'b', 'Item number', 'N'),
(71, 'c', 'Copy information', 'N'),
(71, '8', 'Field link and sequence number', 'Y'),
(72, 'a', 'Subject category code', 'N'),
(72, 'x', 'Subject category code subdivision', 'Y'),
(72, '2', 'Code source', 'N'),
(72, '6', 'Linkage', 'N'),
(72, '8', 'Field link and sequence number', 'Y'),
(74, 'a', 'GPO item number', 'N'),
(74, 'z', 'Canceled/invalid GPO item number', 'Y'),
(74, '8', 'Field link and sequence number', 'Y'),
(80, 'a', 'Universal Decimal Classification number', 'N'),
(80, 'b', 'Item number', 'N'),
(80, 'x', 'Common auxiliary subdivision', 'Y'),
(80, '2', 'Edition identifier', 'N'),
(80, '6', 'Linkage', 'N'),
(80, '8', 'Field link and sequence number', 'Y'),
(82, 'a', 'Classification number', 'Y'),
(82, 'b', 'Item number', 'N'),
(82, '2', 'Edition number', 'N'),
(82, '6', 'Linkage', 'N'),
(82, '8', 'Field link and sequence number', 'Y'),
(84, 'a', 'Classification number', 'Y'),
(84, 'b', 'Item number', 'N'),
(84, '2', 'Source of number', 'N'),
(84, '6', 'Linkage', 'N'),
(84, '8', 'Field link and sequence number', 'Y'),
(86, 'a', 'Classification number', 'N'),
(86, 'z', 'Canceled/invalid classification number', 'Y'),
(86, '2', 'Number source', 'N'),
(86, '6', 'Linkage', 'N'),
(86, '8', 'Field link and sequence number', 'Y'),
(88, 'a', 'Report number', 'N'),
(88, 'z', 'Canceled/invalid report number', 'Y'),
(88, '6', 'Linkage', 'N'),
(88, '8', 'Field link and sequence number', 'Y'),
(100, 'a', 'Personal name', 'N'),
(100, 'b', 'Numeration', 'N'),
(100, 'c', 'Titles and other words associated with a name', 'Y'),
(100, 'd', 'Dates associated with a name', 'N'),
(100, 'e', 'Relator term', 'Y'),
(100, 'f', 'Date of a work', 'N'),
(100, 'g', 'Miscellaneous information', 'N'),
(100, 'j', 'Attribution qualifier', 'Y'),
(100, 'k', 'Form subheading', 'Y'),
(100, 'l', 'Language of a work', 'N'),
(100, 'n', 'Number of part/section of a work', 'Y'),
(100, 'p', 'Name of part/section of a work', 'Y'),
(100, 'q', 'Fuller form of name', 'N'),
(100, 't', 'Title of a work', 'N'),
(100, 'u', 'Affiliation', 'N'),
(100, '4', 'Relator code', 'Y'),
(100, '6', 'Linkage', 'N'),
(100, '8', 'Field link and sequence number', 'Y'),
(110, 'a', 'Corporate name or jurisdiction name as entry element', 'N'),
(110, 'b', 'Subordinate unit', 'Y'),
(110, 'c', 'Location of meeting', 'N'),
(110, 'd', 'Date of meeting or treaty signing', 'Y'),
(110, 'e', 'Relator term', 'Y'),
(110, 'f', 'Date of a work', 'N'),
(110, 'g', 'Miscellaneous information', 'N'),
(110, 'k', 'Form subheading', 'Y'),
(110, 'l', 'Language of a work', 'N'),
(110, 'n', 'Number of part/section/meeting', 'Y'),
(110, 'p', 'Name of part/section of a work', 'Y'),
(110, 't', 'Title of a work', 'N'),
(110, 'u', 'Affiliation', 'N'),
(110, '4', 'Relator code', 'Y'),
(110, '6', 'Linkage', 'N'),
(110, '8', 'Field link and sequence number', 'Y'),
(111, 'a', 'Meeting name or jurisdiction name as entry element', 'N'),
(111, 'c', 'Location of meeting', 'N'),
(111, 'd', 'Date of meeting', 'N'),
(111, 'e', 'Subordinate unit', 'Y'),
(111, 'f', 'Date of a work', 'N'),
(111, 'g', 'Miscellaneous information', 'N'),
(111, 'k', 'Form subheading', 'Y'),
(111, 'l', 'Language of a work', 'N'),
(111, 'n', 'Number of part/section/meeting', 'Y'),
(111, 'p', 'Name of part/section of a work', 'Y'),
(111, 'q', 'Name of meeting following jurisdiction name entry element', 'N'),
(111, 't', 'Title of a work', 'N'),
(111, 'u', 'Affiliation', 'N'),
(111, '4', 'Relator code', 'Y'),
(111, '6', 'Linkage', 'N'),
(111, '8', 'Field link and sequence number', 'Y'),
(130, 'a', 'Uniform title', 'N'),
(130, 'd', 'Date of treaty signing', 'Y'),
(130, 'f', 'Date of a work', 'N'),
(130, 'g', 'Miscellaneous information', 'N'),
(130, 'h', 'Medium', 'N'),
(130, 'k', 'Form subheading', 'Y'),
(130, 'l', 'Language of a work', 'N'),
(130, 'm', 'Medium of performance for music', 'Y'),
(130, 'n', 'Number of part/section of a work', 'Y'),
(130, 'o', 'Arranged statement for music', 'N'),
(130, 'p', 'Name of part/section of a work', 'Y'),
(130, 'r', 'Key for music', 'N'),
(130, 's', 'Version', 'N'),
(130, 't', 'Title of a work', 'N'),
(130, '6', 'Linkage', 'N'),
(130, '8', 'Field link and sequence number', 'Y'),
(210, 'a', 'Abbreviated title', 'N'),
(210, 'b', 'Qualifying information', 'N'),
(210, '2', 'Source', 'Y'),
(210, '6', 'Linkage', 'N'),
(210, '8', 'Field link and sequence number', 'Y'),
(222, 'a', 'Key title', 'N'),
(222, 'b', 'Qualifying information', 'N'),
(222, '6', 'Linkage', 'N'),
(222, '8', 'Field link and sequence number', 'Y'),
(240, 'a', 'Uniform title', 'N'),
(240, 'd', 'Date of treaty signing', 'Y'),
(240, 'f', 'Date of a work', 'N'),
(240, 'g', 'Miscellaneous information', 'N'),
(240, 'h', 'Medium', 'N'),
(240, 'k', 'Form subheading', 'Y'),
(240, 'l', 'Language of a work', 'N'),
(240, 'm', 'Medium of performance for music', 'Y'),
(240, 'n', 'Number of part/section of a work', 'Y'),
(240, 'o', 'Arranged statement for music', 'N'),
(240, 'p', 'Name of part/section of a work', 'Y'),
(240, 'r', 'Key for music', 'N'),
(240, 's', 'Version', 'N'),
(240, '6', 'Linkage', 'N'),
(240, '8', 'Field link and sequence number', 'Y'),
(242, 'a', 'Title', 'N'),
(242, 'b', 'Remainder of title', 'N'),
(242, 'c', 'Statement of responsibility, etc.', 'N'),
(242, 'h', 'Medium', 'N'),
(242, 'n', 'Number of part/section of a work', 'Y'),
(242, 'p', 'Name of part/section of a work', 'Y'),
(242, 'y', 'Language code of translated title', 'N'),
(242, '6', 'Linkage', 'N'),
(242, '8', 'Field link and sequence number', 'Y'),
(243, 'a', 'Uniform title', 'N'),
(243, 'd', 'Date of treaty signing', 'Y'),
(243, 'f', 'Date of a work', 'N'),
(243, 'g', 'Miscellaneous information', 'N'),
(243, 'h', 'Medium', 'N'),
(243, 'k', 'Form subheading', 'Y'),
(243, 'l', 'Language of a work', 'N'),
(243, 'm', 'Medium of performance for music', 'N'),
(243, 'n', 'Number of part/section of a work', 'Y'),
(243, 'o', 'Arranged statement for music', 'N'),
(243, 'p', 'Name of part/section of a work', 'Y'),
(243, 'r', 'Key for music', 'N'),
(243, 's', 'Version', 'N'),
(243, '6', 'Linkage', 'N'),
(243, '8', 'Field link and sequence number', 'Y'),
(245, 'a', 'Title', 'N'),
(245, 'b', 'Remainder of title', 'N'),
(245, 'c', 'Statement of responsibility, etc.', 'N'),
(245, 'f', 'Inclusive dates', 'N'),
(245, 'g', 'Bulk dates', 'N'),
(245, 'h', 'Medium', 'N'),
(245, 'k', 'Form', 'Y'),
(245, 'n', 'Number of part/section of a work', 'Y'),
(245, 'p', 'Name of part/section of a work', 'Y'),
(245, 's', 'Version', 'N'),
(245, '6', 'Linkage', 'N'),
(245, '8', 'Field link and sequence number', 'Y'),
(246, 'a', 'Title proper/short title', 'N'),
(246, 'b', 'Remainder of title', 'N'),
(246, 'f', 'Date or sequential designation', 'N'),
(246, 'g', 'Miscellaneous information', 'N'),
(246, 'h', 'Medium', 'N'),
(246, 'i', 'Display text', 'N'),
(246, 'n', 'Number of part/section of a work', 'Y'),
(246, 'p', 'Name of part/section of a work', 'Y'),
(246, '5', 'Institution to which field applies', 'N'),
(246, '6', 'Linkage', 'N'),
(246, '8', 'Field link and sequence number', 'Y'),
(247, 'a', 'Title proper/short title', 'N'),
(247, 'b', 'Remainder of title', 'N'),
(247, 'f', 'Date or sequential designation', 'N'),
(247, 'g', 'Miscellaneous information', 'N'),
(247, 'h', 'Medium', 'N'),
(247, 'n', 'Number of part/section of a work', 'Y'),
(247, 'p', 'Name of part/section of a work', 'Y'),
(247, 'x', 'International Standard Serial Number', 'N'),
(247, '6', 'Linkage', 'N'),
(247, '8', 'Field link and sequence number', 'Y'),
(250, 'a', 'Edition statement', 'N'),
(250, 'b', 'Remainder of edition statement', 'N'),
(250, '6', 'Linkage', 'N'),
(250, '8', 'Field link and sequence number', 'Y'),
(254, 'a', 'Musical presentation statement', 'N'),
(254, '6', 'Linkage', 'N'),
(254, '8', 'Field link and sequence number', 'Y'),
(255, 'a', 'Statement of scale', 'N'),
(255, 'b', 'Statement of projection', 'N'),
(255, 'c', 'Statement of coordinates', 'N'),
(255, 'd', 'Statement of zone', 'N'),
(255, 'e', 'Statement of equinox', 'N'),
(255, 'f', 'Outer G-ring coordinate pairs', 'N'),
(255, 'g', 'Exclusion G-ring coordinate pairs', 'N'),
(255, '6', 'Linkage', 'N'),
(255, '8', 'Field link and sequence number', 'Y'),
(256, 'a', 'Computer file characteristics', 'N'),
(256, '6', 'Linkage', 'N'),
(256, '8', 'Field link and sequence number', 'Y'),
(257, 'a', 'Country of producing entity', 'N'),
(257, '6', 'Linkage', 'N'),
(257, '8', 'Field link and sequence number', 'Y'),
(260, 'a', 'Place of publication, distribution, etc.', 'Y'),
(260, 'b', 'Name of publisher, distributor, etc.', 'Y'),
(260, 'c', 'Date of publication, distribution, etc.', 'Y'),
(260, 'd', 'Plates of publisher''s number for music (Pre-AACR 2)  [LOCAL]', 'Y'),
(260, 'e', 'Place of manufacture', 'N'),
(260, 'f', 'Manufacturer', 'N'),
(260, 'g', 'Date of manufacture', 'N'),
(260, '3', 'Materials specified', 'N'),
(260, '8', 'Field link and sequence number', 'Y'),
(261, 'a', 'Producing company', 'Y'),
(261, 'b', 'Releasing company (primary distributor)', 'Y'),
(261, 'd', 'Date of production, release, etc.', 'Y'),
(261, 'e', 'Contractual producer', 'Y'),
(261, 'f', 'Place of production, release, etc.', 'Y'),
(261, '6', 'Linkage', 'N'),
(261, '8', 'Field link and sequence number', 'Y'),
(262, 'a', 'Place of production, release, etc.', 'N'),
(262, 'b', 'Publisher or trade name', 'N'),
(262, 'c', 'Date of production, release, etc.', 'N'),
(262, 'k', 'Serial identification', 'N'),
(262, 'l', 'Matrix and/or take number', 'N'),
(262, '6', 'Linkage', 'N'),
(262, '8', 'Field link and sequence number', 'Y'),
(263, 'a', 'Projected publication date', 'N'),
(263, '6', 'Linkage', 'N'),
(263, '8', 'Field link and sequence number', 'Y'),
(270, 'a', 'Address', 'Y'),
(270, 'b', 'City', 'N'),
(270, 'c', 'State or province', 'N'),
(270, 'd', 'Country', 'N'),
(270, 'e', 'Postal code', 'N'),
(270, 'f', 'Terms preceding attention name', 'N'),
(270, 'g', 'Attention name', 'N'),
(270, 'h', 'Attention position', 'N'),
(270, 'i', 'Type of address', 'N'),
(270, 'j', 'Specialized telephone number', 'Y'),
(270, 'k', 'Telephone number', 'Y'),
(270, 'l', 'Fax number', 'Y'),
(270, 'm', 'Electronic mail address', 'Y'),
(270, 'n', 'TDD or TTY number', 'Y'),
(270, 'p', 'Contact person', 'Y'),
(270, 'q', 'Title of contact person', 'Y'),
(270, 'r', 'Hours', 'Y'),
(270, 'z', 'Public note', 'Y'),
(270, '4', 'Relator code', 'Y'),
(270, '6', 'Linkage', 'N'),
(270, '8', 'Field link and sequence number', 'Y'),
(300, 'a', 'Extent', 'Y'),
(300, 'b', 'Other physical details', 'N'),
(300, 'c', 'Dimensions', 'Y'),
(300, 'e', 'Accompanying material', 'N'),
(300, 'f', 'Type of unit', 'Y'),
(300, 'g', 'Size of unit', 'Y'),
(300, '3', 'Materials specified', 'N'),
(300, '6', 'Linkage', 'N'),
(300, '8', 'Field link and sequence number', 'Y'),
(306, 'a', 'Playing time', 'Y'),
(306, '6', 'Linkage', 'N'),
(306, '8', 'Field link and sequence number', 'Y'),
(307, 'a', 'Hours', 'N'),
(307, 'b', 'Additional information', 'N'),
(307, '6', 'Linkage', 'N'),
(307, '8', 'Field link and sequence number', 'Y'),
(310, 'a', 'Current publication frequency', 'N'),
(310, 'b', 'Date of current publication frequency', 'N'),
(310, '6', 'Linkage', 'N'),
(310, '8', 'Field link and sequence number', 'Y'),
(340, 'a', 'Material base and configuration', 'Y'),
(340, 'b', 'Dimensions', 'Y'),
(340, 'c', 'Materials applied to surface', 'Y'),
(340, 'd', 'Information recording technique', 'Y'),
(340, 'e', 'Support', 'Y'),
(340, 'f', 'Production rate/ratio', 'Y'),
(340, 'h', 'Location within medium', 'Y'),
(340, 'i', 'Technical specifications of medium', 'Y'),
(340, '3', 'Materials specified', 'N'),
(340, '6', 'Linkage', 'N'),
(340, '8', 'Field link and sequence number', 'Y'),
(342, 'a', 'Name', 'N'),
(342, 'b', 'Coordinate or distance units', 'N'),
(342, 'c', 'Latitude resolution', 'N'),
(342, 'd', 'Longitude resolution', 'N'),
(342, 'e', 'Standard parallel or oblique line latitude', 'Y'),
(342, 'f', 'Oblique line longitude', 'Y'),
(342, 'g', 'Longitude of central meridian or projection center', 'N'),
(342, 'h', 'Latitude of projection origin or projection center', 'N'),
(342, 'i', 'False easting', 'N'),
(342, 'j', 'False northing', 'N'),
(342, 'k', 'Scale factor', 'N'),
(342, 'l', 'Height of perspective point above surface', 'N'),
(342, 'm', 'Azimuthal angle', 'N'),
(342, 'n', 'Azimuth measure point longitude or straight vertical', 'N'),
(342, 'o', 'Landsat number and path number', 'N'),
(342, 'p', 'Zone identifier', 'N'),
(342, 'q', 'Ellipsoid name', 'N'),
(342, 'r', 'Semi-major axis', 'N'),
(342, 's', 'Denominator of flattening ratio', 'N'),
(342, 't', 'Vertical resolution', 'N'),
(342, 'u', 'Vertical encoding method', 'N'),
(342, 'v', 'Local planar, local, or other projection or grid description', 'N'),
(342, 'w', 'Local planar or local georeference information', 'N'),
(342, '2', 'Reference method used', 'N'),
(342, '6', 'Linkage', 'N'),
(342, '8', 'Field link and sequence number', 'Y'),
(343, 'a', 'Planar coordinate encoding method', 'N'),
(343, 'b', 'Planar distance units', 'N'),
(343, 'c', 'Abscissa resolution', 'N'),
(343, 'd', 'Ordinate resolution', 'N'),
(343, 'e', 'Distance resolution', 'N'),
(343, 'f', 'Bearing resolution', 'N'),
(343, 'g', 'Bearing units', 'N'),
(343, 'h', 'Bearing reference direction', 'N'),
(343, 'i', 'Bearing reference meridian', 'N'),
(343, '6', 'Linkage', 'N'),
(343, '8', 'Field link and sequence number', 'Y'),
(351, 'a', 'Organization', 'Y'),
(351, 'b', 'Arrangement', 'Y'),
(351, 'c', 'Hierarchical level', 'N'),
(351, '3', 'Materials specified', 'N'),
(351, '6', 'Linkage', 'N'),
(351, '8', 'Field link and sequence number', 'Y'),
(352, 'a', 'Direct reference method', 'N'),
(352, 'b', 'Object type', 'Y'),
(352, 'c', 'Object count', 'Y'),
(352, 'd', 'Row count', 'N'),
(352, 'e', 'Column count', 'N'),
(352, 'f', 'Vertical count', 'N'),
(352, 'g', 'VPF topology level', 'N'),
(352, 'i', 'Indirect reference description', 'N'),
(352, '6', 'Linkage', 'N'),
(352, '8', 'Field link and sequence number', 'Y'),
(355, 'a', 'Security classification', 'N'),
(355, 'b', 'Handling instructions', 'Y'),
(355, 'c', 'External dissemination information', 'Y'),
(355, 'd', 'Downgrading or declassification event', 'N'),
(355, 'e', 'Classification system', 'N'),
(355, 'f', 'Country of origin code', 'N'),
(355, 'g', 'Downgrading date', 'N'),
(355, 'h', 'Declassification date', 'N'),
(355, 'j', 'Authorization', 'Y'),
(355, '6', 'Linkage', 'N'),
(355, '8', 'Field link and sequence number', 'Y'),
(362, 'a', 'Dates of publication and/or sequential designation', 'N'),
(362, 'z', 'Source of information', 'N'),
(362, '6', 'Linkage', 'N'),
(362, '8', 'Field link and sequence number', 'Y'),
(400, 'a', 'Personal name', 'N'),
(400, 'b', 'Numeration', 'N'),
(400, 'c', 'Titles and other words associated with a name', 'Y'),
(400, 'd', 'Dates associated with a name', 'N'),
(400, 'e', 'Relator term', 'Y'),
(400, 'f', 'Date of a work', 'N'),
(400, 'g', 'Miscellaneous information', 'N'),
(400, 'k', 'Form subheading', 'Y'),
(400, 'l', 'Language of a work', 'N'),
(400, 'n', 'Number of part/section of a work', 'Y'),
(400, 'p', 'Name of part/section of a work', 'Y'),
(400, 't', 'Title of a work', 'N'),
(400, 'u', 'Affiliation', 'N'),
(400, 'v', 'Volume number/sequential designation', 'N'),
(400, 'x', 'International Standard Serial Number', 'N'),
(400, '4', 'Relator code', 'Y'),
(400, '6', 'Linkage', 'N'),
(400, '8', 'Field link and sequence number', 'Y'),
(410, 'a', 'Corporate name or jurisdiction name as entry element', 'N'),
(410, 'b', 'Subordinate unit', 'Y'),
(410, 'c', 'Location of meeting', 'N'),
(410, 'd', 'Date of meeting or treaty signing', 'Y'),
(410, 'e', 'Relator term', 'Y'),
(410, 'f', 'Date of a work', 'N'),
(410, 'g', 'Miscellaneous information', 'N'),
(410, 'k', 'Form subheading', 'Y'),
(410, 'l', 'Language of a work', 'N'),
(410, 'n', 'Number of part/section/meeting', 'Y'),
(410, 'p', 'Name of part/section of a work', 'Y'),
(410, 't', 'Title of a work', 'N'),
(410, 'u', 'Affiliation', 'N'),
(410, 'v', 'Volume number/sequential designation', 'N'),
(410, 'x', 'International Standard Serial Number', 'N'),
(410, '4', 'Relator code', 'Y'),
(410, '6', 'Linkage', 'N'),
(410, '8', 'Field link and sequence number', 'Y'),
(411, 'a', 'Meeting name or jurisdiction name as entry element', 'N'),
(411, 'c', 'Location of meeting', 'N'),
(411, 'd', 'Date of meeting', 'N'),
(411, 'e', 'Subordinate unit', 'Y'),
(411, 'f', 'Date of a work', 'N'),
(411, 'g', 'Miscellaneous information', 'N'),
(411, 'k', 'Form subheading', 'Y'),
(411, 'l', 'Language of a work', 'N'),
(411, 'n', 'Number of part/section/meeting', 'Y'),
(411, 'p', 'Name of part/section of a work', 'Y'),
(411, 'q', 'Name of meeting following jurisdiction name entry element', 'N'),
(411, 't', 'Title of a work', 'N'),
(411, 'u', 'Affiliation', 'N'),
(411, 'v', 'Volume number/sequential designation', 'N'),
(411, 'x', 'International Standard Serial Number', 'N'),
(411, '4', 'Relator code', 'Y'),
(411, '6', 'Linkage', 'N'),
(411, '8', 'Field link and sequence number', 'Y'),
(440, 'a', 'Title', 'N'),
(440, 'n', 'Number of part/section of a work', 'Y'),
(440, 'p', 'Name of part/section of a work', 'Y'),
(440, 'v', 'Volume number/sequential designation', 'N'),
(440, 'x', 'International Standard Serial Number', 'N'),
(440, '6', 'Linkage', 'N'),
(440, '8', 'Field link and sequence number', 'Y'),
(490, 'a', 'Series statement', 'Y'),
(490, 'l', 'Library of Congress call number', 'N'),
(490, 'v', 'Volume number/sequential designation', 'Y'),
(490, 'x', 'International Standard Serial Number', 'N'),
(490, '6', 'Linkage', 'N'),
(490, '8', 'Field link and sequence number', 'Y'),
(500, 'a', 'General note', 'N'),
(500, '3', 'Materials specified', 'N'),
(500, '5', 'Institution to which field applies', 'N'),
(500, '6', 'Linkage', 'N'),
(500, '8', 'Field link and sequence number', 'Y'),
(501, 'a', 'With note', 'N'),
(501, '5', 'Institution to which field applies', 'N'),
(501, '6', 'Linkage', 'N'),
(501, '8', 'Field link and sequence number', 'Y'),
(502, 'a', 'Dissertation note', 'N'),
(502, '6', 'Linkage', 'N'),
(502, '8', 'Field link and sequence number', 'Y'),
(504, 'a', 'Bibliography, etc. note', 'N'),
(504, 'b', 'Number of references', 'N'),
(504, '6', 'Linkage', 'N'),
(504, '8', 'Field link and sequence number', 'Y'),
(505, 'a', 'Formatted contents note', 'N'),
(505, 'g', 'Miscellaneous information', 'Y'),
(505, 'r', 'Statement of responsibility', 'Y'),
(505, 't', 'Title', 'Y'),
(505, 'u', 'Uniform Resource Identifier', 'Y'),
(505, '6', 'Linkage', 'N'),
(505, '8', 'Field link and sequence number', 'Y'),
(506, 'a', 'Terms governing access', 'N'),
(506, 'b', 'Jurisdiction', 'Y'),
(506, 'c', 'Physical access provisions', 'Y'),
(506, 'd', 'Authorized users', 'Y'),
(506, 'e', 'Authorization', 'Y'),
(506, '3', 'Materials specified', 'N'),
(506, '5', 'Institution to which field applies', 'N'),
(506, '6', 'Linkage', 'N'),
(506, '8', 'Field link and sequence number', 'Y'),
(507, 'a', 'Representative fraction of scale note', 'N'),
(507, 'b', 'Remainder of scale note', 'N'),
(507, '6', 'Linkage', 'N'),
(507, '8', 'Field link and sequence number', 'Y'),
(508, 'a', 'Creation/production credits note', 'N'),
(508, '6', 'Linkage', 'N'),
(508, '8', 'Field link and sequence number', 'Y'),
(510, 'a', 'Name of source', 'N'),
(510, 'b', 'Coverage of source', 'N'),
(510, 'c', 'Location within source', 'N'),
(510, 'x', 'International Standard Serial Number', 'N'),
(510, '3', 'Materials specified', 'N'),
(510, '6', 'Linkage', 'N'),
(510, '8', 'Field link and sequence number', 'Y'),
(511, 'a', 'Participant or performer note', 'N'),
(511, '6', 'Linkage', 'N'),
(511, '8', 'Field link and sequence number', 'Y'),
(513, 'a', 'Type of report', 'N'),
(513, 'b', 'Period covered', 'N'),
(513, '6', 'Linkage', 'N'),
(513, '8', 'Field link and sequence number', 'Y'),
(514, 'a', 'Attribute accuracy report', 'N'),
(514, 'b', 'Attribute accuracy value', 'Y'),
(514, 'c', 'Attribute accuracy explanation', 'Y'),
(514, 'd', 'Logical consistency report', 'Y'),
(514, 'e', 'Completeness report', 'N'),
(514, 'f', 'Horizontal position accuracy report', 'N'),
(514, 'g', 'Horizontal position accuracy value', 'Y'),
(514, 'h', 'Horizontal position accuracy explanation', 'Y'),
(514, 'i', 'Vertical positional accuracy report', 'N'),
(514, 'j', 'Vertical positional accuracy value', 'Y'),
(514, 'k', 'Vertical positional accuracy explanation', 'Y'),
(514, 'm', 'Cloud cover', 'N'),
(514, 'u', 'Uniform Resource Identifier', 'Y'),
(514, 'z', 'Display note', 'Y'),
(514, '6', 'Linkage', 'N'),
(514, '8', 'Field link and sequence number', 'Y'),
(515, 'a', 'Numbering peculiarities note', 'N'),
(515, '6', 'Linkage', 'N'),
(515, '8', 'Field link and sequence number', 'Y'),
(516, 'a', 'Type of computer file or data note', 'N'),
(516, '6', 'Linkage', 'N'),
(516, '8', 'Field link and sequence number', 'Y'),
(518, 'a', 'Date/time and place of an event note', 'N'),
(518, '3', 'Materials specified', 'N'),
(518, '6', 'Linkage', 'N'),
(518, '8', 'Field link and sequence number', 'Y'),
(520, 'a', 'Summary, etc. note', 'N'),
(520, 'b', 'Expansion of summary note', 'N'),
(520, 'u', 'Uniform Resource Identifier', 'Y'),
(520, '3', 'Materials specified', 'N'),
(520, '6', 'Linkage', 'N'),
(520, '8', 'Field link and sequence number', 'Y'),
(521, 'a', 'Target audience note', 'Y'),
(521, 'b', 'Source', 'N'),
(521, '3', 'Materials specified', 'N'),
(521, '6', 'Linkage', 'N'),
(521, '8', 'Field link and sequence number', 'Y'),
(522, 'a', 'Geographic coverage note', 'N'),
(522, '6', 'Linkage', 'N'),
(522, '8', 'Field link and sequence number', 'Y'),
(524, 'a', 'Preferred citation of described materials note', 'N'),
(524, '2', 'Source of schema used', 'N'),
(524, '3', 'Materials specified', 'N'),
(524, '6', 'Linkage', 'N'),
(524, '8', 'Field link and sequence number', 'Y'),
(525, 'a', 'Supplement note', 'N'),
(525, '6', 'Linkage', 'N'),
(525, '8', 'Field link and sequence number', 'Y'),
(526, 'a', 'Program name', 'N'),
(526, 'b', 'Interest level', 'N'),
(526, 'c', 'Reading level', 'N'),
(526, 'd', 'Title point value', 'N'),
(526, 'i', 'Display text', 'N'),
(526, 'x', 'Nonpublic note', 'Y'),
(526, 'z', 'Public note', 'Y'),
(526, '5', 'Institution to which field applies', 'N'),
(526, '6', 'Linkage', 'N'),
(526, '8', 'Field link and sequence number', 'Y'),
(530, 'a', 'Additional physical form available note', 'N'),
(530, 'b', 'Availability source', 'N'),
(530, 'c', 'Availability conditions', 'N'),
(530, 'd', 'Order number', 'N'),
(530, 'u', 'Uniform Resource Identifier', 'Y'),
(530, '3', 'Materials specified', 'N'),
(530, '6', 'Linkage', 'N'),
(530, '8', 'Field link and sequence number', 'Y'),
(533, 'a', 'Type of reproduction', 'N'),
(533, 'b', 'Place of reproduction', 'Y'),
(533, 'c', 'Agency responsible for reproduction', 'Y'),
(533, 'd', 'Date of reproduction', 'N'),
(533, 'e', 'Physical description of reproduction', 'N'),
(533, 'f', 'Series statement of reproduction', 'Y'),
(533, 'm', 'Dates and/or sequential designation of issues reproduced', 'Y'),
(533, 'n', 'Note about reproduction', 'Y'),
(533, '3', 'Materials specified', 'N'),
(533, '6', 'Linkage', 'N'),
(533, '7', 'Fixed-length data elements of reproduction', 'N'),
(533, '8', 'Field link and sequence number', 'Y'),
(534, 'a', 'Main entry of original', 'N'),
(534, 'b', 'Edition statement of original', 'N'),
(534, 'c', 'Publication, distribution, etc. of original', 'N'),
(534, 'e', 'Physical description, etc. of original', 'N'),
(534, 'f', 'Series statement of original', 'Y'),
(534, 'k', 'Key title of original', 'Y'),
(534, 'l', 'Location of original', 'N'),
(534, 'm', 'Material specific details', 'N'),
(534, 'n', 'Note about original', 'Y'),
(534, 'p', 'Introductory phrase', 'N'),
(534, 't', 'Title statement of original', 'N'),
(534, 'x', 'International Standard Serial Number', 'Y'),
(534, 'z', 'International Standard Book Number', 'Y'),
(534, '6', 'Linkage', 'N'),
(534, '8', 'Field link and sequence number', 'Y'),
(535, 'a', 'Custodian', 'N'),
(535, 'b', 'Postal address', 'Y'),
(535, 'c', 'Country', 'Y'),
(535, 'd', 'Telecommunications address', 'Y'),
(535, 'g', 'Repository location code', 'N'),
(535, '3', 'Materials specified', 'N'),
(535, '6', 'Linkage', 'N'),
(535, '8', 'Field link and sequence number', 'Y'),
(536, 'a', 'Text of note', 'N'),
(536, 'b', 'Contract number', 'Y'),
(536, 'c', 'Grant number', 'Y'),
(536, 'd', 'Undifferentiated number', 'Y'),
(536, 'e', 'Program element number', 'Y'),
(536, 'f', 'Project number', 'Y'),
(536, 'g', 'Task number', 'Y'),
(536, 'h', 'Work unit number', 'Y'),
(536, '6', 'Linkage', 'N'),
(536, '8', 'Field link and sequence number', 'Y'),
(538, 'a', 'System details note', 'N'),
(538, '6', 'Linkage', 'N'),
(538, '8', 'Field link and sequence number', 'Y'),
(540, 'a', 'Terms governing use and reproduction', 'N'),
(540, 'b', 'Jurisdiction', 'N'),
(540, 'c', 'Authorization', 'N'),
(540, 'd', 'Authorized users', 'N'),
(540, '3', 'Materials specified', 'N'),
(540, '5', 'Institution to which field applies', 'N'),
(540, '6', 'Linkage', 'N'),
(540, '8', 'Field link and sequence number', 'Y'),
(541, 'a', 'Source of acquisition', 'N'),
(541, 'b', 'Address', 'N'),
(541, 'c', 'Method of acquisition', 'N'),
(541, 'd', 'Date of acquisition', 'N'),
(541, 'e', 'Accession number', 'N'),
(541, 'f', 'Owner', 'N'),
(541, 'h', 'Purchase price', 'N'),
(541, 'n', 'Extent', 'Y'),
(541, 'o', 'Type of unit', 'Y'),
(541, '3', 'Materials specified', 'N'),
(541, '5', 'Institution to which field applies', 'N'),
(541, '6', 'Linkage', 'N'),
(541, '8', 'Field link and sequence number', 'Y'),
(544, 'a', 'Custodian', 'Y'),
(544, 'b', 'Address', 'Y'),
(544, 'c', 'Country', 'Y'),
(544, 'd', 'Title', 'Y'),
(544, 'e', 'Provenance', 'Y'),
(544, 'n', 'Note', 'Y'),
(544, '3', 'Materials specified', 'N'),
(544, '6', 'Linkage', 'N'),
(544, '8', 'Field link and sequence number', 'Y'),
(545, 'a', 'Biographical or historical note', 'N'),
(545, 'b', 'Expansion', 'N'),
(545, 'u', 'Uniform Resource Identifier', 'Y'),
(545, '6', 'Linkage', 'N'),
(545, '8', 'Field link and sequence number', 'Y'),
(546, 'a', 'Language note', 'N'),
(546, 'b', 'Information code or alphabet', 'Y'),
(546, '3', 'Materials specified', 'N'),
(546, '6', 'Linkage', 'N'),
(546, '8', 'Field link and sequence number', 'Y'),
(547, 'a', 'Former title complexity note', 'N'),
(547, '6', 'Linkage', 'N'),
(547, '8', 'Field link and sequence number', 'Y'),
(550, 'a', 'Issuing body note', 'N'),
(550, '6', 'Linkage', 'N'),
(550, '8', 'Field link and sequence number', 'Y'),
(552, 'a', 'Entity type label', 'N'),
(552, 'b', 'Entity type definition and source', 'N'),
(552, 'c', 'Attribute label', 'N'),
(552, 'd', 'Attribute definition and source', 'N'),
(552, 'e', 'Enumerated domain value', 'Y'),
(552, 'f', 'Enumerated domain value definition and source', 'Y'),
(552, 'g', 'Range domain minimum and maximum', 'N'),
(552, 'h', 'Codeset name and source', 'N'),
(552, 'i', 'Unrepresentable domain', 'N'),
(552, 'j', 'Attribute units of measurement and resolution', 'N'),
(552, 'k', 'Beginning date and ending date of attribute values', 'N'),
(552, 'l', 'Attribute value accuracy', 'N'),
(552, 'm', 'Attribute value accuracy explanation', 'N'),
(552, 'n', 'Attribute measurement frequency', 'N'),
(552, 'o', 'Entity and attribute overview', 'Y'),
(552, 'p', 'Entity and attribute detail citation', 'Y'),
(552, 'u', 'Uniform Resource Identifier', 'Y'),
(552, 'z', 'Display note', 'Y'),
(552, '6', 'Linkage', 'N'),
(552, '8', 'Field link and sequence number', 'Y'),
(555, 'a', 'Cumulative index/finding aids note', 'N'),
(555, 'b', 'Availability source', 'Y'),
(555, 'c', 'Degree of control', 'N'),
(555, 'd', 'Bibliographic reference', 'N'),
(555, 'u', 'Uniform Resource Identifier', 'Y'),
(555, '3', 'Materials specified', 'N'),
(555, '6', 'Linkage', 'N'),
(555, '8', 'Field link and sequence number', 'Y'),
(556, 'a', 'Information about documentation note', 'N'),
(556, 'z', 'International Standard Book Number', 'Y'),
(556, '6', 'Linkage', 'N'),
(556, '8', 'Field link and sequence number', 'Y'),
(561, 'a', 'History', 'N'),
(561, '3', 'Materials specified', 'N'),
(561, '5', 'Institution to which field applies', 'N'),
(561, '6', 'Linkage', 'N'),
(561, '8', 'Field link and sequence number', 'Y'),
(562, 'a', 'Identifying markings', 'Y'),
(562, 'b', 'Copy identification', 'Y'),
(562, 'c', 'Version identification', 'Y'),
(562, 'd', 'Presentation format', 'Y'),
(562, 'e', 'Number of copies', 'Y'),
(562, '3', 'Materials specified', 'N'),
(562, '5', 'Institution to which field applies', 'N'),
(562, '6', 'Linkage', 'N'),
(562, '8', 'Field link and sequence number', 'Y'),
(565, 'a', 'Number of cases/variables', 'N'),
(565, 'b', 'Name of variable', 'Y'),
(565, 'c', 'Unit of analysis', 'Y'),
(565, 'd', 'Universe of data', 'Y'),
(565, 'e', 'Filing scheme or code', 'Y'),
(565, '3', 'Materials specified', 'N'),
(565, '6', 'Linkage', 'N'),
(565, '8', 'Field link and sequence number', 'Y'),
(567, 'a', 'Methodology note', 'N'),
(567, '6', 'Linkage', 'N'),
(567, '8', 'Field link and sequence number', 'Y'),
(580, 'a', 'Linking entry complexity note', 'N'),
(580, '6', 'Linkage', 'N'),
(580, '8', 'Field link and sequence number', 'Y'),
(581, 'a', 'Publications about described materials note', 'N'),
(581, 'z', 'International Standard Book Number', 'Y'),
(581, '3', 'Materials specified', 'N'),
(581, '6', 'Linkage', 'N'),
(581, '8', 'Field link and sequence number', 'Y'),
(583, 'a', 'Action', 'N'),
(583, 'b', 'Action identification', 'Y'),
(583, 'c', 'Time/date of action', 'Y'),
(583, 'd', 'Action interval', 'Y'),
(583, 'e', 'Contingency for action', 'Y'),
(583, 'f', 'Authorization', 'Y'),
(583, 'h', 'Jurisdiction', 'Y'),
(583, 'i', 'Method of action', 'Y'),
(583, 'j', 'Site of action', 'Y'),
(583, 'k', 'Action agent', 'Y'),
(583, 'l', 'Status', 'Y'),
(583, 'n', 'Extent', 'Y'),
(583, 'o', 'Type of unit', 'Y'),
(583, 'u', 'Uniform Resource Identifier', 'Y'),
(583, 'x', 'Nonpublic note', 'Y'),
(583, 'z', 'Public note', 'Y'),
(583, '2', 'Source of term', 'N'),
(583, '3', 'Materials specified', 'N'),
(583, '5', 'Institution to which field applies', 'N'),
(583, '6', 'Linkage', 'N'),
(583, '8', 'Field link and sequence number', 'Y'),
(584, 'a', 'Accumulation', 'Y'),
(584, 'b', 'Frequency of use', 'Y'),
(584, '3', 'Materials specified', 'N'),
(584, '5', 'Institution to which field applies', 'N'),
(584, '6', 'Linkage', 'N'),
(584, '8', 'Field link and sequence number', 'Y'),
(585, 'a', 'Exhibitions note', 'N'),
(585, '3', 'Materials specified', 'N'),
(585, '5', 'Institution to which field applies', 'N'),
(585, '6', 'Linkage', 'N'),
(585, '8', 'Field link and sequence number', 'Y'),
(586, 'a', 'Awards note', 'N'),
(586, '3', 'Materials specified', 'N'),
(586, '6', 'Linkage', 'N'),
(586, '8', 'Field link and sequence number', 'Y'),
(600, 'a', 'Personal name', 'N'),
(600, 'b', 'Numeration', 'N'),
(600, 'c', 'Titles and other words associated with a name', 'Y'),
(600, 'd', 'Dates associated with a name', 'N'),
(600, 'e', 'Relator term', 'Y'),
(600, 'f', 'Date of a work', 'N'),
(600, 'g', 'Miscellaneous information', 'N'),
(600, 'h', 'Medium', 'N'),
(600, 'k', 'Form subheading', 'Y'),
(600, 'j', 'Attribution qualifier', 'Y'),
(600, 'l', 'Language of a work', 'N'),
(600, 'm', 'Medium of performance for music', 'Y'),
(600, 'n', 'Number of part/section of a work', 'Y'),
(600, 'o', 'Arranged statement for music', 'N'),
(600, 'p', 'Name of part/section of a work', 'Y'),
(600, 'q', 'Fuller form of name', 'N'),
(600, 'r', 'Key for music', 'N'),
(600, 's', 'Version', 'N'),
(600, 't', 'Title of a work', 'N'),
(600, 'u', 'Affiliation', 'N'),
(600, 'v', 'Form subdivision', 'Y'),
(600, 'x', 'General subdivision', 'Y'),
(600, 'y', 'Chronological subdivision', 'Y'),
(600, 'z', 'Geographic subdivision', 'Y'),
(600, '2', 'Source of heading or term', 'N'),
(600, '3', 'Materials specified', 'N'),
(600, '4', 'Relator code', 'Y'),
(600, '6', 'Linkage', 'N'),
(600, '8', 'Field link and sequence number', 'Y'),
(610, 'a', 'Corporate name or jurisdiction name as entry element', 'N'),
(610, 'b', 'Subordinate unit', 'Y'),
(610, 'c', 'Location of meeting', 'N'),
(610, 'd', 'Date of meeting or treaty signing', 'Y'),
(610, 'e', 'Relator term', 'Y'),
(610, 'f', 'Date of a work', 'N'),
(610, 'g', 'Miscellaneous information', 'N'),
(610, 'h', 'Medium', 'N'),
(610, 'k', 'Form subheading', 'Y'),
(610, 'l', 'Language of a work', 'N'),
(610, 'm', 'Medium of performance for music', 'Y'),
(610, 'n', 'Number of part/section/meeting', 'Y'),
(610, 'o', 'Arranged statement for music', 'N'),
(610, 'p', 'Name of part/section of a work', 'Y'),
(610, 'r', 'Key for music', 'N'),
(610, 's', 'Version', 'N'),
(610, 't', 'Title of a work', 'N'),
(610, 'u', 'Affiliation', 'N'),
(610, 'v', 'Form subdivision', 'Y'),
(610, 'x', 'General subdivision', 'Y'),
(610, 'y', 'Chronological subdivision', 'Y'),
(610, 'z', 'Geographic subdivision', 'Y'),
(610, '2', 'Source of heading or term', 'N'),
(610, '3', 'Materials specified', 'N'),
(610, '4', 'Relator code', 'Y'),
(610, '6', 'Linkage', 'N'),
(610, '8', 'Field link and sequence number', 'Y'),
(611, 'a', 'Meeting name or jurisdiction name as entry element', 'N'),
(611, 'c', 'Location of meeting', 'N'),
(611, 'd', 'Date of meeting', 'N'),
(611, 'e', 'Subordinate unit', 'Y'),
(611, 'f', 'Date of a work', 'N'),
(611, 'g', 'Miscellaneous information', 'N'),
(611, 'h', 'Medium', 'N'),
(611, 'k', 'Form subheading', 'Y'),
(611, 'l', 'Language of a work', 'N'),
(611, 'n', 'Number of part/section/meeting', 'Y'),
(611, 'p', 'Name of part/section of a work', 'Y'),
(611, 'q', 'Name of meeting following jurisdiction name entry element', 'N'),
(611, 's', 'Version', 'N'),
(611, 't', 'Title of a work', 'N'),
(611, 'u', 'Affiliation', 'N'),
(611, 'v', 'Form subdivision', 'Y'),
(611, 'x', 'General subdivision', 'Y'),
(611, 'y', 'Chronological subdivision', 'Y'),
(611, 'z', 'Geographic subdivision', 'Y'),
(611, '2', 'Source of heading or term', 'N'),
(611, '3', 'Materials specified', 'N'),
(611, '4', 'Relator code', 'Y'),
(611, '6', 'Linkage', 'N'),
(611, '8', 'Field link and sequence number', 'Y'),
(630, 'a', 'Uniform title', 'N'),
(630, 'd', 'Date of treaty signing', 'Y'),
(630, 'f', 'Date of a work', 'N'),
(630, 'g', 'Miscellaneous information', 'N'),
(630, 'h', 'Medium', 'N'),
(630, 'k', 'Form subheading', 'Y'),
(630, 'l', 'Language of a work', 'N'),
(630, 'm', 'Medium of performance for music', 'Y'),
(630, 'n', 'Number of part/section of a work', 'Y'),
(630, 'o', 'Arranged statement for music', 'N'),
(630, 'p', 'Name of part/section of a work', 'Y'),
(630, 'r', 'Key for music', 'N'),
(630, 's', 'Version', 'N'),
(630, 't', 'Title of a work', 'N'),
(630, 'v', 'Form subdivision', 'Y'),
(630, 'x', 'General subdivision', 'Y'),
(630, 'y', 'Chronological subdivision', 'Y'),
(630, 'z', 'Geographic subdivision', 'Y'),
(630, '2', 'Source of heading or term', 'N'),
(630, '3', 'Materials specified', 'N'),
(630, '6', 'Linkage', 'N'),
(630, '8', 'Field link and sequence number', 'Y'),
(650, 'a', 'Topical term or geographic name as entry element', 'N'),
(650, 'b', 'Topical term following geographic name as entry element', 'N'),
(650, 'c', 'Location of event', 'N'),
(650, 'd', 'Active dates', 'N'),
(650, 'e', 'Relator term', 'N'),
(650, 'v', 'Form subdivision', 'Y'),
(650, 'x', 'General subdivision', 'Y'),
(650, 'y', 'Chronological subdivision', 'Y'),
(650, 'z', 'Geographic subdivision', 'Y'),
(650, '2', 'Source of heading or term', 'N'),
(650, '3', 'Materials specified', 'N'),
(650, '6', 'Linkage', 'N'),
(650, '8', 'Field link and sequence number', 'Y'),
(651, 'a', 'Geographic name', 'N'),
(651, 'v', 'Form subdivision', 'Y'),
(651, 'x', 'General subdivision', 'Y'),
(651, 'y', 'Chronological subdivision', 'Y'),
(651, 'z', 'Geographic subdivision', 'Y'),
(651, '2', 'Source of heading or term', 'N'),
(651, '3', 'Materials specified', 'N'),
(651, '6', 'Linkage', 'N'),
(651, '8', 'Field link and sequence number', 'Y'),
(653, 'a', 'Uncontrolled term', 'Y'),
(653, '6', 'Linkage', 'N'),
(653, '8', 'Field link and sequence number', 'Y'),
(654, 'a', 'Focus term', 'N'),
(654, 'b', 'Non-focus term', 'Y'),
(654, 'c', 'Facet/hierarchy designation', 'Y'),
(654, 'v', 'Form subdivision', 'Y'),
(654, 'y', 'Chronological subdivision', 'Y'),
(654, 'z', 'Geographic subdivision', 'Y'),
(654, '2', 'Source of heading or term', 'N'),
(654, '3', 'Materials specified', 'N'),
(654, '6', 'Linkage', 'N'),
(654, '8', 'Field link and sequence number', 'Y'),
(655, 'a', 'Genre/form data or focus term', 'N'),
(655, 'b', 'Non-focus term', 'Y'),
(655, 'c', 'Facet/hierarchy designation', 'Y'),
(655, 'v', 'Form subdivision', 'Y'),
(655, 'x', 'General subdivision', 'Y'),
(655, 'y', 'Chronological subdivision', 'Y'),
(655, 'z', 'Geographic subdivision', 'Y'),
(655, '2', 'Source of term', 'N'),
(655, '3', 'Materials specified', 'N'),
(655, '5', 'Institution to which field applies', 'N'),
(655, '6', 'Linkage', 'N'),
(655, '8', 'Field link and sequence number', 'Y'),
(656, 'a', 'Occupation', 'N'),
(656, 'k', 'Form', 'N'),
(656, 'v', 'Form subdivision', 'Y'),
(656, 'x', 'General subdivision', 'Y'),
(656, 'y', 'Chronological subdivision', 'Y'),
(656, 'z', 'Geographic subdivision', 'Y'),
(656, '2', 'Source of term', 'N'),
(656, '3', 'Materials specified', 'N'),
(656, '6', 'Linkage', 'N'),
(656, '8', 'Field link and sequence number', 'Y'),
(657, 'a', 'Function', 'N'),
(657, 'v', 'Form subdivision', 'Y'),
(657, 'x', 'General subdivision', 'Y'),
(657, 'y', 'Chronological subdivision', 'Y'),
(657, 'z', 'Geographic subdivision', 'Y'),
(657, '2', 'Source of term', 'N'),
(657, '3', 'Materials specified', 'N'),
(657, '6', 'Linkage', 'N'),
(657, '8', 'Field link and sequence number', 'Y'),
(658, 'a', 'Main curriculum objective', 'N'),
(658, 'b', 'Subordinate curriculum objective', 'Y'),
(658, 'c', 'Curriculum code', 'N'),
(658, 'd', 'Correlation factor', 'N'),
(658, '2', 'Source of term or code', 'N'),
(658, '6', 'Linkage', 'N'),
(658, '8', 'Field link and sequence number', 'Y'),
(700, 'a', 'Personal name', 'N'),
(700, 'b', 'Numeration', 'N'),
(700, 'c', 'Titles and other words associated with a name', 'Y'),
(700, 'd', 'Dates associated with a name', 'N'),
(700, 'e', 'Relator term', 'Y'),
(700, 'f', 'Date of a work', 'N'),
(700, 'g', 'Miscellaneous information', 'N'),
(700, 'h', 'Medium', 'N'),
(700, 'j', 'Attribution qualifier', 'Y'),
(700, 'k', 'Form subheading', 'Y'),
(700, 'l', 'Language of a work', 'N'),
(700, 'm', 'Medium of performance for music', 'Y'),
(700, 'n', 'Number of part/section of a work', 'Y'),
(700, 'o', 'Arranged statement for music', 'N'),
(700, 'p', 'Name of part/section of a work', 'Y'),
(700, 'q', 'Fuller form of name', 'N'),
(700, 'r', 'Key for music', 'N'),
(700, 's', 'Version', 'N'),
(700, 't', 'Title of a work', 'N'),
(700, 'u', 'Affiliation', 'N'),
(700, 'x', 'International Standard Serial Number', 'N'),
(700, '3', 'Materials specified', 'N'),
(700, '4', 'Relator code', 'Y'),
(700, '5', 'Institution to which field applies', 'N'),
(700, '6', 'Linkage', 'N'),
(700, '8', 'Field link and sequence number', 'Y'),
(710, 'a', 'Corporate name or jurisdiction name as entry element', 'N'),
(710, 'b', 'Subordinate unit', 'Y'),
(710, 'c', 'Location of meeting', 'N'),
(710, 'd', 'Date of meeting or treaty signing', 'Y'),
(710, 'e', 'Relator term', 'Y'),
(710, 'f', 'Date of a work', 'N'),
(710, 'g', 'Miscellaneous information', 'N'),
(710, 'h', 'Medium', 'N'),
(710, 'k', 'Form subheading', 'Y'),
(710, 'l', 'Language of a work', 'N'),
(710, 'm', 'Medium of performance for music', 'Y'),
(710, 'n', 'Number of part/section/meeting', 'Y'),
(710, 'o', 'Arranged statement for music', 'N'),
(710, 'p', 'Name of part/section of a work', 'Y'),
(710, 'r', 'Key for music', 'N'),
(710, 's', 'Version', 'N'),
(710, 't', 'Title of a work', 'N'),
(710, 'u', 'Affiliation', 'N'),
(710, 'x', 'International Standard Serial Number', 'N'),
(710, '3', 'Materials specified', 'N'),
(710, '4', 'Relator code', 'Y'),
(710, '5', 'Institution to which field applies', 'N'),
(710, '6', 'Linkage', 'N'),
(710, '8', 'Field link and sequence number', 'Y'),
(711, 'a', 'Meeting name or jurisdiction name as entry element', 'N'),
(711, 'c', 'Location of meeting', 'N'),
(711, 'd', 'Date of meeting', 'N'),
(711, 'e', 'Subordinate unit', 'Y'),
(711, 'f', 'Date of a work', 'N'),
(711, 'g', 'Miscellaneous information', 'N'),
(711, 'h', 'Medium', 'N'),
(711, 'k', 'Form subheading', 'Y'),
(711, 'l', 'Language of a work', 'N'),
(711, 'n', 'Number of part/section/meeting', 'Y'),
(711, 'p', 'Name of part/section of a work', 'Y'),
(711, 'q', 'Name of meeting following jurisdiction name entry element', 'N'),
(711, 's', 'Version', 'N'),
(711, 't', 'Title of a work', 'N'),
(711, 'u', 'Affiliation', 'N'),
(711, 'x', 'International Standard Serial Number', 'N'),
(711, '3', 'Materials specified', 'N'),
(711, '4', 'Relator code', 'Y'),
(711, '5', 'Institution to which field applies', 'N'),
(711, '6', 'Linkage', 'N'),
(711, '8', 'Field link and sequence number', 'Y'),
(720, 'a', 'Name', 'N'),
(720, 'e', 'Relator term', 'Y'),
(720, '4', 'Relator code', 'Y'),
(720, '6', 'Linkage', 'N'),
(720, '8', 'Field link and sequence number', 'Y'),
(730, 'a', 'Uniform title', 'N'),
(730, 'd', 'Date of treaty signing', 'Y'),
(730, 'f', 'Date of a work', 'N'),
(730, 'g', 'Miscellaneous information', 'N'),
(730, 'h', 'Medium', 'N'),
(730, 'k', 'Form subheading', 'Y'),
(730, 'l', 'Language of a work', 'N'),
(730, 'm', 'Medium of performance for music', 'Y'),
(730, 'n', 'Number of part/section of a work', 'Y'),
(730, 'o', 'Arranged statement for music', 'N'),
(730, 'p', 'Name of part/section of a work', 'Y'),
(730, 'r', 'Key for music', 'N'),
(730, 's', 'Version', 'N'),
(730, 't', 'Title of a work', 'N'),
(730, 'x', 'International Standard Serial Number', 'N'),
(730, '3', 'Materials specified', 'N'),
(730, '5', 'Institution to which field applies', 'N'),
(730, '6', 'Linkage', 'N'),
(730, '8', 'Field link and sequence number', 'Y'),
(740, 'a', 'Uncontrolled related/analytical title', 'N'),
(740, 'h', 'Medium', 'N'),
(740, 'n', 'Number of part/section of a work', 'Y'),
(740, 'p', 'Name of part/section of a work', 'Y'),
(740, '5', 'Institution to which field applies', 'N'),
(740, '6', 'Linkage', 'N'),
(740, '8', 'Field link and sequence number', 'Y'),
(752, 'a', 'Country', 'N'),
(752, 'b', 'State, province, territory', 'N'),
(752, 'c', 'County, region, islands area', 'N'),
(752, 'd', 'City', 'N'),
(752, '6', 'Linkage', 'N'),
(752, '8', 'Field link and sequence number', 'Y'),
(753, 'a', 'Make and model of machine', 'N'),
(753, 'b', 'Programming language', 'N'),
(753, 'c', 'Operating system', 'N'),
(753, '6', 'Linkage', 'N'),
(753, '8', 'Field link and sequence number', 'Y'),
(754, 'a', 'Taxonomic name', 'Y'),
(754, 'c', 'Taxonomic category', 'Y'),
(754, 'd', 'Common or alternative name', 'Y'),
(754, 'x', 'Non-public note', 'Y'),
(754, 'z', 'Public note', 'Y'),
(754, '2', 'Source of taxonomic identification', 'N'),
(754, '6', 'Linkage', 'N'),
(754, '8', 'Field link and sequence number', 'Y'),
(760, 'a', 'Main entry heading', 'N'),
(760, 'b', 'Edition', 'N'),
(760, 'c', 'Qualifying information', 'N'),
(760, 'd', 'Place, publisher, and date of publication', 'N'),
(760, 'g', 'Relationship information', 'Y'),
(760, 'h', 'Physical description', 'N'),
(760, 'i', 'Display text', 'N'),
(760, 'm', 'Material-specific details', 'N'),
(760, 'n', 'Note', 'Y'),
(760, 'o', 'Other item identifier', 'Y'),
(760, 's', 'Uniform title', 'N'),
(760, 't', 'Title', 'N'),
(760, 'w', 'Record control number', 'Y'),
(760, 'x', 'International Standard Serial Number', 'N'),
(760, 'y', 'CODEN designation', 'N'),
(760, '6', 'Linkage', 'N'),
(760, '7', 'Control subfield', 'N'),
(760, '8', 'Field link and sequence number', 'Y'),
(762, 'a', 'Main entry heading', 'N'),
(762, 'b', 'Edition', 'N'),
(762, 'c', 'Qualifying information', 'N'),
(762, 'd', 'Place, publisher, and date of publication', 'N'),
(762, 'g', 'Relationship information', 'Y'),
(762, 'h', 'Physical description', 'N'),
(762, 'i', 'Display text', 'N'),
(762, 'm', 'Material-specific details', 'N'),
(762, 'n', 'Note', 'Y'),
(762, 'o', 'Other item identifier', 'Y'),
(762, 's', 'Uniform title', 'N'),
(762, 't', 'Title', 'N'),
(762, 'w', 'Record control number', 'Y'),
(762, 'x', 'International Standard Serial Number', 'N'),
(762, 'y', 'CODEN designation', 'N'),
(762, '6', 'Linkage', 'N'),
(762, '7', 'Control subfield', 'N'),
(762, '8', 'Field link and sequence number', 'Y'),
(765, 'a', 'Main entry heading', 'N'),
(765, 'b', 'Edition', 'N'),
(765, 'c', 'Qualifying information', 'N'),
(765, 'd', 'Place, publisher, and date of publication', 'N'),
(765, 'g', 'Relationship information', 'Y'),
(765, 'h', 'Physical description', 'N'),
(765, 'i', 'Display text', 'N');
INSERT INTO `usmarc_subfield_dm` VALUES
(765, 'k', 'Series data for related item', 'Y'),
(765, 'm', 'Material-specific details', 'N'),
(765, 'n', 'Note', 'Y'),
(765, 'o', 'Other item identifier', 'Y'),
(765, 'r', 'Report number', 'Y'),
(765, 's', 'Uniform title', 'N'),
(765, 't', 'Title', 'N'),
(765, 'u', 'Standard Technical Report Number', 'N'),
(765, 'w', 'Record control number', 'Y'),
(765, 'x', 'International Standard Serial Number', 'N'),
(765, 'y', 'CODEN designation', 'N'),
(765, 'z', 'International Standard Book Number', 'Y'),
(765, '6', 'Linkage', 'N'),
(765, '7', 'Control subfield', 'N'),
(765, '8', 'Field link and sequence number', 'Y'),
(767, 'a', 'Main entry heading', 'N'),
(767, 'b', 'Edition', 'N'),
(767, 'c', 'Qualifying information', 'N'),
(767, 'd', 'Place, publisher, and date of publication', 'N'),
(767, 'g', 'Relationship information', 'Y'),
(767, 'h', 'Physical description', 'N'),
(767, 'i', 'Display text', 'N'),
(767, 'k', 'Series data for related item', 'Y'),
(767, 'm', 'Material-specific details', 'N'),
(767, 'n', 'Note', 'Y'),
(767, 'o', 'Other item identifier', 'Y'),
(767, 'r', 'Report number', 'Y'),
(767, 's', 'Uniform title', 'N'),
(767, 't', 'Title', 'N'),
(767, 'u', 'Standard Technical Report Number', 'N'),
(767, 'w', 'Record control number', 'Y'),
(767, 'x', 'International Standard Serial Number', 'N'),
(767, 'y', 'CODEN designation', 'N'),
(767, 'z', 'International Standard Book Number', 'Y'),
(767, '6', 'Linkage', 'N'),
(767, '7', 'Control subfield', 'N'),
(767, '8', 'Field link and sequence number', 'Y'),
(770, 'a', 'Main entry heading', 'N'),
(770, 'b', 'Edition', 'N'),
(770, 'c', 'Qualifying information', 'N'),
(770, 'd', 'Place, publisher, and date of publication', 'N'),
(770, 'g', 'Relationship information', 'Y'),
(770, 'h', 'Physical description', 'N'),
(770, 'i', 'Display text', 'N'),
(770, 'k', 'Series data for related item', 'Y'),
(770, 'm', 'Material-specific details', 'N'),
(770, 'n', 'Note', 'Y'),
(770, 'o', 'Other item identifier', 'Y'),
(770, 'r', 'Report number', 'Y'),
(770, 's', 'Uniform title', 'N'),
(770, 't', 'Title', 'N'),
(770, 'u', 'Standard Technical Report Number', 'N'),
(770, 'w', 'Record control number', 'Y'),
(770, 'x', 'International Standard Serial Number', 'N'),
(770, 'y', 'CODEN designation', 'N'),
(770, 'z', 'International Standard Book Number', 'Y'),
(770, '6', 'Linkage', 'N'),
(770, '7', 'Control subfield', 'N'),
(770, '8', 'Field link and sequence number', 'Y'),
(772, 'a', 'Main entry heading', 'N'),
(772, 'b', 'Edition', 'N'),
(772, 'c', 'Qualifying information', 'N'),
(772, 'd', 'Place, publisher, and date of publication', 'N'),
(772, 'g', 'Relationship information', 'Y'),
(772, 'h', 'Physical description', 'N'),
(772, 'i', 'Display text', 'N'),
(772, 'k', 'Series data for related item', 'Y'),
(772, 'm', 'Material-specific details', 'N'),
(772, 'n', 'Note', 'Y'),
(772, 'o', 'Other item identifier', 'Y'),
(772, 'r', 'Report number', 'Y'),
(772, 's', 'Uniform title', 'N'),
(772, 't', 'Title', 'N'),
(772, 'u', 'Standard Technical Report Number', 'N'),
(772, 'w', 'Record control number', 'Y'),
(772, 'x', 'International Standard Serial Number', 'N'),
(772, 'y', 'CODEN designation', 'N'),
(772, 'z', 'International Stan dard Book Number', 'Y'),
(772, '6', 'Linkage', 'N'),
(772, '7', 'Control subfield', 'N'),
(772, '8', 'Field link and sequence number', 'Y'),
(773, 'a', 'Main entry heading', 'N'),
(773, 'b', 'Edition', 'N'),
(773, 'd', 'Place, publisher, and date of publication', 'N'),
(773, 'g', 'Relationship information', 'Y'),
(773, 'h', 'Physical description', 'N'),
(773, 'i', 'Display text', 'N'),
(773, 'k', 'Series data for related item', 'Y'),
(773, 'm', 'Material-specific details', 'N'),
(773, 'n', 'Note', 'Y'),
(773, 'o', 'Other item identifier', 'Y'),
(773, 'p', 'Abbreviated title', 'N'),
(773, 'r', 'Report number', 'Y'),
(773, 's', 'Uniform title', 'N'),
(773, 't', 'Title', 'N'),
(773, 'u', 'Standard Technical Report Number', 'N'),
(773, 'w', 'Record control number', 'Y'),
(773, 'x', 'International Standard Serial Number', 'N'),
(773, 'y', 'CODEN designation', 'N'),
(773, 'z', 'International Standard Book Number', 'Y'),
(773, '3', 'Materials specified', 'N'),
(773, '6', 'Linkage', 'N'),
(773, '7', 'Control subfield', 'N'),
(773, '8', 'Field link and sequence number', 'Y'),
(774, 'a', 'Main entry heading', 'N'),
(774, 'b', 'Edition', 'N'),
(774, 'c', 'Qualifying information', 'N'),
(774, 'd', 'Place, publisher, and date of publication', 'N'),
(774, 'g', 'Relationship information', 'Y'),
(774, 'h', 'Physical description', 'N'),
(774, 'i', 'Display text', 'N'),
(774, 'k', 'Series data for related item', 'Y'),
(774, 'm', 'Material-specific details', 'N'),
(774, 'n', 'Note', 'Y'),
(774, 'o', 'Other item identifier', 'Y'),
(774, 'r', 'Report number', 'Y'),
(774, 's', 'Uniform title', 'N'),
(774, 't', 'Title', 'N'),
(774, 'u', 'Standard Technical Report Number', 'N'),
(774, 'w', 'Record control number', 'Y'),
(774, 'x', 'International Standard Serial Number', 'N'),
(774, 'y', 'CODEN designation', 'N'),
(774, 'z', 'International Standard Book Number', 'Y'),
(774, '6', 'Linkage', 'N'),
(774, '7', 'Control subfield', 'N'),
(774, '8', 'Field link and sequence number', 'Y'),
(775, 'a', 'Main entry heading', 'N'),
(775, 'b', 'Edition', 'N'),
(775, 'c', 'Qualifying information', 'N'),
(775, 'd', 'Place, publisher, and date of publication', 'N'),
(775, 'e', 'Language code', 'N'),
(775, 'f', 'Country code', 'N'),
(775, 'g', 'Relationship information', 'Y'),
(775, 'h', 'Physical description', 'N'),
(775, 'i', 'Display text', 'N'),
(775, 'k', 'Series data for related item', 'Y'),
(775, 'm', 'Material-specific details', 'N'),
(775, 'n', 'Note', 'Y'),
(775, 'o', 'Other item identifier', 'Y'),
(775, 'r', 'Report number', 'Y'),
(775, 's', 'Uniform title', 'N'),
(775, 't', 'Title', 'N'),
(775, 'u', 'Standard Technical Report Number', 'N'),
(775, 'w', 'Record control number', 'Y'),
(775, 'x', 'International Standard Serial Number', 'N'),
(775, 'y', 'CODEN designation', 'N'),
(775, 'z', 'International Standard Book Number', 'Y'),
(775, '6', 'Linkage', 'N'),
(775, '7', 'Control subfield', 'N'),
(775, '8', 'Field link and sequence number', 'Y'),
(776, 'a', 'Main entry heading', 'N'),
(776, 'b', 'Edition', 'N'),
(776, 'c', 'Qualifying information', 'N'),
(776, 'd', 'Place, publisher, and date of publication', 'N'),
(776, 'g', 'Relationship information', 'Y'),
(776, 'h', 'Physical description', 'N'),
(776, 'i', 'Display text', 'N'),
(776, 'k', 'Series data for related item', 'Y'),
(776, 'm', 'Material-specific details', 'N'),
(776, 'n', 'Note', 'Y'),
(776, 'o', 'Other item identifier', 'Y'),
(776, 'r', 'Report number', 'Y'),
(776, 's', 'Uniform title', 'N'),
(776, 't', 'Title', 'N'),
(776, 'u', 'Standard Technical Report Number', 'N'),
(776, 'w', 'Record control number', 'Y'),
(776, 'x', 'International Standard Serial Number', 'N'),
(776, 'y', 'CODEN designation', 'N'),
(776, 'z', 'International Standard Book Number', 'Y'),
(776, '6', 'Linkage', 'N'),
(776, '7', 'Control subfield', 'N'),
(776, '8', 'Field link and sequence number', 'Y'),
(777, 'a', 'Main entry heading', 'N'),
(777, 'b', 'Edition', 'N'),
(777, 'c', 'Qualifying information', 'N'),
(777, 'd', 'Place, publisher, and date of publication', 'N'),
(777, 'g', 'Relationship information', 'Y'),
(777, 'h', 'Physical description', 'N'),
(777, 'i', 'Display text', 'N'),
(777, 'k', 'Series data for related item', 'Y'),
(777, 'm', 'Material-specific details', 'N'),
(777, 'n', 'Note', 'Y'),
(777, 'o', 'Other item identifier', 'Y'),
(777, 's', 'Uniform title', 'N'),
(777, 't', 'Title', 'N'),
(777, 'w', 'Record control number', 'Y'),
(777, 'x', 'International Standard Serial Number', 'N'),
(777, 'y', 'CODEN designation', 'N'),
(777, '6', 'Linkage', 'N'),
(777, '7', 'Control subfield', 'N'),
(777, '8', 'Field link and sequence number', 'Y'),
(780, 'a', 'Main entry heading', 'N'),
(780, 'b', 'Edition', 'N'),
(780, 'c', 'Qualifying information', 'N'),
(780, 'd', 'Place, publisher, and date of publication', 'N'),
(780, 'g', 'Relationship information', 'Y'),
(780, 'h', 'Physical description', 'N'),
(780, 'i', 'Display text', 'N'),
(780, 'k', 'Series data for related item', 'Y'),
(780, 'm', 'Material-specific details', 'N'),
(780, 'n', 'Note', 'Y'),
(780, 'o', 'Other item identifier', 'Y'),
(780, 'r', 'Report number', 'Y'),
(780, 's', 'Uniform title', 'N'),
(780, 't', 'Title', 'N'),
(780, 'u', 'Standard Technical Report Number', 'N'),
(780, 'w', 'Record control number', 'Y'),
(780, 'x', 'International Standard Serial Number', 'N'),
(780, 'y', 'CODEN designation', 'N'),
(780, 'z', 'International Standard Book Number', 'Y'),
(780, '6', 'Linkage', 'N'),
(780, '7', 'Control subfield', 'N'),
(780, '8', 'Field link and sequence number', 'Y'),
(785, 'a', 'Main entry heading', 'N'),
(785, 'b', 'Edition', 'N'),
(785, 'c', 'Qualifying information', 'N'),
(785, 'd', 'Place, publisher, and date of publication', 'N'),
(785, 'g', 'Relationship information', 'Y'),
(785, 'h', 'Physical description', 'N'),
(785, 'i', 'Display text', 'N'),
(785, 'k', 'Series data for related item', 'Y'),
(785, 'm', 'Material-specific details', 'N'),
(785, 'n', 'Note', 'Y'),
(785, 'o', 'Other item identifier', 'Y'),
(785, 'r', 'Report number', 'Y'),
(785, 's', 'Uniform title', 'N'),
(785, 't', 'Title', 'N'),
(785, 'u', 'Standa rd Technical Report Number', 'N'),
(785, 'w', 'Record control number', 'Y'),
(785, 'x', 'International Standard Serial Number', 'N'),
(785, 'y', 'CODEN designation', 'N'),
(785, 'z', 'International Standard Book Number', 'Y'),
(785, '6', 'Linkage', 'N'),
(785, '7', 'Control subfield', 'N'),
(785, '8', 'Field link and sequence number', 'Y'),
(786, 'a', 'Main entry heading', 'N'),
(786, 'b', 'Edition', 'N'),
(786, 'c', 'Qualifying information', 'N'),
(786, 'd', 'Place, publisher, and date of publication', 'N'),
(786, 'g', 'Relationship information', 'Y'),
(786, 'h', 'Physical description', 'N'),
(786, 'i', 'Display text', 'N'),
(786, 'j', 'Period of content', 'N'),
(786, 'k', 'Series data for related item', 'Y'),
(786, 'm', 'Material-specific details', 'N'),
(786, 'n', 'Note', 'Y'),
(786, 'o', 'Other item identifier', 'Y'),
(786, 'p', 'Abbreviated title', 'N'),
(786, 'r', 'Report number', 'Y'),
(786, 's', 'Uniform title', 'N'),
(786, 't', 'Title', 'N'),
(786, 'u', 'Standard Technical Report Number', 'N'),
(786, 'v', 'Source Contribution', 'N'),
(786, 'w', 'Record control number', 'Y'),
(786, 'x', 'International Standard Serial Number', 'N'),
(786, 'y', 'CODEN designation', 'N'),
(786, 'z', 'International Standard Book Number', 'Y'),
(786, '6', 'Linkage', 'N'),
(786, '7', 'Control subfield', 'N'),
(786, '8', 'Field link and sequence number', 'Y'),
(787, 'a', 'Main entry heading', 'N'),
(787, 'b', 'Edition', 'N'),
(787, 'c', 'Qualifying information', 'N'),
(787, 'd', 'Place, publisher, and date of publication', 'N'),
(787, 'g', 'Relationship information', 'Y'),
(787, 'h', 'Physical description', 'N'),
(787, 'i', 'Display text', 'N'),
(787, 'k', 'Series data for related item', 'Y'),
(787, 'm', 'Material-specific details', 'N'),
(787, 'n', 'Note', 'Y'),
(787, 'o', 'Other item identifier', 'Y'),
(787, 'r', 'Report number', 'Y'),
(787, 's', 'Uniform title', 'N'),
(787, 't', 'Title', 'N'),
(787, 'u', 'Standard Technical Report Number', 'N'),
(787, 'w', 'Record control number', 'Y'),
(787, 'x', 'International Standard Serial Number', 'N'),
(787, 'y', 'CODEN designation', 'N'),
(787, 'z', 'International Standard Book Number', 'Y'),
(787, '6', 'Linkage', 'N'),
(787, '7', 'Control subfield', 'N'),
(787, '8', 'Field link and sequence number', 'Y'),
(800, 'a', 'Personal name', 'N'),
(800, 'b', 'Numeration', 'N'),
(800, 'c', 'Titles and other words associated with a name', 'Y'),
(800, 'd', 'Dates associated with a name', 'N'),
(800, 'e', 'Relator term', 'Y'),
(800, 'f', 'Date of a work', 'N'),
(800, 'g', 'Miscellaneous information', 'N'),
(800, 'h', 'Medium', 'N'),
(800, 'j', 'Attribution qualifier', 'Y'),
(800, 'k', 'Form subheading', 'Y'),
(800, 'l', 'Language of a work', 'N'),
(800, 'm', 'Medium of performance for music', 'Y'),
(800, 'n', 'Number of part/section of a work', 'Y'),
(800, 'o', 'Arranged statement for music', 'N'),
(800, 'p', 'Name of part/section of a work', 'Y'),
(800, 'q', 'Fuller form of name', 'N'),
(800, 'r', 'Key for music', 'N'),
(800, 's', 'Version', 'N'),
(800, 't', 'Title of a work', 'N'),
(800, 'u', 'Affiliation', 'N'),
(800, 'v', 'Volume/sequential designation', 'N'),
(800, '4', 'Relator code', 'Y'),
(800, '6', 'Linkage', 'N'),
(800, '8', 'Field link and sequence number', 'Y'),
(810, 'a', 'Corporate name or jurisdiction name as entry element', 'N'),
(810, 'b', 'Subordinate unit', 'Y'),
(810, 'c', 'Location of meeting', 'N'),
(810, 'd', 'Date of meeting or treaty signing', 'Y'),
(810, 'e', 'Relator term', 'Y'),
(810, 'f', 'Date of a work', 'N'),
(810, 'g', 'Miscellaneous information', 'N'),
(810, 'h', 'Medium', 'N'),
(810, 'k', 'Form subheading', 'Y'),
(810, 'l', 'Language of a work', 'N'),
(810, 'm', 'Medium of performance for music', 'Y'),
(810, 'n', 'Number of part/section/meeting', 'Y'),
(810, 'o', 'Arranged statement for music', 'N'),
(810, 'p', 'Name of part/section of a work', 'Y'),
(810, 'r', 'Key for music', 'N'),
(810, 's', 'Version', 'N'),
(810, 't', 'Title of a work', 'N'),
(810, 'u', 'Affiliation', 'N'),
(810, 'v', 'Volume/sequential designation', 'N'),
(810, '4', 'Relator code', 'Y'),
(810, '6', 'Linkage', 'N'),
(810, '8', 'Field link and sequence number', 'Y'),
(811, 'a', 'Meeting name or jurisdiction name as entry element', 'N'),
(811, 'c', 'Location of meeting', 'N'),
(811, 'd', 'Date of meeting', 'N'),
(811, 'e', 'Subordinate unit', 'Y'),
(811, 'f', 'Date of a work', 'N'),
(811, 'g', 'Miscellaneous information', 'N'),
(811, 'h', 'Medium', 'N'),
(811, 'k', 'Form subheading', 'Y'),
(811, 'l', 'Language of a work', 'N'),
(811, 'n', 'Number of part/section/meeting', 'Y'),
(811, 'p', 'Name of part/section of a work', 'Y'),
(811, 'q', 'Name of meeting following jurisdiction name entry element', 'N'),
(811, 's', 'Version', 'N'),
(811, 't', 'Title of a work', 'N'),
(811, 'u', 'Affiliation', 'N'),
(811, 'v', 'Volume/sequential designation', 'N'),
(811, '4', 'Relator code', 'Y'),
(811, '6', 'Linkage', 'N'),
(811, '8', 'Field link and sequence number', 'Y'),
(830, 'a', 'Uniform title', 'N'),
(830, 'd', 'Date of treaty signing', 'Y'),
(830, 'f', 'Date of a work', 'N'),
(830, 'g', 'Miscellaneous information', 'N'),
(830, 'h', 'Medium', 'N'),
(830, 'k', 'Form subheading', 'Y'),
(830, 'l', 'Language of a work', 'N'),
(830, 'm', 'Medium of performance for music', 'Y'),
(830, 'n', 'Number of part/section of a work', 'Y'),
(830, 'o', 'Arranged statement for music', 'N'),
(830, 'p', 'Name of part/section of a work', 'Y'),
(830, 'r', 'Key for music', 'N'),
(830, 's', 'Version', 'N'),
(830, 't', 'Title of a work', 'N'),
(830, 'v', 'Volume/sequential designation', 'N'),
(830, '6', 'Linkage', 'N'),
(830, '8', 'Field link and sequence number', 'Y'),
(850, 'a', 'Holding institution', 'Y'),
(850, '8', 'Field link and sequence number', 'Y'),
(852, 'a', 'Location', 'N'),
(852, 'b', 'Sublocation or collection', 'Y'),
(852, 'c', 'Shelving location', 'Y'),
(852, 'e', 'Address', 'Y'),
(852, 'f', 'Coded location qualifier', 'Y'),
(852, 'g', 'Non-coded location qualifier', 'Y'),
(852, 'h', 'Classification part', 'N'),
(852, 'i', 'Item part', 'Y'),
(852, 'j', 'Shelving control number', 'N'),
(852, 'k', 'Call number prefix', 'N'),
(852, 'l', 'Shelving form of title', 'N'),
(852, 'm', 'Call number suffix', 'N'),
(852, 'n', 'Country code', 'N'),
(852, 'p', 'Piece designation', 'N'),
(852, 'q', 'Piece physical condition', 'N'),
(852, 's', 'Copyright article-fee code', 'Y'),
(852, 't', 'Copy number', 'N'),
(852, 'x', 'Nonpublic note', 'Y'),
(852, 'z', 'Public note', 'Y'),
(852, '2', 'Source of classification or shelving scheme', 'N'),
(852, '3', 'Materials specified', 'N'),
(852, '6', 'Linkage', 'N'),
(852, '8', 'Sequence number', 'N'),
(856, 'a', 'Host name', 'Y'),
(856, 'b', 'Access number', 'Y'),
(856, 'c', 'Compression information', 'Y'),
(856, 'd', 'Path', 'Y'),
(856, 'f', 'Electronic name', 'Y'),
(856, 'h', 'Processor of request', 'N'),
(856, 'i', 'Instruction', 'Y'),
(856, 'j', 'Bits per second', 'N'),
(856, 'k', 'Password', 'N'),
(856, 'l', 'Logon', 'N'),
(856, 'm', 'Contact for access assistance', 'Y'),
(856, 'n', 'Name of location of host', 'N'),
(856, 'o', 'Operating system', 'N'),
(856, 'p', 'Port', 'N'),
(856, 'q', 'Electronic format type', 'N'),
(856, 'r', 'Settings', 'N'),
(856, 's', 'File size', 'Y'),
(856, 't', 'Terminal emulation', 'Y'),
(856, 'u', 'Uniform Resource Identifier', 'Y'),
(856, 'v', 'Hours access method available', 'Y'),
(856, 'w', 'Record control number', 'Y'),
(856, 'x', 'Nonpublic note', 'Y'),
(856, 'y', 'Link text', 'Y'),
(856, 'z', 'Public note', 'Y'),
(856, '2', 'Access method', 'N'),
(856, '3', 'Materials specified', 'N'),
(856, '6', 'Linkage', 'N'),
(856, '8', 'Field link and sequence number', 'Y'),
(880, '6', 'Linkage', 'N'),
(886, 'a', 'Tag of the foreign MARC field', 'N'),
(886, 'b', 'Content of the foreign MARC field', 'N'),
(886, '2', 'Source of data', 'N'),
(887, 'a', 'Content of non-MARC field', 'N'),
(887, '2', 'Source of data', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `usmarc_tag_dm`
--

CREATE TABLE `usmarc_tag_dm` (
  `block_nmbr` tinyint(4) NOT NULL,
  `tag` smallint(6) NOT NULL,
  `description` varchar(80) NOT NULL,
  `ind1_description` varchar(80) NOT NULL,
  `ind2_description` varchar(80) NOT NULL,
  `repeatable_flg` char(1) NOT NULL,
  PRIMARY KEY (`block_nmbr`,`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `usmarc_tag_dm`
--

INSERT INTO `usmarc_tag_dm` VALUES
(0, 10, 'Library of congress control number', 'Undefined', 'Undefined', 'N'),
(0, 13, 'Patent control information', 'Undefined', 'Undefined', 'Y'),
(0, 15, 'National bibliography number', 'Undefined', 'Undefined', 'Y'),
(0, 16, 'National bibliographic agency control number', 'National bibliographic agency', 'Undefined', 'Y'),
(0, 17, 'Copyright or legal deposit number', 'Undefined', 'Undefined', 'Y'),
(0, 18, 'Copyright article-fee code', 'Undefined', 'Undefined', 'N'),
(0, 20, 'International standard book number', 'Undefined', 'Undefined', 'Y'),
(0, 22, 'International standard serial number', 'Level of international interest', 'Undefined', 'Y'),
(0, 24, 'Other standard identifier', 'Type of standard number or code', 'Difference indicator', 'Y'),
(0, 25, 'Overseas acquisition number', 'Undefined', 'Undefined', 'Y'),
(0, 27, 'Standard technical report number', 'Undefined', 'Undefined', 'Y'),
(0, 28, 'Publisher number', 'Type of publisher number', 'Note/added entry controller', 'Y'),
(0, 30, 'Coden designation', 'Undefined', 'Undefined', 'Y'),
(0, 32, 'Postal registration number', 'Undefined', 'Undefined', 'Y'),
(0, 33, 'Date/time and place of an event', 'Type of date in subfield $a', 'Type of event', 'Y'),
(0, 34, 'Coded cartographic mathematical data', 'Type of scale', 'Type of ring', 'Y'),
(0, 35, 'System control number', 'Undefined', 'Undefined', 'Y'),
(0, 36, 'Original study number for computer data files', 'Undefined', 'Undefined', 'N'),
(0, 37, 'Source of acquisition', 'Undefined', 'Undefined', 'Y'),
(0, 40, 'Cataloging source', 'Undefined', 'Undefined', 'N'),
(0, 41, 'Language code', 'Translation indication', 'Source of code', 'Y'),
(0, 42, 'Authentication code', 'Undefined', 'Undefined', 'N'),
(0, 43, 'Geographic area code', 'Undefined', 'Undefined', 'N'),
(0, 44, 'Country of publishing/producing entity code', 'Undefined', 'Undefined', 'N'),
(0, 45, 'Time period of content', 'Type of time period in subfield $b or $c', 'Undefined', 'N'),
(0, 46, 'Special coded dates', 'Undefined', 'Undefined', 'N'),
(0, 47, 'Form of musical composition code', 'Undefined', 'Undefined', 'N'),
(0, 48, 'Number of musical instruments or voices code', 'Undefined', 'Undefined', 'Y'),
(0, 50, 'Library of congress call number', 'Existence in LC collection', 'Source of call number', 'Y'),
(0, 51, 'Library of congress copy, issue, offprint statement', 'Undefined', 'Undefined', 'Y'),
(0, 52, 'Geographic classification', 'Code source', 'Undefined', 'Y'),
(0, 55, 'Classification numbers assigned in canada', 'Existence in NLC collection', 'Type, completeness, source of class/call number', 'Y'),
(0, 60, 'National library of medicine call number', 'Existence in NLM collection', 'Source of call number', 'Y'),
(0, 61, 'National library of medicine copy statement', 'Undefined', 'Undefined', 'Y'),
(0, 66, 'Character sets present', 'Undefined', 'Undefined', 'N'),
(0, 70, 'National agricultural library call number', 'Existence in NAL collection', 'Undefined', 'Y'),
(0, 71, 'National agricultural library copy statement', 'Undefined', 'Undefined', 'Y'),
(0, 72, 'Subject category code', 'Undefined', 'Code source', 'Y'),
(0, 74, 'Gpo item number', 'Undefined', 'Undefined', 'Y'),
(0, 80, 'Universal decimal classification number', 'Undefined', 'Undefined', 'Y'),
(0, 82, 'Dewey decimal classification number', 'Type of edition', 'Source of classification number', 'Y'),
(0, 84, 'Other classification number', 'Undefined', 'Undefined', 'Y'),
(0, 86, 'Government document classification number', 'Number source', 'Undefined', 'Y'),
(0, 88, 'Report number', 'Undefined', 'Undefined', 'Y'),
(1, 100, 'Main entry--personal name', 'Type of personal name entry element', 'Undefined', 'N'),
(1, 110, 'Main entry--corporate name', 'Type of corporate name entry element', 'Undefined', 'N'),
(1, 111, 'Main entry--meeting name', 'Type of meeting name entry element', 'Undefined', 'N'),
(1, 130, 'Main entry--uniform title', 'Nonfiling characters', 'Undefined', 'N'),
(2, 210, 'Abbreviated title', 'Title added entry', 'Type', 'Y'),
(2, 222, 'Key title', 'Specifies whether variant title and/or added entry is required', 'Nonfiling characters', 'Y'),
(2, 240, 'Uniform title', 'Uniform title printed or displayed', 'Nonfiling characters', 'N'),
(2, 242, 'Translation of title by cataloging agency', 'Title added entry', 'Nonfiling characters', 'Y'),
(2, 243, 'Collective uniform title', 'Uniform title printed or displayed', 'Nonfiling characters', 'N'),
(2, 245, 'Title statement', 'Title added entry', 'Nonfiling characters', 'N'),
(2, 246, 'Varying form of title', 'Note/added entry controller', 'Type of title', 'Y'),
(2, 247, 'Former title or title variations', 'Title added entry', 'Note controller', 'Y'),
(2, 250, 'Edition statement', 'Undefined', 'Undefined', 'N'),
(2, 254, 'Musical presentation statement', 'Undefined', 'Undefined', 'N'),
(2, 255, 'Cartographic mathematical data', 'Undefined', 'Undefined', 'Y'),
(2, 256, 'Computer file characteristics', 'Undefined', 'Undefined', 'N'),
(2, 257, 'Country of producing entity for archival films', 'Undefined', 'Undefined', 'N'),
(2, 260, 'Publication, distribution, etc. (imprint)', 'Sequence of publishing statements', 'Undefined', 'Y'),
(2, 261, 'Imprint statement for films (pre-aacr 1 revised)  [local]', 'Undefined', 'Undefined', 'N'),
(2, 262, 'Imprint statement for sound recordings (pre-aacr 2)  [local]', 'Undefined', 'Undefined', 'N'),
(2, 263, 'Projected publication date', 'Undefined', 'Undefined', 'N'),
(2, 270, 'Address', 'Level', 'Type of address', 'Y'),
(3, 300, 'Physical description', 'Undefined', 'Undefined', 'Y'),
(3, 306, 'Playing time', 'Undefined', 'Undefined', 'N'),
(3, 307, 'Hours, etc.', 'Display constant controller', 'Undefined', 'Y'),
(3, 310, 'Current publication frequency', 'Undefined', 'Undefined', 'N'),
(3, 340, 'Physical medium', 'Undefined', 'Undefined', 'Y'),
(3, 342, 'Geospatial reference data', 'Geospatial reference dimension', 'Geospatial reference method', 'Y'),
(3, 343, 'Planar coordinate data', 'Undefined', 'Undefined', 'Y'),
(3, 351, 'Organization and arrangement of materials', 'Undefined', 'Undefined', 'Y'),
(3, 352, 'Digital graphic representation', 'Undefined', 'Undefined', 'Y'),
(3, 355, 'Security classification control', 'Controlled element', 'Undefined', 'Y'),
(3, 362, 'Dates of publication and/or sequential designation', 'Format of date', 'Undefined', 'Y'),
(4, 400, 'Series statement/added entry--personal name   [us-local]', 'Type of personal name entry element', 'Pronoun represents main entry', 'Y'),
(4, 410, 'Series statement/added entry--corporate name  [us-local]', 'Type of corporate name entry element', 'Pronoun represents main entry', 'Y'),
(4, 411, 'Series statement/added entry--meeting name  [us-local]', 'Type of meeting name entry element', 'Pronoun represents main entry', 'Y'),
(4, 440, 'Series statement/added entry--title', 'Undefined', 'Nonfiling characters', 'Y'),
(4, 490, 'Series statement', 'Specifies whether series is traced', 'Undefined', 'Y'),
(5, 500, 'General note', 'Undefined', 'Undefined', 'Y'),
(5, 501, 'With note', 'Undefined', 'Undefined', 'Y'),
(5, 502, 'Dissertation note', 'Undefined', 'Undefined', 'Y'),
(5, 504, 'Bibliography, etc. note', 'Undefined', 'Undefined', 'Y'),
(5, 505, 'Formatted contents note', 'Display constant controller', 'Level of content designation', 'Y'),
(5, 506, 'Restrictions on access note', 'Undefined', 'Undefined', 'Y'),
(5, 507, 'Scale note for graphic material', 'Undefined', 'Undefined', 'N'),
(5, 508, 'Creation/production credits note', 'Undefined', 'Undefined', 'Y'),
(5, 510, 'Citation/references note', 'Coverage/location in source', 'Undefined', 'Y'),
(5, 511, 'Participant or performer note', 'Display constant controller', 'Undefined', 'Y'),
(5, 513, 'Type of report and period covered note', 'Undefined', 'Undefined', 'Y'),
(5, 514, 'Data quality note', 'Undefined', 'Undefined', 'N'),
(5, 515, 'Numbering peculiarities note', 'Undefined', 'Undefined', 'Y'),
(5, 516, 'Type of computer file or data note', 'Display constant controller', 'Undefined', 'Y'),
(5, 518, 'Date/time and place of an event note', 'Undefined', 'Undefined', 'Y'),
(5, 520, 'Summary, etc.', 'Display constant controller', 'Undefined', 'Y'),
(5, 521, 'Target audience note', 'Display constant controller', 'Undefined', 'Y'),
(5, 522, 'Geographic coverage note', 'Display constant controller', 'Undefined', 'Y'),
(5, 524, 'Preferred citation of described materials note', 'Display constant controller', 'Undefined', 'Y'),
(5, 525, 'Supplement note', 'Undefined', 'Undefined', 'Y'),
(5, 526, 'Study program information note', 'Display constant controller', 'Undefined', 'Y'),
(5, 530, 'Additional physical form available note', 'Undefined', 'Undefined', 'Y'),
(5, 533, 'Reproduction note', 'Undefined', 'Undefined', 'Y'),
(5, 534, 'Original version note', 'Undefined', 'Undefined', 'Y'),
(5, 535, 'Location of originals/duplicates note', 'Additional information about custodian', 'Undefined', 'Y'),
(5, 536, 'Funding information note', 'Undefined', 'Undefined', 'Y'),
(5, 538, 'System details note', 'Undefined', 'Undefined', 'Y'),
(5, 540, 'Terms governing use and reproduction note', 'Undefined', 'Undefined', 'Y'),
(5, 541, 'Immediate source of acquisition note', 'Undefined', 'Undefined', 'Y'),
(5, 544, 'Location of other archival materials note', 'Relationship', 'Undefined', 'Y'),
(5, 545, 'Biographical or historical data', 'Type of data', 'Undefined', 'Y'),
(5, 546, 'Language note', 'Undefined', 'Undefined', 'Y'),
(5, 547, 'Former title complexity note', 'Undefined', 'Undefined', 'Y'),
(5, 550, 'Issuing body note', 'Undefined', 'Undefined', 'Y'),
(5, 552, 'Entity and attribute information note', 'Undefined', 'Undefined', 'Y'),
(5, 555, 'Cumulative index/finding aids note', 'Display constant controller', 'Undefined', 'Y'),
(5, 556, 'Information about documentation note', 'Display constant controller', 'Undefined', 'Y'),
(5, 561, 'Ownership and custodial history', 'Undefined', 'Undefined', 'Y'),
(5, 562, 'Copy and version identification note', 'Undefined', 'Undefined', 'Y'),
(5, 565, 'Case file characteristics note', 'Display constant controller', 'Undefined', 'Y'),
(5, 567, 'Methodology note', 'Display constant controller', 'Undefined', 'Y'),
(5, 580, 'Linking entry complexity note', 'Undefined', 'Undefined', 'Y'),
(5, 581, 'Publications about described materials note', 'Display constant controller', 'Undefined', 'Y'),
(5, 583, 'Action note', 'Undefined', 'Undefined', 'Y'),
(5, 584, 'Accumulation and frequency of use note', 'Undefined', 'Undefined', 'Y'),
(5, 585, 'Exhibitions note', 'Undefined', 'Undefined', 'Y'),
(5, 586, 'Awards note', 'Display constant controller', 'Undefined', 'Y'),
(6, 600, 'Subject added entry--personal name', 'Type of personal name entry element', 'Thesaurus', 'Y'),
(6, 610, 'Subject added entry--corporate name', 'Type of corporate name entry element', 'Thesaurus', 'Y'),
(6, 611, 'Subject added entry--meeting name', 'Type of meeting name entry element', 'Thesaurus', 'Y'),
(6, 630, 'Subject added entry--uniform title', 'Nonfiling characters', 'Thesaurus', 'Y'),
(6, 650, 'Subject added entry--topical term', 'Level of subject', 'Thesaurus', 'Y'),
(6, 651, 'Subject added entry--geographic name', 'Undefined', 'Thesaurus', 'Y'),
(6, 653, 'Index term--uncontrolled', 'Level of index term', 'Undefined', 'Y'),
(6, 654, 'Subject added entry--faceted topical terms', 'Level of subject', 'Undefined', 'Y'),
(6, 655, 'Index term--genre/form', 'Type of heading', 'Source of term', 'Y'),
(6, 656, 'Index term--occupation', 'Undefined', 'Source of term', 'Y'),
(6, 657, 'Index term--function', 'Undefined', 'Source of term', 'Y'),
(6, 658, 'Index term--curriculum objective', 'Undefined', 'Undefined', 'Y'),
(7, 700, 'Added entry--personal name', 'Type of personal name entry element', 'Type of added entry', 'Y'),
(7, 710, 'Added entry--corporate name', 'Type of corporate name entry element', 'Type of added entry', 'Y'),
(7, 711, 'Added entry--meeting name', 'Type of meeting name entry element', 'Type of added entry', 'Y'),
(7, 720, 'Added entry--uncontrolled name', 'Type of name', 'Undefined', 'Y'),
(7, 730, 'Added entry--uniform title', 'Nonfiling characters', 'Type of added entry', 'Y'),
(7, 740, 'Added entry--uncontrolled related/analytical title', 'Nonfiling characters', 'Type of added entry', 'Y'),
(7, 752, 'Added entry--hierarchical place name', 'Undefined', 'Undefined', 'Y'),
(7, 753, 'System details access to computer files', 'Undefined', 'Undefined', 'Y'),
(7, 754, 'Added entry--taxonomic identification', 'Undefined', 'Undefined', 'Y'),
(7, 760, 'Main series entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 762, 'Subseries entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 765, 'Original language entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 767, 'Translation entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 770, 'Supplement/special issue entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 772, 'Supplement parent entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 773, 'Host item entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 774, 'Constituent unit entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 775, 'Other edition entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 776, 'Additional physical form entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 777, 'Issued with entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 780, 'Preceding entry', 'Note controller', 'Type of relationship', 'Y'),
(7, 785, 'Succeeding entry', 'Note controller', 'Type of relationship', 'Y'),
(7, 786, 'Data source entry', 'Note controller', 'Display constant controller', 'Y'),
(7, 787, 'Nonspecific relationship entry', 'Note controller', 'Display constant controller', 'Y'),
(8, 800, 'Series added entry--personal name', 'Type of personal name entry element', 'Undefined', 'Y'),
(8, 810, 'Series added entry--corporate name', 'Type of corporate name entry element', 'Undefined', 'Y'),
(8, 811, 'Series added entry--meeting name', 'Type of meeting name entry element', 'Undefined', 'Y'),
(8, 830, 'Series added entry--uniform title', 'Undefined', 'Nonfiling characters', 'Y'),
(8, 850, 'Holding institution', 'Undefined', 'Undefined', 'Y'),
(8, 852, 'Location', 'Shelving scheme', 'Shelving order', 'Y'),
(8, 856, 'Electronic location and access', 'Access method', 'Relationship', 'Y'),
(8, 880, 'Alternate graphic representation', 'Same as associated field', 'Same as associated field', 'Y'),
(8, 886, 'Foreign marc information field', 'Type of field', 'Undefined', 'Y'),
(8, 887, 'Non-marc information field', 'Undefined', 'Undefined', 'Y');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
