
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `beatz20`
--

-- --------------------------------------------------------

--
-- Table structure for table `activity`
--

CREATE TABLE `activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(45) DEFAULT NULL,
  `module` varchar(100) DEFAULT '',
  `object_model` varchar(100) DEFAULT '',
  `object_id` varchar(100) DEFAULT '',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `activity`
--

INSERT INTO `activity` VALUES
(1, 'ActivitySpaceCreated', '', '', '', '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `comment`
--

CREATE TABLE `comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text,
  `object_model` varchar(100) NOT NULL,
  `object_id` int(11) NOT NULL,
  `space_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content`
--

CREATE TABLE `content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) NOT NULL,
  `object_model` varchar(100) NOT NULL,
  `object_id` int(11) NOT NULL,
  `visibility` tinyint(4) DEFAULT NULL,
  `sticked` tinyint(4) DEFAULT NULL,
  `archived` tinytext,
  `space_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_object_model` (`object_model`,`object_id`),
  UNIQUE KEY `index_guid` (`guid`),
  KEY `index_space_id` (`space_id`),
  KEY `index_user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `content`
--

INSERT INTO `content` VALUES
(1, 'd4e99160-f895-44b6-8a48-0ccab595facf', 'Activity', 1, 1, 0, '0', 1, 1, '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `file`
--

CREATE TABLE `file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) DEFAULT NULL,
  `object_model` varchar(100) DEFAULT '',
  `object_id` varchar(100) DEFAULT '',
  `file_name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `mime_type` varchar(150) DEFAULT NULL,
  `size` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_object` (`object_model`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group`
--

CREATE TABLE `group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `space_id` int(10) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `description` text,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `ldap_dn` varchar(255) DEFAULT NULL,
  `can_create_public_spaces` int(1) DEFAULT '1',
  `can_create_private_spaces` int(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `group`
--

INSERT INTO `group` VALUES
(1, NULL, 'Artist', 'Artist can upload the music', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1, 1),
(2, NULL, 'Listener', 'Listening the music', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `group_admin`
--

CREATE TABLE `group_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_admin` (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `like`
--

CREATE TABLE `like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `target_user_id` int(11) DEFAULT NULL,
  `object_model` varchar(100) NOT NULL,
  `object_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_object` (`object_model`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `logging`
--

CREATE TABLE `logging` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(128) DEFAULT NULL,
  `category` varchar(128) DEFAULT NULL,
  `logtime` int(11) DEFAULT NULL,
  `message` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `logging`
--
-- --------------------------------------------------------

--
-- Table structure for table `migration`
--

CREATE TABLE `migration` (
  `version` varchar(255) NOT NULL,
  `apply_time` int(11) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `migration`
--

INSERT INTO `migration` VALUES
('m000000_000000_base_activity', [[timestamp]], 'activity'),
('m000000_000000_base_admin', [[timestamp]], 'admin'),
('m000000_000000_base_comment', [[timestamp]], 'comment'),
('m000000_000000_base_core', [[timestamp]], 'core'),
('m000000_000000_base_file', [[timestamp]], 'file'),
('m000000_000000_base_like', [[timestamp]], 'like'),
('m000000_000000_base_notification', [[timestamp]], 'notification'),
('m000000_000000_base_post', [[timestamp]], 'post'),
('m000000_000000_base_space', [[timestamp]], 'space'),
('m000000_000000_base_user', [[timestamp]], 'user'),
('m000000_000000_base_wall', [[timestamp]], 'wall'),
('m131023_164513_initial', [[timestamp]], 'user'),
('m131023_165411_initial', [[timestamp]], 'space'),
('m131023_165625_initial', [[timestamp]], 'wall'),
('m131023_165755_initial', [[timestamp]], 'core'),
('m131023_165835_initial', [[timestamp]], 'post'),
('m131023_170033_initial', [[timestamp]], 'notification'),
('m131023_170135_initial', [[timestamp]], 'like'),
('m131023_170159_initial', [[timestamp]], 'file'),
('m131023_170253_initial', [[timestamp]], 'comment'),
('m131023_170339_initial', [[timestamp]], 'activity'),
('m131203_110444_oembed', [[timestamp]], 'core'),
('m131213_165552_user_optimize', [[timestamp]], 'user'),
('m140226_111945_ldap', [[timestamp]], 'core'),
('m140303_125031_password', [[timestamp]], 'user'),
('m140304_142711_memberautoadd', [[timestamp]], 'space'),
('m140321_000917_content', [[timestamp]], 'core'),
('m140324_170617_membership', [[timestamp]], 'space'),
('m140507_150421_create_settings_table', [[timestamp]], 'user'),
('m140507_171527_create_settings_table', [[timestamp]], 'space'),
('m140512_141414_i18n_profilefields', [[timestamp]], 'user'),
('m140513_180317_createlogging', [[timestamp]], 'admin'),
('m140701_000611_profile_genderfield', [[timestamp]], 'user'),
('m140701_074404_protect_default_profilefields', [[timestamp]], 'user'),
('m140702_143912_notify_notification_unify', [[timestamp]], 'wall'),
('m140703_104527_profile_birthdayfield', [[timestamp]], 'user'),
('m140704_080659_installationid', [[timestamp]], 'admin'),
('m140705_065525_emailing_settings', [[timestamp]], 'user'),
('m140706_135210_lastlogin', [[timestamp]], 'user'),
('m140829_122906_delete', [[timestamp]], 'user'),
('m140830_145504_following', [[timestamp]], 'core'),
('m140901_080147_indizies', [[timestamp]], 'like'),
('m140901_080432_indices', [[timestamp]], 'file'),
('m140901_112246_addState', [[timestamp]], 'space'),
('m140901_153403_addState', [[timestamp]], 'user'),
('m140901_170329_group_create_space', [[timestamp]], 'user'),
('m140902_091234_session_key_length', [[timestamp]], 'user'),
('m140907_140822_zip_field_to_text', [[timestamp]], 'user'),
('m140930_205511_fix_default', [[timestamp]], 'activity'),
('m140930_205859_fix_default', [[timestamp]], 'like'),
('m140930_210142_fix_default', [[timestamp]], 'file'),
('m140930_210635_fix_default', [[timestamp]], 'user'),
('m140930_212528_fix_default', [[timestamp]], 'notification'),
('m141015_173305_follow_notifications', [[timestamp]], 'core'),
('m141019_093319_mentioning', [[timestamp]], 'user'),
('m141020_162639_fix_default', [[timestamp]], 'core'),
('m141020_193920_rm_alsocreated', [[timestamp]], 'comment'),
('m141020_193931_rm_alsoliked', [[timestamp]], 'like'),
('m141021_162639_oembed_setting', [[timestamp]], 'core'),
('m141022_094635_addDefaults', [[timestamp]], 'space'),
('m141031_140056_cleanup_profiles', [[timestamp]], 'user');

-- --------------------------------------------------------

--
-- Table structure for table `module_enabled`
--

CREATE TABLE `module_enabled` (
  `module_id` varchar(100) NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `notification`
--

CREATE TABLE `notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `seen` tinyint(4) DEFAULT NULL,
  `source_object_model` varchar(100) DEFAULT NULL,
  `source_object_id` int(11) DEFAULT NULL,
  `target_object_model` varchar(100) DEFAULT NULL,
  `target_object_id` int(11) DEFAULT NULL,
  `space_id` int(11) DEFAULT NULL,
  `emailed` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `post`
--

CREATE TABLE `post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_2trash` text,
  `message` text,
  `url` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `profile`
--

CREATE TABLE `profile` (
  `user_id` int(11) NOT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `birthday_hide_year` int(1) DEFAULT NULL,
  `birthday` datetime DEFAULT NULL,
  `about` text,
  `phone_private` varchar(255) DEFAULT NULL,
  `phone_work` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `im_skype` varchar(255) DEFAULT NULL,
  `im_msn` varchar(255) DEFAULT NULL,
  `im_icq` int(11) DEFAULT NULL,
  `im_xmpp` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `url_facebook` varchar(255) DEFAULT NULL,
  `url_linkedin` varchar(255) DEFAULT NULL,
  `url_xing` varchar(255) DEFAULT NULL,
  `url_youtube` varchar(255) DEFAULT NULL,
  `url_vimeo` varchar(255) DEFAULT NULL,
  `url_flickr` varchar(255) DEFAULT NULL,
  `url_myspace` varchar(255) DEFAULT NULL,
  `url_googleplus` varchar(255) DEFAULT NULL,
  `url_twitter` varchar(255) DEFAULT NULL,
  `wordpress_blog_link` varchar(255) DEFAULT NULL,
  `featured_user` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `profile`
--

INSERT INTO `profile` VALUES
(1, '[[admin_fname]]', '[[admin_lname]]', 'System Administration', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `profile_field`
--

CREATE TABLE `profile_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_field_category_id` int(11) NOT NULL,
  `module_id` varchar(255) DEFAULT NULL,
  `field_type_class` varchar(255) NOT NULL,
  `field_type_config` text,
  `internal_name` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `required` tinyint(4) DEFAULT NULL,
  `show_at_registration` tinyint(4) DEFAULT NULL,
  `editable` tinyint(4) NOT NULL DEFAULT '1',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `ldap_attribute` varchar(255) DEFAULT NULL,
  `translation_category` varchar(255) DEFAULT NULL,
  `is_system` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_profile_field_category` (`profile_field_category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=32 ;

--
-- Dumping data for table `profile_field`
--

INSERT INTO `profile_field` VALUES
(1, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":20,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'firstname', 'Firstname', NULL, 100, 1, 1, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, 'givenName', NULL, 1),
(2, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":30,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'lastname', 'Lastname', NULL, 200, 1, 1, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, 'sn', NULL, 1),
(3, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":50,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'title', 'Title', NULL, 300, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, 'title', NULL, 1),
(4, 1, NULL, 'ProfileFieldTypeSelect', '{"options":"male=>Male\\nfemale=>Female\\ncustom=>Custom"}', 'gender', 'Gender', NULL, 300, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(5, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":150,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'street', 'Street', NULL, 400, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(6, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":10,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'zip', 'Zip', NULL, 500, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(7, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'city', 'City', NULL, 600, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(8, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'country', 'Country', NULL, 700, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(9, 1, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'state', 'State', NULL, 800, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(10, 1, NULL, 'ProfileFieldTypeBirthday', '{"showTimePicker":false}', 'birthday', 'Birthday', NULL, 900, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(11, 1, NULL, 'ProfileFieldTypeTextArea', '[]', 'about', 'About', NULL, 900, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(12, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'phone_private', 'Phone Private', NULL, 100, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(13, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'phone_work', 'Phone Work', NULL, 200, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(14, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'mobile', 'Mobile', NULL, 300, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(15, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'fax', 'Fax', NULL, 400, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(16, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'im_skype', 'Skype Nickname', NULL, 500, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(17, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":100,"validator":null,"default":null,"regexp":null,"regexpErrorMessage":null}', 'im_msn', 'MSN', NULL, 600, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(18, 2, NULL, 'ProfileFieldTypeNumber', '{"maxValue":null,"minValue":null}', 'im_icq', 'ICQ Number', NULL, 700, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(19, 2, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"email","default":null,"regexp":null,"regexpErrorMessage":null}', 'im_xmpp', 'XMPP Jabber Address', NULL, 800, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(20, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url', 'Url', NULL, 100, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(21, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_facebook', 'Facebook URL', NULL, 200, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(22, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_linkedin', 'LinkedIn URL', NULL, 300, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(23, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_xing', 'Xing URL', NULL, 400, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(24, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_youtube', 'Youtube URL', NULL, 500, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(25, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_vimeo', 'Vimeo URL', NULL, 600, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(26, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_flickr', 'Flickr URL', NULL, 700, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(27, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_myspace', 'MySpace URL', NULL, 800, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(28, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_googleplus', 'Google+ URL', NULL, 900, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(29, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'url_twitter', 'Twitter URL', NULL, 1000, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(30, 3, NULL, 'ProfileFieldTypeText', '{"minLength":null,"maxLength":255,"validator":"url","default":null,"regexp":null,"regexpErrorMessage":null}', 'wordpress_blog_link', 'Wordpress blog link', NULL, 1100, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1),
(31, 1, NULL, 'ProfileFieldTypeSelect', '{"options":"1=>YES\\u0000=>NO"}', 'featured_user', 'Featured user', NULL, 300, NULL, 0, 1, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `profile_field_category`
--

CREATE TABLE `profile_field_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '100',
  `module_id` int(11) DEFAULT NULL,
  `visibility` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `translation_category` varchar(255) DEFAULT NULL,
  `is_system` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `profile_field_category`
--

INSERT INTO `profile_field_category` VALUES
(1, 'General', '', 100, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1),
(2, 'Communication', '', 200, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1),
(3, 'Social bookmarks', '', 300, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `setting`
--

CREATE TABLE `setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `value_text` text,
  `module_id` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

--
-- Dumping data for table `setting`
--

INSERT INTO `setting` VALUES
(1, 'oembedProviders', NULL, '{"vimeo.com":"http:\\/\\/vimeo.com\\/api\\/oembed.json?scheme=https&url=%url%&format=json&maxwidth=450","youtube.com":"http:\\/\\/www.youtube.com\\/oembed?scheme=https&url=%url%&format=json&maxwidth=450","youtu.be":"http:\\/\\/www.youtube.com\\/oembed?scheme=https&url=%url%&format=json&maxwidth=450","soundcloud.com":"https:\\/\\/soundcloud.com\\/oembed?url=%url%&format=json&maxwidth=450","slideshare.net":"https:\\/\\/www.slideshare.net\\/api\\/oembed\\/2?url=%url%&format=json&maxwidth=450"}', NULL, NULL, NULL, NULL, NULL),
(2, 'defaultVisibility', '1', NULL, 'space', NULL, NULL, NULL, NULL),
(3, 'defaultJoinPolicy', '1', NULL, 'space', NULL, NULL, NULL, NULL),
(4, 'name', '[[site_name]]', NULL, NULL, '[[regtime]]', 0, '[[regtime]]', 0),
(5, 'baseUrl', '[[softurl]]', NULL, NULL, '[[regtime]]', 0, '[[regtime]]', 0),
(6, 'paginationSize', '10', NULL, NULL, '[[regtime]]', 0, '[[regtime]]', 0),
(7, 'displayNameFormat', '{profile.firstname} {profile.lastname}', NULL, NULL, '[[regtime]]', 0, '[[regtime]]', 0),
(8, 'authInternal', '1', NULL, 'authentication', '[[regtime]]', 0, '[[regtime]]', 0),
(9, 'authLdap', '0', NULL, 'authentication', '[[regtime]]', 0, '[[regtime]]', 0),
(10, 'refreshUsers', '1', NULL, 'authentication_ldap', '[[regtime]]', 0, '[[regtime]]', 0),
(11, 'needApproval', '0', NULL, 'authentication_internal', '[[regtime]]', 0, '[[regtime]]', 0),
(12, 'anonymousRegistration', '1', NULL, 'authentication_internal', '[[regtime]]', 0, '[[regtime]]', 0),
(13, 'internalUsersCanInvite', '1', NULL, 'authentication_internal', '[[regtime]]', 0, '[[regtime]]', 0),
(14, 'transportType', 'php', NULL, 'mailing', '[[regtime]]', 0, '[[regtime]]', 0),
(15, 'systemEmailAddress', 'social@example.com', NULL, 'mailing', '[[regtime]]', 0, '[[regtime]]', 0),
(16, 'systemEmailName', '[[site_name]]', NULL, 'mailing', '[[regtime]]', 0, '[[regtime]]', 0),
(17, 'receive_email_activities', '1', NULL, 'mailing', '[[regtime]]', 0, '[[regtime]]', 0),
(18, 'receive_email_notifications', '2', NULL, 'mailing', '[[regtime]]', 0, '[[regtime]]', 0),
(19, 'maxFileSize', '1048576', NULL, 'file', '[[regtime]]', 0, '[[regtime]]', 0),
(20, 'maxPreviewImageWidth', '200', NULL, 'file', '[[regtime]]', 0, '[[regtime]]', 0),
(21, 'maxPreviewImageHeight', '200', NULL, 'file', '[[regtime]]', 0, '[[regtime]]', 0),
(22, 'hideImageFileInfo', '0', NULL, 'file', '[[regtime]]', 0, '[[regtime]]', 0),
(23, 'type', 'CFileCache', NULL, 'cache', '[[regtime]]', 0, '[[regtime]]', 0),
(24, 'expireTime', '3600', NULL, 'cache', '[[regtime]]', 0, '[[regtime]]', 0),
(25, 'installationId', '[[installationId]]', NULL, 'admin', '[[regtime]]', 0, '[[regtime]]', 0),
(26, 'theme', 'construction_yii_theme', NULL, NULL, '[[regtime]]', 0, '[[regtime]]', 0),
(27, 'spaceOrder', '0', NULL, 'space', '[[regtime]]', 0, '[[regtime]]', 0),
(28, 'enable', '1', NULL, 'tour', '[[regtime]]', 0, '[[regtime]]', 0),
(29, 'secret', '[[secret]]', NULL, NULL, '[[regtime]]', 0, '[[regtime]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `space`
--

CREATE TABLE `space` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) DEFAULT NULL,
  `wall_id` int(11) DEFAULT NULL,
  `name` varchar(45) NOT NULL,
  `description` text,
  `website` varchar(45) DEFAULT NULL,
  `join_policy` tinyint(4) DEFAULT NULL,
  `visibility` tinyint(4) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `tags` text,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `ldap_dn` varchar(255) DEFAULT NULL,
  `auto_add_new_members` int(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `space`
--

INSERT INTO `space` VALUES
(1, '7b851e37-bb04-4366-9e53-450f9811ba2f', 2, 'Classic', 'Classic music', NULL, 2, 2, 1, NULL, '[[regtime]]', 1, '[[regtime]]', 1, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `space_membership`
--

CREATE TABLE `space_membership` (
  `space_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `originator_user_id` varchar(45) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `request_message` text,
  `last_visit` datetime DEFAULT NULL,
  `invite_role` tinyint(4) DEFAULT NULL,
  `admin_role` tinyint(4) DEFAULT NULL,
  `share_role` tinyint(4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`space_id`,`user_id`),
  KEY `index_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `space_membership`
--

INSERT INTO `space_membership` VALUES
(1, 1, NULL, 3, NULL, '[[regtime]]', 1, 1, 1, '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `space_module`
--

CREATE TABLE `space_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(255) NOT NULL,
  `space_id` int(11) NOT NULL,
  `state` int(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `space_setting`
--

CREATE TABLE `space_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `space_id` int(10) DEFAULT NULL,
  `module_id` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_space_setting` (`space_id`,`module_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `url_oembed`
--

CREATE TABLE `url_oembed` (
  `url` varchar(255) NOT NULL,
  `preview` text NOT NULL,
  PRIMARY KEY (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(45) DEFAULT NULL,
  `wall_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `super_admin` tinyint(4) NOT NULL DEFAULT '0',
  `username` varchar(25) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `auth_mode` varchar(10) NOT NULL,
  `tags` text,
  `language` varchar(5) DEFAULT NULL,
  `last_activity_email` datetime NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_email` (`email`),
  UNIQUE KEY `unique_username` (`username`),
  UNIQUE KEY `unique_guid` (`guid`),
  UNIQUE KEY `unique_wall_id` (`wall_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user`
--

INSERT INTO `user` VALUES
(1, '133d4295-2311-49a2-af27-942495f6cbb3', 1, 1, 1, 1, '[[admin_username]]', '[[admin_email]]', 'local', NULL, '', '[[regtime]]', '[[regtime]]', NULL, '[[regtime]]', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_follow`
--

CREATE TABLE `user_follow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_model` varchar(100) NOT NULL,
  `object_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `send_notifications` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `index_user` (`user_id`),
  KEY `index_object` (`object_model`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_http_session`
--

CREATE TABLE `user_http_session` (
  `id` char(255) NOT NULL,
  `expire` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user_invite`
--

CREATE TABLE `user_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_originator_id` int(11) DEFAULT NULL,
  `space_invite_id` int(11) DEFAULT NULL,
  `email` varchar(45) NOT NULL,
  `source` varchar(45) DEFAULT NULL,
  `token` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_email` (`email`),
  UNIQUE KEY `unique_token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_mentioning`
--

CREATE TABLE `user_mentioning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_model` varchar(100) NOT NULL,
  `object_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `i_user` (`user_id`),
  KEY `i_object` (`object_model`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_module`
--

CREATE TABLE `user_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `state` int(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_user_module` (`user_id`,`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_password`
--

CREATE TABLE `user_password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `algorithm` varchar(20) DEFAULT NULL,
  `password` text,
  `salt` text,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_password`
--

INSERT INTO `user_password` VALUES
(1, 1, '[[algorithm]]', '[[admin_pass]]', '[[salt]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_setting`
--

CREATE TABLE `user_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `module_id` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_user_setting` (`user_id`,`module_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wall`
--

CREATE TABLE `wall` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(45) DEFAULT NULL,
  `object_model` varchar(50) NOT NULL,
  `object_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `wall`
--

INSERT INTO `wall` VALUES
(1, 'User', 'User', 1, '[[regtime]]', NULL, '[[regtime]]', NULL),
(2, 'Space', 'Space', 1, '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `wall_entry`
--

CREATE TABLE `wall_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wall_id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `wall_entry`
--

INSERT INTO `wall_entry` VALUES
(1, 2, 1, '[[regtime]]', 1, '[[regtime]]', 1);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
