<?php
/**
 * Login and registration page by AuthController
 *
 * @property CFormModel $model is the login form.
 * @property CFormModel $registerModel is the registration form.
 * @property Boolean $canRegister indicates that anonymous registrations are enabled.
 *
 * @package humhub.modules_core.user.views
 * @since 0.5
 */
$this->pageTitle = Yii::t('UserModule.views_auth_login', '<strong>Please</strong> sign in');



?>
 
  <div class="container" style="  margin-bottom: 40px;margin-top: 40px;" >


<div class="col-md-8 col-md-offset-2 col-sm-8 col-sm-offset-2 col-xs-12 music_details" style="padding: 30px;">


             <div class="panel panel-default" id="login-form" style="max-width: 340px; margin: 0 auto 20px; text-align: left;border-color#8AA6B1;">

        <div class="panel-heading" style="background-color:#D1D1D1;"><?php echo Yii::t('UserModule.views_auth_login', '<strong>Please</strong> sign in'); ?></div>

        <div class="panel-body">
            <?php
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'account-login-form',
                'enableAjaxValidation' => false,
            ));
            ?>

            <p><?php echo Yii::t('UserModule.views_auth_login', "If you're already a member, please login with your username/email and password."); ?></p>

            <div class="form-group">
                <?php echo $form->textField($model, 'username', array('class' => 'form-control', 'id' => 'login_username', 'placeholder' => Yii::t('UserModule.views_auth_login', 'username or email'))); ?>
                <?php echo $form->error($model, 'username'); ?>
            </div>

            <div class="form-group">
                <?php echo $form->passwordField($model, 'password', array('class' => 'form-control', 'id' => 'login_password', 'placeholder' => Yii::t('UserModule.views_auth_login', 'password'))); ?>
                <?php echo $form->error($model, 'password'); ?>
            </div>

            <div class="checkbox">
                <label>
                    <?php echo $form->checkBox($model, 'rememberMe'); ?> <?php echo Yii::t('UserModule.views_auth_login', 'Remember me next time'); ?>
                </label>
            </div>

            <hr>
            <div class="row">
                <div class="col-md-4 col-sm-4 col-xs-4">
                    <?php echo CHtml::submitButton(Yii::t('UserModule.views_auth_login', 'Sign in'), array('class' => 'btn btn-large btn-primary')); ?>
                </div>
                <div class="col-md-8 text-right">
                    <small>
                        <?php echo Yii::t('UserModule.views_auth_login', 'Forgot your password?'); ?>
                        <a href="<?php echo $this->createUrl('//user/auth/recoverPassword'); ?>"><br><?php echo Yii::t('UserModule.views_auth_login', 'Create a new one.') ?></a>
                    </small>
                </div>
            </div>

            <?php $this->endWidget(); ?>

        </div>

    </div>
    <div class="sign-content col-md-10 col-sm-10 col-xs-12 col-md-offset-1 col-sm-offset-1" style="margin-top: 15px;margin-bottom:15px;">
    	 
    	<a href="<?php echo Yii::app()->createUrl('//user/auth/Signup') ?>"><label>Music Fans, Signup for free...</label></a>
    	
    	<p>And begin discovering new music and tracking your favorite artists today.</p>
    </div>
       <div class="sign-content col-md-10 col-sm-10 col-xs-12 col-md-offset-1 col-sm-offset-1">
    	
    	<a href="<?php echo Yii::app()->createUrl('//user/auth/Signup') ?>"><label>Artists, Signup for free...</label></a>
    	<p>And reach millions of PureVolume music fans.</p>
    </div>

</div>
</div>
