<?php
/**
 * Login and registration page by AuthController
 *
 * @property CFormModel $model is the login form.
 * @property CFormModel $registerModel is the registration form.
 * @property Boolean $canRegister indicates that anonymous registrations are enabled.
 *
 * @package humhub.modules_core.user.views
 * @since 0.5
 */
$this->pageTitle = Yii::t('UserModule.views_auth_login', '<strong>Please</strong> sign in');
?>
 
  <div class="container" style="  margin-bottom: 40px;margin-top: 40px;" >
   <!-- <h1 id="app-title" class=""><?php echo CHtml::encode(Yii::app()->name); ?></h1>-->
<div class="col-md-8 col-md-offset-2 col-sm-8 col-sm-offset-2 col-xs-12 music_details" style="padding: 30px;">
	    <div class="sign-content col-md-10 col-sm-10 col-xs-12 col-md-offset-1 col-sm-offset-1" style="margin-top: 15px;margin-bottom:15px;">
    	<label>I'm a Listener</label>
    	<p>Discover new music. Showcase your taste.</p>
    	<ul>
    		<li>Discover new music and artists</li>
    		<li>Find music through your friends</li>
    		<li>Keep track of your favorite artists</li>
    		<li>Find shows near you</li>
       	</ul>
    </div>

    <div class="clearfix"></div>
    
    <?php if ($canRegister) : ?>
    	<div id="user_signup" class="">
    
        <div id="register-form" class="panel panel-default" style="max-width: 340px; margin: 40px auto 0px; text-align: left;">

            <div class="panel-heading" style="background-color:#D1D1D1;"><?php echo Yii::t('UserModule.views_auth_login', '<strong>Sign</strong> up') ?>
      
            </div>

            <div class="panel-body">

                <p><?php echo Yii::t('UserModule.views_auth_login', "Don't have an account? Join the network by entering your e-mail address."); ?></p>
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'account-register-form',
                    'enableAjaxValidation' => false,
                ));
                ?>

                <div class="form-group">
                    <?php echo $form->textField($registerModel, 'email', array('class' => 'form-control', 'id' => 'register-email', 'placeholder' => Yii::t('UserModule.views_auth_login', 'email'))); ?>
                    <?php echo $form->error($registerModel, 'email'); ?>
                </div>
                <hr>
                <?php echo CHtml::submitButton(Yii::t('UserModule.views_auth_login', 'Register'), array('class' => 'btn btn-primary')); ?>

                <?php $this->endWidget(); ?>
            </div>
        </div>
 
       
</div>
    <?php endif; ?>
    
    

</div>
</div>

<script type="text/javascript">
  /*  $(function() {
        // set cursor to login field
        $('#login_username').focus();
    })*/


    // Shake panel after wrong validation

        $('#login-form').removeClass('bounceIn');
        $('#login-form').addClass('shake');
        $('#register-form').removeClass('bounceInLeft');
        $('#app-title').removeClass('fadeIn');


    // Shake panel after wrong validation

        $('#register-form').removeClass('bounceInLeft');
        $('#register-form').addClass('shake');
        $('#login-form').removeClass('bounceIn');
        $('#app-title').removeClass('fadeIn');

</script>


