<div class="container" style="margin-bottom: 40px;">
	<div  class="col-md-9 col-sm-9 col-xs-12" style="background:white;">
	

    <div class="panel-heading">
        <?php echo Yii::t('', '<strong>Member</strong> directory'); ?>
    </div>

    <div class="panel-body">

        <!-- search form -->

        <?php echo CHtml::form(Yii::app()->createUrl('//people/default/browse_people', array()), 'post', array('class' => 'form-search')); ?>
        <div class="row">
            <div class="col-md-3"></div>
            <div class="col-md-6">
                <div class="form-group form-group-search">
                    <?php echo CHtml::textField("keyword", $keyword, array("class" => "form-control form-search", "placeholder" => Yii::t('DirectoryModule.views_directory_members', 'search for members'))); ?>
                    <?php echo CHtml::submitButton(Yii::t('DirectoryModule.views_directory_members', 'Search'), array('class' => 'btn btn-default btn-sm form-button-search')); ?>
                </div>
            </div>
            <div class="col-md-3"></div>
        </div>
        <?php echo CHtml::endForm(); ?>



        <?php if ($hitCount == 0): ?>
            <p><?php echo Yii::t('DirectoryModule.views_directory_members', 'No members found!'); ?></p>
        <?php endif; ?>

    </div>
    <hr>

    <ul class="media-list">
        <!-- BEGIN: Results -->
        <?php foreach ($hits as $hit) : ?>
            <?php
            $doc = $hit->getDocument();
            $model = $doc->getField("model")->value;
            $userId = $doc->getField('pk')->value;
            $user = User::model()->findByPk($userId);

            // Check for null user, if there are "zombies" in search index
            if ($user == null)
                continue;
            ?>
            <li>

                <div class="media">

                    <!-- Follow Handling -->
                    <div class="pull-right">
                       
                    </div>

                    <a href="<?php echo $user->getUrl(); ?>" class="pull-left">
                        <img class="media-object img-rounded"
                             src="<?php echo $user->getProfileImage()->getUrl(); ?>" width="50"
                             height="50" alt="50x50" data-src="holder.js/50x50"
                             style="width: 50px; height: 50px;">
                    </a>


                    <div class="media-body">
                        <h4 class="media-heading"><a
                                href="<?php echo $user->getUrl(); ?>"><?php echo CHtml::encode($user->displayName); ?></a>
                                <?php if ($user->group != null) { ?>
                                <small>(<?php echo CHtml::encode($user->group->name); ?>)</small><?php } ?>
                        </h4>
                        <h5><?php echo CHtml::encode($user->profile->title); ?></h5>

                        <?php $tag_count = 0; ?>
                        <?php if ($user->tags) : ?>
                            <?php foreach ($user->getTags() as $tag): ?>
                                <?php if ($tag_count <= 5) { ?>
                                    <?php echo HHtml::link($tag, $this->createUrl('//people/default/', array('keyword' => 'tags:' . $tag)), array('class' => 'label label-default')); ?>
                                    <?php
                                    $tag_count++;
                                }
                                ?>
                            <?php endforeach; ?>
                        <?php endif; ?>

                    </div>

                </div>

            </li>


        <?php endforeach; ?>
        <!-- END: Results -->
    </ul>



<div class="pagination-container">
    <?php
    $this->widget('CLinkPager', array(
        'currentPage' => $pages->getCurrentPage(),
        'itemCount' => $hitCount,
        'pageSize' => $pageSize,
        'maxButtonCount' => 5,
        'nextPageLabel' => '<i class="fa fa-step-forward"></i>',
        'prevPageLabel' => '<i class="fa fa-step-backward"></i>',
        'firstPageLabel' => '<i class="fa fa-fast-backward"></i>',
        'lastPageLabel' => '<i class="fa fa-fast-forward"></i>',
        'header' => '',
        'htmlOptions' => array('class' => 'pagination'),
    ));
    ?>
</div>


<script type="text/javascript">

    // ajax request to follow the user
    function setFollow(url, id) {
        jQuery.ajax({
            url: url,
            type: 'POST',
            'success': function() {
                $('#button_follow_' + id).addClass('hide');
                $('#button_unfollow_' + id).removeClass('hide');
            }});
    }

    // ajax request to unfollow the user
    function setUnfollow(url, id) {
        jQuery.ajax({
            url: url,
            type: 'POST',
            'success': function() {
                $('#button_follow_' + id).removeClass('hide');
                $('#button_unfollow_' + id).addClass('hide');
            }});
    }

</script>

<div class="clearfix"></div>
</div>
<div  class="col-md-3 col-sm-3 col-xs-12">
	
<div class="panel panel-default" id="user-statistics-panel">

    <!-- Display panel menu widget -->
    <?php $this->widget('application.widgets.PanelMenuWidget', array('id' => 'user-statistics-panel')); ?>

    <div class="panel-heading">
        <?php echo Yii::t('DirectoryModule.widgets_views_memberStats', '<strong>Member</strong> stats'); ?>
    </div>
    <div class="panel-body">
        <div class="knob-container" style="text-align: center; opacity: 0;">
            <strong><?php echo Yii::t('DirectoryModule.widgets_views_memberStats', 'Total users'); ?></strong><br><br>

            <input id="user-total" class="knob" data-width="120" data-displayprevious="true" data-readOnly="true"
                   data-fgcolor="#7191a8" data-skin="tron"
                   data-thickness=".2" value="<?php echo $statsTotalUsers; ?>"
                   data-max="<?php echo $statsTotalUsers; ?>"
                   style="font-size: 25px !important; margin-top: 44px !important;">
        </div>

        <hr>

        <div class="knob-container" style="text-align: center; opacity: 0;">
            <strong><?php echo Yii::t('DirectoryModule.widgets_views_memberStats', 'Online right now'); ?></strong><br><br>

            <input id="user-online" class="knob" data-width="120" data-displayprevious="true" data-readOnly="true"
                   data-fgcolor="#4cd9c0"
                   data-skin="tron"
                   data-thickness=".2" value="<?php echo $statsUserOnline; ?>"
                   data-max="<?php echo $statsTotalUsers; ?>"
                   style="font-size: 25px !important; margin-top: 44px !important;">
        </div>
    </div>
</div></div></div>



<script>
    $(function () {
        $(".knob").knob();
        $(".knob-container").css( "opacity", 1 );
    });

</script>

