<?php

class NewsModule extends CWebModule
{
	public function init()
	{
		// this method is called when the module is being created
		// you may place code here to customize the module or the application

		// import the module-level models and components
		$this->setImport(array(
			'news.models.*',
			'news.components.*',
		));
	}

	public function beforeControllerAction($controller, $action)
	{
		if(parent::beforeControllerAction($controller, $action))
		{
			// this method is called before any module controller action is performed
			// you may place customized code here
			return true;
		}
		else
			return false;
	}
	 public static function onTopMenuInit($event)
    {
        // Is Module enabled on this workspace?
        $event->sender->addItem(array(
            'label' => Yii::t('', 'News'),
            'id' => 'news',
            'icon' => '',
            'url' => Yii::app()->createUrl('//news/default'),
            'sortOrder' => 200,
            'isActive' => (Yii::app()->controller->module && Yii::app()->controller->module->id == 'news'),
        ));
    }
}
