<?php

/**
 * This is the model class for table "profile".
 *
 * The followings are the available columns in table 'profile':
 * @property integer $user_id
 * @property string $firstname
 * @property string $lastname
 * @property string $title
 * @property string $gender
 * @property string $street
 * @property string $zip
 * @property string $city
 * @property string $country
 * @property string $state
 * @property integer $birthday_hide_year
 * @property string $birthday
 * @property string $about
 * @property string $phone_private
 * @property string $phone_work
 * @property string $mobile
 * @property string $fax
 * @property string $im_skype
 * @property string $im_msn
 * @property integer $im_icq
 * @property string $im_xmpp
 * @property string $url
 * @property string $url_facebook
 * @property string $url_linkedin
 * @property string $url_xing
 * @property string $url_youtube
 * @property string $url_vimeo
 * @property string $url_flickr
 * @property string $url_myspace
 * @property string $url_googleplus
 * @property string $url_twitter
 * @property string $wordpress_blog_link
 */
class Profile extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'profile';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id', 'required'),
			array('user_id, birthday_hide_year, im_icq', 'numerical', 'integerOnly'=>true),
			array('firstname, lastname, title, gender, street, zip, city, country, state, phone_private, phone_work, mobile, fax,featured_user, im_skype, im_msn, im_xmpp, url, url_facebook, url_linkedin, url_xing, url_youtube, url_vimeo, url_flickr, url_myspace, url_googleplus, url_twitter, wordpress_blog_link', 'length', 'max'=>255),
			array('birthday, about', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('user_id, firstname, lastname, title, gender, street, zip, city, country, state, birthday_hide_year, featured_user,  birthday, about, phone_private, phone_work, mobile, fax, im_skype, im_msn, im_icq, im_xmpp, url, url_facebook, url_linkedin, url_xing, url_youtube, url_vimeo, url_flickr, url_myspace, url_googleplus, url_twitter, wordpress_blog_link','safe','on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_id' => 'User',
			'firstname' => 'Firstname',
			'lastname' => 'Lastname',
			'title' => 'Title',
			'gender' => 'Gender',
			'street' => 'Street',
			'zip' => 'Zip',
			'city' => 'City',
			'country' => 'Country',
			'state' => 'State',
			'birthday_hide_year' => 'Birthday Hide Year',
			'birthday' => 'Birthday',
			'about' => 'About',
			'phone_private' => 'Phone Private',
			'phone_work' => 'Phone Work',
			'mobile' => 'Mobile',
			'fax' => 'Fax',
			'im_skype' => 'Im Skype',
			'im_msn' => 'Im Msn',
			'im_icq' => 'Im Icq',
			'im_xmpp' => 'Im Xmpp',
			'url' => 'Url',
			'url_facebook' => 'Url Facebook',
			'url_linkedin' => 'Url Linkedin',
			'url_xing' => 'Url Xing',
			'url_youtube' => 'Url Youtube',
			'url_vimeo' => 'Url Vimeo',
			'url_flickr' => 'Url Flickr',
			'url_myspace' => 'Url Myspace',
			'url_googleplus' => 'Url Googleplus',
			'url_twitter' => 'Url Twitter',
			'wordpress_blog_link' => 'Wordpress Blog Link',
			'featured_user' => 'Featured user',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('firstname',$this->firstname,true);
		$criteria->compare('lastname',$this->lastname,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('street',$this->street,true);
		$criteria->compare('zip',$this->zip,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('birthday_hide_year',$this->birthday_hide_year);
		$criteria->compare('birthday',$this->birthday,true);
		$criteria->compare('about',$this->about,true);
		$criteria->compare('phone_private',$this->phone_private,true);
		$criteria->compare('phone_work',$this->phone_work,true);
		$criteria->compare('mobile',$this->mobile,true);
		$criteria->compare('fax',$this->fax,true);
		$criteria->compare('im_skype',$this->im_skype,true);
		$criteria->compare('im_msn',$this->im_msn,true);
		$criteria->compare('im_icq',$this->im_icq);
		$criteria->compare('im_xmpp',$this->im_xmpp,true);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('url_facebook',$this->url_facebook,true);
		$criteria->compare('url_linkedin',$this->url_linkedin,true);
		$criteria->compare('url_xing',$this->url_xing,true);
		$criteria->compare('url_youtube',$this->url_youtube,true);
		$criteria->compare('url_vimeo',$this->url_vimeo,true);
		$criteria->compare('url_flickr',$this->url_flickr,true);
		$criteria->compare('url_myspace',$this->url_myspace,true);
		$criteria->compare('url_googleplus',$this->url_googleplus,true);
		$criteria->compare('url_twitter',$this->url_twitter,true);
		$criteria->compare('wordpress_blog_link',$this->wordpress_blog_link,true);
		$criteria->compare('featured_user',$this->featured_user,true);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
public function get_user($data)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
		$usercriteria = new CDbCriteria();
            $usercriteria->select="*";
            $usercriteria->condition="id=".$data."";
            $user_detail=User::model()->findAll($usercriteria);
				return $user_detail;

	}
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Profile the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
