<?php
/**
 * This is included into every email to provide footer text, including a quick unsubscribe link.
 *
 * For more info about email skins, see: http://b2evolution.net/man/themes-templates-skins/email-skins/
 *
 * b2evolution - {@link http://b2evolution.net/}
 * Released under GNU GPL License - {@link http://b2evolution.net/about/gnu-gpl-license}
 * @copyright (c)2003-2020 by Francois Planque - {@link http://fplanque.com/}
 */
if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );

global $admin_url, $baseurl, $app_name, $Settings;

// Default params:
$params = array_merge( array(
		'unsubscribe_text' => '',
		'recipient_User'   => NULL,
	), $params );

$recipient_user_ID  = empty( $params['recipient_User'] ) ? NULL : $params['recipient_User']->ID;

if( ! in_array( $params['template_name'], array( 'account_activate', 'account_activated' ) ) )
{
	// Add custom messages here
}

if( ! empty( $params['is_welcome_email'] ) )
{	// If this is a welcome email campaign on newsletter subsribing:
	// Add custom messages here
}

if( isset( $params['ecmp_ID'] ) && $params['ecmp_ID'] == 1 )
{	// Email Campaign #1 is sending now:
	// Add custom messages here
}

if( isset( $params['enlt_ID'] ) && $params['enlt_ID'] == 1 )
{	// Newsletter/List #1 is sending now:
	// Add custom messages here
}

if( check_usertags( $recipient_user_ID, array( 'user_tag_1', 'user_tag_2' ), 'has_any' ) )
{	// Check user tags of the recipient, 3rd param has 3 values:
	//   'has_any' - has at least one tag from the array,
	//   'has_all' - has all tags from the array,
	//   'has_none' - has no all tags from the array.
	// Add custom messages here
}

?>
</div>
</div>

<div class="email_footer"<?php echo emailskin_style( 'div.email_footer' ); ?>>
<div style="max-width: 700px; margin: 1ex auto;">

<?php
if( empty( $params['email_headers']['Reply-To'] ) )
{	// Display the message below only when replying is not allowed to current email message,
	// usually for email messages from anonymous users:
	echo '<p'.emailskin_style( '.p' ).'><b>'.T_( 'Please do not reply to this email!' ).'</b><br />'."\n";
}
echo sprintf( T_( 'This message was automatically generated by %s running on <a %s>%s</a>.' ), $app_name, 'href="'.$baseurl.'"'.emailskin_style( '.a' ), $Settings->get( 'notification_short_name' ) );
echo "<br />\n";
if( ! empty( $params['recipient_User'] ) )
{	// Display a login and a link to restore a password only for registered User:
	echo sprintf( T_( 'Your login on %s is: $login$' ), $Settings->get( 'notification_short_name' ) );
	echo ' &bull; ';
	echo '<a href="'.get_lostpassword_url( false, '&amp;', false ).'"'.emailskin_style( '.a' ).'>'.T_('Lost password?').'</a>';
}
echo "</p>\n";

if( ! empty( $params['recipient_User'] ) || ! empty( $params['comment_ID'] ) )
{	// Display info to unsubscribe registered or anonymous user:
	echo '<p'.emailskin_style( '.p' ).'><b>'.T_( 'Too many emails?' ).'</b><br />'."\n";
	echo sprintf( T_('To configure the emails you receive, click here: <a %s>edit notification preferences</a>.'), 'href="'.get_notifications_url( '&amp;', $recipient_user_ID, ( empty( $params['comment_ID'] ) ? NULL : $params['comment_ID'] ) ).'"'.emailskin_style( '.a' ) );
	if( !empty( $params['unsubscribe_text'] ) )
	{ // Display the unsubscribe message with link
		echo "<br />\n";
		echo $params['unsubscribe_text'];
	}
	echo "</p>\n";
}

echo '<p'.emailskin_style( '.p+p.center' ).'><img'.emailskin_style( '.img+img.b2evo' ).' src="'.$rsc_url.'img/powered-by-b2evolution-120t.gif" alt="Powered by b2evolution" /></p>';
?>
</div>
</div>

</div><?php /* End of "div.email_wrap"*/?>
</body>
</html>