<?php
/**
 * This file is part of b2evolution - {@link http://b2evolution.net/}
 * See also {@link https://github.com/b2evolution/b2evolution}.
 *
 * @license GNU GPL v2 - {@link http://b2evolution.net/about/gnu-gpl-license}
 *
 * @copyright (c)2009-2016 by Francois Planque - {@link http://fplanque.com/}
 * Parts of this file are copyright (c)2009 by The Evo Factory - {@link http://www.evofactory.com/}.
 *
 * Released under GNU GPL License - {@link http://b2evolution.net/about/gnu-gpl-license}
 *
 * @package messaging
 */
if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );

global $DB;

// Check minimum permission:
if( ! check_user_perm( 'perm_messaging', 'reply' ) )
{
	$Messages->add( 'Sorry, you are not allowed to view cotnacts!' );
	header_redirect( $admin_url );
}

// Set options path:
$AdminUI->set_path( 'messaging', 'contacts' );

// Get action parameter from request:
param_action();

$mct_blocked = NULL;
switch( $action )
{
	case 'block': // Block selected contact
		// Check that this action request is not a CSRF hacked request:
		$Session->assert_received_crumb( 'messaging_contacts' );
		$mct_blocked = 1;
		break;

	case 'unblock': // Unblock selected contact
		// Check that this action request is not a CSRF hacked request:
		$Session->assert_received_crumb( 'messaging_contacts' );
		$mct_blocked = 0;
		break;

	case 'remove_user': // Remove user from contacts group
		// Check that this action request is not a CSRF hacked request:
		$Session->assert_received_crumb( 'messaging_contacts' );

		$user_ID = param( 'user_ID', 'integer', 0 );
		$group_ID = param( 'group_ID', 'integer', 0 );
		if( $user_ID > 0 && $group_ID > 0 )
		{	// Remove user from selected group
			if( remove_contacts_group_user( $group_ID, $user_ID ) )
			{	// User has been removed from the group
				// Redirect to the contacts list
				header_redirect( url_add_param( $admin_url, 'ctrl=contacts', '&' ) );
			}
		}
		break;

	case 'add_group': // Add users to the group
		// Check that this action request is not a CSRF hacked request:
		$Session->assert_received_crumb( 'messaging_contacts' );

		$group = param( 'group', 'string', '' );
		$users = param( 'users', 'string', '' );

		if( $result = create_contacts_group_users( $group, $users ) )
		{	// Users have been added to the group
			$Messages->add( sprintf( TB_('%d contacts have been added to the &laquo;%s&raquo; group.'), $result['count_users'], $result['group_name'] ), 'success' );
			header_redirect( url_add_param( $admin_url, 'ctrl=contacts' ) );
		}
		break;

	case 'rename_group': // Rename the group
		// Check that this action request is not a CSRF hacked request:
		$Session->assert_received_crumb( 'messaging_contacts' );

		$group_ID = param( 'group_ID', 'integer', true );

		if( rename_contacts_group( $group_ID ) )
		{
			$Messages->add( TB_('The group has been renamed.'), 'success' );
			header_redirect( url_add_param( $admin_url, 'ctrl=contacts&g='.$group_ID, '&' ) );
		}
		break;

	case 'delete_group': // Delete the group
		// Check that this action request is not a CSRF hacked request:
		$Session->assert_received_crumb( 'messaging_contacts' );

		$group_ID = param( 'group_ID', 'integer', true );

		if( delete_contacts_group( $group_ID ) )
		{
			$Messages->add( TB_('The group has been deleted.'), 'success' );
			header_redirect( url_add_param( $admin_url, 'ctrl=contacts', '&' ) );
		}
		break;
}

if( isset( $mct_blocked ) )
{
	set_contact_blocked( param( 'user_ID', 'integer' ), $mct_blocked );

	// Memorize params for the function regenerate_url()
	param( 's', 'string', '', true );
	param( 'g', 'integer', 0, true );
	param( 'results_mct_page', 'integer', 0, true );
	param( 'results_mct_order', 'string', '', true );
	// Redirect so that a reload doesn't write to the DB twice:
	header_redirect( regenerate_url( '', '', '', '&' ), 303 ); // Will EXIT
	// We have EXITed already at this point!!
}

$AdminUI->breadcrumbpath_init( false );  // fp> I'm playing with the idea of keeping the current blog in the path here...
$AdminUI->breadcrumbpath_add( TB_('Messages'), '?ctrl=threads' );
$AdminUI->breadcrumbpath_add( TB_('Contacts'), '?ctrl=contacts' );

// Set an url for manual page:
$AdminUI->set_page_manual_link( 'contacts-list' );

// Display messages depending on user email status
display_user_email_status_message();

// Display <html><head>...</head> section! (Note: should be done early if actions do not redirect)
$AdminUI->disp_html_head();

// Display title, menu, messages, etc. (Note: messages MUST be displayed AFTER the actions)
$AdminUI->disp_body_top();

$AdminUI->disp_payload_begin();

/**
 * Display payload:
 */
switch( $action )
{
	case 'nil':
		// Do nothing
		break;

	case 'block':
	case 'unblock':
	default:
		// Display contacts:
		$AdminUI->disp_view( 'messaging/views/_contact_list.view.php' );
		break;
}

$AdminUI->disp_payload_end();

// Display body bottom, debug info and close </html>:
$AdminUI->disp_global_footer();

?>