
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_axis0872`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer`
--

CREATE TABLE `[[dbprefix]]account_customer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `password` char(32) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `site_id` smallint(5) unsigned DEFAULT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default_shipping_address_id` int(10) unsigned DEFAULT NULL,
  `default_billing_address_id` int(10) unsigned DEFAULT NULL,
  `created_at` date NOT NULL,
  `modified_at` date NOT NULL,
  `group_id` smallint(5) unsigned DEFAULT '1',
  `locale` char(5) NOT NULL DEFAULT 'en_US',
  PRIMARY KEY (`id`),
  KEY `FK_account_customer_site` (`site_id`),
  KEY `FK_account_customer_group` (`group_id`),
  KEY `FK_ACCOUNT_CUSTOMER_SHIPPING_ADDRESS` (`default_shipping_address_id`),
  KEY `FK_ACCOUNT_CUSTOMER_BILLING_ADDRESS` (`default_billing_address_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_address`
--

CREATE TABLE `[[dbprefix]]account_customer_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `gender` char(1) DEFAULT '',
  `company` varchar(128) DEFAULT NULL,
  `phone` varchar(64) NOT NULL,
  `fax` varchar(64) NOT NULL,
  `firstname` varchar(128) NOT NULL,
  `lastname` varchar(128) NOT NULL,
  `street_address` varchar(128) NOT NULL,
  `suburb` varchar(128) DEFAULT NULL,
  `postcode` varchar(20) NOT NULL,
  `city` varchar(64) NOT NULL,
  `country_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `zone_id` mediumint(8) unsigned DEFAULT NULL,
  `state` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `FK_ACCOUNT_CUSTOMER_ADDRESS_CUSTOMER` (`customer_id`),
  KEY `FK_ACCOUNT_CUSTOMER_ADDRESS_COUNTRY` (`country_id`),
  KEY `FK_ACCOUNT_CUSTOMER_ADDRESS_ZONE` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_detail`
--

CREATE TABLE `[[dbprefix]]account_customer_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `customer_field_id` mediumint(8) unsigned NOT NULL,
  `customer_valueset_value_id` mediumint(8) unsigned DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `FK_account_customer_detail_customer` (`customer_id`),
  KEY `FK_account_customer_detail_field` (`customer_field_id`),
  KEY `FK_account_customer_detail_valueset_value` (`customer_valueset_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_field`
--

CREATE TABLE `[[dbprefix]]account_customer_field` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `customer_field_group_id` smallint(5) unsigned NOT NULL,
  `field_type` varchar(128) NOT NULL,
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '5',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `customer_valueset_id` smallint(5) unsigned DEFAULT NULL,
  `validator` varchar(128) DEFAULT NULL,
  `axis_validator` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_account_customer_field_group` (`customer_field_group_id`),
  KEY `FK_account_customer_field_valueset` (`customer_valueset_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]account_customer_field`
--

INSERT INTO `[[dbprefix]]account_customer_field` VALUES
(3, 'nickname', 2, 'text', 0, 5, 1, NULL, 'Alnum', 'Axis_Community_Validate_Nickname');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_fieldgroup`
--

CREATE TABLE `[[dbprefix]]account_customer_fieldgroup` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_name` (`name`),
  KEY `Index_sort_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]account_customer_fieldgroup`
--

INSERT INTO `[[dbprefix]]account_customer_fieldgroup` VALUES
(2, 'community', 5, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_fieldgroup_label`
--

CREATE TABLE `[[dbprefix]]account_customer_fieldgroup_label` (
  `customer_field_group_id` smallint(5) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `group_label` varchar(45) NOT NULL,
  PRIMARY KEY USING BTREE (`customer_field_group_id`,`language_id`),
  KEY `FK_account_customer_field_group_label_language` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]account_customer_fieldgroup_label`
--

INSERT INTO `[[dbprefix]]account_customer_fieldgroup_label` VALUES
(2, 1, 'Community');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_field_label`
--

CREATE TABLE `[[dbprefix]]account_customer_field_label` (
  `customer_field_id` mediumint(8) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `field_label` varchar(128) NOT NULL,
  PRIMARY KEY USING BTREE (`customer_field_id`,`language_id`),
  KEY `FK_account_customer_field_label_language` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]account_customer_field_label`
--

INSERT INTO `[[dbprefix]]account_customer_field_label` VALUES
(3, 1, 'Nickname');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_forgotpassword`
--

CREATE TABLE `[[dbprefix]]account_customer_forgotpassword` (
  `customer_id` int(10) unsigned NOT NULL,
  `hash` char(32) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_group`
--

CREATE TABLE `[[dbprefix]]account_customer_group` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `description` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]account_customer_group`
--

INSERT INTO `[[dbprefix]]account_customer_group` VALUES
(0, 'All', 'system group no delete'),
(1, 'General', ''),
(2, 'Retailer', ''),
(3, 'Wholesale', ''),
(4, 'Banned', ''),
(5, 'Guest', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_valueset`
--

CREATE TABLE `[[dbprefix]]account_customer_valueset` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_valueset_value`
--

CREATE TABLE `[[dbprefix]]account_customer_valueset_value` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `customer_valueset_id` smallint(5) unsigned NOT NULL,
  `sort_order` smallint(5) unsigned NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY USING BTREE (`id`),
  KEY `FK_account_customer_valueset_value_valueset` (`customer_valueset_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_customer_valueset_value_label`
--

CREATE TABLE `[[dbprefix]]account_customer_valueset_value_label` (
  `valueset_value_id` mediumint(8) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `label` varchar(128) NOT NULL,
  PRIMARY KEY (`valueset_value_id`,`language_id`),
  KEY `FK_account_customer_valueset_value_label_language` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]account_wishlist`
--

CREATE TABLE `[[dbprefix]]account_wishlist` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `wish_comment` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE_wishlist_set` (`customer_id`,`product_id`),
  KEY `customer_wishlist_FKIndex_customer` (`customer_id`),
  KEY `customer_wishlist_FKIndex_product` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_acl_role`
--

CREATE TABLE `[[dbprefix]]admin_acl_role` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]admin_acl_role`
--

INSERT INTO `[[dbprefix]]admin_acl_role` VALUES
(1, 0, 'Administrator');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_acl_rule`
--

CREATE TABLE `[[dbprefix]]admin_acl_rule` (
  `role_id` mediumint(8) unsigned NOT NULL,
  `resource_id` varchar(128) NOT NULL,
  `permission` enum('allow','deny') NOT NULL,
  PRIMARY KEY (`role_id`,`resource_id`),
  KEY `resource` (`resource_id`),
  KEY `i_acl_rule_id` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]admin_acl_rule`
--

INSERT INTO `[[dbprefix]]admin_acl_rule` VALUES
(1, 'admin', 'allow');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_user`
--

CREATE TABLE `[[dbprefix]]admin_user` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` mediumint(8) unsigned DEFAULT NULL,
  `firstname` varchar(32) NOT NULL,
  `lastname` varchar(32) NOT NULL,
  `email` varchar(128) NOT NULL,
  `username` varchar(40) NOT NULL,
  `password` varchar(32) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastlogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `reload_acl_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `i_admin_user_role_id` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]admin_user`
--

INSERT INTO `[[dbprefix]]admin_user` VALUES
(1, 1, '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', '[[admin_username]]', '[[admin_pass]]', '[[regtime]]', '[[regtime]]', '[[regtime]]', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_user_forgotpassword`
--

CREATE TABLE `[[dbprefix]]admin_user_forgotpassword` (
  `user_id` mediumint(9) unsigned NOT NULL,
  `hash` char(32) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_category`
--

CREATE TABLE `[[dbprefix]]catalog_category` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` smallint(5) unsigned NOT NULL,
  `lft` smallint(5) unsigned NOT NULL,
  `rgt` smallint(5) unsigned NOT NULL,
  `lvl` tinyint(3) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `modified_on` datetime DEFAULT NULL,
  `status` enum('enabled','disabled') DEFAULT 'enabled',
  `image_base` varchar(255) NOT NULL DEFAULT '',
  `image_listing` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `i_site_id` (`site_id`),
  KEY `i_lft` (`lft`),
  KEY `i_rgt` (`rgt`),
  KEY `i_lvl` (`lvl`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]catalog_category`
--

INSERT INTO `[[dbprefix]]catalog_category` VALUES
(1, 1, 1, 2, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'enabled', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_category_description`
--

CREATE TABLE `[[dbprefix]]catalog_category_description` (
  `category_id` mediumint(8) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `name` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `meta_title` varchar(128) NOT NULL DEFAULT '',
  `meta_description` text NOT NULL,
  `meta_keyword` varchar(255) NOT NULL DEFAULT '',
  `image_base_title` varchar(128) NOT NULL DEFAULT '',
  `image_listing_title` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`category_id`,`language_id`),
  KEY `i_language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]catalog_category_description`
--

INSERT INTO `[[dbprefix]]catalog_category_description` VALUES
(1, 1, 'Main Store', 'Root Category', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_hurl`
--

CREATE TABLE `[[dbprefix]]catalog_hurl` (
  `key_word` varchar(128) NOT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  `key_type` enum('c','m','p') NOT NULL,
  `key_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY USING BTREE (`key_word`,`site_id`),
  KEY `i_elastic_url_site_id` (`site_id`),
  KEY `i_elastic_url_key_id` (`key_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product`
--

CREATE TABLE `[[dbprefix]]catalog_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manufacturer_id` smallint(5) unsigned DEFAULT NULL,
  `quantity` decimal(15,4) unsigned NOT NULL DEFAULT '0.0000',
  `sku` varchar(255) DEFAULT NULL,
  `image_base` int(10) unsigned DEFAULT NULL,
  `image_listing` int(10) unsigned DEFAULT NULL,
  `image_thumbnail` int(10) unsigned DEFAULT NULL,
  `cost` decimal(15,4) unsigned NOT NULL DEFAULT '0.0000',
  `price` decimal(15,4) unsigned NOT NULL DEFAULT '0.0000',
  `date_available` date DEFAULT NULL,
  `weight` decimal(10,3) DEFAULT '0.000',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordered` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  `modified_on` datetime DEFAULT NULL,
  `tax_class_id` mediumint(8) unsigned DEFAULT NULL,
  `viewed` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `new_from` datetime DEFAULT NULL,
  `new_to` datetime DEFAULT NULL,
  `featured_from` datetime DEFAULT NULL,
  `featured_to` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_sku` (`sku`),
  KEY `i_manufacture_id` USING BTREE (`manufacturer_id`),
  KEY `FK_CATALOG_PRODUCT_TAX_CLASS` (`tax_class_id`),
  KEY `FK_CATALOG_PRODUCT_IMAGE_BASE_IMAGE` (`image_base`),
  KEY `FK_CATALOG_PRODUCT_IMAGE_LISTING_IMAGE` (`image_listing`),
  KEY `FK_CATALOG_PRODUCT_IMAGE_THUMBNAIL_IMAGE` (`image_thumbnail`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_attribute`
--

CREATE TABLE `[[dbprefix]]catalog_product_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned DEFAULT '0',
  `option_id` mediumint(8) unsigned NOT NULL,
  `option_value_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(15,4) DEFAULT NULL,
  `price_type` enum('to','by','percent') DEFAULT NULL,
  `weight` decimal(10,2) DEFAULT NULL,
  `weight_type` enum('to','by','percent') DEFAULT NULL,
  `modifier` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_product_attribute2_pi` (`product_id`),
  KEY `FK_product_attribute2_pvi` (`variation_id`),
  KEY `FK_product_attribute2_poi` (`option_id`),
  KEY `FK_product_attribute2_povi` (`option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_attribute_value`
--

CREATE TABLE `[[dbprefix]]catalog_product_attribute_value` (
  `product_attribute_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_value` text,
  PRIMARY KEY (`product_attribute_id`,`language_id`),
  KEY `FK_PRODUCT_ATTRIBUTE_ID` (`product_attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_category`
--

CREATE TABLE `[[dbprefix]]catalog_product_category` (
  `category_id` mediumint(8) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`product_id`),
  KEY `FK_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_description`
--

CREATE TABLE `[[dbprefix]]catalog_product_description` (
  `product_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `viewed` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `image_seo_name` varchar(128) NOT NULL DEFAULT '',
  `meta_title` varchar(128) NOT NULL DEFAULT '',
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `short_description` text NOT NULL,
  PRIMARY KEY (`product_id`,`language_id`),
  KEY `FK_PRODUCT_DESCRIPTION_LANGUAGE_ID` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_image`
--

CREATE TABLE `[[dbprefix]]catalog_product_image` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `path` varchar(255) NOT NULL DEFAULT '',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `FK_CATALOG_PRODUCT_IMAGE_PRODUCT_ID_PRODUCT` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_image_title`
--

CREATE TABLE `[[dbprefix]]catalog_product_image_title` (
  `image_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `title` varchar(128) NOT NULL,
  PRIMARY KEY (`image_id`,`language_id`),
  KEY `FK_CATALOG_PRODUCT_IMAGE_TITLE_LANGUAGE` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_manufacturer`
--

CREATE TABLE `[[dbprefix]]catalog_product_manufacturer` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_manufacturer_description`
--

CREATE TABLE `[[dbprefix]]catalog_product_manufacturer_description` (
  `manufacturer_id` smallint(5) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `title` varchar(255) DEFAULT '',
  `description` text,
  PRIMARY KEY USING BTREE (`manufacturer_id`,`language_id`),
  KEY `FK_PRODUCT_MANUFACTURER_TITLE_LANGUAGE_ID` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_option`
--

CREATE TABLE `[[dbprefix]]catalog_product_option` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `input_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comparable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `languagable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filterable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `valueset_id` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_option_code` (`code`),
  KEY `product_option_sort_order` USING BTREE (`sort_order`),
  KEY `FK_CATALOG_PRODUCT_OPTION_VALUESET` (`valueset_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_option_text`
--

CREATE TABLE `[[dbprefix]]catalog_product_option_text` (
  `option_id` mediumint(8) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `name` varchar(128) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`option_id`,`language_id`),
  KEY `FK_PRODUCT_OPTION_LANGUAGE` (`language_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TEXT_NAME` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_option_value`
--

CREATE TABLE `[[dbprefix]]catalog_product_option_value` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `valueset_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY USING BTREE (`id`),
  KEY `FK_CATALOG_PRODUCT_OPTION_VALUE_VALUESET` (`valueset_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_VALUE_SORT_ORDER` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_option_valueset`
--

CREATE TABLE `[[dbprefix]]catalog_product_option_valueset` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_option_value_text`
--

CREATE TABLE `[[dbprefix]]catalog_product_option_value_text` (
  `option_value_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `name` varchar(128) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`option_value_id`,`language_id`),
  KEY `FK_PRODUCT_OPTION_VALUE_LANGUAGE` (`language_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_VALUE_TEXT_NAME` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_price_index`
--

CREATE TABLE `[[dbprefix]]catalog_product_price_index` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `time_from` int(10) unsigned NOT NULL,
  `time_to` int(10) unsigned NOT NULL,
  `min_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `max_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `final_min_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `final_max_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `FK_CATALOG_PRODUCT_PRICE_INDEX_PRODUCT_ID` (`product_id`),
  KEY `FK_CATALOG_PRODUCT_PRICE_INDEX_SITE_ID` (`site_id`),
  KEY `FK_CATALOG_RPODUCT_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_TIME_FROM` USING BTREE (`time_from`),
  KEY `IDX_TIME_TO` USING BTREE (`time_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_related`
--

CREATE TABLE `[[dbprefix]]catalog_product_related` (
  `product_id` int(10) unsigned NOT NULL,
  `related_product_id` int(10) unsigned NOT NULL,
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '50',
  PRIMARY KEY (`product_id`,`related_product_id`),
  KEY `FK_CATALOG_PRODUCT_RELATED_RELATED_PRODUCT_ID` (`related_product_id`),
  KEY `IDX_CATALOG_PRODUCT_RELATED_SORT_ORDER` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_stock`
--

CREATE TABLE `[[dbprefix]]catalog_product_stock` (
  `product_id` int(10) unsigned NOT NULL,
  `in_stock` int(1) NOT NULL DEFAULT '1',
  `manage` int(1) NOT NULL DEFAULT '1',
  `min_qty` int(8) NOT NULL DEFAULT '0',
  `min_qty_allowed` int(8) NOT NULL DEFAULT '1',
  `max_qty_allowed` int(8) NOT NULL DEFAULT '0',
  `decimal` int(1) NOT NULL DEFAULT '0',
  `notify_qty` int(8) NOT NULL DEFAULT '0',
  `backorder` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_product_variation`
--

CREATE TABLE `[[dbprefix]]catalog_product_variation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `sku` varchar(255) NOT NULL,
  `quantity` decimal(15,4) unsigned NOT NULL DEFAULT '0.0000',
  `cost` decimal(15,4) unsigned NOT NULL DEFAULT '0.0000',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price_type` enum('to','by','percent') NOT NULL DEFAULT 'by',
  `weight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `weight_type` enum('to','by','percent') NOT NULL DEFAULT 'by',
  PRIMARY KEY (`id`),
  KEY `FK_PRODUCT_VARIATION_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]catalog_product_variation`
--

INSERT INTO `[[dbprefix]]catalog_product_variation` VALUES
(0, NULL, '', '0.0000', '0.0000', '0.0000', 'by', '0.00', 'by');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checkout_cart`
--

CREATE TABLE `[[dbprefix]]checkout_cart` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `INDEX_CHECKOUT_CART_CUSTOMER` USING BTREE (`customer_id`),
  KEY `INDEX_CHECKOUT_CART_SITE` USING BTREE (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checkout_cart_product`
--

CREATE TABLE `[[dbprefix]]checkout_cart_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shopping_cart_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `quantity` decimal(15,4) unsigned NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `variation_id` int(10) unsigned DEFAULT NULL,
  `final_weight` decimal(10,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `INDEX_CHECKOUT_CART_PRODUCT_PRODUCT` (`product_id`),
  KEY `INDEX_CHECKOUT_CART_PRODUCT_CART` USING BTREE (`shopping_cart_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checkout_cart_product_attribute`
--

CREATE TABLE `[[dbprefix]]checkout_cart_product_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shopping_cart_product_id` int(10) unsigned NOT NULL,
  `product_attribute_value` text,
  `product_attribute_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `INDEX_CHECKOUT_CART_PRODUCT_ATTRIBUTE_CART_PRODUCT` USING BTREE (`shopping_cart_product_id`),
  KEY `INDEX_CHECKOUT_CART_PRODUCT_ATTRIBUTE_PRODUCT_ATTRIBUTE` (`product_attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_block`
--

CREATE TABLE `[[dbprefix]]cms_block` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_active` tinyint(1) DEFAULT NULL,
  `name` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]cms_block`
--

INSERT INTO `[[dbprefix]]cms_block` VALUES
(1, 1, 'copyright'),
(2, 1, 'header_links'),
(3, 1, 'footer_links'),
(4, 1, 'menu'),
(5, 1, 'footer_contacts'),
(6, 1, 'about_us'),
(7, 1, 'home.banner'),
(8, 1, 'sidebar.banner');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_block_content`
--

CREATE TABLE `[[dbprefix]]cms_block_content` (
  `block_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` smallint(5) unsigned NOT NULL,
  `content` text,
  PRIMARY KEY USING BTREE (`language_id`,`block_id`),
  KEY `FK_CMS_BLOCK_CONTENT_BLOCK_ID` (`block_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]cms_block_content`
--

INSERT INTO `[[dbprefix]]cms_block_content` VALUES
(1, 1, '<p class="legality">&copy; 2008-2012 <a href="http://axiscommerce.com">Axis</a> Demo Store. All rights reserved.</p>'),
(2, 1, '<ul class="list-horizontal list-pipe info-menu no-bullet no-indent">\n        <li class="first-item">Call Us: <span class="blue">1-800-800-8000</span></li>\n        <li><a href="{{helper_href(/)}}">Help desk</a></li>\n        <li><a href="{{helper_href(/page/shipping)}}">Shipping</a></li>\n        <li><a href="{{helper_href(/page/privacy)}}">Privacy</a></li>\n        <li><a href="{{helper_href(/sitemap)}}">Sitemap</a></li>\n    </ul>'),
(3, 1, '<div class="box box-pages">\n    <div class="head"><h3 class="title">Info</h3></div>\n    <div class="content">\n        <ul class="informational">\n            <li>\n                <ul>\n                    <li><a href="{{helper_href(page/privacy)}}">Privacy Policy</a></li>\n                    <li><a href="{{helper_href(page/terms-of-use)}}">Terms &amp; Conditions</a></li>\n                    <li><a href="{{helper_href(contacts)}}">Contact Us</a></li>\n                    <li><a href="{{helper_href(page/company-history)}}">Company history</a></li>\n                </ul>\n            </li>\n            <li>\n                <ul>\n                    <li><a href="{{helper_href(/)}}">Delivery Time</a></li>\n                    <li><a href="{{helper_href(/)}}">Shipping &amp; Rates</a></li>\n                    <li><a href="{{helper_href(/)}}">Order Return &amp; Refund</a></li>\n                </ul>\n            </li>\n            <li>\n                <ul>\n                    <li><a href="{{helper_href(page/careers/)}}">Careers at Axis Demo Store</a></li>\n                    <li><a href="{{helper_href(/)}}">Information</a></li>\n                    <li><a href="{{helper_href(/)}}">Become a Supplier</a></li>\n                </ul>\n            </li>\n        </ul>\n    </div>\n</div>'),
(4, 1, '<li class="nav-contacts"><a href="{{helper_href(contacts)}}"><span>Contacts</span></a></li>'),
(5, 1, '<div class="box box-contacts">\n    <div class="head"><h3 class="title">Axis Demo store</h3></div>\n    <div class="content">\n        <p>Axis Demo store</p>\n        <p>USA, New York, Street Address, 10001</p>\n        <p>Phone: 1-800-000-0000</p>\n        <img class="payments" src="{{helper_skinUrl(images/payments.gif)}}" alt="MasterCard,Visa,AmericanExperess"/>\n    </div>\n</div>'),
(6, 1, '<div class="col3-set" style="padding: 0 7px !important;">\n  <div class="col-1">\n    <p><strong>Lorem ipsum dolor sit amet</strong>, consectetur adipiscing elit. Sed euismod odio consectetur augue elementum dictum non ac orci. Pellentesque nunc nunc, facilisis eu tincidunt et, aliquam a elit. Sed vitae lacus augue, a accumsan nisi. Donec sit amet nisi et eros laoreet pretium nec id nunc.</p>\n  </div>\n  <div class="col-2">\n    <p><span style="color: #339">Lorem ipsum dolor sit amet, consectetur adipiscing elit. <strong>Sed euismod odio consectetur augue elementum dictum non ac orci. </strong><span style="font-size: 1.2em;">Pellentesque nunc nunc</span></span>, facilisis eu tincidunt et, aliquam a elit. Sed vitae lacus augue, a accumsan nisi. Donec sit amet nisi et eros laoreet pretium nec id nunc.</p>\n  </div>\n  <div class="col-3">\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed euismod odio consectetur augue elementum dictum non ac orci. Pellentesque nunc nunc, facilisis eu tincidunt et, aliquam a elit. Sed vitae lacus augue, a accumsan nisi.</p>\n    <p><em>Donec sit amet nisi et eros laoreet pretium nec id nunc.</em></p>\n  </div>\n</div>'),
(7, 1, '<div class="home-callout" style="margin-bottom:5px;overflow:hidden;zoom:1;">\n  <div class="f-left">\n    <a href="{{helper_href(checkout/cart)}}" title="Canon EOS 50D" class="f-left" style="height:253px;"><img src="{{helper_skinUrl(images/media/home.callout_1.jpg)}}" alt="Canon EOS 50D"/></a>\n  </div>\n  <div class="f-right" style="width:330px;">\n    <a href="{{helper_href(store/htc-hero)}}" title="Htc Hero Special Offer. 20% Off" class="f-left" style="margin-bottom:10px;height:118px;"><img src="{{helper_skinUrl(images/media/home.callout_2.jpg)}}" alt="Htc Hero Special Offer. 20% Off"/></a>\n    <a href="{{helper_href(page/shipping)}}" title="Mac book Pro" class="f-left" style="height:125px;"><img src="{{helper_skinUrl(images/media/home.callout_3.jpg)}}" alt="MacBook Pro"/></a>\n  </div>\n</div>'),
(8, 1, '<a href="{{helper_href(store/htc-hero)}}" title="Htc Hero Special Offer. 20% Off" style="display:block;margin-bottom:7px;height:118px;">\n<img src="{{helper_skinUrl(images/media/sidebar.callout_1.jpg)}}" alt="Htc Hero Special Offer. 20% Off"/>\n</a>');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_category`
--

CREATE TABLE `[[dbprefix]]cms_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_active` tinyint(3) unsigned DEFAULT '1',
  `parent_id` int(10) unsigned DEFAULT NULL,
  `site_id` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY USING BTREE (`id`),
  KEY `FK_CMS_CATEGORY_CMS_CATEGORY` (`parent_id`),
  KEY `FK_CMS_CATEGORY_SITE_ID` (`site_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]cms_category`
--

INSERT INTO `[[dbprefix]]cms_category` VALUES
(1, 1, NULL, 1, 'General'),
(2, 1, NULL, 1, 'about-us');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_category_content`
--

CREATE TABLE `[[dbprefix]]cms_category_content` (
  `cms_category_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `title` varchar(45) DEFAULT NULL,
  `description` text,
  `link` varchar(128) DEFAULT NULL,
  `meta_keyword` text,
  `meta_description` text,
  `meta_title` varchar(128) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`language_id`,`cms_category_id`),
  KEY `FK_CMS_CATEGORY_TITLE_CMS_CATEGORY` (`cms_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]cms_category_content`
--

INSERT INTO `[[dbprefix]]cms_category_content` VALUES
(1, 1, NULL, NULL, 'general', NULL, NULL, NULL),
(2, 1, NULL, NULL, 'about-us', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_page`
--

CREATE TABLE `[[dbprefix]]cms_page` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_active` tinyint(4) DEFAULT NULL,
  `layout` varchar(45) DEFAULT NULL,
  `comment` tinyint(4) DEFAULT NULL,
  `access` tinyint(4) DEFAULT NULL,
  `name` varchar(128) DEFAULT NULL,
  `show_in_box` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]cms_page`
--

INSERT INTO `[[dbprefix]]cms_page` VALUES
(1, 1, 'layout_2columns-left', 1, NULL, 'privacy-policy', 1),
(2, 1, 'layout_1column', 1, NULL, 'shipping-and-returns', 1),
(3, 1, 'layout_2columns-right', 1, NULL, 'terms-of-use', 1),
(4, 1, 'layout_2columns-left', 0, NULL, 'company_history', 0),
(5, 1, 'layout_2columns-left', 0, NULL, 'careers', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_page_category`
--

CREATE TABLE `[[dbprefix]]cms_page_category` (
  `cms_category_id` int(10) unsigned NOT NULL,
  `cms_page_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`cms_category_id`,`cms_page_id`),
  KEY `FK_CMS_PAGE_TO_CATEGORY_CMS_CATEGORY` (`cms_category_id`),
  KEY `FK_CMS_PAGE_TO_CATEGORY_CMS_PAGE` (`cms_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]cms_page_category`
--

INSERT INTO `[[dbprefix]]cms_page_category` VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4),
(2, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_page_comment`
--

CREATE TABLE `[[dbprefix]]cms_page_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cms_page_id` int(10) unsigned NOT NULL,
  `author` varchar(128) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `modified_on` datetime DEFAULT NULL,
  `content` text,
  `status` tinyint(3) unsigned DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id`),
  KEY `FK_CMS_PAGE_COMMENT_CMS_PAGE` (`cms_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_page_content`
--

CREATE TABLE `[[dbprefix]]cms_page_content` (
  `cms_page_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `link` varchar(128) DEFAULT NULL,
  `title` varchar(128) DEFAULT NULL,
  `content` text,
  `meta_keyword` text,
  `meta_description` text,
  `meta_title` varchar(128) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`language_id`,`cms_page_id`),
  KEY `FK_CMS_PAGE_CONTENT_CMS_PAGE` (`cms_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]cms_page_content`
--

INSERT INTO `[[dbprefix]]cms_page_content` VALUES
(1, 1, 'privacy', 'Privacy policy', '<div class="col2-set">\n    <div class="col-1">asd, consectetuer adipiscing elit. Sed dolor urna, dapibus ac, convallis eget, ornare a, nisl. Quisque vestibulum congue est. Vivamus ante. Nullam neque tellus, aliquet sed, placerat eget, sagittis hendrerit, leo. Fusce varius pulvinar pede. Fusce at lectus. Nunc ac purus. Aenean rhoncus lacinia nisl. Sed eros sapien, pretium ut, condimentum at, lobortis porta, leo. Aenean ut nibh non metus porttitor sodales. Suspendisse nisl. Phasellus condimentum egestas magna.\nFusce porta porttitor enim. Aenean tempor est nec massa. Phasellus in sapien. Vestibulum urna odio, imperdiet eu, faucibus eu, pretium a, arcu. Morbi mi urna, commodo in, eleifend id, interdum sed, lorem. Pellentesque ullamcorper purus in sapien. Integer faucibus quam a leo. Vivamus posuere porta ipsum. In purus. Proin commodo. Cras eget mi in lacus dignissim volutpat. Fusce orci. Donec eget erat. Mauris sapien libero, sodales non, consequat ut, varius id, lorem.\nMorbi adipiscing. Aenean eu mi. Praesent erat lectus, fringilla non, condimentum ut, semper vitae, lectus. Ut vulputate. Vivamus purus velit, semper nec, dignissim vel, faucibus nec, felis. Cras posuere. Curabitur dignissim convallis lorem. Aenean bibendum auctor justo. Nulla nec diam vel justo rutrum tempor. Suspendisse nec tortor a eros laoreet rutrum. In sapien.\n</div>\n<div class="col-2">\nCras sem sem, condimentum sed, bibendum ac, molestie eget, felis. Integer diam pede, pulvinar quis, eleifend vel, pretium at, nunc. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Quisque id lectus vitae augue imperdiet sodales. Donec dapibus nisl nec arcu. Ut felis turpis, accumsan ac, sagittis a, aliquet vitae, leo. Nullam venenatis, leo quis consectetuer ullamcorper, nisl justo bibendum lorem, sit amet pulvinar quam lorem nec sem. Nunc eleifend, quam sed viverra sollicitudin, dui arcu aliquet nibh, nec tincidunt sem quam non ante. Maecenas et lectus. In tincidunt nisl et velit. Nam venenatis, augue eget congue gravida, mi neque facilisis nunc, sed porta augue erat ac felis\nProin tellus risus, pulvinar ac, pretium eu, faucibus eu, ipsum. Fusce mauris nisl, elementum id, auctor sit amet, porta ac, nibh. Mauris vulputate egestas ipsum.\n\nNunc eget nisi. Phasellus id elit nec elit sollicitudin imperdiet. Cras a justo. Praesent orci. Vivamus sagittis libero ut nulla. Integer dapibus lectus quis lorem. Maecenas consectetuer urna vitae lectus volutpat malesuada. Duis risus. Sed vulputate nulla ac nibh. Pellentesque tincidunt pharetra turpis. Cras libero velit, tristique ut, vehicula a, tempor in, nibh. Praesent ac magna at risus lobortis dictum. Curabitur ultrices neque vehicula neque.</div>\n</div>', 'privacy', 'description of privacy policy page', 'Privacy policy'),
(2, 1, 'shipping', 'Shipping and returns', 'Praesent vestibulum iaculis eros. Donec porta odio in tortor. Proin nulla nunc, ornare eu, rhoncus non, laoreet quis, sem. Praesent dictum, sapien a fermentum adipiscing, erat mauris dignissim nisi, <span style="background-color: rgb(153, 204, 0);">nec placerat lorem quam id est.<br/><br/><span style="background-color: rgb(192, 192, 192);">Nullam ut libero. Fusce libero magna, iaculis ac, tempus nec, posuere id, felis. Nulla suscipit augue in sapien. Nullam congue convallis dolor. Cras gravida felis vel nulla. Etiam pulvinar sem in nisi ornare mattis. Proin tempus.</span></span><span style="background-color: rgb(192, 192, 192);"> </span><br/><br/>Phasellus tincidunt mattis nunc. Fusce lorem. Sed consequat. Nulla ac purus. Donec vel nibh. Aliquam in sapien. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In eget quam.', '', '', 'Shipping and Returns'),
(3, 1, 'terms-of-use', 'Terms of use', '{{static_intro}}<br/>\n<p>\nIt is a long established fact that a reader will be distracted by the\nreadable content of a page when looking at its layout. The point of\nusing  is that it has a more-or-less normal distribution of\nletters, as opposed to using "Content here, content here", making it\nlook like readable English.</p>&nbsp;{{static_google_banner}}\n<br/>\n<p>\nMany desktop publishing packages and web\npage editors now use Lorem Ipsum as their default model text, and a\nsearch for "lorem ipsum" will uncover many web sites still in their\ninfancy. Various versions have evolved over the years, sometimes by\naccident, sometimes on purpose (injected humour and the like).\n</p>\n{{static_name_new}}', '', '', 'Terms of Use'),
(4, 1, 'company-history', 'Company history', '<div class="col3-set">\n    <div class="col-1">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Sed dolor urna, dapibus ac, convallis eget, ornare a, nisl. Quisque vestibulum congue est. Vivamus ante. Nullam neque tellus, aliquet sed, placerat eget, sagittis hendrerit, leo. Fusce varius pulvinar pede. Fusce at lectus. Nunc ac purus. Aenean rhoncus lacinia nisl. Sed eros sapien, pretium ut, condimentum at, lobortis porta, leo. Aenean ut nibh non metus porttitor sodales. Suspendisse nisl. Phasellus condimentum egestas magna.\nFusce porta porttitor enim. Aenean tempor est nec massa. Phasellus in sapien. Vestibulum urna odio, imperdiet eu, faucibus eu, pretium a, arcu. Morbi mi urna, commodo in, eleifend id, interdum sed, lorem. Pellentesque ullamcorper purus in sapien. Integer faucibus quam a leo. Vivamus posuere porta ipsum. In purus. Proin commodo. Cras eget mi in lacus dignissim volutpat. Fusce orci. Donec eget erat. Mauris sapien libero, sodales non, consequat ut, varius id, lorem.\n</div>\n  <div class="col-2">\nMorbi adipiscing. Aenean eu mi. Praesent erat lectus, fringilla non, condimentum ut, semper vitae, lectus. Ut vulputate. Vivamus purus velit, semper nec, dignissim vel, faucibus nec, felis. Cras posuere. Curabitur dignissim convallis lorem. Aenean bibendum auctor justo. Nulla nec diam vel justo rutrum tempor. Suspendisse nec tortor a eros laoreet rutrum. In sapien.\nCras sem sem, condimentum sed, bibendum ac, molestie eget, felis. Integer diam pede, pulvinar quis, eleifend vel, pretium at, nunc. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Quisque id lectus vitae augue imperdiet sodales. Donec dapibus nisl nec arcu. Ut felis turpis, accumsan ac, sagittis a, aliquet vitae, leo. Nullam venenatis, leo quis consectetuer ullamcorper, nisl justo bibendum lorem, sit amet pulvinar quam lorem nec sem. Nunc eleifend, quam sed viverra sollicitudin, dui arcu aliquet nibh, nec tincidunt sem quam non ante. Maecenas et lectus. In tincidunt nisl et velit. Nam venenatis, augue eget congue gravida, mi neque facilisis nunc, sed porta augue erat ac felis. </div>\n<div class="col-3">Proin tellus risus, pulvinar ac, pretium eu, faucibus eu, ipsum. Fusce mauris nisl, elementum id, auctor sit amet, porta ac, nibh. Mauris vulputate egestas ipsum.\n\nNunc eget nisi. Phasellus id elit nec elit sollicitudin imperdiet. Cras a justo. Praesent orci. Vivamus sagittis libero ut nulla. Integer dapibus lectus quis lorem. Maecenas consectetuer urna vitae lectus volutpat malesuada. Duis risus. Sed vulputate nulla ac nibh. Pellentesque tincidunt pharetra turpis. Cras libero velit, tristique ut, vehicula a, tempor in, nibh. Praesent ac magna at risus lobortis dictum. Curabitur ultrices neque vehicula neque.</div>\n</div>', 'Company, about, history', '', 'Company history'),
(5, 1, 'careers', 'Careers at our store', '<div class="col2-set" style="margin-bottom: 7px;">\n <div class="col-1">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Sed dolor urna, dapibus ac, convallis eget, ornare a, nisl. Quisque vestibulum congue est. Vivamus ante. Nullam neque tellus, aliquet sed, placerat eget, sagittis hendrerit, leo. Fusce varius pulvinar pede. Fusce at lectus. Nunc ac purus. Aenean rhoncus lacinia nisl. Sed eros sapien, pretium ut, condimentum at, lobortis porta, leo. Aenean ut nibh non metus porttitor sodales. Suspendisse nisl. Phasellus condimentum egestas magna. </div>\n <div class="col-2">Fusce porta porttitor enim. Aenean tempor est nec massa. Phasellus in sapien. Vestibulum urna odio, imperdiet eu, faucibus eu, pretium a, arcu. Morbi mi urna, commodo in, eleifend id, interdum sed, lorem. Pellentesque ullamcorper purus in sapien. Integer faucibus quam a leo. Vivamus posuere porta ipsum. In purus. Proin commodo. Cras eget mi in lacus dignissim volutpat. Fusce orci. Donec eget erat. Mauris sapien libero, sodales non, consequat ut, varius id, lorem. </div>\n</div>\n<div>\nCras sem sem, condimentum sed, bibendum ac, molestie eget, felis. Integer diam pede, pulvinar quis, eleifend vel, pretium at, nunc. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Quisque id lectus vitae augue imperdiet sodales. Donec dapibus nisl nec arcu. Ut felis turpis, accumsan ac, sagittis a, aliquet vitae, leo. Nullam venenatis, leo quis consectetuer ullamcorper, nisl justo bibendum lorem, sit amet pulvinar quam lorem nec sem. Nunc eleifend, quam sed viverra sollicitudin, dui arcu aliquet nibh, nec tincidunt sem quam non ante. Maecenas et lectus. In tincidunt nisl et velit. Nam venenatis, augue eget congue gravida, mi neque facilisis nunc, sed porta augue erat ac felis. Proin tellus risus, pulvinar ac, pretium eu, faucibus eu, ipsum. Fusce mauris nisl, elementum id, auctor sit amet, porta ac, nibh. Mauris vulputate egestas ipsum.\n\nNunc eget nisi. Phasellus id elit nec elit sollicitudin imperdiet. Cras a justo. Praesent orci. Vivamus sagittis libero ut nulla. Integer dapibus lectus quis lorem. Maecenas consectetuer urna vitae lectus volutpat malesuada. Duis risus. Sed vulputate nulla ac nibh. Pellentesque tincidunt pharetra turpis. Cras libero velit, tristique ut, vehicula a, tempor in, nibh. Praesent ac magna at risus lobortis dictum. Curabitur ultrices neque vehicula neque. \n</div>', '', '', 'Careers at our store');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]community_media`
--

CREATE TABLE `[[dbprefix]]community_media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `status` enum('pending','approved','disapproved') NOT NULL,
  `size` double NOT NULL,
  `date_uploaded` datetime NOT NULL,
  `author` varchar(128) NOT NULL,
  `title` varchar(128) NOT NULL,
  `description` varchar(255) NOT NULL,
  `media_type` enum('video','image') NOT NULL,
  `width` smallint(5) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_community_media_product` (`product_id`),
  KEY `FK_community_media_customer` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]community_review`
--

CREATE TABLE `[[dbprefix]]community_review` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `status` enum('pending','approved','disapproved') NOT NULL,
  `summary` text NOT NULL,
  `author` varchar(128) NOT NULL,
  `title` varchar(128) NOT NULL,
  `date_created` datetime NOT NULL,
  `pros` varchar(255) NOT NULL,
  `cons` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_community_review_customer` (`customer_id`),
  KEY `FK_community_review_product` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]community_review_mark`
--

CREATE TABLE `[[dbprefix]]community_review_mark` (
  `review_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_id` int(10) unsigned NOT NULL,
  `mark` float DEFAULT NULL,
  PRIMARY KEY (`review_id`,`rating_id`),
  KEY `FK_community_review_mark_rating` (`rating_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]community_review_rating`
--

CREATE TABLE `[[dbprefix]]community_review_rating` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]community_review_rating`
--

INSERT INTO `[[dbprefix]]community_review_rating` VALUES
(1, 'price', 'enabled'),
(2, 'quality', 'enabled'),
(3, 'value', 'enabled');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]community_review_rating_title`
--

CREATE TABLE `[[dbprefix]]community_review_rating_title` (
  `rating_id` int(10) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `title` varchar(128) NOT NULL,
  PRIMARY KEY USING BTREE (`rating_id`,`language_id`),
  KEY `FK_community_review_rating_title_language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]community_review_rating_title`
--

INSERT INTO `[[dbprefix]]community_review_rating_title` VALUES
(1, 1, 'Price'),
(2, 1, 'Quality'),
(3, 1, 'Value');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_department`
--

CREATE TABLE `[[dbprefix]]contacts_department` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]contacts_department`
--

INSERT INTO `[[dbprefix]]contacts_department` VALUES
(1, 'test@axiscommerce.com'),
(2, 'test@axiscommerce.com'),
(3, 'test@axiscommerce.com'),
(4, 'test@axiscommerce.com');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_department_name`
--

CREATE TABLE `[[dbprefix]]contacts_department_name` (
  `department_id` smallint(5) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`department_id`,`language_id`),
  KEY `FK_CONTACTS_DEPARTMENT_NAME_LANGUAGE` (`language_id`),
  KEY `FK_CONTACTS_DEPARTMENT_NAME_DEPARTMENT` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]contacts_department_name`
--

INSERT INTO `[[dbprefix]]contacts_department_name` VALUES
(1, 1, 'Support'),
(2, 1, 'General'),
(3, 1, 'Shopping'),
(4, 1, 'Developers');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_message`
--

CREATE TABLE `[[dbprefix]]contacts_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(64) NOT NULL,
  `subject` varchar(128) NOT NULL,
  `message` text,
  `custom_info` text,
  `department_id` smallint(5) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `message_status` enum('new','read','replied') NOT NULL DEFAULT 'new',
  `site_id` smallint(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_contacts_message_department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_cache`
--

CREATE TABLE `[[dbprefix]]core_cache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `is_active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `lifetime` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]core_cache`
--

INSERT INTO `[[dbprefix]]core_cache` VALUES
(1, 'modules', 1, 864000),
(2, 'config', 0, 864000),
(3, 'query', 0, NULL),
(4, 'Zend_Translate', 1, 864000),
(5, 'boxes', 1, NULL),
(6, 'locales', 1, 864000),
(7, 'cms', 1, NULL),
(8, 'catalog', 1, NULL),
(9, 'community', 1, NULL),
(10, 'order_total_methods', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_config_field`
--

CREATE TABLE `[[dbprefix]]core_config_field` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `lvl` tinyint(3) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `title` varchar(128) NOT NULL,
  `type` varchar(128) NOT NULL DEFAULT '',
  `model` varchar(128) NOT NULL,
  `description` text,
  `translation_module` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_path` USING BTREE (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=533 ;

--
-- Dumping data for table `[[dbprefix]]core_config_field`
--

INSERT INTO `[[dbprefix]]core_config_field` VALUES
(1, 1, 'core', 'Core', '', '', '', 'Axis_Core'),
(2, 2, 'core/store', 'Store', '', '', '', NULL),
(3, 3, 'core/store/name', 'Name', 'textarea', '', '', NULL),
(4, 3, 'core/store/city', 'City', 'textarea', '', '', NULL),
(5, 3, 'core/store/country', 'Country', 'select', 'location/option_country', 'Store Country', NULL),
(6, 3, 'core/store/zone', 'Zone', 'select', 'core/option_store_zone', 'Store zone(state,province)', NULL),
(7, 3, 'core/store/zip', 'Zip code', 'textarea', '', 'Zip code', NULL),
(8, 3, 'core/store/owner', 'Store owner', 'textarea', '', '', NULL),
(9, 2, 'core/backend', 'Backend', '', '', '', NULL),
(10, 3, 'core/backend/route', 'Route', 'textarea', '', 'Admin url (example.com/<b>adminRoute</b>)', NULL),
(11, 3, 'core/backend/ssl', 'Ssl Enabled', 'radio', 'core/option_boolean', '', NULL),
(12, 2, 'core/frontend', 'Frontend', '', '', '', NULL),
(13, 3, 'core/frontend/ssl', 'Ssl Enabled', 'radio', 'core/option_boolean', '', NULL),
(14, 2, 'core/company', 'Company', '', '', '', NULL),
(15, 3, 'core/company/name', 'Name', 'textarea', '', 'Company name', NULL),
(16, 3, 'core/company/site', 'Website', 'textarea', '', 'Company website', NULL),
(17, 3, 'core/company/country', 'Country', 'select', 'location/option_country', 'Company country', NULL),
(18, 3, 'core/company/city', 'City', 'textarea', '', '', NULL),
(19, 3, 'core/company/zone', 'Zone', 'select', 'core/option_company_zone', '', NULL),
(20, 3, 'core/company/street', 'Street', 'textarea', '', '', NULL),
(21, 3, 'core/company/zip', 'Zip code', 'textarea', '', '', NULL),
(22, 3, 'core/company/phone', 'Phone', 'textarea', '', '', NULL),
(23, 3, 'core/company/fax', 'Fax', 'textarea', '', '', NULL),
(24, 3, 'core/company/administratorEmail', 'Administrator email', 'select', 'core/option_mail_boxes', '', NULL),
(25, 3, 'core/company/customerRelationEmail', 'Customer relations email', 'select', 'core/option_mail_boxes', '', NULL),
(26, 3, 'core/company/salesDepartmentEmail', 'Sales department email', 'select', 'core/option_mail_boxes', '', NULL),
(27, 3, 'core/company/supportEmail', 'Support email', 'select', 'core/option_mail_boxes', '', NULL),
(28, 2, 'core/cache', 'Cache', '', '', '', NULL),
(29, 3, 'core/cache/default_lifetime', 'Default Lifetime', 'textarea', '', '', NULL),
(30, 2, 'core/translation', 'Translation', '', '', '', NULL),
(31, 3, 'core/translation/autodetect', 'Autodetect new words', 'radio', 'core/option_boolean', 'Detect not translated words and write them to the file (Make sure that locale folder has writable permissions: >chmod -R 0777 [root_path]/app/locale)', NULL),
(32, 2, 'core/minify', 'Minify', '', '', '', NULL),
(33, 3, 'core/minify/js_front', 'Enable javascript merging the frontend', 'radio', 'core/option_boolean', '', NULL),
(34, 3, 'core/minify/js_admin', 'Enable javascript merging on the backend', 'radio', 'core/option_boolean', '', NULL),
(35, 3, 'core/minify/css_front', 'Enable css merging on the frontend', 'radio', 'core/option_boolean', '', NULL),
(36, 3, 'core/minify/css_admin', 'Enable css merging on the backend', 'radio', 'core/option_boolean', '', NULL),
(37, 1, 'mail', 'Mail', '', '', '', 'Axis_Core'),
(38, 2, 'mail/main', 'General', '', '', '', NULL),
(39, 3, 'mail/main/mtcFrom', 'Sender', 'select', 'core/option_mail_boxes', '', NULL),
(40, 3, 'mail/main/transport', 'Mail transport', 'select', 'core/option_mail_transport', 'Mail Transport (smtp or sendmail)', NULL),
(41, 2, 'mail/smtp', 'Smtp', '', '', '', NULL),
(42, 3, 'mail/smtp/host', 'Host', 'textarea', '', '', NULL),
(43, 3, 'mail/smtp/user', 'User', 'password', 'core/option_crypt', '', NULL),
(44, 3, 'mail/smtp/password', 'Password', 'password', 'core/option_crypt', '', NULL),
(45, 3, 'mail/smtp/port', 'Port', 'textarea', '', '', NULL),
(46, 3, 'mail/smtp/auth', 'Use Auth', 'radio', 'core/option_boolean', '', NULL),
(47, 3, 'mail/smtp/secure', 'Secure', 'select', 'core/option_mail_secure', '', NULL),
(48, 2, 'mail/mailboxes', 'Mailboxes', '', '', '', NULL),
(49, 3, 'mail/mailboxes/email1', 'Email', 'textarea', '', '', NULL),
(50, 3, 'mail/mailboxes/email2', 'Email', 'textarea', '', '', NULL),
(51, 3, 'mail/mailboxes/email3', 'Email', 'textarea', '', '', NULL),
(52, 3, 'mail/mailboxes/email4', 'Email', 'textarea', '', '', NULL),
(53, 3, 'mail/mailboxes/email5', 'Email', 'textarea', '', '', NULL),
(54, 3, 'mail/mailboxes/email6', 'Email', 'textarea', '', '', NULL),
(55, 3, 'mail/mailboxes/email7', 'Email', 'textarea', '', '', NULL),
(56, 3, 'mail/mailboxes/email8', 'Email', 'textarea', '', '', NULL),
(57, 3, 'mail/mailboxes/email9', 'Email', 'textarea', '', '', NULL),
(58, 3, 'mail/mailboxes/email10', 'Email', 'textarea', '', '', NULL),
(59, 3, 'mail/mailboxes/email11', 'Email', 'textarea', '', '', NULL),
(60, 3, 'mail/mailboxes/email12', 'Email', 'textarea', '', '', NULL),
(61, 3, 'mail/mailboxes/email13', 'Email', 'textarea', '', '', NULL),
(62, 3, 'mail/mailboxes/email14', 'Email', 'textarea', '', '', NULL),
(63, 3, 'mail/mailboxes/email15', 'Email', 'textarea', '', '', NULL),
(64, 1, 'design', 'Design', '', '', '', 'Axis_Core'),
(65, 2, 'design/main', 'General', '', '', '', NULL),
(66, 3, 'design/main/frontTemplateId', 'Front Template', 'select', 'core/option_template', '', NULL),
(67, 3, 'design/main/adminTemplateId', 'Admin Template', 'select', 'core/option_template', '', NULL),
(68, 2, 'design/htmlHead', 'HTML Head', '', '', '', NULL),
(69, 3, 'design/htmlHead/defaultTitle', 'Default Title', 'textarea', '', '', NULL),
(70, 3, 'design/htmlHead/defaultDescription', 'Default Description', 'textarea', '', '', NULL),
(71, 3, 'design/htmlHead/defaultKeywords', 'Default Keywords', 'textarea', '', '', NULL),
(72, 3, 'design/htmlHead/titlePrefix', 'Title Prefix', 'textarea', '', '', NULL),
(73, 3, 'design/htmlHead/titleSuffix', 'Title Suffix', 'textarea', '', '', NULL),
(74, 3, 'design/htmlHead/titleDivider', 'Title Divider', 'textarea', '', '', NULL),
(75, 3, 'design/htmlHead/titlePattern', 'Title Pattern', 'multiple', 'core/option_template_titlePattern', 'Check values, which you want to see on page title', NULL),
(76, 3, 'design/htmlHead/defaultRobots', 'Default Robots', 'select', 'core/option_template_robots', '', NULL),
(77, 3, 'design/htmlHead/homeDescription', 'Homepage description', 'textarea', '', 'Homepage description', NULL),
(78, 3, 'design/htmlHead/homeKeywords', 'Homepage keywords', 'textarea', '', '', NULL),
(79, 3, 'design/htmlHead/homeTitle', 'Homepage title', 'textarea', '', 'Homepage title', NULL),
(80, 2, 'core/session', 'Session', '', '', '', NULL),
(81, 3, 'core/session/remoteAddressValidation', 'Remote Address (IP) Validation', 'radio', 'core/option_boolean', '', NULL),
(82, 3, 'core/session/httpUserAgentValidation', 'User Agent (Browser) Validation', 'radio', 'core/option_boolean', '', NULL),
(83, 2, 'design/header', 'Header', '', '', '', NULL),
(84, 3, 'design/header/logoSrc', 'Logo Image Src', 'textarea', '', '', NULL),
(85, 3, 'design/header/logoAlt', 'Logo Image Alt', 'textarea', '', '', NULL),
(86, 1, 'locale', 'Locale', '', '', '', 'Axis_Locale'),
(87, 2, 'locale/main', 'General', '', '', '', NULL),
(89, 3, 'locale/main/locale', 'Default locale', 'select', 'locale/option_zendLocale', 'Default site locale', NULL),
(90, 3, 'locale/main/timezone', 'Timezone', 'select', 'locale/option_zendTimezone', 'Timezone', NULL),
(91, 3, 'locale/main/baseCurrency', 'Base currency', 'select', 'locale/option_currency', 'Currency will be used for all online payment transactions', NULL),
(92, 3, 'locale/main/currency', 'Default display currency', 'select', 'locale/option_currency_default', 'Default currency', NULL),
(93, 3, 'locale/main/language_admin', 'Default backend language', 'select', 'locale/option_language', 'Default backend language', NULL),
(94, 3, 'locale/main/language_front', 'Default frontend language', 'select', 'locale/option_language', 'Default frontend language', NULL),
(95, 1, 'shipping', 'Shipping Methods', '', '', '', 'Axis_Admin'),
(96, 2, 'shipping/Free_Standard', 'Free Shipping Standard', '', '', '', 'Axis_ShippingFree'),
(97, 3, 'shipping/Free_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(98, 3, 'shipping/Free_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(99, 3, 'shipping/Free_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(100, 3, 'shipping/Free_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(101, 3, 'shipping/Free_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(102, 3, 'shipping/Free_Standard/handling', 'Handling Fee', 'text', '', '', NULL),
(103, 3, 'shipping/Free_Standard/cost', 'Free Shipping Cost', 'text', '', '', NULL),
(104, 3, 'shipping/Free_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(105, 3, 'shipping/Free_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(106, 3, 'shipping/Free_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(107, 1, 'payment', 'Payment Methods', '', '', '', 'Axis_Admin'),
(108, 2, 'payment/FreeOrder_Standard', 'Free Order', '', '', '', 'Axis_PaymentFreeOrder'),
(109, 3, 'payment/FreeOrder_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(110, 3, 'payment/FreeOrder_Standard/title', 'Title', 'text', '', 'Title', NULL),
(111, 3, 'payment/FreeOrder_Standard/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(112, 3, 'payment/FreeOrder_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(113, 3, 'payment/FreeOrder_Standard/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(114, 3, 'payment/FreeOrder_Standard/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(115, 3, 'payment/FreeOrder_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(116, 3, 'payment/FreeOrder_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(117, 2, 'shipping/Pickup_Standard', 'Pickup Standard', '', '', '', 'Axis_ShippingPickup'),
(118, 3, 'shipping/Pickup_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(119, 3, 'shipping/Pickup_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(120, 3, 'shipping/Pickup_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(121, 3, 'shipping/Pickup_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(122, 3, 'shipping/Pickup_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(123, 3, 'shipping/Pickup_Standard/handling', 'Handling Fee', 'text', '', '', NULL),
(124, 3, 'shipping/Pickup_Standard/price', 'Shipping Cost', 'text', '', 'The shipping cost for all orders using this shipping method.', NULL),
(125, 3, 'shipping/Pickup_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(126, 3, 'shipping/Pickup_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(127, 3, 'shipping/Pickup_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(128, 2, 'shipping/Ups_Standard', 'Ups Standard', '', '', '', 'Axis_ShippingUps'),
(129, 3, 'shipping/Ups_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(130, 3, 'shipping/Ups_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(131, 3, 'shipping/Ups_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(132, 3, 'shipping/Ups_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(133, 3, 'shipping/Ups_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(134, 3, 'shipping/Ups_Standard/pickup', 'UPS Pickup Method', 'select', 'shippingUps/option_standard_pickup', 'How do you give packages to UPS?', NULL),
(135, 3, 'shipping/Ups_Standard/package', 'UPS Packaging?', 'select', 'shippingUps/option_standard_package', 'CP - Your Packaging, ULE - UPS Letter, UT - UPS Tube, UBE - UPS Express Box', NULL),
(136, 3, 'shipping/Ups_Standard/res', 'Residential Delivery?', 'select', 'shippingUps/option_standard_destinationType', 'Quote for Residential (RES) or Commercial Delivery (COM)', NULL),
(137, 3, 'shipping/Ups_Standard/handling', 'Handling Fee', 'text', '', '', NULL),
(138, 3, 'shipping/Ups_Standard/title', 'Title', 'text', '', '', NULL),
(139, 3, 'shipping/Ups_Standard/types', 'Allowed Shipping Methods', 'multiple', 'shippingUps/option_standard_service', 'Select the UPS services to be offered. : <br />Nxt AM, Nxt AM Ltr, Nxt, Nxt Ltr, Nxt PR, Nxt Save, Nxt Save Ltr, 2nd AM, 2nd AM Ltr, 2nd, 2nd Ltr, 3 Day Select, Ground, Canada,World Xp, World Xp Ltr, World Xp Plus, World Xp Plus Ltr, World Expedite, WorldWideSaver.', NULL),
(140, 3, 'shipping/Ups_Standard/boxWeightDisplay', 'boxWeightDisplay', 'text', '', 'Variants: 0, 1 or 2 ', NULL),
(141, 3, 'shipping/Ups_Standard/type', 'UPS Type', 'select', 'shippingUps/option_standard_requestType', 'CGI or XML', NULL),
(142, 3, 'shipping/Ups_Standard/measure', 'UPS Weight Unit', 'select', 'shippingUps/option_standard_measure', 'LBS or KGS', NULL),
(143, 3, 'shipping/Ups_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(144, 3, 'shipping/Ups_Standard/gateway', 'Gateway Url', 'text', '', '', NULL),
(145, 3, 'shipping/Ups_Standard/xmlUserId', 'XML Account User Id', 'text', 'core/option_crypt', '', NULL),
(146, 3, 'shipping/Ups_Standard/xmlPassword', 'XML Account Password', 'text', 'core/option_crypt', '', NULL),
(147, 3, 'shipping/Ups_Standard/xmlAccessLicenseNumber', 'XML Access License Number', 'text', 'core/option_crypt', '', NULL),
(148, 3, 'shipping/Ups_Standard/xmlGateway', 'Gateway XML URL', 'text', '', '', NULL),
(149, 3, 'shipping/Ups_Standard/xmlOrigin', 'Origin of the shipment', 'select', 'shippingUps/option_standard_origin', '', NULL),
(150, 3, 'shipping/Ups_Standard/negotiatedActive', 'Enable Negotiated Rates', 'radio', 'core/option_boolean', '', NULL),
(151, 3, 'shipping/Ups_Standard/shipperNumber', 'Shipper Number', 'text', 'core/option_crypt', '', NULL),
(152, 3, 'shipping/Ups_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(153, 3, 'shipping/Ups_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(154, 3, 'shipping/Ups_Standard/showErrors', 'Display messages from service provider', 'radio', 'core/option_boolean', '', 'Axis_Admin'),
(155, 1, 'gbase', 'Google Base', '', '', '', 'Axis_GoogleBase'),
(156, 2, 'gbase/main', 'General', '', '', '', NULL),
(157, 3, 'gbase/main/payment', 'Payment', 'multiple', 'googleBase/option_payment', 'Let your customers buy with all major credit cards', NULL),
(158, 3, 'gbase/main/notes', 'Payment notes', 'text', '', '', NULL),
(159, 3, 'gbase/main/application', 'Application', 'text', '', 'Name of the application that last modified this item.\\r\\nAll applications should set this attribute whenever they insert or update an item. Recommended format : Organization-ApplicationName-Version', NULL),
(160, 3, 'gbase/main/dryRun', 'dryRun', 'radio', 'core/option_boolean', 'Set ''Yes'' for testing, ''No'' for production', NULL),
(161, 3, 'gbase/main/link', 'Link products to', 'select', 'googleBase/option_linkType', 'If you want to use GoogleBase pages as landing page for your items, or you  can''t give the link to your webstore - select Google Base, otherwise - select Website.', NULL),
(162, 3, 'gbase/main/itemType', 'Item type', 'text', '', 'Type of your products. Read this for more information http://code.google.com/apis/base/starting-out.html#ItemTypes', NULL),
(163, 2, 'gbase/auth', 'Login', '', '', '', NULL),
(164, 3, 'gbase/auth/login', 'Login', 'text', 'core/option_crypt', 'Your google account to submit products', NULL),
(165, 3, 'gbase/auth/password', 'Password', 'text', 'core/option_crypt', 'Password to google account', NULL),
(166, 3, 'gbase/auth/connection', 'Connection type', 'select', 'googleBase/option_connectionType', 'Login type. For ClientLogin fill login and password fields. For AuthSub you will have to enter login and password manually', NULL),
(167, 1, 'tag', 'Tag', '', '', '', 'Axis_Tag'),
(168, 2, 'tag/main', 'General', '', '', '', NULL),
(169, 3, 'tag/main/customer_status', 'Default customer tag status', 'select', 'tag/option_status', 'Default tag status added by registered customer', NULL),
(170, 3, 'tag/main/guest_status', 'Default guest tag status', 'select', 'tag/option_status', 'Default tag status added by guest', NULL),
(171, 2, 'shipping/Flat_Standard', 'Flat Rate Standard', '', '', '', 'Axis_ShippingFlat'),
(172, 3, 'shipping/Flat_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(173, 3, 'shipping/Flat_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(174, 3, 'shipping/Flat_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(175, 3, 'shipping/Flat_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(176, 3, 'shipping/Flat_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(177, 3, 'shipping/Flat_Standard/multiPrice', 'Multi Price', 'shippingflat/standard/multiprice.phtml', 'shippingFlat/option_standard_multiPrice', '', NULL),
(178, 3, 'shipping/Flat_Standard/type', 'Type', 'select', 'shippingTable/option_standard_service', 'The shipping cost is based on:', NULL),
(179, 3, 'shipping/Flat_Standard/formDesc', 'Checkout Description', 'text', '', '', NULL),
(180, 3, 'shipping/Flat_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(181, 2, 'shipping/Item_Standard', 'Item Standard', '', '', '', 'Axis_ShippingItem'),
(182, 3, 'shipping/Item_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(183, 3, 'shipping/Item_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(184, 3, 'shipping/Item_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(185, 3, 'shipping/Item_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(186, 3, 'shipping/Item_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(187, 3, 'shipping/Item_Standard/price', 'Shipping Price', 'text', '', 'Shipping price (per item)', NULL),
(188, 3, 'shipping/Item_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(189, 3, 'shipping/Item_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(190, 3, 'shipping/Item_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(191, 1, 'sales', 'Sales', '', '', '', 'Axis_Sales'),
(192, 2, 'sales/order', 'Order', '', '', '', NULL),
(193, 3, 'sales/order/defaultStatusId', 'Default Order Status', 'select', 'sales/option_order_status', 'Default Order Status', NULL),
(194, 3, 'sales/order/order_number_pattern_prefix', 'Prefix for Custom Order Number', 'text', '', '', NULL),
(195, 3, 'sales/order/order_number_pattern', 'Pattern for Custom Order Number', 'text', '', 'Please notice: Changing code pattern for existing orders in database can cause problems.', NULL),
(196, 3, 'sales/order/email', 'Order notifications reciever', 'select', 'core/option_mail_boxes', 'All notifications about new orders will be sended to this email', NULL),
(197, 2, 'shipping/Fedex_Standard', 'Fedex', '', '', '', 'Axis_ShippingFedex'),
(198, 3, 'shipping/Fedex_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(199, 3, 'shipping/Fedex_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(200, 3, 'shipping/Fedex_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(201, 3, 'shipping/Fedex_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(202, 3, 'shipping/Fedex_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(203, 3, 'shipping/Fedex_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(204, 3, 'shipping/Fedex_Standard/title', 'Title', 'text', '', '', NULL),
(205, 3, 'shipping/Fedex_Standard/account', 'Account Number', 'text', 'core/option_crypt', '', NULL),
(206, 3, 'shipping/Fedex_Standard/package', 'Package', 'select', 'shippingFedex/option_standard_package', '', NULL),
(207, 3, 'shipping/Fedex_Standard/dropoff', 'Dropoff', 'select', 'shippingFedex/option_standard_pickup', '', NULL),
(208, 3, 'shipping/Fedex_Standard/allowedTypes', 'Allowed methods', 'multiple', 'shippingFedex/option_standard_service', '', NULL),
(209, 3, 'shipping/Fedex_Standard/measure', 'UPS Weight Unit', 'select', 'shippingFedex/option_standard_measure', 'LBS or KGS', NULL),
(210, 3, 'shipping/Fedex_Standard/residenceDelivery', 'Residential Delivery', 'radio', 'core/option_boolean', '', NULL),
(211, 3, 'shipping/Fedex_Standard/gateway', 'Fedex Gateway Url', 'text', '', '', NULL),
(212, 3, 'shipping/Fedex_Standard/handling', 'Handling Fee', 'text', '', '', NULL),
(213, 3, 'shipping/Fedex_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(214, 3, 'shipping/Fedex_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(215, 3, 'shipping/Fedex_Standard/showErrors', 'Display messages from service provider', 'radio', 'core/option_boolean', '', 'Axis_Admin'),
(216, 3, 'shipping/Fedex_Standard/meterNumber', 'Meter Number', 'password', 'core/option_crypt', '', NULL),
(217, 3, 'shipping/Fedex_Standard/key', 'Key', 'password', 'core/option_crypt', '', NULL),
(218, 3, 'shipping/Fedex_Standard/password', 'Password', 'password', 'core/option_crypt', '', NULL),
(219, 2, 'payment/Paypal_Standard', 'PayPal Standard', '', '', '', 'Axis_PaymentPaypal'),
(220, 3, 'payment/Paypal_Standard/title', 'Title', 'text', '', '', NULL),
(221, 3, 'payment/Paypal_Standard/name', 'Paypal business name', 'text', '', '', NULL),
(222, 3, 'payment/Paypal_Standard/email', 'Paypal business email', 'text', 'core/option_crypt', '', NULL),
(223, 3, 'payment/Paypal_Standard/logo', 'Paypal Logo Image URL', 'text', '', 'Maximum image size is 750x90px', NULL),
(224, 3, 'payment/Paypal_Standard/sandboxMode', 'Sandbox Mode', 'radio', 'core/option_boolean', '', NULL),
(225, 3, 'payment/Paypal_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(226, 3, 'payment/Paypal_Standard/paymentAction', 'Payment Action', 'select', 'paymentPaypal/option_paymentAction', 'Payment Action: Default: Sale (Sale, Authorization)', NULL),
(227, 3, 'payment/Paypal_Standard/transactionType', 'Transaction Type', 'select', 'paymentPaypal/option_standard_transactionType', 'Transaction Type', NULL),
(228, 3, 'payment/Paypal_Standard/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(229, 3, 'payment/Paypal_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(232, 3, 'payment/Paypal_Standard/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(233, 3, 'payment/Paypal_Standard/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(234, 2, 'payment/Paypal_Direct', 'Paypal Direct', '', '', '', 'Axis_PaymentPaypal'),
(235, 3, 'payment/Paypal_Direct/title', 'Title', 'text', '', 'Title', NULL),
(236, 3, 'payment/Paypal_Direct/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(237, 3, 'payment/Paypal_Direct/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(238, 3, 'payment/Paypal_Direct/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(239, 3, 'payment/Paypal_Direct/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(240, 3, 'payment/Paypal_Direct/enabledCvv', 'Accept verification code', 'radio', 'core/option_boolean', '', 'Axis_Admin'),
(241, 3, 'payment/Paypal_Direct/creditCard', 'Accepted Credit Cards', 'multiple', 'sales/option_order_creditCard_type', 'Credits cards allowed to use with this payment method', 'Axis_Admin'),
(242, 3, 'payment/Paypal_Direct/saveCCAction', 'Save credit card number action', 'select', 'sales/option_order_creditCard_saveNumberType', 'How would you like to save credit card number', 'Axis_Admin'),
(243, 3, 'payment/Paypal_Direct/saveCvv', 'Save verification code', 'radio', '', 'Do you want to save cvv code?', 'Axis_Admin'),
(244, 3, 'payment/Paypal_Direct/server', 'Live or Sandbox', 'select', 'paymentPaypal/option_serverType', 'Live: Used to process Live transactions Sandbox: For developers and testing', NULL),
(245, 3, 'payment/Paypal_Direct/paymentAction', 'Payment Action', 'select', 'paymentPaypal/option_paymentAction', 'How do you want to obtain payment?', NULL),
(246, 3, 'payment/Paypal_Direct/currency', 'Transaction Currency', 'select', 'locale/option_currency', 'Which currency should the order be sent to PayPal?   If an unsupported currency is sent to PayPal, it will be auto-converted to USD (or GBP if using UK account)', NULL),
(247, 3, 'payment/Paypal_Direct/mode', 'PayPal Api Mode', 'select', 'paymentPaypal/option_type', 'Which PayPal API system should be used for processing?', NULL),
(248, 3, 'payment/Paypal_Direct/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(249, 2, 'payment/Paypal_Express', 'Paypal Express', '', '', '', 'Axis_PaymentPaypal'),
(250, 3, 'payment/Paypal_Express/title', 'Title', 'text', '', 'Title', NULL),
(251, 3, 'payment/Paypal_Express/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(252, 3, 'payment/Paypal_Express/server', 'Live or Sandbox', 'select', 'paymentPaypal/option_serverType', 'Live: Used to process Live transactions Sandbox: For developers and testing', NULL),
(253, 3, 'payment/Paypal_Express/mode', 'PayPal Api Mode', 'select', 'paymentPaypal/option_type', 'set mode Paypal Express Checkout payments (nvp, payflow)', NULL),
(254, 3, 'payment/Paypal_Express/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(255, 3, 'payment/Paypal_Express/paymentAction', 'Payment Action', 'select', 'paymentPaypal/option_express_paymentAction', 'How do you want to obtain payment? Default: Sale (Sale, Order, Authorization)', NULL),
(256, 3, 'payment/Paypal_Express/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(257, 2, 'payment/payflow', 'PayPal Payflow Api', '', '', '', 'Axis_PaymentPaypal'),
(258, 3, 'payment/payflow/pfuser', 'PAYFLOW: User', 'text', 'core/option_crypt', 'If you set up one or more additional users on the account, this value is the ID of the user authorized to process transactions. Otherwise it should be the same value as VENDOR. This value is case-sensitive.', NULL),
(259, 3, 'payment/payflow/pfpartner', 'PAYFLOW: Partner', 'text', 'core/option_crypt', 'Your Payflow Partner linked to your Payflow account. This value is case-sensitive.  Typical values: <strong>PayPal</strong> or <strong>Axis</strong>', NULL),
(260, 3, 'payment/payflow/pfvendor', 'PAYFLOW: Vendor', 'text', 'core/option_crypt', 'Your merchant login ID that you created when you registered for the Payflow Pro account. This value is case-sensitive.', NULL),
(261, 3, 'payment/payflow/pfpassword', 'PAYFLOW: Password', 'text', 'core/option_crypt', 'The 6- to 32-character password that you defined while registering for the account. This value is case-sensitive.', NULL),
(262, 2, 'payment/nvp', 'PayPal NVP Api', '', '', '', 'Axis_PaymentPaypal'),
(263, 3, 'payment/nvp/apiusername', 'API Signature -- Username', 'text', 'core/option_crypt', 'The API Username from your PayPal API Signature settings under *API Access*. This value typically looks like an email address and is case-sensitive.', NULL),
(264, 3, 'payment/nvp/apipassword', 'API Signature -- Password', 'text', 'core/option_crypt', 'The API Password from your PayPal API Signature settings under *API Access*. This value is a 16-character code and is case-sensitive.', NULL),
(265, 3, 'payment/nvp/apisignature', 'API Signature -- Signature', 'text', 'core/option_crypt', 'The API Signature from your PayPal API Signature settings under *API Access*. This value is a 56-character code, and is case-sensitive.', NULL),
(266, 3, 'payment/nvp/version', 'VERSION', 'text', '', 'Used protocol Paypal version', NULL),
(267, 3, 'payment/Paypal_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(268, 3, 'payment/Paypal_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(269, 3, 'payment/Paypal_Direct/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(270, 3, 'payment/Paypal_Direct/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(271, 3, 'payment/Paypal_Express/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(272, 3, 'payment/Paypal_Express/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(273, 3, 'payment/Paypal_Express/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(274, 1, 'catalog', 'Catalog', '', '', '', 'Axis_Catalog'),
(275, 2, 'catalog/main', 'General', '', '', '', NULL),
(276, 3, 'catalog/main/route', 'Catalog route', 'text', '', 'Catalog url (example.com/<b>route</b>/product)', NULL),
(277, 2, 'catalog/listing', 'Product Listing', '', '', '', NULL),
(278, 3, 'catalog/listing/type', 'Type', 'select', 'catalog/option_product_listing_type', 'Default listing type', NULL),
(279, 3, 'catalog/listing/perPage', 'Show per page', 'text', '', '', NULL),
(280, 3, 'catalog/listing/perPageDefault', 'Default product count per page', 'text', '', '', NULL),
(281, 3, 'catalog/listing/sortBy', 'Sort By', 'text', '', '', NULL),
(282, 2, 'catalog/product', 'Product View', '', '', '', NULL),
(283, 3, 'catalog/product/hurldelimiter', 'Hurl world delimiter', 'text', '', '', NULL),
(284, 3, 'catalog/product/seodelimiter', 'Hurl world delimiter', 'text', '', '', NULL),
(285, 3, 'catalog/product/seodesclength', 'SEO Description Length (45 -150 chars)', 'text', '', '', NULL),
(286, 2, 'catalog/lightzoom', 'Lightzoom', '', '', '', NULL),
(287, 3, 'catalog/lightzoom/zoomStageWidth', 'Zoomer width', 'text', '', '', NULL),
(288, 3, 'catalog/lightzoom/zoomStageHeight', 'Zoomer height', 'text', '', '', NULL),
(289, 3, 'catalog/lightzoom/zoomStagePosition', 'Zoomer position', 'select', 'catalog/option_lightzoom_stagePosition', '', NULL),
(290, 3, 'catalog/lightzoom/zoomStageOffsetX', 'Zoomer offset-x', 'text', '', '', NULL),
(291, 3, 'catalog/lightzoom/zoomStageOffsetY', 'Zoomer offset-y', 'text', '', '', NULL),
(292, 3, 'catalog/lightzoom/zoomLensOpacity', 'Lens opacity', 'text', '', '', NULL),
(293, 3, 'catalog/lightzoom/zoomCursor', 'Lens cursor', 'select', 'catalog/option_lightzoom_cursor', '', NULL),
(294, 3, 'catalog/lightzoom/zoomOnTrigger', 'Zoom on trigger', 'select', 'catalog/option_lightzoom_domEvent_onTrigger', 'Select none, if you wish to disable this event', NULL),
(295, 3, 'catalog/lightzoom/zoomOffTrigger', 'Zoom off trigger', 'select', 'catalog/option_lightzoom_domEvent_offTrigger', 'Select none, if you wish to disable this event', NULL),
(296, 3, 'catalog/lightzoom/lightboxTrigger', 'Lightbox trigger', 'select', 'catalog/option_lightzoom_domEvent_trigger', 'Select none, if you wish to disable this event', NULL),
(297, 3, 'catalog/lightzoom/lightboxResizeSpeed', 'Lightbox resize speed', 'text', '', 'Animation speed, ms', NULL),
(298, 3, 'catalog/lightzoom/lightboxFadeSpeed', 'Lightbox fade speed', 'text', '', 'Animation speed, ms', NULL),
(299, 3, 'catalog/lightzoom/lightboxMaskOpacity', 'Mask opacity', 'text', '', '', NULL),
(300, 3, 'catalog/lightzoom/switchImageTrigger', 'Switch image trigger', 'select', 'catalog/option_lightzoom_domEvent_imageTrigger', 'Select none, if you wish to disable this event', NULL),
(301, 1, 'image', 'Images', '', '', '', 'Axis_Catalog'),
(302, 2, 'image/main', 'General', '', '', '', NULL),
(303, 3, 'image/main/cachePath', 'Cache path', 'text', '', 'Image cache path, relative to AXIS_ROOT', NULL),
(304, 2, 'image/product', 'Product Images', '', '', '', NULL),
(305, 3, 'image/product/cache', 'Cache', 'radio', 'core/option_boolean', 'Enable image cache', NULL),
(306, 3, 'image/product/widthLarge', 'Large width', 'text', '', '', NULL),
(307, 3, 'image/product/heightLarge', 'Large height', 'text', '', '', NULL),
(308, 3, 'image/product/widthMedium', 'Product Info width', 'text', '', '', NULL),
(309, 3, 'image/product/heightMedium', 'Product Info height', 'text', '', '', NULL),
(310, 3, 'image/product/widthSmall', 'Small width', 'text', '', '', NULL),
(311, 3, 'image/product/heightSmall', 'Small height', 'text', '', '', NULL),
(312, 3, 'image/product/widthThumbnail', 'Thumbnail image width', 'text', '', '', NULL),
(313, 3, 'image/product/heightThumbnail', 'Thumbnail image height', 'text', '', '', NULL),
(314, 2, 'image/watermark', 'Watermark', '', '', '', NULL),
(315, 3, 'image/watermark/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(316, 3, 'image/watermark/image', 'Image path', 'text', '', 'Path relative to the skin images folder: catalog/watermark.png', NULL),
(317, 3, 'image/watermark/position', 'Watermark Position', 'select', 'catalog/option_watermark_position', '', NULL),
(318, 3, 'image/watermark/opacity', 'Opacity', 'text', '', 'Values [0 - 100]', NULL),
(319, 3, 'image/watermark/repeat', 'Repeat', 'radio', 'core/option_boolean', '', NULL),
(320, 2, 'shipping/Table_Standard', 'Table Standard', '', '', '', 'Axis_ShippingTable'),
(321, 3, 'shipping/Table_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(322, 3, 'shipping/Table_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(323, 3, 'shipping/Table_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(324, 3, 'shipping/Table_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(325, 3, 'shipping/Table_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(326, 3, 'shipping/Table_Standard/handling', 'Handling Fee', 'text', '', '', NULL),
(327, 3, 'shipping/Table_Standard/type', 'Table Method', 'select', 'shippingTable/option_standard_service', 'The shipping cost is based on the order total or the total weight of the items ordered or the total number of items orderd.', NULL),
(328, 3, 'shipping/Table_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(329, 3, 'shipping/Table_Standard/formDesc', 'Checkout Description', 'text', '', '', NULL),
(330, 1, 'tax', 'Tax', '', '', '', 'Axis_Tax'),
(331, 2, 'tax/main', 'General', '', '', '', NULL),
(332, 3, 'tax/main/taxBasis', 'TaxBasis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', NULL),
(333, 2, 'tax/shipping', 'Shipping Tax', '', '', '', NULL),
(334, 3, 'tax/shipping/taxBasis', 'Shipping TaxBasis', 'select', 'tax/option_basis', 'Address that will be used for shipping tax calculation', NULL),
(335, 3, 'tax/shipping/taxClass', 'Shipping TaxClass', 'select', 'tax/option_class', 'Tax class that will be used for shipping tax calculation', NULL),
(336, 1, 'orderTotal', 'Order Total Modules', '', '', '', 'Axis_Checkout'),
(337, 2, 'orderTotal/tax', 'Tax', '', '', '', NULL),
(338, 3, 'orderTotal/tax/model', 'Model', 'text', '', '', NULL),
(339, 2, 'orderTotal/shipping_tax', 'ShippingTax', '', '', '', NULL),
(340, 3, 'orderTotal/shipping_tax/model', 'Model', 'text', '', '', NULL),
(341, 1, 'sitemap', 'Sitemap', '', '', '', 'Axis_Sitemap'),
(342, 2, 'sitemap/main', 'General', '', '', '', NULL),
(343, 3, 'sitemap/main/enabled', 'Enabled', 'radio', 'core/option_boolean', 'Enabled', NULL),
(345, 3, 'sitemap/main/frequency', 'Frequency', 'select', 'sitemap/option_frequency', 'Frequency', NULL),
(350, 2, 'sitemap/categories', 'Categories Options', '', '', '', NULL),
(351, 3, 'sitemap/categories/priority', 'Priority', 'text', '', 'The priority of this URL relative to other URLs on your site.Valid values range from 0.0 to 1.0', NULL),
(352, 3, 'sitemap/categories/frequency', 'Frequency', 'select', 'sitemap/option_frequency', 'Frequency', NULL),
(353, 2, 'sitemap/products', 'Products Options', '', '', '', NULL),
(354, 3, 'sitemap/products/priority', 'Priority', 'text', '', 'The priority of this URL relative to other URLs on your site.Valid values range from 0.0 to 1.0', NULL),
(355, 3, 'sitemap/products/frequency', 'Frequency', 'select', 'sitemap/option_frequency', 'Frequency', NULL),
(356, 2, 'sitemap/cms', 'CMS Pages Options', '', '', '', NULL),
(357, 3, 'sitemap/cms/priority', 'Priority', 'text', '', 'The priority of this URL relative to other URLs on your site.Valid values range from 0.0 to 1.0', NULL),
(358, 3, 'sitemap/cms/frequency', 'Frequency', 'select', 'sitemap/option_frequency', 'Frequency', NULL),
(359, 3, 'sitemap/cms/showPages', 'Show pages', 'radio', 'core/option_boolean', 'Show pages on sitemap page', NULL),
(360, 1, 'analytics', 'Google analytics', '', '', '', 'Axis_GoogleAnalytics'),
(361, 2, 'analytics/main', 'General', '', '', '', NULL),
(362, 3, 'analytics/main/uacct', 'GOOGLE_ANALYTICS_UACCT', 'text', 'core/option_crypt', '', NULL),
(363, 3, 'analytics/main/used', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(369, 2, 'analytics/conversion', 'Conversion option', '', '', '', NULL),
(373, 2, 'analytics/tracking', 'Tracking options', '', '', '', NULL),
(376, 2, 'shipping/Usps_Standard', 'Usps Standard', '', '', '', 'Axis_ShippingUsps'),
(377, 3, 'shipping/Usps_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(378, 3, 'shipping/Usps_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(379, 3, 'shipping/Usps_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(380, 3, 'shipping/Usps_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(381, 3, 'shipping/Usps_Standard/handling', 'Handling price', 'text', '', '', NULL),
(382, 3, 'shipping/Usps_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(383, 3, 'shipping/Usps_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(384, 3, 'shipping/Usps_Standard/title', 'Title', 'text', '', '', NULL),
(385, 3, 'shipping/Usps_Standard/gateway', 'Gateway Url', 'text', '', '', NULL),
(386, 3, 'shipping/Usps_Standard/service', 'Allowed Service', 'multiple', 'shippingUsps/option_standard_service', '', NULL),
(387, 3, 'shipping/Usps_Standard/userId', 'User ID', 'text', 'core/option_crypt', '', NULL),
(388, 3, 'shipping/Usps_Standard/container', 'Container', 'select', 'shippingUsps/option_standard_package', '', NULL),
(389, 3, 'shipping/Usps_Standard/size', 'Size', 'select', 'shippingUsps/option_standard_size', '', NULL),
(390, 3, 'shipping/Usps_Standard/machinable', 'Machinable', 'radio', 'core/option_boolean', '', NULL),
(391, 3, 'shipping/Usps_Standard/allowedMethods', 'Allowed Shipping Methods', 'multiple', 'shippingUsps/option_standard_serviceLabel', '', NULL),
(392, 3, 'shipping/Usps_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(393, 3, 'shipping/Usps_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(394, 3, 'shipping/Usps_Standard/showErrors', 'Display messages from service provider', 'radio', 'core/option_boolean', '', 'Axis_Admin'),
(395, 2, 'payment/AuthorizenetAim_Standard', 'Authorize.Net Aim', '', '', '', 'Axis_PaymentAuthorizenetAim'),
(396, 3, 'payment/AuthorizenetAim_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(397, 3, 'payment/AuthorizenetAim_Standard/title', 'Title', 'text', '', '', NULL),
(398, 3, 'payment/AuthorizenetAim_Standard/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(399, 3, 'payment/AuthorizenetAim_Standard/creditCard', 'Accepted Credit Cards', 'multiple', 'sales/option_order_creditCard_type', 'Credits cards allowed to use with this payment method', 'Axis_Admin'),
(400, 3, 'payment/AuthorizenetAim_Standard/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(401, 3, 'payment/AuthorizenetAim_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(402, 3, 'payment/AuthorizenetAim_Standard/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(404, 3, 'payment/AuthorizenetAim_Standard/xLogin', 'Login Id', 'text', 'core/option_crypt', 'The API Login ID used for the Authorize.net service', NULL),
(405, 3, 'payment/AuthorizenetAim_Standard/xTransactionKey', 'Transaction Key', 'text', 'core/option_crypt', 'Transaction Key used for encrypting TP data (See your Authorizenet Account->Security Settings->API Login ID and Transaction Key for details.)', NULL),
(406, 3, 'payment/AuthorizenetAim_Standard/gateway', 'Gateway URL', 'text', '', '', NULL),
(407, 3, 'payment/AuthorizenetAim_Standard/emailCustomer', 'Customer Notification', 'radio', 'core/option_boolean', 'Should Authorize.Net email a receipt to the customer?', NULL),
(408, 3, 'payment/AuthorizenetAim_Standard/emailMerchant', 'Merchant Email', 'text', '', '', NULL),
(409, 3, 'payment/AuthorizenetAim_Standard/test', 'Test Mode', 'radio', 'core/option_boolean', '', NULL),
(410, 3, 'payment/AuthorizenetAim_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(411, 3, 'payment/AuthorizenetAim_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(412, 3, 'payment/AuthorizenetAim_Standard/authorizationType', 'Authorization Type', 'select', 'paymentAuthorizenetAim/option_standard_authorizationType', 'Do you want submitted credit card transactions to be authorized only, or authorized and captured?', NULL),
(413, 2, 'shipping/PerWeightUnit_Standard', 'Per Weight Unit', '', '', '', 'Axis_ShippingPerWeightUnit'),
(414, 3, 'shipping/PerWeightUnit_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(415, 3, 'shipping/PerWeightUnit_Standard/geozone', 'Allowed Shipping Zone', 'select', 'location/option_geozone', 'Shipping method will be available only for selected zone', 'Axis_Admin'),
(416, 3, 'shipping/PerWeightUnit_Standard/taxBasis', 'Tax Basis', 'select', 'tax/option_basis', 'Address that will be used for tax calculation', 'Axis_Tax'),
(417, 3, 'shipping/PerWeightUnit_Standard/taxClass', 'Tax Class', 'select', 'tax/option_class', 'Tax class that will be used for tax calculation', 'Axis_Tax'),
(418, 3, 'shipping/PerWeightUnit_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(419, 3, 'shipping/PerWeightUnit_Standard/handling', 'Handling Fee', 'text', '', '', NULL),
(420, 3, 'shipping/PerWeightUnit_Standard/price', 'Shipping Cost per Unit', 'text', '', 'NOTE: When using this Shipping Module be sure to check the Tare settings in the Shipping/Packaging and set the Largest Weight high enough to handle the price, such as 5000.00 and the adjust the settings on Small and Large packages which will add to the price as well.The shipping cost will be used to determin shipping charges based on: Product Quantity * Units (products_weight) * Cost per Unit - in an order that uses this shipping method.', NULL),
(421, 3, 'shipping/PerWeightUnit_Standard/payments', 'Disallowed Payments', 'multiple', 'checkout/option_payment', 'Selected payment methods will be not available with this shipping method', 'Axis_Admin'),
(422, 3, 'shipping/PerWeightUnit_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(423, 3, 'shipping/PerWeightUnit_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(424, 3, 'locale/main/addressFormat', 'Default Address Format', 'select', 'location/option_address_format', 'Default address format', NULL),
(425, 2, 'payment/CheckMoney_Standard', 'Check & Money Order', '', '', '', 'Axis_PaymentCheckMoney'),
(426, 3, 'payment/CheckMoney_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(427, 3, 'payment/CheckMoney_Standard/title', 'Title', 'text', '', 'Title', NULL),
(428, 3, 'payment/CheckMoney_Standard/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(429, 3, 'payment/CheckMoney_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(430, 3, 'payment/CheckMoney_Standard/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(431, 3, 'payment/CheckMoney_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(432, 3, 'payment/CheckMoney_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(433, 3, 'payment/CheckMoney_Standard/payTo', 'Make check payable to', 'text', '', 'Who should payments be made payable to?', NULL),
(434, 3, 'payment/CheckMoney_Standard/sendCheckTo', 'Send your check to', 'textarea', '', ' This is the Store Name, Address and Phone used on printable documents and displayed online', NULL),
(435, 3, 'payment/CheckMoney_Standard/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(436, 1, 'account', 'Account', '', '', '', NULL),
(437, 2, 'account/main', 'General', '', '', '', NULL),
(438, 3, 'account/main/defaultCustomerGroup', 'Default Customer Group', 'select', 'account/option_customer_group', 'Default Customer Group (default:''General'')', NULL),
(439, 2, 'account/address_form', 'Address Form', '', '', '', NULL),
(440, 3, 'account/address_form/company_status', 'Company Status', 'select', 'core/option_config_field_status', '', NULL),
(441, 3, 'account/address_form/company_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(442, 3, 'account/address_form/phone_status', 'Phone Status', 'select', 'core/option_config_field_status', '', NULL),
(443, 3, 'account/address_form/phone_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(444, 3, 'account/address_form/fax_status', 'Fax Status', 'select', 'core/option_config_field_status', '', NULL),
(445, 3, 'account/address_form/fax_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(446, 3, 'account/address_form/street_address_status', 'Street Status', 'select', 'core/option_config_field_status', '', NULL),
(447, 3, 'account/address_form/street_address_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(448, 3, 'account/address_form/city_status', 'City Status', 'select', 'core/option_config_field_status', '', NULL),
(449, 3, 'account/address_form/city_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(450, 3, 'account/address_form/zone_id_status', 'Region Status', 'select', 'core/option_config_field_status', '', NULL),
(451, 3, 'account/address_form/zone_id_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(452, 3, 'account/address_form/postcode_status', 'Postcode Status', 'select', 'core/option_config_field_status', '', NULL),
(453, 3, 'account/address_form/postcode_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(454, 3, 'account/address_form/country_id_status', 'Country Status', 'select', 'core/option_config_field_status', '', NULL);
INSERT INTO `[[dbprefix]]core_config_field` VALUES
(455, 3, 'account/address_form/country_id_sort_order', 'Company Sort Order', 'text', '', '', NULL),
(456, 3, 'account/address_form/country_id_allow', 'Allowed Countries', 'multiple', 'location/option_address_country', '', NULL),
(457, 3, 'account/address_form/company_value', 'Company Default Value', 'text', '', '', NULL),
(458, 3, 'account/address_form/phone_value', 'Phone Default Value', 'text', '', '', NULL),
(459, 3, 'account/address_form/fax_value', 'Fax Default Value', 'text', '', '', NULL),
(460, 3, 'account/address_form/street_address_value', 'Street Address Default Value', 'text', '', '', NULL),
(461, 3, 'account/address_form/city_value', 'City Default Value', 'text', '', '', NULL),
(462, 3, 'account/address_form/zone_id_value', 'State(Region) Default Value', 'text', '', 'You can get the id of desired region at [admin]/location/zone', NULL),
(463, 3, 'account/address_form/postcode_value', 'Postcode Default Value', 'text', '', '', NULL),
(464, 3, 'account/address_form/country_id_value', 'Country Default Value', 'select', 'location/option_country', '', NULL),
(465, 1, 'community', 'Community', '', '', '', 'Axis_Community'),
(466, 2, 'community/review', 'Reviews', '', '', '', NULL),
(467, 3, 'community/review/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(468, 3, 'community/review/rating_enabled', 'Enable ratings', 'radio', 'core/option_boolean', 'Enable rating system in reviews', NULL),
(469, 3, 'community/review/rating_title', 'Show rating title', 'radio', 'core/option_boolean', 'Show rating titles', NULL),
(470, 3, 'community/review/merge_average', 'Merge average ratings', 'radio', 'core/option_boolean', 'Show average rating as one', NULL),
(471, 3, 'community/review/customer_status', 'Default customer review status', 'select', 'community/option_review_status', 'Default review status written by registered customer', NULL),
(472, 3, 'community/review/guest_status', 'Default guest review status', 'select', 'community/option_review_status', 'Default review status written by guest', NULL),
(473, 3, 'community/review/guest_permission', 'Allow guest to write a reviews', 'radio', 'core/option_boolean', '', NULL),
(474, 3, 'community/review/perPage', 'Reviews showed per page', 'text', '', '', NULL),
(475, 3, 'community/review/perPageDefault', 'Default reviews count per page', 'text', '', '', NULL),
(476, 2, 'payment/CreditCard_Standard', 'Save Credit Card', '', '', '', 'Axis_PaymentCreditCard'),
(477, 3, 'payment/CreditCard_Standard/title', 'Title', 'text', '', 'Title', NULL),
(478, 3, 'payment/CreditCard_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(479, 3, 'payment/CreditCard_Standard/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(480, 3, 'payment/CreditCard_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(481, 3, 'payment/CreditCard_Standard/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(482, 3, 'payment/CreditCard_Standard/enabledCvv', 'Accept verification code', 'radio', 'core/option_boolean', '', 'Axis_Admin'),
(483, 3, 'payment/CreditCard_Standard/saveCvv', 'Save verification code', 'radio', 'core/option_boolean', 'Do you want to save cvv code?', 'Axis_Admin'),
(484, 3, 'payment/CreditCard_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(485, 3, 'payment/CreditCard_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(486, 3, 'payment/CreditCard_Standard/creditCard', 'Accepted Credit Cards', 'multiple', 'sales/option_order_creditCard_type', 'Credits cards allowed to use with this payment method', 'Axis_Admin'),
(487, 3, 'payment/CreditCard_Standard/saveCCAction', 'Save credit card number action', 'select', 'sales/option_order_creditCard_saveNumberType', 'How would you like to save credit card number', 'Axis_Admin'),
(488, 3, 'payment/CreditCard_Standard/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(489, 2, 'payment/CashOnDelivery_Standard', 'Cash On Delivery', '', '', '', 'Axis_PaymentCashOnDelivery'),
(490, 3, 'payment/CashOnDelivery_Standard/enabled', 'Enabled', 'radio', 'core/option_boolean', '', 'Axis_Core'),
(491, 3, 'payment/CashOnDelivery_Standard/title', 'Title', 'text', '', '', NULL),
(492, 3, 'payment/CashOnDelivery_Standard/geozone', 'Allowed Payment Zone', 'select', 'location/option_geozone', 'Payment method will be available only for selected zone', 'Axis_Admin'),
(493, 3, 'payment/CashOnDelivery_Standard/sortOrder', 'Sort Order', 'text', '', '', 'Axis_Core'),
(494, 3, 'payment/CashOnDelivery_Standard/orderStatusId', 'Order Status on payment complete', 'select', 'sales/option_order_status', 'Set the status of orders made with this payment module to this value', 'Axis_Admin'),
(495, 3, 'payment/CashOnDelivery_Standard/shippings', 'Disallowed Shippings', 'multiple', 'checkout/option_shipping', 'Selected shipping methods will be not available with this payment method', 'Axis_Admin'),
(496, 3, 'payment/CashOnDelivery_Standard/minOrderTotal', 'Minimum order total amount', 'text', '', '', 'Axis_Admin'),
(497, 3, 'payment/CashOnDelivery_Standard/maxOrderTotal', 'Maximum order total amount', 'text', '', '', 'Axis_Admin'),
(498, 1, 'log', 'Log', '', '', '', 'Axis_Log'),
(499, 2, 'log/main', 'General', '', '', '', NULL),
(500, 3, 'log/main/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(501, 3, 'log/main/php', 'Php log', 'text', '', 'Path relative to AXIS_ROOT', NULL),
(502, 3, 'log/main/payment', 'Payment log', 'text', '', 'Path relative to AXIS_ROOT', NULL),
(503, 3, 'log/main/shipping', 'Shipping log', 'text', '', 'Path relative to AXIS_ROOT', NULL),
(504, 2, 'orderTotal/subtotal', 'Subtotal', '', '', '', NULL),
(505, 3, 'orderTotal/subtotal/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(506, 3, 'orderTotal/subtotal/sortOrder', 'Sort Order', 'text', '', '', NULL),
(507, 2, 'orderTotal/shipping', 'Shipping', '', '', '', NULL),
(508, 3, 'orderTotal/shipping/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(509, 3, 'orderTotal/shipping/sortOrder', 'Sort Order', 'text', '', '', NULL),
(510, 3, 'orderTotal/tax/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(511, 3, 'orderTotal/tax/sortOrder', 'Sort Order', 'text', '', '', NULL),
(512, 3, 'orderTotal/shipping_tax/enabled', 'Enabled', 'radio', 'core/option_boolean', '', NULL),
(513, 3, 'orderTotal/shipping_tax/sortOrder', 'Sort Order', 'text', '', '', NULL),
(514, 1, 'checkout', 'Checkout', '', '', '', NULL),
(515, 2, 'checkout/address_form', 'Address Form', '', '', '', NULL),
(516, 3, 'checkout/address_form/custom_fields_display_mode', 'Display Mode for Custom Fields', 'select', 'checkout/option_form_address_customFieldsDisplayMode', '', NULL),
(517, 3, 'checkout/address_form/shipping_address_enabled', 'Display Shipping Address', 'radio', 'core/option_boolean', '', NULL),
(518, 2, 'checkout/default_values', 'Default Values', '', '', '', 'Axis_Checkout'),
(522, 3, 'checkout/default_values/shipping_method', 'Shipping Method', 'text', '', '', NULL),
(523, 3, 'checkout/default_values/payment_method', 'Payment Method', 'select', 'checkout/option_default_payment', '', NULL),
(524, 2, 'checkout/onestep_ajax', 'Onestep Ajax Requests', '', '', '', NULL),
(525, 3, 'checkout/onestep_ajax/billing_address', 'Reload when Billing Address was Changed', 'radio', 'core/option_boolean', 'You can disable this option if you don''t use different payment methods for different addresses', NULL),
(526, 3, 'checkout/onestep_ajax/delivery_address', 'Reload when Delivery Address was Changed', 'radio', 'core/option_boolean', 'You can disable this option if you don''t use different shipping methods or shipping taxes for different addresses', NULL),
(527, 3, 'checkout/onestep_ajax/shipping_method', 'Reload when Shipping Method was Changed', 'radio', 'core/option_boolean', 'You can disable this option if all of your shipping methods have equal pricing, and if you don''t have dependency between available payment methods and shipping method', NULL),
(528, 3, 'checkout/onestep_ajax/payment_method', 'Reload when Payment Method was Changed', 'radio', 'core/option_boolean', 'You can disable this option if you don''t have dependency between available shipping methods and payment method', NULL),
(529, 2, 'checkout/cart', 'Shopping Cart', '', '', '', NULL),
(530, 3, 'checkout/cart/redirect', 'Redirect Location', 'select', 'checkout/option_cart_redirect', 'Customer will be redirected to selected page after adding item to cart', NULL),
(531, 3, 'orderTotal/subtotal/model', 'Model', 'text', '', '', NULL),
(532, 3, 'orderTotal/shipping/model', 'Model', 'text', '', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_config_value`
--

CREATE TABLE `[[dbprefix]]core_config_value` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `config_field_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` varchar(128) NOT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `config_value_site_id` (`site_id`),
  KEY `FK_config_field_id` (`config_field_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=447 ;

--
-- Dumping data for table `[[dbprefix]]core_config_value`
--

INSERT INTO `[[dbprefix]]core_config_value` VALUES
(1, 3, 'core/store/name', 0, 'Enter store name'),
(2, 4, 'core/store/city', 0, ''),
(3, 5, 'core/store/country', 0, '223'),
(4, 6, 'core/store/zone', 0, '43'),
(5, 7, 'core/store/zip', 0, '10001'),
(6, 8, 'core/store/owner', 0, '[[admin_fname]] [[admin_lname]]'),
(7, 10, 'core/backend/route', 0, 'admin'),
(8, 11, 'core/backend/ssl', 0, ''),
(9, 13, 'core/frontend/ssl', 0, ''),
(10, 15, 'core/company/name', 0, 'Axiscommerce'),
(11, 16, 'core/company/site', 0, 'www.example.com'),
(12, 17, 'core/company/country', 0, '223'),
(13, 18, 'core/company/city', 0, 'New York'),
(14, 19, 'core/company/zone', 0, '43'),
(15, 20, 'core/company/street', 0, 'Enter this your street'),
(16, 21, 'core/company/zip', 0, '10001'),
(17, 22, 'core/company/phone', 0, ''),
(18, 23, 'core/company/fax', 0, ''),
(19, 24, 'core/company/administratorEmail', 0, 'email1'),
(20, 25, 'core/company/customerRelationEmail', 0, 'email3'),
(21, 26, 'core/company/salesDepartmentEmail', 0, 'email4'),
(22, 27, 'core/company/supportEmail', 0, 'email5'),
(23, 29, 'core/cache/default_lifetime', 0, '86400'),
(24, 31, 'core/translation/autodetect', 0, '0'),
(25, 33, 'core/minify/js_front', 0, '0'),
(26, 34, 'core/minify/js_admin', 0, '0'),
(27, 35, 'core/minify/css_front', 0, '0'),
(28, 36, 'core/minify/css_admin', 0, '0'),
(29, 39, 'mail/main/mtcFrom', 0, 'email2'),
(30, 40, 'mail/main/transport', 0, 'sendmail'),
(31, 42, 'mail/smtp/host', 0, 'host.smtp.com'),
(32, 43, 'mail/smtp/user', 0, 'q222JA7V7p5NzKBEXrkkYq8KXMnLnIjc'),
(33, 44, 'mail/smtp/password', 0, 'mwzuk7CgoFw='),
(34, 45, 'mail/smtp/port', 0, '465'),
(35, 46, 'mail/smtp/auth', 0, '1'),
(36, 47, 'mail/smtp/secure', 0, 'ssl'),
(37, 49, 'mail/mailboxes/email1', 0, '[[admin_email]]'),
(38, 50, 'mail/mailboxes/email2', 0, 'notifications@[[domhost]][[relativeurl]]'),
(39, 51, 'mail/mailboxes/email3', 0, 'relations@[[domhost]][[relativeurl]]'),
(40, 52, 'mail/mailboxes/email4', 0, 'sales@[[domhost]][[relativeurl]]'),
(41, 53, 'mail/mailboxes/email5', 0, 'support@[[domhost]][[relativeurl]]'),
(42, 54, 'mail/mailboxes/email6', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(43, 55, 'mail/mailboxes/email7', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(44, 56, 'mail/mailboxes/email8', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(45, 57, 'mail/mailboxes/email9', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(46, 58, 'mail/mailboxes/email10', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(47, 59, 'mail/mailboxes/email11', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(48, 60, 'mail/mailboxes/email12', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(49, 61, 'mail/mailboxes/email13', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(50, 62, 'mail/mailboxes/email14', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(51, 63, 'mail/mailboxes/email15', 0, 'no-reply@[[domhost]][[relativeurl]]'),
(52, 66, 'design/main/frontTemplateId', 0, '2'),
(53, 67, 'design/main/adminTemplateId', 0, '1'),
(54, 69, 'design/htmlHead/defaultTitle', 0, 'Default Title'),
(55, 70, 'design/htmlHead/defaultDescription', 0, 'Default Description'),
(56, 71, 'design/htmlHead/defaultKeywords', 0, 'Axis, store'),
(57, 72, 'design/htmlHead/titlePrefix', 0, ''),
(58, 73, 'design/htmlHead/titleSuffix', 0, ''),
(59, 74, 'design/htmlHead/titleDivider', 0, ' - '),
(60, 75, 'design/htmlHead/titlePattern', 0, 'Page Title,Site Name'),
(61, 76, 'design/htmlHead/defaultRobots', 0, 'INDEX FOLLOW'),
(62, 77, 'design/htmlHead/homeDescription', 0, ''),
(63, 78, 'design/htmlHead/homeKeywords', 0, 'Axis, store'),
(64, 79, 'design/htmlHead/homeTitle', 0, 'Homepage title'),
(65, 81, 'core/session/remoteAddressValidation', 0, '0'),
(66, 82, 'core/session/httpUserAgentValidation', 0, '0'),
(67, 84, 'design/header/logoSrc', 0, 'logo.gif'),
(68, 85, 'design/header/logoAlt', 0, 'Axiscommerce'),
(70, 89, 'locale/main/locale', 0, 'en_US'),
(71, 90, 'locale/main/timezone', 0, 'America/Los_Angeles'),
(72, 91, 'locale/main/baseCurrency', 0, 'USD'),
(73, 92, 'locale/main/currency', 0, 'USD'),
(74, 93, 'locale/main/language_admin', 0, '1'),
(75, 94, 'locale/main/language_front', 0, '1'),
(76, 97, 'shipping/Free_Standard/enabled', 0, ''),
(77, 98, 'shipping/Free_Standard/geozone', 0, '1'),
(78, 99, 'shipping/Free_Standard/taxBasis', 0, 'delivery'),
(79, 100, 'shipping/Free_Standard/taxClass', 0, ''),
(80, 101, 'shipping/Free_Standard/sortOrder', 0, ''),
(81, 102, 'shipping/Free_Standard/handling', 0, ''),
(82, 103, 'shipping/Free_Standard/cost', 0, ''),
(83, 104, 'shipping/Free_Standard/payments', 0, ''),
(84, 105, 'shipping/Free_Standard/minOrderTotal', 0, ''),
(85, 106, 'shipping/Free_Standard/maxOrderTotal', 0, ''),
(86, 109, 'payment/FreeOrder_Standard/enabled', 0, '0'),
(87, 110, 'payment/FreeOrder_Standard/title', 0, 'Free Order'),
(88, 111, 'payment/FreeOrder_Standard/geozone', 0, '1'),
(89, 112, 'payment/FreeOrder_Standard/sortOrder', 0, '1'),
(90, 113, 'payment/FreeOrder_Standard/orderStatusId', 0, '1'),
(91, 114, 'payment/FreeOrder_Standard/shippings', 0, ''),
(92, 115, 'payment/FreeOrder_Standard/minOrderTotal', 0, ''),
(93, 116, 'payment/FreeOrder_Standard/maxOrderTotal', 0, ''),
(94, 118, 'shipping/Pickup_Standard/enabled', 0, '0'),
(95, 119, 'shipping/Pickup_Standard/geozone', 0, '1'),
(96, 120, 'shipping/Pickup_Standard/taxBasis', 0, 'delivery'),
(97, 121, 'shipping/Pickup_Standard/taxClass', 0, ''),
(98, 122, 'shipping/Pickup_Standard/sortOrder', 0, ''),
(99, 123, 'shipping/Pickup_Standard/handling', 0, ''),
(100, 124, 'shipping/Pickup_Standard/price', 0, ''),
(101, 125, 'shipping/Pickup_Standard/payments', 0, ''),
(102, 126, 'shipping/Pickup_Standard/minOrderTotal', 0, ''),
(103, 127, 'shipping/Pickup_Standard/maxOrderTotal', 0, ''),
(104, 129, 'shipping/Ups_Standard/enabled', 0, '0'),
(105, 130, 'shipping/Ups_Standard/geozone', 0, '1'),
(106, 131, 'shipping/Ups_Standard/taxBasis', 0, 'delivery'),
(107, 132, 'shipping/Ups_Standard/taxClass', 0, ''),
(108, 133, 'shipping/Ups_Standard/sortOrder', 0, ''),
(109, 134, 'shipping/Ups_Standard/pickup', 0, '03'),
(110, 135, 'shipping/Ups_Standard/package', 0, '00'),
(111, 136, 'shipping/Ups_Standard/res', 0, '01'),
(112, 137, 'shipping/Ups_Standard/handling', 0, ''),
(113, 138, 'shipping/Ups_Standard/title', 0, 'Ups'),
(114, 139, 'shipping/Ups_Standard/types', 0, '1DM,1DML,1DA,1DAL,1DAPI,1DP,1DPL,2DM,2DML,2DA,2DAL,3DS,GND,GNDCOM,GNDRES,STD,XPR,WXS,XPRL,XDM,XDML,XPD'),
(115, 140, 'shipping/Ups_Standard/boxWeightDisplay', 0, '1'),
(116, 141, 'shipping/Ups_Standard/type', 0, 'CGI'),
(117, 142, 'shipping/Ups_Standard/measure', 0, 'LBS'),
(118, 143, 'shipping/Ups_Standard/payments', 0, ''),
(119, 144, 'shipping/Ups_Standard/gateway', 0, 'http://www.ups.com/using/services/rave/qcostcgi.cgi'),
(120, 145, 'shipping/Ups_Standard/xmlUserId', 0, ''),
(121, 146, 'shipping/Ups_Standard/xmlPassword', 0, ''),
(122, 147, 'shipping/Ups_Standard/xmlAccessLicenseNumber', 0, ''),
(123, 148, 'shipping/Ups_Standard/xmlGateway', 0, 'https://onlinetools.ups.com/ups.app/xml/Rate'),
(124, 149, 'shipping/Ups_Standard/xmlOrigin', 0, 'United States Domestic Shipments'),
(125, 150, 'shipping/Ups_Standard/negotiatedActive', 0, '0'),
(126, 151, 'shipping/Ups_Standard/shipperNumber', 0, ''),
(127, 152, 'shipping/Ups_Standard/minOrderTotal', 0, ''),
(128, 153, 'shipping/Ups_Standard/maxOrderTotal', 0, ''),
(129, 154, 'shipping/Ups_Standard/showErrors', 0, '1'),
(130, 157, 'gbase/main/payment', 0, 'Discover,American Express,VISA,MasterCard,Wire transfer,Check,Cash'),
(131, 158, 'gbase/main/notes', 0, 'Google Checkout'),
(132, 159, 'gbase/main/application', 0, 'StoreArchitect-Axis-0.8.5.1 dev'),
(133, 160, 'gbase/main/dryRun', 0, '0'),
(134, 161, 'gbase/main/link', 0, 'Website'),
(135, 162, 'gbase/main/itemType', 0, 'Products'),
(136, 164, 'gbase/auth/login', 0, ''),
(137, 165, 'gbase/auth/password', 0, ''),
(138, 166, 'gbase/auth/connection', 0, 'AuthSub'),
(139, 169, 'tag/main/customer_status', 0, '1'),
(140, 170, 'tag/main/guest_status', 0, '2'),
(141, 172, 'shipping/Flat_Standard/enabled', 0, '1'),
(142, 173, 'shipping/Flat_Standard/geozone', 0, '1'),
(143, 174, 'shipping/Flat_Standard/taxBasis', 0, 'delivery'),
(144, 175, 'shipping/Flat_Standard/taxClass', 0, ''),
(145, 176, 'shipping/Flat_Standard/sortOrder', 0, ''),
(146, 177, 'shipping/Flat_Standard/multiPrice', 0, '{"standard":{"title":"","price":25,"minOrderTotal":"","maxOrderTotal":99.9999},"discount":{"title":"","price":15,"minOrderTotal":100,"maxOrderTotal":""}}'),
(147, 178, 'shipping/Flat_Standard/type', 0, 'Per Order'),
(148, 179, 'shipping/Flat_Standard/formDesc', 0, 'Flat Rate'),
(149, 180, 'shipping/Flat_Standard/payments', 0, ''),
(150, 182, 'shipping/Item_Standard/enabled', 0, '0'),
(151, 183, 'shipping/Item_Standard/geozone', 0, '1'),
(152, 184, 'shipping/Item_Standard/taxBasis', 0, 'delivery'),
(153, 185, 'shipping/Item_Standard/taxClass', 0, ''),
(154, 186, 'shipping/Item_Standard/sortOrder', 0, ''),
(155, 187, 'shipping/Item_Standard/price', 0, '1'),
(156, 188, 'shipping/Item_Standard/payments', 0, ''),
(157, 189, 'shipping/Item_Standard/minOrderTotal', 0, ''),
(158, 190, 'shipping/Item_Standard/maxOrderTotal', 0, ''),
(159, 193, 'sales/order/defaultStatusId', 0, '1'),
(160, 194, 'sales/order/order_number_pattern_prefix', 0, ''),
(161, 195, 'sales/order/order_number_pattern', 0, '100000000'),
(162, 196, 'sales/order/email', 0, 'email1'),
(163, 198, 'shipping/Fedex_Standard/enabled', 0, '0'),
(164, 199, 'shipping/Fedex_Standard/geozone', 0, '1'),
(165, 200, 'shipping/Fedex_Standard/taxBasis', 0, 'delivery'),
(166, 201, 'shipping/Fedex_Standard/taxClass', 0, ''),
(167, 202, 'shipping/Fedex_Standard/sortOrder', 0, ''),
(168, 203, 'shipping/Fedex_Standard/payments', 0, ''),
(169, 204, 'shipping/Fedex_Standard/title', 0, 'Fedex Express'),
(170, 205, 'shipping/Fedex_Standard/account', 0, ''),
(171, 206, 'shipping/Fedex_Standard/package', 0, 'YOUR_PACKAGING'),
(172, 207, 'shipping/Fedex_Standard/dropoff', 0, 'REGULAR_PICKUP'),
(173, 208, 'shipping/Fedex_Standard/allowedTypes', 0, 'FEDEX_GROUND'),
(174, 209, 'shipping/Fedex_Standard/measure', 0, 'LBS'),
(175, 210, 'shipping/Fedex_Standard/residenceDelivery', 0, '0'),
(176, 211, 'shipping/Fedex_Standard/gateway', 0, 'https://gateway.fedex.com:443/GatewayDC'),
(177, 212, 'shipping/Fedex_Standard/handling', 0, ''),
(178, 213, 'shipping/Fedex_Standard/minOrderTotal', 0, ''),
(179, 214, 'shipping/Fedex_Standard/maxOrderTotal', 0, ''),
(180, 215, 'shipping/Fedex_Standard/showErrors', 0, '1'),
(181, 216, 'shipping/Fedex_Standard/meterNumber', 0, ''),
(182, 217, 'shipping/Fedex_Standard/key', 0, ''),
(183, 218, 'shipping/Fedex_Standard/password', 0, ''),
(184, 220, 'payment/Paypal_Standard/title', 0, 'PayPal Standard'),
(185, 221, 'payment/Paypal_Standard/name', 0, 'Axis Paypal Standard Payment'),
(186, 222, 'payment/Paypal_Standard/email', 0, 'qAJpoW6gGJw='),
(187, 223, 'payment/Paypal_Standard/logo', 0, 'logo.gif'),
(188, 224, 'payment/Paypal_Standard/sandboxMode', 0, '1'),
(189, 225, 'payment/Paypal_Standard/enabled', 0, '0'),
(190, 226, 'payment/Paypal_Standard/paymentAction', 0, 'Sale'),
(191, 227, 'payment/Paypal_Standard/transactionType', 0, 'Aggregate Cart'),
(192, 228, 'payment/Paypal_Standard/geozone', 0, '1'),
(193, 229, 'payment/Paypal_Standard/sortOrder', 0, '1'),
(196, 232, 'payment/Paypal_Standard/orderStatusId', 0, '1'),
(197, 233, 'payment/Paypal_Standard/shippings', 0, ''),
(198, 235, 'payment/Paypal_Direct/title', 0, 'PayPal Direct'),
(199, 236, 'payment/Paypal_Direct/enabled', 0, '0'),
(200, 237, 'payment/Paypal_Direct/geozone', 0, '1'),
(201, 238, 'payment/Paypal_Direct/sortOrder', 0, '1'),
(202, 239, 'payment/Paypal_Direct/orderStatusId', 0, ''),
(203, 240, 'payment/Paypal_Direct/enabledCvv', 0, '1'),
(204, 241, 'payment/Paypal_Direct/creditCard', 0, 'VISA,MASTERCARD,AMERICAN_EXPRESS'),
(205, 242, 'payment/Paypal_Direct/saveCCAction', 0, 'last_four'),
(206, 243, 'payment/Paypal_Direct/saveCvv', 0, ''),
(207, 244, 'payment/Paypal_Direct/server', 0, 'sandbox'),
(208, 245, 'payment/Paypal_Direct/paymentAction', 0, 'Sale'),
(209, 246, 'payment/Paypal_Direct/currency', 0, 'USD'),
(210, 247, 'payment/Paypal_Direct/mode', 0, 'nvp'),
(211, 248, 'payment/Paypal_Direct/shippings', 0, ''),
(212, 250, 'payment/Paypal_Express/title', 0, 'PayPal Express'),
(213, 251, 'payment/Paypal_Express/enabled', 0, '0'),
(214, 252, 'payment/Paypal_Express/server', 0, 'sandbox'),
(215, 253, 'payment/Paypal_Express/mode', 0, 'nvp'),
(216, 254, 'payment/Paypal_Express/orderStatusId', 0, '2'),
(217, 255, 'payment/Paypal_Express/paymentAction', 0, 'Sale'),
(218, 256, 'payment/Paypal_Express/shippings', 0, ''),
(219, 258, 'payment/payflow/pfuser', 0, ''),
(220, 259, 'payment/payflow/pfpartner', 0, 'd/c4RfwC64c='),
(221, 260, 'payment/payflow/pfvendor', 0, ''),
(222, 261, 'payment/payflow/pfpassword', 0, ''),
(223, 263, 'payment/nvp/apiusername', 0, ''),
(224, 264, 'payment/nvp/apipassword', 0, ''),
(225, 265, 'payment/nvp/apisignature', 0, ''),
(226, 266, 'payment/nvp/version', 0, '3.2'),
(227, 267, 'payment/Paypal_Standard/minOrderTotal', 0, ''),
(228, 268, 'payment/Paypal_Standard/maxOrderTotal', 0, ''),
(229, 269, 'payment/Paypal_Direct/minOrderTotal', 0, ''),
(230, 270, 'payment/Paypal_Direct/maxOrderTotal', 0, ''),
(231, 271, 'payment/Paypal_Express/minOrderTotal', 0, ''),
(232, 272, 'payment/Paypal_Express/maxOrderTotal', 0, ''),
(233, 273, 'payment/Paypal_Express/sortOrder', 0, '1'),
(234, 276, 'catalog/main/route', 0, 'store'),
(235, 278, 'catalog/listing/type', 0, 'grid'),
(236, 279, 'catalog/listing/perPage', 0, '6,9,18,32'),
(237, 280, 'catalog/listing/perPageDefault', 0, '9'),
(238, 281, 'catalog/listing/sortBy', 0, 'Name,Price'),
(239, 283, 'catalog/product/hurldelimiter', 0, '-'),
(240, 284, 'catalog/product/seodelimiter', 0, '_'),
(241, 285, 'catalog/product/seodesclength', 0, '100'),
(242, 287, 'catalog/lightzoom/zoomStageWidth', 0, '250'),
(243, 288, 'catalog/lightzoom/zoomStageHeight', 0, '250'),
(244, 289, 'catalog/lightzoom/zoomStagePosition', 0, 'right'),
(245, 290, 'catalog/lightzoom/zoomStageOffsetX', 0, '10'),
(246, 291, 'catalog/lightzoom/zoomStageOffsetY', 0, '0'),
(247, 292, 'catalog/lightzoom/zoomLensOpacity', 0, '0.7'),
(248, 293, 'catalog/lightzoom/zoomCursor', 0, 'crosshair'),
(249, 294, 'catalog/lightzoom/zoomOnTrigger', 0, 'mouseenter'),
(250, 295, 'catalog/lightzoom/zoomOffTrigger', 0, 'mouseleave'),
(251, 296, 'catalog/lightzoom/lightboxTrigger', 0, 'click'),
(252, 297, 'catalog/lightzoom/lightboxResizeSpeed', 0, '800'),
(253, 298, 'catalog/lightzoom/lightboxFadeSpeed', 0, '300'),
(254, 299, 'catalog/lightzoom/lightboxMaskOpacity', 0, '0.8'),
(255, 300, 'catalog/lightzoom/switchImageTrigger', 0, 'click'),
(256, 303, 'image/main/cachePath', 0, '/media/cache'),
(257, 305, 'image/product/cache', 0, '1'),
(258, 306, 'image/product/widthLarge', 0, ''),
(259, 307, 'image/product/heightLarge', 0, ''),
(260, 308, 'image/product/widthMedium', 0, '250'),
(261, 309, 'image/product/heightMedium', 0, '250'),
(262, 310, 'image/product/widthSmall', 0, '150'),
(263, 311, 'image/product/heightSmall', 0, '150'),
(264, 312, 'image/product/widthThumbnail', 0, '40'),
(265, 313, 'image/product/heightThumbnail', 0, '40'),
(266, 315, 'image/watermark/enabled', 0, '0'),
(267, 316, 'image/watermark/image', 0, 'catalog/watermark.png'),
(268, 317, 'image/watermark/position', 0, 'bottom_right'),
(269, 318, 'image/watermark/opacity', 0, '50'),
(270, 319, 'image/watermark/repeat', 0, '0'),
(271, 321, 'shipping/Table_Standard/enabled', 0, '0'),
(272, 322, 'shipping/Table_Standard/geozone', 0, '1'),
(273, 323, 'shipping/Table_Standard/taxBasis', 0, 'delivery'),
(274, 324, 'shipping/Table_Standard/taxClass', 0, ''),
(275, 325, 'shipping/Table_Standard/sortOrder', 0, ''),
(276, 326, 'shipping/Table_Standard/handling', 0, ''),
(277, 327, 'shipping/Table_Standard/type', 0, 'Per Price'),
(278, 328, 'shipping/Table_Standard/payments', 0, ''),
(279, 329, 'shipping/Table_Standard/formDesc', 0, 'Table Rate'),
(280, 332, 'tax/main/taxBasis', 0, 'delivery'),
(281, 334, 'tax/shipping/taxBasis', 0, 'delivery'),
(282, 335, 'tax/shipping/taxClass', 0, '1'),
(283, 338, 'orderTotal/tax/model', 0, 'tax/checkout_total_tax'),
(284, 340, 'orderTotal/shipping_tax/model', 0, 'tax/checkout_total_shippingTax'),
(285, 343, 'sitemap/main/enabled', 0, '0'),
(287, 345, 'sitemap/main/frequency', 0, 'daily'),
(292, 351, 'sitemap/categories/priority', 0, '0.8'),
(293, 352, 'sitemap/categories/frequency', 0, 'daily'),
(294, 354, 'sitemap/products/priority', 0, '0.8'),
(295, 355, 'sitemap/products/frequency', 0, 'daily'),
(296, 357, 'sitemap/cms/priority', 0, '0.5'),
(297, 358, 'sitemap/cms/frequency', 0, 'daily'),
(298, 359, 'sitemap/cms/showPages', 0, '1'),
(299, 362, 'analytics/main/uacct', 0, ''),
(300, 363, 'analytics/main/used', 0, '0'),
(310, 377, 'shipping/Usps_Standard/enabled', 0, '0'),
(311, 378, 'shipping/Usps_Standard/taxClass', 0, ''),
(312, 379, 'shipping/Usps_Standard/taxBasis', 0, 'delivery'),
(313, 380, 'shipping/Usps_Standard/geozone', 0, '1'),
(314, 381, 'shipping/Usps_Standard/handling', 0, '5'),
(315, 382, 'shipping/Usps_Standard/sortOrder', 0, ''),
(316, 383, 'shipping/Usps_Standard/payments', 0, ''),
(317, 384, 'shipping/Usps_Standard/title', 0, 'United States Postal Service'),
(318, 385, 'shipping/Usps_Standard/gateway', 0, 'http://production.shippingapis.com/ShippingAPI.dll'),
(319, 386, 'shipping/Usps_Standard/service', 0, 'ALL'),
(320, 387, 'shipping/Usps_Standard/userId', 0, ''),
(321, 388, 'shipping/Usps_Standard/container', 0, 'VARIABLE'),
(322, 389, 'shipping/Usps_Standard/size', 0, 'REGULAR'),
(323, 390, 'shipping/Usps_Standard/machinable', 0, '1'),
(324, 391, 'shipping/Usps_Standard/allowedMethods', 0, 'First-Class,First-Class Mail International Large Envelope,First-Class Mail International Letter,First-Class Mail International Package,First-Class Mail,First-Class Mail Flat,First-Class Mail Large Envelope,First-Class Mail International,First-Class Mail Letter,First-Class Mail Parcel,First-Class Mail Package,Parcel Post,Bound Printed Matter,Media Mail,Library Mail,Express Mail,Express Mail PO to PO,Express Mail Flat Rate Envelope,Express Mail Flat-Rate Envelope Sunday/Holiday Guarantee,Express Mail Sunday/Holiday Guarantee,Express Mail Flat Rate Envelope Hold For Pickup,Express Mail Hold For Pickup,Global Express Guaranteed (GXG),Global Express Guaranteed Non-Document Rectangular,Global Express Guaranteed Non-Document Non-Rectangular,USPS GXG Envelopes,Express Mail International,Express Mail International Flat Rate Envelope,Priority Mail,Priority Mail Small Flat Rate Box,Priority Mail Medium Flat Rate Box,Priority Mail Large Flat Rate Box,Priority Mail Flat Rate Box,Priority Mail Flat Rate Envelope,Priority Mail International,Priority Mail International Flat Rate Envelope,Priority Mail International Small Flat Rate Box,Priority Mail International Medium Flat Rate Box,Priority Mail International Large Flat Rate Box,Priority Mail International Flat Rate Box'),
(325, 392, 'shipping/Usps_Standard/minOrderTotal', 0, ''),
(326, 393, 'shipping/Usps_Standard/maxOrderTotal', 0, ''),
(327, 394, 'shipping/Usps_Standard/showErrors', 0, '1'),
(328, 396, 'payment/AuthorizenetAim_Standard/enabled', 0, '0'),
(329, 397, 'payment/AuthorizenetAim_Standard/title', 0, 'Authorize.Net'),
(330, 398, 'payment/AuthorizenetAim_Standard/shippings', 0, ''),
(331, 399, 'payment/AuthorizenetAim_Standard/creditCard', 0, 'VISA,MASTERCARD,AMERICAN_EXPRESS'),
(332, 400, 'payment/AuthorizenetAim_Standard/geozone', 0, '1'),
(333, 401, 'payment/AuthorizenetAim_Standard/sortOrder', 0, '1'),
(334, 402, 'payment/AuthorizenetAim_Standard/orderStatusId', 0, '2'),
(336, 404, 'payment/AuthorizenetAim_Standard/xLogin', 0, ''),
(337, 405, 'payment/AuthorizenetAim_Standard/xTransactionKey', 0, ''),
(338, 406, 'payment/AuthorizenetAim_Standard/gateway', 0, 'https://test.authorize.net/gateway/transact.dll'),
(339, 407, 'payment/AuthorizenetAim_Standard/emailCustomer', 0, '0'),
(340, 408, 'payment/AuthorizenetAim_Standard/emailMerchant', 0, ''),
(341, 409, 'payment/AuthorizenetAim_Standard/test', 0, '0'),
(342, 410, 'payment/AuthorizenetAim_Standard/minOrderTotal', 0, ''),
(343, 411, 'payment/AuthorizenetAim_Standard/maxOrderTotal', 0, ''),
(344, 412, 'payment/AuthorizenetAim_Standard/authorizationType', 0, 'authorize'),
(345, 414, 'shipping/PerWeightUnit_Standard/enabled', 0, '0'),
(346, 415, 'shipping/PerWeightUnit_Standard/geozone', 0, '1'),
(347, 416, 'shipping/PerWeightUnit_Standard/taxBasis', 0, 'delivery'),
(348, 417, 'shipping/PerWeightUnit_Standard/taxClass', 0, ''),
(349, 418, 'shipping/PerWeightUnit_Standard/sortOrder', 0, ''),
(350, 419, 'shipping/PerWeightUnit_Standard/handling', 0, ''),
(351, 420, 'shipping/PerWeightUnit_Standard/price', 0, '1'),
(352, 421, 'shipping/PerWeightUnit_Standard/payments', 0, ''),
(353, 422, 'shipping/PerWeightUnit_Standard/minOrderTotal', 0, ''),
(354, 423, 'shipping/PerWeightUnit_Standard/maxOrderTotal', 0, ''),
(355, 424, 'locale/main/addressFormat', 0, '1'),
(356, 426, 'payment/CheckMoney_Standard/enabled', 0, '0'),
(357, 427, 'payment/CheckMoney_Standard/title', 0, 'Check & Money Order'),
(358, 428, 'payment/CheckMoney_Standard/geozone', 0, '1'),
(359, 429, 'payment/CheckMoney_Standard/sortOrder', 0, '1'),
(360, 430, 'payment/CheckMoney_Standard/orderStatusId', 0, '1'),
(361, 431, 'payment/CheckMoney_Standard/minOrderTotal', 0, ''),
(362, 432, 'payment/CheckMoney_Standard/maxOrderTotal', 0, ''),
(363, 433, 'payment/CheckMoney_Standard/payTo', 0, 'The Axis Store Company'),
(364, 434, 'payment/CheckMoney_Standard/sendCheckTo', 0, 'Store Name <br />Address <br />Country <br />Phone'),
(365, 435, 'payment/CheckMoney_Standard/shippings', 0, ''),
(366, 438, 'account/main/defaultCustomerGroup', 0, '1'),
(367, 440, 'account/address_form/company_status', 0, 'optional'),
(368, 441, 'account/address_form/company_sort_order', 0, '10'),
(369, 442, 'account/address_form/phone_status', 0, 'required'),
(370, 443, 'account/address_form/phone_sort_order', 0, '20'),
(371, 444, 'account/address_form/fax_status', 0, 'optional'),
(372, 445, 'account/address_form/fax_sort_order', 0, '30'),
(373, 446, 'account/address_form/street_address_status', 0, 'required'),
(374, 447, 'account/address_form/street_address_sort_order', 0, '40'),
(375, 448, 'account/address_form/city_status', 0, 'required'),
(376, 449, 'account/address_form/city_sort_order', 0, '50'),
(377, 450, 'account/address_form/zone_id_status', 0, 'required'),
(378, 451, 'account/address_form/zone_id_sort_order', 0, '60'),
(379, 452, 'account/address_form/postcode_status', 0, 'required'),
(380, 453, 'account/address_form/postcode_sort_order', 0, '70'),
(381, 454, 'account/address_form/country_id_status', 0, 'required'),
(382, 455, 'account/address_form/country_id_sort_order', 0, '80'),
(383, 456, 'account/address_form/country_id_allow', 0, '0'),
(384, 457, 'account/address_form/company_value', 0, ''),
(385, 458, 'account/address_form/phone_value', 0, ''),
(386, 459, 'account/address_form/fax_value', 0, ''),
(387, 460, 'account/address_form/street_address_value', 0, ''),
(388, 461, 'account/address_form/city_value', 0, ''),
(389, 462, 'account/address_form/zone_id_value', 0, '12'),
(390, 463, 'account/address_form/postcode_value', 0, '90064'),
(391, 464, 'account/address_form/country_id_value', 0, '223'),
(392, 467, 'community/review/enabled', 0, '1'),
(393, 468, 'community/review/rating_enabled', 0, '1'),
(394, 469, 'community/review/rating_title', 0, '1'),
(395, 470, 'community/review/merge_average', 0, '1'),
(396, 471, 'community/review/customer_status', 0, 'pending'),
(397, 472, 'community/review/guest_status', 0, 'pending'),
(398, 473, 'community/review/guest_permission', 0, '1'),
(399, 474, 'community/review/perPage', 0, '10,25,50,all'),
(400, 475, 'community/review/perPageDefault', 0, '10'),
(401, 477, 'payment/CreditCard_Standard/title', 0, 'Save Credit Card'),
(402, 478, 'payment/CreditCard_Standard/enabled', 0, '0'),
(403, 479, 'payment/CreditCard_Standard/geozone', 0, '1'),
(404, 480, 'payment/CreditCard_Standard/sortOrder', 0, '1'),
(405, 481, 'payment/CreditCard_Standard/orderStatusId', 0, '1'),
(406, 482, 'payment/CreditCard_Standard/enabledCvv', 0, '1'),
(407, 483, 'payment/CreditCard_Standard/saveCvv', 0, '0'),
(408, 484, 'payment/CreditCard_Standard/minOrderTotal', 0, ''),
(409, 485, 'payment/CreditCard_Standard/maxOrderTotal', 0, ''),
(410, 486, 'payment/CreditCard_Standard/creditCard', 0, 'VISA,MASTERCARD,AMERICAN_EXPRESS'),
(411, 487, 'payment/CreditCard_Standard/saveCCAction', 0, 'last_four'),
(412, 488, 'payment/CreditCard_Standard/shippings', 0, ''),
(413, 490, 'payment/CashOnDelivery_Standard/enabled', 0, '1'),
(414, 491, 'payment/CashOnDelivery_Standard/title', 0, 'Cash On Delivery'),
(415, 492, 'payment/CashOnDelivery_Standard/geozone', 0, '1'),
(416, 493, 'payment/CashOnDelivery_Standard/sortOrder', 0, '1'),
(417, 494, 'payment/CashOnDelivery_Standard/orderStatusId', 0, '1'),
(418, 495, 'payment/CashOnDelivery_Standard/shippings', 0, ''),
(419, 496, 'payment/CashOnDelivery_Standard/minOrderTotal', 0, ''),
(420, 497, 'payment/CashOnDelivery_Standard/maxOrderTotal', 0, ''),
(421, 500, 'log/main/enabled', 0, '1'),
(422, 501, 'log/main/php', 0, '/var/logs/php.log'),
(423, 502, 'log/main/payment', 0, '/var/logs/payment.log'),
(424, 503, 'log/main/shipping', 0, '/var/logs/shipping.log'),
(425, 505, 'orderTotal/subtotal/enabled', 0, '1'),
(426, 506, 'orderTotal/subtotal/sortOrder', 0, '10'),
(427, 508, 'orderTotal/shipping/enabled', 0, '1'),
(428, 509, 'orderTotal/shipping/sortOrder', 0, '20'),
(429, 510, 'orderTotal/tax/enabled', 0, '1'),
(430, 511, 'orderTotal/tax/sortOrder', 0, '30'),
(431, 512, 'orderTotal/shipping_tax/enabled', 0, '1'),
(432, 513, 'orderTotal/shipping_tax/sortOrder', 0, '40'),
(433, 516, 'checkout/address_form/custom_fields_display_mode', 0, 'all'),
(434, 517, 'checkout/address_form/shipping_address_enabled', 0, '1'),
(438, 522, 'checkout/default_values/shipping_method', 0, 'Flat_Standard_standard'),
(439, 523, 'checkout/default_values/payment_method', 0, 'CashOnDelivery_Standard'),
(440, 525, 'checkout/onestep_ajax/billing_address', 0, '1'),
(441, 526, 'checkout/onestep_ajax/delivery_address', 0, '1'),
(442, 527, 'checkout/onestep_ajax/shipping_method', 0, '1'),
(443, 528, 'checkout/onestep_ajax/payment_method', 0, '1'),
(444, 530, 'checkout/cart/redirect', 0, 'checkout/onestep'),
(445, 531, 'orderTotal/subtotal/model', 0, 'checkout/total_subtotal'),
(446, 532, 'orderTotal/shipping/model', 0, 'checkout/total_shipping');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_module`
--

CREATE TABLE `[[dbprefix]]core_module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `package` varchar(64) NOT NULL,
  `code` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `version` varchar(10) NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=39 ;

--
-- Dumping data for table `[[dbprefix]]core_module`
--

INSERT INTO `[[dbprefix]]core_module` VALUES
(1, 'Axis_Core', 'Axis_Core', 'Core', '0.3.0', 1),
(2, 'Axis_Locale', 'Axis_Locale', 'Locale', '0.1.7', 1),
(3, 'Axis_Shipping', 'Axis_ShippingFree', 'Free Shipping Method', '0.1.1', 1),
(4, 'Axis_Payment', 'Axis_PaymentFreeOrder', 'Free Order', '0.1.2', 1),
(5, 'Axis_Search', 'Axis_Search', 'Search', '0.1.4', 1),
(6, 'Axis_Shipping', 'Axis_ShippingPickup', 'Shipping Pickup', '0.1.1', 1),
(7, 'Axis_Shipping', 'Axis_ShippingUps', 'Shipping Ups', '0.1.3', 1),
(8, 'Axis_Cms', 'Axis_Cms', 'Cms', '0.1.6', 1),
(9, 'Axis_GoogleBase', 'Axis_GoogleBase', 'Google Base', '0.1.3', 1),
(10, 'Axis_Tag', 'Axis_Tag', 'Tag', '0.1.6', 1),
(11, 'Axis_Shipping', 'Axis_ShippingFlat', 'Flat', '0.1.1', 1),
(12, 'Axis_Shipping', 'Axis_ShippingItem', 'Item Shipping Method', '0.1.1', 1),
(13, 'Axis_Admin', 'Axis_Admin', 'Backend', '0.1.4', 1),
(14, 'Axis_Sales', 'Axis_Sales', 'Sales', '0.2.5', 1),
(15, 'Axis_Shipping', 'Axis_ShippingFedex', 'Fedex Shipping Methods', '0.1.4', 1),
(16, 'Axis_Payment', 'Axis_PaymentPaypal', 'Paypal', '0.1.4', 1),
(17, 'Axis_Catalog', 'Axis_Catalog', 'Catalog', '0.3.1', 1),
(18, 'Axis_Shipping', 'Axis_ShippingTable', 'Table', '0.1.3', 1),
(19, 'Axis_Poll', 'Axis_Poll', 'Poll', '0.1.3', 1),
(20, 'Axis_Install', 'Axis_Install', 'Install', '0.1.0', 1),
(21, 'Axis_Tax', 'Axis_Tax', 'Tax', '0.1.4', 1),
(22, 'Axis_Sitemap', 'Axis_Sitemap', 'Sitemap', '0.1.4', 1),
(23, 'Axis_GoogleAnalytics', 'Axis_GoogleAnalytics', 'GoogleAnalytics', '0.1.1', 1),
(24, 'Axis_Shipping', 'Axis_ShippingUsps', 'Shipping Usps', '0.1.3', 1),
(25, 'Axis_Payment', 'Axis_PaymentAuthorizenetAim', 'AuthorizenetAim', '0.1.3', 1),
(26, 'Axis_Discount', 'Axis_Discount', 'Discount', '0.0.3', 1),
(27, 'Axis_Shipping', 'Axis_ShippingPerWeightUnit', 'Shipping Per Weight Unit', '0.1.1', 1),
(28, 'Axis_Location', 'Axis_Location', 'Location', '0.1.7', 1),
(29, 'Axis_Payment', 'Axis_PaymentCheckMoney', 'Check Money', '0.1.1', 1),
(30, 'Axis_Contacts', 'Axis_Contacts', 'Contacts', '0.1.4', 1),
(31, 'Axis_Account', 'Axis_Account', 'Account', '0.2.9', 1),
(32, 'Axis_Community', 'Axis_Community', 'Community', '0.1.4', 1),
(33, 'Axis_Payment', 'Axis_PaymentCreditCard', 'Save Credit Card Number', '0.1.2', 1),
(34, 'Axis_Catalog', 'Axis_Csv', 'Csv import/export', '0.1.2', 1),
(35, 'Axis_Payment', 'Axis_PaymentCashOnDelivery', 'Cash On Delivery', '0.1.2', 1),
(36, 'Axis_Import', 'Axis_Import', 'Oscommerce import', '0.1.2', 1),
(37, 'Axis_Log', 'Axis_Log', 'Log', '0.1.4', 1),
(38, 'Axis_Checkout', 'Axis_Checkout', 'Checkout', '0.2.8', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_module_upgrade`
--

CREATE TABLE `[[dbprefix]]core_module_upgrade` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(10) unsigned NOT NULL,
  `version` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_module_id` (`module_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=176 ;

--
-- Dumping data for table `[[dbprefix]]core_module_upgrade`
--

INSERT INTO `[[dbprefix]]core_module_upgrade` VALUES
(1, 1, '0.1.7'),
(2, 1, '0.1.8'),
(3, 1, '0.1.9'),
(4, 1, '0.2.0'),
(5, 1, '0.2.1'),
(6, 1, '0.2.2'),
(7, 1, '0.2.3'),
(8, 1, '0.2.4'),
(9, 1, '0.2.5'),
(10, 1, '0.2.6'),
(11, 1, '0.2.7'),
(12, 1, '0.2.8'),
(13, 1, '0.2.9'),
(14, 1, '0.3.0'),
(15, 2, '0.1.3'),
(16, 2, '0.1.4'),
(17, 2, '0.1.5'),
(18, 2, '0.1.6'),
(19, 2, '0.1.7'),
(20, 3, '0.1.0'),
(21, 3, '0.1.1'),
(22, 4, '0.1.0'),
(23, 4, '0.1.1'),
(24, 4, '0.1.2'),
(25, 5, '0.1.2'),
(26, 5, '0.1.3'),
(27, 5, '0.1.4'),
(28, 6, '0.1.0'),
(29, 6, '0.1.1'),
(30, 7, '0.1.0'),
(31, 7, '0.1.1'),
(32, 7, '0.1.2'),
(33, 7, '0.1.3'),
(34, 8, '0.1.1'),
(35, 8, '0.1.2'),
(36, 8, '0.1.3'),
(37, 8, '0.1.4'),
(38, 8, '0.1.5'),
(39, 8, '0.1.6'),
(40, 9, '0.1.0'),
(41, 9, '0.1.1'),
(42, 9, '0.1.2'),
(43, 9, '0.1.3'),
(44, 10, '0.1.1'),
(45, 10, '0.1.2'),
(46, 10, '0.1.3'),
(47, 10, '0.1.4'),
(48, 10, '0.1.5'),
(49, 10, '0.1.6'),
(50, 11, '0.1.0'),
(51, 11, '0.1.1'),
(52, 12, '0.1.0'),
(53, 12, '0.1.1'),
(54, 13, '0.1.0'),
(55, 13, '0.1.1'),
(56, 13, '0.1.2'),
(57, 13, '0.1.3'),
(58, 13, '0.1.4'),
(59, 14, '0.1.7'),
(60, 14, '0.1.8'),
(61, 14, '0.1.9'),
(62, 14, '0.2.0'),
(63, 14, '0.2.1'),
(64, 14, '0.2.2'),
(65, 14, '0.2.3'),
(66, 14, '0.2.4'),
(67, 14, '0.2.5'),
(68, 15, '0.1.0'),
(69, 15, '0.1.1'),
(70, 15, '0.1.2'),
(71, 15, '0.1.3'),
(72, 15, '0.1.4'),
(73, 16, '0.1.0'),
(74, 16, '0.1.1'),
(75, 16, '0.1.2'),
(76, 16, '0.1.3'),
(77, 16, '0.1.4'),
(78, 17, '0.2.3'),
(79, 17, '0.2.4'),
(80, 17, '0.2.5'),
(81, 17, '0.2.6'),
(82, 17, '0.2.7'),
(83, 17, '0.2.8'),
(84, 17, '0.2.9'),
(85, 17, '0.3.0'),
(86, 17, '0.3.1'),
(87, 18, '0.1.2'),
(88, 18, '0.1.3'),
(89, 19, '0.1.1'),
(90, 19, '0.1.2'),
(91, 19, '0.1.3'),
(92, 20, '0.1.0'),
(93, 21, '0.1.0'),
(94, 21, '0.1.1'),
(95, 21, '0.1.2'),
(96, 21, '0.1.3'),
(97, 21, '0.1.4'),
(98, 22, '0.1.0'),
(99, 22, '0.1.1'),
(100, 22, '0.1.2'),
(101, 22, '0.1.3'),
(102, 22, '0.1.4'),
(103, 23, '0.1.0'),
(104, 23, '0.1.1'),
(105, 24, '0.1.0'),
(106, 24, '0.1.1'),
(107, 24, '0.1.2'),
(108, 24, '0.1.3'),
(109, 25, '0.1.0'),
(110, 25, '0.1.1'),
(111, 25, '0.1.2'),
(112, 25, '0.1.3'),
(113, 26, '0.0.1'),
(114, 26, '0.0.2'),
(115, 26, '0.0.3'),
(116, 27, '0.1.0'),
(117, 27, '0.1.1'),
(118, 28, '0.1.2'),
(119, 28, '0.1.3'),
(120, 28, '0.1.4'),
(121, 28, '0.1.5'),
(122, 28, '0.1.6'),
(123, 28, '0.1.7'),
(124, 29, '0.1.0'),
(125, 29, '0.1.1'),
(126, 30, '0.1.0'),
(127, 30, '0.1.1'),
(128, 30, '0.1.2'),
(129, 30, '0.1.3'),
(130, 30, '0.1.4'),
(131, 31, '0.1.6'),
(132, 31, '0.1.7'),
(133, 31, '0.1.8'),
(134, 31, '0.1.9'),
(135, 31, '0.2.0'),
(136, 31, '0.2.1'),
(137, 31, '0.2.2'),
(138, 31, '0.2.3'),
(139, 31, '0.2.4'),
(140, 31, '0.2.5'),
(141, 31, '0.2.6'),
(142, 31, '0.2.7'),
(143, 31, '0.2.8'),
(144, 31, '0.2.9'),
(145, 32, '0.1.0'),
(146, 32, '0.1.1'),
(147, 32, '0.1.2'),
(148, 32, '0.1.3'),
(149, 32, '0.1.4'),
(150, 33, '0.1.1'),
(151, 33, '0.1.2'),
(152, 34, '0.1.0'),
(153, 34, '0.1.1'),
(154, 34, '0.1.2'),
(155, 35, '0.1.0'),
(156, 35, '0.1.1'),
(157, 35, '0.1.2'),
(158, 36, '0.1.0'),
(159, 36, '0.1.1'),
(160, 36, '0.1.2'),
(161, 37, '0.1.1'),
(162, 37, '0.1.2'),
(163, 37, '0.1.3'),
(164, 37, '0.1.4'),
(165, 38, '0.1.2'),
(166, 38, '0.1.3'),
(167, 38, '0.2.0'),
(168, 38, '0.2.1'),
(169, 38, '0.2.2'),
(170, 38, '0.2.3'),
(171, 38, '0.2.4'),
(172, 38, '0.2.5'),
(173, 38, '0.2.6'),
(174, 38, '0.2.7'),
(175, 38, '0.2.8');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_page`
--

CREATE TABLE `[[dbprefix]]core_page` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module_name` varchar(64) NOT NULL,
  `controller_name` varchar(64) NOT NULL,
  `action_name` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY USING BTREE (`id`),
  KEY `i_page_1` (`module_name`,`controller_name`,`action_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]core_page`
--

INSERT INTO `[[dbprefix]]core_page` VALUES
(1, '*', '*', '*'),
(30, 'account', '*', '*'),
(36, 'account', 'address-book', '*'),
(31, 'account', 'auth', '*'),
(32, 'account', 'forgot', '*'),
(50, 'account', 'index', 'index'),
(33, 'account', 'info', '*'),
(35, 'account', 'wishlist', '*'),
(16, 'catalog', '*', '*'),
(17, 'catalog', 'index', '*'),
(18, 'catalog', 'index', 'product'),
(19, 'catalog', 'index', 'view'),
(20, 'catalog', 'product-compare', '*'),
(21, 'catalog', 'product-compare', 'index'),
(43, 'checkout', '*', '*'),
(44, 'checkout', 'cart', '*'),
(45, 'checkout', 'cart', 'index'),
(48, 'checkout', 'index', 'success'),
(49, 'checkout', 'onestep', '*'),
(9, 'cms', '*', '*'),
(37, 'community', '*', '*'),
(38, 'community', 'review', '*'),
(42, 'community', 'review', 'customer'),
(40, 'community', 'review', 'detail'),
(39, 'community', 'review', 'index'),
(41, 'community', 'review', 'product'),
(29, 'contacts', '*', '*'),
(3, 'core', 'error', '*'),
(4, 'core', 'error', 'not-found'),
(2, 'core', 'index', 'index'),
(15, 'paymentpaypal', '*', '*'),
(22, 'poll', '*', '*'),
(5, 'search', '*', '*'),
(6, 'search', 'index', '*'),
(7, 'search', 'index', 'index'),
(8, 'search', 'index', 'result'),
(23, 'sitemap', '*', '*'),
(24, 'sitemap', 'index', '*'),
(26, 'sitemap', 'index', 'get-all-categories'),
(28, 'sitemap', 'index', 'get-all-pages'),
(27, 'sitemap', 'index', 'get-all-products'),
(25, 'sitemap', 'index', 'index'),
(10, 'tag', '*', '*'),
(13, 'tag', 'account', '*'),
(11, 'tag', 'index', '*'),
(14, 'tag', 'index', 'index'),
(12, 'tag', 'index', 'show-products');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_site`
--

CREATE TABLE `[[dbprefix]]core_site` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `base` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `secure` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `i_base_url` USING BTREE (`base`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]core_site`
--

INSERT INTO `[[dbprefix]]core_site` VALUES
(1, '[[softurl]]', '[[domhost]][[relativeurl]]', '[[softurl]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_template`
--

CREATE TABLE `[[dbprefix]]core_template` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `default_layout` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]core_template`
--

INSERT INTO `[[dbprefix]]core_template` VALUES
(1, 'default', 'layout_3columns'),
(2, 'custom', 'layout_3columns');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_template_box`
--

CREATE TABLE `[[dbprefix]]core_template_box` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` mediumint(8) unsigned NOT NULL,
  `block` varchar(64) NOT NULL DEFAULT 'content',
  `class` varchar(64) NOT NULL,
  `sort_order` tinyint(3) NOT NULL DEFAULT '100',
  `config` text NOT NULL,
  `box_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `template_boxes_FK_template` (`template_id`),
  KEY `i_box_order` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=71 ;

--
-- Dumping data for table `[[dbprefix]]core_template_box`
--

INSERT INTO `[[dbprefix]]core_template_box` VALUES
(1, 1, 'left', 'Axis_Locale_Currency', 10, '{}', 1),
(2, 1, 'left', 'Axis_Account_Navigation', 10, '{}', 1),
(3, 1, 'content', 'Axis_Account_AddressBook', 127, '{}', 1),
(4, 1, 'content', 'Axis_Account_Wishlist', 127, '{}', 1),
(5, 1, 'right', 'Axis_Catalog_Compare', 70, '{}', 1),
(6, 1, 'left', 'Axis_Catalog_Filters', 70, '{}', 1),
(7, 1, 'content', 'Axis_Catalog_New', 30, '{"products_count":2,"title":"New products","columns_count":2,"template":"catalog/box/highlight/grid.wide.phtml","tab_container":"home"}', 1),
(8, 1, 'content', 'Axis_Catalog_Featured', 100, '{"products_count":3,"columns_count":3,"title":"Store hottest products","template":"catalog/box/highlight/listing.phtml"}', 1),
(9, 1, 'right', 'Axis_Catalog_Manufacturer', 100, '{}', 1),
(10, 1, 'content', 'Axis_Catalog_Product', 20, '{"tab_container":"product-info"}', 1),
(11, 1, 'left', 'Axis_Cms_Navigation', 100, '{"disable_wrapper":1}', 1),
(12, 1, 'header', 'Axis_Cms_Block_header_links', 100, '{"disable_wrapper":1}', 1),
(13, 1, 'content', 'Axis_Community_ReviewProduct', 30, '{"tab_container":"product-info"}', 1),
(14, 1, 'content', 'Axis_Discount_Special', 10, '{"products_count":2,"title":"Season sale","columns_count":2,"template":"catalog/box/highlight/grid.wide.phtml","tab_container":"home"}', 1),
(15, 1, 'beforeBodyEnd', 'Axis_GoogleAnalytics_Ga', 100, '{}', 1),
(16, 1, 'content', 'Axis_PaymentPaypal_ExpressButton', 100, '{}', 1),
(17, 1, 'right', 'Axis_Poll_Poll', 110, '{}', 1),
(18, 1, 'content', 'Axis_Sales_Recent', 100, '{}', 1),
(19, 1, 'header', 'Axis_Search_Search', 100, '{"disable_wrapper":1}', 1),
(20, 1, 'content', 'Axis_Search_Search', 100, '{}', 1),
(21, 1, 'content', 'Axis_Tag_Product', 100, '{"tab_container":"product-info"}', 1),
(22, 1, 'content', 'Axis_Tag_Account', 110, '{}', 1),
(23, 1, 'header', 'Axis_Catalog_Navigation', 127, '{"disable_wrapper":1,"template":"catalog/box/navigationTop.phtml"}', 1),
(24, 1, 'right', 'Axis_Checkout_Cart', 50, '{}', 1),
(25, 1, 'content', 'Axis_Cms_Block_about_us', 50, '{"title":"About Us","class":"box-about-us","tab_container":"home"}', 1),
(26, 1, 'beforeContent', 'Axis_Cms_Block_home.banner', 10, '{}', 1),
(27, 1, 'right', 'Axis_Cms_Block_sidebar.banner', 60, '{}', 1),
(28, 1, 'left', 'Axis_Checkout_Cart', 50, '{}', 1),
(29, 1, 'content', 'Axis_Catalog_Bestseller', 40, '{"products_count":2,"title":"Bestsellers","columns_count":2,"template":"catalog/box/highlight/grid.wide.phtml","tab_container":"home"}', 1),
(30, 1, 'right', 'Axis_Catalog_Popular', 10, '{"products_count":5,"title":"Popular products","template":"catalog/box/highlight/sidebar.phtml"}', 1),
(31, 1, 'right', 'Axis_Account_Wishlist', 100, '{"template":"account/box/wishlist/sidebar.phtml"}', 1),
(32, 1, 'left', 'Axis_Tag_Cloud', 100, '{}', 1),
(33, 1, 'beforeContent', 'Axis_Core_Breadcrumbs', 100, '{"template":""}', 1),
(34, 1, 'right', 'Axis_Catalog_RecentlyViewed', 20, '{"template":"catalog/box/recentlyViewed.phtml","products_count":15}', 1),
(35, 1, 'content', 'Axis_Catalog_Related', 110, '{"template":"catalog\\/box\\/highlight\\/listing.phtml","tab_container":"product-info"}', 1),
(36, 2, 'left', 'Axis_Locale_Currency', 10, '{}', 1),
(37, 2, 'left', 'Axis_Account_Navigation', 10, '{}', 1),
(38, 2, 'content', 'Axis_Account_AddressBook', 127, '{}', 1),
(39, 2, 'content', 'Axis_Account_Wishlist', 127, '{}', 1),
(40, 2, 'right', 'Axis_Catalog_Compare', 70, '{}', 1),
(41, 2, 'left', 'Axis_Catalog_Filters', 70, '{}', 1),
(42, 2, 'content', 'Axis_Catalog_New', 30, '{"products_count":2,"title":"New products","columns_count":2,"template":"catalog/box/highlight/grid.wide.phtml","tab_container":"home"}', 1),
(43, 2, 'content', 'Axis_Catalog_Featured', 100, '{"products_count":3,"columns_count":3,"title":"Store hottest products","template":"catalog/box/highlight/listing.phtml"}', 1),
(44, 2, 'right', 'Axis_Catalog_Manufacturer', 100, '{}', 1),
(45, 2, 'content', 'Axis_Catalog_Product', 20, '{"tab_container":"product-info"}', 1),
(46, 2, 'left', 'Axis_Cms_Navigation', 100, '{"disable_wrapper":1}', 1),
(47, 2, 'header', 'Axis_Cms_Block_header_links', 100, '{"disable_wrapper":1}', 1),
(48, 2, 'content', 'Axis_Community_ReviewProduct', 30, '{"tab_container":"product-info"}', 1),
(49, 2, 'content', 'Axis_Discount_Special', 10, '{"products_count":2,"title":"Season sale","columns_count":2,"template":"catalog/box/highlight/grid.wide.phtml","tab_container":"home"}', 1),
(50, 2, 'beforeBodyEnd', 'Axis_GoogleAnalytics_Ga', 100, '{}', 1),
(51, 2, 'content', 'Axis_PaymentPaypal_ExpressButton', 100, '{}', 1),
(52, 2, 'right', 'Axis_Poll_Poll', 110, '{}', 1),
(53, 2, 'content', 'Axis_Sales_Recent', 100, '{}', 1),
(54, 2, 'header', 'Axis_Search_Search', 100, '{"disable_wrapper":1}', 1),
(55, 2, 'content', 'Axis_Search_Search', 100, '{}', 1),
(56, 2, 'content', 'Axis_Tag_Product', 100, '{"tab_container":"product-info"}', 1),
(57, 2, 'content', 'Axis_Tag_Account', 110, '{}', 1),
(58, 2, 'header', 'Axis_Catalog_Navigation', 127, '{"disable_wrapper":1,"template":"catalog/box/navigationTop.phtml"}', 1),
(59, 2, 'right', 'Axis_Checkout_Cart', 50, '{}', 1),
(60, 2, 'content', 'Axis_Cms_Block_about_us', 50, '{"title":"About Us","class":"box-about-us","tab_container":"home"}', 1),
(61, 2, 'beforeContent', 'Axis_Cms_Block_home.banner', 10, '{}', 1),
(62, 2, 'right', 'Axis_Cms_Block_sidebar.banner', 60, '{}', 1),
(63, 2, 'left', 'Axis_Checkout_Cart', 50, '{}', 1),
(64, 2, 'content', 'Axis_Catalog_Bestseller', 40, '{"products_count":2,"title":"Bestsellers","columns_count":2,"template":"catalog/box/highlight/grid.wide.phtml","tab_container":"home"}', 1),
(65, 2, 'right', 'Axis_Catalog_Popular', 10, '{"products_count":5,"title":"Popular products","template":"catalog/box/highlight/sidebar.phtml"}', 1),
(66, 2, 'right', 'Axis_Account_Wishlist', 100, '{"template":"account/box/wishlist/sidebar.phtml"}', 1),
(67, 2, 'left', 'Axis_Tag_Cloud', 100, '{}', 1),
(68, 2, 'beforeContent', 'Axis_Core_Breadcrumbs', 100, '{"template":""}', 1),
(69, 2, 'right', 'Axis_Catalog_RecentlyViewed', 20, '{"template":"catalog/box/recentlyViewed.phtml","products_count":15}', 1),
(70, 2, 'content', 'Axis_Catalog_Related', 110, '{"template":"catalog\\/box\\/highlight\\/listing.phtml","tab_container":"product-info"}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_template_box_page`
--

CREATE TABLE `[[dbprefix]]core_template_box_page` (
  `box_id` mediumint(8) unsigned NOT NULL,
  `page_id` mediumint(8) unsigned NOT NULL,
  `box_show` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `template` varchar(64) DEFAULT NULL,
  `block` varchar(32) DEFAULT NULL,
  `tab_container` varchar(64) DEFAULT NULL,
  `sort_order` tinyint(3) DEFAULT NULL,
  PRIMARY KEY (`box_id`,`page_id`),
  KEY `FK_core_template_box_page_page_id` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]core_template_box_page`
--

INSERT INTO `[[dbprefix]]core_template_box_page` VALUES
(1, 1, 1, NULL, NULL, NULL, NULL),
(1, 30, 0, NULL, NULL, NULL, NULL),
(2, 30, 1, NULL, NULL, NULL, NULL),
(3, 50, 1, NULL, NULL, NULL, NULL),
(4, 50, 1, NULL, NULL, NULL, NULL),
(5, 1, 1, NULL, NULL, NULL, NULL),
(5, 20, 0, NULL, NULL, NULL, NULL),
(6, 16, 1, NULL, NULL, NULL, NULL),
(6, 18, 0, NULL, NULL, NULL, NULL),
(6, 20, 0, NULL, NULL, NULL, NULL),
(7, 2, 1, NULL, NULL, NULL, NULL),
(8, 2, 1, NULL, NULL, NULL, NULL),
(9, 19, 1, NULL, NULL, NULL, NULL),
(10, 18, 1, NULL, NULL, NULL, NULL),
(11, 1, 1, NULL, NULL, NULL, NULL),
(11, 18, 0, NULL, NULL, NULL, NULL),
(11, 30, 0, NULL, NULL, NULL, NULL),
(12, 1, 1, NULL, NULL, NULL, NULL),
(13, 18, 1, NULL, NULL, NULL, NULL),
(14, 2, 1, NULL, NULL, NULL, NULL),
(15, 1, 1, NULL, NULL, NULL, NULL),
(16, 45, 1, NULL, NULL, NULL, NULL),
(17, 1, 1, NULL, NULL, NULL, NULL),
(18, 50, 1, NULL, NULL, NULL, NULL),
(19, 1, 1, NULL, NULL, NULL, NULL),
(20, 7, 1, NULL, NULL, NULL, NULL),
(21, 18, 1, NULL, NULL, NULL, NULL),
(22, 50, 1, NULL, NULL, NULL, NULL),
(23, 1, 1, NULL, NULL, NULL, NULL),
(24, 1, 1, NULL, NULL, NULL, NULL),
(24, 30, 0, NULL, NULL, NULL, NULL),
(24, 44, 0, NULL, NULL, NULL, NULL),
(24, 45, 0, NULL, NULL, NULL, NULL),
(25, 2, 1, NULL, NULL, NULL, NULL),
(26, 2, 1, NULL, NULL, NULL, NULL),
(27, 1, 1, NULL, NULL, NULL, NULL),
(27, 2, 0, NULL, NULL, NULL, NULL),
(28, 30, 1, NULL, NULL, NULL, NULL),
(28, 44, 0, NULL, NULL, NULL, NULL),
(28, 45, 0, NULL, NULL, NULL, NULL),
(29, 2, 1, NULL, NULL, NULL, NULL),
(30, 2, 1, NULL, NULL, NULL, NULL),
(31, 16, 1, NULL, NULL, NULL, NULL),
(31, 43, 1, NULL, NULL, NULL, NULL),
(32, 1, 1, NULL, NULL, NULL, NULL),
(33, 1, 1, NULL, NULL, NULL, NULL),
(33, 2, 0, NULL, NULL, NULL, NULL),
(33, 49, 0, NULL, NULL, NULL, NULL),
(34, 1, 1, NULL, NULL, NULL, NULL),
(35, 18, 1, NULL, NULL, NULL, NULL),
(36, 1, 1, NULL, NULL, NULL, NULL),
(36, 30, 0, NULL, NULL, NULL, NULL),
(37, 30, 1, NULL, NULL, NULL, NULL),
(38, 50, 1, NULL, NULL, NULL, NULL),
(39, 50, 1, NULL, NULL, NULL, NULL),
(40, 1, 1, NULL, NULL, NULL, NULL),
(40, 20, 0, NULL, NULL, NULL, NULL),
(41, 16, 1, NULL, NULL, NULL, NULL),
(41, 18, 0, NULL, NULL, NULL, NULL),
(41, 20, 0, NULL, NULL, NULL, NULL),
(42, 2, 1, NULL, NULL, NULL, NULL),
(43, 2, 1, NULL, NULL, NULL, NULL),
(44, 19, 1, NULL, NULL, NULL, NULL),
(45, 18, 1, NULL, NULL, NULL, NULL),
(46, 1, 1, NULL, NULL, NULL, NULL),
(46, 18, 0, NULL, NULL, NULL, NULL),
(46, 30, 0, NULL, NULL, NULL, NULL),
(47, 1, 1, NULL, NULL, NULL, NULL),
(48, 18, 1, NULL, NULL, NULL, NULL),
(49, 2, 1, NULL, NULL, NULL, NULL),
(50, 1, 1, NULL, NULL, NULL, NULL),
(51, 45, 1, NULL, NULL, NULL, NULL),
(52, 1, 1, NULL, NULL, NULL, NULL),
(53, 50, 1, NULL, NULL, NULL, NULL),
(54, 1, 1, NULL, NULL, NULL, NULL),
(55, 7, 1, NULL, NULL, NULL, NULL),
(56, 18, 1, NULL, NULL, NULL, NULL),
(57, 50, 1, NULL, NULL, NULL, NULL),
(58, 1, 1, NULL, NULL, NULL, NULL),
(59, 1, 1, NULL, NULL, NULL, NULL),
(59, 30, 0, NULL, NULL, NULL, NULL),
(59, 44, 0, NULL, NULL, NULL, NULL),
(59, 45, 0, NULL, NULL, NULL, NULL),
(60, 2, 1, NULL, NULL, NULL, NULL),
(61, 2, 1, NULL, NULL, NULL, NULL),
(62, 1, 1, NULL, NULL, NULL, NULL),
(62, 2, 0, NULL, NULL, NULL, NULL),
(63, 30, 1, NULL, NULL, NULL, NULL),
(63, 44, 0, NULL, NULL, NULL, NULL),
(63, 45, 0, NULL, NULL, NULL, NULL),
(64, 2, 1, NULL, NULL, NULL, NULL),
(65, 2, 1, NULL, NULL, NULL, NULL),
(66, 16, 1, NULL, NULL, NULL, NULL),
(66, 43, 1, NULL, NULL, NULL, NULL),
(67, 1, 1, NULL, NULL, NULL, NULL),
(68, 1, 1, NULL, NULL, NULL, NULL),
(68, 2, 0, NULL, NULL, NULL, NULL),
(68, 49, 0, NULL, NULL, NULL, NULL),
(69, 1, 1, NULL, NULL, NULL, NULL),
(70, 18, 1, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_template_mail`
--

CREATE TABLE `[[dbprefix]]core_template_mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `template` varchar(128) NOT NULL,
  `event` varchar(64) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `from` varchar(96) NOT NULL,
  `site` varchar(128) NOT NULL,
  `type` varchar(4) NOT NULL DEFAULT 'html',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]core_template_mail`
--

INSERT INTO `[[dbprefix]]core_template_mail` VALUES
(1, 'Store', 'default', 'default', 1, 'email2', '1', 'html'),
(2, 'Contact Us', 'contact-us', 'contact_us', 1, 'email2', '1', 'html'),
(3, 'Forgot Password', 'forgot', 'forgot_password', 1, 'email2', '1', 'html'),
(4, 'Notice customer', 'account_new-customer', 'account_new-customer', 1, 'email2', '1', 'html'),
(5, 'Notice owner', 'account_new-owner', 'account_new-owner', 1, 'email2', '1', 'html'),
(6, 'Notice customer', 'order_new-customer', 'order_new-customer', 1, 'email2', '1', 'html'),
(7, 'Notice owner', 'order_new-owner', 'order_new-owner', 1, 'email2', '1', 'html'),
(8, 'Cusromer notify change order status', 'change_order_status-customer', 'change_order_status-customer', 1, 'email2', '1', 'html');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_template_page`
--

CREATE TABLE `[[dbprefix]]core_template_page` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` mediumint(8) unsigned NOT NULL,
  `page_id` mediumint(8) unsigned NOT NULL,
  `layout` varchar(64) NOT NULL,
  `parent_page_id` mediumint(8) unsigned DEFAULT NULL,
  `priority` smallint(5) unsigned NOT NULL DEFAULT '100',
  PRIMARY KEY (`id`),
  KEY `FK_template_layout_to_page_template_id` (`template_id`),
  KEY `FK_template_layout_to_page_page_id` (`page_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]core_template_page`
--

INSERT INTO `[[dbprefix]]core_template_page` VALUES
(1, 1, 30, 'layout_2columns-left', NULL, 100),
(2, 1, 31, 'layout_1column', NULL, 100),
(3, 1, 32, 'layout_1column', NULL, 100),
(4, 1, 23, 'layout_1column', NULL, 100),
(5, 1, 29, 'layout_2columns-right', NULL, 100),
(6, 1, 2, 'layout_2columns-right', NULL, 100),
(7, 1, 4, 'layout_1column', NULL, 100),
(8, 1, 19, 'layout_3columns', NULL, 100),
(9, 1, 18, 'layout_2columns-right', NULL, 100),
(10, 1, 21, 'layout_1column', NULL, 100),
(11, 1, 37, 'layout_2columns-left', NULL, 100),
(12, 1, 22, 'layout_2columns-right', NULL, 100),
(13, 1, 49, 'layout_1column', NULL, 100),
(14, 1, 44, 'layout_1column', NULL, 100),
(15, 1, 48, 'layout_1column', NULL, 100),
(16, 1, 15, 'layout_1column', NULL, 100),
(17, 1, 1, 'layout_3columns', NULL, 100),
(18, 1, 5, 'layout_2columns-right', NULL, 100),
(19, 1, 14, 'layout_1column', NULL, 100),
(20, 1, 13, '', 30, 100),
(21, 2, 30, 'layout_2columns-left', NULL, 100),
(22, 2, 31, 'layout_1column', NULL, 100),
(23, 2, 32, 'layout_1column', NULL, 100),
(24, 2, 23, 'layout_1column', NULL, 100),
(25, 2, 29, 'layout_2columns-right', NULL, 100),
(26, 2, 2, 'layout_2columns-right', NULL, 100),
(27, 2, 4, 'layout_1column', NULL, 100),
(28, 2, 19, 'layout_3columns', NULL, 100),
(29, 2, 18, 'layout_2columns-right', NULL, 100),
(30, 2, 21, 'layout_1column', NULL, 100),
(31, 2, 37, 'layout_2columns-left', NULL, 100),
(32, 2, 22, 'layout_2columns-right', NULL, 100),
(33, 2, 49, 'layout_1column', NULL, 100),
(34, 2, 44, 'layout_1column', NULL, 100),
(35, 2, 48, 'layout_1column', NULL, 100),
(36, 2, 15, 'layout_1column', NULL, 100),
(37, 2, 1, 'layout_3columns', NULL, 100),
(38, 2, 5, 'layout_2columns-right', NULL, 100),
(39, 2, 14, 'layout_1column', NULL, 100),
(40, 2, 13, '', 30, 100);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]csv_profile`
--

CREATE TABLE `[[dbprefix]]csv_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `type` varchar(32) NOT NULL,
  `direction` enum('export','import') NOT NULL,
  `site` varchar(20) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]csv_profile_filter`
--

CREATE TABLE `[[dbprefix]]csv_profile_filter` (
  `profile_id` int(10) unsigned NOT NULL,
  `language_ids` varchar(128) NOT NULL,
  `name` varchar(128) NOT NULL,
  `sku` varchar(128) NOT NULL,
  `stock` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `price_from` int(10) unsigned DEFAULT NULL,
  `price_to` int(10) unsigned DEFAULT NULL,
  `qty_from` int(10) unsigned DEFAULT NULL,
  `qty_to` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discount`
--

CREATE TABLE `[[dbprefix]]discount` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL,
  `amount` decimal(12,4) NOT NULL,
  `priority` tinyint(2) unsigned DEFAULT NULL,
  `is_combined` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discount_eav`
--

CREATE TABLE `[[dbprefix]]discount_eav` (
  `discount_id` int(10) unsigned NOT NULL,
  `entity` varchar(25) NOT NULL,
  `value` int(11) NOT NULL,
  KEY `discount_fk_constraint` (`discount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]import_profile`
--

CREATE TABLE `[[dbprefix]]import_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `host` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `db_name` varchar(255) NOT NULL,
  `db_user` varchar(255) NOT NULL,
  `db_password` varchar(255) NOT NULL,
  `table_prefix` varchar(128) NOT NULL,
  `type` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locale_currency`
--

CREATE TABLE `[[dbprefix]]locale_currency` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(3) NOT NULL,
  `title` varchar(128) NOT NULL,
  `position` tinyint(1) unsigned DEFAULT NULL,
  `display` tinyint(2) unsigned DEFAULT NULL,
  `format` varchar(10) DEFAULT NULL,
  `currency_precision` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `rate` decimal(17,10) unsigned NOT NULL DEFAULT '1.0000000000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_LOCALE_CURRENCY` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]locale_currency`
--

INSERT INTO `[[dbprefix]]locale_currency` VALUES
(1, 'USD', 'US Dollar', 8, 2, 'en_US', 2, '1.0000000000');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locale_language`
--

CREATE TABLE `[[dbprefix]]locale_language` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(3) NOT NULL,
  `language` varchar(128) NOT NULL,
  `locale` varchar(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `LOCALE_LANGUAGE_CODE` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]locale_language`
--

INSERT INTO `[[dbprefix]]locale_language` VALUES
(1, 'en', 'English', 'en_US');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_address_format`
--

CREATE TABLE `[[dbprefix]]location_address_format` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `address_format` text NOT NULL,
  `address_summary` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]location_address_format`
--

INSERT INTO `[[dbprefix]]location_address_format` VALUES
(1, 'ISO/IEC 19773', '{{firstname}} {{lastname}}EOL{{if company}}{{company}}EOL{{/if}}{{if street_address}}{{street_address}}EOL{{/if}}{{if suburb}}{{suburb}}EOL{{/if}}{{if city}}{{city}}{{/if}} {{if zone.name}}{{zone.name}} {{/if}}{{if postcode}}{{postcode}}{{/if}}{{if country}}EOL{{country.name}}EOL{{/if}}{{if phone}}T: {{phone}}EOL{{/if}}{{if fax}}F: {{fax}}EOL{{/if}}', '{{firstname}} {{lastname}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_country`
--

CREATE TABLE `[[dbprefix]]location_country` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `iso_code_2` char(2) NOT NULL DEFAULT '',
  `iso_code_3` char(3) NOT NULL DEFAULT '',
  `address_format_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `LOCATION_COUNTRY_ISO2` (`iso_code_2`),
  KEY `LOCATION_COUNTRY_ISO3` (`iso_code_3`),
  KEY `LOCATION_COUNTRY_FORMAT` USING BTREE (`address_format_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=243 ;

--
-- Dumping data for table `[[dbprefix]]location_country`
--

INSERT INTO `[[dbprefix]]location_country` VALUES
(0, 'ALL WORLD COUNTRY', '*', '*', 1),
(1, 'Afghanistan', 'AF', 'AFG', 1),
(2, 'Albania', 'AL', 'ALB', 1),
(3, 'Algeria', 'DZ', 'DZA', 1),
(4, 'American Samoa', 'AS', 'ASM', 1),
(5, 'Andorra', 'AD', 'AND', 1),
(6, 'Angola', 'AO', 'AGO', 1),
(7, 'Anguilla', 'AI', 'AIA', 1),
(8, 'Antarctica', 'AQ', 'ATA', 1),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 1),
(10, 'Argentina', 'AR', 'ARG', 1),
(11, 'Armenia', 'AM', 'ARM', 1),
(12, 'Aruba', 'AW', 'ABW', 1),
(13, 'Australia', 'AU', 'AUS', 1),
(14, 'Austria', 'AT', 'AUT', 1),
(15, 'Azerbaijan', 'AZ', 'AZE', 1),
(16, 'Bahamas', 'BS', 'BHS', 1),
(17, 'Bahrain', 'BH', 'BHR', 1),
(18, 'Bangladesh', 'BD', 'BGD', 1),
(19, 'Barbados', 'BB', 'BRB', 1),
(20, 'Belarus', 'BY', 'BLR', 1),
(21, 'Belgium', 'BE', 'BEL', 1),
(22, 'Belize', 'BZ', 'BLZ', 1),
(23, 'Benin', 'BJ', 'BEN', 1),
(24, 'Bermuda', 'BM', 'BMU', 1),
(25, 'Bhutan', 'BT', 'BTN', 1),
(26, 'Bolivia', 'BO', 'BOL', 1),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', 1),
(28, 'Botswana', 'BW', 'BWA', 1),
(29, 'Bouvet Island', 'BV', 'BVT', 1),
(30, 'Brazil', 'BR', 'BRA', 1),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1),
(32, 'Brunei Darussalam', 'BN', 'BRN', 1),
(33, 'Bulgaria', 'BG', 'BGR', 1),
(34, 'Burkina Faso', 'BF', 'BFA', 1),
(35, 'Burundi', 'BI', 'BDI', 1),
(36, 'Cambodia', 'KH', 'KHM', 1),
(37, 'Cameroon', 'CM', 'CMR', 1),
(38, 'Canada', 'CA', 'CAN', 1),
(39, 'Cape Verde', 'CV', 'CPV', 1),
(40, 'Cayman Islands', 'KY', 'CYM', 1),
(41, 'Central African Republic', 'CF', 'CAF', 1),
(42, 'Chad', 'TD', 'TCD', 1),
(43, 'Chile', 'CL', 'CHL', 1),
(44, 'China', 'CN', 'CHN', 1),
(45, 'Christmas Island', 'CX', 'CXR', 1),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1),
(47, 'Colombia', 'CO', 'COL', 1),
(48, 'Comoros', 'KM', 'COM', 1),
(49, 'Congo', 'CG', 'COG', 1),
(50, 'Cook Islands', 'CK', 'COK', 1),
(51, 'Costa Rica', 'CR', 'CRI', 1),
(52, 'Cote D''Ivoire', 'CI', 'CIV', 1),
(53, 'Croatia', 'HR', 'HRV', 1),
(54, 'Cuba', 'CU', 'CUB', 1),
(55, 'Cyprus', 'CY', 'CYP', 1),
(56, 'Czech Republic', 'CZ', 'CZE', 1),
(57, 'Denmark', 'DK', 'DNK', 1),
(58, 'Djibouti', 'DJ', 'DJI', 1),
(59, 'Dominica', 'DM', 'DMA', 1),
(60, 'Dominican Republic', 'DO', 'DOM', 1),
(61, 'East Timor', 'TP', 'TMP', 1),
(62, 'Ecuador', 'EC', 'ECU', 1),
(63, 'Egypt', 'EG', 'EGY', 1),
(64, 'El Salvador', 'SV', 'SLV', 1),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', 1),
(66, 'Eritrea', 'ER', 'ERI', 1),
(67, 'Estonia', 'EE', 'EST', 1),
(68, 'Ethiopia', 'ET', 'ETH', 1),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1),
(70, 'Faroe Islands', 'FO', 'FRO', 1),
(71, 'Fiji', 'FJ', 'FJI', 1),
(72, 'Finland', 'FI', 'FIN', 1),
(73, 'France', 'FR', 'FRA', 1),
(74, 'France, Metropolitan', 'FX', 'FXX', 1),
(75, 'French Guiana', 'GF', 'GUF', 1),
(76, 'French Polynesia', 'PF', 'PYF', 1),
(77, 'French Southern Territories', 'TF', 'ATF', 1),
(78, 'Gabon', 'GA', 'GAB', 1),
(79, 'Gambia', 'GM', 'GMB', 1),
(80, 'Georgia', 'GE', 'GEO', 1),
(81, 'Germany', 'DE', 'DEU', 1),
(82, 'Ghana', 'GH', 'GHA', 1),
(83, 'Gibraltar', 'GI', 'GIB', 1),
(84, 'Greece', 'GR', 'GRC', 1),
(85, 'Greenland', 'GL', 'GRL', 1),
(86, 'Grenada', 'GD', 'GRD', 1),
(87, 'Guadeloupe', 'GP', 'GLP', 1),
(88, 'Guam', 'GU', 'GUM', 1),
(89, 'Guatemala', 'GT', 'GTM', 1),
(90, 'Guinea', 'GN', 'GIN', 1),
(91, 'Guinea-bissau', 'GW', 'GNB', 1),
(92, 'Guyana', 'GY', 'GUY', 1),
(93, 'Haiti', 'HT', 'HTI', 1),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1),
(95, 'Honduras', 'HN', 'HND', 1),
(96, 'Hong Kong', 'HK', 'HKG', 1),
(97, 'Hungary', 'HU', 'HUN', 1),
(98, 'Iceland', 'IS', 'ISL', 1),
(99, 'India', 'IN', 'IND', 1),
(100, 'Indonesia', 'ID', 'IDN', 1),
(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1),
(102, 'Iraq', 'IQ', 'IRQ', 1),
(103, 'Ireland', 'IE', 'IRL', 1),
(104, 'Israel', 'IL', 'ISR', 1),
(105, 'Italy', 'IT', 'ITA', 1),
(106, 'Jamaica', 'JM', 'JAM', 1),
(107, 'Japan', 'JP', 'JPN', 1),
(108, 'Jordan', 'JO', 'JOR', 1),
(109, 'Kazakhstan', 'KZ', 'KAZ', 1),
(110, 'Kenya', 'KE', 'KEN', 1),
(111, 'Kiribati', 'KI', 'KIR', 1),
(112, 'Korea, Democratic People''s Republic of', 'KP', 'PRK', 1),
(113, 'Korea, Republic of', 'KR', 'KOR', 1),
(114, 'Kuwait', 'KW', 'KWT', 1),
(115, 'Kyrgyzstan', 'KG', 'KGZ', 1),
(116, 'Lao People''s Democratic Republic', 'LA', 'LAO', 1),
(117, 'Latvia', 'LV', 'LVA', 1),
(118, 'Lebanon', 'LB', 'LBN', 1),
(119, 'Lesotho', 'LS', 'LSO', 1),
(120, 'Liberia', 'LR', 'LBR', 1),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1),
(122, 'Liechtenstein', 'LI', 'LIE', 1),
(123, 'Lithuania', 'LT', 'LTU', 1),
(124, 'Luxembourg', 'LU', 'LUX', 1),
(125, 'Macau', 'MO', 'MAC', 1),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MK', 'MKD', 1),
(127, 'Madagascar', 'MG', 'MDG', 1),
(128, 'Malawi', 'MW', 'MWI', 1),
(129, 'Malaysia', 'MY', 'MYS', 1),
(130, 'Maldives', 'MV', 'MDV', 1),
(131, 'Mali', 'ML', 'MLI', 1),
(132, 'Malta', 'MT', 'MLT', 1),
(133, 'Marshall Islands', 'MH', 'MHL', 1),
(134, 'Martinique', 'MQ', 'MTQ', 1),
(135, 'Mauritania', 'MR', 'MRT', 1),
(136, 'Mauritius', 'MU', 'MUS', 1),
(137, 'Mayotte', 'YT', 'MYT', 1),
(138, 'Mexico', 'MX', 'MEX', 1),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', 1),
(140, 'Moldova, Republic of', 'MD', 'MDA', 1),
(141, 'Monaco', 'MC', 'MCO', 1),
(142, 'Mongolia', 'MN', 'MNG', 1),
(143, 'Montserrat', 'MS', 'MSR', 1),
(144, 'Morocco', 'MA', 'MAR', 1),
(145, 'Mozambique', 'MZ', 'MOZ', 1),
(146, 'Myanmar', 'MM', 'MMR', 1),
(147, 'Namibia', 'NA', 'NAM', 1),
(148, 'Nauru', 'NR', 'NRU', 1),
(149, 'Nepal', 'NP', 'NPL', 1),
(150, 'Netherlands', 'NL', 'NLD', 1),
(151, 'Netherlands Antilles', 'AN', 'ANT', 1),
(152, 'New Caledonia', 'NC', 'NCL', 1),
(153, 'New Zealand', 'NZ', 'NZL', 1),
(154, 'Nicaragua', 'NI', 'NIC', 1),
(155, 'Niger', 'NE', 'NER', 1),
(156, 'Nigeria', 'NG', 'NGA', 1),
(157, 'Niue', 'NU', 'NIU', 1),
(158, 'Norfolk Island', 'NF', 'NFK', 1),
(159, 'Northern Mariana Islands', 'MP', 'MNP', 1),
(160, 'Norway', 'NO', 'NOR', 1),
(161, 'Oman', 'OM', 'OMN', 1),
(162, 'Pakistan', 'PK', 'PAK', 1),
(163, 'Palau', 'PW', 'PLW', 1),
(164, 'Panama', 'PA', 'PAN', 1),
(165, 'Papua New Guinea', 'PG', 'PNG', 1),
(166, 'Paraguay', 'PY', 'PRY', 1),
(167, 'Peru', 'PE', 'PER', 1),
(168, 'Philippines', 'PH', 'PHL', 1),
(169, 'Pitcairn', 'PN', 'PCN', 1),
(170, 'Poland', 'PL', 'POL', 1),
(171, 'Portugal', 'PT', 'PRT', 1),
(172, 'Puerto Rico', 'PR', 'PRI', 1),
(173, 'Qatar', 'QA', 'QAT', 1),
(174, 'Reunion', 'RE', 'REU', 1),
(175, 'Romania', 'RO', 'ROM', 1),
(176, 'Russian Federation', 'RU', 'RUS', 1),
(177, 'Rwanda', 'RW', 'RWA', 1),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1),
(179, 'Saint Lucia', 'LC', 'LCA', 1),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1),
(181, 'Samoa', 'WS', 'WSM', 1),
(182, 'San Marino', 'SM', 'SMR', 1),
(183, 'Sao Tome and Principe', 'ST', 'STP', 1),
(184, 'Saudi Arabia', 'SA', 'SAU', 1),
(185, 'Senegal', 'SN', 'SEN', 1),
(186, 'Seychelles', 'SC', 'SYC', 1),
(187, 'Sierra Leone', 'SL', 'SLE', 1),
(188, 'Singapore', 'SG', 'SGP', 1),
(189, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1),
(190, 'Slovenia', 'SI', 'SVN', 1),
(191, 'Solomon Islands', 'SB', 'SLB', 1),
(192, 'Somalia', 'SO', 'SOM', 1),
(193, 'South Africa', 'ZA', 'ZAF', 1),
(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1),
(195, 'Spain', 'ES', 'ESP', 1),
(196, 'Sri Lanka', 'LK', 'LKA', 1),
(197, 'St. Helena', 'SH', 'SHN', 1),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1),
(199, 'Sudan', 'SD', 'SDN', 1),
(200, 'Suriname', 'SR', 'SUR', 1),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1),
(202, 'Swaziland', 'SZ', 'SWZ', 1),
(203, 'Sweden', 'SE', 'SWE', 1),
(204, 'Switzerland', 'CH', 'CHE', 1),
(205, 'Syrian Arab Republic', 'SY', 'SYR', 1),
(206, 'Taiwan', 'TW', 'TWN', 1),
(207, 'Tajikistan', 'TJ', 'TJK', 1),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1),
(209, 'Thailand', 'TH', 'THA', 1),
(210, 'Togo', 'TG', 'TGO', 1),
(211, 'Tokelau', 'TK', 'TKL', 1),
(212, 'Tonga', 'TO', 'TON', 1),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 1),
(214, 'Tunisia', 'TN', 'TUN', 1),
(215, 'Turkey', 'TR', 'TUR', 1),
(216, 'Turkmenistan', 'TM', 'TKM', 1),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1),
(218, 'Tuvalu', 'TV', 'TUV', 1),
(219, 'Uganda', 'UG', 'UGA', 1),
(220, 'Ukraine', 'UA', 'UKR', 1),
(221, 'United Arab Emirates', 'AE', 'ARE', 1),
(222, 'United Kingdom', 'GB', 'GBR', 1),
(223, 'United States', 'US', 'USA', 1),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1),
(225, 'Uruguay', 'UY', 'URY', 1),
(226, 'Uzbekistan', 'UZ', 'UZB', 1),
(227, 'Vanuatu', 'VU', 'VUT', 1),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', 1),
(229, 'Venezuela', 'VE', 'VEN', 1),
(230, 'Viet Nam', 'VN', 'VNM', 1),
(231, 'Virgin Islands (British)', 'VG', 'VGB', 1),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1),
(234, 'Western Sahara', 'EH', 'ESH', 1),
(235, 'Yemen', 'YE', 'YEM', 1),
(236, 'Yugoslavia', 'YU', 'YUG', 1),
(237, 'Zaire', 'ZR', 'ZAR', 1),
(238, 'Zambia', 'ZM', 'ZMB', 1),
(239, 'Zimbabwe', 'ZW', 'ZWE', 1),
(240, 'Aaland Islands', 'AX', 'ALA', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_geozone`
--

CREATE TABLE `[[dbprefix]]location_geozone` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `description` text,
  `priority` tinyint(3) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `modified_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]location_geozone`
--

INSERT INTO `[[dbprefix]]location_geozone` VALUES
(1, 'ALL', 'ALL WORLD', 1, '0000-00-00 00:00:00', NULL),
(2, 'USA', 'United State of America', 5, '0000-00-00 00:00:00', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_geozone_zone`
--

CREATE TABLE `[[dbprefix]]location_geozone_zone` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `geozone_id` mediumint(8) unsigned NOT NULL,
  `zone_id` mediumint(8) unsigned DEFAULT NULL,
  `created_on` datetime NOT NULL,
  `modified_on` datetime DEFAULT NULL,
  `country_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_LOCATION_GEOZONE_ZONE_ZONE` (`zone_id`),
  KEY `FK_LOCATION_GEOZONE_ZONE_COUNTRY` (`country_id`),
  KEY `FK_LOCATION_GEOZONE_ZONE_GEOZONE` (`geozone_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]location_geozone_zone`
--

INSERT INTO `[[dbprefix]]location_geozone_zone` VALUES
(1, 1, 0, '0000-00-00 00:00:00', NULL, 0),
(2, 2, 0, '0000-00-00 00:00:00', NULL, 223);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_zone`
--

CREATE TABLE `[[dbprefix]]location_zone` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  `country_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_LOCATION_ZONE_COUNTRY` (`country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=201 ;

--
-- Dumping data for table `[[dbprefix]]location_zone`
--

INSERT INTO `[[dbprefix]]location_zone` VALUES
(0, '*', 'ALL ZONES', 0),
(1, 'AL', 'Alabama', 223),
(2, 'AK', 'Alaska', 223),
(3, 'AS', 'American Samoa', 223),
(4, 'AZ', 'Arizona', 223),
(5, 'AR', 'Arkansas', 223),
(6, 'AF', 'Armed Forces Africa', 223),
(7, 'AA', 'Armed Forces Americas', 223),
(8, 'AC', 'Armed Forces Canada', 223),
(9, 'AE', 'Armed Forces Europe', 223),
(10, 'AM', 'Armed Forces Middle East', 223),
(11, 'AP', 'Armed Forces Pacific', 223),
(12, 'CA', 'California', 223),
(13, 'CO', 'Colorado', 223),
(14, 'CT', 'Connecticut', 223),
(15, 'DE', 'Delaware', 223),
(16, 'DC', 'District of Columbia', 223),
(17, 'FM', 'Federated States Of Micronesia', 223),
(18, 'FL', 'Florida', 223),
(19, 'GA', 'Georgia', 223),
(20, 'GU', 'Guam', 223),
(21, 'HI', 'Hawaii', 223),
(22, 'ID', 'Idaho', 223),
(23, 'IL', 'Illinois', 223),
(24, 'IN', 'Indiana', 223),
(25, 'IA', 'Iowa', 223),
(26, 'KS', 'Kansas', 223),
(27, 'KY', 'Kentucky', 223),
(28, 'LA', 'Louisiana', 223),
(29, 'ME', 'Maine', 223),
(30, 'MH', 'Marshall Islands', 223),
(31, 'MD', 'Maryland', 223),
(32, 'MA', 'Massachusetts', 223),
(33, 'MI', 'Michigan', 223),
(34, 'MN', 'Minnesota', 223),
(35, 'MS', 'Mississippi', 223),
(36, 'MO', 'Missouri', 223),
(37, 'MT', 'Montana', 223),
(38, 'NE', 'Nebraska', 223),
(39, 'NV', 'Nevada', 223),
(40, 'NH', 'New Hampshire', 223),
(41, 'NJ', 'New Jersey', 223),
(42, 'NM', 'New Mexico', 223),
(43, 'NY', 'New York', 223),
(44, 'NC', 'North Carolina', 223),
(45, 'ND', 'North Dakota', 223),
(46, 'MP', 'Northern Mariana Islands', 223),
(47, 'OH', 'Ohio', 223),
(48, 'OK', 'Oklahoma', 223),
(49, 'OR', 'Oregon', 223),
(50, 'PW', 'Palau', 163),
(51, 'PA', 'Pennsylvania', 223),
(52, 'PR', 'Puerto Rico', 223),
(53, 'RI', 'Rhode Island', 223),
(54, 'SC', 'South Carolina', 223),
(55, 'SD', 'South Dakota', 223),
(56, 'TN', 'Tennessee', 223),
(57, 'TX', 'Texas', 223),
(58, 'UT', 'Utah', 223),
(59, 'VT', 'Vermont', 223),
(60, 'VI', 'Virgin Islands', 223),
(61, 'VA', 'Virginia', 223),
(62, 'WA', 'Washington', 223),
(63, 'WV', 'West Virginia', 223),
(64, 'WI', 'Wisconsin', 223),
(65, 'WY', 'Wyoming', 223),
(66, 'AB', 'Alberta', 38),
(67, 'BC', 'British Columbia', 38),
(68, 'MB', 'Manitoba', 38),
(69, 'NF', 'Newfoundland', 38),
(70, 'NB', 'New Brunswick', 38),
(71, 'NS', 'Nova Scotia', 38),
(72, 'NT', 'Northwest Territories', 38),
(73, 'NU', 'Nunavut', 38),
(74, 'ON', 'Ontario', 38),
(75, 'PE', 'Prince Edward Island', 38),
(76, 'QC', 'Quebec', 38),
(77, 'SK', 'Saskatchewan', 38),
(78, 'YT', 'Yukon Territory', 38),
(79, 'NDS', 'Niedersachsen', 81),
(80, 'BAW', 'Baden-Wrttemberg', 81),
(81, 'BAY', 'Bayern', 81),
(82, 'BER', 'Berlin', 81),
(83, 'BRG', 'Brandenburg', 81),
(84, 'BRE', 'Bremen', 81),
(85, 'HAM', 'Hamburg', 81),
(86, 'HES', 'Hessen', 81),
(87, 'MEC', 'Mecklenburg-Vorpommern', 81),
(88, 'NRW', 'Nordrhein-Westfalen', 81),
(89, 'RHE', 'Rheinland-Pfalz', 81),
(90, 'SAR', 'Saarland', 81),
(91, 'SAS', 'Sachsen', 81),
(92, 'SAC', 'Sachsen-Anhalt', 81),
(93, 'SCN', 'Schleswig-Holstein', 81),
(94, 'THE', 'Thringen', 81),
(95, 'WI', 'Wien', 14),
(96, 'NO', 'Niedersterreich', 14),
(97, 'OO', 'Obersterreich', 14),
(98, 'SB', 'Salzburg', 14),
(99, 'KN', 'KÃ¤rtnen', 14),
(100, 'ST', 'Steiermark', 14),
(101, 'TI', 'Tirol', 14),
(102, 'BL', 'Burgenland', 14),
(103, 'VB', 'Voralberg', 14),
(104, 'AG', 'Aargau', 204),
(105, 'AI', 'Appenzell Innerrhoden', 204),
(106, 'AR', 'Appenzell Ausserrhoden', 204),
(107, 'BE', 'Bern', 204),
(108, 'BL', 'Basel-Landschaft', 204),
(109, 'BS', 'Basel-Stadt', 204),
(110, 'FR', 'Freiburg', 204),
(111, 'GE', 'Genf', 204),
(112, 'GL', 'Glarus', 204),
(113, 'JU', 'Graubnden', 204),
(114, 'JU', 'Jura', 204),
(115, 'LU', 'Luzern', 204),
(116, 'NE', 'Neuenburg', 204),
(117, 'NW', 'Nidwalden', 204),
(118, 'OW', 'Obwalden', 204),
(119, 'SG', 'St. Gallen', 204),
(120, 'SH', 'Schaffhausen', 204),
(121, 'SO', 'Solothurn', 204),
(122, 'SZ', 'Schwyz', 204),
(123, 'TG', 'Thurgau', 204),
(124, 'TI', 'Tessin', 204),
(125, 'UR', 'Uri', 204),
(126, 'VD', 'Waadt', 204),
(127, 'VS', 'Wallis', 204),
(128, 'ZG', 'Zug', 204),
(129, 'ZH', 'Zrich', 204),
(130, 'A Corua', 'A Corua', 195),
(131, 'Alava', 'Alava', 195),
(132, 'Albacete', 'Albacete', 195),
(133, 'Alicante', 'Alicante', 195),
(134, 'Almeria', 'Almeria', 195),
(135, 'Asturias', 'Asturias', 195),
(136, 'Avila', 'Avila', 195),
(137, 'Badajoz', 'Badajoz', 195),
(138, 'Baleares', 'Baleares', 195),
(139, 'Barcelona', 'Barcelona', 195),
(140, 'Burgos', 'Burgos', 195),
(141, 'Caceres', 'Caceres', 195),
(142, 'Cadiz', 'Cadiz', 195),
(143, 'Cantabria', 'Cantabria', 195),
(144, 'Castellon', 'Castellon', 195),
(145, 'Ceuta', 'Ceuta', 195),
(146, 'Ciudad Real', 'Ciudad Real', 195),
(147, 'Cordoba', 'Cordoba', 195),
(148, 'Cuenca', 'Cuenca', 195),
(149, 'Girona', 'Girona', 195),
(150, 'Granada', 'Granada', 195),
(151, 'Guadalajara', 'Guadalajara', 195),
(152, 'Guipuzcoa', 'Guipuzcoa', 195),
(153, 'Huelva', 'Huelva', 195),
(154, 'Huesca', 'Huesca', 195),
(155, 'Jaen', 'Jaen', 195),
(156, 'La Rioja', 'La Rioja', 195),
(157, 'Las Palmas', 'Las Palmas', 195),
(158, 'Leon', 'Leon', 195),
(159, 'Lleida', 'Lleida', 195),
(160, 'Lugo', 'Lugo', 195),
(161, 'Madrid', 'Madrid', 195),
(162, 'Malaga', 'Malaga', 195),
(163, 'Melilla', 'Melilla', 195),
(164, 'Murcia', 'Murcia', 195),
(165, 'Navarra', 'Navarra', 195),
(166, 'Ourense', 'Ourense', 195),
(167, 'Palencia', 'Palencia', 195),
(168, 'Pontevedra', 'Pontevedra', 195),
(169, 'Salamanca', 'Salamanca', 195),
(170, 'Santa Cruz de Tenerife', 'Santa Cruz de Tenerife', 195),
(171, 'Segovia', 'Segovia', 195),
(172, 'Sevilla', 'Sevilla', 195),
(173, 'Soria', 'Soria', 195),
(174, 'Tarragona', 'Tarragona', 195),
(175, 'Teruel', 'Teruel', 195),
(176, 'Toledo', 'Toledo', 195),
(177, 'Valencia', 'Valencia', 195),
(178, 'Valladolid', 'Valladolid', 195),
(179, 'Vizcaya', 'Vizcaya', 195),
(180, 'Zamora', 'Zamora', 195),
(181, 'Zaragoza', 'Zaragoza', 195),
(182, 'ACT', 'Australian Capital Territory', 13),
(183, 'NSW', 'New South Wales', 13),
(184, 'NT', 'Northern Territory', 13),
(185, 'QLD', 'Queensland', 13),
(186, 'SA', 'South Australia', 13),
(187, 'TAS', 'Tasmania', 13),
(188, 'VIC', 'Victoria', 13),
(189, 'WA', 'Western Australia', 13);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_event`
--

CREATE TABLE `[[dbprefix]]log_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visitor_id` int(11) NOT NULL,
  `event_name` varchar(64) NOT NULL,
  `object_id` mediumint(9) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_url`
--

CREATE TABLE `[[dbprefix]]log_url` (
  `url_id` int(11) NOT NULL,
  `visitor_id` int(11) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visit_at` datetime DEFAULT NULL,
  `site_id` smallint(9) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_url_info`
--

CREATE TABLE `[[dbprefix]]log_url_info` (
  `id` mediumint(7) NOT NULL AUTO_INCREMENT,
  `url` varchar(1024) DEFAULT NULL,
  `refer` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_visitor`
--

CREATE TABLE `[[dbprefix]]log_visitor` (
  `id` mediumint(7) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` char(32) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_LOG_VISITOR` (`session_id`,`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_visitor_info`
--

CREATE TABLE `[[dbprefix]]log_visitor_info` (
  `visitor_id` int(11) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `http_accept_charset` varchar(128) DEFAULT NULL,
  `http_accept_language` varchar(128) DEFAULT NULL,
  `server_addr` varchar(128) DEFAULT NULL,
  `remote_addr` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`visitor_id`),
  KEY `fk_log_visitor_info_log_visitor` (`visitor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_authorizenetaim_standard_order`
--

CREATE TABLE `[[dbprefix]]payment_authorizenetaim_standard_order` (
  `order_id` int(10) unsigned NOT NULL,
  `trans_id` varchar(128) NOT NULL,
  `cc_type` varchar(32) NOT NULL,
  `cc_owner` varchar(64) NOT NULL,
  `cc_number` varchar(64) NOT NULL,
  `cc_expires` varchar(16) NOT NULL,
  `cc_issue` varchar(16) NOT NULL,
  `x_type` varchar(16) NOT NULL,
  `x_method` varchar(8) NOT NULL,
  PRIMARY KEY USING BTREE (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_paypal_standard_order`
--

CREATE TABLE `[[dbprefix]]payment_paypal_standard_order` (
  `order_id` int(10) unsigned NOT NULL,
  `trans_id` varchar(128) NOT NULL,
  `status` varchar(32) NOT NULL,
  PRIMARY KEY USING BTREE (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_answer`
--

CREATE TABLE `[[dbprefix]]poll_answer` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` smallint(5) unsigned NOT NULL,
  `question_id` mediumint(8) unsigned NOT NULL,
  `answer` varchar(255) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id`,`language_id`),
  KEY `FK_POLL_ANSWER_LANGUAGE` (`language_id`),
  KEY `FK_POLL_ANSWER_QUESTION` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_question`
--

CREATE TABLE `[[dbprefix]]poll_question` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `changed_at` datetime DEFAULT NULL,
  `status` tinyint(3) unsigned DEFAULT '1',
  `type` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY USING BTREE (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_question_description`
--

CREATE TABLE `[[dbprefix]]poll_question_description` (
  `question_id` mediumint(8) unsigned NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `question` varchar(255) NOT NULL,
  PRIMARY KEY (`language_id`,`question_id`),
  KEY `FK_POLL_QUESTION_DESCRIPTION_LANGUAGE` (`language_id`),
  KEY `FK_POLL_QUESTION_DESCRIPTION_QUESTION` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_question_site`
--

CREATE TABLE `[[dbprefix]]poll_question_site` (
  `question_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY USING BTREE (`question_id`,`site_id`),
  KEY `FK_POLL_QUESTION_SITE_SITE` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_vote`
--

CREATE TABLE `[[dbprefix]]poll_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` int(11) DEFAULT NULL,
  `answer_id` mediumint(8) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `visitor_id` int(10) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_POLL_VOTE` (`ip`,`answer_id`,`customer_id`),
  KEY `FK_POLL_VOTE_ANSWER` (`answer_id`),
  KEY `FK_POLL_VOTE_CUSTOMER` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order`
--

CREATE TABLE `[[dbprefix]]sales_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `number` varchar(32) NOT NULL,
  `customer_id` int(10) unsigned DEFAULT '0',
  `locale` char(5) NOT NULL DEFAULT 'en_US',
  `customer_email` varchar(96) DEFAULT NULL,
  `delivery_firstname` varchar(128) NOT NULL,
  `delivery_lastname` varchar(128) NOT NULL,
  `delivery_phone` varchar(64) DEFAULT NULL,
  `delivery_fax` varchar(64) DEFAULT NULL,
  `delivery_company` varchar(128) DEFAULT NULL,
  `delivery_street_address` varchar(128) DEFAULT NULL,
  `delivery_suburb` varchar(128) DEFAULT NULL,
  `delivery_city` varchar(64) DEFAULT NULL,
  `delivery_postcode` varchar(20) DEFAULT NULL,
  `delivery_state` varchar(64) DEFAULT NULL,
  `delivery_country` varchar(64) DEFAULT NULL,
  `delivery_address_format_id` int(5) DEFAULT '0',
  `billing_firstname` varchar(128) NOT NULL,
  `billing_lastname` varchar(128) NOT NULL,
  `billing_phone` varchar(64) DEFAULT NULL,
  `billing_fax` varchar(64) DEFAULT NULL,
  `billing_company` varchar(128) DEFAULT NULL,
  `billing_street_address` varchar(64) DEFAULT NULL,
  `billing_suburb` varchar(128) DEFAULT NULL,
  `billing_city` varchar(64) DEFAULT NULL,
  `billing_postcode` varchar(20) DEFAULT NULL,
  `billing_state` varchar(64) DEFAULT NULL,
  `billing_country` varchar(64) DEFAULT NULL,
  `billing_address_format_id` int(5) DEFAULT '0',
  `payment_method` varchar(255) NOT NULL DEFAULT '',
  `payment_method_code` varchar(255) NOT NULL DEFAULT '',
  `shipping_method` varchar(255) NOT NULL DEFAULT '',
  `shipping_method_code` varchar(255) NOT NULL DEFAULT '',
  `coupon_code` varchar(32) DEFAULT NULL,
  `date_modified_on` datetime DEFAULT NULL,
  `date_purchased_on` datetime NOT NULL,
  `date_finished_on` datetime DEFAULT NULL,
  `order_status_id` mediumint(8) unsigned DEFAULT NULL,
  `currency` char(3) NOT NULL,
  `currency_rate` decimal(17,10) unsigned NOT NULL DEFAULT '1.0000000000',
  `order_total` decimal(14,2) NOT NULL,
  `txn_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(96) DEFAULT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  `customer_comment` text,
  `admin_comment` text,
  PRIMARY KEY (`id`),
  KEY `INDEX_SALES_ORDER` USING BTREE (`order_status_id`,`id`,`customer_id`),
  KEY `INDEX_SALES_ORDER_DATE` USING BTREE (`date_purchased_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_creditcard`
--

CREATE TABLE `[[dbprefix]]sales_order_creditcard` (
  `order_id` int(10) unsigned NOT NULL,
  `cc_type` varchar(64) NOT NULL,
  `cc_owner` varchar(64) DEFAULT NULL,
  `cc_number` varchar(64) NOT NULL,
  `cc_expires_year` varchar(20) NOT NULL,
  `cc_expires_month` varchar(20) NOT NULL,
  `cc_issue_year` varchar(20) DEFAULT NULL,
  `cc_issue_month` varchar(20) DEFAULT NULL,
  `cc_cvv` varchar(20) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_product`
--

CREATE TABLE `[[dbprefix]]sales_order_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `variation_id` int(11) DEFAULT NULL,
  `sku` varchar(128) NOT NULL,
  `name` varchar(128) NOT NULL,
  `price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `final_weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `quantity` decimal(15,4) NOT NULL,
  `backorder` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id`),
  KEY `INDEX_SALES_ORDER_PRODUCT` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_product_attribute`
--

CREATE TABLE `[[dbprefix]]sales_order_product_attribute` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_product_id` int(11) NOT NULL,
  `product_option` varchar(128) NOT NULL,
  `product_option_value` text NOT NULL,
  PRIMARY KEY USING BTREE (`id`),
  KEY `FK_SALES_ORDER_PRODUCT_ATTRIBUTE` (`order_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_status`
--

CREATE TABLE `[[dbprefix]]sales_order_status` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` char(32) NOT NULL,
  `system` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]sales_order_status`
--

INSERT INTO `[[dbprefix]]sales_order_status` VALUES
(0, 'new', 1),
(1, 'pending', 1),
(2, 'processing', 1),
(3, 'ship', 1),
(4, 'delivered', 1),
(5, 'complete', 1),
(6, 'hold', 1),
(7, 'cancel', 1),
(8, 'refund', 1),
(9, 'failed', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_status_history`
--

CREATE TABLE `[[dbprefix]]sales_order_status_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `order_status_id` smallint(5) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `notified` tinyint(1) unsigned NOT NULL,
  `comments` text,
  PRIMARY KEY (`id`),
  KEY `INDEX_SALES_ORDER_STATUS_HISTORY` (`order_id`,`order_status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_status_relation`
--

CREATE TABLE `[[dbprefix]]sales_order_status_relation` (
  `from_status` smallint(5) NOT NULL,
  `to_status` smallint(5) NOT NULL,
  PRIMARY KEY (`from_status`,`to_status`),
  KEY `INDEX_SALES_ORDER_STATUS_RELATION_FROM` (`from_status`),
  KEY `INDEX_SALES_ORDER_STATUS_RELATION_TO` (`to_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]sales_order_status_relation`
--

INSERT INTO `[[dbprefix]]sales_order_status_relation` VALUES
(0, 1),
(0, 9),
(1, 2),
(1, 6),
(1, 7),
(1, 9),
(2, 3),
(2, 6),
(2, 7),
(2, 8),
(2, 9),
(3, 4),
(3, 8),
(3, 9),
(4, 5),
(4, 8),
(6, 1),
(6, 2),
(6, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_status_text`
--

CREATE TABLE `[[dbprefix]]sales_order_status_text` (
  `status_id` smallint(5) NOT NULL,
  `language_id` smallint(5) unsigned NOT NULL,
  `status_name` varchar(128) NOT NULL,
  PRIMARY KEY (`status_id`,`language_id`),
  KEY `INDEX_SALES_ORDER_STATUS_TEXT_LANGUAGE` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]sales_order_status_text`
--

INSERT INTO `[[dbprefix]]sales_order_status_text` VALUES
(0, 1, 'New'),
(1, 1, 'Pending payment'),
(2, 1, 'Proccesing'),
(3, 1, 'Shipping'),
(4, 1, 'Delivered'),
(5, 1, 'Completed'),
(6, 1, 'Holded'),
(7, 1, 'Canceled'),
(8, 1, 'Refund'),
(9, 1, 'Failed');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sales_order_total`
--

CREATE TABLE `[[dbprefix]]sales_order_total` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `code` varchar(32) NOT NULL,
  `title` varchar(128) NOT NULL,
  `value` decimal(15,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `INDEX_SALES_ORDER_TOTAL` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_log`
--

CREATE TABLE `[[dbprefix]]search_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `visitor_id` int(10) unsigned NOT NULL,
  `query_id` int(10) unsigned NOT NULL,
  `num_results` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `site_id` smallint(9) NOT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_log_query`
--

CREATE TABLE `[[dbprefix]]search_log_query` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `query` varchar(255) NOT NULL,
  `hit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]shippingtable_rate`
--

CREATE TABLE `[[dbprefix]]shippingtable_rate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` smallint(5) NOT NULL DEFAULT '0',
  `country_id` mediumint(8) NOT NULL DEFAULT '0',
  `zone_id` mediumint(8) NOT NULL DEFAULT '0',
  `zip` varchar(10) NOT NULL,
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY USING BTREE (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sitemap`
--

CREATE TABLE `[[dbprefix]]sitemap` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(225) NOT NULL,
  `created_on` datetime NOT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  `status` smallint(5) unsigned NOT NULL,
  `modified_on` datetime NOT NULL,
  `crawlers` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_sitemap_file_site` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_customer`
--

CREATE TABLE `[[dbprefix]]tag_customer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `site_id` smallint(5) unsigned NOT NULL,
  `name` varchar(128) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `i_site_id` USING BTREE (`site_id`),
  KEY `i_customer_id` USING BTREE (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_product`
--

CREATE TABLE `[[dbprefix]]tag_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_tag_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_tag_products_FKIndex1` (`customer_tag_id`),
  KEY `customer_tag_products_FKIndex2` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tax_class`
--

CREATE TABLE `[[dbprefix]]tax_class` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `description` text,
  `created_on` datetime NOT NULL,
  `modified_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]tax_class`
--

INSERT INTO `[[dbprefix]]tax_class` VALUES
(1, 'Taxable Goods', 'Taxable Goods', '0000-00-00 00:00:00', NULL),
(2, 'Shipping', 'Tax shipping', '0000-00-00 00:00:00', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tax_rate`
--

CREATE TABLE `[[dbprefix]]tax_rate` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tax_class_id` mediumint(8) unsigned NOT NULL,
  `geozone_id` mediumint(8) unsigned NOT NULL,
  `rate` decimal(9,4) NOT NULL,
  `description` varchar(255) NOT NULL,
  `created_on` datetime NOT NULL,
  `modified_on` datetime DEFAULT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE_tax_class` USING BTREE (`tax_class_id`,`geozone_id`,`customer_group_id`),
  KEY `FK_tax_customer_group` (`customer_group_id`),
  KEY `FK_tax_geozone` USING BTREE (`geozone_id`),
  KEY `FK_tax_rate_class` (`tax_class_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]tax_rate`
--

INSERT INTO `[[dbprefix]]tax_rate` VALUES
(1, 1, 1, '8.0000', 'Taxable Goods', '0000-00-00 00:00:00', NULL, 0),
(2, 2, 1, '8.0000', 'Shipping Tax', '0000-00-00 00:00:00', NULL, 0);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]account_customer`
--
ALTER TABLE `[[dbprefix]]account_customer`
  ADD CONSTRAINT `FK_ACCOUNT_CUSTOMER_SHIPPING_ADDRESS` FOREIGN KEY (`default_shipping_address_id`) REFERENCES `[[dbprefix]]account_customer_address` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_ACCOUNT_CUSTOMER_BILLING_ADDRESS` FOREIGN KEY (`default_billing_address_id`) REFERENCES `[[dbprefix]]account_customer_address` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_account_customer_group` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]account_customer_group` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_account_customer_site` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]account_customer_address`
--
ALTER TABLE `[[dbprefix]]account_customer_address`
  ADD CONSTRAINT `FK_ACCOUNT_CUSTOMER_ADDRESS_COUNTRY` FOREIGN KEY (`country_id`) REFERENCES `[[dbprefix]]location_country` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_ACCOUNT_CUSTOMER_ADDRESS_CUSTOMER` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_ACCOUNT_CUSTOMER_ADDRESS_ZONE` FOREIGN KEY (`zone_id`) REFERENCES `[[dbprefix]]location_zone` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]account_customer_detail`
--
ALTER TABLE `[[dbprefix]]account_customer_detail`
  ADD CONSTRAINT `FK_account_customer_detail_customer` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_detail_field` FOREIGN KEY (`customer_field_id`) REFERENCES `[[dbprefix]]account_customer_field` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_detail_valueset_value` FOREIGN KEY (`customer_valueset_value_id`) REFERENCES `[[dbprefix]]account_customer_valueset_value` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]account_customer_field`
--
ALTER TABLE `[[dbprefix]]account_customer_field`
  ADD CONSTRAINT `FK_account_customer_field_group` FOREIGN KEY (`customer_field_group_id`) REFERENCES `[[dbprefix]]account_customer_fieldgroup` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_field_valueset` FOREIGN KEY (`customer_valueset_id`) REFERENCES `[[dbprefix]]account_customer_valueset` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]account_customer_fieldgroup_label`
--
ALTER TABLE `[[dbprefix]]account_customer_fieldgroup_label`
  ADD CONSTRAINT `FK_account_customer_field_group_label_fieldgroup` FOREIGN KEY (`customer_field_group_id`) REFERENCES `[[dbprefix]]account_customer_fieldgroup` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_field_group_label_language` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]account_customer_field_label`
--
ALTER TABLE `[[dbprefix]]account_customer_field_label`
  ADD CONSTRAINT `FK_account_customer_field_label_customer_field` FOREIGN KEY (`customer_field_id`) REFERENCES `[[dbprefix]]account_customer_field` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_field_label_language` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]account_customer_forgotpassword`
--
ALTER TABLE `[[dbprefix]]account_customer_forgotpassword`
  ADD CONSTRAINT `FK_account_customer_forgot_password_customer` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]account_customer_valueset_value`
--
ALTER TABLE `[[dbprefix]]account_customer_valueset_value`
  ADD CONSTRAINT `FK_account_customer_valueset_value_valueset` FOREIGN KEY (`customer_valueset_id`) REFERENCES `[[dbprefix]]account_customer_valueset` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]account_customer_valueset_value_label`
--
ALTER TABLE `[[dbprefix]]account_customer_valueset_value_label`
  ADD CONSTRAINT `FK_account_customer_valueset_value_label_valueset_value` FOREIGN KEY (`valueset_value_id`) REFERENCES `[[dbprefix]]account_customer_valueset_value` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_valueset_value_label_language` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]account_wishlist`
--
ALTER TABLE `[[dbprefix]]account_wishlist`
  ADD CONSTRAINT `FK_account_customer_wishlist_customer` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_account_customer_wishlist_product` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]admin_acl_rule`
--
ALTER TABLE `[[dbprefix]]admin_acl_rule`
  ADD CONSTRAINT `fk_acl_role_id` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]admin_acl_role` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]admin_user_forgotpassword`
--
ALTER TABLE `[[dbprefix]]admin_user_forgotpassword`
  ADD CONSTRAINT `FK_admin_user_forgot_password` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_category_description`
--
ALTER TABLE `[[dbprefix]]catalog_category_description`
  ADD CONSTRAINT `FK_CATALOG_CATEGORY_DESCRIPTION_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]catalog_category` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_CATEGORY_DESCRIPTION_LANGUAGE_ID` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product`
--
ALTER TABLE `[[dbprefix]]catalog_product`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_MANUFACTURER` FOREIGN KEY (`manufacturer_id`) REFERENCES `[[dbprefix]]catalog_product_manufacturer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_TAX_CLASS` FOREIGN KEY (`tax_class_id`) REFERENCES `[[dbprefix]]tax_class` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_IMAGE_BASE_IMAGE` FOREIGN KEY (`image_base`) REFERENCES `[[dbprefix]]catalog_product_image` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_IMAGE_LISTING_IMAGE` FOREIGN KEY (`image_listing`) REFERENCES `[[dbprefix]]catalog_product_image` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_IMAGE_THUMBNAIL_IMAGE` FOREIGN KEY (`image_thumbnail`) REFERENCES `[[dbprefix]]catalog_product_image` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_attribute`
--
ALTER TABLE `[[dbprefix]]catalog_product_attribute`
  ADD CONSTRAINT `FK_PRODUCT_ATTRIBUTE_OPTION_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_option` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_ATTRIBUTE_PRODUCT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_ATTRIBUTE_VALUE_ID` FOREIGN KEY (`option_value_id`) REFERENCES `[[dbprefix]]catalog_product_option_value` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_ATTRIBUTE_VARIATION_ID` FOREIGN KEY (`variation_id`) REFERENCES `[[dbprefix]]catalog_product_variation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_attribute_value`
--
ALTER TABLE `[[dbprefix]]catalog_product_attribute_value`
  ADD CONSTRAINT `FK_PRODUCT_ATTRIBUTE_ID` FOREIGN KEY (`product_attribute_id`) REFERENCES `[[dbprefix]]catalog_product_attribute` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_category`
--
ALTER TABLE `[[dbprefix]]catalog_product_category`
  ADD CONSTRAINT `FK_PRODUCT_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]catalog_category` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_description`
--
ALTER TABLE `[[dbprefix]]catalog_product_description`
  ADD CONSTRAINT `FK_PRODUCT_DESCRIPTION_PRODUCT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_DESCRIPTION_LANGUAGE_ID` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_image`
--
ALTER TABLE `[[dbprefix]]catalog_product_image`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_IMAGE_PRODUCT_ID_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_image_title`
--
ALTER TABLE `[[dbprefix]]catalog_product_image_title`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_IMAGE_TITLE_IMAGE` FOREIGN KEY (`image_id`) REFERENCES `[[dbprefix]]catalog_product_image` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_IMAGE_TITLE_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_manufacturer_description`
--
ALTER TABLE `[[dbprefix]]catalog_product_manufacturer_description`
  ADD CONSTRAINT `FK_PRODUCT_MANUFACTURER_TITLE_LANGUAGE_ID` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_MANUFACTURER_TITLE_MANUFACTURER_ID` FOREIGN KEY (`manufacturer_id`) REFERENCES `[[dbprefix]]catalog_product_manufacturer` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_option`
--
ALTER TABLE `[[dbprefix]]catalog_product_option`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_VALUESET` FOREIGN KEY (`valueset_id`) REFERENCES `[[dbprefix]]catalog_product_option_valueset` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_option_text`
--
ALTER TABLE `[[dbprefix]]catalog_product_option_text`
  ADD CONSTRAINT `FK_PRODUCT_OPTION_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_option` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_OPTION_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_option_value`
--
ALTER TABLE `[[dbprefix]]catalog_product_option_value`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_VALUE_VALUESET` FOREIGN KEY (`valueset_id`) REFERENCES `[[dbprefix]]catalog_product_option_valueset` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_option_value_text`
--
ALTER TABLE `[[dbprefix]]catalog_product_option_value_text`
  ADD CONSTRAINT `FK_PRODUCT_OPTION_VALUE_ID` FOREIGN KEY (`option_value_id`) REFERENCES `[[dbprefix]]catalog_product_option_value` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_PRODUCT_OPTION_VALUE_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_price_index`
--
ALTER TABLE `[[dbprefix]]catalog_product_price_index`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_PRICE_INDEX_PRODUCT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_PRICE_INDEX_SITE_ID` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_RPODUCT_PRICE_INDEX_CUSTOMER_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `[[dbprefix]]account_customer_group` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_related`
--
ALTER TABLE `[[dbprefix]]catalog_product_related`
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_RELATED_PRODUCT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CATALOG_PRODUCT_RELATED_RELATED_PRODUCT_ID` FOREIGN KEY (`related_product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_stock`
--
ALTER TABLE `[[dbprefix]]catalog_product_stock`
  ADD CONSTRAINT `FK_product_stock_id` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]catalog_product_variation`
--
ALTER TABLE `[[dbprefix]]catalog_product_variation`
  ADD CONSTRAINT `FK_PRODUCT_VARIATION_PRODUCT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]checkout_cart`
--
ALTER TABLE `[[dbprefix]]checkout_cart`
  ADD CONSTRAINT `FK_CHECKOUT_CART_SITE` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CHECKOUT_CART_CUSTOMER` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]checkout_cart_product`
--
ALTER TABLE `[[dbprefix]]checkout_cart_product`
  ADD CONSTRAINT `FK_CHECKOUT_CART_PRODUCT_CART` FOREIGN KEY (`shopping_cart_id`) REFERENCES `[[dbprefix]]checkout_cart` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_CHECKOUT_CART_PRODUCT_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]checkout_cart_product_attribute`
--
ALTER TABLE `[[dbprefix]]checkout_cart_product_attribute`
  ADD CONSTRAINT `FK_CHECKOUT_CART_PRODUCT_ATTRIBUTE_CART_PRODUCT` FOREIGN KEY (`shopping_cart_product_id`) REFERENCES `[[dbprefix]]checkout_cart_product` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_CHECKOUT_CART_PRODUCT_ATTRIBUTE_PRODUCT_ATTRIBUTE` FOREIGN KEY (`product_attribute_id`) REFERENCES `[[dbprefix]]catalog_product_attribute` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]cms_block_content`
--
ALTER TABLE `[[dbprefix]]cms_block_content`
  ADD CONSTRAINT `FK_CMS_BLOCK_CONTENT_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CMS_BLOCK_CONTENT_BLOCK_ID` FOREIGN KEY (`block_id`) REFERENCES `[[dbprefix]]cms_block` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]cms_category`
--
ALTER TABLE `[[dbprefix]]cms_category`
  ADD CONSTRAINT `FK_CMS_CATEGORY_SITE_ID` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  ADD CONSTRAINT `FK_CMS_CATEGORY_CMS_CATEGORY` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]cms_category` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]cms_category_content`
--
ALTER TABLE `[[dbprefix]]cms_category_content`
  ADD CONSTRAINT `FK_CMS_CATEGORY_CONTENT_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CMS_CATEGORY_TITLE_CMS_CATEGORY` FOREIGN KEY (`cms_category_id`) REFERENCES `[[dbprefix]]cms_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]cms_page_category`
--
ALTER TABLE `[[dbprefix]]cms_page_category`
  ADD CONSTRAINT `FK_CMS_PAGE_TO_CATEGORY_CMS_CATEGORY` FOREIGN KEY (`cms_category_id`) REFERENCES `[[dbprefix]]cms_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CMS_PAGE_TO_CATEGORY_CMS_PAGE` FOREIGN KEY (`cms_page_id`) REFERENCES `[[dbprefix]]cms_page` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]cms_page_comment`
--
ALTER TABLE `[[dbprefix]]cms_page_comment`
  ADD CONSTRAINT `FK_CMS_PAGE_COMMENT_CMS_PAGE` FOREIGN KEY (`cms_page_id`) REFERENCES `[[dbprefix]]cms_page` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]cms_page_content`
--
ALTER TABLE `[[dbprefix]]cms_page_content`
  ADD CONSTRAINT `FK_CMS_PAGE_CONTENT_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CMS_PAGE_CONTENT_CMS_PAGE` FOREIGN KEY (`cms_page_id`) REFERENCES `[[dbprefix]]cms_page` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]community_media`
--
ALTER TABLE `[[dbprefix]]community_media`
  ADD CONSTRAINT `FK_community_media_customer` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_community_media_product` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]community_review`
--
ALTER TABLE `[[dbprefix]]community_review`
  ADD CONSTRAINT `FK_community_review_customer` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_community_review_product` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]community_review_mark`
--
ALTER TABLE `[[dbprefix]]community_review_mark`
  ADD CONSTRAINT `FK_community_review_mark_review` FOREIGN KEY (`review_id`) REFERENCES `[[dbprefix]]community_review` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_community_review_mark_rating` FOREIGN KEY (`rating_id`) REFERENCES `[[dbprefix]]community_review_rating` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]community_review_rating_title`
--
ALTER TABLE `[[dbprefix]]community_review_rating_title`
  ADD CONSTRAINT `FK_community_review_rating_title_language_id` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_community_review_rating_title_rating_id` FOREIGN KEY (`rating_id`) REFERENCES `[[dbprefix]]community_review_rating` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]contacts_department_name`
--
ALTER TABLE `[[dbprefix]]contacts_department_name`
  ADD CONSTRAINT `FK_CONTACTS_DEPARTMENT_NAME_DEPARTMENT` FOREIGN KEY (`department_id`) REFERENCES `[[dbprefix]]contacts_department` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_CONTACTS_DEPARTMENT_NAME_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]contacts_message`
--
ALTER TABLE `[[dbprefix]]contacts_message`
  ADD CONSTRAINT `FK_contacts_message_department_id` FOREIGN KEY (`department_id`) REFERENCES `[[dbprefix]]contacts_department` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION;

--
-- Constraints for table `[[dbprefix]]core_config_value`
--
ALTER TABLE `[[dbprefix]]core_config_value`
  ADD CONSTRAINT `FK_config_field_id` FOREIGN KEY (`config_field_id`) REFERENCES `[[dbprefix]]core_config_field` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]core_module_upgrade`
--
ALTER TABLE `[[dbprefix]]core_module_upgrade`
  ADD CONSTRAINT `fk_module_id` FOREIGN KEY (`module_id`) REFERENCES `[[dbprefix]]core_module` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]core_template_box`
--
ALTER TABLE `[[dbprefix]]core_template_box`
  ADD CONSTRAINT `FK_core_template_box_template_id` FOREIGN KEY (`template_id`) REFERENCES `[[dbprefix]]core_template` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]core_template_box_page`
--
ALTER TABLE `[[dbprefix]]core_template_box_page`
  ADD CONSTRAINT `FK_core_template_box_page_box_id` FOREIGN KEY (`box_id`) REFERENCES `[[dbprefix]]core_template_box` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_core_template_box_page_page_id` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]core_page` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Constraints for table `[[dbprefix]]core_template_page`
--
ALTER TABLE `[[dbprefix]]core_template_page`
  ADD CONSTRAINT `FK_template_layout_to_page_page_id` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]core_page` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_template_layout_to_page_template_id` FOREIGN KEY (`template_id`) REFERENCES `[[dbprefix]]core_template` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]csv_profile_filter`
--
ALTER TABLE `[[dbprefix]]csv_profile_filter`
  ADD CONSTRAINT `FK_csv_profile_filter_id` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]csv_profile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]discount_eav`
--
ALTER TABLE `[[dbprefix]]discount_eav`
  ADD CONSTRAINT `discount_fk_constraint` FOREIGN KEY (`discount_id`) REFERENCES `[[dbprefix]]discount` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]location_country`
--
ALTER TABLE `[[dbprefix]]location_country`
  ADD CONSTRAINT `FK_LOCATION_COUNTRY_FORMAT` FOREIGN KEY (`address_format_id`) REFERENCES `[[dbprefix]]location_address_format` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]location_geozone_zone`
--
ALTER TABLE `[[dbprefix]]location_geozone_zone`
  ADD CONSTRAINT `FK_LOCATION_GEOZONE_ZONE_COUNTRY` FOREIGN KEY (`country_id`) REFERENCES `[[dbprefix]]location_country` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_LOCATION_GEOZONE_ZONE_GEOZONE` FOREIGN KEY (`geozone_id`) REFERENCES `[[dbprefix]]location_geozone` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_LOCATION_GEOZONE_ZONE_ZONE` FOREIGN KEY (`zone_id`) REFERENCES `[[dbprefix]]location_zone` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]location_zone`
--
ALTER TABLE `[[dbprefix]]location_zone`
  ADD CONSTRAINT `FK_LOCATION_ZONE_COUNTRY` FOREIGN KEY (`country_id`) REFERENCES `[[dbprefix]]location_country` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]payment_authorizenetaim_standard_order`
--
ALTER TABLE `[[dbprefix]]payment_authorizenetaim_standard_order`
  ADD CONSTRAINT `FK_paymnet_authorizenetaimstandard_order_1` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]payment_paypal_standard_order`
--
ALTER TABLE `[[dbprefix]]payment_paypal_standard_order`
  ADD CONSTRAINT `FK_paymnet_paypalstandard_order_1` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]poll_answer`
--
ALTER TABLE `[[dbprefix]]poll_answer`
  ADD CONSTRAINT `FK_POLL_ANSWER_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_POLL_ANSWER_QUESTION` FOREIGN KEY (`question_id`) REFERENCES `[[dbprefix]]poll_question` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]poll_question_description`
--
ALTER TABLE `[[dbprefix]]poll_question_description`
  ADD CONSTRAINT `FK_POLL_QUESTION_DESCRIPTION_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_POLL_QUESTION_DESCRIPTION_QUESTION` FOREIGN KEY (`question_id`) REFERENCES `[[dbprefix]]poll_question` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]poll_question_site`
--
ALTER TABLE `[[dbprefix]]poll_question_site`
  ADD CONSTRAINT `FK_POLL_QUESTION_SITE_QUESTION` FOREIGN KEY (`question_id`) REFERENCES `[[dbprefix]]poll_question` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_POLL_QUESTION_SITE_SITE` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]poll_vote`
--
ALTER TABLE `[[dbprefix]]poll_vote`
  ADD CONSTRAINT `FK_POLL_VOTE_CUSTOMER` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_POLL_VOTE_ANSWER` FOREIGN KEY (`answer_id`) REFERENCES `[[dbprefix]]poll_answer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_creditcard`
--
ALTER TABLE `[[dbprefix]]sales_order_creditcard`
  ADD CONSTRAINT `FK_SALES_ORDER_CREDITCARD_ORDER` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_product`
--
ALTER TABLE `[[dbprefix]]sales_order_product`
  ADD CONSTRAINT `FK_SALES_ORDER_PRODUCT` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_product_attribute`
--
ALTER TABLE `[[dbprefix]]sales_order_product_attribute`
  ADD CONSTRAINT `FK_SALES_ORDER_PRODUCT_ATTRIBUTE` FOREIGN KEY (`order_product_id`) REFERENCES `[[dbprefix]]sales_order_product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_status_history`
--
ALTER TABLE `[[dbprefix]]sales_order_status_history`
  ADD CONSTRAINT `FK_SALES_ORDER_STATUS_HISTORY_ORDER` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_status_relation`
--
ALTER TABLE `[[dbprefix]]sales_order_status_relation`
  ADD CONSTRAINT `FK_SALES_ORDER_STATUS_RELATION_TO` FOREIGN KEY (`to_status`) REFERENCES `[[dbprefix]]sales_order_status` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_SALES_ORDER_STATUS_RELATION_FROM` FOREIGN KEY (`from_status`) REFERENCES `[[dbprefix]]sales_order_status` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_status_text`
--
ALTER TABLE `[[dbprefix]]sales_order_status_text`
  ADD CONSTRAINT `FK_SALES_ORDER_STATUS_TEXT_STATUS` FOREIGN KEY (`status_id`) REFERENCES `[[dbprefix]]sales_order_status` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_SALES_ORDER_STATUS_TEXT_LANGUAGE` FOREIGN KEY (`language_id`) REFERENCES `[[dbprefix]]locale_language` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]sales_order_total`
--
ALTER TABLE `[[dbprefix]]sales_order_total`
  ADD CONSTRAINT `FK_SALES_ORDER_TOTAL_ORDER` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sitemap`
--
ALTER TABLE `[[dbprefix]]sitemap`
  ADD CONSTRAINT `FK_sitemap_file_site` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]tag_customer`
--
ALTER TABLE `[[dbprefix]]tag_customer`
  ADD CONSTRAINT `FK_customer_tag_customer` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]account_customer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_customer_tag_site` FOREIGN KEY (`site_id`) REFERENCES `[[dbprefix]]core_site` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]tag_product`
--
ALTER TABLE `[[dbprefix]]tag_product`
  ADD CONSTRAINT `FK_customer_tag_product_id` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_customer_tag_product_customer` FOREIGN KEY (`customer_tag_id`) REFERENCES `[[dbprefix]]tag_customer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]tax_rate`
--
ALTER TABLE `[[dbprefix]]tax_rate`
  ADD CONSTRAINT `FK_tax_customer_group` FOREIGN KEY (`customer_group_id`) REFERENCES `[[dbprefix]]account_customer_group` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_tax_geozone` FOREIGN KEY (`geozone_id`) REFERENCES `[[dbprefix]]location_geozone` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_tax_rate_class` FOREIGN KEY (`tax_class_id`) REFERENCES `[[dbprefix]]tax_class` (`id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
