<?php
/**
 * Axis
 *
 * This file is part of Axis.
 *
 * Axis is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Axis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Axis.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @category    Axis
 * @package     Axis_View
 * @subpackage  Axis_View_Helper
 * @copyright   Copyright 2008-2012 Axis
 * @license     GNU Public License V3.0
 */

/**
 *
 * @category    Axis
 * @package     Axis_View
 * @subpackage  Axis_View_Helper
 * @author      Axis Core Team <core@axiscommerce.com>
 */
class Axis_View_Helper_ShippingForm
{
    /**
     * Return additional paymet form
     * @return string
     * @param object|string $payment
     * @param string $template example: 'view', 'form', 'process' etc
     */
    public function shippingForm($shippingCode, $template, $area = null)
    {
        if ($shippingCode instanceof Axis_Method_Shipping_Model_Abstract) {
            $this->view->shipping = $shippingCode;
            $shippingCode = $this->view->shipping->getCode();
        } else {
            $this->view->shipping = Axis_Shipping::getMethod($shippingCode);
        }

        if (null === $area) {
            $area = $this->view->area;
        }

        $shortPath = 'shipping'
            . str_replace('_', '/', strtolower($shippingCode))
            . '/' . $template . '.phtml';

        $fallbackList = array_unique(array(
            $this->view->templateName,
            /* $this->view->defaultTemplate */
            'fallback',
            'default'
        ));
        foreach ($fallbackList as $fallback) {
            $templatePath = $this->view->path 
                . '/app/design/' 
                . $area
                . '/'
                . $fallback
                . '/templates';
            
            if (is_readable($templatePath . '/' . $shortPath)) {
                return $this->view->render($shortPath);
            }
        }

        return '';
    }

    public function setView($view)
    {
        $this->view = $view;
    }
}
