<?php
/**
 * Axis
 *
 * This file is part of Axis.
 *
 * Axis is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Axis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Axis.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @category    Axis
 * @package     Axis_Locale
 * @subpackage  Axis_Locale_Model
 * @copyright   Copyright 2008-2012 Axis
 * @license     GNU Public License V3.0
 */

/**
 *
 * @category    Axis
 * @package     Axis_Locale
 * @subpackage  Axis_Locale_Model
 * @author      Axis Core Team <core@axiscommerce.com>
 */
class Axis_Locale_Model_Option_Currency_Position extends Axis_Config_Option_Array_Abstract 
{
    const STANDARD = 8;
    const RIGHT    = 16;
    const LEFT     = 32;

    /**
     * 
     * @return array
     */
    protected function _loadCollection()
    {
        return array(
            self::STANDARD => Axis::translate('locale')->__('Standard'),
            self::RIGHT    => Axis::translate('locale')->__('Right'),
            self::LEFT     => Axis::translate('locale')->__('Left')
        );
    }
}