<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php
/***** Do not edit this file, instead overwrite the changes in conf.local.php *****/

$conf = array();

/***** Directories *****/
$conf['base_dir'] = dirname(dirname(dirname(__FILE__))) . '/';
$conf['system_dir'] = $conf['base_dir'] . 'avactis-system/';
$conf['conf_dir'] = $conf['base_dir'] . 'avactis-conf/';
$conf['modules_dir'] = $conf['system_dir'] . 'modules/';
$conf['add_modules_dir'] = $conf['base_dir'] . 'avactis-extensions/';
$conf['cache_dir'] = $conf['conf_dir'] . 'cache/';
$conf['backup_dir'] = $conf['conf_dir'] . 'backup/';
$conf['themes_backup_dir'] = $conf['backup_dir'] . 'themes/';


/***** MySQL Engine *****/
$conf['mysql_table_engine'] = 'MyISAM'; // MyISAM | InnoDB

/***** Trace Log Settings *****/

// you may configure many trace loggers as you want
$conf['tracelog'] = array();

// default trace logger - log only err of wrn messages
// Note! Must be defined all values.
$conf['tracelog'][10] = array(
    'enabled' => 'yes',
    // any writable file
    'file' => $conf['cache_dir'] . '../cache/avactis_log',
    //"[@id] [@level] [@date @time.@microtime] [@delta_time] [@mem] [@delta_mem] [@filepath] [@file:@line] [@class@func()]";
    'template' => "[@id] [@level] [@date @time] [@class@func] [@file:@line]",
    'rotation' => array(
                    'size' => 1.0, // Megabytes
                    'rotate' => 10  // Integer
                )
);

// you may filter by 'level', 'file' (full path), 'func' and 'class'
// between fields will be applied AND rule, between field values will be applied OR rule
$conf['tracelog'][10]['filter'] = array(
    'level' => array('err', 'wrn')
);


/***** Profiler Settings *****/
$conf['profiler'] = array(
    'enabled' => 'no',
    'display_include' => 'no',
    'display_file_io' => 'no',
    'display_queries' => 'no',
    'display_cache' => 'no',
	'display_block_tags' => 'no',
    'write_csv' => 'no',
);


/***** Gift Certificate Image *****/
$conf['gc_image_name'] = array(
    'largeimage' => 'gc.png',
    'smallimage' => 'gc.png'
);


/***** Cache Engine Types ****/
$conf['cache_storages'] = array(
    'FILE' => array(
                'driver' => 'CCacheDriverFile',
                'args' => array(
                            0 => $conf['cache_dir'], // dir_storage
                        ),
            ),
    'SINGLE_FILE' => array(
                'driver' => 'CCacheDriverSingleFile',
                'args' => array(
                            0 => $conf['cache_dir'], // dir_storage
                            1 => 'global.common', // cache_file_label
                        ),
            ),
    'SINGLE_FILE_AZ' => array(
                'driver' => 'CCacheDriverSingleFile',
                'args' => array(
                            0 => $conf['cache_dir'], // dir_storage
                            1 => 'global.AdminZone', // cache_file_label
                        ),
            ),
    'SINGLE_FILE_CZ' => array(
                'driver' => 'CCacheDriverSingleFile',
                'args' => array(
                            0 => $conf['cache_dir'], // dir_storage
                            1 => 'global.CustomerZone', // cache_file_label
                        ),
            ),
    'RAM'=> array(
				'driver' => 'CCacheDriverRAM',
		),
    'NULL'=> array(
                'driver' => 'CCacheDriverNull',
            ),
    /* only for reference
	'MEMCACHED' => array(
                'driver' => 'CCacheDriverMemcached',
                'args' => array(
                            0 => '127.0.0.1', // host
                            1 => '11211', // port
                        ),
            ),
	'REDIS' => array(
     		'driver'=>'CCacheDriverRedis',
     		'args'=> array(
     			0 => '127.0.0.1',
     			1 => '6379',
     		),
		),
    'APC'=> array(
                'driver' => 'CCacheDriverAPC',
	),*/
);

if (APC_EXTENSION_LOADED === true) {
	$conf['cache_storages'] = array_merge($conf['cache_storages'],array('APC'=>array('driver'=>'CCacheDriverAPC')));
}


/***** Cache Configuration ****/
$conf['cache'] = array(
	// FORMAT: 'namespace' => 'storage'

	// common:
	'persistent'    => 'SINGLE_FILE',
	'temporary'     => 'RAM',

	// special:
	'database'       => 'SINGLE_FILE',
	'templatesAZ'    => 'SINGLE_FILE_AZ',
	'modulesAZ'      => 'SINGLE_FILE_AZ',
	'templatesCZ'    => 'SINGLE_FILE_CZ',
	'modulesCZ'      => 'SINGLE_FILE_CZ',
	'inifiles'       => 'SINGLE_FILE',
	'hash'           => 'SINGLE_FILE',
	'attr_ids'       => 'SINGLE_FILE',
	'checkout'       => 'RAM',
);

// HTTP request variable name
$conf['variable_skin_name'] = 'scsbn';

/**
 * To activate combining, first run: avactis-system/admin/index.php?asc_action=combine_php
 * Drop combined files in emergency: avactis-system/admin/drop_combined_php.php
 */
$conf['preload_core_php'] = array(
    'combined_file' => $conf['cache_dir'].'combined.core.php',
    'files' => array(
        'core/PEAR.php',
        'core/Blowfish.php',
        'core/Blowfish/DefaultKey.php',
        'core/Blowfish/PHP.php',
        'core/Blowfish/MCrypt.php',
        'core/Blowfish/ECB.php',
        'core/RSA/ErrorHandler.php',
        'core/RSA/KeyPair.php',
        'core/RSA/Key.php',
        'core/RSA/MathLoader.php',
        'core/RSA.php',

        'core/CFileLock.php',
        'core/dbquery.php',
        'core/db_delete.php',
        'core/db_insert.php',
        'core/db_insert_select.php',
        'core/db_multiple_insert.php',
        'core/db_multiple_replace.php',
        'core/db_mysql_lock_tables.php',
        'core/db_mysql.php',
        'core/db_mysql_unlock_tables.php',
        'core/db_replace.php',
        'core/db_select.php',
        'core/db_table_clone.php',
        'core/db_table_create.php',
        'core/db_table_delete.php',
        'core/db_table_move.php',
        'core/db_update.php',

        'core/abstract/pm_sm_api.php',
        'core/abstract/pm_sm_input_az.php',
        'core/abstract/update_pm_sm_action.php',
        'core/action_message.php',
        'core/ajax_action.php',
        'core/application.php',

// new cache
        'core/ICacheStorage.php',
        'core/ICacheDriver.php',
        'core/CObject.php',
        'core/CCacheDriverNull.php',
        'core/CCacheDriverRAM.php',
        'core/CCacheDriverAPC.php',
        'core/CCacheDriverFile.php',
        'core/CCacheDriverMemcached.php',
        'core/CCacheDriverRedis.php',
        'core/CCacheDriverSingleFile.php',
        'core/CCacheItem.php',
        'core/CCacheStorage.php',
        'core/CCacheStorageWrapperNamespace.php',
        'core/CCacheFactory.php',

        'core/cdatetimeperiods.php',
        'core/cdatetime.php',
        'core/cstoredatetime.php',
        'core/request.php',
        'core/cz_request.php',
        'core/factory.php',
        'core/html_form.php',
        'core/image_obj.php',
        'core/io_disk.php',
        'core/JSON.php',
        'core/layout_configuration_manager.php',
        'core/message_resources.php',
        'core/multilang_core.php',
        'core/NullView.php',
        'core/phpSniff.core.php',
        'core/phpSniff.class.php',
        'core/query_executer.php',
        'core/replacer.php',
        'core/session_db.php',
        'core/session.php',
        'core/spyc.php',
        'core/tag_param_stack.php',
        'core/template_filler.php',
        'core/tmpl_filler.php',
        'core/tmpl_includer.php',
        'core/URI.class.php',
        'core/urlm.php',
        'core/UUIDUtils.php',
        'core/validator.php',
        'core/version.php',
        'core/plugin.php',
        'core/kses.php',
        'core/formatting.php',
        'core/script-loader.php',
        'core/default-filters.php',

        'includes/nav-menu.php',
        'includes/nav-menu-template.php',
        'includes/option.php',
        'includes/general-template.php',
        'includes/theme.php',

        'modules/modules_manager/abstract/module_info.php',
        'modules/modules_manager/dbqueries/common.php',
        'modules/modules_manager/mm_api.php',
        'modules/resources/const.php',
        'modules/resources/resources_api.php',
        'modules/resources/dbqueries/common.php',
        'modules/multilang/multilang_api.php',
        'modules/multilang/dbqueries/common.php',
        'modules/configuration/const.php',
        'modules/configuration/configuration_api.php',
        'modules/configuration/abstract/settings.php',
        'modules/configuration/dbqueries/common.php',
        'modules/eventsmanager/events_manager_api.php',
        'modules/menu_manager/menu_api.php'
    ),
);

$conf['preload_modules_php'] = array(
    'combined_file' => $conf['cache_dir'].'combined.modules.php',
    'files' => array(
        'bestsellers_api/const.php',
        'bestsellers_api/bestsellers_api.php',
        'bestsellers_api/dbqueries/common.php',

        'cart/cart_api.php',

        'catalog/const.php',
        'catalog/catalog_api.php',
        'catalog/dbqueries/common.php',
        'catalog/abstract/catalog_search.php',
        'catalog/abstract/category_class.php',
        'catalog/abstract/product_class.php',
        'catalog/abstract/product_list_filter.php',
        'catalog/abstract/product_list_tag_settings.php',
        'catalog/actions/setcurrcat_action.php',

        'charts/const.php',

        'checkout/const.php',
        'checkout/checkout_api.php',
        'checkout/dbqueries/common.php',

        'cms/abstract/cms_page_info.php',
        'cms/cms_api.php',
        'cms/const.php',
        'cms/dbqueries/common.php',

        'crypto/crypto_api.php',

        'currency_converter/const.php',
        'currency_converter/currency_converter_api.php',
        'currency_converter/dbqueries/common.php',

        'customer_account/const.php',
        'customer_account/customer_account_api.php',
        'customer_account/dbqueries/common.php',

        'customer_reviews/const.php',
        'customer_reviews/customer_reviews_api.php',
        'customer_reviews/abstract/product_review_info.php',
        'customer_reviews/dbqueries/common.php',

        'data_converter/const.php',

        'discounts/discounts_api.php',
        'discounts/dbqueries/common.php',

        'eventsmanager/dbqueries/common.php',

        'featured_products/const.php',
        'featured_products/featured_products_api.php',
        'featured_products/dbqueries/common.php',

        'gift_certificate/const.php',
        'gift_certificate/gift_certificate_api.php',
        'gift_certificate/abstract/gift_certificate_classes.php',
        'gift_certificate/dbqueries/common.php',

        'images/const.php',
        'images/images_api.php',
        'images/dbqueries/common.php',

        'last_viewed_products/last_viewed_products_api.php',

        'layout_cms/const.php',
        'layout_cms/layout_cms_api.php',

        'localization/const.php',
        'localization/localization_api.php',
        'localization/dbqueries/common.php',

        'location/location_api.php',
        'location/dbqueries/common.php',

        'look_feel/const.php',
        'look_feel/look_feel_api.php',

        'manufacturers/const.php',
        'manufacturers/manufacturers_api.php',
        'manufacturers/dbqueries/common.php',

        'mod_rewrite/const.php',
        'mod_rewrite/mod_rewrite_api.php',
        'mod_rewrite/dbqueries/common.php',

        'modules_manager/actions/action_is_not_set.php',

        'newsletter/const.php',
        'newsletter/dbqueries/common.php',
        'newsletter/newsletter_api.php',

        'paginator/paginator_api.php',

        'payment_module_chase_cc/const.php',
        'payment_module_cod/payment_module_cod_api.php',
        'payment_module_cyberbit_cc/dbqueries/common.php',
        'payment_module_dibs_cc/const.php',
        'payment_module_direct_deposit/payment_module_direct_deposit_api.php',
        'payment_module_epdq_cc/const.php',
        'payment_module_epn_cc/const.php',
        'payment_module_eway_cc/const.php',
        'payment_module_ideal_cc/const.php',
        'payment_module_nexcommerce_cc/const.php',
        'payment_module_offline_cc/dbqueries/common.php',
        'payment_module_orbital_cc/const.php',
        'payment_module_protx_direct_cc/const.php',
        'payment_module_tranzila_cc/const.php',

        'product_images/product_images_api.php',
        'product_images/dbqueries/common.php',

        'product_options/const.php',
        'product_options/product_options_api.php',
        'product_options/dbqueries/common.php',

        'promocodes/const.php',
        'promocodes/promo_codes_api.php',
        'promocodes/dbqueries/common.php',

        'quantity_discounts/const.php',
        'quantity_discounts/quantity_discounts_api.php',
        'quantity_discounts/dbqueries/common.php',

        'related_products/const.php',
        'related_products/related_products_api.php',
        'related_products/dbqueries/common.php',

        'reports/const.php',
        'reports/reports_api.php',
        'reports/abstract/report_data_collector.php',
        'reports/dbqueries/common.php',
        'reports/report-collectors/report_data_product_stat_collector.php',
        'reports/report-collectors/report_data_visitors_stat_collector.php',

        'shell/const.php',

        'shipping_cost_calculator/const.php',
        'shipping_cost_calculator/shipping_cost_calculator_api.php',
        'shipping_cost_calculator/dbqueries/common.php',

        'shipping_module_aup/dbqueries/common.php',
        'shipping_module_cpc/dbqueries/common.php',
        'shipping_module_dsr/dbqueries/common.php',
        'shipping_module_fedex/dbqueries/common.php',
        'shipping_module_flat_shipping_rates/dbqueries/common.php',
        'shipping_module_freight101/dbqueries/common.php',
        'shipping_module_intershipper/dbqueries/common.php',
        'shipping_module_ups/dbqueries/common.php',
        'shipping_module_usps/dbqueries/common.php',

        'statistics/const.php',

        'subscriptions/const.php',
        'subscriptions/subscriptions_api.php',
        'subscriptions/dbqueries/common.php',

        'taxes/const.php',
        'taxes/taxes_api.php',
        'taxes/dbqueries/common.php',

        'tax_exempts/const.php',
        'tax_exempts/tax_exempts_api.php',
        'tax_exempts/dbqueries/common.php',

        'tax_rate_by_zip/dbqueries/common.php',

        'timeline/const.php',
        'timeline/dbqueries/common.php',
        'timeline/timeline_api.php',

        'transaction_tracking/const.php',
        'transaction_tracking/transaction_tracking_api.php',
        'transaction_tracking/dbqueries/common.php',

        'users/users_api.php',
        'users/dbqueries/common.php',

        'wishlist/wishlist_api.php',
        'wishlist/dbqueries/common.php',

        'eventstack/event_stack_api.php',
        'eventstack/dbqueries/common.php',

        'most_viewed_products/most_viewed_products_api.php',
        'most_viewed_products/dbqueries/common.php',

        'rest/rest_api.php',
        'rest/dbqueries/common.php',

        'top_rated_products/top_rated_products_api.php',
        'top_rated_products/dbqueries/common.php',
    ),
);

$conf['preload_modules_views_cz_php'] = array(
    'combined_file' => $conf['cache_dir'].'combined.modules.views.cz.php',
    'files' => array(
        'bestsellers_api/views/bestsellers_cz.php',
        'cart/views/cart_content.php',
        'cart/views/cart_thumbnail.php',
        'catalog/abstract/product_info.php',
        'catalog/actions/setcurrprod_action.php',
        'catalog/views/cat_breadcrumb_cz.php',
        'catalog/views/cr_product_info_cz.php',
        'catalog/views/navigation-bar-custom-cz.php',
        'catalog/views/navigation-bar-cz.php',
        'catalog/views/prodslist_cz.php',
        'catalog/views/product_info_cz.php',
        'catalog/views/product_list_sorter_cz.php',
        'catalog/views/product_set_view.php',
        'catalog/views/product_type_filter_cz.php',
        'catalog/views/search_form_cz.php',
        'catalog/views/search_result_cz.php',
        'catalog/views/subcategories_cz.php',

        'checkout/abstract/person_info_input_cz.php',
        'checkout/abstract/person_info_output_cz.php',
        'checkout/hooks/step_id_is_not_set.php',
        'checkout/views/checkout-bank-account-info-input-cz.php',
        'checkout/views/checkout-bank-account-info-output-cz.php',
        'checkout/views/checkout-billing-info-input-cz.php',
        'checkout/views/checkout-billing-info-output-cz.php',
        'checkout/views/checkout-credit-card-info-input-cz.php',
        'checkout/views/checkout-credit-card-info-output-cz.php',
        'checkout/views/checkout-customer-info-input-cz.php',
        'checkout/views/checkout-customer-info-output-cz.php',
        'checkout/views/checkout-navigation-bar-cz.php',
        'checkout/views/checkout-order-cz.php',
        'checkout/views/checkout-shipping-info-input-cz.php',
        'checkout/views/checkout-shipping-info-output-cz.php',
        'checkout/views/checkout-shipping-methods-output.php',
        'checkout/views/checkout-shipping-methods-select.php',
        'checkout/views/checkout-step-link-cz.php',
        'checkout/views/checkout-view-cz.php',
        'checkout/views/one-step-checkout-cz.php',
        'cms/views/cms_menu_cz.php',
        'cms/views/cms_page_cz.php',
        'cms/views/cms_page_tree_cz.php',

        'cms/views/pageview_cz.php',
        'customer_account/abstract/customer_info.php',
        'customer_account/hooks/check_account_before_page_out.php',
        'customer_account/views/auth_box_cz.php',
        'customer_account/views/customer_change_password_form_cz.php',
        'customer_account/views/customer_forgot_password_form_cz.php',
        'customer_account/views/customer_home_page.php',
        'customer_account/views/customer_new_password_form_cz.php',
        'customer_account/views/customer_order_download_links_cz.php',
        'customer_account/views/customer_order_info_cz.php',
        'customer_account/views/customer_order_invoice_cz.php',
        'customer_account/views/customer_order_list_cz.php',

        'customer_account/views/customer_order_search_by_id_form_cz.php',
        'customer_account/views/customer_order_search_form_cz.php',
        'customer_account/views/customer_orders_history_cz.php',
        'customer_account/views/customer_personal_info_cz.php',
        'customer_account/views/reg_form_cz.php',
        'customer_account/views/reg_msg_cz.php',
        'customer_reviews/views/cr_product_add_review_form_cz.php',
        'customer_reviews/views/cr_product_add_review_link_cz.php',
        'customer_reviews/views/cr_product_detailed_rating_cz.php',
        'customer_reviews/views/cr_product_rating_cz.php',
        'customer_reviews/views/cr_product_review_list_cz.php',

        'error/views/error_view.php',
        'error/views/a_error.php',
        'error/views/c_error.php',

        'featured_products/views/featured_products_cz.php',
        'gift_certificate/views/gc_add_cz.php',
        'gift_certificate/views/gc_create_cz.php',
        'images/views/image_output_cz.php',
        'last_viewed_products/views/last_viewed_products_cz.php',
        'localization/views/currency_selector_cz.php',
        'manufacturers/views/manufacturer_info_cz.php',
        'manufacturers/views/manufacturers_filter_cz.php',
        'multilang/views/ml_select_language_cz.php',
        'paginator/views/paginator_line.php',
        'paginator/views/paginator_rows_per_page.php',
        'product_files/views/download_product_file_prompt_cz.php',
        'product_images/views/images_block_cz.php',
        'product_options/views/options-choice-cz.php',
        'product_options/views/options-combination-cz.php',
        'product_options/views/options-warnings-cz.php',
        'promocodes/views/promo_code_form_cz.php',
        'related_products/views/related_products_cz.php',
        'reports/views/one_tag_reports.php',
        'shipping_cost_calculator/views/shipping_calculator_cz.php',
        'subscriptions/abstract/subscribe_cz.php',
        'subscriptions/views/subscribe_box_cz.php',
        'subscriptions/views/subscribe_form_profile_cz.php',
        'subscriptions/views/subscribe_on_checkout_cz.php',
        'subscriptions/views/subscribe_on_checkout_output_cz.php',
        'subscriptions/views/unsubscribe_by_link_cz.php',
        'tax_exempts/views/full_tax_exempt_form_cz.php',
        'transaction_tracking/views/transaction-tracking-html-code-cz.php',
        'transaction_tracking/views/visitor-tracking-code-cz.php',
        'wishlist/views/wl_add_to_wishlist_button_cz.php',
        'wishlist/views/wl_send_wishlist_content_cz.php',
        'wishlist/views/wl_wishlist_content_cz.php',

    ),
);

if ( file_exists($conf['system_dir'].'conf/conf.local.php') )
			rename($conf['system_dir'].'conf/conf.local.php',$conf['conf_dir'].'conf.local.php');

include_once($conf['conf_dir'].'conf.local.php');
