<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php

/**
 * Configuration Module, Cache Settings.
 *
 * @package Configuration
 * @author Alexey Florinsky
 */
class CacheSettings
{
//------------------------------------------------
//               PUBLIC DECLARATION
//------------------------------------------------

    /**#@+
     * @access public
     */

    /**
     * CacheSettings constructor.
     */
    function CacheSettings()
    {
        global $application;
        $this->MessageResources = &$application->getInstance('MessageResources');
    }

    /**
     *
     */
    function output()
    {
        global $application;

        $application->registerAttributes(array('ResultMessageRow', 'ResultMessage','CacheConfigurations'));

        return modApiFunc('TmplFiller', 'fill', "configuration/cache_settings/","container.tpl.html", array());
    }

	function outputCacheConfigurations()
	{
		return modApiFunc('TmplFiller', 'fill', "configuration/cache_settings/","cache_configurations.tpl.html", array());
	}

    function outputResultMessage()
    {
        global $application;
        if(modApiFunc("Session","is_set","ResultMessage"))
        {
			$code = '';
			if(modApiFunc("Session","is_set","ResultCode"))
			{
	            $code.="<br>".modApiFunc("Session","get","ResultCode");
	            modApiFunc("Session","un_set","ResultCode");
			}
            $msg=modApiFunc("Session","get","ResultMessage");
            modApiFunc("Session","un_set","ResultMessage");
            $template_contents=array(
                "ResultMessage" => getMsg('SYS',$msg).$code
            );
            $this->_Template_Contents=$template_contents;
            $application->registerAttributes($this->_Template_Contents);
            $this->mTmplFiller = &$application->getInstance('TmplFiller');
            return $this->mTmplFiller->fill("configuration/cache_settings/", "result-message.tpl.html",array());
        }
        else
        {
            return "";
        }
    }

    function getTag($tag)
	{
		global $application;
		$value = null;
		switch ($tag)
		{
            case 'ResultMessageRow':
            	$value = $this->outputResultMessage();
                break;
            case 'ResultMessage':
            	$value = $this->_Template_Contents['ResultMessage'];
            	break;
			case 'CacheConfigurations':
            	$value = $this->outputCacheConfigurations();
            	break;
		}
		return $value;
	}


    /**#@-*/

//------------------------------------------------
//              PRIVATE DECLARATION
//------------------------------------------------

    /**#@+
     * @access private
     */

    var $MessageResources;
    var $_selectCacheLevelOptionData;

    /**#@-*/

}
?>