<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php
/**
 * Sets up the default filters and actions for most
 * of the WordPress hooks.
 *
 * If you need to remove a default hook, this file will
 * give you the priority for which to use to remove the
 * hook.
 *
 * Not all of the default hooks are found in default-filters.php
 *
 * @package WordPress
 */

// Strip, trim, kses, special chars for string saves
foreach ( array( 'pre_term_name', 'pre_comment_author_name', 'pre_link_name', 'pre_link_target', 'pre_link_rel', 'pre_user_display_name', 'pre_user_first_name', 'pre_user_last_name', 'pre_user_nickname' ) as $filter ) {
	asc_add_filter( $filter, 'asc_sanitize_text_field'  );
	asc_add_filter( $filter, 'asc_filter_kses'       );
	asc_add_filter( $filter, '_asc_specialchars', 30 );
}

/*// Strip, kses, special chars for string display
foreach ( array( 'term_name', 'comment_author_name', 'link_name', 'link_target', 'link_rel', 'user_display_name', 'user_first_name', 'user_last_name', 'user_nickname' ) as $filter ) {
	if ( is_admin() ) {
		// These are expensive. Run only on admin pages for defense in depth.
		asc_add_filter( $filter, 'asc_sanitize_text_field'  );
		asc_add_filter( $filter, 'asc_kses_data'       );
	}
	asc_add_filter( $filter, '_asc_specialchars', 30 );
}
*/
// Kses only for textarea saves
foreach ( array( 'pre_term_description', 'pre_link_description', 'pre_link_notes', 'pre_user_description' ) as $filter ) {
	asc_add_filter( $filter, 'asc_filter_kses' );
}
/*
// Kses only for textarea admin displays
if ( is_admin() ) {
	foreach ( array( 'term_description', 'link_description', 'link_notes', 'user_description' ) as $filter ) {
		asc_add_filter( $filter, 'asc_kses_data' );
	}
	asc_add_filter( 'comment_text', 'asc_kses_post' );
}
*/
// Email saves
foreach ( array( 'pre_comment_author_email', 'pre_user_email' ) as $filter ) {
	asc_add_filter( $filter, 'trim'           );
	asc_add_filter( $filter, 'asc_sanitize_email' );
	asc_add_filter( $filter, 'asc_filter_kses' );
}
/*
// Email admin display
foreach ( array( 'comment_author_email', 'user_email' ) as $filter ) {
	asc_add_filter( $filter, 'asc_sanitize_email' );
	if ( is_admin() )
		asc_add_filter( $filter, 'asc_kses_data' );
}
*/
// Save URL
foreach ( array( 'pre_comment_author_url', 'pre_user_url', 'pre_link_url', 'pre_link_image',
	'pre_link_rss', 'pre_post_guid' ) as $filter ) {
	asc_add_filter( $filter, 'asc_strip_all_tags' );
	asc_add_filter( $filter, 'asc_esc_url_raw'       );
	asc_add_filter( $filter, 'asc_filter_kses'    );
}
/*
// Display URL
foreach ( array( 'user_url', 'link_url', 'link_image', 'link_rss', 'comment_url', 'post_guid' ) as $filter ) {
	if ( is_admin() )
		asc_add_filter( $filter, 'asc_strip_all_tags' );
	asc_add_filter( $filter, 'esc_url'           );
	if ( is_admin() )
		asc_add_filter( $filter, 'asc_kses_data'    );
}
*/
// Slugs
asc_add_filter( 'pre_term_slug', 'asc_sanitize_title' );

// Keys
foreach ( array( 'pre_post_type', 'pre_post_status', 'pre_post_comment_status', 'pre_post_ping_status' ) as $filter ) {
	asc_add_filter( $filter, 'asc_sanitize_key' );
}

// Mime types
asc_add_filter( 'pre_post_mime_type', 'asc_sanitize_mime_type' );
asc_add_filter( 'post_mime_type', 'asc_sanitize_mime_type' );

// Places to balance tags on input
foreach ( array( 'content_save_pre', 'excerpt_save_pre', 'comment_save_pre', 'pre_comment_content' ) as $filter ) {
	asc_add_filter( $filter, 'asc_balanceTags', 50 );
}

// Format strings for display.
foreach ( array( 'comment_author', 'term_name', 'link_name', 'link_description', 'link_notes', 'bloginfo', 'asc_title', 'widget_title' ) as $filter ) {
	asc_add_filter( $filter, 'asc_wptexturize'   );
	asc_add_filter( $filter, 'asc_convert_chars' );
	asc_add_filter( $filter, 'asc_esc_html'      );
}

// Format WordPress
foreach ( array( 'the_content', 'the_title', 'asc_title' ) as $filter )
	asc_add_filter( $filter, 'asc_capital_P_dangit', 11 );
asc_add_filter( 'comment_text', 'asc_capital_P_dangit', 31 );

// Format titles
foreach ( array( 'single_post_title', 'single_cat_title', 'single_tag_title', 'single_month_title', 'nav_menu_attr_title', 'nav_menu_description' ) as $filter ) {
	asc_add_filter( $filter, 'asc_wptexturize' );
	asc_add_filter( $filter, 'strip_tags'  );
}

// Format text area for display.
foreach ( array( 'term_description' ) as $filter ) {
	asc_add_filter( $filter, 'asc_wptexturize'      );
	asc_add_filter( $filter, 'asc_convert_chars'    );
	asc_add_filter( $filter, 'asc_wpautop'          );
	asc_add_filter( $filter, 'asc_shortcode_unautop');
}

// Format for RSS
asc_add_filter( 'term_name_rss', 'asc_convert_chars' );

// Pre save hierarchy
asc_add_filter( 'asc_insert_post_parent', 'asc_check_post_hierarchy_for_loops', 10, 2 );
asc_add_filter( 'asc_update_term_parent', 'asc_check_term_hierarchy_for_loops', 10, 3 );

// Display filters
asc_add_filter( 'the_title', 'asc_wptexturize'   );
asc_add_filter( 'the_title', 'asc_convert_chars' );
asc_add_filter( 'the_title', 'trim'          );

asc_add_filter( 'the_content', 'asc_wptexturize'        );
asc_add_filter( 'the_content', 'asc_convert_smilies'    );
asc_add_filter( 'the_content', 'asc_convert_chars'      );
asc_add_filter( 'the_content', 'asc_wpautop'            );
asc_add_filter( 'the_content', 'asc_shortcode_unautop'  );
asc_add_filter( 'the_content', 'prepend_attachment' );

asc_add_filter( 'the_excerpt',     'asc_wptexturize'      );
asc_add_filter( 'the_excerpt',     'asc_convert_smilies'  );
asc_add_filter( 'the_excerpt',     'asc_convert_chars'    );
asc_add_filter( 'the_excerpt',     'asc_wpautop'          );
asc_add_filter( 'the_excerpt',     'asc_shortcode_unautop');
asc_add_filter( 'get_the_excerpt', 'asc_trim_excerpt'  );

asc_add_filter( 'comment_text', 'asc_wptexturize'            );
asc_add_filter( 'comment_text', 'asc_convert_chars'          );
asc_add_filter( 'comment_text', 'asc_make_clickable',      9 );
asc_add_filter( 'comment_text', 'asc_force_balance_tags', 25 );
asc_add_filter( 'comment_text', 'asc_convert_smilies',    20 );
asc_add_filter( 'comment_text', 'asc_wpautop',            30 );

asc_add_filter( 'comment_excerpt', 'asc_convert_chars' );

asc_add_filter( 'list_cats',         'asc_wptexturize' );

asc_add_filter( 'asc_sprintf', 'asc_sprintf_l', 10, 2 );

// RSS filters
asc_add_filter( 'the_title_rss',      'strip_tags'      );
asc_add_filter( 'the_title_rss',      'asc_ent2ncr',      8 );
asc_add_filter( 'the_title_rss',      'asc_esc_html'        );
asc_add_filter( 'the_content_rss',    'asc_ent2ncr',      8 );
asc_add_filter( 'the_excerpt_rss',    'asc_convert_chars'   );
asc_add_filter( 'the_excerpt_rss',    'asc_ent2ncr',      8 );
asc_add_filter( 'comment_author_rss', 'asc_ent2ncr',      8 );
asc_add_filter( 'comment_text_rss',   'asc_ent2ncr',      8 );
asc_add_filter( 'comment_text_rss',   'asc_esc_html'        );
asc_add_filter( 'bloginfo_rss',       'asc_ent2ncr',      8 );
asc_add_filter( 'the_author',         'asc_ent2ncr',      8 );

// Misc filters
asc_add_filter( 'option_ping_sites',        'privacy_ping_filter'                 );
asc_add_filter( 'option_blog_charset',      '_asc_specialchars'                    ); // IMPORTANT: This must not be asc_specialchars() or esc_html() or it'll cause an infinite loop
asc_add_filter( 'option_blog_charset',      '_canonical_charset'                  );
asc_add_filter( 'option_home',              '_config_asc_home'                     );
asc_add_filter( 'option_siteurl',           '_config_asc_siteurl'                  );
asc_add_filter( 'tiny_mce_before_init',     '_mce_set_direction'                  );
asc_add_filter( 'pre_kses',                 'asc_pre_kses_less_than'               );
asc_add_filter( 'asc_sanitize_title',           'asc_sanitize_title_with_dashes',   10, 3 );
asc_add_action( 'check_comment_flood',      'check_comment_flood_db',       10, 3 );
asc_add_filter( 'comment_flood_filter',     'asc_throttle_comment_flood',    10, 3 );
asc_add_filter( 'pre_comment_content',      'asc_rel_nofollow',              15    );
asc_add_filter( 'comment_email',            'asc_antispambot'                         );
asc_add_filter( 'option_tag_base',          '_asc_filter_taxonomy_base'            );
asc_add_filter( 'option_category_base',     '_asc_filter_taxonomy_base'            );
asc_add_filter( 'the_posts',                '_close_comments_for_old_posts', 10, 2);
asc_add_filter( 'comments_open',            '_close_comments_for_old_post', 10, 2 );
asc_add_filter( 'pings_open',               '_close_comments_for_old_post', 10, 2 );
asc_add_filter( 'editable_slug',            'urldecode'                           );
asc_add_filter( 'editable_slug',            'asc_esc_textarea'                        );
asc_add_filter( 'nav_menu_meta_box_object', '_asc_nav_menu_meta_box_object'        );
asc_add_filter( 'pingback_ping_source_uri', 'pingback_ping_source_uri'            );
asc_add_filter( 'xmlrpc_pingback_error',    'xmlrpc_pingback_error'               );

asc_add_filter( 'http_request_host_is_external', 'allowed_http_request_hosts', 10, 2 );

// Actions
asc_add_action( 'asc_head',             'asc_enqueue_scripts',              1     );
asc_add_action( 'asc_head',             'feed_links',                      2     );
asc_add_action( 'asc_head',             'feed_links_extra',                3     );
asc_add_action( 'asc_head',             'rsd_link'                               );
asc_add_action( 'asc_head',             'wlwmanifest_link'                       );
asc_add_action( 'asc_head',             'adjacent_posts_rel_link_asc_head', 10, 0 );
asc_add_action( 'asc_head',             'locale_stylesheet'                      );
asc_add_action( 'publish_future_post', 'check_and_publish_future_post',   10, 1 );
asc_add_action( 'asc_head',             'noindex',                          1    );
asc_add_action( 'asc_head',             'asc_print_styles',                  8    );
asc_add_action( 'asc_head',             'asc_print_head_scripts',            9    );
asc_add_action( 'asc_head',             'asc_generator'                           );
asc_add_action( 'asc_head',             'rel_canonical'                          );
asc_add_action( 'asc_footer',           'asc_print_footer_scripts',         20    );
asc_add_action( 'asc_head',             'asc_shortlink_asc_head',            10, 0 );
asc_add_action( 'template_redirect',   'asc_shortlink_header',             11, 0 );
asc_add_action( 'asc_print_footer_scripts', '_asc_footer_scripts'                 );
asc_add_action( 'init',                'check_theme_switched',            99    );
asc_add_action( 'after_switch_theme',  '_asc_sidebars_changed'                   );

if ( isset( $_GET['replytocom'] ) )
    asc_add_action( 'asc_head', 'asc_no_robots' );

// Login actions
asc_add_action( 'login_head',          'asc_print_head_scripts',         9     );
asc_add_action( 'login_footer',        'asc_print_footer_scripts',       20    );
asc_add_action( 'login_init',          'send_frame_options_header',     10, 0 );

// Feed Generator Tags
foreach ( array( 'rss2_head', 'commentsrss2_head', 'rss_head', 'rdf_header', 'atom_head', 'comments_atom_head', 'opml_head', 'app_head' ) as $action ) {
	asc_add_action( $action, 'the_generator' );
}

// WP Cron
if ( !defined( 'DOING_CRON' ) )
	asc_add_action( 'init', 'asc_cron' );

// 2 Actions 2 Furious
asc_add_action( 'do_feed_rdf',                'do_feed_rdf',                             10, 1 );
asc_add_action( 'do_feed_rss',                'do_feed_rss',                             10, 1 );
asc_add_action( 'do_feed_rss2',               'do_feed_rss2',                            10, 1 );
asc_add_action( 'do_feed_atom',               'do_feed_atom',                            10, 1 );
asc_add_action( 'do_pings',                   'do_all_pings',                            10, 1 );
asc_add_action( 'do_robots',                  'do_robots'                                      );
asc_add_action( 'set_comment_cookies',        'asc_set_comment_cookies',                  10, 2 );
asc_add_action( 'sanitize_comment_cookies',   'sanitize_comment_cookies'                       );
asc_add_action( 'admin_print_scripts',        'asc1_print_head_scripts',                      20    );
asc_add_action( 'admin_print_footer_scripts', '_asc_footer_scripts'                             );
asc_add_action( 'admin_print_styles',         'asc_print_admin_styles',                      20    );
asc_add_action( 'init',                       'smilies_init',                             5    );
asc_add_action( 'plugins_loaded',             'asc_maybe_load_widgets',                    0    );
asc_add_action( 'plugins_loaded',             'asc_maybe_load_embeds',                     0    );
asc_add_action( 'shutdown',                   'asc_ob_end_flush_all',                      1    );
asc_add_action( 'post_updated',               'asc_save_post_revision',                   10, 1 );
asc_add_action( 'publish_post',               '_publish_post_hook',                       5, 1 );
asc_add_action( 'transition_post_status',     '_transition_post_status',                  5, 3 );
asc_add_action( 'transition_post_status',     '_update_term_count_on_transition_post_status', 10, 3 );
asc_add_action( 'comment_form',               'asc_comment_form_unfiltered_html_nonce'          );
asc_add_action( 'asc_scheduled_delete',        'asc_scheduled_delete'                            );
asc_add_action( 'asc_scheduled_auto_draft_delete', 'asc_delete_auto_drafts'                      );
asc_add_action( 'admin_init',                 'send_frame_options_header',               10, 0 );
asc_add_action( 'importer_scheduled_cleanup', 'asc_delete_attachment'                           );
asc_add_action( 'upgrader_scheduled_cleanup', 'asc_delete_attachment'                           );
asc_add_action( 'welcome_panel',              'asc_welcome_panel'                               );

// Navigation menu actions
asc_add_action( 'delete_post',                '_asc_delete_post_menu_item'         );
asc_add_action( 'delete_term',                '_asc_delete_tax_menu_item',   10, 3 );
asc_add_action( 'transition_post_status',     '_asc_auto_add_pages_to_menu', 10, 3 );

// Post Thumbnail CSS class filtering
asc_add_action( 'begin_fetch_post_thumbnail_html', '_asc_post_thumbnail_class_filter_add'    );
asc_add_action( 'end_fetch_post_thumbnail_html',   '_asc_post_thumbnail_class_filter_remove' );

// Redirect Old Slugs
asc_add_action( 'template_redirect', 'asc_old_slug_redirect'              );
asc_add_action( 'post_updated',      'asc_check_for_changed_slugs', 12, 3 );

// Nonce check for Post Previews
asc_add_action( 'init', '_show_post_preview' );

// Timezone
asc_add_filter( 'pre_option_gmt_offset','asc_timezone_override_offset' );

// Admin Color Schemes
asc_add_action( 'admin_init', 'register_admin_color_schemes', 1);
asc_add_action( 'admin_color_scheme_picker', 'admin_color_scheme_picker' );

// If the upgrade hasn't run yet, assume link manager is used.
asc_add_filter( 'default_option_link_manager_enabled', '__return_true' );

// This option no longer exists; tell plugins we always support auto-embedding.
asc_add_filter( 'default_option_embed_autourls', '__return_true' );

// Default settings for heartbeat
asc_add_filter( 'heartbeat_settings', 'asc_heartbeat_settings' );

// Check if the user is logged out
asc_add_action( 'admin_enqueue_scripts', 'asc_auth_check_load' );
asc_add_filter( 'heartbeat_send',        'asc_auth_check' );
asc_add_filter( 'heartbeat_nopriv_send', 'asc_auth_check' );

// Default authentication filters
asc_add_filter( 'authenticate', 'asc_authenticate_username_password',  20, 3 );
asc_add_filter( 'authenticate', 'asc_authenticate_spam_check',         99    );
asc_add_filter( 'determine_current_user', 'asc_validate_auth_cookie'          );
asc_add_filter( 'determine_current_user', 'asc_validate_logged_in_cookie', 20 );

unset($filter, $action);