<?php
/****************************************************************/
/* ATutor														*/
/****************************************************************/
/* Copyright (c) 2002-2008                                      */
/* Written by Greg Gay, Joel Kronenberg & Chris Ridpath         */
/* Inclusive Design Institute                                   */
/* http://atutor.ca												*/
/*                                                              */
/* This program is free software. You can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation.				*/
/****************************************************************/
// $Id$
define('AT_INCLUDE_PATH', '../../../include/');
require (AT_INCLUDE_PATH.'vitals.inc.php');

if (isset($_GET['submit'])) { // was the 'back' button pressed?
	//header('Location: '.url_rewrite('mods/_standard/reading_list/index.php', AT_PRETTY_URL_IS_HEADER));
		header('Location: '.$_base_href.'mods/_standard/reading_list/index.php');
	exit;
}

require(AT_INCLUDE_PATH.'header.inc.php');

$id = intval($_GET['id']);

$sql = "SELECT * FROM %sexternal_resources WHERE course_id=%d AND resource_id=%d";
$row = queryDB($sql, array(TABLE_PREFIX, $_SESSION['course_id'], $id), TRUE);

if($row['resource_id'] == 0){
	// can't get resource from database
	$msg->printErrors('ITEM_NOT_FOUND');
	require(AT_INCLUDE_PATH.'footer.inc.php');
	exit;
}

$row['type']		= intval($row['type']);
$row['title']		= AT_print($row['title'], 'readling_list.title');
$row['author']		= AT_print($row['author'], 'readling_list.author');
$row['publisher']	= AT_print($row['publisher'], 'readling_list.publisher');
$row['date']		= AT_print($row['date'], 'readling_list.date');
$row['id']			= AT_print($row['id'], 'readling_list.id');
$row['comments']	= AT_print($row['comments'], 'readling_list.comments');

?>
<form action="<?php echo $_SERVER['PHP_SELF'];?>" method="get" name="form">
<div class="input-form">

	<?php if ($row['type'] == RL_TYPE_BOOK): ?>
		<div class="row">
			<?php  echo _AT('title'). ": <strong>". $row['title']. "</strong>"; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_type_of_resource'). ": ". _AT($_rl_types[$row['type']]); ?> 
		</div>
		<div class="row">
			<?php  echo _AT('author'). ": ". $row['author']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_publisher'). ": ". $row['publisher']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('date'). ": ". $row['date']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_isbn_number'). ": ". $row['id']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('comment'). ": ". $row['comments']; ?> 
		</div>

	<?php elseif ($row['type'] == RL_TYPE_URL): ?>
		<div class="row">
			<?php  echo _AT('title'). ": <strong>". $row['title']. "</strong>"; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_type_of_resource'). ": ". _AT($_rl_types[$row['type']]); ?> 
		</div>
		<div class="row">
			<?php echo _AT('location'). ": " ?><a href="<?php echo $row['url']?>" target="readinglist"><?php echo $row['url']; ?></a> 
		</div>
		<div class="row">
			<?php  echo _AT('author'). ": ". $row['author']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('comment'). ": ". $row['comments']; ?> 
		</div>

	<?php elseif ($row['type'] == RL_TYPE_HANDOUT): ?>
		<div class="row">
			<?php  echo _AT('title'). ": <strong>". $row['title']. "</strong>"; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_type_of_resource'). ": ". _AT($_rl_types[$row['type']]); ?> 
		</div>
		<div class="row">
			<?php  echo _AT('author'). ": ". $row['author']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('date'). ": ". $row['date']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('comment'). ": ". $row['comments']; ?> 
		</div>

	<?php elseif ($row['type'] == RL_TYPE_AV): ?>
		<div class="row">
			<?php  echo _AT('title'). ": <strong>". $row['title']. "</strong>" ; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_type_of_resource'). ": ". _AT($_rl_types[$row['type']]); ?> 
		</div>
		<div class="row">
			<?php  echo _AT('author'). ": ". $row['author']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('date'). ": ". $row['date']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('comment'). ": ". $row['comments']; ?> 
		</div>

	<?php elseif ($row['type'] == RL_TYPE_FILE): ?>
		<div class="row">
			<?php  echo _AT('title'). ": <strong>". $row['title']. "</strong>"; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_type_of_resource'). ": ". _AT($_rl_types[$row['type']]); ?> 
		</div>
		<div class="row">
			<?php  echo _AT('author'). ": ". $row['author']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_publisher'). ": ". $row['publisher']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('date'). ": ". $row['date']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('rl_id'). ": ". $row['id']; ?> 
		</div>
		<div class="row">
			<?php  echo _AT('comment'). ": ". $row['comments']; ?> 
		</div>
	<?php endif; ?>

	<div class="row buttons">
		<input type="submit" name="submit" value="<?php echo _AT('back'); ?>" />
	</div>
</div>
</form>

<?php require(AT_INCLUDE_PATH.'footer.inc.php'); ?>