<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

$_['hello']            = 'Hello,';
$_['best_regards']     = 'Best Regards,';
$_['thanks']           = 'Thanks,';
$_['the_team']         = 'The {store_name} team';
$_['image']            = 'Image';
$_['product']          = 'Product';
$_['model']            = 'Model';
$_['quantity']         = 'Quantity';
$_['price']            = 'Price';
$_['total']            = 'Total';
$_['reply_email']      = 'Please reply to this e-mail if you have any questions.';
$_['view_order']       = 'To view your order click on the link below';
$_['order_details']    = 'Order Details';
$_['order_id']         = 'Order ID';
$_['date_added']       = 'Date Added';
$_['date_ordered']     = 'Date Ordered';
$_['payment_method']   = 'Payment Method';
$_['shipping_method']  = 'Shipping Method';
$_['email']            = 'E-mail';
$_['telephone']        = 'Telephone';
$_['ip_address']       = 'IP Address';
$_['order_status']     = 'Order Status';
$_['payment_address']  = 'Payment Address';
$_['shipping_address'] = 'Shipping Address';
$_['customer']         = 'Customer';


$_['admin_1_subject']  = 'User {username} logged in on {store_name} admin panel';
$_['admin_login_body'] = 'We would like to notify you that user <strong>{username}</strong> has just logged in to the admin panel of your store, <strong>{store_name}</strong>, using IP address <strong>{ip_address}</strong>.<br><br> If this is expected you need to do nothing about it. If you suspect a hacking attempt, please log in to your store\'s admin panel immediately and change your password at once.';

$_['affiliate_1_subject']         = '{store_name} - Affiliate Program';
$_['affiliate_1_thank_you']       = 'Thank you for joining the {store_name} Affiliate Program!';
$_['affiliate_1_account_created'] = 'Your account has now been created and you can log in by using your e-mail address and password by visiting our website or at the following URL';
$_['affiliate_1_track_code']      = 'Upon logging in, you will be able to generate tracking codes, track commission payments and edit your account information.';

$_['affiliate_2_subject']            = 'Affiliate Reset Password';
$_['affiliate_2_dear']               = 'Dear {firstname} {lastname}';
$_['affiliate_2_affiliate_user']     = 'Your Affiliate user';
$_['affiliate_2_affiliate_password'] = 'Your Affiliate password';

$_['affiliate_3_subject']         = '{store_name} - Affiliate Program';
$_['affiliate_3_thank_you']       = 'Thank you for joining the {store_name} Affiliate Program!';
$_['affiliate_3_account_created'] = 'Your account must be approved before you can login. Once approved you can log in by using your e-mail address and password by visiting our website or at the following URL';
$_['affiliate_3_track_code']      = 'Upon logging in, you will be able to generate tracking codes, track commission payments and edit your account information.';

$_['affiliate_4_subject']         = '{store_name} - Affiliate Program';
$_['affiliate_4_thank_you']       = 'Thank you for joining the {store_name} Affiliate Program!';
$_['affiliate_4_account_created'] = 'Your account must be approved before you can login. Once approved you can log in by using your e-mail address and password by visiting our website or at the following URL';
$_['affiliate_4_track_code']      = 'Upon logging in, you will be able to generate tracking codes, track commission payments and edit your account information.';

$_['affiliate_5_subject']    = '{store_name} - Affiliate Program';
$_['affiliate_5_commission'] = 'You have received {commission} commission!';

$_['affiliate_6_subject']    = '{store_name} - Affiliate Program';
$_['affiliate_6_commission'] = 'Your total amount of commission is now {amount}.';

$_['contact_1_subject'] = '{store_name} - Contact';
$_['contact_1_contact'] = 'Contact';
$_['contact_1_message'] = 'Contact Message';

$_['customer_1_subject']         = '{store_name} Thank you for register {firstname} {lastname}';
$_['customer_1_thank_you']       = 'Welcome and thank you for registering at {store_name}!';
$_['customer_1_account_created'] = 'Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL';
$_['customer_1_review_orders']   = 'Upon logging in, you will be able to access other services including reviewing past orders, printing invoices and editing your account information.';

$_['customer_2_subject']          = '{store_name} Thank you for register approve {firstname} {lastname}';
$_['customer_2_thank_you']        = 'Welcome and thank you for registering at {store_name}!';
$_['customer_2_account_approved'] = 'Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL';

$_['customer_3_subject']         = '{store_name} Reset Password {firstname} {lastname}';
$_['customer_3_change_password'] = '{firstname} {lastname} change your password';
$_['customer_3_username']        = 'Your user name';
$_['customer_3_password']        = 'Your password';

$_['customer_4_subject']          = '{store_name} Thank you for register approve {firstname} {lastname}';
$_['customer_4_thank_you']        = 'Welcome and thank you for registering at {store_name}!';
$_['customer_4_account_approved'] = 'Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL';

$_['customer_5_subject']       = 'You have received a gift voucher from {store_name}';
$_['customer_5_dear']          = 'Congratulations {recip_name}';
$_['customer_5_received_gift'] = 'You have received a gift voucher worth {amount}.';
$_['customer_5_sent_by']       = 'This Gift Certificate has been sent to you by {name}, with a message saying:<br /><br />{message}';
$_['customer_5_redeem_gift']   = 'To redeem this gift voucher, write down or copy the gift voucher code, then click on the the link below and purchase the product you wish to use this gift voucher on. You can enter the gift voucher code on the shopping cart page before you click checkout.<br /><br />Your gift voucher code is: {code}<br /><br />Store URL: {store_url}';

$_['customer_6_subject']         = '{store_name} - Account Credit';
$_['customer_6_received_credit'] = 'You have received {credit} credit!';
$_['customer_6_total_amount']    = 'Your total amount of credit is now {total_credit}';
$_['customer_6_auto_deduct']     = 'Your account credit will be automatically deducted from your next purchase.';

$_['invoice_1_subject']            = 'Invoice for your {order_id} order';
$_['invoice_1_hello_customer']     = 'Hello {customer},';
$_['invoice_1_invoice_attachment'] = 'Thank you for your interest in {store_name} products. You can find the invoice in the attachment.';

$_['invoice_2_subject']         = '{store_name} Invoice - {invoice_no} History';
$_['invoice_2_invoice_no']      = 'Invoice No.';
$_['invoice_2_invoice_date']    = 'Invoice Date';
$_['invoice_2_invoice_comment'] = 'The comments for your invoice are';

$_['order_1_subject']   = '{store_name} Order -  {order_id} Pending';
$_['order_1_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_2_subject']   = '{store_name} Order -  {order_id} Processing';
$_['order_2_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_3_subject']   = '{store_name} Order -  {order_id} Shipped';
$_['order_3_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_5_subject']   = '{store_name} Order -  {order_id} Complete';
$_['order_5_thank_you'] = 'Thank you for your interest in {store_name} products. Your order has been received and will be processed once payment has been confirmed.';

$_['order_7_subject']   = '{store_name} Order -  {order_id} Cancelled';
$_['order_7_thank_you'] = 'Thank you for your interest in {store_name} products but your order was cancelled.';

$_['order_8_subject']   = '{store_name} Order -  {order_id} Denied';
$_['order_8_thank_you'] = 'Thank you for your interest in {store_name} products but your order was denied.';

$_['order_9_subject']   = '{store_name} Order -  {order_id} Cancelled Reversal';
$_['order_9_thank_you'] = 'Thank you for your interest in {store_name} products. Your order has been received and will be processed once payment has been confirmed.';

$_['order_10_subject']   = '{store_name} Order -  {order_id} Failed';
$_['order_10_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_11_subject']   = '{store_name} Order -  {order_id} Refunded';
$_['order_11_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_12_subject']   = '{store_name} Order -  {order_id} Reversed';
$_['order_12_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_13_subject']   = '{store_name} Order -  {order_id} Chargeback';
$_['order_13_thank_you'] = 'Thank you for your interest in {store_name} products but your order chargeback. Please contact us.';

$_['order_14_subject']   = '{store_name} Order -  {order_id} Expired';
$_['order_14_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_15_subject']   = '{store_name} Order -  {order_id} Processed';
$_['order_15_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['order_16_subject']   = '{store_name} Order -  {order_id} Voided';
$_['order_16_thank_you'] = 'Thank you for your interest in {store_name} products.';

$_['return_1_subject']        = '{store_name} - Product Return Request';
$_['return_1_return_request'] = 'You have a new product return request.';
$_['return_1_return_details'] = 'Return Details';
$_['return_1_return_reason']  = 'Return Reason';
$_['return_1_opened']         = 'Opened';

$_['reviews_1_subject']        = '{store_name} - Product Review';
$_['reviews_1_product_review'] = 'You have a new product review waiting.';
$_['reviews_1_reviewer']       = 'Reviewer';
$_['reviews_1_rating']         = 'Rating';
$_['reviews_1_review_text']    = 'Review Text';

$_['stock_1_subject']             = '{store_name} - {total_products} Product(s) Out Of Stock';
$_['stock_1_notify']              = 'We would like to notify that you have <b>{total_products}</b> product(s) out of stock in store <b>{store_name}</b>.';
$_['stock_1_click_notifications'] = 'You can view them by clicking on Notifications icon -&gt; Out of Stock, or browse to Catalog -&gt; Products and filter quantity = 0.';

