<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

class ModelShippingItem extends Model {
    function getQuote($address) {
        $this->load->language('shipping/item');

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('item_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

        if (!$this->config->get('item_geo_zone_id')) {
            $status = true;
        } elseif ($query->num_rows) {
            $status = true;
        } else {
            $status = false;
        }

        $method_data = array();

        if ($status) {
            $items = 0;

            foreach ($this->cart->getProducts() as $product) {
                if ($product['shipping']) {
                    $items += $product['quantity'];
                }
            }

            $quote_data = array();

            $quote_data['item'] = array(
                'code'         => 'item.item',
                'title'        => $this->language->get('text_description'),
                'cost'         => $this->config->get('item_cost') * $items,
                'tax_class_id' => $this->config->get('item_tax_class_id'),
                'text'         => $this->currency->format($this->tax->calculate($this->config->get('item_cost') * $items, $this->config->get('item_tax_class_id'), $this->config->get('config_tax')))
            );

            $method_data = array(
                'code'       => 'item',
                'title'      => $this->language->get('text_title'),
                'quote'      => $quote_data,
                'sort_order' => $this->config->get('item_sort_order'),
                'error'      => false
            );
        }

        return $method_data;
    }
}
