var TinyMCE_editor;

tinymce.PluginManager.add("image_manager", function (editor, url) {
    function showImageManager() {
        TinyMCE_editor = editor;

        $('#modal-image').remove();

        $.ajax({
            url: 'index.php?route=common/filemanager&token=' + getURLVar('token'),
            dataType: 'html',
            beforeSend: function() {
                $('#button-image i').replaceWith('<i class="fa fa-circle-o-notch fa-spin"></i>');
                $('#button-image').prop('disabled', true);
            },
            complete: function() {
                $('#button-image i').replaceWith('<i class="fa fa-upload"></i>');
                $('#button-image').prop('disabled', false);
            },
            success: function(html) {
                $('body').append('<div id="modal-image" class="modal">' + html + '</div>');

                $('#modal-image').modal('show');
            }
        });
    }

    editor.addButton("image_manager", {
        icon         : "image",
        tooltip      : "Insert image",
        onclick      : showImageManager,
        stateSelector: "img:not([data-mce-object],[data-mce-placeholder])"
    });

    editor.addMenuItem("image_manager", {
        icon            : "image",
        text            : "Insert image",
        onclick         : showImageManager,
        context         : "insert",
        prependToContext: !0
    });

    editor.on('BeforeSetContent', function( event ) {
        if (event.content) {
            event.content = event.content.replace(/<img[^>]+>/g, function( image ) {
                var match;

                if (image.indexOf( 'data-image="image"' ) !== -1) {
                    if (match = image.match( /src="([^"]+)"/ )) {
                        path = match[1];
                    }

                    if (match = image.match( /data-original-src="([^"]+)"/ )) {
                        real_path = match[1];
                        real_path = '../' + real_path;
                    }

                    image = image.replace(path, real_path);
                } else {
                    pathname = window.location.pathname.split('admin/');

                    if (match = image.match( /src="([^"]+)"/ )) {
                        path = match[1];
                    }

                    image_path = 'data-image="image" data-original-src="' + path.replace(window.location.origin + pathname[0], '') + '"';

                    image = image.replace('src', image_path + ' src');
                }

                return image;
            });
        }
    });

    editor.on('PostProcess', function(event) {
        if (event.get) {
            event.content = event.content.replace(/<img[^>]+>/g, function( image ) {
                var match;

                if (image.indexOf( 'data-image="image"' ) !== -1) {
                    if (match = image.match( /src="([^"]+)"/ )) {
                        path = match[1];
                    }

                    if (match = image.match( /data-original-src="([^"]+)"/ )) {
                        real_path = match[1];
                    }

                    image = image.replace(path, real_path);
                }

                return image;
            });
        }
    });
});

function InsertTinyMCEImage(src, original_src) {
    TinyMCE_editor.insertContent('<img src="' + src + '" data-image="image" data-original-src="' + original_src + '" data-mce-src="' + src + '" />');

    $('#modal-image').remove();
    $('body').removeClass('modal-open');
}