<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

// Heading
$_['heading_title']                    = 'Settings';

// Text
$_['text_stores']                      = 'Stores';
$_['text_success']                     = 'Success: You have modified settings!';
$_['text_edit']                        = 'Edit Setting';
$_['text_product']                     = 'Products';
$_['text_review']                      = 'Reviews';
$_['text_voucher']                     = 'Vouchers';
$_['text_tax']                         = 'Taxes';
$_['text_account']                     = 'Account';
$_['text_checkout']                    = 'Checkout';
$_['text_stock']                       = 'Stock';
$_['text_affiliate']                   = 'Affiliates';
$_['text_return']                      = 'Returns';
$_['text_shipping']                    = 'Shipping Address';
$_['text_payment']                     = 'Payment Address';
$_['text_phpmail']                     = 'PHP Mail';
$_['text_sendmail']                    = 'Sendmail';
$_['text_smtp']                        = 'SMTP';
$_['text_smtp_encryption_n']           = 'None';
$_['text_smtp_encryption_s']           = 'SSL';
$_['text_smtp_encryption_t']           = 'TLS';
$_['text_common']                      = 'Common';
$_['text_summernote']                  = 'Summernote';
$_['text_tinymce']                     = 'TinyMCE';
$_['text_seo_urls']                    = 'SEO URLs';
$_['text_seo_metadata']                = 'Metadata';
$_['text_seo_sitemap']                 = 'Sitemap';
$_['text_seo_category_last']           = 'Only Last Category';
$_['text_seo_category_all']            = 'All Parent + Child Categories';
$_['text_seo_www_red_with']            = 'With www';
$_['text_seo_www_red_non']             = 'Without www';
$_['text_metadata']                    = 'Metadata';
$_['text_meta_title_add_pre']          = 'Yes, before their title';
$_['text_meta_title_add_post']         = 'Yes, after their title';
$_['text_blog_home']                   = 'Blog Home';
$_['text_post_list']                   = 'Post Listing';
$_['text_post_form']                   = 'Post Page';
$_['text_comment']                     = 'Comment';
$_['text_secure_checkout']             = 'Account & Checkout';
$_['text_secure_catalog']              = 'Catalog';
$_['text_secure_all']                  = 'All Site (Catalog + Admin)';
$_['text_firewall']                    = 'Firewall';
$_['text_upload']                      = 'Uploads';
$_['text_captcha']                     = 'Captcha';
$_['text_sec_get']                     = 'GET (URL data)';
$_['text_sec_post']                    = 'POST (Form data)';
$_['text_cache_storage_file']          = 'File';
$_['text_pagecache']                   = 'Page Cache';
$_['text_cache_clear']                 = 'Clear Cache';
$_['text_cache_cleared']               = 'Cache Successfully Cleaned';
$_['text_error_basic']                 = 'Basic';
$_['text_error_advanced']              = 'Advanced';
$_['text_none']                        = '- None -';
$_['text_name_asc']                    = 'Post Name (A - Z)';
$_['text_name_desc']                   = 'Post Name (Z - A)';
$_['text_date_added_asc']              = 'Date Added (Oldest - Newest)';
$_['text_date_added_desc']             = 'Date Added (Newest - Oldest)';
$_['text_date_modified_asc']           = 'Date Modified (Newest - Oldest)';
$_['text_date_modified_desc']          = 'Date Modified (Oldest - Newest)';
$_['text_viewed_asc']                  = 'Viewed (Least - Most)';
$_['text_viewed_desc']                 = 'Viewed (Most - Least)';
$_['text_random']                      = 'Random';
$_['text_sort_order']                  = 'Use Post Sort Order';

// Entry
$_['entry_name']                       = 'Store Name';
$_['entry_owner']                      = 'Store Owner';
$_['entry_address']                    = 'Address';
$_['entry_geocode']                    = 'Geocode';
$_['entry_email']                      = 'E-Mail';
$_['entry_telephone']                  = 'Telephone';
$_['entry_fax']                        = 'Fax';
$_['entry_image']                      = 'Image';
$_['entry_open']                       = 'Opening Times';
$_['entry_comment']                    = 'Comment';
$_['entry_location']                   = 'Store Location';
$_['entry_meta_title']                 = 'Meta Title';
$_['entry_meta_description']           = 'Meta Description';
$_['entry_meta_keyword']               = 'Meta Keywords';
$_['entry_layout']                     = 'Default Layout';
$_['entry_admin_template']             = 'Admin Template';
$_['entry_admin_template_message']     = 'Admin Template Message';
$_['entry_template']                   = 'Template';
$_['entry_country']                    = 'Country';
$_['entry_zone']                       = 'Region / State';
$_['entry_language']                   = 'Language';
$_['entry_admin_language']             = 'Administration Language';
$_['entry_currency']                   = 'Currency';
$_['entry_currency_auto']              = 'Auto Update Currency';
$_['entry_length_class']               = 'Length Class';
$_['entry_weight_class']               = 'Weight Class';
$_['entry_product_limit']              = 'Default Items Per Page (Catalog)';
$_['entry_product_description_length'] = 'List Description Limit (Catalog)';
$_['entry_limit_admin']                = 'Default Items Per Page (Admin)';
$_['entry_product_count']              = 'Category Product Count';
$_['entry_review']                     = 'Allow Reviews';
$_['entry_review_guest']               = 'Allow Guest Reviews';
$_['entry_review_mail']                = 'New Review Alert Mail';
$_['entry_voucher_min']                = 'Voucher Min';
$_['entry_voucher_max']                = 'Voucher Max';
$_['entry_tax']                        = 'Display Prices With Tax';
$_['entry_tax_default']                = 'Use Store Tax Address';
$_['entry_tax_customer']               = 'Use Customer Tax Address';
$_['entry_customer_online']            = 'Customers Online';
$_['entry_customer_activity']          = 'Customers Activity';
$_['entry_customer_search']            = 'Customers Searches';
$_['entry_customer_group']             = 'Customer Group';
$_['entry_customer_group_display']     = 'Customer Groups';
$_['entry_customer_price']             = 'Login Display Prices';
$_['entry_login_attempts']             = 'Max Login Attempts';
$_['entry_account']                    = 'Account Terms';
$_['entry_account_mail']               = 'New Account Alert Mail';
$_['entry_api']                        = 'API User';
$_['entry_cart_weight']                = 'Display Weight on Cart Page';
$_['entry_checkout_guest']             = 'Guest Checkout';
$_['entry_checkout']                   = 'Checkout Terms';
$_['entry_invoice_prefix']             = 'Invoice Prefix';
$_['entry_order_status']               = 'Order Status';
$_['entry_processing_status']          = 'Processing Order Status';
$_['entry_complete_status']            = 'Complete Order Status';
$_['entry_order_mail']                 = 'New Order Alert Mail';
$_['entry_mail_alert']                 = 'Additional Alert E-Mails';
$_['entry_stock_display']              = 'Display Stock';
$_['entry_stock_warning']              = 'Show Out Of Stock Warning';
$_['entry_stock_checkout']             = 'Stock Checkout';
$_['entry_stock_mail']                 = 'Out Of Stock Mail';
$_['entry_affiliate_approval']         = 'Affiliate Requires Approval';
$_['entry_affiliate_auto']             = 'Automatic Commission';
$_['entry_affiliate_commission']       = 'Affiliate Commission (%)';
$_['entry_affiliate']                  = 'Affiliate Terms';
$_['entry_affiliate_activity']         = 'Affiliates Activity';
$_['entry_affiliate_mail']             = 'New Affiliate Alert Mail';
$_['entry_return']                     = 'Return Terms';
$_['entry_return_status']              = 'Return Status';
$_['entry_return_mail']                = 'New Return Request Mail';
$_['entry_logo']                       = 'Store Logo';
$_['entry_icon']                       = 'Icon';
$_['entry_image_category']             = 'Category Image Size';
$_['entry_image_thumb']                = 'Product Image Thumb Size';
$_['entry_image_popup']                = 'Product Image Popup Size';
$_['entry_image_product']              = 'Product Image List Size';
$_['entry_image_additional']           = 'Additional Product Image Size';
$_['entry_image_related']              = 'Related Product Image Size';
$_['entry_image_compare']              = 'Compare Image Size';
$_['entry_image_wishlist']             = 'Wish List Image Size';
$_['entry_image_cart']                 = 'Cart Image Size';
$_['entry_image_location']             = 'Store Image Size';
$_['entry_image_maintenance']          = 'Maintenance Image Size';
$_['entry_image_blog_post_list']       = 'Blog Post List Image Size';
$_['entry_image_blog_post_form']       = 'Blog Post Detail Image Size';
$_['entry_width']                      = 'Width';
$_['entry_height']                     = 'Height';
$_['entry_mail_protocol']              = 'Protocol';
$_['entry_mail_sendmail_path']         = 'Sendmail Path';
$_['entry_smtp_hostname']              = 'SMTP Host';
$_['entry_smtp_username']              = 'SMTP Username';
$_['entry_smtp_password']              = 'SMTP Password';
$_['entry_smtp_port']                  = 'SMTP Port';
$_['entry_smtp_encryption']            = 'SMTP Security';
$_['entry_secure']                     = 'Use SSL';
$_['entry_shared']                     = 'Use Shared Sessions';
$_['entry_robots']                     = 'Robots';
$_['entry_file_max_size']              = 'Max File Size';
$_['entry_file_ext_allowed']           = 'Allowed File Extensions';
$_['entry_file_mime_allowed']          = 'Allowed File Mime Types';
$_['entry_maintenance']                = 'Site Offline';
$_['entry_maintenance_message']        = 'Message';
$_['entry_maintenance_image']          = 'Image';
$_['entry_maintenance_login']          = 'Display Login';
$_['entry_password']                   = 'Allow Forgotten Password';
$_['entry_encryption']                 = 'Encryption Key';
$_['entry_compression']                = 'Output Compression Level';
$_['entry_debug_system']               = 'Debug System';
$_['entry_error_display']              = 'Display Errors';
$_['entry_error_log']                  = 'Log Errors';
$_['entry_error_filename']             = 'Error Log Filename';
$_['entry_status']                     = 'Status';
$_['entry_text_editor']                = 'Text Editor (Admin)';
$_['entry_seo_url']                    = 'Use SEO URLs';
$_['entry_seo_rewrite']                = 'Remove index.php';
$_['entry_seo_suffix']                 = 'Add Suffix to URLs';
$_['entry_seo_category']               = 'Add Category to Products URLs';
$_['entry_seo_translate']              = 'Translate URLs';
$_['entry_seo_lang_code']              = 'Add language code to URLs';
$_['entry_seo_canonical']              = 'Use canonical links';
$_['entry_seo_www_red']                = 'www Redirection';
$_['entry_seo_nonseo_red']             = 'non-SEO to SEO URLs Redirection';
$_['entry_meta_title_add']             = 'Add to other titles';
$_['entry_meta_generator']             = 'Meta Generator';
$_['entry_meta_googlekey']             = 'Meta Google Key';
$_['entry_meta_alexakey']              = 'Meta Alexa Key';
$_['entry_sitemap_all']                = 'All items XML map';
$_['entry_sitemap_products']           = 'Products XML map';
$_['entry_sitemap_categories']         = 'Categories XML map';
$_['entry_sitemap_manufacturers']      = 'Manufacturers XML map';
$_['entry_sec_admin_login']            = 'Email on Admin Login';
$_['entry_sec_admin_keyword']          = 'Keyword for Admin Panel';
$_['entry_sec_lfi']                    = 'LFI Protection';
$_['entry_sec_rfi']                    = 'RFI Protection';
$_['entry_sec_sql']                    = 'SQLi Protection';
$_['entry_sec_xss']                    = 'XSS Protection';
$_['entry_sec_csrf']                   = 'CSRF Protection';
$_['entry_sec_htmlpurifier']           = 'Use HTMLPurifier';
$_['entry_cache_storage']              = 'Storage';
$_['entry_cache_memcache_servers']     = 'Memcache Servers';
$_['entry_cache_redis_server']         = 'Redis Server';
$_['entry_cache_lifetime']             = 'Lifetime';
$_['entry_cache_clear']                = 'Clear After Save';
$_['entry_pagecache']                  = 'Use Page Cache';
$_['entry_pagecache_exclude']          = 'Exclude Routes';
$_['entry_timezone']                   = 'Time Zone';
$_['entry_captcha']                    = 'Captcha';
$_['entry_blog_name']                  = 'Name';
$_['entry_blog_description']           = 'Description';
$_['entry_blog_featured_slide']        = 'Featured Slide';
$_['entry_blog_post_limit']            = 'Posts Per Page';
$_['entry_blog_post_description_lenth']= 'Posts Description Length';
$_['entry_blog_post_row']              = 'Posts Per Row';
$_['entry_blog_post_sort_order']       = 'Posts Sort Order';
$_['entry_blog_post_date']             = 'Display Date';
$_['entry_blog_post_comment']          = 'Display Number Of Comments';
$_['entry_blog_post_read']             = 'Display Viewed';
$_['entry_blog_post_author']           = 'Display Author';
$_['entry_blog_post_share']            = 'Display Sharing Buttons';
$_['entry_blog_related_row']           = 'Posts Per Row';
$_['entry_blog_related_thumb']         = 'Display Post Thumb';
$_['entry_blog_comment_limit']         = 'Comments Per Page';
$_['entry_blog_comment_enable']        = 'Allow Comment';
$_['entry_blog_comment_status']        = 'Publish';
$_['entry_blog_comment_guest']         = 'Allow Guest';
$_['entry_blog_comment_mail']          = 'New Comment Alert Mail';
$_['entry_blog_related_short_description_length'] = 'Related Short Description Limit';

// Help
$_['help_geocode']                     = 'Please enter your store location geocode manually.';
$_['help_open']                        = 'Fill in your store\'s opening times.';
$_['help_comment']                     = 'This field is for any special notes you would like to tell the customer i.e. Store does not accept cheques.';
$_['help_location']                    = 'The different store locations you have that you want displayed on the contact us form.';
$_['help_currency']                    = 'Change the default currency. Clear your browser cache to see the change and reset your existing cookie.';
$_['help_currency_auto']               = 'Set your store to automatically update currencies daily.';
$_['help_product_limit']               = 'Determines how many catalog items are shown per page (products, categories, etc).';
$_['help_product_description_length']  = 'In the list view, short description character limit (categories, special etc).';
$_['help_limit_admin']                 = 'Determines how many admin items are shown per page (orders, customers, etc).';
$_['help_product_count']               = 'Show the number of products inside the subcategories in the storefront header category menu. Be warned, this will cause an extreme performance hit for stores with a lot of subcategories!';
$_['help_review']                      = 'Enable/Disable new review entry and display of existing reviews.';
$_['help_review_guest']                = 'Allow guests to post reviews.';
$_['help_review_mail']                 = 'Send an email to the store owner when a new review is created.';
$_['help_voucher_min']                 = 'Minimum amount a customer can purchase a voucher for.';
$_['help_voucher_max']                 = 'Maximum amount a customer can purchase a voucher for.';
$_['help_tax_default']                 = 'Use the store address to calculate taxes if customer is not logged in. You can choose to use the store address for the customer\'s shipping or payment address.';
$_['help_tax_customer']                = 'Use the customer\'s default address when they login to calculate taxes. You can choose to use the default address for the customer\'s shipping or payment address.';
$_['help_customer_online']             = 'Track customers online via the customer reports section.';
$_['help_customer_activity']           = 'Track customers activity via the customer reports section.';
$_['help_customer_search']             = 'Track customers searches via the customer reports section.';
$_['help_customer_group']              = 'Default customer group.';
$_['help_customer_group_display']      = 'Display customer groups that new customers can select to use such as wholesale and business when signing up.';
$_['help_customer_price']              = 'Only show prices when a customer is logged in.';
$_['help_login_attempts']              = 'Maximum login attempts allowed before the account is locked for 1 hour. Customer and affliate accounts can be unlocked on the customer or affliate admin pages.';
$_['help_account']                     = 'Forces people to agree to terms before an account can be created.';
$_['help_account_mail']                = 'Send an email to the store owner when a new account is registered.';
$_['help_invoice_prefix']              = 'Set the invoice prefix (e.g. INV-2011-00). Invoice IDs will start at 1 for each unique prefix.';
$_['help_api']                         = 'Default API user the admin should use.';
$_['help_cart_weight']                 = 'Show the cart weight on the cart page.';
$_['help_checkout_guest']              = 'Allow customers to checkout without creating an account. This will not be available when a downloadable product is in the shopping cart.';
$_['help_checkout']                    = 'Forces people to agree to terms before a customer can checkout.';
$_['help_order_status']                = 'Set the default order status when an order is processed.';
$_['help_processing_status']           = 'Set the order status the customer\'s order must reach before the order starts stock subtraction and coupon, voucher and rewards redemption.';
$_['help_complete_status']             = 'Set the order status the customer\'s order must reach before they are allowed to access their downloadable products and gift vouchers.';
$_['help_order_mail']                  = 'Send an email to the store owner when a new order is created.';
$_['help_stock_display']               = 'Display stock quantity on the product page.';
$_['help_stock_warning']               = 'Display out of stock message on the shopping cart page if a product is out of stock but stock checkout is yes. (Warning always shows if stock checkout is no)';
$_['help_stock_checkout']              = 'Allow customers to still checkout if the products they are ordering are not in stock.';
$_['help_stock_mail']                  = 'Send an email to the store owner when a product\'s stock reaches zero.';
$_['help_affiliate_approval']          = 'Automatically approve any new affiliates who sign up.';
$_['help_affiliate_auto']              = 'Automatically add commission when each order reaches the complete status.';
$_['help_affiliate_commission']        = 'The default affiliate commission percentage.';
$_['help_affiliate']                   = 'Forces people to agree to terms before an affiliate account can be created.';
$_['help_affiliate_activity']          = 'Track affiliate activity via the affiliate reports section.';
$_['help_affiliate_mail']              = 'Send an email to the store owner when a new affiliate is registered.';
$_['help_return']                      = 'Forces people to agree to terms before a return can be created.';
$_['help_return_status']               = 'Set the default return status when a return request is submitted.';
$_['help_return_mail']                 = 'Send an email to the store owner when a new return request is registered.';
$_['help_icon']                        = 'The icon should be a PNG that is 16px x 16px.';
$_['help_mail_protocol']               = 'Select which mail protocol to use for the email delivery.';
$_['help_mail_sendmail_path']          = 'Enter the path to the Sendmail program directory on the host server.';
$_['help_mail_smtp_encryption']        = 'Select the security method that your SMTP server uses..';
$_['help_mail_alert']                  = 'Any additional emails you want to receive the alert email, in addition to the main store email. (comma separated).';
$_['help_secure']                      = 'To use SSL check with your host if a SSL certificate is installed.';
$_['help_shared']                      = 'Try to share the session cookie between stores so the cart can be passed between different domains.';
$_['help_robots']                      = 'A list of web crawler user agents that shared sessions will not be used with. Use separate lines for each user agent.';
$_['help_file_max_size']               = 'The maximum image file size you can upload in Image Manager. Enter as byte.';
$_['help_file_ext_allowed']            = 'Add which file extensions are allowed to be uploaded. Use a new line for each value.';
$_['help_file_mime_allowed']           = 'Add which file mime types are allowed to be uploaded. Use a new line for each value.';
$_['help_maintenance']                 = 'Prevents customers from browsing your store, they will instead see a maintenance message. If you\'re logged in as admin, you will see the store as normal.';
$_['help_maintenance_message']         = 'Enter a message to display at the maintenance page. If none is entered the default text from the language file will be displayed. HTML isn\'t supported.';
$_['help_maintenance_image']           = 'Select a image to display at the maintenance page. If none is selcted the default store or placeholder image will be displayed.';
$_['help_maintenance_login']           = 'Display a login form at the maintenance page.';
$_['help_password']                    = 'Allow forgotten password to be used for the admin. This will be disabled automatically if the system detects a hack attempt.';
$_['help_encryption']                  = 'Please provide a secret key that will be used to encrypt private information when processing orders.';
$_['help_compression']                 = 'GZIP for more efficient transfer to requesting clients. Compression level must be between 0 - 9.';
$_['help_debug_system']                = 'If enabled, diagnostic information (i.e. run time, memory) will be displayed at the bottom of every page of the store back-end and front-end. It is not advisable to leave the debug mode activated when running a live store.';
$_['help_text_editor']                 = 'Admin panel all textarea filed text editor.';
$_['help_seo_url']                     = 'Enable SEO URLs if you want to get pretty URLs and better results with search engines.';
$_['help_seo_rewrite']                 = 'To remove index.php, Apache mod_rewrite module must be installed in your host/server and you need to rename the htaccess.txt to .htaccess';
$_['help_seo_suffix']                  = 'Append .html suffix to the SEO URLs.';
$_['help_seo_category']                = 'Select whether to prepend the category slugs to product URL.';
$_['help_seo_translate']               = 'Translate URLs based on the selected language.';
$_['help_seo_lang_code']               = 'Prepend the language code (en, de) to the SEO URLs.';
$_['help_seo_canonical']               = 'Add canonical link to header for pagination, sorgint etc URLs.';
$_['help_seo_www_red']                 = 'Select whether to redirect to with or without www prefix.';
$_['help_seo_nonseo_red']              = 'Select whether to redirect to the SEO URL if the URL is non-SEO.';
$_['help_meta_title_add']              = 'Add the store title into other pages (product, category, manufacturer etc.) title like My Store - My Product.';
$_['help_meta_generator']              = 'The generator meta tag is generally used to show the company/program that has built the site.';
$_['help_meta_googlekey']              = 'Enter your Google Site Verification Key to verify your site.';
$_['help_meta_alexakey']               = 'Enter your Alexa Site Verification Key to verify your site.';
$_['help_sitemap_all']                 = 'The XML Sitemap link for all store items (products, categories, manufacturers, informations and other pages). The content is updated automatically whenever you create a new item.';
$_['help_sitemap_products']            = 'The XML Sitemap link for products. The content is updated automatically whenever you create a new item.';
$_['help_sitemap_categories']          = 'The XML Sitemap link for categories. The content is updated automatically whenever you create a new item.';
$_['help_sitemap_manufacturers']       = 'The XML Sitemap link for manufacturers. The content is updated automatically whenever you create a new item.';
$_['help_blog_featured_slide']         = 'Dislay a slide for featured items on Blog home page.';
$_['help_blog_post_limit']             = 'Determines how many post items are shown per page (posts).';
$_['help_blog_post_description_lenth'] = 'In the list view, short description character limit (home, categories etc).';
$_['help_blog_post_row']               = 'Determines how many post items are shown per row (posts).';
$_['help_blog_post_sot_order']         = 'Determines how posts are ordered in the list view';
$_['help_blog_related_row']            = 'Determines how many related items are shown per row (posts).';
$_['help_blog_comment_limit']          = 'Determines how many post items are shown per page (comments).';
$_['help_blog_comment_status']         = 'Determines if comments should be published directly after they are added by customers. If set to No they have to be approved and published by a administrator.';
$_['help_blog_comment_activity']       = 'Whether to enable or disable comments system for Blog globally.';
$_['help_blog_comment_mail']           =  'Send an email to the store owner when a new comment is created.';
$_['help_blog_related_short_description_length']  =  'In the list view, short description character limit.';
$_['help_sec_admin_login']             = 'Enter an email address to be notified upon a successful login of anyone in your admin panel. Leave blank to not be sent a notification.';
$_['help_sec_admin_keyword']           = 'Enter a keyword to access the admin panel such as \'mypanel\' so that the system will require it to be in the link like domain.com/admin?mypanel. Leave blank to disable it.';
$_['help_sec_lfi']                     = '(Local File Inclusion) This feature will try to protect against directory traversal techniques (such as route=../../../etc/passwd) that might allow an attacker to read sensitive files.';
$_['help_sec_rfi']                     = '(Remote File Inclusion) This feature will try to protect against access to URLs (such as route=http://www.malicious-site.com/exploit.txt) that might allow an attacker to download and run malicious scripts.';
$_['help_sec_sql']                     = '(SQL Injection) This feature will try to protect against common SQL injection attacks (such as SELECT xyx FROM users) that might allow an attacker to get sensitive data from your database.';
$_['help_sec_xss']                     = '(Cross Site Scripting) This feature will try to protect against Javascript attacks that might cause connection drop.';
$_['help_sec_csrf']                    = '(Cross-Site Request Forgery) This feature will try to protect against authentication attacks that forces your customer to execute unwanted actions. Enter one route per line.';
$_['help_sec_htmlpurifier']            = 'HTMLPurifier Library offers higher security level by cleaning the content of request variables. Enabling this option may affect the page load slightly.';
$_['help_cache_storage']               = 'Select the storage to save the cached data. All options except File require a specific PHP extension to be installed in your server. Please, check the documentation for further details.';
$_['help_cache_memcache_servers']      = 'Servers (i.e. 127.0.0.1:80) to be used as storage. Enter one server per line.';
$_['help_cache_redis_server']          = 'Server (i.e. 127.0.0.1:80) to be used as storage.';
$_['help_cache_lifetime']              = 'The maximum length of time in seconds for a cache file to be stored before it is refreshed. Default: 86400 (24 hours)';
$_['help_cache_clear']                 = 'Clear the cache after a product, category, manufacturer, information is created/edited.';
$_['help_pagecache']                   = 'Page Cache acts as like a page snapshot. It\'s super fast as it caches everything in HTML format. The cache is created on the first page visit by the first visitor of the store. After that, all other visitors will get this page loaded from the cache. Not applicable when visitor logged in or added product to cart or is in cart/checkout page.';
$_['help_pagecache_exclude']           = 'Route values (i.e. common/home) to be excluded from the Page Cache. Enter one route per line.';
$_['help_timezone']                    = 'Choose a city in the list to configure the date and time.';

// Error
$_['error_warning']                    = 'Warning: Please check the form carefully for errors!';
$_['error_permission']                 = 'Warning: You do not have permission to modify settings!';
$_['error_name']                       = 'Store Name must be between 3 and 32 characters!';
$_['error_owner']                      = 'Store Owner must be between 3 and 64 characters!';
$_['error_address']                    = 'Store Address must be between 10 and 256 characters!';
$_['error_email']                      = 'E-Mail Address does not appear to be valid!';
$_['error_telephone']                  = 'Telephone must be between 3 and 32 characters!';
$_['error_meta_title']                 = 'Title must be between 3 and 32 characters!';
$_['error_limit']                      = 'Limit required!';
$_['error_login_attempts']             = 'Login Attempts must be greater than 0!';
$_['error_customer_group_display']     = 'You must include the default customer group if you are going to use this feature!';
$_['error_voucher_min']                = 'Minimum voucher amount required!';
$_['error_voucher_max']                = 'Maximum voucher amount required!';
$_['error_processing_status']          = 'You must choose at least 1 order process status';
$_['error_complete_status']            = 'You must choose at least 1 order complete status';
$_['error_image_thumb']                = 'Product Image Thumb Size dimensions required!';
$_['error_image_popup']                = 'Product Image Popup Size dimensions required!';
$_['error_image_product']              = 'Product List Size dimensions required!';
$_['error_image_category']             = 'Category List Size dimensions required!';
$_['error_image_additional']           = 'Additional Product Image Size dimensions required!';
$_['error_image_related']              = 'Related Product Image Size dimensions required!';
$_['error_image_compare']              = 'Compare Image Size dimensions required!';
$_['error_image_wishlist']             = 'Wish List Image Size dimensions required!';
$_['error_image_cart']                 = 'Cart Image Size dimensions required!';
$_['error_image_location']             = 'Store Image Size dimensions required!';
$_['error_image_maintenance']          = 'Maintenance Image Size dimensions required!';
$_['error_image_blog_post_list']       = 'Post List Image Size dimensions required!';
$_['error_image_blog_post_form']       = 'Post Detail Image Size dimensions required!';
$_['error_blog_name']                  = 'Blog Name required!';
$_['error_blog_meta_title']            = 'Blog Meta Title required!';
$_['error_error_filename']             = 'Error Log Filename required!';
$_['error_encryption']                 = 'Encryption Key must be between 3 and 32 characters!';
$_['error_cache_not_cleared']          = 'Cache Not Cleaned';
$_['error_cache_memcache_servers']     = 'Memcache servers are required!';
$_['error_cache_redis_server']         = 'Redis server is required!';
