<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

class ControllerExtensionModule extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/module');

        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->load->model('extension/extension');
        
        $this->load->model('extension/module');

        $this->getList();
    }
    
    public function install() {
        $this->load->language('extension/module');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('extension/extension');

        $this->load->model('extension/module');

        if ($this->validate()) {
            $this->model_extension_extension->install('module', $this->request->get['extension']);

            $this->load->model('user/user_group');

            $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'module/' . $this->request->get['extension']);
            $this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'module/' . $this->request->get['extension']);

            // Call install method if it exsits
            $this->load->controller('module/' . $this->request->get['extension'] . '/install');

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->getList();    
    }
    
    public function uninstall() {
        $this->load->language('extension/module');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('extension/extension');

        $this->load->model('extension/module');

        if ($this->validate()) {
            $this->model_extension_extension->uninstall('module', $this->request->get['extension']);

            $this->model_extension_module->deleteModulesByCode($this->request->get['extension']);

            $this->load->model('setting/setting');

            $this->model_setting_setting->deleteSetting($this->request->get['extension']);

            // Call uninstall method if it exsits
            $this->load->controller('module/' . $this->request->get['extension'] . '/uninstall');

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
        }    
        
        $this->getList();
    }
    
    public function delete() {
        $this->load->language('extension/module');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('extension/extension');

        $this->load->model('extension/module');

        if (isset($this->request->get['module_id']) && $this->validateDelete()) {
            $this->model_extension_module->deleteModule($this->request->get['module_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->getList();        
    }
    
    public function getList() {
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
        );
        
        $data['heading_title'] = $this->language->get('heading_title');
        
        $data['text_layout'] = sprintf($this->language->get('text_layout'), $this->url->link('appearance/layout', 'token=' . $this->session->data['token'], 'SSL'));
        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_confirm_title'] = sprintf($this->language->get('text_confirm_title'), $this->language->get('heading_title'));

        $data['column_name'] = $this->language->get('column_name');
        $data['column_action'] = $this->language->get('column_action');
        
        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_delete'] = $this->language->get('button_delete');
        $data['button_install'] = $this->language->get('button_install');
        $data['button_uninstall'] = $this->language->get('button_uninstall');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        
        $data['delete'] = $this->url->link('extension/module/delete', 'token=' . $this->session->data['token'], 'SSL');

        $extensions = $this->model_extension_extension->getInstalled('module');

        foreach ($extensions as $key => $value) {
            if (!file_exists(DIR_ADMIN . 'controller/module/' . $value . '.php')) {
                $this->model_extension_extension->uninstall('module', $value);

                unset($extensions[$key]);
                
                $this->model_extension_module->deleteModulesByCode($value);
            }
        }    

        $data['extensions'] = array();

        $files = glob(DIR_ADMIN . 'controller/module/*.php');

        if ($files) {
            foreach ($files as $file) {
                $extension = basename($file, '.php');

                $this->load->language('module/' . $extension);

                $module_data = array();
                
                $modules = $this->model_extension_module->getModulesByCode($extension);
                
                foreach ($modules as $module) {
                    $module_data[] = array(
                        'module_id' => $module['module_id'],
                        'name'      => $this->language->get('heading_title') . ' &gt; ' . $module['name'],
                        'edit'      => $this->url->link('module/' . $extension, 'token=' . $this->session->data['token'] . '&module_id=' . $module['module_id'], 'SSL'),
                        'delete'    => $this->url->link('extension/module/delete', 'token=' . $this->session->data['token'] . '&module_id=' . $module['module_id'], 'SSL')
                    );
                }

                $data['extensions'][] = array(
                    'name'      => $this->language->get('heading_title'),
                    'module'    => $module_data,
                    'install'   => $this->url->link('extension/module/install', 'token=' . $this->session->data['token'] . '&extension=' . $extension, 'SSL'),
                    'uninstall' => $this->url->link('extension/module/uninstall', 'token=' . $this->session->data['token'] . '&extension=' . $extension, 'SSL'),
                    'installed' => in_array($extension, $extensions),
                    'edit'      => $this->url->link('module/' . $extension, 'token=' . $this->session->data['token'], 'SSL')
                );
            }
        }

        $names = array();
        foreach ($data['extensions'] as $key => $row)
        {
            $names[$key] = $row['name'];
        }
        array_multisort($names, SORT_ASC, $data['extensions']);
        
        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }
                
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module.tpl', $data));
    }
    
    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
            
        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'extension/module')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }    
}
