/**
 * Format title into a slug value after each keypress
 * Disabled if the slug is manually changed
 */
$(function() {
	var input = $('input[name=title]'),
		output = $('input[name=slug]');
	var slugHasValue = output.val(),
		slugOldValue = false;

	var slugify = function(str) {
		str = String(str);
		var characterMap = {
			'©': '(c)',
			'Á': 'A',
			'á': 'a',
			'À': 'A',
			'à': 'a',
			'Â': 'A',
			'â': 'a',
			'Å': 'A',
			'å': 'a',
			'Ä': 'Ae',
			'ä': 'ae',
			'Ã': 'A',
			'ã': 'a',
			'Ą': 'A',
			'ą': 'a',
			'Ā': 'A',
			'ā': 'a',
			'Æ': 'AE',
			'æ': 'ae',
			'Ć': 'C',
			'ć': 'c',
			'Č': 'C',
			'č': 'c',
			'Ç': 'C',
			'ç': 'c',
			'Ď': 'D',
			'ď': 'd',
			'Ð': 'D',
			'ð': 'd',
			'É': 'E',
			'é': 'e',
			'È': 'E',
			'è': 'e',
			'Ê': 'E',
			'ê': 'e',
			'Ě': 'E',
			'ě': 'e',
			'Ë': 'E',
			'ë': 'e',
			'Ę': 'e',
			'ę': 'e',
			'Ē': 'E',
			'ē': 'e',
			'Ğ': 'G',
			'ğ': 'g',
			'Ģ': 'G',
			'ģ': 'g',
			'Í': 'I',
			'í': 'i',
			'Ì': 'I',
			'ì': 'i',
			'Î': 'I',
			'î': 'i',
			'Ï': 'I',
			'ï': 'i',
			'İ': 'I',
			'Ī': 'i',
			'ī': 'i',
			'ı': 'i',
			'Ķ': 'k',
			'ķ': 'k',
			'Ļ': 'L',
			'ļ': 'l',
			'Ł': 'L',
			'ł': 'l',
			'Ń': 'N',
			'ń': 'n',
			'Ň': 'N',
			'ň': 'n',
			'Ñ': 'N',
			'ñ': 'n',
			'Ņ': 'N',
			'ņ': 'n',
			'Ó': 'O',
			'Ó': 'o',
			'ó': 'o',
			'Ò': 'O',
			'ò': 'o',
			'Ô': 'O',
			'ô': 'o',
			'Ö': 'Oe',
			'ö': 'oe',
			'Ő': 'O',
			'ő': 'o',
			'Õ': 'O',
			'õ': 'o',
			'Ø': 'O',
			'ø': 'o',
			'Ř': 'R',
			'ř': 'r',
			'Ś': 'S',
			'ś': 's',
			'Š': 'S',
			'š': 's',
			'Ş': 'S',
			'ş': 's',
			'ß': 'ss',
			'Ť': 'T',
			'ť': 't',
			'Ú': 'U',
			'ú': 'u',
			'Ù': 'U',
			'ù': 'u',
			'Û': 'U',
			'û': 'u',
			'Ů': 'U',
			'ů': 'u',
			'Ü': 'Ue',
			'ü': 'ue',
			'Ű': 'U',
			'ű': 'u',
			'Ū': 'u',
			'ū': 'u',
			'Ý': 'Y',
			'ý': 'y',
			'ÿ': 'y',
			'Ź': 'Z',
			'ź': 'z',
			'Ž': 'Z',
			'ž': 'z',
			'Ż': 'Z',
			'ż': 'z',
			'Þ': 'TH',
			'þ': 'th',
			'Α': 'A',
			'α': 'a',
			'Ά': 'A',
			'ά': 'a',
			'Β': 'B',
			'β': 'b',
			'Γ': 'G',
			'γ': 'g',
			'Δ': 'D',
			'δ': 'd',
			'Ε': 'E',
			'ε': 'e',
			'Έ': 'E',
			'έ': 'e',
			'Ζ': 'Z',
			'ζ': 'z',
			'Η': 'H',
			'η': 'h',
			'Ή': 'H',
			'ή': 'h',
			'Θ': '8',
			'θ': '8',
			'Ι': 'I',
			'ι': 'i',
			'Ί': 'I',
			'ί': 'i',
			'Ϊ': 'I',
			'ϊ': 'i',
			'ΐ': 'i',
			'Κ': 'K',
			'κ': 'k',
			'Λ': 'L',
			'λ': 'l',
			'Μ': 'M',
			'μ': 'm',
			'Ν': 'N',
			'ν': 'n',
			'Ξ': '3',
			'ξ': '3',
			'Ο': 'O',
			'ο': 'o',
			'Ό': 'O',
			'ό': 'o',
			'Π': 'P',
			'π': 'p',
			'Ρ': 'R',
			'ρ': 'r',
			'Σ': 'S',
			'ς': 's',
			'σ': 's',
			'Τ': 'T',
			'τ': 't',
			'Υ': 'Y',
			'υ': 'y',
			'Ύ': 'Y',
			'ύ': 'y',
			'Ϋ': 'Y',
			'ϋ': 'y',
			'ΰ': 'y',
			'Φ': 'F',
			'φ': 'f',
			'Χ': 'X',
			'χ': 'x',
			'Ψ': 'PS',
			'ψ': 'ps',
			'Ω': 'W',
			'ω': 'w',
			'Ώ': 'W',
			'ώ': 'w',
			'А': 'A',
			'а': 'a',
			'Б': 'B',
			'б': 'b',
			'В': 'V',
			'в': 'v',
			'Г': 'G',
			'г': 'g',
			'Ґ': 'G',
			'Д': 'D',
			'д': 'd',
			'Е': 'E',
			'е': 'e',
			'Ё': 'Yo',
			'ё': 'yo',
			'Є': 'Ye',
			'є': 'ye',
			'Ж': 'Zh',
			'ж': 'zh',
			'З': 'Z',
			'з': 'z',
			'И': 'I',
			'и': 'i',
			'І': 'I',
			'і': 'i',
			'Ї': 'Yi',
			'ї': 'yi',
			'Й': 'J',
			'й': 'j',
			'К': 'K',
			'к': 'k',
			'Л': 'L',
			'л': 'l',
			'М': 'M',
			'м': 'm',
			'Н': 'N',
			'н': 'n',
			'О': 'O',
			'о': 'o',
			'П': 'P',
			'п': 'p',
			'Р': 'R',
			'р': 'r',
			'С': 'S',
			'с': 's',
			'Т': 'T',
			'т': 't',
			'У': 'U',
			'у': 'u',
			'Ф': 'F',
			'ф': 'f',
			'Х': 'H',
			'х': 'h',
			'Ц': 'C',
			'ц': 'c',
			'Ч': 'Ch',
			'ч': 'ch',
			'Ш': 'Sh',
			'ш': 'sh',
			'Щ': 'Sh',
			'щ': 'sh',
			'Ы': 'Y',
			'ы': 'y',
			'Э': 'E',
			'э': 'e',
			'Ю': 'Yu',
			'ю': 'yu',
			'Я': 'Ya',
			'я': 'ya'
		};

		// remove accents
		var from = ['À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ', '·', '/', '_', ',', ':', ';'],
			to = ['A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o', '-', '-', '-', '-', '-', '-'];

		for (var i = 0; i < from.length; i++) {
			str = str.replace(new RegExp(from[i], 'g'), to[i]);
		};

		return str.toLowerCase().replace(/[^a-z0-9 -]/g, '') // remove invalid chars
			.replace(/\s+/g, '-') // collapse whitespace and replace by -
			.replace(/-+/g, '-'); // collapse dashes
	};

	output.bind('focus', function() {
		slugOldValue = output.val();
		slugHasValue = output.val();
	});

	output.bind('blur', function() {
		if (output.val() == '') {
			output.val(slugify(input.val()));
		} else {
			output.val(slugify(output.val()));
		}
	});

	input.bind('keyup', function() {
		if (slugHasValue == '') {
			output.val(slugify(input.val()));
		}
	});
});
