
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_alegro129`
--

-- --------------------------------------------------------

--
-- Table structure for table `address`
--

CREATE TABLE `address` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `vendor_id` int(11) NOT NULL DEFAULT '0',
  `company` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address_1` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address_2` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`customer_id`),
  KEY `vendor_id` (`vendor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` int(11) NOT NULL DEFAULT '0',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `path` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(3) DEFAULT '0',
  `category_hide` int(1) NOT NULL DEFAULT '0',
  `date_added` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `category`
--

INSERT INTO `category` VALUES
(1, 6, 0, '1', 1, 0, '2007-08-30 20:56:29', '2009-12-11 04:43:42'),
(2, 6, 0, '2', 2, 0, '2007-08-30 18:22:13', '2009-01-08 20:30:22'),
(3, 7, 0, '3', 3, 0, '2007-08-30 20:56:18', '2009-01-08 20:09:34'),
(4, 5, 0, '4', 4, 0, '2008-12-27 10:57:32', '2009-04-25 17:31:34'),
(5, 6, 1, '1_5', 1, 0, '2008-12-27 11:00:16', '2009-12-06 12:40:45'),
(6, 7, 1, '1_6', 2, 0, '2008-12-27 11:00:41', '2009-12-06 12:40:56'),
(7, 5, 1, '1_7', 3, 0, '2008-12-27 11:01:23', '2009-12-06 12:41:26'),
(8, 2, 1, '1_8', 5, 0, '2008-12-27 11:01:55', '2009-12-06 12:41:07'),
(9, 3, 0, '9', 6, 0, '2008-12-27 11:14:46', '2009-01-08 20:12:00'),
(10, 8, 0, '10', 5, 0, '2008-12-30 21:18:16', '2009-01-08 20:30:35'),
(11, 8, 1, '1_11', 4, 0, '2008-12-30 21:19:00', '2009-12-06 12:41:16');

-- --------------------------------------------------------

--
-- Table structure for table `category_description`
--

CREATE TABLE `category_description` (
  `category_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `meta_keywords` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`category_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `category_description`
--

INSERT INTO `category_description` VALUES
(3, 1, 'Latest', '<p>Latest Products to be added. These will only be displayed on the Home Page</p>', '', '', ''),
(9, 1, 'Motor Bikes', '<p>Default MotorBikes: These Products Demonstrate some features of our modified search.<br>\r\nYou can search by hidden terms.</p>', '', '', ''),
(1, 1, 'All &amp; Products', '<p>All Products: &amp; Latest, Featured, Specials, Related Products &amp; Default MotorBikes</p>', '', '', ''),
(2, 1, 'Featured', '<p>Featured Products. These will only be displayed on the Home Page.<br>\r\nYou can select as many items as you want, but only the amount set in admin <br>\r\nwill be display. If the amount is greater than admin limit, the items are randomly<br>\r\nselected.</p>', '', '', ''),
(10, 1, 'Related Products', '<p>Related Products: These products are items specified by the selected product.<br>\r\nThey are only displayed on Product Page in Right Side bar.<br>\r\nYou can select as many items as you want, but only the amount set in admin <br>\r\nwill be display. If the amount is greater than admin limit, the items are randomly<br>\r\nselected.</p>', '', '', ''),
(7, 1, 'Specials', '<p>Products on Special: These products are Special Priced items.<br>\r\nThey are displayed on Home, Category and Product Pages in the Right Side bar.<br>\r\nIf Related Items are available for a product, Specials are not displayed on Product page.<br>\r\nYou can select as many items as you want, but only the amount set in admin <br>\r\nwill be display. If the amount is greater than admin limit, the items are randomly<br>\r\nselected.</p>', '', '', ''),
(4, 1, 'Specials', '<p>Products on Special: These products are Special Priced items.<br>\r\nThey are displayed on Home, Category and Product Pages in the Right Side bar.<br>\r\nIf Related Items are available for a product, Specials are not displayed on Product page.<br>\r\nYou can select as many items as you want, but only the amount set in admin <br>\r\nwill be display. If the amount is greater than admin limit, the items are randomly<br>\r\nselected.</p>', 'specials, category', 'Category for products on special', 'Products on special'),
(5, 1, 'Featured', '<p>Featured Products. These will only be displayed on the Home Page.<br>\r\nYou can select as many items as you want, but only the amount set in admin <br>\r\nwill be display. If the amount is greater than admin limit, the items are randomly<br>\r\nselected.</p>', '', '', ''),
(6, 1, 'Latest', '<p>Latest Products to be added. These will only be displayed on the Home Page</p>', '', '', ''),
(8, 1, 'Motor Bikes', '<p>Default MotorBikes: These Products Demonstrate some features of our modified search.<br>\r\nYou can search by hidden terms.</p>', '', '', ''),
(11, 1, 'Related Products', '<p>Related Products: These products are items specified by the selected product.<br>\r\nThey are only displayed on Product Page in Right Side bar.<br>\r\nYou can select as many items as you want, but only the amount set in admin <br>\r\nwill be display. If the amount is greater than admin limit, the items are randomly<br>\r\nselected.</p>', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country_status` int(1) NOT NULL DEFAULT '0',
  `iso_code_2` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `iso_code_3` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address_format` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=250 ;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
(1, 'Afghanistan', 0, 'AF', 'AFG', ''),
(2, 'Albania', 0, 'AL', 'ALB', ''),
(3, 'Algeria', 0, 'DZ', 'DZA', ''),
(4, 'American Samoa', 0, 'AS', 'ASM', ''),
(5, 'Andorra', 0, 'AD', 'AND', ''),
(6, 'Angola', 0, 'AO', 'AGO', ''),
(7, 'Anguilla', 0, 'AI', 'AIA', ''),
(8, 'Antarctica', 0, 'AQ', 'ATA', ''),
(9, 'Antigua and Barbuda', 0, 'AG', 'ATG', ''),
(10, 'Argentina', 0, 'AR', 'ARG', ''),
(11, 'Armenia', 0, 'AM', 'ARM', ''),
(12, 'Aruba', 0, 'AW', 'ABW', ''),
(13, 'Australia', 0, 'AU', 'AUS', ''),
(14, 'Austria', 0, 'AT', 'AUT', ''),
(15, 'Azerbaijan', 0, 'AZ', 'AZE', ''),
(16, 'Bahamas', 0, 'BS', 'BHS', ''),
(17, 'Bahrain', 0, 'BH', 'BHR', ''),
(18, 'Bangladesh', 0, 'BD', 'BGD', ''),
(19, 'Barbados', 0, 'BB', 'BRB', ''),
(20, 'Belarus', 0, 'BY', 'BLR', ''),
(21, 'Belgium', 0, 'BE', 'BEL', ''),
(22, 'Belize', 0, 'BZ', 'BLZ', ''),
(23, 'Benin', 0, 'BJ', 'BEN', ''),
(24, 'Bermuda', 0, 'BM', 'BMU', ''),
(25, 'Bhutan', 0, 'BT', 'BTN', ''),
(26, 'Bolivia', 0, 'BO', 'BOL', ''),
(27, 'Bosnia and Herzegowina', 0, 'BA', 'BIH', ''),
(28, 'Botswana', 0, 'BW', 'BWA', ''),
(29, 'Bouvet Island', 0, 'BV', 'BVT', ''),
(30, 'Brazil', 0, 'BR', 'BRA', ''),
(31, 'British Indian Ocean Territory', 0, 'IO', 'IOT', ''),
(32, 'Brunei Darussalam', 0, 'BN', 'BRN', ''),
(33, 'Bulgaria', 0, 'BG', 'BGR', ''),
(34, 'Burkina Faso', 0, 'BF', 'BFA', ''),
(35, 'Burundi', 0, 'BI', 'BDI', ''),
(36, 'Cambodia', 0, 'KH', 'KHM', ''),
(37, 'Cameroon', 0, 'CM', 'CMR', ''),
(38, 'Canada', 1, 'CA', 'CAN', ''),
(39, 'Cape Verde', 0, 'CV', 'CPV', ''),
(40, 'Cayman Islands', 0, 'KY', 'CYM', ''),
(41, 'Central African Republic', 0, 'CF', 'CAF', ''),
(42, 'Chad', 0, 'TD', 'TCD', ''),
(43, 'Chile', 0, 'CL', 'CHL', ''),
(44, 'China', 0, 'CN', 'CHN', ''),
(45, 'Christmas Island', 0, 'CX', 'CXR', ''),
(46, 'Cocos (Keeling) Islands', 0, 'CC', 'CCK', ''),
(47, 'Colombia', 0, 'CO', 'COL', ''),
(48, 'Comoros', 0, 'KM', 'COM', ''),
(49, 'Congo', 0, 'CG', 'COG', ''),
(50, 'Cook Islands', 0, 'CK', 'COK', ''),
(51, 'Costa Rica', 0, 'CR', 'CRI', ''),
(52, 'Côte d&#039;Ivoire', 0, 'CI', 'CIV', ''),
(53, 'Croatia', 0, 'HR', 'HRV', ''),
(54, 'Cuba', 0, 'CU', 'CUB', ''),
(55, 'Cyprus', 0, 'CY', 'CYP', ''),
(56, 'Czech Republic', 0, 'CZ', 'CZE', ''),
(57, 'Denmark', 0, 'DK', 'DNK', ''),
(58, 'Djibouti', 0, 'DJ', 'DJI', ''),
(59, 'Dominica', 0, 'DM', 'DMA', ''),
(60, 'Dominican Republic', 0, 'DO', 'DOM', ''),
(61, 'East Timor', 0, 'TP', 'TMP', ''),
(62, 'Ecuador', 0, 'EC', 'ECU', ''),
(63, 'Egypt', 0, 'EG', 'EGY', ''),
(64, 'El Salvador', 0, 'SV', 'SLV', ''),
(65, 'Equatorial Guinea', 0, 'GQ', 'GNQ', ''),
(66, 'Eritrea', 0, 'ER', 'ERI', ''),
(67, 'Estonia', 0, 'EE', 'EST', ''),
(68, 'Ethiopia', 0, 'ET', 'ETH', ''),
(69, 'Falkland Islands (Malvinas)', 0, 'FK', 'FLK', ''),
(70, 'Faroe Islands', 0, 'FO', 'FRO', ''),
(71, 'Fiji', 0, 'FJ', 'FJI', ''),
(72, 'Finland', 0, 'FI', 'FIN', ''),
(73, 'France', 0, 'FR', 'FRA', ''),
(74, 'France, Metropolitan', 0, 'FX', 'FXX', ''),
(75, 'French Guiana', 0, 'GF', 'GUF', ''),
(76, 'French Polynesia', 0, 'PF', 'PYF', ''),
(77, 'French Southern Territories', 0, 'TF', 'ATF', ''),
(78, 'Gabon', 0, 'GA', 'GAB', ''),
(79, 'Gambia', 0, 'GM', 'GMB', ''),
(80, 'Georgia', 0, 'GE', 'GEO', ''),
(81, 'Germany', 0, 'DE', 'DEU', ''),
(82, 'Ghana', 0, 'GH', 'GHA', ''),
(83, 'Gibraltar', 0, 'GI', 'GIB', ''),
(84, 'Greece', 0, 'GR', 'GRC', ''),
(85, 'Greenland', 0, 'GL', 'GRL', ''),
(86, 'Grenada', 0, 'GD', 'GRD', ''),
(87, 'Guadeloupe', 0, 'GP', 'GLP', ''),
(88, 'Guam', 0, 'GU', 'GUM', ''),
(89, 'Guatemala', 0, 'GT', 'GTM', ''),
(90, 'Guinea', 0, 'GN', 'GIN', ''),
(91, 'Guinea-bissau', 0, 'GW', 'GNB', ''),
(92, 'Guyana', 0, 'GY', 'GUY', ''),
(93, 'Haiti', 0, 'HT', 'HTI', ''),
(94, 'Heard and Mc Donald Islands', 0, 'HM', 'HMD', ''),
(95, 'Honduras', 0, 'HN', 'HND', ''),
(96, 'Hong Kong', 0, 'HK', 'HKG', ''),
(97, 'Hungary', 0, 'HU', 'HUN', ''),
(98, 'Iceland', 0, 'IS', 'ISL', ''),
(99, 'India', 0, 'IN', 'IND', ''),
(100, 'Indonesia', 0, 'ID', 'IDN', ''),
(101, 'Iran (Islamic Republic of)', 0, 'IR', 'IRN', ''),
(102, 'Iraq', 0, 'IQ', 'IRQ', ''),
(103, 'Ireland', 0, 'IE', 'IRL', ''),
(104, 'Israel', 0, 'IL', 'ISR', ''),
(105, 'Italy', 0, 'IT', 'ITA', ''),
(106, 'Jamaica', 0, 'JM', 'JAM', ''),
(107, 'Japan', 0, 'JP', 'JPN', ''),
(108, 'Jordan', 0, 'JO', 'JOR', ''),
(109, 'Kazakhstan', 0, 'KZ', 'KAZ', ''),
(110, 'Kenya', 0, 'KE', 'KEN', ''),
(111, 'Kiribati', 0, 'KI', 'KIR', ''),
(112, 'Korea, Democratic People&#039;s Republic of', 0, 'KP', 'PRK', ''),
(113, 'Korea, Republic of', 0, 'KR', 'KOR', ''),
(114, 'Kuwait', 0, 'KW', 'KWT', ''),
(115, 'Kyrgyzstan', 0, 'KG', 'KGZ', ''),
(116, 'Lao People&#039;s Democratic Republic', 0, 'LA', 'LAO', ''),
(117, 'Latvia', 0, 'LV', 'LVA', ''),
(118, 'Lebanon', 0, 'LB', 'LBN', ''),
(119, 'Lesotho', 0, 'LS', 'LSO', ''),
(120, 'Liberia', 0, 'LR', 'LBR', ''),
(121, 'Libyan Arab Jamahiriya', 0, 'LY', 'LBY', ''),
(122, 'Liechtenstein', 0, 'LI', 'LIE', ''),
(123, 'Lithuania', 0, 'LT', 'LTU', ''),
(124, 'Luxembourg', 0, 'LU', 'LUX', ''),
(125, 'Macau', 0, 'MO', 'MAC', ''),
(126, 'Macedonia, The Former Yugoslav Republic of', 0, 'MK', 'MKD', ''),
(127, 'Madagascar', 0, 'MG', 'MDG', ''),
(128, 'Malawi', 0, 'MW', 'MWI', ''),
(129, 'Malaysia', 0, 'MY', 'MYS', ''),
(130, 'Maldives', 0, 'MV', 'MDV', ''),
(131, 'Mali', 0, 'ML', 'MLI', ''),
(132, 'Malta', 0, 'MT', 'MLT', ''),
(133, 'Marshall Islands', 0, 'MH', 'MHL', ''),
(134, 'Martinique', 0, 'MQ', 'MTQ', ''),
(135, 'Mauritania', 0, 'MR', 'MRT', ''),
(136, 'Mauritius', 0, 'MU', 'MUS', ''),
(137, 'Mayotte', 0, 'YT', 'MYT', ''),
(138, 'Mexico', 0, 'MX', 'MEX', ''),
(139, 'Micronesia, Federated States of', 0, 'FM', 'FSM', ''),
(140, 'Moldova, Republic of', 0, 'MD', 'MDA', ''),
(141, 'Monaco', 0, 'MC', 'MCO', ''),
(142, 'Mongolia', 0, 'MN', 'MNG', ''),
(143, 'Montserrat', 0, 'MS', 'MSR', ''),
(144, 'Morocco', 0, 'MA', 'MAR', ''),
(145, 'Mozambique', 0, 'MZ', 'MOZ', ''),
(146, 'Myanmar', 0, 'MM', 'MMR', ''),
(147, 'Namibia', 0, 'NA', 'NAM', ''),
(148, 'Nauru', 0, 'NR', 'NRU', ''),
(149, 'Nepal', 0, 'NP', 'NPL', ''),
(150, 'Netherlands', 0, 'NL', 'NLD', ''),
(151, 'Netherlands Antilles', 0, 'AN', 'ANT', ''),
(152, 'New Caledonia', 0, 'NC', 'NCL', ''),
(153, 'New Zealand', 0, 'NZ', 'NZL', ''),
(154, 'Nicaragua', 0, 'NI', 'NIC', ''),
(155, 'Niger', 0, 'NE', 'NER', ''),
(156, 'Nigeria', 0, 'NG', 'NGA', ''),
(157, 'Niue', 0, 'NU', 'NIU', ''),
(158, 'Norfolk Island', 0, 'NF', 'NFK', ''),
(159, 'Northern Mariana Islands', 0, 'MP', 'MNP', ''),
(160, 'Norway', 0, 'NO', 'NOR', ''),
(161, 'Oman', 0, 'OM', 'OMN', ''),
(162, 'Pakistan', 0, 'PK', 'PAK', ''),
(163, 'Palau', 0, 'PW', 'PLW', ''),
(164, 'Panama', 0, 'PA', 'PAN', ''),
(165, 'Papua New Guinea', 0, 'PG', 'PNG', ''),
(166, 'Paraguay', 0, 'PY', 'PRY', ''),
(167, 'Peru', 0, 'PE', 'PER', ''),
(168, 'Philippines', 0, 'PH', 'PHL', ''),
(169, 'Pitcairn', 0, 'PN', 'PCN', ''),
(170, 'Poland', 0, 'PL', 'POL', ''),
(171, 'Portugal', 0, 'PT', 'PRT', ''),
(172, 'Puerto Rico', 0, 'PR', 'PRI', ''),
(173, 'Qatar', 0, 'QA', 'QAT', ''),
(174, 'Reunion', 0, 'RE', 'REU', ''),
(175, 'Romania', 0, 'RO', 'ROM', ''),
(176, 'Russian Federation', 0, 'RU', 'RUS', ''),
(177, 'Rwanda', 0, 'RW', 'RWA', ''),
(178, 'Saint Kitts and Nevis', 0, 'KN', 'KNA', ''),
(179, 'Saint Lucia', 0, 'LC', 'LCA', ''),
(180, 'Saint Vincent and the Grenadines', 0, 'VC', 'VCT', ''),
(181, 'Samoa', 0, 'WS', 'WSM', ''),
(182, 'San Marino', 0, 'SM', 'SMR', ''),
(183, 'Sao Tome and Principe', 0, 'ST', 'STP', ''),
(184, 'Saudi Arabia', 0, 'SA', 'SAU', ''),
(185, 'Senegal', 0, 'SN', 'SEN', ''),
(186, 'Seychelles', 0, 'SC', 'SYC', ''),
(187, 'Sierra Leone', 0, 'SL', 'SLE', ''),
(188, 'Singapore', 0, 'SG', 'SGP', ''),
(189, 'Slovakia (Slovak Republic)', 0, 'SK', 'SVK', ''),
(190, 'Slovenia', 0, 'SI', 'SVN', ''),
(191, 'Solomon Islands', 0, 'SB', 'SLB', ''),
(192, 'Somalia', 0, 'SO', 'SOM', ''),
(193, 'South Africa', 0, 'ZA', 'ZAF', ''),
(194, 'South Georgia and the South Sandwich Islands', 0, 'GS', 'SGS', ''),
(195, 'Spain', 0, 'ES', 'ESP', ''),
(196, 'Sri Lanka', 0, 'LK', 'LKA', ''),
(197, 'St. Helena', 0, 'SH', 'SHN', ''),
(198, 'St. Pierre and Miquelon', 0, 'PM', 'SPM', ''),
(199, 'Sudan', 0, 'SD', 'SDN', ''),
(200, 'Suriname', 0, 'SR', 'SUR', ''),
(201, 'Svalbard and Jan Mayen Islands', 0, 'SJ', 'SJM', ''),
(202, 'Swaziland', 0, 'SZ', 'SWZ', ''),
(203, 'Sweden', 0, 'SE', 'SWE', ''),
(204, 'Switzerland', 0, 'CH', 'CHE', ''),
(205, 'Syrian Arab Republic', 0, 'SY', 'SYR', ''),
(206, 'Taiwan', 0, 'TW', 'TWN', ''),
(207, 'Tajikistan', 0, 'TJ', 'TJK', ''),
(208, 'Tanzania, United Republic of', 0, 'TZ', 'TZA', ''),
(209, 'Thailand', 0, 'TH', 'THA', ''),
(210, 'Togo', 0, 'TG', 'TGO', ''),
(211, 'Tokelau', 0, 'TK', 'TKL', ''),
(212, 'Tonga', 0, 'TO', 'TON', ''),
(213, 'Trinidad and Tobago', 0, 'TT', 'TTO', ''),
(214, 'Tunisia', 0, 'TN', 'TUN', ''),
(215, 'Turkey', 0, 'TR', 'TUR', ''),
(216, 'Turkmenistan', 0, 'TM', 'TKM', ''),
(217, 'Turks and Caicos Islands', 0, 'TC', 'TCA', ''),
(218, 'Tuvalu', 0, 'TV', 'TUV', ''),
(219, 'Uganda', 0, 'UG', 'UGA', ''),
(220, 'Ukraine', 0, 'UA', 'UKR', ''),
(221, 'United Arab Emirates', 0, 'AE', 'ARE', ''),
(222, 'United Kingdom', 0, 'GB', 'GBR', ''),
(223, 'United States', 1, 'US', 'USA', ''),
(224, 'United States Minor Outlying Islands', 0, 'UM', 'UMI', ''),
(225, 'Uruguay', 0, 'UY', 'URY', ''),
(226, 'Uzbekistan', 0, 'UZ', 'UZB', ''),
(227, 'Vanuatu', 0, 'VU', 'VUT', ''),
(228, 'Vatican City State (Holy See)', 0, 'VA', 'VAT', ''),
(229, 'Venezuela', 0, 'VE', 'VEN', ''),
(230, 'Viet Nam', 0, 'VN', 'VNM', ''),
(231, 'Virgin Islands (British)', 0, 'VG', 'VGB', ''),
(232, 'Virgin Islands (U.S.)', 0, 'VI', 'VIR', ''),
(233, 'Wallis and Futuna Islands', 0, 'WF', 'WLF', ''),
(234, 'Western Sahara', 0, 'EH', 'ESH', ''),
(235, 'Yemen', 0, 'YE', 'YEM', ''),
(236, 'Yugoslavia', 0, 'YU', 'YUG', ''),
(237, 'Congo, Democratic Republic of (was Zaire)', 0, 'CD', 'COD', ''),
(238, 'Zambia', 0, 'ZM', 'ZMB', ''),
(239, 'Zimbabwe', 0, 'ZW', 'ZWE', ''),
(240, 'Aaland Islands', 0, 'AX', 'ALA', ''),
(241, 'Guernsey', 0, 'GG', 'GGY', ''),
(242, 'Isle of Man', 0, 'IM', 'IMN', ''),
(243, 'Jersey', 0, 'JE', 'JEY', ''),
(244, 'Montenegro', 0, 'ME', 'MNE', ''),
(245, 'Palestinian Territory, occupied', 0, 'PS', 'PSE', ''),
(246, 'Serbia', 0, 'RS', 'SRB', ''),
(247, 'St. Barthelemy', 0, 'BL', 'BLM', ''),
(248, 'St. Martin (french part)', 0, 'MF', 'MAF', ''),
(249, 'Timor-Leste', 0, 'TL', 'TLS', '');

-- --------------------------------------------------------

--
-- Table structure for table `coupon`
--

CREATE TABLE `coupon` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `discount` decimal(15,4) NOT NULL,
  `prefix` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `minimum_order` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `shipping` int(1) NOT NULL,
  `date_start` datetime NOT NULL,
  `date_end` datetime NOT NULL,
  `uses_total` int(11) NOT NULL,
  `uses_customer` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(1) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`coupon_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `coupon`
--

INSERT INTO `coupon` VALUES
(1, '1234', 10.0000, '-', 0.0000, 1, '2007-01-01 00:00:00', '2008-01-01 00:00:00', 1000, '1000', 1, '2007-08-23 17:38:27');

-- --------------------------------------------------------

--
-- Table structure for table `coupon_description`
--

CREATE TABLE `coupon_description` (
  `coupon_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`coupon_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `coupon_description`
--

INSERT INTO `coupon_description` VALUES
(1, 1, 'Coupon (-10%)', '10% Discount to all customer with special offer coupon code.');

-- --------------------------------------------------------

--
-- Table structure for table `coupon_product`
--

CREATE TABLE `coupon_product` (
  `coupon_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `coupon_product`
--

INSERT INTO `coupon_product` VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `coupon_redeem`
--

CREATE TABLE `coupon_redeem` (
  `coupon_redeem_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `coupon_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_redeem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` int(1) NOT NULL DEFAULT '1',
  `lock_rate` int(1) NOT NULL DEFAULT '0',
  `symbol_left` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `symbol_right` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimal_place` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` double(13,8) DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`currency_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=95 ;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
(1, 'Canadian Dollar', 'CAD', 1, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(2, 'United States Dollar', 'USD', 1, 0, '$', '', '2', 1.00000000, '2009-10-11 14:44:23'),
(3, 'British Pound', 'GBP', 1, 0, '£', '', '2', 1.00000000, '2009-10-11 10:36:51'),
(4, 'Euro', 'EUR', 1, 0, '', '€', '2', 1.00000000, '2008-12-17 20:46:47'),
(5, 'Australian Dollar', 'AUD', 1, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(6, 'United Arab Emirates Dirham', 'AED', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(7, 'Netherlands Antillean Guilder', 'ANG', 0, 0, 'ƒ', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(8, 'Argentine Peso', 'ARS', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(9, 'Bangladeshi Taka', 'BDT', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(10, 'Bulgarian Lev', 'BGN', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(11, 'Bahraini Dinar', 'BHD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(12, 'Brunei Dollar', 'BND', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(13, 'Bolivian Boliviano', 'BOB', 0, 0, '$b', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(14, 'Brazilian Real', 'BRL', 0, 0, 'R$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(15, 'Botswanan Pula', 'BWP', 0, 0, 'P', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(16, 'Swiss Franc', 'CHF', 0, 0, 'CHF', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(17, 'Chilean Peso', 'CLP', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(18, 'Chinese Yuan Renminbi', 'CNY', 0, 0, '¥', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(19, 'Colombian Peso', 'COP', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(20, 'Costa Rican Colón', 'CRC', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(21, 'Czech Republic Koruna', 'CZK', 0, 0, 'Kc', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(22, 'Danish Krone', 'DKK', 0, 0, 'kr', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(23, 'Dominican Peso', 'DOP', 0, 0, 'RD$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(24, 'Algerian Dinar', 'DZD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(25, 'Estonian Kroon', 'EEK', 0, 0, 'kr', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(26, 'Egyptian Pound', 'EGP', 0, 0, '£', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(27, 'Fijian Dollar', 'FJD', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(28, 'Hong Kong Dollar', 'HKD', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(29, 'Honduran Lempira', 'HNL', 0, 0, 'L', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(30, 'Croatian Kuna', 'HRK', 0, 0, 'kn', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(31, 'Hungarian Forint', 'HUF', 0, 0, '', 'Ft', '2', 1.00000000, '2008-12-17 20:46:47'),
(32, 'Indonesian Rupiah', 'IDR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(33, 'Israeli New Sheqel', 'ILS', 0, 0, '?', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(34, 'Indian Rupee', 'INR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(35, 'Icelandic Króna', 'ISK', 0, 0, 'kr', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(36, 'Jamaican Dollar', 'JMD', 0, 0, 'J$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(37, 'Jordanian Dinar', 'JOD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(38, 'Japanese Yen', 'JPY', 0, 0, '¥', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(39, 'Kenyan Shilling', 'KES', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(40, 'South Korean Won', 'KRW', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(41, 'Kuwaiti Dinar', 'KWD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(42, 'Cayman Islands Dollar', 'KYD', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(43, 'Kazakhstan Tenge', 'KZT', 0, 0, '??', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(44, 'Lebanese Pound', 'LBP', 0, 0, '£', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(45, 'Sri Lanka Rupee', 'LKR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(46, 'Lithuanian Litas', 'LTL', 0, 0, 'Lt', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(47, 'Latvian Lats', 'LVL', 0, 0, 'Ls', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(48, 'Moroccan Dirham', 'MAD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(49, 'Moldovan Leu', 'MDL', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(50, 'Macedonian Denar', 'MKD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(51, 'Mauritian Rupee', 'MUR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(52, 'Maldivian Rufiyaa', 'MVR', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(53, 'Mexican Peso', 'MXN', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(54, 'Malaysian Ringgit', 'MYR', 0, 0, 'RM', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(55, 'Namibian Dollar', 'NAD', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(56, 'Nigerian Naira', 'NGN', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(57, 'Nicaraguan Cordoba Oro', 'NIO', 0, 0, 'C$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(58, 'Norwegian Krone', 'NOK', 0, 0, 'kr', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(59, 'Nepalese Rupee', 'NPR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(60, 'New Zealand Dollar', 'NZD', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(61, 'Omani Rial', 'OMR', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(62, 'Peruvian Nuevo Sol', 'PEN', 0, 0, 'S/.', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(63, 'Papua New Guinean Kina', 'PGK', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(64, 'Philippine Peso', 'PHP', 0, 0, 'Php', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(65, 'Pakistani Rupee', 'PKR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(66, 'Polish Zloty', 'PLN', 0, 0, 'zl', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(67, 'Paraguayan Guarani', 'PYG', 0, 0, 'Gs', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(68, 'Qatari Rial', 'QAR', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(69, 'Romanian Leu', 'RON', 0, 0, 'lei', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(70, 'Serbian Dinar', 'RSD', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(71, 'Russian Ruble', 'RUB', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(72, 'Saudi Riyal', 'SAR', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(73, 'Seychellois Rupee', 'SCR', 0, 0, 'Rp', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(74, 'Swedish Krona', 'SEK', 0, 0, 'kr', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(75, 'Singapore Dollar', 'SGD', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(76, 'Slovak Koruna', 'SKK', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(77, 'Sierra Leonean Leone', 'SLL', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(78, 'Salvadoran Colón', 'SVC', 0, 0, '$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(79, 'Thai Baht', 'THB', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(80, 'Tunisian Dinar', 'TND', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(81, 'Turkish Lira', 'TRY', 0, 0, '£', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(82, 'Trinidad and Tobago Dollar', 'TTD', 0, 0, 'TT$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(83, 'New Taiwan Dollar', 'TWD', 0, 0, 'NT$', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(84, 'Tanzanian Shilling', 'TZS', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(85, 'Ukrainian Hryvnia', 'UAH', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(86, 'Ugandan Shilling', 'UGX', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(87, 'Uruguayan Peso', 'UYU', 0, 0, '$U', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(88, 'Uzbekistan Som', 'UZS', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(89, 'Venezuelan Bolr Fuerte', 'VEF', 0, 0, 'Bs', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(90, 'Vietnamese Dong', 'VND', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(91, 'CFA Franc BCEAO', 'XOF', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(92, 'Yemeni Rial', 'YER', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(93, 'South African Rand', 'ZAR', 0, 0, 'R', '', '2', 1.00000000, '2008-12-17 20:46:47'),
(94, 'Zambian Kwacha', 'ZMK', 0, 0, '', '', '2', 1.00000000, '2008-12-17 20:46:47');

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `firstname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `telephone` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `newsletter` int(1) NOT NULL DEFAULT '0',
  `address_id` int(11) NOT NULL DEFAULT '0',
  `cart` text COLLATE utf8_unicode_ci,
  `status` int(1) DEFAULT '0',
  `guest` int(1) NOT NULL DEFAULT '0',
  `ip` varchar(39) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`customer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- Table structure for table `dimension`
--

CREATE TABLE `dimension` (
  `dimension_id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`dimension_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=16 ;

--
-- Dumping data for table `dimension`
--

INSERT INTO `dimension` VALUES
(1, 'in', 1, 1, 'Inch'),
(2, 'ft', 1, 1, 'Foot'),
(3, 'm', 1, 1, 'Meter'),
(4, 'L', 3, 1, 'Litre'),
(5, 'US qt', 3, 1, 'Quart US'),
(6, 'in²', 2, 1, 'Inch Squared'),
(7, 'cm²', 2, 1, 'Centimetre Squared'),
(8, 'cm', 1, 1, 'Centimetre'),
(9, 'mm', 1, 1, 'Millimetre'),
(10, 'yd', 1, 1, 'Yard'),
(11, 'ft²', 2, 1, 'Foot Squared'),
(12, 'm²', 2, 1, 'Metre Squared'),
(13, 'mm²', 2, 1, 'Millimtre Squared'),
(14, 'Imp qt', 3, 1, 'Quart Imp'),
(15, 'ml', 3, 1, 'Milliliter');

-- --------------------------------------------------------

--
-- Table structure for table `dimension_rule`
--

CREATE TABLE `dimension_rule` (
  `dimension_rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `type_id` int(11) NOT NULL DEFAULT '0',
  `from_id` int(11) NOT NULL DEFAULT '0',
  `to_id` int(11) NOT NULL DEFAULT '0',
  `rule` decimal(17,6) NOT NULL DEFAULT '0.000000',
  PRIMARY KEY (`dimension_rule_id`,`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=63 ;

--
-- Dumping data for table `dimension_rule`
--

INSERT INTO `dimension_rule` VALUES
(1, 1, 1, 8, 2.540000),
(2, 1, 2, 8, 30.480000),
(3, 1, 3, 8, 100.000000),
(4, 1, 3, 2, 3.280800),
(5, 3, 5, 14, 0.832674),
(6, 3, 4, 5, 1.056688),
(7, 1, 2, 3, 0.304800),
(8, 1, 1, 3, 0.025400),
(9, 2, 7, 6, 0.155000),
(10, 2, 6, 7, 6.451600),
(11, 1, 8, 3, 0.010000),
(12, 1, 8, 2, 0.032808),
(13, 1, 8, 1, 0.393700),
(14, 1, 2, 1, 12.000000),
(15, 1, 1, 2, 0.083333),
(16, 1, 3, 1, 393701.000000),
(17, 1, 9, 8, 0.100000),
(18, 1, 9, 3, 0.001000),
(19, 1, 9, 2, 0.003281),
(20, 1, 9, 1, 0.039370),
(21, 1, 10, 9, 914.400000),
(22, 1, 10, 8, 91.440000),
(23, 1, 10, 3, 0.914400),
(24, 1, 10, 2, 3.000000),
(25, 1, 10, 1, 36.000000),
(26, 1, 1, 9, 25.400000),
(27, 1, 1, 10, 0.027778),
(28, 1, 2, 9, 308.800000),
(29, 1, 2, 10, 0.333333),
(30, 1, 3, 9, 1000.000000),
(31, 1, 3, 10, 1.093613),
(32, 1, 8, 9, 10.000000),
(33, 1, 8, 10, 0.010936),
(34, 1, 9, 10, 0.001094),
(35, 2, 11, 7, 929.030400),
(36, 2, 11, 6, 144.000000),
(37, 2, 12, 11, 10.763900),
(38, 2, 12, 7, 10000.000000),
(39, 2, 12, 6, 1550.003000),
(40, 2, 13, 6, 0.001550),
(41, 2, 13, 7, 0.010000),
(42, 2, 13, 11, 0.000011),
(43, 2, 13, 12, 0.000001),
(44, 2, 12, 13, 1000000.000000),
(45, 2, 7, 11, 0.001076),
(46, 2, 7, 12, 0.000100),
(47, 2, 7, 13, 100.000000),
(48, 2, 11, 12, 0.092903),
(49, 2, 11, 13, 92903.040000),
(50, 2, 6, 11, 0.006900),
(51, 2, 6, 12, 0.000645),
(52, 2, 6, 13, 645.160000),
(53, 3, 14, 5, 1.200950),
(54, 3, 14, 4, 1.136524),
(55, 3, 5, 4, 0.946353),
(56, 3, 15, 4, 0.001000),
(57, 3, 15, 5, 0.001057),
(58, 3, 15, 14, 0.000879),
(59, 3, 4, 14, 0.879876),
(60, 3, 4, 15, 1000.000000),
(61, 3, 14, 15, 1136.522970),
(62, 3, 5, 15, 946.352946);

-- --------------------------------------------------------

--
-- Table structure for table `dimension_type`
--

CREATE TABLE `dimension_type` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`),
  KEY `type_name` (`type_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `dimension_type`
--

INSERT INTO `dimension_type` VALUES
(1, 'linear'),
(2, 'area'),
(3, 'volume');

-- --------------------------------------------------------

--
-- Table structure for table `download`
--

CREATE TABLE `download` (
  `download_id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remaining` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `download_description`
--

CREATE TABLE `download_description` (
  `download_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`download_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `extension`
--

CREATE TABLE `extension` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `directory` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `controller` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=76 ;

--
-- Dumping data for table `extension`
--

INSERT INTO `extension` VALUES
(19, 'total', 'calculate', 'calculate', 'total.php', 'calculate_total'),
(18, 'paypal', 'payment', 'payment', 'paypal.php', 'payment_paypal'),
(1, 'flat', 'shipping', 'shipping', 'flat.php', 'shipping_flat'),
(20, 'subtotal', 'calculate', 'calculate', 'subtotal.php', 'calculate_subtotal'),
(21, 'tax', 'calculate', 'calculate', 'tax.php', 'calculate_tax'),
(22, 'shipping', 'calculate', 'calculate', 'shipping.php', 'calculate_shipping'),
(23, 'header', 'module', 'module', 'header.php', 'module_catalog_header'),
(24, 'footer', 'module', 'module', 'footer.php', 'module_catalog_footer'),
(25, 'category', 'module', 'module', 'category.php', 'module_catalog_category'),
(26, 'information', 'module', 'module', 'information.php', 'module_catalog_information'),
(27, 'review', 'module', 'module', 'review.php', 'module_extra_review'),
(28, 'cart', 'module', 'module', 'cart.php', 'module_catalog_cart'),
(29, 'header', 'module', 'module', 'header.php', 'module_admin_header'),
(30, 'footer', 'module', 'module', 'footer.php', 'module_admin_footer'),
(31, 'menu', 'module', 'module', 'menu.php', 'module_admin_menu'),
(32, 'cod', 'payment', 'payment', 'cod.php', 'payment_cod'),
(33, 'language', 'module', 'module', 'language.php', 'module_catalog_language'),
(34, 'search', 'module', 'module', 'search.php', 'module_catalog_search'),
(35, 'currency', 'module', 'module', 'currency.php', 'module_catalog_currency'),
(36, 'item', 'shipping', 'shipping', 'item.php', 'shipping_item'),
(38, 'coupon', 'calculate', 'calculate', 'coupon.php', 'calculate_coupon'),
(39, 'zone', 'shipping', 'shipping', 'zone.php', 'shipping_zone'),
(40, 'language', 'module', 'module', 'language.php', 'module_admin_language'),
(41, 'latest', 'module', 'module', 'latest.php', 'module_extra_latest'),
(42, 'featured', 'module', 'module', 'featured.php', 'module_extra_featured'),
(43, 'specials', 'module', 'module', 'specials.php', 'module_extra_specials'),
(44, 'related', 'module', 'module', 'related.php', 'module_extra_related'),
(45, 'popular', 'module', 'module', 'popular.php', 'module_extra_popular'),
(46, 'manufacturer', 'module', 'module', 'manufacturer.php', 'module_extra_manufacturer'),
(47, 'manufactureroptions', 'module', 'module', 'manufactureroptions.php', 'module_extra_manufactureroptions'),
(48, 'categoryoptions', 'module', 'module', 'categoryoptions.php', 'module_extra_categoryoptions'),
(49, 'searchoptions', 'module', 'module', 'searchoptions.php', 'module_extra_searchoptions'),
(50, 'navigation', 'module', 'module', 'navigation.php', 'module_catalog_navigation'),
(51, 'homepage', 'module', 'module', 'homepage.php', 'module_extra_homepage'),
(52, 'authnetaim', 'payment', 'payment', 'authnetaim.php', 'payment_authnetaim'),
(53, 'google', 'payment', 'payment', 'google.php', 'payment_google'),
(54, 'developer', 'module', 'module', 'developer.php', 'module_extra_developer'),
(55, 'cheque', 'payment', 'payment', 'cheque.php', 'payment_cheque'),
(56, 'bestseller', 'module', 'module', 'bestseller.php', 'module_extra_bestseller'),
(57, 'moneyorder', 'payment', 'payment', 'moneyorder.php', 'payment_moneyorder'),
(58, 'paymate', 'payment', 'payment', 'paymate.php', 'payment_paymate'),
(59, 'discount', 'calculate', 'calculate', 'discount.php', 'calculate_discount'),
(60, 'imagedisplay', 'module', 'module', 'imagedisplay.php', 'module_extra_imagedisplay'),
(61, 'converter', 'module', 'module', 'converter.php', 'module_catalog_converter'),
(62, 'warehouse', 'shipping', 'shipping', 'warehouse.php', 'shipping_warehouse'),
(63, 'ccavenue', 'payment', 'payment', 'ccavenue.php', 'payment_ccavenue'),
(64, 'australiapost', 'shipping', 'shipping', 'australiapost.php', 'shipping_australiapost'),
(65, 'zoneplus', 'shipping', 'shipping', 'zoneplus.php', 'shipping_zoneplus'),
(66, 'canadapost', 'shipping', 'shipping', 'canadapost.php', 'shipping_canadapost'),
(67, 'banktr', 'payment', 'payment', 'banktr.php', 'payment_banktr'),
(68, 'recently', 'module', 'module', 'recently.php', 'module_extra_recently'),
(69, 'toprated', 'module', 'module', 'toprated.php', 'module_extra_toprated'),
(70, 'alsobought', 'module', 'module', 'alsobought.php', 'module_extra_alsobought'),
(71, 'categorymenu', 'module', 'module', 'categorymenu.php', 'module_catalog_categorymenu'),
(72, 'manufacturerlist', 'module', 'module', 'manufacturerlist.php', 'module_extra_manufacturerlist'),
(73, 'categorylist', 'module', 'module', 'categorylist.php', 'module_extra_categorylist'),
(74, 'manufacturerslider', 'module', 'module', 'manufacturerslider.php', 'module_extra_manufacturerslider'),
(75, 'categoryslider', 'module', 'module', 'categoryslider.php', 'module_extra_categoryslider');

-- --------------------------------------------------------

--
-- Table structure for table `extension_description`
--

CREATE TABLE `extension_description` (
  `extension_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`extension_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `extension_description`
--

INSERT INTO `extension_description` VALUES
(1, 1, 'Flat Rate', 'Flat Rate Shipping'),
(18, 1, 'PayPal', 'PayPal Payment Gateway'),
(19, 1, 'Calculate Total', 'Calculate Total'),
(20, 1, 'Calculate Subtotal', 'Calculate Subtotal'),
(22, 1, 'Calculate Shipping', 'Calculate Shipping'),
(23, 1, 'Catalog Header', 'Catalog Header'),
(24, 1, 'Catalog Footer', 'Catalog Footer'),
(25, 1, 'Catalog Category', 'Catalog Category'),
(26, 1, 'Catalog Information', 'Catalog Information'),
(27, 1, 'Catalog Review', 'Catalog Review'),
(28, 1, 'Catalog Cart', 'Catalog Cart'),
(29, 1, 'Admin Header', 'Admin Header'),
(32, 1, 'Cash On Delivery', 'Cash On Delivery'),
(30, 1, 'Admin Footer', 'Admin Footer'),
(31, 1, 'Admin Menu', 'Admin Menu'),
(21, 1, 'Calculate Tax', 'Calculate Tax'),
(33, 1, 'Catalog Language', 'Catalog Language'),
(34, 1, 'Catalog Search', 'Catalog Search'),
(35, 1, 'Catalog Currency', 'Catalog Currency'),
(36, 1, 'Per Item Rate', 'Per Item Rate'),
(38, 1, 'Calculate Coupon', 'Calculate Coupon'),
(39, 1, 'Zone', 'Zone'),
(40, 1, 'Admin Language', 'Admin Language'),
(41, 1, 'Catalog Latest', 'Display Latest Products'),
(42, 1, 'Catalog Featured', 'Display Featured Products'),
(43, 1, 'Catalog Specials', 'Display Special Offer Products'),
(44, 1, 'Catalog Related', 'Display Related Products'),
(45, 1, 'Catalog Popular', 'Display Popular Products'),
(46, 1, 'Catalog Manufacturer', 'Filter by Manufacturer'),
(47, 1, 'Catalog Manufacturer Options', 'Manufacturer Options'),
(48, 1, 'Catalog Category Options', 'Category Options'),
(49, 1, 'Catalog Search Options', 'Search Options'),
(50, 1, 'Catalog Navigation', 'Catalog Navigation Bar'),
(51, 1, 'Home Page', 'Home Page Module'),
(52, 1, 'Authorize.Net (AIM)', 'Authorize.Net (AIM)'),
(53, 1, 'Google Checkout', 'Google Checkout Payment Gateway'),
(54, 1, 'Developer', 'Developer Information'),
(55, 1, 'Cheque Payment', 'Offline Payment by Cheque'),
(56, 1, 'Catalog bestseller', 'Display Best Seller Products'),
(57, 1, 'Money Order Payment', 'Offline Payment by Money Order'),
(58, 1, 'Paymate', 'Paymate Gateway'),
(59, 1, 'Calculate Discount', 'Calculate Discount'),
(60, 1, 'Image Display', 'Image Display Module'),
(61, 1, 'Currency Converter', 'Currency Converter Module'),
(62, 1, 'Warehouse Pickup', 'Warehouse Pickup'),
(63, 1, 'ccAvenue', 'ccAvenue Gateway'),
(64, 1, 'Australia Post', 'Australia Post'),
(65, 1, 'Zone Plus', 'Zone Plus Shipping'),
(66, 1, 'Canada Post', 'Canada Post Shipping'),
(67, 1, 'Bank Transfer', 'Offline Bank Transfer'),
(68, 1, 'Catalog Recently Viewed', 'Display Recently Viewed Products'),
(69, 1, 'Catalog Top Rated', 'Display Top Rated Products'),
(70, 1, 'Catalog Also Bought', 'Display Also Bought Products'),
(71, 1, 'Catalog Category Menu', 'Category Menu Module'),
(72, 1, 'Catalog Manufacturer List', 'Display List of Manufacturers'),
(73, 1, 'Catalog Category List', 'Display List of Categories'),
(74, 1, 'Catalog Manufacturer Slider', 'Manufacturer Image Slider'),
(75, 1, 'Catalog Category Slider', 'Category Image Slider');

-- --------------------------------------------------------

--
-- Table structure for table `geo_zone`
--

CREATE TABLE `geo_zone` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `geo_zone`
--

INSERT INTO `geo_zone` VALUES
(1, 'UK Tax Zone', 'UK VAT Zone', '2007-08-12 22:29:07', '0000-00-00 00:00:00'),
(2, 'Shipping Zone 1', 'Shipping Zone 1', '0000-00-00 00:00:00', '2007-08-28 23:24:40'),
(3, 'Canada ', 'Canada Shipping', '0000-00-00 00:00:00', '2009-02-01 10:47:24'),
(4, 'United States', 'Continental shipping', '0000-00-00 00:00:00', '2009-02-01 15:50:25'),
(5, 'Alberta Shipping Zone', 'Alberta Shipping Zone', '0000-00-00 00:00:00', '2009-06-06 06:16:10');

-- --------------------------------------------------------

--
-- Table structure for table `home_description`
--

CREATE TABLE `home_description` (
  `home_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `title` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `welcome` varchar(510) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_description` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_keywords` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flash` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flash_height` int(11) DEFAULT NULL,
  `flash_loop` int(11) DEFAULT NULL,
  `flash_width` int(11) DEFAULT NULL,
  `image_id` int(11) DEFAULT NULL,
  `run_times` int(11) DEFAULT '1',
  PRIMARY KEY (`home_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `home_description`
--

INSERT INTO `home_description` VALUES
(1, 1, 'Home Page Welcome', '<p>This is unlimited test for HomePage Module. Title, short and long text files, flash file and image are all language dependent. You can have more than one home page entry, with only one being enabled at a time.</p>\r\n<p>When enabling a new entry, all existing entries are automatically disabled.</p>', '<p>This is a short text for the home page module.</p>', NULL, NULL, NULL, '', NULL, NULL, NULL, 47, 1);

-- --------------------------------------------------------

--
-- Table structure for table `home_page`
--

CREATE TABLE `home_page` (
  `home_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`home_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `home_page`
--

INSERT INTO `home_page` VALUES
(1, 'Home Page Module', 1);

-- --------------------------------------------------------

--
-- Table structure for table `home_slides`
--

CREATE TABLE `home_slides` (
  `home_slide_id` int(11) NOT NULL AUTO_INCREMENT,
  `home_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `image_id` int(11) DEFAULT NULL,
  `sort_order` int(3) DEFAULT '0',
  PRIMARY KEY (`home_slide_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `image`
--

CREATE TABLE `image` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=48 ;

--
-- Dumping data for table `image`
--

INSERT INTO `image` VALUES
(1, 'image_1.jpg', '2007-07-25 00:58:38'),
(2, 'image_2.jpg', '2007-07-25 00:58:38'),
(3, 'image_3.jpg', '2007-07-25 00:58:38'),
(4, 'image_4.jpg', '2007-07-25 00:58:38'),
(5, 'SPECIALS.jpg', '2008-12-17 20:08:25'),
(6, 'FEATURED.jpg', '2008-12-17 20:08:44'),
(7, 'LATEST.jpg', '2008-12-17 20:09:13'),
(8, 'RELATED.jpg', '2008-12-30 21:17:18'),
(9, 'EnhancedSearch.jpg', '2009-04-26 14:08:00'),
(10, 'Featured1.jpg', '2009-04-26 14:35:32'),
(11, 'Featured2.jpg', '2009-04-26 14:41:41'),
(12, 'Featured3.jpg', '2009-04-26 14:41:41'),
(13, 'Featured4.jpg', '2009-04-26 14:41:41'),
(14, 'Featured5.jpg', '2009-04-26 14:41:41'),
(15, 'Featured6.jpg', '2009-04-26 14:41:41'),
(16, 'Featured7.jpg', '2009-04-26 14:41:41'),
(17, 'Featured8.jpg', '2009-04-26 14:41:41'),
(18, 'Featured9.jpg', '2009-04-26 14:41:41'),
(19, 'HOP_40955.jpg', '2009-04-26 14:41:41'),
(20, 'HoppyLogo.png', '2009-04-26 14:41:41'),
(21, 'Latest1.jpg', '2009-04-26 14:41:41'),
(22, 'Latest2.jpg', '2009-04-26 14:41:41'),
(23, 'Latest3.jpg', '2009-04-26 14:41:41'),
(24, 'PEF_0369-10.jpg', '2009-04-26 14:41:41'),
(25, 'PerformanceFriction.jpg', '2009-04-26 14:41:41'),
(26, 'Related1.jpg', '2009-04-26 14:41:41'),
(27, 'Related10.jpg', '2009-04-26 14:41:41'),
(28, 'Related11.jpg', '2009-04-26 14:41:41'),
(29, 'Related2.jpg', '2009-04-26 14:41:41'),
(30, 'Related3.jpg', '2009-04-26 14:41:41'),
(31, 'Related4.jpg', '2009-04-26 14:41:41'),
(32, 'Related5.jpg', '2009-04-26 14:41:41'),
(33, 'Related6.jpg', '2009-04-26 14:41:41'),
(34, 'Related7.jpg', '2009-04-26 14:41:41'),
(35, 'Related8.jpg', '2009-04-26 14:41:41'),
(36, 'Related9.jpg', '2009-04-26 14:41:41'),
(37, 'Specials1.jpg', '2009-04-26 14:41:41'),
(38, 'Specials2.jpg', '2009-04-26 14:41:41'),
(39, 'Specials3.jpg', '2009-04-26 14:41:41'),
(40, 'Specials4.jpg', '2009-04-26 14:41:41'),
(41, 'Specials5.jpg', '2009-04-26 14:41:41'),
(42, 'Specials6.jpg', '2009-04-26 14:41:41'),
(43, 'BRE_PE4013HWPCAT.jpg', '2009-12-08 06:33:02'),
(44, 'Shopping.gif', '2009-12-14 04:19:59'),
(46, 'no_image.png', '2009-12-16 06:10:48'),
(47, 'HomepageDemo.gif', '2009-12-18 07:04:46');

-- --------------------------------------------------------

--
-- Table structure for table `image_description`
--

CREATE TABLE `image_description` (
  `image_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`image_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `image_description`
--

INSERT INTO `image_description` VALUES
(1, 1, 'Image 1'),
(2, 1, 'Image 2'),
(3, 1, 'Image 3'),
(4, 1, 'Image 4'),
(5, 1, 'Specials'),
(6, 1, 'Featured'),
(7, 1, 'Latest'),
(8, 1, 'Related Products'),
(10, 1, 'Featured1'),
(11, 1, 'Featured2'),
(12, 1, 'Featured3'),
(13, 1, 'Featured4'),
(14, 1, 'Featured5'),
(15, 1, 'Featured6'),
(16, 1, 'Featured7'),
(17, 1, 'Featured8'),
(18, 1, 'Featured9'),
(19, 1, 'HOP 40955'),
(20, 1, 'HoppyLogo'),
(21, 1, 'Latest1'),
(22, 1, 'Latest2'),
(23, 1, 'Latest3'),
(24, 1, 'PEF 0369 10'),
(25, 1, 'PerformanceFriction'),
(26, 1, 'Related1'),
(27, 1, 'Related10'),
(28, 1, 'Related11'),
(29, 1, 'Related2'),
(30, 1, 'Related3'),
(31, 1, 'Related4'),
(32, 1, 'Related5'),
(33, 1, 'Related6'),
(34, 1, 'Related7'),
(35, 1, 'Related8'),
(36, 1, 'Related9'),
(37, 1, 'Specials1'),
(38, 1, 'Specials2'),
(39, 1, 'Specials3'),
(40, 1, 'Specials4'),
(41, 1, 'Specials5'),
(42, 1, 'Specials6'),
(43, 1, 'BRE PE4013HWPCAT'),
(44, 1, 'Shopping'),
(46, 1, 'No Image'),
(47, 1, 'HomepageDemo');

-- --------------------------------------------------------

--
-- Table structure for table `image_display`
--

CREATE TABLE `image_display` (
  `image_display_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_display_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `image_display_description`
--

CREATE TABLE `image_display_description` (
  `image_display_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `flash` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flash_width` int(11) NOT NULL DEFAULT '0',
  `flash_height` int(11) NOT NULL DEFAULT '0',
  `flash_loop` int(11) NOT NULL DEFAULT '0',
  `image_id` int(11) DEFAULT NULL,
  `image_width` int(11) NOT NULL DEFAULT '0',
  `image_height` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_display_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `image_display_slides`
--

CREATE TABLE `image_display_slides` (
  `image_display_slide_id` int(11) NOT NULL AUTO_INCREMENT,
  `image_display_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `image_id` int(11) DEFAULT NULL,
  `sort_order` int(3) DEFAULT '0',
  PRIMARY KEY (`image_display_slide_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `information`
--

CREATE TABLE `information` (
  `information_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `information_hide` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`information_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `information`
--

INSERT INTO `information` VALUES
(1, 1, 0),
(2, 2, 0),
(3, 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `information_description`
--

CREATE TABLE `information_description` (
  `information_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`information_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `information_description`
--

INSERT INTO `information_description` VALUES
(1, 1, 'About Us', '<p>About Us</p>'),
(3, 1, 'Terms & Conditions', '<p>Terms &amp; Conditions</p>'),
(2, 1, 'Privacy Policy', '<p><strong><span class="c2"><span class="c1">** Your Store ** Website Privacy Statement</span></span></strong></p>\r\n<p class="c3">This document was last updated on January 18, 2009, 11:23 am.</p>\r\n<p><strong><span class="c1">1. Acknowledgement and acceptance of terms</span></strong></p>\r\n<p class="c3">** Your Store ** is committed to protecting your privacy. This Privacy Statement sets forth our current privacy practices with regard to the information we collect when you or your computer interact with our website. By accessing <a href="../../../../../">**Your Store ** / www.yourstore.com</a>, you acknowledge and fully understand ** Your Store''s ** Privacy Statement and freely consent to the information collection and use practices described in this Website Privacy Statement.</p>\r\n<p><strong><span class="c1">2. Participating Merchant Policies</span></strong></p>\r\n<p class="c3">Related services and offerings with links from this website, including vendor sites, have their own privacy statements that can be viewed by clicking on the corresponding links within each respective website. Online merchants and others who participate in ** Your Store''s ** services are encouraged to participate in industry privacy initiatives and to take a responsible attitude towards consumer privacy. However, since we do not have direct control over the policies or practices of participating merchants and other third parties, we are not responsible for the privacy practices or contents of those sites. We recommend and encourage that you always review the privacy policies of merchants and other third parties before you provide any personal information or complete any transaction with such parties.</p>\r\n<p><strong><span class="c1">3. Information We Collect and How We Use It</span></strong></p>\r\n<p class="c3">** Your Store ** collects certain information from and about its users three ways: directly from our Web Server logs, the user, and with Cookies.</p>\r\n<blockquote> <blockquote>\r\n<p><strong><span class="c1">Web Server Logs</span></strong><span class="c1">.</span></p>\r\n</blockquote>\r\n<p class="c3">When you visit our Website, we may track information to administer the site and analyze its usage. Examples of information we may track include:</p>\r\n<blockquote>\r\n<p class="c3"><span class="c4">?</span> Your Internet protocol address.</p>\r\n<p class="c3"><span class="c4">?</span> The kind of browser or computer you use.</p>\r\n<p class="c3"><span class="c4">?</span> Number of links you click within the site.</p>\r\n<p class="c3"><span class="c4">?</span> State or country from which you accessed the site.</p>\r\n<p class="c3"><span class="c4">?</span> Date and time of your visit.</p>\r\n<p class="c3"><span class="c4">?</span> Name of your Internet service provider.</p>\r\n<p class="c3"><span class="c4">?</span> Web page you linked to our site from.</p>\r\n<p class="c3"><span class="c4">?</span> Pages you viewed on the site.</p>\r\n</blockquote> </blockquote>\r\n<p><strong><span class="c1">b. Use of Cookies</span></strong></p>\r\n<p class="c3">** Your Store ** may use cookies to personalize or enhance your user experience. A cookie is a small text file that is placed on your hard disk by a Web page server. Cookies cannot be used to run programs or deliver viruses to your computer. Cookies are uniquely assigned to you, and can only be read by a Web Server in the domain that issued the cookie to you.</p>\r\n<p class="c3">One of the primary purposes of cookies is to provide a convenience feature to save you time. For example, if you personalize a web page, or navigate within a site, a cookie helps the site to recall your specific information on subsequent visits. Hence, this simplifies the process of delivering relevant content and eases site navigation by providing and saving your preferences and login information as well as providing personalized functionality..</p>\r\n<p class="c3">** Your Store ** reserves the right to share aggregated site statistics with partner companies, but does not allow other companies to place cookies on our website unless there is a temporary, overriding customer value (such as merging into ** yourstore.com ** a site that relies on third-party cookies).</p>\r\n<p class="c3">You have the ability to accept or decline cookies. Most Web browsers automatically accept cookies, but you can usually modify your browser setting to decline cookies. If you reject cookies by changing your browser settings then be aware that this may disable some of the functionality on our Website.</p>\r\n<blockquote> <blockquote>\r\n<p class="c3">Personal Information Users</p>\r\n</blockquote> </blockquote>\r\n<p class="c3">Visitors to our website can register to purchase services. When you register, we will request some personal information such as name, address, email, telephone number or facsimile number, account number and other relevant information. If you are purchasing a service, we will request financial information. Any financial information we collect is used only to bill you for the services you purchased. If you purchase by credit card, this information may be forwarded to your credit card provider. For other types of registrations, we will ask for the relevant information. You may also be asked to disclose personal information to us so that we can provide assistance and information to you. For example, such data may be warranted in order to provide online technical support and troubleshooting.</p>\r\n<p class="c3">We will not disclose personally identifiable information we collect from you to third parties without your permission except to the extent necessary including:</p>\r\n<blockquote> <blockquote>\r\n<p class="c3">To fulfill your service requests for services.</p>\r\n<p class="c3">To protect ourselves from liability,</p>\r\n<p class="c3">To respond to legal process or comply with law, or</p>\r\n<p class="c3">In connection with a merger, acquisition, or liquidation of the company.</p>\r\n</blockquote> </blockquote>\r\n<p><strong><span class="c1">4. Use of Web Beacons or GIF files</span></strong></p>\r\n<p class="c3"><a href="../../../../../">** Your Store ** / www.yourstore.com</a> Web pages may contain electronic images known as Web beacons - sometimes also called single-pixel gifs - that allow ** Your Store ** to count users who have visited those pages and to deliver co-branded services. ** Your Store ** may include Web beacons in promotional e-mail messages or newsletters in order to determine whether messages have been opened and acted upon.</p>\r\n<p class="c3">Some of these Web beacons may be placed by third party service providers to help determine the effectiveness of our advertising campaigns or email communications. These Web beacons may be used by these service providers to place a persistent cookie on your computer. This allows the service provider to recognize your computer each time you visit certain pages or emails and compile anonymous information in relation to those page views, which in turn enables us and our service providers to learn which advertisements and emails bring you to our website and how you use the site. ** Your Store ** prohibits Web beacons from being used to collect or access your personal information.</p>\r\n<p><strong><span class="c1">5. Accessing Web Account Information</span></strong></p>\r\n<p class="c3">We will provide you with the means to ensure that personally identifiable information in your web account file is correct and current. You may review this information by contacting us by sending an email to our support attendant --sales@yourstore.com.</p>\r\n<p><strong><span class="c1">6. Changes to this Statement</span></strong></p>\r\n<p class="c3">** Your Store ** has the discretion to occasionally update this privacy statement. When we do, we will also revise the &quot;updated&quot; date at the top of this Privacy page. We encourage you to periodically review this privacy statement to stay informed about how we are helping to protect the personal information we collect. Your continued use of the service constitutes your agreement to this privacy statement and any updates.</p>\r\n<p><strong><span class="c1">7. Contacting Us</span></strong></p>\r\n<p class="c3">If you have questions regarding our Privacy Statement, its implementation, failure to adhere to this Privacy Statement and/or our general practices, please contact us. <a href="mailto:sales@yourstore.com">sales@yourstore.com</a> or send your comments to :</p>\r\n<p class="c3">** Your Store **</p>\r\n<p><strong><span class="c1">Attention: Privacy Statement Personal</span></strong></p>\r\n<pre class="c5">\r\nYour Address\r\nCity, Province, Country\r\nPost Code \r\n</pre>\r\n<p class="c3">** Your Store ** will use commercially reasonable efforts to promptly respond and resolve any problem or question.</p>');

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `language_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_status` int(1) NOT NULL DEFAULT '1',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `directory` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
(1, 1, 'English', 'en', 'en.png', 'english', 'english.php', 1);

-- --------------------------------------------------------

--
-- Table structure for table `manufacturer`
--

CREATE TABLE `manufacturer` (
  `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `manufacturer`
--

INSERT INTO `manufacturer` VALUES
(1, 'The Bike Builder Guys', 1, 0),
(2, 'Sedona', 39, 0),
(3, 'Cancun', 12, 0),
(4, 'Mayan Ruins at the Yucatan Peninsula', 16, 0),
(5, 'Flowers', 22, 0);

-- --------------------------------------------------------

--
-- Table structure for table `newsletter`
--

CREATE TABLE `newsletter` (
  `newsletter_id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `date_sent` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`newsletter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `option`
--

CREATE TABLE `option` (
  `option_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`option_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `option`
--

INSERT INTO `option` VALUES
(1, 1, 'Size'),
(2, 1, 'Colour'),
(3, 1, 'Speed'),
(4, 1, 'Memory');

-- --------------------------------------------------------

--
-- Table structure for table `option_value`
--

CREATE TABLE `option_value` (
  `option_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '0',
  `option_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`option_value_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `option_value`
--

INSERT INTO `option_value` VALUES
(2, 1, 2, 'Red'),
(3, 1, 2, 'Blue'),
(4, 1, 2, 'Green'),
(5, 1, 2, 'Yellow'),
(6, 1, 4, '1GB'),
(7, 1, 4, '2GB'),
(8, 1, 4, '4GB'),
(9, 1, 4, '8GB'),
(10, 1, 1, 'Small'),
(11, 1, 1, 'Medium'),
(12, 1, 1, 'Large'),
(13, 1, 3, 'Slow'),
(14, 1, 3, 'Fast');

-- --------------------------------------------------------

--
-- Table structure for table `order`
--

CREATE TABLE `order` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `modified` int(1) NOT NULL DEFAULT '0',
  `new_reference` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `invoice_number` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `firstname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_firstname` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_lastname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_company` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shipping_address_1` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_address_2` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shipping_city` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_postcode` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_zone` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shipping_country` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping_address_format` text COLLATE utf8_unicode_ci NOT NULL,
  `shipping_method` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_firstname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_lastname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_company` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_address_1` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_address_2` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_city` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_postcode` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_zone` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_country` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_address_format` text COLLATE utf8_unicode_ci NOT NULL,
  `payment_method` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `date_modified` datetime DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `currency` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` decimal(14,6) DEFAULT NULL,
  `ip` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `coupon_sort_order` int(3) NOT NULL DEFAULT '0',
  `discount_sort_order` int(3) NOT NULL DEFAULT '0',
  `shipping_tax_rate` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `freeshipping_net` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `shipping_net` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `taxed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

-- --------------------------------------------------------

--
-- Table structure for table `order_data`
--

CREATE TABLE `order_data` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `expire` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=17 ;

-- --------------------------------------------------------

--
-- Table structure for table `order_download`
--

CREATE TABLE `order_download` (
  `order_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `order_product_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remaining` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `order_google`
--

CREATE TABLE `order_google` (
  `order_reference` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_number` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `total` decimal(14,6) NOT NULL,
  PRIMARY KEY (`order_reference`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_history`
--

CREATE TABLE `order_history` (
  `order_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `notify` int(1) DEFAULT '0',
  `comment` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`order_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `order_option`
--

CREATE TABLE `order_option` (
  `order_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `order_product_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `prefix` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`order_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `order_product`
--

CREATE TABLE `order_product` (
  `order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `model_number` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vendor_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `vendor_id` int(11) NOT NULL DEFAULT '0',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `discount` decimal(15,4) NOT NULL,
  `special_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `coupon` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `general_discount` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `quantity` int(4) NOT NULL DEFAULT '0',
  `barcode` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `order_status`
--

CREATE TABLE `order_status` (
  `order_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`order_status_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=18 ;

--
-- Dumping data for table `order_status`
--

INSERT INTO `order_status` VALUES
(1, 1, 'Pending'),
(2, 1, 'Processing'),
(3, 1, 'Shipped'),
(12, 1, 'Canceled'),
(16, 1, 'Complete'),
(17, 1, 'Paid Unconfirmed');

-- --------------------------------------------------------

--
-- Table structure for table `order_total`
--

CREATE TABLE `order_total` (
  `order_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `text` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_total_id`),
  KEY `idx_orders_total_orders_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `product`
--

CREATE TABLE `product` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `quantity` int(4) NOT NULL DEFAULT '0',
  `barcode` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `min_qty` int(4) NOT NULL DEFAULT '1',
  `max_qty` int(4) NOT NULL DEFAULT '0',
  `multiple` int(4) NOT NULL DEFAULT '0',
  `manufacturer_id` int(11) NOT NULL DEFAULT '0',
  `vendor_id` int(11) NOT NULL DEFAULT '0',
  `image_id` int(11) NOT NULL DEFAULT '0',
  `shipping` int(1) NOT NULL DEFAULT '1',
  `shipping_time_from` int(2) NOT NULL DEFAULT '2',
  `shipping_time_to` int(2) NOT NULL DEFAULT '4',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `date_modified` datetime DEFAULT NULL,
  `date_available` datetime DEFAULT NULL,
  `weight` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `weight_class_id` int(11) NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension_value` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0:0:0',
  `status` int(1) NOT NULL DEFAULT '0',
  `featured` int(1) NOT NULL DEFAULT '0',
  `special_offer` int(1) NOT NULL DEFAULT '0',
  `related` int(1) NOT NULL DEFAULT '0',
  `sale_end_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `sale_start_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `remaining` int(1) NOT NULL DEFAULT '1',
  `special_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax_class_id` int(11) NOT NULL DEFAULT '0',
  `viewed` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `date_added` (`date_added`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=25 ;

--
-- Dumping data for table `product`
--

INSERT INTO `product` VALUES
(1, 10, '', 1, 0, 0, 1, 0, 1, 1, 2, 4, 1595.0000, 1, '2006-06-08 22:13:10', '2009-10-11 16:40:31', '2007-05-21 00:00:00', 1.0000, 2, 0, '0:0:0', 1, 1, 0, 0, '2009-12-31 00:00:00', '2009-04-01 00:00:00', 1, 1435.5000, 6, 860),
(2, 10, '', 1, 0, 0, 1, 0, 2, 1, 2, 4, 10.9500, 2, '2006-06-08 22:16:53', '2009-09-26 15:50:07', '2007-02-08 00:00:00', 1.5000, 2, 0, '0:0:0', 1, 1, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 94),
(3, 10, '', 1, 0, 0, 1, 0, 3, 1, 2, 4, 10.0000, 3, '2006-06-14 00:38:14', '2009-07-26 09:06:28', '2006-06-14 00:00:00', 2.0000, 2, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 29),
(4, 10, '', 1, 0, 0, 1, 0, 4, 1, 2, 4, 10.0000, 4, '2006-06-14 00:39:22', '2009-09-13 16:51:20', '2006-06-14 00:00:00', 2.5000, 2, 0, '0:0:0', 1, 0, 0, 0, '2009-03-31 00:00:00', '2009-02-01 00:00:00', 1, 5.0000, 6, 32),
(5, 1, '', 1, 0, 0, 2, 0, 37, 0, 2, 4, 19.9500, 0, '2008-12-17 20:07:42', '2009-07-26 09:08:39', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 0, 1, 0, '2009-06-30 00:00:00', '2009-03-01 00:00:00', 1, 15.9500, 6, 30),
(6, 1, '', 1, 0, 0, 2, 0, 38, 0, 2, 4, 10.0000, 0, '2008-12-17 20:11:07', '2009-07-26 09:08:56', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 0, 1, 0, '2009-03-31 00:00:00', '2009-02-28 00:00:00', 1, 0.0000, 6, 16),
(7, 1, '', 1, 0, 0, 2, 0, 39, 0, 2, 4, 1.0000, 0, '2008-12-17 20:13:58', '2009-07-26 09:09:09', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 0, 1, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 16),
(8, 1, '', 1, 0, 0, 2, 0, 41, 0, 2, 4, 40.0000, 0, '2008-12-17 20:15:05', '2009-07-26 09:09:23', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 0, 1, 0, '2009-01-31 00:00:00', '2009-04-01 00:00:00', 1, 36.0000, 6, 33),
(9, 1, '', 1, 0, 0, 2, 0, 41, 0, 2, 4, 1.0000, 0, '2008-12-17 20:35:07', '2009-07-26 09:09:55', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 0, 1, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 29),
(10, 1, '', 1, 0, 0, 3, 0, 10, 1, 2, 4, 15.9900, 0, '2008-12-17 20:44:28', '2009-10-31 17:44:43', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 1, 0, 1, '2009-06-30 00:00:00', '2009-03-01 00:00:00', 1, 13.9900, 6, 298),
(11, 1, '', 1, 0, 0, 3, 0, 11, 0, 2, 4, 1.0000, 0, '2008-12-17 20:49:39', '2009-10-04 10:02:56', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 1, 0, 1, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 153),
(12, 1, '', 1, 0, 0, 3, 0, 12, 0, 2, 4, 29.9900, 0, '2008-12-17 20:51:21', '2009-10-04 10:09:46', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 1, 0, 0, '2009-06-30 00:00:00', '2009-03-01 00:00:00', 1, 24.9500, 6, 97),
(13, 1, '', 1, 0, 0, 3, 0, 13, 0, 2, 4, 1.0000, 0, '2008-12-17 20:53:08', '2009-09-07 14:38:24', '2008-12-17 00:00:00', 1.0000, 4, 0, '0:0:0', 1, 1, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 55),
(14, 1, '', 1, 0, 0, 3, 0, 26, 1, 2, 4, 1.0000, 0, '2008-12-27 10:52:01', '2009-07-26 09:07:08', '2008-12-27 00:00:00', 10.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 21),
(15, 1, '', 1, 0, 0, 3, 0, 29, 1, 2, 4, 15.0000, 0, '2008-12-27 10:53:40', '2009-07-26 09:07:27', '2008-12-27 00:00:00', 5.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '2009-06-30 00:00:00', '2009-03-01 00:00:00', 1, 12.9900, 6, 218),
(16, 1, '', 1, 0, 0, 3, 0, 30, 1, 2, 4, 10.0000, 0, '2008-12-27 10:54:48', '2009-07-26 09:07:41', '2008-12-27 00:00:00', 15.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 5),
(17, 1, '', 1, 0, 0, 3, 0, 31, 1, 2, 4, 10.0000, 0, '2008-12-31 18:32:45', '2009-07-26 09:08:03', '2008-12-31 00:00:00', 3.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '2009-12-31 00:00:00', '2009-03-01 00:00:00', 1, 8.9900, 6, 4),
(18, 2, '', 1, 0, 0, 3, 0, 32, 1, 2, 4, 12.0000, 0, '2008-12-31 18:34:06', '2009-07-26 09:08:18', '2008-12-31 00:00:00', 13.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 3),
(19, 1, '', 5, 0, 0, 5, 0, 21, 1, 2, 4, 2.0000, 0, '2008-12-31 18:35:41', '2009-12-08 07:24:54', '2008-12-31 00:00:00', 2.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 19),
(20, 2, '', 1, 0, 0, 5, 0, 22, 1, 2, 4, 20.0000, 0, '2008-12-31 18:36:51', '2009-10-03 15:32:01', '2008-12-31 00:00:00', 5.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 5),
(21, 3, '', 1, 0, 0, 5, 0, 23, 1, 2, 4, 30.0000, 0, '2008-12-31 18:38:07', '2009-07-26 09:05:51', '2008-12-31 00:00:00', 8.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '2009-12-31 00:00:00', '2009-03-01 00:00:00', 1, 24.9900, 6, 6),
(22, 1, '', 1, 0, 0, 4, 0, 10, 1, 2, 4, 10.0000, 0, '2009-09-14 05:21:43', '2009-10-04 10:04:30', '2009-09-14 00:00:00', 2.0000, 4, 0, '0:0:0', 1, 0, 0, 1, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 1),
(23, 0, '', 1, 0, 0, 3, 0, 6, 1, 2, 4, 10.0000, 0, '2009-10-04 10:41:37', '2009-10-04 10:43:02', '2009-10-04 00:00:00', 20.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 0),
(24, 0, '', 1, 0, 0, 3, 0, 6, 1, 2, 4, 100.0000, 0, '2009-10-04 10:44:41', '2009-10-04 10:43:02', '2009-10-04 00:00:00', 2.0000, 4, 0, '0:0:0', 1, 0, 0, 0, '1969-12-31 00:00:00', '1969-12-31 00:00:00', 1, 0.0000, 6, 0);

-- --------------------------------------------------------

--
-- Table structure for table `product_description`
--

CREATE TABLE `product_description` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `technical` text COLLATE utf8_unicode_ci,
  `technical_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `model` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `model_number` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_keywords` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alt_description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`product_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=45 ;

--
-- Dumping data for table `product_description`
--

INSERT INTO `product_description` VALUES
(3, 1, 'Product 3', '<p>A very fast motorcycle with 16&quot; tires.</p>\r\n<p>This blue motorcycle has 16&quot; inch wheels tires.</p>', '', '', 'MINIMOTO3', NULL, '', '', '', ''),
(21, 1, 'Latest 3', '<p>Latest Product Number 3<br>\r\nTry <strong><span style="color: rgb(0, 0, 255);">Search</span></strong> motor cycles by <strong><span style="color: rgb(255, 0, 0);">color</span></strong>.<br>\r\nFeatures Dated Special Price.</p>', '', '', 'latest', NULL, '', '', '', ''),
(6, 1, 'Special2', '<p>Special Number 2<br>\r\nOnce number of items <strong>exceeds limit</strong>,<br>\r\nRandom selection occurs.</p>', '', '', 'specials', NULL, '', '', '', ''),
(7, 1, 'Special3', '<p>Special Number 3<br>\r\nSpecials are displayed on product page<br>\r\nunless <strong>related</strong> items are available.</p>', '', '', 'specials', NULL, '', '', '', ''),
(8, 1, 'Special4', '<p>Special Number 4<br>\r\nSpecials are displayed in&nbsp; <strong>category</strong> pages.</p>', '', '', 'specials', NULL, '', '', '', ''),
(9, 1, 'Special5', '<p>Special Number 5</p>', '', '', 'specials', NULL, '', '', '', ''),
(11, 1, 'Featured2', '<p>Featured Product Number 2<br>\r\nThis item has <strong><span style="font-size: smaller;"><span style="color: rgb(51, 153, 102);">5 Related</span></span></strong> Products.<br>\r\nThey are Shown Randomly.<br>\r\n3/8&quot;&amp;1/2&quot;</p>\r\n<p><hidden>*Hidden Description*</hidden></p>', '', '', 'Featured', NULL, '', '', '', ''),
(17, 1, 'Related 4', '<p>This is Related Product Number 4</p>', '', '', 'related', NULL, '', '', '', ''),
(18, 1, 'Related 5', '<p>Related Product Number 5</p>', '', '', 'related', NULL, '', '', '', ''),
(19, 1, 'Latest 1', '<p>Latest Product Number 1<br>\r\nThese are last three items <br>\r\nadded to the cart.</p>', '', '', 'latest', NULL, '', '', '', '<p>Latest Product Number 1<br>\r\nThese are last items <br>\r\nadded to the cart. Only <br>\r\nThree are displayed</p>'),
(20, 1, 'Latest 2', '<p>Latest Product Number 2<br>\r\nTry our <strong><span style="color: rgb(255, 0, 0);">enhanced search</span></strong>.<br>\r\nIt Searches hidden fields.</p>', '', '', 'latest', NULL, '', '', '', ''),
(14, 1, 'Related 1', '<p>Related Product Number 1</p>', '', '', 'related', NULL, '', '', '', ''),
(15, 1, 'Related 2', '<p>Related Product Number 2<br>\r\nDated Special Price.</p>', '', '', 'related', NULL, '', '', '', ''),
(16, 1, 'Related 3', '<p>Related Product Number 3</p>', '', '', 'related', NULL, '', '', '', ''),
(5, 1, 'Special1', '<p>Specials number 1<br>\r\nFeatured, Specials, and Related Items are<br>\r\npicked <strong><span style="color: rgb(255, 0, 255);">randomly</span></strong>.</p>', '', '', 'specials', NULL, '', '', '', ''),
(4, 1, 'Product 4', '<p>This is a Yellow Motor Cycle. <br>\r\nIt has a Racing Engine. It Goes 250 KPH.<br>\r\nIt has 17&quot; tires. I like Yellow.</p>\r\n<p><hidden>*Hidden Description*</hidden>yellow motorcyle bike racing engine motor over 250 kph kilometer per hour</p>', '', '', 'MINIMOTO4', NULL, '', '', '', ''),
(1, 1, 'Product 1', '<p>This is a sample of reviews<br>\r\nThis&nbsp; Motor cycle has been reviewed by one customer.</p>\r\n<p>This is a sample of a review done by a potential customer. The color is red.<br>\r\n&nbsp;</p>', '', '', 'Motor Cycle', NULL, 'Meta keywords, dynamic', 'This is the meta description for product 1', 'This is meta tilte for product 1', '<p>This is a motor bike.<br>\r\nIt has quantity discount.<br>\r\nIt has reviews</p>'),
(13, 1, 'Featured4', '<p>Featured Number 4<br>\r\nThis item has hidden search terms.<br>\r\nThese are available only to internal cart searches.</p>\r\n<p><hidden>featured item number 4 four</p>', '', '', 'Featured', NULL, '', '', '', ''),
(2, 1, 'Product 2', '<p>This is a Green Motor Cycle.<br>\r\nIt goes very fast. It has a Sport Seat.</p>\r\n<p><hidden>*Hidden Description*</hidden>Green motorcycle with sport seat.</p>', '', '', 'Motor Cycle', NULL, '', '', '', ''),
(12, 1, 'Featured3', '<p>Featured Number 3<br>\r\nThis item has no related Products.<br>\r\nSpecial Priced Items Will Be Displayed.</p>', '', '', '3/8&quot;&amp;1/2&quot;', NULL, '', '', '', ''),
(22, 1, 'Featured1Hidden', '<p>Description Source for Featured1</p>\r\n<p>Featured Number 1<br>\r\n<br>\r\nThis Product has <strong><span style="font-size: medium;"><span style="color: rgb(255, 0, 0);">2 Related </span></span></strong>Products.<br>\r\n<br>\r\nThese are Displayed in Product View.</p>\r\n<p>&nbsp;</p>\r\n<p><hidden>*Hidden Description*</hidden> This item has hidden description.</p>', '', '', '3/8&quot;&amp;1/2&quot;', NULL, '', '', '', ''),
(10, 1, 'Featured13/8&quot;&amp;1/2&quot;', '<p>Featured Number 1<br>\r\nThis Product has <strong><span style="font-size: medium;"><span style="color: rgb(255, 0, 0);">2 Related </span></span></strong>Products.<br>\r\nThese are Displayed in Product View.</p>\r\n<p><hidden>*Hidden Description*</hidden> This item has hidden description.</p>', '<p>This is where technical specifications would go.</p>', '', 'Coral Reef', NULL, 'related, products', 'Includes 2 related items', 'Featured 1', '<p>Shows related Products<br>\r\non product Page<br>\r\notherwise Specials are<br>\r\nshown.</p>'),
(23, 1, 'Featured2 3/8&quot;&amp;1/2&quot;', '<p>3/8&quot;&amp;1/2&quot; test</p>', '', '', '3/8&quot;&amp;1/2&quot;', NULL, '', '', '', ''),
(24, 1, 'Featured3 3/8&quot;&amp;1/2&quot;', '<p>3-3/8&quot;&amp;1/2&quot;</p>', '', '', '3/8&quot;&amp;1/2&quot;', NULL, '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `product_discount`
--

CREATE TABLE `product_discount` (
  `product_discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `quantity` int(4) NOT NULL,
  `discount` decimal(15,4) NOT NULL,
  PRIMARY KEY (`product_discount_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=35 ;

--
-- Dumping data for table `product_discount`
--

INSERT INTO `product_discount` VALUES
(34, 1, 4, 15.0000),
(33, 1, 3, 10.0000),
(32, 1, 2, 5.0000);

-- --------------------------------------------------------

--
-- Table structure for table `product_options`
--

CREATE TABLE `product_options` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_option` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` int(4) NOT NULL DEFAULT '0',
  `barcode` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_id` int(11) NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension_value` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0:0:0',
  `model_number` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`product_id`,`product_option`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `product_to_category`
--

CREATE TABLE `product_to_category` (
  `product_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `product_to_category`
--

INSERT INTO `product_to_category` VALUES
(1, 8),
(1, 9),
(2, 8),
(2, 9),
(3, 8),
(3, 9),
(4, 8),
(4, 9),
(5, 4),
(5, 7),
(6, 4),
(6, 7),
(7, 4),
(7, 7),
(8, 4),
(8, 7),
(9, 4),
(9, 7),
(10, 2),
(10, 5),
(11, 2),
(11, 5),
(12, 2),
(12, 5),
(13, 2),
(13, 5),
(14, 10),
(14, 11),
(15, 10),
(15, 11),
(16, 10),
(16, 11),
(17, 10),
(17, 11),
(18, 10),
(18, 11),
(19, 3),
(19, 6),
(20, 3),
(20, 6),
(21, 3),
(21, 6),
(22, 2),
(22, 5),
(23, 2),
(23, 5),
(24, 2),
(24, 5);

-- --------------------------------------------------------

--
-- Table structure for table `product_to_download`
--

CREATE TABLE `product_to_download` (
  `product_id` int(11) NOT NULL DEFAULT '0',
  `download_id` int(11) NOT NULL DEFAULT '0',
  `free` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `product_to_image`
--

CREATE TABLE `product_to_image` (
  `product_id` int(11) NOT NULL DEFAULT '0',
  `image_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `product_to_image`
--

INSERT INTO `product_to_image` VALUES
(1, 2),
(1, 3),
(1, 4),
(2, 1),
(2, 3);

-- --------------------------------------------------------

--
-- Table structure for table `product_to_option`
--

CREATE TABLE `product_to_option` (
  `product_to_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `option_id` int(11) NOT NULL DEFAULT '0',
  `option_value_id` int(11) NOT NULL DEFAULT '0',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `prefix` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '+',
  `option_weight` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `option_weightclass_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_to_option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `product_to_option`
--

INSERT INTO `product_to_option` VALUES
(1, 1, 2, 2, 1.0000, '+', 0.0000, 4, 1),
(2, 1, 2, 3, 2.0000, '-', 0.0000, 4, 2),
(3, 1, 1, 10, 3.0000, '+', 0.0000, 4, 3),
(4, 15, 1, 10, 1.0000, '-', 0.0000, 4, 1),
(5, 15, 1, 12, 1.0000, '+', 0.0000, 4, 2),
(6, 2, 1, 10, 1.0000, '-', 0.0000, 4, 1),
(7, 2, 1, 11, 0.0000, '-', 0.0000, 4, 2),
(8, 2, 1, 12, 1.0000, '+', 0.0000, 4, 3),
(9, 2, 3, 13, 0.0000, '-', 0.0000, 4, 1),
(10, 2, 3, 14, 2.0000, '+', 0.0000, 4, 2);

-- --------------------------------------------------------

--
-- Table structure for table `related_products`
--

CREATE TABLE `related_products` (
  `product_id` int(11) NOT NULL,
  `related_product_id` int(11) NOT NULL,
  PRIMARY KEY (`product_id`,`related_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `related_products`
--

INSERT INTO `related_products` VALUES
(10, 14),
(10, 15),
(11, 14),
(11, 15),
(11, 16),
(11, 17),
(11, 18),
(22, 10);

-- --------------------------------------------------------

--
-- Table structure for table `review`
--

CREATE TABLE `review` (
  `review_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `author` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `text` text COLLATE utf8_unicode_ci NOT NULL,
  `rating1` int(1) DEFAULT NULL,
  `rating2` int(1) DEFAULT NULL,
  `rating3` int(1) DEFAULT NULL,
  `rating4` int(1) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `date_added` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`review_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `review`
--

INSERT INTO `review` VALUES
(1, 1, 0, 'John Customer', 'This a sample Review.\r\nThis product was reviewed by a potential or previous customer.', 4, 5, 3, 5, 1, '2008-12-27 11:23:43', '0000-00-00 00:00:00'),
(2, 1, 2, 'Another Customer', 'This is a nice red motor cycle. It goes very fast and handles well at high speeds. \r\nIt is very comfortable to ride for long distances.', 5, 5, 4, 3, 1, '2009-04-08 19:48:49', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `session`
--

CREATE TABLE `session` (
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `expire` int(10) NOT NULL DEFAULT '0',
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `setting`
--

CREATE TABLE `setting` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `key` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(768) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`),
  KEY `group` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=265 ;

--
-- Dumping data for table `setting`
--

INSERT INTO `setting` VALUES
(1, 'catalog', 'footer', 'footer_status', '1'),
(2, 'global', 'cod', 'cod_sort_order', '1'),
(3, 'catalog', 'header', 'header_status', '1'),
(4, 'catalog', 'language', 'language_status', '1'),
(5, 'admin', 'language', 'language_status', '1'),
(6, 'global', 'shipping', 'shipping_status', '1'),
(7, 'catalog', 'config', 'category_addtocart', '1'),
(8, 'catalog', 'config', 'search_image_width', '175'),
(9, 'catalog', 'config', 'category_image_height', '175'),
(10, 'global', 'total', 'total_sort_order', '6'),
(11, 'global', 'coupon', 'coupon_sort_order', '4'),
(12, 'global', 'shipping', 'shipping_sort_order', '2'),
(13, 'global', 'subtotal', 'subtotal_sort_order', '1'),
(14, 'global', 'subtotal', 'subtotal_status', '1'),
(15, 'global', 'coupon', 'coupon_status', '1'),
(16, 'global', 'tax', 'tax_sort_order', '5'),
(17, 'global', 'tax', 'tax_status', '1'),
(18, 'global', 'flat', 'flat_tax_class_id', '0'),
(19, 'global', 'flat', 'flat_cost', '0.00'),
(20, 'catalog', 'category', 'category_status', '1'),
(21, 'global', 'total', 'total_status', '1'),
(22, 'global', 'cod', 'cod_geo_zone_id', '0'),
(23, 'global', 'cod', 'cod_status', '1'),
(24, 'catalog', 'review', 'review_status', '1'),
(25, 'catalog', 'search', 'search_status', '1'),
(26, 'catalog', 'currency', 'currency_status', '1'),
(27, 'catalog', 'information', 'information_status', '1'),
(28, 'global', 'item', 'item_sort_order', '0'),
(29, 'global', 'item', 'item_tax_class_id', '0'),
(30, 'catalog', 'config', 'category_image_width', '175'),
(31, 'catalog', 'config', 'additional_image_width', '150'),
(32, 'global', 'paypal', 'paypal_test', '0'),
(33, 'catalog', 'config', 'additional_image_height', '150'),
(34, 'global', 'paypal', 'paypal_email', 'youremail@domain.com'),
(35, 'global', 'zone', 'zone_tax_class_id', '6'),
(36, 'global', 'zone', 'zone_2_status', '0'),
(37, 'global', 'item', 'item_cost', '0.00'),
(38, 'global', 'item', 'item_geo_zone_id', '0'),
(39, 'global', 'item', 'item_status', '0'),
(40, 'global', 'flat', 'flat_geo_zone_id', '0'),
(41, 'global', 'flat', 'flat_status', '1'),
(42, 'catalog', 'cart', 'cart_status', '1'),
(43, 'admin', 'menu', 'menu_status', '1'),
(44, 'admin', 'footer', 'footer_status', '1'),
(45, 'admin', 'header', 'header_status', '1'),
(46, 'global', 'zone', 'zone_1_status', '0'),
(47, 'global', 'zone', 'zone_2_cost', '1.00:7'),
(48, 'global', 'zone', 'zone_1_cost', ''),
(49, 'global', 'paypal', 'paypal_geo_zone_id', '0'),
(50, 'catalog', 'config', 'product_addtocart', '1'),
(51, 'catalog', 'config', 'product_image_height', '250'),
(52, 'catalog', 'config', 'product_image_width', '250'),
(53, 'catalog', 'config', 'config_download_status', '16'),
(54, 'global', 'paypal', 'paypal_currency', 'EUR,GBP,USD'),
(55, 'global', 'paypal', 'paypal_status', '1'),
(56, 'global', 'paypal', 'paypal_sort_order', '1'),
(57, 'global', 'zone', 'zone_sort_order', '0'),
(58, 'global', 'flat', 'flat_sort_order', '0'),
(59, 'catalog', 'config', 'config_download', '1'),
(60, 'global', 'config', 'config_image_height', '175'),
(61, 'global', 'config', 'config_image_width', '175'),
(62, 'global', 'config', 'config_image_resize', '1'),
(63, 'catalog', 'featured', 'featured_columns', '4'),
(64, 'catalog', 'latest', 'latest_columns', '3'),
(65, 'catalog', 'specials', 'specials_addtocart', '1'),
(66, 'global', 'config', 'config_compress_level', '4'),
(67, 'global', 'config', 'config_compress_output', '1'),
(68, 'catalog', 'related', 'related_addtocart', '1'),
(69, 'global', 'config', 'config_cache_query', '1'),
(70, 'global', 'config', 'config_email_send', '1'),
(71, 'global', 'config', 'config_email', 'youremail@domain.com'),
(72, 'catalog', 'config', 'config_checkout_id', '3'),
(73, 'catalog', 'config', 'config_account_id', '0'),
(74, 'catalog', 'config', 'config_stock_subtract', '0'),
(75, 'global', 'version', 'version', '1.2.9'),
(76, 'global', 'paypal', 'paypal_auth_type', 'sale'),
(77, 'catalog', 'config', 'config_vat', '123456'),
(78, 'catalog', 'popular', 'popular_total', '6'),
(79, 'catalog', 'config', 'config_stock_checkout', '1'),
(80, 'catalog', 'config', 'config_stock_check', '0'),
(81, 'global', 'config', 'config_order_status_id', '1'),
(82, 'global', 'config', 'config_tax', '1'),
(83, 'global', 'config', 'config_weight_class_id', '4'),
(84, 'global', 'config', 'config_currency', 'CAD'),
(85, 'admin', 'config', 'config_language', 'en'),
(86, 'catalog', 'config', 'config_language', 'en'),
(87, 'catalog', 'related', 'related_image_height', '175'),
(88, 'catalog', 'popular', 'popular_addtocart', '1'),
(89, 'catalog', 'popular', 'popular_image_height', '175'),
(90, 'catalog', 'popular', 'popular_image_width', '175'),
(91, 'catalog', 'popular', 'popular_limit', '1'),
(92, 'catalog', 'popular', 'popular_status', '1'),
(93, 'catalog', 'featured', 'featured_addtocart', '1'),
(94, 'catalog', 'featured', 'featured_image_height', '140'),
(95, 'catalog', 'featured', 'featured_image_width', '140'),
(96, 'catalog', 'latest', 'latest_total', '10'),
(97, 'catalog', 'latest', 'latest_addtocart', '1'),
(98, 'catalog', 'latest', 'latest_image_height', '175'),
(99, 'catalog', 'latest', 'latest_image_width', '175'),
(100, 'catalog', 'specials', 'specials_image_height', '175'),
(101, 'catalog', 'specials', 'specials_image_width', '175'),
(102, 'catalog', 'specials', 'specials_limit', '2'),
(103, 'catalog', 'specials', 'specials_status', '1'),
(104, 'catalog', 'related', 'related_image_width', '175'),
(105, 'catalog', 'related', 'related_limit', '3'),
(106, 'catalog', 'related', 'related_status', '1'),
(107, 'global', 'config', 'config_zone_id', '602'),
(108, 'global', 'config', 'config_country_id', '38'),
(109, 'admin', 'config', 'config_ssl', '0'),
(110, 'admin', 'config', 'config_parse_time', '0'),
(111, 'admin', 'config', 'config_max_rows', '20'),
(112, 'admin', 'config', 'config_template', 'default'),
(113, 'catalog', 'config', 'config_ssl', '0'),
(114, 'catalog', 'config', 'config_parse_time', '0'),
(115, 'global', 'config', 'config_url_alias', '0'),
(116, 'catalog', 'config', 'config_max_rows', '3'),
(117, 'catalog', 'config', 'config_template', 'default'),
(118, 'global', 'config', 'config_fax', '0123456789'),
(119, 'global', 'config', 'config_telephone', '0123456789'),
(120, 'catalog', 'featured', 'featured_limit', '4'),
(121, 'catalog', 'latest', 'latest_limit', '3'),
(122, 'catalog', 'latest', 'latest_status', '1'),
(123, 'catalog', 'featured', 'featured_status', '1'),
(124, 'catalog', 'manufacturer', 'manufacturer_columns', '1'),
(125, 'catalog', 'manufacturer', 'manufacturer_image_width', '175'),
(126, 'catalog', 'manufacturer', 'manufacturer_image_height', '175'),
(127, 'catalog', 'manufacturer', 'manufacturer_addtocart', '1'),
(128, 'catalog', 'manufactureroptions', 'manufacturer_options_status', '1'),
(129, 'catalog', 'categoryoptions', 'category_options_status', '1'),
(130, 'catalog', 'categoryoptions', 'category_columns', '1'),
(131, 'catalog', 'categoryoptions', 'category_display_lock', '0'),
(132, 'catalog', 'searchoptions', 'search_options_status', '1'),
(133, 'catalog', 'searchoptions', 'search_columns', '1'),
(134, 'catalog', 'searchoptions', 'search_display_lock', '0'),
(135, 'catalog', 'maintenance', 'maintenance_status', '0'),
(136, 'catalog', 'navigation', 'navigation_status', '1'),
(137, 'global', 'config', 'config_address', 'Address\r\nCity\r\nCounty \r\nPostal Code\r\nCountry'),
(138, 'global', 'config', 'config_owner', 'Your Name'),
(139, 'global', 'config', 'config_store', 'Your Store Name'),
(140, 'catalog', 'config', 'search_image_height', '175'),
(141, 'catalog', 'config', 'search_addtocart', '1'),
(142, 'catalog', 'config', 'search_limit', '7'),
(143, 'catalog', 'homepage', 'homepage_status', '1'),
(144, 'catalog', 'manufacturer', 'manufacturer_status', '1'),
(145, 'catalog', 'manufacturer', 'manufacturer_display_lock', '0'),
(146, 'global', 'authnetaim', 'authnetaim_status', '0'),
(147, 'global', 'authnetaim', 'authnetaim_geo_zone_id', '0'),
(148, 'global', 'authnetaim', 'authnetaim_sendemail', 'FALSE'),
(149, 'global', 'authnetaim', 'authnetaim_test', '1'),
(150, 'global', 'authnetaim', 'authnetaim_prod_login', ''),
(151, 'global', 'authnetaim', 'authnetaim_prod_txnkey', ''),
(152, 'global', 'authnetaim', 'authnetaim_test_login', ''),
(153, 'global', 'authnetaim', 'authnetaim_test_txnkey', ''),
(154, 'global', 'authnetaim', 'authnetaim_authtype', 'auth_capture'),
(155, 'global', 'authnetaim', 'authnetaim_sort_order', '1'),
(156, 'global', 'google', 'google_status', '0'),
(157, 'global', 'google', 'google_geo_zone_id', '0'),
(158, 'global', 'google', 'google_merchantid', ''),
(159, 'global', 'google', 'google_merchantkey', ''),
(160, 'global', 'google', 'google_test', '0'),
(161, 'global', 'google', 'google_currency', 'USD'),
(162, 'global', 'google', 'google_sort_order', '1'),
(163, 'catalog', 'config', 'product_options_select', 'select'),
(164, 'catalog', 'config', 'category_options_select', 'select'),
(165, 'catalog', 'config', 'search_options_select', 'select'),
(166, 'catalog', 'manufacturer', 'manufacturer_options_select', 'select'),
(167, 'catalog', 'config', 'config_styles', 'default'),
(168, 'global', 'config', 'config_seo', '0'),
(169, 'catalog', 'config', 'config_colors', 'neutral.css'),
(170, 'catalog', 'featured', 'featured_image_display', 'image_link'),
(171, 'catalog', 'featured', 'featured_lines_single', '6'),
(172, 'catalog', 'featured', 'featured_lines_multi', '4'),
(173, 'catalog', 'featured', 'featured_lines_char', '108'),
(174, 'catalog', 'latest', 'latest_image_display', 'image_link'),
(175, 'catalog', 'latest', 'latest_lines_single', '6'),
(176, 'catalog', 'latest', 'latest_lines_multi', '4'),
(177, 'catalog', 'latest', 'latest_lines_char', '108'),
(178, 'catalog', 'specials', 'specials_columns', '3'),
(179, 'catalog', 'specials', 'specials_image_display', 'image_link'),
(180, 'catalog', 'specials', 'specials_lines_single', '6'),
(181, 'catalog', 'specials', 'specials_lines_multi', '3'),
(182, 'catalog', 'specials', 'specials_lines_char', '108'),
(183, 'catalog', 'related', 'related_columns', '3'),
(184, 'catalog', 'related', 'related_image_display', 'image_link'),
(185, 'catalog', 'related', 'related_lines_single', '6'),
(186, 'catalog', 'related', 'related_lines_multi', '3'),
(187, 'catalog', 'related', 'related_lines_char', '108'),
(188, 'catalog', 'popular', 'popular_columns', '1'),
(189, 'catalog', 'popular', 'popular_image_display', 'image_link'),
(190, 'catalog', 'popular', 'popular_lines_single', '6'),
(191, 'catalog', 'popular', 'popular_lines_multi', '3'),
(192, 'catalog', 'popular', 'popular_lines_char', '108'),
(193, 'catalog', 'config', 'product_image_display', 'thickbox'),
(194, 'catalog', 'config', 'content_image_display', 'thickbox'),
(195, 'catalog', 'config', 'content_lines_single', '6'),
(196, 'catalog', 'config', 'content_lines_multi', '4'),
(197, 'catalog', 'config', 'content_lines_char', '108'),
(198, 'catalog', 'config', 'config_columns', '3'),
(199, 'global', 'config', 'config_email_orders', ''),
(200, 'global', 'config', 'config_email_accounts', ''),
(201, 'global', 'config', 'config_email_newsletter', ''),
(202, 'global', 'config', 'config_email_mail', ''),
(203, 'global', 'config', 'config_email_contact', ''),
(204, 'catalog', 'config', 'addtocart_quantity_box', 'selectbox'),
(205, 'catalog', 'config', 'addtocart_quantity_max', '20'),
(206, 'global', 'developer', 'developer_developer', 'Your Developer Team'),
(207, 'global', 'developer', 'developer_link', 'http://www.alegrocart.com'),
(208, 'global', 'developer', 'developer_status', '1'),
(209, 'global', 'zone', 'zone_status', '0'),
(210, 'catalog', 'imagedisplay', 'imagedisplay_status', '1'),
(211, 'global', 'config', 'config_currency_surcharge', '0.000'),
(212, 'global', 'config', 'invoice_number', '1'),
(213, 'global', 'config', 'config_tax_store', '0'),
(214, 'catalog', 'config', 'search_rows', '0'),
(215, 'catalog', 'config', 'category_rows', '0'),
(216, 'global', 'config', 'config_dimension_type_id', '1'),
(217, 'global', 'config', 'config_dimension_1_id', '1'),
(218, 'global', 'config', 'config_dimension_2_id', '6'),
(219, 'global', 'config', 'config_dimension_3_id', '4'),
(220, 'global', 'config', 'config_dimension_decimal', '2'),
(221, 'global', 'config', 'config_rss_limit', '40'),
(222, 'catalog', 'config', 'config_store_logo', 'shoppingcart2.png'),
(223, 'catalog', 'config', 'config_logo_left', '385'),
(224, 'catalog', 'config', 'config_logo_top', '5'),
(225, 'catalog', 'config', 'config_logo_width', '230'),
(226, 'catalog', 'config', 'config_logo_height', '60'),
(227, 'catalog', 'config', 'magnifier', '0'),
(228, 'catalog', 'config', 'magnifier_width', '125'),
(229, 'catalog', 'config', 'magnifier_height', '125'),
(230, 'global', 'config', 'error_developer_ip', ''),
(231, 'global', 'config', 'error_show_user', '0'),
(232, 'global', 'config', 'error_show_developer', '0'),
(233, 'global', 'config', 'config_error_email', ''),
(234, 'global', 'config', 'error_handler_status', '0'),
(235, 'global', 'config', 'config_rss_status', '1'),
(236, 'global', 'config', 'config_rss_source', 'rss_latest'),
(237, 'catalog', 'config', 'config_footer_logo', 'paypal-visa-mastercard.png'),
(238, 'catalog', 'config', 'footer_logo_left', '0'),
(239, 'catalog', 'config', 'footer_logo_top', '15'),
(240, 'catalog', 'config', 'footer_logo_width', '170'),
(241, 'catalog', 'config', 'footer_logo_height', '30'),
(242, 'catalog', 'config', 'config_guest_checkout', '1'),
(243, 'global', 'config', 'error_email_status', '1'),
(244, 'global', 'config', 'config_time_zone', 'UTC'),
(245, 'catalog', 'config', 'captcha_contactus', '0'),
(246, 'catalog', 'config', 'captcha_reg', '0'),
(247, 'catalog', 'config', 'captcha_length', '5'),
(248, 'catalog', 'config', 'show_stock', '1'),
(249, 'global', 'config', 'barcode_encoding', 'upc'),
(250, 'global', 'config', 'config_weight_decimal', '1'),
(251, 'catalog', 'config', 'config_discount_options', '0'),
(252, 'catalog', 'config', 'config_show_stock_icon', '0'),
(253, 'catalog', 'config', 'config_low_stock_warning', '0'),
(254, 'global', 'config', 'config_session_expire', '3600'),
(255, 'catalog', 'config', 'config_freedownload', '0'),
(256, 'global', 'config', 'sitemap_status', '0'),
(257, 'catalog', 'config', 'options_manufacturer', '1'),
(258, 'catalog', 'config', 'options_model', '1'),
(259, 'global', 'config', 'config_email_port', '25'),
(260, 'global', 'config', 'config_email_tout', '10'),
(261, 'catalog', 'review', 'review_image_display', 'thickbox'),
(262, 'catalog', 'cart', 'cart_offset', '0'),
(263, 'global', 'config', 'config_image_quality', '75'),
(264, 'global', 'config', 'config_newsletter', '0');

-- --------------------------------------------------------

--
-- Table structure for table `tax_class`
--

CREATE TABLE `tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`tax_class_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `tax_class`
--

INSERT INTO `tax_class` VALUES
(6, 'Taxable Goods', 'taxed stuff', '2006-11-08 08:45:44', '2007-07-26 13:54:08');

-- --------------------------------------------------------

--
-- Table structure for table `tax_rate`
--

CREATE TABLE `tax_rate` (
  `tax_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_id` int(11) NOT NULL DEFAULT '0',
  `tax_class_id` int(11) NOT NULL DEFAULT '0',
  `priority` int(5) DEFAULT '1',
  `rate` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`tax_rate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tax_rate`
--

INSERT INTO `tax_rate` VALUES
(1, 1, 6, 1, 17.5000, 'UK VAT 17.5%', '2007-08-08 23:33:27', '2006-11-08 08:49:10');

-- --------------------------------------------------------

--
-- Table structure for table `tpl_location`
--

CREATE TABLE `tpl_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`location_id`),
  KEY `location` (`location`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `tpl_location`
--

INSERT INTO `tpl_location` VALUES
(1, 'header'),
(2, 'extra'),
(3, 'column'),
(4, 'content'),
(5, 'columnright'),
(6, 'footer'),
(7, 'pagebottom');

-- --------------------------------------------------------

--
-- Table structure for table `tpl_manager`
--

CREATE TABLE `tpl_manager` (
  `tpl_manager_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpl_controller` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpl_columns` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `tpl_status` int(3) DEFAULT '1',
  `tpl_color` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`tpl_manager_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tpl_module`
--

CREATE TABLE `tpl_module` (
  `tpl_module_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpl_manager_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `module_code` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(3) DEFAULT '0',
  PRIMARY KEY (`tpl_module_id`),
  KEY `location_id` (`location_id`),
  KEY `tpl_manager_id` (`tpl_manager_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `url_alias`
--

CREATE TABLE `url_alias` (
  `url_alias_id` int(11) NOT NULL AUTO_INCREMENT,
  `query` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `alias` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`url_alias_id`),
  KEY `query` (`query`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(11) NOT NULL DEFAULT '0',
  `username` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `firstname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user`
--

INSERT INTO `user` VALUES
(1, 1, '[[admin_username]]', '[[admin_pass]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', '', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_group`
--

CREATE TABLE `user_group` (
  `user_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permission` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_group_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `user_group`
--

INSERT INTO `user_group` VALUES
(1, 'Top Administrator', 'a:2:{s:6:"access";a:1:{i:0;s:1:"*";}s:6:"modify";a:1:{i:0;s:1:"*";}}'),
(2, 'Demonstration', 'a:2:{s:6:"access";a:75:{i:0;s:16:"calculate_coupon";i:1;s:18:"calculate_shipping";i:2;s:18:"calculate_subtotal";i:3;s:13:"calculate_tax";i:4;s:15:"calculate_total";i:5;s:8:"category";i:6;s:7:"country";i:7;s:6:"coupon";i:8;s:8:"currency";i:9;s:8:"customer";i:10;s:8:"download";i:11;s:5:"error";i:12;s:9:"extension";i:13;s:18:"generate_url_alias";i:14;s:8:"geo_zone";i:15;s:4:"home";i:16;s:5:"image";i:17;s:5:"index";i:18;s:11:"information";i:19;s:8:"language";i:20;s:5:"login";i:21;s:6:"logout";i:22;s:4:"mail";i:23;s:11:"maintenance";i:24;s:12:"manufacturer";i:25;s:19:"module_admin_footer";i:26;s:19:"module_admin_header";i:27;s:21:"module_admin_language";i:28;s:17:"module_admin_menu";i:29;s:19:"module_catalog_cart";i:30;s:23:"module_catalog_category";i:31;s:23:"module_catalog_currency";i:32;s:21:"module_catalog_footer";i:33;s:21:"module_catalog_header";i:34;s:26:"module_catalog_information";i:35;s:23:"module_catalog_language";i:36;s:25:"module_catalog_navigation";i:37;s:21:"module_catalog_review";i:38;s:21:"module_catalog_search";i:39;s:28:"module_extra_categoryoptions";i:40;s:21:"module_extra_featured";i:41;s:19:"module_extra_latest";i:42;s:25:"module_extra_manufacturer";i:43;s:32:"module_extra_manufactureroptions";i:44;s:20:"module_extra_popular";i:45;s:20:"module_extra_related";i:46;s:26:"module_extra_searchoptions";i:47;s:21:"module_extra_specials";i:48;s:10:"newsletter";i:49;s:6:"option";i:50;s:12:"option_value";i:51;s:5:"order";i:52;s:12:"order_status";i:53;s:11:"payment_cod";i:54;s:14:"payment_paypal";i:55;s:10:"permission";i:56;s:7:"product";i:57;s:14:"product_option";i:58;s:16:"report_purchased";i:59;s:11:"report_sale";i:60;s:13:"report_viewed";i:61;s:6:"review";i:62;s:11:"server_info";i:63;s:7:"setting";i:64;s:13:"shipping_flat";i:65;s:13:"shipping_item";i:66;s:13:"shipping_zone";i:67;s:9:"tax_class";i:68;s:8:"tax_rate";i:69;s:9:"url_alias";i:70;s:4:"user";i:71;s:10:"user_group";i:72;s:12:"weight_class";i:73;s:4:"zone";i:74;s:16:"zone_to_geo_zone";}s:6:"modify";N;}');

-- --------------------------------------------------------

--
-- Table structure for table `vendor`
--

CREATE TABLE `vendor` (
  `vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `discount` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` int(1) NOT NULL,
  `email` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `telephone` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `trade` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`vendor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- Table structure for table `watermark`
--

CREATE TABLE `watermark` (
  `wm_id` int(11) NOT NULL AUTO_INCREMENT,
  `wm_method` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_text` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_font` int(11) NOT NULL DEFAULT '0',
  `wm_fontcolor` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_transparency` int(11) NOT NULL DEFAULT '0',
  `wm_thposition` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_tvposition` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_thmargin` int(11) NOT NULL DEFAULT '0',
  `wm_tvmargin` int(11) NOT NULL DEFAULT '0',
  `wm_image` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_ihposition` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_ivposition` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wm_ihmargin` int(11) NOT NULL DEFAULT '0',
  `wm_ivmargin` int(11) NOT NULL DEFAULT '0',
  `wm_scale` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`wm_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `watermark`
--

INSERT INTO `watermark` VALUES
(1, 'auto', '', 5, 'CCCCCC', 80, 'CENTER', 'TOP', 10, 15, '0', 'RIGHT', 'BOTTOM', 12, 21, 50),
(2, 'manual', 'Alegrocart TEST manual watermark', 4, '000000', 70, 'CENTER', 'TOP', 15, 25, 'ac_logo.png', 'RIGHT', 'BOTTOM', 15, 25, 60);

-- --------------------------------------------------------

--
-- Table structure for table `weight_class`
--

CREATE TABLE `weight_class` (
  `weight_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`weight_class_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `weight_class`
--

INSERT INTO `weight_class` VALUES
(1, 'g', 1, 'Gram(s)'),
(2, 'kg', 1, 'Kilogram(s)'),
(3, 'oz', 1, 'Ounce(s)'),
(4, 'lb', 1, 'Pound(s)');

-- --------------------------------------------------------

--
-- Table structure for table `weight_rule`
--

CREATE TABLE `weight_rule` (
  `from_id` int(11) NOT NULL DEFAULT '0',
  `to_id` int(11) NOT NULL DEFAULT '0',
  `rule` decimal(15,4) NOT NULL DEFAULT '0.0000'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `weight_rule`
--

INSERT INTO `weight_rule` VALUES
(1, 2, 0.0010),
(1, 3, 0.0353),
(1, 4, 0.0022),
(2, 1, 1000.0000),
(2, 3, 35.2739),
(2, 4, 2.2046),
(3, 1, 28.3495),
(3, 2, 0.0283),
(3, 4, 0.0625),
(4, 1, 453.5923),
(4, 2, 0.4535),
(4, 3, 16.0000);

-- --------------------------------------------------------

--
-- Table structure for table `zone`
--

CREATE TABLE `zone` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `code` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zone_status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3848 ;

--
-- Dumping data for table `zone`
--

INSERT INTO `zone` VALUES
(1, 1, 'BDS', 'Badakhshan', 1),
(2, 1, 'BDG', 'Badghis', 1),
(3, 1, 'BGL', 'Baghlan', 1),
(4, 1, 'BAL', 'Balkh', 1),
(5, 1, 'BAM', 'Bamian', 1),
(6, 1, 'FRA', 'Farah', 1),
(7, 1, 'FYB', 'Faryab', 1),
(8, 1, 'GHA', 'Ghazni', 1),
(9, 1, 'GHO', 'Ghowr', 1),
(10, 1, 'HEL', 'Helmand', 1),
(11, 1, 'HER', 'Herat', 1),
(12, 1, 'JOW', 'Jowzjan', 1),
(13, 1, 'KAB', 'Kabul', 1),
(14, 1, 'KAN', 'Kandahar', 1),
(15, 1, 'KAP', 'Kapisa', 1),
(16, 1, 'KHO', 'Khost', 1),
(17, 1, 'KNR', 'Konar', 1),
(18, 1, 'KDZ', 'Kondoz', 1),
(19, 1, 'LAG', 'Laghman', 1),
(20, 1, 'LOW', 'Lowgar', 1),
(21, 1, 'NAN', 'Nangrahar', 1),
(22, 1, 'NIM', 'Nimruz', 1),
(23, 1, 'NUR', 'Nurestan', 1),
(24, 1, 'ORU', 'Oruzgan', 1),
(25, 1, 'PIA', 'Paktia', 1),
(26, 1, 'PKA', 'Paktika', 1),
(27, 1, 'PAR', 'Parwan', 1),
(28, 1, 'SAM', 'Samangan', 1),
(29, 1, 'SAR', 'Sar-e Pol', 1),
(30, 1, 'TAK', 'Takhar', 1),
(31, 1, 'WAR', 'Wardak', 1),
(32, 1, 'ZAB', 'Zabol', 1),
(33, 2, 'BR', 'Berat', 1),
(34, 2, 'BU', 'Bulqize', 1),
(35, 2, 'DL', 'Delvine', 1),
(36, 2, 'DV', 'Devoll', 1),
(37, 2, 'DI', 'Diber', 1),
(38, 2, 'DR', 'Durres', 1),
(39, 2, 'EL', 'Elbasan', 1),
(40, 2, 'ER', 'Kolonje', 1),
(41, 2, 'FR', 'Fier', 1),
(42, 2, 'GJ', 'Gjirokaster', 1),
(43, 2, 'GR', 'Gramsh', 1),
(44, 2, 'HA', 'Has', 1),
(45, 2, 'KA', 'Kavaje', 1),
(46, 2, 'KB', 'Kurbin', 1),
(47, 2, 'KC', 'Kucove', 1),
(48, 2, 'KO', 'Korce', 1),
(49, 2, 'KR', 'Kruje', 1),
(50, 2, 'KU', 'Kukes', 1),
(51, 2, 'LB', 'Librazhd', 1),
(52, 2, 'LE', 'Lezhe', 1),
(53, 2, 'LU', 'Lushnje', 1),
(54, 2, 'MM', 'Malesi e Madhe', 1),
(55, 2, 'MK', 'Mallakaster', 1),
(56, 2, 'MT', 'Mat', 1),
(57, 2, 'MR', 'Mirdite', 1),
(58, 2, 'PQ', 'Peqin', 1),
(59, 2, 'PR', 'Permet', 1),
(60, 2, 'PG', 'Pogradec', 1),
(61, 2, 'PU', 'Puke', 1),
(62, 2, 'SH', 'Shkoder', 1),
(63, 2, 'SK', 'Skrapar', 1),
(64, 2, 'SR', 'Sarande', 1),
(65, 2, 'TE', 'Tepelene', 1),
(66, 2, 'TP', 'Tropoje', 1),
(67, 2, 'TR', 'Tirane', 1),
(68, 2, 'VL', 'Vlore', 1),
(69, 3, 'ADR', 'Adrar', 1),
(70, 3, 'ADE', 'Ain Defla', 1),
(71, 3, 'ATE', 'Ain Temouchent', 1),
(72, 3, 'ALG', 'Alger', 1),
(73, 3, 'ANN', 'Annaba', 1),
(74, 3, 'BAT', 'Batna', 1),
(75, 3, 'BEC', 'Bechar', 1),
(76, 3, 'BEJ', 'Bejaia', 1),
(77, 3, 'BIS', 'Biskra', 1),
(78, 3, 'BLI', 'Blida', 1),
(79, 3, 'BBA', 'Bordj Bou Arreridj', 1),
(80, 3, 'BOA', 'Bouira', 1),
(81, 3, 'BMD', 'Boumerdes', 1),
(82, 3, 'CHL', 'Chlef', 1),
(83, 3, 'CON', 'Constantine', 1),
(84, 3, 'DJE', 'Djelfa', 1),
(85, 3, 'EBA', 'El Bayadh', 1),
(86, 3, 'EOU', 'El Oued', 1),
(87, 3, 'ETA', 'El Tarf', 1),
(88, 3, 'GHA', 'Ghardaia', 1),
(89, 3, 'GUE', 'Guelma', 1),
(90, 3, 'ILL', 'Illizi', 1),
(91, 3, 'JIJ', 'Jijel', 1),
(92, 3, 'KHE', 'Khenchela', 1),
(93, 3, 'LAG', 'Laghouat', 1),
(94, 3, 'MUA', 'Muaskar', 1),
(95, 3, 'MED', 'Medea', 1),
(96, 3, 'MIL', 'Mila', 1),
(97, 3, 'MOS', 'Mostaganem', 1),
(98, 3, 'MSI', 'M&#039;Sila', 1),
(99, 3, 'NAA', 'Naama', 1),
(100, 3, 'ORA', 'Oran', 1),
(101, 3, 'OUA', 'Ouargla', 1),
(102, 3, 'OEB', 'Oum el-Bouaghi', 1),
(103, 3, 'REL', 'Relizane', 1),
(104, 3, 'SAI', 'Saida', 1),
(105, 3, 'SET', 'Setif', 1),
(106, 3, 'SBA', 'Sidi Bel Abbes', 1),
(107, 3, 'SKI', 'Skikda', 1),
(108, 3, 'SAH', 'Souk Ahras', 1),
(109, 3, 'TAM', 'Tamanghasset', 1),
(110, 3, 'TEB', 'Tebessa', 1),
(111, 3, 'TIA', 'Tiaret', 1),
(112, 3, 'TIN', 'Tindouf', 1),
(113, 3, 'TIP', 'Tipaza', 1),
(114, 3, 'TIS', 'Tissemsilt', 1),
(115, 3, 'TOU', 'Tizi Ouzou', 1),
(116, 3, 'TLE', 'Tlemcen', 1),
(117, 4, 'E', 'Eastern', 1),
(118, 4, 'M', 'Manu&#039;a', 1),
(119, 4, 'R', 'Rose Island', 1),
(120, 4, 'S', 'Swains Island', 1),
(121, 4, 'W', 'Western', 1),
(122, 5, 'ALV', 'Andorra la Vella', 1),
(123, 5, 'CAN', 'Canillo', 1),
(124, 5, 'ENC', 'Encamp', 1),
(125, 5, 'ESE', 'Escaldes-Engordany', 1),
(126, 5, 'LMA', 'La Massana', 1),
(127, 5, 'ORD', 'Ordino', 1),
(128, 5, 'SJL', 'Sant Julia de Loria', 1),
(129, 6, 'BGO', 'Bengo', 1),
(130, 6, 'BGU', 'Benguela', 1),
(131, 6, 'BIE', 'Bie', 1),
(132, 6, 'CAB', 'Cabinda', 1),
(133, 6, 'CCU', 'Cuando-Cubango', 1),
(134, 6, 'CNO', 'Cuanza Norte', 1),
(135, 6, 'CUS', 'Cuanza Sul', 1),
(136, 6, 'CNN', 'Cunene', 1),
(137, 6, 'HUA', 'Huambo', 1),
(138, 6, 'HUI', 'Huila', 1),
(139, 6, 'LUA', 'Luanda', 1),
(140, 6, 'LNO', 'Lunda Norte', 1),
(141, 6, 'LSU', 'Lunda Sul', 1),
(142, 6, 'MAL', 'Malange', 1),
(143, 6, 'MOX', 'Moxico', 1),
(144, 6, 'NAM', 'Namibe', 1),
(145, 6, 'UIG', 'Uige', 1),
(146, 6, 'ZAI', 'Zaire', 1),
(147, 9, 'ASG', 'Saint George', 1),
(148, 9, 'ASJ', 'Saint John', 1),
(149, 9, 'ASM', 'Saint Mary', 1),
(150, 9, 'ASL', 'Saint Paul', 1),
(151, 9, 'ASR', 'Saint Peter', 1),
(152, 9, 'ASH', 'Saint Philip', 1),
(153, 9, 'BAR', 'Barbuda', 1),
(154, 9, 'RED', 'Redonda', 1),
(155, 10, 'AN', 'Antartida e Islas del Atlantico', 1),
(156, 10, 'BA', 'Buenos Aires', 1),
(157, 10, 'CA', 'Catamarca', 1),
(158, 10, 'CH', 'Chaco', 1),
(159, 10, 'CU', 'Chubut', 1),
(160, 10, 'CO', 'Cordoba', 1),
(161, 10, 'CR', 'Corrientes', 1),
(162, 10, 'DF', 'Distrito Federal', 1),
(163, 10, 'ER', 'Entre Rios', 1),
(164, 10, 'FO', 'Formosa', 1),
(165, 10, 'JU', 'Jujuy', 1),
(166, 10, 'LP', 'La Pampa', 1),
(167, 10, 'LR', 'La Rioja', 1),
(168, 10, 'ME', 'Mendoza', 1),
(169, 10, 'MI', 'Misiones', 1),
(170, 10, 'NE', 'Neuquen', 1),
(171, 10, 'RN', 'Rio Negro', 1),
(172, 10, 'SA', 'Salta', 1),
(173, 10, 'SJ', 'San Juan', 1),
(174, 10, 'SL', 'San Luis', 1),
(175, 10, 'SC', 'Santa Cruz', 1),
(176, 10, 'SF', 'Santa Fe', 1),
(177, 10, 'SD', 'Santiago del Estero', 1),
(178, 10, 'TF', 'Tierra del Fuego', 1),
(179, 10, 'TU', 'Tucuman', 1),
(180, 11, 'AGT', 'Aragatsotn', 1),
(181, 11, 'ARR', 'Ararat', 1),
(182, 11, 'ARM', 'Armavir', 1),
(183, 11, 'GEG', 'Geghark''unik''', 1),
(184, 11, 'KOT', 'Kotayk&#039;', 1),
(185, 11, 'LOR', 'Lorri', 1),
(186, 11, 'SHI', 'Shirak', 1),
(187, 11, 'SYU', 'Syunik&#039;', 1),
(188, 11, 'TAV', 'Tavush', 1),
(189, 11, 'VAY', 'Vayots&#039; Dzor', 1),
(190, 11, 'YER', 'Yerevan', 1),
(191, 13, 'ACT', 'Australian Capital Territory', 1),
(192, 13, 'NSW', 'New South Wales', 1),
(193, 13, 'NT', 'Northern Territory', 1),
(194, 13, 'QLD', 'Queensland', 1),
(195, 13, 'SA', 'South Australia', 1),
(196, 13, 'TAS', 'Tasmania', 1),
(197, 13, 'VIC', 'Victoria', 1),
(198, 13, 'WA', 'Western Australia', 1),
(199, 14, 'BUR', 'Burgenland', 1),
(200, 14, 'KAR', 'Kärnten', 1),
(201, 14, 'NOS', 'Niederösterreich', 1),
(202, 14, 'OOS', 'Oberösterreich', 1),
(203, 14, 'SAL', 'Salzburg', 1),
(204, 14, 'STE', 'Steiermark', 1),
(205, 14, 'TIR', 'Tirol', 1),
(206, 14, 'VOR', 'Vorarlberg', 1),
(207, 14, 'WIE', 'Wien', 1),
(208, 15, 'AB', 'Ali Bayramli', 1),
(209, 15, 'ABS', 'Abseron', 1),
(210, 15, 'AGC', 'AgcabAdi', 1),
(211, 15, 'AGM', 'Agdam', 1),
(212, 15, 'AGS', 'Agdas', 1),
(213, 15, 'AGA', 'Agstafa', 1),
(214, 15, 'AGU', 'Agsu', 1),
(215, 15, 'AST', 'Astara', 1),
(216, 15, 'BA', 'Baki', 1),
(217, 15, 'BAB', 'BabAk', 1),
(218, 15, 'BAL', 'BalakAn', 1),
(219, 15, 'BAR', 'BArdA', 1),
(220, 15, 'BEY', 'Beylaqan', 1),
(221, 15, 'BIL', 'Bilasuvar', 1),
(222, 15, 'CAB', 'Cabrayil', 1),
(223, 15, 'CAL', 'Calilabab', 1),
(224, 15, 'CUL', 'Culfa', 1),
(225, 15, 'DAS', 'Daskasan', 1),
(226, 15, 'DAV', 'Davaci', 1),
(227, 15, 'FUZ', 'Fuzuli', 1),
(228, 15, 'GA', 'Ganca', 1),
(229, 15, 'GAD', 'Gadabay', 1),
(230, 15, 'GOR', 'Goranboy', 1),
(231, 15, 'GOY', 'Goycay', 1),
(232, 15, 'HAC', 'Haciqabul', 1),
(233, 15, 'IMI', 'Imisli', 1),
(234, 15, 'ISM', 'Ismayilli', 1),
(235, 15, 'KAL', 'Kalbacar', 1),
(236, 15, 'KUR', 'Kurdamir', 1),
(237, 15, 'LA', 'Lankaran', 1),
(238, 15, 'LAC', 'Lacin', 1),
(239, 15, 'LAN', 'Lankaran', 1),
(240, 15, 'LER', 'Lerik', 1),
(241, 15, 'MAS', 'Masalli', 1),
(242, 15, 'MI', 'Mingacevir', 1),
(243, 15, 'NA', 'Naftalan', 1),
(244, 15, 'NEF', 'Neftcala', 1),
(245, 15, 'OGU', 'Oguz', 1),
(246, 15, 'ORD', 'Ordubad', 1),
(247, 15, 'QAB', 'Qabala', 1),
(248, 15, 'QAX', 'Qax', 1),
(249, 15, 'QAZ', 'Qazax', 1),
(250, 15, 'QOB', 'Qobustan', 1),
(251, 15, 'QBA', 'Quba', 1),
(252, 15, 'QBI', 'Qubadli', 1),
(253, 15, 'QUS', 'Qusar', 1),
(254, 15, 'SA', 'Saki', 1),
(255, 15, 'SAT', 'Saatli', 1),
(256, 15, 'SAB', 'Sabirabad', 1),
(257, 15, 'SAD', 'Sadarak', 1),
(258, 15, 'SAH', 'Sahbuz', 1),
(259, 15, 'SAK', 'Saki', 1),
(260, 15, 'SAL', 'Salyan', 1),
(261, 15, 'SM', 'Sumqayit', 1),
(262, 15, 'SMI', 'Samaxi', 1),
(263, 15, 'SKR', 'Samkir', 1),
(264, 15, 'SMX', 'Samux', 1),
(265, 15, 'SAR', 'Sarur', 1),
(266, 15, 'SIY', 'Siyazan', 1),
(267, 15, 'SS', 'Susa', 1),
(268, 15, 'SUS', 'Susa', 1),
(269, 15, 'TAR', 'Tartar', 1),
(270, 15, 'TOV', 'Tovuz', 1),
(271, 15, 'UCA', 'Ucar', 1),
(272, 15, 'XA', 'Xankandi', 1),
(273, 15, 'XAC', 'Xacmaz', 1),
(274, 15, 'XAN', 'Xanlar', 1),
(275, 15, 'XIZ', 'Xizi', 1),
(276, 15, 'XCI', 'Xocali', 1),
(277, 15, 'XVD', 'Xocavand', 1),
(278, 15, 'YAR', 'Yardimli', 1),
(279, 15, 'YEV', 'Yevlax', 1),
(280, 15, 'ZAN', 'Zangilan', 1),
(281, 15, 'ZAQ', 'Zaqatala', 1),
(282, 15, 'ZAR', 'Zardab', 1),
(283, 15, 'NX', 'Naxcivan', 1),
(284, 16, 'ACK', 'Acklins', 1),
(285, 16, 'BER', 'Berry Islands', 1),
(286, 16, 'BIM', 'Bimini', 1),
(287, 16, 'BLK', 'Black Point', 1),
(288, 16, 'CAT', 'Cat Island', 1),
(289, 16, 'CAB', 'Central Abaco', 1),
(290, 16, 'CAN', 'Central Andros', 1),
(291, 16, 'CEL', 'Central Eleuthera', 1),
(292, 16, 'FRE', 'City of Freeport', 1),
(293, 16, 'CRO', 'Crooked Island', 1),
(294, 16, 'EGB', 'East Grand Bahama', 1),
(295, 16, 'EXU', 'Exuma', 1),
(296, 16, 'GRD', 'Grand Cay', 1),
(297, 16, 'HAR', 'Harbour Island', 1),
(298, 16, 'HOP', 'Hope Town', 1),
(299, 16, 'INA', 'Inagua', 1),
(300, 16, 'LNG', 'Long Island', 1),
(301, 16, 'MAN', 'Mangrove Cay', 1),
(302, 16, 'MAY', 'Mayaguana', 1),
(303, 16, 'MOO', 'Moore&#039;s Island', 1),
(304, 16, 'NAB', 'North Abaco', 1),
(305, 16, 'NAN', 'North Andros', 1),
(306, 16, 'NEL', 'North Eleuthera', 1),
(307, 16, 'RAG', 'Ragged Island', 1),
(308, 16, 'RUM', 'Rum Cay', 1),
(309, 16, 'SAL', 'San Salvador', 1),
(310, 16, 'SAB', 'South Abaco', 1),
(311, 16, 'SAN', 'South Andros', 1),
(312, 16, 'SEL', 'South Eleuthera', 1),
(313, 16, 'SWE', 'Spanish Wells', 1),
(314, 16, 'WGB', 'West Grand Bahama', 1),
(315, 17, 'CAP', 'Capital', 1),
(316, 17, 'CEN', 'Central', 1),
(317, 17, 'MUH', 'Muharraq', 1),
(318, 17, 'NOR', 'Northern', 1),
(319, 17, 'SOU', 'Southern', 1),
(320, 18, 'BAR', 'Barisal', 1),
(321, 18, 'CHI', 'Chittagong', 1),
(322, 18, 'DHA', 'Dhaka', 1),
(323, 18, 'KHU', 'Khulna', 1),
(324, 18, 'RAJ', 'Rajshahi', 1),
(325, 18, 'SYL', 'Sylhet', 1),
(326, 19, 'CC', 'Christ Church', 1),
(327, 19, 'AND', 'Saint Andrew', 1),
(328, 19, 'GEO', 'Saint George', 1),
(329, 19, 'JAM', 'Saint James', 1),
(330, 19, 'JOH', 'Saint John', 1),
(331, 19, 'JOS', 'Saint Joseph', 1),
(332, 19, 'LUC', 'Saint Lucy', 1),
(333, 19, 'MIC', 'Saint Michael', 1),
(334, 19, 'PET', 'Saint Peter', 1),
(335, 19, 'PHI', 'Saint Philip', 1),
(336, 19, 'THO', 'Saint Thomas', 1),
(337, 20, 'BR', 'Brestskaya (Brest)', 1),
(338, 20, 'HO', 'Homyel''skaya (Homyel'')', 1),
(339, 20, 'HM', 'Horad Minsk', 1),
(340, 20, 'HR', 'Hrodzyenskaya (Hrodna)', 1),
(341, 20, 'MA', 'Mahilyowskaya (Mahilyow)', 1),
(342, 20, 'MI', 'Minskaya', 1),
(343, 20, 'VI', 'Vitsyebskaya (Vitsyebsk)', 1),
(344, 21, 'VAN', 'Antwerpen', 1),
(345, 21, 'WBR', 'Brabant Wallon', 1),
(346, 21, 'WHT', 'Hainaut', 1),
(347, 21, 'WLG', 'Liege', 1),
(348, 21, 'VLI', 'Limburg', 1),
(349, 21, 'WLX', 'Luxembourg', 1),
(350, 21, 'WNA', 'Namur', 1),
(351, 21, 'VOV', 'Oost-Vlaanderen', 1),
(352, 21, 'VBR', 'Vlaams Brabant', 1),
(353, 21, 'VWV', 'West-Vlaanderen', 1),
(354, 22, 'BZ', 'Belize', 1),
(355, 22, 'CY', 'Cayo', 1),
(356, 22, 'CR', 'Corozal', 1),
(357, 22, 'OW', 'Orange Walk', 1),
(358, 22, 'SC', 'Stann Creek', 1),
(359, 22, 'TO', 'Toledo', 1),
(360, 23, 'AL', 'Alibori', 1),
(361, 23, 'AK', 'Atakora', 1),
(362, 23, 'AQ', 'Atlantique', 1),
(363, 23, 'BO', 'Borgou', 1),
(364, 23, 'CO', 'Collines', 1),
(365, 23, 'DO', 'Donga', 1),
(366, 23, 'KO', 'Kouffo', 1),
(367, 23, 'LI', 'Littoral', 1),
(368, 23, 'MO', 'Mono', 1),
(369, 23, 'OU', 'Oueme', 1),
(370, 23, 'PL', 'Plateau', 1),
(371, 23, 'ZO', 'Zou', 1),
(372, 24, 'DS', 'Devonshire', 1),
(373, 24, 'HC', 'Hamilton City', 1),
(374, 24, 'HA', 'Hamilton', 1),
(375, 24, 'PG', 'Paget', 1),
(376, 24, 'PB', 'Pembroke', 1),
(377, 24, 'GC', 'Saint George City', 1),
(378, 24, 'SG', 'Saint George&#039;s', 1),
(379, 24, 'SA', 'Sandys', 1),
(380, 24, 'SM', 'Smith&#039;s', 1),
(381, 24, 'SH', 'Southampton', 1),
(382, 24, 'WA', 'Warwick', 1),
(383, 25, 'BUM', 'Bumthang', 1),
(384, 25, 'CHU', 'Chukha', 1),
(385, 25, 'DAG', 'Dagana', 1),
(386, 25, 'GAS', 'Gasa', 1),
(387, 25, 'HAA', 'Haa', 1),
(388, 25, 'LHU', 'Lhuntse', 1),
(389, 25, 'MON', 'Mongar', 1),
(390, 25, 'PAR', 'Paro', 1),
(391, 25, 'PEM', 'Pemagatshel', 1),
(392, 25, 'PUN', 'Punakha', 1),
(393, 25, 'SJO', 'Samdrup Jongkhar', 1),
(394, 25, 'SAT', 'Samtse', 1),
(395, 25, 'SAR', 'Sarpang', 1),
(396, 25, 'THI', 'Thimphu', 1),
(397, 25, 'TRG', 'Trashigang', 1),
(398, 25, 'TRY', 'Trashiyangste', 1),
(399, 25, 'TRO', 'Trongsa', 1),
(400, 25, 'TSI', 'Tsirang', 1),
(401, 25, 'WPH', 'Wangdue Phodrang', 1),
(402, 25, 'ZHE', 'Zhemgang', 1),
(403, 26, 'BEN', 'Beni', 1),
(404, 26, 'CHU', 'Chuquisaca', 1),
(405, 26, 'COC', 'Cochabamba', 1),
(406, 26, 'LPZ', 'La Paz', 1),
(407, 26, 'ORU', 'Oruro', 1),
(408, 26, 'PAN', 'Pando', 1),
(409, 26, 'POT', 'Potosi', 1),
(410, 26, 'SCZ', 'Santa Cruz', 1),
(411, 26, 'TAR', 'Tarija', 1),
(412, 27, 'BRO', 'Brcko district', 1),
(413, 27, 'FUS', 'Unsko-Sanski Kanton', 1),
(414, 27, 'FPO', 'Posavski Kanton', 1),
(415, 27, 'FTU', 'Tuzlanski Kanton', 1),
(416, 27, 'FZE', 'Zenicko-Dobojski Kanton', 1),
(417, 27, 'FBP', 'Bosanskopodrinjski Kanton', 1),
(418, 27, 'FSB', 'Srednjebosanski Kanton', 1),
(419, 27, 'FHN', 'Hercegovacko-neretvanski Kanton', 1),
(420, 27, 'FZH', 'Zapadnohercegovacka Zupanija', 1),
(421, 27, 'FSA', 'Kanton Sarajevo', 1),
(422, 27, 'FZA', 'Zapadnobosanska', 1),
(423, 27, 'SBL', 'Banja Luka', 1),
(424, 27, 'SDO', 'Doboj', 1),
(425, 27, 'SBI', 'Bijeljina', 1),
(426, 27, 'SVL', 'Vlasenica', 1),
(427, 27, 'SSR', 'Sarajevo-Romanija or Sokolac', 1),
(428, 27, 'SFO', 'Foca', 1),
(429, 27, 'STR', 'Trebinje', 1),
(430, 28, 'CE', 'Central', 1),
(431, 28, 'GH', 'Ghanzi', 1),
(432, 28, 'KD', 'Kgalagadi', 1),
(433, 28, 'KT', 'Kgatleng', 1),
(434, 28, 'KW', 'Kweneng', 1),
(435, 28, 'NG', 'Ngamiland', 1),
(436, 28, 'NE', 'North East', 1),
(437, 28, 'NW', 'North West', 1),
(438, 28, 'SE', 'South East', 1),
(439, 28, 'SO', 'Southern', 1),
(440, 30, 'AC', 'Acre', 1),
(441, 30, 'AL', 'Alagoas', 1),
(442, 30, 'AP', 'Amapa', 1),
(443, 30, 'AM', 'Amazonas', 1),
(444, 30, 'BA', 'Bahia', 1),
(445, 30, 'CE', 'Ceara', 1),
(446, 30, 'DF', 'Distrito Federal', 1),
(447, 30, 'ES', 'Espirito Santo', 1),
(448, 30, 'GO', 'Goias', 1),
(449, 30, 'MA', 'Maranhao', 1),
(450, 30, 'MT', 'Mato Grosso', 1),
(451, 30, 'MS', 'Mato Grosso do Sul', 1),
(452, 30, 'MG', 'Minas Gerais', 1),
(453, 30, 'PA', 'Para', 1),
(454, 30, 'PB', 'Paraiba', 1),
(455, 30, 'PR', 'Parana', 1),
(456, 30, 'PE', 'Pernambuco', 1),
(457, 30, 'PI', 'Piaui', 1),
(458, 30, 'RJ', 'Rio de Janeiro', 1),
(459, 30, 'RN', 'Rio Grande do Norte', 1),
(460, 30, 'RS', 'Rio Grande do Sul', 1),
(461, 30, 'RO', 'Rondonia', 1),
(462, 30, 'RR', 'Roraima', 1),
(463, 30, 'SC', 'Santa Catarina', 1),
(464, 30, 'SP', 'Sao Paulo', 1),
(465, 30, 'SE', 'Sergipe', 1),
(466, 30, 'TO', 'Tocantins', 1),
(467, 31, 'PB', 'Peros Banhos', 1),
(468, 31, 'SI', 'Salomon Islands', 1),
(469, 31, 'NI', 'Nelsons Island', 1),
(470, 31, 'TB', 'Three Brothers', 1),
(471, 31, 'EA', 'Eagle Islands', 1),
(472, 31, 'DI', 'Danger Island', 1),
(473, 31, 'EG', 'Egmont Islands', 1),
(474, 31, 'DG', 'Diego Garcia', 1),
(475, 32, 'BEL', 'Belait', 1),
(476, 32, 'BRM', 'Brunei and Muara', 1),
(477, 32, 'TEM', 'Temburong', 1),
(478, 32, 'TUT', 'Tutong', 1),
(479, 33, '', 'Blagoevgrad', 1),
(480, 33, '', 'Burgas', 1),
(481, 33, '', 'Dobrich', 1),
(482, 33, '', 'Gabrovo', 1),
(483, 33, '', 'Haskovo', 1),
(484, 33, '', 'Kardjali', 1),
(485, 33, '', 'Kyustendil', 1),
(486, 33, '', 'Lovech', 1),
(487, 33, '', 'Montana', 1),
(488, 33, '', 'Pazardjik', 1),
(489, 33, '', 'Pernik', 1),
(490, 33, '', 'Pleven', 1),
(491, 33, '', 'Plovdiv', 1),
(492, 33, '', 'Razgrad', 1),
(493, 33, '', 'Shumen', 1),
(494, 33, '', 'Silistra', 1),
(495, 33, '', 'Sliven', 1),
(496, 33, '', 'Smolyan', 1),
(497, 33, '', 'Sofia', 1),
(498, 33, '', 'Sofia - town', 1),
(499, 33, '', 'Stara Zagora', 1),
(500, 33, '', 'Targovishte', 1),
(501, 33, '', 'Varna', 1),
(502, 33, '', 'Veliko Tarnovo', 1),
(503, 33, '', 'Vidin', 1),
(504, 33, '', 'Vratza', 1),
(505, 33, '', 'Yambol', 1),
(506, 34, 'BAL', 'Bale', 1),
(507, 34, 'BAM', 'Bam', 1),
(508, 34, 'BAN', 'Banwa', 1),
(509, 34, 'BAZ', 'Bazega', 1),
(510, 34, 'BOR', 'Bougouriba', 1),
(511, 34, 'BLG', 'Boulgou', 1),
(512, 34, 'BOK', 'Boulkiemde', 1),
(513, 34, 'COM', 'Comoe', 1),
(514, 34, 'GAN', 'Ganzourgou', 1),
(515, 34, 'GNA', 'Gnagna', 1),
(516, 34, 'GOU', 'Gourma', 1),
(517, 34, 'HOU', 'Houet', 1),
(518, 34, 'IOA', 'Ioba', 1),
(519, 34, 'KAD', 'Kadiogo', 1),
(520, 34, 'KEN', 'Kenedougou', 1),
(521, 34, 'KOD', 'Komondjari', 1),
(522, 34, 'KOP', 'Kompienga', 1),
(523, 34, 'KOS', 'Kossi', 1),
(524, 34, 'KOL', 'Koulpelogo', 1),
(525, 34, 'KOT', 'Kouritenga', 1),
(526, 34, 'KOW', 'Kourweogo', 1),
(527, 34, 'LER', 'Leraba', 1),
(528, 34, 'LOR', 'Loroum', 1),
(529, 34, 'MOU', 'Mouhoun', 1),
(530, 34, 'NAH', 'Nahouri', 1),
(531, 34, 'NAM', 'Namentenga', 1),
(532, 34, 'NAY', 'Nayala', 1),
(533, 34, 'NOU', 'Noumbiel', 1),
(534, 34, 'OUB', 'Oubritenga', 1),
(535, 34, 'OUD', 'Oudalan', 1),
(536, 34, 'PAS', 'Passore', 1),
(537, 34, 'PON', 'Poni', 1),
(538, 34, 'SAG', 'Sanguie', 1),
(539, 34, 'SAM', 'Sanmatenga', 1),
(540, 34, 'SEN', 'Seno', 1),
(541, 34, 'SIS', 'Sissili', 1),
(542, 34, 'SOM', 'Soum', 1),
(543, 34, 'SOR', 'Sourou', 1),
(544, 34, 'TAP', 'Tapoa', 1),
(545, 34, 'TUY', 'Tuy', 1),
(546, 34, 'YAG', 'Yagha', 1),
(547, 34, 'YAT', 'Yatenga', 1),
(548, 34, 'ZIR', 'Ziro', 1),
(549, 34, 'ZOD', 'Zondoma', 1),
(550, 34, 'ZOW', 'Zoundweogo', 1),
(551, 35, 'BB', 'Bubanza', 1),
(552, 35, 'BJ', 'Bujumbura', 1),
(553, 35, 'BR', 'Bururi', 1),
(554, 35, 'CA', 'Cankuzo', 1),
(555, 35, 'CI', 'Cibitoke', 1),
(556, 35, 'GI', 'Gitega', 1),
(557, 35, 'KR', 'Karuzi', 1),
(558, 35, 'KY', 'Kayanza', 1),
(559, 35, 'KI', 'Kirundo', 1),
(560, 35, 'MA', 'Makamba', 1),
(561, 35, 'MU', 'Muramvya', 1),
(562, 35, 'MY', 'Muyinga', 1),
(563, 35, 'MW', 'Mwaro', 1),
(564, 35, 'NG', 'Ngozi', 1),
(565, 35, 'RT', 'Rutana', 1),
(566, 35, 'RY', 'Ruyigi', 1),
(567, 36, 'PP', 'Phnom Penh', 1),
(568, 36, 'PS', 'Preah Seihanu (Kompong Som)', 1),
(569, 36, 'PA', 'Pailin', 1),
(570, 36, 'KB', 'Keb', 1),
(571, 36, 'BM', 'Banteay Meanchey', 1),
(572, 36, 'BA', 'Battambang', 1),
(573, 36, 'KM', 'Kampong Cham', 1),
(574, 36, 'KN', 'Kampong Chhnang', 1),
(575, 36, 'KU', 'Kampong Speu', 1),
(576, 36, 'KO', 'Kampong Som', 1),
(577, 36, 'KT', 'Kampong Thom', 1),
(578, 36, 'KP', 'Kampot', 1),
(579, 36, 'KL', 'Kandal', 1),
(580, 36, 'KK', 'Kaoh Kong', 1),
(581, 36, 'KR', 'Kratie', 1),
(582, 36, 'MK', 'Mondul Kiri', 1),
(583, 36, 'OM', 'Oddar Meancheay', 1),
(584, 36, 'PU', 'Pursat', 1),
(585, 36, 'PR', 'Preah Vihear', 1),
(586, 36, 'PG', 'Prey Veng', 1),
(587, 36, 'RK', 'Ratanak Kiri', 1),
(588, 36, 'SI', 'Siemreap', 1),
(589, 36, 'ST', 'Stung Treng', 1),
(590, 36, 'SR', 'Svay Rieng', 1),
(591, 36, 'TK', 'Takeo', 1),
(592, 37, 'ADA', 'Adamawa (Adamaoua)', 1),
(593, 37, 'CEN', 'Centre', 1),
(594, 37, 'EST', 'East (Est)', 1),
(595, 37, 'EXN', 'Extreme North (Extreme-Nord)', 1),
(596, 37, 'LIT', 'Littoral', 1),
(597, 37, 'NOR', 'North (Nord)', 1),
(598, 37, 'NOT', 'Northwest (Nord-Ouest)', 1),
(599, 37, 'OUE', 'West (Ouest)', 1),
(600, 37, 'SUD', 'South (Sud)', 1),
(601, 37, 'SOU', 'Southwest (Sud-Ouest).', 1),
(602, 38, 'AB', 'Alberta', 1),
(603, 38, 'BC', 'British Columbia', 1),
(604, 38, 'MB', 'Manitoba', 1),
(605, 38, 'NB', 'New Brunswick', 1),
(606, 38, 'NL', 'Newfoundland and Labrador', 1),
(607, 38, 'NT', 'Northwest Territories', 1),
(608, 38, 'NS', 'Nova Scotia', 1),
(609, 38, 'NU', 'Nunavut', 1),
(610, 38, 'ON', 'Ontario', 1),
(611, 38, 'PE', 'Prince Edward Island', 1),
(612, 38, 'QC', 'Québec', 1),
(613, 38, 'SK', 'Saskatchewan', 1),
(614, 38, 'YT', 'Yukon Territory', 1),
(615, 39, 'BV', 'Boa Vista', 1),
(616, 39, 'BR', 'Brava', 1),
(617, 39, 'CS', 'Calheta de Sao Miguel', 1),
(618, 39, 'MA', 'Maio', 1),
(619, 39, 'MO', 'Mosteiros', 1),
(620, 39, 'PA', 'Paul', 1),
(621, 39, 'PN', 'Porto Novo', 1),
(622, 39, 'PR', 'Praia', 1),
(623, 39, 'RG', 'Ribeira Grande', 1),
(624, 39, 'SL', 'Sal', 1),
(625, 39, 'CA', 'Santa Catarina', 1),
(626, 39, 'CR', 'Santa Cruz', 1),
(627, 39, 'SD', 'Sao Domingos', 1),
(628, 39, 'SF', 'Sao Filipe', 1),
(629, 39, 'SN', 'Sao Nicolau', 1),
(630, 39, 'SV', 'Sao Vicente', 1),
(631, 39, 'TA', 'Tarrafal', 1),
(632, 40, 'CR', 'Creek', 1),
(633, 40, 'EA', 'Eastern', 1),
(634, 40, 'ML', 'Midland', 1),
(635, 40, 'ST', 'South Town', 1),
(636, 40, 'SP', 'Spot Bay', 1),
(637, 40, 'SK', 'Stake Bay', 1),
(638, 40, 'WD', 'West End', 1),
(639, 40, 'WN', 'Western', 1),
(640, 41, 'BBA', 'Bamingui-Bangoran', 1),
(641, 41, 'BKO', 'Basse-Kotto', 1),
(642, 41, 'HKO', 'Haute-Kotto', 1),
(643, 41, 'HMB', 'Haut-Mbomou', 1),
(644, 41, 'KEM', 'Kemo', 1),
(645, 41, 'LOB', 'Lobaye', 1),
(646, 41, 'MKD', 'Mambére-Kadé&#239;', 1),
(647, 41, 'MBO', 'Mbomou', 1),
(648, 41, 'NMM', 'Nana-Mambere', 1),
(649, 41, 'OMP', 'Ombella-M&#039;Poko', 1),
(650, 41, 'OUK', 'Ouaka', 1),
(651, 41, 'OUH', 'Ouham', 1),
(652, 41, 'OPE', 'Ouham-Pende', 1),
(653, 41, 'VAK', 'Vakaga', 1),
(654, 41, 'NGR', 'Nana-Grebizi', 1),
(655, 41, 'SMB', 'Sangha-Mbaere', 1),
(656, 41, 'BAN', 'Bangui', 1),
(657, 42, 'BA', 'Batha', 1),
(658, 42, 'BI', 'Biltine', 1),
(659, 42, 'BE', 'Borkou-Ennedi-Tibesti', 1),
(660, 42, 'CB', 'Chari-Baguirmi', 1),
(661, 42, 'GU', 'Guera', 1),
(662, 42, 'KA', 'Kanem', 1),
(663, 42, 'LA', 'Lac', 1),
(664, 42, 'LC', 'Logone Occidental', 1),
(665, 42, 'LR', 'Logone Oriental', 1),
(666, 42, 'MK', 'Mayo-Kebbi', 1),
(667, 42, 'MC', 'Moyen-Chari', 1),
(668, 42, 'OU', 'Ouaddai', 1),
(669, 42, 'SA', 'Salamat', 1),
(670, 42, 'TA', 'Tandjile', 1),
(671, 43, 'AI', 'Aisen del General Carlos Ibanez', 1),
(672, 43, 'AN', 'Antofagasta', 1),
(673, 43, 'AR', 'Araucania', 1),
(674, 43, 'AT', 'Atacama', 1),
(675, 43, 'BI', 'Bio-Bio', 1),
(676, 43, 'CO', 'Coquimbo', 1),
(677, 43, 'LI', 'O&#039;Higgins', 1),
(678, 43, 'LL', 'Los Lagos', 1),
(679, 43, 'MA', 'Magallanes', 1),
(680, 43, 'ML', 'Maule', 1),
(681, 43, 'RM', 'Region Metropolitana', 1),
(682, 43, 'TA', 'Tarapaca', 1),
(683, 43, 'VS', 'Valparaiso', 1),
(684, 44, 'AN', 'Anhui', 1),
(685, 44, 'BE', 'Beijing', 1),
(686, 44, 'CH', 'Chongqing', 1),
(687, 44, 'FU', 'Fujian', 1),
(688, 44, 'GA', 'Gansu', 1),
(689, 44, 'GU', 'Guangdong', 1),
(690, 44, 'GX', 'Guangxi', 1),
(691, 44, 'GZ', 'Guizhou', 1),
(692, 44, 'HA', 'Hainan', 1),
(693, 44, 'HB', 'Hebei', 1),
(694, 44, 'HL', 'Heilongjiang', 1),
(695, 44, 'HE', 'Henan', 1),
(696, 44, 'HK', 'Hong Kong', 1),
(697, 44, 'HU', 'Hubei', 1),
(698, 44, 'HN', 'Hunan', 1),
(699, 44, 'IM', 'Inner Mongolia', 1),
(700, 44, 'JI', 'Jiangsu', 1),
(701, 44, 'JX', 'Jiangxi', 1),
(702, 44, 'JL', 'Jilin', 1),
(703, 44, 'LI', 'Liaoning', 1),
(704, 44, 'MA', 'Macau', 1),
(705, 44, 'NI', 'Ningxia', 1),
(706, 44, 'SH', 'Shaanxi', 1),
(707, 44, 'SA', 'Shandong', 1),
(708, 44, 'SG', 'Shanghai', 1),
(709, 44, 'SX', 'Shanxi', 1),
(710, 44, 'SI', 'Sichuan', 1),
(711, 44, 'TI', 'Tianjin', 1),
(712, 44, 'XI', 'Xinjiang', 1),
(713, 44, 'YU', 'Yunnan', 1),
(714, 44, 'ZH', 'Zhejiang', 1),
(715, 46, 'D', 'Direction Island', 1),
(716, 46, 'H', 'Home Island', 1),
(717, 46, 'O', 'Horsburgh Island', 1),
(718, 46, 'S', 'South Island', 1),
(719, 46, 'W', 'West Island', 1),
(720, 47, 'AMZ', 'Amazonas', 1),
(721, 47, 'ANT', 'Antioquia', 1),
(722, 47, 'ARA', 'Arauca', 1),
(723, 47, 'ATL', 'Atlantico', 1),
(724, 47, 'BDC', 'Bogota D.C.', 1),
(725, 47, 'BOL', 'Bolivar', 1),
(726, 47, 'BOY', 'Boyaca', 1),
(727, 47, 'CAL', 'Caldas', 1),
(728, 47, 'CAQ', 'Caqueta', 1),
(729, 47, 'CAS', 'Casanare', 1),
(730, 47, 'CAU', 'Cauca', 1),
(731, 47, 'CES', 'Cesar', 1),
(732, 47, 'CHO', 'Choco', 1),
(733, 47, 'COR', 'Cordoba', 1),
(734, 47, 'CAM', 'Cundinamarca', 1),
(735, 47, 'GNA', 'Guainia', 1),
(736, 47, 'GJR', 'Guajira', 1),
(737, 47, 'GVR', 'Guaviare', 1),
(738, 47, 'HUI', 'Huila', 1),
(739, 47, 'MAG', 'Magdalena', 1),
(740, 47, 'MET', 'Meta', 1),
(741, 47, 'NAR', 'Narino', 1),
(742, 47, 'NDS', 'Norte de Santander', 1),
(743, 47, 'PUT', 'Putumayo', 1),
(744, 47, 'QUI', 'Quindio', 1),
(745, 47, 'RIS', 'Risaralda', 1),
(746, 47, 'SAP', 'San Andres y Providencia', 1),
(747, 47, 'SAN', 'Santander', 1),
(748, 47, 'SUC', 'Sucre', 1),
(749, 47, 'TOL', 'Tolima', 1),
(750, 47, 'VDC', 'Valle del Cauca', 1),
(751, 47, 'VAU', 'Vaupes', 1),
(752, 47, 'VIC', 'Vichada', 1),
(753, 48, 'G', 'Grande Comore', 1),
(754, 48, 'A', 'Anjouan', 1),
(755, 48, 'M', 'Moheli', 1),
(756, 49, 'BO', 'Bouenza', 1),
(757, 49, 'BR', 'Brazzaville', 1),
(758, 49, 'CU', 'Cuvette', 1),
(759, 49, 'CO', 'Cuvette-Ouest', 1),
(760, 49, 'KO', 'Kouilou', 1),
(761, 49, 'LE', 'Lekoumou', 1),
(762, 49, 'LI', 'Likouala', 1),
(763, 49, 'NI', 'Niari', 1),
(764, 49, 'PL', 'Plateaux', 1),
(765, 49, 'PO', 'Pool', 1),
(766, 49, 'SA', 'Sangha', 1),
(767, 50, 'PU', 'Pukapuka', 1),
(768, 50, 'RK', 'Rakahanga', 1),
(769, 50, 'MK', 'Manihiki', 1),
(770, 50, 'PE', 'Penrhyn', 1),
(771, 50, 'NI', 'Nassau Island', 1),
(772, 50, 'SU', 'Surwarrow', 1),
(773, 50, 'PA', 'Palmerston', 1),
(774, 50, 'AI', 'Aitutaki', 1),
(775, 50, 'MA', 'Manuae', 1),
(776, 50, 'TA', 'Takutea', 1),
(777, 50, 'MT', 'Mitiaro', 1),
(778, 50, 'AT', 'Atiu', 1),
(779, 50, 'MU', 'Mauke', 1),
(780, 50, 'RR', 'Rarotonga', 1),
(781, 50, 'MG', 'Mangaia', 1),
(782, 51, 'AL', 'Alajuela', 1),
(783, 51, 'CA', 'Cartago', 1),
(784, 51, 'GU', 'Guanacaste', 1),
(785, 51, 'HE', 'Heredia', 1),
(786, 51, 'LI', 'Limon', 1),
(787, 51, 'PU', 'Puntarenas', 1),
(788, 51, 'SJ', 'San Jose', 1),
(789, 52, 'ABE', 'Abengourou', 1),
(790, 52, 'ABI', 'Abidjan', 1),
(791, 52, 'ABO', 'Aboisso', 1),
(792, 52, 'ADI', 'Adiake', 1),
(793, 52, 'ADZ', 'Adzope', 1),
(794, 52, 'AGB', 'Agboville', 1),
(795, 52, 'AGN', 'Agnibilekrou', 1),
(796, 52, 'ALE', 'Alepe', 1),
(797, 52, 'BOC', 'Bocanda', 1),
(798, 52, 'BAN', 'Bangolo', 1),
(799, 52, 'BEO', 'Beoumi', 1),
(800, 52, 'BIA', 'Biankouma', 1),
(801, 52, 'BDK', 'Bondoukou', 1),
(802, 52, 'BGN', 'Bongouanou', 1),
(803, 52, 'BFL', 'Bouafle', 1),
(804, 52, 'BKE', 'Bouake', 1),
(805, 52, 'BNA', 'Bouna', 1),
(806, 52, 'BDL', 'Boundiali', 1),
(807, 52, 'DKL', 'Dabakala', 1),
(808, 52, 'DBU', 'Dabou', 1),
(809, 52, 'DAL', 'Daloa', 1),
(810, 52, 'DAN', 'Danane', 1),
(811, 52, 'DAO', 'Daoukro', 1),
(812, 52, 'DIM', 'Dimbokro', 1),
(813, 52, 'DIV', 'Divo', 1),
(814, 52, 'DUE', 'Duekoue', 1),
(815, 52, 'FER', 'Ferkessedougou', 1),
(816, 52, 'GAG', 'Gagnoa', 1),
(817, 52, 'GBA', 'Grand-Bassam', 1),
(818, 52, 'GLA', 'Grand-Lahou', 1),
(819, 52, 'GUI', 'Guiglo', 1),
(820, 52, 'ISS', 'Issia', 1),
(821, 52, 'JAC', 'Jacqueville', 1),
(822, 52, 'KAT', 'Katiola', 1),
(823, 52, 'KOR', 'Korhogo', 1),
(824, 52, 'LAK', 'Lakota', 1),
(825, 52, 'MAN', 'Man', 1),
(826, 52, 'MKN', 'Mankono', 1),
(827, 52, 'MBA', 'Mbahiakro', 1),
(828, 52, 'ODI', 'Odienne', 1),
(829, 52, 'OUM', 'Oume', 1),
(830, 52, 'SAK', 'Sakassou', 1),
(831, 52, 'SPE', 'San-Pedro', 1),
(832, 52, 'SAS', 'Sassandra', 1),
(833, 52, 'SEG', 'Seguela', 1),
(834, 52, 'SIN', 'Sinfra', 1),
(835, 52, 'SOU', 'Soubre', 1),
(836, 52, 'TAB', 'Tabou', 1),
(837, 52, 'TAN', 'Tanda', 1),
(838, 52, 'TIE', 'Tiebissou', 1),
(839, 52, 'TIN', 'Tingrela', 1),
(840, 52, 'TIA', 'Tiassale', 1),
(841, 52, 'TBA', 'Touba', 1),
(842, 52, 'TLP', 'Toulepleu', 1),
(843, 52, 'TMD', 'Toumodi', 1),
(844, 52, 'VAV', 'Vavoua', 1),
(845, 52, 'YAM', 'Yamoussoukro', 1),
(846, 52, 'ZUE', 'Zuenoula', 1),
(847, 53, 'BB', 'Bjelovar-Bilogora', 1),
(848, 53, 'CZ', 'City of Zagreb', 1),
(849, 53, 'DN', 'Dubrovnik-Neretva', 1),
(850, 53, 'IS', 'Istra', 1),
(851, 53, 'KA', 'Karlovac', 1),
(852, 53, 'KK', 'Koprivnica-Krizevci', 1),
(853, 53, 'KZ', 'Krapina-Zagorje', 1),
(854, 53, 'LS', 'Lika-Senj', 1),
(855, 53, 'ME', 'Medimurje', 1),
(856, 53, 'OB', 'Osijek-Baranja', 1),
(857, 53, 'PS', 'Pozega-Slavonia', 1),
(858, 53, 'PG', 'Primorje-Gorski Kotar', 1),
(859, 53, 'SI', 'Sibenik', 1),
(860, 53, 'SM', 'Sisak-Moslavina', 1),
(861, 53, 'SB', 'Slavonski Brod-Posavina', 1),
(862, 53, 'SD', 'Split-Dalmatia', 1),
(863, 53, 'VA', 'Varazdin', 1),
(864, 53, 'VP', 'Virovitica-Podravina', 1),
(865, 53, 'VS', 'Vukovar-Srijem', 1),
(866, 53, 'ZK', 'Zadar-Knin', 1),
(867, 53, 'ZA', 'Zagreb', 1),
(868, 54, 'CA', 'Camaguey', 1),
(869, 54, 'CD', 'Ciego de Avila', 1),
(870, 54, 'CI', 'Cienfuegos', 1),
(871, 54, 'CH', 'Ciudad de La Habana', 1),
(872, 54, 'GR', 'Granma', 1),
(873, 54, 'GU', 'Guantanamo', 1),
(874, 54, 'HO', 'Holguin', 1),
(875, 54, 'IJ', 'Isla de la Juventud', 1),
(876, 54, 'LH', 'La Habana', 1),
(877, 54, 'LT', 'Las Tunas', 1),
(878, 54, 'MA', 'Matanzas', 1),
(879, 54, 'PR', 'Pinar del Rio', 1),
(880, 54, 'SS', 'Sancti Spiritus', 1),
(881, 54, 'SC', 'Santiago de Cuba', 1),
(882, 54, 'VC', 'Villa Clara', 1),
(883, 55, 'F', 'Famagusta', 1),
(884, 55, 'K', 'Kyrenia', 1),
(885, 55, 'A', 'Larnaca', 1),
(886, 55, 'I', 'Limassol', 1),
(887, 55, 'N', 'Nicosia', 1),
(888, 55, 'P', 'Paphos', 1),
(889, 56, 'U', 'Ustecky', 1),
(890, 56, 'C', 'Jihocesky', 1),
(891, 56, 'B', 'Jihomoravsky', 1),
(892, 56, 'K', 'Karlovarsky', 1),
(893, 56, 'H', 'Kralovehradecky', 1),
(894, 56, 'L', 'Liberecky', 1),
(895, 56, 'T', 'Moravskoslezsky', 1),
(896, 56, 'M', 'Olomoucky', 1),
(897, 56, 'E', 'Pardubicky', 1),
(898, 56, 'P', 'Plzensky', 1),
(899, 56, 'A', 'Praha', 1),
(900, 56, 'S', 'Stredocesky', 1),
(901, 56, 'J', 'Vysocina', 1),
(902, 56, 'Z', 'Zlinsky', 1),
(903, 57, 'AR', 'Arhus', 1),
(904, 57, 'BH', 'Bornholm', 1),
(905, 57, 'CO', 'Copenhagen', 1),
(906, 57, 'FO', 'Faroe Islands', 1),
(907, 57, 'FR', 'Frederiksborg', 1),
(908, 57, 'FY', 'Fyn', 1),
(909, 57, 'KO', 'Kobenhavn', 1),
(910, 57, 'NO', 'Nordjylland', 1),
(911, 57, 'RI', 'Ribe', 1),
(912, 57, 'RK', 'Ringkobing', 1),
(913, 57, 'RO', 'Roskilde', 1),
(914, 57, 'SO', 'Sonderjylland', 1),
(915, 57, 'ST', 'Storstrom', 1),
(916, 57, 'VK', 'Vejle', 1),
(917, 57, 'VJ', 'Vestj&#230;lland', 1),
(918, 57, 'VB', 'Viborg', 1),
(919, 58, 'S', '&#039;Ali Sabih', 1),
(920, 58, 'K', 'Dikhil', 1),
(921, 58, 'J', 'Djibouti', 1),
(922, 58, 'O', 'Obock', 1),
(923, 58, 'T', 'Tadjoura', 1),
(924, 59, 'AND', 'Saint Andrew Parish', 1),
(925, 59, 'DAV', 'Saint David Parish', 1),
(926, 59, 'GEO', 'Saint George Parish', 1),
(927, 59, 'JOH', 'Saint John Parish', 1),
(928, 59, 'JOS', 'Saint Joseph Parish', 1),
(929, 59, 'LUK', 'Saint Luke Parish', 1),
(930, 59, 'MAR', 'Saint Mark Parish', 1),
(931, 59, 'PAT', 'Saint Patrick Parish', 1),
(932, 59, 'PAU', 'Saint Paul Parish', 1),
(933, 59, 'PET', 'Saint Peter Parish', 1),
(934, 60, 'DN', 'Distrito Nacional', 1),
(935, 60, 'AZ', 'Azua', 1),
(936, 60, 'BC', 'Baoruco', 1),
(937, 60, 'BH', 'Barahona', 1),
(938, 60, 'DJ', 'Dajabon', 1),
(939, 60, 'DU', 'Duarte', 1),
(940, 60, 'EL', 'Elias Pina', 1),
(941, 60, 'SY', 'El Seybo', 1),
(942, 60, 'ET', 'Espaillat', 1),
(943, 60, 'HM', 'Hato Mayor', 1),
(944, 60, 'IN', 'Independencia', 1),
(945, 60, 'AL', 'La Altagracia', 1),
(946, 60, 'RO', 'La Romana', 1),
(947, 60, 'VE', 'La Vega', 1),
(948, 60, 'MT', 'Maria Trinidad Sanchez', 1),
(949, 60, 'MN', 'Monsenor Nouel', 1),
(950, 60, 'MC', 'Monte Cristi', 1),
(951, 60, 'MP', 'Monte Plata', 1),
(952, 60, 'PD', 'Pedernales', 1),
(953, 60, 'PR', 'Peravia (Bani)', 1),
(954, 60, 'PP', 'Puerto Plata', 1),
(955, 60, 'SL', 'Salcedo', 1),
(956, 60, 'SM', 'Samana', 1),
(957, 60, 'SH', 'Sanchez Ramirez', 1),
(958, 60, 'SC', 'San Cristobal', 1),
(959, 60, 'JO', 'San Jose de Ocoa', 1),
(960, 60, 'SJ', 'San Juan', 1),
(961, 60, 'PM', 'San Pedro de Macoris', 1),
(962, 60, 'SA', 'Santiago', 1),
(963, 60, 'ST', 'Santiago Rodriguez', 1),
(964, 60, 'SD', 'Santo Domingo', 1),
(965, 60, 'VA', 'Valverde', 1),
(966, 61, 'AL', 'Aileu', 1),
(967, 61, 'AN', 'Ainaro', 1),
(968, 61, 'BA', 'Baucau', 1),
(969, 61, 'BO', 'Bobonaro', 1),
(970, 61, 'CO', 'Cova Lima', 1),
(971, 61, 'DI', 'Dili', 1),
(972, 61, 'ER', 'Ermera', 1),
(973, 61, 'LA', 'Lautem', 1),
(974, 61, 'LI', 'Liquica', 1),
(975, 61, 'MT', 'Manatuto', 1),
(976, 61, 'MF', 'Manufahi', 1),
(977, 61, 'OE', 'Oecussi', 1),
(978, 61, 'VI', 'Viqueque', 1),
(979, 62, 'AZU', 'Azuay', 1),
(980, 62, 'BOL', 'Bolivar', 1),
(981, 62, 'CAN', 'Ca&#241;ar', 1),
(982, 62, 'CAR', 'Carchi', 1),
(983, 62, 'CHI', 'Chimborazo', 1),
(984, 62, 'COT', 'Cotopaxi', 1),
(985, 62, 'EOR', 'El Oro', 1),
(986, 62, 'ESM', 'Esmeraldas', 1),
(987, 62, 'GPS', 'Galápagos', 1),
(988, 62, 'GUA', 'Guayas', 1),
(989, 62, 'IMB', 'Imbabura', 1),
(990, 62, 'LOJ', 'Loja', 1),
(991, 62, 'LRO', 'Los Rios', 1),
(992, 62, 'MAN', 'Manabí', 1),
(993, 62, 'MSA', 'Morona Santiago', 1),
(994, 62, 'NAP', 'Napo', 1),
(995, 62, 'ORE', 'Orellana', 1),
(996, 62, 'PAS', 'Pastaza', 1),
(997, 62, 'PIC', 'Pichincha', 1),
(998, 62, 'SUC', 'Sucumbíos', 1),
(999, 62, 'TUN', 'Tungurahua', 1),
(1000, 62, 'ZCH', 'Zamora Chinchipe', 1),
(1001, 63, 'DHY', 'Ad Daqahliyah', 1),
(1002, 63, 'BAM', 'Al Bahr al Ahmar', 1),
(1003, 63, 'BHY', 'Al Buhayrah', 1),
(1004, 63, 'FYM', 'Al Fayyum', 1),
(1005, 63, 'GBY', 'Al Gharbiyah', 1),
(1006, 63, 'IDR', 'Al Iskandariyah', 1),
(1007, 63, 'IML', 'Al Isma&#039;iliyah', 1),
(1008, 63, 'JZH', 'Al Jizah', 1),
(1009, 63, 'MFY', 'Al Minufiyah', 1),
(1010, 63, 'MNY', 'Al Minya', 1),
(1011, 63, 'QHR', 'Al Qahirah', 1),
(1012, 63, 'QLY', 'Al Qalyubiyah', 1),
(1013, 63, 'WJD', 'Al Wadi al Jadid', 1),
(1014, 63, 'SHQ', 'Ash Sharqiyah', 1),
(1015, 63, 'SWY', 'As Suways', 1),
(1016, 63, 'ASW', 'Aswan', 1),
(1017, 63, 'ASY', 'Asyut', 1),
(1018, 63, 'BSW', 'Bani Suwayf', 1),
(1019, 63, 'BSD', 'Bur Sa&#039;id', 1),
(1020, 63, 'DMY', 'Dumyat', 1),
(1021, 63, 'JNS', 'Janub Sina&#039;', 1),
(1022, 63, 'KSH', 'Kafr ash Shaykh', 1),
(1023, 63, 'MAT', 'Matruh', 1),
(1024, 63, 'QIN', 'Qina', 1),
(1025, 63, 'SHS', 'Shamal Sina&#039;', 1),
(1026, 63, 'SUH', 'Suhaj', 1),
(1027, 64, 'AH', 'Ahuachapan', 1),
(1028, 64, 'CA', 'Cabanas', 1),
(1029, 64, 'CH', 'Chalatenango', 1),
(1030, 64, 'CU', 'Cuscatlan', 1),
(1031, 64, 'LB', 'La Libertad', 1),
(1032, 64, 'PZ', 'La Paz', 1),
(1033, 64, 'UN', 'La Union', 1),
(1034, 64, 'MO', 'Morazan', 1),
(1035, 64, 'SM', 'San Miguel', 1),
(1036, 64, 'SS', 'San Salvador', 1),
(1037, 64, 'SV', 'San Vicente', 1),
(1038, 64, 'SA', 'Santa Ana', 1),
(1039, 64, 'SO', 'Sonsonate', 1),
(1040, 64, 'US', 'Usulutan', 1),
(1041, 65, 'AN', 'Provincia Annobon', 1),
(1042, 65, 'BN', 'Provincia Bioko Norte', 1),
(1043, 65, 'BS', 'Provincia Bioko Sur', 1),
(1044, 65, 'CS', 'Provincia Centro Sur', 1),
(1045, 65, 'KN', 'Provincia Kie-Ntem', 1),
(1046, 65, 'LI', 'Provincia Litoral', 1),
(1047, 65, 'WN', 'Provincia Wele-Nzas', 1),
(1048, 66, 'MA', 'Central (Maekel)', 1),
(1049, 66, 'KE', 'Anseba (Keren)', 1),
(1050, 66, 'DK', 'Southern Red Sea (Debub-Keih-Bah', 1),
(1051, 66, 'SK', 'Northern Red Sea (Semien-Keih-Ba', 1),
(1052, 66, 'DE', 'Southern (Debub)', 1),
(1053, 66, 'BR', 'Gash-Barka (Barentu)', 1),
(1054, 67, 'HA', 'Harjumaa (Tallinn)', 1),
(1055, 67, 'HI', 'Hiiumaa (Kardla)', 1),
(1056, 67, 'IV', 'Ida-Virumaa (Johvi)', 1),
(1057, 67, 'JA', 'Jarvamaa (Paide)', 1),
(1058, 67, 'JO', 'Jogevamaa (Jogeva)', 1),
(1059, 67, 'LV', 'Laane-Virumaa (Rakvere)', 1),
(1060, 67, 'LA', 'Laanemaa (Haapsalu)', 1),
(1061, 67, 'PA', 'Parnumaa (Parnu)', 1),
(1062, 67, 'PO', 'Polvamaa (Polva)', 1),
(1063, 67, 'RA', 'Raplamaa (Rapla)', 1),
(1064, 67, 'SA', 'Saaremaa (Kuessaare)', 1),
(1065, 67, 'TA', 'Tartumaa (Tartu)', 1),
(1066, 67, 'VA', 'Valgamaa (Valga)', 1),
(1067, 67, 'VI', 'Viljandimaa (Viljandi)', 1),
(1068, 67, 'VO', 'Vorumaa (Voru)', 1),
(1069, 68, 'AF', 'Afar', 1),
(1070, 68, 'AH', 'Amhara', 1),
(1071, 68, 'BG', 'Benishangul-Gumaz', 1),
(1072, 68, 'GB', 'Gambela', 1),
(1073, 68, 'HR', 'Hariai', 1),
(1074, 68, 'OR', 'Oromia', 1),
(1075, 68, 'SM', 'Somali', 1),
(1076, 68, 'SN', 'Southern Nations - Nationalities', 1),
(1077, 68, 'TG', 'Tigray', 1),
(1078, 68, 'AA', 'Addis Ababa', 1),
(1079, 68, 'DD', 'Dire Dawa', 1),
(1080, 71, 'C', 'Central Division', 1),
(1081, 71, 'N', 'Northern Division', 1),
(1082, 71, 'E', 'Eastern Division', 1),
(1083, 71, 'W', 'Western Division', 1),
(1084, 71, 'R', 'Rotuma', 1),
(1085, 72, 'AL', 'Ahvenanmaan Laani', 1),
(1086, 72, 'ES', 'Etela-Suomen Laani', 1),
(1087, 72, 'IS', 'Ita-Suomen Laani', 1),
(1088, 72, 'LS', 'Lansi-Suomen Laani', 1),
(1089, 72, 'LA', 'Lapin Lanani', 1),
(1090, 72, 'OU', 'Oulun Laani', 1),
(1091, 73, 'FR-A', 'Alsace', 1),
(1092, 73, 'FR-B', 'Aquitaine', 1),
(1093, 73, 'FR-C', 'Auvergne', 1),
(1094, 73, 'FR-P', 'Basse-Normandie', 1),
(1095, 73, 'FR-D', 'Bourgogne', 1),
(1096, 73, 'FR-E', 'Bretagne', 1),
(1097, 73, 'FR-F', 'Centre', 1),
(1098, 73, 'FR-G', 'Champagne-Ardenne', 1),
(1099, 73, 'FR-H', 'Corse', 1),
(1100, 73, 'FR-I', 'Franche-Comté', 1),
(1101, 73, 'FR-Q', 'Haute-Normandie', 1),
(1102, 73, 'FR-J', 'Île-de-France', 1),
(1103, 73, 'FR-K', 'Languedoc-Roussillon', 1),
(1104, 73, 'FR-L', 'Limousin', 1),
(1105, 73, 'FR-M', 'Lorraine', 1),
(1106, 73, 'FR-N', 'Midi-Pyrénées', 1),
(1107, 73, 'FR-O', 'Nord-Pas-de-Calais', 1),
(1108, 73, 'FR-R', 'Pays de la Loire', 1),
(1109, 73, 'FR-S', 'Picardie', 1),
(1110, 73, 'FR-T', 'Poitou-Charentes', 1),
(1111, 73, 'FR-U', 'Provence-Alpes-Côte d&#039;Azur', 1),
(1112, 73, 'FR-V', 'Rhône-Alpes', 1),
(1113, 73, 'FR-GP', 'Guadeloupe', 1),
(1114, 73, 'FR-GF', 'Guyane', 1),
(1115, 73, 'FR-MQ', 'Martinique', 1),
(1116, 73, 'FR-RE', 'Réunion', 1),
(1117, 74, 'FR-01', 'Ain', 1),
(1118, 74, 'FR-02', 'Aisne', 1),
(1119, 74, 'FR-03', 'Allier', 1),
(1120, 74, 'FR-04', 'Alpes de Haute Provence', 1),
(1121, 74, 'FR-05', 'Hautes-Alpes', 1),
(1122, 74, 'FR-06', 'Alpes Maritimes', 1),
(1123, 74, 'FR-07', 'Ard&#232;che', 1),
(1124, 74, 'FR-08', 'Ardennes', 1),
(1125, 74, 'FR-09', 'Ari&#232;ge', 1),
(1126, 74, 'FR-10', 'Aube', 1),
(1127, 74, 'FR-11', 'Aude', 1),
(1128, 74, 'FR-12', 'Aveyron', 1),
(1129, 74, 'FR-13', 'Bouches du Rhône', 1),
(1130, 74, 'FR-14', 'Calvados', 1),
(1131, 74, 'FR-15', 'Cantal', 1),
(1132, 74, 'FR-16', 'Charente', 1),
(1133, 74, 'FR-17', 'Charente Maritime', 1),
(1134, 74, 'FR-18', 'Cher', 1),
(1135, 74, 'FR-19', 'Corr&#232;ze', 1),
(1136, 74, 'FR-2A', 'Corse du Sud', 1),
(1137, 74, 'FR-2B', 'Haute Corse', 1),
(1138, 74, 'FR-21', 'Côte d&#039;or', 1),
(1139, 74, 'FR-22', 'Côtes d&#039;Armor', 1),
(1140, 74, 'FR-23', 'Creuse', 1),
(1141, 74, 'FR-24', 'Dordogne', 1),
(1142, 74, 'FR-25', 'Doubs', 1),
(1143, 74, 'FR-26', 'Drôme', 1),
(1144, 74, 'FR-27', 'Eure', 1),
(1145, 74, 'FR-28', 'Eure et Loir', 1),
(1146, 74, 'FR-29', 'Finist&#232;re', 1),
(1147, 74, 'FR-30', 'Gard', 1),
(1148, 74, 'FR-31', 'Haute Garonne', 1),
(1149, 74, 'FR-32', 'Gers', 1),
(1150, 74, 'FR-33', 'Gironde', 1),
(1151, 74, 'FR-34', 'Hérault', 1),
(1152, 74, 'FR-35', 'Ille et Vilaine', 1),
(1153, 74, 'FR-36', 'Indre', 1),
(1154, 74, 'FR-37', 'Indre et Loire', 1),
(1155, 74, 'FR-38', 'Is&#232;re', 1),
(1156, 74, 'FR-39', 'Jura', 1),
(1157, 74, 'FR-40', 'Landes', 1),
(1158, 74, 'FR-41', 'Loir et Cher', 1),
(1159, 74, 'FR-42', 'Loire', 1),
(1160, 74, 'FR-43', 'Haute Loire', 1),
(1161, 74, 'FR-44', 'Loire Atlantique', 1),
(1162, 74, 'FR-45', 'Loiret', 1),
(1163, 74, 'FR-46', 'Lot', 1),
(1164, 74, 'FR-47', 'Lot et Garonne', 1),
(1165, 74, 'FR-48', 'Loz&#232;re', 1),
(1166, 74, 'FR-49', 'Maine et Loire', 1),
(1167, 74, 'FR-50', 'Manche', 1),
(1168, 74, 'FR-51', 'Marne', 1),
(1169, 74, 'FR-52', 'Haute Marne', 1),
(1170, 74, 'FR-53', 'Mayenne', 1),
(1171, 74, 'FR-54', 'Meurthe et Moselle', 1),
(1172, 74, 'FR-55', 'Meuse', 1),
(1173, 74, 'FR-56', 'Morbihan', 1),
(1174, 74, 'FR-57', 'Moselle', 1),
(1175, 74, 'FR-58', 'Ni&#232;vre', 1),
(1176, 74, 'FR-59', 'Nord', 1),
(1177, 74, 'FR-60', 'Oise', 1),
(1178, 74, 'FR-61', 'Orne', 1),
(1179, 74, 'FR-62', 'Pas de Calais', 1),
(1180, 74, 'FR-63', 'Puy de Dôme', 1),
(1181, 74, 'FR-64', 'Pyrénées Atlantiques', 1),
(1182, 74, 'FR-65', 'Hautes Pyrénées', 1),
(1183, 74, 'FR-66', 'Pyrénées Orientales', 1),
(1184, 74, 'FR-67', 'Bas Rhin', 1),
(1185, 74, 'FR-68', 'Haut Rhin', 1),
(1186, 74, 'FR-69', 'Rhône', 1),
(1187, 74, 'FR-70', 'Haute Saône', 1),
(1188, 74, 'FR-71', 'Saône et Loire', 1),
(1189, 74, 'FR-72', 'Sarthe', 1),
(1190, 74, 'FR-74', 'Savoie', 1),
(1191, 74, 'FR-74', 'Haute Savoie', 1),
(1192, 74, 'FR-75', 'Paris', 1),
(1193, 74, 'FR-76', 'Seine Maritime', 1),
(1194, 74, 'FR-77', 'Seine et Marne', 1),
(1195, 74, 'FR-78', 'Yvelines', 1),
(1196, 74, 'FR-79', 'Deux S&#232;vres', 1),
(1197, 74, 'FR-80', 'Somme', 1),
(1198, 74, 'FR-81', 'Tarn', 1),
(1199, 74, 'FR-82', 'Tarn et Garonne', 1),
(1200, 74, 'FR-83', 'Var', 1),
(1201, 74, 'FR-84', 'Vaucluse', 1),
(1202, 74, 'FR-85', 'Vendée', 1),
(1203, 74, 'FR-86', 'Vienne', 1),
(1204, 74, 'FR-87', 'Haute Vienne', 1),
(1205, 74, 'FR-88', 'Vosges', 1),
(1206, 74, 'FR-89', 'Yonne', 1),
(1207, 74, 'FR-90', 'Territoire de Belfort', 1),
(1208, 74, 'FR-91', 'Essonne', 1),
(1209, 74, 'FR-92', 'Hauts de Seine', 1),
(1210, 74, 'FR-93', 'Seine St-Denis', 1),
(1211, 74, 'FR-94', 'Val de Marne', 1),
(1212, 74, 'FR-95', 'Val d&#039;Oise', 1),
(1213, 87, 'FR-GP', 'Guadeloupe', 1),
(1214, 134, 'FR-MQ', 'Martinique', 1),
(1215, 75, 'FR-GF', 'Guyane', 1),
(1216, 174, 'FR-RE', 'La Réunion', 1),
(1217, 198, 'FR-PM', 'Saint Pierre et Miquelon', 1),
(1218, 137, 'FR-YT', 'Mayotte', 1),
(1219, 247, 'FR-BL', 'Saint Barthélemy', 1),
(1220, 248, 'FR-MF', 'Saint Martin', 1),
(1221, 233, 'FR-WF', 'Wallis et Futuna', 1),
(1222, 76, 'FR-PF', 'Polynésie française', 1),
(1223, 152, 'FR-NC', 'Nouvelle Calédonie', 1),
(1224, 76, 'FR-CP', 'Clipperton', 1),
(1225, 77, 'FR-TF', 'Terres australes et antarctiques', 1),
(1226, 78, 'ES', 'Estuaire', 1),
(1227, 78, 'HO', 'Haut-Ogooue', 1),
(1228, 78, 'MO', 'Moyen-Ogooue', 1),
(1229, 78, 'NG', 'Ngounie', 1),
(1230, 78, 'NY', 'Nyanga', 1),
(1231, 78, 'OI', 'Ogooue-Ivindo', 1),
(1232, 78, 'OL', 'Ogooue-Lolo', 1),
(1233, 78, 'OM', 'Ogooue-Maritime', 1),
(1234, 78, 'WN', 'Woleu-Ntem', 1),
(1235, 79, 'BJ', 'Banjul', 1),
(1236, 79, 'BS', 'Basse', 1),
(1237, 79, 'BR', 'Brikama', 1),
(1238, 79, 'JA', 'Janjangbure', 1),
(1239, 79, 'KA', 'Kanifeng', 1),
(1240, 79, 'KE', 'Kerewan', 1),
(1241, 79, 'KU', 'Kuntaur', 1),
(1242, 79, 'MA', 'Mansakonko', 1),
(1243, 79, 'LR', 'Lower River', 1),
(1244, 79, 'CR', 'Central River', 1),
(1245, 79, 'NB', 'North Bank', 1),
(1246, 79, 'UR', 'Upper River', 1),
(1247, 79, 'WE', 'Western', 1),
(1248, 80, 'AB', 'Abkhazia', 1),
(1249, 80, 'AJ', 'Ajaria', 1),
(1250, 80, 'TB', 'Tbilisi', 1),
(1251, 80, 'GU', 'Guria', 1),
(1252, 80, 'IM', 'Imereti', 1),
(1253, 80, 'KA', 'Kakheti', 1),
(1254, 80, 'KK', 'Kvemo Kartli', 1),
(1255, 80, 'MM', 'Mtskheta-Mtianeti', 1),
(1256, 80, 'RL', 'Racha Lechkhumi and Kvemo Svanet', 1),
(1257, 80, 'SZ', 'Samegrelo-Zemo Svaneti', 1),
(1258, 80, 'SJ', 'Samtskhe-Javakheti', 1),
(1259, 80, 'SK', 'Shida Kartli', 1),
(1260, 81, 'BAW', 'Baden-Württemberg', 1),
(1261, 81, 'BAY', 'Bayern', 1),
(1262, 81, 'BER', 'Berlin', 1),
(1263, 81, 'BRG', 'Brandenburg', 1),
(1264, 81, 'BRE', 'Bremen', 1),
(1265, 81, 'HAM', 'Hamburg', 1),
(1266, 81, 'HES', 'Hessen', 1),
(1267, 81, 'MEC', 'Mecklenburg-Vorpommern', 1),
(1268, 81, 'NDS', 'Niedersachsen', 1),
(1269, 81, 'NRW', 'Nordrhein-Westfalen', 1),
(1270, 81, 'RHE', 'Rheinland-Pfalz', 1),
(1271, 81, 'SAR', 'Saarland', 1),
(1272, 81, 'SAS', 'Sachsen', 1),
(1273, 81, 'SAC', 'Sachsen-Anhalt', 1),
(1274, 81, 'SCN', 'Schleswig-Holstein', 1),
(1275, 81, 'THE', 'Thüringen', 1),
(1276, 82, 'AS', 'Ashanti Region', 1),
(1277, 82, 'BA', 'Brong-Ahafo Region', 1),
(1278, 82, 'CE', 'Central Region', 1),
(1279, 82, 'EA', 'Eastern Region', 1),
(1280, 82, 'GA', 'Greater Accra Region', 1),
(1281, 82, 'NO', 'Northern Region', 1),
(1282, 82, 'UE', 'Upper East Region', 1),
(1283, 82, 'UW', 'Upper West Region', 1),
(1284, 82, 'VO', 'Volta Region', 1),
(1285, 82, 'WE', 'Western Region', 1),
(1286, 84, 'AT', 'Attica', 1),
(1287, 84, 'CN', 'Central Greece', 1),
(1288, 84, 'CM', 'Central Macedonia', 1),
(1289, 84, 'CR', 'Crete', 1),
(1290, 84, 'EM', 'East Macedonia and Thrace', 1),
(1291, 84, 'EP', 'Epirus', 1),
(1292, 84, 'II', 'Ionian Islands', 1),
(1293, 84, 'NA', 'North Aegean', 1),
(1294, 84, 'PP', 'Peloponnesos', 1),
(1295, 84, 'SA', 'South Aegean', 1),
(1296, 84, 'TH', 'Thessaly', 1),
(1297, 84, 'WG', 'West Greece', 1),
(1298, 84, 'WM', 'West Macedonia', 1),
(1299, 85, 'A', 'Avannaa', 1),
(1300, 85, 'T', 'Tunu', 1),
(1301, 85, 'K', 'Kitaa', 1),
(1302, 86, 'A', 'Saint Andrew', 1),
(1303, 86, 'D', 'Saint David', 1),
(1304, 86, 'G', 'Saint George', 1),
(1305, 86, 'J', 'Saint John', 1),
(1306, 86, 'M', 'Saint Mark', 1),
(1307, 86, 'P', 'Saint Patrick', 1),
(1308, 86, 'C', 'Carriacou', 1),
(1309, 86, 'Q', 'Petit Martinique', 1),
(1310, 89, 'AV', 'Alta Verapaz', 1),
(1311, 89, 'BV', 'Baja Verapaz', 1),
(1312, 89, 'CM', 'Chimaltenango', 1),
(1313, 89, 'CQ', 'Chiquimula', 1),
(1314, 89, 'PE', 'El Peten', 1),
(1315, 89, 'PR', 'El Progreso', 1),
(1316, 89, 'QC', 'El Quiche', 1),
(1317, 89, 'ES', 'Escuintla', 1),
(1318, 89, 'GU', 'Guatemala', 1),
(1319, 89, 'HU', 'Huehuetenango', 1),
(1320, 89, 'IZ', 'Izabal', 1),
(1321, 89, 'JA', 'Jalapa', 1),
(1322, 89, 'JU', 'Jutiapa', 1),
(1323, 89, 'QZ', 'Quetzaltenango', 1),
(1324, 89, 'RE', 'Retalhuleu', 1),
(1325, 89, 'ST', 'Sacatepequez', 1),
(1326, 89, 'SM', 'San Marcos', 1),
(1327, 89, 'SR', 'Santa Rosa', 1),
(1328, 89, 'SO', 'Solola', 1),
(1329, 89, 'SU', 'Suchitepequez', 1),
(1330, 89, 'TO', 'Totonicapan', 1),
(1331, 89, 'ZA', 'Zacapa', 1),
(1332, 90, 'CNK', 'Conakry', 1),
(1333, 90, 'BYL', 'Beyla', 1),
(1334, 90, 'BFA', 'Boffa', 1),
(1335, 90, 'BOK', 'Boke', 1),
(1336, 90, 'COY', 'Coyah', 1),
(1337, 90, 'DBL', 'Dabola', 1),
(1338, 90, 'DLB', 'Dalaba', 1),
(1339, 90, 'DGR', 'Dinguiraye', 1),
(1340, 90, 'DBR', 'Dubreka', 1),
(1341, 90, 'FRN', 'Faranah', 1),
(1342, 90, 'FRC', 'Forecariah', 1),
(1343, 90, 'FRI', 'Fria', 1),
(1344, 90, 'GAO', 'Gaoual', 1),
(1345, 90, 'GCD', 'Gueckedou', 1),
(1346, 90, 'KNK', 'Kankan', 1),
(1347, 90, 'KRN', 'Kerouane', 1),
(1348, 90, 'KND', 'Kindia', 1),
(1349, 90, 'KSD', 'Kissidougou', 1),
(1350, 90, 'KBA', 'Koubia', 1),
(1351, 90, 'KDA', 'Koundara', 1),
(1352, 90, 'KRA', 'Kouroussa', 1),
(1353, 90, 'LAB', 'Labe', 1),
(1354, 90, 'LLM', 'Lelouma', 1),
(1355, 90, 'LOL', 'Lola', 1),
(1356, 90, 'MCT', 'Macenta', 1),
(1357, 90, 'MAL', 'Mali', 1),
(1358, 90, 'MAM', 'Mamou', 1),
(1359, 90, 'MAN', 'Mandiana', 1),
(1360, 90, 'NZR', 'Nzerekore', 1),
(1361, 90, 'PIT', 'Pita', 1),
(1362, 90, 'SIG', 'Siguiri', 1),
(1363, 90, 'TLM', 'Telimele', 1),
(1364, 90, 'TOG', 'Tougue', 1),
(1365, 90, 'YOM', 'Yomou', 1),
(1366, 91, 'BF', 'Bafata Region', 1),
(1367, 91, 'BB', 'Biombo Region', 1),
(1368, 91, 'BS', 'Bissau Region', 1),
(1369, 91, 'BL', 'Bolama Region', 1),
(1370, 91, 'CA', 'Cacheu Region', 1),
(1371, 91, 'GA', 'Gabu Region', 1),
(1372, 91, 'OI', 'Oio Region', 1),
(1373, 91, 'QU', 'Quinara Region', 1),
(1374, 91, 'TO', 'Tombali Region', 1),
(1375, 92, 'BW', 'Barima-Waini', 1),
(1376, 92, 'CM', 'Cuyuni-Mazaruni', 1),
(1377, 92, 'DM', 'Demerara-Mahaica', 1),
(1378, 92, 'EC', 'East Berbice-Corentyne', 1),
(1379, 92, 'EW', 'Essequibo Islands-West Demerara', 1),
(1380, 92, 'MB', 'Mahaica-Berbice', 1),
(1381, 92, 'PM', 'Pomeroon-Supenaam', 1),
(1382, 92, 'PI', 'Potaro-Siparuni', 1),
(1383, 92, 'UD', 'Upper Demerara-Berbice', 1),
(1384, 92, 'UT', 'Upper Takutu-Upper Essequibo', 1),
(1385, 93, 'AR', 'Artibonite', 1),
(1386, 93, 'CE', 'Centre', 1),
(1387, 93, 'GA', 'Grand&#039;Anse', 1),
(1388, 93, 'ND', 'Nord', 1),
(1389, 93, 'NE', 'Nord-Est', 1),
(1390, 93, 'NO', 'Nord-Ouest', 1),
(1391, 93, 'OU', 'Ouest', 1),
(1392, 93, 'SD', 'Sud', 1),
(1393, 93, 'SE', 'Sud-Est', 1),
(1394, 94, 'F', 'Flat Island', 1),
(1395, 94, 'M', 'McDonald Island', 1),
(1396, 94, 'S', 'Shag Island', 1),
(1397, 94, 'H', 'Heard Island', 1),
(1398, 95, 'AT', 'Atlantida', 1),
(1399, 95, 'CH', 'Choluteca', 1),
(1400, 95, 'CL', 'Colon', 1),
(1401, 95, 'CM', 'Comayagua', 1),
(1402, 95, 'CP', 'Copan', 1),
(1403, 95, 'CR', 'Cortes', 1),
(1404, 95, 'PA', 'El Paraiso', 1),
(1405, 95, 'FM', 'Francisco Morazan', 1),
(1406, 95, 'GD', 'Gracias a Dios', 1),
(1407, 95, 'IN', 'Intibuca', 1),
(1408, 95, 'IB', 'Islas de la Bahia (Bay Islands)', 1),
(1409, 95, 'PZ', 'La Paz', 1),
(1410, 95, 'LE', 'Lempira', 1),
(1411, 95, 'OC', 'Ocotepeque', 1),
(1412, 95, 'OL', 'Olancho', 1),
(1413, 95, 'SB', 'Santa Barbara', 1),
(1414, 95, 'VA', 'Valle', 1),
(1415, 95, 'YO', 'Yoro', 1),
(1416, 96, 'HCW', 'Central and Western Hong Kong Is', 1),
(1417, 96, 'HEA', 'Eastern Hong Kong Island', 1),
(1418, 96, 'HSO', 'Southern Hong Kong Island', 1),
(1419, 96, 'HWC', 'Wan Chai Hong Kong Island', 1),
(1420, 96, 'KKC', 'Kowloon City Kowloon', 1),
(1421, 96, 'KKT', 'Kwun Tong Kowloon', 1),
(1422, 96, 'KSS', 'Sham Shui Po Kowloon', 1),
(1423, 96, 'KWT', 'Wong Tai Sin Kowloon', 1),
(1424, 96, 'KYT', 'Yau Tsim Mong Kowloon', 1),
(1425, 96, 'NIS', 'Islands New Territories', 1),
(1426, 96, 'NKT', 'Kwai Tsing New Territories', 1),
(1427, 96, 'NNO', 'North New Territories', 1),
(1428, 96, 'NSK', 'Sai Kung New Territories', 1),
(1429, 96, 'NST', 'Sha Tin New Territories', 1),
(1430, 96, 'NTP', 'Tai Po New Territories', 1),
(1431, 96, 'NTW', 'Tsuen Wan New Territories', 1),
(1432, 96, 'NTM', 'Tuen Mun New Territories', 1),
(1433, 96, 'NYL', 'Yuen Long New Territories', 1),
(1434, 97, 'BK', 'Bács-Kiskun', 1),
(1435, 97, 'BA', 'Baranya', 1),
(1436, 97, 'BE', 'Békés', 1),
(1437, 97, 'BS', 'Békéscsaba', 1),
(1438, 97, 'BZ', 'Borsod-Abauj-Zemplén', 1),
(1439, 97, 'BU', 'Budapest', 1),
(1440, 97, 'CS', 'Csongrád', 1),
(1441, 97, 'DE', 'Debrecen', 1),
(1442, 97, 'DU', 'Dunaújváros', 1),
(1443, 97, 'EG', 'Eger', 1),
(1444, 97, 'FE', 'Fejér', 1),
(1445, 97, 'GY', 'Gyor', 1),
(1446, 97, 'GM', 'Gyor-Moson-Sopron', 1),
(1447, 97, 'HB', 'Hajdu-Bihar', 1),
(1448, 97, 'HE', 'Heves', 1),
(1449, 97, 'HO', 'Hodmezovásárhely', 1),
(1450, 97, 'JN', 'Jász-Nagykun-Szolnok', 1),
(1451, 97, 'KA', 'Kaposvár', 1),
(1452, 97, 'KE', 'Kecskemét', 1),
(1453, 97, 'KO', 'Komárom-Esztergom', 1),
(1454, 97, 'MI', 'Miskolc', 1),
(1455, 97, 'NA', 'Nagykanizsa', 1),
(1456, 97, 'NO', 'Nográd', 1),
(1457, 97, 'NY', 'Nyiregyháza', 1),
(1458, 97, 'PE', 'Pécs', 1),
(1459, 97, 'PS', 'Pest', 1),
(1460, 97, 'SO', 'Somogy', 1),
(1461, 97, 'SP', 'Sopron', 1),
(1462, 97, 'SS', 'Szabolcs-Szatmár-Bereg', 1),
(1463, 97, 'SZ', 'Szeged', 1),
(1464, 97, 'SE', 'Székesfehérvár', 1),
(1465, 97, 'SL', 'Szolnok', 1),
(1466, 97, 'SM', 'Szombathely', 1),
(1467, 97, 'TA', 'Tatabánya', 1),
(1468, 97, 'TO', 'Tolna', 1),
(1469, 97, 'VA', 'Vas', 1),
(1470, 97, 'VE', 'Veszprém', 1),
(1471, 97, 'ZA', 'Zala', 1),
(1472, 97, 'ZZ', 'Zalaegerszeg', 1),
(1473, 98, 'AL', 'Austurland', 1),
(1474, 98, 'HF', 'Hofuoborgarsvaeoi', 1),
(1475, 98, 'NE', 'Norourland eystra', 1),
(1476, 98, 'NV', 'Norourland vestra', 1),
(1477, 98, 'SL', 'Suourland', 1),
(1478, 98, 'SN', 'Suournes', 1),
(1479, 98, 'VF', 'Vestfiroir', 1),
(1480, 98, 'VL', 'Vesturland', 1),
(1481, 99, 'AN', 'Andaman and Nicobar Islands', 1),
(1482, 99, 'AP', 'Andhra Pradesh', 1),
(1483, 99, 'AR', 'Arunachal Pradesh', 1),
(1484, 99, 'AS', 'Assam', 1),
(1485, 99, 'BI', 'Bihar', 1),
(1486, 99, 'CH', 'Chandigarh', 1),
(1487, 99, 'DA', 'Dadra and Nagar Haveli', 1),
(1488, 99, 'DM', 'Daman and Diu', 1),
(1489, 99, 'DE', 'Delhi', 1),
(1490, 99, 'GO', 'Goa', 1),
(1491, 99, 'GU', 'Gujarat', 1),
(1492, 99, 'HA', 'Haryana', 1),
(1493, 99, 'HP', 'Himachal Pradesh', 1),
(1494, 99, 'JA', 'Jammu and Kashmir', 1),
(1495, 99, 'KA', 'Karnataka', 1),
(1496, 99, 'KE', 'Kerala', 1),
(1497, 99, 'LI', 'Lakshadweep Islands', 1),
(1498, 99, 'MP', 'Madhya Pradesh', 1),
(1499, 99, 'MA', 'Maharashtra', 1),
(1500, 99, 'MN', 'Manipur', 1),
(1501, 99, 'ME', 'Meghalaya', 1),
(1502, 99, 'MI', 'Mizoram', 1),
(1503, 99, 'NA', 'Nagaland', 1),
(1504, 99, 'OR', 'Orissa', 1),
(1505, 99, 'PO', 'Pondicherry', 1),
(1506, 99, 'PU', 'Punjab', 1),
(1507, 99, 'RA', 'Rajasthan', 1),
(1508, 99, 'SI', 'Sikkim', 1),
(1509, 99, 'TN', 'Tamil Nadu', 1),
(1510, 99, 'TR', 'Tripura', 1),
(1511, 99, 'UP', 'Uttar Pradesh', 1),
(1512, 99, 'WB', 'West Bengal', 1),
(1513, 100, 'AC', 'Aceh', 1),
(1514, 100, 'BA', 'Bali', 1),
(1515, 100, 'BT', 'Banten', 1),
(1516, 100, 'BE', 'Bengkulu', 1),
(1517, 100, 'BD', 'BoDeTaBek', 1),
(1518, 100, 'GO', 'Gorontalo', 1),
(1519, 100, 'JK', 'Jakarta Raya', 1),
(1520, 100, 'JA', 'Jambi', 1),
(1521, 100, 'JB', 'Jawa Barat', 1),
(1522, 100, 'JT', 'Jawa Tengah', 1),
(1523, 100, 'JI', 'Jawa Timur', 1),
(1524, 100, 'KB', 'Kalimantan Barat', 1),
(1525, 100, 'KS', 'Kalimantan Selatan', 1),
(1526, 100, 'KT', 'Kalimantan Tengah', 1),
(1527, 100, 'KI', 'Kalimantan Timur', 1),
(1528, 100, 'BB', 'Kepulauan Bangka Belitung', 1),
(1529, 100, 'LA', 'Lampung', 1),
(1530, 100, 'MA', 'Maluku', 1);
INSERT INTO `zone` VALUES
(1531, 100, 'MU', 'Maluku Utara', 1),
(1532, 100, 'NB', 'Nusa Tenggara Barat', 1),
(1533, 100, 'NT', 'Nusa Tenggara Timur', 1),
(1534, 100, 'PA', 'Papua', 1),
(1535, 100, 'RI', 'Riau', 1),
(1536, 100, 'SN', 'Sulawesi Selatan', 1),
(1537, 100, 'ST', 'Sulawesi Tengah', 1),
(1538, 100, 'SG', 'Sulawesi Tenggara', 1),
(1539, 100, 'SA', 'Sulawesi Utara', 1),
(1540, 100, 'SB', 'Sumatera Barat', 1),
(1541, 100, 'SS', 'Sumatera Selatan', 1),
(1542, 100, 'SU', 'Sumatera Utara', 1),
(1543, 100, 'YO', 'Yogyakarta', 1),
(1544, 101, 'TEH', 'Tehran', 1),
(1545, 101, 'QOM', 'Qom', 1),
(1546, 101, 'MKZ', 'Markazi', 1),
(1547, 101, 'QAZ', 'Qazvin', 1),
(1548, 101, 'GIL', 'Gilan', 1),
(1549, 101, 'ARD', 'Ardabil', 1),
(1550, 101, 'ZAN', 'Zanjan', 1),
(1551, 101, 'EAZ', 'East Azarbaijan', 1),
(1552, 101, 'WEZ', 'West Azarbaijan', 1),
(1553, 101, 'KRD', 'Kurdistan', 1),
(1554, 101, 'HMD', 'Hamadan', 1),
(1555, 101, 'KRM', 'Kermanshah', 1),
(1556, 101, 'ILM', 'Ilam', 1),
(1557, 101, 'LRS', 'Lorestan', 1),
(1558, 101, 'KZT', 'Khuzestan', 1),
(1559, 101, 'CMB', 'Chahar Mahaal and Bakhtiari', 1),
(1560, 101, 'KBA', 'Kohkiluyeh and Buyer Ahmad', 1),
(1561, 101, 'BSH', 'Bushehr', 1),
(1562, 101, 'FAR', 'Fars', 1),
(1563, 101, 'HRM', 'Hormozgan', 1),
(1564, 101, 'SBL', 'Sistan and Baluchistan', 1),
(1565, 101, 'KRB', 'Kerman', 1),
(1566, 101, 'YZD', 'Yazd', 1),
(1567, 101, 'EFH', 'Esfahan', 1),
(1568, 101, 'SMN', 'Semnan', 1),
(1569, 101, 'MZD', 'Mazandaran', 1),
(1570, 101, 'GLS', 'Golestan', 1),
(1571, 101, 'NKH', 'North Khorasan', 1),
(1572, 101, 'RKH', 'Razavi Khorasan', 1),
(1573, 101, 'SKH', 'South Khorasan', 1),
(1574, 102, 'BD', 'Baghdad', 1),
(1575, 102, 'SD', 'Salah ad Din', 1),
(1576, 102, 'DY', 'Diyala', 1),
(1577, 102, 'WS', 'Wasit', 1),
(1578, 102, 'MY', 'Maysan', 1),
(1579, 102, 'BA', 'Al Basrah', 1),
(1580, 102, 'DQ', 'Dhi Qar', 1),
(1581, 102, 'MU', 'Al Muthanna', 1),
(1582, 102, 'QA', 'Al Qadisyah', 1),
(1583, 102, 'BB', 'Babil', 1),
(1584, 102, 'KB', 'Al Karbala', 1),
(1585, 102, 'NJ', 'An Najaf', 1),
(1586, 102, 'AB', 'Al Anbar', 1),
(1587, 102, 'NN', 'Ninawa', 1),
(1588, 102, 'DH', 'Dahuk', 1),
(1589, 102, 'AL', 'Arbil', 1),
(1590, 102, 'TM', 'At Ta&#039;mim', 1),
(1591, 102, 'SL', 'As Sulaymaniyah', 1),
(1592, 103, 'CA', 'Carlow', 1),
(1593, 103, 'CV', 'Cavan', 1),
(1594, 103, 'CL', 'Clare', 1),
(1595, 103, 'CO', 'Cork', 1),
(1596, 103, 'DO', 'Donegal', 1),
(1597, 103, 'DU', 'Dublin', 1),
(1598, 103, 'GA', 'Galway', 1),
(1599, 103, 'KE', 'Kerry', 1),
(1600, 103, 'KI', 'Kildare', 1),
(1601, 103, 'KL', 'Kilkenny', 1),
(1602, 103, 'LA', 'Laois', 1),
(1603, 103, 'LE', 'Leitrim', 1),
(1604, 103, 'LI', 'Limerick', 1),
(1605, 103, 'LO', 'Longford', 1),
(1606, 103, 'LU', 'Louth', 1),
(1607, 103, 'MA', 'Mayo', 1),
(1608, 103, 'ME', 'Meath', 1),
(1609, 103, 'MO', 'Monaghan', 1),
(1610, 103, 'OF', 'Offaly', 1),
(1611, 103, 'RO', 'Roscommon', 1),
(1612, 103, 'SL', 'Sligo', 1),
(1613, 103, 'TI', 'Tipperary', 1),
(1614, 103, 'WA', 'Waterford', 1),
(1615, 103, 'WE', 'Westmeath', 1),
(1616, 103, 'WX', 'Wexford', 1),
(1617, 103, 'WI', 'Wicklow', 1),
(1618, 104, 'BS', 'Be&#039;er Sheva', 1),
(1619, 104, 'BH', 'Bika&#039;at Hayarden', 1),
(1620, 104, 'EA', 'Eilat and Arava', 1),
(1621, 104, 'GA', 'Galil', 1),
(1622, 104, 'HA', 'Haifa', 1),
(1623, 104, 'JM', 'Jehuda Mountains', 1),
(1624, 104, 'JE', 'Jerusalem', 1),
(1625, 104, 'NE', 'Negev', 1),
(1626, 104, 'SE', 'Semaria', 1),
(1627, 104, 'SH', 'Sharon', 1),
(1628, 104, 'TA', 'Tel Aviv (Gosh Dan)', 1),
(1629, 105, 'AB', 'Abruzzo', 1),
(1630, 105, 'BA', 'Basilicata', 1),
(1631, 105, 'CA', 'Calabria', 1),
(1632, 105, 'CP', 'Campania', 1),
(1633, 105, 'ER', 'Emilia Romagna', 1),
(1634, 105, 'FV', 'Friuli-Venezia Giulia', 1),
(1635, 105, 'LA', 'Lazio (Latium & Rome)', 1),
(1636, 105, 'TM', 'Le Marche (The Marches)', 1),
(1637, 105, 'LI', 'Liguria', 1),
(1638, 105, 'LO', 'Lombardia (Lombardy)', 1),
(1639, 105, 'MO', 'Molise', 1),
(1640, 105, 'PI', 'Piemonte (Piedmont)', 1),
(1641, 105, 'AP', 'Puglia (Apulia)', 1),
(1642, 105, 'SA', 'Sardegna (Sardinia)', 1),
(1643, 105, 'SI', 'Sicilia (Sicily)', 1),
(1644, 105, 'TU', 'Toscana (Tuscany)', 1),
(1645, 105, 'TR', 'Trentino Alto Adige', 1),
(1646, 105, 'UM', 'Umbria', 1),
(1647, 105, 'VA', 'Val d&#039;Aosta', 1),
(1648, 105, 'VE', 'Veneto', 1),
(1649, 106, 'CLA', 'Clarendon Parish', 1),
(1650, 106, 'HAN', 'Hanover Parish', 1),
(1651, 106, 'KIN', 'Kingston Parish', 1),
(1652, 106, 'MAN', 'Manchester Parish', 1),
(1653, 106, 'POR', 'Portland Parish', 1),
(1654, 106, 'AND', 'Saint Andrew Parish', 1),
(1655, 106, 'ANN', 'Saint Ann Parish', 1),
(1656, 106, 'CAT', 'Saint Catherine Parish', 1),
(1657, 106, 'ELI', 'Saint Elizabeth Parish', 1),
(1658, 106, 'JAM', 'Saint James Parish', 1),
(1659, 106, 'MAR', 'Saint Mary Parish', 1),
(1660, 106, 'THO', 'Saint Thomas Parish', 1),
(1661, 106, 'TRL', 'Trelawny Parish', 1),
(1662, 106, 'WML', 'Westmoreland Parish', 1),
(1663, 107, 'AI', 'Aichi', 1),
(1664, 107, 'AK', 'Akita', 1),
(1665, 107, 'AO', 'Aomori', 1),
(1666, 107, 'CH', 'Chiba', 1),
(1667, 107, 'EH', 'Ehime', 1),
(1668, 107, 'FK', 'Fukui', 1),
(1669, 107, 'FU', 'Fukuoka', 1),
(1670, 107, 'FS', 'Fukushima', 1),
(1671, 107, 'GI', 'Gifu', 1),
(1672, 107, 'GU', 'Gumma', 1),
(1673, 107, 'HI', 'Hiroshima', 1),
(1674, 107, 'HO', 'Hokkaido', 1),
(1675, 107, 'HY', 'Hyogo', 1),
(1676, 107, 'IB', 'Ibaraki', 1),
(1677, 107, 'IS', 'Ishikawa', 1),
(1678, 107, 'IW', 'Iwate', 1),
(1679, 107, 'KA', 'Kagawa', 1),
(1680, 107, 'KG', 'Kagoshima', 1),
(1681, 107, 'KN', 'Kanagawa', 1),
(1682, 107, 'KO', 'Kochi', 1),
(1683, 107, 'KU', 'Kumamoto', 1),
(1684, 107, 'KY', 'Kyoto', 1),
(1685, 107, 'MI', 'Mie', 1),
(1686, 107, 'MY', 'Miyagi', 1),
(1687, 107, 'MZ', 'Miyazaki', 1),
(1688, 107, 'NA', 'Nagano', 1),
(1689, 107, 'NG', 'Nagasaki', 1),
(1690, 107, 'NR', 'Nara', 1),
(1691, 107, 'NI', 'Niigata', 1),
(1692, 107, 'OI', 'Oita', 1),
(1693, 107, 'OK', 'Okayama', 1),
(1694, 107, 'ON', 'Okinawa', 1),
(1695, 107, 'OS', 'Osaka', 1),
(1696, 107, 'SA', 'Saga', 1),
(1697, 107, 'SI', 'Saitama', 1),
(1698, 107, 'SH', 'Shiga', 1),
(1699, 107, 'SM', 'Shimane', 1),
(1700, 107, 'SZ', 'Shizuoka', 1),
(1701, 107, 'TO', 'Tochigi', 1),
(1702, 107, 'TS', 'Tokushima', 1),
(1703, 107, 'TK', 'Tokyo', 1),
(1704, 107, 'TT', 'Tottori', 1),
(1705, 107, 'TY', 'Toyama', 1),
(1706, 107, 'WA', 'Wakayama', 1),
(1707, 107, 'YA', 'Yamagata', 1),
(1708, 107, 'YM', 'Yamaguchi', 1),
(1709, 107, 'YN', 'Yamanashi', 1),
(1710, 108, 'AM', '&#039;Amman', 1),
(1711, 108, 'AJ', 'Ajlun', 1),
(1712, 108, 'AA', 'Al &#039;Aqabah', 1),
(1713, 108, 'AB', 'Al Balqa&#039;', 1),
(1714, 108, 'AK', 'Al Karak', 1),
(1715, 108, 'AL', 'Al Mafraq', 1),
(1716, 108, 'AT', 'At Tafilah', 1),
(1717, 108, 'AZ', 'Az Zarqa&#039;', 1),
(1718, 108, 'IR', 'Irbid', 1),
(1719, 108, 'JA', 'Jarash', 1),
(1720, 108, 'MA', 'Ma&#039;an', 1),
(1721, 108, 'MD', 'Madaba', 1),
(1722, 109, 'AL', 'Almaty', 1),
(1723, 109, 'AC', 'Almaty City', 1),
(1724, 109, 'AM', 'Aqmola', 1),
(1725, 109, 'AQ', 'Aqtobe', 1),
(1726, 109, 'AS', 'Astana City', 1),
(1727, 109, 'AT', 'Atyrau', 1),
(1728, 109, 'BA', 'Batys Qazaqstan', 1),
(1729, 109, 'BY', 'Bayqongyr City', 1),
(1730, 109, 'MA', 'Mangghystau', 1),
(1731, 109, 'ON', 'Ongtustik Qazaqstan', 1),
(1732, 109, 'PA', 'Pavlodar', 1),
(1733, 109, 'QA', 'Qaraghandy', 1),
(1734, 109, 'QO', 'Qostanay', 1),
(1735, 109, 'QY', 'Qyzylorda', 1),
(1736, 109, 'SH', 'Shyghys Qazaqstan', 1),
(1737, 109, 'SO', 'Soltustik Qazaqstan', 1),
(1738, 109, 'ZH', 'Zhambyl', 1),
(1739, 110, 'CE', 'Central', 1),
(1740, 110, 'CO', 'Coast', 1),
(1741, 110, 'EA', 'Eastern', 1),
(1742, 110, 'NA', 'Nairobi Area', 1),
(1743, 110, 'NE', 'North Eastern', 1),
(1744, 110, 'NY', 'Nyanza', 1),
(1745, 110, 'RV', 'Rift Valley', 1),
(1746, 110, 'WE', 'Western', 1),
(1747, 111, 'AG', 'Abaiang', 1),
(1748, 111, 'AM', 'Abemama', 1),
(1749, 111, 'AK', 'Aranuka', 1),
(1750, 111, 'AO', 'Arorae', 1),
(1751, 111, 'BA', 'Banaba', 1),
(1752, 111, 'BE', 'Beru', 1),
(1753, 111, 'bT', 'Butaritari', 1),
(1754, 111, 'KA', 'Kanton', 1),
(1755, 111, 'KR', 'Kiritimati', 1),
(1756, 111, 'KU', 'Kuria', 1),
(1757, 111, 'MI', 'Maiana', 1),
(1758, 111, 'MN', 'Makin', 1),
(1759, 111, 'ME', 'Marakei', 1),
(1760, 111, 'NI', 'Nikunau', 1),
(1761, 111, 'NO', 'Nonouti', 1),
(1762, 111, 'ON', 'Onotoa', 1),
(1763, 111, 'TT', 'Tabiteuea', 1),
(1764, 111, 'TR', 'Tabuaeran', 1),
(1765, 111, 'TM', 'Tamana', 1),
(1766, 111, 'TW', 'Tarawa', 1),
(1767, 111, 'TE', 'Teraina', 1),
(1768, 112, 'CHA', 'Chagang-do', 1),
(1769, 112, 'HAB', 'Hamgyong-bukto', 1),
(1770, 112, 'HAN', 'Hamgyong-namdo', 1),
(1771, 112, 'HWB', 'Hwanghae-bukto', 1),
(1772, 112, 'HWN', 'Hwanghae-namdo', 1),
(1773, 112, 'KAN', 'Kangwon-do', 1),
(1774, 112, 'PYB', 'P&#039;yongan-bukto', 1),
(1775, 112, 'PYN', 'P&#039;yongan-namdo', 1),
(1776, 112, 'YAN', 'Ryanggang-do (Yanggang-do)', 1),
(1777, 112, 'NAJ', 'Rason Directly Governed City', 1),
(1778, 112, 'PYO', 'P&#039;yongyang Special City', 1),
(1779, 113, 'CO', 'Ch''ungch''ong-bukto', 1),
(1780, 113, 'CH', 'Ch''ungch''ong-namdo', 1),
(1781, 113, 'CD', 'Cheju-do', 1),
(1782, 113, 'CB', 'Cholla-bukto', 1),
(1783, 113, 'CN', 'Cholla-namdo', 1),
(1784, 113, 'IG', 'Inch&#039;on-gwangyoksi', 1),
(1785, 113, 'KA', 'Kangwon-do', 1),
(1786, 113, 'KG', 'Kwangju-gwangyoksi', 1),
(1787, 113, 'KD', 'Kyonggi-do', 1),
(1788, 113, 'KB', 'Kyongsang-bukto', 1),
(1789, 113, 'KN', 'Kyongsang-namdo', 1),
(1790, 113, 'PG', 'Pusan-gwangyoksi', 1),
(1791, 113, 'SO', 'Soul-t&#039;ukpyolsi', 1),
(1792, 113, 'TA', 'Taegu-gwangyoksi', 1),
(1793, 113, 'TG', 'Taejon-gwangyoksi', 1),
(1794, 114, 'AL', 'Al &#039;Asimah', 1),
(1795, 114, 'AA', 'Al Ahmadi', 1),
(1796, 114, 'AF', 'Al Farwaniyah', 1),
(1797, 114, 'AJ', 'Al Jahra&#039;', 1),
(1798, 114, 'HA', 'Hawalli', 1),
(1799, 115, 'GB', 'Bishkek', 1),
(1800, 115, 'B', 'Batken', 1),
(1801, 115, 'C', 'Chu', 1),
(1802, 115, 'J', 'Jalal-Abad', 1),
(1803, 115, 'N', 'Naryn', 1),
(1804, 115, 'O', 'Osh', 1),
(1805, 115, 'T', 'Talas', 1),
(1806, 115, 'Y', 'Ysyk-Kol', 1),
(1807, 116, 'VT', 'Vientiane', 1),
(1808, 116, 'AT', 'Attapu', 1),
(1809, 116, 'BK', 'Bokeo', 1),
(1810, 116, 'BL', 'Bolikhamxai', 1),
(1811, 116, 'CH', 'Champasak', 1),
(1812, 116, 'HO', 'Houaphan', 1),
(1813, 116, 'KH', 'Khammouan', 1),
(1814, 116, 'LM', 'Louang Namtha', 1),
(1815, 116, 'LP', 'Louangphabang', 1),
(1816, 116, 'OU', 'Oudomxai', 1),
(1817, 116, 'PH', 'Phongsali', 1),
(1818, 116, 'SL', 'Salavan', 1),
(1819, 116, 'SV', 'Savannakhet', 1),
(1820, 116, 'VI', 'Vientiane', 1),
(1821, 116, 'XA', 'Xaignabouli', 1),
(1822, 116, 'XE', 'Xekong', 1),
(1823, 116, 'XI', 'Xiangkhoang', 1),
(1824, 116, 'XN', 'Xaisomboun', 1),
(1825, 117, 'AIZ', 'Aizkraukles Rajons', 1),
(1826, 117, 'ALU', 'Aluksnes Rajons', 1),
(1827, 117, 'BAL', 'Balvu Rajons', 1),
(1828, 117, 'BAU', 'Bauskas Rajons', 1),
(1829, 117, 'CES', 'Cesu Rajons', 1),
(1830, 117, 'DGR', 'Daugavpils Rajons', 1),
(1831, 117, 'DOB', 'Dobeles Rajons', 1),
(1832, 117, 'GUL', 'Gulbenes Rajons', 1),
(1833, 117, 'JEK', 'Jekabpils Rajons', 1),
(1834, 117, 'JGR', 'Jelgavas Rajons', 1),
(1835, 117, 'KRA', 'Kraslavas Rajons', 1),
(1836, 117, 'KUL', 'Kuldigas Rajons', 1),
(1837, 117, 'LPR', 'Liepajas Rajons', 1),
(1838, 117, 'LIM', 'Limbazu Rajons', 1),
(1839, 117, 'LUD', 'Ludzas Rajons', 1),
(1840, 117, 'MAD', 'Madonas Rajons', 1),
(1841, 117, 'OGR', 'Ogres Rajons', 1),
(1842, 117, 'PRE', 'Preilu Rajons', 1),
(1843, 117, 'RZR', 'Rezeknes Rajons', 1),
(1844, 117, 'RGR', 'Rigas Rajons', 1),
(1845, 117, 'SAL', 'Saldus Rajons', 1),
(1846, 117, 'TAL', 'Talsu Rajons', 1),
(1847, 117, 'TUK', 'Tukuma Rajons', 1),
(1848, 117, 'VLK', 'Valkas Rajons', 1),
(1849, 117, 'VLM', 'Valmieras Rajons', 1),
(1850, 117, 'VSR', 'Ventspils Rajons', 1),
(1851, 117, 'DGV', 'Daugavpils', 1),
(1852, 117, 'JGV', 'Jelgava', 1),
(1853, 117, 'JUR', 'Jurmala', 1),
(1854, 117, 'LPK', 'Liepaja', 1),
(1855, 117, 'RZK', 'Rezekne', 1),
(1856, 117, 'RGA', 'Riga', 1),
(1857, 117, 'VSL', 'Ventspils', 1),
(1858, 119, 'BE', 'Berea', 1),
(1859, 119, 'BB', 'Butha-Buthe', 1),
(1860, 119, 'LE', 'Leribe', 1),
(1861, 119, 'MF', 'Mafeteng', 1),
(1862, 119, 'MS', 'Maseru', 1),
(1863, 119, 'MH', 'Mohale&#039;s Hoek', 1),
(1864, 119, 'MK', 'Mokhotlong', 1),
(1865, 119, 'QN', 'Qacha&#039;s Nek', 1),
(1866, 119, 'QT', 'Quthing', 1),
(1867, 119, 'TT', 'Thaba-Tseka', 1),
(1868, 120, 'BI', 'Bomi', 1),
(1869, 120, 'BG', 'Bong', 1),
(1870, 120, 'GB', 'Grand Bassa', 1),
(1871, 120, 'CM', 'Grand Cape Mount', 1),
(1872, 120, 'GG', 'Grand Gedeh', 1),
(1873, 120, 'GK', 'Grand Kru', 1),
(1874, 120, 'LO', 'Lofa', 1),
(1875, 120, 'MG', 'Margibi', 1),
(1876, 120, 'ML', 'Maryland', 1),
(1877, 120, 'MS', 'Montserrado', 1),
(1878, 120, 'NB', 'Nimba', 1),
(1879, 120, 'RC', 'River Cess', 1),
(1880, 120, 'SN', 'Sinoe', 1),
(1881, 121, 'AJ', 'Ajdabiya', 1),
(1882, 121, 'AZ', 'Al &#039;Aziziyah', 1),
(1883, 121, 'FA', 'Al Fatih', 1),
(1884, 121, 'JA', 'Al Jabal al Akhdar', 1),
(1885, 121, 'JU', 'Al Jufrah', 1),
(1886, 121, 'KH', 'Al Khums', 1),
(1887, 121, 'KU', 'Al Kufrah', 1),
(1888, 121, 'NK', 'An Nuqat al Khams', 1),
(1889, 121, 'AS', 'Ash Shati&#039;', 1),
(1890, 121, 'AW', 'Awbari', 1),
(1891, 121, 'ZA', 'Az Zawiyah', 1),
(1892, 121, 'BA', 'Banghazi', 1),
(1893, 121, 'DA', 'Darnah', 1),
(1894, 121, 'GD', 'Ghadamis', 1),
(1895, 121, 'GY', 'Gharyan', 1),
(1896, 121, 'MI', 'Misratah', 1),
(1897, 121, 'MZ', 'Murzuq', 1),
(1898, 121, 'SB', 'Sabha', 1),
(1899, 121, 'SW', 'Sawfajjin', 1),
(1900, 121, 'SU', 'Surt', 1),
(1901, 121, 'TL', 'Tarabulus (Tripoli)', 1),
(1902, 121, 'TH', 'Tarhunah', 1),
(1903, 121, 'TU', 'Tubruq', 1),
(1904, 121, 'YA', 'Yafran', 1),
(1905, 121, 'ZL', 'Zlitan', 1),
(1906, 122, 'V', 'Vaduz', 1),
(1907, 122, 'A', 'Schaan', 1),
(1908, 122, 'B', 'Balzers', 1),
(1909, 122, 'N', 'Triesen', 1),
(1910, 122, 'E', 'Eschen', 1),
(1911, 122, 'M', 'Mauren', 1),
(1912, 122, 'T', 'Triesenberg', 1),
(1913, 122, 'R', 'Ruggell', 1),
(1914, 122, 'G', 'Gamprin', 1),
(1915, 122, 'L', 'Schellenberg', 1),
(1916, 122, 'P', 'Planken', 1),
(1917, 123, 'AL', 'Alytus', 1),
(1918, 123, 'KA', 'Kaunas', 1),
(1919, 123, 'KL', 'Klaipeda', 1),
(1920, 123, 'MA', 'Marijampole', 1),
(1921, 123, 'PA', 'Panevezys', 1),
(1922, 123, 'SI', 'Siauliai', 1),
(1923, 123, 'TA', 'Taurage', 1),
(1924, 123, 'TE', 'Telsiai', 1),
(1925, 123, 'UT', 'Utena', 1),
(1926, 123, 'VI', 'Vilnius', 1),
(1927, 124, 'DD', 'Diekirch', 1),
(1928, 124, 'DC', 'Clervaux', 1),
(1929, 124, 'DR', 'Redange', 1),
(1930, 124, 'DV', 'Vianden', 1),
(1931, 124, 'DW', 'Wiltz', 1),
(1932, 124, 'GG', 'Grevenmacher', 1),
(1933, 124, 'GE', 'Echternach', 1),
(1934, 124, 'GR', 'Remich', 1),
(1935, 124, 'LL', 'Luxembourg', 1),
(1936, 124, 'LC', 'Capellen', 1),
(1937, 124, 'LE', 'Esch-sur-Alzette', 1),
(1938, 124, 'LM', 'Mersch', 1),
(1939, 125, 'OLF', 'Our Lady Fatima Parish', 1),
(1940, 125, 'ANT', 'St. Anthony Parish', 1),
(1941, 125, 'LAZ', 'St. Lazarus Parish', 1),
(1942, 125, 'CAT', 'Cathedral Parish', 1),
(1943, 125, 'LAW', 'St. Lawrence Parish', 1),
(1944, 127, 'AN', 'Antananarivo', 1),
(1945, 127, 'AS', 'Antsiranana', 1),
(1946, 127, 'FN', 'Fianarantsoa', 1),
(1947, 127, 'MJ', 'Mahajanga', 1),
(1948, 127, 'TM', 'Toamasina', 1),
(1949, 127, 'TL', 'Toliara', 1),
(1950, 128, 'BLK', 'Balaka', 1),
(1951, 128, 'BLT', 'Blantyre', 1),
(1952, 128, 'CKW', 'Chikwawa', 1),
(1953, 128, 'CRD', 'Chiradzulu', 1),
(1954, 128, 'CTP', 'Chitipa', 1),
(1955, 128, 'DDZ', 'Dedza', 1),
(1956, 128, 'DWA', 'Dowa', 1),
(1957, 128, 'KRG', 'Karonga', 1),
(1958, 128, 'KSG', 'Kasungu', 1),
(1959, 128, 'LKM', 'Likoma', 1),
(1960, 128, 'LLG', 'Lilongwe', 1),
(1961, 128, 'MCG', 'Machinga', 1),
(1962, 128, 'MGC', 'Mangochi', 1),
(1963, 128, 'MCH', 'Mchinji', 1),
(1964, 128, 'MLJ', 'Mulanje', 1),
(1965, 128, 'MWZ', 'Mwanza', 1),
(1966, 128, 'MZM', 'Mzimba', 1),
(1967, 128, 'NTU', 'Ntcheu', 1),
(1968, 128, 'NKB', 'Nkhata Bay', 1),
(1969, 128, 'NKH', 'Nkhotakota', 1),
(1970, 128, 'NSJ', 'Nsanje', 1),
(1971, 128, 'NTI', 'Ntchisi', 1),
(1972, 128, 'PHL', 'Phalombe', 1),
(1973, 128, 'RMP', 'Rumphi', 1),
(1974, 128, 'SLM', 'Salima', 1),
(1975, 128, 'THY', 'Thyolo', 1),
(1976, 128, 'ZBA', 'Zomba', 1),
(1977, 129, 'JO', 'Johor', 1),
(1978, 129, 'KE', 'Kedah', 1),
(1979, 129, 'KL', 'Kelantan', 1),
(1980, 129, 'LA', 'Labuan', 1),
(1981, 129, 'ME', 'Melaka', 1),
(1982, 129, 'NS', 'Negeri Sembilan', 1),
(1983, 129, 'PA', 'Pahang', 1),
(1984, 129, 'PE', 'Perak', 1),
(1985, 129, 'PR', 'Perlis', 1),
(1986, 129, 'PP', 'Pulau Pinang', 1),
(1987, 129, 'SA', 'Sabah', 1),
(1988, 129, 'SR', 'Sarawak', 1),
(1989, 129, 'SE', 'Selangor', 1),
(1990, 129, 'TE', 'Terengganu', 1),
(1991, 129, 'WP', 'Wilayah Persekutuan', 1),
(1992, 130, 'THU', 'Thiladhunmathi Uthuru', 1),
(1993, 130, 'THD', 'Thiladhunmathi Dhekunu', 1),
(1994, 130, 'MLU', 'Miladhunmadulu Uthuru', 1),
(1995, 130, 'MLD', 'Miladhunmadulu Dhekunu', 1),
(1996, 130, 'MAU', 'Maalhosmadulu Uthuru', 1),
(1997, 130, 'MAD', 'Maalhosmadulu Dhekunu', 1),
(1998, 130, 'FAA', 'Faadhippolhu', 1),
(1999, 130, 'MAA', 'Male Atoll', 1),
(2000, 130, 'AAU', 'Ari Atoll Uthuru', 1),
(2001, 130, 'AAD', 'Ari Atoll Dheknu', 1),
(2002, 130, 'FEA', 'Felidhe Atoll', 1),
(2003, 130, 'MUA', 'Mulaku Atoll', 1),
(2004, 130, 'NAU', 'Nilandhe Atoll Uthuru', 1),
(2005, 130, 'NAD', 'Nilandhe Atoll Dhekunu', 1),
(2006, 130, 'KLH', 'Kolhumadulu', 1),
(2007, 130, 'HDH', 'Hadhdhunmathi', 1),
(2008, 130, 'HAU', 'Huvadhu Atoll Uthuru', 1),
(2009, 130, 'HAD', 'Huvadhu Atoll Dhekunu', 1),
(2010, 130, 'FMU', 'Fua Mulaku', 1),
(2011, 130, 'ADD', 'Addu', 1),
(2012, 131, 'GA', 'Gao', 1),
(2013, 131, 'KY', 'Kayes', 1),
(2014, 131, 'KD', 'Kidal', 1),
(2015, 131, 'KL', 'Koulikoro', 1),
(2016, 131, 'MP', 'Mopti', 1),
(2017, 131, 'SG', 'Segou', 1),
(2018, 131, 'SK', 'Sikasso', 1),
(2019, 131, 'TB', 'Tombouctou', 1),
(2020, 131, 'CD', 'Bamako Capital District', 1),
(2021, 132, 'ATT', 'Attard', 1),
(2022, 132, 'BAL', 'Balzan', 1),
(2023, 132, 'BGU', 'Birgu', 1),
(2024, 132, 'BKK', 'Birkirkara', 1),
(2025, 132, 'BRZ', 'Birzebbuga', 1),
(2026, 132, 'BOR', 'Bormla', 1),
(2027, 132, 'DIN', 'Dingli', 1),
(2028, 132, 'FGU', 'Fgura', 1),
(2029, 132, 'FLO', 'Floriana', 1),
(2030, 132, 'GDJ', 'Gudja', 1),
(2031, 132, 'GZR', 'Gzira', 1),
(2032, 132, 'GRG', 'Gargur', 1),
(2033, 132, 'GXQ', 'Gaxaq', 1),
(2034, 132, 'HMR', 'Hamrun', 1),
(2035, 132, 'IKL', 'Iklin', 1),
(2036, 132, 'ISL', 'Isla', 1),
(2037, 132, 'KLK', 'Kalkara', 1),
(2038, 132, 'KRK', 'Kirkop', 1),
(2039, 132, 'LIJ', 'Lija', 1),
(2040, 132, 'LUQ', 'Luqa', 1),
(2041, 132, 'MRS', 'Marsa', 1),
(2042, 132, 'MKL', 'Marsaskala', 1),
(2043, 132, 'MXL', 'Marsaxlokk', 1),
(2044, 132, 'MDN', 'Mdina', 1),
(2045, 132, 'MEL', 'Melliea', 1),
(2046, 132, 'MGR', 'Mgarr', 1),
(2047, 132, 'MST', 'Mosta', 1),
(2048, 132, 'MQA', 'Mqabba', 1),
(2049, 132, 'MSI', 'Msida', 1),
(2050, 132, 'MTF', 'Mtarfa', 1),
(2051, 132, 'NAX', 'Naxxar', 1),
(2052, 132, 'PAO', 'Paola', 1),
(2053, 132, 'PEM', 'Pembroke', 1),
(2054, 132, 'PIE', 'Pieta', 1),
(2055, 132, 'QOR', 'Qormi', 1),
(2056, 132, 'QRE', 'Qrendi', 1),
(2057, 132, 'RAB', 'Rabat', 1),
(2058, 132, 'SAF', 'Safi', 1),
(2059, 132, 'SGI', 'San Giljan', 1),
(2060, 132, 'SLU', 'Santa Lucija', 1),
(2061, 132, 'SPB', 'San Pawl il-Bahar', 1),
(2062, 132, 'SGW', 'San Gwann', 1),
(2063, 132, 'SVE', 'Santa Venera', 1),
(2064, 132, 'SIG', 'Siggiewi', 1),
(2065, 132, 'SLM', 'Sliema', 1),
(2066, 132, 'SWQ', 'Swieqi', 1),
(2067, 132, 'TXB', 'Ta Xbiex', 1),
(2068, 132, 'TRX', 'Tarxien', 1),
(2069, 132, 'VLT', 'Valletta', 1),
(2070, 132, 'XGJ', 'Xgajra', 1),
(2071, 132, 'ZBR', 'Zabbar', 1),
(2072, 132, 'ZBG', 'Zebbug', 1),
(2073, 132, 'ZJT', 'Zejtun', 1),
(2074, 132, 'ZRQ', 'Zurrieq', 1),
(2075, 132, 'FNT', 'Fontana', 1),
(2076, 132, 'GHJ', 'Ghajnsielem', 1),
(2077, 132, 'GHR', 'Gharb', 1),
(2078, 132, 'GHS', 'Ghasri', 1),
(2079, 132, 'KRC', 'Kercem', 1),
(2080, 132, 'MUN', 'Munxar', 1),
(2081, 132, 'NAD', 'Nadur', 1),
(2082, 132, 'QAL', 'Qala', 1),
(2083, 132, 'VIC', 'Victoria', 1),
(2084, 132, 'SLA', 'San Lawrenz', 1),
(2085, 132, 'SNT', 'Sannat', 1),
(2086, 132, 'ZAG', 'Xagra', 1),
(2087, 132, 'XEW', 'Xewkija', 1),
(2088, 132, 'ZEB', 'Zebbug', 1),
(2089, 133, 'ALG', 'Ailinginae', 1),
(2090, 133, 'ALL', 'Ailinglaplap', 1),
(2091, 133, 'ALK', 'Ailuk', 1),
(2092, 133, 'ARN', 'Arno', 1),
(2093, 133, 'AUR', 'Aur', 1),
(2094, 133, 'BKR', 'Bikar', 1),
(2095, 133, 'BKN', 'Bikini', 1),
(2096, 133, 'BKK', 'Bokak', 1),
(2097, 133, 'EBN', 'Ebon', 1),
(2098, 133, 'ENT', 'Enewetak', 1),
(2099, 133, 'EKB', 'Erikub', 1),
(2100, 133, 'JBT', 'Jabat', 1),
(2101, 133, 'JLT', 'Jaluit', 1),
(2102, 133, 'JEM', 'Jemo', 1),
(2103, 133, 'KIL', 'Kili', 1),
(2104, 133, 'KWJ', 'Kwajalein', 1),
(2105, 133, 'LAE', 'Lae', 1),
(2106, 133, 'LIB', 'Lib', 1),
(2107, 133, 'LKP', 'Likiep', 1),
(2108, 133, 'MJR', 'Majuro', 1),
(2109, 133, 'MLP', 'Maloelap', 1),
(2110, 133, 'MJT', 'Mejit', 1),
(2111, 133, 'MIL', 'Mili', 1),
(2112, 133, 'NMK', 'Namorik', 1),
(2113, 133, 'NAM', 'Namu', 1),
(2114, 133, 'RGL', 'Rongelap', 1),
(2115, 133, 'RGK', 'Rongrik', 1),
(2116, 133, 'TOK', 'Toke', 1),
(2117, 133, 'UJA', 'Ujae', 1),
(2118, 133, 'UJL', 'Ujelang', 1),
(2119, 133, 'UTK', 'Utirik', 1),
(2120, 133, 'WTH', 'Wotho', 1),
(2121, 133, 'WTJ', 'Wotje', 1),
(2122, 135, 'AD', 'Adrar', 1),
(2123, 135, 'AS', 'Assaba', 1),
(2124, 135, 'BR', 'Brakna', 1),
(2125, 135, 'DN', 'Dakhlet Nouadhibou', 1),
(2126, 135, 'GO', 'Gorgol', 1),
(2127, 135, 'GM', 'Guidimaka', 1),
(2128, 135, 'HC', 'Hodh Ech Chargui', 1),
(2129, 135, 'HG', 'Hodh El Gharbi', 1),
(2130, 135, 'IN', 'Inchiri', 1),
(2131, 135, 'TA', 'Tagant', 1),
(2132, 135, 'TZ', 'Tiris Zemmour', 1),
(2133, 135, 'TR', 'Trarza', 1),
(2134, 135, 'NO', 'Nouakchott', 1),
(2135, 136, 'BR', 'Beau Bassin-Rose Hill', 1),
(2136, 136, 'CU', 'Curepipe', 1),
(2137, 136, 'PU', 'Port Louis', 1),
(2138, 136, 'QB', 'Quatre Bornes', 1),
(2139, 136, 'VP', 'Vacoas-Phoenix', 1),
(2140, 136, 'AG', 'Agalega Islands', 1),
(2141, 136, 'CC', 'Cargados Carajos Shoals (Saint B', 1),
(2142, 136, 'RO', 'Rodrigues', 1),
(2143, 136, 'BL', 'Black River', 1),
(2144, 136, 'FL', 'Flacq', 1),
(2145, 136, 'GP', 'Grand Port', 1),
(2146, 136, 'MO', 'Moka', 1),
(2147, 136, 'PA', 'Pamplemousses', 1),
(2148, 136, 'PW', 'Plaines Wilhems', 1),
(2149, 136, 'PL', 'Port Louis', 1),
(2150, 136, 'RR', 'Riviere du Rempart', 1),
(2151, 136, 'SA', 'Savanne', 1),
(2152, 138, 'BN', 'Baja California Norte', 1),
(2153, 138, 'BS', 'Baja California Sur', 1),
(2154, 138, 'CA', 'Campeche', 1),
(2155, 138, 'CI', 'Chiapas', 1),
(2156, 138, 'CH', 'Chihuahua', 1),
(2157, 138, 'CZ', 'Coahuila de Zaragoza', 1),
(2158, 138, 'CL', 'Colima', 1),
(2159, 138, 'DF', 'Distrito Federal', 1),
(2160, 138, 'DU', 'Durango', 1),
(2161, 138, 'GA', 'Guanajuato', 1),
(2162, 138, 'GE', 'Guerrero', 1),
(2163, 138, 'HI', 'Hidalgo', 1),
(2164, 138, 'JA', 'Jalisco', 1),
(2165, 138, 'ME', 'Mexico', 1),
(2166, 138, 'MI', 'Michoacan de Ocampo', 1),
(2167, 138, 'MO', 'Morelos', 1),
(2168, 138, 'NA', 'Nayarit', 1),
(2169, 138, 'NL', 'Nuevo Leon', 1),
(2170, 138, 'OA', 'Oaxaca', 1),
(2171, 138, 'PU', 'Puebla', 1),
(2172, 138, 'QA', 'Queretaro de Arteaga', 1),
(2173, 138, 'QR', 'Quintana Roo', 1),
(2174, 138, 'SA', 'San Luis Potosi', 1),
(2175, 138, 'SI', 'Sinaloa', 1),
(2176, 138, 'SO', 'Sonora', 1),
(2177, 138, 'TB', 'Tabasco', 1),
(2178, 138, 'TM', 'Tamaulipas', 1),
(2179, 138, 'TL', 'Tlaxcala', 1),
(2180, 138, 'VE', 'Veracruz-Llave', 1),
(2181, 138, 'YU', 'Yucatan', 1),
(2182, 138, 'ZA', 'Zacatecas', 1),
(2183, 139, 'C', 'Chuuk', 1),
(2184, 139, 'K', 'Kosrae', 1),
(2185, 139, 'P', 'Pohnpei', 1),
(2186, 139, 'Y', 'Yap', 1),
(2187, 140, 'GA', 'Gagauzia', 1),
(2188, 140, 'CU', 'Chisinau', 1),
(2189, 140, 'BA', 'Balti', 1),
(2190, 140, 'CA', 'Cahul', 1),
(2191, 140, 'ED', 'Edinet', 1),
(2192, 140, 'LA', 'Lapusna', 1),
(2193, 140, 'OR', 'Orhei', 1),
(2194, 140, 'SO', 'Soroca', 1),
(2195, 140, 'TI', 'Tighina', 1),
(2196, 140, 'UN', 'Ungheni', 1),
(2197, 140, 'SN', 'Stînga Nistrului', 1),
(2198, 141, 'FV', 'Fontvieille', 1),
(2199, 141, 'LC', 'La Condamine', 1),
(2200, 141, 'MV', 'Monaco-Ville', 1),
(2201, 141, 'MC', 'Monte-Carlo', 1),
(2202, 142, '1', 'Ulanbaatar', 1),
(2203, 142, '035', 'Orhon', 1),
(2204, 142, '037', 'Darhan uul', 1),
(2205, 142, '039', 'Hentiy', 1),
(2206, 142, '041', 'Hovsgol', 1),
(2207, 142, '043', 'Hovd', 1),
(2208, 142, '046', 'Uvs', 1),
(2209, 142, '047', 'Tov', 1),
(2210, 142, '049', 'Selenge', 1),
(2211, 142, '051', 'Suhbaatar', 1),
(2212, 142, '053', 'Omnogovi', 1),
(2213, 142, '055', 'Ovorhangay', 1),
(2214, 142, '057', 'Dzavhan', 1),
(2215, 142, '059', 'DundgovL', 1),
(2216, 142, '061', 'Dornod', 1),
(2217, 142, '063', 'Dornogov', 1),
(2218, 142, '064', 'Govi-Sumber', 1),
(2219, 142, '065', 'Govi-Altay', 1),
(2220, 142, '067', 'Bulgan', 1),
(2221, 142, '069', 'Bayanhongor', 1),
(2222, 142, '071', 'Bayan-Olgiy', 1),
(2223, 142, '073', 'Arhangay', 1),
(2224, 143, 'A', 'Saint Anthony', 1),
(2225, 143, 'G', 'Saint Georges', 1),
(2226, 143, 'P', 'Saint Peter', 1),
(2227, 144, 'AGD', 'Agadir', 1),
(2228, 144, 'HOC', 'Al Hoceima', 1),
(2229, 144, 'AZI', 'Azilal', 1),
(2230, 144, 'BME', 'Beni Mellal', 1),
(2231, 144, 'BSL', 'Ben Slimane', 1),
(2232, 144, 'BLM', 'Boulemane', 1),
(2233, 144, 'CBL', 'Casablanca', 1),
(2234, 144, 'CHA', 'Chaouen', 1),
(2235, 144, 'EJA', 'El Jadida', 1),
(2236, 144, 'EKS', 'El Kelaa des Sraghna', 1),
(2237, 144, 'ERA', 'Er Rachidia', 1),
(2238, 144, 'ESS', 'Essaouira', 1),
(2239, 144, 'FES', 'Fes', 1),
(2240, 144, 'FIG', 'Figuig', 1),
(2241, 144, 'GLM', 'Guelmim', 1),
(2242, 144, 'IFR', 'Ifrane', 1),
(2243, 144, 'KEN', 'Kenitra', 1),
(2244, 144, 'KHM', 'Khemisset', 1),
(2245, 144, 'KHN', 'Khenifra', 1),
(2246, 144, 'KHO', 'Khouribga', 1),
(2247, 144, 'LYN', 'Laayoune', 1),
(2248, 144, 'LAR', 'Larache', 1),
(2249, 144, 'MRK', 'Marrakech', 1),
(2250, 144, 'MKN', 'Meknes', 1),
(2251, 144, 'NAD', 'Nador', 1),
(2252, 144, 'ORZ', 'Ouarzazate', 1),
(2253, 144, 'OUJ', 'Oujda', 1),
(2254, 144, 'RSA', 'Rabat-Sale', 1),
(2255, 144, 'SAF', 'Safi', 1),
(2256, 144, 'SET', 'Settat', 1),
(2257, 144, 'SKA', 'Sidi Kacem', 1),
(2258, 144, 'TGR', 'Tangier', 1),
(2259, 144, 'TAN', 'Tan-Tan', 1),
(2260, 144, 'TAO', 'Taounate', 1),
(2261, 144, 'TRD', 'Taroudannt', 1),
(2262, 144, 'TAT', 'Tata', 1),
(2263, 144, 'TAZ', 'Taza', 1),
(2264, 144, 'TET', 'Tetouan', 1),
(2265, 144, 'TIZ', 'Tiznit', 1),
(2266, 144, 'ADK', 'Ad Dakhla', 1),
(2267, 144, 'BJD', 'Boujdour', 1),
(2268, 144, 'ESM', 'Es Smara', 1),
(2269, 145, 'CD', 'Cabo Delgado', 1),
(2270, 145, 'GZ', 'Gaza', 1),
(2271, 145, 'IN', 'Inhambane', 1),
(2272, 145, 'MN', 'Manica', 1),
(2273, 145, 'MC', 'Maputo (city)', 1),
(2274, 145, 'MP', 'Maputo', 1),
(2275, 145, 'NA', 'Nampula', 1),
(2276, 145, 'NI', 'Niassa', 1),
(2277, 145, 'SO', 'Sofala', 1),
(2278, 145, 'TE', 'Tete', 1),
(2279, 145, 'ZA', 'Zambezia', 1),
(2280, 146, 'AY', 'Ayeyarwady', 1),
(2281, 146, 'BG', 'Bago', 1),
(2282, 146, 'MG', 'Magway', 1),
(2283, 146, 'MD', 'Mandalay', 1),
(2284, 146, 'SG', 'Sagaing', 1),
(2285, 146, 'TN', 'Tanintharyi', 1),
(2286, 146, 'YG', 'Yangon', 1),
(2287, 146, 'CH', 'Chin State', 1),
(2288, 146, 'KC', 'Kachin State', 1),
(2289, 146, 'KH', 'Kayah State', 1),
(2290, 146, 'KN', 'Kayin State', 1),
(2291, 146, 'MN', 'Mon State', 1),
(2292, 146, 'RK', 'Rakhine State', 1),
(2293, 146, 'SH', 'Shan State', 1),
(2294, 147, 'CA', 'Caprivi', 1),
(2295, 147, 'ER', 'Erongo', 1),
(2296, 147, 'HA', 'Hardap', 1),
(2297, 147, 'KR', 'Karas', 1),
(2298, 147, 'KV', 'Kavango', 1),
(2299, 147, 'KH', 'Khomas', 1),
(2300, 147, 'KU', 'Kunene', 1),
(2301, 147, 'OW', 'Ohangwena', 1),
(2302, 147, 'OK', 'Omaheke', 1),
(2303, 147, 'OT', 'Omusati', 1),
(2304, 147, 'ON', 'Oshana', 1),
(2305, 147, 'OO', 'Oshikoto', 1),
(2306, 147, 'OJ', 'Otjozondjupa', 1),
(2307, 148, 'AO', 'Aiwo', 1),
(2308, 148, 'AA', 'Anabar', 1),
(2309, 148, 'AT', 'Anetan', 1),
(2310, 148, 'AI', 'Anibare', 1),
(2311, 148, 'BA', 'Baiti', 1),
(2312, 148, 'BO', 'Boe', 1),
(2313, 148, 'BU', 'Buada', 1),
(2314, 148, 'DE', 'Denigomodu', 1),
(2315, 148, 'EW', 'Ewa', 1),
(2316, 148, 'IJ', 'Ijuw', 1),
(2317, 148, 'ME', 'Meneng', 1),
(2318, 148, 'NI', 'Nibok', 1),
(2319, 148, 'UA', 'Uaboe', 1),
(2320, 148, 'YA', 'Yaren', 1),
(2321, 149, 'BA', 'Bagmati', 1),
(2322, 149, 'BH', 'Bheri', 1),
(2323, 149, 'DH', 'Dhawalagiri', 1),
(2324, 149, 'GA', 'Gandaki', 1),
(2325, 149, 'JA', 'Janakpur', 1),
(2326, 149, 'KA', 'Karnali', 1),
(2327, 149, 'KO', 'Kosi', 1),
(2328, 149, 'LU', 'Lumbini', 1),
(2329, 149, 'MA', 'Mahakali', 1),
(2330, 149, 'ME', 'Mechi', 1),
(2331, 149, 'NA', 'Narayani', 1),
(2332, 149, 'RA', 'Rapti', 1),
(2333, 149, 'SA', 'Sagarmatha', 1),
(2334, 149, 'SE', 'Seti', 1),
(2335, 150, 'DR', 'Drenthe', 1),
(2336, 150, 'FL', 'Flevoland', 1),
(2337, 150, 'FR', 'Friesland', 1),
(2338, 150, 'GE', 'Gelderland', 1),
(2339, 150, 'GR', 'Groningen', 1),
(2340, 150, 'LI', 'Limburg', 1),
(2341, 150, 'NB', 'Noord Brabant', 1),
(2342, 150, 'NH', 'Noord Holland', 1),
(2343, 150, 'OV', 'Overijssel', 1),
(2344, 150, 'UT', 'Utrecht', 1),
(2345, 150, 'ZE', 'Zeeland', 1),
(2346, 150, 'ZH', 'Zuid Holland', 1),
(2347, 152, 'L', 'Iles Loyaute', 1),
(2348, 152, 'N', 'Nord', 1),
(2349, 152, 'S', 'Sud', 1),
(2350, 153, 'AUK', 'Auckland', 1),
(2351, 153, 'BOP', 'Bay of Plenty', 1),
(2352, 153, 'CAN', 'Canterbury', 1),
(2353, 153, 'COR', 'Coromandel', 1),
(2354, 153, 'GIS', 'Gisborne', 1),
(2355, 153, 'FIO', 'Fiordland', 1),
(2356, 153, 'HKB', 'Hawke&#039;s Bay', 1),
(2357, 153, 'MBH', 'Marlborough', 1),
(2358, 153, 'MWT', 'Manawatu-Wanganui', 1),
(2359, 153, 'MCM', 'Mt Cook-Mackenzie', 1),
(2360, 153, 'NSN', 'Nelson', 1),
(2361, 153, 'NTL', 'Northland', 1),
(2362, 153, 'OTA', 'Otago', 1),
(2363, 153, 'STL', 'Southland', 1),
(2364, 153, 'TKI', 'Taranaki', 1),
(2365, 153, 'WGN', 'Wellington', 1),
(2366, 153, 'WKO', 'Waikato', 1),
(2367, 153, 'WAI', 'Wairprarapa', 1),
(2368, 153, 'WTC', 'West Coast', 1),
(2369, 154, 'AN', 'Atlantico Norte', 1),
(2370, 154, 'AS', 'Atlantico Sur', 1),
(2371, 154, 'BO', 'Boaco', 1),
(2372, 154, 'CA', 'Carazo', 1),
(2373, 154, 'CI', 'Chinandega', 1),
(2374, 154, 'CO', 'Chontales', 1),
(2375, 154, 'ES', 'Esteli', 1),
(2376, 154, 'GR', 'Granada', 1),
(2377, 154, 'JI', 'Jinotega', 1),
(2378, 154, 'LE', 'Leon', 1),
(2379, 154, 'MD', 'Madriz', 1),
(2380, 154, 'MN', 'Managua', 1),
(2381, 154, 'MS', 'Masaya', 1),
(2382, 154, 'MT', 'Matagalpa', 1),
(2383, 154, 'NS', 'Nuevo Segovia', 1),
(2384, 154, 'RS', 'Rio San Juan', 1),
(2385, 154, 'RI', 'Rivas', 1),
(2386, 155, 'AG', 'Agadez', 1),
(2387, 155, 'DF', 'Diffa', 1),
(2388, 155, 'DS', 'Dosso', 1),
(2389, 155, 'MA', 'Maradi', 1),
(2390, 155, 'NM', 'Niamey', 1),
(2391, 155, 'TH', 'Tahoua', 1),
(2392, 155, 'TL', 'Tillaberi', 1),
(2393, 155, 'ZD', 'Zinder', 1),
(2394, 156, 'AB', 'Abia', 1),
(2395, 156, 'CT', 'Abuja Federal Capital Territory', 1),
(2396, 156, 'AD', 'Adamawa', 1),
(2397, 156, 'AK', 'Akwa Ibom', 1),
(2398, 156, 'AN', 'Anambra', 1),
(2399, 156, 'BC', 'Bauchi', 1),
(2400, 156, 'BY', 'Bayelsa', 1),
(2401, 156, 'BN', 'Benue', 1),
(2402, 156, 'BO', 'Borno', 1),
(2403, 156, 'CR', 'Cross River', 1),
(2404, 156, 'DE', 'Delta', 1),
(2405, 156, 'EB', 'Ebonyi', 1),
(2406, 156, 'ED', 'Edo', 1),
(2407, 156, 'EK', 'Ekiti', 1),
(2408, 156, 'EN', 'Enugu', 1),
(2409, 156, 'GO', 'Gombe', 1),
(2410, 156, 'IM', 'Imo', 1),
(2411, 156, 'JI', 'Jigawa', 1),
(2412, 156, 'KD', 'Kaduna', 1),
(2413, 156, 'KN', 'Kano', 1),
(2414, 156, 'KT', 'Katsina', 1),
(2415, 156, 'KE', 'Kebbi', 1),
(2416, 156, 'KO', 'Kogi', 1),
(2417, 156, 'KW', 'Kwara', 1),
(2418, 156, 'LA', 'Lagos', 1),
(2419, 156, 'NA', 'Nassarawa', 1),
(2420, 156, 'NI', 'Niger', 1),
(2421, 156, 'OG', 'Ogun', 1),
(2422, 156, 'ONG', 'Ondo', 1),
(2423, 156, 'OS', 'Osun', 1),
(2424, 156, 'OY', 'Oyo', 1),
(2425, 156, 'PL', 'Plateau', 1),
(2426, 156, 'RI', 'Rivers', 1),
(2427, 156, 'SO', 'Sokoto', 1),
(2428, 156, 'TA', 'Taraba', 1),
(2429, 156, 'YO', 'Yobe', 1),
(2430, 156, 'ZA', 'Zamfara', 1),
(2431, 159, 'N', 'Northern Islands', 1),
(2432, 159, 'R', 'Rota', 1),
(2433, 159, 'S', 'Saipan', 1),
(2434, 159, 'T', 'Tinian', 1),
(2435, 160, 'AK', 'Akershus', 1),
(2436, 160, 'AA', 'Aust-Agder', 1),
(2437, 160, 'BU', 'Buskerud', 1),
(2438, 160, 'FM', 'Finnmark', 1),
(2439, 160, 'HM', 'Hedmark', 1),
(2440, 160, 'HL', 'Hordaland', 1),
(2441, 160, 'MR', 'More og Romdal', 1),
(2442, 160, 'NT', 'Nord-Trondelag', 1),
(2443, 160, 'NL', 'Nordland', 1),
(2444, 160, 'OF', 'Ostfold', 1),
(2445, 160, 'OP', 'Oppland', 1),
(2446, 160, 'OL', 'Oslo', 1),
(2447, 160, 'RL', 'Rogaland', 1),
(2448, 160, 'ST', 'Sor-Trondelag', 1),
(2449, 160, 'SJ', 'Sogn og Fjordane', 1),
(2450, 160, 'SV', 'Svalbard', 1),
(2451, 160, 'TM', 'Telemark', 1),
(2452, 160, 'TR', 'Troms', 1),
(2453, 160, 'VA', 'Vest-Agder', 1),
(2454, 160, 'VF', 'Vestfold', 1),
(2455, 161, 'DA', 'Ad Dakhiliyah', 1),
(2456, 161, 'BA', 'Al Batinah', 1),
(2457, 161, 'WU', 'Al Wusta', 1),
(2458, 161, 'SH', 'Ash Sharqiyah', 1),
(2459, 161, 'ZA', 'Az Zahirah', 1),
(2460, 161, 'MA', 'Masqat', 1),
(2461, 161, 'MU', 'Musandam', 1),
(2462, 161, 'ZU', 'Zufar', 1),
(2463, 162, 'B', 'Balochistan', 1),
(2464, 162, 'T', 'Federally Administered Tribal Ar', 1),
(2465, 162, 'I', 'Islamabad Capital Territory', 1),
(2466, 162, 'N', 'North-West Frontier', 1),
(2467, 162, 'P', 'Punjab', 1),
(2468, 162, 'S', 'Sindh', 1),
(2469, 163, 'AM', 'Aimeliik', 1),
(2470, 163, 'AR', 'Airai', 1),
(2471, 163, 'AN', 'Angaur', 1),
(2472, 163, 'HA', 'Hatohobei', 1),
(2473, 163, 'KA', 'Kayangel', 1),
(2474, 163, 'KO', 'Koror', 1),
(2475, 163, 'ME', 'Melekeok', 1),
(2476, 163, 'NA', 'Ngaraard', 1),
(2477, 163, 'NG', 'Ngarchelong', 1),
(2478, 163, 'ND', 'Ngardmau', 1),
(2479, 163, 'NT', 'Ngatpang', 1),
(2480, 163, 'NC', 'Ngchesar', 1),
(2481, 163, 'NR', 'Ngeremlengui', 1),
(2482, 163, 'NW', 'Ngiwal', 1),
(2483, 163, 'PE', 'Peleliu', 1),
(2484, 163, 'SO', 'Sonsorol', 1),
(2485, 164, 'BT', 'Bocas del Toro', 1),
(2486, 164, 'CH', 'Chiriqui', 1),
(2487, 164, 'CC', 'Cocle', 1),
(2488, 164, 'CL', 'Colon', 1),
(2489, 164, 'DA', 'Darien', 1),
(2490, 164, 'HE', 'Herrera', 1),
(2491, 164, 'LS', 'Los Santos', 1),
(2492, 164, 'PA', 'Panama', 1),
(2493, 164, 'SB', 'San Blas', 1),
(2494, 164, 'VG', 'Veraguas', 1),
(2495, 165, 'BV', 'Bougainville', 1),
(2496, 165, 'CE', 'Central', 1),
(2497, 165, 'CH', 'Chimbu', 1),
(2498, 165, 'EH', 'Eastern Highlands', 1),
(2499, 165, 'EB', 'East New Britain', 1),
(2500, 165, 'ES', 'East Sepik', 1),
(2501, 165, 'EN', 'Enga', 1),
(2502, 165, 'GU', 'Gulf', 1),
(2503, 165, 'MD', 'Madang', 1),
(2504, 165, 'MN', 'Manus', 1),
(2505, 165, 'MB', 'Milne Bay', 1),
(2506, 165, 'MR', 'Morobe', 1),
(2507, 165, 'NC', 'National Capital', 1),
(2508, 165, 'NI', 'New Ireland', 1),
(2509, 165, 'NO', 'Northern', 1),
(2510, 165, 'SA', 'Sandaun', 1),
(2511, 165, 'SH', 'Southern Highlands', 1),
(2512, 165, 'WE', 'Western', 1),
(2513, 165, 'WH', 'Western Highlands', 1),
(2514, 165, 'WB', 'West New Britain', 1),
(2515, 166, 'AG', 'Alto Paraguay', 1),
(2516, 166, 'AN', 'Alto Parana', 1),
(2517, 166, 'AM', 'Amambay', 1),
(2518, 166, 'AS', 'Asuncion', 1),
(2519, 166, 'BO', 'Boqueron', 1),
(2520, 166, 'CG', 'Caaguazu', 1),
(2521, 166, 'CZ', 'Caazapa', 1),
(2522, 166, 'CN', 'Canindeyu', 1),
(2523, 166, 'CE', 'Central', 1),
(2524, 166, 'CC', 'Concepcion', 1),
(2525, 166, 'CD', 'Cordillera', 1),
(2526, 166, 'GU', 'Guaira', 1),
(2527, 166, 'IT', 'Itapua', 1),
(2528, 166, 'MI', 'Misiones', 1),
(2529, 166, 'NE', 'Neembucu', 1),
(2530, 166, 'PA', 'Paraguari', 1),
(2531, 166, 'PH', 'Presidente Hayes', 1),
(2532, 166, 'SP', 'San Pedro', 1),
(2533, 167, 'AM', 'Amazonas', 1),
(2534, 167, 'AN', 'Ancash', 1),
(2535, 167, 'AP', 'Apurimac', 1),
(2536, 167, 'AR', 'Arequipa', 1),
(2537, 167, 'AY', 'Ayacucho', 1),
(2538, 167, 'CJ', 'Cajamarca', 1),
(2539, 167, 'CL', 'Callao', 1),
(2540, 167, 'CU', 'Cusco', 1),
(2541, 167, 'HV', 'Huancavelica', 1),
(2542, 167, 'HO', 'Huanuco', 1),
(2543, 167, 'IC', 'Ica', 1),
(2544, 167, 'JU', 'Junin', 1),
(2545, 167, 'LD', 'La Libertad', 1),
(2546, 167, 'LY', 'Lambayeque', 1),
(2547, 167, 'LI', 'Lima', 1),
(2548, 167, 'LO', 'Loreto', 1),
(2549, 167, 'MD', 'Madre de Dios', 1),
(2550, 167, 'MO', 'Moquegua', 1),
(2551, 167, 'PA', 'Pasco', 1),
(2552, 167, 'PI', 'Piura', 1),
(2553, 167, 'PU', 'Puno', 1),
(2554, 167, 'SM', 'San Martin', 1),
(2555, 167, 'TA', 'Tacna', 1),
(2556, 167, 'TU', 'Tumbes', 1),
(2557, 167, 'UC', 'Ucayali', 1),
(2558, 168, 'ABR', 'Abra', 1),
(2559, 168, 'ANO', 'Agusan del Norte', 1),
(2560, 168, 'ASU', 'Agusan del Sur', 1),
(2561, 168, 'AKL', 'Aklan', 1),
(2562, 168, 'ALB', 'Albay', 1),
(2563, 168, 'ANT', 'Antique', 1),
(2564, 168, 'APY', 'Apayao', 1),
(2565, 168, 'AUR', 'Aurora', 1),
(2566, 168, 'BAS', 'Basilan', 1),
(2567, 168, 'BTA', 'Bataan', 1),
(2568, 168, 'BTE', 'Batanes', 1),
(2569, 168, 'BTG', 'Batangas', 1),
(2570, 168, 'BLR', 'Biliran', 1),
(2571, 168, 'BEN', 'Benguet', 1),
(2572, 168, 'BOL', 'Bohol', 1),
(2573, 168, 'BUK', 'Bukidnon', 1),
(2574, 168, 'BUL', 'Bulacan', 1),
(2575, 168, 'CAG', 'Cagayan', 1),
(2576, 168, 'CNO', 'Camarines Norte', 1),
(2577, 168, 'CSU', 'Camarines Sur', 1),
(2578, 168, 'CAM', 'Camiguin', 1),
(2579, 168, 'CAP', 'Capiz', 1),
(2580, 168, 'CAT', 'Catanduanes', 1),
(2581, 168, 'CAV', 'Cavite', 1),
(2582, 168, 'CEB', 'Cebu', 1),
(2583, 168, 'CMP', 'Compostela', 1),
(2584, 168, 'DNO', 'Davao del Norte', 1),
(2585, 168, 'DSU', 'Davao del Sur', 1),
(2586, 168, 'DOR', 'Davao Oriental', 1),
(2587, 168, 'ESA', 'Eastern Samar', 1),
(2588, 168, 'GUI', 'Guimaras', 1),
(2589, 168, 'IFU', 'Ifugao', 1),
(2590, 168, 'INO', 'Ilocos Norte', 1),
(2591, 168, 'ISU', 'Ilocos Sur', 1),
(2592, 168, 'ILO', 'Iloilo', 1),
(2593, 168, 'ISA', 'Isabela', 1),
(2594, 168, 'KAL', 'Kalinga', 1),
(2595, 168, 'LAG', 'Laguna', 1),
(2596, 168, 'LNO', 'Lanao del Norte', 1),
(2597, 168, 'LSU', 'Lanao del Sur', 1),
(2598, 168, 'UNI', 'La Union', 1),
(2599, 168, 'LEY', 'Leyte', 1),
(2600, 168, 'MAG', 'Maguindanao', 1),
(2601, 168, 'MRN', 'Marinduque', 1),
(2602, 168, 'MSB', 'Masbate', 1),
(2603, 168, 'MIC', 'Mindoro Occidental', 1),
(2604, 168, 'MIR', 'Mindoro Oriental', 1),
(2605, 168, 'MSC', 'Misamis Occidental', 1),
(2606, 168, 'MOR', 'Misamis Oriental', 1),
(2607, 168, 'MOP', 'Mountain', 1),
(2608, 168, 'NOC', 'Negros Occidental', 1),
(2609, 168, 'NOR', 'Negros Oriental', 1),
(2610, 168, 'NCT', 'North Cotabato', 1),
(2611, 168, 'NSM', 'Northern Samar', 1),
(2612, 168, 'NEC', 'Nueva Ecija', 1),
(2613, 168, 'NVZ', 'Nueva Vizcaya', 1),
(2614, 168, 'PLW', 'Palawan', 1),
(2615, 168, 'PMP', 'Pampanga', 1),
(2616, 168, 'PNG', 'Pangasinan', 1),
(2617, 168, 'QZN', 'Quezon', 1),
(2618, 168, 'QRN', 'Quirino', 1),
(2619, 168, 'RIZ', 'Rizal', 1),
(2620, 168, 'ROM', 'Romblon', 1),
(2621, 168, 'SMR', 'Samar', 1),
(2622, 168, 'SRG', 'Sarangani', 1),
(2623, 168, 'SQJ', 'Siquijor', 1),
(2624, 168, 'SRS', 'Sorsogon', 1),
(2625, 168, 'SCO', 'South Cotabato', 1),
(2626, 168, 'SLE', 'Southern Leyte', 1),
(2627, 168, 'SKU', 'Sultan Kudarat', 1),
(2628, 168, 'SLU', 'Sulu', 1),
(2629, 168, 'SNO', 'Surigao del Norte', 1),
(2630, 168, 'SSU', 'Surigao del Sur', 1),
(2631, 168, 'TAR', 'Tarlac', 1),
(2632, 168, 'TAW', 'Tawi-Tawi', 1),
(2633, 168, 'ZBL', 'Zambales', 1),
(2634, 168, 'ZNO', 'Zamboanga del Norte', 1),
(2635, 168, 'ZSU', 'Zamboanga del Sur', 1),
(2636, 168, 'ZSI', 'Zamboanga Sibugay', 1),
(2637, 170, 'DO', 'Dolnoslaskie', 1),
(2638, 170, 'KP', 'Kujawsko-Pomorskie', 1),
(2639, 170, 'LO', 'Lodzkie', 1),
(2640, 170, 'LL', 'Lubelskie', 1),
(2641, 170, 'LU', 'Lubuskie', 1),
(2642, 170, 'ML', 'Malopolskie', 1),
(2643, 170, 'MZ', 'Mazowieckie', 1),
(2644, 170, 'OP', 'Opolskie', 1),
(2645, 170, 'PP', 'Podkarpackie', 1),
(2646, 170, 'PL', 'Podlaskie', 1),
(2647, 170, 'PM', 'Pomorskie', 1),
(2648, 170, 'SL', 'Slaskie', 1),
(2649, 170, 'SW', 'Swietokrzyskie', 1),
(2650, 170, 'WM', 'Warminsko-Mazurskie', 1),
(2651, 170, 'WP', 'Wielkopolskie', 1),
(2652, 170, 'ZA', 'Zachodniopomorskie', 1),
(2653, 198, 'P', 'Saint Pierre', 1),
(2654, 198, 'M', 'Miquelon', 1),
(2655, 171, 'AC', 'Açores', 1),
(2656, 171, 'AV', 'Aveiro', 1),
(2657, 171, 'BE', 'Beja', 1),
(2658, 171, 'BR', 'Braga', 1),
(2659, 171, 'BA', 'Bragança', 1),
(2660, 171, 'CB', 'Castelo Branco', 1),
(2661, 171, 'CO', 'Coimbra', 1),
(2662, 171, 'EV', 'é;vora', 1),
(2663, 171, 'FA', 'Faro', 1),
(2664, 171, 'GU', 'Guarda', 1),
(2665, 171, 'LE', 'Leiria', 1),
(2666, 171, 'LI', 'Lisboa', 1),
(2667, 171, 'ME', 'Madeira', 1),
(2668, 171, 'PO', 'Portalegre', 1),
(2669, 171, 'PR', 'Porto', 1),
(2670, 171, 'SA', 'Santaré;m', 1),
(2671, 171, 'SE', 'Setúbal', 1),
(2672, 171, 'VC', 'Viana do Castelo', 1),
(2673, 171, 'VR', 'Vila Real', 1),
(2674, 171, 'VI', 'Viseu', 1),
(2675, 173, 'DW', 'Ad Dawhah', 1),
(2676, 173, 'GW', 'Al Ghuwayriyah', 1),
(2677, 173, 'JM', 'Al Jumayliyah', 1),
(2678, 173, 'KR', 'Al Khawr', 1),
(2679, 173, 'WK', 'Al Wakrah', 1),
(2680, 173, 'RN', 'Ar Rayyan', 1),
(2681, 173, 'JB', 'Jarayan al Batinah', 1),
(2682, 173, 'MS', 'Madinat ash Shamal', 1),
(2683, 173, 'UD', 'Umm Sa&#039;id', 1),
(2684, 173, 'UL', 'Umm Salal', 1),
(2685, 175, 'AB', 'Alba', 1),
(2686, 175, 'AR', 'Arad', 1),
(2687, 175, 'AG', 'Arges', 1),
(2688, 175, 'BC', 'Bacau', 1),
(2689, 175, 'BH', 'Bihor', 1),
(2690, 175, 'BN', 'Bistrita-Nasaud', 1),
(2691, 175, 'BT', 'Botosani', 1),
(2692, 175, 'BV', 'Brasov', 1),
(2693, 175, 'BR', 'Braila', 1),
(2694, 175, 'B', 'Bucuresti', 1),
(2695, 175, 'BZ', 'Buzau', 1),
(2696, 175, 'CS', 'Caras-Severin', 1),
(2697, 175, 'CL', 'Calarasi', 1),
(2698, 175, 'CJ', 'Cluj', 1),
(2699, 175, 'CT', 'Constanta', 1),
(2700, 175, 'CV', 'Covasna', 1),
(2701, 175, 'DB', 'Dimbovita', 1),
(2702, 175, 'DJ', 'Dolj', 1),
(2703, 175, 'GL', 'Galati', 1),
(2704, 175, 'GR', 'Giurgiu', 1),
(2705, 175, 'GJ', 'Gorj', 1),
(2706, 175, 'HR', 'Harghita', 1),
(2707, 175, 'HD', 'Hunedoara', 1),
(2708, 175, 'IL', 'Ialomita', 1),
(2709, 175, 'IS', 'Iasi', 1),
(2710, 175, 'IF', 'Ilfov', 1),
(2711, 175, 'MM', 'Maramures', 1),
(2712, 175, 'MH', 'Mehedinti', 1),
(2713, 175, 'MS', 'Mures', 1),
(2714, 175, 'NT', 'Neamt', 1),
(2715, 175, 'OT', 'Olt', 1),
(2716, 175, 'PH', 'Prahova', 1),
(2717, 175, 'SM', 'Satu-Mare', 1),
(2718, 175, 'SJ', 'Salaj', 1),
(2719, 175, 'SB', 'Sibiu', 1),
(2720, 175, 'SV', 'Suceava', 1),
(2721, 175, 'TR', 'Teleorman', 1),
(2722, 175, 'TM', 'Timis', 1),
(2723, 175, 'TL', 'Tulcea', 1),
(2724, 175, 'VS', 'Vaslui', 1),
(2725, 175, 'VL', 'Valcea', 1),
(2726, 175, 'VN', 'Vrancea', 1),
(2727, 176, 'AB', 'Abakan', 1),
(2728, 176, 'AG', 'Aginskoye', 1),
(2729, 176, 'AN', 'Anadyr', 1),
(2730, 176, 'AR', 'Arkahangelsk', 1),
(2731, 176, 'AS', 'Astrakhan', 1),
(2732, 176, 'BA', 'Barnaul', 1),
(2733, 176, 'BE', 'Belgorod', 1),
(2734, 176, 'BI', 'Birobidzhan', 1),
(2735, 176, 'BL', 'Blagoveshchensk', 1),
(2736, 176, 'BR', 'Bryansk', 1),
(2737, 176, 'CH', 'Cheboksary', 1),
(2738, 176, 'CL', 'Chelyabinsk', 1),
(2739, 176, 'CR', 'Cherkessk', 1),
(2740, 176, 'CI', 'Chita', 1),
(2741, 176, 'DU', 'Dudinka', 1),
(2742, 176, 'EL', 'Elista', 1),
(2743, 176, 'GO', 'Gomo-Altaysk', 1),
(2744, 176, 'GA', 'Gorno-Altaysk', 1),
(2745, 176, 'GR', 'Groznyy', 1),
(2746, 176, 'IR', 'Irkutsk', 1),
(2747, 176, 'IV', 'Ivanovo', 1),
(2748, 176, 'IZ', 'Izhevsk', 1),
(2749, 176, 'KA', 'Kalinigrad', 1),
(2750, 176, 'KL', 'Kaluga', 1),
(2751, 176, 'KS', 'Kasnodar', 1),
(2752, 176, 'KZ', 'Kazan', 1),
(2753, 176, 'KE', 'Kemerovo', 1),
(2754, 176, 'KH', 'Khabarovsk', 1),
(2755, 176, 'KM', 'Khanty-Mansiysk', 1),
(2756, 176, 'KO', 'Kostroma', 1),
(2757, 176, 'KR', 'Krasnodar', 1),
(2758, 176, 'KN', 'Krasnoyarsk', 1),
(2759, 176, 'KU', 'Kudymkar', 1),
(2760, 176, 'KG', 'Kurgan', 1),
(2761, 176, 'KK', 'Kursk', 1),
(2762, 176, 'KY', 'Kyzyl', 1),
(2763, 176, 'LI', 'Lipetsk', 1),
(2764, 176, 'MA', 'Magadan', 1),
(2765, 176, 'MK', 'Makhachkala', 1),
(2766, 176, 'MY', 'Maykop', 1),
(2767, 176, 'MO', 'Moscow', 1),
(2768, 176, 'MU', 'Murmansk', 1),
(2769, 176, 'NA', 'Nalchik', 1),
(2770, 176, 'NR', 'Naryan Mar', 1),
(2771, 176, 'NZ', 'Nazran', 1),
(2772, 176, 'NI', 'Nizhniy Novgorod', 1),
(2773, 176, 'NO', 'Novgorod', 1),
(2774, 176, 'NV', 'Novosibirsk', 1),
(2775, 176, 'OM', 'Omsk', 1),
(2776, 176, 'OR', 'Orel', 1),
(2777, 176, 'OE', 'Orenburg', 1),
(2778, 176, 'PA', 'Palana', 1),
(2779, 176, 'PE', 'Penza', 1),
(2780, 176, 'PR', 'Perm', 1),
(2781, 176, 'PK', 'Petropavlovsk-Kamchatskiy', 1),
(2782, 176, 'PT', 'Petrozavodsk', 1),
(2783, 176, 'PS', 'Pskov', 1),
(2784, 176, 'RO', 'Rostov-na-Donu', 1),
(2785, 176, 'RY', 'Ryazan', 1),
(2786, 176, 'SL', 'Salekhard', 1),
(2787, 176, 'SA', 'Samara', 1),
(2788, 176, 'SR', 'Saransk', 1),
(2789, 176, 'SV', 'Saratov', 1),
(2790, 176, 'SM', 'Smolensk', 1),
(2791, 176, 'SP', 'St. Petersburg', 1),
(2792, 176, 'ST', 'Stavropol', 1),
(2793, 176, 'SY', 'Syktyvkar', 1),
(2794, 176, 'TA', 'Tambov', 1),
(2795, 176, 'TO', 'Tomsk', 1),
(2796, 176, 'TU', 'Tula', 1),
(2797, 176, 'TR', 'Tura', 1),
(2798, 176, 'TV', 'Tver', 1),
(2799, 176, 'TY', 'Tyumen', 1),
(2800, 176, 'UF', 'Ufa', 1),
(2801, 176, 'UL', 'Ul&#039;yanovsk', 1),
(2802, 176, 'UU', 'Ulan-Ude', 1),
(2803, 176, 'US', 'Ust&#039;-Ordynskiy', 1),
(2804, 176, 'VL', 'Vladikavkaz', 1),
(2805, 176, 'VA', 'Vladimir', 1),
(2806, 176, 'VV', 'Vladivostok', 1),
(2807, 176, 'VG', 'Volgograd', 1),
(2808, 176, 'VD', 'Vologda', 1),
(2809, 176, 'VO', 'Voronezh', 1),
(2810, 176, 'VY', 'Vyatka', 1),
(2811, 176, 'YA', 'Yakutsk', 1),
(2812, 176, 'YR', 'Yaroslavl', 1),
(2813, 176, 'YE', 'Yekaterinburg', 1),
(2814, 176, 'YO', 'Yoshkar-Ola', 1),
(2815, 177, 'BU', 'Butare', 1),
(2816, 177, 'BY', 'Byumba', 1),
(2817, 177, 'CY', 'Cyangugu', 1),
(2818, 177, 'GK', 'Gikongoro', 1),
(2819, 177, 'GS', 'Gisenyi', 1),
(2820, 177, 'GT', 'Gitarama', 1),
(2821, 177, 'KG', 'Kibungo', 1),
(2822, 177, 'KY', 'Kibuye', 1),
(2823, 177, 'KR', 'Kigali Rurale', 1),
(2824, 177, 'KV', 'Kigali-ville', 1),
(2825, 177, 'RU', 'Ruhengeri', 1),
(2826, 177, 'UM', 'Umutara', 1),
(2827, 178, 'CCN', 'Christ Church Nichola Town', 1),
(2828, 178, 'SAS', 'Saint Anne Sandy Point', 1),
(2829, 178, 'SGB', 'Saint George Basseterre', 1),
(2830, 178, 'SGG', 'Saint George Gingerland', 1),
(2831, 178, 'SJW', 'Saint James Windward', 1),
(2832, 178, 'SJC', 'Saint John Capesterre', 1),
(2833, 178, 'SJF', 'Saint John Figtree', 1),
(2834, 178, 'SMC', 'Saint Mary Cayon', 1),
(2835, 178, 'CAP', 'Saint Paul Capesterre', 1),
(2836, 178, 'CHA', 'Saint Paul Charlestown', 1),
(2837, 178, 'SPB', 'Saint Peter Basseterre', 1),
(2838, 178, 'STL', 'Saint Thomas Lowland', 1),
(2839, 178, 'STM', 'Saint Thomas Middle Island', 1),
(2840, 178, 'TPP', 'Trinity Palmetto Point', 1),
(2841, 179, 'AR', 'Anse-la-Raye', 1),
(2842, 179, 'CA', 'Castries', 1),
(2843, 179, 'CH', 'Choiseul', 1),
(2844, 179, 'DA', 'Dauphin', 1),
(2845, 179, 'DE', 'Dennery', 1),
(2846, 179, 'GI', 'Gros-Islet', 1),
(2847, 179, 'LA', 'Laborie', 1),
(2848, 179, 'MI', 'Micoud', 1),
(2849, 179, 'PR', 'Praslin', 1),
(2850, 179, 'SO', 'Soufriere', 1),
(2851, 179, 'VF', 'Vieux-Fort', 1),
(2852, 180, 'C', 'Charlotte', 1),
(2853, 180, 'R', 'Grenadines', 1),
(2854, 180, 'A', 'Saint Andrew', 1),
(2855, 180, 'D', 'Saint David', 1),
(2856, 180, 'G', 'Saint George', 1),
(2857, 180, 'P', 'Saint Patrick', 1),
(2858, 181, 'AN', 'A&#039;ana', 1),
(2859, 181, 'AI', 'Aiga-i-le-Tai', 1),
(2860, 181, 'AT', 'Atua', 1),
(2861, 181, 'FA', 'Fa&#039;asaleleaga', 1),
(2862, 181, 'GE', 'Gaga&#039;emauga', 1),
(2863, 181, 'GF', 'Gagaifomauga', 1),
(2864, 181, 'PA', 'Palauli', 1),
(2865, 181, 'SA', 'Satupa&#039;itea', 1),
(2866, 181, 'TU', 'Tuamasaga', 1),
(2867, 181, 'VF', 'Va&#039;a-o-Fonoti', 1),
(2868, 181, 'VS', 'Vaisigano', 1),
(2869, 182, 'AC', 'Acquaviva', 1),
(2870, 182, 'BM', 'Borgo Maggiore', 1),
(2871, 182, 'CH', 'Chiesanuova', 1),
(2872, 182, 'DO', 'Domagnano', 1),
(2873, 182, 'FA', 'Faetano', 1),
(2874, 182, 'FI', 'Fiorentino', 1),
(2875, 182, 'MO', 'Montegiardino', 1),
(2876, 182, 'SM', 'Citta di San Marino', 1),
(2877, 182, 'SE', 'Serravalle', 1),
(2878, 183, 'S', 'Sao Tome', 1),
(2879, 183, 'P', 'Principe', 1),
(2880, 184, 'BH', 'Al Bahah', 1),
(2881, 184, 'HS', 'Al Hudud ash Shamaliyah', 1),
(2882, 184, 'JF', 'Al Jawf', 1),
(2883, 184, 'MD', 'Al Madinah', 1),
(2884, 184, 'QS', 'Al Qasim', 1),
(2885, 184, 'RD', 'Ar Riyad', 1),
(2886, 184, 'AQ', 'Ash Sharqiyah (Eastern)', 1),
(2887, 184, 'AS', '&#039;Asir', 1),
(2888, 184, 'HL', 'Ha&#039;il', 1),
(2889, 184, 'JZ', 'Jizan', 1),
(2890, 184, 'ML', 'Makkah', 1),
(2891, 184, 'NR', 'Najran', 1),
(2892, 184, 'TB', 'Tabuk', 1),
(2893, 185, 'DA', 'Dakar', 1),
(2894, 185, 'DI', 'Diourbel', 1),
(2895, 185, 'FA', 'Fatick', 1),
(2896, 185, 'KA', 'Kaolack', 1),
(2897, 185, 'KO', 'Kolda', 1),
(2898, 185, 'LO', 'Louga', 1),
(2899, 185, 'MA', 'Matam', 1),
(2900, 185, 'SL', 'Saint-Louis', 1),
(2901, 185, 'TA', 'Tambacounda', 1),
(2902, 185, 'TH', 'Thies', 1),
(2903, 185, 'ZI', 'Ziguinchor', 1),
(2904, 186, 'AP', 'Anse aux Pins', 1),
(2905, 186, 'AB', 'Anse Boileau', 1),
(2906, 186, 'AE', 'Anse Etoile', 1),
(2907, 186, 'AL', 'Anse Louis', 1),
(2908, 186, 'AR', 'Anse Royale', 1),
(2909, 186, 'BL', 'Baie Lazare', 1),
(2910, 186, 'BS', 'Baie Sainte Anne', 1),
(2911, 186, 'BV', 'Beau Vallon', 1),
(2912, 186, 'BA', 'Bel Air', 1),
(2913, 186, 'BO', 'Bel Ombre', 1),
(2914, 186, 'CA', 'Cascade', 1),
(2915, 186, 'GL', 'Glacis', 1),
(2916, 186, 'GM', 'Grand&#039; Anse (on Mahe)', 1),
(2917, 186, 'GP', 'Grand&#039; Anse (on Praslin)', 1),
(2918, 186, 'DG', 'La Digue', 1),
(2919, 186, 'RA', 'La Riviere Anglaise', 1),
(2920, 186, 'MB', 'Mont Buxton', 1),
(2921, 186, 'MF', 'Mont Fleuri', 1),
(2922, 186, 'PL', 'Plaisance', 1),
(2923, 186, 'PR', 'Pointe La Rue', 1),
(2924, 186, 'PG', 'Port Glaud', 1),
(2925, 186, 'SL', 'Saint Louis', 1),
(2926, 186, 'TA', 'Takamaka', 1),
(2927, 187, 'E', 'Eastern', 1),
(2928, 187, 'N', 'Northern', 1),
(2929, 187, 'S', 'Southern', 1),
(2930, 187, 'W', 'Western', 1),
(2931, 189, 'BA', 'Banskobystricky', 1),
(2932, 189, 'BR', 'Bratislavsky', 1),
(2933, 189, 'KO', 'Kosicky', 1),
(2934, 189, 'NI', 'Nitriansky', 1),
(2935, 189, 'PR', 'Presovsky', 1),
(2936, 189, 'TC', 'Trenciansky', 1),
(2937, 189, 'TV', 'Trnavsky', 1),
(2938, 189, 'ZI', 'Zilinsky', 1),
(2939, 191, 'CE', 'Central', 1),
(2940, 191, 'CH', 'Choiseul', 1),
(2941, 191, 'GC', 'Guadalcanal', 1),
(2942, 191, 'HO', 'Honiara', 1),
(2943, 191, 'IS', 'Isabel', 1),
(2944, 191, 'MK', 'Makira', 1),
(2945, 191, 'ML', 'Malaita', 1),
(2946, 191, 'RB', 'Rennell and Bellona', 1),
(2947, 191, 'TM', 'Temotu', 1),
(2948, 191, 'WE', 'Western', 1),
(2949, 192, 'AW', 'Awdal', 1),
(2950, 192, 'BK', 'Bakool', 1),
(2951, 192, 'BN', 'Banaadir', 1),
(2952, 192, 'BR', 'Bari', 1),
(2953, 192, 'BY', 'Bay', 1),
(2954, 192, 'GA', 'Galguduud', 1),
(2955, 192, 'GE', 'Gedo', 1),
(2956, 192, 'HI', 'Hiiraan', 1),
(2957, 192, 'JD', 'Jubbada Dhexe', 1),
(2958, 192, 'JH', 'Jubbada Hoose', 1),
(2959, 192, 'MU', 'Mudug', 1),
(2960, 192, 'NU', 'Nugaal', 1),
(2961, 192, 'SA', 'Sanaag', 1),
(2962, 192, 'SD', 'Shabeellaha Dhexe', 1),
(2963, 192, 'SH', 'Shabeellaha Hoose', 1),
(2964, 192, 'SL', 'Sool', 1),
(2965, 192, 'TO', 'Togdheer', 1),
(2966, 192, 'WG', 'Woqooyi Galbeed', 1),
(2967, 193, 'EC', 'Eastern Cape', 1),
(2968, 193, 'FS', 'Free State', 1),
(2969, 193, 'GT', 'Gauteng', 1),
(2970, 193, 'KN', 'KwaZulu-Natal', 1),
(2971, 193, 'LP', 'Limpopo', 1),
(2972, 193, 'MP', 'Mpumalanga', 1),
(2973, 193, 'NW', 'North West', 1),
(2974, 193, 'NC', 'Northern Cape', 1),
(2975, 193, 'WC', 'Western Cape', 1),
(2976, 195, 'CA', 'A Coru&#241;a', 1),
(2977, 195, 'AL', 'Álava', 1),
(2978, 195, 'AB', 'Albacete', 1),
(2979, 195, 'AC', 'Alicante', 1),
(2980, 195, 'AM', 'Almeria', 1),
(2981, 195, 'AS', 'Asturias', 1),
(2982, 195, 'AV', 'Ávila', 1),
(2983, 195, 'BJ', 'Badajoz', 1),
(2984, 195, 'IB', 'Baleares', 1),
(2985, 195, 'BA', 'Barcelona', 1),
(2986, 195, 'BU', 'Burgos', 1),
(2987, 195, 'CC', 'Cáceres', 1),
(2988, 195, 'CZ', 'Cádiz', 1),
(2989, 195, 'CT', 'Cantabria', 1),
(2990, 195, 'CL', 'Castellón', 1),
(2991, 195, 'CE', 'Ceuta', 1),
(2992, 195, 'CR', 'Ciudad Real', 1),
(2993, 195, 'CD', 'Córdoba', 1),
(2994, 195, 'CU', 'Cuenca', 1),
(2995, 195, 'GI', 'Girona', 1),
(2996, 195, 'GD', 'Granada', 1),
(2997, 195, 'GJ', 'Guadalajara', 1),
(2998, 195, 'GP', 'Guipúzcoa', 1),
(2999, 195, 'HL', 'Huelva', 1),
(3000, 195, 'HS', 'Huesca', 1),
(3001, 195, 'JN', 'Jaén', 1),
(3002, 195, 'RJ', 'La Rioja', 1),
(3003, 195, 'PM', 'Las Palmas', 1),
(3004, 195, 'LE', 'Leon', 1),
(3005, 195, 'LL', 'Lleida', 1),
(3006, 195, 'LG', 'Lugo', 1),
(3007, 195, 'MD', 'Madrid', 1),
(3008, 195, 'MA', 'Malaga', 1),
(3009, 195, 'ML', 'Melilla', 1),
(3010, 195, 'MU', 'Murcia', 1),
(3011, 195, 'NV', 'Navarra', 1),
(3012, 195, 'OU', 'Ourense', 1),
(3013, 195, 'PL', 'Palencia', 1),
(3014, 195, 'PO', 'Pontevedra', 1),
(3015, 195, 'SL', 'Salamanca', 1),
(3016, 195, 'SC', 'Santa Cruz de Tenerife', 1),
(3017, 195, 'SG', 'Segovia', 1),
(3018, 195, 'SV', 'Sevilla', 1),
(3019, 195, 'SO', 'Soria', 1),
(3020, 195, 'TA', 'Tarragona', 1),
(3021, 195, 'TE', 'Teruel', 1),
(3022, 195, 'TO', 'Toledo', 1),
(3023, 195, 'VC', 'Valencia', 1),
(3024, 195, 'VD', 'Valladolid', 1),
(3025, 195, 'VZ', 'Vizcaya', 1),
(3026, 195, 'ZM', 'Zamora', 1),
(3027, 195, 'ZR', 'Zaragoza', 1);
INSERT INTO `zone` VALUES
(3028, 196, 'CE', 'Central', 1),
(3029, 196, 'EA', 'Eastern', 1),
(3030, 196, 'NC', 'North Central', 1),
(3031, 196, 'NO', 'Northern', 1),
(3032, 196, 'NW', 'North Western', 1),
(3033, 196, 'SA', 'Sabaragamuwa', 1),
(3034, 196, 'SO', 'Southern', 1),
(3035, 196, 'UV', 'Uva', 1),
(3036, 196, 'WE', 'Western', 1),
(3037, 197, 'A', 'Ascension', 1),
(3038, 197, 'S', 'Saint Helena', 1),
(3039, 197, 'T', 'Tristan da Cunha', 1),
(3040, 199, 'ANL', 'A&#039;ali an Nil', 1),
(3041, 199, 'BAM', 'Al Bahr al Ahmar', 1),
(3042, 199, 'BRT', 'Al Buhayrat', 1),
(3043, 199, 'JZR', 'Al Jazirah', 1),
(3044, 199, 'KRT', 'Al Khartum', 1),
(3045, 199, 'QDR', 'Al Qadarif', 1),
(3046, 199, 'WDH', 'Al Wahdah', 1),
(3047, 199, 'ANB', 'An Nil al Abyad', 1),
(3048, 199, 'ANZ', 'An Nil al Azraq', 1),
(3049, 199, 'ASH', 'Ash Shamaliyah', 1),
(3050, 199, 'BJA', 'Bahr al Jabal', 1),
(3051, 199, 'GIS', 'Gharb al Istiwa&#039;iyah', 1),
(3052, 199, 'GBG', 'Gharb Bahr al Ghazal', 1),
(3053, 199, 'GDA', 'Gharb Darfur', 1),
(3054, 199, 'GKU', 'Gharb Kurdufan', 1),
(3055, 199, 'JDA', 'Janub Darfur', 1),
(3056, 199, 'JKU', 'Janub Kurdufan', 1),
(3057, 199, 'JQL', 'Junqali', 1),
(3058, 199, 'KSL', 'Kassala', 1),
(3059, 199, 'NNL', 'Nahr an Nil', 1),
(3060, 199, 'SBG', 'Shamal Bahr al Ghazal', 1),
(3061, 199, 'SDA', 'Shamal Darfur', 1),
(3062, 199, 'SKU', 'Shamal Kurdufan', 1),
(3063, 199, 'SIS', 'Sharq al Istiwa&#039;iyah', 1),
(3064, 199, 'SNR', 'Sinnar', 1),
(3065, 199, 'WRB', 'Warab', 1),
(3066, 200, 'BR', 'Brokopondo', 1),
(3067, 200, 'CM', 'Commewijne', 1),
(3068, 200, 'CR', 'Coronie', 1),
(3069, 200, 'MA', 'Marowijne', 1),
(3070, 200, 'NI', 'Nickerie', 1),
(3071, 200, 'PA', 'Para', 1),
(3072, 200, 'PM', 'Paramaribo', 1),
(3073, 200, 'SA', 'Saramacca', 1),
(3074, 200, 'SI', 'Sipaliwini', 1),
(3075, 200, 'WA', 'Wanica', 1),
(3076, 202, 'H', 'Hhohho', 1),
(3077, 202, 'L', 'Lubombo', 1),
(3078, 202, 'M', 'Manzini', 1),
(3079, 202, 'S', 'Shishelweni', 1),
(3080, 203, 'K', 'Blekinge', 1),
(3081, 203, 'W', 'Dalama', 1),
(3082, 203, 'X', 'Gävleborg', 1),
(3083, 203, 'I', 'Gotland', 1),
(3084, 203, 'N', 'Halland', 1),
(3085, 203, 'Z', 'Jämtland', 1),
(3086, 203, 'F', 'Jönkping', 1),
(3087, 203, 'H', 'Kalmar', 1),
(3088, 203, 'G', 'Kronoberg', 1),
(3089, 203, 'BD', 'Norrbotten', 1),
(3090, 203, 'T', 'Örebro', 1),
(3091, 203, 'E', 'Östergötland', 1),
(3092, 203, 'M', 'Sk&#229;ne', 1),
(3093, 203, 'D', 'Södermanland', 1),
(3094, 203, 'AB', 'Stockholm', 1),
(3095, 203, 'C', 'Uppsala', 1),
(3096, 203, 'S', 'Värmland', 1),
(3097, 203, 'AC', 'Västerbotten', 1),
(3098, 203, 'Y', 'Västernorrland', 1),
(3099, 203, 'U', 'Västmanland', 1),
(3100, 203, 'O', 'Västra Götaland', 1),
(3101, 204, 'AG', 'Aargau', 1),
(3102, 204, 'AR', 'Appenzell Ausserrhoden', 1),
(3103, 204, 'AI', 'Appenzell Innerrhoden', 1),
(3104, 204, 'BS', 'Basel-Stadt', 1),
(3105, 204, 'BL', 'Basel-Landschaft', 1),
(3106, 204, 'BE', 'Bern', 1),
(3107, 204, 'FR', 'Fribourg', 1),
(3108, 204, 'GE', 'Gen&#232;ve', 1),
(3109, 204, 'GL', 'Glarus', 1),
(3110, 204, 'GR', 'Graubünden', 1),
(3111, 204, 'JU', 'Jura', 1),
(3112, 204, 'LU', 'Luzern', 1),
(3113, 204, 'NE', 'Neuchâtel', 1),
(3114, 204, 'NW', 'Nidwald', 1),
(3115, 204, 'OW', 'Obwald', 1),
(3116, 204, 'SG', 'St. Gallen', 1),
(3117, 204, 'SH', 'Schaffhausen', 1),
(3118, 204, 'SZ', 'Schwyz', 1),
(3119, 204, 'SO', 'Solothurn', 1),
(3120, 204, 'TG', 'Thurgau', 1),
(3121, 204, 'TI', 'Ticino', 1),
(3122, 204, 'UR', 'Uri', 1),
(3123, 204, 'VS', 'Valais', 1),
(3124, 204, 'VD', 'Vaud', 1),
(3125, 204, 'ZG', 'Zug', 1),
(3126, 204, 'ZH', 'Zürich', 1),
(3127, 205, 'HA', 'Al Hasakah', 1),
(3128, 205, 'LA', 'Al Ladhiqiyah', 1),
(3129, 205, 'QU', 'Al Qunaytirah', 1),
(3130, 205, 'RQ', 'Ar Raqqah', 1),
(3131, 205, 'SU', 'As Suwayda', 1),
(3132, 205, 'DA', 'Dara', 1),
(3133, 205, 'DZ', 'Dayr az Zawr', 1),
(3134, 205, 'DI', 'Dimashq', 1),
(3135, 205, 'HL', 'Halab', 1),
(3136, 205, 'HM', 'Hamah', 1),
(3137, 205, 'HI', 'Hims', 1),
(3138, 205, 'ID', 'Idlib', 1),
(3139, 205, 'RD', 'Rif Dimashq', 1),
(3140, 205, 'TA', 'Tartus', 1),
(3141, 206, 'CH', 'Chang-hua', 1),
(3142, 206, 'CI', 'Chia-i', 1),
(3143, 206, 'HS', 'Hsin-chu', 1),
(3144, 206, 'HL', 'Hua-lien', 1),
(3145, 206, 'IL', 'I-lan', 1),
(3146, 206, 'KH', 'Kao-hsiung county', 1),
(3147, 206, 'KM', 'Kin-men', 1),
(3148, 206, 'LC', 'Lien-chiang', 1),
(3149, 206, 'ML', 'Miao-li', 1),
(3150, 206, 'NT', 'Nan-t&#039;ou', 1),
(3151, 206, 'PH', 'P&#039;eng-hu', 1),
(3152, 206, 'PT', 'P&#039;ing-tung', 1),
(3153, 206, 'TG', 'T&#039;ai-chung', 1),
(3154, 206, 'TA', 'T&#039;ai-nan', 1),
(3155, 206, 'TP', 'T&#039;ai-pei county', 1),
(3156, 206, 'TT', 'T&#039;ai-tung', 1),
(3157, 206, 'TY', 'T&#039;ao-yuan', 1),
(3158, 206, 'YL', 'Yun-lin', 1),
(3159, 206, 'CC', 'Chia-i city', 1),
(3160, 206, 'CL', 'Chi-lung', 1),
(3161, 206, 'HC', 'Hsin-chu', 1),
(3162, 206, 'TH', 'T&#039;ai-chung', 1),
(3163, 206, 'TN', 'T&#039;ai-nan', 1),
(3164, 206, 'KC', 'Kao-hsiung city', 1),
(3165, 206, 'TC', 'T&#039;ai-pei city', 1),
(3166, 207, 'GB', 'Gorno-Badakhstan', 1),
(3167, 207, 'KT', 'Khatlon', 1),
(3168, 207, 'SU', 'Sughd', 1),
(3169, 208, 'AR', 'Arusha', 1),
(3170, 208, 'DS', 'Dar es Salaam', 1),
(3171, 208, 'DO', 'Dodoma', 1),
(3172, 208, 'IR', 'Iringa', 1),
(3173, 208, 'KA', 'Kagera', 1),
(3174, 208, 'KI', 'Kigoma', 1),
(3175, 208, 'KJ', 'Kilimanjaro', 1),
(3176, 208, 'LN', 'Lindi', 1),
(3177, 208, 'MY', 'Manyara', 1),
(3178, 208, 'MR', 'Mara', 1),
(3179, 208, 'MB', 'Mbeya', 1),
(3180, 208, 'MO', 'Morogoro', 1),
(3181, 208, 'MT', 'Mtwara', 1),
(3182, 208, 'MW', 'Mwanza', 1),
(3183, 208, 'PN', 'Pemba North', 1),
(3184, 208, 'PS', 'Pemba South', 1),
(3185, 208, 'PW', 'Pwani', 1),
(3186, 208, 'RK', 'Rukwa', 1),
(3187, 208, 'RV', 'Ruvuma', 1),
(3188, 208, 'SH', 'Shinyanga', 1),
(3189, 208, 'SI', 'Singida', 1),
(3190, 208, 'TB', 'Tabora', 1),
(3191, 208, 'TN', 'Tanga', 1),
(3192, 208, 'ZC', 'Zanzibar Central/South', 1),
(3193, 208, 'ZN', 'Zanzibar North', 1),
(3194, 208, 'ZU', 'Zanzibar Urban/West', 1),
(3195, 209, 'Amnat Charoen', 'Amnat Charoen', 1),
(3196, 209, 'Ang Thong', 'Ang Thong', 1),
(3197, 209, 'Ayutthaya', 'Ayutthaya', 1),
(3198, 209, 'Bangkok', 'Bangkok', 1),
(3199, 209, 'Buriram', 'Buriram', 1),
(3200, 209, 'Chachoengsao', 'Chachoengsao', 1),
(3201, 209, 'Chai Nat', 'Chai Nat', 1),
(3202, 209, 'Chaiyaphum', 'Chaiyaphum', 1),
(3203, 209, 'Chanthaburi', 'Chanthaburi', 1),
(3204, 209, 'Chiang Mai', 'Chiang Mai', 1),
(3205, 209, 'Chiang Rai', 'Chiang Rai', 1),
(3206, 209, 'Chon Buri', 'Chon Buri', 1),
(3207, 209, 'Chumphon', 'Chumphon', 1),
(3208, 209, 'Kalasin', 'Kalasin', 1),
(3209, 209, 'Kamphaeng Phet', 'Kamphaeng Phet', 1),
(3210, 209, 'Kanchanaburi', 'Kanchanaburi', 1),
(3211, 209, 'Khon Kaen', 'Khon Kaen', 1),
(3212, 209, 'Krabi', 'Krabi', 1),
(3213, 209, 'Lampang', 'Lampang', 1),
(3214, 209, 'Lamphun', 'Lamphun', 1),
(3215, 209, 'Loei', 'Loei', 1),
(3216, 209, 'Lop Buri', 'Lop Buri', 1),
(3217, 209, 'Mae Hong Son', 'Mae Hong Son', 1),
(3218, 209, 'Maha Sarakham', 'Maha Sarakham', 1),
(3219, 209, 'Mukdahan', 'Mukdahan', 1),
(3220, 209, 'Nakhon Nayok', 'Nakhon Nayok', 1),
(3221, 209, 'Nakhon Pathom', 'Nakhon Pathom', 1),
(3222, 209, 'Nakhon Phanom', 'Nakhon Phanom', 1),
(3223, 209, 'Nakhon Ratchasima', 'Nakhon Ratchasima', 1),
(3224, 209, 'Nakhon Sawan', 'Nakhon Sawan', 1),
(3225, 209, 'Nakhon Si Thammarat', 'Nakhon Si Thammarat', 1),
(3226, 209, 'Nan', 'Nan', 1),
(3227, 209, 'Narathiwat', 'Narathiwat', 1),
(3228, 209, 'Nong Bua Lamphu', 'Nong Bua Lamphu', 1),
(3229, 209, 'Nong Khai', 'Nong Khai', 1),
(3230, 209, 'Nonthaburi', 'Nonthaburi', 1),
(3231, 209, 'Pathum Thani', 'Pathum Thani', 1),
(3232, 209, 'Pattani', 'Pattani', 1),
(3233, 209, 'Phangnga', 'Phangnga', 1),
(3234, 209, 'Phatthalung', 'Phatthalung', 1),
(3235, 209, 'Phayao', 'Phayao', 1),
(3236, 209, 'Phetchabun', 'Phetchabun', 1),
(3237, 209, 'Phetchaburi', 'Phetchaburi', 1),
(3238, 209, 'Phichit', 'Phichit', 1),
(3239, 209, 'Phitsanulok', 'Phitsanulok', 1),
(3240, 209, 'Phrae', 'Phrae', 1),
(3241, 209, 'Phuket', 'Phuket', 1),
(3242, 209, 'Prachin Buri', 'Prachin Buri', 1),
(3243, 209, 'Prachuap Khiri Khan', 'Prachuap Khiri Khan', 1),
(3244, 209, 'Ranong', 'Ranong', 1),
(3245, 209, 'Ratchaburi', 'Ratchaburi', 1),
(3246, 209, 'Rayong', 'Rayong', 1),
(3247, 209, 'Roi Et', 'Roi Et', 1),
(3248, 209, 'Sa Kaeo', 'Sa Kaeo', 1),
(3249, 209, 'Sakon Nakhon', 'Sakon Nakhon', 1),
(3250, 209, 'Samut Prakan', 'Samut Prakan', 1),
(3251, 209, 'Samut Sakhon', 'Samut Sakhon', 1),
(3252, 209, 'Samut Songkhram', 'Samut Songkhram', 1),
(3253, 209, 'Sara Buri', 'Sara Buri', 1),
(3254, 209, 'Satun', 'Satun', 1),
(3255, 209, 'Sing Buri', 'Sing Buri', 1),
(3256, 209, 'Sisaket', 'Sisaket', 1),
(3257, 209, 'Songkhla', 'Songkhla', 1),
(3258, 209, 'Sukhothai', 'Sukhothai', 1),
(3259, 209, 'Suphan Buri', 'Suphan Buri', 1),
(3260, 209, 'Surat Thani', 'Surat Thani', 1),
(3261, 209, 'Surin', 'Surin', 1),
(3262, 209, 'Tak', 'Tak', 1),
(3263, 209, 'Trang', 'Trang', 1),
(3264, 209, 'Trat', 'Trat', 1),
(3265, 209, 'Ubon Ratchathani', 'Ubon Ratchathani', 1),
(3266, 209, 'Udon Thani', 'Udon Thani', 1),
(3267, 209, 'Uthai Thani', 'Uthai Thani', 1),
(3268, 209, 'Uttaradit', 'Uttaradit', 1),
(3269, 209, 'Yala', 'Yala', 1),
(3270, 209, 'Yasothon', 'Yasothon', 1),
(3271, 210, 'K', 'Kara', 1),
(3272, 210, 'P', 'Plateaux', 1),
(3273, 210, 'S', 'Savanes', 1),
(3274, 210, 'C', 'Centrale', 1),
(3275, 210, 'M', 'Maritime', 1),
(3276, 211, 'A', 'Atafu', 1),
(3277, 211, 'F', 'Fakaofo', 1),
(3278, 211, 'N', 'Nukunonu', 1),
(3279, 212, 'H', 'Ha&#039;apai', 1),
(3280, 212, 'T', 'Tongatapu', 1),
(3281, 212, 'V', 'Vava&#039;u', 1),
(3282, 213, 'CT', 'Couva/Tabaquite/Talparo', 1),
(3283, 213, 'DM', 'Diego Martin', 1),
(3284, 213, 'MR', 'Mayaro/Rio Claro', 1),
(3285, 213, 'PD', 'Penal/Debe', 1),
(3286, 213, 'PT', 'Princes Town', 1),
(3287, 213, 'SG', 'Sangre Grande', 1),
(3288, 213, 'SL', 'San Juan/Laventille', 1),
(3289, 213, 'SI', 'Siparia', 1),
(3290, 213, 'TP', 'Tunapuna/Piarco', 1),
(3291, 213, 'PS', 'Port of Spain', 1),
(3292, 213, 'SF', 'San Fernando', 1),
(3293, 213, 'AR', 'Arima', 1),
(3294, 213, 'PF', 'Point Fortin', 1),
(3295, 213, 'CH', 'Chaguanas', 1),
(3296, 213, 'TO', 'Tobago', 1),
(3297, 214, 'AR', 'Ariana', 1),
(3298, 214, 'BJ', 'Beja', 1),
(3299, 214, 'BA', 'Ben Arous', 1),
(3300, 214, 'BI', 'Bizerte', 1),
(3301, 214, 'GB', 'Gabes', 1),
(3302, 214, 'GF', 'Gafsa', 1),
(3303, 214, 'JE', 'Jendouba', 1),
(3304, 214, 'KR', 'Kairouan', 1),
(3305, 214, 'KS', 'Kasserine', 1),
(3306, 214, 'KB', 'Kebili', 1),
(3307, 214, 'KF', 'Kef', 1),
(3308, 214, 'MH', 'Mahdia', 1),
(3309, 214, 'MN', 'Manouba', 1),
(3310, 214, 'ME', 'Medenine', 1),
(3311, 214, 'MO', 'Monastir', 1),
(3312, 214, 'NA', 'Nabeul', 1),
(3313, 214, 'SF', 'Sfax', 1),
(3314, 214, 'SD', 'Sidi', 1),
(3315, 214, 'SL', 'Siliana', 1),
(3316, 214, 'SO', 'Sousse', 1),
(3317, 214, 'TA', 'Tataouine', 1),
(3318, 214, 'TO', 'Tozeur', 1),
(3319, 214, 'TU', 'Tunis', 1),
(3320, 214, 'ZA', 'Zaghouan', 1),
(3321, 215, 'ADA', 'Adana', 1),
(3322, 215, 'ADI', 'Adiyaman', 1),
(3323, 215, 'AFY', 'Afyonkarahisar', 1),
(3324, 215, 'AGR', 'Agri', 1),
(3325, 215, 'AKS', 'Aksaray', 1),
(3326, 215, 'AMA', 'Amasya', 1),
(3327, 215, 'ANK', 'Ankara', 1),
(3328, 215, 'ANT', 'Antalya', 1),
(3329, 215, 'ARD', 'Ardahan', 1),
(3330, 215, 'ART', 'Artvin', 1),
(3331, 215, 'AYI', 'Aydin', 1),
(3332, 215, 'BAL', 'Balikesir', 1),
(3333, 215, 'BAR', 'Bartin', 1),
(3334, 215, 'BAT', 'Batman', 1),
(3335, 215, 'BAY', 'Bayburt', 1),
(3336, 215, 'BIL', 'Bilecik', 1),
(3337, 215, 'BIN', 'Bingol', 1),
(3338, 215, 'BIT', 'Bitlis', 1),
(3339, 215, 'BOL', 'Bolu', 1),
(3340, 215, 'BRD', 'Burdur', 1),
(3341, 215, 'BRS', 'Bursa', 1),
(3342, 215, 'CKL', 'Canakkale', 1),
(3343, 215, 'CKR', 'Cankiri', 1),
(3344, 215, 'COR', 'Corum', 1),
(3345, 215, 'DEN', 'Denizli', 1),
(3346, 215, 'DIY', 'Diyarbakir', 1),
(3347, 215, 'DUZ', 'Duzce', 1),
(3348, 215, 'EDI', 'Edirne', 1),
(3349, 215, 'ELA', 'Elazig', 1),
(3350, 215, 'EZC', 'Erzincan', 1),
(3351, 215, 'EZR', 'Erzurum', 1),
(3352, 215, 'ESK', 'Eskisehir', 1),
(3353, 215, 'GAZ', 'Gaziantep', 1),
(3354, 215, 'GIR', 'Giresun', 1),
(3355, 215, 'GMS', 'Gumushane', 1),
(3356, 215, 'HKR', 'Hakkari', 1),
(3357, 215, 'HTY', 'Hatay', 1),
(3358, 215, 'IGD', 'Igdir', 1),
(3359, 215, 'ISP', 'Isparta', 1),
(3360, 215, 'IST', 'Istanbul', 1),
(3361, 215, 'IZM', 'Izmir', 1),
(3362, 215, 'KAH', 'Kahramanmaras', 1),
(3363, 215, 'KRB', 'Karabuk', 1),
(3364, 215, 'KRM', 'Karaman', 1),
(3365, 215, 'KRS', 'Kars', 1),
(3366, 215, 'KAS', 'Kastamonu', 1),
(3367, 215, 'KAY', 'Kayseri', 1),
(3368, 215, 'KLS', 'Kilis', 1),
(3369, 215, 'KRK', 'Kirikkale', 1),
(3370, 215, 'KLR', 'Kirklareli', 1),
(3371, 215, 'KRH', 'Kirsehir', 1),
(3372, 215, 'KOC', 'Kocaeli', 1),
(3373, 215, 'KON', 'Konya', 1),
(3374, 215, 'KUT', 'Kutahya', 1),
(3375, 215, 'MAL', 'Malatya', 1),
(3376, 215, 'MAN', 'Manisa', 1),
(3377, 215, 'MAR', 'Mardin', 1),
(3378, 215, 'MER', 'Mersin', 1),
(3379, 215, 'MUG', 'Mugla', 1),
(3380, 215, 'MUS', 'Mus', 1),
(3381, 215, 'NEV', 'Nevsehir', 1),
(3382, 215, 'NIG', 'Nigde', 1),
(3383, 215, 'ORD', 'Ordu', 1),
(3384, 215, 'OSM', 'Osmaniye', 1),
(3385, 215, 'RIZ', 'Rize', 1),
(3386, 215, 'SAK', 'Sakarya', 1),
(3387, 215, 'SAM', 'Samsun', 1),
(3388, 215, 'SAN', 'Sanliurfa', 1),
(3389, 215, 'SII', 'Siirt', 1),
(3390, 215, 'SIN', 'Sinop', 1),
(3391, 215, 'SIR', 'Sirnak', 1),
(3392, 215, 'SIV', 'Sivas', 1),
(3393, 215, 'TEL', 'Tekirdag', 1),
(3394, 215, 'TOK', 'Tokat', 1),
(3395, 215, 'TRA', 'Trabzon', 1),
(3396, 215, 'TUN', 'Tunceli', 1),
(3397, 215, 'USK', 'Usak', 1),
(3398, 215, 'VAN', 'Van', 1),
(3399, 215, 'YAL', 'Yalova', 1),
(3400, 215, 'YOZ', 'Yozgat', 1),
(3401, 215, 'ZON', 'Zonguldak', 1),
(3402, 216, 'A', 'Ahal Welayaty', 1),
(3403, 216, 'B', 'Balkan Welayaty', 1),
(3404, 216, 'D', 'Dashhowuz Welayaty', 1),
(3405, 216, 'L', 'Lebap Welayaty', 1),
(3406, 216, 'M', 'Mary Welayaty', 1),
(3407, 217, 'AC', 'Ambergris Cays', 1),
(3408, 217, 'DC', 'Dellis Cay', 1),
(3409, 217, 'FC', 'French Cay', 1),
(3410, 217, 'LW', 'Little Water Cay', 1),
(3411, 217, 'RC', 'Parrot Cay', 1),
(3412, 217, 'PN', 'Pine Cay', 1),
(3413, 217, 'SL', 'Salt Cay', 1),
(3414, 217, 'GT', 'Grand Turk', 1),
(3415, 217, 'SC', 'South Caicos', 1),
(3416, 217, 'EC', 'East Caicos', 1),
(3417, 217, 'MC', 'Middle Caicos', 1),
(3418, 217, 'NC', 'North Caicos', 1),
(3419, 217, 'PR', 'Providenciales', 1),
(3420, 217, 'WC', 'West Caicos', 1),
(3421, 218, 'NMG', 'Nanumanga', 1),
(3422, 218, 'NLK', 'Niulakita', 1),
(3423, 218, 'NTO', 'Niutao', 1),
(3424, 218, 'FUN', 'Funafuti', 1),
(3425, 218, 'NME', 'Nanumea', 1),
(3426, 218, 'NUI', 'Nui', 1),
(3427, 218, 'NFT', 'Nukufetau', 1),
(3428, 218, 'NLL', 'Nukulaelae', 1),
(3429, 218, 'VAI', 'Vaitupu', 1),
(3430, 219, 'KAL', 'Kalangala', 1),
(3431, 219, 'KMP', 'Kampala', 1),
(3432, 219, 'KAY', 'Kayunga', 1),
(3433, 219, 'KIB', 'Kiboga', 1),
(3434, 219, 'LUW', 'Luwero', 1),
(3435, 219, 'MAS', 'Masaka', 1),
(3436, 219, 'MPI', 'Mpigi', 1),
(3437, 219, 'MUB', 'Mubende', 1),
(3438, 219, 'MUK', 'Mukono', 1),
(3439, 219, 'NKS', 'Nakasongola', 1),
(3440, 219, 'RAK', 'Rakai', 1),
(3441, 219, 'SEM', 'Sembabule', 1),
(3442, 219, 'WAK', 'Wakiso', 1),
(3443, 219, 'BUG', 'Bugiri', 1),
(3444, 219, 'BUS', 'Busia', 1),
(3445, 219, 'IGA', 'Iganga', 1),
(3446, 219, 'JIN', 'Jinja', 1),
(3447, 219, 'KAB', 'Kaberamaido', 1),
(3448, 219, 'KML', 'Kamuli', 1),
(3449, 219, 'KPC', 'Kapchorwa', 1),
(3450, 219, 'KTK', 'Katakwi', 1),
(3451, 219, 'KUM', 'Kumi', 1),
(3452, 219, 'MAY', 'Mayuge', 1),
(3453, 219, 'MBA', 'Mbale', 1),
(3454, 219, 'PAL', 'Pallisa', 1),
(3455, 219, 'SIR', 'Sironko', 1),
(3456, 219, 'SOR', 'Soroti', 1),
(3457, 219, 'TOR', 'Tororo', 1),
(3458, 219, 'ADJ', 'Adjumani', 1),
(3459, 219, 'APC', 'Apac', 1),
(3460, 219, 'ARU', 'Arua', 1),
(3461, 219, 'GUL', 'Gulu', 1),
(3462, 219, 'KIT', 'Kitgum', 1),
(3463, 219, 'KOT', 'Kotido', 1),
(3464, 219, 'LIR', 'Lira', 1),
(3465, 219, 'MRT', 'Moroto', 1),
(3466, 219, 'MOY', 'Moyo', 1),
(3467, 219, 'NAK', 'Nakapiripirit', 1),
(3468, 219, 'NEB', 'Nebbi', 1),
(3469, 219, 'PAD', 'Pader', 1),
(3470, 219, 'YUM', 'Yumbe', 1),
(3471, 219, 'BUN', 'Bundibugyo', 1),
(3472, 219, 'BSH', 'Bushenyi', 1),
(3473, 219, 'HOI', 'Hoima', 1),
(3474, 219, 'KBL', 'Kabale', 1),
(3475, 219, 'KAR', 'Kabarole', 1),
(3476, 219, 'KAM', 'Kamwenge', 1),
(3477, 219, 'KAN', 'Kanungu', 1),
(3478, 219, 'KAS', 'Kasese', 1),
(3479, 219, 'KBA', 'Kibaale', 1),
(3480, 219, 'KIS', 'Kisoro', 1),
(3481, 219, 'KYE', 'Kyenjojo', 1),
(3482, 219, 'MSN', 'Masindi', 1),
(3483, 219, 'MBR', 'Mbarara', 1),
(3484, 219, 'NTU', 'Ntungamo', 1),
(3485, 219, 'RUK', 'Rukungiri', 1),
(3486, 220, 'CK', 'Cherkasy', 1),
(3487, 220, 'CH', 'Chernihiv', 1),
(3488, 220, 'CV', 'Chernivtsi', 1),
(3489, 220, 'CR', 'Crimea', 1),
(3490, 220, 'DN', 'Dnipropetrovs&#039;k', 1),
(3491, 220, 'DO', 'Donets&#039;k', 1),
(3492, 220, 'IV', 'Ivano-Frankivs&#039;k', 1),
(3493, 220, 'KL', 'Kharkiv Kherson', 1),
(3494, 220, 'KM', 'Khmel''nyts''kyy', 1),
(3495, 220, 'KR', 'Kirovohrad', 1),
(3496, 220, 'KV', 'Kiev', 1),
(3497, 220, 'KY', 'Kyyiv', 1),
(3498, 220, 'LU', 'Luhans&#039;k', 1),
(3499, 220, 'LV', 'L&#039;viv', 1),
(3500, 220, 'MY', 'Mykolayiv', 1),
(3501, 220, 'OD', 'Odesa', 1),
(3502, 220, 'PO', 'Poltava', 1),
(3503, 220, 'RI', 'Rivne', 1),
(3504, 220, 'SE', 'Sevastopol', 1),
(3505, 220, 'SU', 'Sumy', 1),
(3506, 220, 'TE', 'Ternopil&#039;', 1),
(3507, 220, 'VI', 'Vinnytsya', 1),
(3508, 220, 'VO', 'Volyn&#039;', 1),
(3509, 220, 'ZK', 'Zakarpattya', 1),
(3510, 220, 'ZA', 'Zaporizhzhya', 1),
(3511, 220, 'ZH', 'Zhytomyr', 1),
(3512, 221, 'AZ', 'Abu Zaby', 1),
(3513, 221, 'AJ', '&#039;Ajman', 1),
(3514, 221, 'FU', 'Al Fujayrah', 1),
(3515, 221, 'SH', 'Ash Shariqah', 1),
(3516, 221, 'DU', 'Dubayy', 1),
(3517, 221, 'RK', 'R&#039;as al Khaymah', 1),
(3518, 221, 'UQ', 'Umm al Qaywayn', 1),
(3519, 222, 'ABN', 'Aberdeen', 1),
(3520, 222, 'ABNS', 'Aberdeenshire', 1),
(3521, 222, 'ANG', 'Anglesey', 1),
(3522, 222, 'AGS', 'Angus', 1),
(3523, 222, 'ARY', 'Argyll and Bute', 1),
(3524, 222, 'BEDS', 'Bedfordshire', 1),
(3525, 222, 'BERKS', 'Berkshire', 1),
(3526, 222, 'BLA', 'Blaenau Gwent', 1),
(3527, 222, 'BRI', 'Bridgend', 1),
(3528, 222, 'BSTL', 'Bristol', 1),
(3529, 222, 'BUCKS', 'Buckinghamshire', 1),
(3530, 222, 'CAE', 'Caerphilly', 1),
(3531, 222, 'CAMBS', 'Cambridgeshire', 1),
(3532, 222, 'CDF', 'Cardiff', 1),
(3533, 222, 'CARM', 'Carmarthenshire', 1),
(3534, 222, 'CDGN', 'Ceredigion', 1),
(3535, 222, 'CHES', 'Cheshire', 1),
(3536, 222, 'CLACK', 'Clackmannanshire', 1),
(3537, 222, 'CON', 'Conwy', 1),
(3538, 222, 'CORN', 'Cornwall', 1),
(3539, 222, 'DNBG', 'Denbighshire', 1),
(3540, 222, 'DERBY', 'Derbyshire', 1),
(3541, 222, 'DVN', 'Devon', 1),
(3542, 222, 'DOR', 'Dorset', 1),
(3543, 222, 'DGL', 'Dumfries and Galloway', 1),
(3544, 222, 'DUND', 'Dundee', 1),
(3545, 222, 'DHM', 'Durham', 1),
(3546, 222, 'ARYE', 'East Ayrshire', 1),
(3547, 222, 'DUNBE', 'East Dunbartonshire', 1),
(3548, 222, 'LOTE', 'East Lothian', 1),
(3549, 222, 'RENE', 'East Renfrewshire', 1),
(3550, 222, 'ERYS', 'East Riding of Yorkshire', 1),
(3551, 222, 'SXE', 'East Sussex', 1),
(3552, 222, 'EDIN', 'Edinburgh', 1),
(3553, 222, 'ESX', 'Essex', 1),
(3554, 222, 'FALK', 'Falkirk', 1),
(3555, 222, 'FFE', 'Fife', 1),
(3556, 222, 'FLINT', 'Flintshire', 1),
(3557, 222, 'GLAS', 'Glasgow', 1),
(3558, 222, 'GLOS', 'Gloucestershire', 1),
(3559, 222, 'LDN', 'Greater London', 1),
(3560, 222, 'MCH', 'Greater Manchester', 1),
(3561, 222, 'GDD', 'Gwynedd', 1),
(3562, 222, 'HANTS', 'Hampshire', 1),
(3563, 222, 'HWR', 'Herefordshire', 1),
(3564, 222, 'HERTS', 'Hertfordshire', 1),
(3565, 222, 'HLD', 'Highlands', 1),
(3566, 222, 'IVER', 'Inverclyde', 1),
(3567, 222, 'IOW', 'Isle of Wight', 1),
(3568, 222, 'KNT', 'Kent', 1),
(3569, 222, 'LANCS', 'Lancashire', 1),
(3570, 222, 'LEICS', 'Leicestershire', 1),
(3571, 222, 'LINCS', 'Lincolnshire', 1),
(3572, 222, 'MSY', 'Merseyside', 1),
(3573, 222, 'MERT', 'Merthyr Tydfil', 1),
(3574, 222, 'MLOT', 'Midlothian', 1),
(3575, 222, 'MMOUTH', 'Monmouthshire', 1),
(3576, 222, 'MORAY', 'Moray', 1),
(3577, 222, 'NPRTAL', 'Neath Port Talbot', 1),
(3578, 222, 'NEWPT', 'Newport', 1),
(3579, 222, 'NOR', 'Norfolk', 1),
(3580, 222, 'ARYN', 'North Ayrshire', 1),
(3581, 222, 'LANN', 'North Lanarkshire', 1),
(3582, 222, 'YSN', 'North Yorkshire', 1),
(3583, 222, 'NHM', 'Northamptonshire', 1),
(3584, 222, 'NLD', 'Northumberland', 1),
(3585, 222, 'NOT', 'Nottinghamshire', 1),
(3586, 222, 'ORK', 'Orkney Islands', 1),
(3587, 222, 'OFE', 'Oxfordshire', 1),
(3588, 222, 'PEM', 'Pembrokeshire', 1),
(3589, 222, 'PERTH', 'Perth and Kinross', 1),
(3590, 222, 'PWS', 'Powys', 1),
(3591, 222, 'REN', 'Renfrewshire', 1),
(3592, 222, 'RHON', 'Rhondda Cynon Taff', 1),
(3593, 222, 'RUT', 'Rutland', 1),
(3594, 222, 'BOR', 'Scottish Borders', 1),
(3595, 222, 'SHET', 'Shetland Islands', 1),
(3596, 222, 'SPE', 'Shropshire', 1),
(3597, 222, 'SOM', 'Somerset', 1),
(3598, 222, 'ARYS', 'South Ayrshire', 1),
(3599, 222, 'LANS', 'South Lanarkshire', 1),
(3600, 222, 'YSS', 'South Yorkshire', 1),
(3601, 222, 'SFD', 'Staffordshire', 1),
(3602, 222, 'STIR', 'Stirling', 1),
(3603, 222, 'SFK', 'Suffolk', 1),
(3604, 222, 'SRY', 'Surrey', 1),
(3605, 222, 'SWAN', 'Swansea', 1),
(3606, 222, 'TORF', 'Torfaen', 1),
(3607, 222, 'TWR', 'Tyne and Wear', 1),
(3608, 222, 'VGLAM', 'Vale of Glamorgan', 1),
(3609, 222, 'WARKS', 'Warwickshire', 1),
(3610, 222, 'WDUN', 'West Dunbartonshire', 1),
(3611, 222, 'WLOT', 'West Lothian', 1),
(3612, 222, 'WMD', 'West Midlands', 1),
(3613, 222, 'SXW', 'West Sussex', 1),
(3614, 222, 'YSW', 'West Yorkshire', 1),
(3615, 222, 'WIL', 'Western Isles', 1),
(3616, 222, 'WLT', 'Wiltshire', 1),
(3617, 222, 'WORCS', 'Worcestershire', 1),
(3618, 222, 'WRX', 'Wrexham', 1),
(3619, 223, 'AL', 'Alabama', 1),
(3620, 223, 'AK', 'Alaska', 1),
(3621, 223, 'AS', 'American Samoa', 1),
(3622, 223, 'AZ', 'Arizona', 1),
(3623, 223, 'AR', 'Arkansas', 1),
(3624, 223, 'AF', 'Armed Forces Africa', 0),
(3625, 223, 'AA', 'Armed Forces Americas', 1),
(3626, 223, 'AC', 'Armed Forces Canada', 1),
(3627, 223, 'AE', 'Armed Forces Europe', 0),
(3628, 223, 'AM', 'Armed Forces Middle East', 0),
(3629, 223, 'AP', 'Armed Forces Pacific', 0),
(3630, 223, 'CA', 'California', 1),
(3631, 223, 'CO', 'Colorado', 1),
(3632, 223, 'CT', 'Connecticut', 1),
(3633, 223, 'DE', 'Delaware', 1),
(3634, 223, 'DC', 'District of Columbia', 1),
(3635, 223, 'FM', 'Federated States Of Micronesia', 1),
(3636, 223, 'FL', 'Florida', 1),
(3637, 223, 'GA', 'Georgia', 1),
(3638, 223, 'GU', 'Guam', 1),
(3639, 223, 'HI', 'Hawaii', 1),
(3640, 223, 'ID', 'Idaho', 1),
(3641, 223, 'IL', 'Illinois', 1),
(3642, 223, 'IN', 'Indiana', 1),
(3643, 223, 'IA', 'Iowa', 1),
(3644, 223, 'KS', 'Kansas', 1),
(3645, 223, 'KY', 'Kentucky', 1),
(3646, 223, 'LA', 'Louisiana', 1),
(3647, 223, 'ME', 'Maine', 1),
(3648, 223, 'MH', 'Marshall Islands', 1),
(3649, 223, 'MD', 'Maryland', 1),
(3650, 223, 'MA', 'Massachusetts', 1),
(3651, 223, 'MI', 'Michigan', 1),
(3652, 223, 'MN', 'Minnesota', 1),
(3653, 223, 'MS', 'Mississippi', 1),
(3654, 223, 'MO', 'Missouri', 1),
(3655, 223, 'MT', 'Montana', 1),
(3656, 223, 'NE', 'Nebraska', 1),
(3657, 223, 'NV', 'Nevada', 1),
(3658, 223, 'NH', 'New Hampshire', 1),
(3659, 223, 'NJ', 'New Jersey', 1),
(3660, 223, 'NM', 'New Mexico', 1),
(3661, 223, 'NY', 'New York', 1),
(3662, 223, 'NC', 'North Carolina', 1),
(3663, 223, 'ND', 'North Dakota', 1),
(3664, 223, 'MP', 'Northern Mariana Islands', 1),
(3665, 223, 'OH', 'Ohio', 1),
(3666, 223, 'OK', 'Oklahoma', 1),
(3667, 223, 'OR', 'Oregon', 1),
(3668, 223, 'PW', 'Palau', 1),
(3669, 223, 'PA', 'Pennsylvania', 1),
(3670, 223, 'PR', 'Puerto Rico', 1),
(3671, 223, 'RI', 'Rhode Island', 1),
(3672, 223, 'SC', 'South Carolina', 1),
(3673, 223, 'SD', 'South Dakota', 1),
(3674, 223, 'TN', 'Tennessee', 1),
(3675, 223, 'TX', 'Texas', 1),
(3676, 223, 'UT', 'Utah', 1),
(3677, 223, 'VT', 'Vermont', 1),
(3678, 223, 'VI', 'Virgin Islands', 1),
(3679, 223, 'VA', 'Virginia', 1),
(3680, 223, 'WA', 'Washington', 1),
(3681, 223, 'WV', 'West Virginia', 1),
(3682, 223, 'WI', 'Wisconsin', 1),
(3683, 223, 'WY', 'Wyoming', 1),
(3684, 224, 'BI', 'Baker Island', 1),
(3685, 224, 'HI', 'Howland Island', 1),
(3686, 224, 'JI', 'Jarvis Island', 1),
(3687, 224, 'JA', 'Johnston Atoll', 1),
(3688, 224, 'KR', 'Kingman Reef', 1),
(3689, 224, 'MA', 'Midway Atoll', 1),
(3690, 224, 'NI', 'Navassa Island', 1),
(3691, 224, 'PA', 'Palmyra Atoll', 1),
(3692, 224, 'WI', 'Wake Island', 1),
(3693, 225, 'AR', 'Artigas', 1),
(3694, 225, 'CA', 'Canelones', 1),
(3695, 225, 'CL', 'Cerro Largo', 1),
(3696, 225, 'CO', 'Colonia', 1),
(3697, 225, 'DU', 'Durazno', 1),
(3698, 225, 'FS', 'Flores', 1),
(3699, 225, 'FA', 'Florida', 1),
(3700, 225, 'LA', 'Lavalleja', 1),
(3701, 225, 'MA', 'Maldonado', 1),
(3702, 225, 'MO', 'Montevideo', 1),
(3703, 225, 'PA', 'Paysandu', 1),
(3704, 225, 'RN', 'Rio Negro', 1),
(3705, 225, 'RV', 'Rivera', 1),
(3706, 225, 'RO', 'Rocha', 1),
(3707, 225, 'SL', 'Salto', 1),
(3708, 225, 'SJ', 'San Jose', 1),
(3709, 225, 'SO', 'Soriano', 1),
(3710, 225, 'TA', 'Tacuarembo', 1),
(3711, 225, 'TT', 'Treinta y Tres', 1),
(3712, 226, 'AN', 'Andijon', 1),
(3713, 226, 'BU', 'Buxoro', 1),
(3714, 226, 'FA', 'Farg&#039;ona', 1),
(3715, 226, 'JI', 'Jizzax', 1),
(3716, 226, 'NG', 'Namangan', 1),
(3717, 226, 'NW', 'Navoiy', 1),
(3718, 226, 'QA', 'Qashqadaryo', 1),
(3719, 226, 'QR', 'Qoraqalpog&#039;iston Republikas', 1),
(3720, 226, 'SA', 'Samarqand', 1),
(3721, 226, 'SI', 'Sirdaryo', 1),
(3722, 226, 'SU', 'Surxondaryo', 1),
(3723, 226, 'TK', 'Toshkent City', 1),
(3724, 226, 'TO', 'Toshkent Region', 1),
(3725, 226, 'XO', 'Xorazm', 1),
(3726, 227, 'MA', 'Malampa', 1),
(3727, 227, 'PE', 'Penama', 1),
(3728, 227, 'SA', 'Sanma', 1),
(3729, 227, 'SH', 'Shefa', 1),
(3730, 227, 'TA', 'Tafea', 1),
(3731, 227, 'TO', 'Torba', 1),
(3732, 229, 'AM', 'Amazonas', 1),
(3733, 229, 'AN', 'Anzoategui', 1),
(3734, 229, 'AP', 'Apure', 1),
(3735, 229, 'AR', 'Aragua', 1),
(3736, 229, 'BA', 'Barinas', 1),
(3737, 229, 'BO', 'Bolivar', 1),
(3738, 229, 'CA', 'Carabobo', 1),
(3739, 229, 'CO', 'Cojedes', 1),
(3740, 229, 'DA', 'Delta Amacuro', 1),
(3741, 229, 'DF', 'Dependencias Federales', 1),
(3742, 229, 'DI', 'Distrito Federal', 1),
(3743, 229, 'FA', 'Falcon', 1),
(3744, 229, 'GU', 'Guarico', 1),
(3745, 229, 'LA', 'Lara', 1),
(3746, 229, 'ME', 'Merida', 1),
(3747, 229, 'MI', 'Miranda', 1),
(3748, 229, 'MO', 'Monagas', 1),
(3749, 229, 'NE', 'Nueva Esparta', 1),
(3750, 229, 'PO', 'Portuguesa', 1),
(3751, 229, 'SU', 'Sucre', 1),
(3752, 229, 'TA', 'Tachira', 1),
(3753, 229, 'TR', 'Trujillo', 1),
(3754, 229, 'VA', 'Vargas', 1),
(3755, 229, 'YA', 'Yaracuy', 1),
(3756, 229, 'ZU', 'Zulia', 1),
(3757, 230, 'AG', 'An Giang', 1),
(3758, 230, 'BG', 'Bac Giang', 1),
(3759, 230, 'BK', 'Bac Kan', 1),
(3760, 230, 'BL', 'Bac Lieu', 1),
(3761, 230, 'BC', 'Bac Ninh', 1),
(3762, 230, 'BR', 'Ba Ria-Vung Tau', 1),
(3763, 230, 'BN', 'Ben Tre', 1),
(3764, 230, 'BH', 'Binh Dinh', 1),
(3765, 230, 'BU', 'Binh Duong', 1),
(3766, 230, 'BP', 'Binh Phuoc', 1),
(3767, 230, 'BT', 'Binh Thuan', 1),
(3768, 230, 'CM', 'Ca Mau', 1),
(3769, 230, 'CT', 'Can Tho', 1),
(3770, 230, 'CB', 'Cao Bang', 1),
(3771, 230, 'DL', 'Dak Lak', 1),
(3772, 230, 'DG', 'Dak Nong', 1),
(3773, 230, 'DN', 'Da Nang', 1),
(3774, 230, 'DB', 'Dien Bien', 1),
(3775, 230, 'DI', 'Dong Nai', 1),
(3776, 230, 'DT', 'Dong Thap', 1),
(3777, 230, 'GL', 'Gia Lai', 1),
(3778, 230, 'HG', 'Ha Giang', 1),
(3779, 230, 'HD', 'Hai Duong', 1),
(3780, 230, 'HP', 'Hai Phong', 1),
(3781, 230, 'HM', 'Ha Nam', 1),
(3782, 230, 'HI', 'Ha Noi', 1),
(3783, 230, 'HT', 'Ha Tay', 1),
(3784, 230, 'HH', 'Ha Tinh', 1),
(3785, 230, 'HB', 'Hoa Binh', 1),
(3786, 230, 'HC', 'Ho Chin Minh', 1),
(3787, 230, 'HU', 'Hau Giang', 1),
(3788, 230, 'HY', 'Hung Yen', 1),
(3789, 232, 'C', 'Saint Croix', 1),
(3790, 232, 'J', 'Saint John', 1),
(3791, 232, 'T', 'Saint Thomas', 1),
(3792, 233, 'A', 'Alo', 1),
(3793, 233, 'S', 'Sigave', 1),
(3794, 233, 'W', 'Wallis', 1),
(3795, 235, 'AB', 'Abyan', 1),
(3796, 235, 'AD', 'Adan', 1),
(3797, 235, 'AM', 'Amran', 1),
(3798, 235, 'BA', 'Al Bayda', 1),
(3799, 235, 'DA', 'Ad Dali', 1),
(3800, 235, 'DH', 'Dhamar', 1),
(3801, 235, 'HD', 'Hadramawt', 1),
(3802, 235, 'HJ', 'Hajjah', 1),
(3803, 235, 'HU', 'Al Hudaydah', 1),
(3804, 235, 'IB', 'Ibb', 1),
(3805, 235, 'JA', 'Al Jawf', 1),
(3806, 235, 'LA', 'Lahij', 1),
(3807, 235, 'MA', 'Ma&#039;rib', 1),
(3808, 235, 'MR', 'Al Mahrah', 1),
(3809, 235, 'MW', 'Al Mahwit', 1),
(3810, 235, 'SD', 'Sa&#039;dah', 1),
(3811, 235, 'SN', 'San&#039;a', 1),
(3812, 235, 'SH', 'Shabwah', 1),
(3813, 235, 'TA', 'Ta&#039;izz', 1),
(3814, 236, 'KOS', 'Kosovo', 1),
(3815, 236, 'MON', 'Montenegro', 1),
(3816, 236, 'SER', 'Serbia', 1),
(3817, 236, 'VOJ', 'Vojvodina', 1),
(3818, 237, 'BC', 'Bas-Congo', 1),
(3819, 237, 'BN', 'Bandundu', 1),
(3820, 237, 'EQ', 'Equateur', 1),
(3821, 237, 'KA', 'Katanga', 1),
(3822, 237, 'KE', 'Kasai-Oriental', 1),
(3823, 237, 'KN', 'Kinshasa', 1),
(3824, 237, 'KW', 'Kasai-Occidental', 1),
(3825, 237, 'MA', 'Maniema', 1),
(3826, 237, 'NK', 'Nord-Kivu', 1),
(3827, 237, 'OR', 'Orientale', 1),
(3828, 237, 'SK', 'Sud-Kivu', 1),
(3829, 238, 'CE', 'Central', 1),
(3830, 238, 'CB', 'Copperbelt', 1),
(3831, 238, 'EA', 'Eastern', 1),
(3832, 238, 'LP', 'Luapula', 1),
(3833, 238, 'LK', 'Lusaka', 1),
(3834, 238, 'NO', 'Northern', 1),
(3835, 238, 'NW', 'North-Western', 1),
(3836, 238, 'SO', 'Southern', 1),
(3837, 238, 'WE', 'Western', 1),
(3838, 239, 'BU', 'Bulawayo', 1),
(3839, 239, 'HA', 'Harare', 1),
(3840, 239, 'ML', 'Manicaland', 1),
(3841, 239, 'MC', 'Mashonaland Central', 1),
(3842, 239, 'ME', 'Mashonaland East', 1),
(3843, 239, 'MW', 'Mashonaland West', 1),
(3844, 239, 'MV', 'Masvingo', 1),
(3845, 239, 'MN', 'Matabeleland North', 1),
(3846, 239, 'MS', 'Matabeleland South', 1),
(3847, 239, 'MD', 'Midlands', 1);

-- --------------------------------------------------------

--
-- Table structure for table `zone_to_geo_zone`
--

CREATE TABLE `zone_to_geo_zone` (
  `zone_to_geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`zone_to_geo_zone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `zone_to_geo_zone`
--

INSERT INTO `zone_to_geo_zone` VALUES
(1, 103, 0, 1, '2006-08-21 15:24:20', '2007-08-07 17:41:23'),
(2, 222, 0, 1, '2007-08-07 13:30:02', '0000-00-00 00:00:00'),
(3, 222, 0, 2, '2007-08-29 22:25:23', '0000-00-00 00:00:00'),
(4, 38, 602, 3, '2009-02-01 10:52:49', '0000-00-00 00:00:00'),
(5, 38, 603, 3, '2009-02-01 15:33:50', '0000-00-00 00:00:00'),
(6, 38, 613, 3, '2009-02-01 15:42:24', '0000-00-00 00:00:00'),
(7, 223, 3680, 4, '2009-02-01 15:50:47', '0000-00-00 00:00:00'),
(8, 38, 604, 3, '2009-02-01 17:26:43', '0000-00-00 00:00:00'),
(9, 38, 608, 3, '2009-06-06 06:56:12', '0000-00-00 00:00:00');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
