<?php
/**
 * ----------------------------------------------
 * Advanced Guestbook 2.4.4 (PHP/MySQL)
 * Copyright (c) Chi Kien Uong
 * URL: http://www.proxy2.de
 * ----------------------------------------------
 */
/**
 * Usage
 * <pre>
 *   $img = new BitmapImageText();
 *   $img->setText("TEXT");
 *   $img->setBackgroundColors(array("EEEEEE", "F2F3D3", "F5EAEA", "E4F3EE", "EEE4F3"));
 *   $img->setTextColors(array("000000", "FD130A", "0A1BFD", "149703", "486C66", "870DC3", "D78406", "105243"));
 *   $img->getImage();
 * </pre>
 */

class BitmapImageText {

	var $width;
	var $text;
	var $textColors;
	var $backgroundColors;
	var $contentLength;
	var $bitmapFileHeader;
	var $bitmapFilesize;
	var $bitmapDataSize;
	var $bitmapHeaderSize;
	var $bitmapData;
	var $charArr;

	function BitmapImageText() {

		$this->width = 0;
		$this->text = NULL;
		$this->bitmapFilesize = 0;
		$this->bitmapDataSize = 0;
		$this->bitmapHeaderSize = 54;
		$this->textColors = array(array(0,0,0));
		$this->backgroundColors = array(array(255,255,255));
		$this->charArr = array();
		$this->bitmapData = "";
		$this->contentLength = 0;
		$this->bitmapFileHeader = array(
			0x42,0x4D,
			&$this->bitmapFilesize,
			0,0,0,0,
			0x36,0,0,0,
			0x28,0,0,0,
			&$this->width,
			0x10,0,0,0,
			1,0,
			0x18,0,
			0,0,0,0,
			&$this->bitmapDataSize,
			0xC4,0xE,0,0,
			0xC4,0xE,0,0,
			0,0,0,0,
			0,0,0,0
		);
		$hcount = count($this->bitmapFileHeader);
		for ($i=0; $i<$hcount; $i++) {
			$this->bitmapFileHeader[$i] = pack("C", $this->bitmapFileHeader[$i]);
		}
		$this->chars['0'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['1'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['2'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['3'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['4'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['5'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['6'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['7'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['8'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['9'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['A'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['B'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['C'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['D'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['E'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['F'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['G'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,1,1,1,1,1,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['H'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['I'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['J'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['K'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['L'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['M'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['N'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['O'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['P'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['Q'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['R'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['S'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['T'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['U'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['V'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
			0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['W'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['X'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['Y'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['Z'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);
		$this->chars['undefined'] = array(

			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
			0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		);

	}

	function setText($text) {
		$text = trim($text);
		if (!empty($text)) {
			$this->text = $text;
			$this->charArr = array();
			$this->bitmapData = "";
			$this->bitmapDataSize = 0;
			$this->width = 0;
			$this->bitmapFilesize = 0;
			$this->contentLength = 0;
			return true;
		}
		return false;
	}

	function setBackgroundColor($htmlColorCode) {
		$rgbArr = $this->getRGBCode($htmlColorCode);
		if (count($rgbArr)>0) {
			unset($this->backgroundColors);
			$this->backgroundColors[] = $rgbArr;
			return true;
		}
		return false;
	}

	function setBackgroundColors($htmlColorCodeArr) {
		$retval = false;
		foreach ($htmlColorCodeArr as $key => $value) {
			$rgbArr = $this->getRGBCode($value);
			if (count($rgbArr)>0) {
				if ($retval == false) {
					unset($this->backgroundColors);
					$retval = true;
				}
				$this->backgroundColors[] = $rgbArr;
			}
		}
		return $retval;
	}

	function setTextColor($htmlColorCode) {
		$rgbArr = $this->getRGBCode($htmlColorCode);
		if (count($rgbArr)>0) {
			unset($this->textColors);
			$this->textColors[] = $rgbArr;
			return true;
		}
		return false;
	}

	function setTextColors($htmlColorCodeArr) {
		$retval = false;
		foreach ($htmlColorCodeArr as $key => $value) {
			$rgbArr = $this->getRGBCode($value);
			if (count($rgbArr)>0) {
				if ($retval == false) {
					unset($this->textColors);
					$retval = true;
				}
				$this->textColors[] = $rgbArr;
			}
		}
		return $retval;
	}

	function getImageWidth($width) {
		if ($this->text != "") {
			return strlen($this->text)*16;
		}
	}

	function getImageFile($filename) {
		$this->createImage();
		if (!empty($this->bitmapData)) {
			$filename = trim($filename);
			$saveDir = dirname($filename);
			if (!is_writable($saveDir)) {
				return NULL;
			}
			if (file_exists($filename) && !is_writable($filename)) {
				return NULL;
			}
			$retVal = NULL;
			$handle = fopen($filename, "wb");
			if ($handle) {
				fwrite($handle, implode("", $this->bitmapFileHeader));
				fwrite($handle, $this->bitmapData);
				fclose($handle);
				$retVal = $filename;
			}
			return $retVal;
		}
		return NULL;
	}

	function getImage() {
		$this->createImage();
		if (!empty($this->bitmapData)) {
			header("Content-Type: image/bmp");
			header("Content-Length: ".$this->contentLength);
			echo implode("", $this->bitmapFileHeader);
			echo $this->bitmapData;
		} else {
			$this->createPixel();
		}
	}

	function createPixel() {
		$date = date("D, d M Y H:i:s");
		header("Cache-Control: no-cache");
		header("Pragma: no-cache");
		header("Content-Type: image/bmp");
		header("Expires: Sat, 1 Jan 2000 00:00:00 GMT");
		header("Last-Modified: $date GMT");
		echo base64_decode("Qk06AAAAAAAAADYAAAAoAAAAAQAAAAEAAAABABgAAAAAAAQAAADEDgAAxA4AAAAAAAAAAAAA////AA==");
	}

	/**
	 * private methods
	 */

	function getRGBCode($htmlColorCode) {
		$rgbArr = array();
		if (strlen($htmlColorCode) == 6) {
			$htmlCodeArr = array();
			eregi("([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})", $htmlColorCode, $htmlCodeArr);
			if (count($htmlCodeArr) == 4) {
				for ($i=1; $i<=3; $i++) {
					$k = $i-1;
					$rgbArr[$k] = hexdec($htmlCodeArr[$i]);
				}
				return $rgbArr;
			}
		}
		return $rgbArr;
	}

	function getBGRHex($colorArr) {
		$codeHex = pack("C", $colorArr[2]).pack("C", $colorArr[1]).pack("C", $colorArr[0]);
		return $codeHex;
	}

	function getHexStr($strArr) {
		$hexStr = "";
		$arrSize = count($strArr);
		for ($i=0; $i<$arrSize; $i++) {
			$hexStr .= pack("C", $strArr[$i]);
		}
		return $hexStr;
	}

	function getPreparedText() {
		$this->charArr = array();
		if ($this->text != "") {
			$charArr = preg_split('//', $this->text, -1, PREG_SPLIT_NO_EMPTY);
			srand((double)microtime()*1000000);
			$textColorIndex = count($this->textColors) - 1;
			for ($i=0; $i<count($charArr); $i++) {
				$randColorIndex = rand(0,$textColorIndex);
				if (isset($this->chars[$charArr[$i]])) {
					$char = $charArr[$i];
				} else {
					$char = 'undefined';
				}
				$this->charArr[] = array("color" => $this->textColors[$randColorIndex], "char" => $char);
			}
		}
		return $this->charArr;
	}

	function getTextLength() {
		if ($this->text != NULL) {
			return strlen($this->text);
		}
		return 0;
	}

	function createImage() {
		if ($this->bitmapData != "" || $this->text == "") {
			return;
		}
		if (count($this->charArr) == 0) {
			$this->getPreparedText();
		}
		$chars = count($this->charArr);
		srand((double)microtime()*1000000);
		$backgroundColorIndex = count($this->backgroundColors) - 1;
		$randBgIndex = rand(0,$backgroundColorIndex);
		$randBgColor = $this->getBGRHex($this->backgroundColors[$randBgIndex]);
		$this->bitmapData = "";
		if ($chars == 1) {
			$randTextColor = $this->getBGRHex($this->charArr[0]['color']);
			for ($k=0; $k<256; $k++) {
				if ($this->chars[$this->charArr[0]['char']][$k] == 0) {
					$this->bitmapData .= $randBgColor;
				} else {
					$this->bitmapData .= $randTextColor;
				}
			}
		} else {
			for ($k=0; $k<$chars; $k++) {
				$alpha = $this->charArr[$k]['char'];
				$randTextColors[$alpha] = $this->getBGRHex($this->charArr[$k]['color']);
			}
			$inner = 0;
			for ($p=0; $p<16; $p++) {
				for ($k=0; $k<$chars; $k++) {
					$index = $this->charArr[$k]['char'];
					for ($i=0; $i<16; $i++) {
						$pos = $inner + $i;
						if ($this->chars[$index][$pos] == 0) {
							$this->bitmapData .= $randBgColor;
						} else {
							$this->bitmapData .= $randTextColors[$index];
						}
					}
				}
				$inner += 16;
			}
		}
		$this->width = pack("V", $chars*16);
		$this->bitmapDataSize = pack("V", $chars*768);
		$this->bitmapFilesize = pack("V", $this->bitmapHeaderSize + $chars*768);
		$this->contentLength = $this->bitmapHeaderSize + $chars*768;
	}

}

?>