
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `aefs`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]apps`
--

CREATE TABLE `[[dbprefix]]apps` (
  `apid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `ap_name` varchar(100) NOT NULL DEFAULT '',
  `ap_version` varchar(15) NOT NULL DEFAULT '',
  `installed_time` int(10) NOT NULL DEFAULT '0',
  `ap_info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`apid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]apps`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]apps_registry`
--

CREATE TABLE `[[dbprefix]]apps_registry` (
  `apid` mediumint(8) NOT NULL DEFAULT '0',
  `uid` mediumint(8) NOT NULL DEFAULT '0',
  `apps_registry` text NOT NULL,
  UNIQUE KEY `apid` (`apid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]apps_registry`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachments`
--

CREATE TABLE `[[dbprefix]]attachments` (
  `atid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `at_original_file` tinytext NOT NULL,
  `at_file` tinytext NOT NULL,
  `at_mimetype_id` smallint(5) NOT NULL DEFAULT '0',
  `at_size` int(10) NOT NULL DEFAULT '0',
  `at_fid` smallint(5) NOT NULL DEFAULT '0',
  `at_pid` int(10) NOT NULL DEFAULT '0',
  `at_downloads` int(10) NOT NULL DEFAULT '0',
  `at_time` int(10) NOT NULL DEFAULT '0',
  `at_mid` mediumint(8) NOT NULL DEFAULT '0',
  `at_width` smallint(5) NOT NULL DEFAULT '0',
  `at_height` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`atid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]attachments`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachment_mimetypes`
--

CREATE TABLE `[[dbprefix]]attachment_mimetypes` (
  `atmtid` smallint(5) NOT NULL AUTO_INCREMENT,
  `atmt_ext` varchar(20) NOT NULL DEFAULT '',
  `atmt_mimetype` varchar(255) NOT NULL DEFAULT '',
  `atmt_icon` tinytext NOT NULL,
  `atmt_posts` tinyint(2) NOT NULL DEFAULT '0',
  `atmt_avatar` tinyint(2) NOT NULL DEFAULT '0',
  `atmt_isimage` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`atmtid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]attachment_mimetypes`
--

INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(1, 'png', 'image/png', 'png.png', 1, 1, 1);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(2, 'jpg', 'image/jpeg', 'jpg.png', 1, 1, 1);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(3, 'gif', 'image/gif', 'gif.png', 1, 1, 1);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(4, 'bmp', 'image/bitmap', 'bmp.png', 1, 1, 1);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(5, 'tiff', 'image/tiff', 'tiff.png', 1, 1, 1);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(6, 'txt', 'plain/text', 'txt.png', 1, 0, 0);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(7, 'jpeg', 'image/jpeg', 'jpg.png', 1, 1, 1);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(8, 'doc', 'application/msword', 'doc.png', 1, 0, 0);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(9, 'mpg', 'video/mpeg', 'mpg.png', 1, 0, 0);
INSERT INTO `[[dbprefix]]attachment_mimetypes` VALUES(10, 'zip', 'application/zip', 'zip.png', 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `cid` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `order` smallint(5) NOT NULL DEFAULT '0',
  `collapsable` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES(1, 'General Stuff', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]errors`
--

CREATE TABLE `[[dbprefix]]errors` (
  `type` tinyint(3) NOT NULL DEFAULT '0',
  `id` mediumint(5) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]errors`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forumpermissions`
--

CREATE TABLE `[[dbprefix]]forumpermissions` (
  `fpfid` smallint(5) NOT NULL DEFAULT '0',
  `fpugid` mediumint(5) NOT NULL DEFAULT '0',
  `can_post_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_reply` tinyint(2) NOT NULL DEFAULT '0',
  `can_vote_polls` tinyint(2) NOT NULL DEFAULT '0',
  `can_post_polls` tinyint(2) NOT NULL DEFAULT '0',
  `can_attach` tinyint(2) NOT NULL DEFAULT '0',
  `can_view_attach` tinyint(2) NOT NULL DEFAULT '0',
  UNIQUE KEY `fpfid` (`fpfid`,`fpugid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]forumpermissions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums`
--

CREATE TABLE `[[dbprefix]]forums` (
  `fid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat_id` smallint(5) NOT NULL DEFAULT '0',
  `par_board_id` smallint(5) NOT NULL DEFAULT '0',
  `forum_order` smallint(5) NOT NULL DEFAULT '0',
  `member_group` tinytext NOT NULL,
  `fname` tinytext NOT NULL,
  `description` tinytext NOT NULL,
  `fimage` tinytext NOT NULL,
  `fredirect` tinytext NOT NULL,
  `ntopic` mediumint(8) NOT NULL DEFAULT '0',
  `nposts` mediumint(8) NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '1',
  `prune` tinyint(3) NOT NULL DEFAULT '0',
  `allow_poll` tinyint(2) NOT NULL DEFAULT '0',
  `allow_html` tinyint(2) NOT NULL DEFAULT '0',
  `id_skin` smallint(5) NOT NULL DEFAULT '0',
  `override_skin` tinyint(2) NOT NULL DEFAULT '0',
  `inc_mem_posts` tinyint(2) NOT NULL DEFAULT '1',
  `quick_reply` tinyint(2) NOT NULL DEFAULT '0',
  `quick_topic` tinyint(2) NOT NULL DEFAULT '0',
  `f_last_pid` int(10) NOT NULL DEFAULT '0',
  `frulestitle` tinytext NOT NULL,
  `frules` text NOT NULL,
  `mod_topics` tinyint(2) NOT NULL DEFAULT '0',
  `mod_posts` tinyint(2) NOT NULL DEFAULT '0',
  `rss` int(4) NOT NULL DEFAULT '0',
  `rss_topic` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]forums`
--

INSERT INTO `[[dbprefix]]forums` VALUES(1, 1, 0, 1, '-1,0,2,3', 'Generals', 'Talk about anything you like in general!', '', '', 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, '', '0', 0, 10, 10, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fpass`
--

CREATE TABLE `[[dbprefix]]fpass` (
  `fpuid` mediumint(8) NOT NULL DEFAULT '0',
  `resetcode` varchar(10) NOT NULL DEFAULT '',
  `fptime` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `fpuid` (`fpuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]fpass`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mark_read`
--

CREATE TABLE `[[dbprefix]]mark_read` (
  `mr_uid` mediumint(8) NOT NULL DEFAULT '0',
  `mr_fid` smallint(5) NOT NULL DEFAULT '0',
  `mr_time` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `mr_uid` (`mr_uid`,`mr_fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]mark_read`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]moderators`
--

CREATE TABLE `[[dbprefix]]moderators` (
  `mod_mem_id` mediumint(8) NOT NULL DEFAULT '0',
  `mod_fid` smallint(5) NOT NULL DEFAULT '0',
  UNIQUE KEY `mod_mem_id` (`mod_mem_id`,`mod_fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]moderators`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news`
--

CREATE TABLE `[[dbprefix]]news` (
  `nid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) NOT NULL DEFAULT '0',
  `title` tinytext NOT NULL,
  `news` text NOT NULL,
  `time` int(12) NOT NULL DEFAULT '0',
  `image` tinytext NOT NULL,
  `fullstorylink` tinytext NOT NULL,
  `approved` tinyint(2) NOT NULL DEFAULT '0',
  `showinticker` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]news`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notify_forum`
--

CREATE TABLE `[[dbprefix]]notify_forum` (
  `notify_mid` mediumint(8) NOT NULL DEFAULT '0',
  `notify_fid` smallint(5) NOT NULL DEFAULT '0',
  UNIQUE KEY `notify_mid` (`notify_mid`,`notify_fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]notify_forum`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notify_topic`
--

CREATE TABLE `[[dbprefix]]notify_topic` (
  `notify_mid` mediumint(8) NOT NULL DEFAULT '0',
  `notify_tid` mediumint(8) NOT NULL DEFAULT '0',
  UNIQUE KEY `notify_mid` (`notify_mid`,`notify_tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]notify_topic`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `member_group_id` mediumint(8) NOT NULL DEFAULT '0',
  `view_forum` tinyint(2) NOT NULL DEFAULT '0',
  `can_post_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_reply` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_own_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_other_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_own` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_other` tinyint(2) NOT NULL DEFAULT '0',
  `approve_topics` tinyint(2) NOT NULL DEFAULT '0',
  `approve_posts` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_own_post` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_other_post` tinyint(2) NOT NULL DEFAULT '0',
  `can_search` tinyint(2) NOT NULL DEFAULT '0',
  `can_email_mem` tinyint(2) NOT NULL DEFAULT '0',
  `can_email_friend` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_own_profile` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_other_profile` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_own_account` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_other_account` tinyint(2) NOT NULL DEFAULT '0',
  `can_ban_user` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_own_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_other_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_view_poll` tinyint(2) NOT NULL DEFAULT '0',
  `can_vote_polls` tinyint(2) NOT NULL DEFAULT '0',
  `can_post_polls` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_other_poll` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_own_poll` tinyint(2) NOT NULL DEFAULT '0',
  `add_poll_topic_own` tinyint(2) NOT NULL DEFAULT '0',
  `add_poll_topic_other` tinyint(2) NOT NULL DEFAULT '0',
  `can_rem_own_poll` tinyint(2) NOT NULL DEFAULT '0',
  `can_rem_other_poll` tinyint(2) NOT NULL DEFAULT '0',
  `can_merge_topics` tinyint(2) NOT NULL DEFAULT '0',
  `can_merge_posts` tinyint(2) NOT NULL DEFAULT '0',
  `can_split_topics` tinyint(2) NOT NULL DEFAULT '0',
  `can_email_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_make_sticky` tinyint(2) NOT NULL DEFAULT '0',
  `can_move_own_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_move_other_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_lock_own_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_lock_other_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_announce_topic` tinyint(2) NOT NULL DEFAULT '0',
  `can_report_post` tinyint(2) NOT NULL DEFAULT '0',
  `can_report_pm` tinyint(2) NOT NULL DEFAULT '0',
  `prefix` varchar(80) NOT NULL DEFAULT '',
  `suffix` varchar(80) NOT NULL DEFAULT '',
  `can_attach` tinyint(2) NOT NULL DEFAULT '0',
  `can_view_attach` tinyint(2) NOT NULL DEFAULT '0',
  `can_remove_attach` tinyint(2) NOT NULL DEFAULT '0',
  `max_attach` mediumint(8) NOT NULL DEFAULT '0',
  `notify_new_posts` tinyint(2) NOT NULL DEFAULT '0',
  `notify_new_topics` tinyint(2) NOT NULL DEFAULT '0',
  `use_avatar` tinyint(2) NOT NULL DEFAULT '0',
  `url_avatar` tinyint(2) NOT NULL DEFAULT '0',
  `upload_avatar` tinyint(2) NOT NULL DEFAULT '0',
  `hide_online` tinyint(2) NOT NULL DEFAULT '0',
  `view_active` tinyint(2) NOT NULL DEFAULT '0',
  `view_anonymous` tinyint(2) NOT NULL DEFAULT '0',
  `allow_html` tinyint(2) NOT NULL DEFAULT '0',
  `has_priviliges` tinyint(2) NOT NULL DEFAULT '0',
  `view_ip` tinyint(2) NOT NULL DEFAULT '0',
  `can_admin` tinyint(2) NOT NULL DEFAULT '0',
  `can_use_pm` tinyint(2) NOT NULL DEFAULT '0',
  `max_stored_pm` mediumint(8) NOT NULL DEFAULT '0',
  `max_mass_pm` mediumint(8) NOT NULL DEFAULT '0',
  `view_offline_board` tinyint(2) NOT NULL DEFAULT '0',
  `can_view_profile` tinyint(2) NOT NULL DEFAULT '0',
  `view_members` tinyint(2) NOT NULL DEFAULT '0',
  `view_stats` tinyint(2) NOT NULL DEFAULT '0',
  `can_submit_news` tinyint(2) NOT NULL DEFAULT '0',
  `can_approve_news` tinyint(2) NOT NULL DEFAULT '0',
  `can_edit_news` tinyint(2) NOT NULL DEFAULT '0',
  `can_delete_news` tinyint(2) NOT NULL DEFAULT '0',
  `group_message` text NOT NULL,
  `can_shout` tinyint(2) NOT NULL DEFAULT '0',
  `can_del_shout` tinyint(2) NOT NULL DEFAULT '0',
  `view_calendar` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`member_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES(-1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, '', 0, 0, 1);
INSERT INTO `[[dbprefix]]permissions` VALUES(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '', '', 1, 1, 1, 50000, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, '', 1, 1, 1);
INSERT INTO `[[dbprefix]]permissions` VALUES(3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '', '', 1, 1, 1, 2048, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 150, 0, 0, 1, 1, 1, 1, 0, 0, 0, '', 1, 0, 1);
INSERT INTO `[[dbprefix]]permissions` VALUES(2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '', '', 1, 1, 1, 2048, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, '', 1, 1, 1);
INSERT INTO `[[dbprefix]]permissions` VALUES(-3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 1);
INSERT INTO `[[dbprefix]]permissions` VALUES(0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, '', '', 1, 1, 0, 1024, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 200, 5, 0, 1, 1, 1, 1, 0, 0, 0, '', 1, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pm`
--

CREATE TABLE `[[dbprefix]]pm` (
  `pmid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `pm_from` mediumint(8) NOT NULL DEFAULT '0',
  `pm_to` mediumint(8) NOT NULL DEFAULT '0',
  `pm_time` int(10) NOT NULL DEFAULT '0',
  `pm_read_time` int(10) NOT NULL DEFAULT '0',
  `pm_folder` tinyint(2) NOT NULL DEFAULT '0',
  `pm_subject` tinytext NOT NULL,
  `pm_body` text NOT NULL,
  `pm_track` tinyint(2) NOT NULL DEFAULT '0',
  `pm_to_text` tinytext NOT NULL,
  PRIMARY KEY (`pmid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]pm`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]polls`
--

CREATE TABLE `[[dbprefix]]polls` (
  `poid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `poll_qt` tinytext NOT NULL,
  `poll_mid` mediumint(8) NOT NULL DEFAULT '0',
  `poll_locked` tinyint(2) NOT NULL DEFAULT '0',
  `poll_tid` mediumint(8) NOT NULL DEFAULT '0',
  `poll_expiry` int(10) NOT NULL DEFAULT '0',
  `poll_change_vote` tinyint(2) NOT NULL DEFAULT '0',
  `poll_started` int(10) NOT NULL DEFAULT '0',
  `poll_show_when` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`poid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]polls`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_options`
--

CREATE TABLE `[[dbprefix]]poll_options` (
  `pooid` mediumint(10) NOT NULL AUTO_INCREMENT,
  `poo_poid` mediumint(8) NOT NULL DEFAULT '0',
  `poo_option` tinytext NOT NULL,
  `poo_votes` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pooid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]poll_options`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_voters`
--

CREATE TABLE `[[dbprefix]]poll_voters` (
  `pv_mid` mediumint(8) NOT NULL DEFAULT '0',
  `pv_pooid` mediumint(10) NOT NULL DEFAULT '0',
  `pv_poid` mediumint(8) NOT NULL DEFAULT '0',
  UNIQUE KEY `pv_mid` (`pv_mid`,`pv_pooid`,`pv_poid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]poll_voters`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `pid` int(10) NOT NULL AUTO_INCREMENT,
  `post_tid` mediumint(8) NOT NULL DEFAULT '0',
  `p_top_sticky` tinyint(2) NOT NULL DEFAULT '0',
  `post_fid` smallint(5) NOT NULL DEFAULT '0',
  `ptime` int(10) NOT NULL DEFAULT '0',
  `poster_id` mediumint(8) NOT NULL DEFAULT '0',
  `poster_ip` varchar(20) NOT NULL DEFAULT '',
  `modtime` int(10) NOT NULL DEFAULT '0',
  `modifiers_id` mediumint(8) NOT NULL DEFAULT '0',
  `post` text NOT NULL,
  `use_smileys` tinyint(2) NOT NULL DEFAULT '1',
  `gposter_name` varchar(80) NOT NULL DEFAULT '',
  `gposter_email` varchar(80) NOT NULL DEFAULT '',
  `post_title` varchar(255) NOT NULL DEFAULT '',
  `num_attachments` tinyint(4) NOT NULL DEFAULT '0',
  `par_id` int(10) NOT NULL DEFAULT '0',
  `p_approved` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]posts`
--

INSERT INTO `[[dbprefix]]posts` VALUES(1, 1, 0, 1, [[timestamp]], -1, '', 0, 0, 'Hi,\r\n\r\n    We would like to thank you for using AEF.\r\nIf you need any assistance  :??:  , feel free to ask us for help at the [url=http://www.anelectron.com/board/]support board[/url].\r\n\r\nThanks and enjoy AEF!!!  ;-D \r\n\r\n', 1, 'AEF Team', 'aef@anelectron.com', '', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]read_board`
--

CREATE TABLE `[[dbprefix]]read_board` (
  `rb_uid` mediumint(8) NOT NULL DEFAULT '0',
  `rb_time` int(12) NOT NULL DEFAULT '0',
  UNIQUE KEY `rb_uid` (`rb_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]read_board`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]read_forums`
--

CREATE TABLE `[[dbprefix]]read_forums` (
  `rf_uid` mediumint(8) NOT NULL DEFAULT '0',
  `rf_fid` smallint(5) NOT NULL DEFAULT '0',
  `rf_time` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `rf_uid` (`rf_uid`,`rf_fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]read_forums`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]read_topics`
--

CREATE TABLE `[[dbprefix]]read_topics` (
  `rt_uid` mediumint(8) NOT NULL DEFAULT '0',
  `rt_tid` smallint(5) NOT NULL DEFAULT '0',
  `rt_time` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `rt_uid` (`rt_uid`,`rt_tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]read_topics`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]registry`
--

CREATE TABLE `[[dbprefix]]registry` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `regval` text NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]registry`
--

INSERT INTO `[[dbprefix]]registry` VALUES('reserved_names', 'admin\r\nwebmaster\r\nmaster\r\nuser\r\nlocalhost\r\nlord');
INSERT INTO `[[dbprefix]]registry` VALUES('latest_mem', '[[admin_username]]|1');
INSERT INTO `[[dbprefix]]registry` VALUES('num_mem', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('recyclebin', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('mostactive', '1|[[timestamp]]');
INSERT INTO `[[dbprefix]]registry` VALUES('maxtopics', '30');
INSERT INTO `[[dbprefix]]registry` VALUES('maxpostsintopics', '15');
INSERT INTO `[[dbprefix]]registry` VALUES('maxreplyhot', '15');
INSERT INTO `[[dbprefix]]registry` VALUES('maxreplyveryhot', '25');
INSERT INTO `[[dbprefix]]registry` VALUES('disableshoutingtopics', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('disableshoutingdesc', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('prenextopic', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('warnoldtopic', '120');
INSERT INTO `[[dbprefix]]registry` VALUES('prefixsticky', 'Sticky:');
INSERT INTO `[[dbprefix]]registry` VALUES('prefixmoved', 'Moved:');
INSERT INTO `[[dbprefix]]registry` VALUES('prefixpolls', 'Poll:');
INSERT INTO `[[dbprefix]]registry` VALUES('maxtitlechars', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('mintitlechars', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('maxdescchars', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('mindescchars', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('allow_taf', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('maxcharposts', '20000');
INSERT INTO `[[dbprefix]]registry` VALUES('mincharposts', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('timepostfromuser', '10');
INSERT INTO `[[dbprefix]]registry` VALUES('maxemotpost', '15');
INSERT INTO `[[dbprefix]]registry` VALUES('maximgspost', '15');
INSERT INTO `[[dbprefix]]registry` VALUES('allowdynimg', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('maximgwidthpost', '300');
INSERT INTO `[[dbprefix]]registry` VALUES('maximgheightpost', '300');
INSERT INTO `[[dbprefix]]registry` VALUES('removenestedquotes', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('attachsigtopost', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('embedflashinpost', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('maxflashpost', '5');
INSERT INTO `[[dbprefix]]registry` VALUES('maxflashwidthinpost', '300');
INSERT INTO `[[dbprefix]]registry` VALUES('maxflashheightinpost', '300');
INSERT INTO `[[dbprefix]]registry` VALUES('enablepolls', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('maxpollsintopic', '3');
INSERT INTO `[[dbprefix]]registry` VALUES('maxoptionspoll', '10');
INSERT INTO `[[dbprefix]]registry` VALUES('maxpollqtlen', '100');
INSERT INTO `[[dbprefix]]registry` VALUES('censor_words_from', '');
INSERT INTO `[[dbprefix]]registry` VALUES('censor_words_to', '');
INSERT INTO `[[dbprefix]]registry` VALUES('maintenance', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('censor_words_case', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('parsebbc', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('autolink', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_hr', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_b', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_i', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_u', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_s', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_left', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_right', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_center', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_size', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_font', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_sup', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_sub', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_color', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_url', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_ftp', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_email', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_img', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_flash', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_code', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_quote', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_php', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_ul', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_ol', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('bbc_parseHTML', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('reg_method', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('allow_reg', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('wel_email', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('reg_notify', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('max_pass', '20');
INSERT INTO `[[dbprefix]]registry` VALUES('max_uname', '20');
INSERT INTO `[[dbprefix]]registry` VALUES('min_pass', '4');
INSERT INTO `[[dbprefix]]registry` VALUES('min_uname', '4');
INSERT INTO `[[dbprefix]]registry` VALUES('sec_conf', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('samepc_reg', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('age_limit', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('age_rest_act', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('age_rest_act_address', '');
INSERT INTO `[[dbprefix]]registry` VALUES('age_rest_act_fax', '');
INSERT INTO `[[dbprefix]]registry` VALUES('age_rest_act_tele', '');
INSERT INTO `[[dbprefix]]registry` VALUES('reserved_match_whole', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('reserved_match_insensitive', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('login_failed', '5');
INSERT INTO `[[dbprefix]]registry` VALUES('anon_login', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('fpass_sec_conf', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('userstextlen', '100');
INSERT INTO `[[dbprefix]]registry` VALUES('wwwlen', '150');
INSERT INTO `[[dbprefix]]registry` VALUES('customtitlelen', '30');
INSERT INTO `[[dbprefix]]registry` VALUES('locationlen', '100');
INSERT INTO `[[dbprefix]]registry` VALUES('realnamelen', '100');
INSERT INTO `[[dbprefix]]registry` VALUES('secretqtlen', '200');
INSERT INTO `[[dbprefix]]registry` VALUES('secretansmaxlen', '20');
INSERT INTO `[[dbprefix]]registry` VALUES('secretansminlen', '4');
INSERT INTO `[[dbprefix]]registry` VALUES('usersiglen', '200');
INSERT INTO `[[dbprefix]]registry` VALUES('showavatars', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('avatardir', '[[softpath]]/avatars');
INSERT INTO `[[dbprefix]]registry` VALUES('avatarurl', '[[softurl]]/avatars');
INSERT INTO `[[dbprefix]]registry` VALUES('uploadavatardir', '[[softpath]]/uploads/avatars');
INSERT INTO `[[dbprefix]]registry` VALUES('uploadavatarurl', '[[softurl]]/uploads/avatars');
INSERT INTO `[[dbprefix]]registry` VALUES('uploadavatarmaxsize', '5000');
INSERT INTO `[[dbprefix]]registry` VALUES('avatartypes', 'gif,jpg,png');
INSERT INTO `[[dbprefix]]registry` VALUES('uploadppicdir', '[[softpath]]/uploads/personalpic');
INSERT INTO `[[dbprefix]]registry` VALUES('uploadppicurl', '[[softurl]]/uploads/personalpic');
INSERT INTO `[[dbprefix]]registry` VALUES('uploadppicmaxsize', '5000');
INSERT INTO `[[dbprefix]]registry` VALUES('ppictypes', 'gif,jpg,png,tiff');
INSERT INTO `[[dbprefix]]registry` VALUES('pmon', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('notifynewpm', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('pmusesmileys', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('pmnumshowinfolders', '50');
INSERT INTO `[[dbprefix]]registry` VALUES('pmsaveinsentitems', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('attachmentmode', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('allownewattachment', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('attachmentdir', '[[softpath]]/uploads/attachments');
INSERT INTO `[[dbprefix]]registry` VALUES('maxattachmentpost', '3');
INSERT INTO `[[dbprefix]]registry` VALUES('maxattachsize', '150');
INSERT INTO `[[dbprefix]]registry` VALUES('maxattachsizepost', '250');
INSERT INTO `[[dbprefix]]registry` VALUES('attachmentshowimage', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('attachmentshowimagemaxwidth', '200');
INSERT INTO `[[dbprefix]]registry` VALUES('attachmentshowimagemaxheight', '200');
INSERT INTO `[[dbprefix]]registry` VALUES('attachmenturl', '[[softurl]]/uploads/attachments');
INSERT INTO `[[dbprefix]]registry` VALUES('usesmileys', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('maintenance_subject', '');
INSERT INTO `[[dbprefix]]registry` VALUES('maintenance_message', '');
INSERT INTO `[[dbprefix]]registry` VALUES('mail', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('mail_user', '');
INSERT INTO `[[dbprefix]]registry` VALUES('mail_pass', '');
INSERT INTO `[[dbprefix]]registry` VALUES('mail_server', '');
INSERT INTO `[[dbprefix]]registry` VALUES('mail_port', '');
INSERT INTO `[[dbprefix]]registry` VALUES('notifications', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('numsubinpage', '30');
INSERT INTO `[[dbprefix]]registry` VALUES('session_timeout', '3600');
INSERT INTO `[[dbprefix]]registry` VALUES('last_active_span', '15');
INSERT INTO `[[dbprefix]]registry` VALUES('only_users', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('stats', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('memhideemail', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('showmemdetails', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('maxactivelist', '50');
INSERT INTO `[[dbprefix]]registry` VALUES('maxmemberlist', '50');
INSERT INTO `[[dbprefix]]registry` VALUES('theme', 'default');
INSERT INTO `[[dbprefix]]registry` VALUES('theme_id', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('choose_theme', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('version', '1.0.9');
INSERT INTO `[[dbprefix]]registry` VALUES('enablenews', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('enableshoutbox', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('shouts', '10');
INSERT INTO `[[dbprefix]]registry` VALUES('shoutboxtime', '1440');
INSERT INTO `[[dbprefix]]registry` VALUES('countinboardposts', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('subscribeauto', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('enablesig', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('showimgs', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('shoutbox_emot', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('shoutbox_nbbc', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('shoutbox_sbbc', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('language', 'english');
INSERT INTO `[[dbprefix]]registry` VALUES('choose_language', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('smiley_space_boundary', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('users_visited_today', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('av_width', '90');
INSERT INTO `[[dbprefix]]registry` VALUES('av_height', '90');
INSERT INTO `[[dbprefix]]registry` VALUES('ppic_width', '90');
INSERT INTO `[[dbprefix]]registry` VALUES('ppic_height', '90');
INSERT INTO `[[dbprefix]]registry` VALUES('last_posts_reply', '10');
INSERT INTO `[[dbprefix]]registry` VALUES('recent_posts', '8');
INSERT INTO `[[dbprefix]]registry` VALUES('who_read_topic', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('show_groups', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('change_username', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('rss_recent', '10');
INSERT INTO `[[dbprefix]]registry` VALUES('smart_redirect', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('report_posts', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('charset', 'ISO-8859-1');
INSERT INTO `[[dbprefix]]registry` VALUES('title_in_link', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('seo', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('timezone', '0');
INSERT INTO `[[dbprefix]]registry` VALUES('tickednews', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('todaysnews', '1');
INSERT INTO `[[dbprefix]]registry` VALUES('newsperpage', '12');
INSERT INTO `[[dbprefix]]registry` VALUES('bannedip', '');
INSERT INTO `[[dbprefix]]registry` VALUES('keywords', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `sid` varchar(32) NOT NULL DEFAULT '',
  `uid` mediumint(8) NOT NULL DEFAULT '0',
  `time` int(12) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `ip` varchar(20) NOT NULL DEFAULT '',
  `last_activity` tinytext NOT NULL,
  `activity` text NOT NULL,
  `viewing_board` smallint(5) NOT NULL DEFAULT '0',
  `viewing_topic` mediumint(8) NOT NULL DEFAULT '0',
  `anonymous` tinyint(2) NOT NULL DEFAULT '0',
  UNIQUE KEY `sid` (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]sessions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]shouts`
--

CREATE TABLE `[[dbprefix]]shouts` (
  `shid` int(10) NOT NULL AUTO_INCREMENT,
  `shtime` int(10) NOT NULL DEFAULT '0',
  `shuid` mediumint(8) NOT NULL DEFAULT '0',
  `shtext` text NOT NULL,
  PRIMARY KEY (`shid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]shouts`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]smileys`
--

CREATE TABLE `[[dbprefix]]smileys` (
  `smid` smallint(5) NOT NULL AUTO_INCREMENT,
  `smcode` varchar(40) NOT NULL DEFAULT '',
  `smfile` varchar(40) NOT NULL DEFAULT '',
  `smtitle` varchar(40) NOT NULL DEFAULT '',
  `smorder` smallint(5) NOT NULL DEFAULT '0',
  `smstatus` tinyint(2) NOT NULL DEFAULT '0',
  `smfolder` varchar(70) NOT NULL DEFAULT '',
  PRIMARY KEY (`smid`),
  UNIQUE KEY `smcode` (`smcode`),
  UNIQUE KEY `smcode_2` (`smcode`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]smileys`
--

INSERT INTO `[[dbprefix]]smileys` VALUES(1, ':)', 'smile.png', 'Smile', 1, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(2, ':D', 'bigsmile.png', 'Big Smile', 2, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(3, ':angel:', 'angel.png', 'Angel', 3, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(4, ':-x', 'crossedlips.png', 'Crossed Lips', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(5, ':cry:', 'cry.png', 'Cry', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(6, ':kiss:', 'kiss.png', 'Kiss', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(7, ':nerd:', 'nerd.png', 'Nerd', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(8, ':neu:', 'neutral.png', 'Neutral', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(9, ':??:', 'ooh.png', 'Question ??', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(10, ':-(', 'sad.png', 'Sad', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(11, ':squi:', 'squigglemouth.png', 'Squiggle mouth', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(12, ':P', 'tongue.png', 'Sticking tongue out', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(13, ';-D', 'wink.png', 'Wink', 0, 0, 'cutemoticons');
INSERT INTO `[[dbprefix]]smileys` VALUES(14, ':xd:', 'xd.png', 'XD', 0, 0, 'cutemoticons');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats`
--

CREATE TABLE `[[dbprefix]]stats` (
  `timestamp` int(12) NOT NULL DEFAULT '0',
  `users` mediumint(8) NOT NULL DEFAULT '0',
  `topics` mediumint(8) NOT NULL DEFAULT '0',
  `posts` mediumint(8) NOT NULL DEFAULT '0',
  `active` mediumint(8) NOT NULL DEFAULT '0',
  `pageviews` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]stats`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]themes`
--

CREATE TABLE `[[dbprefix]]themes` (
  `thid` mediumint(5) NOT NULL AUTO_INCREMENT,
  `th_name` varchar(100) NOT NULL DEFAULT '',
  `th_folder` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`thid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]themes`
--

INSERT INTO `[[dbprefix]]themes` VALUES(1, 'Electron', 'default');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]theme_registry`
--

CREATE TABLE `[[dbprefix]]theme_registry` (
  `thid` mediumint(8) NOT NULL DEFAULT '0',
  `uid` mediumint(8) NOT NULL DEFAULT '0',
  `theme_registry` text NOT NULL,
  UNIQUE KEY `thid` (`thid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]theme_registry`
--

INSERT INTO `[[dbprefix]]theme_registry` VALUES(1, 0, 'a:15:{s:4:"name";s:8:"Electron";s:4:"path";[[softpath_ser]]s:3:"url";[[softurl_ser]]s:6:"images";[[softurl_ser_image]]s:7:"wysiwyg";i:1;s:11:"fixshoutbox";i:0;s:8:"showdock";i:1;s:9:"headerimg";s:0:"";s:9:"headerads";s:0:"";s:13:"headernavtree";i:1;s:14:"shownumqueries";i:1;s:14:"showntimetaken";i:1;s:9:"copyright";s:0:"";s:9:"footerads";s:0:"";s:13:"footernavtree";i:0;}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]topics`
--

CREATE TABLE `[[dbprefix]]topics` (
  `tid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `topic` mediumtext NOT NULL,
  `t_description` mediumtext NOT NULL,
  `t_bid` smallint(5) NOT NULL DEFAULT '0',
  `t_status` tinyint(2) NOT NULL DEFAULT '1',
  `n_posts` smallint(5) NOT NULL DEFAULT '0',
  `n_views` smallint(5) NOT NULL DEFAULT '0',
  `type_image` mediumint(3) NOT NULL DEFAULT '0',
  `t_mem_id` mediumint(8) NOT NULL DEFAULT '0',
  `poll_id` mediumint(8) NOT NULL DEFAULT '0',
  `t_sticky` tinyint(2) NOT NULL DEFAULT '0',
  `first_post_id` int(10) NOT NULL DEFAULT '0',
  `last_post_id` int(10) NOT NULL DEFAULT '0',
  `mem_id_last_post` mediumint(8) NOT NULL DEFAULT '0',
  `has_attach` smallint(5) NOT NULL DEFAULT '0',
  `t_approved` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]topics`
--

INSERT INTO `[[dbprefix]]topics` VALUES(1, 'Welcome to AEF', '', 1, 1, 0, 0, 6, -1, 0, 0, 1, 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `username` varchar(80) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `salt` varchar(5) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `r_time` int(12) NOT NULL DEFAULT '0',
  `r_ip` varchar(20) NOT NULL DEFAULT '',
  `cookpass` varchar(32) NOT NULL DEFAULT '',
  `lastlogin` int(12) NOT NULL DEFAULT '0',
  `lastlogin_1` int(12) NOT NULL DEFAULT '0',
  `posts` mediumint(8) NOT NULL DEFAULT '0',
  `u_member_group` mediumint(5) NOT NULL DEFAULT '0',
  `realname` tinytext NOT NULL,
  `pm` smallint(5) NOT NULL DEFAULT '0',
  `unread_pm` smallint(5) NOT NULL DEFAULT '0',
  `users_text` tinytext NOT NULL,
  `gender` tinyint(2) NOT NULL DEFAULT '0',
  `birth_date` date NOT NULL DEFAULT '0000-00-00',
  `customtitle` varchar(100) NOT NULL DEFAULT '',
  `location` varchar(255) NOT NULL DEFAULT '',
  `www` tinytext NOT NULL,
  `timezone` varchar(6) NOT NULL DEFAULT '0',
  `gmail` varchar(255) NOT NULL DEFAULT '',
  `icq` varchar(255) NOT NULL DEFAULT '',
  `aim` varchar(255) NOT NULL DEFAULT '',
  `yim` varchar(255) NOT NULL DEFAULT '',
  `msn` varchar(255) NOT NULL DEFAULT '',
  `sig` text NOT NULL,
  `avatar` tinytext NOT NULL,
  `avatar_type` tinyint(2) NOT NULL DEFAULT '0',
  `avatar_width` tinyint(4) NOT NULL DEFAULT '0',
  `avatar_height` tinyint(4) NOT NULL DEFAULT '0',
  `ppic` tinytext NOT NULL,
  `ppic_type` tinyint(2) NOT NULL DEFAULT '0',
  `ppic_width` tinyint(4) NOT NULL DEFAULT '0',
  `ppic_height` tinyint(4) NOT NULL DEFAULT '0',
  `timeformat` varchar(80) NOT NULL DEFAULT '',
  `secret_question` tinytext NOT NULL,
  `secret_answer` tinytext NOT NULL,
  `user_theme` mediumint(5) NOT NULL DEFAULT '1',
  `act_status` tinyint(2) NOT NULL DEFAULT '0',
  `activation_code` varchar(10) NOT NULL DEFAULT '',
  `validation_code` varchar(32) NOT NULL DEFAULT '',
  `total_time_loggedin` int(12) NOT NULL DEFAULT '0',
  `warns` tinyint(2) NOT NULL DEFAULT '0',
  `last_warned` int(10) NOT NULL DEFAULT '0',
  `language` varchar(50) NOT NULL DEFAULT '0',
  `temp_ban` int(10) NOT NULL DEFAULT '0',
  `temp_ban_time` int(10) NOT NULL DEFAULT '0',
  `temp_ban_ug` mediumint(5) NOT NULL DEFAULT '0',
  `adminemail` tinyint(2) NOT NULL DEFAULT '0',
  `hideemail` tinyint(2) NOT NULL DEFAULT '0',
  `subscribeauto` tinyint(2) NOT NULL DEFAULT '0',
  `sendnewreply` tinyint(2) NOT NULL DEFAULT '0',
  `pm_email_notify` tinyint(2) NOT NULL DEFAULT '0',
  `pm_notify` tinyint(2) NOT NULL DEFAULT '0',
  `saveoutgoingpm` tinyint(2) NOT NULL DEFAULT '0',
  `showsigs` tinyint(2) NOT NULL DEFAULT '0',
  `showavatars` tinyint(2) NOT NULL DEFAULT '0',
  `showsmileys` tinyint(2) NOT NULL DEFAULT '0',
  `autofastreply` tinyint(2) NOT NULL DEFAULT '0',
  `showimgs` tinyint(2) NOT NULL DEFAULT '0',
  `i_am_anon` tinyint(2) NOT NULL DEFAULT '0',
  `user_settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES(1, '[[admin_username]]', '[[admin_pass]]', '[[adminsalt]]', '[[admin_email]]', [[timestamp]], '[[clientip]]', '', 0, 0, 0, 1, '', 0, 0, '', 0, '0000-00-00', '', '', '', '0', '', '', '', '', '', '', '', 0, 0, 0, '', 0, 0, 0, '', '', '', 1, 1, '', '', 0, 0, 0, '0', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_groups`
--

CREATE TABLE `[[dbprefix]]user_groups` (
  `member_group` mediumint(5) NOT NULL AUTO_INCREMENT,
  `mem_gr_name` varchar(80) NOT NULL DEFAULT '',
  `mem_gr_colour` varchar(20) NOT NULL DEFAULT '',
  `post_count` mediumint(8) NOT NULL DEFAULT '0',
  `image_name` varchar(30) NOT NULL DEFAULT '',
  `image_count` mediumint(5) NOT NULL DEFAULT '0',
  `max_pm` mediumint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`member_group`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]user_groups`
--

INSERT INTO `[[dbprefix]]user_groups` VALUES(-3, 'Banned', '#000000', -1, 'banned.gif', 1, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(-1, 'Guest', '#000000', -1, 'guests.png', 1, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(1, 'Administrator', '#FF0000', -1, 'admin.gif', 7, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(2, 'Universal Moderator', '#0000FF', -1, 'unimod.gif', 6, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(3, 'Moderator', '#339933', -1, 'mod.gif', 5, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(4, 'Newbie', '#000000', 0, 'member.gif', 1, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(5, 'Working Newbie', '#000000', 50, 'member.gif', 2, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(6, 'Working Member', '#000000', 100, 'member.gif', 3, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(7, 'Elite Member', '#000000', 250, 'member.gif', 4, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(8, 'Super Member', '#000000', 500, 'member.gif', 5, 0);
INSERT INTO `[[dbprefix]]user_groups` VALUES(0, 'Member', '#000000', -1, 'member.gif', 2, 0);
