<?php
/**
 * ----------------------------------------------
 * Advanced Poll  (PHP/MySQL)
 * Copyright (c) Chi Kien Uong
 * URL: http://www.proxy2.de
 * ----------------------------------------------
 */

class polldb_sql {

    var $link;
    var $result;
    var $record;
    var $db;
    var $port;
    var $query_count;

    public function __construct() {
        global $POLLDB;
        $this->query_count=0;
        $this->db = $POLLDB;
        if(preg_match("/:/", $this->db['host'])) {
            list($host,$port) = explode(":",$this->db['host']);
            $this->port = $port;
        } else {
            $this->port = 3306;
        }
    }

	function connect() {
        $this->link = mysqli_connect($this->db['host'], $this->db['user'], $this->db['pass'], $this->db['dbName'], $this->port);
        if (!$this->link) {            
            $this->sql_error("Connection Error");
            return false;
        }
        return $this->link;
    }
	
	function query($query_string) {
        $this->result = $this->link->query($query_string);
		$this->query_count++;
        if (!$this->result) {
            $this->sql_error("Query Error");
        }
        return $this->result;
    }
	
	function fetch_array($stmt) {
		if ($stmt) {
			$this->record = $stmt->fetch_assoc();
		}
        return $this->record;
    }

	function num_rows($stmt) {
        if ($stmt) {
			return $stmt->num_rows;
		}
		return 0;
    }

    function num_fields($stmt) {
        if ($stmt) {
			return $stmt->field_count;
		}
		return 0;
    }
	
    function free_result($stmt) {
		if ($stmt) {
			return $stmt->free();
		}
    }

    function affected_rows() {
		if ($this->link) {
			return $this->link->affected_rows;
		}
		return 0;
    }

	function close_db() {
        if ($this->link) {
            return $this->link->close();
        } else {
            return false;
        }
    }

    function sql_error($message) {
        $description = mysqli_connect_error();
        $number = mysqli_connect_errno();
        $error ="MySQL Error : $message\n";
        $error.="Error Number: $number $description\n";
        $error.="Date        : ".date("D, F j, Y H:i:s")."\n";
        $error.="IP          : ".getenv("REMOTE_ADDR")."\n";
        $error.="Browser     : ".getenv("HTTP_USER_AGENT")."\n";
        $error.="Referer     : ".getenv("HTTP_REFERER")."\n";
        $error.="PHP Version : ".PHP_VERSION."\n";
        $error.="OS          : ".PHP_OS."\n";
        $error.="Server      : ".getenv("SERVER_SOFTWARE")."\n";
        $error.="Server Name : ".getenv("SERVER_NAME")."\n";
        $error.="Script Name : ".getenv("SCRIPT_NAME")."\n";
        echo "<b><font size=4 face=Arial>$message</font></b><hr>";
        echo "<pre>$error</pre>";
        exit();
    }

}

?>